/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.NamedData;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;

public class NetworkCrawler
implements DataProvider {
    private final List<URL> urls = new ArrayList<URL>();
    private int timeout;

    public NetworkCrawler(URL ... urls) {
        for (URL url : urls) {
            this.urls.add(url);
        }
        this.timeout = 10000;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean feed(Pattern supported, DataLoader visitor) {
        try {
            OrekitException delayedException = null;
            boolean loaded = false;
            for (URL url : this.urls) {
                try {
                    if (!visitor.stillAcceptsData()) continue;
                    String name = url.toURI().toString();
                    String fileName = new File(url.getPath()).getName();
                    if (ZIP_ARCHIVE_PATTERN.matcher(fileName).matches()) {
                        new ZipJarCrawler(url).feed(supported, visitor);
                        loaded = true;
                        continue;
                    }
                    NamedData data = new NamedData(fileName, () -> this.getStream(url));
                    data = DataProvidersManager.getInstance().applyAllFilters(data);
                    if (!supported.matcher(data.getName()).matches()) continue;
                    InputStream input = data.getStreamOpener().openStream();
                    Throwable throwable = null;
                    try {
                        visitor.loadData(input, name);
                        loaded = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (OrekitException oe) {
                    delayedException = oe;
                }
            }
            if (!loaded && delayedException != null) {
                throw delayedException;
            }
            return loaded;
        }
        catch (IOException | URISyntaxException | ParseException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    private InputStream getStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(this.timeout);
        return connection.getInputStream();
    }
}

