/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import org.hipparchus.distribution.discrete.AbstractIntegerDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class GeometricDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130507L;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public GeometricDistribution(double p) throws MathIllegalArgumentException {
        if (p <= 0.0 || p > 1.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_LEFT, p, 0, 1);
        }
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccess = FastMath.log(p);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-p);
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        if (x < 0) {
            return 0.0;
        }
        return FastMath.exp(this.log1mProbabilityOfSuccess * (double)x) * this.probabilityOfSuccess;
    }

    @Override
    public double logProbability(int x) {
        if (x < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)x * this.log1mProbabilityOfSuccess + this.logProbabilityOfSuccess;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        return -FastMath.expm1(this.log1mProbabilityOfSuccess * (double)(x + 1));
    }

    @Override
    public double getNumericalMean() {
        return (1.0 - this.probabilityOfSuccess) / this.probabilityOfSuccess;
    }

    @Override
    public double getNumericalVariance() {
        return (1.0 - this.probabilityOfSuccess) / (this.probabilityOfSuccess * this.probabilityOfSuccess);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        if (p == 0.0) {
            return 0;
        }
        return Math.max(0, (int)Math.ceil(FastMath.log1p(-p) / this.log1mProbabilityOfSuccess - 1.0));
    }
}

