/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.RealFieldUnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;

public interface BracketedRealFieldUnivariateSolver<T extends RealFieldElement<T>> {
    public int getMaxEvaluations();

    public int getEvaluations();

    public T getAbsoluteAccuracy();

    public T getRelativeAccuracy();

    public T getFunctionValueAccuracy();

    public T solve(int var1, RealFieldUnivariateFunction<T> var2, T var3, T var4, AllowedSolution var5);

    public T solve(int var1, RealFieldUnivariateFunction<T> var2, T var3, T var4, T var5, AllowedSolution var6);

    default public Interval<T> solveInterval(int maxEval, RealFieldUnivariateFunction<T> f, T min, T max) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.solveInterval(maxEval, f, min, max, (RealFieldElement)min.add(((RealFieldElement)max.subtract(min)).multiply(0.5)));
    }

    public Interval<T> solveInterval(int var1, RealFieldUnivariateFunction<T> var2, T var3, T var4, T var5) throws MathIllegalArgumentException, MathIllegalStateException;

    public static class Interval<T extends RealFieldElement<T>> {
        private final T leftAbscissa;
        private final T leftValue;
        private final T rightAbscissa;
        private final T rightValue;

        public Interval(T leftAbscissa, T leftValue, T rightAbscissa, T rightValue) {
            this.leftAbscissa = leftAbscissa;
            this.leftValue = leftValue;
            this.rightAbscissa = rightAbscissa;
            this.rightValue = rightValue;
        }

        public T getLeftAbscissa() {
            return this.leftAbscissa;
        }

        public T getRightAbscissa() {
            return this.rightAbscissa;
        }

        public T getLeftValue() {
            return this.leftValue;
        }

        public T getRightValue() {
            return this.rightValue;
        }

        public T getSide(AllowedSolution allowed) {
            T xA = this.getLeftAbscissa();
            T yA = this.getLeftValue();
            T xB = this.getRightAbscissa();
            switch (allowed) {
                case ANY_SIDE: {
                    RealFieldElement absYA = (RealFieldElement)this.getLeftValue().abs();
                    RealFieldElement absYB = (RealFieldElement)this.getRightValue().abs();
                    return absYA.subtract(absYB).getReal() < 0.0 ? xA : xB;
                }
                case LEFT_SIDE: {
                    return xA;
                }
                case RIGHT_SIDE: {
                    return xB;
                }
                case BELOW_SIDE: {
                    return yA.getReal() <= 0.0 ? xA : xB;
                }
                case ABOVE_SIDE: {
                    return yA.getReal() < 0.0 ? xB : xA;
                }
            }
            throw MathRuntimeException.createInternalError();
        }
    }
}

