/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.sampling;

import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.ODEFixedStepHandler;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.ode.sampling.StepNormalizerBounds;
import org.hipparchus.ode.sampling.StepNormalizerMode;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class StepNormalizer
implements ODEStepHandler {
    private double h;
    private final ODEFixedStepHandler handler;
    private ODEStateAndDerivative first;
    private ODEStateAndDerivative last;
    private boolean forward;
    private final StepNormalizerBounds bounds;
    private final StepNormalizerMode mode;

    public StepNormalizer(double h, ODEFixedStepHandler handler) {
        this(h, handler, StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double h, ODEFixedStepHandler handler, StepNormalizerMode mode) {
        this(h, handler, mode, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double h, ODEFixedStepHandler handler, StepNormalizerBounds bounds) {
        this(h, handler, StepNormalizerMode.INCREMENT, bounds);
    }

    public StepNormalizer(double h, ODEFixedStepHandler handler, StepNormalizerMode mode, StepNormalizerBounds bounds) {
        this.h = FastMath.abs((double)h);
        this.handler = handler;
        this.mode = mode;
        this.bounds = bounds;
        this.first = null;
        this.last = null;
        this.forward = true;
    }

    @Override
    public void init(ODEStateAndDerivative initialState, double finalTime) {
        this.first = null;
        this.last = null;
        this.forward = true;
        this.handler.init(initialState, finalTime);
    }

    @Override
    public void handleStep(ODEStateInterpolator interpolator, boolean isLast) throws MathIllegalStateException {
        double nextTime;
        if (this.last == null) {
            this.last = this.first = interpolator.getPreviousState();
            this.forward = interpolator.isForward();
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        double d = nextTime = this.mode == StepNormalizerMode.INCREMENT ? this.last.getTime() + this.h : (FastMath.floor((double)(this.last.getTime() / this.h)) + 1.0) * this.h;
        if (this.mode == StepNormalizerMode.MULTIPLES && Precision.equals((double)nextTime, (double)this.last.getTime(), (int)1)) {
            nextTime += this.h;
        }
        boolean nextInStep = this.isNextInStep(nextTime, interpolator);
        while (nextInStep) {
            this.doNormalizedStep(false);
            this.last = interpolator.getInterpolatedState(nextTime);
            nextInStep = this.isNextInStep(nextTime += this.h, interpolator);
        }
        if (isLast) {
            boolean addLast = this.bounds.lastIncluded() && this.last.getTime() != interpolator.getCurrentState().getTime();
            this.doNormalizedStep(!addLast);
            if (addLast) {
                this.last = interpolator.getCurrentState();
                this.doNormalizedStep(true);
            }
        }
    }

    private boolean isNextInStep(double nextTime, ODEStateInterpolator interpolator) {
        return this.forward ? nextTime <= interpolator.getCurrentState().getTime() : nextTime >= interpolator.getCurrentState().getTime();
    }

    private void doNormalizedStep(boolean isLast) {
        if (!this.bounds.firstIncluded() && this.first.getTime() == this.last.getTime()) {
            return;
        }
        this.handler.handleStep(this.last, isLast);
    }
}

