/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.LofOffset;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SpacecraftState
implements TimeStamped,
TimeShiftable<SpacecraftState>,
TimeInterpolable<SpacecraftState>,
Serializable {
    private static final long serialVersionUID = 20130407L;
    private static final double DEFAULT_MASS = 1000.0;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final Orbit orbit;
    private final AbsolutePVCoordinates absPva;
    private final Attitude attitude;
    private final double mass;
    private final Map<String, double[]> additional;

    public SpacecraftState(Orbit orbit) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, null);
    }

    public SpacecraftState(Orbit orbit, double mass) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, null);
    }

    public SpacecraftState(Orbit orbit, Map<String, double[]> additional) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, Map<String, double[]> additional) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, double mass, Map<String, double[]> additional) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass, Map<String, double[]> additional) throws IllegalArgumentException {
        SpacecraftState.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.absPva = null;
        this.attitude = attitude;
        this.mass = mass;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, double[]>(additional.size());
            for (Map.Entry<String, double[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (double[])entry.getValue().clone());
            }
        }
    }

    public SpacecraftState(AbsolutePVCoordinates absPva) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), 1000.0, null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude) throws IllegalArgumentException {
        this(absPva, attitude, 1000.0, null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, double mass) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, double mass) throws IllegalArgumentException {
        this(absPva, attitude, mass, null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Map<String, double[]> additional) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), 1000.0, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, Map<String, double[]> additional) throws IllegalArgumentException {
        this(absPva, attitude, 1000.0, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, double mass, Map<String, double[]> additional) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, double mass, Map<String, double[]> additional) throws IllegalArgumentException {
        SpacecraftState.checkConsistency(absPva, attitude);
        this.orbit = null;
        this.absPva = absPva;
        this.attitude = attitude;
        this.mass = mass;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, double[]>(additional.size());
            for (Map.Entry<String, double[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (double[])entry.getValue().clone());
            }
        }
    }

    public SpacecraftState addAdditionalState(String name, double ... value) {
        HashMap<String, double[]> newMap = new HashMap<String, double[]>(this.additional.size() + 1);
        newMap.putAll(this.additional);
        newMap.put(name, (double[])value.clone());
        if (this.absPva == null) {
            return new SpacecraftState(this.orbit, this.attitude, this.mass, newMap);
        }
        return new SpacecraftState(this.absPva, this.attitude, this.mass, newMap);
    }

    private static void checkConsistency(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        if (FastMath.abs((double)orbit.getDate().durationFrom(attitude.getDate())) > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbit.getDate(), attitude.getDate());
        }
        if (orbit.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbit.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    public boolean isOrbitDefined() {
        return this.orbit != null;
    }

    private static void checkConsistency(AbsolutePVCoordinates absPva, Attitude attitude) throws IllegalArgumentException {
        if (FastMath.abs((double)absPva.getDate().durationFrom(attitude.getDate())) > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, absPva.getDate(), attitude.getDate());
        }
        if (absPva.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, absPva.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    @Override
    public SpacecraftState shiftedBy(double dt) {
        if (this.absPva == null) {
            return new SpacecraftState(this.orbit.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
        }
        return new SpacecraftState(this.absPva.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
    }

    @Override
    public SpacecraftState interpolate(AbsoluteDate date, Stream<SpacecraftState> sample) {
        HashMap<String, double[]> interpolatedAdditional;
        AbsolutePVCoordinates interpolatedAbsPva;
        Orbit interpolatedOrbit;
        ArrayList absPvas;
        ArrayList orbits;
        if (this.isOrbitDefined()) {
            orbits = new ArrayList();
            absPvas = null;
        } else {
            orbits = null;
            absPvas = new ArrayList();
        }
        ArrayList attitudes = new ArrayList();
        HermiteInterpolator massInterpolator = new HermiteInterpolator();
        HashMap<String, HermiteInterpolator> additionalInterpolators = new HashMap<String, HermiteInterpolator>(this.additional.size());
        for (String name : this.additional.keySet()) {
            additionalInterpolators.put(name, new HermiteInterpolator());
        }
        sample.forEach(state -> {
            double deltaT = state.getDate().durationFrom(date);
            if (this.isOrbitDefined()) {
                orbits.add(state.getOrbit());
            } else {
                absPvas.add(state.getAbsPVA());
            }
            attitudes.add(state.getAttitude());
            massInterpolator.addSamplePoint(deltaT, (double[][])new double[][]{{state.getMass()}});
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                ((HermiteInterpolator)entry.getValue()).addSamplePoint(deltaT, (double[][])new double[][]{state.getAdditionalState((String)entry.getKey())});
            }
        });
        if (this.isOrbitDefined()) {
            interpolatedOrbit = (Orbit)this.orbit.interpolate(date, orbits);
            interpolatedAbsPva = null;
        } else {
            interpolatedOrbit = null;
            interpolatedAbsPva = (AbsolutePVCoordinates)this.absPva.interpolate(date, absPvas);
        }
        Attitude interpolatedAttitude = (Attitude)this.attitude.interpolate(date, attitudes);
        double interpolatedMass = massInterpolator.value(0.0)[0];
        if (this.additional.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new HashMap<String, double[]>(this.additional.size());
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                interpolatedAdditional.put((String)entry.getKey(), ((HermiteInterpolator)entry.getValue()).value(0.0));
            }
        }
        if (this.isOrbitDefined()) {
            return new SpacecraftState(interpolatedOrbit, interpolatedAttitude, interpolatedMass, interpolatedAdditional);
        }
        return new SpacecraftState(interpolatedAbsPva, interpolatedAttitude, interpolatedMass, interpolatedAdditional);
    }

    public AbsolutePVCoordinates getAbsPVA() throws OrekitIllegalStateException {
        if (this.absPva == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ABSOLUTE_PVCOORDINATES, new Object[0]);
        }
        return this.absPva;
    }

    public Orbit getOrbit() throws OrekitIllegalStateException {
        if (this.orbit == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ORBIT, new Object[0]);
        }
        return this.orbit;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.absPva == null ? this.orbit.getDate() : this.absPva.getDate();
    }

    public Frame getFrame() {
        return this.absPva == null ? this.orbit.getFrame() : this.absPva.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.containsKey(name);
    }

    public void ensureCompatibleAdditionalStates(SpacecraftState state) throws MathIllegalStateException {
        for (Map.Entry<String, double[]> entry : this.additional.entrySet()) {
            double[] other = state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, entry.getValue().length});
        }
        if (state.additional.size() > this.additional.size()) {
            for (String name : state.additional.keySet()) {
                if (this.additional.containsKey(name)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
            }
        }
    }

    public double[] getAdditionalState(String name) {
        if (!this.additional.containsKey(name)) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return (double[])this.additional.get(name).clone();
    }

    public Map<String, double[]> getAdditionalStates() {
        return Collections.unmodifiableMap(this.additional);
    }

    public Transform toTransform() {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        return new Transform(pv.getDate(), new Transform(pv.getDate(), pv.negate()), new Transform(pv.getDate(), this.attitude.getOrientation()));
    }

    public double getMu() {
        return this.absPva == null ? this.orbit.getMu() : Double.NaN;
    }

    public double getKeplerianPeriod() {
        return this.absPva == null ? this.orbit.getKeplerianPeriod() : Double.NaN;
    }

    public double getKeplerianMeanMotion() {
        return this.absPva == null ? this.orbit.getKeplerianMeanMotion() : Double.NaN;
    }

    public double getA() {
        return this.absPva == null ? this.orbit.getA() : Double.NaN;
    }

    public double getEquinoctialEx() {
        return this.absPva == null ? this.orbit.getEquinoctialEx() : Double.NaN;
    }

    public double getEquinoctialEy() {
        return this.absPva == null ? this.orbit.getEquinoctialEy() : Double.NaN;
    }

    public double getHx() {
        return this.absPva == null ? this.orbit.getHx() : Double.NaN;
    }

    public double getHy() {
        return this.absPva == null ? this.orbit.getHy() : Double.NaN;
    }

    public double getLv() {
        return this.absPva == null ? this.orbit.getLv() : Double.NaN;
    }

    public double getLE() {
        return this.absPva == null ? this.orbit.getLE() : Double.NaN;
    }

    public double getLM() {
        return this.absPva == null ? this.orbit.getLM() : Double.NaN;
    }

    public double getE() {
        return this.absPva == null ? this.orbit.getE() : Double.NaN;
    }

    public double getI() {
        return this.absPva == null ? this.orbit.getI() : Double.NaN;
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        return this.absPva == null ? this.orbit.getPVCoordinates() : this.absPva.getPVCoordinates();
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) {
        return this.absPva == null ? this.orbit.getPVCoordinates(outputFrame) : this.absPva.getPVCoordinates(outputFrame);
    }

    public Attitude getAttitude() {
        return this.attitude;
    }

    public double getMass() {
        return this.mass;
    }

    private Object writeReplace() {
        return this.isOrbitDefined() ? new DTOO(this) : new DTOA(this);
    }

    public String toString() {
        return "SpacecraftState{orbit=" + this.orbit + ", attitude=" + this.attitude + ", mass=" + this.mass + ", additional=" + this.additional + '}';
    }

    private static class DTOA
    implements Serializable {
        private static final long serialVersionUID = 20150916L;
        private final AbsolutePVCoordinates absPva;
        private double[] d;
        private final Map<String, double[]> additional;

        private DTOA(SpacecraftState state) {
            this.absPva = state.absPva;
            this.additional = state.additional.isEmpty() ? null : state.additional;
            Rotation rotation = state.attitude.getRotation();
            Vector3D spin = state.attitude.getSpin();
            Vector3D rotationAcceleration = state.attitude.getRotationAcceleration();
            this.d = new double[]{rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), spin.getX(), spin.getY(), spin.getZ(), rotationAcceleration.getX(), rotationAcceleration.getY(), rotationAcceleration.getZ(), state.mass};
        }

        private Object readResolve() {
            return new SpacecraftState(this.absPva, new Attitude(this.absPva.getFrame(), new TimeStampedAngularCoordinates(this.absPva.getDate(), new Rotation(this.d[0], this.d[1], this.d[2], this.d[3], false), new Vector3D(this.d[4], this.d[5], this.d[6]), new Vector3D(this.d[7], this.d[8], this.d[9]))), this.d[10], this.additional);
        }
    }

    private static class DTOO
    implements Serializable {
        private static final long serialVersionUID = 20150916L;
        private final Orbit orbit;
        private double[] d;
        private final Map<String, double[]> additional;

        private DTOO(SpacecraftState state) {
            this.orbit = state.orbit;
            this.additional = state.additional.isEmpty() ? null : state.additional;
            Rotation rotation = state.attitude.getRotation();
            Vector3D spin = state.attitude.getSpin();
            Vector3D rotationAcceleration = state.attitude.getRotationAcceleration();
            this.d = new double[]{rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), spin.getX(), spin.getY(), spin.getZ(), rotationAcceleration.getX(), rotationAcceleration.getY(), rotationAcceleration.getZ(), state.mass};
        }

        private Object readResolve() {
            return new SpacecraftState(this.orbit, new Attitude(this.orbit.getFrame(), new TimeStampedAngularCoordinates(this.orbit.getDate(), new Rotation(this.d[0], this.d[1], this.d[2], this.d[3], false), new Vector3D(this.d[4], this.d[5], this.d[6]), new Vector3D(this.d[7], this.d[8], this.d[9]))), this.d[10], this.additional);
        }
    }
}

