/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeVectorFunction;
import org.orekit.utils.LoveNumbers;

class SolidTidesField
implements NormalizedSphericalHarmonicsProvider {
    private static final int MAX_LEGENDRE_DEGREE = 4;
    private final LoveNumbers love;
    private final TimeVectorFunction deltaCSFunction;
    private final double deltaC20PermanentTide;
    private final TimeVectorFunction poleTideFunction;
    private final Frame centralBodyFrame;
    private final double ae;
    private final double mu;
    private final TideSystem centralTideSystem;
    private final CelestialBody[] bodies;
    private final double[][] anm;
    private final double[][] bnm;
    private final double[] dmm;

    SolidTidesField(LoveNumbers love, TimeVectorFunction deltaCSFunction, double deltaC20PermanentTide, TimeVectorFunction poleTideFunction, Frame centralBodyFrame, double ae, double mu, TideSystem centralTideSystem, CelestialBody ... bodies) {
        this.centralBodyFrame = centralBodyFrame;
        this.ae = ae;
        this.mu = mu;
        this.centralTideSystem = centralTideSystem;
        this.bodies = bodies;
        this.anm = this.buildTriangularArray(5, false);
        this.bnm = this.buildTriangularArray(5, false);
        this.dmm = new double[love.getSize()];
        this.recursionCoefficients();
        this.love = love;
        this.deltaCSFunction = deltaCSFunction;
        this.deltaC20PermanentTide = deltaC20PermanentTide;
        this.poleTideFunction = poleTideFunction;
    }

    @Override
    public int getMaxDegree() {
        return 4;
    }

    @Override
    public int getMaxOrder() {
        return 4;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public double getAe() {
        return this.ae;
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return AbsoluteDate.J2000_EPOCH;
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return date.durationFrom(AbsoluteDate.J2000_EPOCH);
    }

    @Override
    public TideSystem getTideSystem() {
        return TideSystem.ZERO_TIDE;
    }

    @Override
    public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(AbsoluteDate date) {
        double[][] cnm = this.buildTriangularArray(5, true);
        double[][] snm = this.buildTriangularArray(5, true);
        double[][] pnm = this.buildTriangularArray(5, true);
        for (CelestialBody body : this.bodies) {
            Vector3D position = body.getPVCoordinates(date, this.centralBodyFrame).getPosition();
            double x = position.getX();
            double y = position.getY();
            double z = position.getZ();
            double x2 = x * x;
            double y2 = y * y;
            double z2 = z * z;
            double r2 = x2 + y2 + z2;
            double r = FastMath.sqrt((double)r2);
            double rho2 = x2 + y2;
            double rho = FastMath.sqrt((double)rho2);
            this.evaluateLegendre(z / r, rho / r, pnm);
            this.frequencyIndependentPart(r, body.getGM(), x / rho, y / rho, pnm, cnm, snm);
        }
        this.frequencyDependentPart(date, cnm, snm);
        if (this.centralTideSystem == TideSystem.ZERO_TIDE) {
            this.removePermanentTide(cnm);
        }
        if (this.poleTideFunction != null) {
            this.poleTide(date, cnm, snm);
        }
        return new TideHarmonics(date, cnm, snm);
    }

    private void recursionCoefficients() {
        for (int n = 0; n < this.anm.length; ++n) {
            for (int m = 0; m < n; ++m) {
                double f = (n - m) * (n + m);
                this.anm[n][m] = FastMath.sqrt((double)((double)((2 * n - 1) * (2 * n + 1)) / f));
                this.bnm[n][m] = FastMath.sqrt((double)((double)((2 * n + 1) * (n + m - 1) * (n - m - 1)) / (f * (double)(2 * n - 3))));
            }
        }
        this.dmm[0] = Double.NaN;
        this.dmm[1] = Double.NaN;
        for (int m = 2; m < this.dmm.length; ++m) {
            this.dmm[m] = FastMath.sqrt((double)((double)(2 * m + 1) / (2.0 * (double)m)));
        }
    }

    private void evaluateLegendre(double t, double u, double[][] pnm) {
        int m;
        pnm[0][0] = 1.0;
        pnm[1][0] = this.anm[1][0] * t;
        pnm[1][1] = FastMath.sqrt((double)3.0) * u;
        for (m = 2; m < this.dmm.length; ++m) {
            pnm[m][m - 1] = this.anm[m][m - 1] * t * pnm[m - 1][m - 1];
            pnm[m][m] = this.dmm[m] * u * pnm[m - 1][m - 1];
        }
        for (m = 0; m < this.dmm.length; ++m) {
            for (int n = m + 2; n < pnm.length; ++n) {
                pnm[n][m] = this.anm[n][m] * t * pnm[n - 1][m] - this.bnm[n][m] * pnm[n - 2][m];
            }
        }
    }

    private void frequencyIndependentPart(double r, double gm, double cosLambda, double sinLambda, double[][] pnm, double[][] cnm, double[][] snm) {
        double rRatio = this.ae / r;
        double fM = gm / this.mu;
        double cosMLambda = 1.0;
        double sinMLambda = 0.0;
        for (int m = 0; m < this.love.getSize(); ++m) {
            double fNPlus1 = fM;
            for (int n = m; n < this.love.getSize(); ++n) {
                double coeff = (fNPlus1 *= rRatio) / (double)(2 * n + 1) * pnm[n][m];
                double cCos = coeff * cosMLambda;
                double cSin = coeff * sinMLambda;
                double kR = this.love.getReal(n, m);
                double kI = this.love.getImaginary(n, m);
                double[] dArray = cnm[n];
                int n2 = m;
                dArray[n2] = dArray[n2] + (kR * cCos + kI * cSin);
                double[] dArray2 = snm[n];
                int n3 = m;
                dArray2[n3] = dArray2[n3] + (kR * cSin - kI * cCos);
                if (n != 2) continue;
                double kP = this.love.getPlus(n, m);
                double[] dArray3 = cnm[4];
                int n4 = m;
                dArray3[n4] = dArray3[n4] + kP * cCos;
                double[] dArray4 = snm[4];
                int n5 = m;
                dArray4[n5] = dArray4[n5] + kP * cSin;
            }
            double tmp = cosMLambda * cosLambda - sinMLambda * sinLambda;
            sinMLambda = sinMLambda * cosLambda + cosMLambda * sinLambda;
            cosMLambda = tmp;
            fM *= rRatio;
        }
    }

    private void frequencyDependentPart(AbsoluteDate date, double[][] cnm, double[][] snm) {
        double[] deltaCS = this.deltaCSFunction.value(date);
        double[] dArray = cnm[2];
        dArray[0] = dArray[0] + deltaCS[0];
        double[] dArray2 = cnm[2];
        dArray2[1] = dArray2[1] + deltaCS[1];
        double[] dArray3 = snm[2];
        dArray3[1] = dArray3[1] + deltaCS[2];
        double[] dArray4 = cnm[2];
        dArray4[2] = dArray4[2] + deltaCS[3];
        double[] dArray5 = snm[2];
        dArray5[2] = dArray5[2] + deltaCS[4];
    }

    private void removePermanentTide(double[][] cnm) {
        double[] dArray = cnm[2];
        dArray[0] = dArray[0] - this.deltaC20PermanentTide;
    }

    private void poleTide(AbsoluteDate date, double[][] cnm, double[][] snm) {
        double[] deltaCS = this.poleTideFunction.value(date);
        double[] dArray = cnm[2];
        dArray[1] = dArray[1] + deltaCS[0];
        double[] dArray2 = snm[2];
        dArray2[1] = dArray2[1] + deltaCS[1];
    }

    private double[][] buildTriangularArray(int size, boolean withDiagonal) {
        double[][] array = new double[size][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new double[withDiagonal ? i + 1 : i];
        }
        return array;
    }

    private static class TideHarmonics
    implements NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics {
        private final AbsoluteDate date;
        private final double[][] cnm;
        private final double[][] snm;

        private TideHarmonics(AbsoluteDate date, double[][] cnm, double[][] snm) {
            this.date = date;
            this.cnm = cnm;
            this.snm = snm;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        @Override
        public double getNormalizedCnm(int n, int m) {
            return this.cnm[n][m];
        }

        @Override
        public double getNormalizedSnm(int n, int m) {
            return this.snm[n][m];
        }
    }
}

