/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

class FieldDSSTTesseralContext<T extends RealFieldElement<T>>
extends FieldForceModelContext<T> {
    private static final int I = 1;
    private static final double MIN_PERIOD_IN_SECONDS = 864000.0;
    private static final double MIN_PERIOD_IN_SAT_REV = 10.0;
    private T A;
    private T chi;
    private T chi2;
    private T theta;
    private T ax2oA;
    private T ooAB;
    private T BoA;
    private T BoABpo;
    private T Co2AB;
    private T moa;
    private T roa;
    private T e2;
    private T n;
    private T period;
    private int maxEccPow;
    private T ratio;
    private final List<Integer> resOrders;

    FieldDSSTTesseralContext(FieldAuxiliaryElements<T> auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, T[] parameters) {
        super(auxiliaryElements);
        Field<T> field = auxiliaryElements.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        this.maxEccPow = 0;
        this.resOrders = new ArrayList<Integer>();
        T mu = parameters[0];
        RealFieldElement absA = FastMath.abs(auxiliaryElements.getSma());
        this.n = (RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)mu.divide((Object)absA))).divide((Object)absA);
        T a = auxiliaryElements.getSma();
        this.period = a.getReal() < 0.0 ? (RealFieldElement)zero.add(Double.POSITIVE_INFINITY) : (RealFieldElement)((RealFieldElement)a.multiply(Math.PI * 2)).multiply(((RealFieldElement)a.divide(mu)).sqrt());
        this.A = FastMath.sqrt((RealFieldElement)((RealFieldElement)mu.multiply(auxiliaryElements.getSma())));
        this.e2 = (RealFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc());
        FieldTransform<T> t = centralBodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        FieldVector3D<T> xB = t.transformVector(FieldVector3D.getPlusI(field));
        FieldVector3D<T> yB = t.transformVector(FieldVector3D.getPlusJ(field));
        this.theta = FastMath.atan2((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getVectorF().dotProduct(yB).negate()).add(auxiliaryElements.getVectorG().dotProduct(xB).multiply(1))), (RealFieldElement)((RealFieldElement)auxiliaryElements.getVectorF().dotProduct(xB).add(auxiliaryElements.getVectorG().dotProduct(yB).multiply(1))));
        this.ax2oA = (RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().divide(this.A)).multiply(2.0);
        this.BoA = (RealFieldElement)auxiliaryElements.getB().divide(this.A);
        this.ooAB = (RealFieldElement)((RealFieldElement)this.A.multiply(auxiliaryElements.getB())).reciprocal();
        this.Co2AB = (RealFieldElement)((RealFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0);
        this.BoABpo = (RealFieldElement)this.BoA.divide(auxiliaryElements.getB().add(1.0));
        this.moa = (RealFieldElement)mu.divide(auxiliaryElements.getSma());
        this.roa = (RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().divide(provider.getAe())).reciprocal();
        this.chi = (RealFieldElement)auxiliaryElements.getB().reciprocal();
        this.chi2 = (RealFieldElement)this.chi.multiply(this.chi);
        T e = auxiliaryElements.getEcc();
        this.maxEccPow = e.getReal() <= 0.005 ? 3 : (e.getReal() <= 0.02 ? 4 : (e.getReal() <= 0.1 ? 7 : (e.getReal() <= 0.2 ? 10 : (e.getReal() <= 0.3 ? 12 : (e.getReal() <= 0.4 ? 15 : 20)))));
        this.ratio = (RealFieldElement)this.period.divide(bodyPeriod);
        RealFieldElement tolerance = (RealFieldElement)FastMath.max((RealFieldElement)((RealFieldElement)zero.add(10.0)), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.period.divide(864000.0)).reciprocal())).reciprocal();
        this.resOrders.clear();
        for (int m = 1; m <= provider.getMaxOrder(); ++m) {
            RealFieldElement resonance = (RealFieldElement)this.ratio.multiply(m);
            int jComputedRes = (int)FastMath.round((RealFieldElement)resonance);
            if (jComputedRes <= 0 || jComputedRes > maxFrequencyShortPeriodics || !(FastMath.abs((RealFieldElement)((RealFieldElement)resonance.subtract((double)jComputedRes))).getReal() <= tolerance.getReal())) continue;
            this.resOrders.add(m);
        }
    }

    public List<Integer> getResOrders() {
        return this.resOrders;
    }

    public T getE2() {
        return this.e2;
    }

    public T getTheta() {
        return this.theta;
    }

    public T getAx2oA() {
        return this.ax2oA;
    }

    public T getChi() {
        return this.chi;
    }

    public T getChi2() {
        return this.chi2;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getCo2AB() {
        return this.Co2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMoa() {
        return this.moa;
    }

    public T getRoa() {
        return this.roa;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public T getOrbitPeriod() {
        return this.period;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getRatio() {
        return this.ratio;
    }
}

