/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.VisibilityTrigger;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class CircularFieldOfViewDetector
extends AbstractDetector<CircularFieldOfViewDetector> {
    private final PVCoordinatesProvider targetPVProvider;
    private final double radiusTarget;
    private final VisibilityTrigger trigger;
    private final Vector3D center;
    private final double halfAperture;

    public CircularFieldOfViewDetector(double maxCheck, PVCoordinatesProvider pvTarget, Vector3D center, double halfAperture) {
        this(maxCheck, pvTarget, 0.0, VisibilityTrigger.VISIBLE_AS_SOON_AS_PARTIALLY_IN_FOV, center, halfAperture);
    }

    public CircularFieldOfViewDetector(double maxCheck, PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, Vector3D center, double halfAperture) {
        this(maxCheck, 0.001, 100, new StopOnDecreasing(), pvTarget, radiusTarget, trigger, center, halfAperture);
    }

    private CircularFieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super CircularFieldOfViewDetector> handler, PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, Vector3D center, double halfAperture) {
        super(maxCheck, threshold, maxIter, handler);
        this.targetPVProvider = pvTarget;
        this.radiusTarget = radiusTarget;
        this.trigger = trigger;
        this.center = center;
        this.halfAperture = halfAperture;
    }

    @Override
    protected CircularFieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super CircularFieldOfViewDetector> newHandler) {
        return new CircularFieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.radiusTarget, this.trigger, this.center, this.halfAperture);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public double getHalfAperture() {
        return this.halfAperture;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D targetPosInert = new Vector3D(1.0, this.targetPVProvider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), -1.0, s.getPVCoordinates().getPosition());
        Vector3D targetPosSat = s.getAttitude().getRotation().applyTo(targetPosInert);
        double angularRadius = FastMath.asin((double)(this.radiusTarget / targetPosSat.getNorm()));
        return this.halfAperture - Vector3D.angle((Vector3D)targetPosSat, (Vector3D)this.center) - FastMath.copySign((double)angularRadius, (double)this.trigger.getSign());
    }
}

