/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum SatelliteSystem {
    GPS('G'),
    GLONASS('R'),
    GALILEO('E'),
    BEIDOU('C'),
    QZSS('J'),
    IRNSS('I'),
    SBAS('S'),
    MIXED('M');

    private static final Map<Character, SatelliteSystem> KEYS_MAP;
    private final char key;

    private SatelliteSystem(char key) {
        this.key = key;
    }

    public char getKey() {
        return this.key;
    }

    public static SatelliteSystem parseSatelliteSystem(String s) throws OrekitIllegalArgumentException {
        SatelliteSystem satelliteSystem = KEYS_MAP.get(Character.valueOf(s.charAt(0)));
        if (satelliteSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_SATELLITE_SYSTEM, Character.valueOf(s.charAt(0)));
        }
        return satelliteSystem;
    }

    static {
        KEYS_MAP = new HashMap<Character, SatelliteSystem>();
        for (SatelliteSystem satelliteSystem : SatelliteSystem.values()) {
            KEYS_MAP.put(Character.valueOf(satelliteSystem.getKey()), satelliteSystem);
        }
    }
}

