/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.orekit.gnss.RinexLoader;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;

public class RinexHeader {
    private final double rinexVersion;
    private final SatelliteSystem satelliteSystem;
    private final String markerName;
    private final String markerNumber;
    private String markerType;
    private final String observerName;
    private final String agencyName;
    private final String receiverNumber;
    private final String receiverType;
    private final String receiverVersion;
    private final String antennaNumber;
    private final String antennaType;
    private final Vector3D approxPos;
    private final double antHeight;
    private final Vector2D eccentricities;
    private Vector3D antRefPoint;
    private String obsCode;
    private Vector3D antPhaseCenter;
    private Vector3D antBSight;
    private double antAzi;
    private Vector3D antZeroDir;
    private Vector3D centerMass;
    private String sigStrengthUnit;
    private final double interval;
    private final AbsoluteDate tFirstObs;
    private final AbsoluteDate tLastObs;
    private final int clkOffset;
    private List<RinexLoader.Parser.AppliedDCBS> listAppliedDCBS;
    private List<RinexLoader.Parser.AppliedPCVS> listAppliedPCVS;
    private List<RinexLoader.Parser.PhaseShiftCorrection> phaseShiftCorrections;
    private final int leapSeconds;
    private int leapSecondsFuture;
    private int leapSecondsWeekNum;
    private int leapSecondsDayNum;

    public RinexHeader(double rinexVersion, SatelliteSystem satelliteSystem, String markerName, String markerNumber, String markerType, String observerName, String agencyName, String receiverNumber, String receiverType, String receiverVersion, String antennaNumber, String antennaType, Vector3D approxPos, double antHeight, Vector2D eccentricities, Vector3D antRefPoint, Vector3D antBSight, Vector3D centerMass, double interval, AbsoluteDate tFirstObs, AbsoluteDate tLastObs, int clkOffset, int leapSeconds) {
        this.rinexVersion = rinexVersion;
        this.satelliteSystem = satelliteSystem;
        this.markerName = markerName;
        this.markerNumber = markerNumber;
        this.markerType = markerType;
        this.observerName = observerName;
        this.agencyName = agencyName;
        this.receiverNumber = receiverNumber;
        this.receiverType = receiverType;
        this.receiverVersion = receiverVersion;
        this.antennaNumber = antennaNumber;
        this.antennaType = antennaType;
        this.approxPos = approxPos;
        this.antHeight = antHeight;
        this.eccentricities = eccentricities;
        this.antRefPoint = antRefPoint;
        this.antBSight = antBSight;
        this.centerMass = centerMass;
        this.interval = interval;
        this.tFirstObs = tFirstObs;
        this.tLastObs = tLastObs;
        this.clkOffset = clkOffset;
        this.leapSeconds = leapSeconds;
    }

    public RinexHeader(double rinexVersion, SatelliteSystem satelliteSystem, String markerName, String markerNumber, String markerType, String observerName, String agencyName, String receiverNumber, String receiverType, String receiverVersion, String antennaNumber, String antennaType, Vector3D approxPos, double antHeight, Vector2D eccentricities, Vector3D antRefPoint, String obsCode, Vector3D antPhaseCenter, Vector3D antBSight, double antAzi, Vector3D antZeroDir, Vector3D centerMass, String sigStrengthUnit, double interval, AbsoluteDate tFirstObs, AbsoluteDate tLastObs, int clkOffset, List<RinexLoader.Parser.AppliedDCBS> listAppliedDCBS, List<RinexLoader.Parser.AppliedPCVS> listAppliedPCVS, List<RinexLoader.Parser.PhaseShiftCorrection> phaseShiftCorrections, int leapSeconds, int leapSecondsFuture, int leapSecondsWeekNum, int leapSecondsDayNum) {
        this.rinexVersion = rinexVersion;
        this.satelliteSystem = satelliteSystem;
        this.markerName = markerName;
        this.markerNumber = markerNumber;
        this.observerName = observerName;
        this.agencyName = agencyName;
        this.receiverNumber = receiverNumber;
        this.receiverType = receiverType;
        this.receiverVersion = receiverVersion;
        this.antennaNumber = antennaNumber;
        this.antennaType = antennaType;
        this.approxPos = approxPos;
        this.antHeight = antHeight;
        this.eccentricities = eccentricities;
        this.clkOffset = clkOffset;
        this.interval = interval;
        this.tFirstObs = tFirstObs;
        this.tLastObs = tLastObs;
        this.leapSeconds = leapSeconds;
        this.markerType = markerType;
        this.sigStrengthUnit = sigStrengthUnit;
        this.phaseShiftCorrections = phaseShiftCorrections;
        this.obsCode = obsCode;
        this.listAppliedDCBS = listAppliedDCBS;
        this.listAppliedPCVS = listAppliedPCVS;
        this.leapSecondsDayNum = leapSecondsDayNum;
        this.leapSecondsFuture = leapSecondsFuture;
        this.leapSecondsWeekNum = leapSecondsWeekNum;
        this.centerMass = centerMass;
        this.antAzi = antAzi;
        this.antBSight = antBSight;
        this.antZeroDir = antZeroDir;
        this.antRefPoint = antRefPoint;
        this.antPhaseCenter = antPhaseCenter;
    }

    public double getRinexVersion() {
        return this.rinexVersion;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public String getMarkerName() {
        return this.markerName;
    }

    public String getMarkerNumber() {
        return this.markerNumber;
    }

    public String getObserverName() {
        return this.observerName;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public String getReceiverNumber() {
        return this.receiverNumber;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public String getReceiverVersion() {
        return this.receiverVersion;
    }

    public String getAntennaNumber() {
        return this.antennaNumber;
    }

    public String getAntennaType() {
        return this.antennaType;
    }

    public Vector3D getApproxPos() {
        return this.approxPos;
    }

    public double getAntennaHeight() {
        return this.antHeight;
    }

    public Vector2D getEccentricities() {
        return this.eccentricities;
    }

    public int getClkOffset() {
        return this.clkOffset;
    }

    public double getInterval() {
        return this.interval;
    }

    public AbsoluteDate getTFirstObs() {
        return this.tFirstObs;
    }

    public AbsoluteDate getTLastObs() {
        return this.tLastObs;
    }

    public int getLeapSeconds() {
        return this.leapSeconds;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public Vector3D getAntennaReferencePoint() {
        return this.antRefPoint;
    }

    public String getObservationCode() {
        return this.obsCode;
    }

    public Vector3D getAntennaPhaseCenter() {
        return this.antPhaseCenter;
    }

    public Vector3D getAntennaBSight() {
        return this.antBSight;
    }

    public double getAntennaAzimuth() {
        return this.antAzi;
    }

    public Vector3D getAntennaZeroDirection() {
        return this.antZeroDir;
    }

    public Vector3D getCenterMass() {
        return this.centerMass;
    }

    public String getSignalStrengthUnit() {
        return this.sigStrengthUnit;
    }

    public int getLeapSecondsFuture() {
        return this.leapSecondsFuture;
    }

    public int getLeapSecondsWeekNum() {
        return this.leapSecondsWeekNum;
    }

    public int getLeapSecondsDayNum() {
        return this.leapSecondsDayNum;
    }

    public List<RinexLoader.Parser.AppliedDCBS> getListAppliedDCBS() {
        return this.listAppliedDCBS;
    }

    public List<RinexLoader.Parser.AppliedPCVS> getListAppliedPCVS() {
        return this.listAppliedPCVS;
    }

    public List<RinexLoader.Parser.PhaseShiftCorrection> getPhaseShiftCorrections() {
        return this.phaseShiftCorrections;
    }
}

