/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.GPSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;

public class GPSAlmanac
implements GPSOrbitalElements {
    private final String src;
    private final int prn;
    private final int svn;
    private final int health;
    private final int ura;
    private final int config;
    private final int week;
    private final double toa;
    private final double sma;
    private final double ecc;
    private final double inc;
    private final double om0;
    private final double dom;
    private final double aop;
    private final double anom;
    private final double af0;
    private final double af1;

    public GPSAlmanac(String source, int prn, int svn, int week, double toa, double sqa, double ecc, double inc, double om0, double dom, double aop, double anom, double af0, double af1, int health, int ura, int config) {
        this.src = source;
        this.prn = prn;
        this.svn = svn;
        this.week = week;
        this.toa = toa;
        this.sma = sqa * sqa;
        this.ecc = ecc;
        this.inc = inc;
        this.om0 = om0;
        this.dom = dom;
        this.aop = aop;
        this.anom = anom;
        this.af0 = af0;
        this.af1 = af1;
        this.health = health;
        this.ura = ura;
        this.config = config;
    }

    @Override
    public AbsoluteDate getDate() {
        return new GNSSDate(this.week, this.toa * 1000.0, SatelliteSystem.GPS).getDate();
    }

    public String getSource() {
        return this.src;
    }

    @Override
    public int getPRN() {
        return this.prn;
    }

    public int getSVN() {
        return this.svn;
    }

    @Override
    public int getWeek() {
        return this.week;
    }

    @Override
    public double getTime() {
        return this.toa;
    }

    @Override
    public double getSma() {
        return this.sma;
    }

    @Override
    public double getMeanMotion() {
        double absA = FastMath.abs((double)this.sma);
        return FastMath.sqrt((double)(3.986005E14 / absA)) / absA;
    }

    @Override
    public double getE() {
        return this.ecc;
    }

    @Override
    public double getI0() {
        return this.inc;
    }

    @Override
    public double getIDot() {
        return 0.0;
    }

    @Override
    public double getOmega0() {
        return this.om0;
    }

    @Override
    public double getOmegaDot() {
        return this.dom;
    }

    @Override
    public double getPa() {
        return this.aop;
    }

    @Override
    public double getM0() {
        return this.anom;
    }

    @Override
    public double getCuc() {
        return 0.0;
    }

    @Override
    public double getCus() {
        return 0.0;
    }

    @Override
    public double getCrc() {
        return 0.0;
    }

    @Override
    public double getCrs() {
        return 0.0;
    }

    @Override
    public double getCic() {
        return 0.0;
    }

    @Override
    public double getCis() {
        return 0.0;
    }

    @Override
    public double getAf0() {
        return this.af0;
    }

    @Override
    public double getAf1() {
        return this.af1;
    }

    public int getHealth() {
        return this.health;
    }

    public int getURA() {
        return this.ura;
    }

    public int getSatConfiguration() {
        return this.config;
    }
}

