/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.bodies.Ellipse;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;

public class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = 20140924L;
    private final Frame frame;
    private final double a;
    private final double b;
    private final double c;

    public Ellipsoid(Frame frame, double a, double b, double c) {
        this.frame = frame;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isInside(Vector3D point) {
        double scaledZ;
        double scaledY;
        double scaledX = point.getX() / this.a;
        return scaledX * scaledX + (scaledY = point.getY() / this.b) * scaledY + (scaledZ = point.getZ() / this.c) * scaledZ <= 1.0;
    }

    public Ellipse getPlaneSection(Vector3D planePoint, Vector3D planeNormal) throws MathRuntimeException {
        double m;
        double bMA;
        Vector3D u = planeNormal.orthogonal();
        Vector3D v = Vector3D.crossProduct((Vector3D)planeNormal, (Vector3D)u).normalize();
        double xUOa = u.getX() / this.a;
        double yUOb = u.getY() / this.b;
        double zUOc = u.getZ() / this.c;
        double xVOa = v.getX() / this.a;
        double yVOb = v.getY() / this.b;
        double zVOc = v.getZ() / this.c;
        double xPOa = planePoint.getX() / this.a;
        double yPOb = planePoint.getY() / this.b;
        double zPOc = planePoint.getZ() / this.c;
        double alpha = xUOa * xUOa + yUOb * yUOb + zUOc * zUOc;
        double beta = xVOa * xVOa + yVOb * yVOb + zVOc * zVOc;
        double gamma = MathArrays.linearCombination((double)xUOa, (double)xVOa, (double)yUOb, (double)yVOb, (double)zUOc, (double)zVOc);
        double delta = MathArrays.linearCombination((double)xPOa, (double)xUOa, (double)yPOb, (double)yUOb, (double)zPOc, (double)zUOc);
        double epsilon = MathArrays.linearCombination((double)xPOa, (double)xVOa, (double)yPOb, (double)yVOb, (double)zPOc, (double)zVOc);
        double zeta = MathArrays.linearCombination((double)xPOa, (double)xPOa, (double)yPOb, (double)yPOb, (double)zPOc, (double)zPOc, (double)1.0, (double)-1.0);
        double tanTheta = FastMath.abs((double)gamma) < Precision.SAFE_MIN ? 0.0 : ((bMA = beta - alpha) >= 0.0 ? -2.0 * gamma / (bMA + FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))) : -2.0 * gamma / (bMA - FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))));
        double tan2 = tanTheta * tanTheta;
        double cos2 = 1.0 / (1.0 + tan2);
        double sin2 = tan2 * cos2;
        double cosSin = tanTheta * cos2;
        double cos = FastMath.sqrt((double)cos2);
        double sin = tanTheta * cos;
        double denom = MathArrays.linearCombination((double)gamma, (double)gamma, (double)(-alpha), (double)beta);
        double tauC = MathArrays.linearCombination((double)beta, (double)delta, (double)(-gamma), (double)epsilon) / denom;
        double nuC = MathArrays.linearCombination((double)alpha, (double)epsilon, (double)(-gamma), (double)delta) / denom;
        double twogcs = 2.0 * gamma * cosSin;
        double bigA = alpha * cos2 + beta * sin2 + twogcs;
        double bigB = alpha * sin2 + beta * cos2 - twogcs;
        double bigF = (alpha * tauC + 2.0 * (gamma * nuC + delta)) * tauC + (beta * nuC + 2.0 * epsilon) * nuC + zeta;
        double l = FastMath.sqrt((double)(-bigF / bigA));
        if (Double.isNaN(l + (m = FastMath.sqrt((double)(-bigF / bigB))))) {
            return null;
        }
        if (l > m) {
            return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(cos, u, sin, v), new Vector3D(-sin, u, cos, v), l, m, this.frame);
        }
        return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(sin, u, -cos, v), new Vector3D(cos, u, sin, v), m, l, this.frame);
    }

    public Vector3D pointOnLimb(Vector3D observer, Vector3D outside) throws MathRuntimeException {
        double xt2;
        double xt1;
        double s;
        if (this.isInside(observer)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        Vector3D normal = Vector3D.crossProduct((Vector3D)observer, (Vector3D)outside);
        Ellipse section = this.getPlaneSection(Vector3D.ZERO, normal);
        double a2 = section.getA() * section.getA();
        double b2 = section.getB() * section.getB();
        Vector2D observer2D = section.toPlane(observer);
        double xo = observer2D.getX();
        double yo = observer2D.getY();
        double xo2 = xo * xo;
        double yo2 = yo * yo;
        double alpha = a2 * yo2 + b2 * xo2;
        double beta = a2 * b2 * xo;
        double gamma = a2 * a2 * (b2 - yo2);
        double sqrt = FastMath.sqrt((double)(beta * beta - alpha * gamma));
        if (beta > 0.0) {
            s = beta + sqrt;
            xt1 = s / alpha;
            xt2 = gamma / s;
        } else {
            s = beta - sqrt;
            xt1 = gamma / s;
            xt2 = s / alpha;
        }
        Vector3D t1 = section.toSpace(new Vector2D(xt1, b2 * (a2 - xt1 * xo) / (a2 * yo)));
        Vector3D t2 = section.toSpace(new Vector2D(xt2, b2 * (a2 - xt2 * xo) / (a2 * yo)));
        return Vector3D.distance((Vector3D)t1, (Vector3D)outside) <= Vector3D.distance((Vector3D)t2, (Vector3D)outside) ? t1 : t2;
    }
}

