/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.events.Action;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class AttitudesSequence
implements AttitudeProvider {
    private transient TimeSpanMap<AttitudeProvider> activated = null;
    private final List<Switch<?>> switches = new ArrayList();

    public void resetActiveProvider(AttitudeProvider provider) {
        this.activated = new TimeSpanMap<AttitudeProvider>(provider);
    }

    public void registerSwitchEvents(Propagator propagator) {
        for (Switch<?> s : this.switches) {
            propagator.addEventDetector(s);
        }
    }

    public <T extends RealFieldElement<T>> void registerSwitchEvents(final Field<T> field, FieldPropagator<T> propagator) {
        for (final Switch<?> sw : this.switches) {
            propagator.addEventDetector(new FieldEventDetector<T>(){

                @Override
                public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
                    sw.init(s0.toSpacecraftState(), t.toAbsoluteDate());
                }

                @Override
                public T g(FieldSpacecraftState<T> s) {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.g(s.toSpacecraftState()));
                }

                @Override
                public T getThreshold() {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.getThreshold());
                }

                @Override
                public T getMaxCheckInterval() {
                    return (RealFieldElement)((RealFieldElement)field.getZero()).add(sw.getMaxCheckInterval());
                }

                @Override
                public int getMaxIterationCount() {
                    return sw.getMaxIterationCount();
                }

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, boolean increasing) {
                    return sw.eventOccurred(s.toSpacecraftState(), increasing);
                }

                @Override
                public FieldSpacecraftState<T> resetState(FieldSpacecraftState<T> oldState) {
                    return new FieldSpacecraftState(field, sw.resetState(oldState.toSpacecraftState()));
                }
            });
        }
    }

    public <T extends EventDetector> void addSwitchingCondition(AttitudeProvider past, AttitudeProvider future, T switchEvent, boolean switchOnIncrease, boolean switchOnDecrease, double transitionTime, AngularDerivativesFilter transitionFilter, SwitchHandler handler) {
        if (transitionTime < switchEvent.getThreshold()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SHORT_TRANSITION_TIME_FOR_ATTITUDES_SWITCH, transitionTime, switchEvent.getThreshold());
        }
        if (this.activated == null) {
            this.resetActiveProvider(past);
        }
        this.switches.add(new Switch(this, switchEvent, switchOnIncrease, switchOnDecrease, past, future, transitionTime, transitionFilter, handler));
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.activated.get(date).getAttitude(pvProv, date, frame);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.activated.get(date.toAbsoluteDate()).getAttitude(pvProv, date, frame);
    }

    public static interface SwitchHandler {
        public void switchOccurred(AttitudeProvider var1, AttitudeProvider var2, SpacecraftState var3);
    }

    private class Switch<T extends EventDetector>
    implements EventDetector {
        private final T event;
        private final boolean switchOnIncrease;
        private final boolean switchOnDecrease;
        private final AttitudeProvider past;
        private final AttitudeProvider future;
        private final double transitionTime;
        private final AngularDerivativesFilter transitionFilter;
        private final SwitchHandler switchHandler;
        private boolean forward;
        final /* synthetic */ AttitudesSequence this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Switch(T switchOnDecrease, boolean past, boolean future, AttitudeProvider transitionTime, AttitudeProvider attitudeProvider, double transitionFilter, AngularDerivativesFilter angularDerivativesFilter, SwitchHandler switchHandler) {
            void switchHandler2;
            void event;
            this.this$0 = (AttitudesSequence)d;
            this.event = event;
            this.switchOnIncrease = switchOnIncrease;
            this.switchOnDecrease = switchOnDecrease;
            this.past = past;
            this.future = future;
            this.transitionTime = transitionTime;
            this.transitionFilter = transitionFilter;
            this.switchHandler = switchHandler2;
        }

        @Override
        public double getThreshold() {
            return this.event.getThreshold();
        }

        @Override
        public double getMaxCheckInterval() {
            return this.event.getMaxCheckInterval();
        }

        @Override
        public int getMaxIterationCount() {
            return this.event.getMaxIterationCount();
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            boolean bl = this.forward = t.durationFrom(s0.getDate()) >= 0.0;
            if (this.this$0.activated.getTransitions().size() > 1) {
                if (this.forward) {
                    this.this$0.activated = this.this$0.activated.extractRange(AbsoluteDate.PAST_INFINITY, s0.getDate().shiftedBy(this.transitionTime));
                } else {
                    this.this$0.activated = this.this$0.activated.extractRange(s0.getDate().shiftedBy(-this.transitionTime), AbsoluteDate.FUTURE_INFINITY);
                }
            }
            this.event.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) {
            return this.event.g(this.forward ? s : s.shiftedBy(-this.transitionTime));
        }

        @Override
        public Action eventOccurred(SpacecraftState s, boolean increasing) {
            AbsoluteDate date = s.getDate();
            if (this.this$0.activated.get(date) == (this.forward ? this.past : this.future) && (increasing && this.switchOnIncrease || !increasing && this.switchOnDecrease)) {
                if (this.forward) {
                    AbsoluteDate transitionEnd = date.shiftedBy(this.transitionTime);
                    this.this$0.activated.addValidAfter(new TransitionProvider(s.getAttitude(), transitionEnd), date);
                    this.this$0.activated.addValidAfter(this.future, transitionEnd);
                    if (this.switchHandler != null) {
                        this.switchHandler.switchOccurred(this.past, this.future, s);
                    }
                    return this.event.eventOccurred(s, increasing);
                }
                Orbit sOrbit = s.getOrbit().shiftedBy(-this.transitionTime);
                Attitude sAttitude = this.past.getAttitude(sOrbit, sOrbit.getDate(), sOrbit.getFrame());
                SpacecraftState sState = new SpacecraftState(sOrbit, sAttitude, s.getMass());
                for (Map.Entry<String, double[]> entry : s.getAdditionalStates().entrySet()) {
                    sState = sState.addAdditionalState(entry.getKey(), entry.getValue());
                }
                this.this$0.activated.addValidBefore(new TransitionProvider(sAttitude, date), date);
                this.this$0.activated.addValidBefore(this.past, sOrbit.getDate());
                if (this.switchHandler != null) {
                    this.switchHandler.switchOccurred(this.future, this.past, sState);
                }
                return this.event.eventOccurred(sState, increasing);
            }
            return this.event.eventOccurred(s, increasing);
        }

        @Override
        public SpacecraftState resetState(SpacecraftState oldState) {
            return this.event.resetState(oldState);
        }

        private class TransitionProvider
        implements AttitudeProvider {
            private final Attitude transitionPreceding;
            private final AbsoluteDate transitionEnd;

            TransitionProvider(Attitude transitionPreceding, AbsoluteDate transitionEnd) {
                this.transitionPreceding = transitionPreceding;
                this.transitionEnd = transitionEnd;
            }

            @Override
            public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
                TimeStampedAngularCoordinates start = this.transitionPreceding.withReferenceFrame(frame).getOrientation();
                TimeStampedAngularCoordinates end = Switch.this.future.getAttitude(pvProv, this.transitionEnd, frame).getOrientation();
                TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, Switch.this.transitionFilter, Arrays.asList(start, end));
                return new Attitude(frame, interpolated);
            }

            public <S extends RealFieldElement<S>> FieldAttitude<S> getAttitude(FieldPVCoordinatesProvider<S> pvProv, FieldAbsoluteDate<S> date, Frame frame) {
                TimeStampedFieldAngularCoordinates<S> start = new TimeStampedFieldAngularCoordinates<S>(date.getField(), this.transitionPreceding.withReferenceFrame(frame).getOrientation());
                TimeStampedFieldAngularCoordinates<S> end = Switch.this.future.getAttitude(pvProv, new FieldAbsoluteDate<S>(date.getField(), this.transitionEnd), frame).getOrientation();
                TimeStampedFieldAngularCoordinates<S> interpolated = TimeStampedFieldAngularCoordinates.interpolate(date, Switch.this.transitionFilter, Arrays.asList(start, end));
                return new FieldAttitude<S>(frame, interpolated);
            }
        }
    }
}

