/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSatellitesRangeBuilder
extends AbstractMeasurementBuilder<InterSatellitesRange> {
    private final boolean twoway;

    public InterSatellitesRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, boolean twoWay, double sigma, double baseWeight) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.twoway = twoWay;
    }

    @Override
    public InterSatellitesRange build(SpacecraftState[] states) {
        ObservableSatellite[] satellites = this.getSatellites();
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState state = states[satellites[0].getPropagatorIndex()];
        InterSatellitesRange dummy = new InterSatellitesRange(satellites[0], satellites[1], this.twoway, state.getDate(), Double.NaN, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimate(0, 0, states).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        InterSatellitesRange measurement = new InterSatellitesRange(satellites[0], satellites[1], this.twoway, state.getDate(), range, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

