/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.RealFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class L1TransformProvider
implements TransformProvider {
    private static final double RELATIVE_ACCURACY = 1.0E-14;
    private static final double ABSOLUTE_ACCURACY = 0.001;
    private static final double FUNCTION_ACCURACY = 0.0;
    private static final int MAX_ORDER = 5;
    private static final int MAX_EVALUATIONS = 1000;
    private static final long serialVersionUID = 20170824L;
    private final Frame frame;
    private final CelestialBody primaryBody;
    private final CelestialBody secondaryBody;

    public L1TransformProvider(CelestialBody primaryBody, CelestialBody secondaryBody) {
        this.primaryBody = primaryBody;
        this.secondaryBody = secondaryBody;
        this.frame = primaryBody.getInertiallyOrientedFrame();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        TimeStampedPVCoordinates pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        Vector3D translation = this.getL1(pv21.getPosition()).negate();
        Rotation rotation = new Rotation(pv21.getPosition(), pv21.getVelocity(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        return new Transform(date, new Transform(date, translation), new Transform(date, rotation));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        TimeStampedFieldPVCoordinates<T> pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        FieldVector3D translation = this.getL1(pv21.getPosition()).negate();
        Field field = pv21.getPosition().getX().getField();
        FieldRotation rotation = new FieldRotation(pv21.getPosition(), pv21.getVelocity(), FieldVector3D.getPlusI((Field)field), FieldVector3D.getPlusJ((Field)field));
        return new FieldTransform<T>(date, new FieldTransform<T>(date, translation), new FieldTransform<T>(date, rotation));
    }

    private Vector3D getL1(Vector3D primaryToSecondary) {
        double massRatio = this.secondaryBody.getGM() / this.primaryBody.getGM();
        double bigR = primaryToSecondary.getNorm();
        double baseR = bigR * (1.0 - FastMath.cbrt((double)(massRatio / 3.0)));
        UnivariateFunction l1Equation = r -> {
            double bigrminusR = bigR - r;
            double lhs = 1.0 / (r * r);
            double rhs1 = massRatio / (bigrminusR * bigrminusR);
            double rhs2 = 1.0 / (bigR * bigR);
            double rhs3 = (1.0 + massRatio) * bigrminusR * rhs2 / bigR;
            return lhs - (rhs1 + rhs2 - rhs3);
        };
        double[] searchInterval = UnivariateSolverUtils.bracket((UnivariateFunction)l1Equation, (double)baseR, (double)0.0, (double)bigR, (double)(0.01 * bigR), (double)1.0, (int)1000);
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-14, 0.001, 0.0, 5);
        double r2 = solver.solve(1000, l1Equation, searchInterval[0], searchInterval[1], AllowedSolution.ANY_SIDE);
        return new Vector3D(r2 / bigR, primaryToSecondary);
    }

    private <T extends RealFieldElement<T>> FieldVector3D<T> getL1(FieldVector3D<T> primaryToSecondary) {
        double massRatio = this.secondaryBody.getGM() / this.primaryBody.getGM();
        RealFieldElement bigR = primaryToSecondary.getNorm();
        RealFieldElement baseR = (RealFieldElement)bigR.multiply(1.0 - FastMath.cbrt((double)(massRatio / 3.0)));
        RealFieldUnivariateFunction l1Equation = r -> {
            RealFieldElement bigrminusR = (RealFieldElement)bigR.subtract((Object)r);
            RealFieldElement lhs = (RealFieldElement)((RealFieldElement)r.multiply((Object)r)).reciprocal();
            RealFieldElement rhs1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)bigrminusR.multiply((Object)bigrminusR)).reciprocal()).multiply(massRatio);
            RealFieldElement rhs2 = (RealFieldElement)((RealFieldElement)bigR.multiply((Object)bigR)).reciprocal();
            RealFieldElement rhs3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)bigrminusR.multiply((Object)rhs2)).multiply(1.0 + massRatio)).divide((Object)bigR);
            return (RealFieldElement)lhs.subtract(((RealFieldElement)rhs1.add((Object)rhs2)).add((Object)rhs3));
        };
        RealFieldElement zero = (RealFieldElement)primaryToSecondary.getX().getField().getZero();
        RealFieldElement[] searchInterval = UnivariateSolverUtils.bracket((RealFieldUnivariateFunction)l1Equation, (RealFieldElement)baseR, (RealFieldElement)zero, (RealFieldElement)((RealFieldElement)bigR.multiply(2)), (RealFieldElement)((RealFieldElement)bigR.multiply(0.01)), (RealFieldElement)((RealFieldElement)zero.add(1.0)), (int)1000);
        RealFieldElement relativeAccuracy = (RealFieldElement)zero.add(1.0E-14);
        RealFieldElement absoluteAccuracy = (RealFieldElement)zero.add(0.001);
        RealFieldElement functionAccuracy = (RealFieldElement)zero.add(0.0);
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver(relativeAccuracy, absoluteAccuracy, functionAccuracy, 5);
        RealFieldElement r2 = solver.solve(1000, l1Equation, searchInterval[0], searchInterval[1], AllowedSolution.ANY_SIDE);
        return new FieldVector3D((RealFieldElement)r2.divide((Object)bigR), primaryToSecondary);
    }
}

