/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PV
extends AbstractMeasurement<PV> {
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private final double[][] covarianceMatrix;

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double sigmaPosition, double sigmaVelocity, double baseWeight, ObservableSatellite satellite) {
        this(date, position, velocity, new double[]{sigmaPosition, sigmaPosition, sigmaPosition, sigmaVelocity, sigmaVelocity, sigmaVelocity}, baseWeight, satellite);
    }

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double[] sigmaPosition, double[] sigmaVelocity, double baseWeight, ObservableSatellite satellite) {
        this(date, position, velocity, PV.buildPvCovarianceMatrix(sigmaPosition, sigmaVelocity), baseWeight, satellite);
    }

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double[] sigmaPV, double baseWeight, ObservableSatellite satellite) {
        this(date, position, velocity, PV.buildPvCovarianceMatrix(sigmaPV), baseWeight, satellite);
    }

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double[][] positionCovarianceMatrix, double[][] velocityCovarianceMatrix, double baseWeight, ObservableSatellite satellite) {
        this(date, position, velocity, PV.buildPvCovarianceMatrix(positionCovarianceMatrix, velocityCovarianceMatrix), baseWeight, satellite);
    }

    public PV(AbsoluteDate date, Vector3D position, Vector3D velocity, double[][] covarianceMatrix, double baseWeight, ObservableSatellite satellite) {
        super(date, new double[]{position.getX(), position.getY(), position.getZ(), velocity.getX(), velocity.getY(), velocity.getZ()}, PV.extractSigmas(covarianceMatrix), new double[]{baseWeight, baseWeight, baseWeight, baseWeight, baseWeight, baseWeight}, Arrays.asList(satellite));
        this.covarianceMatrix = (double[][])covarianceMatrix.clone();
    }

    public Vector3D getPosition() {
        double[] pv = this.getObservedValue();
        return new Vector3D(pv[0], pv[1], pv[2]);
    }

    public Vector3D getVelocity() {
        double[] pv = this.getObservedValue();
        return new Vector3D(pv[3], pv[4], pv[5]);
    }

    public double[][] getCovarianceMatrix() {
        return (double[][])this.covarianceMatrix.clone();
    }

    public double[][] getCorrelationCoefficientsMatrix() {
        double[] sigmas = this.getTheoreticalStandardDeviation();
        double[][] corrCoefMatrix = new double[sigmas.length][sigmas.length];
        for (int i = 0; i < sigmas.length; ++i) {
            for (int j = 0; j < sigmas.length; ++j) {
                corrCoefMatrix[i][j] = this.covarianceMatrix[i][j] / (sigmas[i] * sigmas[j]);
            }
        }
        return corrCoefMatrix;
    }

    @Override
    protected EstimatedMeasurement<PV> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites().get(0);
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        TimeStampedPVCoordinates pv = state.getPVCoordinates();
        EstimatedMeasurement<PV> estimated = new EstimatedMeasurement<PV>(this, iteration, evaluation, states, new TimeStampedPVCoordinates[]{pv});
        estimated.setEstimatedValue(pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ());
        estimated.setStateDerivatives(0, IDENTITY);
        return estimated;
    }

    private static double[] extractSigmas(double[][] pvCovarianceMatrix) {
        if (pvCovarianceMatrix.length != 6 || pvCovarianceMatrix[0].length != 6) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, pvCovarianceMatrix.length, pvCovarianceMatrix[0], 6, 6);
        }
        double[] sigmas = new double[6];
        for (int i = 0; i < sigmas.length; ++i) {
            sigmas[i] = FastMath.sqrt((double)pvCovarianceMatrix[i][i]);
        }
        return sigmas;
    }

    private static double[][] buildPvCovarianceMatrix(double[][] positionCovarianceMatrix, double[][] velocityCovarianceMatrix) {
        if (positionCovarianceMatrix.length != 3 || positionCovarianceMatrix[0].length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, positionCovarianceMatrix.length, positionCovarianceMatrix[0], 3, 3);
        }
        if (velocityCovarianceMatrix.length != 3 || velocityCovarianceMatrix[0].length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, velocityCovarianceMatrix.length, velocityCovarianceMatrix[0], 3, 3);
        }
        double[][] pvCovarianceMatrix = new double[6][6];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                pvCovarianceMatrix[i][j] = positionCovarianceMatrix[i][j];
                pvCovarianceMatrix[i + 3][j + 3] = velocityCovarianceMatrix[i][j];
            }
        }
        return pvCovarianceMatrix;
    }

    private static double[][] buildPvCovarianceMatrix(double[] sigmaPV) {
        if (sigmaPV.length != 6) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, sigmaPV.length, 6);
        }
        double[][] pvCovarianceMatrix = new double[6][6];
        for (int i = 0; i < sigmaPV.length; ++i) {
            pvCovarianceMatrix[i][i] = sigmaPV[i] * sigmaPV[i];
        }
        return pvCovarianceMatrix;
    }

    private static double[][] buildPvCovarianceMatrix(double[] sigmaPosition, double[] sigmaVelocity) {
        if (sigmaPosition.length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, sigmaPosition.length, 3);
        }
        if (sigmaVelocity.length != 3) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, sigmaVelocity.length, 3);
        }
        double[][] pvCovarianceMatrix = new double[6][6];
        for (int i = 0; i < sigmaPosition.length; ++i) {
            pvCovarianceMatrix[i][i] = sigmaPosition[i] * sigmaPosition[i];
            pvCovarianceMatrix[i + 3][i + 3] = sigmaVelocity[i] * sigmaVelocity[i];
        }
        return pvCovarianceMatrix;
    }
}

