/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.errors;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.Transform;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.Dump;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorMeanPlaneCrossing;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.raster.Tile;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;

public class DumpManager {
    private static final ThreadLocal<Dump> DUMP = new ThreadLocal();
    private static boolean isSuspended = false;

    private DumpManager() {
    }

    public static void activate(File file) {
        if (DumpManager.isActive()) {
            throw new RuggedException(RuggedMessages.DEBUG_DUMP_ALREADY_ACTIVE, new Object[0]);
        }
        try {
            DUMP.set(new Dump(new PrintWriter(file, "UTF-8")));
        }
        catch (IOException ioe) {
            throw new RuggedException(ioe, RuggedMessages.DEBUG_DUMP_ACTIVATION_ERROR, file.getAbsolutePath(), ioe.getLocalizedMessage());
        }
    }

    public static void deactivate() {
        if (!DumpManager.isActive()) {
            throw new RuggedException(RuggedMessages.DEBUG_DUMP_NOT_ACTIVE, new Object[0]);
        }
        DUMP.get().deactivate();
        DUMP.set(null);
    }

    public static Boolean suspend() {
        if (isSuspended) {
            return isSuspended;
        }
        isSuspended = true;
        return false;
    }

    public static void resume(Boolean wasSuspended) {
        if (!wasSuspended.booleanValue()) {
            isSuspended = false;
        }
    }

    public static void endNicely() {
        isSuspended = false;
        if (DumpManager.isActive()) {
            DumpManager.deactivate();
        }
    }

    public static boolean isActive() {
        return DUMP.get() != null && !isSuspended;
    }

    public static void dumpTileCell(Tile tile, int latitudeIndex, int longitudeIndex, double elevation) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpTileCell(tile, latitudeIndex, longitudeIndex, elevation);
        }
    }

    public static void dumpAlgorithm(AlgorithmId algorithmId) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpAlgorithm(algorithmId);
        }
    }

    public static void dumpAlgorithm(AlgorithmId algorithmId, double specific) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpAlgorithm(algorithmId, specific);
        }
    }

    public static void dumpEllipsoid(ExtendedEllipsoid ellipsoid) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpEllipsoid(ellipsoid);
        }
    }

    public static void dumpDirectLocation(AbsoluteDate date, Vector3D sensorPosition, Vector3D los, boolean lightTimeCorrection, boolean aberrationOfLightCorrection, boolean refractionCorrection) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpDirectLocation(date, sensorPosition, los, lightTimeCorrection, aberrationOfLightCorrection, refractionCorrection);
        }
    }

    public static void dumpDirectLocationResult(GeodeticPoint gp) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpDirectLocationResult(gp);
        }
    }

    public static void dumpInverseLocation(LineSensor sensor, GeodeticPoint point, ExtendedEllipsoid ellipsoid, int minLine, int maxLine, boolean lightTimeCorrection, boolean aberrationOfLightCorrection, boolean refractionCorrection) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpInverseLocation(sensor, point, minLine, maxLine, lightTimeCorrection, aberrationOfLightCorrection, refractionCorrection);
            DUMP.get().dumpEllipsoid(ellipsoid);
        }
    }

    public static void dumpInverseLocationResult(SensorPixel pixel) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpInverseLocationResult(pixel);
        }
    }

    public static void dumpTransform(SpacecraftToObservedBody scToBody, int index, Transform bodyToInertial, Transform scToInertial) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpTransform(scToBody, index, bodyToInertial, scToInertial);
        }
    }

    public static void dumpSensorMeanPlane(SensorMeanPlaneCrossing meanPlane) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpSensorMeanPlane(meanPlane);
        }
    }

    public static void dumpSensorLOS(LineSensor sensor, AbsoluteDate date, int i, Vector3D los) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpSensorLOS(sensor, date, i, los);
        }
    }

    public static void dumpSensorDatation(LineSensor sensor, double lineNumber, AbsoluteDate date) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpSensorDatation(sensor, lineNumber, date);
        }
    }

    public static void dumpSensorRate(LineSensor sensor, double lineNumber, double rate) {
        if (DumpManager.isActive()) {
            DUMP.get().dumpSensorRate(sensor, lineNumber, rate);
        }
    }
}

