from openquake.hazardlib.mfd.truncated_gr import TruncatedGRMFD


TEST1_EDGES = [
    [(0.0, 0.0, 0.0), (0.0, 0.0359728811758, 0.0), (0.0190775080917, 0.0550503815181, 0.0), (0.03974514139, 0.0723925718855, 0.0)],
    [(0.0334458231229, -0.0183624932002, 4.24264068712), (0.0334458257892, 0.0176103869541, 4.24264068712), (0.0525233391196, 0.0366878882799, 4.24264068712), (0.0731909809864, 0.0540300791054, 4.24264068712)],
]
TEST1_MFD = TruncatedGRMFD(a_val=0.5, b_val=1.0, min_mag=3.0, max_mag=4.0, bin_width=1.0)
TEST1_MESH_SPACING = 1.0
TEST1_RUPTURE_ASPECT_RATIO = 1.0
TEST1_RUPTURES = [
    dict(
        mag=3.5,
        strike=1.09606675397e-06,
        dip=48.7672680443,
        rake=0.0,
        hypocenter=(0.00278715191981, 0.00296640242165, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.0,0.0), (0.0,0.00899322029302,0.0), ],
            [(0.00557430366758,-0.00306041570197,0.707106781187), (0.00557430401166,0.00593280509556,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.10052538286e-06,
        dip=48.7672668672,
        rake=0.0,
        hypocenter=(0.0027871520922, 0.0119596229695, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.00899322029302,0.0), (0.0,0.017986440586,0.0), ],
            [(0.00557430401166,0.00593280509556,0.707106781187), (0.00557430435714,0.0149260259035,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.09768486756e-06,
        dip=48.7672663905,
        rake=0.0,
        hypocenter=(0.00278715226472, 0.0209528435166, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.017986440586,0.0), (0.0,0.026979660879,0.0), ],
            [(0.00557430435714,0.0149260259035,0.707106781187), (0.00557430470173,0.0239192466979,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.15706238938e-06,
        dip=48.7672633358,
        rake=0.0,
        hypocenter=(0.00278715267711, 0.0299460639653, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.026979660879,0.0), (0.0,0.035972881172,0.0), ],
            [(0.00557430470173,0.0239192466979,0.707106781187), (0.00557430600673,0.0329124671124,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=44.9999968138,
        dip=46.1696975368,
        rake=0.0,
        hypocenter=(0.00596673724858, 0.0376222578277, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.035972881172,0.0), (0.00635916825871,0.0423320484941,0.0), ],
            [(0.00557430600673,0.0329124671124,0.707106781187), (0.0119334747289,0.039271634532,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000010016,
        dip=46.1696986358,
        rake=0.0,
        hypocenter=(0.0123259062457, 0.0439814249499, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00635916825871,0.0423320484941,0.0), (0.0127183375697,0.0486912153003,0.0), ],
            [(0.0119334747289,0.039271634532,0.707106781187), (0.0182926444254,0.0456308014731,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000061771,
        dip=46.169700268,
        rake=0.0,
        hypocenter=(0.0186850763457, 0.0503405915158, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0127183375697,0.0486912153003,0.0), (0.0190775080803,0.0550503815067,0.0), ],
            [(0.0182926444254,0.0456308014731,0.707106781187), (0.0246518153075,0.0519899677829,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=49.9999947793,
        dip=47.0166454002,
        rake=0.0,
        hypocenter=(0.0253092665929, 0.0564105401353, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0190775080803,0.0550503815067,0.0), (0.0259667176627,0.060831112543,0.0), ],
            [(0.0246518153075,0.0519899677829,0.707106781187), (0.0315410253211,0.0577706987086,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000015574,
        dip=47.0166470471,
        rake=0.0,
        hypocenter=(0.0321984771064, 0.0621912706849, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0259667176627,0.060831112543,0.0), (0.0328559287146,0.0666118426928,0.0), ],
            [(0.0315410253211,0.0577706987086,0.707106781187), (0.0384302367273,0.0635514287953,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000090423,
        dip=47.0166494051,
        rake=0.0,
        hypocenter=(0.0390876891256, 0.0679720003324, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0328559287146,0.0666118426928,0.0), (0.0397451413828,0.0723925718794,0.0), ],
            [(0.0384302367273,0.0635514287953,0.707106781187), (0.0453194496776,0.069332157962,0.707106781187), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.99045243725e-06,
        dip=48.7704200638,
        rake=0.0,
        hypocenter=(0.00836145575197, -9.40130348571e-05, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430366758,-0.00306041570197,0.707106781187), (0.00557430401166,0.00593280509556,0.707106781187), ],
            [(0.011148607367,-0.00612083137497,1.41421356237), (0.0111486079617,0.00287238984195,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.00382832368e-06,
        dip=48.7704191225,
        rake=0.0,
        hypocenter=(0.00836145622241, 0.00889920798019, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430401166,0.00593280509556,0.707106781187), (0.00557430435714,0.0149260259035,0.707106781187), ],
            [(0.0111486079617,0.00287238984195,1.41421356237), (0.0111486085592,0.0118656110797,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.99530682884e-06,
        dip=48.7704188854,
        rake=0.0,
        hypocenter=(0.00836145669322, 0.0178924289929, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430435714,0.0149260259035,0.707106781187), (0.00557430470173,0.0239192466979,0.707106781187), ],
            [(0.0111486085592,0.0118656110797,1.41421356237), (0.0111486091549,0.0208588322903,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.21734394774e-05,
        dip=48.7704144038,
        rake=0.0,
        hypocenter=(0.00836145788368, 0.0268856497105, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430470173,0.0239192466979,0.707106781187), (0.00557430600673,0.0329124671124,0.707106781187), ],
            [(0.0111486091549,0.0208588322903,1.41421356237), (0.0111486116714,0.0298520527413,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=44.9999995826,
        dip=46.1728746954,
        rake=0.0,
        hypocenter=(0.0115410432995, 0.034561843646, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430600673,0.0329124671124,0.707106781187), (0.0119334747289,0.039271634532,0.707106781187), ],
            [(0.0111486116714,0.0298520527413,1.41421356237), (0.0175077807909,0.0362112201982,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.000003421,
        dip=46.1728756536,
        rake=0.0,
        hypocenter=(0.017900212688, 0.0409210108543, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0119334747289,0.039271634532,0.707106781187), (0.0182926444254,0.0456308014731,0.707106781187), ],
            [(0.0175077807909,0.0362112201982,1.41421356237), (0.0238669508068,0.0425703872139,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000088451,
        dip=46.172877232,
        rake=0.0,
        hypocenter=(0.0242593831335, 0.0472801775092, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0182926444254,0.0456308014731,0.707106781187), (0.0246518153075,0.0519899677829,0.707106781187), ],
            [(0.0238669508068,0.0425703872139,1.41421356237), (0.0302261219942,0.0489295535669,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=49.9999987229,
        dip=47.0198171642,
        rake=0.0,
        hypocenter=(0.0308835737505, 0.0533501260964, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0246518153075,0.0519899677829,0.707106781187), (0.0315410253211,0.0577706987086,0.707106781187), ],
            [(0.0302261219942,0.0489295535669,1.41421356237), (0.037115332379,0.0547102843274,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000051058,
        dip=47.0198186255,
        rake=0.0,
        hypocenter=(0.0377727846267, 0.0591308565319, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0315410253211,0.0577706987086,0.707106781187), (0.0384302367273,0.0635514287953,0.707106781187), ],
            [(0.037115332379,0.0547102843274,1.41421356237), (0.0440045440795,0.0604910142963,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.000012237,
        dip=47.019820806,
        rake=0.0,
        hypocenter=(0.044661996934, 0.0649115861105, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0384302367273,0.0635514287953,0.707106781187), (0.0453194496776,0.069332157962,0.707106781187), ],
            [(0.0440045440795,0.0604910142963,1.41421356237), (0.0508937572518,0.0662717433884,1.41421356237), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.28934266665e-06,
        dip=48.7735724685,
        rake=0.0,
        hypocenter=(0.0139357595851, -0.00315442849048, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.011148607367,-0.00612083137497,1.41421356237), (0.0111486079617,0.00287238984195,1.41421356237), ],
            [(0.01672291113,-0.00918124699004,2.12132034356), (0.0167229118818,-0.000188025438857,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.31163586377e-06,
        dip=48.7735717628,
        rake=0.0,
        hypocenter=(0.0139357602601, 0.00583879290661, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486079617,0.00287238984195,1.41421356237), (0.0111486085592,0.0118656110797,1.41421356237), ],
            [(0.0167229118818,-0.000188025438857,2.12132034356), (0.0167229126378,0.00880519614362,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.29743353979e-06,
        dip=48.7735717653,
        rake=0.0,
        hypocenter=(0.0139357609358, 0.0148320142997, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486085592,0.0118656110797,1.41421356237), (0.0111486091549,0.0208588322903,1.41421356237), ],
            [(0.0167229126378,0.00880519614362,2.12132034356), (0.0167229133912,0.0177984176853,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.95943212803e-05,
        dip=48.773565857,
        rake=0.0,
        hypocenter=(0.0139357628108, 0.0238252352011, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486091549,0.0208588322903,1.41421356237), (0.0111486116714,0.0298520527413,1.41421356237), ],
            [(0.0167229133912,0.0177984176853,2.12132034356), (0.0167229170258,0.0267916380876,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000022431,
        dip=46.1760522199,
        rake=0.0,
        hypocenter=(0.0171153489911, 0.0315014291372, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486116714,0.0298520527413,1.41421356237), (0.0175077807909,0.0362112201982,1.41421356237), ],
            [(0.0167229170258,0.0267916380876,2.12132034356), (0.0230820864765,0.0331508055217,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000057321,
        dip=46.1760530373,
        rake=0.0,
        hypocenter=(0.023474518705, 0.0378605963714, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0175077807909,0.0362112201982,1.41421356237), (0.0238669508068,0.0425703872139,1.41421356237), ],
            [(0.0230820864765,0.0331508055217,2.12132034356), (0.0294412567457,0.0395099725519,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000114049,
        dip=46.1760545618,
        rake=0.0,
        hypocenter=(0.0298336894298, 0.0442197630551, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0238669508068,0.0425703872139,1.41421356237), (0.0302261219942,0.0489295535669,1.41421356237), ],
            [(0.0294412567457,0.0395099725519,2.12132034356), (0.0358004281725,0.0458691388878,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.000002607,
        dip=47.0229893017,
        rake=0.0,
        hypocenter=(0.0364578803535, 0.0502897115526, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0302261219942,0.0489295535669,1.41421356237), (0.037115332379,0.0547102843274,1.41421356237), ],
            [(0.0358004281725,0.0458691388878,2.12132034356), (0.0426896388684,0.0516498694283,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000085948,
        dip=47.0229905775,
        rake=0.0,
        hypocenter=(0.0433470915325, 0.0560704418192, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.037115332379,0.0547102843274,1.41421356237), (0.0440045440795,0.0604910142963,1.41421356237), ],
            [(0.0426896388684,0.0516498694283,2.12132034356), (0.0495788508029,0.0574305992247,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000153722,
        dip=47.0229925804,
        rake=0.0,
        hypocenter=(0.0502363040679, 0.0618511712742, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0440045440795,0.0604910142963,1.41421356237), (0.0508937572518,0.0662717433884,1.41421356237), ],
            [(0.0495788508029,0.0574305992247,2.12132034356), (0.0564680641372,0.0632113281874,2.12132034356), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.99273744217e-06,
        dip=48.7767252583,
        rake=0.0,
        hypocenter=(0.019510063451, -0.00621484391624, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.01672291113,-0.00918124699004,2.12132034356), (0.0167229118818,-0.000188025438857,2.12132034356), ],
            [(0.0222972149884,-0.0122416625182,2.82842712475), (0.0222972158039,-0.00324844071788,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=5.0239480981e-06,
        dip=48.7767247882,
        rake=0.0,
        hypocenter=(0.0195100642371, 0.00277837777776, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229118818,-0.000188025438857,2.12132034356), (0.0167229126378,0.00880519614362,2.12132034356), ],
            [(0.0222972158039,-0.00324844071788,2.82842712475), (0.022297216625,0.00574478112417,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=5.00406510219e-06,
        dip=48.7767250304,
        rake=0.0,
        hypocenter=(0.0195100650242, 0.0117715994662, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229126378,0.00880519614362,2.12132034356), (0.0167229133912,0.0177984176853,2.12132034356), ],
            [(0.022297216625,0.00574478112417,2.82842712475), (0.0222972174426,0.0147380029119,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.6419707952e-05,
        dip=48.7767176953,
        rake=0.0,
        hypocenter=(0.0195100674903, 0.0207648204663, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229133912,0.0177984176853,2.12132034356), (0.0167229170258,0.0267916380876,2.12132034356), ],
            [(0.0222972174426,0.0147380029119,2.82842712475), (0.0222972221017,0.0237312231803,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000047953,
        dip=46.1792301102,
        rake=0.0,
        hypocenter=(0.0226896543554, 0.0284410143303, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229170258,0.0267916380876,2.12132034356), (0.0230820864765,0.0331508055217,2.12132034356), ],
            [(0.0222972221017,0.0237312231803,2.82842712475), (0.0286563918176,0.0300903905314,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.000007935,
        dip=46.1792307868,
        rake=0.0,
        hypocenter=(0.0290488243284, 0.0348001815302, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0230820864765,0.0331508055217,2.12132034356), (0.0294412567457,0.0395099725519,2.12132034356), ],
            [(0.0286563918176,0.0300903905314,2.82842712475), (0.035015562274,0.0364495575158,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000138563,
        dip=46.1792322576,
        rake=0.0,
        hypocenter=(0.0354079952665, 0.0411593481825, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0294412567457,0.0395099725519,2.12132034356), (0.0358004281725,0.0458691388878,2.12132034356), ],
            [(0.035015562274,0.0364495575158,2.82842712475), (0.041374733874,0.0428087237745,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000064316,
        dip=47.0261618129,
        rake=0.0,
        hypocenter=(0.0420321864339, 0.0472292965327, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0358004281725,0.0458691388878,2.12132034356), (0.0426896388684,0.0516498694283,2.12132034356), ],
            [(0.041374733874,0.0428087237745,2.82842712475), (0.0482639448209,0.0485894540403,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000120242,
        dip=47.026162903,
        rake=0.0,
        hypocenter=(0.0489213978554, 0.0530100265757, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0426896388684,0.0516498694283,2.12132034356), (0.0495788508029,0.0574305992247,2.12132034356), ],
            [(0.0482639448209,0.0485894540403,2.82842712475), (0.0551531569295,0.0543701836096,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000184478,
        dip=47.0261647284,
        rake=0.0,
        hypocenter=(0.0558106105588, 0.0587907558525, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0495788508029,0.0574305992247,2.12132034356), (0.0564680641372,0.0632113281874,2.12132034356), ],
            [(0.0551531569295,0.0543701836096,2.82842712475), (0.0620423703656,0.0601509123882,2.82842712475), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=5.1006368147e-06,
        dip=48.7798784332,
        rake=0.0,
        hypocenter=(0.0250843673815, -0.00927525928318, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972149884,-0.0122416625182,2.82842712475), (0.0222972158039,-0.00324844071788,2.82842712475), ],
            [(0.0278715189741,-0.0153020779305,3.53553390593), (0.0278715197598,-0.00630885596616,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=5.14076503349e-06,
        dip=48.7798781988,
        rake=0.0,
        hypocenter=(0.0250843681853, -0.00028203737738, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972158039,-0.00324844071788,2.82842712475), (0.022297216625,0.00574478112417,2.82842712475), ],
            [(0.0278715197598,-0.00630885596616,3.53553390593), (0.0278715205525,0.00268436605034,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=5.11520141427e-06,
        dip=48.7798786806,
        rake=0.0,
        hypocenter=(0.0250843689902, 0.00871118452132, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.022297216625,0.00574478112417,2.82842712475), (0.0222972174426,0.0147380029119,2.82842712475), ],
            [(0.0278715205525,0.00268436605034,3.53553390593), (0.0278715213407,0.0116775879989,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.26495996413e-05,
        dip=48.7798699187,
        rake=0.0,
        hypocenter=(0.025084371954, 0.0177044055349, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972174426,0.0147380029119,2.82842712475), (0.0222972221017,0.0237312231803,2.82842712475), ],
            [(0.0278715213407,0.0116775879989,3.53553390593), (0.027871526931,0.0206708080484,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000072391,
        dip=46.1824083666,
        rake=0.0,
        hypocenter=(0.0282639594241, 0.0253805992541, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972221017,0.0237312231803,2.82842712475), (0.0286563918176,0.0300903905314,2.82842712475), ],
            [(0.027871526931,0.0206708080484,3.53553390593), (0.0342306968459,0.0270299752562,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000100294,
        dip=46.1824089024,
        rake=0.0,
        hypocenter=(0.0346231295902, 0.0317397663595, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0286563918176,0.0300903905314,2.82842712475), (0.035015562274,0.0364495575158,2.82842712475), ],
            [(0.0342306968459,0.0270299752562,3.53553390593), (0.0405898674234,0.0333891421347,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000161993,
        dip=46.1824103192,
        rake=0.0,
        hypocenter=(0.0409823006755, 0.0380989329203, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.035015562274,0.0364495575158,2.82842712475), (0.041374733874,0.0428087237745,2.82842712475), ],
            [(0.0405898674234,0.0333891421347,3.53553390593), (0.0469490391306,0.039748308256,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000101967,
        dip=47.0293346976,
        rake=0.0,
        hypocenter=(0.0476064920235, 0.0441688810658, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.041374733874,0.0428087237745,2.82842712475), (0.0482639448209,0.0485894540403,2.82842712475), ],
            [(0.0469490391306,0.039748308256,3.53553390593), (0.0538382502684,0.0455290381924,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000153942,
        dip=47.0293356022,
        rake=0.0,
        hypocenter=(0.0544957036275, 0.0499496108305, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0482639448209,0.0485894540403,2.82842712475), (0.0551531569295,0.0543701836096,2.82842712475), ],
            [(0.0538382502684,0.0455290381924,3.53553390593), (0.060727462491,0.0513097674798,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.000021464,
        dip=47.02933725,
        rake=0.0,
        hypocenter=(0.0613849164388, 0.0557303398743, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0551531569295,0.0543701836096,2.82842712475), (0.0620423703656,0.0601509123882,2.82842712475), ],
            [(0.060727462491,0.0513097674798,3.53553390593), (0.0676166759689,0.0570904960196,3.53553390593), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.61304083512e-06,
        dip=48.7830319934,
        rake=0.0,
        hypocenter=(0.0306586714085, -0.0123356745623, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715189741,-0.0153020779305,3.53553390593), (0.0278715197598,-0.00630885596616,3.53553390593), ],
            [(0.0334458231188,-0.0183624931979,4.24264068712), (0.0334458237812,-0.00936927115472,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.66208671855e-06,
        dip=48.7830319946,
        rake=0.0,
        hypocenter=(0.0306586721364, -0.00334245252986, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715197598,-0.00630885596616,3.53553390593), (0.0278715205525,0.00268436605034,3.53553390593), ],
            [(0.0334458237812,-0.00936927115472,4.24264068712), (0.033445824452,-0.00037604904889,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.63084252691e-06,
        dip=48.783032716,
        rake=0.0,
        hypocenter=(0.0306586728657, 0.00565076949394, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715205525,0.00268436605034,3.53553390593), (0.0278715213407,0.0116775879989,3.53553390593), ],
            [(0.033445824452,-0.00037604904889,4.24264068712), (0.0334458251175,0.0086171729754,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.82839965114e-05,
        dip=48.7830225274,
        rake=0.0,
        hypocenter=(0.0306586762337, 0.0146439904359, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715213407,0.0116775879989,3.53553390593), (0.027871526931,0.0206708080484,3.53553390593), ],
            [(0.0334458251175,0.0086171729754,4.24264068712), (0.0334458315455,0.0176103927208,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000095746,
        dip=46.1855869887,
        rake=0.0,
        hypocenter=(0.0338382642289, 0.0223201839377, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.027871526931,0.0206708080484,3.53553390593), (0.0342306968459,0.0270299752562,3.53553390593), ],
            [(0.0334458315455,0.0176103927208,4.24264068712), (0.0398050015933,0.0239695597252,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000120156,
        dip=46.1855873838,
        rake=0.0,
        hypocenter=(0.0401974345222, 0.0286793508885, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0342306968459,0.0270299752562,3.53553390593), (0.0405898674234,0.0333891421347,3.53553390593), ],
            [(0.0398050015933,0.0239695597252,4.24264068712), (0.0461641722259,0.0303287264376,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000184341,
        dip=46.1855887469,
        rake=0.0,
        hypocenter=(0.0465566056885, 0.0350385172974, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0405898674234,0.0333891421347,3.53553390593), (0.0469490391306,0.039748308256,3.53553390593), ],
            [(0.0461641722259,0.0303287264376,4.24264068712), (0.052523343974,0.0366878923613,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000139023,
        dip=47.0325079559,
        rake=0.0,
        hypocenter=(0.0531807971539, 0.0411084651808, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0469490391306,0.039748308256,3.53553390593), (0.0538382502684,0.0455290381924,3.53553390593), ],
            [(0.052523343974,0.0366878923613,4.24264068712), (0.0594125552428,0.0424686219135,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000187047,
        dip=47.032508675,
        rake=0.0,
        hypocenter=(0.0600700088803, 0.0468891946125, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0538382502684,0.0455290381924,3.53553390593), (0.060727462491,0.0513097674798,3.53553390593), ],
            [(0.0594125552428,0.0424686219135,4.24264068712), (0.0663017675192,0.0482493508643,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000244207,
        dip=47.0325101453,
        rake=0.0,
        hypocenter=(0.0669592217395, 0.0526699233685, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.060727462491,0.0513097674798,3.53553390593), (0.0676166759689,0.0570904960196,3.53553390593), ],
            [(0.0663017675192,0.0482493508643,4.24264068712), (0.0731909809788,0.0540300791106,4.24264068712), ],
        ]
    ),
]


TEST2_EDGES = [
    [(0.0, 0.0, 0.0), (0.0, 0.0359728811758, 0.0), (0.0190775080917, 0.0550503815181, 0.0), (0.03974514139, 0.0723925718855, 0.0)],
    [(0.016722911311, -0.00918124666527, 2.12132034356), (0.0167229134853, 0.0267916339998, 2.12132034356), (0.0358004238799, 0.0458691355964, 2.12132034356), (0.0564680614692, 0.0632113266682, 2.12132034356)],
    [(0.0334458231229, -0.0183624932002, 4.24264068712), (0.0334458257892, 0.0176103869541, 4.24264068712), (0.0525233391196, 0.0366878882799, 4.24264068712), (0.0731909809864, 0.0540300791054, 4.24264068712)],
]
TEST2_MFD = TruncatedGRMFD(a_val=0.5, b_val=1.0, min_mag=3.0, max_mag=4.0, bin_width=1.0)
TEST2_MESH_SPACING = 1.0
TEST2_RUPTURE_ASPECT_RATIO = 1.0
TEST2_RUPTURES = [
    dict(
        mag=3.5,
        strike=8.99338038438e-07,
        dip=48.7672679753,
        rake=0.0,
        hypocenter=(0.00278715193464, 0.00296640245257, 0.353553390859),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.0,0.0), (0.0,0.00899322029302,0.0), ],
            [(0.00557430372813,-0.00306041559383,0.707106781187), (0.00557430401045,0.00593280511107,0.707106782249), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=8.91934572083e-07,
        dip=48.7672671682,
        rake=0.0,
        hypocenter=(0.00278715207522, 0.0119596229541, 0.35355339139),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.00899322029302,0.0), (0.0,0.017986440586,0.0), ],
            [(0.00557430401045,0.00593280511107,0.707106782249), (0.00557430429045,0.0149260258262,0.707106783311), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=8.96502455335e-07,
        dip=48.7672670312,
        rake=0.0,
        hypocenter=(0.00278715221558, 0.0209528434476, 0.353553391655),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.017986440586,0.0), (0.0,0.026979660879,0.0), ],
            [(0.00557430429045,0.0149260258262,0.707106783311), (0.00557430457188,0.0239192464989,0.707106783311), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.13461482993e-06,
        dip=48.7672639923,
        rake=0.0,
        hypocenter=(0.00278715261043, 0.0299460638412, 0.353553390593),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.026979660879,0.0), (0.0,0.035972881172,0.0), ],
            [(0.00557430457188,0.0239192464989,0.707106783311), (0.00557430586983,0.0329124668146,0.707106779062), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=44.9999967067,
        dip=46.1696970843,
        rake=0.0,
        hypocenter=(0.00596673715634, 0.0376222576669, 0.353553391124),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0,0.035972881172,0.0), (0.00635916825871,0.0423320484941,0.0), ],
            [(0.00557430586983,0.0329124668146,0.707106779062), (0.0119334744968,0.0392716341866,0.707106785435), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000008959,
        dip=46.1696986095,
        rake=0.0,
        hypocenter=(0.0123259061057, 0.0439814247649, 0.353553394488),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00635916825871,0.0423320484941,0.0), (0.0127183375697,0.0486912153003,0.0), ],
            [(0.0119334744968,0.0392716341866,0.707106785435), (0.0182926440974,0.0456308010787,0.707106792516), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000060751,
        dip=46.1697006702,
        rake=0.0,
        hypocenter=(0.0186850761573, 0.0503405913054, 0.353553397851),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0127183375697,0.0486912153003,0.0), (0.0190775080803,0.0550503815067,0.0), ],
            [(0.0182926440974,0.0456308010787,0.707106792516), (0.0246518148816,0.0519899673359,0.707106798889), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=49.9999947718,
        dip=47.0166458474,
        rake=0.0,
        hypocenter=(0.0253092663605, 0.0564105398963, 0.353553400418),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0190775080803,0.0550503815067,0.0), (0.0259667176627,0.060831112543,0.0), ],
            [(0.0246518148816,0.0519899673359,0.707106798889), (0.0315410248175,0.0577706981995,0.707106802784), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000015576,
        dip=47.016647664,
        rake=0.0,
        hypocenter=(0.0321984768361, 0.0621912704148, 0.353553402454),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0259667176627,0.060831112543,0.0), (0.0328559287146,0.0666118426928,0.0), ],
            [(0.0315410248175,0.0577706981995,0.707106802784), (0.0384302361496,0.0635514282239,0.707106807032), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.000009052,
        dip=47.0166501828,
        rake=0.0,
        hypocenter=(0.0390876888189, 0.0679720000307, 0.35355340449),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0328559287146,0.0666118426928,0.0), (0.0397451413828,0.0723925718794,0.0), ],
            [(0.0384302361496,0.0635514282239,0.707106807032), (0.0453194490285,0.0693321573268,0.707106810927), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.40026631164e-06,
        dip=48.7704201164,
        rake=0.0,
        hypocenter=(0.00836145579647, -9.40129421222e-05, 1.06066017258),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430372813,-0.00306041559383,0.707106781187), (0.00557430401045,0.00593280511107,0.707106782249), ],
            [(0.0111486074881,-0.00612083115869,1.41421356237), (0.0111486079592,0.00287238987296,1.4142135645), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.37805596383e-06,
        dip=48.7704195515,
        rake=0.0,
        hypocenter=(0.00836145617148, 0.00889920793384, 1.06066017417),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430401045,0.00593280511107,0.707106782249), (0.00557430429045,0.0149260258262,0.707106783311), ],
            [(0.0111486079592,0.00287238987296,1.4142135645), (0.0111486084258,0.0118656109251,1.41421356662), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.39175972726e-06,
        dip=48.7704196355,
        rake=0.0,
        hypocenter=(0.00836145654581, 0.0178924287857, 1.06066017497),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430429045,0.0149260258262,0.707106783311), (0.00557430457188,0.0239192464989,0.707106783311), ],
            [(0.0111486084258,0.0118656109251,1.41421356662), (0.0111486088952,0.0208588318924,1.41421356662), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.21060969223e-05,
        dip=48.7704150144,
        rake=0.0,
        hypocenter=(0.00836145768362, 0.0268856493379, 1.06066017178),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430457188,0.0239192464989,0.707106783311), (0.00557430586983,0.0329124668146,0.707106779062), ],
            [(0.0111486088952,0.0208588318924,1.41421356662), (0.0111486113976,0.0298520521457,1.41421355812), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=44.9999992614,
        dip=46.1728741607,
        rake=0.0,
        hypocenter=(0.0115410430227, 0.0345618431636, 1.06066017337),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.00557430586983,0.0329124668146,0.707106779062), (0.0119334744968,0.0392716341866,0.707106785435), ],
            [(0.0111486113976,0.0298520521457,1.41421355812), (0.0175077803268,0.0362112195074,1.41421357087), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000031039,
        dip=46.1728755399,
        rake=0.0,
        hypocenter=(0.017900212268, 0.0409210102995, 1.06066018346),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0119334744968,0.0392716341866,0.707106785435), (0.0182926440974,0.0456308010787,0.707106792516), ],
            [(0.0175077803268,0.0362112195074,1.41421357087), (0.0238669501508,0.0425703864252,1.41421358503), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000085391,
        dip=46.1728775536,
        rake=0.0,
        hypocenter=(0.0242593825681, 0.0472801768782, 1.06066019355),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0182926440974,0.0456308010787,0.707106792516), (0.0246518148816,0.0519899673359,0.707106798889), ],
            [(0.0238669501508,0.0425703864252,1.41421358503), (0.0302261211425,0.0489295526729,1.41421359778), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=49.9999987004,
        dip=47.0198175683,
        rake=0.0,
        hypocenter=(0.0308835730534, 0.0533501253794, 1.06066020125),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0246518148816,0.0519899673359,0.707106798889), (0.0315410248175,0.0577706981995,0.707106802784), ],
            [(0.0302261211425,0.0489295526729,1.41421359778), (0.0371153313719,0.0547102833091,1.41421360557), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000051064,
        dip=47.0198191987,
        rake=0.0,
        hypocenter=(0.0377727838158, 0.0591308557215, 1.06066020736),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0315410248175,0.0577706981995,0.707106802784), (0.0384302361496,0.0635514282239,0.707106807032), ],
            [(0.0371153313719,0.0547102833091,1.41421360557), (0.0440045429241,0.0604910131535,1.41421361406), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000122659,
        dip=47.0198215473,
        rake=0.0,
        hypocenter=(0.0446619960139, 0.0649115852055, 1.06066021347),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0384302361496,0.0635514282239,0.707106807032), (0.0453194490285,0.0693321573268,0.707106810927), ],
            [(0.0440045429241,0.0604910131535,1.41421361406), (0.0508937559536,0.0662717421179,1.41421362185), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.31250455118e-06,
        dip=48.7735726385,
        rake=0.0,
        hypocenter=(0.0139357596595, -0.00315442833604, 1.76776695429),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486074881,-0.00612083115869,1.41421356237), (0.0111486079592,0.00287238987296,1.4142135645), ],
            [(0.016722911311,-0.00918124666527,2.12132034356), (0.0167229118797,-0.000188025393179,2.12132034675), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.29769766989e-06,
        dip=48.773572281,
        rake=0.0,
        hypocenter=(0.0139357601783, 0.0058387928277, 1.76776695695),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486079592,0.00287238987296,1.4142135645), (0.0111486084258,0.0118656109251,1.41421356662), ],
            [(0.0167229118797,-0.000188025393179,2.12132034675), (0.0167229124484,0.00880519590589,2.12132034993), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.22681455483e-06,
        dip=48.7735726402,
        rake=0.0,
        hypocenter=(0.0139357606903, 0.0148320139543, 1.76776695828),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486084258,0.0118656109251,1.41421356662), (0.0111486088952,0.0208588318924,1.41421356662), ],
            [(0.0167229124484,0.00880519590589,2.12132034993), (0.016722912992,0.0177984170938,2.12132034993), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=1.95129301574e-05,
        dip=48.773566438,
        rake=0.0,
        hypocenter=(0.013935762475, 0.0238252345815, 1.76776695297),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486088952,0.0208588318924,1.41421356662), (0.0111486113976,0.0298520521457,1.41421355812), ],
            [(0.016722912992,0.0177984170938,2.12132034993), (0.0167229166151,0.0267916371942,2.12132033719), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000016525,
        dip=46.1760516356,
        rake=0.0,
        hypocenter=(0.017115348526, 0.0315014283354, 1.76776695562),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0111486113976,0.0298520521457,1.41421355812), (0.0175077803268,0.0362112195074,1.41421357087), ],
            [(0.0167229166151,0.0267916371942,2.12132033719), (0.0230820857645,0.0331508044942,2.12132035631), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000052385,
        dip=46.1760528968,
        rake=0.0,
        hypocenter=(0.0234745179995, 0.0378605954497, 1.76776697244),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0175077803268,0.0362112195074,1.41421357087), (0.0238669501508,0.0425703864252,1.41421358503), ],
            [(0.0230820857645,0.0331508044942,2.12132035631), (0.029441255756,0.0395099713719,2.12132037755), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000109192,
        dip=46.1760548184,
        rake=0.0,
        hypocenter=(0.0298336884864, 0.044219762004, 1.76776698926),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0238669501508,0.0425703864252,1.41421358503), (0.0302261211425,0.0489295526729,1.41421359778), ],
            [(0.029441255756,0.0395099713719,2.12132037755), (0.0358004268961,0.0458691375461,2.12132039667), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000025543,
        dip=47.0229896653,
        rake=0.0,
        hypocenter=(0.0364578791913, 0.0502897103577, 1.76776700209),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0302261211425,0.0489295526729,1.41421359778), (0.0371153313719,0.0547102833091,1.41421360557), ],
            [(0.0358004268961,0.0458691375461,2.12132039667), (0.0426896373544,0.0516498679027,2.12132040835), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000086221,
        dip=47.022991109,
        rake=0.0,
        hypocenter=(0.0433470901812, 0.0560704404683, 1.76776701227),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0371153313719,0.0547102833091,1.41421360557), (0.0440045429241,0.0604910131535,1.41421361406), ],
            [(0.0426896373544,0.0516498679027,2.12132040835), (0.0495788490743,0.057430597508,2.1213204211), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000153687,
        dip=47.0229932914,
        rake=0.0,
        hypocenter=(0.0502363025328, 0.0618511697667, 1.76776702245),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0440045429241,0.0604910131535,1.41421361406), (0.0508937559536,0.0662717421179,1.41421362185), ],
            [(0.0495788490743,0.057430597508,2.1213204211), (0.0564680621792,0.0632113262876,2.12132043278), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.022704807e-06,
        dip=48.7767256792,
        rake=0.0,
        hypocenter=(0.0195100635265, -0.00621484376243, 2.47487373548),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.016722911311,-0.00918124666527,2.12132034356), (0.0167229118797,-0.000188025393179,2.12132034675), ],
            [(0.0222972151107,-0.0122416623026,2.82842712475), (0.0222972158048,-0.0032484406887,2.82842712687), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.02124358382e-06,
        dip=48.7767248655,
        rake=0.0,
        hypocenter=(0.0195100641578, 0.00277837769746, 2.47487373814),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229118797,-0.000188025393179,2.12132034675), (0.0167229124484,0.00880519590589,2.12132034993), ],
            [(0.0222972158048,-0.0032484406887,2.82842712687), (0.0222972164985,0.00574478096581,2.828427129), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.88652088575e-06,
        dip=48.7767247536,
        rake=0.0,
        hypocenter=(0.0195100647784, 0.0117715991209, 2.47487373946),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229124484,0.00880519590589,2.12132034993), (0.016722912992,0.0177984170938,2.12132034993), ],
            [(0.0222972164985,0.00574478096581,2.828427129), (0.022297217175,0.0147380025183,2.828427129), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=2.63598384415e-05,
        dip=48.7767168852,
        rake=0.0,
        hypocenter=(0.0195100671522, 0.0207648198479, 2.47487373415),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.016722912992,0.0177984170938,2.12132034993), (0.0167229166151,0.0267916371942,2.12132033719), ],
            [(0.022297217175,0.0147380025183,2.828427129), (0.0222972218268,0.0237312225854,2.8284271205), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000041598,
        dip=46.1792303002,
        rake=0.0,
        hypocenter=(0.0226896538865, 0.0284410135305, 2.47487373681),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0167229166151,0.0267916371942,2.12132033719), (0.0230820857645,0.0331508044942,2.12132035631), ],
            [(0.0222972218268,0.0237312225854,2.8284271205), (0.0286563913395,0.0300903898483,2.82842713324), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000074957,
        dip=46.1792305406,
        rake=0.0,
        hypocenter=(0.0290488236199, 0.0348001806101, 2.47487375363),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0230820857645,0.0331508044942,2.12132035631), (0.029441255756,0.0395099713719,2.12132037755), ],
            [(0.0286563913395,0.0300903898483,2.82842713324), (0.0350155616196,0.0364495567261,2.82842714741), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000133756,
        dip=46.1792315943,
        rake=0.0,
        hypocenter=(0.0354079943242, 0.0411593471308, 2.47487377044),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.029441255756,0.0395099713719,2.12132037755), (0.0358004268961,0.0458691375461,2.12132039667), ],
            [(0.0350155616196,0.0364495567261,2.82842714741), (0.0413747330253,0.0428087228789,2.82842716015), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000063447,
        dip=47.0261612319,
        rake=0.0,
        hypocenter=(0.0420321852706, 0.0472292953384, 2.47487378328),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0358004268961,0.0458691375461,2.12132039667), (0.0426896373544,0.0516498679027,2.12132040835), ],
            [(0.0413747330253,0.0428087228789,2.82842716015), (0.0482639438067,0.048589453026,2.82842716794), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000120968,
        dip=47.0261621738,
        rake=0.0,
        hypocenter=(0.0489213965039, 0.053010025225, 2.47487379346),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0426896373544,0.0516498679027,2.12132040835), (0.0495788490743,0.057430597508,2.1213204211), ],
            [(0.0482639438067,0.048589453026,2.82842716794), (0.0551531557803,0.0543701824633,2.82842717644), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000184116,
        dip=47.0261638016,
        rake=0.0,
        hypocenter=(0.0558106090245, 0.0587907543446, 2.47487380364),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0495788490743,0.057430597508,2.1213204211), (0.0564680621792,0.0632113262876,2.12132043278), ],
            [(0.0551531557803,0.0543701824633,2.82842717644), (0.0620423690641,0.0601509111195,2.82842718423), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.52406169139e-06,
        dip=48.7798787326,
        rake=0.0,
        hypocenter=(0.0250843674292, -0.00927525919218, 3.18198051614),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972151107,-0.0122416623026,2.82842712475), (0.0222972158048,-0.0032484406887,2.82842712687), ],
            [(0.0278715190376,-0.015302077824,3.53553390593), (0.0278715197637,-0.00630885595347,3.535533907), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.51967807325e-06,
        dip=48.7798781577,
        rake=0.0,
        hypocenter=(0.025084368139, -0.000282037426248, 3.18198051773),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972158048,-0.0032484406887,2.82842712687), (0.0222972164985,0.00574478096581,2.828427129), ],
            [(0.0278715197637,-0.00630885595347,3.535533907), (0.0278715204889,0.00268436597136,3.53553390806), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.43558598904e-06,
        dip=48.7798782847,
        rake=0.0,
        hypocenter=(0.0250843688418, 0.00871118431468, 3.18198051853),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972164985,0.00574478096581,2.828427129), (0.022297217175,0.0147380025183,2.828427129), ],
            [(0.0278715204889,0.00268436597136,3.53553390806), (0.0278715212048,0.0116775878033,3.53553390806), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.26430820483e-05,
        dip=48.7798691306,
        rake=0.0,
        hypocenter=(0.0250843717517, 0.0177044051635, 3.18198051534),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.022297217175,0.0147380025183,2.828427129), (0.0222972218268,0.0237312225854,2.8284271205), ],
            [(0.0278715212048,0.0116775878033,3.53553390806), (0.0278715268004,0.0206708077472,3.53553390381), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000068085,
        dip=46.1824086154,
        rake=0.0,
        hypocenter=(0.0282639591421, 0.0253805987746, 3.18198051693),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0222972218268,0.0237312225854,2.8284271205), (0.0286563913395,0.0300903898483,2.82842713324), ],
            [(0.0278715268004,0.0206708077472,3.53553390381), (0.0342306966017,0.0270299749175,3.53553391018), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000098405,
        dip=46.182408749,
        rake=0.0,
        hypocenter=(0.0346231291663, 0.0317397658068, 3.18198052702),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0286563913395,0.0300903898483,2.82842713324), (0.0350155616196,0.0364495567261,2.82842714741), ],
            [(0.0342306966017,0.0270299749175,3.53553391018), (0.0405898671044,0.0333891417354,3.53553391726), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000158837,
        dip=46.182409731,
        rake=0.0,
        hypocenter=(0.0409823001147, 0.0380989322867, 3.18198053711),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0350155616196,0.0364495567261,2.82842714741), (0.0413747330253,0.0428087228789,2.82842716015), ],
            [(0.0405898671044,0.0333891417354,3.53553391726), (0.0469490387095,0.0397483078064,3.53553392364), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.000010087,
        dip=47.0293341524,
        rake=0.0,
        hypocenter=(0.0476064913239, 0.0441688803501, 3.18198054481),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0413747330253,0.0428087228789,2.82842716015), (0.0482639438067,0.048589453026,2.82842716794), ],
            [(0.0469490387095,0.0397483078064,3.53553392364), (0.053838249754,0.0455290376892,3.53553392753), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000155042,
        dip=47.0293349241,
        rake=0.0,
        hypocenter=(0.0544957028156, 0.0499496100206, 3.18198055092),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0482639438067,0.048589453026,2.82842716794), (0.0551531557803,0.0543701824633,2.82842717644), ],
            [(0.053838249754,0.0455290376892,3.53553392753), (0.0607274619213,0.0513097669039,3.53553393178), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000214463,
        dip=47.029336367,
        rake=0.0,
        hypocenter=(0.0613849155224, 0.0557303389672, 3.18198055703),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0551531557803,0.0543701824633,2.82842717644), (0.0620423690641,0.0601509111195,2.82842718423), ],
            [(0.0607274619213,0.0513097669039,3.53553393178), (0.0676166753238,0.0570904953821,3.53553393567), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.4299231219e-06,
        dip=48.7830321711,
        rake=0.0,
        hypocenter=(0.0306586714283, -0.0123356745341, 3.88908729679),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715190376,-0.015302077824,3.53553390593), (0.0278715197637,-0.00630885595347,3.535533907), ],
            [(0.0334458231236,-0.0183624932006,4.24264068712), (0.0334458237881,-0.00936927115852,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.42261726056e-06,
        dip=48.7830318351,
        rake=0.0,
        hypocenter=(0.030658672123, -0.00334245254728, 3.88908729732),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715197637,-0.00630885595347,3.535533907), (0.0278715204889,0.00268436597136,3.53553390806), ],
            [(0.0334458237881,-0.00936927115852,4.24264068712), (0.0334458244513,-0.000376049048498,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=4.38915594265e-06,
        dip=48.7830322009,
        rake=0.0,
        hypocenter=(0.0306586728146, 0.00565076942597, 3.88908729759),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715204889,0.00268436597136,3.53553390806), (0.0278715212048,0.0116775878033,3.53553390806), ],
            [(0.0334458244513,-0.000376049048498,4.24264068712), (0.0334458251132,0.00861717297775,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=3.83579374088e-05,
        dip=48.7830217754,
        rake=0.0,
        hypocenter=(0.0306586761694, 0.0146439903104, 3.88908729653),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715212048,0.0116775878033,3.53553390806), (0.0278715268004,0.0206708077472,3.53553390381), ],
            [(0.0334458251132,0.00861717297775,4.24264068712), (0.0334458315591,0.0176103927134,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000093193,
        dip=46.1855873142,
        rake=0.0,
        hypocenter=(0.033838264136, 0.0223201837773, 3.88908729706),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0278715268004,0.0206708077472,3.53553390381), (0.0342306966017,0.0270299749175,3.53553391018), ],
            [(0.0334458315591,0.0176103927134,4.24264068712), (0.0398050015829,0.023969559731,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.000012077,
        dip=46.1855873236,
        rake=0.0,
        hypocenter=(0.0401974343828, 0.0286793507031, 3.88908730042),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0342306966017,0.0270299749175,3.53553391018), (0.0405898671044,0.0333891417354,3.53553391726), ],
            [(0.0398050015829,0.023969559731,4.24264068712), (0.0461641722422,0.0303287264286,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=45.0000182836,
        dip=46.1855882335,
        rake=0.0,
        hypocenter=(0.0465566055092, 0.035038517082, 3.88908730378),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0405898671044,0.0333891417354,3.53553391726), (0.0469490387095,0.0397483078064,3.53553392364), ],
            [(0.0461641722422,0.0303287264286,4.24264068712), (0.0525233439806,0.0366878923577,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000137698,
        dip=47.0325074465,
        rake=0.0,
        hypocenter=(0.0531807969181, 0.0411084649437, 3.88908730635),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0469490387095,0.0397483078064,3.53553392364), (0.053838249754,0.0455290376892,3.53553392753), ],
            [(0.0525233439806,0.0366878923577,4.24264068712), (0.0594125552281,0.0424686219216,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000188521,
        dip=47.032508048,
        rake=0.0,
        hypocenter=(0.0600700086081, 0.0468891943434, 3.88908730839),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.053838249754,0.0455290376892,3.53553392753), (0.0607274619213,0.0513097669039,3.53553393178), ],
            [(0.0594125552281,0.0424686219216,4.24264068712), (0.066301767529,0.0482493508589,4.24264068712), ],
        ]
    ),
    dict(
        mag=3.5,
        strike=50.0000244216,
        dip=47.032509306,
        rake=0.0,
        hypocenter=(0.0669592214411, 0.0526699230623, 3.88908731042),
        occurrence_rate=4.74341649025e-05,
        surface=[
            [(0.0607274619213,0.0513097669039,3.53553393178), (0.0676166753238,0.0570904953821,3.53553393567), ],
            [(0.066301767529,0.0482493508589,4.24264068712), (0.0731909809902,0.0540300791043,4.24264068712), ],
        ]
    ),
]


TEST3_EDGES = [
    [(0.0, 0.0, 0.0), (0.0, 0.0359728811758, 0.0), (0.0190775080917, 0.0550503815181, 0.0), (0.03974514139, 0.0723925718855, 0.0)],
    [(0.016722911311, -0.00918124666527, 2.12132034356), (0.0167229134853, 0.0267916339998, 2.12132034356), (0.0358004238799, 0.0458691355964, 2.12132034356), (0.0564680614692, 0.0632113266682, 2.12132034356)],
    [(0.0334458231229, -0.0183624932002, 4.24264068712), (0.0334458257892, 0.0176103869541, 4.24264068712), (0.0525233391196, 0.0366878882799, 4.24264068712), (0.0731909809864, 0.0540300791054, 4.24264068712)],
]
TEST3_MFD = TruncatedGRMFD(a_val=0.5, b_val=1.0, min_mag=6.0, max_mag=7.0, bin_width=1.0)
TEST3_MESH_SPACING = 1.0
TEST3_RUPTURE_ASPECT_RATIO = 1.0
TEST3_RUPTURES = [
    dict(
        mag=6.5,
        strike=28.7677663512,
        dip=47.4509172004,
        rake=0.0,
        hypocenter=(0.0230820857645, 0.0331508044942, 2.12132035631),
        occurrence_rate=2.84604989415e-06,
        surface=[
            [(0.0,0.0,0.0), (0.0,0.00899322029302,0.0), (0.0,0.017986440586,0.0), (0.0,0.026979660879,0.0), (0.0,0.035972881172,0.0), (0.00635916825871,0.0423320484941,0.0), (0.0127183375697,0.0486912153003,0.0), (0.0190775080803,0.0550503815067,0.0), (0.0259667176627,0.060831112543,0.0), (0.0328559287146,0.0666118426928,0.0), (0.0397451413828,0.0723925718794,0.0), ],
            [(0.00557430372813,-0.00306041559383,0.707106781187), (0.00557430401045,0.00593280511107,0.707106782249), (0.00557430429045,0.0149260258262,0.707106783311), (0.00557430457188,0.0239192464989,0.707106783311), (0.00557430586983,0.0329124668146,0.707106779062), (0.0119334744968,0.0392716341866,0.707106785435), (0.0182926440974,0.0456308010787,0.707106792516), (0.0246518148816,0.0519899673359,0.707106798889), (0.0315410248175,0.0577706981995,0.707106802784), (0.0384302361496,0.0635514282239,0.707106807032), (0.0453194490285,0.0693321573268,0.707106810927), ],
            [(0.0111486074881,-0.00612083115869,1.41421356237), (0.0111486079592,0.00287238987296,1.4142135645), (0.0111486084258,0.0118656109251,1.41421356662), (0.0111486088952,0.0208588318924,1.41421356662), (0.0111486113976,0.0298520521457,1.41421355812), (0.0175077803268,0.0362112195074,1.41421357087), (0.0238669501508,0.0425703864252,1.41421358503), (0.0302261211425,0.0489295526729,1.41421359778), (0.0371153313719,0.0547102833091,1.41421360557), (0.0440045429241,0.0604910131535,1.41421361406), (0.0508937559536,0.0662717421179,1.41421362185), ],
            [(0.016722911311,-0.00918124666527,2.12132034356), (0.0167229118797,-0.000188025393179,2.12132034675), (0.0167229124484,0.00880519590589,2.12132034993), (0.016722912992,0.0177984170938,2.12132034993), (0.0167229166151,0.0267916371942,2.12132033719), (0.0230820857645,0.0331508044942,2.12132035631), (0.029441255756,0.0395099713719,2.12132037755), (0.0358004268961,0.0458691375461,2.12132039667), (0.0426896373544,0.0516498679027,2.12132040835), (0.0495788490743,0.057430597508,2.1213204211), (0.0564680621792,0.0632113262876,2.12132043278), ],
            [(0.0222972151107,-0.0122416623026,2.82842712475), (0.0222972158048,-0.0032484406887,2.82842712687), (0.0222972164985,0.00574478096581,2.828427129), (0.022297217175,0.0147380025183,2.828427129), (0.0222972218268,0.0237312225854,2.8284271205), (0.0286563913395,0.0300903898483,2.82842713324), (0.0350155616196,0.0364495567261,2.82842714741), (0.0413747330253,0.0428087228789,2.82842716015), (0.0482639438067,0.048589453026,2.82842716794), (0.0551531557803,0.0543701824633,2.82842717644), (0.0620423690641,0.0601509111195,2.82842718423), ],
            [(0.0278715190376,-0.015302077824,3.53553390593), (0.0278715197637,-0.00630885595347,3.535533907), (0.0278715204889,0.00268436597136,3.53553390806), (0.0278715212048,0.0116775878033,3.53553390806), (0.0278715268004,0.0206708077472,3.53553390381), (0.0342306966017,0.0270299749175,3.53553391018), (0.0405898671044,0.0333891417354,3.53553391726), (0.0469490387095,0.0397483078064,3.53553392364), (0.053838249754,0.0455290376892,3.53553392753), (0.0607274619213,0.0513097669039,3.53553393178), (0.0676166753238,0.0570904953821,3.53553393567), ],
            [(0.0334458231236,-0.0183624932006,4.24264068712), (0.0334458237881,-0.00936927115852,4.24264068712), (0.0334458244513,-0.000376049048498,4.24264068712), (0.0334458251132,0.00861717297775,4.24264068712), (0.0334458315591,0.0176103927134,4.24264068712), (0.0398050015829,0.023969559731,4.24264068712), (0.0461641722422,0.0303287264286,4.24264068712), (0.0525233439806,0.0366878923577,4.24264068712), (0.0594125552281,0.0424686219216,4.24264068712), (0.066301767529,0.0482493508589,4.24264068712), (0.0731909809902,0.0540300791043,4.24264068712), ],
        ]
    ),
]


TEST4_EDGES = [
    [(0.0, 0.0, 0.0), (0.00899322029395, 5.50657733404e-19, 0.0), (0.0179864405879, 1.10131546002e-18, 0.0), (0.0269796608818, 1.65197317986e-18, 0.0)],
    [(0.0, 0.0, 1.0), (0.0179864405879, 1.10131545324e-18, 1.0), (0.0359728811758, 2.20263085222e-18, 1.0), (0.0539593217637, 3.30394619692e-18, 1.0)],
    [(0.0, 0.0, 2.0), (0.0269796608818, 1.65197314594e-18, 2.0), (0.0539593217637, 3.30394610874e-18, 2.0), (0.0809389826455, 4.95591888839e-18, 2.0)],
]
TEST4_MFD = TruncatedGRMFD(a_val=0.5, b_val=1.0, min_mag=3.95, max_mag=4.05, bin_width=0.1)
TEST4_MESH_SPACING = 2.0
TEST4_RUPTURE_ASPECT_RATIO = 1.0
TEST4_RUPTURES = [
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.00674491521945, 1.75459031793e-15, 0.5),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.0,0.0,0.0), (0.00899322029395,5.50657733404e-19,0.0), ],
            [(0.0,7.01670929853e-15,1.0), (0.0179864405838,1.10131545299e-18,1.0), ],
        ]
    ),
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.0202347456594, 1.2389798746e-18, 0.5),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.00899322029395,5.50657733404e-19,0.0), (0.0179864405879,1.10131546002e-18,0.0), ],
            [(0.0179864405838,1.10131545299e-18,1.0), (0.0359728811717,2.20263085197e-18,1.0), ],
        ]
    ),
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.0337245761111, 2.06496642279e-18, 0.500000000113),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.0179864405879,1.10131546002e-18,0.0), (0.0269796609129,1.65197318176e-18,0.0), ],
            [(0.0359728811717,2.20263085197e-18,1.0), (0.0539593217718,3.30394619742e-18,1.00000000045), ],
        ]
    ),
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.0112415253732, 3.50904297142e-15, 1.5),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.0,7.01670929853e-15,1.0), (0.0179864405838,1.10131545299e-18,1.0), ],
            [(0.0,7.01670929853e-15,2.0), (0.0269796609089,1.65197317473e-18,2.0), ],
        ]
    ),
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.033724576105, 2.06496641903e-18, 1.5),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.0179864405838,1.10131545299e-18,1.0), (0.0359728811717,2.20263085197e-18,1.0), ],
            [(0.0269796609089,1.65197317473e-18,2.0), (0.0539593217556,3.30394619643e-18,2.0), ],
        ]
    ),
    dict(
        mag=4.0,
        strike=90.0,
        dip=90.0,
        rake=0.0,
        hypocenter=(0.0562076268328, 3.44161055539e-18, 1.50000000011),
        occurrence_rate=1.21625160179e-05,
        surface=[
            [(0.0359728811717,2.20263085197e-18,1.0), (0.0539593217718,3.30394619742e-18,1.00000000045), ],
            [(0.0539593217556,3.30394619643e-18,2.0), (0.080938982632,4.95591897575e-18,2.0), ],
        ]
    ),
]
