# -*- coding: utf-8 -*-
# vim: tabstop=4 shiftwidth=4 softtabstop=4
#
# Copyright (C) 2013-2017 GEM Foundation
#
# OpenQuake is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenQuake is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with OpenQuake. If not, see <http://www.gnu.org/licenses/>.

from openquake.hazardlib.gsim.pezeshk_2011 import (PezeshkEtAl2011,
                                                   PezeshkEtAl2011NEHRPBC)
from openquake.hazardlib.tests.gsim.utils import BaseGSIMTestCase


class Pezeshk2011EtAlTestCase(BaseGSIMTestCase):
    GSIM_CLASS = PezeshkEtAl2011

    # Test data were obtained from a tool given by the authors
    # The data of the values of the mean PGA and SA are in g's.

    def test_mean(self):
        self.check('PEZE11/PZ11_MEAN.csv',
                    max_discrep_percentage=0.5)

    def test_std_total(self):
        self.check('PEZE11/PZ11_STD_TOTAL.csv',
                    max_discrep_percentage=0.5)


class Pezeshk2011NEHRPBCEtAlTestCase(BaseGSIMTestCase):
    GSIM_CLASS = PezeshkEtAl2011NEHRPBC

    # Test data generated by adjustment using Atkinson & Boore factors

    def test_mean(self):
        self.check('PEZE11/PZ11_NEHRPBC_MEAN.csv',
                    max_discrep_percentage=0.1)

    def test_std_total(self):
        self.check('PEZE11/PZ11_NEHRPBC_STD_TOTAL.csv',
                    max_discrep_percentage=0.1)
