#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Autogenerated area detector documentation
# (see ophyd.git/docs/area_detector)

docs = {
    'PixiradDoc.html': dict(
        FrameType=u'''[FrameType]
          The choices for the Pixirad are:

            "1 color low". One color image using threshold 1.
            "1 color high". One color image using threshold 2.
            "2 color". Two color image using thesholds 1 and 2.
            "4 color". Four color image using thesholds 1, 2, 3, and 4.
            "1 color DTF". One color deadtime-free image using theshold 1.
            "2 color DTF". Two color deadtime-free image using theshold 1 for color 1, and
              threshold 3 for color 2.

          Note that the dimensions of the NDArrays from the Pixirad driver depend on the value
          of FrameType.
          1 color arrays are 2-D with dimensions [MaxSizeX, MaxSizeY].
          2 color arrays are 3-D with dimensions [MaxSizeX, MaxSizeY, 2].
          4 color arrays are 3-D with dimensions[MaxSizeX, MaxSizeY, 4].''',
        TriggerMode=u'''[TriggerMode]
          The choices for the Pixirad are:

            "Internal". The timing is internal to the detector.
            "External". Each external trigger pulse starts the next image. The exposure time
              is controlled internally by the AcquireTime record.
            "Bulb". The rising edge of the external trigger signal starts the next image.
              The detector continues to acquire while the external signal is high, and then reads
              out the detector on the falling edge of the external trigger signal.

          Note that the minimum time between external trigger pulses is determined by the
          FrameType record. This is discussed in the Performance
            Measurements section below.''',
        Temperature=u'[Temperature] The setpoint for the cold temperature of the detector.',
        TemperatureActual=u'[TemperatureActual] The readback of the temperature on the cold side of the Peltier cooler.',
        NumImages=u'[NumImages] Controls the number of images to acquire.',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images. If this is greater than the acquisition time
          then the detector will wait until the period has elapsed before collection the next
          image.''',
        CoolingState=u'[CoolingState r/w bo] The state of the Peltier cooler. Choices are "Off" (0) and "On" (1).',
        Cooling_RBV=u'[Cooling_RBV r/w bi] The state of the Peltier cooler. Choices are "Off" (0) and "On" (1).',
        HotTemperature_RBV=u'[HotTemperature_RBV r/o ai] The readback of the temperature (C) on the hot side of the Peltier cooler.',
        BoxTemperature_RBV=u'[BoxTemperature_RBV r/o ai] The readback of the ambient temperature (C) in the detector box.',
        BoxHumidity_RBV=u'[BoxHumidity_RBV r/o ai] The readback of the ambient relative humidity (%) in the detector box.',
        DewPoint_RBV=u'[DewPoint_RBV r/o ai] The calculated dew point (C) based on the BoxHumidity.',
        PeltierPower_RBV=u'[PeltierPower_RBV r/o ai] The power level of the Peltier cooler (%).',
        CoolingStatus_RBV=u'''[CoolingStatus_RBV r/o mbbi]
          The status of the cooling system. Values are:
          0 - "OK"

          1 - "Dew Pt Warning" This means that the cold temperature is within 3 degree of
          the dew point.
          2 - "Dew Pt Error" This means that the cold temperature is less than or equal to
          the dew point.
          3 - "T Hot Warning" This means that the hot temperature is greater than 40 C.
          4 - "T Hot Error" This means that the hot temperature is greater than 50 C.
          5 - "T Cold Warning" This means that the cold temperature is greater than 30 C.
          6 - "T Cold Error" This means that the cold temperature is greater than 40 C.

          If the CoolingStatus_RBV is any of the Error states then the driver will automatically
          turn off the Peltier cooler.''',
        HVMode=u'''[HVMode r/w bo]
          High voltage mode. Choices are:
          0 - "Manual"

          1 - "Auto"

          In Manual mode the high voltage is turned off and on with the HVState record. In
          Auto mode if HVState is Off then the high voltage will be automatically turned on
          when an acquisition is started and automatically turn off when the acquisition is
          complete. This can improve the image quality, because the detector is subject to
          charge trapping when used with high x-ray fluxes, and periodically turning off the
          high voltage helps to clear the trapped charge.''',
        HVState=u'''[HVState r/w bo]
          High voltage state. Choices are:
          0 - "Off"

          1 - "On"

          This record turns the high voltage off and on. If HVMode is Auto then the high voltage
          will be turned on during an acquisition even if HVState is off.''',
        HVValue=u'''[HVValue r/w ao]
          The high voltage value that will be applied to the detector when HVState=On or when
          HVMode=Auto and an acquisition is in progress. The allowed range is 0 to 400 volts.''',
        HVActual_RBV=u'[HVActual_RBV r/o ai] The actual high voltage currently being applied to the detector.',
        HVCurrent_RBV=u'[HVCurrent_RBV r/o ai] The actual high voltage current.',
        Threshold1=u'''[Threshold1 r/w ao]
          Requested threshold energy in keV. There are 4 energy thresholds. The threshold
          energies are controlled by a single high-resolution register (VThMax) with values
          from 1500 to 2200, and 4 low-resoltion registers with values from 0 to 31. The driver
          attempts to set Threshold1 as closely as possible to the requested value by changing
          both VThMax and the low-resolution register. Thresholds 2-4 are then set as closely
          as possible to their requested values using only the low-resolution registers.''',
        Threshold2=u'''[Threshold2 r/w ao]
          Requested threshold energy in keV. There are 4 energy thresholds. The threshold
          energies are controlled by a single high-resolution register (VThMax) with values
          from 1500 to 2200, and 4 low-resoltion registers with values from 0 to 31. The driver
          attempts to set Threshold1 as closely as possible to the requested value by changing
          both VThMax and the low-resolution register. Thresholds 2-4 are then set as closely
          as possible to their requested values using only the low-resolution registers.''',
        Threshold3=u'''[Threshold3 r/w ao]
          Requested threshold energy in keV. There are 4 energy thresholds. The threshold
          energies are controlled by a single high-resolution register (VThMax) with values
          from 1500 to 2200, and 4 low-resoltion registers with values from 0 to 31. The driver
          attempts to set Threshold1 as closely as possible to the requested value by changing
          both VThMax and the low-resolution register. Thresholds 2-4 are then set as closely
          as possible to their requested values using only the low-resolution registers.''',
        Threshold4=u'''[Threshold4 r/w ao]
          Requested threshold energy in keV. There are 4 energy thresholds. The threshold
          energies are controlled by a single high-resolution register (VThMax) with values
          from 1500 to 2200, and 4 low-resoltion registers with values from 0 to 31. The driver
          attempts to set Threshold1 as closely as possible to the requested value by changing
          both VThMax and the low-resolution register. Thresholds 2-4 are then set as closely
          as possible to their requested values using only the low-resolution registers.''',
        ThresholdActual1_RBV=u'''[ThresholdActual1_RBV r/o ai]
          Actual threshold energy in keV. This will be as close as possible to the requested
          value, subject to the constraints and algorithm explained above.''',
        ThresholdActual2_RBV=u'''[ThresholdActual2_RBV r/o ai]
          Actual threshold energy in keV. This will be as close as possible to the requested
          value, subject to the constraints and algorithm explained above.''',
        ThresholdActual3_RBV=u'''[ThresholdActual3_RBV r/o ai]
          Actual threshold energy in keV. This will be as close as possible to the requested
          value, subject to the constraints and algorithm explained above.''',
        ThresholdActual4_RBV=u'''[ThresholdActual4_RBV r/o ai]
          Actual threshold energy in keV. This will be as close as possible to the requested
          value, subject to the constraints and algorithm explained above.''',
        SyncInPolarity=u'''[SyncInPolarity r/w bo]
          Polarity of the Sync In signal. Choices are:

          0 - "Pos."

          1 - "Neg."''',
        SyncOutPolarity=u'''[SyncOutPolarity r/w bo]
          Polarity of the Sync Out signal. Choices are:

          0 - "Pos."

          1 - "Neg."''',
        SyncOutFunction=u'''[SyncOutFunction r/w mbbo]
          Function of the Sync Out signal. Choices are:

          0 - "Shutter" The Sync Out signal is high while the detector is collecting.
          1 - "Read done" The Sync Out signal outputs a pulse when readout is complete.
          2 - "Read" The Sync Out signal is high while the detector is reading out.''',
        ColorsCollected_RBV=u'[ColorsCollected_RBV r/o longin] The number of colors collected so far for the current image.',
        UDPBuffersRead_RBV=u'''[UDPBuffersRead_RBV r/o longin]
          The number of UDP buffers (images) read by the UDP listener thread for the current
          acquisition.''',
        UDPBuffersMax_RBV=u'''[UDPBuffersMax_RBV r/o longin]
          The maximum number of UDP buffers (images) for UDP listener thread. This is set
          at startup.''',
        UDPBuffersFree_RBV=u'[UDPBuffersFree_RBV r/o longin] The number of free UDP buffers (images).',
        UDPSpeed_RBV=u'[UDPSpeed_RBV r/o ai] The speed with which the last UDP buffer was received (MB/s).',
        AutoCalibrate=u'''[AutoCalibrate r/w bo]
          Sends a command to the detector to perform an autocalibration. The detector makes
          adjustments to achieve uniform pixel response. This operation must be performed
          at least once after the detector is power-cycled, and whenever necessary as the
          chip temperature and/or supply voltages may drift with time and environmental conditions.
          If autocalibration has not been performed then there will be many "hot" (non-zero)
          pixels in the image with no x-rays. When an autocalibration is performed the detector
          sends 2 images, one collected before the calibration and one after the calibration.
          These images always have a range of 0-31 counts and show the correction applied
          to each pixel.''',
        SystemReset=u'''[SystemReset r/w bo]
          Writing 1 to this record sends a command to reset detector to its initial state.
          This causes the sockets to disconnect, and it takes about 30 seconds for the system
          to recover. Once it recovers the driver then sends commands to set all of the programmable
          parameters (thresholds, cooling, high voltage, etc.) to the current values in the
          EPICS output records. When the system is available again SystemReset record will
          go back to 0.''',
        ),  # end of PixiradDoc.html


    'FirewireWinDoc.html': dict(
        FORMAT=u'''[FORMAT r/w mbbo]
          The video format. The allowed choices are 0="VGA", 1="Super VGA 1", 2="Super VGA
          2", 6="Still image", 7="User-defined". The FDC_has_format and FDC_valid_format parameters
          described below indicate whether a particular format is actually supported by the
          camera.''',
        HAS_FORMAT_0=u'[HAS_FORMAT_0 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_1=u'[HAS_FORMAT_1 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_2=u'[HAS_FORMAT_2 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_3=u'[HAS_FORMAT_3 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_4=u'[HAS_FORMAT_4 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_5=u'[HAS_FORMAT_5 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_6=u'[HAS_FORMAT_6 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        HAS_FORMAT_7=u'[HAS_FORMAT_7 r/o bi] A flag indicating whether a particular format (0-7) is supported by the camera.',
        VALID_FORMAT_0=u'''[VALID_FORMAT_0 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_1=u'''[VALID_FORMAT_1 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_2=u'''[VALID_FORMAT_2 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_3=u'''[VALID_FORMAT_3 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_4=u'''[VALID_FORMAT_4 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_5=u'''[VALID_FORMAT_5 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_6=u'''[VALID_FORMAT_6 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        VALID_FORMAT_7=u'''[VALID_FORMAT_7 r/o stringin]
          A string describing each of the formats (0-7) supported by the camera. The string
          is "N.A." if the format is not supported.''',
        CURRENT_FORMAT=u'[CURRENT_FORMAT r/o stringin] A string describing the currently selected video format.',
        MODE=u'''[MODE r/w mbbo]
          The video mode. The allowed choices are 0-7. The FDC_has_mode and FDC_valid_mode
          parameters described below indicate whether a particular mode is actually supported
          by the camera in the currently selected video format.''',
        HAS_MODE_0=u'''[HAS_MODE_0 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_1=u'''[HAS_MODE_1 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_2=u'''[HAS_MODE_2 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_3=u'''[HAS_MODE_3 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_4=u'''[HAS_MODE_4 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_5=u'''[HAS_MODE_5 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_6=u'''[HAS_MODE_6 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        HAS_MODE_7=u'''[HAS_MODE_7 r/o bi]
          A flag indicating whether a particular mode (0-7) is supported by the camera in
          the currently selected format.''',
        VALID_MODE_0=u'''[VALID_MODE_0 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_1=u'''[VALID_MODE_1 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_2=u'''[VALID_MODE_2 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_3=u'''[VALID_MODE_3 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_4=u'''[VALID_MODE_4 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_5=u'''[VALID_MODE_5 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_6=u'''[VALID_MODE_6 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        VALID_MODE_7=u'''[VALID_MODE_7 r/o stringin]
          A string describing each of the modes (0-7) supported by the camera in the currently
          selected video format. The string is "N.A." if the mode is not supported in this
          format.''',
        CURRENT_MODE=u'[CURRENT_MODE r/o stringin] A string describing the currently selected video mode.',
        FR=u'''[FR r/w mbbo]
          The frame rate in frames/second. The allowed choices are 0="1.875", 1="3.75", 2="7.5",
          3="15", 4="30", 5="60", 6="120", 7="240". FDC_has_framerate and FDC_valid_framerate
          parameters described below indicate whether a particular frame rate is actually
          supported by the camera in the currently selected video format and mode.''',
        HAS_RATE_0=u'''[HAS_RATE_0 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_1=u'''[HAS_RATE_1 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_2=u'''[HAS_RATE_2 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_3=u'''[HAS_RATE_3 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_4=u'''[HAS_RATE_4 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_5=u'''[HAS_RATE_5 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_6=u'''[HAS_RATE_6 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        HAS_RATE_7=u'''[HAS_RATE_7 r/o bi]
          A flag indicating whether a particular frame rate (0-7) is supported by the camera
          in the currently selected video format and mode.''',
        VALID_RATE_0=u'''[VALID_RATE_0 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_1=u'''[VALID_RATE_1 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_2=u'''[VALID_RATE_2 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_3=u'''[VALID_RATE_3 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_4=u'''[VALID_RATE_4 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_5=u'''[VALID_RATE_5 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_6=u'''[VALID_RATE_6 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        VALID_RATE_7=u'''[VALID_RATE_7 r/o stringin]
          A string describing each of the frame rates (0-7) supported by the camera in the
          currently selected video format and mode. The string is "N.A." if the frame rate
          is not supported in this format and mode.''',
        CURRENT_RATE=u'[CURRENT_RATE r/o stringin] A string describing the currently selected video frame rate.',
        COLORCODE=u'''[COLORCODE r/w mbbo]
          The color code. The allowed choices are 0-10. FDC_has_colorcode and FDC_valid_colorcode
          parameters described below indicate whether a particular color code is actually
          supported by the camera in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_0=u'''[HAS_COLORCODE_0 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_1=u'''[HAS_COLORCODE_1 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_2=u'''[HAS_COLORCODE_2 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_3=u'''[HAS_COLORCODE_3 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_4=u'''[HAS_COLORCODE_4 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_5=u'''[HAS_COLORCODE_5 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_6=u'''[HAS_COLORCODE_6 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_7=u'''[HAS_COLORCODE_7 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_8=u'''[HAS_COLORCODE_8 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_9=u'''[HAS_COLORCODE_9 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        HAS_COLORCODE_10=u'''[HAS_COLORCODE_10 r/o bi]
          A flag indicating whether a particular color code (0-10) is supported by the camera
          in the currently selected video format (7) and mode.''',
        VALID_COLORCODE_0=u'''[VALID_COLORCODE_0 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_1=u'''[VALID_COLORCODE_1 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_2=u'''[VALID_COLORCODE_2 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_3=u'''[VALID_COLORCODE_3 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_4=u'''[VALID_COLORCODE_4 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_5=u'''[VALID_COLORCODE_5 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_6=u'''[VALID_COLORCODE_6 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_7=u'''[VALID_COLORCODE_7 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_8=u'''[VALID_COLORCODE_8 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_9=u'''[VALID_COLORCODE_9 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        VALID_COLORCODE_10=u'''[VALID_COLORCODE_10 r/o stringin]
          A string describing each of the color codes (0-10) supported by the camera in the
          currently selected video format (7) and mode. The string is "N.A." if the color
          code is not supported in this format and mode.''',
        CURRENT_COLORCODE=u'[CURRENT_COLORCODE r/o stringin] A string describing the currently selected color code.',
        READOUT_TIME=u'''[READOUT_TIME r/w ao]
          The readout time in seconds. This value is added to the AcquireTime to determine
          how long to wait before a frame timeout is reported. It should be set to a value
          slightly larger than the actual readout time of the camera in the current mode.''',
        ),  # end of FirewireWinDoc.html


    'Mar345Doc.html': dict(
        Acquire=u'''[Acquire]
          Setting this to 1 starts an acquisition sequence. If ADNumImages is greater than
          1 then it acquires multiple frames. For each frame it does the following:

            Erases the detector if mar345EraseMode is "Before expose".
            Opens the shutter if either the mar345 shutter or EPICS shutter controls are enabled.
            Waits for the desired exposure time.
            Closes the shutter if either the mar345 shutter or EPICS shutter controls are
              enabled.
            Scans the detector and saves the file.
            Erases the detector if mar345EraseMode is "After scan".

          If ADAcquire is set to 0 during exposure (step 3 above) then it proceeds immediately
          to step 4, finishes collecting the current frame and stops the acquisition sequence
          if ADNumImages is greater than 1. If mar345Abort is set to 0 then the acquisition
          is terminated as soon as possible without saving the data. Note however that commands
          to the mar345 server to erase, change mode, or scan cannot be aborted, so the driver
          must wait for these commands to complete.''',
        NumImages=u'[NumImages] Controls the number of images to acquire when ADImageMode is ADImageMultiple.',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images when ADImageMode is ADImageMultiple or ADImageContinuous.
          If this is greater than the acquisition time plus readout overhead then the driver
          will wait until the period has elapsed before starting the next acquisition.''',
        FilePath=u'''[FilePath]
          Controls the path for saving images. It must be a valid path for mar345dtb and
          for the areaDetector driver, which is normally running in an EPICS IOC. If mar345dtb
          and the EPICS IOC are not running on the same machine then soft links will typically
          be used to make the paths look identical.''',
        FileTemplate=u'''[FileTemplate]
          The mar345dtb program uses a file extension which describes the scan size and resolution,
          e.g. 3450, etc. Thus the FileTemplate should not include an extension. Furthermore
          mar345dtb always uses exactly 3 digits for the FileNumber (with leading zeros if
          required), just before the extension. Thus the final 3 characters of the FileTemplate
          must be "%3.3d". If they are not then mar345dtb will successfully save the file,
          but with a different name than the areaDetector driver was expecting it to use,
          and the driver will generate an error when it tries to open the file to read the
          data. A good value for FileTemplate is thus "%s%s_%3.3d", which will concatentate
          the FilePath and FileName, followed by an underscore and then a 3 digit number with
          leading zeros if required. The underscore is optional, and other characters can
          be placed between the FileName and the FileNumber if desired.''',
        FileFormat=u'[FileFormat] mar345 only supports mar345 format binary files.',
        DetectorState_RBV=u'''[DetectorState_RBV]
          mar345 replaces the state strings with the following: Exposing, Scanning, Erasing,
          Changing Mode, Aborting, Error, and Waiting.''',
        ScanSize=u'[ScanSize r/w mbbo] The detector diameter to read out. Choices are 180mm, 240mm, 300mm, and 345mm.',
        ScanResolution=u'[ScanResolution r/w mbbo] The pixel size to use when reading the detector out. Choices are 0.10 and 0.15mm.',
        ChangeMode=u'''[ChangeMode r/w busy]
          Writing 1 to this parameter causes the ScanSize and ScanResolution values to be
          sent to the server, changing the scan mode. This is not strictly necessary, because
          the size and resolution is also encoded in the file extension used in the scan command.
          However, changing the mode before doing a scan reduces the time for the scan, because
          the detector is already configured for the correct mode.''',
        ChangedMode_RBV=u'''[ChangedMode_RBV r/w]
          Writing 1 to this parameter causes the ScanSize and ScanResolution values to be
          sent to the server, changing the scan mode. This is not strictly necessary, because
          the size and resolution is also encoded in the file extension used in the scan command.
          However, changing the mode before doing a scan reduces the time for the scan, because
          the detector is already configured for the correct mode.''',
        EraseMode=u'''[EraseMode r/w mbbo]
          Controls whether an erase cycle should be automatically performed during acquisition.
          Choices are None, Before expose, and After scan.''',
        NumErase=u'''[NumErase r/w longout]
          The number of erase cycles to perform each time the detector is erased, either because
          the mar345Erase parameter is set to 1, or because of an automatic erase as part
          of an acquisition.''',
        Erase=u'''[Erase r/w busy]
          Write 1 to this parameter to initiate erasing the detector. The detector will be
          erased multiple times if mar345NumErase is greater than 1.''',
        Abort=u'''[Abort r/w bo]
          Writing 1 to this parameter aborts the current operation as soon as possible and
          returns the driver to the idle state. Note however that commands to the mar345 server
          cannot be aborted, so the driver must wait for the current command to complete.''',
        marSserverAsyn=u'[marSserverAsyn N/A asyn] asyn record to control debugging communication with mar345dtb program',
        ),  # end of Mar345Doc.html


    'pilatusDoc.html': dict(
        TriggerMode=u'''[TriggerMode]
          The driver redefines the choices for the ADTriggerMode parameter (record $(P)$(R)TriggerMode)
          from ADDriver.h. The choices for the Pilatus are:

            Internal (external signal not used)
            External Enable (count while external trigger line is high, readout on high to
              low transition)
            External Trigger (begin acquisition sequence on high to low transition of external
              trigger line)
            Multiple External Trigger (high to low transition on external signal triggers
              a single acquisition for the programmed exposure time)
            Alignment (collect images as fast as exposure time and readout permit, images
              written to a temporary file)

          The first 4 modes correspond directly to the camserver commands Exposure,
          ExtEnable, ExtTrigger, and ExtMTrigger respectively.
          Alignment mode uses the Exposure command as well, but continuously
          takes images into the same temporary file (alignment.tif).''',
        AcquireTime=u'''[AcquireTime]
          Controls the acquisision time in all modes except External Enable. In External Enable
          mode the timing is controlled entirely by the external trigger line. However, even
          in ExternalEnable mode AcquireTime is used by camserver and by the driver to estimate
          how long the acquisition will take. Hardware timeouts will occur if the actual time
          to acquire differs significantly from the estimated time based on AcquireTime and
          AcquirePeriod.''',
        NumImages=u'''[NumImages]
          Controls the number of images to acquire. It applies in all trigger modes except
          Alignment.''',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the exposure period in seconds in Internal or External Trigger modes when
          NumImages >1. In External Enable mode the timing is controlled entirely by the
          external trigger line. However, even in ExternalEnable mode AcquirePeriod is used
          by camserver and by the driver to estimate how long the acquisition will take. Hardware
          timeouts will occur if the actual time to acquire differs significantly from the
          estimated time based on AcquireTime and AcquirePeriod.''',
        NumExposures=u'''[NumExposures]
          Controls the number of exposures per image. It is most useful in External Enable
          mode, but it can be set in any mode.''',
        Acquire=u'''[Acquire]
          Controls the acquisition. Setting this to 1 starts image acquisition. The driver
          sets the record to 0 when acquisition is complete. This means an entire acquisition
          series if NImages >1. Setting this to 0 aborts an acquisition. If the driver
          was currently acquiring imges then this record will cause the "Stop" and "K" (Kill)
          commands to be sent to camserver.''',
        FilePath=u'''[FilePath]
          Controls the path for saving images. It must be a valid path for camserver and
          for the areaDetector driver, which is normally running in an EPICS IOC. If camserver
          and the EPICS IOC are not running on the same machine then soft links will typically
          be used to make the paths look identical.''',
        FileTemplate=u'''[FileTemplate]
          camserver uses the file extension to determine what format to save the files in.
          The areaDetector Pilatus driver only supports TIFF and CBF files, so the extension
          should be .tif or .cbf. When saving multiple images (NImages>1) camserver has its
          own rules for creating the names of the individual files. The rules are as follows.
          The name constructed using the algorithm described for NDFileTemplate under
            File Saving Parameters is used as a basename. The following examples show
          the interpretation of the basename.
          Basename            Files produced

test6.tif           test6_00000.tif,  test6_00001.tif, ...
test6_.tif          test6_00000.tif,  test6_00001.tif, ...
test6_000.tif       test6_000.tif,    test6_001.tif, ...
test6_014.tif       test6_014.tif,    test6_015.tif, ...
test6_0008.tif      test6_0008.tif,   test6_0009.tif, ...
test6_2_0035.tif    test6_2_0035.tif, test6_2_0036.tif, ...

          The numbers following the last '_' are taken as a format template, and as a start
          value. The minimum format is 3; there is no maximum; the default is 5. The format
          is also constrained by the requested number of images.''',
        DelayTime=u'''[DelayTime r/w ao]
          Delay in seconds between the external trigger and the start of image acquisition.
          It only applies in External Trigger mode''',
        ThresholdEnergy=u'[ThresholdEnergy r/w ao] Threshold energy in keV',
        GainMenu=u'''[GainMenu r/w mbbo]
          Gain menu. Controls the value of Vrf, which determines the shaping time and gain
          of the input amplifiers. The allowed values are:

            0 ("Fast/Low") Fastest shaping time (~125ns) and lowest gain.
            1 ("Medium/Medium") Medium shaping time (~200 ns) and medium gain.
            2 ("Slow/High") Slow shaping time (~400 ns) and high gain.
            3 ("Slow/Ultrahigh") Slowest peaking time (? ns) and highest gain.''',
        Armed=u'''[Armed r/o bi]
          Flag to indicate when the Pilatus is ready to accept external trigger signals (0=not
          ready, 1=ready). This should be used by clients to indicate when it is OK to start
          sending trigger pulses to the Pilatus. If pulses are send before Armed=1 then the
          Pilatus may miss them, leading to DMA timeout errors from camserver''',
        ImageFileTmot=u'''[ImageFileTmot r/w ao]
          Timeout in seconds when reading a TIFF or CBF file. It should be set to several
          seconds, because there can be delays for various reasons. One reason is that there
          is sometimes a delay between when an External Enable acquisition is started and
          when the first external pulse occurs. Another is that it can take some time for
          camserver processes to finish writing the files.''',
        BadPixelFile=u'''[BadPixelFile r/w waveform]
          Name of a file to be used to replace bad pixels. If this record does not point to
          a valid bad pixel file then no bad pixel mapping is performed. The bad pixel map
          is used before making the NDArray callbacks. It does not modify the data in the
          files that camserver writes. This is a simple ASCII file with the following format:
          badX1,badY1 replacementX1,replacementY1
badX2,badY2 replacementX2,replacementY2
...

          The X and Y coordinates range from 0 to NXPixels-1 and NYPixels-1. Up to 100 bad
          pixels can be defined. The bad pixel mapping simply replaces the bad pixels with
          another pixel's value. It does not do any averaging. It is felt that this is sufficient
          for the purpose for which this driver was written, namely fast on-line viewing of
          ROIs and image data. More sophisticated algorithms can be used for offline analysis
          of the image files themselves. The following is an example bad pixel file for a
          GSECARS detector:

263,3   262,3
264,3   266,3
263,3   266,3
300,85  299,85
300,86  299,86
471,129 472,129''',
        NumBadPixels=u'''[NumBadPixels r/o longin]
          The number of bad pixels defined in the bad pixel file. Useful for seeing if the
          bad pixel file was read correctly.''',
        FlatFieldFile=u'''[FlatFieldFile r/w waveform]
          Name of a file to be used to correct for the flat field. If this record does not
          point to a valid flat field file then no flat field correction is performed. The
          flat field file is simply a TIFF or CBF file collected by the Pilatus that is used
          to correct for spatial non-uniformity in the response of the detector. It should
          be collected with a spatially uniform intensity on the detector at roughly the same
          energy as the measurements being corrected. When the flat field file is read, the
          average pixel value (averageFlatField) is computed using all pixels with intensities
          >PilatusMinFlatField. All pixels with intensity <PilatusMinFlatField in the
          flat field are replaced with averageFlatField. When images are collected before
          the NDArray callbacks are performed the following per-pixel correction is applied:
          ImageData[i] =
    (averageFlatField *
    ImageData[i])/flatField[i];''',
        MinFlatField=u'''[MinFlatField r/w longout]
          The mimimum valid intensity in the flat field. This value must be set > 0 to prevent
          divide by 0 errors. If the flat field was collected with some pixels having very
          low intensity then this value can be used to replace those pixels with the average
          response.''',
        FlatFieldValid=u'[FlatFieldValid r/o bi] This record indicates if a valid flat field file has been read. 0=No, 1=Yes.',
        Wavelength=u'[Wavelength r/w ao] MX wavelength to write to CBF and TIFF image header.',
        EnergyLow=u'[EnergyLow r/w ao] MX energy range low value to write to CBF and TIFF image header.',
        EnergyHigh=u'[EnergyHigh r/w ao] MX energy range high value to write to CBF and TIFF image header.',
        DetDist=u'[DetDist r/w ao] MX detector distance to write to CBF and TIFF image header.',
        DetVOffset=u'[DetVOffset r/w ao] MX detector vertical offset to write to CBF and TIFF image header.',
        BeamX=u'[BeamX r/w ao] MX beam X to write to CBF and TIFF image header.',
        BeamY=u'[BeamY r/w ao] MX beam Y to write to CBF and TIFF image header.',
        Flux=u'[Flux r/w ao] MX flux to write to CBF and TIFF image header.',
        FilterTransm=u'[FilterTransm r/w ao] MX filter transmission to write to CBF and TIFF image header.',
        StartAngle=u'''[StartAngle r/w ao]
          MX start angle to write to CBF and TIFF image header. When saving multiple images
          (ADNumImages>1) camserver will automatically increment the field in the image
          header by PilatusAngleIncr for each image.''',
        AngleIncr=u'''[AngleIncr r/w ao]
          MX angle increment to write to CBF and TIFF image header. When saving multiple images
          (ADNumImages>1) camserver will automatically increment the field corresponding
          to PilatusStartAngle in the image header by this value for each image.''',
        Det2theta=u'[Det2theta r/w ao] MX detector 2theta to write to CBF and TIFF image header.',
        Polarization=u'[Polarization r/w ao] MX polarization to write to CBF and TIFF image header.',
        Alpha=u'[Alpha r/w ao] MX alpha to write to CBF and TIFF image header.',
        Kappa=u'[Kappa r/w ao] MX kappa to write to CBF and TIFF image header.',
        Phi=u'[Phi r/w ao] MX phi to write to CBF and TIFF image header.',
        Chi=u'[Chi r/w ao] MX chi to write to CBF and TIFF image header.',
        OscillAxis=u'''[OscillAxis r/w stringout]
          MX oscillation axis text, up to 18 characters in length, to write to CBF and TIFF
          image header.''',
        NumOscill=u'[NumOscill r/w longout] MX number of oscillations to write to CBF and TIFF image header.',
        CbfTemplateFile=u'''[CbfTemplateFile r/w waveform]
          Template file to be used to obtain all of the MX parameters above. Set the name
          of this file to "0" to disable the template file.''',
        HeaderString=u'[HeaderString r/w waveform] Header string to write in the COMMENT field of the CBF file.',
        PixelCutOff_RBV=u'[PixelCutOff_RBV r/o ai] Maximum possible count rate per pixel.',
        Temp0_RBV=u'[Temp0_RBV r/o ai] Temperature readout 0.',
        Temp1_RBV=u'[Temp1_RBV r/o ai] Temperature readout 1.',
        Temp2_RBV=u'[Temp2_RBV r/o ai] Temperature readout 2.',
        Humid0_RBV=u'[Humid0_RBV r/o ai] Humidity readout 0.',
        Humid1_RBV=u'[Humid1_RBV r/o ai] Humidity readout 1.',
        Humid2_RBV=u'[Humid2_RBV r/o ai] Humidity readout 2.',
        TVXVersion_RBV=u'[TVXVersion_RBV r/o stringin] Version of TVX and camserver.',
        CamserverAsyn=u'''[CamserverAsyn N/A asyn]
          asyn record to control debugging communication with camserver. Setting the CNCT
          field in this record to Disconnect causes the drvAsynIPPort server
          to disconnect from camserver. This can be used to allow another program, such as
          TVX, to temporarily take control of camserver, without restarting the EPICS IOC.
          Set CNCT to Connect to reconnect the IOC to camserver, or simply process
          any record which communicates with camserver, because the driver will automatically
          reconnect.''',
        ),  # end of pilatusDoc.html


    'prosilicaDoc.html': dict(
        BayerConvert=u'''[BayerConvert r/w mbbo]
          Color conversion when NDColorMode is Bayer:
          None: Raw Bayer images are passed to the plugins
          RGB1: Bayer images are converted to RGB1
          RGB2: Bayer images are converted to RGB2
          RGB3: Bayer images are converted to RGB3
          Having the camera send Bayer images uses 3 times less network bandwidth than
          sending RGB1 images.  It does place more CPU load on the host to convert
          from Bayer to RGB, but this is often an acceptable tradeoff.''',
        TriggerEvent=u'''[TriggerEvent r/w mbbo]
          The edge or level for the selected trigger signal when ADTriggerMode=Sync In 1 to
          SyncIn 4. Allowed values are:
          Rising edge
          Falling edge
          Any edge
          High level
          Low level''',
        TriggerDelay=u'''[TriggerDelay r/w ao]
          The delay in seconds between the trigger signal and when the frame is actually acquired.
          Minimum value is 1 microsecond.''',
        TriggerOverlap=u'''[TriggerOverlap r/w mbbo]
          Controls the behavior when an external trigger signal arrives before the camera
          is ready for the next trigger. Allowed values are:
          Off - the external trigger is ignored
          Previous frame - the external trigger is latched and triggers the next frame when
          the current frame completes''',
        TriggerSoftware=u'[TriggerSoftware r/w bo] Processing this record performs a software trigger if ADTriggerMode=Software.',
        SyncIn1Level_RBV=u'[SyncIn1Level_RBV r/o bi] The level of the Sync In 1 signal',
        SyncIn2Level_RBV=u'[SyncIn2Level_RBV r/o bi] The level of the Sync In 2 signal',
        SyncOut1Mode=u'''[SyncOut1Mode r/w mbbo]
          The mode of the Sync Out 1 signal. Allowed values are:

          GPO (general purpose output)

          AcqTrigReady

          FrameTrigReady

          FrameTrigger

          Exposing

          FrameReadout

          Imaging

          Acquiring

          SyncIn1

          SyncIn2

          SyncIn3

          SyncIn4

          Strobe1

          Strobe2

          Strobe3

          Strobe4''',
        SyncOut1Level=u'[SyncOut1Level r/w bo] The level of the Sync Out 1 signal. This is only programmable when SyncOut1Mode=GPO.',
        SyncOut1Invert=u'[SyncOut1Invert r/w bo] Flag to invert the Sync Out 1 signal.',
        SyncOut2Mode=u'[SyncOut2Mode r/w mbbo] The mode of the Sync Out 2 signal. Allowed values are the same as for PSSyncOut1Mode.',
        SyncOut2Level=u'[SyncOut2Level r/w bo] The level of the Sync Out 2 signal. This is only programmable when SyncOut2Mode=GPO.',
        SyncOut1Level_RBV=u'[SyncOut1Level_RBV r/w bi] The level of the Sync Out 2 signal. This is only programmable when SyncOut2Mode=GPO.',
        SyncOut2Invert=u'[SyncOut2Invert r/w bo] Flag to invert the Sync Out 2 signal.',
        SyncOut3Mode=u'[SyncOut3Mode r/w mbbo] The mode of the Sync Out 3 signal. Allowed values are the same as for PSSyncOut1Mode.',
        SyncOut3Level=u'[SyncOut3Level r/w bo] The level of the Sync Out 3 signal. This is only programmable when SyncOut3Mode=GPO.',
        SyncOut3Invert=u'[SyncOut3Invert r/w bo] Flag to invert the Sync Out 3 signal.',
        Strobe1Mode=u'''[Strobe1Mode r/w mbbo]
          The mode of the Strobe 1 signal. The Strobe signals are based on the following values,
          but allow for changing the delay and width relative to the underlying value. Any
          of the outputs can be set to the Stobe1 value, rather than the raw values of these
          signals. Allowed values are:

          AcqTrigReady

          FrameTrigReady

          FrameTrigger

          Exposing

          FrameReadout

          Acquiring

          SyncIn1

          SyncIn2

          SyncIn3

          SyncIn4''',
        Strobe1CtlDuration=u'[Strobe1CtlDuration r/w bo] Flag to allow controlling the strobe duration.',
        Strobe1Duration=u'[Strobe1Duration r/w ao] The strobe duration if PSStrobe1CtlDuration is On.',
        Strobe1Delay=u'[Strobe1Delay r/w ao] The strobe delay relative to the underlying signal that the strobe is based on.',
        PSResetTimer=u'''[PSResetTimer r/w longout]
          Resets the timestamp timer in the camera. If PSTimestampType is POSIX or EPICS then
          it also stores the current POSIX or EPICS time in the driver.''',
        PSTimestampType=u'''[PSTimestampType r/w mbbo]
          Controls the type of timestamp in the timeStamp field of each NDArray. Choices are:

            NativeTicks: The number of internal camera clock ticks which have elapsed since
              the last timer reset.
            NativeSeconds: The number of seconds which have elapsed since the last timer reset.
              This is NativeTicks divided by the internal camera clock frequency.
            POSIX: The number of seconds since the POSIX Epoch (00:00:00 UTC, January 1, 1970).
            EPICS The number of seconds since the EPICS Epoch (January 1, 1990).

          The POSIX and EPICS timestamps are calculated as follows: when the timer is reset
          the current POSIX or EPICS time is stored, and the internal camera timer is reset.
          The timestamps are then computed by adding the camera ticks (converted to seconds)
          to the stored POSIX or EPICS time. Thus, the relative times of each frame are accurately
          controlled by the internal camera clock. The accuracy of the absolute time is determined
          by the accuracy of the time of day clock in the IOC computer.''',
        PSReadStatistics=u'[PSReadStatistics r/w longout] Read the Gigabit Ethernet statistics when 1',
        PSDriverType_RBV=u'[PSDriverType_RBV r/o stringin] Driver type',
        PSFilterVersion_RBV=u'[PSFilterVersion_RBV r/o stringin] Packet filter version',
        PSFrameRate_RBV=u'[PSFrameRate_RBV r/o ai] Frame rate (Hz)',
        PSByteRate=u'''[PSByteRate r/w longout]
          Stream bytes per second in the PvAPI driver. This allows limiting the bandwidth
          that a camera uses. It also allows operation of GigE cameras on non-Gigabit Ethernet
          networks by decreasing the value to maximum that the network supports. The default
          of 115000000 allows full-speed operation on GigE networks.''',
        PSPacketSize_RBV=u'''[PSPacketSize_RBV r/o longin]
          Actual packet size of Ethernet packets. When connecting to the camera the driver
          always automatically negotiates the largest packet size that the camera and IOC
          computer support.''',
        PSFramesCompleted_RBV=u'[PSFramesCompleted_RBV r/o longin] Number of frames completed',
        PSFramesDropped_RBV=u'[PSFramesDropped_RBV r/o longin] Number of frames dropped',
        PSPacketsErroneous_RBV=u'[PSPacketsErroneous_RBV r/o longin] Number of erroneous packets',
        PSPacketsMissed_RBV=u'[PSPacketsMissed_RBV r/o longin] Number of missed packets',
        PSPacketsReceived_RBV=u'[PSPacketsReceived_RBV r/o longin] Number of received packets',
        PSPacketsRequested_RBV=u'[PSPacketsRequested_RBV r/o longin] Number of packets requested',
        PSPacketsResent_RBV=u'[PSPacketsResent_RBV r/o longin] Number of packets resent',
        PSBadFrameCounter_RBV=u'[PSBadFrameCounter_RBV r/o longin] Number of bad frames',
        ),  # end of prosilicaDoc.html


    'PointGreyDoc.html': dict(
        TriggerMode=u'''[TriggerMode]
          The choices for the Point Grey are:

            "Internal". The timing is internal to the detector.
            "Ext. standard". Each external trigger pulse starts the next image. The exposure
              time is controlled internally by the AcquireTime record.
            "Bulb". The rising edge of the external trigger signal starts the next image.
              The detector continues to acquire while the external signal is high, and then reads
              out the detector on the falling edge of the external trigger signal.
            "Skip frames". One external trigger pulse starts an image and then the next N
              external trigger signals are ignored. The SkipFrames record defines N.
            "Multi-exposure". One external trigger pulse starts an image and then the next
              N-1 external trigger signals cause an additional exposure into the same image. The
              image is read out after trigger N. The NumExposures record defines N.
            "Multi-exposure bulb". A combination of bulb and multi-exposure modes above. N
              exposures are accumulated into an image before it is read out. The time in the logic
              high state determines the acquire time for each exposure. The NumExposures record
              defines N.
            "Low-smear". Smear reduction works by increasing the speed of the vertical clock
              near the end of the integration cycle. See the Technical Reference Manual for the
              camera for more information.
            "Multi-shot". A single external trigger causes N images to be acquired. The NumImages
              record defines N. NumImages is limited to a maximum 255 in this mode.

          Note that the minimum time between external trigger pulses is no more than the maximum
          value of FrameRate in the current mode, and may be less for a particular camera.
          Note also that not all cameras support all TriggerModes. The TriggerMode enum string
          choices are only those supported for the camera in use.''',
        TemperatureActual=u'[TemperatureActual] The readback of the temperature.',
        NumImages=u'''[NumImages]
          Controls the number of images to acquire. When TriggerMode=Internal this is handled
          in software. When TriggerMode=Multi-shot it is handled in the camera firmware.''',
        NumExposures=u'''[NumExposures]
          Controls the number of exposures per image when TriggerMode="Multi-exposure" or
          "Multi-exposure bulb".''',
        AcquireTime=u'''[AcquireTime]
          Controls the acquisition time per image. This is converted into the ShutterAbsVal
          control of the SHUTTER property. ShutterAbsVal = AcquireTime*1000., because SHUTTER
          units are ms.''',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images. This is converted into the FrameRateAbsVal control
          of the FRAME_RATE property. FrameRateAbsVal = 1./AcquirePeriod.''',
        Gain=u'''[Gain]
          Controls the analog gain on the camera. This is converted into the GainAbsVal control
          of the GAIN property. The units are dB.''',
        SerialNumber=u'''[SerialNumber r/o longin]
          The camera serial number. This number can be used in the cameraId argument to pointGretConfig()
          to select a specific camera for the EPICS IOC.''',
        FirmwareVersion=u'[FirmwareVersion r/o stringin] The camera firmware version.',
        SoftwareVersion=u'[SoftwareVersion r/o stringin] The FlyCapture2 SDK software version.',
        VideoMode=u'''[VideoMode r/w mbbo]
            The video mode. All possible values are listed in the Video
            modes section above. The actual enum choices for this record will only include
          the video modes supported by the camera in use.''',
        Format7Mode=u'''[Format7Mode r/w mbbo]
          The Format7 mode when the camera is in VideoMode=Format7. This is discussed in the
          Format7 modes section above. The actual enum choices
          for this record will only include the Format7 modes supported by the camera in use.''',
        PixelFormat=u'''[PixelFormat r/w mbbo]
          The pixel format when the camera is in VideoMode=Format7. This is discussed in the
          Pixel formats section above. The actual enum choices
          for this record will only include the pixel formats supported by the camera in use
          for the Format7Mode currently selected.''',
        ConvertPixelFormat=u'''[ConvertPixelFormat r/w mbbo]
          The driver allows converting the pixel format from the camera to another pixel format.
          The pixel formats from the camera that can be converted are:

            Raw8
            Raw16
            Mono12

          The pixel format that these can be converted to are:

            None: The input pixel format is not converted.
            Mono8: The input pixel format is converted to Mono8.
            Mono16: The input pixel format is converted to Mono16. This is useful when the
              input pixel format is Mono12, since this saves network bandwidth.
            RGB8: The input format is converted to RGB8. This is useful when the input format
              is Raw8, for a color camera. In this case Bayer color is sent on the network, reducing
              the bandwidth requirement by a factor of 3.
            RGB16: The input format is converted to RGB16. This is useful when the input format
              is Raw16, for a color camera. In this case Bayer color is sent on the network, reducing
              the bandwidth requirement by a factor of 3.''',
        FrameRate=u'''[FrameRate r/w mbbo]
          The frame rate choice when the VideoMode is not Format7. This is discussed in the
          Frame rates section above. The actual enum choices for
          this record will only include the frame rates supported by the camera in use for
          the VideoMode currently selected.''',
        BinningMode=u'[BinningMode r/w mbbo] The binning mode for GigE cameras. The allowed values are camera-specific.',
        TriggerSource=u'''[TriggerSource r/w mbbo]
          The trigger source signal. Choices are "GPIO_0", GPIO_1","GPIO_2", and "GPIO_3",
          which selects one of 4 GPIO pins on the camera. However, not all choices may be
          available on a specific camera, and the enum choices will only be the trigger sources
          actually supported on the camera in use.''',
        TriggerPolarity=u'[TriggerPolarity r/w bo] The trigger polarity. Choices are "Low", and "High".',
        SoftwareTrigger=u'[SoftwareTrigger r/w bo] Processing this record causes the driver to issue a software trigger.',
        SkipFrames=u'[SkipFrames r/w longout] The number of frames to skip when TriggerMode="Skip frames".',
        StrobeSource=u'''[StrobeSource r/w mbbo]
          The strobe output signal. Choices are "GPIO_0", GPIO_1","GPIO_2", and "GPIO_3",
          which selects one of 4 GPIO pins on the camera. However, not all choices may be
          available on a specific camera, and the enum choices will only be the strobe sources
          actually supported on the camera in use.''',
        StrobeEnable=u'[StrobeEnable r/w bo] Enables the strobe output. Choices are "Disable", and "Enable".',
        StrobePolarity=u'[StrobePolarity r/w bo] The strobe polarity. Choices are "Low", and "High".',
        StrobeDelay=u'[StrobeDelay r/w ao] The delay of the strobe signal relative to the start of acquisition.',
        StrobeDuration=u'''[StrobeDuration r/w ao]
          The duration of the strobe signal. If zero then the strobe output is asserted during
          the image aquisition time.''',
        MaxPacketSize=u'''[MaxPacketSize r/o longin]
          The maximum packet size. This depends on the current acquisition settings for Firewire
          and USB cameras. For GigE cameras this is determined by calling DiscoverGigEPacketSize
          at startup, which should return the maximum Ethernet packet size supported between
          the camera and the IOC. However, this sometimes returns 9000 (jumbo packets) when
          jumbo packets are not in fact supported. In this case the user should manually set
          PacketSize to 1440 or image acquisition will fail.''',
        PacketSize=u'''[PacketSize r/w ao]
          The packet size to use. This is used to control the maximum bandwidth, and hence
          maximum frame rate, on Firewire and USB cameras. For GigE cameras it should be set
          to the largest packet size supported on the Ethernet connection between the camera
          and IOC. It should be set to 1440 for connections that do not support jumbo packets,
          and as large as 9000 for connections that do support jumbo packets. If PacketSize
          is set to 0 then the driver will use the current value of MaxPacketSize.''',
        PacketSizeActual=u'[PacketSizeActual r/o longin] The actual packet size being used.',
        PacketDelay=u'''[PacketDelay r/w longout]
          The packet delay to use in microseconds. This is used to control the maximum bandwidth,
          and hence maximum frame rate, on GigE cameras. It is not used for Firewire or USB
          cameras. The default is 400 microseconds. If the number of CorruptFrames is large
          then this can be increased, for example to 1000. This will reduce the maximum frame
          rate but can significantly reduce the number of CorruptFrames.''',
        PacketDelayActual=u'[PacketDelayActual r/o longin] The actual packet delay being used.',
        Bandwidth=u'''[Bandwidth r/o ai]
          The calculated bandidth in MB/s. This is computed from the image size and the frame
          rate.''',
        TimeStampMode=u'''[TimeStampMode r/w mbbo]
          The timestamp mode. Controls the value of the NDArray,.timeStamp value. Choices
          are:

            Camera: The time from the camera is used.
            EPICS: The EPICS time is used
            Hybrid: The EPICS time when the camera started is combined with the time stamp
              from the camera.''',
        CorruptFrames_RBV=u'''[CorruptFrames_RBV r/o longin]
          The number of corrupt frames. The Point Grey SDK resets this to 0 each time acquisition
          is started.''',
        DroppedFrames_RBV=u'''[DroppedFrames_RBV r/o longin]
          The number of dropped frames. The Point Grey SDK resets this to 0 each time acquisition
          is started.''',
        DriverDropped_RBV=u'''[DriverDropped_RBV r/o longin]
          The number of frames dropped by the driver. The Point Grey SDK resets this to 0
          each time acquisition is started.''',
        TransmitFailed_RBV=u'''[TransmitFailed_RBV r/o longin]
          The number of time transmission failed. The Point Grey SDK resets this to 0 each
          time acquisition is started.''',
        ),  # end of PointGreyDoc.html


    'NDPluginStdArrays.html': dict(
        ArrayData=u'''[ArrayData r/o waveform]
          Array data as a 1-D array, possibly converted in data type from that in the NDArray
          object to the specific asyn interface.''',
        ),  # end of NDPluginStdArrays.html


    'NDPluginColorConvert.html': dict(
        ColorModeOut=u'[ColorModeOut r/w mbbo] The output color mode (NDColorMode_t).',
        FalseColor=u'''[FalseColor r/w mbbo]
          The false color map index. There are currently 2 false color maps defined, Rainbow
          and Iron. Additional color maps can easily be added in the future.''',
        ),  # end of NDPluginColorConvert.html


    'pvcamDoc.html': dict(
        NumImages=u'[NumImages] Controls the number of images to acquire when ADImageMode is ADImageMultiple.',
        Initialize=u'[Initialize r/w longout] Initializes the detector',
        Slot1_RBV=u'[Slot1_RBV r stringin] String describing 1st found detector',
        Slot2_RBV=u'[Slot2_RBV r stringin] String describing 2nd found detector',
        Slot3_RBV=u'[Slot3_RBV r stringin] String describing 3rd found detector',
        DetecorSelected=u'[DetecorSelected r/w longout] Index of selected detector',
        ChipName_RBV=u'[ChipName_RBV r stringin] String describing CCD chip',
        NumParallelPixels_RBV=u'[NumParallelPixels_RBV r longin] Parallel size of the CCD in active rows',
        NumSerialPixels_RBV=u'[NumSerialPixels_RBV r longin] Serial size of the CCD',
        PixelParallelSize_RBV=u'[PixelParallelSize_RBV r longin] Size of the pixel in parallel direction in nanometers',
        PixelSerialSize_RBV=u'[PixelSerialSize_RBV r longin] Size of the pixel in Serial direction in nanometers',
        ChipHeight_RBV=u'[ChipHeight_RBV r longin] Height of CCD in mm',
        ChipWidth_RBV=u'[ChipWidth_RBV r longin] Width of CCD in mm',
        PixelParallelDist_RBV=u'[PixelParallelDist_RBV r longin] Pixel-to-pixel distance, in parallel direction, in nanometers',
        PixelSerialDist_RBV=u'[PixelSerialDist_RBV r longin] Pixel-to-pixel distance, in serial direction, in nanometers',
        PostMask_RBV=u'[PostMask_RBV r longin] ',
        PreMask_RBV=u'[PreMask_RBV r longin] ',
        PostScan_RBV=u'[PostScan_RBV r longin] ',
        PreScan_RBV=u'[PreScan_RBV r longin] ',
        NumPorts_RBV=u'[NumPorts_RBV r longin] ',
        FullWellCapacity_RBV=u'[FullWellCapacity_RBV r longin] ',
        FrameTransferCapable_RBV=u'[FrameTransferCapable_RBV r longin] ',
        NumSpeedTableEntries_RBV=u'[NumSpeedTableEntries_RBV r longin] ',
        SpeedTableIndex=u'[SpeedTableIndex r/w longout] ',
        BitDepth_RBV=u'[BitDepth_RBV r longin] ',
        PixelTime_RBV=u'[PixelTime_RBV r longin] ',
        GainIndex=u'[GainIndex r longin] ',
        MaxGainIndex_RBV=u'[MaxGainIndex_RBV r longin] ',
        MinShutterOpenDelay_RBV=u'[MinShutterOpenDelay_RBV r longin] ',
        MaxShutterOpenDelay_RBV=u'[MaxShutterOpenDelay_RBV r longin] ',
        MinShutterCloseDelay_RBV=u'[MinShutterCloseDelay_RBV r longin] ',
        MaxShutterCloseDelay_RBV=u'[MaxShutterCloseDelay_RBV r longin] ',
        OpenDelay=u'[OpenDelay r/w longout] ',
        CloseDelay=u'[CloseDelay r/w longout] ',
        MeasuredTemperature_RBV=u'[MeasuredTemperature_RBV r longin] ',
        MinSetTemperature=u'[MinSetTemperature r longin] ',
        MaxSetTemperature=u'[MaxSetTemperature r longin] ',
        SetTemperature=u'[SetTemperature r/w longin] ',
        DetectorMode=u'[DetectorMode r/w longin] ',
        TriggerMode=u'[TriggerMode r/w longin] ',
        TriggerEdge=u'[TriggerEdge r/w longin] ',
        CameraFirmwareVers_RBV=u'[CameraFirmwareVers_RBV r longin] ',
        PCIFWVers_RBV=u'[PCIFWVers_RBV r longin] ',
        HeadSerialNum_RBV=u'[HeadSerialNum_RBV r longin] ',
        SerialNum_RBV=u'[SerialNum_RBV r longin] ',
        PVCamVers_RBV=u'[PVCamVers_RBV r longin] ',
        DevDrvVers_RBV=u'[DevDrvVers_RBV r longin] ',
        ),  # end of pvcamDoc.html


    'andorDoc.html': dict(
        TriggerMode=u'''[TriggerMode]
          Sets the trigger mode for the detector. Options are:

            Internal
            External
            External Start
            External Exposure
            External FVP
            Software''',
        ImageMode=u'''[ImageMode]
          Sets the image mode for the detector. Options are:

            Single
            Multiple
            Continuous
            Fast Kinetics

          The relation of ImageMode to the Andor acquisition modes are given in the table
          below.''',
        NumExposures=u'''[NumExposures]
          Sets the number of accumulations (performed in software in Andor's driver) in Single
          and Multiple modes''',
        NumImages=u'[NumImages] Sets the number of images to take in multiple (Kinetics Series) mode',
        AcquirePeriod=u'''[AcquirePeriod]
          Sets the time between images in Multiple (Kinetics Series) and Continuous (Run Till
          Abort) modes''',
        Gain=u'''[Gain]
          Sets the pre-amp gain of the detector. For the Andor driver the Gain is treated
          as an integer index into the supported gain table of the specific detector. The
          list of supported gains for the detector gain be found by typing "asynReport 1,ANDOR"
          at the IOC prompt. For example, on the iKon-M the relationship is:

            Gain=0 Andor gain=1.0
            Gain=1 Andor gain=2.0
            Gain=2 Andor gain=4.0''',
        DataType=u'''[DataType]
          Sets data type for reading out the detector. Allowed values are:

            UInt16
            UInt32

          UInt16 can be used when reading out a 16-bit detector with NumExposures=1, (i.e.
          without accumulations), or when one can be sure that multiple accumulations will
          not overflow 16 bits. UInt32 should be used for 32-bit detectors or when multiple
          accumulations could cause 16-bit overflow.''',
        Temperature=u'[Temperature] Sets the setpoint temperature of the CCD (-120C to 20C)',
        TemperatureActual=u'[TemperatureActual] Reads the actual temperature of the CCD',
        FileFormat=u'''[FileFormat]
          Selects the file format for saving files with the Andor driver. Choices are:

            TIFF
            BMP
            SIF
            EDF
            RAW
            SPE

          All of the file formats except SPE are written by the Andor SDK. The SPE file format
          is written directly by the driver. It uses version 3.0 of the SPE format, which
          includes XML metadata after the image data. Only the SPE format is able to save
          the wavelength calibration from the Shamrock spectrographs.''',
        AndorCooler=u'[AndorCooler R/W bo] Turn the CCD cooler on and off',
        AndorTempStatus_RBV=u'[AndorTempStatus_RBV R/O waveform] Temperature status message.',
        AndorMessage_RBV=u'[AndorMessage_RBV R/O waveform] Other status message.',
        AndorShutterMode=u'''[AndorShutterMode R/W mbbo]
          Selects the Andor shutter mode. Choices are:

            Auto
            Open''',
        AndorShutterExTTL=u'''[AndorShutterExTTL R/W bo]
          Selects the TTL polarity of an external shutter. Choices are:

            Low To Open
            High To Open''',
        PALFilePath=u'''[PALFilePath R/W waveform]
          Path and Filename of pallette file (used for TIFF and BMP file colours) (255 chars
          max).''',
        AndorADCSpeed=u'''[AndorADCSpeed R/W mbbo]
          Switch between the slow (low noise) ADC and the fast ADC. Choices are:

            0.05 MHz
            2.5 MHz''',
        AndorAccumulatePeriod=u'''[AndorAccumulatePeriod R/W ao]
          Controls the period between accumulations when ImageMode=Single or Multiple and
          NumExposures>1. NOTE: Some Andor detectors (including the iKon) only support
          a single period when doing multiple accumulations in kinetic series mode. For these
          cameras ANDOR_ACCUMULATE_PERIOD has no effect, ACQUIRE_PERIOD determines the time
          between accumulations, and the time between images is 0, i.e. the next image starts
          as soon as the previous one is complete.''',
        AndorAccumulatePeriodActual=u'''[AndorAccumulatePeriodActual R/O ai]
          Reads the actual value of AndorAccumulatePeriod, which may differ from the requested
          value due to timing limitations of the detector.''',
        AndorAcquireTimeActual=u'''[AndorAcquireTimeActual R/O ai]
          Reads the actual value of ADAcquireTime, which may differ from the requested value
          due to timing limitations of the detector.''',
        AndorAcquirePeriodActual=u'''[AndorAcquirePeriodActual R/O ai]
          Reads the actual value of ADAcquirePeriod, which may differ from the requested value
          due to timing limitations of the detector.''',
        Grating=u'[Grating R/W mbbo] Selects the grating to use',
        Wavelength=u'[Wavelength R/W ao] Selects the central wavelength',
        Calibration=u'[Calibration R/O bi] Array containing the wavelength calibration of each X pixel of the detector in nm.',
        ),  # end of andorDoc.html


    'LightFieldDoc.html': dict(
        ImageMode=u'''[ImageMode]
          The driver redefines the choices for the ADImageMode parameter (record $(P)$(R)ImageMode)
          from ADDriver.h. The choices for the LightField are:

            Normal: This is the same as pressing the Acquire button in LightField. It may
              collect more than 1 accumulation per image if numAccumulations>1, more than 1
              exposure per image if NumExposures>1, more than 1 image per acquisition if NumImages>1,
              and more than 1 aquisition if NumAcquisitions>1.
            Preview: This is the same as pressing the Preview button in LightField. It causes
              acquisition to proceed as quickly as possible. It does not save the data.
            Background: This will cause the driver to acquire a background image to be used
              when background subtraction is enabled.''',
        NumExposures=u'[NumExposures] Controls the number of exposures that LightField will sum into a single image.',
        NumImages=u'[NumImages] Controls the number of images to acquire into a single 3-D data set.',
        Gain=u'''[Gain]
          The precision of the $(P)$(R)Gain record is changed to 0 because the gain in LightField
          is an integer. Allowed values are detector dependent, but 1 and 2 are typically
          supported.''',
        NumAccumulations=u'[NumAccumulations r/w longout] The number of on-chip accumulations to perform per image.',
        NumAcquisitions=u'''[NumAcquisitions r/w longout]
          The number of acquisitions to perform when acquisition is started. This controls
          the number of iterations in the outermost acquisition loop explained above. NOTE:
          This is not yet implemented, it is planned for a future release.''',
        NumAcquisitionsCounter_RBV=u'[NumAcquisitionsCounter_RBV r/o longin] The number of acquisitions performed so far.',
        LFGain=u'''[LFGain r/w mbbo]
          The camera gain. This parameter is used instead of the base class ADGain parameter
          so that it can be displayed as a menu as LightField does.''',
        LFShutterMode=u'''[LFShutterMode r/w mbbo]
          The shutter operating mode for shutters controlled by LightField. Allowed values
          are:

            Normal: The detector shutter will be opened and closed normally for each exposure.
            Always closed: The shutter will be kept closed. Useful for taking a dark current
              image.
            Always open: The shutter will be kept open. Useful if the light source is a strobe
              so the shutter is not needed.
            Open before trigger: The detector shutter will be opened before the trigger.''',
        LFExperimentName=u'''[LFExperimentName r/w mbbo]
          Selects the LightField experiment, which is a set of experimental conditions including
          the selected camera, etc. The record choices are constructed at run-time based on
          the experiment files currently available.''',
        LFUpdateExperiments=u'''[LFUpdateExperiments r/w bo]
          Updates the choices in the LFExperimentName records. This is only needed if a new
          experiment is created after the EPICS IOC is started.''',
        LFGrating=u'''[LFGrating r/w mbbo]
          Selects the spectrometer grating. The record choices are constructed at run-time
          based on the gratings actually available.''',
        LFGratingWavelength=u'[LFGratingWavelength r/w ao] Selects the center wavelength of the spectrometer.',
        LFEntranceWidth=u'[LFEntranceWidth r/w longout] Selects the entrance width of the side port on the spectrometer in microns.',
        LFExitPort=u'''[LFExitPort r/w mbbo]
          Selects the exit port of the spectrometer. Choices are:


            Side
            Front''',
        LFFilePath_RBV=u'[LFFilePath_RBV r/o waveform] The actual file path for saving data.',
        LFFileName_RBV=u'[LFFileName_RBV r/o waveform] The actual file name for saving data.',
        LFBackgroundPath=u'[LFBackgroundPath r/w waveform] The file path to use for saving background data.',
        LFBackgroundFile=u'[LFBackgroundFile r/w waveform] The file name to use for saving background data.',
        LFBackgroundFullFile_RBV=u'[LFBackgroundFullFile_RBV r/o waveform] The actual full file name for saving background data.',
        LFBackgroundEnable=u'[LFBackgroundEnable r/w bo] Enable background correction.',
        LFIntensifierEnable=u'[LFIntensifierEnable r/w bo] Enable image intensifier.',
        LFIntensifierGain=u'[LFIntensifierGain r/w ao] Image intensifier gain.',
        LFGatingMode=u'''[LFGatingMode r/w mbbo]
          Image intensifier gating mode. Choices are:


            Repetitive
            Sequential''',
        LFTriggerFrequency=u'[LFTriggerFrequency r/w ao] Selects the intensifier trigger frequency.',
        LFSyncMasterEnable=u'[LFSyncMasterEnable r/w bo] Enable sync master.',
        LFSyncMaster2Delay=u'[LFSyncMaster2Delay r/w ao] Selects the sync master 2 delay.',
        LFRepGateWidth=u'[LFRepGateWidth r/w ao] Selects the repetitive gate width.',
        LFRepGateDelay=u'[LFRepGateDelay r/w ao] Selects the repetitive gate delay.',
        LFSeqStartGateWidth=u'[LFSeqStartGateWidth r/w ao] Selects the sequential start gate width.',
        LFSeqStartGateDelay=u'[LFSeqStartGateDelay r/w ao] Selects the sequential start gate delay.',
        LFSeqEndGateWidth=u'[LFSeqEndGateWidth r/w ao] Selects the sequential end gate width.',
        LFSeqEndGateDelay=u'[LFSeqEndGateDelay r/w ao] Selects the sequential end gate delay.',
        LFAuxWidth=u'[LFAuxWidth r/w ao] Selects the auxiliary width.',
        LFAuxDelay=u'[LFAuxDelay r/w ao] Selects the auxiliary delay.',
        ReadyToRun=u'[ReadyToRun r/o bi] Flag indicating if LighField is ready to collect data.',
        ),  # end of LightFieldDoc.html


    'BrukerDoc.html': dict(
        NumImages=u'[NumImages] Controls the number of images to acquire when ADImageMode is ADImageMultiple.',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images when ADImageMode is ADImageMultiple or ADImageContinuous.
          If this is greater than the acquisition time plus readout overhead then the driver
          will wait until the period has elapsed before starting the next acquisition.''',
        FilePath=u'''[FilePath]
          Controls the path for saving images. It must be a valid path for BIS and
          for the areaDetector driver, which is normally running in an EPICS IOC. Normally
          BIS and the EPICS IOC are run on the same machine so this is not an issue. Running
          the IOC on another machine is difficult because Windows does not support soft links
          that could be used to make the paths look identical.
          The terminator at the end of FilePath must be a "\" character, it cannot
          be a "/" character, because BIS only recognizes the "\".''',
        FileFormat=u'[FileFormat] BIS only supports Bruker format SRFM files.',
        FrameType=u'''[FrameType]
          The driver redefines the choices for the ADFrameType parameter (record $(P)$(R)FrameType)
          from ADDriver.h. The choices for the BIS driver are:

            Normal (corrected data frame without double correlation)
            Dark (NumDarks background frames with same exposure time)
            Raw (data frame without correction for background)
            DblCorrelation (two images each collected for half the nominal acquisition time,
              zingers removed by double correlation)''',
        ReadSFRMTimeout=u'[ReadSFRMTimeout r/w ao] The timeout waiting for the SFRM file to appear.',
        BISStatus=u'[BISStatus r/w waveform] The status string returned from BIS.',
        NumDarks=u'[NumDarks r/w longout] The number of dark fields to collect when ADFrameType=Dark.',
        ),  # end of BrukerDoc.html


    'simDetectorDoc.html': dict(
        GainX=u'[GainX r/w ao] Gain in the X direction',
        GainY=u'[GainY r/w ao] Gain in the Y direction',
        GainRed=u'[GainRed r/w ao] Gain of the red channel',
        GainGreen=u'[GainGreen r/w ao] Gain of the green channel',
        GainBlue=u'[GainBlue r/w ao] Gain of the blue channel',
        Reset=u'[Reset r/w longout] Set to 1 to reset image back to initial conditions',
        SimMode=u'''[SimMode r/w longout]
          Sets the simulation mode. Options are:

            Linear Ramp
            Array of Peaks''',
        PeakStartX=u'[PeakStartX r/w longout] X location of the first peak centroid',
        PeakStartY=u'[PeakStartY r/w longout] Y location of the first peak centroid',
        PeakWidthX=u'[PeakWidthX r/w longout] X width of the peaks',
        PeakWidthY=u'[PeakWidthY r/w longout] Y width of the peaks',
        PeakNumX=u'[PeakNumX r/w longout] Number of peaks in X direction',
        PeakNumY=u'[PeakNumY r/w longout] Number of peaks in Y direction',
        PeakStepX=u'[PeakStepX r/w longout] X step between peaks',
        PeakStepY=u'[PeakStepY r/w longout] Y location of the first peak centroid',
        PeakVariation=u'''[PeakVariation r/w longout]
          Used to introduce randomness in the peak height. Each gaussian peak in the array
          is assigned a scaling factor.
          scalingFactor = 1.0 + (rand()%peakVariation +1)/100.0''',
        Noise=u'''[Noise r/w longout]
          Used to introduce randomness. Each affected pixel is assigned a scaling factor.
          scalingFactor = 1.0 + (rand()%noise +1)/100.0''',
        ),  # end of simDetectorDoc.html


    'URLDriverDoc.html': dict(
        AcquirePeriod=u'''[AcquirePeriod]
          This controls the period between reading images. The driver attempts to collected
          images at this rate determined by this value. NOTE: If this value is set to 0 or
          too small a value can result in the driver using 100% of the CPU and becoming unresponsive
          to EPICS.''',
        URLName1=u'''[URLName1 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName2=u'''[URLName2 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName3=u'''[URLName3 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName4=u'''[URLName4 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName5=u'''[URLName5 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName6=u'''[URLName6 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName7=u'''[URLName7 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName8=u'''[URLName8 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName9=u'''[URLName9 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        URLName10=u'''[URLName10 r/w waveform]
          The name of the URL to read images from. There are 10 output records to control
          the URL name.''',
        ),  # end of URLDriverDoc.html


    'NDPluginAttribute.html': dict(
        ArrayData_RBV=u'''[ArrayData_RBV r/o waveform]
          Attribute data as a 1-D array, possibly converted in data type from that in the NDArray
          object to the specific asyn interface.''',
        AttrName=u'[AttrName r/w waveform] The name of the NDAttribute parameter that we want to publish. This can be modified at runtime.',
        AttrName_RBV=u'[AttrName_RBV r/w waveform] The name of the NDAttribute parameter that we want to publish. This can be modified at runtime.',
        UpdatePeriod=u'[UpdatePeriod r/w ao] Update period for the array data (in seconds).',
        UpdatePeriod_RBV=u'[UpdatePeriod_RBV r/w ai] Update period for the array data (in seconds).',
        Value_RBV=u'[Value_RBV r/o ai] Attribute value',
        ValueSum_RBV=u'[ValueSum_RBV r/o ai] Sum of the attribute value, since the last reset.',
        Reset=u'[Reset r/w bo] Reset the plugin data. This zeros the array, and resets the value sum and value to zero. This will also automatically reset the plugin ArrayCounter.',
        Update=u'[Update r/w bo] Update the array with the latest attribute values collected by the plugin. This may be necessary at the end of an acqusition if the update period is none zero, in order to take into account the last few data points that may have arried since the last callback to the plugin.',
        ),  # end of NDPluginAttribute.html


    'areaDetectorDoc.html': dict(
        PortName_RBV=u'[PortName_RBV r/o stringin] asyn port name',
        DataType=u'[DataType r/w mbbo] Data type (NDDataType_t).',
        ColorMode=u'[ColorMode r/w mbbo] Color mode (NDColorMode_t).',
        ArraySizeX_RBV=u'[ArraySizeX_RBV r/o longin] Size of the array data in the X direction',
        ArraySizeY_RBV=u'[ArraySizeY_RBV r/o longin] Size of the array data in the Y direction',
        ArraySizeZ_RBV=u'[ArraySizeZ_RBV r/o longin] Size of the array data in the Z direction',
        ArraySize_RBV=u'[ArraySize_RBV r/o longin] Total size of the array data in bytes',
        FilePath=u'[FilePath r/w waveform] File path',
        FilePathExists_RBV=u'[FilePathExists_RBV r/o bi] Flag indicating if file path exists',
        FileName=u'[FileName r/w waveform] File name',
        FileNumber=u'[FileNumber r/w longout] File number',
        FileTemplate=u'''[FileTemplate r/w waveform]
          Format string for constructing NDFullFileName from NDFilePath, NDFileName, and NDFileNumber.
          The final file name (which is placed in NDFullFileName) is created with the following
          code:
          epicsSnprintf(
    FullFilename,
    sizeof(FullFilename),
    FileTemplate, FilePath,
    Filename, FileNumber);

          FilePath, Filename, FileNumber are converted in that order with FileTemplate. An
          example file format is "%s%s%4.4d.tif". The first %s converts the FilePath,
          followed immediately by another %s for Filename. FileNumber is formatted with %4.4d,
          which results in a fixed field with of 4 digits, with leading zeros as required.
          Finally, the .tif extension is added to the file name. This mechanism for creating
          file names is very flexible. Other characters, such as _ can be put in Filename
          or FileTemplate as desired. If one does not want to have FileNumber in the file
          name at all, then just omit the %d format specifier from FileTemplate. If the client
          wishes to construct the complete file name itself, then it can just put that file
          name into NDFileTemplate with no format specifiers at all, in which case NDFilePath,
          NDFileName, and NDFileNumber will be ignored.''',
        FullFileName_RBV=u'[FullFileName_RBV r/o waveform] Full file name constructed using the algorithm described in NDFileTemplate',
        AutoIncrement=u'''[AutoIncrement r/w bo]
          Auto-increment flag. Controls whether FileNumber is automatically incremented by
          1 each time a file is saved (0=No, 1=Yes)''',
        AutoSave=u'''[AutoSave r/w bo]
          Auto-save flag (0=No, 1=Yes) controlling whether a file is automatically saved each
          time acquisition completes.''',
        FileFormat=u'[FileFormat r/w mbbo] File format. The format to write/read data in (e.g. TIFF, netCDF, etc.)',
        WriteFile=u'[WriteFile r/w busy] Manually save the most recent array to a file when value=1',
        ReadFile=u'[ReadFile r/w busy] Manually read a file when value=1',
        FileWriteMode=u'[FileWriteMode r/w mbbo] File saving mode (Single, Capture, Stream)(NDFileMode_t)',
        FileWriteStatus=u'''[FileWriteStatus r/o mbbi]
          File write status. Gives status information on last file open or file write operation.
          Values are WriteOK (0) and WriteError (1).''',
        FileWriteMessage=u'''[FileWriteMessage r/o waveform]
          File write error message. An error message string if the previous file open or file
          write operation resulted in an error.''',
        Capture=u'[Capture r/w busy] Start (1) or stop (0) file capture or streaming',
        NumCapture=u'[NumCapture r/w longout] Number of frames to acquire in capture or streaming mode',
        NumCaptured_RBV=u'[NumCaptured_RBV r/o longin] Number of arrays currently acquired capture or streaming mode',
        DeleteDriverFile=u'''[DeleteDriverFile r/w bo]
          Flag to enable deleting original driver file after a plugin has re-written the file
          in a different format. This can be useful for detectors that must write the data
          to disk in order for the areaDetector driver to read it back. Once a file-writing
          plugin has rewritten the data in another format it can be desireable to then delete
          the original file.''',
        LazyOpen=u'''[LazyOpen r/w bo]
          Flag to defer the creation of a new file until the first NDArray to write has been
          received. This removes the need for passing an extra NDArray through the file writing
          plugin to initialise dimensions and possibly NDAttribute list before opening the
          file. The downside is that file creation can potentially be time-consuming so processing
          the first NDArray may be slower than subsequent ones.

          Only makes sense to use with file plugins which support multiple frames per file
          and only in "Stream" mode.''',
        ArrayCallbacks=u'''[ArrayCallbacks r/w bo]
          Controls whether the driver does callbacks with the array data to registered plugins.
          0=No, 1=Yes. Setting this to 0 can reduce overhead in the case that the driver is
          being used only to control the device, and not to make the data available to plugins
          or to EPICS clients.''',
        ArrayCounter=u'''[ArrayCounter r/w longout]
          Counter that increments by 1 each time an array is acquired. Can be reset by writing
          a value to it.''',
        ArrayRate_RBV=u'[ArrayRate_RBV r/o calc] Rate at which arrays are being acquired. Computed in the ADBase.template database.',
        NDAttributesFile=u'''[NDAttributesFile r/w waveform]
          The name of an XML file defining the PVAttributes and paramAttributes to be added
          to each NDArray by this driver or plugin. The format of the XML file is described
          in the documentation for
            asynNDArrayDriver::readNDAttributesFile().''',
        PoolMaxMem=u'[PoolMaxMem r/o ai] The maximum number of NDArrayPool memory bytes that can be allocated. 0=unlimited.',
        PoolUsedMem=u'''[PoolUsedMem r/o ai]
          The number of NDArrayPool memory bytes currently allocated. The SCAN rate of this
          record controls the scanning of all of the dynamic NDArrayPool status records.''',
        PoolMaxBuffers=u'[PoolMaxBuffers r/o longin] The maximum number of NDArrayPool buffers that can be allocated. 0=unlimited.',
        PoolAllocBuffers=u'[PoolAllocBuffers r/o longin] The number of NDArrayPool buffers currently allocated.',
        PoolFreeBuffers=u'[PoolFreeBuffers r/o longin] The number of NDArrayPool buffers currently allocated but free.',
        PoolUsedBuffers=u'''[PoolUsedBuffers r/o calc]
          The number of NDArrayPool buffers currently in use. This is calculated as NDPoolAllocBuffers
          - NDPoolFreeBuffers.''',
        AsynIO=u'[AsynIO N/A asyn] asyn record to control debugging (asynTrace)',
        Manufacturer_RBV=u'[Manufacturer_RBV r/o stringin] Detector manufacturer name',
        Model_RBV=u'[Model_RBV r/o stringin] Detector model name',
        MaxSizeX_RBV=u'[MaxSizeX_RBV r/o longin] Maximum (sensor) size in the X direction',
        MaxSizeY_RBV=u'[MaxSizeY_RBV r/o longin] Maximum (sensor) size in the Y direction',
        Temperature=u'[Temperature r/w ao] Detector temperature',
        Temperature_Actual=u'[Temperature_Actual r/o ai] Actual detector temperature',
        Gain=u'[Gain r/w ao] Detector gain',
        BinX=u'[BinX r/w longout] Binning in the X direction',
        BinY=u'[BinY r/w longout] Binning in the Y direction',
        MinX=u'''[MinX r/w longout]
          First pixel to read in the X direction.

          0 is the first pixel on the detector.''',
        MinY=u'''[MinY r/w longout]
          First pixel to read in the Y direction.
          0 is the first pixel on the detector.''',
        SizeX=u'[SizeX r/w longout] Size of the region to read in the X direction',
        SizeY=u'[SizeY r/w longout] Size of the region to read in the Y direction',
        ReverseX=u'''[ReverseX r/w longout]
          Reverse array in the X direction
          (0=No, 1=Yes)''',
        ReverseY=u'''[ReverseY r/w longout]
          Reverse array in the Y direction
          (0=No, 1=Yes)''',
        ImageMode=u'[ImageMode r/w mbbo] Image mode (ADImageMode_t).',
        TriggerMode=u'[TriggerMode r/w mbbo] Trigger mode (ADTriggerMode_t).',
        FrameType=u'[FrameType r/w mbbo] Frame type (ADFrameType_t).',
        AcquireTime=u'[AcquireTime r/w ao] Acquisition time per image',
        AcquirePeriod=u'[AcquirePeriod r/w ao] Acquisition period between images',
        NumExposures=u'[NumExposures r/w longout] Number of exposures per image to acquire',
        NumImages=u'[NumImages r/w longout] Number of images to acquire in one acquisition sequence',
        Acquire=u'''[Acquire r/w busy]
          Start (1) or stop (0) image acquisition. This is an EPICS busy record that does
          not process its forward link until acquisition is complete. Clients should write
          1 to the Acquire record to start acquisition, and wait for Acquire to go to 0 to
          know that acquisition is complete.''',
        DetectorState_RBV=u'[DetectorState_RBV r/o mbbi] Acquisition status (ADStatus_t)',
        StatusMessage_RBV=u'[StatusMessage_RBV r/o waveform] Status message string',
        StringToServer_RBV=u'[StringToServer_RBV r/o waveform] String from driver to string-based vendor server',
        StringFromServer_RBV=u'[StringFromServer_RBV r/o waveform] String from string-based vendor server to driver',
        NumExposuresCounter_RBV=u'''[NumExposuresCounter_RBV r/o longin]
          Counter that increments by 1 each time an exposure is acquired for the current image.
          Driver resets to 0 when acquisition is started.''',
        NumImagesCounter_RBV=u'''[NumImagesCounter_RBV r/o longin]
          Counter that increments by 1 each time an image is acquired in the current acquisition
          sequence. Driver resets to 0 when acquisition is started. Drivers can use this as
          the loop counter when ADImageMode=ADImageMultiple.''',
        TimeRemaining_RBV=u'''[TimeRemaining_RBV r/o ai]
          Time remaining for current image. Drivers should update this value if they are doing
          the exposure timing internally, rather than in the detector hardware.''',
        ReadStatus=u'''[ReadStatus r/w bo]
          Write a 1 to this parameter to force a read of the detector status. Detector drivers
          normally read the status as required, so this is usually not necessary, but there
          may be some circumstances under which forcing a status read may be needed.''',
        ShutterMode=u'[ShutterMode r/w mbbo] Shutter mode (None, detector-controlled or EPICS-controlled) (ADShutterMode_t)',
        ShutterControl=u'[ShutterControl r/w bo] Shutter control for the selected (detector or EPICS) shutter (ADShutterStatus_t)',
        ShutterControlEPICS=u'''[ShutterControlEPICS r/w bi]
          This record processes when it receives a callback from the driver to open or close
          the EPICS shutter. It triggers the records below to actually open or close the EPICS
          shutter.''',
        ShutterOpenEPICS=u'''[ShutterOpenEPICS r/w calcout]
          This record writes its OVAL field to its OUT field when the EPICS shutter is told
          to open. The OCAL (and hence OVAL) and OUT fields are user-configurable, so any
          EPICS-controllable shutter can be used.''',
        ShutterCloseEPICS=u'''[ShutterCloseEPICS r/w calcout]
          This record writes its OVAL field to its OUT field when the EPICS shutter is told
          to close. The OCAL (and hence OVAL) and OUT fields are user-configurable, so any
          EPICS-controllable shutter can be used.''',
        ShutterStatus_RBV=u'[ShutterStatus_RBV r/o bi] Status of the detector-controlled shutter (ADShutterStatus_t)',
        ShutterStatusEPICS_RBV=u'''[ShutterStatusEPICS_RBV r/o mbbi]
          Status of the EPICS-controlled shutter. This record should have its input link (INP)
          set to a record that contains the open/close status information for the shutter.
          The link should have the "CP" attribute, so this record processes when the input
          changes. The ZRVL field should be set to the value of the input link when the shutter
          is closed, and the ONVL field should be set to the value of the input link when
          the shutter is open.''',
        ShutterOpenDelay=u'[ShutterOpenDelay r/w ao] Time required for the shutter to actually open (ADShutterStatus_t)',
        ShutterCloseDelay=u'[ShutterCloseDelay r/w ao] Time required for the shutter to actually close (ADShutterStatus_t)',
        ),  # end of areaDetectorDoc.html


    'roperDoc.html': dict(
        ImageMode=u'''[ImageMode]
          The driver redefines the choices for the ADImageMode parameter (record $(P)$(R)ImageMode)
          from ADDriver.h. The choices for the Roper are:

            Normal: This is the same as pressing the Acquire button in WinView. It may collect
              more than 1 exposure per image if NumExposures>1, more than 1 image per acquisition
              if NumImages>1, and more than 1 aquisition if NumAcquisitions>1.
            Continuous: This will cause the driver to perform acquisitions indefinitely, i.e.
              it acts as if NumAcquisitions is infinite.
            Focus: This is the same as pressing the Focus button in WinView. It causes acquisition
              to proceed as quickly as possible. It does not save the data. It currently does
              not call the callbacks for each frame, so the images can only be seen in WinView
              and not in EPICS. This may be fixed in a future release.''',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images when ADImageMode is Continuous. If this is greater
          than the acquisition time plus readout overhead then the driver will wait until
          the period has elapsed before starting the next acquisition.''',
        NumExposures=u'[NumExposures] Controls the number of exposures (accumulations) to acquire into a single image.',
        NumImages=u'[NumImages] Controls the number of images to acquire into a single 3-D data set.',
        TriggerMode=u'''[TriggerMode]
          The driver redefines the choices for the ADTriggerMode parameter (record $(P)$(R)TriggerMode)
          from ADDriver.h. The choices for the Roper are:

            Free run: This acquires images as quickly as possible given the exposure and readout
              times.
            Ext. sync: This acquires one image for each external trigger pulse.
            Bulb trig.: The exposure time is determined by the external trigger pulse width.

            Single trig.: A single external trigger pulse will acquire an entire sequence
              of images.''',
        FileFormat=u'''[FileFormat]
          The driver redefines the choices for the NDFileFormat parameter (record $(P)$(R)FileFormat)
          from asynNDArrayDriver.h. The choices for the Roper are:

            SPE: This is the default file format for WinView. It is a binary format with a
              header containing all of the acquisition and setup information.
            TIFF: TIFF files that contain the full resolution of the image data. The TIFF
              files do not contain any acquisition or setup information.
            8-bit TIFF: 8-bit TIFF files that contain limited resolution image data. The TIFF
              files do not contain any acquisition or setup information.

          The driver does not automatically change the file extension (.SPE, .TIFF, etc.)
          when the FileFormat is changed, the user should do this using the FileTemplate record.''',
        Gain=u'''[Gain]
          The precision of the $(P)$(R)Gain record is changed to 0 because the gain in WinView
          is an integer. Allowed values are detector dependent, but 1 and 2 are typically
          supported.''',
        NumAcquisitions=u'''[NumAcquisitions r/w longout]
          The number of acquisitions to perform when acquisition is started. This controls
          the number of iterations in the outermost acquisition loop explained above.''',
        NumAcquisitionsCounter_RBV=u'[NumAcquisitionsCounter_RBV r/o longin] The number of acquisitions performed so far.',
        AutoDataType=u'''[AutoDataType r/w bo]
          A flag controlling whether WinView will automatically chose the optimal data type
          for the image data. 0=No, 1=Yes. If this flag is 1 then the NDDataType parameter
          ($(P)$(R)DataType record) is ignored. If this flag is 0 then the NDDataType parameter
          controls the data type of the images.''',
        RoperShutterMode=u'''[RoperShutterMode r/w mbbo]
          The shutter operating mode for shutters controlled by WinView. Allowed values are:

            Normal: The detector shutter will be opened and closed normally for each exposure.
            Disabled closed: The shutter will be forced closed. Useful for taking a dark current
              image.
            Disabled open: The shutter will be forced open.''',
        Comment1=u'''[Comment1 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment2=u'''[Comment2 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment3=u'''[Comment3 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment4=u'''[Comment4 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment5=u'''[Comment5 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        ),  # end of roperDoc.html


    'pluginDoc.html': dict(
        PortName_RBV=u'[PortName_RBV r/o stringin] asyn port name',
        PluginType_RBV=u'[PluginType_RBV r/o stringin] A string describing the plugin type.',
        NDArrayPort=u'''[NDArrayPort r/w stringout]
          asyn port name for NDArray driver that will make callbacks to this plugin. This
          port can be changed at run time, connecting the plugin to a different NDArray driver.''',
        NDArrayAddress=u'''[NDArrayAddress r/w longout]
          asyn port address for NDArray driver that will make callbacks to this plugin. This
          address can be changed at run time, connecting the plugin to a different address
          in the NDArray driver.''',
        QueueSize=u'[QueueSize r/o longin] The total queue size for callbacks when BlockingCallbacks=0.',
        QueueFree=u'[QueueFree r/o longin] The number of free queue elements.',
        QueueUse=u'[QueueUse r/o calc] The number of used queue elements.',
        PoolMaxMem=u'[PoolMaxMem r/o ai] The maximum amount of NDArrayPool memory this plugin is allowed to allocate.',
        PoolUsedMem=u'[PoolUsedMem r/o ai] The actual amount of NDArrayPool memory this plugin is currently using.',
        PoolMaxBuffers=u'[PoolMaxBuffers r/o longin] The maximum number of NDArrays this plugin is allowed to allocate.',
        PoolAllocBuffers=u'[PoolAllocBuffers r/o longin] The number of NDArrays this plugin has currently allocated.',
        PoolFreeBuffers=u'[PoolFreeBuffers r/o longin] The number of free NDArrays this plugin has in its NDArrayPool.',
        PoolUsedBuffers=u'''[PoolUsedBuffers N/A calc]
          The number of used NDArrays this plugin has in its NDArrayPool. Calculated from
          PoolAllocBuffers and PoolFreeBuffers.''',
        EnableCallbacks=u'''[EnableCallbacks r/w bo]
          Enable (1) or disable (0) callbacks from the driver to this plugin. If callbacks
          are disabled then the plugin will normally be idle and consume no CPU resources.''',
        BlockingCallbacks=u'''[BlockingCallbacks r/w bo]
          0 = callbacks from the driver do not block; the NDArray data is put on a queue and
          the callback processes in its own thread.

          1 = callbacks from the driver block; the callback processes in the driver callback
          thread.''',
        MinCallbackTime=u'''[MinCallbackTime r/w ao]
          The minimum time in seconds between calls to processCallbacks. Any callbacks occuring
          before this minimum time has elapsed will be ignored. 0 means no minimum time, i.e.
          process all callbacks.''',
        ArrayCounter=u'[ArrayCounter r/w longout] Counter that increments by 1 each time an NDArray callback is processed',
        ArrayRate_RBV=u'[ArrayRate_RBV r/o calc] Rate (Hz) at which ArrayCounter is incrementing. Computed in database.',
        DroppedArrays=u'''[DroppedArrays r/w longout]
          Counter that increments by 1 each time an NDArray callback occurs when NDPluginDriverBlockingCallbacks=0
          and the plugin driver queue is full, so the callback cannot be processed.''',
        NDimensions_RBV=u'[NDimensions_RBV r/o longin] Number of dimensions in last NDArray callback data',
        Dimensions_RBV=u'[Dimensions_RBV r/o waveform] Dimensions in last NDArray callback data',
        ArraySize0_RBV=u'[ArraySize0_RBV r/o longin] First dimension of NDArray callback data',
        ArraySize1_RBV=u'[ArraySize1_RBV r/o longin] Second dimension of NDArray callback data',
        ArraySize2_RBV=u'[ArraySize2_RBV r/o longin] Third dimension of NDArray callback data',
        DataType_RBV=u'[DataType_RBV r/o mbbi] Data type of last NDArray callback data (NDDataType_t).',
        ColorMode_RBV=u'[ColorMode_RBV r/o mbbi] Color mode of last NDArray callback data (NDColorMode_t).',
        BayerPattern_RBV=u'[BayerPattern_RBV r/o mbbi] BayerPattern of last NDArray callback data (NDBayerPattern_t).',
        UniqueId_RBV=u'[UniqueId_RBV r/o longin] Unique ID number of last NDArray callback data',
        TimeStamp_RBV=u'[TimeStamp_RBV r/o ai] Time stamp number of last NDArray callback data',
        NDAttributesFile=u'''[NDAttributesFile r/w waveform]
          The name of an XML file defining the PVAttributes and paramAttributes to be added
          to each NDArray by this plugin. The format of the XML file is described in the documentation
          for asynNDArrayDriver::readNDAttributesFile().''',
        AsynIO=u'[AsynIO N/A asyn] asyn record to control debugging (asynTrace)',
        ),  # end of pluginDoc.html


    'NDPluginROI.html': dict(
        Name=u'[Name r/w stringout] Name of this ROI',
        EnableX=u'''[EnableX r/w bo]
          Enable ROI calculations in the X dimension. If not enabled then the start, size,
          binning, and reverse operations are disabled in the X dimension, and the values
          from the input array are used.''',
        EnableY=u'''[EnableY r/w bo]
          Enable ROI calculations in the Y dimension. If not enabled then the start, size,
          binning, and reverse operations are disabled in the Y dimension, and the values
          from the input array are used.''',
        EnableZ=u'''[EnableZ r/w bo]
          Enable ROI calculations in the Z dimension. If not enabled then the start, size,
          binning, and reverse operations are disabled in the Z dimension, and the values
          from the input array are used.''',
        BinX=u'[BinX r/w longout] Binning in the X dimension',
        BinY=u'[BinY r/w longout] Binning in the Y dimension',
        BinZ=u'[BinZ r/w longout] Binning in the Z dimension',
        MinX=u'[MinX r/w longout] First pixel in the ROI in the X dimension. 0 is the first pixel in the array.',
        MinY=u'''[MinY r/w longout]
          First pixel in the ROI in the Y dimension.
          0 is the first pixel in the array.''',
        MinZ=u'''[MinZ r/w longout]
          First pixel in the ROI in the Z dimension.
          0 is the first pixel in the array.''',
        SizeX=u'[SizeX r/w longout] Size of the ROI in the X dimension',
        SizeY=u'[SizeY r/w longout] Size of the ROI in the Y dimension',
        SizeZ=u'[SizeZ r/w longout] Size of the ROI in the Z dimension',
        AutoSizeX=u'[AutoSizeX r/w bo] Automatically set SizeX to the input array size minus MinX',
        AutoSizeY=u'[AutoSizeY r/w bo] Automatically set SizeY to the input array size minus MinY',
        AutoSizeZ=u'[AutoSizeZ r/w bo] Automatically set SizeZ to the input array size minus MinZ',
        MaxSizeX_RBV=u'[MaxSizeX_RBV r/o longin] Maximum size of the ROI in the X dimension',
        MaxSizeY_RBV=u'[MaxSizeY_RBV r/o longin] Maximum size of the ROI in the Y dimension',
        MaxSizeZ_RBV=u'[MaxSizeZ_RBV r/o longin] Maximum size of the ROI in the Z dimension',
        ReverseX=u'[ReverseX r/w longout] Reverse ROI in the X dimension. (0=No, 1=Yes)',
        ReverseY=u'[ReverseY r/w longout] Reverse ROI in the Y dimension. (0=No, 1=Yes)',
        ReverseZ=u'[ReverseZ r/w longout] Reverse ROI in the Z dimension. (0=No, 1=Yes)',
        DataType=u'''[DataType r/w mbbo]
          Data type of the ROI (NDDataType_t). This can be different from the data type of
          the NDArray callback data.''',
        ArraySizeX_RBV=u'[ArraySizeX_RBV r/o longin] Size of the ROI data in the X dimension',
        ArraySizeY_RBV=u'[ArraySizeY_RBV r/o longin] Size of the ROI data in the Y dimension',
        ArraySizeZ_RBV=u'[ArraySizeZ_RBV r/o longin] Size of the ROI data in the Z dimension',
        EnableScale=u'''[EnableScale r/w bo]
          Enable dividing by the Scale value. (0=Disable, 1=Enable). This is very useful when
          binning or when converting from a higher precision data type to a lower precision
          data type. For example when binning 2x2, then Scale=4 (dividing by 4) will prevent
          integer overflow. Similarly, when converting from 16-bit to 8-bit integers one might
          scale by 256, or perhaps a smaller number if the 16-bit data does not use the full
          16-bit range.''',
        Scale=u'[Scale r/w ao] The scale value to divide by if EnableScale is enabled.',
        ),  # end of NDPluginROI.html


    'PerkinElmerDoc.html': dict(
        NumImages=u'[NumImages] Controls the number of images to acquire when ADImageMode is Multiple or Average',
        AcquireTime=u'''[AcquireTime]
          When using Internal Triggers, this parameter controls the period between trigger
          pulses which will also be equal to the exposure time.''',
        TriggerMode=u'''[TriggerMode]
          Sets the trigger mode for the detector. Options are:

            Internal
            External
            Free Running
            Soft Trigger''',
        ImageMode=u'''[ImageMode]
          Sets the trigger mode for the detector. Options are:

            Single
            Multiple
            Continuous
            Average. This mode is new for the Perkin Elmer. It averages NumImages frames in
              the hardware frame grabber. It is useful when the total acquisition time is longer
              than the 5 second maximum allowed in Internal trigger mode, etc.''',
        PENumFrameBuffers=u'[PENumFrameBuffers r/w longout] Number of software frame buffers to use',
        PEInitialize=u'[PEInitialize w longout] Initialize the detector',
        PE_STATUS_RBV=u'[PE_STATUS_RBV r/w mbbi] Status of PerkinElmer driver. SHOULD DELETE THIS AND JUST USE DETECTOR STATE.',
        PESystemID=u'[PESystemID r/w longin] PROM ID # used in communication with Perkin Elmer',
        PETrigger=u'[PETrigger w longout] Trigger record for soft trigger mode',
        PEFrameBuffIndex=u'''[PEFrameBuffIndex r longout]
          Frame number from the hardware frame buffer for this image. Values go from 1 to
          8.''',
        PEImageNumber=u'[PEImageNumber r longout] Image number for this image in the software frame buffer array.',
        PENumOffsetFrames=u'[PENumOffsetFrames r/w longout] Number of frames to collect and average when collecting offset frames',
        PECurrentOffsetFrame=u'[PECurrentOffsetFrame r longin] Current offset frame being collected when collecting offset frames',
        PEAcquireOffset=u'[PEAcquireOffset r/w busy] Acquire offset frames',
        PEUseOffset=u'[PEUseOffset r/w mbbo] Set whether offset image is to be used. Choices are "Disable" (0) and "Enable" (1).',
        PEOffsetAvailable=u'''[PEOffsetAvailable r mbbi]
          Report whether offset image has been collected and is available for use. Choices
          are "Not available" (0) and "Available" (1).''',
        PENumGainFrames=u'[PENumGainFrames r/w longout] Number of frames to collect and average when collecting gain frames',
        PECurrentGainFrame=u'[PECurrentGainFrame r longin] Current gain frame being collected when collecting gain frames',
        PEAcquireGain=u'[PEAcquireGain w busy] Acquire gain frames',
        PEUseGain=u'[PEUseGain w mbbo] Set whether gain image is to be used. Choices are "Disable" (0) and "Enable" (1).',
        PEGainAvailable=u'''[PEGainAvailable r mbbi]
          Report whether offset image has been collected and is available for use. Choices
          are "Not available" (0) and "Available" (1).''',
        PEUsePixelCorrection=u'[PEUsePixelCorrection w mbbo] Set whether bad pixel correction is to be used',
        PEPixelCorrectionAvailable=u'[PEPixelCorrectionAvailable r mbbi] Report whether pixel correction file has been set and is available for use',
        PEBadPixelFile=u'[PEBadPixelFile w waveform] File name for bad pixel file',
        PECorrectionsDir=u'[PECorrectionsDir r/w waveform] Directory where corrections files should be stored',
        PELoadCorrections=u'[PELoadCorrections w longout] Load offset and gain corrections from a file for use',
        PESaveCorrections=u'[PESaveCorrections w longout] Save offset and gain corrections to a file',
        ),  # end of PerkinElmerDoc.html


    'andor3Doc.html': dict(
        TriggerMode=u'''[TriggerMode]
          Sets the trigger mode for the detector. Options for the Neo are:

            Internal
            Software
            External
            External Start
            External Exposure
            Advanced''',
        ImageMode=u'''[ImageMode]
          Sets the image mode for the detector. Options are:

            Fixed
            Continuous

          Fixed counts collects NumImages images, continuous acquires continuously until acquisition
          is stopped.''',
        NumExposures=u'''[NumExposures]
          Sets the number of accumulations per image. This is performed in Andor's driver,
          not on the chip.''',
        NumImages=u'[NumImages] Sets the number of images to take when ImageMode=Fixed.',
        AcquirePeriod=u'''[AcquirePeriod]
          Sets the FrameRate (=1./AcquirePeriod). The FrameRate can also be set directly.
          The minimum AcquirePeriod (maximum FrameRate) depends on a number of other parameters,
          including the A3Binning, SizeX, SizeY, ReadoutRate, A3ShutterMode, PixelEncoding,
          and Overlap.''',
        DataType=u'''[DataType]
          The data type for the image data. Allowed values are:

            UInt16
            UInt32

          The DataType is selected automatically, based upon the PixelEncoding record. The
          data type will be UInt32 if PixelEncoding is Mono32, and UInt16 for all other values
          of PixelEncoding. PixelEncoding=Mono32 can be used when A3Binning > 1x1, or when
          multiple accumulations (NumExposures > 1) could cause 16-bit overflow.''',
        Temperature=u'[Temperature] Sets the setpoint temperature of the camera.',
        TemperatureActual=u'[TemperatureActual] Reads the actual temperature of the camera.',
        SerialNumber=u'[SerialNumber R/O stringin] Camera serial number',
        FirmwareVersion=u'[FirmwareVersion R/O stringin] Camera firmware version',
        SoftwareVersion=u'[SoftwareVersion R/O stringin] SDK software version',
        ControllerID=u'[ControllerID R/O stringin] Camera controller ID',
        SensorCooling=u'[SensorCooling R/W bo] Turn the sensor cooler on and off',
        TempStatus_RBV=u'''[TempStatus_RBV R/O mbbi]
          Temperature status. Values and strings on the Neo are:

            0 = Cooler Off
            1 = Stabilized
            2 = Cooling
            3 = Drift
            4 = Not Stabilized
            5 = Fault''',
        TempControl=u'''[TempControl R/W mbbo]
          Temperature setpoint value in degrees C. On the cooled cameras (e.g. Neo) the temperature
          is set to discrete values, rather than continuously with the Temperature record,
          because the firmware does pixel corrections for specific temperatures. Choices on
          the Neo are:

            0 = -15
            1 = -20
            2 = -25
            3 = -30
            4 = -35
            5 = -40''',
        FanSpeed=u'''[FanSpeed R/W mbbo]
          Fan speed. Choices on the Neo are:

            0 = Off
            1 = Low
            2 = On''',
        A3ShutterMode=u'''[A3ShutterMode R/W mbbo]
          Selects the shutter mode. Choices for the Neo are:

            0 = Rolling
            1 = Global

          Rolling shutter mode interleaves exposure and readout. This is the fastest readout
          mode, but means that each row of the sensor acquires data for a different time period.
          In Rolling mode the exposure time is determined by the row readout time, and cannot
          be independently controlled. In Global mode all pixels acquire for the same time
          period and are then read out. The exposure time is independent of the readout time,
          and can be as short as 9 microseconds on the Neo.''',
        FrameRate=u'''[FrameRate R/W ao]
          Frame rate. This is the reciprocal of ADAcquirePeriod, and is the units used to
          control the Andor cameras. There are two limitations on the frame rate:

            The maximum rate that the sensor can be read out into the RAM on the camera head.
              The driver will limit the FrameRate to this value in all cases. This value can be
              obtained for the current acquisition settings by typing "asynReport 1" to get a
              detailed report from the Andor3 driver.
            The maximum sustained frame transfer rate that the interface (e.g. CameraLink
              card) can support. This value is contained in the TransferRate PV. It is permissible
              to exceed this value for a limited number of frames, allowing the frames to accumulate
              in the camera head RAM. The number of frames that will fit in the camera head RAM
              is controlled by the PixelEncoding and the AOI parameters (A3Binning, SizeX, SizeY).
              If the camera head RAM fills up the acquisition will hang, and must be stopped and
              restarted.''',
        TransferRate=u'''[TransferRate R/O ai]
          The maximum transfer rate in frames/s of the interface (e.g. CameraLink card). This
          is the maximum sustained FrameRate which can be achieved.''',
        PreAmpGain=u'''[PreAmpGain R/W mbbo]
          Controls the pre-amp gain and readout mode. Choices for the Neo are:

            0 = 11-bit (high well capacity)
            1 = 11-bit (low noise)
            2 = 16-bit (low noise & high well capacity)''',
        PixelEncoding=u'''[PixelEncoding R/W mbbo]
          Controls the pixel encoding. Choices for the Neo are:

            0 = Mono12
            1 = Mono12Packed
            2 = Mono16
            9 = Mono32

          Mono12 and Mono12Packed are only available when PreAmpGain is one of the 11-bit
          modes.''',
        ReadoutRate=u'''[ReadoutRate R/W mbbo]
          Controls the ADC readout rate. Choices for the Neo are:

            0 = 100 MHz
            1 = 200 MHz
            2 = 280 MHz''',
        ReadoutTime=u'[ReadoutTime R/O ai] The readout time from the sensor into camera RAM.',
        Overlap=u'''[Overlap R/W bo]
          Controls whether acquisition and readout are overlapped. Choices are 0 (No) and
          1 (Yes). On the Neo if Overlap=Yes then the minimum exposure time is limited to
          about 10 ms. If Overlap=No then the minimum exposure time is 9 microseconds.''',
        NoiseFilter=u'''[NoiseFilter R/W bo]
          Controls whether the firmware applies the Spurious Noise Filter. Choices are 0 (No)
          and 1 (Yes).''',
        SoftwareTrigger=u'[SoftwareTrigger R/W bo] Writing 1 to this record generates a software trigger if TriggerMode=Software.',
        FullAOIControl=u'[FullAOIControl R/O bi] Indicates whether this camera supports full AOI control. This is Yes for the Neo.',
        A3Binning=u'''[A3Binning R/W mbbo]
          Controls the binning. The binning on the sCMOS camera is done in firmware and only
          certain preset values are allowed. Choices for the Neo are:

            0 = 1x1
            1 = 2x2
            2 = 3x3
            3 = 4x4
            4 = 8x8''',
        ),  # end of andor3Doc.html


    'NDPluginOverlay.html': dict(
        Name=u'[Name r/w stringout] Name for this overlay.',
        Use=u'[Use r/w bo] Flag indicating whether to use (enable) this overlay. 0=No, 1=Yes.',
        PositionX=u'[PositionX r/w longout] The X position of this overlay.',
        PositionXLink=u'''[PositionXLink r/w longout]
          Link to fetch the desired X position of this overlay. The .DOL field of this record
          can be set to another record which will then change PositionX whenever the other
          record updates. The link must have the "CP" attribute, so that this record
          processes whenever the record it is linked to changes. For example, the link could
          be set to "13PS1:Stats1:CentroidX_RBV CP NMS" to fetch its position from the X centroid
          calculated by an NDPluginStats plugin, or to "13PS1:ROI1:MinX_RBV CP MS" to fetch
          its position from the X position of an ROI. If this link field is blank or points
          to a non-existent record then the X position of the overlay can be manually controlled.
          Note that this linking is done entirely in the EPICS database, and not in the plugin
          code.''',
        PositionY=u'[PositionY r/w longout] The Y position of this overlay.',
        PositionYLink=u'''[PositionYLink r/w longout]
          Link to fetch the desired Y position of this overlay. See the notes for PositionXLink
          above.''',
        SizeX=u'[SizeX r/w longout] The X size of this overlay.',
        SizeXLink=u'''[SizeXLink r/w longout]
          Link to fetch the desired X size of this overlay. See the notes for PositionXLink
          above.''',
        SizeY=u'[SizeY r/w longout] The Y size of this overlay.',
        SizeYLink=u'''[SizeYLink r/w longout]
          Link to fetch the desired Y size of this overlay. See the notes for PositionXLink
          above.''',
        WidthX=u'''[WidthX r/w longout]
          The X line width of this overlay. For the cross overlay this will increase the width
          of the line on both sides at the same time, to maintain the central point of the
          cross. For the rectangle overlay the line thickness will grow inwards to the center.
          For both overlay types widths >1 are restricted to even numbers; odd widths >1
          are decreased by 1.''',
        WidthXLink=u'''[WidthXLink r/w longout]
          Link to fetch the desired X line width of this overlay. See the notes for PositionXLink
          above.''',
        WidthY=u'[WidthY r/w longout] The Y line width of this overlay. This behaves in the same way as the OverlayWidthX.',
        WidthYLink=u'''[WidthYLink r/w longout]
          Link to fetch the desired Y line width of this overlay. See the notes for PositionXLink
          above.''',
        Shape=u'''[Shape r/w mbbo]
          The shape of this overlay. Choices are:

            0="Cross"
            1="Rectangle"
            2="Text"

          Other shapes may be added in the future. The PositionX and PositionY position of
          a cross defines the location of the center of the cross. The SizeX and SizeY of
          a cross is the size on either side of the center, i.e. the total width = 2*OverlaySizeX.
          This is done so when HOPR for the SizeX and SizeY records is set to the total image
          size, the cross can be the total size of the image no matter where it is positioned.
          The PositionX and PositionY of a rectangle defines the lower left corner of the
          rectangle. SizeX and SizeY of a rectangle define total width and height. These definitions
          are consistent with the way ROIs are defined in the NDPluginROI plugin. The XPosition
          and YPosition of the text overlay defines the lower left corner of the text. The
          SizeX and SizeY are ignored for the text overlay, the size is defined by the text
          string and the font.''',
        DrawMode=u'''[DrawMode r/w mbbo]
          The operation to use when drawing this overlay. Choices are:

            0="Set"
            1="XOR"

          In Set mode the Red, Green, and Blue values (Green for mono images) are written
          directly into the pixel values. In XOR mode the value in the pixel is XOR'ed with
          the Red, Green, and Blue values. XOR operation typically results in an overlay that
          has better visibility no matter what the values of the surrounding pixels, while
          Set mode with Green=255, for example, will show up well on dark areas of the image,
          but will be hard to see in bright areas of the image. Note that XOR is not supported
          for NDFloat32 or NDFloat64 data types directly, but they are cast to int if XOR
          is selected for arrays with those data types.''',
        Red=u'[Red r/w longout] The red value to use when drawing the overlay. This is only used for color images.',
        Green=u'''[Green r/w longout]
          The green value to use when drawing the overlay. This is the value that is used
          for monochrome images as well.''',
        Blue=u'[Blue r/w longout] The blue value to use when drawing the overlay. This is only used for color images.',
        DisplayText=u'[DisplayText r/w waveform] The text string to write for this overlay if Shape="Text".',
        TimeStampFormat=u'''[TimeStampFormat r/w stringout]
          The format string to use when outputting the EPICS time stamp (epicsTS) field of
          the NDArray in the text overlay. Default="%Y-%m-%d %H:%M:%S.%03f". Any of the components
          of the format can be omitted to suppress the display of that field.''',
        Font=u'''[Font r/w mbbo]
          The font to use for the text display. Choices are:

            0="6x13"
            1="6x13 Bold"
            2="9x15"
            3="9x15 Bold"''',
        ),  # end of NDPluginOverlay.html


    'NDFileHDF5.html': dict(
        XMLFileName=u'''[XMLFileName r/w waveform]
          XML filename, pointing to an XML HDF5 Layout Definition
          This waveform also supports loading raw XML code directly; up to a maximum of 1MB
          long (NELM=1MB)''',
        XMLValid_RBV=u'''[XMLValid_RBV r/o bi]
          Flag to report the validity (xml syntax only) of the loaded XML. Updated when the
          XMLFileName is updated with a new filename and when the XML file is read at HDF5
          file creation''',
        XMLErrorMsg_RBV=u'[XMLErrorMsg_RBV r/o waveform] XML parser error message',
        NumRowChunks=u'''[NumRowChunks r/w longout]
          Configure HDF5 "chunking" to approriate size for the filesystem: sets
          number of rows to use per chunk''',
        NumColChunks=u'''[NumColChunks r/w longout]
          Configure HDF5 "chunking" to approriate size for the filesystem: sets
          number of columns to use per chunk''',
        NumFramesChunks=u'''[NumFramesChunks r/w longout]
          Configure HDF5 "chunking" to approriate size for the filesystem: sets
          number of frames to use per chunk. For a 2D image, setting this parameter > 1 essentially
          implies using in-memory cache as HDF5 only writes full chunks to disk.''',
        BoundaryAlign=u'''[BoundaryAlign r/w longout]
          Set the disk boundary alignment in bytes. This parameter can be used to optimise
          file I/O performance on some file systems. For instance on the Lustre file system
          where the it is optimal to align data to the 'stripe size' (default 1MB).

          This parameter applies to all datasets in the file.

          Setting this parameter to 0 disables use of disk boundary alignment.

          Warning: setting this parameter to a larger size than the size of a single chunk
            will cause datafiles to grow larger than the actual contained data.''',
        BoundaryThreshold=u'''[BoundaryThreshold r/w longout]
          Set a minimum size (bytes) of chunk or dataset where boundary alignment is to be
          applied. This can be used to filter out small datasets like NDAttributes from the
          boundary alignment as it could blow up the file size.

          Setting this parameter to 0 will disable the use of boundary alignment''',
        StoreAttr=u'[StoreAttr r/w bo] Enable or disable support for storing NDArray attributes in file',
        StorePerform=u'[StorePerform r/w bo] Enable or disable support for storing file IO timing measurements in file',
        NumFramesFlush=u'''[NumFramesFlush r/w longout]
          Flush the file metadata to disk every N'th frame. Image data is written to disk
          on every write operation, but HDF5 internal metadata to describe the data layout
          and indices is normally only written at close time.''',
        NumExtraDims=u'[NumExtraDims r/w mbbo] Number of extra dimensions [0..2]',
        ExtraDimSizeN=u'[ExtraDimSizeN r/w] Size of extra dimension N (no. of frames per point)',
        ExtraDimSizeX=u'[ExtraDimSizeX r/w longout] Size of extra dimension X',
        ExtraDimSizeY=u'[ExtraDimSizeY r/w longout] Size of extra dimension Y',
        Runtime=u'[Runtime r/o ai] Total runtime in seconds from first frame to file closed',
        IOSpeed=u'[IOSpeed r/o ai] Overall IO write speed in megabit per second from first frame to file closed',
        Compression=u'[Compression r/w mbbo] Select or switch off compression filter',
        NumDataBits=u'[NumDataBits r/w longout] N-bit compression filter: number of data bits per pixel',
        DataBitsOffset=u'[DataBitsOffset r/w longout] N-bit compression filter: dataword bit-offset in pixel',
        SZipNumPixels=u'[SZipNumPixels r/w longout] szip compression filter: number of pixels in filter [1..32]',
        ZLevel=u'[ZLevel r/w longout] zlib compression filter: compression level [1..9]',
        ),  # end of NDFileHDF5.html


    'NDPluginStats.html': dict(
        ComputeStatistics=u'''[ComputeStatistics r/w bo]
          Flag to control whether to compute statistics for this array (0=No, 1=Yes). Not
          computing statistics reduces CPU load. Basic statistics computations are quite fast,
          since they involve mostly double precision addition, with 1 multiply to compute
          sigma, per array element.''',
        BgdWidth=u'''[BgdWidth r/w longout]
          Width of the background in pixels to use when computing net counts. 0=no background
          subtraction, so the net counts is the same as the total counts.''',
        MinValue_RBV=u'[MinValue_RBV r/o ai] Minimum value in any element in the array',
        MinX_RBV=u'''[MinX_RBV r/o ai]
          X pixel location of minimum value in the array. This is only valid for 2-D monochromatic
          arrays.''',
        MinY_RBV=u'''[MinY_RBV r/o ai]
          Y pixel location of minimum value in the array. This is only valid for 2-D monochromatic
          arrays.''',
        MaxValue_RBV=u'[MaxValue_RBV r/o ai] Maximum value in any element in the array',
        MaxX_RBV=u'''[MaxX_RBV r/o ai]
          X pixel location of maximum value in the array. This is only valid for 2-D monochromatic
          arrays.''',
        MaxY_RBV=u'''[MaxY_RBV r/o ai]
          Y pixel location of maximum value in the array. This is only valid for 2-D monochromatic
          arrays.''',
        MeanValue_RBV=u'[MeanValue_RBV r/o ai] Mean value in the array',
        Total_RBV=u'''[Total_RBV r/o ai]
          Sum (total) of all elements in the array. This is available as an ai record. The
          total counts are also available as epicsInt32 values in an mca record via callbacks
          to the drvFastSweep driver. The mca record is very useful for on-the-fly data acquisition
          of the total counts in the detector or in an ROI.''',
        TotalArray=u'''[TotalArray r/o mca]
          Sum (total) of all elements in the array. This is available as an ai record. The
          total counts are also available as epicsInt32 values in an mca record via callbacks
          to the drvFastSweep driver. The mca record is very useful for on-the-fly data acquisition
          of the total counts in the detector or in an ROI.''',
        Net_RBV=u'''[Net_RBV r/o ai]
          Net (background subtracted) total of all elements in the array. The background is
          calculated by determining the average counts per array element in a border around
          the array of width NDPluginStatsBgdWidth. This average background counts per element
          is then subtracted from all elements inside the array. If NDPluginStatsBgdWidth
          is ≤ 0 then no background is computed. The net counts is available as an ai record.
          The net counts is also available as epicsInt32 values in an mca record via callbacks
          to the drvFastSweep driver. The mca record is very useful for on-the-fly data acquisition
          of the net counts in the detector or in an ROI.''',
        NetArray=u'''[NetArray r/o mca]
          Net (background subtracted) total of all elements in the array. The background is
          calculated by determining the average counts per array element in a border around
          the array of width NDPluginStatsBgdWidth. This average background counts per element
          is then subtracted from all elements inside the array. If NDPluginStatsBgdWidth
          is ≤ 0 then no background is computed. The net counts is available as an ai record.
          The net counts is also available as epicsInt32 values in an mca record via callbacks
          to the drvFastSweep driver. The mca record is very useful for on-the-fly data acquisition
          of the net counts in the detector or in an ROI.''',
        Sigma_RBV=u'[Sigma_RBV r/o ai] Sigma (standard deviation) of all elements in the array',
        ComputeCentroid=u'''[ComputeCentroid r/w bo]
          Flag to control whether to compute the centroid statistics (0=No, 1=Yes). The centroids
          are computed from the average row and column profiles above the centroid threshold.
          These calculations are also quite fast, since they just involve addition operations
          for each array element.''',
        CentroidThreshold=u'''[CentroidThreshold r/w ao]
          Threshold used when computing the centroid statistics. All array elements less than
          this value are set to 0 for computing the centroid statistics. It is important to
          set this value to ignore the "background" when computing the position and size of
          a "beam" image, for example.''',
        CentroidX_RBV=u'[CentroidX_RBV r/o ai] X centroid of the array above the centroid threshold.',
        CentroidY_RBV=u'[CentroidY_RBV r/o ai] Y centroid of the array above the centroid threshold.',
        SigmaX_RBV=u'[SigmaX_RBV r/o ai] Sigma X (width) of the distribution above the centroid threshold.',
        SigmaY_RBV=u'[SigmaY_RBV r/o ai] Sigma Y (height) of the distribution above the centroid threshold.',
        SigmaXY_RBV=u'''[SigmaXY_RBV r/o ai]
          This is the normalized value of sigmaXY, i.e. sigmaXY/(sigmaX * sigmaY). This is
          often called the correlation coefficient, r. It is zero if the X and Y profiles
          are not correlated, meaning that the distribution is not tilted with respect to
          the X and Y axes.''',
        TSControl=u'''[TSControl r/w mbbo]
          Controls time-series data collection. The enum choices are:

            Erase/Start: Clears all time-series arrays, sets TS_CURRENT_POINT=0, and starts
              time-series data collection.
            Start: Starts time-series data collection without clearing arrays or modifying
              TS_CURRENT_POINT. Used to restart collection after a Stop operation.
            Stop: Stops times-series data collection. Performs callbacks on all time-series
              waveform records.

            Read: Performs callbacks on all time-series waveform records, updating the values.''',
        TSRead=u'''[TSRead r/w longout]
          Sends the "Read" command to the TSControl record above. This record can be periodically
          processed to update the time-series waveform records. It is scan disabled if TSAcquiring=Done,
          so that updates are only performed when time-series acquisition is in progress.''',
        TSNumPoints=u'''[TSNumPoints r/w longout]
          Controls the number of time-series points to collect. There is no maximum value,
          the time-series arrays in the plugin are freed and reallocated each time this value
          is changed. However, the size of the waveform records is fixed when the IOC is started,
          so NELM in those records must be large enough for the largest time-series needed.''',
        TSCurrentPoint=u'''[TSCurrentPoint r/o longin]
          The current time-series point. If TSCurrentPoint reaches TSNumPoints then time-series
          acquisition is automatically stopped, and callbacks are done on all time-series
          waveform records, updating the values. This means that even if TSRead has SCAN=Passive
          that the waveform records will update when time-series acquisition is complete.''',
        TSAcquiring=u'[TSAcquiring r/o bi] Indicates status of time-series data acquisition. Values are 0=Done and 1=Acquiring.',
        TSXXX=u'''[TSXXX r/o waveform]
          The time series data arrays. XXX is one of the following, corresponding to each
          of the basic statistics and centroid and sigma statistics described above:

            MinValue
            MinX
            MinY
            MaxValue
            MaxX
            MaxY
            MeanValue
            Sigma
            Total
            Net
            CentroidX
            CentroidY
            SigmaX
            SigmaY
            SigmaXY''',
        ComputeProfiles=u'[ComputeProfiles r/w bo] Flag to control whether to compute the profiles for this array (0=No, 1=Yes).',
        ProfileSizeX_RBV=u'[ProfileSizeX_RBV r/w longin] Number of array elements in the X profiles.',
        ProfileSizeY_RBV=u'[ProfileSizeY_RBV r/w longin] Number of array elements in the Y profiles.',
        CursorX=u'[CursorX r/w longout] X position of a user-defined cursor for profiles.',
        CursorY=u'[CursorY r/w longout] Y position of a user-defined cursor for profiles.',
        ProfileAverageX_RBV=u'''[ProfileAverageX_RBV r/o waveform]
          Profile of the average row in the array, i.e. the sum of all rows in the array divided
          by the number of rows.''',
        ProfileAverageY_RBV=u'''[ProfileAverageY_RBV r/o waveform]
          Profile of the average column in the array, i.e. the sum of all columns in the array
          divided by the number of columns.''',
        ProfileThresholdX_RBV=u'''[ProfileThresholdX_RBV r/o waveform]
          Same as ProfileAverageX except that all array elements less than CentroidThreshold
          are set to zero when computing the average.''',
        ProfileThresholdY_RBV=u'''[ProfileThresholdY_RBV r/o waveform]
          Same as ProfileAverageY except that all array elements less than CentroidThreshold
          are set to zero when computing the average.''',
        ProfileCentroidX_RBV=u'[ProfileCentroidX_RBV r/o waveform] X profile through the array in the row defined by CentroidY.',
        ProfileCentroidY_RBV=u'[ProfileCentroidY_RBV r/o waveform] Y profile through the array in the column defined by CentroidX.',
        ProfileCursorX_RBV=u'[ProfileCursorX_RBV r/o waveform] X profile through the array in the row defined by CursorY.',
        ProfileCursorY_RBV=u'[ProfileCursorY_RBV r/o waveform] Y profile through the array in the row defined by CursorX.',
        ComputeHistogram=u'''[ComputeHistogram r/w bo]
          Flag to control whether to compute the histogram for this array (0=No, 1=Yes). Not
          computing the histogram reduces CPU load.''',
        HistSize=u'[HistSize r/w longout] Number of elements (bins) in the histogram',
        HistMin=u'''[HistMin r/w ao]
          Minimum value for the histogram. All values less than or equal to this will be in
          the first bin of the histogram.''',
        HistMax=u'''[HistMax r/w ao]
          Maximum value for the histogram. All values greater than or equal to this will be
          in the last bin of the histogram.''',
        HistEntropy_RBV=u'''[HistEntropy_RBV r/o ai]
          Entropy of the image. This is a measure of the sharpness of the histogram, and is
          often a useful figure of merit for determining sharpness of focus, etc. It is defined
          as -SUM(BIN[i]*log(BIN[i]), where the sum is over the number of bins in the histogram
          and BIN[i] is the number of elements in bin i.''',
        Histogram_RBV=u'[Histogram_RBV r/o waveform] Histogram array, i.e. counts in each histogram bin.',
        ),  # end of NDPluginStats.html


    'MarCCDDoc.html': dict(
        FrameType=u'''[FrameType]
          The driver redefines the choices for the ADFrameType parameter (record $(P)$(R)FrameType)
          from ADDriver.h. The choices for the MarCCD are:

            Normal (corrected data frame without double correlation)
            Background (background frame with 0 exposure time, done with double correlation
              to remove zingers)
            Raw (data frame without correction for background or spatial distortion)
            DblCorrelation (two images each collected for half the nominal acquisition time,
              zingers removed by double correlation)''',
        ImageMode=u'''[ImageMode]
          The driver redefines the choices for the ADImageMode parameter (record $(P)$(R)ImageMode)
          from ADDriver.h.

            "Single" (aingle frame acquisition)
            "Multiple" (acquire ADNumImages images)
            "Continuous" (acquire images continuously until ADAcquire is set to 0)
            "Series triggered" (acquire a series of images using an external trigger signal)
            "Series timed" (acquire a series of images using the internal clock)

          "Series triggered" and "Series timed" are only supported for ServerMode=2 servers.''',
        TriggerMode=u'''[TriggerMode]
          The driver redefines the choices for the ADTriggerMode parameter (record $(P)$(R)TriggerMode)
          from ADDriver.h.

            Internal (Single frame acquisition)
            Frame (rising edge causes frame transfer/readout and start of next acquisition)
            Bulb (rising edge of trigger starts acquisition, falling edge causes frame transfer/readout)
            Timed (rising edge of trigger causes frame transfer/readout and each exposure lasts for time
                ADAcquireTime)

          ServerMode=1 servers only support "Internal", ServerMode=2 servers support all 4 modes.''',
        NumImages=u'[NumImages] Controls the number of images to acquire when ADImageMode is ADImageMultiple.',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images when ADImageMode is ADImageMultiple or ADImageContinuous.
          If this is greater than the acquisition time plus readout overhead then the driver
          will wait until the period has elapsed before starting the next acquisition.''',
        ReadStatus=u'''[ReadStatus]
          Writing 1 to this parameter causes the status to be read from the marccd server.
          By processing or periodically scanning this record the status information can be
          refreshed. This is normally not necessary, but if ADArrayCallbacks is 0 and marCCDOverlap
          is 1 then the status will not indicate that the system is idle when acquisition
          is complete, because the driver polling stops before the file is written. This record
          can be used to eliminate the confusion that might cause.''',
        FilePath=u'''[FilePath]
          Controls the path for saving images. It must be a valid path for marccd and
          for the areaDetector driver, which is normally running in an EPICS IOC. If marccd
          and the EPICS IOC are not running on the same machine then soft links will typically
          be used to make the paths look identical.''',
        FileFormat=u'[FileFormat] marccd only supports TIFF files.',
        ServerMode_RBV=u'''[ServerMode_RBV r/o longin]
          The version number of the server software running on the detector.  This is 1 for the
          servers running on non-HS detectors, and 2 for the servers running on HS detectors.''',
        MarState_RBV=u'''[MarState_RBV r/o longin]
          State word returned by marccd server. The low-order 4-bits of this word are the
          state of the marccd server, and will be Idle (0x0), Error (0x7), or Busy (0x8).
          The next 24 bits encode the state of the 6 server tasks (Acquire, Readout, Correct,
          Save, Dezinger, Series) with 4-bits per task. Each task can be in the state Idle (0x0),
          Queued (0x1), Executing (0x2), Error (0x4), or Reserved (0x8).''',
        MarStatus_RBV=u'[MarStatus_RBV r/o mbbi] Status of the marccd server task (Idle, Error, or Busy)',
        MarAcquireStatus_RBV=u'[MarAcquireStatus_RBV r/o mbbi] Status of the marccd server acquire task (Idle, Queued, Executing, Error, or Reserved)',
        MarReadoutStatus_RBV=u'[MarReadoutStatus_RBV r/o mbbi] Status of the marccd server readout task (Idle, Queued, Executing, Error, or Reserved)',
        MarCorrectStatus_RBV=u'[MarCorrectStatus_RBV r/o mbbi] Status of the marccd server correct task (Idle, Queued, Executing, Error, or Reserved)',
        MarWritingStatus_RBV=u'''[MarWritingStatus_RBV r/o mbbi]
          Status of the marccd server file writing task (Idle, Queued, Executing, Error, or
          Reserved)''',
        MarDezingerStatus_RBV=u'[MarDezingerStatus_RBV r/o mbbi] Status of the marccd server dezinger task (Idle, Queued, Executing, Error, or Reserved)',
        MarSeriesStatus_RBV=u'[MarSeriesStatus_RBV r/o mbbi] Status of the marccd server series acquisition task (Idle, Queued, Executing, Error, or Reserved).',
        OverlapMode=u'''[OverlapMode r/w bo]
          The marccd server has 5 tasks (Acquire, Readout, Correct, Write, Dezinger) that
          can overlap their operation. The areaDetector driver can exploit this to improve
          performance in some circumstances. If this parameter is set to 1 (Overlap) then
          the ADAcquire parameter will go to 0 (Done) when the Readout task is done executing,
          but before the Correct and Write tasks have finished correcting and saving the file
          to disk. This improves performance because the next image can begin as soon as ADAcquire
          goes to done, and hence before the previous image is written to disk. Note, however
          that this parameter must be set to 0 (Sequential) if callbacks are being used to
          compute statistics that are being used in data collection, e.g. in a scan. If this is
          not done then the statistics information will be grabbed before it is updated and incorrect
          scan data will result.''',
        FrameShift=u'''[FrameShift r/w longout]
          marccd can be used for time-resolved studies by collecting multiple data sets before
          reading out the detector. This is done by placing a mask in front of the detector
          that restricts the x-rays to horizontal stripe. An exposure is made, and then an
          external signal causes the detector to shift the image by the number of lines given
          by this parameter. A number of images separated by times of a few milliseconds can
          be collected, and then the detector is read out. Set this parameter to 0 to disable
          frameshift mode.''',
        SeriesFileTemplate=u'''[SeriesFileTemplate r/w waveform]
          The template for the file names written in trigger or timed series acquisition modes.
          The FilePath, FileName and FileNumber are combined into a string using this
          C format string.  This is used to construct a base file name.
          The actual file names in the series are constructed using this base file name plus
          the SeriesFileFirst and SeriesFileDigits records. Example: "%s%s_%3.3d"''',
        SeriesFileFirst=u'[SeriesFileFirst r/w longout] The number of the first file in a triggered or timed series acquisition.',
        SeriesFileDigits=u'[SeriesFileDigits r/w longout] The number of digits to use for the file numbers in triggered or timed series acquisition.',
        GateMode=u'''[GateMode r/w mbbo]
          The gating mode for the detector. Choices are:
          "None"
          "Gated"''',
        Stability=u'''[Stability r/w ao]
          The following text is from a document describing baseline stabilization from Rayonix.
          "Baseline stabilization is an optional addition to the marccd data collection software.
          This software option stabilizes the baseline offset level of each CCD image to a
          more accurate value than only the analog electronics provide. This feature is important
          in any type of measurement that requires comparisons between successive data frames
          that include, for example, subtracting (or adding) two data frames, such as one
          often must do in small angle scattering experiments. Baseline instability can make
          it appear that there are slightly more or slightly less X-rays across the entire
          detector (or readout channel) in a data frame. That is different than the read noise,
          which has no net effect on the average. A stable baseline is less critical for data
          analysis in which a background value is calculated by measuring the background around
          each individual spot on the same data frame (typically done in single crystal crystallography
          experiments). The baseline level of a CCD is usually established by measuring an
          analog voltage of the readout amplifier, and the "zero" level can drift over time
          due to ambient temperature changes or other electronic instability. The time scale
          on which the drift occurs is usually greater than about 20 minutes or so; therefore,
          the marccd software default for recollecting background images is every 20 minutes
          or once every data segment in a dataset. Expected baseline stability improvement
          Whereas the older MarCCD detectors had a baseline stability that was only good to
          about ±1-2 ADU, the SX Series and MX Series detectors have improved electronic
          baseline stability, closer to ±0.5 ADU. When this Baseline Stabilization
          software option is used, the baseline can be improved much further, with baseline
          stability as low as about ±0.01 ADU. CCD overscan The method of improving
          the baseline is by an overscan technique. When this option is "on", extra blank
          pixels are read out from the CCD after each line of the CCD is read out from the
          serial register. In the marccd program memory, a temporary data frame which is larger
          than the normal data frame is recorded, and the pixels outside the imaging area
          are used to compute the baseline. These blank pixels do not correspond to any real
          region of the CCD; they are just a result of telling the readout electronics to
          readout with no charge present.
          The user must also enter a target baseline stability value. This number represents
          the accuracy to which the program will try to stabilize the baseline, in ADU (analog-to-digital
          units). The resulting data frame will have a baseline value that is approximately
          the corrected_frame_bias, typically 10 or 100, plus or minus the target baseline
          stability value. For example, if the user enters 0.1, and the corrected_frame_bias
          is 10 (i.e. images with no X-rays normally have a baseline around 10 ADU), then
          a data frame with X-rays will result in a baseline value of approximately 10 ±0.1
          ADU (and each individual pixel will also have contributions due to X-rays and read
          noise). The accuracy limit of this software feature is about 0.01 ADU, so any target
          value entered between 0 and 0.01 is automatically converted to the limit, 0.01 ADU.
          Entering a target value of 0 is equivalent to turning off the baseline stabilization."''',
        ReadTiffTimeout=u'''[ReadTiffTimeout r/w ao]
          Timeout in seconds when reading a TIFF file. It should be set to several seconds,
          because there it can take some time for the marccd server to write the file.''',
        DetectorDistance=u'[DetectorDistance r/w ao] Distance from the sample to the detector (mm)',
        BeamX=u'[BeamX r/w ao] X position of the direct beam on the detector (mm)',
        BeamY=u'[BeamY r/w ao] Y position of the direct beam on the detector (mm)',
        StartPhi=u'[StartPhi r/w ao] Starting value of phi rotation (deg)',
        RotationAxis=u'[RotationAxis r/w stringout] Rotation axis being used (phi, omega, etc.)',
        RotationRange=u'[RotationRange r/w ao] Rotation range of the rotation axis.',
        TwoTheta=u'''[TwoTheta r/w ao]
          Detector two-theta angle (deg); requires theta axis definition with display name
          "TwoTheta" in a marccd configuration file (i.e. "theta_display_name TwoTheta").
          This configuration file is typically goniostat_none.conf or goniostat_sw.conf, but
          any configuration file that gets loaded can be used.''',
        Wavelength=u'[Wavelength r/w ao] Wavelength in Angstroms.',
        FileComments=u'[FileComments r/w waveform] Comments for this file.',
        DatasetComments=u'[DatasetComments r/w waveform] Comments for this dataset.',
        marSserverAsyn=u'[marSserverAsyn N/A asyn] asyn record to control debugging communication with marccd_server_socket program',
        ),  # end of MarCCDDoc.html


    'NDPluginProcess.html': dict(
        SaveBackground=u'''[SaveBackground r/w bo]
          Command to use the most recently acquired array as a background. Note that this
          recently acquired array should have been acquired with EnableBackground=0, or else
          that array will already have had the background subtracted, which is probably not
          what was intended!''',
        ValidBackground_RBV=u'''[ValidBackground_RBV r/o bi]
          Flag indicating whether there is a valid background array that has been acquired
          for this array using SaveBackground. This flag will be Invalid (0) if no background
          has been acquired, or if the size of the array has changed since the background
          was last acquired.''',
        EnableBackground=u'''[EnableBackground r/w bo]
          Flag indicating whether the background array acquired with SaveBackground should
          be subtracted when processing the array. If ValidBackground=0 then no background
          subtraction is done even if EnableBackground=Enable.''',
        SaveFlatField=u'''[SaveFlatField r/w bo]
          Command to use the most recently acquired array as a flat field. Note that this
          recently acquired array should have been acquired with EnableFlatField=0, or else
          that array will already have been flat field normalized, which is probably not what
          was intended!''',
        ValidFlatField_RBV=u'''[ValidFlatField_RBV r/o bi]
          Flag indicating whether there is a valid flat field array that has been acquired
          for this array using SaveFlatField. This flag will be Invalid (0) if no flat field
          has been acquired, or if the size of the array has changed since the flat field
          was last acquired.''',
        EnableFlatField=u'''[EnableFlatField r/w bo]
          Flag indicating whether the array should be divided by the flat field array (acquired
          with SaveFlatField) when processing the array. If ValidFlatField=0 then no flat
          field normalization is done even if EnableBackground=Enable. The processing step
          consists of:

          Array = Array / FlatField * ScaleFlatField''',
        ScaleFlatField=u'''[ScaleFlatField r/w ao]
          The scale factor to multiply by after dividing the array by the flat field array.
          This scale factor is normally chosen so that the data after scaling fills the dynamic
          range of the output data type.''',
        EnableOffsetScale=u'''[EnableOffsetScale r/w bo]
          Flag indicating whether the array should be multiplied by Scale and then summed
          with Offset when processing the array. The processing step consists of:

          Array = Array * Scale + Offset''',
        AutoOffsetScale=u'''[AutoOffsetScale r/w busy]
          Processing this record will enable Offset and Scale calculations, and set the Offset=-min(Array)
          and Scale=MaxScale/(max(Array)-min(Array)), where MaxScale is the maximum value
          of the output data type. The output array will thus be scaled to completely fill
          the range of the output data type. Note that the calculation of the offset and scale
          factors is only done once when this record is processed, and these values are used
          for subsequent array callbacks, i.e. it does not autoscale on each array callback.
          Thanks to Tom Cobb for this addition.''',
        Scale=u'[Scale r/w ao] The scale factor to multiply by.',
        Offset=u'[Offset r/w ao] The offset to add.',
        EnableLowClip=u'''[EnableLowClip r/w bo]
          Flag to control whether to clip values to the LowClip value for this array (0=Disable,
          1=Enable).''',
        LowClip=u'''[LowClip r/w ao]
          The minimum allowed value for this array. If EnableLowClip=1, then all values in
          the array less than LowClip will be replaced by LowClip.''',
        EnableHighClip=u'''[EnableHighClip r/w bo]
          Flag to control whether to clip values to the HighClip value for this array (0=Disable,
          1=Enable).''',
        HighClip=u'''[HighClip r/w ao]
          The maximum allowed value for this array. If EnableHighClip=1, then all values in
          the array greater than HighClip will be replaced by HighClip.''',
        DataTypeOut=u'''[DataTypeOut r/w mbbo]
          Data type of the output array (NDDataType_t). This can be different from the data
          type of the NDArray callback data.''',
        EnableFilter=u'''[EnableFilter r/w bo]
          Flag indicating whether the array should be processed with a recursive filter. The
          details of the filter operation are explained below.''',
        ResetFilter=u'[ResetFilter r/w bo] Command to reset the filter back to its initial state.',
        AutoResetFilter=u'''[AutoResetFilter r/w bo]
          If enabled then when NumFiltered=NumFilter the filter automatically resets. This
          can be very useful when using the Average or Sum filter modes. As soon as N sums
          or averages have been performed the filter resets, so the next sum or average is
          computed.''',
        FilterCallbacks=u'''[FilterCallbacks r/w bo]
          Choices are "Every array" and "Array N only". If "Every array" is selected then
          the plugin does callbacks for every incoming array it receives. If "Array N only"
          is selected then the plugin only does callbacks when NumFiltered=NumFilter. This
          can be very useful when using the Sum or Average filter modes. Callbacks are then
          done only when N sums or averages have been performed. If used with AutoResetFilter
          then as input arrays arrive the plugin will continually output one summed or averaged
          array after every N incoming arrays.''',
        NumFilter=u'''[NumFilter r/w longout]
          The characteristic number of arrays to use when filtering. The value of NumFiltered
          will increase as each array is processed, until it reaches the value of NumFilter,
          when it will no longer increase. The value of NumFiltered is used in the filter
          equations, as explained below.''',
        NumFiltered_RBV=u'''[NumFiltered_RBV r/o longin]
          The number of arrays that have been processed by the filter since the filter was
          last reset. The value of NumFiltered is incremented as each array is processed,
          until it reaches the value of NumFilter, when it will cease incrementing. The value
          of NumFiltered is used in the filter equations, as explained below.''',
        FilterType=u'[FilterType r/w mbbo] The filter type, chosen from a predefined list, as described below.',
        OOffset=u'[OOffset r/w ao] Output offset coefficient.',
        OScale=u'[OScale r/w ao] Output scale coefficient.',
        OC1=u'[OC1 r/w ao] Output coefficient #1.',
        OC2=u'[OC2 r/w ao] Output coefficient #2.',
        OC3=u'[OC3 r/w ao] Output coefficient #3.',
        OC4=u'[OC4 r/w ao] Output coefficient #4.',
        FOffset=u'[FOffset r/w ao] Filter offset coefficient.',
        FScale=u'[FScale r/w ao] Filter scale coefficient.',
        FC1=u'[FC1 r/w ao] Filter coefficient #1.',
        FC2=u'[FC2 r/w ao] Filter coefficient #2.',
        FC3=u'[FC3 r/w ao] Filter coefficient #3.',
        FC4=u'[FC4 r/w ao] Filter coefficient #4.',
        ROffset=u'[ROffset r/w ao] Reset offset coefficient.',
        RC1=u'[RC1 r/w ao] Filter coefficient #1.',
        RC2=u'[RC2 r/w ao] Filter coefficient #2.',
        ),  # end of NDPluginProcess.html


    'PSLDoc.html': dict(
        FilePath=u'[FilePath] Controls the path for saving images. It must be a valid path for PSL_server.',
        FileFormat=u'''[FileFormat]
          The PSL driver supports saving images using the PSL_server in the following formats:

            AVI
            BMP
            FLF
            GIF
            JPEG
            PCX
            PNG
            PNM
            TIFF


            This list of file formats is read from the server, so could change in future releases
            of the server with no change to the areaDetector software required.''',
        TriggerMode=u'''[TriggerMode]
          The PSL driver supports one or more of the following trigger modes:

            FreeRunning
            Hardware_Falling
            Hardware_Rising
            Pipeline_Falling
            Pipeline_Rising
            Pipeline_Software
            Software

          The menu of valid trigger modes is read from the server when a camera is opened,
          because it is camera-specific.''',
        TIFFComment=u'[TIFFComment r/w waveform] Comment string to put in header of TIFF files written by PSL_server.',

        TIFFCommand_RBV=u'[TIFFCommand_RBV r/w waveform] Comment string to put in header of TIFF files written by PSL_server.',
        ),  # end of PSLDoc.html


    'RoperDoc.html': dict(
        ImageMode=u'''[ImageMode]
          The driver redefines the choices for the ADImageMode parameter (record $(P)$(R)ImageMode)
          from ADDriver.h. The choices for the Roper are:

            Normal: This is the same as pressing the Acquire button in WinView. It may collect
              more than 1 exposure per image if NumExposures>1, more than 1 image per acquisition
              if NumImages>1, and more than 1 aquisition if NumAcquisitions>1.
            Continuous: This will cause the driver to perform acquisitions indefinitely, i.e.
              it acts as if NumAcquisitions is infinite.
            Focus: This is the same as pressing the Focus button in WinView. It causes acquisition
              to proceed as quickly as possible. It does not save the data. It currently does
              not call the callbacks for each frame, so the images can only be seen in WinView
              and not in EPICS. This may be fixed in a future release.''',
        AcquirePeriod=u'''[AcquirePeriod]
          Controls the period between images when ADImageMode is Continuous. If this is greater
          than the acquisition time plus readout overhead then the driver will wait until
          the period has elapsed before starting the next acquisition.''',
        NumExposures=u'[NumExposures] Controls the number of exposures (accumulations) to acquire into a single image.',
        NumImages=u'[NumImages] Controls the number of images to acquire into a single 3-D data set.',
        TriggerMode=u'''[TriggerMode]
          The driver redefines the choices for the ADTriggerMode parameter (record $(P)$(R)TriggerMode)
          from ADDriver.h. The choices for the Roper are:

            Free run: This acquires images as quickly as possible given the exposure and readout
              times.
            Ext. sync: This acquires one image for each external trigger pulse.
            Bulb trig.: The exposure time is determined by the external trigger pulse width.

            Single trig.: A single external trigger pulse will acquire an entire sequence
              of images.''',
        FileFormat=u'''[FileFormat]
          The driver redefines the choices for the NDFileFormat parameter (record $(P)$(R)FileFormat)
          from asynNDArrayDriver.h. The choices for the Roper are:

            SPE: This is the default file format for WinView. It is a binary format with a
              header containing all of the acquisition and setup information.
            TIFF: TIFF files that contain the full resolution of the image data. The TIFF
              files do not contain any acquisition or setup information.
            8-bit TIFF: 8-bit TIFF files that contain limited resolution image data. The TIFF
              files do not contain any acquisition or setup information.

          The driver does not automatically change the file extension (.SPE, .TIFF, etc.)
          when the FileFormat is changed, the user should do this using the FileTemplate record.''',
        Gain=u'''[Gain]
          The precision of the $(P)$(R)Gain record is changed to 0 because the gain in WinView
          is an integer. Allowed values are detector dependent, but 1 and 2 are typically
          supported.''',
        NumAcquisitions=u'''[NumAcquisitions r/w longout]
          The number of acquisitions to perform when acquisition is started. This controls
          the number of iterations in the outermost acquisition loop explained above.''',
        NumAcquisitionsCounter_RBV=u'[NumAcquisitionsCounter_RBV r/o longin] The number of acquisitions performed so far.',
        AutoDataType=u'''[AutoDataType r/w bo]
          A flag controlling whether WinView will automatically chose the optimal data type
          for the image data. 0=No, 1=Yes. If this flag is 1 then the NDDataType parameter
          ($(P)$(R)DataType record) is ignored. If this flag is 0 then the NDDataType parameter
          controls the data type of the images.''',
        RoperShutterMode=u'''[RoperShutterMode r/w mbbo]
          The shutter operating mode for shutters controlled by WinView. Allowed values are:

            Normal: The detector shutter will be opened and closed normally for each exposure.
            Disabled closed: The shutter will be forced closed. Useful for taking a dark current
              image.
            Disabled open: The shutter will be forced open.''',
        Comment1=u'''[Comment1 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment2=u'''[Comment2 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment3=u'''[Comment3 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment4=u'''[Comment4 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        Comment5=u'''[Comment5 r/w waveform]
          User comments for the data file. 5 comment fields of 80 characters each are available
          in the header of WinView SPE files. These are waveform records with FTVL=UCHAR and
          NELM=80 so that they can be longer than the 40 character string limit in EPICS.''',
        ),  # end of RoperDoc.html


    'NDFileNexus.html': dict(
        TemplateFilePath=u'[TemplateFilePath r/w waveform] Path to XML template file',
        TemplateFileName=u'[TemplateFileName r/w waveform] Name of XML template file',
        ),  # end of NDFileNexus.html


}
