# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Solvers."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_solver')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_solver')
    _solver = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_solver', [dirname(__file__)])
        except ImportError:
            import _solver
            return _solver
        try:
            _mod = imp.load_module('_solver', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _solver = swig_import_helper()
    del swig_import_helper
else:
    import _solver
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _solver.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _solver.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _solver.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _solver.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _solver.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _solver.SwigPyIterator_equal(self, x)

    def copy(self):
        return _solver.SwigPyIterator_copy(self)

    def next(self):
        return _solver.SwigPyIterator_next(self)

    def __next__(self):
        return _solver.SwigPyIterator___next__(self)

    def previous(self):
        return _solver.SwigPyIterator_previous(self)

    def advance(self, n):
        return _solver.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _solver.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _solver.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _solver.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _solver.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _solver.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _solver.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _solver.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _solver.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
class SolverImplementation(openturns.common.PersistentObject):
    """
    SolverImplementation of 1D non linear equations.

    Available constructor:
        SolverImplementation()

        SolverImplementation(*solverImplementation*)

        SolverImplementation(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    solverImplementation : SolverImplementationImplementation
        The implementation of a particular solver which is :class:`~openturns.Bisection`,
        :class:`~openturns.Brent` or :class:`~openturns.Secant`.   
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Bisection, Brent, Secant

    Notes
    -----
    This class enables to solve 1D non linear equations :

    .. math::

        f(x) = value, \\forall x \\in [infPoint, supPoint]

    if :math:`f` is a continuous function from :math:`\\Rset` to :math:`\\Rset`,
    :math:`infPoint, supPoint \\in \\Rset` and if :math:`f` is such that
    :math:`f(infPoint) \\times f(supPoint) < 0`, then :math:`f` has at least a zero
    in the interval :math:`[infPoint, supPoint]`. In particular, it is used in the
    root research of a 
    :class:`Directional Sampling simulation <openturns.DirectionalSampling>`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.SolverImplementation_getClassName(self)


    def __eq__(self, other):
        return _solver.SolverImplementation___eq__(self, other)

    def __repr__(self):
        return _solver.SolverImplementation___repr__(self)

    def solve(self, *args):
        return _solver.SolverImplementation_solve(self, *args)

    def setAbsoluteError(self, absoluteError):
        """
        Accessor to the absolute error.

        Parameters
        ----------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.SolverImplementation_setAbsoluteError(self, absoluteError)


    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.SolverImplementation_getAbsoluteError(self)


    def setRelativeError(self, relativeError):
        """
        Accessor to the relative error.

        Parameters
        ----------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.SolverImplementation_setRelativeError(self, relativeError)


    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.SolverImplementation_getRelativeError(self)


    def setResidualError(self, residualError):
        """
        Accessor to the residual error.

        Parameters
        ----------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.SolverImplementation_setResidualError(self, residualError)


    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.SolverImplementation_getResidualError(self)


    def setMaximumFunctionEvaluation(self, maximumFunctionEvaluation):
        """
        Accessor to the maximum number of evaluations of the function.

        Parameters
        ----------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.SolverImplementation_setMaximumFunctionEvaluation(self, maximumFunctionEvaluation)


    def getMaximumFunctionEvaluation(self):
        """
        Accessor to the maximum number of evaluations of the function.

        Returns
        -------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.SolverImplementation_getMaximumFunctionEvaluation(self)


    def getUsedFunctionEvaluation(self):
        """
        Accessor to the number of evaluations of the function.

        Returns
        -------
        nEval : int
            The number of evaluations of the function.
        """
        return _solver.SolverImplementation_getUsedFunctionEvaluation(self)


    def __init__(self, *args):
        this = _solver.new_SolverImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_SolverImplementation
    __del__ = lambda self: None
SolverImplementation_swigregister = _solver.SolverImplementation_swigregister
SolverImplementation_swigregister(SolverImplementation)

class SolverImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _solver.new_SolverImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _solver.SolverImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _solver.SolverImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _solver.SolverImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _solver.SolverImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _solver.delete_SolverImplementationTypedInterfaceObject
    __del__ = lambda self: None
SolverImplementationTypedInterfaceObject_swigregister = _solver.SolverImplementationTypedInterfaceObject_swigregister
SolverImplementationTypedInterfaceObject_swigregister(SolverImplementationTypedInterfaceObject)

class Solver(SolverImplementationTypedInterfaceObject):
    """
    SolverImplementation of 1D non linear equations.

    Available constructor:
        SolverImplementation()

        SolverImplementation(*solverImplementation*)

        SolverImplementation(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    solverImplementation : SolverImplementationImplementation
        The implementation of a particular solver which is :class:`~openturns.Bisection`,
        :class:`~openturns.Brent` or :class:`~openturns.Secant`.   
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Bisection, Brent, Secant

    Notes
    -----
    This class enables to solve 1D non linear equations :

    .. math::

        f(x) = value, \\forall x \\in [infPoint, supPoint]

    if :math:`f` is a continuous function from :math:`\\Rset` to :math:`\\Rset`,
    :math:`infPoint, supPoint \\in \\Rset` and if :math:`f` is such that
    :math:`f(infPoint) \\times f(supPoint) < 0`, then :math:`f` has at least a zero
    in the interval :math:`[infPoint, supPoint]`. In particular, it is used in the
    root research of a 
    :class:`Directional Sampling simulation <openturns.DirectionalSampling>`.
    """

    __swig_setmethods__ = {}
    for _s in [SolverImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Solver, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Solver, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Solver_getClassName(self)


    def __eq__(self, other):
        return _solver.Solver___eq__(self, other)

    def __repr__(self):
        return _solver.Solver___repr__(self)

    def solve(self, *args):
        return _solver.Solver_solve(self, *args)

    def setAbsoluteError(self, absoluteError):
        """
        Accessor to the absolute error.

        Parameters
        ----------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.Solver_setAbsoluteError(self, absoluteError)


    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.Solver_getAbsoluteError(self)


    def setRelativeError(self, relativeError):
        """
        Accessor to the relative error.

        Parameters
        ----------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.Solver_setRelativeError(self, relativeError)


    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.Solver_getRelativeError(self)


    def setResidualError(self, residualError):
        """
        Accessor to the residual error.

        Parameters
        ----------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.Solver_setResidualError(self, residualError)


    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.Solver_getResidualError(self)


    def setMaximumFunctionEvaluation(self, maximumFunctionEvaluation):
        """
        Accessor to the maximum number of evaluations of the function.

        Parameters
        ----------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.Solver_setMaximumFunctionEvaluation(self, maximumFunctionEvaluation)


    def getMaximumFunctionEvaluation(self):
        """
        Accessor to the maximum number of evaluations of the function.

        Returns
        -------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.Solver_getMaximumFunctionEvaluation(self)


    def getUsedFunctionEvaluation(self):
        """
        Accessor to the number of evaluations of the function.

        Returns
        -------
        nEval : int
            The number of evaluations of the function.
        """
        return _solver.Solver_getUsedFunctionEvaluation(self)


    def __init__(self, *args):
        this = _solver.new_Solver(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_Solver
    __del__ = lambda self: None
Solver_swigregister = _solver.Solver_swigregister
Solver_swigregister(Solver)

class Bisection(SolverImplementation):
    """
    Bisection algorithm solver for 1D non linear equations.

    Available constructor:
        Bisection()

        Bisection(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Brent, Secant
    """

    __swig_setmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Bisection, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Bisection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Bisection_getClassName(self)


    def __repr__(self):
        return _solver.Bisection___repr__(self)

    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.Function`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        If the function :math:`f` is continuous, the Bisection solver will converge
        towards a root of the equation :math:`function(x) = value` in
        :math:`[infPoint, supPoint]`. If not, it will converge towards either a root or
        a discontinuity point of :math:`f` on :math:`[infPoint, supPoint]`. Bisection
        guarantees a convergence.

        """
        return _solver.Bisection_solve(self, *args)


    def __init__(self, *args):
        this = _solver.new_Bisection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_Bisection
    __del__ = lambda self: None
Bisection_swigregister = _solver.Bisection_swigregister
Bisection_swigregister(Bisection)

class Secant(SolverImplementation):
    """
    Secant algorithm solver for 1D non linear equations.

    Available constructor:
        Secant()

        Secant(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Bisection, Brent

    Notes
    -----
    The Secant solver is based on the evaluation of a segment between the two last
    iterated points.
    """

    __swig_setmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Secant, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Secant, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Secant_getClassName(self)


    def __repr__(self):
        return _solver.Secant___repr__(self)

    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.Function`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        The Secant solver is based on the evaluation of a segment between the two last
        iterated points. Secant might fail and not converge.
        """
        return _solver.Secant_solve(self, *args)


    def __init__(self, *args):
        this = _solver.new_Secant(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_Secant
    __del__ = lambda self: None
Secant_swigregister = _solver.Secant_swigregister
Secant_swigregister(Secant)

class Brent(SolverImplementation):
    """
    Brent algorithm solver for 1D non linear equations.

    Available constructor:
        Brent()

        Brent(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Bisection, Secant

    Notes
    -----
    The Brent solver is a mix of Bisection, Secant and inverse quadratic
    interpolation.
    """

    __swig_setmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Brent, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Brent, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Brent_getClassName(self)


    def __repr__(self):
        return _solver.Brent___repr__(self)

    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.Function`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        If the function :math:`f` is continuous, the Brent solver will
        converge towards a root of the equation :math:`function(x) = value` in
        :math:`[infPoint, supPoint]`. If not, it will converge towards either a root or
        a discontinuity point of :math:`f` on :math:`[infPoint, supPoint]`. Bisection
        guarantees a convergence.
        """
        return _solver.Brent_solve(self, *args)


    def __init__(self, *args):
        this = _solver.new_Brent(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_Brent
    __del__ = lambda self: None
Brent_swigregister = _solver.Brent_swigregister
Brent_swigregister(Brent)

class ODESolverImplementation(openturns.common.PersistentObject):
    """
    ODE solver base class.

    Solve an explicit first-order differential equation in the form :math:`y' = f(t, y)`
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolverImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolverImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.ODESolverImplementation_getClassName(self)


    def __repr__(self):
        return _solver.ODESolverImplementation___repr__(self)

    def solve(self, initialState, timeGrid):
        """
        Solve ODE.

        Parameters
        ----------
        initialState : sequence of float
            Initial value of the equation
        timeGrid : sequence of float
            Time steps

        Returns
        -------
        values : :class:`~openturns.Sample`
            The solution of the equation at grid points.
        """
        return _solver.ODESolverImplementation_solve(self, initialState, timeGrid)


    def setTransitionFunction(self, transitionFunction):
        """
        Transition function accessor.

        Parameters
        ----------
        transitionFunction : :class:`~openturns.FieldFunction`
            Transition function.
        """
        return _solver.ODESolverImplementation_setTransitionFunction(self, transitionFunction)


    def getTransitionFunction(self):
        """
        Transition function accessor.

        Returns
        -------
        transitionFunction : :class:`~openturns.FieldFunction`
            Transition function.
        """
        return _solver.ODESolverImplementation_getTransitionFunction(self)


    def __init__(self, *args):
        this = _solver.new_ODESolverImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_ODESolverImplementation
    __del__ = lambda self: None
ODESolverImplementation_swigregister = _solver.ODESolverImplementation_swigregister
ODESolverImplementation_swigregister(ODESolverImplementation)

class ODESolverImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolverImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolverImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _solver.new_ODESolverImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _solver.ODESolverImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _solver.delete_ODESolverImplementationTypedInterfaceObject
    __del__ = lambda self: None
ODESolverImplementationTypedInterfaceObject_swigregister = _solver.ODESolverImplementationTypedInterfaceObject_swigregister
ODESolverImplementationTypedInterfaceObject_swigregister(ODESolverImplementationTypedInterfaceObject)

class ODESolver(ODESolverImplementationTypedInterfaceObject):
    """
    ODE solver base class.

    Solve an explicit first-order differential equation in the form :math:`y' = f(t, y)`
    """

    __swig_setmethods__ = {}
    for _s in [ODESolverImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolver, name, value)
    __swig_getmethods__ = {}
    for _s in [ODESolverImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolver, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.ODESolver_getClassName(self)


    def __repr__(self):
        return _solver.ODESolver___repr__(self)

    def __str__(self, *args):
        return _solver.ODESolver___str__(self, *args)

    def solve(self, initialState, timeGrid):
        """
        Solve ODE.

        Parameters
        ----------
        initialState : sequence of float
            Initial value of the equation
        timeGrid : sequence of float
            Time steps

        Returns
        -------
        values : :class:`~openturns.Sample`
            The solution of the equation at grid points.
        """
        return _solver.ODESolver_solve(self, initialState, timeGrid)


    def setTransitionFunction(self, transitionFunction):
        """
        Transition function accessor.

        Parameters
        ----------
        transitionFunction : :class:`~openturns.FieldFunction`
            Transition function.
        """
        return _solver.ODESolver_setTransitionFunction(self, transitionFunction)


    def getTransitionFunction(self):
        """
        Transition function accessor.

        Returns
        -------
        transitionFunction : :class:`~openturns.FieldFunction`
            Transition function.
        """
        return _solver.ODESolver_getTransitionFunction(self)


    def __init__(self, *args):
        this = _solver.new_ODESolver(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_ODESolver
    __del__ = lambda self: None
ODESolver_swigregister = _solver.ODESolver_swigregister
ODESolver_swigregister(ODESolver)

class RungeKutta(ODESolverImplementation):
    """
    Runge-Kutta fourth-order method.

    See also
    --------
    ODESolver

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['t', 'y0', 'y1'], ['t - y0', 'y1 + t^2'])
    >>> phi = ot.VertexValueFunction(f)
    >>> solver = ot.RungeKutta(phi)
    >>> Y0 = [1.0, -1.0]
    >>> nt = 100
    >>> timeGrid = list(map(lambda i:(i**2.0) / (nt - 1.0)**2.0, range(nt)))
    >>> result = solver.solve(Y0, timeGrid)
    """

    __swig_setmethods__ = {}
    for _s in [ODESolverImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RungeKutta, name, value)
    __swig_getmethods__ = {}
    for _s in [ODESolverImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RungeKutta, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.RungeKutta_getClassName(self)


    def __repr__(self):
        return _solver.RungeKutta___repr__(self)

    def solve(self, initialState, timeGrid):
        """
        Solve ODE.

        Parameters
        ----------
        initialState : sequence of float
            Initial value of the equation
        timeGrid : sequence of float
            Time steps

        Returns
        -------
        values : :class:`~openturns.Sample`
            The solution of the equation at grid points.
        """
        return _solver.RungeKutta_solve(self, initialState, timeGrid)


    def __init__(self, *args):
        this = _solver.new_RungeKutta(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _solver.delete_RungeKutta
    __del__ = lambda self: None
RungeKutta_swigregister = _solver.RungeKutta_swigregister
RungeKutta_swigregister(RungeKutta)

# This file is compatible with both classic and new-style classes.


