# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Optimization routines."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_optim')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_optim')
    _optim = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_optim', [dirname(__file__)])
        except ImportError:
            import _optim
            return _optim
        try:
            _mod = imp.load_module('_optim', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _optim = swig_import_helper()
    del swig_import_helper
else:
    import _optim
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _optim.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _optim.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _optim.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _optim.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _optim.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _optim.SwigPyIterator_equal(self, x)

    def copy(self):
        return _optim.SwigPyIterator_copy(self)

    def next(self):
        return _optim.SwigPyIterator_next(self)

    def __next__(self):
        return _optim.SwigPyIterator___next__(self)

    def previous(self):
        return _optim.SwigPyIterator_previous(self)

    def advance(self, n):
        return _optim.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _optim.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _optim.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _optim.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _optim.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _optim.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _optim.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _optim.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _optim.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.experiment
class OptimizationProblemImplementation(openturns.common.PersistentObject):
    """
    Base class to define an optimization problem.

    Available constructors:
        OptimizationProblem()

        OptimizationProblem(*objective*)

        OptimizationProblem(*objective, equality, inequality, bounds*)

        OptimizationProblem(*level, value*)

    Parameters
    ----------
    objective : :class:`~openturns.Function`
        Objective function. Additional constraints and bounds must always be
        consistent with the objective input dimension.
    equality : :class:`~openturns.Function`
        Equality constraints.
    inequality : :class:`~openturns.Function`
        Inequality constraints.
    bounds : :class:`~openturns.Interval`
        Bounds.
    level : :class:`~openturns.Function`
        Level function.
    value : float
        Level value.

    Notes
    -----

    The first form represents a general optimization problem:

    .. math::

        \\min_{x\\in B} f(x) \\\\
        g(x) = 0 \\\\
        h(x) \\ge 0

    where *B* is problem's bounds, *f* is the objective function, *g* are equality constraints, and *h* are inequality constraints.

    The second form represents a nearest point problem:

    .. math::

        \\min_{x} ||x|| \\\\
        g(x) = v

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.SymbolicFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem(rosenbrock)

    Define an optimization problem to find the point with minimum norm which satisfies :math:`x1+2*x2-3*x3+4*x4=3`.

    >>> import openturns as ot
    >>> levelFunction = ot.SymbolicFunction(
    ...     ['x1', 'x2', 'x3', 'x4'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(levelFunction, 3.0)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblemImplementation_getClassName(self)


    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.Function`
            Objective function.
        """
        return _optim.OptimizationProblemImplementation_getObjective(self)


    def setObjective(self, objective):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.Function`
            Objective function.

        Notes
        -----
        Constraints and bounds are cleared if the objective has a different input
        dimension in order to keep the problem valid at all time.
        """
        return _optim.OptimizationProblemImplementation_setObjective(self, objective)


    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasMultipleObjective(self)


    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.Function`
            Describe equality constraints.
        """
        return _optim.OptimizationProblemImplementation_getEqualityConstraint(self)


    def setEqualityConstraint(self, equalityConstraint):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.Function`
            Equality constraints.
        """
        return _optim.OptimizationProblemImplementation_setEqualityConstraint(self, equalityConstraint)


    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasEqualityConstraint(self)


    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.Function`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblemImplementation_getInequalityConstraint(self)


    def setInequalityConstraint(self, inequalityConstraint):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.Function`
            Inequality constraints.
        """
        return _optim.OptimizationProblemImplementation_setInequalityConstraint(self, inequalityConstraint)


    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasInequalityConstraint(self)


    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementation_getBounds(self)


    def setBounds(self, bounds):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementation_setBounds(self, bounds)


    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasBounds(self)


    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblemImplementation_getLevelFunction(self)


    def setLevelFunction(self, levelFunction):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblemImplementation_setLevelFunction(self, levelFunction)


    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasLevelFunction(self)


    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblemImplementation_getLevelValue(self)


    def setLevelValue(self, levelValue):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblemImplementation_setLevelValue(self, levelValue)


    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblemImplementation_getDimension(self)


    def setMinimization(self, minimization):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_setMinimization(self, minimization)


    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_isMinimization(self)


    def __repr__(self):
        return _optim.OptimizationProblemImplementation___repr__(self)

    def __init__(self, *args):
        this = _optim.new_OptimizationProblemImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementation
    __del__ = lambda self: None
OptimizationProblemImplementation_swigregister = _optim.OptimizationProblemImplementation_swigregister
OptimizationProblemImplementation_swigregister(OptimizationProblemImplementation)

class OptimizationProblemImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _optim.new_OptimizationProblemImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _optim.OptimizationProblemImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementationTypedInterfaceObject
    __del__ = lambda self: None
OptimizationProblemImplementationTypedInterfaceObject_swigregister = _optim.OptimizationProblemImplementationTypedInterfaceObject_swigregister
OptimizationProblemImplementationTypedInterfaceObject_swigregister(OptimizationProblemImplementationTypedInterfaceObject)

class OptimizationProblem(OptimizationProblemImplementationTypedInterfaceObject):
    """
    Base class to define an optimization problem.

    Available constructors:
        OptimizationProblem()

        OptimizationProblem(*objective*)

        OptimizationProblem(*objective, equality, inequality, bounds*)

        OptimizationProblem(*level, value*)

    Parameters
    ----------
    objective : :class:`~openturns.Function`
        Objective function. Additional constraints and bounds must always be
        consistent with the objective input dimension.
    equality : :class:`~openturns.Function`
        Equality constraints.
    inequality : :class:`~openturns.Function`
        Inequality constraints.
    bounds : :class:`~openturns.Interval`
        Bounds.
    level : :class:`~openturns.Function`
        Level function.
    value : float
        Level value.

    Notes
    -----

    The first form represents a general optimization problem:

    .. math::

        \\min_{x\\in B} f(x) \\\\
        g(x) = 0 \\\\
        h(x) \\ge 0

    where *B* is problem's bounds, *f* is the objective function, *g* are equality constraints, and *h* are inequality constraints.

    The second form represents a nearest point problem:

    .. math::

        \\min_{x} ||x|| \\\\
        g(x) = v

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.SymbolicFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem(rosenbrock)

    Define an optimization problem to find the point with minimum norm which satisfies :math:`x1+2*x2-3*x3+4*x4=3`.

    >>> import openturns as ot
    >>> levelFunction = ot.SymbolicFunction(
    ...     ['x1', 'x2', 'x3', 'x4'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(levelFunction, 3.0)
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationProblemImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblem, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationProblemImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblem, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblem_getClassName(self)


    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.Function`
            Objective function.
        """
        return _optim.OptimizationProblem_getObjective(self)


    def setObjective(self, objective):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.Function`
            Objective function.

        Notes
        -----
        Constraints and bounds are cleared if the objective has a different input
        dimension in order to keep the problem valid at all time.
        """
        return _optim.OptimizationProblem_setObjective(self, objective)


    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblem_hasMultipleObjective(self)


    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.Function`
            Describe equality constraints.
        """
        return _optim.OptimizationProblem_getEqualityConstraint(self)


    def setEqualityConstraint(self, equalityConstraint):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.Function`
            Equality constraints.
        """
        return _optim.OptimizationProblem_setEqualityConstraint(self, equalityConstraint)


    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasEqualityConstraint(self)


    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.Function`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblem_getInequalityConstraint(self)


    def setInequalityConstraint(self, inequalityConstraint):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.Function`
            Inequality constraints.
        """
        return _optim.OptimizationProblem_setInequalityConstraint(self, inequalityConstraint)


    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasInequalityConstraint(self)


    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblem_getBounds(self)


    def setBounds(self, bounds):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblem_setBounds(self, bounds)


    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasBounds(self)


    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblem_getLevelFunction(self)


    def setLevelFunction(self, levelFunction):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblem_setLevelFunction(self, levelFunction)


    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasLevelFunction(self)


    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblem_getLevelValue(self)


    def setLevelValue(self, levelValue):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblem_setLevelValue(self, levelValue)


    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblem_getDimension(self)


    def setMinimization(self, minimization):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_setMinimization(self, minimization)


    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblem_isMinimization(self)


    def __repr__(self):
        return _optim.OptimizationProblem___repr__(self)

    def __str__(self, *args):
        return _optim.OptimizationProblem___str__(self, *args)

    def __init__(self, *args):
        this = _optim.new_OptimizationProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblem
    __del__ = lambda self: None
OptimizationProblem_swigregister = _optim.OptimizationProblem_swigregister
OptimizationProblem_swigregister(OptimizationProblem)

class OptimizationResult(openturns.common.PersistentObject):
    """
    Optimization result.

    Returned by optimization solvers, see :class:`~openturns.OptimizationAlgorithm`.

    Available constructors:
        OptimizationResult(*optimalPoint, optimalValue, iterationNumber, absoluteError, relativeError, residualError, constraintError*)

    Parameters
    ----------
    optimalPoint : sequence of float
        Optimal point.
    optimalValue : sequence of float
        Value at optimal point.
    iterationNumber : int
        Number of iterations.
    absoluteError : float
        Parameters for this solver.
    relativeError : float
        Relative error.
    residualError : float
        Residual error.
    constraintError : float
        Constraint error.
    problem : :class:`~openturns.OptimizationProblem`
        Associated problem.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationResult_getClassName(self)


    def setOptimalPoint(self, optimalPoint):
        """
        Accessor to the optimal point.

        Parameters
        ----------
        optimalPoint : :class:`~openturns.Point`
            Optimal point
        """
        return _optim.OptimizationResult_setOptimalPoint(self, optimalPoint)


    def getOptimalPoint(self):
        """
        Accessor to the optimal point.

        Returns
        -------
        optimalPoint : :class:`~openturns.Point`
            Optimal point
        """
        return _optim.OptimizationResult_getOptimalPoint(self)


    def setOptimalValue(self, optimalValue):
        """
        Accessor to the optimal value.

        Parameters
        ----------
        optimalValue : :class:`~openturns.Point`
            Value at the optimal point
        """
        return _optim.OptimizationResult_setOptimalValue(self, optimalValue)


    def getOptimalValue(self):
        """
        Accessor to the optimal value.

        Returns
        -------
        optimalValue : :class:`~openturns.Point`
            Value at the optimal point
        """
        return _optim.OptimizationResult_getOptimalValue(self)


    def setIterationNumber(self, iterationNumber):
        """
        Accessor to the number of iterations.

        Parameters
        ----------
        iterationNumber : int
            Number of evaluations.
        """
        return _optim.OptimizationResult_setIterationNumber(self, iterationNumber)


    def getIterationNumber(self):
        """
        Accessor to the number of iterations.

        Returns
        -------
        iterationNumber : int
            Number of evaluations.
        """
        return _optim.OptimizationResult_getIterationNumber(self)


    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absoluteError : float
            Absolute error, defined by :math:`\\epsilon^a_n=\\|\\vect{x}_{n+1}-\\vect{x}_n\\|_{\\infty}` where :math:`\\vect{x}_{n+1}` and :math:`\\vect{x}_n` are two consecutive approximations of the optimum.
        """
        return _optim.OptimizationResult_getAbsoluteError(self)


    def getAbsoluteErrorHistory(self):
        """
        Accessor to the evolution of the absolute error.

        Returns
        -------
        absoluteErrorHistory : :class:`~openturns.Sample`
            Value of the absolute error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getAbsoluteErrorHistory(self)


    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relativeError : float
            Relative error, defined by :math:`\\epsilon^r_n=\\epsilon^a_n/\\|\\vect{x}_{n+1}\\|_{\\infty}` if :math:`\\|\\vect{x}_{n+1}\\|_{\\infty}\\neq 0`, else :math:`\\epsilon^r_n=-1`.
        """
        return _optim.OptimizationResult_getRelativeError(self)


    def getRelativeErrorHistory(self):
        """
        Accessor to the evolution of the relative error.

        Returns
        -------
        relativeErrorHistory : :class:`~openturns.Sample`
            Value of the relative error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getRelativeErrorHistory(self)


    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        residualError : float
            Residual error, defined by :math:`\\eta^r_n=\\|\\nabla\\cL{\\vect{x}_n}\\|_{\\infty}` where :math:`\\vect{x}_n` is the current approximation of the optimum and :math:`\\cL` is the Lagrangian of the problem.
        """
        return _optim.OptimizationResult_getResidualError(self)


    def getResidualErrorHistory(self):
        """
        Accessor to the evolution of the residual error.

        Returns
        -------
        residualErrorHistory : :class:`~openturns.Sample`
            Value of the residual error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getResidualErrorHistory(self)


    def getConstraintError(self):
        """
        Accessor to the constraint error.

        Returns
        -------
        constraintError : float
            Constraint error, defined by :math:`\\gamma_n=\\|g(\\vect{x}_n)\\|_{\\infty}` where :math:`\\vect{x}_n` is the current approximation of the optimum and :math:`g` is the function that gather all the equality and inequality constraints.
        """
        return _optim.OptimizationResult_getConstraintError(self)


    def getConstraintErrorHistory(self):
        """
        Accessor to the evolution of the constraint error.

        Returns
        -------
        constraintErrorHistory : :class:`~openturns.Sample`
            Value of the constrainte error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getConstraintErrorHistory(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input points used by the solver
        """
        return _optim.OptimizationResult_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output points used by the solver
        """
        return _optim.OptimizationResult_getOutputSample(self)


    def setProblem(self, problem):
        """
        Accessor to the underlying optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Problem corresponding to the result
        """
        return _optim.OptimizationResult_setProblem(self, problem)


    def getProblem(self):
        """
        Accessor to the underlying optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Problem corresponding to the result
        """
        return _optim.OptimizationResult_getProblem(self)


    def setLagrangeMultipliers(self, lagrangeMultipliers):
        """
        Accessor to the Lagrange multipliers.

        Parameters
        ----------
        multipliers : :class:`~openturns.Point`
            Lagrange multipliers.

        Notes
        -----
        See :class:`~openturns.OptimizationAlgorithm` for the details on how the multipliers are defined and stored in the result.

        """
        return _optim.OptimizationResult_setLagrangeMultipliers(self, lagrangeMultipliers)


    def getLagrangeMultipliers(self):
        """
        Accessor to the Lagrange multipliers.

        Returns
        -------
        multipliers : :class:`~openturns.Point`
            Lagrange multipliers.

        Notes
        -----
        See :class:`~openturns.OptimizationAlgorithm` for the details on how the multipliers are defined and stored in the result.

        """
        return _optim.OptimizationResult_getLagrangeMultipliers(self)


    def __repr__(self):
        return _optim.OptimizationResult___repr__(self)

    def store(self, inP, outP, absoluteError, relativeError, residualError, constraintError):
        return _optim.OptimizationResult_store(self, inP, outP, absoluteError, relativeError, residualError, constraintError)

    def drawErrorHistory(self):
        """
        Draw the convergence criteria history.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Convergence criteria history graph
        """
        return _optim.OptimizationResult_drawErrorHistory(self)


    def drawOptimalValueHistory(self):
        """
        Draw the optimal value history.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Optimal value history graph
        """
        return _optim.OptimizationResult_drawOptimalValueHistory(self)


    def __init__(self, *args):
        this = _optim.new_OptimizationResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_OptimizationResult
    __del__ = lambda self: None
OptimizationResult_swigregister = _optim.OptimizationResult_swigregister
OptimizationResult_swigregister(OptimizationResult)

class OptimizationAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Base class for optimization wrappers.

    Available constructors:
        OptimizationAlgorithm(*problem, verbose=False*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem.
    verbose : bool
        Let solver be more verbose.

    Notes
    -----

    Class :class:`~openturns.OptimizationAlgorithm` is an abstract class, which has several implementations.
    The default implementation is :class:`~openturns.Cobyla`, but there are also
    :class:`~openturns.AbdoRackwitz`, :class:`~openturns.SQP` and :class:`~openturns.TNC`.

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.SymbolicFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem(rosenbrock)
    >>> solver = ot.OptimizationAlgorithm(problem)
    >>> solver.setStartingPoint([0, 0])
    >>> solver.setMaximumResidualError(1.e-3)
    >>> solver.setMaximumIterationNumber(100)
    >>> solver.run()
    >>> result = solver.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationAlgorithmImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationAlgorithmImplementation_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationAlgorithmImplementation_run(self)


    def computeLagrangeMultipliers(self, x):
        """
        Compute the Lagrange multipliers of a problem at a given point.

        Parameters
        ----------
        x : sequence of float
            Point at which the Lagrange multipliers are computed.

        Returns
        -------
        lagrangeMultiplier : sequence of float
            Lagrange multipliers of the problem at the given point.

        Notes
        -----
        The Lagrange multipliers :math:`\\vect{\\lambda}` are associated with the following Lagrangian formulation of the optimization problem:

        .. math::

            \\cL(\\vect{x}, \\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq}) = J(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{eq} g(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{\\ell} (\\vect{x}-\\vect{\\ell})^{+} + \\Tr{\\vect{\\lambda}}_{u} (\\vect{u}-\\vect{x})^{+} + \\Tr{\\vect{\\lambda}}_{ineq}  h^{+}(\\vect{x})

        where :math:`\\vect{\\alpha}^{+}=(\\max(0,\\alpha_1),\\hdots,\\max(0,\\alpha_n))`.

        The Lagrange multipliers are stored as :math:`(\\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq})`, where:
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no equality
              constraint, else of dimension the dimension of :math:`g(\\vect{x})` ie the number of scalar equality constraints
            - :math:`\\vect{\\lambda}_{\\ell}` and :math:`\\vect{\\lambda}_{u}` are of dimension 0 if there is no bound constraint, else of dimension of :math:`\\vect{x}`
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no inequality constraint, else of dimension the dimension of :math:`h(\\vect{x})` ie the number of scalar inequality constraints

        The vector :math:`\\vect{\\lambda}` is solution of the following linear system:

        .. math::

            \\Tr{\\vect{\\lambda}}_{eq}\\left[\\dfrac{\\partial g}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{\\ell}\\left[\\dfrac{\\partial (\\vect{x}-\\vect{\\ell})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{u}\\left[\\dfrac{\\partial (\\vect{u}-\\vect{x})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{ineq}\\left[\\dfrac{\\partial h}{\\partial\\vect{x}}(\\vect{x})\\right]=-\\dfrac{\\partial J}{\\partial\\vect{x}}(\\vect{x})

        If there is no constraint of any kind, :math:`\\vect{\\lambda}` is of dimension 0, as well as if no constraint is active.

        """
        return _optim.OptimizationAlgorithmImplementation_computeLagrangeMultipliers(self, x)


    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithmImplementation_getStartingPoint(self)


    def setStartingPoint(self, startingPoint):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithmImplementation_setStartingPoint(self, startingPoint)


    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithmImplementation_getProblem(self)


    def setProblem(self, problem):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithmImplementation_setProblem(self, problem)


    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithmImplementation_getResult(self)


    def setResult(self, result):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithmImplementation_setResult(self, result)


    def setMaximumIterationNumber(self, maximumIterationNumber):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumIterationNumber(self, maximumIterationNumber)


    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumIterationNumber(self)


    def setMaximumEvaluationNumber(self, maximumEvaluationNumber):
        """
        Accessor to maximum allowed number of evaluations.

        Parameters
        ----------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumEvaluationNumber(self, maximumEvaluationNumber)


    def getMaximumEvaluationNumber(self):
        """
        Accessor to maximum allowed number of evaluations.

        Returns
        -------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumEvaluationNumber(self)


    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumAbsoluteError(self)


    def setMaximumAbsoluteError(self, maximumAbsoluteError):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumAbsoluteError(self, maximumAbsoluteError)


    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumRelativeError(self)


    def setMaximumRelativeError(self, maximumRelativeError):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumRelativeError(self, maximumRelativeError)


    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumResidualError(self)


    def setMaximumResidualError(self, maximumResidualError):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumResidualError(self, maximumResidualError)


    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithmImplementation_getMaximumConstraintError(self)


    def setMaximumConstraintError(self, maximumConstraintError):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithmImplementation_setMaximumConstraintError(self, maximumConstraintError)


    def __repr__(self):
        return _optim.OptimizationAlgorithmImplementation___repr__(self)

    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithmImplementation_getVerbose(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithmImplementation_setVerbose(self, verbose)


    def __init__(self, *args):
        this = _optim.new_OptimizationAlgorithmImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def setProgressCallback(self, *args):
        """
        Set up a progress callback.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.

        """
        return _optim.OptimizationAlgorithmImplementation_setProgressCallback(self, *args)


    def setStopCallback(self, *args):
        """
        Set up a stop callback.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.
        """
        return _optim.OptimizationAlgorithmImplementation_setStopCallback(self, *args)

    __swig_destroy__ = _optim.delete_OptimizationAlgorithmImplementation
    __del__ = lambda self: None
OptimizationAlgorithmImplementation_swigregister = _optim.OptimizationAlgorithmImplementation_swigregister
OptimizationAlgorithmImplementation_swigregister(OptimizationAlgorithmImplementation)

class OptimizationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _optim.new_OptimizationAlgorithmImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _optim.OptimizationAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationAlgorithmImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationAlgorithmImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _optim.OptimizationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _optim.delete_OptimizationAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self: None
OptimizationAlgorithmImplementationTypedInterfaceObject_swigregister = _optim.OptimizationAlgorithmImplementationTypedInterfaceObject_swigregister
OptimizationAlgorithmImplementationTypedInterfaceObject_swigregister(OptimizationAlgorithmImplementationTypedInterfaceObject)

class OptimizationAlgorithm(OptimizationAlgorithmImplementationTypedInterfaceObject):
    """
    Base class for optimization wrappers.

    Available constructors:
        OptimizationAlgorithm(*problem, verbose=False*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem.
    verbose : bool
        Let solver be more verbose.

    Notes
    -----

    Class :class:`~openturns.OptimizationAlgorithm` is an abstract class, which has several implementations.
    The default implementation is :class:`~openturns.Cobyla`, but there are also
    :class:`~openturns.AbdoRackwitz`, :class:`~openturns.SQP` and :class:`~openturns.TNC`.

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.SymbolicFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem(rosenbrock)
    >>> solver = ot.OptimizationAlgorithm(problem)
    >>> solver.setStartingPoint([0, 0])
    >>> solver.setMaximumResidualError(1.e-3)
    >>> solver.setMaximumIterationNumber(100)
    >>> solver.run()
    >>> result = solver.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationAlgorithm_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationAlgorithm_run(self)


    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithm_getStartingPoint(self)


    def setStartingPoint(self, startingPoint):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithm_setStartingPoint(self, startingPoint)


    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithm_getProblem(self)


    def setProblem(self, problem):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithm_setProblem(self, problem)


    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithm_getResult(self)


    def setResult(self, result):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithm_setResult(self, result)


    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithm_getMaximumIterationNumber(self)


    def setMaximumIterationNumber(self, maximumIterationNumber):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithm_setMaximumIterationNumber(self, maximumIterationNumber)


    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithm_getMaximumAbsoluteError(self)


    def setMaximumAbsoluteError(self, maximumAbsoluteError):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithm_setMaximumAbsoluteError(self, maximumAbsoluteError)


    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithm_getMaximumRelativeError(self)


    def setMaximumRelativeError(self, maximumRelativeError):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithm_setMaximumRelativeError(self, maximumRelativeError)


    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithm_getMaximumResidualError(self)


    def setMaximumResidualError(self, maximumResidualError):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithm_setMaximumResidualError(self, maximumResidualError)


    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithm_getMaximumConstraintError(self)


    def setMaximumConstraintError(self, maximumConstraintError):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithm_setMaximumConstraintError(self, maximumConstraintError)


    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithm_getVerbose(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithm_setVerbose(self, verbose)


    def __repr__(self):
        return _optim.OptimizationAlgorithm___repr__(self)

    def __str__(self, *args):
        return _optim.OptimizationAlgorithm___str__(self, *args)

    def __init__(self, *args):
        this = _optim.new_OptimizationAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def setProgressCallback(self, *args):
        """
        Set up a progress callback.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.

        """
        return _optim.OptimizationAlgorithm_setProgressCallback(self, *args)


    def setStopCallback(self, *args):
        """
        Set up a stop callback.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.
        """
        return _optim.OptimizationAlgorithm_setStopCallback(self, *args)

    __swig_destroy__ = _optim.delete_OptimizationAlgorithm
    __del__ = lambda self: None
OptimizationAlgorithm_swigregister = _optim.OptimizationAlgorithm_swigregister
OptimizationAlgorithm_swigregister(OptimizationAlgorithm)

class NearestPointCheckerResult(openturns.common.PersistentObject):
    """Proxy of C++ OT::NearestPointCheckerResult"""

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NearestPointCheckerResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NearestPointCheckerResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NearestPointCheckerResult_getClassName(self)


    def getVerifyingConstraintPoints(self):
        return _optim.NearestPointCheckerResult_getVerifyingConstraintPoints(self)

    def getVerifyingConstraintValues(self):
        return _optim.NearestPointCheckerResult_getVerifyingConstraintValues(self)

    def getViolatingConstraintPoints(self):
        return _optim.NearestPointCheckerResult_getViolatingConstraintPoints(self)

    def getViolatingConstraintValues(self):
        return _optim.NearestPointCheckerResult_getViolatingConstraintValues(self)

    def setVerifyingConstraintPoints(self, verifyingConstraintPoints):
        return _optim.NearestPointCheckerResult_setVerifyingConstraintPoints(self, verifyingConstraintPoints)

    def setVerifyingConstraintValues(self, verifyingConstraintValues):
        return _optim.NearestPointCheckerResult_setVerifyingConstraintValues(self, verifyingConstraintValues)

    def setViolatingConstraintPoints(self, violatingConstraintPoints):
        return _optim.NearestPointCheckerResult_setViolatingConstraintPoints(self, violatingConstraintPoints)

    def setViolatingConstraintValues(self, violatingConstraintValues):
        return _optim.NearestPointCheckerResult_setViolatingConstraintValues(self, violatingConstraintValues)

    def __repr__(self):
        return _optim.NearestPointCheckerResult___repr__(self)

    def __init__(self, *args):
        this = _optim.new_NearestPointCheckerResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_NearestPointCheckerResult
    __del__ = lambda self: None
NearestPointCheckerResult_swigregister = _optim.NearestPointCheckerResult_swigregister
NearestPointCheckerResult_swigregister(NearestPointCheckerResult)

class NearestPointChecker(openturns.common.PersistentObject):
    """Proxy of C++ OT::NearestPointChecker"""

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NearestPointChecker, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NearestPointChecker, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NearestPointChecker_getClassName(self)


    def setLevelFunction(self, levelFunction):
        return _optim.NearestPointChecker_setLevelFunction(self, levelFunction)

    def getLevelFunction(self):
        return _optim.NearestPointChecker_getLevelFunction(self)

    def setResult(self, result):
        return _optim.NearestPointChecker_setResult(self, result)

    def getResult(self):
        return _optim.NearestPointChecker_getResult(self)

    def setComparisonOperator(self, comparisonOperator):
        return _optim.NearestPointChecker_setComparisonOperator(self, comparisonOperator)

    def getComparisonOperator(self):
        return _optim.NearestPointChecker_getComparisonOperator(self)

    def setThreshold(self, threshold):
        return _optim.NearestPointChecker_setThreshold(self, threshold)

    def getThreshold(self):
        return _optim.NearestPointChecker_getThreshold(self)

    def setSample(self, sample):
        return _optim.NearestPointChecker_setSample(self, sample)

    def getSample(self):
        return _optim.NearestPointChecker_getSample(self)

    def run(self):
        return _optim.NearestPointChecker_run(self)

    def __repr__(self):
        return _optim.NearestPointChecker___repr__(self)

    def __init__(self, *args):
        this = _optim.new_NearestPointChecker(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_NearestPointChecker
    __del__ = lambda self: None
NearestPointChecker_swigregister = _optim.NearestPointChecker_swigregister
NearestPointChecker_swigregister(NearestPointChecker)

class AbdoRackwitz(OptimizationAlgorithmImplementation):
    """
    Abdo-Rackwitz solver.

    Available constructors:
        AbdoRackwitz(*problem*)

        AbdoRackwitz(*problem, tau, omega, smooth*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    tau : float
        Multiplicative decrease of linear step.
    omega : float
        Armijo factor.
    smooth : float
        Growing factor in penalization term.

    See also
    --------
    Cobyla, SQP, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> problem = ot.OptimizationProblem(model, 5.0)
    >>> algo = ot.AbdoRackwitz(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbdoRackwitz, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbdoRackwitz, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.AbdoRackwitz_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.AbdoRackwitz_run(self)


    def getTau(self):
        """
        Accessor to tau parameter.

        Returns
        -------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.AbdoRackwitz_getTau(self)


    def setTau(self, tau):
        """
        Accessor to tau parameter.

        Parameters
        ----------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.AbdoRackwitz_setTau(self, tau)


    def getOmega(self):
        """
        Accessor to omega parameter.

        Returns
        -------
        omega : float
            Armijo factor.
        """
        return _optim.AbdoRackwitz_getOmega(self)


    def setOmega(self, tau):
        """
        Accessor to omega parameter.

        Parameters
        ----------
        omega : float
            Armijo factor.
        """
        return _optim.AbdoRackwitz_setOmega(self, tau)


    def getSmooth(self):
        """
        Accessor to smooth parameter.

        Returns
        -------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.AbdoRackwitz_getSmooth(self)


    def setSmooth(self, tau):
        """
        Accessor to smooth parameter.

        Parameters
        ----------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.AbdoRackwitz_setSmooth(self, tau)


    def __repr__(self):
        return _optim.AbdoRackwitz___repr__(self)

    def __init__(self, *args):
        this = _optim.new_AbdoRackwitz(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_AbdoRackwitz
    __del__ = lambda self: None
AbdoRackwitz_swigregister = _optim.AbdoRackwitz_swigregister
AbdoRackwitz_swigregister(AbdoRackwitz)

class Cobyla(OptimizationAlgorithmImplementation):
    """
    Constrained Optimization BY Linear Approximations solver.

    Available constructors:
        Cobyla(*problem*)

        Cobyla(*problem, rhoBeg*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    rhoBeg : float
        A reasonable initial change to the variables.

    Notes
    -----
    It constructs successive linear approximations of the objective function and
    constraints via a simplex of :math:`d+1` points, and optimizes these
    approximations in a trust region at each step.
    This solver does not implement the progress callback.

    See also
    --------
    AbdoRackwitz, SQP, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> problem = ot.OptimizationProblem(model, 5.0)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Cobyla, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Cobyla, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.Cobyla_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.Cobyla_run(self)


    def getRhoBeg(self):
        """
        Accessor to rhoBeg parameter.

        Returns
        -------
        rhoBeg : float
            A reasonable initial change to the variables.
        """
        return _optim.Cobyla_getRhoBeg(self)


    def setRhoBeg(self, rhoBeg):
        """
        Accessor to rhoBeg parameter.

        Parameters
        ----------
        rhoBeg : float
            A reasonable initial change to the variables.
        """
        return _optim.Cobyla_setRhoBeg(self, rhoBeg)


    def __repr__(self):
        return _optim.Cobyla___repr__(self)

    def __init__(self, *args):
        this = _optim.new_Cobyla(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_Cobyla
    __del__ = lambda self: None
Cobyla_swigregister = _optim.Cobyla_swigregister
Cobyla_swigregister(Cobyla)

class TNC(OptimizationAlgorithmImplementation):
    """
    Truncated Newton Constrained solver.

    Available constructors:
        TNC(*problem*)

        TNC(*problem, scale, offset, maxCGit, eta, stepmx, accuracy, fmin, rescale*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    specificParameters : :class:`~openturns.TNCSpecificParameters`
        Parameters for this solver.
    scale : sequence of float
        Scaling factors to apply to each variables
    offset : sequence of float
        Constant to substract to each variable
    maxCGit : int
        Maximum number of hessian*vector evaluation per main iteration
    eta : float
        Severity of the line search.
    stepmx : float
        Maximum step for the line search. may be increased during call
    accuracy : float
        Relative precision for finite difference calculations
    fmin : float
        Minimum function value estimate.
    rescale : float
        f scaling factor (in log10) used to trigger f value rescaling

    Notes
    -----
    Non-linear optimizer supporting bound constraints.
    This solver does not implement the progress callback.

    See also
    --------
    AbdoRackwitz, SQP, Cobyla, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> bounds = ot.Interval([1.0]*4, [2.0]*4)
    >>> problem = ot.OptimizationProblem(model, ot.Function(), ot.Function(), bounds)
    >>> algo = ot.TNC(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TNC, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TNC, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.TNC_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.TNC_run(self)


    def getScale(self):
        """
        Accessor to scale parameter.

        Returns
        -------
        scale : :class:`~openturns.Point`
            Scaling factors to apply to each variable

            if empty, the factors are min-max for interval bounded variables

            and 1+|x] for the others.
        """
        return _optim.TNC_getScale(self)


    def setScale(self, scale):
        """
        Accessor to scale parameter.

        Parameters
        ----------
        scale : sequence of float
            Scaling factors to apply to each variable

            if empty, the factors are min-max for interval bounded variables

            and 1+|x] for the others.
        """
        return _optim.TNC_setScale(self, scale)


    def getOffset(self):
        """
        Accessor to offset parameter.

        Returns
        -------
        offset : :class:`~openturns.Point`
            Constant to substract to each variable

            if empty, the constant are (min-max)/2 for interval bounded

            variables and x for the others.
        """
        return _optim.TNC_getOffset(self)


    def setOffset(self, offset):
        """
        Accessor to offset parameter.

        Parameters
        ----------
        offset : sequence of float
            Constant to substract to each variable

            if empty, the constant are (min-max)/2 for interval bounded

            variables and x for the others.
        """
        return _optim.TNC_setOffset(self, offset)


    def getMaxCGit(self):
        """
        Accessor to maxCGit parameter.

        Returns
        -------
        maxCGit : int
            Maximum number of hessian*vector evaluation per main iteration

            if maxCGit = 0, the direction chosen is -gradient

            if maxCGit < 0, maxCGit is set to max(1,min(50,n/2)).
        """
        return _optim.TNC_getMaxCGit(self)


    def setMaxCGit(self, maxCGit):
        """
        Accessor to maxCGit parameter.

        Parameters
        ----------
        maxCGit : int
            Maximum number of hessian*vector evaluation per main iteration

            if maxCGit = 0, the direction chosen is -gradient

            if maxCGit < 0, maxCGit is set to max(1,min(50,n/2)).
        """
        return _optim.TNC_setMaxCGit(self, maxCGit)


    def getEta(self):
        """
        Accessor to eta parameter.

        Returns
        -------
        eta : float
            Severity of the line search.

            if < 0 or > 1, set to 0.25.
        """
        return _optim.TNC_getEta(self)


    def setEta(self, eta):
        """
        Accessor to eta parameter.

        Parameters
        ----------
        eta : float
            Severity of the line search.

            if < 0 or > 1, set to 0.25.
        """
        return _optim.TNC_setEta(self, eta)


    def getStepmx(self):
        """
        Accessor to stepmx parameter.

        Returns
        -------
        stepmx : float
            Maximum step for the line search. may be increased during call

            if too small, will be set to 10.0.
        """
        return _optim.TNC_getStepmx(self)


    def setStepmx(self, stepmx):
        """
        Accessor to stepmx parameter.

        Parameters
        ----------
        stepmx : float
            Maximum step for the line search. may be increased during call

            if too small, will be set to 10.0.
        """
        return _optim.TNC_setStepmx(self, stepmx)


    def getAccuracy(self):
        """
        Accessor to accuracy parameter.

        Returns
        -------
        accuracy : float
            Relative precision for finite difference calculations

            if <= machine_precision, set to sqrt(machine_precision).
        """
        return _optim.TNC_getAccuracy(self)


    def setAccuracy(self, accuracy):
        """
        Accessor to accuracy parameter.

        Parameters
        ----------
        accuracy : float
            Relative precision for finite difference calculations

            if <= machine_precision, set to sqrt(machine_precision).
        """
        return _optim.TNC_setAccuracy(self, accuracy)


    def getFmin(self):
        """
        Accessor to fmin parameter.

        Returns
        -------
        fmin : float
            Minimum function value estimate.
        """
        return _optim.TNC_getFmin(self)


    def setFmin(self, fmin):
        """
        Accessor to fmin parameter.

        Parameters
        ----------
        fmin : float
            Minimum function value estimate.
        """
        return _optim.TNC_setFmin(self, fmin)


    def getRescale(self):
        """
        Accessor to rescale parameter.

        Returns
        -------
        rescale : float
            f scaling factor (in log10) used to trigger f value rescaling

            if 0, rescale at each iteration

            if a big value, never rescale

            if < 0, rescale is set to 1.3.
        """
        return _optim.TNC_getRescale(self)


    def setRescale(self, rescale):
        """
        Accessor to rescale parameter.

        Parameters
        ----------
        rescale : float
            f scaling factor (in log10) used to trigger f value rescaling

            if 0, rescale at each iteration

            if a big value, never rescale

            if < 0, rescale is set to 1.3.
        """
        return _optim.TNC_setRescale(self, rescale)


    def __repr__(self):
        return _optim.TNC___repr__(self)

    def __init__(self, *args):
        this = _optim.new_TNC(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_TNC
    __del__ = lambda self: None
TNC_swigregister = _optim.TNC_swigregister
TNC_swigregister(TNC)

class SQP(OptimizationAlgorithmImplementation):
    """
    Sequential Quadratic Programming solver.

    Available constructors:
        SQP(*problem*)

        SQP(*problem, tau, omega, smooth*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    tau : float
        Multiplicative decrease of linear step.
    omega : float
        Armijo factor.
    smooth : float
        Growing factor in penalization term.

    Notes
    -----
    SQP methods solve a sequence of optimization subproblems,
    each of which optimizes a quadratic model of the objective
    subject to a linearization of the constraints.

    See also
    --------
    AbdoRackwitz, Cobyla, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'], ['x1*cos(x1)+2*x2*x3-3*x3+4*x3*x4'])
    >>> problem = ot.OptimizationProblem(model, -0.5)
    >>> algo = ot.SQP(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SQP, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SQP, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.SQP_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.SQP_run(self)


    def getTau(self):
        """
        Accessor to tau parameter.

        Returns
        -------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.SQP_getTau(self)


    def setTau(self, tau):
        """
        Accessor to tau parameter.

        Parameters
        ----------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.SQP_setTau(self, tau)


    def getOmega(self):
        """
        Accessor to omega parameter.

        Returns
        -------
        omega : float
            Armijo factor.
        """
        return _optim.SQP_getOmega(self)


    def setOmega(self, tau):
        """
        Accessor to omega parameter.

        Parameters
        ----------
        omega : float
            Armijo factor.
        """
        return _optim.SQP_setOmega(self, tau)


    def getSmooth(self):
        """
        Accessor to smooth parameter.

        Returns
        -------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.SQP_getSmooth(self)


    def setSmooth(self, tau):
        """
        Accessor to smooth parameter.

        Parameters
        ----------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.SQP_setSmooth(self, tau)


    def __repr__(self):
        return _optim.SQP___repr__(self)

    def __init__(self, *args):
        this = _optim.new_SQP(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_SQP
    __del__ = lambda self: None
SQP_swigregister = _optim.SQP_swigregister
SQP_swigregister(SQP)

class MultiStart(OptimizationAlgorithmImplementation):
    """
    Multi start optimization algorithm.

    The algorithm runs an optimization solver for N starting points and returns the
    best result of each local search.
    The algorithm succeeds when at least one local search succeeds.

    Available constructors:

        MultiStart(*solver, startingPoints*)

    Parameters
    ----------
    solver : :class:`~openturns.OptimizationAlgorithm`
        The internal solver
    startingPoints : 2-d sequence of float
        Starting point candidates

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 2
    >>> model = ot.SymbolicFunction(['x', 'y'], ['x^2+y^2*(1-x)^3'])
    >>> bounds = ot.Interval([-3.0] * dim, [3.0] * dim)
    >>> problem = ot.OptimizationProblem(model)
    >>> problem.setBounds(bounds)
    >>> solver = ot.TNC(problem)
    >>> startingPoints = ot.Normal(dim).getSample(3)
    >>> algo = ot.MultiStart(solver, startingPoints)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiStart, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiStart, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.MultiStart_getClassName(self)


    def __repr__(self):
        return _optim.MultiStart___repr__(self)

    def run(self):
        """Launch the optimization."""
        return _optim.MultiStart_run(self)


    def setProblem(self, problem):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.MultiStart_setProblem(self, problem)


    def setOptimizationAlgorithm(self, solver):
        """
        Solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The internal solver
        """
        return _optim.MultiStart_setOptimizationAlgorithm(self, solver)


    def getOptimizationAlgorithm(self):
        """
        Solver accessor.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The internal solver
        """
        return _optim.MultiStart_getOptimizationAlgorithm(self)


    def setOptimizationSolver(self, solver):
        return _optim.MultiStart_setOptimizationSolver(self, solver)

    def getOptimizationSolver(self):
        return _optim.MultiStart_getOptimizationSolver(self)

    def setStartingPoints(self, sample):
        """
        Starting points accessor.

        Parameters
        ----------
        startingPointNumber : :class:`~openturns.Sample`
            Starting points
        """
        return _optim.MultiStart_setStartingPoints(self, sample)


    def getStartingPoints(self):
        """
        Starting points accessor.

        Returns
        -------
        startingPointNumber : :class:`~openturns.Sample`
            Starting points
        """
        return _optim.MultiStart_getStartingPoints(self)


    def getResultCollection(self):
        """
        Intermediate optimization results accessor.

        Returns
        -------
        results : :class:`~openturns.OptimizationResultCollection`
            Intermediate optimization results
        """
        return _optim.MultiStart_getResultCollection(self)


    def __init__(self, *args):
        this = _optim.new_MultiStart(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_MultiStart
    __del__ = lambda self: None
MultiStart_swigregister = _optim.MultiStart_swigregister
MultiStart_swigregister(MultiStart)

class NLopt(OptimizationAlgorithmImplementation):
    """
    Interface to NLopt.

    This class exposes the solvers from the non-linear optimization library [NLopt]_.

    More details about available algorithms are available `here <http://ab-initio.mit.edu/wiki/index.php/NLopt_Algorithms>`_.

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    algoName : str
        The NLopt identifier of the algorithm.
        Use :func:`GetAlgorithmNames()` to list available names.

    Notes
    -----
    This solver does not implement the progress callback.

    See also
    --------
    AbdoRackwitz, Cobyla, SQP, TNC

    Examples
    --------
    >>> import openturns as ot
    >>> dim = 4
    >>> bounds = ot.Interval([-3.0] * dim, [5.0] * dim)
    >>> linear = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(linear, ot.Function(), ot.Function(), bounds)
    >>> algo = ot.NLopt(problem, 'LD_MMA')
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NLopt, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NLopt, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NLopt_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.NLopt_run(self)


    def GetAlgorithmNames():
        """
        Accessor to the list of algorithms provided by NLopt, by names.

        Returns
        -------
        names : :class:`~openturns.Description`
            List of algorithm names provided by NLopt, according to its naming convention.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NLopt.GetAlgorithmNames())
        [AUGLAG,AUGLAG_EQ,GD_MLSL,GD_MLSL_LDS,GD_STOGO,GD_STOGO_RAND,GN_CRS2_LM,GN_DIRECT,GN_DIRECT_L,GN_DIRECT_L_NOSCAL,GN_DIRECT_L_RAND,GN_DIRECT_L_RAND_NOSCAL,GN_DIRECT_NOSCAL,GN_ESCH,GN_ISRES,GN_MLSL,GN_MLSL_LDS,GN_ORIG_DIRECT,GN_ORIG_DIRECT_L,G_MLSL,G_MLSL_LDS,LD_AUGLAG,LD_AUGLAG_EQ,LD_CCSAQ,LD_LBFGS,LD_LBFGS_NOCEDAL,LD_MMA,LD_SLSQP,LD_TNEWTON,LD_TNEWTON_PRECOND,LD_TNEWTON_PRECOND_RESTART,LD_TNEWTON_RESTART,LD_VAR1,LD_VAR2,LN_AUGLAG,LN_AUGLAG_EQ,LN_BOBYQA,LN_COBYLA,LN_NELDERMEAD,LN_NEWUOA,LN_NEWUOA_BOUND,LN_PRAXIS,LN_SBPLX]#43
        """
        return _optim.NLopt_GetAlgorithmNames()

    GetAlgorithmNames = staticmethod(GetAlgorithmNames)

    def setAlgorithmName(self, algoName):
        """
        Accessor to the algorithm name.

        Parameters
        ----------
        algoName : str
            The NLopt identifier of the algorithm.
        """
        return _optim.NLopt_setAlgorithmName(self, algoName)


    def getAlgorithmName(self):
        """
        Accessor to the algorithm name.

        Returns
        -------
        algoName : str
            The NLopt identifier of the algorithm.
        """
        return _optim.NLopt_getAlgorithmName(self)


    def setInitialStep(self, initialStep):
        """
        Initial local derivative-free algorithms step accessor.

        Parameters
        ----------
        dx : sequence of float
            The initial step.
        """
        return _optim.NLopt_setInitialStep(self, initialStep)


    def getInitialStep(self):
        """
        Initial local derivative-free algorithms step accessor.

        Returns
        -------
        dx : :class:`~openturns.Point`
            The initial step.
        """
        return _optim.NLopt_getInitialStep(self)


    def setLocalSolver(self, localSolver):
        """
        Local solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.NLopt`
            The local solver.
        """
        return _optim.NLopt_setLocalSolver(self, localSolver)


    def getLocalSolver(self):
        """
        Local solver accessor.

        Returns
        -------
        solver : :class:`~openturns.NLopt`
            The local solver.
        """
        return _optim.NLopt_getLocalSolver(self)


    def SetSeed(seed):
        """
        Initialize the random generator seed.

        Parameters
        ----------
        seed : int
            The RNG seed.
        """
        return _optim.NLopt_SetSeed(seed)

    SetSeed = staticmethod(SetSeed)

    def __repr__(self):
        return _optim.NLopt___repr__(self)

    def __str__(self, *args):
        return _optim.NLopt___str__(self, *args)

    def __init__(self, *args):
        this = _optim.new_NLopt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_NLopt
    __del__ = lambda self: None
NLopt_swigregister = _optim.NLopt_swigregister
NLopt_swigregister(NLopt)

def NLopt_GetAlgorithmNames():
    """
    Accessor to the list of algorithms provided by NLopt, by names.

    Returns
    -------
    names : :class:`~openturns.Description`
        List of algorithm names provided by NLopt, according to its naming convention.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NLopt.GetAlgorithmNames())
    [AUGLAG,AUGLAG_EQ,GD_MLSL,GD_MLSL_LDS,GD_STOGO,GD_STOGO_RAND,GN_CRS2_LM,GN_DIRECT,GN_DIRECT_L,GN_DIRECT_L_NOSCAL,GN_DIRECT_L_RAND,GN_DIRECT_L_RAND_NOSCAL,GN_DIRECT_NOSCAL,GN_ESCH,GN_ISRES,GN_MLSL,GN_MLSL_LDS,GN_ORIG_DIRECT,GN_ORIG_DIRECT_L,G_MLSL,G_MLSL_LDS,LD_AUGLAG,LD_AUGLAG_EQ,LD_CCSAQ,LD_LBFGS,LD_LBFGS_NOCEDAL,LD_MMA,LD_SLSQP,LD_TNEWTON,LD_TNEWTON_PRECOND,LD_TNEWTON_PRECOND_RESTART,LD_TNEWTON_RESTART,LD_VAR1,LD_VAR2,LN_AUGLAG,LN_AUGLAG_EQ,LN_BOBYQA,LN_COBYLA,LN_NELDERMEAD,LN_NEWUOA,LN_NEWUOA_BOUND,LN_PRAXIS,LN_SBPLX]#43
    """
    return _optim.NLopt_GetAlgorithmNames()

def NLopt_SetSeed(seed):
    """
    Initialize the random generator seed.

    Parameters
    ----------
    seed : int
        The RNG seed.
    """
    return _optim.NLopt_SetSeed(seed)

class LevelSet(openturns.typ.DomainImplementation):
    """
    Level set.

    Available constructors:
        LevelSet(*dim=1*)

        LevelSet(*function=ot.SymbolicFunction(['x'], ['1.0']), level=0.0*)

    Parameters
    ----------
    dim : int, :math:`dim \\geq 0`
        Dimension of the LevelSet.
    function : :class:`~openturns.Function`
        A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
        LevelSet.
    level : float
        Level :math:`s` defining the LevelSet.

    Notes
    -----
    A LevelSet is a :class:`~openturns.Domain` defined as follows:

    .. math::

        \\{ \\vect{x} \\in \\Rset^{dim} \\, | \\, f(\\vect{x}) \\leq s \\}

    Examples
    --------
    >>> import openturns as ot
    >>> function = ot.SymbolicFunction(['x1', 'x2'], ['x1^4 + x2^4'])
    >>> s = 1.0
    >>> levelSet = ot.LevelSet(function, s)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelSet, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelSet, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.LevelSet_getClassName(self)


    def contains(self, point):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _optim.LevelSet_contains(self, point)


    def intersect(self, other):
        """
        Return the levelSet equals to the intersection between the LevelSet and another one.

        Parameters
        ----------
        otherLevelSet :
            A LevelSet defined by :math:`(f_2, s_2)`.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            *levelSet* equals to the intersection between the LevelSet and
            *otherLevelSet* i.e. *levelSet* is defined by:
            :math:`\\{\\vect{x} \\in \\Rset^{dim} | f(\\vect{x}) \\leq s \\, \\mbox{and} \\, f_2(\\vect{x}) \\leq s_2\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> # First level set
        >>> function = ot.SymbolicFunction(['x'], ['3*x-1'])
        >>> levelSet1 = ot.LevelSet(function, 0.5)
        >>> # Second level set
        >>> function = ot.SymbolicFunction(['x'], ['x'])
        >>> levelSet2 = ot.LevelSet(function, 0.5)
        >>> # Intersection between levelSet1 and levelSet2
        >>> intersection = levelSet1.intersect(levelSet2)
        >>> # Tests
        >>> print(intersection.contains([1.0]))
        False
        >>> print(intersection.contains([0.25]))
        True
        """
        return _optim.LevelSet_intersect(self, other)


    def join(self, other):
        """
        Return the levelSet equals to the union between the LevelSet and another one.

        Parameters
        ----------
        otherLevelSet :
            A LevelSet defined by :math:`(f_2, s_2)`.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            *levelSet* equals to the union between the LevelSet and *otherLevelSet*
            i.e. *levelSet* is defined by:
            :math:`\\{\\vect{x} \\in \\Rset^{dim} | f(\\vect{x}) \\leq s \\, \\mbox{or} \\, f_2(\\vect{x}) \\leq s_2\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> # First level set
        >>> function = ot.SymbolicFunction(['x'], ['3*x-1'])
        >>> levelSet1 = ot.LevelSet(function, 0.0)
        >>> # Second level set
        >>> function = ot.SymbolicFunction(['x'], ['x'])
        >>> levelSet2 = ot.LevelSet(function, 0.0)
        >>> # Union between levelSet1 and levelSet2
        >>> join = levelSet1.join(levelSet2)
        >>> # Tests
        >>> print(join.contains([0.5]))
        False
        >>> print(join.contains([0.25]))
        True
        """
        return _optim.LevelSet_join(self, other)


    def __eq__(self, other):
        return _optim.LevelSet___eq__(self, other)

    def getFunction(self):
        """
        Get the function defining the level set.

        Returns
        -------
        function : :class:`~openturns.Function`
            A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
            LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> function = ot.SymbolicFunction(['x'], ['3*x-1'])
        >>> levelSet = ot.LevelSet(function, 0.0)
        >>> print(levelSet.getFunction().getEvaluation())
        [x]->[3*x-1]
        """
        return _optim.LevelSet_getFunction(self)


    def setFunction(self, function):
        """
        Set the function defining the level set.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
            LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> levelSet = ot.LevelSet()
        >>> function = ot.SymbolicFunction(['x'], ['3*x-1'])
        >>> levelSet.setFunction(function)
        """
        return _optim.LevelSet_setFunction(self, function)


    def getLevel(self):
        """
        Get the level defining the level set.

        Returns
        -------
        level : float
            Level :math:`s` defining the LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> function = ot.SymbolicFunction(['x'], ['3*x-1'])
        >>> levelSet = ot.LevelSet(function, 0.0)
        >>> print(levelSet.getLevel())
        0.0
        """
        return _optim.LevelSet_getLevel(self)


    def setLevel(self, level):
        """
        Set the level defining the level set.

        Parameters
        ----------
        level : float
            Level :math:`s` defining the LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> levelSet = ot.LevelSet()
        >>> levelSet.setLevel(3.0)
        """
        return _optim.LevelSet_setLevel(self, level)


    def setLowerBound(self, bound):
        """
        Set the lower bound of the bounding box.

        Parameters
        ----------
        bound : sequence of floats
            Lower bound of the bounding box of the level set. It allows to clip the level set.
        """
        return _optim.LevelSet_setLowerBound(self, bound)


    def getLowerBound(self):
        """
        Get the lower bound of the domain.

        Returns
        -------
        lower : :class:`~openturns.Point`
            The lower bound of an axes-aligned bounding box of the domain.
        """
        return _optim.LevelSet_getLowerBound(self)


    def setUpperBound(self, bound):
        """
        Set the upper bound of the bounding box.

        Parameters
        ----------
        bound : sequence of floats
            Upper bound of the bounding box of the level set. It allows to clip the level set.
        """
        return _optim.LevelSet_setUpperBound(self, bound)


    def getUpperBound(self):
        """
        Get the upper bound of the domain.

        Returns
        -------
        upper : :class:`~openturns.Point`
            The upper bound of an axes-aligned bounding box of the domain.
        """
        return _optim.LevelSet_getUpperBound(self)


    def __repr__(self):
        return _optim.LevelSet___repr__(self)

    def __str__(self, *args):
        return _optim.LevelSet___str__(self, *args)

    def __init__(self, *args):
        this = _optim.new_LevelSet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_LevelSet
    __del__ = lambda self: None
LevelSet_swigregister = _optim.LevelSet_swigregister
LevelSet_swigregister(LevelSet)

class LevelSetMesher(openturns.common.PersistentObject):
    """
    Creation of mesh of box type.

    Available constructor:
        LevelSetMesher(*discretization*)

    Parameters
    ----------
    discretization : sequence of int, of dimension :math:`\\leq 3`.
        Discretization of the level set bounding box.
    solver : :class:`~openturns.OptimizationAlgorithm`
        Optimization solver used to project the vertices onto the level set.
        It must be able to solve nearest point problems.
        Default is :class:`~openturns.AbdoRackwitz`.

    Notes
    -----
    The meshing algorithm is based on the :class:`~openturns.IntervalMesher` class.
    First, the bounding box of the level set (provided by the user or automatically
    computed) is meshed. Then, all the simplices with all vertices outside of the
    level set are rejected, while the simplices with all vertices inside of the level
    set are kept. The remaining simplices are adapted the following way :

      * The mean point of the vertices inside of the level set is computed

      * Each vertex outside of the level set is projected onto the level set using
        a linear interpolation

      * If the *project* flag is *True*, then the projection is refined using an
        optimization solver.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> mesher = ot.LevelSetMesher([5, 10])
    >>> level = 1.0
    >>> function = ot.SymbolicFunction(['x0', 'x1'], ['x0^2+x1^2'])
    >>> levelSet = ot.LevelSet(function, level)
    >>> mesh = mesher.build(levelSet)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelSetMesher, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelSetMesher, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.LevelSetMesher_getClassName(self)


    def setDiscretization(self, discretization):
        """
        Accessor to the discretization.

        Parameters
        ----------
        discretization : sequence of int
            Discretization of the bounding box of the level sets.
        """
        return _optim.LevelSetMesher_setDiscretization(self, discretization)


    def getDiscretization(self):
        """
        Accessor to the discretization.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            Discretization of the bounding box of the level sets.
        """
        return _optim.LevelSetMesher_getDiscretization(self)


    def __repr__(self):
        return _optim.LevelSetMesher___repr__(self)

    def __str__(self, *args):
        return _optim.LevelSetMesher___str__(self, *args)

    def setOptimizationAlgorithm(self, solver):
        """
        Accessor to the optimization solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The optimization solver used to project vertices onto the level set.
        """
        return _optim.LevelSetMesher_setOptimizationAlgorithm(self, solver)


    def getOptimizationAlgorithm(self):
        """
        Accessor to the optimization solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The optimization solver used to project vertices onto the level set.
        """
        return _optim.LevelSetMesher_getOptimizationAlgorithm(self)


    def setOptimizationSolver(self, solver):
        return _optim.LevelSetMesher_setOptimizationSolver(self, solver)

    def getOptimizationSolver(self):
        return _optim.LevelSetMesher_getOptimizationSolver(self)

    def build(self, *args):
        """
        Build the mesh of level set type.

        Parameters
        ----------
        levelSet : :class:`~openturns.LevelSet`
            The level set to be meshed, of dimension equal to the dimension
            of `discretization`.
        boundingBox : :class:`~openturns.Interval`
            The bounding box used to mesh the level set. By default it is automatically computed from the elements of the given level set.
        project : bool
            Flag to tell if the vertices outside of the level set of a simplex partially included into the level set have to be projected onto the level set. Default is *True*.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh built.
        """
        return _optim.LevelSetMesher_build(self, *args)


    def __init__(self, *args):
        this = _optim.new_LevelSetMesher(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_LevelSetMesher
    __del__ = lambda self: None
LevelSetMesher_swigregister = _optim.LevelSetMesher_swigregister
LevelSetMesher_swigregister(LevelSetMesher)

class SolverImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementationPointer, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ptr_"] = _optim.SolverImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.SolverImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_optim.SolverImplementationPointer_ptr__get, _optim.SolverImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _optim.new_SolverImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_SolverImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _optim.SolverImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _optim.SolverImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _optim.SolverImplementationPointer___deref__(self)

    def isNull(self):
        return _optim.SolverImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _optim.SolverImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _optim.SolverImplementationPointer_get(self)

    def getImplementation(self):
        return _optim.SolverImplementationPointer_getImplementation(self)

    def unique(self):
        return _optim.SolverImplementationPointer_unique(self)

    def use_count(self):
        return _optim.SolverImplementationPointer_use_count(self)

    def swap(self, other):
        return _optim.SolverImplementationPointer_swap(self, other)
SolverImplementationPointer_swigregister = _optim.SolverImplementationPointer_swigregister
SolverImplementationPointer_swigregister(SolverImplementationPointer)

class OptimizationProblemImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _optim.OptimizationProblemImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.OptimizationProblemImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_optim.OptimizationProblemImplementationPointer_ptr__get, _optim.OptimizationProblemImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _optim.new_OptimizationProblemImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _optim.OptimizationProblemImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _optim.OptimizationProblemImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _optim.OptimizationProblemImplementationPointer___deref__(self)

    def isNull(self):
        return _optim.OptimizationProblemImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _optim.OptimizationProblemImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _optim.OptimizationProblemImplementationPointer_get(self)

    def getImplementation(self):
        return _optim.OptimizationProblemImplementationPointer_getImplementation(self)

    def unique(self):
        return _optim.OptimizationProblemImplementationPointer_unique(self)

    def use_count(self):
        return _optim.OptimizationProblemImplementationPointer_use_count(self)

    def swap(self, other):
        return _optim.OptimizationProblemImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblemImplementationPointer_getClassName(self)


    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.Function`
            Objective function.
        """
        return _optim.OptimizationProblemImplementationPointer_getObjective(self)


    def setObjective(self, objective):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.Function`
            Objective function.

        Notes
        -----
        Constraints and bounds are cleared if the objective has a different input
        dimension in order to keep the problem valid at all time.
        """
        return _optim.OptimizationProblemImplementationPointer_setObjective(self, objective)


    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasMultipleObjective(self)


    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.Function`
            Describe equality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_getEqualityConstraint(self)


    def setEqualityConstraint(self, equalityConstraint):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.Function`
            Equality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_setEqualityConstraint(self, equalityConstraint)


    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasEqualityConstraint(self)


    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.Function`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_getInequalityConstraint(self)


    def setInequalityConstraint(self, inequalityConstraint):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.Function`
            Inequality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_setInequalityConstraint(self, inequalityConstraint)


    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasInequalityConstraint(self)


    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementationPointer_getBounds(self)


    def setBounds(self, bounds):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementationPointer_setBounds(self, bounds)


    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasBounds(self)


    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblemImplementationPointer_getLevelFunction(self)


    def setLevelFunction(self, levelFunction):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.Function`
            Level function.
        """
        return _optim.OptimizationProblemImplementationPointer_setLevelFunction(self, levelFunction)


    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasLevelFunction(self)


    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblemImplementationPointer_getLevelValue(self)


    def setLevelValue(self, levelValue):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblemImplementationPointer_setLevelValue(self, levelValue)


    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblemImplementationPointer_getDimension(self)


    def setMinimization(self, minimization):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_setMinimization(self, minimization)


    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_isMinimization(self)


    def __repr__(self):
        return _optim.OptimizationProblemImplementationPointer___repr__(self)

    def __eq__(self, arg2):
        return _optim.OptimizationProblemImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _optim.OptimizationProblemImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _optim.OptimizationProblemImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationProblemImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationProblemImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _optim.OptimizationProblemImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _optim.OptimizationProblemImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationPointer_setName(self, name)

OptimizationProblemImplementationPointer_swigregister = _optim.OptimizationProblemImplementationPointer_swigregister
OptimizationProblemImplementationPointer_swigregister(OptimizationProblemImplementationPointer)

class OptimizationAlgorithmImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationAlgorithmImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationAlgorithmImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _optim.OptimizationAlgorithmImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.OptimizationAlgorithmImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_optim.OptimizationAlgorithmImplementationPointer_ptr__get, _optim.OptimizationAlgorithmImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _optim.new_OptimizationAlgorithmImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _optim.delete_OptimizationAlgorithmImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _optim.OptimizationAlgorithmImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _optim.OptimizationAlgorithmImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _optim.OptimizationAlgorithmImplementationPointer___deref__(self)

    def isNull(self):
        return _optim.OptimizationAlgorithmImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _optim.OptimizationAlgorithmImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _optim.OptimizationAlgorithmImplementationPointer_get(self)

    def getImplementation(self):
        return _optim.OptimizationAlgorithmImplementationPointer_getImplementation(self)

    def unique(self):
        return _optim.OptimizationAlgorithmImplementationPointer_unique(self)

    def use_count(self):
        return _optim.OptimizationAlgorithmImplementationPointer_use_count(self)

    def swap(self, other):
        return _optim.OptimizationAlgorithmImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getClassName(self)


    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationAlgorithmImplementationPointer_run(self)


    def computeLagrangeMultipliers(self, x):
        """
        Compute the Lagrange multipliers of a problem at a given point.

        Parameters
        ----------
        x : sequence of float
            Point at which the Lagrange multipliers are computed.

        Returns
        -------
        lagrangeMultiplier : sequence of float
            Lagrange multipliers of the problem at the given point.

        Notes
        -----
        The Lagrange multipliers :math:`\\vect{\\lambda}` are associated with the following Lagrangian formulation of the optimization problem:

        .. math::

            \\cL(\\vect{x}, \\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq}) = J(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{eq} g(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{\\ell} (\\vect{x}-\\vect{\\ell})^{+} + \\Tr{\\vect{\\lambda}}_{u} (\\vect{u}-\\vect{x})^{+} + \\Tr{\\vect{\\lambda}}_{ineq}  h^{+}(\\vect{x})

        where :math:`\\vect{\\alpha}^{+}=(\\max(0,\\alpha_1),\\hdots,\\max(0,\\alpha_n))`.

        The Lagrange multipliers are stored as :math:`(\\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq})`, where:
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no equality
              constraint, else of dimension the dimension of :math:`g(\\vect{x})` ie the number of scalar equality constraints
            - :math:`\\vect{\\lambda}_{\\ell}` and :math:`\\vect{\\lambda}_{u}` are of dimension 0 if there is no bound constraint, else of dimension of :math:`\\vect{x}`
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no inequality constraint, else of dimension the dimension of :math:`h(\\vect{x})` ie the number of scalar inequality constraints

        The vector :math:`\\vect{\\lambda}` is solution of the following linear system:

        .. math::

            \\Tr{\\vect{\\lambda}}_{eq}\\left[\\dfrac{\\partial g}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{\\ell}\\left[\\dfrac{\\partial (\\vect{x}-\\vect{\\ell})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{u}\\left[\\dfrac{\\partial (\\vect{u}-\\vect{x})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{ineq}\\left[\\dfrac{\\partial h}{\\partial\\vect{x}}(\\vect{x})\\right]=-\\dfrac{\\partial J}{\\partial\\vect{x}}(\\vect{x})

        If there is no constraint of any kind, :math:`\\vect{\\lambda}` is of dimension 0, as well as if no constraint is active.

        """
        return _optim.OptimizationAlgorithmImplementationPointer_computeLagrangeMultipliers(self, x)


    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getStartingPoint(self)


    def setStartingPoint(self, startingPoint):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.Point`
            Starting point.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setStartingPoint(self, startingPoint)


    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getProblem(self)


    def setProblem(self, problem):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setProblem(self, problem)


    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getResult(self)


    def setResult(self, result):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setResult(self, result)


    def setMaximumIterationNumber(self, maximumIterationNumber):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumIterationNumber(self, maximumIterationNumber)


    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumIterationNumber(self)


    def setMaximumEvaluationNumber(self, maximumEvaluationNumber):
        """
        Accessor to maximum allowed number of evaluations.

        Parameters
        ----------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumEvaluationNumber(self, maximumEvaluationNumber)


    def getMaximumEvaluationNumber(self):
        """
        Accessor to maximum allowed number of evaluations.

        Returns
        -------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumEvaluationNumber(self)


    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumAbsoluteError(self)


    def setMaximumAbsoluteError(self, maximumAbsoluteError):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumAbsoluteError(self, maximumAbsoluteError)


    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumRelativeError(self)


    def setMaximumRelativeError(self, maximumRelativeError):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumRelativeError(self, maximumRelativeError)


    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumResidualError(self)


    def setMaximumResidualError(self, maximumResidualError):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumResidualError(self, maximumResidualError)


    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getMaximumConstraintError(self)


    def setMaximumConstraintError(self, maximumConstraintError):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setMaximumConstraintError(self, maximumConstraintError)


    def __repr__(self):
        return _optim.OptimizationAlgorithmImplementationPointer___repr__(self)

    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getVerbose(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setVerbose(self, verbose)


    def setProgressCallback(self, *args):
        """
        Set up a progress callback.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.

        """
        return _optim.OptimizationAlgorithmImplementationPointer_setProgressCallback(self, *args)


    def setStopCallback(self, *args):
        """
        Set up a stop callback.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.

        Notes
        -----
        May not be implemented by all solvers, refer to the solver documentation.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setStopCallback(self, *args)


    def __eq__(self, arg2):
        return _optim.OptimizationAlgorithmImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _optim.OptimizationAlgorithmImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _optim.OptimizationAlgorithmImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationAlgorithmImplementationPointer_setName(self, name)

OptimizationAlgorithmImplementationPointer_swigregister = _optim.OptimizationAlgorithmImplementationPointer_swigregister
OptimizationAlgorithmImplementationPointer_swigregister(OptimizationAlgorithmImplementationPointer)

# This file is compatible with both classic and new-style classes.


