# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Function primitives."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_func')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_func')
    _func = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_func', [dirname(__file__)])
        except ImportError:
            import _func
            return _func
        try:
            _mod = imp.load_module('_func', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _func = swig_import_helper()
    del swig_import_helper
else:
    import _func
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _func.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _func.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _func.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _func.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _func.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _func.SwigPyIterator_equal(self, x)

    def copy(self):
        return _func.SwigPyIterator_copy(self)

    def next(self):
        return _func.SwigPyIterator_next(self)

    def __next__(self):
        return _func.SwigPyIterator___next__(self)

    def previous(self):
        return _func.SwigPyIterator_previous(self)

    def advance(self, n):
        return _func.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _func.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _func.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _func.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _func.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _func.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _func.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _func.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _func.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.geom
import openturns.graph
class EnumerateFunctionImplementation(openturns.common.PersistentObject):
    """
    Enumerate function.

    Available constructors:
        EnumerateFunction(*dim=1*)

        EnumerateFunction(*dim, q*)

        EnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : positive int
        If *dim* is the only argument mentioned, it is used to create
        a :class:`~openturns.LinearEnumerateFunction` object of dimension *dim*.
        If *q* is also mentioned, it is used to create
        a :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object of
        dimension *dim* and parameter *q*.
    q : float
        The q-quasi-norm parameter used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.
    weight : sequence of float
        The weights of the indices in each dimension used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.

    Notes
    -----
    *EnumerateFunction* represents a bijection from :math:`\\Nset` to
    :math:`\\Nset^{dim}`. This bijection is based on a particular procedure of
    enumerating the set of multi-indices. It begins from the multi-index
    :math:`\\{0,0,\\dots,0\\}`.

    We associate a multi-index :math:`\\{j_{p1}, j_{p2},\\dots, j_{pdim}\\}` for every
    integer :math:`i_p` in :math:`\\Nset`:

    For more details, let us consider any :math:`i_p, i_q \\in \\Nset`:

    if :math:`|i_p-i_q|\\leq 1` then
    :math:`|\\sum_{k=1}^{dim} (j_{pk}- j_{qk})| \\leq 1`. This proposition provides a
    necessary but unsufficient condition for the construction of the bijection.
    Another assumption was done indicating the way of iteration.
    Below an example showing this assumption.

    Example for :math:`dim=2`:

    .. math::

        phi(0) &= [0 ~ 0] \\\\
        phi(1) &= [1 ~ 0] \\\\
        phi(2) &= [0 ~ 1] \\\\
        phi(3) &= [2 ~ 0] \\\\
        phi(4) &= [1 ~ 1] \\\\
        phi(5) &= [0 ~ 2] \\\\
        phi(6) &= [3 ~ 0]

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\\vect{i_p}` represents the collection of degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). In fact,
    after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* characterizes the term of the basis by providing the
    degrees of the univariate functions (respectively univariate polynomials).

    In order to know the degree of the :math:`k^{th}` polynomial of the
    multivariate basis, it is enough to sum all the integers given in the list.

    Examples
    --------
    >>> import openturns as ot
    >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
    >>> for i in range(6):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunctionImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunctionImplementation_getClassName(self)


    def __repr__(self):
        return _func.EnumerateFunctionImplementation___repr__(self)

    def __call__(self, index):
        return _func.EnumerateFunctionImplementation___call__(self, index)

    def inverse(self, indices):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.EnumerateFunctionImplementation_inverse(self, indices)


    def getStrataCardinal(self, strateIndex):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.EnumerateFunctionImplementation_getStrataCardinal(self, strateIndex)


    def getStrataCumulatedCardinal(self, strateIndex):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.EnumerateFunctionImplementation_getStrataCumulatedCardinal(self, strateIndex)


    def getMaximumDegreeStrataIndex(self, maximumDegree):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeStrataIndex(self, maximumDegree)


    def getMaximumDegreeCardinal(self, maximumDegree):
        """
        Get the cardinal of indices of degree inferior or equal to a given value.

        Parameters
        ----------
        maximumDegree : int
            Number of polynoms of the basis.

        Returns
        -------
        cardinal : int
            Cardinal of indices of degree :math:`max \\leq maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getMaximumDegreeCardinal(2))
        6
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeCardinal(self, maximumDegree)


    def setDimension(self, dimension):
        """
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_setDimension(self, dimension)


    def getDimension(self):
        """
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_getDimension(self)


    def __init__(self, *args):
        this = _func.new_EnumerateFunctionImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_EnumerateFunctionImplementation
    __del__ = lambda self: None
EnumerateFunctionImplementation_swigregister = _func.EnumerateFunctionImplementation_swigregister
EnumerateFunctionImplementation_swigregister(EnumerateFunctionImplementation)

class EnumerateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_EnumerateFunctionImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.EnumerateFunctionImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_EnumerateFunctionImplementationTypedInterfaceObject
    __del__ = lambda self: None
EnumerateFunctionImplementationTypedInterfaceObject_swigregister = _func.EnumerateFunctionImplementationTypedInterfaceObject_swigregister
EnumerateFunctionImplementationTypedInterfaceObject_swigregister(EnumerateFunctionImplementationTypedInterfaceObject)

class EnumerateFunction(EnumerateFunctionImplementationTypedInterfaceObject):
    """
    Enumerate function.

    Available constructors:
        EnumerateFunction(*dim=1*)

        EnumerateFunction(*dim, q*)

        EnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : positive int
        If *dim* is the only argument mentioned, it is used to create
        a :class:`~openturns.LinearEnumerateFunction` object of dimension *dim*.
        If *q* is also mentioned, it is used to create
        a :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object of
        dimension *dim* and parameter *q*.
    q : float
        The q-quasi-norm parameter used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.
    weight : sequence of float
        The weights of the indices in each dimension used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.

    Notes
    -----
    *EnumerateFunction* represents a bijection from :math:`\\Nset` to
    :math:`\\Nset^{dim}`. This bijection is based on a particular procedure of
    enumerating the set of multi-indices. It begins from the multi-index
    :math:`\\{0,0,\\dots,0\\}`.

    We associate a multi-index :math:`\\{j_{p1}, j_{p2},\\dots, j_{pdim}\\}` for every
    integer :math:`i_p` in :math:`\\Nset`:

    For more details, let us consider any :math:`i_p, i_q \\in \\Nset`:

    if :math:`|i_p-i_q|\\leq 1` then
    :math:`|\\sum_{k=1}^{dim} (j_{pk}- j_{qk})| \\leq 1`. This proposition provides a
    necessary but unsufficient condition for the construction of the bijection.
    Another assumption was done indicating the way of iteration.
    Below an example showing this assumption.

    Example for :math:`dim=2`:

    .. math::

        phi(0) &= [0 ~ 0] \\\\
        phi(1) &= [1 ~ 0] \\\\
        phi(2) &= [0 ~ 1] \\\\
        phi(3) &= [2 ~ 0] \\\\
        phi(4) &= [1 ~ 1] \\\\
        phi(5) &= [0 ~ 2] \\\\
        phi(6) &= [3 ~ 0]

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\\vect{i_p}` represents the collection of degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). In fact,
    after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* characterizes the term of the basis by providing the
    degrees of the univariate functions (respectively univariate polynomials).

    In order to know the degree of the :math:`k^{th}` polynomial of the
    multivariate basis, it is enough to sum all the integers given in the list.

    Examples
    --------
    >>> import openturns as ot
    >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
    >>> for i in range(6):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]
    """

    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunction_getClassName(self)


    def __repr__(self):
        return _func.EnumerateFunction___repr__(self)

    def __str__(self, *args):
        return _func.EnumerateFunction___str__(self, *args)

    def __call__(self, index):
        return _func.EnumerateFunction___call__(self, index)

    def inverse(self, indices):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.EnumerateFunction_inverse(self, indices)


    def getStrataCardinal(self, strataIndex):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.EnumerateFunction_getStrataCardinal(self, strataIndex)


    def getStrataCumulatedCardinal(self, strataIndex):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.EnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)


    def getMaximumDegreeStrataIndex(self, maximumDegree):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.EnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)


    def getMaximumDegreeCardinal(self, maximumDegree):
        """
        Get the cardinal of indices of degree inferior or equal to a given value.

        Parameters
        ----------
        maximumDegree : int
            Number of polynoms of the basis.

        Returns
        -------
        cardinal : int
            Cardinal of indices of degree :math:`max \\leq maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getMaximumDegreeCardinal(2))
        6
        """
        return _func.EnumerateFunction_getMaximumDegreeCardinal(self, maximumDegree)


    def setDimension(self, dimension):
        """
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_setDimension(self, dimension)


    def getDimension(self):
        """
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_getDimension(self)


    def __init__(self, *args):
        this = _func.new_EnumerateFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_EnumerateFunction
    __del__ = lambda self: None
EnumerateFunction_swigregister = _func.EnumerateFunction_swigregister
EnumerateFunction_swigregister(EnumerateFunction)

class LinearEnumerateFunction(EnumerateFunctionImplementation):
    """
    Linear enumerate function.

    Available constructors:
        LinearEnumerateFunction(*dim=1*)

    Parameters
    ----------
    dim : int
        Dimension.

    Notes
    -----
    Given an input random vector :math:`\\vect{X}` with prescribed probability
    density function (PDF) :math:`f_{\\vect{X}}(\\vect{x})`, it is possible to build
    up a *polynomial chaos* (PC) basis
    :math:`\\{\\psi_{\\vect{\\alpha}},\\vect{\\alpha} \\in \\Nset^{n_X}\\}`. Of interest is
    the definition of enumeration strategies for exploring this basis, i.e. of
    suitable *enumeration functions* :math:`\\tau` from :math:`\\Nset` to
    :math:`\\Nset^{n_X}`, which creates a one-to-one mapping between an integer
    :math:`j` and a multi-index :math:`\\Nset^{n_X}`.

    Let us first define the *total degree* of any multi-index :math:`\\vect{\\alpha}`
    in :math:`\\Nset^{n_X}` by :math:`\\sum_{i=1}^{n_X} \\alpha_i`. A natural choice to
    sort the PC basis (i.e. the multi-indices :math:`\\vect{\\alpha}`)
    is the lexicographical order with a constraint of increasing total degree.
    Mathematically speaking, a bijective enumeration function :math:`\\tau` is
    defined by:

    .. math::

        \\begin{array}{llcl}
          \\tau \\, : & \\Nset & \\longrightarrow & \\Nset^{n_X} \\\\
          &  j & \\longmapsto & \\{\\alpha_1,\\dots, \\alpha_{n_X}\\} \\,
                     \\equiv \\, \\{\\tau_1(j),\\dots,\\tau_{n_X}(j)\\} \\\\
        \\end{array}

    such that:

    .. math::

        \\tau(0) = \\{0,\\dots,0\\}

    and

    .. math::

        \\forall 1 \\leq j<k  \\quad \\, , \\quad \\, \\left\\{
        \\begin{array}{l}
          \\displaystyle{\\sum_{i=1}^{n_X} \\tau_i(j) < \\sum_{i=1}^{n_X} \\tau_i(k)}  \\\\
          \\\\
          \\mbox{ or} \\\\
          \\\\
          \\displaystyle{\\exists \\; m \\in \\{1,\\dots,n_X\\} \\; : \\;
              \\left(\\forall i \\leq m , \\; \\tau_i(j) = \\tau_i(k) \\; \\right)
              \\, \\, \\, \\mbox{ and } \\, \\, \\,
              \\left(\\tau_m(j) < \\tau_m(k) \\right)} \\\\
        \\end{array}
        \\right.

    Such an enumeration strategy is illustrated in a two-dimensional case
    (i.e. :math:`n_X=2`) in the figure below:

    .. plot:: pyplots/LinearEnumerateFunction.py
        :include-source: False

    This corresponds to the following enumeration of the multi-indices:

    ===== =====================
      j   :math:`\\vect{\\alpha} = \\{\\alpha_1,\\alpha_2\\}`
    ===== =====================
      0       {0, 0}
      1       {1, 0}
      2       {0, 1}
      3       {2, 0}
      4       {1, 1}
      5       {0, 2}
      6       {3, 0}
      7       {2, 1}
      8       {1, 2}
      9       {0, 3}
    ===== =====================

    See also
    --------
    EnumerateFunction, HyperbolicAnisotropicEnumerateFunction

    Examples
    --------
    >>> import openturns as ot
    >>> # 4-dimensional case
    >>> enumerateFunction = ot.LinearEnumerateFunction(4)
    >>> for i in range(9):
    ...     print(enumerateFunction(i))
    [0,0,0,0]
    [1,0,0,0]
    [0,1,0,0]
    [0,0,1,0]
    [0,0,0,1]
    [2,0,0,0]
    [1,1,0,0]
    [1,0,1,0]
    [1,0,0,1]
    """

    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnumerateFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearEnumerateFunction_getClassName(self)


    def __repr__(self):
        return _func.LinearEnumerateFunction___repr__(self)

    def __call__(self, index):
        return _func.LinearEnumerateFunction___call__(self, index)

    def inverse(self, indices):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.LinearEnumerateFunction_inverse(self, indices)


    def getStrataCardinal(self, strataIndex):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.LinearEnumerateFunction_getStrataCardinal(self, strataIndex)


    def getStrataCumulatedCardinal(self, strataIndex):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.LinearEnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)


    def getMaximumDegreeStrataIndex(self, maximumDegree):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.LinearEnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)


    def __init__(self, *args):
        this = _func.new_LinearEnumerateFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearEnumerateFunction
    __del__ = lambda self: None
LinearEnumerateFunction_swigregister = _func.LinearEnumerateFunction_swigregister
LinearEnumerateFunction_swigregister(LinearEnumerateFunction)

class HyperbolicAnisotropicEnumerateFunction(EnumerateFunctionImplementation):
    """
    Hyperbolic and anisotropic enumerate function.

    Available constructors:
        HyperbolicAnisotropicEnumerateFunction(*dim*)

        HyperbolicAnisotropicEnumerateFunction(*dim, q*)

        HyperbolicAnisotropicEnumerateFunction(*weight*)

        HyperbolicAnisotropicEnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : integer
        Dimension of the :class:`~openturns.EnumerateFunction`. *dim* must be equal
        to the dimension of the :class:`~openturns.OrthogonalBasis`.
    q : float
        Correspond to the q-quasi norm parameter. If not precised, :math:`q = 0.4`.
    weight : sequence of float
        Weights of the indices in each dimension. If not precised, all weights are
        equals to :math:`w_i = 1`.

    See also
    --------
    EnumerateFunction, LinearEnumerateFunction

    Notes
    -----
    The hyperbolic truncation strategy is inspired by the so-called sparsity-of-
    effects principle, which states that most models are principally governed by
    main effects and low-order interactions. Accordingly, one wishes to define an
    enumeration strategy which first selects those multi-indices related to main
    effects, i.e. with a reasonably small number of nonzero components, prior to
    selecting those associated with higher-order interactions.

    For any real number :math:`q \\in ]0, 1]`, one defines the anisotropic hyperbolic
    norm of a multi-index :math:`a` by:

    .. math::

        \\| \\vect{a} \\|_{\\vect{w}, q} = \\left( \\sum_{i=1}^{n_X} w_i a^q \\right)^{1/q}

    where the :math:`w_i`'s are real positive numbers. This would lead to first
    select the basis polynomials depending on a specific subset of input variables.

    Examples
    --------
    >>> import openturns as ot
    >>> # 4-dimensional case
    >>> enumerateFunction = ot.HyperbolicAnisotropicEnumerateFunction(2, 0.5)
    >>> for i in range(10):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [0,2]
    [3,0]
    [0,3]
    [1,1]
    [4,0]
    [0,4]

    """

    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HyperbolicAnisotropicEnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HyperbolicAnisotropicEnumerateFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getClassName(self)


    def __repr__(self):
        return _func.HyperbolicAnisotropicEnumerateFunction___repr__(self)

    def __call__(self, index):
        return _func.HyperbolicAnisotropicEnumerateFunction___call__(self, index)

    def inverse(self, indices):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_inverse(self, indices)


    def getStrataCardinal(self, strataIndex):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCardinal(self, strataIndex)


    def getStrataCumulatedCardinal(self, strataIndex):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCumulatedCardinal(self, strataIndex)


    def getMaximumDegreeStrataIndex(self, maximumDegree):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getMaximumDegreeStrataIndex(self, maximumDegree)


    def setQ(self, q):
        """
        Accessor to the norm.

        Parameters
        ----------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setQ(self, q)


    def getQ(self):
        """
        Accessor to the norm.

        Returns
        -------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getQ(self)


    def setWeight(self, weight):
        """
        Accessor to the weights.

        Parameters
        ----------
        w : sequence of float
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setWeight(self, weight)


    def getWeight(self):
        """
        Accessor to the weights.

        Returns
        -------
        w : :class:`~openturns.Point`
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getWeight(self)


    def __init__(self, *args):
        this = _func.new_HyperbolicAnisotropicEnumerateFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_HyperbolicAnisotropicEnumerateFunction
    __del__ = lambda self: None
HyperbolicAnisotropicEnumerateFunction_swigregister = _func.HyperbolicAnisotropicEnumerateFunction_swigregister
HyperbolicAnisotropicEnumerateFunction_swigregister(HyperbolicAnisotropicEnumerateFunction)

OT_TYPECHECK_FIELDIMPLEMENTATION = _func.OT_TYPECHECK_FIELDIMPLEMENTATION
class FieldImplementation(openturns.common.PersistentObject):
    """
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\\cD` a domain of :math:`\\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A class:`~openturns.Field` contains a mesh and the values associated to each
    vertice of the mesh. In the context of a stochastic process :math:`X`, a
    :class:`~openturns.Field` contains the mesh and a realization of :math:`X`
    discretized on this mesh.

    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = ot.IndicesCollection([[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]])
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldImplementation_getClassName(self)


    def getValueAtIndex(self, index):
        """
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.Point`
            The value of the field associated to the selected vertex, in :math:`\\Rset^d`.
        """
        return _func.FieldImplementation_getValueAtIndex(self, index)


    def setValueAtIndex(self, index, val):
        """
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.Point` in :math:`\\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.FieldImplementation_setValueAtIndex(self, index, val)


    def getValueAtNearestPosition(self, position):
        """
        Get the value of the field at the vertex of the mesh the nearest to the given point.

        Parameters
        ----------
        point : sequence of float in :math:`\\Rset^n`.

        Returns
        -------
        value : :class:`~openturns.Point` in :math:`\\Rset^d`.
            The value of the field associated to vertex the nearest of *point* with
            respect to the Euclidean norm.
        """
        return _func.FieldImplementation_getValueAtNearestPosition(self, position)


    def setValueAtNearestPosition(self, position, val):
        """
        Assign the value of the field to the vertex the nearest to a specified position.

        Parameters
        ----------
        position : sequence of float in :math:`\\Rset^n`.
        value : sequence of float in :math:`\\Rset^d`.
            New value assigned to the vertex the nearest to *position* with respect to
            the Euclidean norm.
        """
        return _func.FieldImplementation_setValueAtNearestPosition(self, position, val)


    def getValueAtNearestTime(self, timestamp):
        return _func.FieldImplementation_getValueAtNearestTime(self, timestamp)

    def setValueAtNearestTime(self, timestamp, val):
        return _func.FieldImplementation_setValueAtNearestTime(self, timestamp, val)

    def setDescription(self, description):
        """
        Set the description of the field..

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.FieldImplementation_setDescription(self, description)


    def getDescription(self):
        """
        Get the description of the vertices and the values of the field.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and the values of the field.
        """
        return _func.FieldImplementation_getDescription(self)


    def getMesh(self):
        """
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _func.FieldImplementation_getMesh(self)


    def getTimeGrid(self):
        """
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.FieldImplementation_getTimeGrid(self)


    def __eq__(self, other):
        return _func.FieldImplementation___eq__(self, other)

    def __repr__(self):
        return _func.FieldImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FieldImplementation___str__(self, *args)

    def getSize(self):
        """
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number of values inside the field, which corresponds to the number of
            vertices of the mesh.
        """
        return _func.FieldImplementation_getSize(self)


    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _func.FieldImplementation_getSpatialDimension(self)


    def getDimension(self):
        """
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the values: :math:`d`.
        """
        return _func.FieldImplementation_getDimension(self)


    def getSample(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.FieldImplementation_getSample(self)


    def getValues(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`). Identical to :meth:`getSample`.
        """
        return _func.FieldImplementation_getValues(self)


    def setValues(self, values):
        """
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.FieldImplementation_setValues(self, values)


    def getMarginal(self, *args):
        return _func.FieldImplementation_getMarginal(self, *args)

    def asSample(self):
        return _func.FieldImplementation_asSample(self)

    def asDeformedMesh(self):
        """
        Get the mesh deformed according to the values of the field.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            replaced by the sum of the vertex and the value of the field at this
            vertex. Only works when :math:`d=n`: the spatial dimension :math:`n`: is
            equal to the dimension of the field :math:`d`.
        """
        return _func.FieldImplementation_asDeformedMesh(self)


    def getSpatialMean(self):
        """
        Get the spatial weighted mean of the values of the field.

        Returns
        -------
        spatialMean : :class:`~openturns.Point`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The spatial mean of the field is defined by:

        .. math::

           \\displaystyle \\frac{1}{V} \\sum_{S_i \\in \\cM} \\left( \\frac{1}{n+1}\\sum_{k=0}^{n} \\vect{x}_{i_k}\\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\\vect{x}_{i_0}, \\dots, \\vect{x}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\\displaystyle V=\\sum_{S_i \\in \\cD} |S_i|`.
        """
        return _func.FieldImplementation_getSpatialMean(self)


    def getTemporalMean(self):
        """
        Get the mean of the values of the field.

        Returns
        -------
        temporalMean : :class:`~openturns.Point`
            Mean of the values of the field.

        Notes
        -----
        If we note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values in
        :math:`\\Rset^d` of the field, then the temporal mean is defined by:

        .. math::

           \\displaystyle  \\frac{1}{N} \\sum_{i=0}^{N-1} \\vect{x}_i

        Only makes sense in the case of a regular grid.
        """
        return _func.FieldImplementation_getTemporalMean(self)


    def drawMarginal(self, index=0, interpolate=True):
        """
        Draw one marginal field if the spatial dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.FieldImplementation_drawMarginal(self, index, interpolate)


    def draw(self):
        """
        Draw the first marginal of the field if the spatial dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.FieldImplementation_draw(self)


    def exportToVTKFile(self, fileName):
        """
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.FieldImplementation_exportToVTKFile(self, fileName)


    def __getitem__(self, *args):
        return _func.FieldImplementation___getitem__(self, *args)

    def __setitem__(self, *args):
        return _func.FieldImplementation___setitem__(self, *args)

    def __init__(self, *args):
        this = _func.new_FieldImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FieldImplementation
    __del__ = lambda self: None
FieldImplementation_swigregister = _func.FieldImplementation_swigregister
FieldImplementation_swigregister(FieldImplementation)

class FieldImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_FieldImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FieldImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FieldImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FieldImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.FieldImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_FieldImplementationTypedInterfaceObject
    __del__ = lambda self: None
FieldImplementationTypedInterfaceObject_swigregister = _func.FieldImplementationTypedInterfaceObject_swigregister
FieldImplementationTypedInterfaceObject_swigregister(FieldImplementationTypedInterfaceObject)

class Field(FieldImplementationTypedInterfaceObject):
    """
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\\cD` a domain of :math:`\\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A class:`~openturns.Field` contains a mesh and the values associated to each
    vertice of the mesh. In the context of a stochastic process :math:`X`, a
    :class:`~openturns.Field` contains the mesh and a realization of :math:`X`
    discretized on this mesh.

    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = ot.IndicesCollection([[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]])
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """

    __swig_setmethods__ = {}
    for _s in [FieldImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Field, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Field, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Field_getClassName(self)


    def getValueAtIndex(self, index):
        """
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.Point`
            The value of the field associated to the selected vertex, in :math:`\\Rset^d`.
        """
        return _func.Field_getValueAtIndex(self, index)


    def setValueAtIndex(self, index, val):
        """
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.Point` in :math:`\\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.Field_setValueAtIndex(self, index, val)


    def getValueAtNearestPosition(self, position):
        """
        Get the value of the field at the vertex of the mesh the nearest to the given point.

        Parameters
        ----------
        point : sequence of float in :math:`\\Rset^n`.

        Returns
        -------
        value : :class:`~openturns.Point` in :math:`\\Rset^d`.
            The value of the field associated to vertex the nearest of *point* with
            respect to the Euclidean norm.
        """
        return _func.Field_getValueAtNearestPosition(self, position)


    def setValueAtNearestPosition(self, position, val):
        """
        Assign the value of the field to the vertex the nearest to a specified position.

        Parameters
        ----------
        position : sequence of float in :math:`\\Rset^n`.
        value : sequence of float in :math:`\\Rset^d`.
            New value assigned to the vertex the nearest to *position* with respect to
            the Euclidean norm.
        """
        return _func.Field_setValueAtNearestPosition(self, position, val)


    def getMarginal(self, *args):
        return _func.Field_getMarginal(self, *args)

    def setDescription(self, description):
        """
        Set the description of the field..

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.Field_setDescription(self, description)


    def getDescription(self):
        """
        Get the description of the vertices and the values of the field.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and the values of the field.
        """
        return _func.Field_getDescription(self)


    def getMesh(self):
        """
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _func.Field_getMesh(self)


    def getTimeGrid(self):
        """
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.Field_getTimeGrid(self)


    def __eq__(self, other):
        return _func.Field___eq__(self, other)

    def __repr__(self):
        return _func.Field___repr__(self)

    def __str__(self, *args):
        return _func.Field___str__(self, *args)

    def getSize(self):
        """
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number of values inside the field, which corresponds to the number of
            vertices of the mesh.
        """
        return _func.Field_getSize(self)


    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _func.Field_getSpatialDimension(self)


    def getDimension(self):
        """
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the values: :math:`d`.
        """
        return _func.Field_getDimension(self)


    def getSample(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.Field_getSample(self)


    def getValues(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.Sample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`). Identical to :meth:`getSample`.
        """
        return _func.Field_getValues(self)


    def setValues(self, values):
        """
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.Field_setValues(self, values)


    def asDeformedMesh(self):
        """
        Get the mesh deformed according to the values of the field.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            replaced by the sum of the vertex and the value of the field at this
            vertex. Only works when :math:`d=n`: the spatial dimension :math:`n`: is
            equal to the dimension of the field :math:`d`.
        """
        return _func.Field_asDeformedMesh(self)


    def getSpatialMean(self):
        """
        Get the spatial weighted mean of the values of the field.

        Returns
        -------
        spatialMean : :class:`~openturns.Point`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The spatial mean of the field is defined by:

        .. math::

           \\displaystyle \\frac{1}{V} \\sum_{S_i \\in \\cM} \\left( \\frac{1}{n+1}\\sum_{k=0}^{n} \\vect{x}_{i_k}\\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\\vect{x}_{i_0}, \\dots, \\vect{x}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\\displaystyle V=\\sum_{S_i \\in \\cD} |S_i|`.
        """
        return _func.Field_getSpatialMean(self)


    def getTemporalMean(self):
        """
        Get the mean of the values of the field.

        Returns
        -------
        temporalMean : :class:`~openturns.Point`
            Mean of the values of the field.

        Notes
        -----
        If we note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values in
        :math:`\\Rset^d` of the field, then the temporal mean is defined by:

        .. math::

           \\displaystyle  \\frac{1}{N} \\sum_{i=0}^{N-1} \\vect{x}_i

        Only makes sense in the case of a regular grid.
        """
        return _func.Field_getTemporalMean(self)


    def drawMarginal(self, index=0, interpolate=True):
        """
        Draw one marginal field if the spatial dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.Field_drawMarginal(self, index, interpolate)


    def draw(self):
        """
        Draw the first marginal of the field if the spatial dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.Field_draw(self)


    def exportToVTKFile(self, fileName):
        """
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.Field_exportToVTKFile(self, fileName)


    def __init__(self, *args):
        this = _func.new_Field(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, index):
        return _func.Field___getitem__(self, index)

    def __setitem__(self, index, val):
        return _func.Field___setitem__(self, index, val)

    def __len__(self):
        return _func.Field___len__(self)
    __swig_destroy__ = _func.delete_Field
    __del__ = lambda self: None
Field_swigregister = _func.Field_swigregister
Field_swigregister(Field)

class TimeSeries(FieldImplementation):
    """
    Time series.

    Available constructors:
        TimeSeries(*nSteps,dim*)

        TimeSeries(*timeGrid, dim*)

        TimeSeries(*timeGrid, sample*)

        TimeSeries(*field*)

    Parameters
    ----------
    nSteps : int
        Enables to create a regular time grid on :math:`[0, nSteps]` which time step is equal to 1.

    timeGrid : :class:`~openturns.RegularGrid`
        Regular time grid of the time series.

    dim : int
        Dimension of the values of the time series at each time stamp. By default, the values are equal to the null vector.

    sample : 2-d sequence of float
        Values assigned to each time stamp of the time series.

    field : :class:`~openturns.Field`
        Maps a field into a time series when the associated lesh cn be interpretated as a regular time grid.

    Examples
    --------
    Create a time series:

    >>> import openturns as ot
    >>> tmin = 0.0
    >>> timeStep = 0.1
    >>> n = 5
    >>> myTimeGrid = ot.RegularGrid(tmin, timeStep, n)
    >>> myValues = [[1.0], [2.0], [1.5], [4.5], [0.5]]
    >>> myTimeSeries = ot.TimeSeries(myTimeGrid, myValues)

    Draw the time series:

    >>> graph = myTimeSeries.draw()
    """

    __swig_setmethods__ = {}
    for _s in [FieldImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeSeries, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeSeries, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TimeSeries_getClassName(self)


    def __repr__(self):
        return _func.TimeSeries___repr__(self)

    def __str__(self, *args):
        return _func.TimeSeries___str__(self, *args)

    def __eq__(self, other):
        return _func.TimeSeries___eq__(self, other)

    def add(self, *args):
        """
        Add a new value to the time series and extend the associated time grid.

        Available usages:
            add(*sample*)

            add(*timeSeries*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension the same as the dimension of the values of the time series.

        timeSeries : :class:`~openturns.TimeSeries`, which time grid must match with the initial time grid (one follows the other).

        Returns
        -------
        newTimeSeries: :class:`~openturns.TimeSeries`, which regular grid has been extended with a new time stamp or a second time grid, associated to the new values.

        """
        return _func.TimeSeries_add(self, *args)


    def __init__(self, *args):
        this = _func.new_TimeSeries(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_TimeSeries
    __del__ = lambda self: None
TimeSeries_swigregister = _func.TimeSeries_swigregister
TimeSeries_swigregister(TimeSeries)

class ProcessSample(openturns.common.PersistentObject):
    """
    Collection of fields.

    Available constructors:
        ProcessSample(*mesh, K, d*)

        ProcessSample(*K, field*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh shared by all the fields in the collection.
    K : int
        Number of fields in the collection.
    d : int
        Dimension  of the values of the field.
    field : :class:`~openturns.Field`
        One field.

    Notes
    -----
    A :class:`~openturns.ProcessSample` stores a sample of fields.
    We note `K` the number of fields contained in the process sample and `d` the dimension of the values associated to each vertex of the common mesh :math:`\\cM \\in \\Rset^n`.

    These fields can be generated by a stochastic process.

    - In the first usage, we fix the common mesh with `mesh`, the number of fields contained in the sample with `K` and the dimension of the values with `d`. The values of the fields are by default fixed to zero.

    - In the second usage, the  collection of fields is filled with `K` copies of the given field `field`.

    We note :math:`\\vect{x}_i^k \\in \\Rset^d` the value of the field `k` at the vertex `i`. We note `N` the number of vertices of :math:`\\cM`, with :math:`0 \\leq i \\leq N-1` and :math:`1 \\leq k \\leq K`.

    Examples
    --------
    Create a bi dimensional mesh as a box:

    >>> import openturns as ot
    >>> myIndices = [10, 5]
    >>> myMesher = ot.IntervalMesher(myIndices)
    >>> lowerBound = [0.0, 0.0]
    >>> upperBound = [2.0, 1.0]
    >>> myInterval = ot.Interval(lowerBound, upperBound)
    >>> myMesh = myMesher.build(myInterval)

    Create a second order normal porcess of dimension 3:

    >>> amplitude = [5]
    >>> scale = [3, 3]
    >>> model = ot.ExponentialModel(scale, amplitude)
    >>> myProcess = ot.GaussianProcess(model, myMesh)

    Generate a sample of different fields:

    >>> n = 10
    >>> mySampleFields = myProcess.getSample(n)

    Duplicate the same field:

    >>> myField = myProcess.getRealization()
    >>> n = 10
    >>> mySampleFields2 = ot.ProcessSample(n, myField)

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessSample, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessSample, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProcessSample_getClassName(self)


    def add(self, *args):
        """
        Add a field to the collection.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            A new field to add. 
            This field shares the same mesh and the same dimension as the other
            fields of the collection.

        """
        return _func.ProcessSample_add(self, *args)


    def __repr__(self):
        return _func.ProcessSample___repr__(self)

    def __str__(self, *args):
        return _func.ProcessSample___str__(self, *args)

    def getTimeGrid(self):
        """
        Get the time grid of the fields.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid shared by all the fields of the collection.
            Can be used only if the mesh can be interpreted as a regular time grid.

        """
        return _func.ProcessSample_getTimeGrid(self)


    def getMesh(self):
        """
        Get the mesh of the fields.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh shared by all the fields of the collection.

        """
        return _func.ProcessSample_getMesh(self)


    def getSize(self):
        """
        Get the size of the collection of fields.

        Returns
        -------
        K : int
            Number of fields in the collection.

        """
        return _func.ProcessSample_getSize(self)


    def getDimension(self):
        """
        Get the dimension of the values of fields.

        Returns
        -------
        d : int
            Dimension of the values of the fields.

        """
        return _func.ProcessSample_getDimension(self)


    def computeMean(self):
        """
        Compute the mean field of the collection of fields.

        Returns
        -------
        mean : :class:`~openturns.Field`
            The mean field has the same dimension `d` and the same mesh as the fields
            contained in the collection. At each vertex of the mesh, we calculate the
            mean of the values at this vertex of the `K` fields contained
            in the process sample:

        .. math::

            \\forall i \\in [0,N-1], \\quad \\dfrac{1}{K} \\sum_{k=1}^K \\vect{x}_i^k

        """
        return _func.ProcessSample_computeMean(self)


    def computeTemporalMean(self):
        """
        Compute the temporal mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`.
            The `k` numerical point is the temporal mean of the field `k`:

        .. math::

            \\forall k \\in [1,K], \\quad \\dfrac{1}{N}\\sum_{i=0}^{N-1} \\vect{x}_i^k

        This method can be used only when the mesh can be interpreted as a regular grid.

        """
        return _func.ProcessSample_computeTemporalMean(self)


    def computeSpatialMean(self):
        """
        Compute the spatial mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.Sample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`. The `k` numerical point is the spatial mean of the field `k`:

        .. math::

            \\forall k \\in [1,K], \\quad \\dfrac{1}{N}\\sum_{i=0}^{N-1} \\vect{x}_i^k

        """
        return _func.ProcessSample_computeSpatialMean(self)


    def computeQuantilePerComponent(self, prob):
        """
        Compute the temporal mean of the values of the fields.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            Order of the quantile.

        Returns
        -------
        quantileField : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we estimate the
            component-wise quantile of order `p`, using the empirical quantile.

        """
        return _func.ProcessSample_computeQuantilePerComponent(self, prob)


    def getMarginal(self, *args):
        return _func.ProcessSample_getMarginal(self, *args)

    def drawMarginal(self, index=0):
        """
        Draw the selected field.

        Parameters
        ----------
        indice : int
            Index of the field that is drawn in the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the selected field using the `interpolate` method.

        """
        return _func.ProcessSample_drawMarginal(self, index)


    def __init__(self, *args):
        this = _func.new_ProcessSample(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, index):
        return _func.ProcessSample___getitem__(self, index)

    def __setitem__(self, index, field):
        return _func.ProcessSample___setitem__(self, index, field)

    def __len__(self):
        return _func.ProcessSample___len__(self)
    __swig_destroy__ = _func.delete_ProcessSample
    __del__ = lambda self: None
ProcessSample_swigregister = _func.ProcessSample_swigregister
ProcessSample_swigregister(ProcessSample)

class SpecFunc(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpecFunc, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SpecFunc, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    if _newclass:
        IsNaN = staticmethod(_func.SpecFunc_IsNaN)
    else:
        IsNaN = _func.SpecFunc_IsNaN
    if _newclass:
        IsNormal = staticmethod(_func.SpecFunc_IsNormal)
    else:
        IsNormal = _func.SpecFunc_IsNormal

    def BesselI0(x):
        """
        Modified first kind Bessel function of order 0.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{I}_0(x) = \\sum_{m=0}^\\infty\\frac{1}{m!^2}\\left(\\frac{x}{2}\\right)^{2m}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselI0(x)

    BesselI0 = staticmethod(BesselI0)

    def LogBesselI0(x):
        """
        Logarithm of the modified first kind Bessel function of order 0.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselI0(x) = \\log (\\mathrm{I}_0(x))

        See also
        --------
        SpecFunc_BesselI0

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselI0(x)

    LogBesselI0 = staticmethod(LogBesselI0)

    def BesselI1(x):
        """
        Modified first kind Bessel function of order 1.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{I}_1(x) = \\sum_{m=0}^\\infty\\frac{1}{m!(m+1)!}\\left(\\frac{x}{2}\\right)^{2m+1}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselI1(x)

    BesselI1 = staticmethod(BesselI1)

    def LogBesselI1(x):
        """
        Logarithm of the modified first kind Bessel function of order 1.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselI1(x) = \\log (\\mathrm{I}_1(x))

        See also
        --------
        SpecFunc_BesselI1

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselI1(x)

    LogBesselI1 = staticmethod(LogBesselI1)
    if _newclass:
        DeltaLogBesselI10 = staticmethod(_func.SpecFunc_DeltaLogBesselI10)
    else:
        DeltaLogBesselI10 = _func.SpecFunc_DeltaLogBesselI10

    def LogBesselK(nu, x):
        """
        Logarithm of the modified second kind Bessel function of order :math:`\\nu`.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselK(\\nu, x) = \\log(\\mathrm{K}_{\\nu}(x))

        See also
        --------
        SpecFunc_BesselK

        Parameters
        ----------
        nu : float
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselK(nu, x)

    LogBesselK = staticmethod(LogBesselK)

    def BesselK(nu, x):
        """
        Modified second kind Bessel function of order :math:`\\nu`.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{K}_{\\nu}(x) = \\frac{\\pi}{2}\\frac{\\mathrm{I}_{-\\nu}(x)-\\mathrm{I}_{\\nu}(x)}{\\sin{\\nu\\pi}}

        Parameters
        ----------
        nu : float
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselK(nu, x)

    BesselK = staticmethod(BesselK)
    if _newclass:
        BesselKDerivative = staticmethod(_func.SpecFunc_BesselKDerivative)
    else:
        BesselKDerivative = _func.SpecFunc_BesselKDerivative

    def Beta(a, b):
        """
        Beta function :math:`\\mathrm{B}`.

        .. math::

            \\forall (a, b) > 0, \\quad
            \\mathrm{B}(a, b) = \\int_0^1 t^{a-1}(1-t)^{b-1}\\di{t}

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Beta(a, b)

    Beta = staticmethod(Beta)

    def IncompleteBeta(a, b, x, tail=False):
        """
        Incomplete Beta function.

        .. math::

            \\forall (a, b) > 0, t \\in [0, 1], \\quad
            \\mathrm{B}(x; a, b) = \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{B}(x; a, b)`.
            - If *tail* is *True*: :math:`result = \\mathrm{B}(a, b) - \\mathrm{B}(x; a, b)`.
        """
        return _func.SpecFunc_IncompleteBeta(a, b, x, tail)

    IncompleteBeta = staticmethod(IncompleteBeta)

    def IncompleteBetaInverse(a, b, x, tail=False):
        """
        Inverse of the incomplete Beta function.

        .. math::

            \\forall (a, b) > 0 \\quad
            IncompleteBetaInverse(x; a, b) = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)

        See also
        --------
        SpecFunc_IncompleteBeta, SpecFunc_RegularizedIncompleteBetaInverse

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); b, a)`.
        """
        return _func.SpecFunc_IncompleteBetaInverse(a, b, x, tail)

    IncompleteBetaInverse = staticmethod(IncompleteBetaInverse)

    def RegularizedIncompleteBeta(a, b, x, tail=False):
        """
        Regularized incomplete Beta function.

        .. math::

            \\forall (a, b) > 0 \\quad
            \\mathrm{I}(x; a, b) = \\frac{\\mathrm{B}(x; a, b)}{\\mathrm{B}(a, b)}
                                = \\frac{1}{\\mathrm{B}(a, b)} \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

        with :math:`B(a, b)` the Beta function and :math:`B(x; a, b)` the incomplete
        Beta function.

        See also
        --------
        SpecFunc_IncompleteBeta, SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{I}(x; a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}(x; a, b)`.
        """
        return _func.SpecFunc_RegularizedIncompleteBeta(a, b, x, tail)

    RegularizedIncompleteBeta = staticmethod(RegularizedIncompleteBeta)

    def RegularizedIncompleteBetaInverse(a, b, x, tail=False):
        """
        Inverse of the regularized incomplete Beta function.

        .. math::

            \\forall (a, b) > 0, \\quad
            RegularizedIncompleteBetaInverse(x; a, b) = \\mathrm{I}^{-1}(x; a, b)

        See also
        --------
        SpecFunc_RegularizedIncompleteBeta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{I}^{-1}(x; a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}^{-1}(x; b, a)`.
        """
        return _func.SpecFunc_RegularizedIncompleteBetaInverse(a, b, x, tail)

    RegularizedIncompleteBetaInverse = staticmethod(RegularizedIncompleteBetaInverse)

    def LnBeta(a, b):
        """
        Logarithm of the Beta function.

        .. math::

            \\forall (a, b) > 0,\\quad
            LnBeta(a, b) = \\ln (\\mathrm{B}(a, b)) = \\log (\\mathrm{B}(a, b))

        See also
        --------
        SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LnBeta(a, b)

    LnBeta = staticmethod(LnBeta)

    def LogBeta(a, b):
        """
        Logarithm of the Beta function.

        .. math::

            \\forall (a, b) > 0, \\quad
            LogBeta(a, b) = \\log (\\mathrm{B}(a, b))

        See also
        --------
        SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBeta(a, b)

    LogBeta = staticmethod(LogBeta)

    def Dawson(*args):
        """
        Dawson function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            \\mathrm{D}_+(x) = \\exp(-x^2)\\int_0^x \\exp(t^2)\\di{t}

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Dawson(*args)

    Dawson = staticmethod(Dawson)

    def Debye(x, n):
        """
        Debye function of order :math:`n`.

        .. math::

            \\forall x \\in \\Rset, \\forall n \\in \\Nset^* \\text{and} \\, n \\leq 20, \\quad
            \\mathrm{D}_n(x) = \\frac{n}{x^n} \\int_0^x \\frac{t^n}{\\exp(t)-1}\\di{t}

        Parameters
        ----------
        x : float
        n : int :math:`\\in \\{1, \\cdots, 20\\}`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Debye(x, n)

    Debye = staticmethod(Debye)

    def DiLog(x):
        """
        Dilogarithm function.

        .. math::

            \\forall x \\in ]-\\infty, 1[, \\quad
            Li_2(x) = -\\int_0^x \\frac{\\log (1-t)}{t}\\di{t}

        Parameters
        ----------
        x : float :math:`\\in ]-\\infty, 1[`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiLog(x)

    DiLog = staticmethod(DiLog)

    def Ei(*args):
        """
        Exponential integral function.

        .. math::

            \\forall z \\in \\Cset, \\quad
            \\mathrm{Ei}(z) = -\\int_{-z}^{\\infty} \\frac{\\exp(-t)}{t}\\di{t}

        Parameters
        ----------
        z : float or complex

        Returns
        -------
        result : float or complex (same as z)
        """
        return _func.SpecFunc_Ei(*args)

    Ei = staticmethod(Ei)

    def Faddeeva(z):
        """
        Complex Faddeeva function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            \\mathrm{W}(x) = \\exp(-x^2)\\mathrm{erfc}(-ix)

        with :math:`ErfC` the complementary error function.

        See also
        --------
        SpecFunc_ErfC

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Faddeeva(z)

    Faddeeva = staticmethod(Faddeeva)

    def FaddeevaIm(x):
        """
        Imaginary part of the Faddeeva function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            FaddeevaIm(x) = \\Im (\\mathrm{W}(x))

        See also
        --------
        SpecFunc_Faddeeva

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_FaddeevaIm(x)

    FaddeevaIm = staticmethod(FaddeevaIm)

    def IGamma1pm1(a):
        """
        IGamma1pm1 function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            IGamma1pm1(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_IGamma1pm1(a)

    IGamma1pm1 = staticmethod(IGamma1pm1)

    def GammaCorrection(a):
        """
        GammaCorrection function.

        .. math::

            \\forall x \\in \\Rset^*_+, \\quad
            GammaCorrection(a) = \\log (\\Gamma(a)) - \\log (\\sqrt{2\\Pi}) + a - (a - 0.5) \\log(a)

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_GammaCorrection(a)

    GammaCorrection = staticmethod(GammaCorrection)

    def Gamma(*args):
        """
        Gamma function :math:`\\Gamma`.

        .. math::

            \\forall a \\in \\Cset, \\quad
            \\Gamma(a) = \\int_0^{\\infty} t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        a : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Gamma(*args)

    Gamma = staticmethod(Gamma)

    def LnGamma(a):
        """
        Logarithm of the Gamma function.

        .. math::

            \\forall a \\in \\Rset, \\quad
            LnGamma(a) = \\ln (\\Gamma(a))

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LnGamma(a)

    LnGamma = staticmethod(LnGamma)

    def LogGamma1p(a):
        """
        LogGamma1p function.

        .. math::

            \\forall a \\in \\Rset, \\quad
            LogGamma1p(a) = \\log (\\Gamma(1+a))

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogGamma1p(a)

    LogGamma1p = staticmethod(LogGamma1p)

    def LogGamma(*args):
        """
        Logarithm of the Gamma function.

        .. math::

            \\forall a \\in \\Cset, \\quad
            LogGamma(a) = \\log (\\Gamma(a))

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_LogGamma(*args)

    LogGamma = staticmethod(LogGamma)

    def IncompleteGamma(a, x, tail=False):
        """
        Incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\gamma(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\gamma(a, x)`.
            - If *tail* is *True*: :math:`result = \\Gamma(a) - \\gamma(a, x)`.
        """
        return _func.SpecFunc_IncompleteGamma(a, x, tail)

    IncompleteGamma = staticmethod(IncompleteGamma)

    def IncompleteGammaInverse(a, x, tail=False):
        """
        Inverse of the incomplete Gamma function with respect to :math:`x`.

        .. math::

            IncompleteGammaInverse(a, x) = \\gamma^{-1}(a, x)

        See also
        --------
        SpecFunc_IncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x/\\Gamma(a))`.
            - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, (1-x)/\\Gamma(a))`.
        """
        return _func.SpecFunc_IncompleteGammaInverse(a, x, tail)

    IncompleteGammaInverse = staticmethod(IncompleteGammaInverse)

    def RegularizedIncompleteGamma(a, x, tail=False):
        """
        Regularized incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{P}(a, x) = \\frac{\\gamma(a, x)}{\\Gamma(a)}
                             = \\frac{1}{\\Gamma(a)}\\int_0^x t^{a-1}\\exp(-t)\\di{t}

        See also
        --------
        SpecFunc_Gamma, SpecFunc_IncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}(a, x)`.
            - If *tail* is *True*: :math:`result = \\Gamma(a) - \\mathrm{P}(a, x)`.
        """
        return _func.SpecFunc_RegularizedIncompleteGamma(a, x, tail)

    RegularizedIncompleteGamma = staticmethod(RegularizedIncompleteGamma)

    def RegularizedIncompleteGammaInverse(a, x, tail=False):
        """
        Inverse of the regularized incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            RegularizedIncompleteGammaInverse(a, x) = \\mathrm{P}^{-1}(a, x)

        See also
        --------
        SpecFunc_Gamma, SpecFunc_RegularizedIncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float :math:`\\in [0, 1]`
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x)`.
            - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, 1-x)`.
        """
        return _func.SpecFunc_RegularizedIncompleteGammaInverse(a, x, tail)

    RegularizedIncompleteGammaInverse = staticmethod(RegularizedIncompleteGammaInverse)

    def DiGamma(x):
        """
        Digamma function.

        .. math::

            \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiGamma(x)

    DiGamma = staticmethod(DiGamma)

    def Psi(x):
        """
        Psi function.

        .. math::

            \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Psi(x)

    Psi = staticmethod(Psi)

    def DiGammaInv(a):
        """
        Inverse of the DiGamma function.

        .. math::

            DiGammaInv(x) = \\Psi^{-1} (x)

        See also
        --------
        SpecFunc_DiGamma

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiGammaInv(a)

    DiGammaInv = staticmethod(DiGammaInv)

    def TriGamma(x):
        """
        TriGamma function.

        .. math::

            \\Psi_1(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d}^2 \\Gamma(x)}{\\mathrm{d}x^2}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_TriGamma(x)

    TriGamma = staticmethod(TriGamma)

    def HyperGeom_1_1(*args):
        """
        Hypergeometric function of type (1,1).

        .. math::

            {}_1F_1(p_1, q_1, x) = \\sum_{n=0}^{\\infty}
                                   \\left[
                                   \\prod_{k=0}^{n-1} \\frac{(p_1 + k)}{(q_1 + k)}
                                   \\right]  \\frac{x^n}{n!}

        Parameters
        ----------
        p1, q1 : float
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_HyperGeom_1_1(*args)

    HyperGeom_1_1 = staticmethod(HyperGeom_1_1)

    def HyperGeom_2_1(p1, p2, q1, x):
        """
        Hypergeometric function of type (2,1).

        .. math::

            {}_2F_1(p_1, p_2, q_1, x) = \\sum_{n=0}^{\\infty}
                                        \\left[
                                        \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k)}
                                        \\right] \\frac{x^n}{n!}

        Parameters
        ----------
        p1, p2, q1, x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_HyperGeom_2_1(p1, p2, q1, x)

    HyperGeom_2_1 = staticmethod(HyperGeom_2_1)

    def HyperGeom_2_2(p1, p2, q1, q2, x):
        """
        Hypergeometric function of type (2,2).

        .. math::

            {}_2F_2(p_1, p_2, q_1, q_2, x) = \\sum_{n=0}^{\\infty}
                                 \\left[
                                 \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k) (q_2 + k)}
                                 \\right] \\frac{x^n}{n!}

        Parameters
        ----------
        p1, p2, q1, q2, x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_HyperGeom_2_2(p1, p2, q1, q2, x)

    HyperGeom_2_2 = staticmethod(HyperGeom_2_2)

    def Erf(*args):
        """
        Error function Erf.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Erf(x) = \\frac{2}{\\sqrt{\\pi}} \\int_0^x \\exp(-t^2)\\di{t}

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Erf(*args)

    Erf = staticmethod(Erf)

    def ErfI(*args):
        """
        Imaginary error function ErfI.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfI(x) = -i Erf(ix)

        with :math:`Erf` the error function.

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfI(*args)

    ErfI = staticmethod(ErfI)

    def ErfC(*args):
        """
        Complementary error function ErfC.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfC(x) = 1 - Erf(x)

        with :math:`Erf` the error function.

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfC(*args)

    ErfC = staticmethod(ErfC)

    def ErfCX(*args):
        """
        ErfCX function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfCX(x) = \\exp(x^2).ErfC(x)

        with :math:`ErfC` the complementary error function.

        See also
        --------
        SpecFunc_ErfC

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfCX(*args)

    ErfCX = staticmethod(ErfCX)

    def ErfInverse(x):
        """
        Inverse of the error function Erf.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfInverse(x) = Erf^{-1} (x)

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_ErfInverse(x)

    ErfInverse = staticmethod(ErfInverse)

    def LambertW(x, principal=True):
        """
        Lambert W function.

        The Lambert W function :math:`\\mathrm{W}(x)` is defined by the relation:

        .. math::

            x = \\mathrm{W}(x) \\exp(\\mathrm{W}(x))

        Parameters
        ----------
        x : float
        principal : bool, optional
            By default, *principal* is *True*.

        Returns
        -------
        result : float
            - If *principal* is *True* : :math:`result = \\mathrm{W}_0(x)`.
              :math:`\\mathrm{W}_0(x)` is referred to as the principal branch of the Lambert W
              function. It denotes the upper part of the function whose domain is
              :math:`[-1/e, +\\infty[` and range :math:`[-1, +\\infty[`.
            - If *principal* is *False* : :math:`result = \\mathrm{W}_{-1}(x)`.
              :math:`\\mathrm{W}_{-1}(x)` is the second real branch of the Lambert W function.
              It denotes the lower part of the function whose domain is
              :math:`[-1/e, 0[` and range :math:`]-\\infty, -1]`.
        """
        return _func.SpecFunc_LambertW(x, principal)

    LambertW = staticmethod(LambertW)

    def Log1p(z):
        """
        Log1p function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Log1p(x) = \\log (1+x)

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Log1p(z)

    Log1p = staticmethod(Log1p)

    def Expm1(z):
        """
        Expm1 function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Expm1(x) = \\exp(x)-1

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Expm1(z)

    Expm1 = staticmethod(Expm1)

    def Log1MExp(x):
        """
        Log1MExp function.

        .. math::

            \\forall x \\in \\Rset^+, \\quad
            Log1MExp(x) = \\log (1-\\exp(-x))

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Log1MExp(x)

    Log1MExp = staticmethod(Log1MExp)

    def NextPowerOfTwo(n):
        """
        Smallest power of two greater or equal to the given :math:`n`.

        .. math::

            NextPowerOfTwo(n) = 2^{\\lceil \\log_2(n)\\rceil}

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.NextPowerOfTwo(42))
        64
        """
        return _func.SpecFunc_NextPowerOfTwo(n)

    NextPowerOfTwo = staticmethod(NextPowerOfTwo)

    def Log2(n):
        """
        Integer base 2 logarithm of :math:`n`.

        .. math::

            Log2(n) = \\log_2(n)

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.Log2(42))
        5
        """
        return _func.SpecFunc_Log2(n)

    Log2 = staticmethod(Log2)

    def BitCount(n):
        """
        Compute the number of bits set to 1 in an integer.

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.BitCount(42))
        3
        """
        return _func.SpecFunc_BitCount(n)

    BitCount = staticmethod(BitCount)

    def Cbrt(x):
        """
        Cubit root function.

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Cbrt(x)

    Cbrt = staticmethod(Cbrt)

    def BinomialCoefficient(n, k):
        """
        Binomial coefficient.

        Returns the value :math:`C_k^n = \\binom{n}{k}`

        Parameters
        ----------
        n : int
        k : int

        Returns
        -------
        result : int
        """
        return _func.SpecFunc_BinomialCoefficient(n, k)

    BinomialCoefficient = staticmethod(BinomialCoefficient)
    __swig_destroy__ = _func.delete_SpecFunc
    __del__ = lambda self: None
SpecFunc_swigregister = _func.SpecFunc_swigregister
SpecFunc_swigregister(SpecFunc)
cvar = _func.cvar
SpecFunc.ISQRT2PI = _func.cvar.SpecFunc_ISQRT2PI
SpecFunc.SQRT2PI = _func.cvar.SpecFunc_SQRT2PI
SpecFunc.LOGSQRT2PI = _func.cvar.SpecFunc_LOGSQRT2PI
SpecFunc.EulerConstant = _func.cvar.SpecFunc_EulerConstant
SpecFunc.PI2_6 = _func.cvar.SpecFunc_PI2_6
SpecFunc.PI_SQRT6 = _func.cvar.SpecFunc_PI_SQRT6
SpecFunc.EULERSQRT6_PI = _func.cvar.SpecFunc_EULERSQRT6_PI
SpecFunc.PI2_3 = _func.cvar.SpecFunc_PI2_3
SpecFunc.SQRT3_PI = _func.cvar.SpecFunc_SQRT3_PI
SpecFunc.PI_SQRT3 = _func.cvar.SpecFunc_PI_SQRT3
SpecFunc.ZETA3 = _func.cvar.SpecFunc_ZETA3
SpecFunc.MaximumIteration = _func.cvar.SpecFunc_MaximumIteration
SpecFunc.Precision = _func.cvar.SpecFunc_Precision
SpecFunc.MinScalar = _func.cvar.SpecFunc_MinScalar
SpecFunc.LogMinScalar = _func.cvar.SpecFunc_LogMinScalar
SpecFunc.MaxScalar = _func.cvar.SpecFunc_MaxScalar
SpecFunc.LogMaxScalar = _func.cvar.SpecFunc_LogMaxScalar
SpecFunc.ScalarEpsilon = _func.cvar.SpecFunc_ScalarEpsilon
SpecFunc.MinNumericalScalar = _func.cvar.SpecFunc_MinNumericalScalar
SpecFunc.LogMinNumericalScalar = _func.cvar.SpecFunc_LogMinNumericalScalar
SpecFunc.MaxNumericalScalar = _func.cvar.SpecFunc_MaxNumericalScalar
SpecFunc.LogMaxNumericalScalar = _func.cvar.SpecFunc_LogMaxNumericalScalar
SpecFunc.NumericalScalarEpsilon = _func.cvar.SpecFunc_NumericalScalarEpsilon

def SpecFunc_IsNaN(value):
    return _func.SpecFunc_IsNaN(value)
SpecFunc_IsNaN = _func.SpecFunc_IsNaN

def SpecFunc_IsNormal(value):
    return _func.SpecFunc_IsNormal(value)
SpecFunc_IsNormal = _func.SpecFunc_IsNormal

def SpecFunc_BesselI0(x):
    """
    Modified first kind Bessel function of order 0.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{I}_0(x) = \\sum_{m=0}^\\infty\\frac{1}{m!^2}\\left(\\frac{x}{2}\\right)^{2m}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_BesselI0(x)

def SpecFunc_LogBesselI0(x):
    """
    Logarithm of the modified first kind Bessel function of order 0.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselI0(x) = \\log (\\mathrm{I}_0(x))

    See also
    --------
    SpecFunc_BesselI0

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LogBesselI0(x)

def SpecFunc_BesselI1(x):
    """
    Modified first kind Bessel function of order 1.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{I}_1(x) = \\sum_{m=0}^\\infty\\frac{1}{m!(m+1)!}\\left(\\frac{x}{2}\\right)^{2m+1}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_BesselI1(x)

def SpecFunc_LogBesselI1(x):
    """
    Logarithm of the modified first kind Bessel function of order 1.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselI1(x) = \\log (\\mathrm{I}_1(x))

    See also
    --------
    SpecFunc_BesselI1

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LogBesselI1(x)

def SpecFunc_DeltaLogBesselI10(x):
    return _func.SpecFunc_DeltaLogBesselI10(x)
SpecFunc_DeltaLogBesselI10 = _func.SpecFunc_DeltaLogBesselI10

def SpecFunc_LogBesselK(nu, x):
    """
    Logarithm of the modified second kind Bessel function of order :math:`\\nu`.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselK(\\nu, x) = \\log(\\mathrm{K}_{\\nu}(x))

    See also
    --------
    SpecFunc_BesselK

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LogBesselK(nu, x)

def SpecFunc_BesselK(nu, x):
    """
    Modified second kind Bessel function of order :math:`\\nu`.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{K}_{\\nu}(x) = \\frac{\\pi}{2}\\frac{\\mathrm{I}_{-\\nu}(x)-\\mathrm{I}_{\\nu}(x)}{\\sin{\\nu\\pi}}

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_BesselK(nu, x)

def SpecFunc_BesselKDerivative(nu, x):
    return _func.SpecFunc_BesselKDerivative(nu, x)
SpecFunc_BesselKDerivative = _func.SpecFunc_BesselKDerivative

def SpecFunc_Beta(a, b):
    """
    Beta function :math:`\\mathrm{B}`.

    .. math::

        \\forall (a, b) > 0, \\quad
        \\mathrm{B}(a, b) = \\int_0^1 t^{a-1}(1-t)^{b-1}\\di{t}

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_Beta(a, b)

def SpecFunc_IncompleteBeta(a, b, x, tail=False):
    """
    Incomplete Beta function.

    .. math::

        \\forall (a, b) > 0, t \\in [0, 1], \\quad
        \\mathrm{B}(x; a, b) = \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{B}(x; a, b)`.
        - If *tail* is *True*: :math:`result = \\mathrm{B}(a, b) - \\mathrm{B}(x; a, b)`.
    """
    return _func.SpecFunc_IncompleteBeta(a, b, x, tail)

def SpecFunc_IncompleteBetaInverse(a, b, x, tail=False):
    """
    Inverse of the incomplete Beta function.

    .. math::

        \\forall (a, b) > 0 \\quad
        IncompleteBetaInverse(x; a, b) = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)

    See also
    --------
    SpecFunc_IncompleteBeta, SpecFunc_RegularizedIncompleteBetaInverse

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); b, a)`.
    """
    return _func.SpecFunc_IncompleteBetaInverse(a, b, x, tail)

def SpecFunc_RegularizedIncompleteBeta(a, b, x, tail=False):
    """
    Regularized incomplete Beta function.

    .. math::

        \\forall (a, b) > 0 \\quad
        \\mathrm{I}(x; a, b) = \\frac{\\mathrm{B}(x; a, b)}{\\mathrm{B}(a, b)}
                            = \\frac{1}{\\mathrm{B}(a, b)} \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

    with :math:`B(a, b)` the Beta function and :math:`B(x; a, b)` the incomplete
    Beta function.

    See also
    --------
    SpecFunc_IncompleteBeta, SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{I}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}(x; a, b)`.
    """
    return _func.SpecFunc_RegularizedIncompleteBeta(a, b, x, tail)

def SpecFunc_RegularizedIncompleteBetaInverse(a, b, x, tail=False):
    """
    Inverse of the regularized incomplete Beta function.

    .. math::

        \\forall (a, b) > 0, \\quad
        RegularizedIncompleteBetaInverse(x; a, b) = \\mathrm{I}^{-1}(x; a, b)

    See also
    --------
    SpecFunc_RegularizedIncompleteBeta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{I}^{-1}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}^{-1}(x; b, a)`.
    """
    return _func.SpecFunc_RegularizedIncompleteBetaInverse(a, b, x, tail)

def SpecFunc_LnBeta(a, b):
    """
    Logarithm of the Beta function.

    .. math::

        \\forall (a, b) > 0,\\quad
        LnBeta(a, b) = \\ln (\\mathrm{B}(a, b)) = \\log (\\mathrm{B}(a, b))

    See also
    --------
    SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LnBeta(a, b)

def SpecFunc_LogBeta(a, b):
    """
    Logarithm of the Beta function.

    .. math::

        \\forall (a, b) > 0, \\quad
        LogBeta(a, b) = \\log (\\mathrm{B}(a, b))

    See also
    --------
    SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LogBeta(a, b)

def SpecFunc_Dawson(*args):
    """
    Dawson function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        \\mathrm{D}_+(x) = \\exp(-x^2)\\int_0^x \\exp(t^2)\\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_Dawson(*args)

def SpecFunc_Debye(x, n):
    """
    Debye function of order :math:`n`.

    .. math::

        \\forall x \\in \\Rset, \\forall n \\in \\Nset^* \\text{and} \\, n \\leq 20, \\quad
        \\mathrm{D}_n(x) = \\frac{n}{x^n} \\int_0^x \\frac{t^n}{\\exp(t)-1}\\di{t}

    Parameters
    ----------
    x : float
    n : int :math:`\\in \\{1, \\cdots, 20\\}`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_Debye(x, n)

def SpecFunc_DiLog(x):
    """
    Dilogarithm function.

    .. math::

        \\forall x \\in ]-\\infty, 1[, \\quad
        Li_2(x) = -\\int_0^x \\frac{\\log (1-t)}{t}\\di{t}

    Parameters
    ----------
    x : float :math:`\\in ]-\\infty, 1[`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_DiLog(x)

def SpecFunc_Ei(*args):
    """
    Exponential integral function.

    .. math::

        \\forall z \\in \\Cset, \\quad
        \\mathrm{Ei}(z) = -\\int_{-z}^{\\infty} \\frac{\\exp(-t)}{t}\\di{t}

    Parameters
    ----------
    z : float or complex

    Returns
    -------
    result : float or complex (same as z)
    """
    return _func.SpecFunc_Ei(*args)

def SpecFunc_Faddeeva(z):
    """
    Complex Faddeeva function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        \\mathrm{W}(x) = \\exp(-x^2)\\mathrm{erfc}(-ix)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    SpecFunc_ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _func.SpecFunc_Faddeeva(z)

def SpecFunc_FaddeevaIm(x):
    """
    Imaginary part of the Faddeeva function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        FaddeevaIm(x) = \\Im (\\mathrm{W}(x))

    See also
    --------
    SpecFunc_Faddeeva

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_FaddeevaIm(x)

def SpecFunc_IGamma1pm1(a):
    """
    IGamma1pm1 function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        IGamma1pm1(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_IGamma1pm1(a)

def SpecFunc_GammaCorrection(a):
    """
    GammaCorrection function.

    .. math::

        \\forall x \\in \\Rset^*_+, \\quad
        GammaCorrection(a) = \\log (\\Gamma(a)) - \\log (\\sqrt{2\\Pi}) + a - (a - 0.5) \\log(a)

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_GammaCorrection(a)

def SpecFunc_Gamma(*args):
    """
    Gamma function :math:`\\Gamma`.

    .. math::

        \\forall a \\in \\Cset, \\quad
        \\Gamma(a) = \\int_0^{\\infty} t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_Gamma(*args)

def SpecFunc_LnGamma(a):
    """
    Logarithm of the Gamma function.

    .. math::

        \\forall a \\in \\Rset, \\quad
        LnGamma(a) = \\ln (\\Gamma(a))

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LnGamma(a)

def SpecFunc_LogGamma1p(a):
    """
    LogGamma1p function.

    .. math::

        \\forall a \\in \\Rset, \\quad
        LogGamma1p(a) = \\log (\\Gamma(1+a))

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_LogGamma1p(a)

def SpecFunc_LogGamma(*args):
    """
    Logarithm of the Gamma function.

    .. math::

        \\forall a \\in \\Cset, \\quad
        LogGamma(a) = \\log (\\Gamma(a))

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_LogGamma(*args)

def SpecFunc_IncompleteGamma(a, x, tail=False):
    """
    Incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\gamma(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\gamma(a, x)`.
        - If *tail* is *True*: :math:`result = \\Gamma(a) - \\gamma(a, x)`.
    """
    return _func.SpecFunc_IncompleteGamma(a, x, tail)

def SpecFunc_IncompleteGammaInverse(a, x, tail=False):
    """
    Inverse of the incomplete Gamma function with respect to :math:`x`.

    .. math::

        IncompleteGammaInverse(a, x) = \\gamma^{-1}(a, x)

    See also
    --------
    SpecFunc_IncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x/\\Gamma(a))`.
        - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, (1-x)/\\Gamma(a))`.
    """
    return _func.SpecFunc_IncompleteGammaInverse(a, x, tail)

def SpecFunc_RegularizedIncompleteGamma(a, x, tail=False):
    """
    Regularized incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{P}(a, x) = \\frac{\\gamma(a, x)}{\\Gamma(a)}
                         = \\frac{1}{\\Gamma(a)}\\int_0^x t^{a-1}\\exp(-t)\\di{t}

    See also
    --------
    SpecFunc_Gamma, SpecFunc_IncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}(a, x)`.
        - If *tail* is *True*: :math:`result = \\Gamma(a) - \\mathrm{P}(a, x)`.
    """
    return _func.SpecFunc_RegularizedIncompleteGamma(a, x, tail)

def SpecFunc_RegularizedIncompleteGammaInverse(a, x, tail=False):
    """
    Inverse of the regularized incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        RegularizedIncompleteGammaInverse(a, x) = \\mathrm{P}^{-1}(a, x)

    See also
    --------
    SpecFunc_Gamma, SpecFunc_RegularizedIncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float :math:`\\in [0, 1]`
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x)`.
        - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, 1-x)`.
    """
    return _func.SpecFunc_RegularizedIncompleteGammaInverse(a, x, tail)

def SpecFunc_DiGamma(x):
    """
    Digamma function.

    .. math::

        \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_DiGamma(x)

def SpecFunc_Psi(x):
    """
    Psi function.

    .. math::

        \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_Psi(x)

def SpecFunc_DiGammaInv(a):
    """
    Inverse of the DiGamma function.

    .. math::

        DiGammaInv(x) = \\Psi^{-1} (x)

    See also
    --------
    SpecFunc_DiGamma

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_DiGammaInv(a)

def SpecFunc_TriGamma(x):
    """
    TriGamma function.

    .. math::

        \\Psi_1(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d}^2 \\Gamma(x)}{\\mathrm{d}x^2}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_TriGamma(x)

def SpecFunc_HyperGeom_1_1(*args):
    """
    Hypergeometric function of type (1,1).

    .. math::

        {}_1F_1(p_1, q_1, x) = \\sum_{n=0}^{\\infty}
                               \\left[
                               \\prod_{k=0}^{n-1} \\frac{(p_1 + k)}{(q_1 + k)}
                               \\right]  \\frac{x^n}{n!}

    Parameters
    ----------
    p1, q1 : float
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_HyperGeom_1_1(*args)

def SpecFunc_HyperGeom_2_1(p1, p2, q1, x):
    """
    Hypergeometric function of type (2,1).

    .. math::

        {}_2F_1(p_1, p_2, q_1, x) = \\sum_{n=0}^{\\infty}
                                    \\left[
                                    \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k)}
                                    \\right] \\frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_HyperGeom_2_1(p1, p2, q1, x)

def SpecFunc_HyperGeom_2_2(p1, p2, q1, q2, x):
    """
    Hypergeometric function of type (2,2).

    .. math::

        {}_2F_2(p_1, p_2, q_1, q_2, x) = \\sum_{n=0}^{\\infty}
                             \\left[
                             \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k) (q_2 + k)}
                             \\right] \\frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, q2, x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_HyperGeom_2_2(p1, p2, q1, q2, x)

def SpecFunc_Erf(*args):
    """
    Error function Erf.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Erf(x) = \\frac{2}{\\sqrt{\\pi}} \\int_0^x \\exp(-t^2)\\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_Erf(*args)

def SpecFunc_ErfI(*args):
    """
    Imaginary error function ErfI.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfI(x) = -i Erf(ix)

    with :math:`Erf` the error function.

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_ErfI(*args)

def SpecFunc_ErfC(*args):
    """
    Complementary error function ErfC.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfC(x) = 1 - Erf(x)

    with :math:`Erf` the error function.

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_ErfC(*args)

def SpecFunc_ErfCX(*args):
    """
    ErfCX function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfCX(x) = \\exp(x^2).ErfC(x)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    SpecFunc_ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
    return _func.SpecFunc_ErfCX(*args)

def SpecFunc_ErfInverse(x):
    """
    Inverse of the error function Erf.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfInverse(x) = Erf^{-1} (x)

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_ErfInverse(x)

def SpecFunc_LambertW(x, principal=True):
    """
    Lambert W function.

    The Lambert W function :math:`\\mathrm{W}(x)` is defined by the relation:

    .. math::

        x = \\mathrm{W}(x) \\exp(\\mathrm{W}(x))

    Parameters
    ----------
    x : float
    principal : bool, optional
        By default, *principal* is *True*.

    Returns
    -------
    result : float
        - If *principal* is *True* : :math:`result = \\mathrm{W}_0(x)`.
          :math:`\\mathrm{W}_0(x)` is referred to as the principal branch of the Lambert W
          function. It denotes the upper part of the function whose domain is
          :math:`[-1/e, +\\infty[` and range :math:`[-1, +\\infty[`.
        - If *principal* is *False* : :math:`result = \\mathrm{W}_{-1}(x)`.
          :math:`\\mathrm{W}_{-1}(x)` is the second real branch of the Lambert W function.
          It denotes the lower part of the function whose domain is
          :math:`[-1/e, 0[` and range :math:`]-\\infty, -1]`.
    """
    return _func.SpecFunc_LambertW(x, principal)

def SpecFunc_Log1p(z):
    """
    Log1p function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Log1p(x) = \\log (1+x)

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _func.SpecFunc_Log1p(z)

def SpecFunc_Expm1(z):
    """
    Expm1 function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Expm1(x) = \\exp(x)-1

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
    return _func.SpecFunc_Expm1(z)

def SpecFunc_Log1MExp(x):
    """
    Log1MExp function.

    .. math::

        \\forall x \\in \\Rset^+, \\quad
        Log1MExp(x) = \\log (1-\\exp(-x))

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : complex
    """
    return _func.SpecFunc_Log1MExp(x)

def SpecFunc_NextPowerOfTwo(n):
    """
    Smallest power of two greater or equal to the given :math:`n`.

    .. math::

        NextPowerOfTwo(n) = 2^{\\lceil \\log_2(n)\\rceil}

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.NextPowerOfTwo(42))
    64
    """
    return _func.SpecFunc_NextPowerOfTwo(n)

def SpecFunc_Log2(n):
    """
    Integer base 2 logarithm of :math:`n`.

    .. math::

        Log2(n) = \\log_2(n)

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.Log2(42))
    5
    """
    return _func.SpecFunc_Log2(n)

def SpecFunc_BitCount(n):
    """
    Compute the number of bits set to 1 in an integer.

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.BitCount(42))
    3
    """
    return _func.SpecFunc_BitCount(n)

def SpecFunc_Cbrt(x):
    """
    Cubit root function.

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
    return _func.SpecFunc_Cbrt(x)

def SpecFunc_BinomialCoefficient(n, k):
    """
    Binomial coefficient.

    Returns the value :math:`C_k^n = \\binom{n}{k}`

    Parameters
    ----------
    n : int
    k : int

    Returns
    -------
    result : int
    """
    return _func.SpecFunc_BinomialCoefficient(n, k)

class EvaluationImplementation(openturns.common.PersistentObject):
    """
    Numerical math evaluation implementation.

    Available constructors:
        EvaluationImplementation()

    See also
    --------
    Function, AggregatedEvaluation,
    DatabaseEvaluation,
    DualLinearCombinationEvaluation, LinearFunction

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EvaluationImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EvaluationImplementation_getClassName(self)


    def __eq__(self, other):
        return _func.EvaluationImplementation___eq__(self, other)

    def __repr__(self):
        return _func.EvaluationImplementation___repr__(self)

    def __str__(self, *args):
        return _func.EvaluationImplementation___str__(self, *args)

    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.EvaluationImplementation_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.EvaluationImplementation_getDescription(self)


    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.EvaluationImplementation_getInputDescription(self)


    def setInputDescription(self, inputDescription):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.EvaluationImplementation_setInputDescription(self, inputDescription)


    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.EvaluationImplementation_getOutputDescription(self)


    def setOutputDescription(self, outputDescription):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.EvaluationImplementation_setOutputDescription(self, outputDescription)


    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.EvaluationImplementation_enableHistory(self)


    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.EvaluationImplementation_disableHistory(self)


    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementation_isHistoryEnabled(self)


    def clearHistory(self):
        """Empty the content of the history."""
        return _func.EvaluationImplementation_clearHistory(self)


    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.Sample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getHistoryInput(self)


    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.Sample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getHistoryOutput(self)


    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getInputParameterHistory(self)


    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.EvaluationImplementation_enableCache(self)


    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.EvaluationImplementation_disableCache(self)


    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementation_isCacheEnabled(self)


    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.EvaluationImplementation_getCacheHits(self)


    def addCacheContent(self, inSample, outSample):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.EvaluationImplementation_addCacheContent(self, inSample, outSample)


    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementation_getCacheInput(self)


    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementation_getCacheOutput(self)


    def clearCache(self):
        """Empty the content of the cache."""
        return _func.EvaluationImplementation_clearCache(self)


    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.EvaluationImplementation_isActualImplementation(self)


    def __call__(self, *args):
        return _func.EvaluationImplementation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.EvaluationImplementation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.EvaluationImplementation_getOutputDimension(self)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.EvaluationImplementation_getParameterDimension(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.EvaluationImplementation_getMarginal(self, *args)


    def parameterGradient(self, inP):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.EvaluationImplementation_parameterGradient(self, inP)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.EvaluationImplementation_getParameter(self)


    def setParameter(self, parameters):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.EvaluationImplementation_setParameter(self, parameters)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_setParameterDescription(self, description)


    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.EvaluationImplementation_getCallsNumber(self)


    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x'], ['sin(2*_pi*x)*exp(-x^2/2)'])
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.EvaluationImplementation_draw(self, *args)


    def __init__(self, *args):
        this = _func.new_EvaluationImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_EvaluationImplementation
    __del__ = lambda self: None
EvaluationImplementation_swigregister = _func.EvaluationImplementation_swigregister
EvaluationImplementation_swigregister(EvaluationImplementation)

class GradientImplementation(openturns.common.PersistentObject):
    """
    Numerical math gradient implementation.

    See also
    --------
    Function, HessianImplementation

    Notes
    -----
    This object is the result of the method *getGradient* of a 
    :class:`~openturns.Function`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GradientImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.GradientImplementation_getClassName(self)


    def __eq__(self, other):
        return _func.GradientImplementation___eq__(self, other)

    def __repr__(self):
        return _func.GradientImplementation___repr__(self)

    def __str__(self, *args):
        return _func.GradientImplementation___str__(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.GradientImplementation_getMarginal(self, *args)


    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.GradientImplementation_isActualImplementation(self)


    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.GradientImplementation_gradient(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.GradientImplementation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.GradientImplementation_getOutputDimension(self)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.GradientImplementation_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.GradientImplementation_setParameter(self, parameter)


    def getCallsNumber(self):
        """
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.GradientImplementation_getCallsNumber(self)


    def __init__(self, *args):
        this = _func.new_GradientImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_GradientImplementation
    __del__ = lambda self: None
GradientImplementation_swigregister = _func.GradientImplementation_swigregister
GradientImplementation_swigregister(GradientImplementation)

class HessianImplementation(openturns.common.PersistentObject):
    """
    Numerical math hessian implementation.

    See also
    --------
    Function, GradientImplementation

    Notes
    -----
    This object is the result of the method *getHessian* of a 
    :class:`~openturns.Function`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HessianImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HessianImplementation_getClassName(self)


    def __eq__(self, other):
        return _func.HessianImplementation___eq__(self, other)

    def __repr__(self):
        return _func.HessianImplementation___repr__(self)

    def __str__(self, *args):
        return _func.HessianImplementation___str__(self, *args)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.HessianImplementation_isActualImplementation(self)


    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.HessianImplementation_getMarginal(self, *args)


    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.HessianImplementation_hessian(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.HessianImplementation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.HessianImplementation_getOutputDimension(self)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.HessianImplementation_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.HessianImplementation_setParameter(self, parameter)


    def getCallsNumber(self):
        """
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.HessianImplementation_getCallsNumber(self)


    def __init__(self, *args):
        this = _func.new_HessianImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_HessianImplementation
    __del__ = lambda self: None
HessianImplementation_swigregister = _func.HessianImplementation_swigregister
HessianImplementation_swigregister(HessianImplementation)

class NoEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::NoEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.NoEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.NoEvaluation___repr__(self)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoEvaluation_isActualImplementation(self)


    def __call__(self, inP):
        return _func.NoEvaluation___call__(self, inP)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NoEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NoEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_NoEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_NoEvaluation
    __del__ = lambda self: None
NoEvaluation_swigregister = _func.NoEvaluation_swigregister
NoEvaluation_swigregister(NoEvaluation)

class NoGradient(GradientImplementation):
    """Proxy of C++ OT::NoGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoGradient_getClassName(self)


    def __eq__(self, other):
        return _func.NoGradient___eq__(self, other)

    def __repr__(self):
        return _func.NoGradient___repr__(self)

    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoGradient_getOutputDimension(self)


    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoGradient_isActualImplementation(self)


    def __init__(self, *args):
        this = _func.new_NoGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_NoGradient
    __del__ = lambda self: None
NoGradient_swigregister = _func.NoGradient_swigregister
NoGradient_swigregister(NoGradient)

class NoHessian(HessianImplementation):
    """Proxy of C++ OT::NoHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoHessian_getClassName(self)


    def __eq__(self, other):
        return _func.NoHessian___eq__(self, other)

    def __repr__(self):
        return _func.NoHessian___repr__(self)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoHessian_isActualImplementation(self)


    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoHessian_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_NoHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_NoHessian
    __del__ = lambda self: None
NoHessian_swigregister = _func.NoHessian_swigregister
NoHessian_swigregister(NoHessian)

class LinearEvaluation(EvaluationImplementation):
    """
    Linear numerical math evaluation implementation.

    Available constructors:
       LinearEvaluation(*center, constant, linear*)

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\\vect{b}`.
    constant : sequence of float
        Vector :math:`\\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\\mat{A}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a linear :class:`~openturns.Function` :math:`f` 
    defined as :

    .. math::

        f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
            & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

    where:

    - :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
      input *linear*
    - :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*
    - :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*.
    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.LinearEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.LinearEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.LinearEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.LinearEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearEvaluation_getOutputDimension(self)


    def getCenter(self):
        """
        Accessor to the center.

        Returns
        -------
        center : :class:`~openturns.Point`
            The center :math:`\\vect{b}`.
        """
        return _func.LinearEvaluation_getCenter(self)


    def getConstant(self):
        """
        Accessor to the constant.

        Returns
        -------
        constant : :class:`~openturns.Point`
            The constant :math:`\\vect{c}`.
        """
        return _func.LinearEvaluation_getConstant(self)


    def getLinear(self):
        """
        Accessor to the matrix.

        Returns
        -------
        linear : :class:`~openturns.Matrix`
            The matrix :math:`\\mat{A}`.
        """
        return _func.LinearEvaluation_getLinear(self)


    def __init__(self, *args):
        this = _func.new_LinearEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearEvaluation
    __del__ = lambda self: None
LinearEvaluation_swigregister = _func.LinearEvaluation_swigregister
LinearEvaluation_swigregister(LinearEvaluation)

class LinearGradient(GradientImplementation):
    """Linear numerical math gradient implementation."""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearGradient_getClassName(self)


    def __eq__(self, other):
        return _func.LinearGradient___eq__(self, other)

    def __repr__(self):
        return _func.LinearGradient___repr__(self)

    def __str__(self, *args):
        return _func.LinearGradient___str__(self, *args)

    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearGradient_getOutputDimension(self)


    def getCenter(self):
        return _func.LinearGradient_getCenter(self)

    def getConstant(self):
        return _func.LinearGradient_getConstant(self)

    def getLinear(self):
        return _func.LinearGradient_getLinear(self)

    def __init__(self, *args):
        this = _func.new_LinearGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearGradient
    __del__ = lambda self: None
LinearGradient_swigregister = _func.LinearGradient_swigregister
LinearGradient_swigregister(LinearGradient)

class QuadraticEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::QuadraticEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.QuadraticEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.QuadraticEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.QuadraticEvaluation___str__(self, *args)

    def __call__(self, inP):
        return _func.QuadraticEvaluation___call__(self, inP)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.QuadraticEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.QuadraticEvaluation_getOutputDimension(self)


    def getCenter(self):
        return _func.QuadraticEvaluation_getCenter(self)

    def getConstant(self):
        return _func.QuadraticEvaluation_getConstant(self)

    def getLinear(self):
        return _func.QuadraticEvaluation_getLinear(self)

    def getQuadratic(self):
        return _func.QuadraticEvaluation_getQuadratic(self)

    def __init__(self, *args):
        this = _func.new_QuadraticEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_QuadraticEvaluation
    __del__ = lambda self: None
QuadraticEvaluation_swigregister = _func.QuadraticEvaluation_swigregister
QuadraticEvaluation_swigregister(QuadraticEvaluation)

class ConstantGradient(GradientImplementation):
    """Proxy of C++ OT::ConstantGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantGradient_getClassName(self)


    def __eq__(self, other):
        return _func.ConstantGradient___eq__(self, other)

    def __repr__(self):
        return _func.ConstantGradient___repr__(self)

    def __str__(self, *args):
        return _func.ConstantGradient___str__(self, *args)

    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantGradient_getOutputDimension(self)


    def getConstant(self):
        return _func.ConstantGradient_getConstant(self)

    def __init__(self, *args):
        this = _func.new_ConstantGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ConstantGradient
    __del__ = lambda self: None
ConstantGradient_swigregister = _func.ConstantGradient_swigregister
ConstantGradient_swigregister(ConstantGradient)

class ConstantHessian(HessianImplementation):
    """Proxy of C++ OT::ConstantHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantHessian_getClassName(self)


    def __eq__(self, other):
        return _func.ConstantHessian___eq__(self, other)

    def __repr__(self):
        return _func.ConstantHessian___repr__(self)

    def __str__(self, *args):
        return _func.ConstantHessian___str__(self, *args)

    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantHessian_getOutputDimension(self)


    def getConstant(self):
        return _func.ConstantHessian_getConstant(self)

    def __init__(self, *args):
        this = _func.new_ConstantHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ConstantHessian
    __del__ = lambda self: None
ConstantHessian_swigregister = _func.ConstantHessian_swigregister
ConstantHessian_swigregister(ConstantHessian)

class ComposedEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::ComposedEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.ComposedEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.ComposedEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ComposedEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.ComposedEvaluation___call__(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.ComposedEvaluation_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ComposedEvaluation_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedEvaluation_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedEvaluation_setParameterDescription(self, description)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ComposedEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ComposedEvaluation_getOutputDimension(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.ComposedEvaluation_getMarginal(self, *args)


    def getLeftEvaluationImplementation(self):
        return _func.ComposedEvaluation_getLeftEvaluationImplementation(self)

    def getRightEvaluationImplementation(self):
        return _func.ComposedEvaluation_getRightEvaluationImplementation(self)

    def __init__(self, *args):
        this = _func.new_ComposedEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ComposedEvaluation
    __del__ = lambda self: None
ComposedEvaluation_swigregister = _func.ComposedEvaluation_swigregister
ComposedEvaluation_swigregister(ComposedEvaluation)

class ComposedGradient(GradientImplementation):
    """Proxy of C++ OT::ComposedGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedGradient_getClassName(self)


    def __eq__(self, other):
        return _func.ComposedGradient___eq__(self, other)

    def __repr__(self):
        return _func.ComposedGradient___repr__(self)

    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedGradient_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ComposedGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ComposedGradient
    __del__ = lambda self: None
ComposedGradient_swigregister = _func.ComposedGradient_swigregister
ComposedGradient_swigregister(ComposedGradient)

class ComposedHessian(HessianImplementation):
    """Proxy of C++ OT::ComposedHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedHessian_getClassName(self)


    def __eq__(self, other):
        return _func.ComposedHessian___eq__(self, other)

    def __repr__(self):
        return _func.ComposedHessian___repr__(self)

    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedHessian_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ComposedHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ComposedHessian
    __del__ = lambda self: None
ComposedHessian_swigregister = _func.ComposedHessian_swigregister
ComposedHessian_swigregister(ComposedHessian)

class ProductEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::ProductEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.ProductEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.ProductEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ProductEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.ProductEvaluation___call__(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.ProductEvaluation_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ProductEvaluation_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ProductEvaluation_getParameterDescription(self)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ProductEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ProductEvaluation
    __del__ = lambda self: None
ProductEvaluation_swigregister = _func.ProductEvaluation_swigregister
ProductEvaluation_swigregister(ProductEvaluation)

class ProductGradient(GradientImplementation):
    """Proxy of C++ OT::ProductGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductGradient_getClassName(self)


    def __eq__(self, other):
        return _func.ProductGradient___eq__(self, other)

    def __repr__(self):
        return _func.ProductGradient___repr__(self)

    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductGradient_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ProductGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ProductGradient
    __del__ = lambda self: None
ProductGradient_swigregister = _func.ProductGradient_swigregister
ProductGradient_swigregister(ProductGradient)

class ProductHessian(HessianImplementation):
    """Proxy of C++ OT::ProductHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductHessian_getClassName(self)


    def __eq__(self, other):
        return _func.ProductHessian___eq__(self, other)

    def __repr__(self):
        return _func.ProductHessian___repr__(self)

    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductHessian_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ProductHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ProductHessian
    __del__ = lambda self: None
ProductHessian_swigregister = _func.ProductHessian_swigregister
ProductHessian_swigregister(ProductHessian)

class FunctionImplementation(openturns.common.PersistentObject):
    """
    Function base class.

    Available constructors:
        Function(*inputs, outputs, formulas*)

        Function(*inputs, formulas*)

        Function(*inputString, formulaString, outputString = 'outputVariable'*)

        Function(*f, g*)

        Function(*functionCollection*)

        Function(*functionCollection, scalarCoefficientColl*)

        Function(*scalarFunctionCollection, vectorCoefficientColl*)

        Function(*function, comparisonOperator, threshold*)

        Function(*function, indices, referencePoint, parametersSet=True*)

        Function(*inputSample, outputSample*)

    Parameters
    ----------
    inputs : sequence of str
        Ordered list of input variables names of the *Function*.
    outputs : sequence of str
        Ordered list of output variables names of the *Function*.
        If it is not specified, default names are created for the output variables.
    formulas : sequence of str
        Ordered list of analytical formulas between the inputs and the outputs.
        The *Function* is defined by *ouputs = formulas(inputs)*.
    inputString : str
        Description of the *Function*'s input.
    outputString : str
        Description of the *Function*'s output.
    formulaString : str
        Analytical formula of the *Function*.
        The *Function* is defined by
        *ouputString = formulaString(inputString)*.

        Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

        Available operators:

        - = (assignment)
        - && (logical and)
        - || (logical or)
        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \\+ (addition)
        - \\- (subtraction)
        - \\* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

        Available constants:

        - _e (Euler's constant)
        - _pi (Pi)

    f,g : two :class:`~openturns.Function`
        The *Function* is the composition function :math:`f\\circ g`.
    functionCollection : list of :class:`~openturns.Function`
        Collection of several *Function*.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.
    scalarFunctionCollection : list of :class:`~openturns.Function`
        Collection of several scalar *Function*.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.
    function : :class:`~openturns.Function`
        Function from which another function is created.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator.
    threshold : float
        Threshold from which values are compared.
    indices : sequence of int
        Indices of the set variables which are set to *referencePoint*'s values.
    parametersSet : bool
        If *True* (default), the set variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        vector of *indices*.
    referencePoint : sequence of float
        Values of the set variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.

    Examples
    --------
    Create a *Function* from a list of analytical formulas and
    descriptions of the inputs and the outputs :

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'],
    ...                         ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *Function* from strings:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction('x', '2.0*sqrt(x)')
    >>> print(f(([16],[4])))
        [ y0 ]
    0 : [ 8  ]
    1 : [ 4  ]


    Create a *Function* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from another *Function*:

    >>> f = ot.SymbolicFunction(ot.Description.BuildDefault(4, 'x'),
    ...                         ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.ParametricFunction(f, [3, 1], [10.0, 4.0], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.ParametricFunction(f, [3, 1], [6.0, 5.0], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *Function* from another *Function*
    and by using a comparison operator:

    >>> analytical = ot.SymbolicFunction(['x0','x1'], ['x0 + x1'])
    >>> indicator = ot.IndicatorFunction(analytical, ot.Less(), 0.0)
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *Function* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> myFunction = ot.AggregatedFunction(functions)
    >>> print(myFunction([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *Function* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
    then the linear combination is:

    .. math::

        linComb: \\left|\\begin{array}{rcl}
                      \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                      \\vect{X} & \\mapsto & \\displaystyle \\sum_i c_if_i (\\vect{X})
                  \\end{array}\\right.

    >>> myFunction2 = ot.LinearCombinationFunction(functions, [2.0, 4.0])
    >>> print(myFunction2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *Function* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,    f_i: \\Rset^n \\rightarrow \\Rset`
    and :math:`vectorCoefficientColl = (\\vect{c}_1, \\hdots, \\vect{c}_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,   \\vect{c}_i \\in \\Rset^p`

    .. math::

        vectLinComb: \\left|\\begin{array}{rcl}
                         \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                         \\vect{X} & \\mapsto & \\displaystyle \\sum_i \\vect{c}_if_i (\\vect{X})
                     \\end{array}\\right.

    >>> functions=list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2']))
    >>> myFunction2 = ot.DualLinearCombinationFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(myFunction2([1, 2, 3]))
    [25,35]


    Create a *Function* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *Function* which is the composition function
    :math:`f\\circ g`:

    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                         ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionImplementation_getClassName(self)

    if _newclass:
        GetValidConstants = staticmethod(_func.FunctionImplementation_GetValidConstants)
    else:
        GetValidConstants = _func.FunctionImplementation_GetValidConstants
    if _newclass:
        GetValidFunctions = staticmethod(_func.FunctionImplementation_GetValidFunctions)
    else:
        GetValidFunctions = _func.FunctionImplementation_GetValidFunctions
    if _newclass:
        GetValidOperators = staticmethod(_func.FunctionImplementation_GetValidOperators)
    else:
        GetValidOperators = _func.FunctionImplementation_GetValidOperators

    def __mul__(self, *args):
        return _func.FunctionImplementation___mul__(self, *args)

    def __eq__(self, other):
        return _func.FunctionImplementation___eq__(self, other)

    def __repr__(self):
        return _func.FunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FunctionImplementation___str__(self, *args)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.FunctionImplementation_enableCache(self)


    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.FunctionImplementation_disableCache(self)


    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.FunctionImplementation_isCacheEnabled(self)


    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.FunctionImplementation_getCacheHits(self)


    def addCacheContent(self, inSample, outSample):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.FunctionImplementation_addCacheContent(self, inSample, outSample)


    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.FunctionImplementation_getCacheInput(self)


    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.FunctionImplementation_getCacheOutput(self)


    def clearCache(self):
        """Empty the content of the cache."""
        return _func.FunctionImplementation_clearCache(self)


    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.FunctionImplementation_enableHistory(self)


    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.FunctionImplementation_disableHistory(self)


    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.FunctionImplementation_isHistoryEnabled(self)


    def clearHistory(self):
        """Empty the content of the history."""
        return _func.FunctionImplementation_clearHistory(self)


    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.Sample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.FunctionImplementation_getHistoryInput(self)


    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.Sample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.FunctionImplementation_getHistoryOutput(self)


    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.FunctionImplementation_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.FunctionImplementation_getInputParameterHistory(self)


    def setEvaluation(self, evaluation):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.FunctionImplementation_setEvaluation(self, evaluation)


    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.FunctionImplementation_getEvaluation(self)


    def setGradient(self, gradient):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.GradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementation_setGradient(self, gradient)


    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.GradientImplementation`
            The gradient function.
        """
        return _func.FunctionImplementation_getGradient(self)


    def setHessian(self, hessian):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.HessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementation_setHessian(self, hessian)


    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.HessianImplementation`
            The hessian function.
        """
        return _func.FunctionImplementation_getHessian(self)


    def __call__(self, *args):
        return _func.FunctionImplementation___call__(self, *args)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.FunctionImplementation_gradient(self, *args)


    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.FunctionImplementation_hessian(self, *args)


    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.FunctionImplementation_parameterGradient(self, *args)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.FunctionImplementation_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.FunctionImplementation_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementation_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementation_setParameterDescription(self, description)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.FunctionImplementation_getParameterDimension(self)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.FunctionImplementation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.FunctionImplementation_getOutputDimension(self)


    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.FunctionImplementation_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.FunctionImplementation_getDescription(self)


    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.FunctionImplementation_getInputDescription(self)


    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.FunctionImplementation_getOutputDescription(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.FunctionImplementation_getMarginal(self, *args)


    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.FunctionImplementation_getEvaluationCallsNumber(self)


    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            Function has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.FunctionImplementation_getGradientCallsNumber(self)


    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            Function has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.FunctionImplementation_getHessianCallsNumber(self)


    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.FunctionImplementation_draw(self, *args)


    def __init__(self, *args):
        this = _func.new_FunctionImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FunctionImplementation
    __del__ = lambda self: None
FunctionImplementation_swigregister = _func.FunctionImplementation_swigregister
FunctionImplementation_swigregister(FunctionImplementation)

def FunctionImplementation_GetValidConstants():
    return _func.FunctionImplementation_GetValidConstants()
FunctionImplementation_GetValidConstants = _func.FunctionImplementation_GetValidConstants

def FunctionImplementation_GetValidFunctions():
    return _func.FunctionImplementation_GetValidFunctions()
FunctionImplementation_GetValidFunctions = _func.FunctionImplementation_GetValidFunctions

def FunctionImplementation_GetValidOperators():
    return _func.FunctionImplementation_GetValidOperators()
FunctionImplementation_GetValidOperators = _func.FunctionImplementation_GetValidOperators

class ProductFunction(FunctionImplementation):
    """
    Product function.

    Available constructor:
        ProductFunction(*f, g*)

    The function is the product function :math:`f\\times g`.

    Parameters
    ----------
    f,g : two :class:`~openturns.FunctionImplementation`
        The functions to multiply.

    Examples
    --------
    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x1', 'x2'], ['x1'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['x2'])
    >>> product = ot.ProductFunction(f.getImplementation(), g.getImplementation())
    >>> print(product([3, 4]))
    [12]

    Or, shorter:

    >>> product = f * g
    """

    __swig_setmethods__ = {}
    for _s in [FunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductFunction_getClassName(self)


    def __eq__(self, other):
        return _func.ProductFunction___eq__(self, other)

    def __repr__(self):
        return _func.ProductFunction___repr__(self)

    def __str__(self, *args):
        return _func.ProductFunction___str__(self, *args)

    def parameterGradient(self, inP):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ProductFunction_parameterGradient(self, inP)


    def __init__(self, *args):
        this = _func.new_ProductFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ProductFunction
    __del__ = lambda self: None
ProductFunction_swigregister = _func.ProductFunction_swigregister
ProductFunction_swigregister(ProductFunction)

class FunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_FunctionImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FunctionImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FunctionImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FunctionImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.FunctionImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_FunctionImplementationTypedInterfaceObject
    __del__ = lambda self: None
FunctionImplementationTypedInterfaceObject_swigregister = _func.FunctionImplementationTypedInterfaceObject_swigregister
FunctionImplementationTypedInterfaceObject_swigregister(FunctionImplementationTypedInterfaceObject)

class FunctionCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionCollection, name)
    __swig_destroy__ = _func.delete_FunctionCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.FunctionCollection_clear(self)


    def __len__(self):
        return _func.FunctionCollection___len__(self)

    def __eq__(self, rhs):
        return _func.FunctionCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.FunctionCollection___contains__(self, val)

    def __getitem__(self, i):
        return _func.FunctionCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.FunctionCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.FunctionCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.FunctionCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.FunctionCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.FunctionCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.FunctionCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.FunctionCollection_isEmpty(self)


    def __repr__(self):
        return _func.FunctionCollection___repr__(self)

    def __str__(self, *args):
        return _func.FunctionCollection___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_FunctionCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
FunctionCollection_swigregister = _func.FunctionCollection_swigregister
FunctionCollection_swigregister(FunctionCollection)

class FunctionPersistentCollection(openturns.common.PersistentObject, FunctionCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, FunctionCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, FunctionCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _func.new_FunctionPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _func.FunctionPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func.FunctionPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete_FunctionPersistentCollection
    __del__ = lambda self: None
FunctionPersistentCollection_swigregister = _func.FunctionPersistentCollection_swigregister
FunctionPersistentCollection_swigregister(FunctionPersistentCollection)

class Function(FunctionImplementationTypedInterfaceObject):
    """
    Function base class.

    Available constructors:
        Function(*inputs, outputs, formulas*)

        Function(*inputs, formulas*)

        Function(*inputString, formulaString, outputString = 'outputVariable'*)

        Function(*f, g*)

        Function(*functionCollection*)

        Function(*functionCollection, scalarCoefficientColl*)

        Function(*scalarFunctionCollection, vectorCoefficientColl*)

        Function(*function, comparisonOperator, threshold*)

        Function(*function, indices, referencePoint, parametersSet=True*)

        Function(*inputSample, outputSample*)

    Parameters
    ----------
    inputs : sequence of str
        Ordered list of input variables names of the *Function*.
    outputs : sequence of str
        Ordered list of output variables names of the *Function*.
        If it is not specified, default names are created for the output variables.
    formulas : sequence of str
        Ordered list of analytical formulas between the inputs and the outputs.
        The *Function* is defined by *ouputs = formulas(inputs)*.
    inputString : str
        Description of the *Function*'s input.
    outputString : str
        Description of the *Function*'s output.
    formulaString : str
        Analytical formula of the *Function*.
        The *Function* is defined by
        *ouputString = formulaString(inputString)*.

        Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

        Available operators:

        - = (assignment)
        - && (logical and)
        - || (logical or)
        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \\+ (addition)
        - \\- (subtraction)
        - \\* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

        Available constants:

        - _e (Euler's constant)
        - _pi (Pi)

    f,g : two :class:`~openturns.Function`
        The *Function* is the composition function :math:`f\\circ g`.
    functionCollection : list of :class:`~openturns.Function`
        Collection of several *Function*.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.
    scalarFunctionCollection : list of :class:`~openturns.Function`
        Collection of several scalar *Function*.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.
    function : :class:`~openturns.Function`
        Function from which another function is created.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator.
    threshold : float
        Threshold from which values are compared.
    indices : sequence of int
        Indices of the set variables which are set to *referencePoint*'s values.
    parametersSet : bool
        If *True* (default), the set variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        vector of *indices*.
    referencePoint : sequence of float
        Values of the set variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.

    Examples
    --------
    Create a *Function* from a list of analytical formulas and
    descriptions of the inputs and the outputs :

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'],
    ...                         ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *Function* from strings:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction('x', '2.0*sqrt(x)')
    >>> print(f(([16],[4])))
        [ y0 ]
    0 : [ 8  ]
    1 : [ 4  ]


    Create a *Function* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *Function* from another *Function*:

    >>> f = ot.SymbolicFunction(ot.Description.BuildDefault(4, 'x'),
    ...                         ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.ParametricFunction(f, [3, 1], [10.0, 4.0], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.ParametricFunction(f, [3, 1], [6.0, 5.0], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *Function* from another *Function*
    and by using a comparison operator:

    >>> analytical = ot.SymbolicFunction(['x0','x1'], ['x0 + x1'])
    >>> indicator = ot.IndicatorFunction(analytical, ot.Less(), 0.0)
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *Function* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> myFunction = ot.AggregatedFunction(functions)
    >>> print(myFunction([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *Function* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
    then the linear combination is:

    .. math::

        linComb: \\left|\\begin{array}{rcl}
                      \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                      \\vect{X} & \\mapsto & \\displaystyle \\sum_i c_if_i (\\vect{X})
                  \\end{array}\\right.

    >>> myFunction2 = ot.LinearCombinationFunction(functions, [2.0, 4.0])
    >>> print(myFunction2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *Function* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,    f_i: \\Rset^n \\rightarrow \\Rset`
    and :math:`vectorCoefficientColl = (\\vect{c}_1, \\hdots, \\vect{c}_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,   \\vect{c}_i \\in \\Rset^p`

    .. math::

        vectLinComb: \\left|\\begin{array}{rcl}
                         \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                         \\vect{X} & \\mapsto & \\displaystyle \\sum_i \\vect{c}_if_i (\\vect{X})
                     \\end{array}\\right.

    >>> functions=list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2']))
    >>> myFunction2 = ot.DualLinearCombinationFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(myFunction2([1, 2, 3]))
    [25,35]


    Create a *Function* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *Function* which is the composition function
    :math:`f\\circ g`:

    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                         ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    __swig_setmethods__ = {}
    for _s in [FunctionImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Function, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Function, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Function_getClassName(self)


    def __eq__(self, other):
        return _func.Function___eq__(self, other)

    def __repr__(self):
        return _func.Function___repr__(self)

    def __str__(self, *args):
        return _func.Function___str__(self, *args)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.Function_enableCache(self)


    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.Function_disableCache(self)


    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.Function_isCacheEnabled(self)


    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.Function_getCacheHits(self)


    def addCacheContent(self, inSample, outSample):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.Function_addCacheContent(self, inSample, outSample)


    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.Function_getCacheInput(self)


    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.Function_getCacheOutput(self)


    def clearCache(self):
        """Empty the content of the cache."""
        return _func.Function_clearCache(self)


    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.Function_enableHistory(self)


    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.Function_disableHistory(self)


    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.Function_isHistoryEnabled(self)


    def clearHistory(self):
        """Empty the content of the history."""
        return _func.Function_clearHistory(self)


    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.Sample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.Function_getHistoryInput(self)


    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.Sample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.Function_getHistoryOutput(self)


    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.Function_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.Function_getInputParameterHistory(self)


    def setEvaluation(self, evaluation):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.Function_setEvaluation(self, evaluation)


    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.Function_getEvaluation(self)


    def setGradient(self, gradient):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.GradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.Function_setGradient(self, gradient)


    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.GradientImplementation`
            The gradient function.
        """
        return _func.Function_getGradient(self)


    def setHessian(self, hessian):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.HessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.Function_setHessian(self, hessian)


    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.HessianImplementation`
            The hessian function.
        """
        return _func.Function_getHessian(self)


    def __mul__(self, right):
        return _func.Function___mul__(self, right)

    def __add__(self, right):
        return _func.Function___add__(self, right)

    def __sub__(self, right):
        return _func.Function___sub__(self, right)

    def __call__(self, *args):
        return _func.Function___call__(self, *args)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.Function_gradient(self, *args)


    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.Function_hessian(self, *args)


    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.Function_parameterGradient(self, *args)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.Function_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.Function_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Function_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.Function_setParameterDescription(self, description)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.Function_getParameterDimension(self)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.Function_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.Function_getOutputDimension(self)


    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.Function_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.Function_getDescription(self)


    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.Function_getInputDescription(self)


    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.Function_getOutputDescription(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.Function_getMarginal(self, *args)


    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.Function_getCallsNumber(self)


    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.Function_getEvaluationCallsNumber(self)


    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            Function has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.Function_getGradientCallsNumber(self)


    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            Function has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.Function_getHessianCallsNumber(self)


    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.Function_draw(self, *args)

    if _newclass:
        GetValidConstants = staticmethod(_func.Function_GetValidConstants)
    else:
        GetValidConstants = _func.Function_GetValidConstants
    if _newclass:
        GetValidFunctions = staticmethod(_func.Function_GetValidFunctions)
    else:
        GetValidFunctions = _func.Function_GetValidFunctions
    if _newclass:
        GetValidOperators = staticmethod(_func.Function_GetValidOperators)
    else:
        GetValidOperators = _func.Function_GetValidOperators

    def __init__(self, *args):
        this = _func.new_Function(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_Function
    __del__ = lambda self: None
Function_swigregister = _func.Function_swigregister
Function_swigregister(Function)

def Function_GetValidConstants():
    return _func.Function_GetValidConstants()
Function_GetValidConstants = _func.Function_GetValidConstants

def Function_GetValidFunctions():
    return _func.Function_GetValidFunctions()
Function_GetValidFunctions = _func.Function_GetValidFunctions

def Function_GetValidOperators():
    return _func.Function_GetValidOperators()
Function_GetValidOperators = _func.Function_GetValidOperators


# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonFunction(object):
    """
    Override Function from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a sequence of float,
        returns a sequence of float

    You can also optionally override these functions:
        _exec_sample(X): multiple evaluations, X is a 2-d sequence of float,
        returns a 2-d sequence of float

        _gradient(X): gradient, X is a sequence of float,
        returns a 2-d sequence of float

        _hessian(X): hessian, X is a sequence of float,
        returns a 3-d sequence of float
    """
    def __init__(self, n=0, p=0):
        try:
            self.__n = int(n)
        except:
            raise TypeError('n argument is not an integer.')
        try:
            self.__p = int(p)
        except:
            raise TypeError('p argument is not an integer.')
        self.__descIn = list(map(lambda i: 'x' + str(i), range(n)))
        self.__descOut = list(map(lambda i: 'y' + str(i), range(p)))

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__n):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__p):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__n

    def getOutputDimension(self):
        return self.__p

    def __str__(self):
        return 'OpenTURNSPythonFunction( %s #%d ) -> %s #%d' % (self.__descIn, self.__n, self.__descOut, self.__p)

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        try:
            pt = openturns.typ.Point(X)
        except TypeError:
            try:
                ns = openturns.typ.Sample(X)
            except TypeError:
                raise TypeError('Expect a 1-d or 2-d sequence of float as argument')
            else:
                Y = self._exec_sample(ns)
        else:
            Y = self._exec(pt)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are 1-d sequence of float')

    def _exec_sample(self, X):
        res = list()
        for point in X:
            res.append(self._exec(point))
        return res

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]


def _exec_sample_multiprocessing(func, n_cpus):
    """Return a distributed function using multiprocessing.

    Parameters
    ----------
    func : Function or calable
        A callable python object, usually a function. The function should take
        an input vector as argument and return an output vector.

    n_cpus : int
        Number of CPUs on which to distribute the function calls.

    Returns
    -------
    _exec_sample : Function or callable
        The parallelized funtion.
    """
    def _exec_sample(X):
        from multiprocessing import Pool
        p = Pool(processes=n_cpus)
        rs = p.map_async(func, X)
        p.close()
        return rs.get()
    return _exec_sample

class PythonFunction(Function):
    """
    Override Function from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    func : a callable python object
        called on a single point.
        Default is None.
    func_sample : a callable python object
        called on multiple points at once.
        Default is None.
    gradient : a callable python objects
        returns the gradient as a 2-d sequence of float.
        Default is None (uses finite-difference).
    hessian : a callable python object
        returns the hessian as a 3-d sequence of float.
        Default is None (uses finite-difference).
    n_cpus : integer
        Number of cpus on which func should be distributed using multiprocessing.
        If -1, it uses all the cpus available. If 1, it does nothing. If n_cpus
        and func_sample are both given as arguments, n_cpus will be ignored and
        samples will be handled by func_sample.
        Default is None.

    Notes
    -----
    You must provide at least func or func_sample arguments. Notice that if
    func_sample is provided, n_cpus is ignored. Note also that if PythonFunction
    is distributed (n_cpus > 1), the traceback of a raised exception by a func
    call is lost due to the way multiprocessing dispatches and handles func
    calls. This can be solved by temporarily deactivating n_cpus during the
    development of the wrapper or by manually handling the distribution of the
    wrapper with external libraries like joblib that keep track of a raised
    exception and shows the traceback to the user.

    Examples
    --------
    >>> import openturns as ot
    >>> def a_exec(X):
    ...     Y = [3.*X[0] - X[1]]
    ...     return Y
    >>> def a_grad(X):
    ...     dY = [[3.], [-1.]]
    ...     return dY
    >>> f = ot.PythonFunction(2, 1, a_exec, gradient=a_grad)
    >>> X = [100., 100.]
    >>> Y = f(X)
    >>> print(Y)
    [200]
    >>> dY = f.gradient(X)
    >>> print(dY)
    [[  3 ]
     [ -1 ]]
    """
    def __new__(self, n, p, func=None, func_sample=None, gradient=None, hessian=None, n_cpus=None):
        if func == None and func_sample == None:
            raise RuntimeError('no func nor func_sample given.')
        instance = OpenTURNSPythonFunction(n, p)
        import collections
        if func != None:
            if not isinstance(func, collections.Callable):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        if func_sample != None:
            if not isinstance(func_sample, collections.Callable):
                raise RuntimeError('func_sample argument is not callable.')
            instance._exec_sample = func_sample
            if func == None:
                instance._exec = instance._exec_point_on_exec_sample
        elif n_cpus != None and n_cpus != 1 and func != None:
            if not isinstance(n_cpus, int):
                raise RuntimeError('n_cpus is not an integer')
            if n_cpus == -1:
                import multiprocessing
                n_cpus = multiprocessing.cpu_count()
            instance._exec_sample = _exec_sample_multiprocessing(func, n_cpus)
        if gradient != None:
            if not isinstance(gradient, collections.Callable):
                raise RuntimeError('gradient argument is not callable.')
            instance._gradient = gradient
        if hessian != None:
            if not isinstance(hessian, collections.Callable):
                raise RuntimeError('hessian argument is not callable.')
            instance._hessian = hessian 
        return Function(instance)

# deprecated
class NumericalMathFunction(Function):
    def __init__(self, *args):
        super(NumericalMathFunction, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalMathFunction is deprecated in favor of Function')

class AggregatedFunction(Function):
    """
    Aggregated function.

    Available constructor:
        AggregatedFunction(*functionCollection*)

    The built function stacks all the outputs from each function in the list.

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Functions to aggregate.

    Examples
    --------
    >>> import openturns as ot
    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                        ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                        ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> myFunction = ot.AggregatedFunction(functions)
    >>> print(myFunction([1.0, 2.0, 3.0]))
    [3,6,8,0]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AggregatedFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AggregatedFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AggregatedFunction_getClassName(self)


    def __eq__(self, other):
        return _func.AggregatedFunction___eq__(self, other)

    def __repr__(self):
        return _func.AggregatedFunction___repr__(self)

    def __str__(self, *args):
        return _func.AggregatedFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_AggregatedFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_AggregatedFunction
    __del__ = lambda self: None
AggregatedFunction_swigregister = _func.AggregatedFunction_swigregister
AggregatedFunction_swigregister(AggregatedFunction)

class SymbolicFunction(Function):
    """
    Symbolic function.

    Available constructor:
        SymbolicFunction(*inputs, formulas*)

    Parameters
    ----------
    inputs : sequence of str, or str
        List of input variables names of the function.
    formulas : sequence of str, or str
        List of analytical formulas between the inputs and the outputs.
        The function is defined by *ouputs = formulas(inputs)*.

    Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

        Available operators:

        - = (assignment)
        - && (logical and)
        - || (logical or)
        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \\+ (addition)
        - \\- (subtraction)
        - \\* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

        Available constants:

        - _e (Euler's constant)
        - _pi (Pi)

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x0', 'x1'], ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymbolicFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymbolicFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicFunction_getClassName(self)


    def __eq__(self, other):
        return _func.SymbolicFunction___eq__(self, other)

    def __repr__(self):
        return _func.SymbolicFunction___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicFunction___str__(self, *args)

    def GetValidConstants():
        """
        Return the list of valid constants.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the constants we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidConstants()[0])
        _e -> Euler's constant (2.71828...)
        """
        return _func.SymbolicFunction_GetValidConstants()

    GetValidConstants = staticmethod(GetValidConstants)

    def GetValidFunctions():
        """
        Return the list of valid functions.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the functions we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidFunctions()[0])
        sin(arg) -> sine function
        """
        return _func.SymbolicFunction_GetValidFunctions()

    GetValidFunctions = staticmethod(GetValidFunctions)

    def GetValidOperators():
        """
        Return the list of valid operators.

        Returns
        -------
        list_operators : :class:`~openturns.Description`
            List of the operators we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.SymbolicFunction.GetValidOperators()[0])
        = -> assignement, can only be applied to variable names (priority -1)
        """
        return _func.SymbolicFunction_GetValidOperators()

    GetValidOperators = staticmethod(GetValidOperators)

    def __init__(self, *args):
        this = _func.new_SymbolicFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_SymbolicFunction
    __del__ = lambda self: None
SymbolicFunction_swigregister = _func.SymbolicFunction_swigregister
SymbolicFunction_swigregister(SymbolicFunction)

def SymbolicFunction_GetValidConstants():
    """
    Return the list of valid constants.

    Returns
    -------
    list_constants : :class:`~openturns.Description`
        List of the constants we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.SymbolicFunction.GetValidConstants()[0])
    _e -> Euler's constant (2.71828...)
    """
    return _func.SymbolicFunction_GetValidConstants()

def SymbolicFunction_GetValidFunctions():
    """
    Return the list of valid functions.

    Returns
    -------
    list_functions : :class:`~openturns.Description`
        List of the functions we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.SymbolicFunction.GetValidFunctions()[0])
    sin(arg) -> sine function
    """
    return _func.SymbolicFunction_GetValidFunctions()

def SymbolicFunction_GetValidOperators():
    """
    Return the list of valid operators.

    Returns
    -------
    list_operators : :class:`~openturns.Description`
        List of the operators we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.SymbolicFunction.GetValidOperators()[0])
    = -> assignement, can only be applied to variable names (priority -1)
    """
    return _func.SymbolicFunction_GetValidOperators()

class LinearCombinationFunction(Function):
    """
    Linear combination of functions.

    Allows to create a function which is the linear combination of functions 
    with scalar weights.

    :math:`functionCollection  = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
    then the linear combination is:

    .. math::

        linComb: \\left|\\begin{array}{rcl}
                      \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                      \\vect{X} & \\mapsto & \\displaystyle \\sum_i c_if_i (\\vect{X})
                  \\end{array}\\right.

    Available constructor:
        LinearCombinationFunction(*functionCollection, scalarCoefficientColl*)

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Collection of functions to sum.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.

    Examples
    --------
    >>> import openturns as ot
    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> coefficients = [2.0, 4.0]
    >>> myFunction2 = ot.LinearCombinationFunction(functions, coefficients)
    >>> print(myFunction2([1.0, 2.0, 3.0]))
    [38,12]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationFunction_getClassName(self)


    def __eq__(self, other):
        return _func.LinearCombinationFunction___eq__(self, other)

    def __repr__(self):
        return _func.LinearCombinationFunction___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_LinearCombinationFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationFunction
    __del__ = lambda self: None
LinearCombinationFunction_swigregister = _func.LinearCombinationFunction_swigregister
LinearCombinationFunction_swigregister(LinearCombinationFunction)

class ComposedFunction(FunctionImplementation):
    """
    Composed function.

    Available constructor:
        ComposedFunction(*f, g*)

    The function is the composed function :math:`f\\circ g`.

    Parameters
    ----------
    f,g : two :class:`~openturns.Function`
        The functions to compose.

    Examples
    --------
    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x1', 'x2'],
    ...                           ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
    >>> composed = ot.ComposedFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """

    __swig_setmethods__ = {}
    for _s in [FunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedFunction_getClassName(self)


    def __eq__(self, other):
        return _func.ComposedFunction___eq__(self, other)

    def __repr__(self):
        return _func.ComposedFunction___repr__(self)

    def parameterGradient(self, inP):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ComposedFunction_parameterGradient(self, inP)


    def __init__(self, *args):
        this = _func.new_ComposedFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ComposedFunction
    __del__ = lambda self: None
ComposedFunction_swigregister = _func.ComposedFunction_swigregister
ComposedFunction_swigregister(ComposedFunction)

class ParametricFunction(Function):
    """
    Parametric function.

    Available constructor:
        ParametricFunction(*function, indices, referencePoint, parametersSet*)

    It defines a parametric function from *function* by freezing the variables
    marked by the *indices* set to the values of *referencePoint*.

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Function with full parameters from which the parametric function is built.
    indices : sequence of int
        Indices of the frozen variables.
    referencePoint : sequence of float
        Values of the frozen variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    parametersSet : bool
        If *True* (default), the frozen variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        set of *indices*.

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(ot.Description.BuildDefault(4, 'x'),
    ...                              ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.ParametricFunction(f, [3, 1], [10, 4])
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5 using the complementary set flag:

    >>> g = ot.ParametricFunction(f, [3, 1], [6, 5], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricFunction_getClassName(self)


    def __eq__(self, other):
        return _func.ParametricFunction___eq__(self, other)

    def __repr__(self):
        return _func.ParametricFunction___repr__(self)

    def __str__(self, *args):
        return _func.ParametricFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_ParametricFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ParametricFunction
    __del__ = lambda self: None
ParametricFunction_swigregister = _func.ParametricFunction_swigregister
ParametricFunction_swigregister(ParametricFunction)

class DualLinearCombinationFunction(Function):
    """
    Linear combination of functions with vectorial weights.

    Allows to create a function which is the linear combination
    of scalar functions with vectorial weights.

    Parameters
    ----------
    functionCollection : sequence of :class:`~openturns.Function`
        Collection of functions.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.

    Examples
    --------
    >>> import openturns as ot
    >>> functions = list()
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                        ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.SymbolicFunction(['x1', 'x2', 'x3'],
    ...                                        ['x1^2 + x2']))
    >>> myFunction = ot.DualLinearCombinationFunction(functions, [[2.0, 4.0], [3.0, 1.0]])
    >>> print(myFunction([1, 2, 3]))
    [25,35]

    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationFunction_getClassName(self)


    def __eq__(self, other):
        return _func.DualLinearCombinationFunction___eq__(self, other)

    def __repr__(self):
        return _func.DualLinearCombinationFunction___repr__(self)

    def __str__(self, *args):
        return _func.DualLinearCombinationFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_DualLinearCombinationFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationFunction
    __del__ = lambda self: None
DualLinearCombinationFunction_swigregister = _func.DualLinearCombinationFunction_swigregister
DualLinearCombinationFunction_swigregister(DualLinearCombinationFunction)

class FieldFunctionImplementation(openturns.common.PersistentObject):
    """
    Field function.

    Available constructors:
        FieldFunction(*meshDimension=1*)

        FieldFunction(*function, meshDimension=1*)

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q` used to define a
        :class:`~openturns.ValueFunction` object.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the mesh :math:`\\cM`.

    Notes
    -----
    Field functions are functions being able to act on fields.
    Two particular field functions are defined:
    the :class:`spatial function <openturns.ValueFunction>` and
    the :class:`temporal function <openturns.VertexValueFunction>`.


    A field function
    :math:`f_{dyn}:\\cD \\times \\Rset^d \\mapsto \\cD' \\times \\Rset^q`
    where :math:`\\cD \\in \\Rset^n` and :math:`\\cD' \\in \\Rset^p` is defined by:

    .. math::

        f_{dyn}(\\vect{t}, \\vect{x}) = (t'(\\vect{t}), v'(\\vect{t}, \\vect{x}))

    with :math:`t': \\cD \\mapsto \\cD'` and
    :math:`v': \\cD \\times \\Rset^d \\mapsto \\Rset^q`.

    A field function :math:`f_{dyn}` transforms a multivariate stochastic
    process:

    .. math::

        X: \\Omega \\times \\cD \\mapsto \\Rset^d

    where :math:`\\cD \\in \\Rset^n` is discretized according to the mesh :math:`\\cM`
    into the multivariate stochastic process:

    .. math::

        Y=f_{dyn}(X)

    such that:

    .. math::

        Y: \\Omega \\times \\cD' \\mapsto \\Rset^q

    where the mesh :math:`\\cD' \\in \\Rset^p`  is discretized according to the
    :math:`\\cM'`.

    A field function :math:`f_{dyn}` also acts on fields and produces fields of
    possibly different dimension (:math:`q\\neq d`) and mesh (:math:`\\cD \\neq \\cD'`
    or :math:`\\cM \\neq \\cM'`).

    OpenTURNS only proposes field functions where :math:`\\cD'=\\cD` and
    :math:`\\cM'=\\cM` which means that :math:`t'=Id` through the *spatial function*
    and the *temporal function*. It follows that the process :math:`Y` shares the
    same mesh with :math:`X`, only its values have changed.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldFunctionImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldFunctionImplementation_getClassName(self)


    def __eq__(self, other):
        return _func.FieldFunctionImplementation___eq__(self, other)

    def __repr__(self):
        return _func.FieldFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.FieldFunctionImplementation___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldFunctionImplementation___call__(self, *args)

    def getSpatialDimension(self):
        """
        Get the dimension of the mesh.

        Returns
        -------
        spatialDimension : int, :math:`n \\geq 0`
            Dimension of the mesh :math:`\\cM`.
        """
        return _func.FieldFunctionImplementation_getSpatialDimension(self)


    def getInputDimension(self):
        """
        Get the dimension of the input.

        Returns
        -------
        d : int
            Input dimension :math:`d` of the function.
        """
        return _func.FieldFunctionImplementation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Get the dimension of the output.

        Returns
        -------
        q : int
            Output dimension :math:`q` of the function.
        """
        return _func.FieldFunctionImplementation_getOutputDimension(self)


    def setInputDescription(self, inputDescription):
        """
        Set the description of the inputs.

        Parameters
        ----------
        inputDescription : sequence of str
            Describes the inputs of the function.
        """
        return _func.FieldFunctionImplementation_setInputDescription(self, inputDescription)


    def getInputDescription(self):
        """
        Get the description of the inputs.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Describes the inputs of the function.
        """
        return _func.FieldFunctionImplementation_getInputDescription(self)


    def setOutputDescription(self, outputDescription):
        """
        Set the description of the outputs.

        Parameters
        ----------
        outputDescription : sequence of str
            Describes the outputs of the function.
        """
        return _func.FieldFunctionImplementation_setOutputDescription(self, outputDescription)


    def getOutputDescription(self):
        """
        Get the description of the outputs.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Describes the outputs of the function.
        """
        return _func.FieldFunctionImplementation_getOutputDescription(self)


    def getOutputMesh(self, inputMesh):
        """
        Get the mesh associated to the output process.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh of the output process.
        """
        return _func.FieldFunctionImplementation_getOutputMesh(self, inputMesh)


    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            FieldFunction.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            FieldFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the field function :math:`f_{dyn}`.
        """
        return _func.FieldFunctionImplementation_getMarginal(self, *args)


    def getCallsNumber(self):
        """
        Get the number of calls of a FieldFunction.

        Returns
        -------
        callsNumber : int
            Counts the number of times the FieldFunction has been called since its
            creation.
        """
        return _func.FieldFunctionImplementation_getCallsNumber(self)


    def __init__(self, *args):
        this = _func.new_FieldFunctionImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FieldFunctionImplementation
    __del__ = lambda self: None
FieldFunctionImplementation_swigregister = _func.FieldFunctionImplementation_swigregister
FieldFunctionImplementation_swigregister(FieldFunctionImplementation)

class FieldFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_FieldFunctionImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FieldFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FieldFunctionImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FieldFunctionImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.FieldFunctionImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_FieldFunctionImplementationTypedInterfaceObject
    __del__ = lambda self: None
FieldFunctionImplementationTypedInterfaceObject_swigregister = _func.FieldFunctionImplementationTypedInterfaceObject_swigregister
FieldFunctionImplementationTypedInterfaceObject_swigregister(FieldFunctionImplementationTypedInterfaceObject)

class FieldFunction(FieldFunctionImplementationTypedInterfaceObject):
    """
    Field function.

    Available constructors:
        FieldFunction(*meshDimension=1*)

        FieldFunction(*function, meshDimension=1*)

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q` used to define a
        :class:`~openturns.ValueFunction` object.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the mesh :math:`\\cM`.

    Notes
    -----
    Field functions are functions being able to act on fields.
    Two particular field functions are defined:
    the :class:`spatial function <openturns.ValueFunction>` and
    the :class:`temporal function <openturns.VertexValueFunction>`.


    A field function
    :math:`f_{dyn}:\\cD \\times \\Rset^d \\mapsto \\cD' \\times \\Rset^q`
    where :math:`\\cD \\in \\Rset^n` and :math:`\\cD' \\in \\Rset^p` is defined by:

    .. math::

        f_{dyn}(\\vect{t}, \\vect{x}) = (t'(\\vect{t}), v'(\\vect{t}, \\vect{x}))

    with :math:`t': \\cD \\mapsto \\cD'` and
    :math:`v': \\cD \\times \\Rset^d \\mapsto \\Rset^q`.

    A field function :math:`f_{dyn}` transforms a multivariate stochastic
    process:

    .. math::

        X: \\Omega \\times \\cD \\mapsto \\Rset^d

    where :math:`\\cD \\in \\Rset^n` is discretized according to the mesh :math:`\\cM`
    into the multivariate stochastic process:

    .. math::

        Y=f_{dyn}(X)

    such that:

    .. math::

        Y: \\Omega \\times \\cD' \\mapsto \\Rset^q

    where the mesh :math:`\\cD' \\in \\Rset^p`  is discretized according to the
    :math:`\\cM'`.

    A field function :math:`f_{dyn}` also acts on fields and produces fields of
    possibly different dimension (:math:`q\\neq d`) and mesh (:math:`\\cD \\neq \\cD'`
    or :math:`\\cM \\neq \\cM'`).

    OpenTURNS only proposes field functions where :math:`\\cD'=\\cD` and
    :math:`\\cM'=\\cM` which means that :math:`t'=Id` through the *spatial function*
    and the *temporal function*. It follows that the process :math:`Y` shares the
    same mesh with :math:`X`, only its values have changed.
    """

    __swig_setmethods__ = {}
    for _s in [FieldFunctionImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldFunctionImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldFunction_getClassName(self)


    def __eq__(self, other):
        return _func.FieldFunction___eq__(self, other)

    def __repr__(self):
        return _func.FieldFunction___repr__(self)

    def __str__(self, *args):
        return _func.FieldFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.FieldFunction___call__(self, *args)

    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            FieldFunction.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            FieldFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the field function :math:`f_{dyn}`.
        """
        return _func.FieldFunction_getMarginal(self, *args)


    def getSpatialDimension(self):
        """
        Get the dimension of the mesh.

        Returns
        -------
        spatialDimension : int, :math:`n \\geq 0`
            Dimension of the mesh :math:`\\cM`.
        """
        return _func.FieldFunction_getSpatialDimension(self)


    def getInputDimension(self):
        """
        Get the dimension of the input.

        Returns
        -------
        d : int
            Input dimension :math:`d` of the function.
        """
        return _func.FieldFunction_getInputDimension(self)


    def getOutputDimension(self):
        """
        Get the dimension of the output.

        Returns
        -------
        q : int
            Output dimension :math:`q` of the function.
        """
        return _func.FieldFunction_getOutputDimension(self)


    def getOutputMesh(self, inputMesh):
        """
        Get the mesh associated to the output process.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh of the output process.
        """
        return _func.FieldFunction_getOutputMesh(self, inputMesh)


    def getInputDescription(self):
        """
        Get the description of the inputs.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Describes the inputs of the function.
        """
        return _func.FieldFunction_getInputDescription(self)


    def getOutputDescription(self):
        """
        Get the description of the outputs.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Describes the outputs of the function.
        """
        return _func.FieldFunction_getOutputDescription(self)


    def getCallsNumber(self):
        """
        Get the number of calls of a FieldFunction.

        Returns
        -------
        callsNumber : int
            Counts the number of times the FieldFunction has been called since its
            creation.
        """
        return _func.FieldFunction_getCallsNumber(self)


    def __init__(self, *args):
        this = _func.new_FieldFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FieldFunction
    __del__ = lambda self: None
FieldFunction_swigregister = _func.FieldFunction_swigregister
FieldFunction_swigregister(FieldFunction)


# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonFieldFunction(object):
    """
    Override FieldFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    s : positive integer
        the spatial dimension

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a :class:`~openturns.Field`,
        returns a :class:`~openturns.Field`
    """
    def __init__(self, n=0, p=0, s=0):
        try:
            self.__n = int(n)
        except:
            raise TypeError('n argument is not an integer.')
        try:
            self.__p = int(p)
        except:
            raise TypeError('p argument is not an integer.')
        try:
            self.__s = int(s)
        except:
            raise TypeError('s argument is not an integer.')
        self.__descIn = list(map(lambda i: 'x' + str(i), range(n)))
        self.__descOut = list(map(lambda i: 'y' + str(i), range(p)))

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__n):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__p):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__n

    def getOutputDimension(self):
        return self.__p

    def getSpatialDimension(self):
        return self.__s

    def __str__(self):
        return 'OpenTURNSPythonFieldFunction( %s #%d ) -> %s #%d' % (self.__descIn, self.__n, self.__descOut, self.__p)

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = self._exec(X)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are Fields objects')

class PythonFieldFunction(FieldFunction):
    """
    Override FieldFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    s : positive int
        the spatial dimension
    func : a callable python object
        called on a :class:`~openturns.Field` object.
        Returns a :class:`~openturns.Field`.
        Default is None.

    Notes
    -----
    func 
    """
    def __new__(self, n, p, s, func=None):
        if func == None:
            raise RuntimeError('func not provided.')
        instance = OpenTURNSPythonFieldFunction(n, p, s)
        import collections
        if func != None:
            if not isinstance(func, collections.Callable):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        return FieldFunction(instance)


# deprecated
class DynamicalFunction(FieldFunction):
    def __init__(self, *args):
        super(DynamicalFunction, self).__init__(*args)
        openturns.common.Log.Warn('class DynamicalFunction is deprecated in favor of FieldFunction')

class OpenTURNSPythonDynamicalFunction(OpenTURNSPythonFieldFunction):
    def __init__(self, *args):
        super(OpenTURNSPythonDynamicalFunction, self).__init__(*args)
        openturns.common.Log.Warn('class OpenTURNSPythonDynamicalFunction is deprecated in favor of OpenTURNSPythonFieldFunction')

class PythonDynamicalFunction(PythonFieldFunction):
    def __new__(self, *args):
        common.Log.Warn('class PythonDynamicalFunction is deprecated in favor of PythonFieldFunction')
        return FieldFunction(*args)


class IndicatorFunction(Function):
    """
    Indicator function.

    This function compares the output of another function against a threshold.

    Parameters
    ----------
    function : :class:`~openturns.Function`
        Function from which another function is created.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator.
    threshold : float
        Threshold from which values are compared.

    Examples
    --------
    >>> import openturns as ot
    >>> analytical = ot.SymbolicFunction(['x0', 'x1'], ['x0 + x1'])
    >>> indicator = ot.IndicatorFunction(analytical, ot.Less(), 0.0)
    >>> print(indicator([2, 3]))
    [0]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndicatorFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndicatorFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IndicatorFunction_getClassName(self)


    def __eq__(self, other):
        return _func.IndicatorFunction___eq__(self, other)

    def __repr__(self):
        return _func.IndicatorFunction___repr__(self)

    def __str__(self, *args):
        return _func.IndicatorFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_IndicatorFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_IndicatorFunction
    __del__ = lambda self: None
IndicatorFunction_swigregister = _func.IndicatorFunction_swigregister
IndicatorFunction_swigregister(IndicatorFunction)

class ValueFunction(FieldFunctionImplementation):
    """
    Spatial function.

    Available constructors:
        ValueFunction(*meshDimension=1*)

        ValueFunction(*g, meshDimension=1*)

    Parameters
    ----------
    g : :class:`~openturns.Function`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q`.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the vertices of the mesh :math:`\\cM`. This data is required
        for tests on the compatibility of dimension when a composite process is
        created using the spatial function.

    Notes
    -----
    A spatial function
    :math:`f_{spat}: \\cD \\times \\Rset^d \\mapsto \\cD \\times \\Rset^q`, with
    :math:`\\cD \\in \\Rset^n`, is a particular
    :class:`field function <openturns.FieldFunction>` that lets invariant
    the mesh of a field and defined by a function
    :math:`g : \\Rset^d  \\mapsto \\Rset^q` such that:

    .. math::

        f_{spat}(\\vect{t}, \\vect{x})=(\\vect{t}, g(\\vect{x}))

    Let's note that the input dimension of :math:`f_{spat}` still designs the
    dimension of :math:`\\vect{x}`: :math:`d`. Its output dimension is equal to
    :math:`q`.

    See also
    --------
    VertexValueFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`g : \\Rset^d \\mapsto \\Rset^q` such as:

    .. math::

        g: \\left|\\begin{array}{rcl}
                    \\Rset & \\rightarrow & \\Rset \\\\
                    x & \\mapsto & x^2
                \\end{array}\\right.

    >>> g = ot.SymbolicFunction(['x'], ['x^2'])

    Convert :math:`g` into a spatial function with :math:`n` the dimension of the
    mesh of the field on which :math:`g` will be applied:

    >>> n = 1
    >>> myValueFunction = ot.ValueFunction(g, n)
    >>> # Create a TimeSeries
    >>> tg = ot.RegularGrid(0.0, 0.2, 6)
    >>> data = ot.Sample(tg.getN(), g.getInputDimension())
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(tg, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(myValueFunction(ts))
        [ t    y0   ]
    0 : [  0    0   ]
    1 : [  0.2  1   ]
    2 : [  0.4  4   ]
    3 : [  0.6  9   ]
    4 : [  0.8 16   ]
    5 : [  1   25   ]
    """

    __swig_setmethods__ = {}
    for _s in [FieldFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ValueFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ValueFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ValueFunction_getClassName(self)


    def __eq__(self, other):
        return _func.ValueFunction___eq__(self, other)

    def __repr__(self):
        return _func.ValueFunction___repr__(self)

    def __str__(self, *args):
        return _func.ValueFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.ValueFunction___call__(self, *args)

    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            FieldFunction.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            FieldFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the field function :math:`f_{dyn}`.
        """
        return _func.ValueFunction_getMarginal(self, *args)


    def getEvaluation(self):
        """
        Get the evaluation function of :math:`g`.

        Returns
        -------
        g : :class:`~openturns.EvaluationImplementation`
            Evaluation function of :math:`g: \\Rset^d \\mapsto \\Rset^q`.

        Examples
        --------
        >>> import openturns as ot
        >>> g = ot.SymbolicFunction(['x'], ['x^2'])
        >>> n = 1
        >>> myValueFunction = ot.ValueFunction(g, n)
        >>> print(myValueFunction.getEvaluation())
        [x]->[x^2]
        """
        return _func.ValueFunction_getEvaluation(self)


    def __init__(self, *args):
        this = _func.new_ValueFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ValueFunction
    __del__ = lambda self: None
ValueFunction_swigregister = _func.ValueFunction_swigregister
ValueFunction_swigregister(ValueFunction)


# deprecated
class SpatialFunction(ValueFunction):
    def __init__(self, *args):
        super(SpatialFunction, self).__init__(*args)
        openturns.common.Log.Warn('class SpatialFunction is deprecated in favor of ValueFunction')

class VertexValueFunction(FieldFunctionImplementation):
    """
    Temporal function.

    Available constructors:
        VertexValueFunction(*meshDimension=1*)

        VertexValueFunction(*h, meshDimension=1*)

    Parameters
    ----------
    h : :class:`~openturns.Function`
        Function :math:`h: \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q`.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the vertices of the mesh :math:`\\cM`. This data is required
        for tests on the compatibility of dimension when a composite process is
        created using the temporal function.

    Notes
    -----
    A temporal function
    :math:`f_{temp}: \\cD \\times \\Rset^d \\mapsto \\cD \\times \\Rset^q`, with
    :math:`\\cD \\in \\Rset^n`, is a particular
    :class:`field function <openturns.FieldFunction>` that lets invariant
    the mesh of a field and defined by a function
    :math:`h : \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q` such that:

    .. math::

      f_{temp}(\\vect{t}, \\vect{x})=(\\vect{t}, h(\\vect{t},\\vect{x}))

    Let's note that the input dimension of :math:`f_{temp}` still design the
    dimension of :math:`\\vect{x}`: :math:`d`. Its output dimension is equal to
    :math:`q`.

    See also
    --------
    ValueFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`h : \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q` such as:

    .. math::

        h: \\left|\\begin{array}{rcl}
                    \\Rset \\times \\Rset & \\rightarrow & \\Rset \\\\
                    (t, x) & \\mapsto & (x + t^2)
                \\end{array}\\right.

    >>> h = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])

    Convert :math:`h` into a temporal function with :math:`n` the dimension of the
    mesh of the field on which :math:`h` will be applied:

    >>> n = 1
    >>> myVertexValueFunction = ot.VertexValueFunction(h, n)
    >>> # Create a TimeSeries
    >>> tg = ot.RegularGrid(0.0, 0.2, 6)
    >>> data = ot.Sample(tg.getN(), h.getInputDimension()-1)
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(tg, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(myVertexValueFunction(ts))
        [ t    y0   ]
    0 : [ 0    0    ]
    1 : [ 0.2  1.04 ]
    2 : [ 0.4  2.16 ]
    3 : [ 0.6  3.36 ]
    4 : [ 0.8  4.64 ]
    5 : [ 1    6    ]
    """

    __swig_setmethods__ = {}
    for _s in [FieldFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VertexValueFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, VertexValueFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.VertexValueFunction_getClassName(self)


    def __eq__(self, other):
        return _func.VertexValueFunction___eq__(self, other)

    def __repr__(self):
        return _func.VertexValueFunction___repr__(self)

    def __str__(self, *args):
        return _func.VertexValueFunction___str__(self, *args)

    def __call__(self, *args):
        return _func.VertexValueFunction___call__(self, *args)

    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            FieldFunction.

        Returns
        -------
        fieldFunction : :class:`~openturns.FieldFunction`
            FieldFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the field function :math:`f_{dyn}`.
        """
        return _func.VertexValueFunction_getMarginal(self, *args)


    def getEvaluation(self):
        """
        Get the evaluation function of :math:`h`.

        Returns
        -------
        h : :class:`~openturns.EvaluationImplementation`
            Evaluation function of
            :math:`h: \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q`.

        Examples
        --------
        >>> import openturns as ot
        >>> h = ot.SymbolicFunction(['t', 'x'], ['x + t^2'])
        >>> n = 1
        >>> myVertexValueFunction = ot.ValueFunction(h, n)
        >>> print(myVertexValueFunction.getEvaluation())
        [t,x]->[x + t^2]
        """
        return _func.VertexValueFunction_getEvaluation(self)


    def __init__(self, *args):
        this = _func.new_VertexValueFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_VertexValueFunction
    __del__ = lambda self: None
VertexValueFunction_swigregister = _func.VertexValueFunction_swigregister
VertexValueFunction_swigregister(VertexValueFunction)


# deprecated
class TemporalFunction(VertexValueFunction):
    def __init__(self, *args):
        super(TemporalFunction, self).__init__(*args)
        openturns.common.Log.Warn('class TemporalFunction is deprecated in favor of VertexValueFunction')

class DualLinearCombinationEvaluation(EvaluationImplementation):
    """
    Dual linear combination evaluation implementation.

    Available constructors:

        DualLinearCombinationEvaluation(*scalarFctColl, vectCoefColl*)

    Parameters
    ----------
    scalarFctColl : sequence of :class:`~openturns.Function`
        A collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`,
        such that :math:`\\forall i \\in \\{1, \\ldots, l\\}`, 
        :math:`f_i : \\Rset^n \\rightarrow \\Rset`.
    vectCoefColl : 2-d sequence of float
        Sample :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}` of size :math:`l` and dimension :math:`p`.

    See also
    --------
    Function, AggregatedEvaluation, DatabaseEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` which is the function
    :math:`f: \\Rset^n \\rightarrow \\Rset^p` defined as the linear combination of the functions :math:`f_i` with vector coefficients in :math:`\\cC`:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\left\\{ \\sum_{i=1}^l f_i( \\vect{x} ) c_i^{(j)} \\right\\}_{j = 1, \\ldots, p}

    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationEvaluation_getClassName(self)


    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.DualLinearCombinationEvaluation_setDescription(self, description)


    def __repr__(self):
        return _func.DualLinearCombinationEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.DualLinearCombinationEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.DualLinearCombinationEvaluation___call__(self, *args)

    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coef : :class:`~openturns.Sample`
            The vectorial coefficients :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}`
            which define the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluation_getCoefficients(self)


    def getFunctionsCollection(self):
        """
        Accessor to the collection of functions.

        Returns
        -------
        fctColl : :class:`~openturns.FunctionCollection`
            The collection of scalar functions :math:`(f_i)_{i = 1, \\ldots, l}` which
            defines the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluation_getFunctionsCollection(self)


    def setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients):
        """
        Accessor to the coefficients and the collection of functions.

        Parameters
        ----------
        scalarFctColl : sequence of :class:`~openturns.Function`
            The collection of functions :math:`(f_i)_{i = 1, \\ldots, l}`.
        vectCoefColl : 2-d sequence of float
            The sample of coefficients :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}`.
        """
        return _func.DualLinearCombinationEvaluation_setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DualLinearCombinationEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DualLinearCombinationEvaluation_getOutputDimension(self)


    def parameterGradient(self, inP):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.DualLinearCombinationEvaluation_parameterGradient(self, inP)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluation_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluation_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.DualLinearCombinationEvaluation_getParameterDescription(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.DualLinearCombinationEvaluation_getMarginal(self, *args)


    def __init__(self, *args):
        this = _func.new_DualLinearCombinationEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationEvaluation
    __del__ = lambda self: None
DualLinearCombinationEvaluation_swigregister = _func.DualLinearCombinationEvaluation_swigregister
DualLinearCombinationEvaluation_swigregister(DualLinearCombinationEvaluation)

class DualLinearCombinationGradient(GradientImplementation):
    """
    Dual linear combination gradient implementation.

    Available constructors:

        DualLinearCombinationGradient(*myDLCEI*)

    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluation,
    DualLinearCombinationHessian

    Notes
    -----
    It returns the implementation of the gradient. By default, the analytical
    gradient is implemented.
    """

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationGradient_getClassName(self)


    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationGradient_getOutputDimension(self)


    def __repr__(self):
        return _func.DualLinearCombinationGradient___repr__(self)

    def __init__(self, *args):
        this = _func.new_DualLinearCombinationGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationGradient
    __del__ = lambda self: None
DualLinearCombinationGradient_swigregister = _func.DualLinearCombinationGradient_swigregister
DualLinearCombinationGradient_swigregister(DualLinearCombinationGradient)

class DualLinearCombinationHessian(HessianImplementation):
    """
    Dual linear combination hessian implementation.

    Available constructors:

        DualLinearCombinationHessian(*myDLCEI*)

    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluation,
    DualLinearCombinationGradient

    Notes
    -----
    It returns the implementation of the hessian. By default, the analytical
    hessian is implemented.
    """

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationHessian_getClassName(self)


    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationHessian_getOutputDimension(self)


    def __repr__(self):
        return _func.DualLinearCombinationHessian___repr__(self)

    def __init__(self, *args):
        this = _func.new_DualLinearCombinationHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationHessian
    __del__ = lambda self: None
DualLinearCombinationHessian_swigregister = _func.DualLinearCombinationHessian_swigregister
DualLinearCombinationHessian_swigregister(DualLinearCombinationHessian)

class LinearCombinationEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::LinearCombinationEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationEvaluation_getClassName(self)


    def __repr__(self):
        return _func.LinearCombinationEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.LinearCombinationEvaluation___call__(self, *args)

    def getCoefficients(self):
        return _func.LinearCombinationEvaluation_getCoefficients(self)

    def getFunctionsCollection(self):
        return _func.LinearCombinationEvaluation_getFunctionsCollection(self)

    def setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients):
        return _func.LinearCombinationEvaluation_setFunctionsCollectionAndCoefficients(self, functionsCollection, coefficients)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearCombinationEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearCombinationEvaluation_getOutputDimension(self)


    def parameterGradient(self, inP):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.LinearCombinationEvaluation_parameterGradient(self, inP)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.LinearCombinationEvaluation_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.LinearCombinationEvaluation_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.LinearCombinationEvaluation_getParameterDescription(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.LinearCombinationEvaluation_getMarginal(self, *args)


    def __init__(self, *args):
        this = _func.new_LinearCombinationEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationEvaluation
    __del__ = lambda self: None
LinearCombinationEvaluation_swigregister = _func.LinearCombinationEvaluation_swigregister
LinearCombinationEvaluation_swigregister(LinearCombinationEvaluation)

class LinearCombinationGradient(GradientImplementation):
    """Proxy of C++ OT::LinearCombinationGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationGradient_getClassName(self)


    def gradient(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationGradient_gradient(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationGradient_getOutputDimension(self)


    def __repr__(self):
        return _func.LinearCombinationGradient___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationGradient___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_LinearCombinationGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationGradient
    __del__ = lambda self: None
LinearCombinationGradient_swigregister = _func.LinearCombinationGradient_swigregister
LinearCombinationGradient_swigregister(LinearCombinationGradient)

class LinearCombinationHessian(HessianImplementation):
    """Proxy of C++ OT::LinearCombinationHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationHessian_getClassName(self)


    def hessian(self, inP):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationHessian_hessian(self, inP)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationHessian_getOutputDimension(self)


    def __repr__(self):
        return _func.LinearCombinationHessian___repr__(self)

    def __str__(self, *args):
        return _func.LinearCombinationHessian___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_LinearCombinationHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationHessian
    __del__ = lambda self: None
LinearCombinationHessian_swigregister = _func.LinearCombinationHessian_swigregister
LinearCombinationHessian_swigregister(LinearCombinationHessian)

class LinearFunction(Function):
    """
    Linear numerical math function.

    Available constructors:
       LinearFunction(*center, constant, linear*)

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\\vect{b}`.
    constant : sequence of float
        Vector :math:`\\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\\mat{A}`.

    See also
    --------
    Function

    Notes
    -----
    This implements a linear :class:`~openturns.Function` :math:`f` 
    defined as :

    .. math::

        f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
            & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

    where:

    - :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
      input *linear*,
    - :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*,

    - :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*.
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearFunction_getClassName(self)


    def __eq__(self, other):
        return _func.LinearFunction___eq__(self, other)

    def __repr__(self):
        return _func.LinearFunction___repr__(self)

    def __str__(self, *args):
        return _func.LinearFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_LinearFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearFunction
    __del__ = lambda self: None
LinearFunction_swigregister = _func.LinearFunction_swigregister
LinearFunction_swigregister(LinearFunction)


# deprecated
class LinearNumericalMathFunction(LinearFunction):
    def __init__(self, *args):
        super(LinearNumericalMathFunction, self).__init__(*args)
        openturns.common.Log.Warn('class LinearNumericalMathFunction is deprecated in favor of LinearFunction')

class QuadraticFunction(Function):
    """
    Quadratic function.

    Available constructors:
       QuadraticFunction(*center, constant, linear, quadratic*)

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\\vect{b}`.
    constant : sequence of float
        Vector :math:`\\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\\mat{A}`.
    quadratic : :class:`~openturns.SymmetricTensor`
        Tensor :math:`\\underline{\\underline{\\underline{M}}}`.

    Notes
    -----
    This implements a quadratic function :math:`f` defined as:

    .. math::

        f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
            & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c} + \\frac{1}{2} \\vect{X}^T \\times \\underline{\\underline{\\underline{M}}} \\times \\vect{X}

    where:

    - :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by *linear*,

    - :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by *center*,

    - :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by *constant*.

    - :math:`\\underline{\\underline{\\underline{M}}}` is a :math:`\\Rset^p \\times \\Rset^n \\times \\Rset^n` symmetric tensor defined by *quadratic*.

    Examples
    --------
    >>> import openturns as ot
    >>> inputDimension = 3
    >>> outputDimension = 2
    >>> center = [1.0] * inputDimension
    >>> constant = [-1.0, 2.0]
    >>> linear = ot.Matrix(inputDimension, outputDimension)
    >>> quadratic = ot.SymmetricTensor(inputDimension, outputDimension)
    >>> function = ot.QuadraticFunction(center, constant, linear, quadratic)
    >>> inP = [7.0, 8.0, 9.0]
    >>> print(function(inP))
    [-1,2]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticFunction_getClassName(self)


    def __eq__(self, other):
        return _func.QuadraticFunction___eq__(self, other)

    def __repr__(self):
        return _func.QuadraticFunction___repr__(self)

    def __str__(self, *args):
        return _func.QuadraticFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_QuadraticFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_QuadraticFunction
    __del__ = lambda self: None
QuadraticFunction_swigregister = _func.QuadraticFunction_swigregister
QuadraticFunction_swigregister(QuadraticFunction)


# deprecated
class QuadraticNumericalMathFunction(QuadraticFunction):
    def __init__(self, *args):
        super(QuadraticNumericalMathFunction, self).__init__(*args)
        openturns.common.Log.Warn('class QuadraticNumericalMathFunction is deprecated in favor of QuadraticFunction')

class UniVariateFunctionImplementation(openturns.common.PersistentObject):
    """Base class for univariate functions."""

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionImplementation_getClassName(self)


    def __repr__(self):
        return _func.UniVariateFunctionImplementation___repr__(self)

    def __str__(self, *args):
        return _func.UniVariateFunctionImplementation___str__(self, *args)

    def __call__(self, x):
        return _func.UniVariateFunctionImplementation___call__(self, x)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunctionImplementation_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunctionImplementation_hessian(self, x)


    def draw(self, xMin, xMax, pointNumber):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunctionImplementation_draw(self, xMin, xMax, pointNumber)


    def __init__(self, *args):
        this = _func.new_UniVariateFunctionImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunctionImplementation
    __del__ = lambda self: None
UniVariateFunctionImplementation_swigregister = _func.UniVariateFunctionImplementation_swigregister
UniVariateFunctionImplementation_swigregister(UniVariateFunctionImplementation)

class UniVariateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_UniVariateFunctionImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.UniVariateFunctionImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_UniVariateFunctionImplementationTypedInterfaceObject
    __del__ = lambda self: None
UniVariateFunctionImplementationTypedInterfaceObject_swigregister = _func.UniVariateFunctionImplementationTypedInterfaceObject_swigregister
UniVariateFunctionImplementationTypedInterfaceObject_swigregister(UniVariateFunctionImplementationTypedInterfaceObject)

class UniVariateFunction(UniVariateFunctionImplementationTypedInterfaceObject):
    """Base class for univariate functions."""

    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunction_getClassName(self)


    def __repr__(self):
        return _func.UniVariateFunction___repr__(self)

    def __str__(self, *args):
        return _func.UniVariateFunction___str__(self, *args)

    def __call__(self, x):
        return _func.UniVariateFunction___call__(self, x)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunction_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunction_hessian(self, x)


    def draw(self, xMin, xMax, pointNumber):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunction_draw(self, xMin, xMax, pointNumber)


    def __init__(self, *args):
        this = _func.new_UniVariateFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunction
    __del__ = lambda self: None
UniVariateFunction_swigregister = _func.UniVariateFunction_swigregister
UniVariateFunction_swigregister(UniVariateFunction)

class MonomialFunction(UniVariateFunctionImplementation):
    """
    Monomial function class.

    Available constructors:
        MonomialFunction(*degree*)

    Parameters
    ----------
    degre : int
        Degree of the monomial function

    Notes
    -----
    The *monomial function* defines as :

    .. math::

        P(x)  = X^n


    Examples
    --------
    Create a standard absolute exponential covariance function:

    >>> import openturns as ot
    >>> P = ot.MonomialFunction(3)


    """

    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonomialFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonomialFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MonomialFunction_getClassName(self)


    def __repr__(self):
        return _func.MonomialFunction___repr__(self)

    def __str__(self, *args):
        return _func.MonomialFunction___str__(self, *args)

    def __call__(self, x):
        return _func.MonomialFunction___call__(self, x)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the monomial's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.MonomialFunction(3)
        >>> print(P.gradient(1.0))
        3.0
        """
        return _func.MonomialFunction_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the monomial's second-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.MonomialFunction(3)
        >>> print(P.hessian(1.0))
        6.0
        """
        return _func.MonomialFunction_hessian(self, x)


    def __init__(self, *args):
        this = _func.new_MonomialFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_MonomialFunction
    __del__ = lambda self: None
MonomialFunction_swigregister = _func.MonomialFunction_swigregister
MonomialFunction_swigregister(MonomialFunction)

class UniVariatePolynomialImplementation(UniVariateFunctionImplementation):
    """
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print('(%s) + (%s) = %s' % (P, Q, P + Q))
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print('(%s) - (%s) = %s' % (P, Q, P - Q))
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print('(%s) * (%s) = %s' % (P, Q, P * Q))
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """

    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomialImplementation_getClassName(self)


    def __repr__(self):
        return _func.UniVariatePolynomialImplementation___repr__(self)

    def __str__(self, *args):
        return _func.UniVariatePolynomialImplementation___str__(self, *args)

    def __call__(self, *args):
        return _func.UniVariatePolynomialImplementation___call__(self, *args)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomialImplementation_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomialImplementation_hessian(self, x)


    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomialImplementation_derivate(self)


    def __mul__(self, *args):
        return _func.UniVariatePolynomialImplementation___mul__(self, *args)

    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomialImplementation_incrementDegree(self, degree)


    def __add__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementation___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementation___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomialImplementation_setCoefficients(self, coefficients)


    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomialImplementation_getCoefficients(self)


    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomialImplementation_getDegree(self)


    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomialImplementation_getRoots(self)


    def __init__(self, *args):
        this = _func.new_UniVariatePolynomialImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementation
    __del__ = lambda self: None
UniVariatePolynomialImplementation_swigregister = _func.UniVariatePolynomialImplementation_swigregister
UniVariatePolynomialImplementation_swigregister(UniVariatePolynomialImplementation)

class UniVariatePolynomialImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_UniVariatePolynomialImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementationTypedInterfaceObject
    __del__ = lambda self: None
UniVariatePolynomialImplementationTypedInterfaceObject_swigregister = _func.UniVariatePolynomialImplementationTypedInterfaceObject_swigregister
UniVariatePolynomialImplementationTypedInterfaceObject_swigregister(UniVariatePolynomialImplementationTypedInterfaceObject)

class UniVariatePolynomial(UniVariatePolynomialImplementationTypedInterfaceObject):
    """
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print('(%s) + (%s) = %s' % (P, Q, P + Q))
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print('(%s) - (%s) = %s' % (P, Q, P - Q))
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print('(%s) * (%s) = %s' % (P, Q, P * Q))
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """

    __swig_setmethods__ = {}
    for _s in [UniVariatePolynomialImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomial, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariatePolynomialImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomial, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomial_getClassName(self)


    def __repr__(self):
        return _func.UniVariatePolynomial___repr__(self)

    def __str__(self, *args):
        return _func.UniVariatePolynomial___str__(self, *args)

    def __call__(self, *args):
        return _func.UniVariatePolynomial___call__(self, *args)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomial_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomial_hessian(self, x)


    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomial_derivate(self)


    def __mul__(self, *args):
        return _func.UniVariatePolynomial___mul__(self, *args)

    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomial_incrementDegree(self, degree)


    def __add__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomial___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomial___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomial_setCoefficients(self, coefficients)


    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomial_getCoefficients(self)


    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomial_getDegree(self)


    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomial_getRoots(self)


    def draw(self, xMin, xMax, pointNumber):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariatePolynomial_draw(self, xMin, xMax, pointNumber)


    def __init__(self, *args):
        this = _func.new_UniVariatePolynomial(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomial
    __del__ = lambda self: None
UniVariatePolynomial_swigregister = _func.UniVariatePolynomial_swigregister
UniVariatePolynomial_swigregister(UniVariatePolynomial)

class AggregatedEvaluation(EvaluationImplementation):
    """
    Aggregated numerical math evaluation implementation.

    Available constructors:
        AggregatedEvaluation(*functionsCollection*)

    Parameters
    ----------
    functionsCollection : sequence of :class:`~openturns.Function`
        A collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`,
        such that :math:`\\forall i \\in \\{1, \\ldots, l\\}`, 
        :math:`f_i : \\Rset^n \\rightarrow \\Rset^{p_i}`.

    See also
    --------
    Function, DatabaseEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It implements a :class:`~openturns.Function`
    :math:`f : \\Rset^n \\rightarrow \\Rset^{p_1 + \\ldots + p_l}` defined by:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\Tr{(f_1(\\vect{x}), \\ldots, f_l(\\vect{x}))}

    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AggregatedEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AggregatedEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AggregatedEvaluation_getClassName(self)


    def __repr__(self):
        return _func.AggregatedEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.AggregatedEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.AggregatedEvaluation___call__(self, *args)

    def getFunctionsCollection(self):
        """
        Accessor to the collection of functions.

        Returns
        -------
        functionCol : :class:`~openturns.FunctionCollection`
            The collection of functions defining :math:`f`.
        """
        return _func.AggregatedEvaluation_getFunctionsCollection(self)


    def setFunctionsCollection(self, functionsCollection):
        """
        Accessor to the collection of functions.

        Parameters
        ----------
        functionsCollection : sequence of :class:`~openturns.Function`
            The collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`.
        """
        return _func.AggregatedEvaluation_setFunctionsCollection(self, functionsCollection)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.AggregatedEvaluation_getMarginal(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.AggregatedEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.AggregatedEvaluation_getOutputDimension(self)


    def parameterGradient(self, inP):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.AggregatedEvaluation_parameterGradient(self, inP)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.AggregatedEvaluation_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.AggregatedEvaluation_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.AggregatedEvaluation_getParameterDescription(self)


    def __init__(self, *args):
        this = _func.new_AggregatedEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_AggregatedEvaluation
    __del__ = lambda self: None
AggregatedEvaluation_swigregister = _func.AggregatedEvaluation_swigregister
AggregatedEvaluation_swigregister(AggregatedEvaluation)

class PiecewiseLinearEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::PiecewiseLinearEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PiecewiseLinearEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PiecewiseLinearEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseLinearEvaluation_getClassName(self)


    def __repr__(self):
        return _func.PiecewiseLinearEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.PiecewiseLinearEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.PiecewiseLinearEvaluation___call__(self, *args)

    def getLocations(self):
        return _func.PiecewiseLinearEvaluation_getLocations(self)

    def setLocations(self, locations):
        return _func.PiecewiseLinearEvaluation_setLocations(self, locations)

    def getValues(self):
        return _func.PiecewiseLinearEvaluation_getValues(self)

    def setValues(self, *args):
        return _func.PiecewiseLinearEvaluation_setValues(self, *args)

    def setLocationsAndValues(self, locations, values):
        return _func.PiecewiseLinearEvaluation_setLocationsAndValues(self, locations, values)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseLinearEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseLinearEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_PiecewiseLinearEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_PiecewiseLinearEvaluation
    __del__ = lambda self: None
PiecewiseLinearEvaluation_swigregister = _func.PiecewiseLinearEvaluation_swigregister
PiecewiseLinearEvaluation_swigregister(PiecewiseLinearEvaluation)

class PiecewiseHermiteEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::PiecewiseHermiteEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PiecewiseHermiteEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PiecewiseHermiteEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseHermiteEvaluation_getClassName(self)


    def __repr__(self):
        return _func.PiecewiseHermiteEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.PiecewiseHermiteEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.PiecewiseHermiteEvaluation___call__(self, *args)

    def derivate(self, inP):
        return _func.PiecewiseHermiteEvaluation_derivate(self, inP)

    def getLocations(self):
        return _func.PiecewiseHermiteEvaluation_getLocations(self)

    def setLocations(self, locations):
        return _func.PiecewiseHermiteEvaluation_setLocations(self, locations)

    def getValues(self):
        return _func.PiecewiseHermiteEvaluation_getValues(self)

    def setValues(self, values):
        return _func.PiecewiseHermiteEvaluation_setValues(self, values)

    def getDerivatives(self):
        return _func.PiecewiseHermiteEvaluation_getDerivatives(self)

    def setDerivatives(self, derivatives):
        return _func.PiecewiseHermiteEvaluation_setDerivatives(self, derivatives)

    def setLocationsValuesAndDerivatives(self, locations, values, derivatives):
        return _func.PiecewiseHermiteEvaluation_setLocationsValuesAndDerivatives(self, locations, values, derivatives)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseHermiteEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseHermiteEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_PiecewiseHermiteEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_PiecewiseHermiteEvaluation
    __del__ = lambda self: None
PiecewiseHermiteEvaluation_swigregister = _func.PiecewiseHermiteEvaluation_swigregister
PiecewiseHermiteEvaluation_swigregister(PiecewiseHermiteEvaluation)

class SymbolicEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::SymbolicEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymbolicEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymbolicEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.SymbolicEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.SymbolicEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.SymbolicEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.SymbolicEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.SymbolicEvaluation_getOutputDimension(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.SymbolicEvaluation_getMarginal(self, *args)


    def getInputVariablesNames(self):
        return _func.SymbolicEvaluation_getInputVariablesNames(self)

    def getOutputVariablesNames(self):
        return _func.SymbolicEvaluation_getOutputVariablesNames(self)

    def getFormulas(self):
        return _func.SymbolicEvaluation_getFormulas(self)

    def __init__(self, *args):
        this = _func.new_SymbolicEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_SymbolicEvaluation
    __del__ = lambda self: None
SymbolicEvaluation_swigregister = _func.SymbolicEvaluation_swigregister
SymbolicEvaluation_swigregister(SymbolicEvaluation)

class SymbolicGradient(GradientImplementation):
    """Proxy of C++ OT::SymbolicGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymbolicGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymbolicGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicGradient_getClassName(self)


    def __eq__(self, other):
        return _func.SymbolicGradient___eq__(self, other)

    def __repr__(self):
        return _func.SymbolicGradient___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicGradient___str__(self, *args)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.SymbolicGradient_gradient(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.SymbolicGradient_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.SymbolicGradient_getOutputDimension(self)


    def getFormula(self, i, j):
        return _func.SymbolicGradient_getFormula(self, i, j)

    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.SymbolicGradient_getMarginal(self, *args)


    def __init__(self, *args):
        this = _func.new_SymbolicGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_SymbolicGradient
    __del__ = lambda self: None
SymbolicGradient_swigregister = _func.SymbolicGradient_swigregister
SymbolicGradient_swigregister(SymbolicGradient)

class SymbolicHessian(HessianImplementation):
    """Proxy of C++ OT::SymbolicHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymbolicHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymbolicHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SymbolicHessian_getClassName(self)


    def __eq__(self, other):
        return _func.SymbolicHessian___eq__(self, other)

    def __repr__(self):
        return _func.SymbolicHessian___repr__(self)

    def __str__(self, *args):
        return _func.SymbolicHessian___str__(self, *args)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.SymbolicHessian_hessian(self, *args)


    def getFormula(self, i, j, k):
        return _func.SymbolicHessian_getFormula(self, i, j, k)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.SymbolicHessian_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.SymbolicHessian_getOutputDimension(self)


    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.SymbolicHessian_getMarginal(self, *args)


    def __init__(self, *args):
        this = _func.new_SymbolicHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_SymbolicHessian
    __del__ = lambda self: None
SymbolicHessian_swigregister = _func.SymbolicHessian_swigregister
SymbolicHessian_swigregister(SymbolicHessian)

class DatabaseFunction(Function):
    """
    Pre-evaluated function.

    Available constructor:
        DatabaseFunction(*inputSample, outputSample*)

        DatabaseFunction(*inputSample, outputSample, enableCache*)

    Allows to build a function takes a value in the output sample when presented
    the corresponding point in the input sample .

    Parameters
    ----------
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.
    enableCache : bool, optional
        Whether to enable the cache, defaults to True
        It can take a significant amount of time for large samples.

    Examples
    --------
    >>> import openturns as ot
    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.DatabaseFunction(inputSample, outputSample)
    >>> x = [1.8] * database.getInputDimension()
    >>> print(database(x))
    [5]
    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseFunction, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DatabaseFunction_getClassName(self)


    def __eq__(self, other):
        return _func.DatabaseFunction___eq__(self, other)

    def __repr__(self):
        return _func.DatabaseFunction___repr__(self)

    def __str__(self, *args):
        return _func.DatabaseFunction___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_DatabaseFunction(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DatabaseFunction
    __del__ = lambda self: None
DatabaseFunction_swigregister = _func.DatabaseFunction_swigregister
DatabaseFunction_swigregister(DatabaseFunction)

class DatabaseEvaluation(EvaluationImplementation):
    """
    Data based math evaluation implementation.

    Available constructors:

        DatabaseEvaluation(*inputSample, outputSample*)

        DatabaseEvaluation(*inputSample, outputSample, activateCache*)

    Parameters
    ----------
    inputSample : 2-d sequence of float
        Sample :math:`\\cS^{in}` of size :math:`l` and dimension :math:`n`.
    outputSample : 2-d sequence of float
        Sample :math:`\\cS^{out}` of size :math:`l` and dimension :math:`p`.
    activateCache : bool
        Flag to enable cache or not.

    See also
    --------
    Function, AggregatedEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` that implements a 
    nearest-neighbor function :math:`f : \\Rset^n \\rightarrow \\Rset^p` based on the 
    input sample :math:`S^{in}` and taking values in the outputSample :math:`S^{out}`:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = y_{i*}

    where:

    .. math::
        i^* = \\underset{ \\vect{x}_i \\in S^{in} }{ \\argmin_{i \\in \\{1, \\ldots, l\\}} } \\|\\vect{x} - \\vect{x}_i \\|

    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DatabaseEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.DatabaseEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.DatabaseEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.DatabaseEvaluation___str__(self, *args)

    def setInputSample(self, inputSample):
        """
        Accessor to the input sample defining the functions.

        Parameters
        ----------
        inputSample : :class:`~openturns.Sample`
            The input sample defining the function.
        """
        return _func.DatabaseEvaluation_setInputSample(self, inputSample)


    def getInputSample(self):
        """
        Accessor to the input sample defining the functions.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample defining the function.
        """
        return _func.DatabaseEvaluation_getInputSample(self)


    def setOutputSample(self, outputSample):
        """
        Accessor to the output sample defining the functions.

        Parameters
        ----------
        outputSample : :class:`~openturns.Sample`
            The output sample defining the function.
        """
        return _func.DatabaseEvaluation_setOutputSample(self, outputSample)


    def getOutputSample(self):
        """
        Accessor to the output sample defining the functions.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample defining the function.
        """
        return _func.DatabaseEvaluation_getOutputSample(self)


    def __call__(self, *args):
        return _func.DatabaseEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DatabaseEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DatabaseEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_DatabaseEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_DatabaseEvaluation
    __del__ = lambda self: None
DatabaseEvaluation_swigregister = _func.DatabaseEvaluation_swigregister
DatabaseEvaluation_swigregister(DatabaseEvaluation)

class IndicatorEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::IndicatorEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndicatorEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndicatorEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IndicatorEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.IndicatorEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.IndicatorEvaluation___repr__(self)

    def __call__(self, *args):
        return _func.IndicatorEvaluation___call__(self, *args)

    def getEvaluation(self):
        return _func.IndicatorEvaluation_getEvaluation(self)

    def setEvaluation(self, p_evaluation):
        return _func.IndicatorEvaluation_setEvaluation(self, p_evaluation)

    def getComparisonOperator(self):
        return _func.IndicatorEvaluation_getComparisonOperator(self)

    def setComparisonOperator(self, comparisonOperator):
        return _func.IndicatorEvaluation_setComparisonOperator(self, comparisonOperator)

    def getThreshold(self):
        return _func.IndicatorEvaluation_getThreshold(self)

    def setThreshold(self, threshold):
        return _func.IndicatorEvaluation_setThreshold(self, threshold)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.IndicatorEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.IndicatorEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_IndicatorEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_IndicatorEvaluation
    __del__ = lambda self: None
IndicatorEvaluation_swigregister = _func.IndicatorEvaluation_swigregister
IndicatorEvaluation_swigregister(IndicatorEvaluation)

class PolynomialCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolynomialCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PolynomialCollection, name)
    __swig_destroy__ = _func.delete_PolynomialCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.PolynomialCollection_clear(self)


    def __len__(self):
        return _func.PolynomialCollection___len__(self)

    def __eq__(self, rhs):
        return _func.PolynomialCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.PolynomialCollection___contains__(self, val)

    def __getitem__(self, i):
        return _func.PolynomialCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.PolynomialCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.PolynomialCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.PolynomialCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.PolynomialCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.PolynomialCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.PolynomialCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.PolynomialCollection_isEmpty(self)


    def __repr__(self):
        return _func.PolynomialCollection___repr__(self)

    def __str__(self, *args):
        return _func.PolynomialCollection___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_PolynomialCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
PolynomialCollection_swigregister = _func.PolynomialCollection_swigregister
PolynomialCollection_swigregister(PolynomialCollection)

class PolynomialPersistentCollection(openturns.common.PersistentObject, PolynomialCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, PolynomialCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolynomialPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, PolynomialCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PolynomialPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PolynomialPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _func.new_PolynomialPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _func.PolynomialPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func.PolynomialPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete_PolynomialPersistentCollection
    __del__ = lambda self: None
PolynomialPersistentCollection_swigregister = _func.PolynomialPersistentCollection_swigregister
PolynomialPersistentCollection_swigregister(PolynomialPersistentCollection)

class ProductPolynomialEvaluation(EvaluationImplementation):
    """
    Product polynomial evaluation implementation.

    Available constructors:
        ProductPolynomialEvaluation(*polCollection*)

    Parameters
    ----------
    distCol : :class:`~openturns.PolynomialCollection`
        A collection of :class:`~openturns.UniVariatePolynomial`.

    Notes
    -----
    It returns the product of the polynomials of *polCollection*. The input
    dimension *n* is equal to the number of polynomials in *polCollection*.

    Examples
    --------
    >>> import openturns as ot
    >>> P1 = ot.UniVariatePolynomial([1.0, 2.0, 3.0, 0])
    >>> P2 = ot.UniVariatePolynomial([3.0, 2.0, 4.0, 5.0])
    >>> P3 = ot.UniVariatePolynomial([-1.0, 0.0, 4, 0.0])
    >>> polyCol = ot.PolynomialCollection(1, P1)
    >>> polyCol.add(P2)
    >>> polyCol.add(P3)
    >>> productPoly = ot.ProductPolynomialEvaluation(polyCol)
    >>> productPoly([2, 1, 3])
    class=Point name=Unnamed dimension=1 values=[8330]

    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductPolynomialEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductPolynomialEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductPolynomialEvaluation_getClassName(self)


    def __repr__(self):
        return _func.ProductPolynomialEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ProductPolynomialEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.ProductPolynomialEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductPolynomialEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductPolynomialEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_ProductPolynomialEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ProductPolynomialEvaluation
    __del__ = lambda self: None
ProductPolynomialEvaluation_swigregister = _func.ProductPolynomialEvaluation_swigregister
ProductPolynomialEvaluation_swigregister(ProductPolynomialEvaluation)

class ParametricEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::ParametricEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricEvaluation_getClassName(self)


    def __call__(self, *args):
        return _func.ParametricEvaluation___call__(self, *args)

    def getParametersPositions(self):
        return _func.ParametricEvaluation_getParametersPositions(self)

    def getInputPositions(self):
        return _func.ParametricEvaluation_getInputPositions(self)

    def getFunction(self):
        return _func.ParametricEvaluation_getFunction(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ParametricEvaluation_getInputDimension(self)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.ParametricEvaluation_getParameterDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ParametricEvaluation_getOutputDimension(self)


    def setParameter(self, parameters):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ParametricEvaluation_setParameter(self, parameters)


    def __repr__(self):
        return _func.ParametricEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.ParametricEvaluation___str__(self, *args)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.ParametricEvaluation_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.ParametricEvaluation_getInputParameterHistory(self)


    def __init__(self, *args):
        this = _func.new_ParametricEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ParametricEvaluation
    __del__ = lambda self: None
ParametricEvaluation_swigregister = _func.ParametricEvaluation_swigregister
ParametricEvaluation_swigregister(ParametricEvaluation)

class ParametricGradient(GradientImplementation):
    """Proxy of C++ OT::ParametricGradient"""

    __swig_setmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricGradient, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricGradient_getClassName(self)


    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricGradient_gradient(self, *args)


    def getEvaluation(self):
        return _func.ParametricGradient_getEvaluation(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricGradient_getInputDimension(self)


    def getParameterDimension(self):
        return _func.ParametricGradient_getParameterDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricGradient_getOutputDimension(self)


    def __repr__(self):
        return _func.ParametricGradient___repr__(self)

    def __str__(self, *args):
        return _func.ParametricGradient___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_ParametricGradient(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ParametricGradient
    __del__ = lambda self: None
ParametricGradient_swigregister = _func.ParametricGradient_swigregister
ParametricGradient_swigregister(ParametricGradient)

class ParametricHessian(HessianImplementation):
    """Proxy of C++ OT::ParametricHessian"""

    __swig_setmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [HessianImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricHessian, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricHessian_getClassName(self)


    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricHessian_hessian(self, *args)


    def getEvaluation(self):
        return _func.ParametricHessian_getEvaluation(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricHessian_getInputDimension(self)


    def getParameterDimension(self):
        return _func.ParametricHessian_getParameterDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricHessian_getOutputDimension(self)


    def __repr__(self):
        return _func.ParametricHessian___repr__(self)

    def __str__(self, *args):
        return _func.ParametricHessian___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_ParametricHessian(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ParametricHessian
    __del__ = lambda self: None
ParametricHessian_swigregister = _func.ParametricHessian_swigregister
ParametricHessian_swigregister(ParametricHessian)

class P1LagrangeEvaluation(EvaluationImplementation):
    """
    Data based math evaluation implementation.

    Available constructors:

        P1LagrangeEvaluation(*field*)

    Parameters
    ----------
    field : :class:`~openturns.Field`
        Field :math:`\\cF` defining the parameters of a P1 Lagrange interpolation function.

    See also
    --------
    Function, AggregatedEvaluation, DualLinearCombinationEvaluation,
    LinearFunction

    Notes
    -----
    It returns a :class:`~openturns.Function` that implements the P1 Lagrange interpolation function :math:`f : \\cD_N \\rightarrow \\Rset^p` :

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\sum_{\\vect{\\xi}_i\\in\\cV(\\vect{x})}\\alpha_i f(\\vect{\\xi}_i)

    where :math:`\\cD_N` is a :class:`~openturns.Mesh`, :math:`\\cV(\\vect{x})` is the simplex in :math:`\\cD_N` that contains :math:`\\vect{x}`, :math:`\\alpha_i` are the barycentric coordinates of :math:`\\vect{x}` wrt the vertices :math:`\\vect{\\xi}_i` of :math:`\\cV(\\vect{x})`:

    .. math::
        \\vect{x}=\\sum_{\\vect{\\xi}_i\\in\\cV(\\vect{x})}\\alpha_i\\vect{\\xi}_i

    Examples
    --------
    Create a P1 Lagrange evaluation:

    >>> import openturns as ot
    >>> field = ot.Field(ot.RegularGrid(0.0, 1.0, 4), [[0.5], [1.5], [1.0], [-0.5]])
    >>> evaluation = ot.P1LagrangeEvaluation(field)
    >>> print(evaluation([2.3]))
    [0.55]
    """

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, P1LagrangeEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, P1LagrangeEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.P1LagrangeEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.P1LagrangeEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.P1LagrangeEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.P1LagrangeEvaluation___str__(self, *args)

    def setField(self, field):
        """
        Accessor to the field defining the functions.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluation_setField(self, field)


    def getField(self):
        """
        Accessor to the field defining the functions.

        Returns
        -------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluation_getField(self)


    def setMesh(self, mesh):
        return _func.P1LagrangeEvaluation_setMesh(self, mesh)

    def getMesh(self):
        return _func.P1LagrangeEvaluation_getMesh(self)

    def setVertices(self, vertices):
        return _func.P1LagrangeEvaluation_setVertices(self, vertices)

    def getVertices(self):
        return _func.P1LagrangeEvaluation_getVertices(self)

    def setSimplices(self, simplices):
        return _func.P1LagrangeEvaluation_setSimplices(self, simplices)

    def getSimplices(self):
        return _func.P1LagrangeEvaluation_getSimplices(self)

    def setValues(self, values):
        return _func.P1LagrangeEvaluation_setValues(self, values)

    def getValues(self):
        return _func.P1LagrangeEvaluation_getValues(self)

    def __call__(self, *args):
        return _func.P1LagrangeEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.P1LagrangeEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.P1LagrangeEvaluation_getOutputDimension(self)


    def __init__(self, *args):
        this = _func.new_P1LagrangeEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_P1LagrangeEvaluation
    __del__ = lambda self: None
P1LagrangeEvaluation_swigregister = _func.P1LagrangeEvaluation_swigregister
P1LagrangeEvaluation_swigregister(P1LagrangeEvaluation)

class BasisImplementation(openturns.common.PersistentObject):
    """
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.Function`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
    >>> basis = ot.Basis(functions)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisImplementation_getClassName(self)


    def build(self, index):
        """
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \\geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.BasisImplementation_build(self, index)


    def getSubBasis(self, indices):
        """
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.Function`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.BasisImplementation_getSubBasis(self, indices)


    def __repr__(self):
        return _func.BasisImplementation___repr__(self)

    def getDimension(self):
        """
        Get the dimension of the Basis.

        Returns
        -------
        dimension : int
            Dimension of the Basis.
        """
        return _func.BasisImplementation_getDimension(self)


    def getSize(self):
        """
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.BasisImplementation_getSize(self)


    def isOrthogonal(self):
        """
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.BasisImplementation_isOrthogonal(self)


    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.BasisImplementation_isFunctional(self)


    def add(self, elt):
        """
        Add an element in the Basis.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function added in the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(2):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> basis.add(ot.SymbolicFunction(input, [input[2]]))
        """
        return _func.BasisImplementation_add(self, elt)


    def __init__(self, *args):
        this = _func.new_BasisImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisImplementation
    __del__ = lambda self: None
BasisImplementation_swigregister = _func.BasisImplementation_swigregister
BasisImplementation_swigregister(BasisImplementation)

class BasisCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BasisCollection, name)
    __swig_destroy__ = _func.delete_BasisCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.BasisCollection_clear(self)


    def __len__(self):
        return _func.BasisCollection___len__(self)

    def __eq__(self, rhs):
        return _func.BasisCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.BasisCollection___contains__(self, val)

    def __getitem__(self, i):
        return _func.BasisCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.BasisCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.BasisCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.BasisCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.BasisCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.BasisCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.BasisCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.BasisCollection_isEmpty(self)


    def __repr__(self):
        return _func.BasisCollection___repr__(self)

    def __str__(self, *args):
        return _func.BasisCollection___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_BasisCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
BasisCollection_swigregister = _func.BasisCollection_swigregister
BasisCollection_swigregister(BasisCollection)

class BasisPersistentCollection(openturns.common.PersistentObject, BasisCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, BasisCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, BasisCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _func.new_BasisPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _func.BasisPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _func.BasisPersistentCollection___str__(self, *args)
    __swig_destroy__ = _func.delete_BasisPersistentCollection
    __del__ = lambda self: None
BasisPersistentCollection_swigregister = _func.BasisPersistentCollection_swigregister
BasisPersistentCollection_swigregister(BasisPersistentCollection)

class BasisImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_BasisImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.BasisImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_BasisImplementationTypedInterfaceObject
    __del__ = lambda self: None
BasisImplementationTypedInterfaceObject_swigregister = _func.BasisImplementationTypedInterfaceObject_swigregister
BasisImplementationTypedInterfaceObject_swigregister(BasisImplementationTypedInterfaceObject)

class Basis(BasisImplementationTypedInterfaceObject):
    """
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.Function`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
    >>> basis = ot.Basis(functions)
    """

    __swig_setmethods__ = {}
    for _s in [BasisImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Basis, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Basis, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Basis_getClassName(self)


    def build(self, index):
        """
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \\geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.Basis_build(self, index)


    def getSubBasis(self, indices):
        """
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.Function`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.Basis_getSubBasis(self, indices)


    def getDimension(self):
        """
        Get the dimension of the Basis.

        Returns
        -------
        dimension : int
            Dimension of the Basis.
        """
        return _func.Basis_getDimension(self)


    def getSize(self):
        """
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.Basis_getSize(self)


    def add(self, elt):
        """
        Add an element in the Basis.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function added in the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(2):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> basis.add(ot.SymbolicFunction(input, [input[2]]))
        """
        return _func.Basis_add(self, elt)


    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.Basis_isFunctional(self)


    def isOrthogonal(self):
        """
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.Basis_isOrthogonal(self)


    def __repr__(self):
        return _func.Basis___repr__(self)

    def __str__(self, *args):
        return _func.Basis___str__(self, *args)

    def __len__(self):
        return _func.Basis___len__(self)

    def __init__(self, *args):
        this = _func.new_Basis(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_Basis
    __del__ = lambda self: None
Basis_swigregister = _func.Basis_swigregister
Basis_swigregister(Basis)

class BasisSequenceImplementation(openturns.geom.IndicesPersistentCollection):
    """
    Sequence of basis.

    Available constructors:
        BasisSequence(*basis*)

        BasisSequence(*basisSeqImp*)

    Parameters
    ----------
    basis : a :class:`~openturns.Basis`
        A Basis.
    basisSeqImp : BasisSequenceImplementation
        A BasisSequenceImplementation.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.geom.IndicesPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.geom.IndicesPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceImplementation_getClassName(self)


    def __repr__(self):
        return _func.BasisSequenceImplementation___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequenceImplementation___str__(self, *args)

    def getDimension(self):
        return _func.BasisSequenceImplementation_getDimension(self)

    def getMasterBasis(self):
        return _func.BasisSequenceImplementation_getMasterBasis(self)

    def getBasis(self, index):
        return _func.BasisSequenceImplementation_getBasis(self, index)

    def getIndices(self, index):
        return _func.BasisSequenceImplementation_getIndices(self, index)

    def __init__(self, *args):
        this = _func.new_BasisSequenceImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceImplementation
    __del__ = lambda self: None
BasisSequenceImplementation_swigregister = _func.BasisSequenceImplementation_swigregister
BasisSequenceImplementation_swigregister(BasisSequenceImplementation)

class BasisSequenceImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_BasisSequenceImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.BasisSequenceImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_BasisSequenceImplementationTypedInterfaceObject
    __del__ = lambda self: None
BasisSequenceImplementationTypedInterfaceObject_swigregister = _func.BasisSequenceImplementationTypedInterfaceObject_swigregister
BasisSequenceImplementationTypedInterfaceObject_swigregister(BasisSequenceImplementationTypedInterfaceObject)

class BasisSequenceImplementationTypedCollectionInterfaceObject(BasisSequenceImplementationTypedInterfaceObject):
    __swig_setmethods__ = {}
    for _s in [BasisSequenceImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementationTypedCollectionInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementationTypedCollectionInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_BasisSequenceImplementationTypedCollectionInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, i):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject___setitem__(self, i, val)

    def add(self, elt):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_add(self, elt)

    def getSize(self):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_getSize(self)

    def getDimension(self):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_getDimension(self)

    def isEmpty(self):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_isEmpty(self)

    def erase(self, position):
        return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_erase(self, position)
    __swig_destroy__ = _func.delete_BasisSequenceImplementationTypedCollectionInterfaceObject
    __del__ = lambda self: None
BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister = _func.BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister
BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister(BasisSequenceImplementationTypedCollectionInterfaceObject)

class BasisSequence(BasisSequenceImplementationTypedCollectionInterfaceObject):
    """
    Sequence of basis.

    Available constructors:
        BasisSequence(*basis*)

        BasisSequence(*basisSeqImp*)

    Parameters
    ----------
    basis : a :class:`~openturns.Basis`
        A Basis.
    basisSeqImp : BasisSequenceImplementation
        A BasisSequenceImplementation.
    """

    __swig_setmethods__ = {}
    for _s in [BasisSequenceImplementationTypedCollectionInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceImplementationTypedCollectionInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequence, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequence_getClassName(self)


    def getDimension(self):
        return _func.BasisSequence_getDimension(self)

    def getMasterBasis(self):
        return _func.BasisSequence_getMasterBasis(self)

    def getBasis(self, index):
        return _func.BasisSequence_getBasis(self, index)

    def getIndices(self, index):
        return _func.BasisSequence_getIndices(self, index)

    def __repr__(self):
        return _func.BasisSequence___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequence___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_BasisSequence(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisSequence
    __del__ = lambda self: None
BasisSequence_swigregister = _func.BasisSequence_swigregister
BasisSequence_swigregister(BasisSequence)

class FunctionalBasisImplementation(BasisImplementation):
    __swig_setmethods__ = {}
    for _s in [BasisImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasisImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasisImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionalBasisImplementation_getClassName(self)


    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.FunctionalBasisImplementation_isFunctional(self)


    def __repr__(self):
        return _func.FunctionalBasisImplementation___repr__(self)

    def __init__(self, *args):
        this = _func.new_FunctionalBasisImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FunctionalBasisImplementation
    __del__ = lambda self: None
FunctionalBasisImplementation_swigregister = _func.FunctionalBasisImplementation_swigregister
FunctionalBasisImplementation_swigregister(FunctionalBasisImplementation)

class FunctionalBasisImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasisImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasisImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_FunctionalBasisImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.FunctionalBasisImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_FunctionalBasisImplementationTypedInterfaceObject
    __del__ = lambda self: None
FunctionalBasisImplementationTypedInterfaceObject_swigregister = _func.FunctionalBasisImplementationTypedInterfaceObject_swigregister
FunctionalBasisImplementationTypedInterfaceObject_swigregister(FunctionalBasisImplementationTypedInterfaceObject)

class FunctionalBasis(FunctionalBasisImplementationTypedInterfaceObject):
    """Proxy of C++ OT::FunctionalBasis"""

    __swig_setmethods__ = {}
    for _s in [FunctionalBasisImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasis, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionalBasisImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasis, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionalBasis_getClassName(self)


    def build(self, index):
        return _func.FunctionalBasis_build(self, index)

    def isOrthogonal(self):
        return _func.FunctionalBasis_isOrthogonal(self)

    def __repr__(self):
        return _func.FunctionalBasis___repr__(self)

    def __init__(self, *args):
        this = _func.new_FunctionalBasis(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FunctionalBasis
    __del__ = lambda self: None
FunctionalBasis_swigregister = _func.FunctionalBasis_swigregister
FunctionalBasis_swigregister(FunctionalBasis)

class BasisSequenceFactoryImplementation(openturns.common.PersistentObject):
    """
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LARS

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactoryImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactoryImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactoryImplementation_getClassName(self)


    def setVerbose(self, verbose):
        return _func.BasisSequenceFactoryImplementation_setVerbose(self, verbose)

    def getVerbose(self):
        return _func.BasisSequenceFactoryImplementation_getVerbose(self)

    def build(self, x, y, psi, indices):
        return _func.BasisSequenceFactoryImplementation_build(self, x, y, psi, indices)

    def setMaximumRelativeConvergence(self, coefficientsPaths):
        return _func.BasisSequenceFactoryImplementation_setMaximumRelativeConvergence(self, coefficientsPaths)

    def getMaximumRelativeConvergence(self):
        return _func.BasisSequenceFactoryImplementation_getMaximumRelativeConvergence(self)

    def __repr__(self):
        return _func.BasisSequenceFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequenceFactoryImplementation___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_BasisSequenceFactoryImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceFactoryImplementation
    __del__ = lambda self: None
BasisSequenceFactoryImplementation_swigregister = _func.BasisSequenceFactoryImplementation_swigregister
BasisSequenceFactoryImplementation_swigregister(BasisSequenceFactoryImplementation)

class BasisSequenceFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactoryImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactoryImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_BasisSequenceFactoryImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_BasisSequenceFactoryImplementationTypedInterfaceObject
    __del__ = lambda self: None
BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister = _func.BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister
BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister(BasisSequenceFactoryImplementationTypedInterfaceObject)

class BasisSequenceFactory(BasisSequenceFactoryImplementationTypedInterfaceObject):
    """
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LARS

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [BasisSequenceFactoryImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceFactoryImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactory_getClassName(self)


    def __repr__(self):
        return _func.BasisSequenceFactory___repr__(self)

    def __str__(self, *args):
        return _func.BasisSequenceFactory___str__(self, *args)

    def setVerbose(self, verbose):
        """
        Accessor to the verbosity.

        Parameters
        ----------
        v : bool
            Enable or disable the verbosity.
        """
        return _func.BasisSequenceFactory_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity.

        Returns
        -------
        v : bool.
            Verbosity
        """
        return _func.BasisSequenceFactory_getVerbose(self)


    def build(self, x, y, psi, indices):
        return _func.BasisSequenceFactory_build(self, x, y, psi, indices)

    def setMaximumRelativeConvergence(self, coefficientsPaths):
        """
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Parameters
        ----------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_setMaximumRelativeConvergence(self, coefficientsPaths)


    def getMaximumRelativeConvergence(self):
        """
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Returns
        -------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_getMaximumRelativeConvergence(self)


    def __init__(self, *args):
        this = _func.new_BasisSequenceFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceFactory
    __del__ = lambda self: None
BasisSequenceFactory_swigregister = _func.BasisSequenceFactory_swigregister
BasisSequenceFactory_swigregister(BasisSequenceFactory)

class UniVariateFunctionFactory(openturns.common.PersistentObject):
    """Base class for univariate function factories."""

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionFactory_getClassName(self)


    def __repr__(self):
        return _func.UniVariateFunctionFactory___repr__(self)

    def build(self, order):
        """
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.UniVariateFunctionFactory_build(self, order)


    def __init__(self, *args):
        this = _func.new_UniVariateFunctionFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunctionFactory
    __del__ = lambda self: None
UniVariateFunctionFactory_swigregister = _func.UniVariateFunctionFactory_swigregister
UniVariateFunctionFactory_swigregister(UniVariateFunctionFactory)

class MonomialFunctionFactory(UniVariateFunctionFactory):
    """Factory for univariate monomial functions."""

    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonomialFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonomialFunctionFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.MonomialFunctionFactory_getClassName(self)


    def __repr__(self):
        return _func.MonomialFunctionFactory___repr__(self)

    def buildAsMonomialFunction(self, order):
        """
        Build the :math:`n`-th order monomial function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.MonomialFunction`
            Requested monomial function.
        """
        return _func.MonomialFunctionFactory_buildAsMonomialFunction(self, order)


    def build(self, order):
        """
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.MonomialFunctionFactory_build(self, order)


    def __init__(self, *args):
        this = _func.new_MonomialFunctionFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_MonomialFunctionFactory
    __del__ = lambda self: None
MonomialFunctionFactory_swigregister = _func.MonomialFunctionFactory_swigregister
MonomialFunctionFactory_swigregister(MonomialFunctionFactory)

class UniVariateFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionFactoryTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionFactoryTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _func.new_UniVariateFunctionFactoryTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.UniVariateFunctionFactoryTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionFactoryTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionFactoryTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _func.UniVariateFunctionFactoryTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _func.delete_UniVariateFunctionFactoryTypedInterfaceObject
    __del__ = lambda self: None
UniVariateFunctionFactoryTypedInterfaceObject_swigregister = _func.UniVariateFunctionFactoryTypedInterfaceObject_swigregister
UniVariateFunctionFactoryTypedInterfaceObject_swigregister(UniVariateFunctionFactoryTypedInterfaceObject)

class FunctionFamilyCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionFamilyCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionFamilyCollection, name)
    __swig_destroy__ = _func.delete_FunctionFamilyCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _func.FunctionFamilyCollection_clear(self)


    def __len__(self):
        return _func.FunctionFamilyCollection___len__(self)

    def __eq__(self, rhs):
        return _func.FunctionFamilyCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _func.FunctionFamilyCollection___contains__(self, val)

    def __getitem__(self, i):
        return _func.FunctionFamilyCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _func.FunctionFamilyCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _func.FunctionFamilyCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.FunctionFamilyCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.FunctionFamilyCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.FunctionFamilyCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.FunctionFamilyCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.FunctionFamilyCollection_isEmpty(self)


    def __repr__(self):
        return _func.FunctionFamilyCollection___repr__(self)

    def __str__(self, *args):
        return _func.FunctionFamilyCollection___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_FunctionFamilyCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
FunctionFamilyCollection_swigregister = _func.FunctionFamilyCollection_swigregister
FunctionFamilyCollection_swigregister(FunctionFamilyCollection)

class UniVariateFunctionFamily(UniVariateFunctionFactoryTypedInterfaceObject):
    """Base class for univariate function factories."""

    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionFactoryTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionFamily, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionFactoryTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionFamily, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionFamily_getClassName(self)


    def __repr__(self):
        return _func.UniVariateFunctionFamily___repr__(self)

    def build(self, order):
        """
        Build the :math:`n`-th order univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested univariate function.
        """
        return _func.UniVariateFunctionFamily_build(self, order)


    def __init__(self, *args):
        this = _func.new_UniVariateFunctionFamily(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunctionFamily
    __del__ = lambda self: None
UniVariateFunctionFamily_swigregister = _func.UniVariateFunctionFamily_swigregister
UniVariateFunctionFamily_swigregister(UniVariateFunctionFamily)

class TensorizedUniVariateFunctionFactory(FunctionalBasisImplementation):
    """
    Base class for tensorized multivariate functions.

    Available constructors:
            TensorizedUniVariateFunctionFactory(*functions*)

            TensorizedUniVariateFunctionFactory(*functions, enumerateFunction*)

    Parameters
    ----------
    functions : list of :class:`~openturns.UniVariateFunctionFamily`
        List of univariate function factories.
    enumerateFunction : :class:`~openturns.EnumerateFunction`
        Associates to an integer its multi-index image in the :math:`\\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.

    Notes
    -----
    TensorizedUniVariateFunctionFactory allows to create multidimensional functions as the tensor product of univariate
    functions created by their respective factories (i.e. :class:`~openturns.UniVariateFunctionFamily`):

    .. math::

       \\Phi_n(x_1,\\dots,x_d)=\\prod_{i=1}^d \\phi^i_{enum(n)_i}(x_i)


    where :math:`\\phi^i_k` is the univariate basis of degree :math:`k` associated to the component :math:`x_i`
    and :math:`enum(n)_i` is the ith component of the multi-index :math:`enum(n)`


    Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.

    Examples
    --------
    >>> import openturns as ot
    >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory(), ot.MonomialFunctionFactory()]
    >>> dim = len(funcColl)
    >>> enumerateFunction = ot.LinearEnumerateFunction(dim)
    >>> productBasis = ot.TensorizedUniVariateFunctionFactory(funcColl, enumerateFunction)
    """

    __swig_setmethods__ = {}
    for _s in [FunctionalBasisImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorizedUniVariateFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionalBasisImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorizedUniVariateFunctionFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TensorizedUniVariateFunctionFactory_getClassName(self)


    def build(self, index):
        """
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \\geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.Function`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.SymbolicFunction(input, [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.TensorizedUniVariateFunctionFactory_build(self, index)


    def getEnumerateFunction(self):
        return _func.TensorizedUniVariateFunctionFactory_getEnumerateFunction(self)

    def setEnumerateFunction(self, phi):
        return _func.TensorizedUniVariateFunctionFactory_setEnumerateFunction(self, phi)

    def getFunctionFamilyCollection(self):
        return _func.TensorizedUniVariateFunctionFactory_getFunctionFamilyCollection(self)

    def setFunctionFamilyCollection(self, coll):
        return _func.TensorizedUniVariateFunctionFactory_setFunctionFamilyCollection(self, coll)

    def __repr__(self):
        return _func.TensorizedUniVariateFunctionFactory___repr__(self)

    def __init__(self, *args):
        this = _func.new_TensorizedUniVariateFunctionFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_TensorizedUniVariateFunctionFactory
    __del__ = lambda self: None
TensorizedUniVariateFunctionFactory_swigregister = _func.TensorizedUniVariateFunctionFactory_swigregister
TensorizedUniVariateFunctionFactory_swigregister(TensorizedUniVariateFunctionFactory)

class LARS(BasisSequenceFactoryImplementation):
    """
    Least Angle Regression.

    Available constructors:
        LARS()

    See also
    --------
    BasisSequenceFactory

    Notes
    -----
    LARS inherits from :class:`~openturns.BasisSequenceFactory`.

    If the size :math:`P` of the PC basis is of similar size to :math:`N`, or even
    possibly significantly larger than :math:`N` , then the following ordinary least
    squares problem is ill-posed:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} E_{\\mu} \\left[ \\left( g \\circ T^{-1}
                (\\vect{U}) - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U}) \\right)^2 \\right]

    The sparse least squares approaches may be employed instead. Eventually a sparse
    PC representation is obtained, that is an approximation which only contains a
    small number of active basis functions.

    This class is not usable as is because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [BasisSequenceFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LARS, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LARS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LARS_getClassName(self)


    def build(self, x, y, psi, indices):
        return _func.LARS_build(self, x, y, psi, indices)

    def __repr__(self):
        return _func.LARS___repr__(self)

    def __str__(self, *args):
        return _func.LARS___str__(self, *args)

    def __init__(self, *args):
        this = _func.new_LARS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LARS
    __del__ = lambda self: None
LARS_swigregister = _func.LARS_swigregister
LARS_swigregister(LARS)


# deprecated
class LAR(LARS):
    def __init__(self, *args):
        super(LAR, self).__init__(*args)
        openturns.common.Log.Warn('class LAR is deprecated in favor of LARS')

class BoxCoxEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::BoxCoxEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoxCoxEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BoxCoxEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.BoxCoxEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.BoxCoxEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.BoxCoxEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.BoxCoxEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.BoxCoxEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.BoxCoxEvaluation_getOutputDimension(self)


    def getLambda(self):
        return _func.BoxCoxEvaluation_getLambda(self)

    def getShift(self):
        return _func.BoxCoxEvaluation_getShift(self)

    def __init__(self, *args):
        this = _func.new_BoxCoxEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BoxCoxEvaluation
    __del__ = lambda self: None
BoxCoxEvaluation_swigregister = _func.BoxCoxEvaluation_swigregister
BoxCoxEvaluation_swigregister(BoxCoxEvaluation)

class BoxCoxTransform(Function):
    """
    BoxCox transformation.

    Available constructors:
        BoxCoxTransform(*lambdaVect, shiftVect = [0]*)

        BoxCoxTransform(*lambda, shift=0*)

    Parameters
    ----------
    lambdaVect : sequence of float
        The  :math:`(\\lambda_1, \\dots, \\lambda_d)` parameter.
    shiftVect : sequence of float
        The  :math:`(\\alpha_1, \\dots, \\alpha_d)` parameter. 

        Default is :math:`(\\alpha_1, \\dots, \\alpha_d)=(0, \\dots, 0)`.
    lambda : float
        The  :math:`\\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\\alpha` parameter in the univariate case.

        Default is :math:`\\alpha = 0`.


    Notes
    -----
    The Box Cox transformation :math:`h_{\\vect{\\lambda}, \\vect{\\alpha}}: \\Rset^d \\rightarrow \\Rset^d` writes for each component :math:`h_{\\lambda_i, \\alpha_i}: \\Rset \\rightarrow \\Rset`:

    .. math::

        h_{\\lambda_i, \\alpha_i} (x)= 
        \\left\\{
        \\begin{array}{ll}
        \\dfrac{(x+\\alpha_i)^{\\lambda_i}-1}{\\lambda} & \\lambda_i \\neq 0 \\\\
        \\log(x+\\alpha_i)                        & \\lambda_i = 0
        \\end{array}
        \\right.

    for all :math:`x+\\alpha_i >0`.

    The inverse Box Cox transformation writes:

    .. math::

        \\begin{array}{lcl}
          h_{\\lambda_i, \\alpha_i}^{-1}(y) & = &
          \\left\\{
          \\begin{array}{ll}
        \\displaystyle (\\lambda_i y + 1)^{\\frac{1}{\\lambda_i}} - \\alpha_i & \\lambda_i \\neq 0 \\\\
        \\displaystyle \\exp(y) - \\alpha_i                         & \\lambda_i = 0
          \\end{array}
          \\right.
        \\end{array}

    Examples
    --------

    Create a Box Cox tranformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myBoxCox = ot.BoxCoxTransform(myLambda)

    Estimate a transformation from a sample:

    >>> mySample = ot.Exponential(2).getSample(100)
    >>> myModelTransform = ot.BoxCoxFactory().build(mySample)

    Apply ot to the sample:

    >>> myNormalSample = myModelTransform(mySample)

    >>> hist = ot.HistogramFactory().build(myNormalSample)
    >>> graph = hist.drawPDF()

    Apply it to a field:

    >>> myIndices= ot.Indices([10,5])
    >>> myMesher=ot.IntervalMesher(myIndices)
    >>> myInterval = ot.Interval([0.0, 0.0], [2.0, 1.0])
    >>> myMesh=myMesher.build(myInterval)
    >>> amplitude=[1.0]
    >>> scale=[0.2, 0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXproc=ot.GaussianProcess(myCovModel, myMesh)
    >>> g = ot.SymbolicFunction(['x1'],  ['exp(x1)'])
    >>> myDynTransform = ot.ValueFunction(g, 2)
    >>> myXtProcess = ot.CompositeProcess(myDynTransform, myXproc)

    >>> myField = myXtProcess.getRealization()
    >>> myModelTransform = ot.BoxCoxFactory().build(myField)
    >>> myStabilizedField = myModelTransform(myField)

    >>> marginal = ot.HistogramFactory().build(myStabilizedField.getValues())
    >>> graph2 = marginal.drawPDF()

    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoxCoxTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BoxCoxTransform, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxTransform_getClassName(self)


    def getLambda(self):
        """
        Accessor to the :math:`\\vect{\\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\\vect{\\lambda}` parameter.


        """
        return _func.BoxCoxTransform_getLambda(self)


    def getShift(self):
        """
        Accessor to the :math:`\\vect{\\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\\vect{\\Lambda}` parameter.


        """
        return _func.BoxCoxTransform_getShift(self)


    def getInverse(self):
        """
        Accessor to the inverse Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.InverseBoxCoxTransform`
            The inverse Box Cox transformation.


        """
        return _func.BoxCoxTransform_getInverse(self)


    def __init__(self, *args):
        this = _func.new_BoxCoxTransform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BoxCoxTransform
    __del__ = lambda self: None
BoxCoxTransform_swigregister = _func.BoxCoxTransform_swigregister
BoxCoxTransform_swigregister(BoxCoxTransform)

class InverseBoxCoxEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::InverseBoxCoxEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseBoxCoxEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseBoxCoxEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.InverseBoxCoxEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.InverseBoxCoxEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.InverseBoxCoxEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.InverseBoxCoxEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseBoxCoxEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseBoxCoxEvaluation_getOutputDimension(self)


    def getLambda(self):
        return _func.InverseBoxCoxEvaluation_getLambda(self)

    def getShift(self):
        return _func.InverseBoxCoxEvaluation_getShift(self)

    def __init__(self, *args):
        this = _func.new_InverseBoxCoxEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_InverseBoxCoxEvaluation
    __del__ = lambda self: None
InverseBoxCoxEvaluation_swigregister = _func.InverseBoxCoxEvaluation_swigregister
InverseBoxCoxEvaluation_swigregister(InverseBoxCoxEvaluation)

class InverseBoxCoxTransform(Function):
    """
    BoxCox transformation.

    Available constructors:
        InverseBoxCoxTransform(*lambdaVect, shiftVect = 0*)

        InverseBoxCoxTransform(*lambda, shift=0*)

    Parameters
    ----------
    lambdaVect : :class:`~openturns.Point`
        The  :math:`(\\lambda_1, \\dots, \\lambda_d)` parameter.
    shiftVect : :class:`~openturns.Point`
        The  :math:`(\\alpha_1, \\dots, \\alpha_d)` parameter. 

        Default is :math:`(\\alpha_1, \\dots, \\alpha_d)=(0, \\dots, 0)`.
    lambda : float
        The  :math:`\\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\\alpha` parameter in the univariate case.

        Default is :math:`\\alpha = 0`.


    Notes
    -----
    The inverse Box Cox transformation :math:`h_{\\vect{\\lambda}, \\vect{\\alpha}}^{-1}: \\Rset^d \\rightarrow \\Rset^d` writes for each component :math:`h_{\\lambda_i, \\alpha_i}^{-1}: \\Rset \\rightarrow \\Rset`:

    .. math::

        \\begin{array}{lcl}
          h_{\\lambda_i, \\alpha_i}^{-1}(y) & = &
          \\left\\{
          \\begin{array}{ll}
        \\displaystyle (\\lambda_i y + 1)^{\\frac{1}{\\lambda_i}} - \\alpha_i & \\lambda_i \\neq 0 \\\\
        \\displaystyle \\exp(y) - \\alpha_i                         & \\lambda_i = 0
          \\end{array}
          \\right.
        \\end{array}

    The  Box Cox transformation writes:

    .. math::

        h_{\\lambda_i, \\alpha_i}^{-1} (x)= 
        \\left\\{
        \\begin{array}{ll}
        \\dfrac{(x+\\alpha_i)^\\lambda_i-1}{\\lambda} & \\lambda_i \\neq 0 \\\\
        \\log(x+\\alpha_i)                        & \\lambda_i = 0
        \\end{array}
        \\right.

    for all :math:`x+\\alpha_i >0`.

    Examples
    --------

    Create an inverse Box Cox tranformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myInverseBoxCox = ot.InverseBoxCoxTransform(myLambda)

    """

    __swig_setmethods__ = {}
    for _s in [Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseBoxCoxTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseBoxCoxTransform, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxTransform_getClassName(self)


    def getLambda(self):
        """
        Accessor to the :math:`\\vect{\\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\\vect{\\lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getLambda(self)


    def getShift(self):
        """
        Accessor to the :math:`\\vect{\\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.Point`
            The :math:`\\vect{\\Lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getShift(self)


    def getInverse(self):
        """
        Accessor to the  Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.BoxCoxTransform`
            The Box Cox transformation.


        """
        return _func.InverseBoxCoxTransform_getInverse(self)


    def __init__(self, *args):
        this = _func.new_InverseBoxCoxTransform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_InverseBoxCoxTransform
    __del__ = lambda self: None
InverseBoxCoxTransform_swigregister = _func.InverseBoxCoxTransform_swigregister
InverseBoxCoxTransform_swigregister(InverseBoxCoxTransform)

class TrendEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::TrendEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrendEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrendEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.TrendEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.TrendEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.TrendEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.TrendEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.TrendEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.TrendEvaluation_getOutputDimension(self)


    def getFunction(self):
        return _func.TrendEvaluation_getFunction(self)

    def __init__(self, *args):
        this = _func.new_TrendEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_TrendEvaluation
    __del__ = lambda self: None
TrendEvaluation_swigregister = _func.TrendEvaluation_swigregister
TrendEvaluation_swigregister(TrendEvaluation)

class TrendTransform(VertexValueFunction):
    """
    Trend transformation.

    Parameters
    ----------
    myTrendFunc : :class:`~openturns.Function`
        The trend function :math:`f_{trend}` of a process.

    Notes
    -----
    A multivariate stochastic process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* where :math:`\\cD \\in \\Rset^n` may write as the sum of a trend function :math:`f_{trend}: \\Rset^n \\rightarrow \\Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* as follows:

    .. math::

        X(\\omega,\\vect{t}) = X_{stat}(\\omega,\\vect{t}) + f_{trend}(\\vect{t})


    We note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\\cM = (\\vect{t}_0, \\dots, \\vect{t}_{N-1})` of :math:`\\cD`. We note :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \\vect{x}^{stat}_i = \\vect{x}_i - f_{trend}(\\vect{t}_i)


    Examples
    --------
    Create a trend function: :math:`f_{trend} : \\Rset \\mapsto \\Rset` where :math:`f_{trend}(t)=1+2t+t^2`:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['t'], ['1+2*t+t^2'])
    >>> fTrend = ot.TrendTransform(f)

    Add it to a process:

    >>> myGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> amplitude=[5.0]
    >>> scale=[0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXProcess=ot.GaussianProcess(myCovModel, myGrid)
    >>> myYProcess = ot.CompositeProcess(fTrend, myXProcess)

    Remove it from a field:

    >>> myField = myYProcess.getRealization()
    >>> myStatField = fTrend.getInverse()(myField)

    Then re-add it:

    >>> myInitialField = fTrend(myStatField)

    """

    __swig_setmethods__ = {}
    for _s in [VertexValueFunction]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrendTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [VertexValueFunction]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrendTransform, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendTransform_getClassName(self)


    def __eq__(self, other):
        return _func.TrendTransform___eq__(self, other)

    def __repr__(self):
        return _func.TrendTransform___repr__(self)

    def __str__(self, *args):
        return _func.TrendTransform___str__(self, *args)

    def __call__(self, *args):
        return _func.TrendTransform___call__(self, *args)

    def getInverse(self):
        """
        Accessor to the inverse trend function.

        Returns
        -------
        myInverseTrendTransform : :class:`~openturns.InverseTrendTransform`
            The :math:`f_{trend}^{-1}` function.


        """
        return _func.TrendTransform_getInverse(self)


    def __init__(self, *args):
        this = _func.new_TrendTransform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_TrendTransform
    __del__ = lambda self: None
TrendTransform_swigregister = _func.TrendTransform_swigregister
TrendTransform_swigregister(TrendTransform)

class InverseTrendEvaluation(EvaluationImplementation):
    """Proxy of C++ OT::InverseTrendEvaluation"""

    __swig_setmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseTrendEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseTrendEvaluation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendEvaluation_getClassName(self)


    def __eq__(self, other):
        return _func.InverseTrendEvaluation___eq__(self, other)

    def __repr__(self):
        return _func.InverseTrendEvaluation___repr__(self)

    def __str__(self, *args):
        return _func.InverseTrendEvaluation___str__(self, *args)

    def __call__(self, *args):
        return _func.InverseTrendEvaluation___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseTrendEvaluation_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseTrendEvaluation_getOutputDimension(self)


    def getFunction(self):
        return _func.InverseTrendEvaluation_getFunction(self)

    def __init__(self, *args):
        this = _func.new_InverseTrendEvaluation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_InverseTrendEvaluation
    __del__ = lambda self: None
InverseTrendEvaluation_swigregister = _func.InverseTrendEvaluation_swigregister
InverseTrendEvaluation_swigregister(InverseTrendEvaluation)

class InverseTrendTransform(VertexValueFunction):
    """
    Inverse Trend transformation.

    Parameters
    ----------
    myInverseTrendFunc : :class:`~openturns.Function`
        The  inverse trend function :math:`f_{trend}^{-1}`.


    Notes
    -----
    A multivariate stochastic  process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* where :math:`\\cD \\in \\Rset^n` may write as the sum of a trend function :math:`f_{trend}: \\Rset^n \\rightarrow \\Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* as follows:

    .. math::

        X(\\omega,\\vect{t}) = X_{stat}(\\omega,\\vect{t}) + f_{trend}(\\vect{t})


    We note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\\cM = (\\vect{t}_0, \\dots, \\vect{t}_{N-1})` of :math:`\\cD`. We note :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \\vect{x}^{stat}_i = \\vect{x}_i - f_{trend}(\\vect{t}_i)

    The inverse trend transformation enables to get the :math:`X_{stat}` process or to get the :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` field.


    Examples
    --------
    Create a trend function: :math:`f_{trend} : \\Rset \\mapsto \\Rset` where :math:`f_{trend}(t,s)=-(1+2t+t^2)`:

    >>> import openturns as ot
    >>> h = ot.SymbolicFunction(['t'], ['-(1+2*t+t^2)'])
    >>> fTrendInv = ot.InverseTrendTransform(h)


    """

    __swig_setmethods__ = {}
    for _s in [VertexValueFunction]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseTrendTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [VertexValueFunction]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseTrendTransform, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendTransform_getClassName(self)


    def getInverse(self):
        """
        Accessor to the  trend function.

        Returns
        -------
        myTrendTransform : :class:`~openturns.TrendTransform`
            The :math:`f_{trend}` function.


        """
        return _func.InverseTrendTransform_getInverse(self)


    def __eq__(self, other):
        return _func.InverseTrendTransform___eq__(self, other)

    def __repr__(self):
        return _func.InverseTrendTransform___repr__(self)

    def __str__(self, *args):
        return _func.InverseTrendTransform___str__(self, *args)

    def __call__(self, *args):
        return _func.InverseTrendTransform___call__(self, *args)

    def __init__(self, *args):
        this = _func.new_InverseTrendTransform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_InverseTrendTransform
    __del__ = lambda self: None
InverseTrendTransform_swigregister = _func.InverseTrendTransform_swigregister
InverseTrendTransform_swigregister(InverseTrendTransform)

class BasisFactory(openturns.common.PersistentObject):
    """
    Basis factory to construct the regression basis.

    Available constructors:
       BasisFactory()

       BasisFactory(*orthogUniVarPolFactory*)

    Parameters
    ----------
    orthogUniVarPolFactory : :class:`~openturns.OrthogonalUniVariatePolynomialFactory`
        Factory that builds particular univariate polynomial (e.g. Hermite,
        Legendre, Laguerre, ...).

    See also
    --------
    ConstantBasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    BasisFactory is the interface of the OrthogonalUniVariatePolynomialFactory
    implementation. It represents the factory that allows the construction of any
    univariate orthonormal polynomial with any degree.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisFactory_getClassName(self)


    def __repr__(self):
        return _func.BasisFactory___repr__(self)

    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.BasisFactory_build(self)


    def __init__(self, *args):
        this = _func.new_BasisFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_BasisFactory
    __del__ = lambda self: None
BasisFactory_swigregister = _func.BasisFactory_swigregister
BasisFactory_swigregister(BasisFactory)

class ConstantBasisFactory(BasisFactory):
    """
    Constant basis factory to construct the regression basis.

    Available constructors:
       ConstantBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    A factory for constant basis of input dimension *dimension*.
    """

    __swig_setmethods__ = {}
    for _s in [BasisFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantBasisFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantBasisFactory_getClassName(self)


    def __repr__(self):
        return _func.ConstantBasisFactory___repr__(self)

    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.ConstantBasisFactory_build(self)


    def save(self, adv):
        return _func.ConstantBasisFactory_save(self, adv)

    def load(self, adv):
        return _func.ConstantBasisFactory_load(self, adv)

    def __init__(self, *args):
        this = _func.new_ConstantBasisFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_ConstantBasisFactory
    __del__ = lambda self: None
ConstantBasisFactory_swigregister = _func.ConstantBasisFactory_swigregister
ConstantBasisFactory_swigregister(ConstantBasisFactory)

class LinearBasisFactory(BasisFactory):
    """
    Linear basis factory to construct the regression basis.

    Available constructors:
       LinearBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, QuadraticBasisFactory

    Notes
    -----
    A factory for linear basis of input dimension *dimension*.
    """

    __swig_setmethods__ = {}
    for _s in [BasisFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearBasisFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearBasisFactory_getClassName(self)


    def __repr__(self):
        return _func.LinearBasisFactory___repr__(self)

    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.LinearBasisFactory_build(self)


    def save(self, adv):
        return _func.LinearBasisFactory_save(self, adv)

    def load(self, adv):
        return _func.LinearBasisFactory_load(self, adv)

    def __init__(self, *args):
        this = _func.new_LinearBasisFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_LinearBasisFactory
    __del__ = lambda self: None
LinearBasisFactory_swigregister = _func.LinearBasisFactory_swigregister
LinearBasisFactory_swigregister(LinearBasisFactory)

class QuadraticBasisFactory(BasisFactory):
    """
    Quadratic basis factory to construct the regression basis.

    Available constructors:
       QuadraticBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, LinearBasisFactory

    Notes
    -----
    A factory for quadratic basis of input dimension *dimension*.
    """

    __swig_setmethods__ = {}
    for _s in [BasisFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticBasisFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticBasisFactory_getClassName(self)


    def __repr__(self):
        return _func.QuadraticBasisFactory___repr__(self)

    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.QuadraticBasisFactory_build(self)


    def save(self, adv):
        return _func.QuadraticBasisFactory_save(self, adv)

    def load(self, adv):
        return _func.QuadraticBasisFactory_load(self, adv)

    def __init__(self, *args):
        this = _func.new_QuadraticBasisFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_QuadraticBasisFactory
    __del__ = lambda self: None
QuadraticBasisFactory_swigregister = _func.QuadraticBasisFactory_swigregister
QuadraticBasisFactory_swigregister(QuadraticBasisFactory)

class EvaluationImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EvaluationImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EvaluationImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.EvaluationImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.EvaluationImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_func.EvaluationImplementationPointer_ptr__get, _func.EvaluationImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _func.new_EvaluationImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_EvaluationImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _func.EvaluationImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func.EvaluationImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _func.EvaluationImplementationPointer___deref__(self)

    def isNull(self):
        return _func.EvaluationImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func.EvaluationImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func.EvaluationImplementationPointer_get(self)

    def getImplementation(self):
        return _func.EvaluationImplementationPointer_getImplementation(self)

    def unique(self):
        return _func.EvaluationImplementationPointer_unique(self)

    def use_count(self):
        return _func.EvaluationImplementationPointer_use_count(self)

    def swap(self, other):
        return _func.EvaluationImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EvaluationImplementationPointer_getClassName(self)


    def __eq__(self, other):
        return _func.EvaluationImplementationPointer___eq__(self, other)

    def __repr__(self):
        return _func.EvaluationImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func.EvaluationImplementationPointer___str__(self, *args)

    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.EvaluationImplementationPointer_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.EvaluationImplementationPointer_getDescription(self)


    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.EvaluationImplementationPointer_getInputDescription(self)


    def setInputDescription(self, inputDescription):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.EvaluationImplementationPointer_setInputDescription(self, inputDescription)


    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.EvaluationImplementationPointer_getOutputDescription(self)


    def setOutputDescription(self, outputDescription):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.EvaluationImplementationPointer_setOutputDescription(self, outputDescription)


    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.EvaluationImplementationPointer_enableHistory(self)


    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.EvaluationImplementationPointer_disableHistory(self)


    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementationPointer_isHistoryEnabled(self)


    def clearHistory(self):
        """Empty the content of the history."""
        return _func.EvaluationImplementationPointer_clearHistory(self)


    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.Sample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementationPointer_getHistoryInput(self)


    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.Sample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementationPointer_getHistoryOutput(self)


    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.EvaluationImplementationPointer_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.EvaluationImplementationPointer_getInputParameterHistory(self)


    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.EvaluationImplementationPointer_enableCache(self)


    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.EvaluationImplementationPointer_disableCache(self)


    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementationPointer_isCacheEnabled(self)


    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.EvaluationImplementationPointer_getCacheHits(self)


    def addCacheContent(self, inSample, outSample):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.EvaluationImplementationPointer_addCacheContent(self, inSample, outSample)


    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementationPointer_getCacheInput(self)


    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementationPointer_getCacheOutput(self)


    def clearCache(self):
        """Empty the content of the cache."""
        return _func.EvaluationImplementationPointer_clearCache(self)


    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.EvaluationImplementationPointer_isActualImplementation(self)


    def __call__(self, *args):
        return _func.EvaluationImplementationPointer___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.EvaluationImplementationPointer_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.EvaluationImplementationPointer_getOutputDimension(self)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.EvaluationImplementationPointer_getParameterDimension(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.EvaluationImplementationPointer_getMarginal(self, *args)


    def parameterGradient(self, inP):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.EvaluationImplementationPointer_parameterGradient(self, inP)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.EvaluationImplementationPointer_getParameter(self)


    def setParameter(self, parameters):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.EvaluationImplementationPointer_setParameter(self, parameters)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementationPointer_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementationPointer_setParameterDescription(self, description)


    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.EvaluationImplementationPointer_getCallsNumber(self)


    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction(['x'], ['sin(2*_pi*x)*exp(-x^2/2)'])
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.EvaluationImplementationPointer_draw(self, *args)


    def __ne__(self, other):
        return _func.EvaluationImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.EvaluationImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.EvaluationImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.EvaluationImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.EvaluationImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.EvaluationImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.EvaluationImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.EvaluationImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.EvaluationImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.EvaluationImplementationPointer_setName(self, name)

EvaluationImplementationPointer_swigregister = _func.EvaluationImplementationPointer_swigregister
EvaluationImplementationPointer_swigregister(EvaluationImplementationPointer)

class FunctionImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.FunctionImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.FunctionImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_func.FunctionImplementationPointer_ptr__get, _func.FunctionImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _func.new_FunctionImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_FunctionImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _func.FunctionImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func.FunctionImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _func.FunctionImplementationPointer___deref__(self)

    def isNull(self):
        return _func.FunctionImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func.FunctionImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func.FunctionImplementationPointer_get(self)

    def getImplementation(self):
        return _func.FunctionImplementationPointer_getImplementation(self)

    def unique(self):
        return _func.FunctionImplementationPointer_unique(self)

    def use_count(self):
        return _func.FunctionImplementationPointer_use_count(self)

    def swap(self, other):
        return _func.FunctionImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionImplementationPointer_getClassName(self)


    def GetValidConstants(self):
        return _func.FunctionImplementationPointer_GetValidConstants(self)

    def GetValidFunctions(self):
        return _func.FunctionImplementationPointer_GetValidFunctions(self)

    def GetValidOperators(self):
        return _func.FunctionImplementationPointer_GetValidOperators(self)

    def __mul__(self, *args):
        return _func.FunctionImplementationPointer___mul__(self, *args)

    def __eq__(self, other):
        return _func.FunctionImplementationPointer___eq__(self, other)

    def __repr__(self):
        return _func.FunctionImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func.FunctionImplementationPointer___str__(self, *args)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.FunctionImplementationPointer_enableCache(self)


    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.FunctionImplementationPointer_disableCache(self)


    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.FunctionImplementationPointer_isCacheEnabled(self)


    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.FunctionImplementationPointer_getCacheHits(self)


    def addCacheContent(self, inSample, outSample):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.FunctionImplementationPointer_addCacheContent(self, inSample, outSample)


    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.FunctionImplementationPointer_getCacheInput(self)


    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.Sample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.FunctionImplementationPointer_getCacheOutput(self)


    def clearCache(self):
        """Empty the content of the cache."""
        return _func.FunctionImplementationPointer_clearCache(self)


    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.FunctionImplementationPointer_enableHistory(self)


    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.FunctionImplementationPointer_disableHistory(self)


    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.FunctionImplementationPointer_isHistoryEnabled(self)


    def clearHistory(self):
        """Empty the content of the history."""
        return _func.FunctionImplementationPointer_clearHistory(self)


    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.Sample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.FunctionImplementationPointer_getHistoryInput(self)


    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.Sample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.FunctionImplementationPointer_getHistoryOutput(self)


    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input points stored in the history mecanism.
        """
        return _func.FunctionImplementationPointer_getInputPointHistory(self)


    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.Sample`
            All the input parameters stored in the history mecanism.
        """
        return _func.FunctionImplementationPointer_getInputParameterHistory(self)


    def setEvaluation(self, evaluation):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.
        """
        return _func.FunctionImplementationPointer_setEvaluation(self, evaluation)


    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.EvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.FunctionImplementationPointer_getEvaluation(self)


    def setGradient(self, gradient):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.GradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementationPointer_setGradient(self, gradient)


    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.GradientImplementation`
            The gradient function.
        """
        return _func.FunctionImplementationPointer_getGradient(self)


    def setHessian(self, hessian):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.HessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.FunctionImplementationPointer_setHessian(self, hessian)


    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.HessianImplementation`
            The hessian function.
        """
        return _func.FunctionImplementationPointer_getHessian(self)


    def __call__(self, *args):
        return _func.FunctionImplementationPointer___call__(self, *args)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.FunctionImplementationPointer_gradient(self, *args)


    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.FunctionImplementationPointer_hessian(self, *args)


    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.FunctionImplementationPointer_parameterGradient(self, *args)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.FunctionImplementationPointer_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.FunctionImplementationPointer_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementationPointer_getParameterDescription(self)


    def setParameterDescription(self, description):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.FunctionImplementationPointer_setParameterDescription(self, description)


    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.FunctionImplementationPointer_getParameterDimension(self)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.FunctionImplementationPointer_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.FunctionImplementationPointer_getOutputDimension(self)


    def setDescription(self, description):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.FunctionImplementationPointer_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y0]
        """
        return _func.FunctionImplementationPointer_getDescription(self)


    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.FunctionImplementationPointer_getInputDescription(self)


    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y0]
        """
        return _func.FunctionImplementationPointer_getOutputDescription(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.Function`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.FunctionImplementationPointer_getMarginal(self, *args)


    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.FunctionImplementationPointer_getEvaluationCallsNumber(self)


    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            Function has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.FunctionImplementationPointer_getGradientCallsNumber(self)


    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            Function has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.FunctionImplementationPointer_getHessianCallsNumber(self)


    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.SymbolicFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.FunctionImplementationPointer_draw(self, *args)


    def __ne__(self, other):
        return _func.FunctionImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.FunctionImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.FunctionImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.FunctionImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.FunctionImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.FunctionImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.FunctionImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.FunctionImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FunctionImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FunctionImplementationPointer_setName(self, name)

FunctionImplementationPointer_swigregister = _func.FunctionImplementationPointer_swigregister
FunctionImplementationPointer_swigregister(FunctionImplementationPointer)

class GradientImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GradientImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GradientImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.GradientImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.GradientImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_func.GradientImplementationPointer_ptr__get, _func.GradientImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _func.new_GradientImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_GradientImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _func.GradientImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func.GradientImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _func.GradientImplementationPointer___deref__(self)

    def isNull(self):
        return _func.GradientImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func.GradientImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func.GradientImplementationPointer_get(self)

    def getImplementation(self):
        return _func.GradientImplementationPointer_getImplementation(self)

    def unique(self):
        return _func.GradientImplementationPointer_unique(self)

    def use_count(self):
        return _func.GradientImplementationPointer_use_count(self)

    def swap(self, other):
        return _func.GradientImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.GradientImplementationPointer_getClassName(self)


    def __eq__(self, other):
        return _func.GradientImplementationPointer___eq__(self, other)

    def __repr__(self):
        return _func.GradientImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func.GradientImplementationPointer___str__(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.GradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.GradientImplementationPointer_getMarginal(self, *args)


    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.GradientImplementationPointer_isActualImplementation(self)


    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.GradientImplementationPointer_gradient(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.GradientImplementationPointer_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.GradientImplementationPointer_getOutputDimension(self)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.GradientImplementationPointer_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.GradientImplementationPointer_setParameter(self, parameter)


    def getCallsNumber(self):
        """
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.GradientImplementationPointer_getCallsNumber(self)


    def __ne__(self, other):
        return _func.GradientImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.GradientImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.GradientImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.GradientImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.GradientImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.GradientImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.GradientImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.GradientImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.GradientImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.GradientImplementationPointer_setName(self, name)

GradientImplementationPointer_swigregister = _func.GradientImplementationPointer_swigregister
GradientImplementationPointer_swigregister(GradientImplementationPointer)

class HessianImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HessianImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HessianImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.HessianImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.HessianImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_func.HessianImplementationPointer_ptr__get, _func.HessianImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _func.new_HessianImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_HessianImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _func.HessianImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func.HessianImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _func.HessianImplementationPointer___deref__(self)

    def isNull(self):
        return _func.HessianImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func.HessianImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func.HessianImplementationPointer_get(self)

    def getImplementation(self):
        return _func.HessianImplementationPointer_getImplementation(self)

    def unique(self):
        return _func.HessianImplementationPointer_unique(self)

    def use_count(self):
        return _func.HessianImplementationPointer_use_count(self)

    def swap(self, other):
        return _func.HessianImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HessianImplementationPointer_getClassName(self)


    def __eq__(self, other):
        return _func.HessianImplementationPointer___eq__(self, other)

    def __repr__(self):
        return _func.HessianImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func.HessianImplementationPointer___str__(self, *args)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.HessianImplementationPointer_isActualImplementation(self)


    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.HessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.HessianImplementationPointer_getMarginal(self, *args)


    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.HessianImplementationPointer_hessian(self, *args)


    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.HessianImplementationPointer_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.HessianImplementationPointer_getOutputDimension(self)


    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            The parameter values.
        """
        return _func.HessianImplementationPointer_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.HessianImplementationPointer_setParameter(self, parameter)


    def getCallsNumber(self):
        """
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.HessianImplementationPointer_getCallsNumber(self)


    def __ne__(self, other):
        return _func.HessianImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.HessianImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.HessianImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.HessianImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.HessianImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.HessianImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.HessianImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.HessianImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.HessianImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.HessianImplementationPointer_setName(self, name)

HessianImplementationPointer_swigregister = _func.HessianImplementationPointer_swigregister
HessianImplementationPointer_swigregister(HessianImplementationPointer)

class UniVariatePolynomialImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.UniVariatePolynomialImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.UniVariatePolynomialImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_func.UniVariatePolynomialImplementationPointer_ptr__get, _func.UniVariatePolynomialImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _func.new_UniVariatePolynomialImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _func.UniVariatePolynomialImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _func.UniVariatePolynomialImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _func.UniVariatePolynomialImplementationPointer___deref__(self)

    def isNull(self):
        return _func.UniVariatePolynomialImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _func.UniVariatePolynomialImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _func.UniVariatePolynomialImplementationPointer_get(self)

    def getImplementation(self):
        return _func.UniVariatePolynomialImplementationPointer_getImplementation(self)

    def unique(self):
        return _func.UniVariatePolynomialImplementationPointer_unique(self)

    def use_count(self):
        return _func.UniVariatePolynomialImplementationPointer_use_count(self)

    def swap(self, other):
        return _func.UniVariatePolynomialImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomialImplementationPointer_getClassName(self)


    def __repr__(self):
        return _func.UniVariatePolynomialImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _func.UniVariatePolynomialImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _func.UniVariatePolynomialImplementationPointer___call__(self, *args)

    def gradient(self, x):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomialImplementationPointer_gradient(self, x)


    def hessian(self, x):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomialImplementationPointer_hessian(self, x)


    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomialImplementationPointer_derivate(self)


    def __mul__(self, *args):
        return _func.UniVariatePolynomialImplementationPointer___mul__(self, *args)

    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomialImplementationPointer_incrementDegree(self, degree)


    def __add__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementationPointer___add__(self, uniVariatePolynomial)

    def __sub__(self, uniVariatePolynomial):
        return _func.UniVariatePolynomialImplementationPointer___sub__(self, uniVariatePolynomial)

    def setCoefficients(self, coefficients):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomialImplementationPointer_setCoefficients(self, coefficients)


    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomialImplementationPointer_getCoefficients(self)


    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomialImplementationPointer_getDegree(self)


    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomialImplementationPointer_getRoots(self)


    def draw(self, xMin, xMax, pointNumber):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariatePolynomialImplementationPointer_draw(self, xMin, xMax, pointNumber)


    def __eq__(self, arg2):
        return _func.UniVariatePolynomialImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _func.UniVariatePolynomialImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.UniVariatePolynomialImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.UniVariatePolynomialImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.UniVariatePolynomialImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.UniVariatePolynomialImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationPointer_setName(self, name)

UniVariatePolynomialImplementationPointer_swigregister = _func.UniVariatePolynomialImplementationPointer_swigregister
UniVariatePolynomialImplementationPointer_swigregister(UniVariatePolynomialImplementationPointer)

# This file is compatible with both classic and new-style classes.


