# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Probabilistic distributions."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_dist_bundle3')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_dist_bundle3')
    _dist_bundle3 = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_dist_bundle3', [dirname(__file__)])
        except ImportError:
            import _dist_bundle3
            return _dist_bundle3
        try:
            _mod = imp.load_module('_dist_bundle3', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _dist_bundle3 = swig_import_helper()
    del swig_import_helper
else:
    import _dist_bundle3
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle3.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _dist_bundle3.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _dist_bundle3.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _dist_bundle3.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _dist_bundle3.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _dist_bundle3.SwigPyIterator_equal(self, x)

    def copy(self):
        return _dist_bundle3.SwigPyIterator_copy(self)

    def next(self):
        return _dist_bundle3.SwigPyIterator_next(self)

    def __next__(self):
        return _dist_bundle3.SwigPyIterator___next__(self)

    def previous(self):
        return _dist_bundle3.SwigPyIterator_previous(self)

    def advance(self, n):
        return _dist_bundle3.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _dist_bundle3.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _dist_bundle3.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _dist_bundle3.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _dist_bundle3.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _dist_bundle3.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _dist_bundle3.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _dist_bundle3.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _dist_bundle3.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class OrderStatisticsMarginalChecker(openturns.common.Object):
    """
    Compatibility tests of marginals with respect to the order statistics constraint.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The marginals :math:`(F_1, \\dots, F_n)` which are tested with respect to the order :math:`F_1 < \\dots < F_n` in the context of the maximum order statistics distribution.

    Notes
    -----

    Three tests are performed. We note :math:`[a_i,b_i]` the range of :math:`X_i`. The tests are :

    - Test 1 checks that :math:`a_i \\leq a_{i+1}` and :math:`b_i \\leq b_{i+1}` for all :math:`i`.

    - Test 2 discretizes :math:`[0,1]` with :math:`\\{\\dfrac{1}{2n},\\dfrac{3}{2n}, \\dots,\\dfrac{2n-1}{2n}\\} = \\{q_1, \\dots, q_{2n-1} \\}` where :math:`n` is defined in the :class:`~openturns.ResourceMap` with `OSMC-OptimizationEpsilon`. By default, :math:`n=100`. Test 2 checks that:

      .. math::

          F_k^{-1}(q_j) \\geq F_{k-1}^{-1}(q_j)+\\epsilon, \\quad 1 \\leq j \\leq d

      where :math:`\\epsilon` is defined in the :class:`~openturns.ResourceMap` with `OSMC-QuantileIteration`. By default, :math:`\\epsilon=10^{-7}`.

    - Test 3 checks that: 

      .. math::

          \\min_{q \\in [q_{j-1}, q_j]} \\{F_k^{-1}(q) - F_{k-1}^{-1}(q) \\} \\geq \\epsilon

      using the TNC algorithm.


    Examples
    --------
    Create the test checker:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.Uniform(-0.5, 1.5)]
    >>> testChecker = ot.OrderStatisticsMarginalChecker(coll)

    Check the compatibility:

    >>> compatibilityResult = testChecker.isCompatible()
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrderStatisticsMarginalChecker, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrderStatisticsMarginalChecker, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_getClassName(self)


    def isCompatible(self):
        """
        Result of the compatibility tests.

        Returns
        -------
        resCompatibility : bool
            The final result of the 3 compatibility tests with respect to the order constraint.
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_isCompatible(self)


    def check(self):
        """
        Give the reasons of uncompatibility of the margins if any.

        Notes
        -----
        This method throws an exception in case of compatibility problem with a message indicating the first compatibility problem arised.

        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_check(self)


    def buildPartition(self):
        """
        Accessor to the partition in independent marginal sets if any.

        Returns
        -------
        indepMarginals : :class:`~openturns.Indices`
            Indicates the indices that build some independent sets of marginals. If we note :math:`indepMarginals = [i_1, i_2]` then the sub random vectors :math:`(X_1, \\dots, X_{i_1})`,  :math:`(X_{i_1+1}, \\dots, X_{i_2})` and  :math:`(X_{i_2+1}, \\dots, X_n)` are independent.
            This information is automatically used by OpenTURNS to build the appropriated maximum entropy order statistics distribution.
        """
        return _dist_bundle3.OrderStatisticsMarginalChecker_buildPartition(self)


    def getOptimizationAlgorithm(self):
        return _dist_bundle3.OrderStatisticsMarginalChecker_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        return _dist_bundle3.OrderStatisticsMarginalChecker_setOptimizationAlgorithm(self, solver)

    def getOptimizationSolver(self):
        return _dist_bundle3.OrderStatisticsMarginalChecker_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _dist_bundle3.OrderStatisticsMarginalChecker_setOptimizationSolver(self, solver)

    def __init__(self, *args):
        this = _dist_bundle3.new_OrderStatisticsMarginalChecker(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_OrderStatisticsMarginalChecker
    __del__ = lambda self: None
OrderStatisticsMarginalChecker_swigregister = _dist_bundle3.OrderStatisticsMarginalChecker_swigregister
OrderStatisticsMarginalChecker_swigregister(OrderStatisticsMarginalChecker)

class ParametrizedDistribution(openturns.model_copula.DistributionImplementation):
    """
    Parametrized distribution.

    Available constructors:
        ParametrizedDistribution(*parameters*)

    Parameters
    ----------
    parameters : :class:`~openturns.DistributionParameters`
        Parameters of the distribution to be created.

    See also
    --------
    Distribution

    Notes
    -----
    A *ParametrizedDistribution* object enables to create a distribution with
    non-native parameters defined thanks to the class
    :class:`~openturns.DistributionParameters`.

    Examples
    --------
    Create the parameters of the Gamma distribution:

    >>> import openturns as ot
    >>> parameters = ot.GammaMuSigma(1.5, 2.5, -0.5)

    Create the distribution:

    >>> distribution = ot.ParametrizedDistribution(parameters)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametrizedDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametrizedDistribution, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ParametrizedDistribution_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.ParametrizedDistribution___eq__(self, other)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ParametrizedDistribution_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.ParametrizedDistribution_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.ParametrizedDistribution_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.ParametrizedDistribution_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.ParametrizedDistribution_computeCDFGradient(self, *args)


    def computeQuantile(self, *args):
        """
        Compute the quantile function.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : :class:`~openturns.Point`
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\\vect{X}}(p) = F_{\\vect{X}}^{-1}(p),
                              \\quad p \\in [0; 1]
        """
        return _dist_bundle3.ParametrizedDistribution_computeQuantile(self, *args)


    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        """
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)

        """
        return _dist_bundle3.ParametrizedDistribution_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)


    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        """
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the bilateral confidence interval at level 0.9 with marginal probability:

        >>> confInt, marginalProb = paramDist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _dist_bundle3.ParametrizedDistribution_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)


    def computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail):
        """
        Compute a unilateral confidence interval.

        Refer to :func:`computeUnilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.
        tail : boolean
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, False)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, True)

        """
        return _dist_bundle3.ParametrizedDistribution_computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.ParametrizedDistribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ParametrizedDistribution_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ParametrizedDistribution_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ParametrizedDistribution_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ParametrizedDistribution_isElliptical(self)


    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ParametrizedDistribution_isContinuous(self)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.ParametrizedDistribution_getRoughness(self)


    def getMean(self):
        """
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \\vect{\\mu} = \\Tr{\\left(\\Expect{X_i}, \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getMean(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.ParametrizedDistribution_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.ParametrizedDistribution_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.ParametrizedDistribution_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.ParametrizedDistribution_getStandardRepresentative(self)


    def __repr__(self):
        return _dist_bundle3.ParametrizedDistribution___repr__(self)

    def __init__(self, *args):
        this = _dist_bundle3.new_ParametrizedDistribution(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_ParametrizedDistribution
    __del__ = lambda self: None
ParametrizedDistribution_swigregister = _dist_bundle3.ParametrizedDistribution_swigregister
ParametrizedDistribution_swigregister(ParametrizedDistribution)

class Poisson(openturns.model_copula.DiscreteDistribution):
    """
    Poisson distribution.

    Available constructors:
        Poisson(*lambda=1.0*)

    Parameters
    ----------
    lambda : float, :math:`\\lambda > 0`
        Mean and variance value.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = \\frac{\\lambda^k}{k!}\\;e^{-\\lambda}, \\,  k \\in \\Nset

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\lambda \\\\
            \\Var{X} & = & sqrt{\\lambda}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Poisson(10.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Poisson, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Poisson, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Poisson_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Poisson___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Poisson___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Poisson___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Poisson_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Poisson_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Poisson_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Poisson_computeComplementaryCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Poisson_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Poisson_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Poisson_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.Poisson_computeLogCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle3.Poisson_computeGeneratingFunction(self, z)


    def computeLogGeneratingFunction(self, z):
        """
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input `X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle3.Poisson_computeLogGeneratingFunction(self, z)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.Poisson_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Poisson_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Poisson_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Poisson_getKurtosis(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Poisson_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Poisson_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Poisson_getParameterDescription(self)


    def setLambda(self, arg2):
        """
        Accessor to the distribution's mean and variance value.

        Parameters
        ----------
        lambda : float
            Distribution's mean and variance value.
        """
        return _dist_bundle3.Poisson_setLambda(self, arg2)


    def getLambda(self):
        """
        Accessor to the distribution's mean and variance value.

        Returns
        -------
        lambda : float
            Distribution's mean and variance value.
        """
        return _dist_bundle3.Poisson_getLambda(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Poisson(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Poisson
    __del__ = lambda self: None
Poisson_swigregister = _dist_bundle3.Poisson_swigregister
Poisson_swigregister(Poisson)

class PoissonFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Poisson factory.

    Available constructor:
        PoissonFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PoissonFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PoissonFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.PoissonFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.PoissonFactory_build(self, *args)


    def buildAsPoisson(self, *args):
        return _dist_bundle3.PoissonFactory_buildAsPoisson(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_PoissonFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_PoissonFactory
    __del__ = lambda self: None
PoissonFactory_swigregister = _dist_bundle3.PoissonFactory_swigregister
PoissonFactory_swigregister(PoissonFactory)

class ProductDistribution(openturns.model_copula.ContinuousDistribution):
    """
    Product distribution.

    Helper class for defining the push-forward distribution of a given univariate distribution by a given scalar function.

    Available constructors:
        ProductDistribution(*distX, distY*)

    Parameters
    ----------

    distX : :class:`~openturns.Distribution`, univariate
        Independant of `distY`

    distY : :class:`~openturns.Distribution`, univariate
        Independant of `distX`

    Returns
    -------
    distZ : :class:`~openturns.Distribution`, univariate
        :math:`distZ` is the distribution of the random variable :math:`Z = XY` when :math:`(X,Y)` is a random vector with independant copula and respective marginal distributions `distX` and `distY`.


    Notes
    -----
    We note :math:`Z=XY` the scalar random variable which distribution is :math:`f_Z`.

    .. math::

        \\displaystyle f_Z(z) = \\int_{\\Rset} f_X (t) f_{Y}(\\dfrac{z}{t}) \\, \\dfrac{\\Diff t}{|t|}

    with :math:`f_X`,  and :math:`f_Y` the probability density functions of :math:`X`  and :math:`Y`.

    Its first moments, if finite, are defined as: 

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{Z} & = &  \\Expect{X} \\Expect{Y} \\\\
            \\Var{Z} & = & \\Expect{X}^2 \\Var{Y} +  \\Expect{Y}^2 \\Var{X} + \\Var{X}  \\Var{Y} 
        \\end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distX = ot.Normal(-1.0, 1.0)
    >>> distY = ot.Uniform(-1.0, 1.0)
    >>> distZ = ot.ProductDistribution(distX, distY)

    Draw a sample:

    >>> sample = distZ.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductDistribution, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ProductDistribution_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.ProductDistribution___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.ProductDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.ProductDistribution___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.ProductDistribution_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ProductDistribution_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ProductDistribution_computeCDF(self, *args)


    def computeProbability(self, interval):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.ProductDistribution_computeProbability(self, interval)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.ProductDistribution_computeCharacteristicFunction(self, x)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ProductDistribution_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ProductDistribution_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ProductDistribution_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ProductDistribution_isElliptical(self)


    def setLeft(self, left):
        return _dist_bundle3.ProductDistribution_setLeft(self, left)

    def getLeft(self):
        """
        Accessor to the left distribution of the product.

        Returns
        -------
        distX :  :class:`~openturns.Distribution`.
        """
        return _dist_bundle3.ProductDistribution_getLeft(self)


    def setRight(self, right):
        return _dist_bundle3.ProductDistribution_setRight(self, right)

    def getRight(self):
        """
        Accessor to the right distribution of the product.

        Returns
        -------
        distY :  :class:`~openturns.Distribution`.
        """
        return _dist_bundle3.ProductDistribution_getRight(self)


    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isContinuous(self)


    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isDiscrete(self)


    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.ProductDistribution_isIntegral(self)


    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.ProductDistribution_getSingularities(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_ProductDistribution(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_ProductDistribution
    __del__ = lambda self: None
ProductDistribution_swigregister = _dist_bundle3.ProductDistribution_swigregister
ProductDistribution_swigregister(ProductDistribution)

class RandomMixture(openturns.model_copula.DistributionImplementation):
    """
    RandomMixture distribution.

    Available constructors:
        RandomMixture(*coll, cst*)

        RandomMixture(*coll, weights, cst*)

        RandomMixture(*coll, weightsMatrix*)

        RandomMixture(*coll, weightsMatrix, constant*)


    Parameters
    ----------
    coll : list of :class:`~openturns.Distribution`
        The collection of distributions that model the random vector.
    cst : float
        Constant coefficient of the affine expression in dimension 1.
        Default value is zero.
    weights :  sequence of float
        Weights of the affine combination in dimension 1.
    constant : sequence of float
        Constant vector of the affine expression.
        Its size should be equal to the dimension of the distribution.
        Default value is (0,...,0).
    weightsMatrix :  2-d sequence of float
        Weights of the affine combination.

    Notes
    -----
    Create an affine combination of input random variables of form:
        :math:`Y = y_0 + M X`
    where: :math:`\\vect{Y}` of size :math:`d` with :math:`d\\in \\{1,2,3\\}`
           :math:`\\vect{X}` is a :math:`n`-random vector with independent components, i.e. a
           collection of univariate distributions,

           :math:`\\mat{M}` is a :math:`d \\times n` deterministic matrix, i.e. the linear
           operator of the affine transformation,

           :math:`\\vect{y}_0` a constant and deterministic vector, i.e the constant
           part of the affine transformation.

    As the univariate random variables :math:`X_i` are independent, the
    characteristic function of :math:`\\vect{Y}`, denoted :math:`\\phi_Y`, is
    easily defined from the characteristic function of :math:`X_k` denoted
    :math:`\\phi_{X_k}` as follows :

    .. math::

        \\phi(z_1,...,z_d) =  \\prod_{j=1}^d {\\exp(i z_j {y_0}_j)} \\prod_{k=1}^n \\phi_{X_k}((\\Tr{\\mat{M}} z)_k)

    It is possible to evaluate its density probability function once the
    characteristic function evaluated, using the Poisson summation formula:

    .. math::

        \\sum_{j_1 \\in \\mathbb{Z}}\\hdots \\sum_{j_d \\in \\mathbb{Z}} p(y_1 + 2\\pi j_1/h_1,\\hdots,y_d + 2\\pi j_d/h_d) = (h_1\\hdots h_d)/(2^d \\pi^d) \\sum_{k_1 \\in \\mathbb{Z}}\\hdots \\sum_{k_d \\in \\mathbb{Z}} \\phi(k_1 h_1,\\hdots,k_d h_d)\\exp(-i(k_1 h_1+\\hdots+k_d h_d))

    For :math:`h_i` small enough, the nested sums of the left term are reduced
    to the central term :math:`j_1=\\hdots=j_d = 0`.
    Thus, the density is approximated by:

    .. math::

        p(y_1,\\hdots,y_d) = (h_1\\hdots h_d)/(2^d \\pi^d) \\sum_{|k_1| \\leq N}\\hdots \\sum_{|k_d| \\leq N} \\phi(k_1 h_1,\\hdots,k_d h_d)\\exp(-i(k_1 h_1+\\hdots+k_d h_d))

    The nested sums of the right term are computed by blocks of form
    :math:`2^b \\leq k < 2^{b+1}`, and are truncated when the contribution of a
    block becomes lower than a threshold, which can be changed by
    setPDFPrecision method.
    Two other methods also may change the number of iterations; setBlockMin
    sets the block number from which truncation is possible, which means that
    computations are always performed for blocks lower than this parameter,
    even if their contributions are very small. On the other hand, setBlockMax
    sets the maximum number of blocks, which can be useful to make sure that
    computations run in a limited time.

    Note that the total number of evaluations of the characteristic function to
    compute up to block :math:`b` is equivalent to :math:`2^{dim \\times (b+1)}`, so
    it is important to ensure that this number has some reasonable value.

    Note finally that the characteristic function evaluations are independent
    from :math:`\\vect{y}=(y_1,\\hdots,y_d)`: these values are stored in a cache.


    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{\\vect{Y}}  & = & \\vect{y}_0 + \\mat{M}\\Expect{\\vect{X}} \\\\
            \\Cov{Y}  & = & \\mat{M} \\Cov{X} \\Tr{\\mat{M}}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.RandomMixture([ot.Normal(), ot.Uniform()])

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomMixture, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomMixture, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RandomMixture_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.RandomMixture___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.RandomMixture___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.RandomMixture___str__(self, *args)

    def getDistributionCollection(self):
        """
        Return the list of distributions used.

        In dimension 1, some analytical aggregations may be performed on
        distributions to improve performance, and collection may differ from the
        one originally given by user.

        Returns
        -------
        coll : DistributionCollection
            The collection of univariate distributions used for the combination

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Sum of two Uniform here is a Triangular
        >>> coll = distribution.getDistributionCollection()
        >>> print(coll)
        [Triangular(a = -2, m = 0, b = 2)]
        """
        return _dist_bundle3.RandomMixture_getDistributionCollection(self)


    def getFFTAlgorithm(self):
        return _dist_bundle3.RandomMixture_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        return _dist_bundle3.RandomMixture_setFFTAlgorithm(self, fft)

    def setConstant(self, constant):
        """
        Set the constant term of the affine combination.

        Parameters
        ----------
        vect : sequence of float
            The constant term

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Set the new constant term is 0
        >>> distribution.setConstant([1.0])
        """
        return _dist_bundle3.RandomMixture_setConstant(self, constant)


    def getConstant(self):
        """
        Return the vector of the affine combination.

        Returns
        -------
        out : :class:`~openturns.Point`
            The constant term

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # Constant term is 0
        >>> cst = distribution.getConstant()
        >>> print(cst)
        [0]
        """
        return _dist_bundle3.RandomMixture_getConstant(self)


    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.RandomMixture_getRealization(self)


    def getSample(self, size):
        """
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator
        """
        return _dist_bundle3.RandomMixture_getSample(self, size)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computePDF(self, *args)


    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.RandomMixture_getMarginal(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.RandomMixture_computeComplementaryCDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.RandomMixture_computeCDF(self, *args)


    def computeProbability(self, interval):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.RandomMixture_computeProbability(self, interval)


    def computeQuantile(self, *args):
        """
        Compute the quantile function.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : :class:`~openturns.Point`
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\\vect{X}}(p) = F_{\\vect{X}}^{-1}(p),
                              \\quad p \\in [0; 1]
        """
        return _dist_bundle3.RandomMixture_computeQuantile(self, *args)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.RandomMixture_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.RandomMixture_computeCharacteristicFunction(self, *args)


    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.RandomMixture_computeLogCharacteristicFunction(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.RandomMixture_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.RandomMixture_computeCDFGradient(self, *args)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.RandomMixture_getParametersCollection(self)


    def getWeights(self):
        """
        Return the weights of the combination as a Matrix.

        Returns
        -------
        out : :class:`~openturns.Matrix`
            The element of affine transformation

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # weights
        >>> w = distribution.getWeights()
        >>> print(w)
        [[ 1 ]]
        """
        return _dist_bundle3.RandomMixture_getWeights(self)


    def getPositionIndicator(self):
        """**(ditch me?)**"""
        return _dist_bundle3.RandomMixture_getPositionIndicator(self)


    def getDispersionIndicator(self):
        """**(ditch me?)**"""
        return _dist_bundle3.RandomMixture_getDispersionIndicator(self)


    def setBlockMin(self, blockMin):
        """
        Set the blockMin parameter.

        Parameters
        ----------
        blockMin : int
            Number of minimal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> distribution.setBlockMin(4)
        """
        return _dist_bundle3.RandomMixture_setBlockMin(self, blockMin)


    def getBlockMin(self):
        """
        Return the blockMin parameter.

        Returns
        -------
        blockMin : int
            Number of minimal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # blockMin
        >>> blockMin = distribution.getBlockMin()
        >>> print(blockMin)
        3
        """
        return _dist_bundle3.RandomMixture_getBlockMin(self)


    def setBlockMax(self, blockMax):
        """
        Set the blockMax parameter.

        Returns
        -------
        blockMax : int
            Number of maximal evaluations of blocks for characteristic function
            evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> distribution.setBlockMax(14)
        """
        return _dist_bundle3.RandomMixture_setBlockMax(self, blockMax)


    def getBlockMax(self):
        """
        Return the blockMax parameter.

        Returns
        -------
        blockMax : int
            Number of maximal evaluations of blocks for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # blockMax
        >>> blockMax = distribution.getBlockMax()
        >>> print(blockMax)
        16
        """
        return _dist_bundle3.RandomMixture_getBlockMax(self)


    def setMaxSize(self, maxSize):
        """
        Set the maximum size of cache for characteristic function evaluations.

        Parameters
        ----------
        size : int
            Maximum size of cache for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> size = pow(2,15)
        >>> distribution.setMaxSize(size)
        """
        return _dist_bundle3.RandomMixture_setMaxSize(self, maxSize)


    def getMaxSize(self):
        """
        Return the maximum size of cache for characteristic function evaluations.

        Returns
        -------
        size : int
            Maximum size of cache for characteristic function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # default cache size
        >>> size = distribution.getMaxSize()
        >>> print(size)
        65536
        """
        return _dist_bundle3.RandomMixture_getMaxSize(self)


    def setAlpha(self, alpha):
        """
        Set the a priori range of PDF and CDF arguments in terms of standard deviation.

        Parameters
        ----------
        alpha : float
            A Priori range of PDF/CDF

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> alpha = 8.0
        >>> distribution.setAlpha(alpha)
        """
        return _dist_bundle3.RandomMixture_setAlpha(self, alpha)


    def getAlpha(self):
        """
        Return the priori range of PDF and CDF argument.

        It is expressed in dispersionIndicator units.

        Returns
        -------
        alpha : float
            A Priori range of PDF/CDF

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # alpha
        >>> alpha = distribution.getAlpha()
        >>> print(alpha)
        5.0
        """
        return _dist_bundle3.RandomMixture_getAlpha(self)


    def setBeta(self, beta):
        """
        Set the distance of the a priori range at which the PDF is negligible.

        Parameters
        ----------
        beta : float
            Distance from the boundary of the a priori range

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> beta = 8.0
        >>> distribution.setBeta(beta)
        """
        return _dist_bundle3.RandomMixture_setBeta(self, beta)


    def getBeta(self):
        """
        Return the distance of the a priori range at which the PDF is negligible.

        Returns
        -------
        beta : float
            Distance from the boundary of the a priori range

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # beta
        >>> beta = distribution.getBeta()
        >>> print(beta)
        8.5
        """
        return _dist_bundle3.RandomMixture_getBeta(self)


    def setReferenceBandwidth(self, bandwidth):
        """
        Set the reference bandwidth.

        Parameters
        ----------
        bw : sequence of float
            The reference bandwidth

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> bw = [0.75]
        >>> distribution.setReferenceBandwidth(bw)
        """
        return _dist_bundle3.RandomMixture_setReferenceBandwidth(self, bandwidth)


    def getReferenceBandwidth(self):
        """
        Return the reference bandwidth.

        It is the maximum bandwidth that allows an accurate computation
        of the PDF over the range :math:`[mean \\pm \\beta\\sigma]`.

        Returns
        -------
        out : :class:`~openturns.Point`
            The reference bandwidth

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> # bw
        >>> bw = distribution.getReferenceBandwidth()
        >>> print(bw)
        [0.785398]
        """
        return _dist_bundle3.RandomMixture_getReferenceBandwidth(self)


    def setPDFPrecision(self, pdfPrecision):
        """
        Set the requested precision for PDF computation.

        Parameters
        ----------
        eps : float
            Precision for density evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> eps = 1.e-12
        >>> distribution.setPDFPrecision(eps)
        """
        return _dist_bundle3.RandomMixture_setPDFPrecision(self, pdfPrecision)


    def setCDFPrecision(self, cdfPrecision):
        """
        Set the requested precision for CDF computation.

        Parameters
        ----------
        eps : float
            Precision for cumulative function evaluations

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Uniform(-1.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> eps = 1.e-12
        >>> distribution.setCDFPrecision(eps)
        """
        return _dist_bundle3.RandomMixture_setCDFPrecision(self, cdfPrecision)


    def project(self, *args):
        """
        Project a RandomMixture distribution over a collection of DistributionFactory.

        Uses sampling and Kolmogorov distance.

        Parameters
        ----------
        coll : :class:`~openturns.DistributionFactoryCollection`
            The collection of factories
        kolmogorovNorm: sequence of float
            The Kolmogorov norms
        size : int
            Size of projection

        Returns
        -------
        out : tuple of size 2:
            First element is a collection of :class:`~openturns.Distribution`,
            and second element is a sequence of float containing
            the Kolmogorov norm of the projection over its factory.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.RandomMixture([ot.Normal(0.0, 1.0), ot.Uniform(-1.0, 1.0)])
        >>> coll = [ot.NormalFactory(), ot.UniformFactory()]
        >>> dist, kolmogorovNorm = distribution.project(coll)

        """
        return _dist_bundle3.RandomMixture_project(self, *args)


    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_hasIndependentCopula(self)


    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle3.RandomMixture_hasEllipticalCopula(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.RandomMixture_isElliptical(self)


    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isContinuous(self)


    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isDiscrete(self)


    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.RandomMixture_isIntegral(self)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.RandomMixture_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.RandomMixture_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.RandomMixture_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.RandomMixture_getKurtosis(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_RandomMixture(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_RandomMixture
    __del__ = lambda self: None
RandomMixture_swigregister = _dist_bundle3.RandomMixture_swigregister
RandomMixture_swigregister(RandomMixture)

class Rayleigh(openturns.model_copula.ContinuousDistribution):
    """
    Rayleigh distribution.

    Available constructors:
        Rayleigh(*sigma=1.0, gamma=0.*)

    Parameters
    ----------
    sigma : float, :math:`\\sigma > 0`
        Scale parameter :math:`\\sigma`.
    gamma : float
        Location parameter :math:`\\gamma`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{(x - \\gamma)} {\\sigma^2}
                 exp \\left(-\\frac{(x - \\gamma)^2}{2\\sigma^2}\\right)
                 \\quad x \\in [\\gamma,+\\infty[

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\sigma sqrt{\\frac{\\pi}{2}} + \\gamma \\\\
            \\Var{X} & = & \\frac{4 - \\pi}{2} \\sigma^2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Poisson(10.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Rayleigh, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Rayleigh, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Rayleigh_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Rayleigh___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Rayleigh___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Rayleigh___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Rayleigh_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.Rayleigh_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Rayleigh_computeCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Rayleigh_computeCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Rayleigh_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Rayleigh_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Rayleigh_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Rayleigh_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Rayleigh_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Rayleigh_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Rayleigh_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Rayleigh_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Rayleigh_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Rayleigh_getParameterDescription(self)


    def setSigma(self, sigma):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle3.Rayleigh_setSigma(self, sigma)


    def getSigma(self):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle3.Rayleigh_getSigma(self)


    def setGamma(self, gamma):
        """
        Accessor to the distribution's location parameter :math:`\\gamma`.

        Parameters
        ----------
        gamma : float
            Location parameter :math:`\\gamma`.
        """
        return _dist_bundle3.Rayleigh_setGamma(self, gamma)


    def getGamma(self):
        """
        Accessor to the distribution's location parameter :math:`\\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\\gamma`.
        """
        return _dist_bundle3.Rayleigh_getGamma(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Rayleigh(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Rayleigh
    __del__ = lambda self: None
Rayleigh_swigregister = _dist_bundle3.Rayleigh_swigregister
Rayleigh_swigregister(Rayleigh)

class RayleighFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Rayleigh factory.

    Available constructor:
        RayleighFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RayleighFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RayleighFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RayleighFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.RayleighFactory_build(self, *args)


    def buildAsRayleigh(self, *args):
        return _dist_bundle3.RayleighFactory_buildAsRayleigh(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_RayleighFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_RayleighFactory
    __del__ = lambda self: None
RayleighFactory_swigregister = _dist_bundle3.RayleighFactory_swigregister
RayleighFactory_swigregister(RayleighFactory)

class Rice(openturns.model_copula.ContinuousDistribution):
    """
    Rice distribution.

    Available constructors:
        Rice(*sigma=1.0, nu=0.*)

    Parameters
    ----------
    sigma : float, :math:`\\sigma > 0`
        Scale parameter.
    nu : float, :math:`\\nu \\geq 0`
        Location parameter.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = 2\\frac{x}{\\sigma^2}p_{\\chi^2(2,\\frac{\\nu^2}{\\sigma^2})}
                 \\left(\\frac{x^2}{\\sigma^2}\\right),
                 \\quad x \\in [0; +\\infty[

    where :math:`p_{\\chi^2(\\nu, \\lambda)}` is the probability density function of a
    :class:`~openturns.NonCentralChiSquare` distribution.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\sigma \\sqrt{\\frac{\\pi}{2}}
                             \\mathrm{L}_{1/2}\\left(-\\frac{\\nu^2}{2\\sigma^2}\\right) \\\\
            \\Var{X} & = & 2\\sigma^2 + \\nu^2 - \\frac{\\pi\\sigma^2}{2}
                          \\mathrm{L}_{1/2}^2\\left(\\frac{-\\nu^2}{2\\sigma^2}\\right)
        \\end{eqnarray*}

    where :math:`\\mathrm{L}_q(x)` denotes a Laguerre polynomial.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Rice()

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Rice, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Rice, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Rice_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Rice___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Rice___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Rice___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Rice_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Rice_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.Rice_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Rice_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Rice_computeComplementaryCDF(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Rice_getStandardDeviation(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Rice_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Rice_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Rice_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Rice_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Rice_getParameterDescription(self)


    def setSigma(self, sigma):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle3.Rice_setSigma(self, sigma)


    def getSigma(self):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle3.Rice_getSigma(self)


    def setNu(self, nu):
        """
        Accessor to the distribution's location parameter :math:`\\nu`.

        Parameters
        ----------
        nu : float, :math:`\\nu >= 0`
            Location parameter :math:`\\nu`.
        """
        return _dist_bundle3.Rice_setNu(self, nu)


    def getNu(self):
        """
        Accessor to the distribution's location parameter :math:`\\nu`.

        Returns
        -------
        nu : float
            Location parameter :math:`\\nu`.
        """
        return _dist_bundle3.Rice_getNu(self)


    def setMaximumIteration(self, maximumIteration):
        return _dist_bundle3.Rice_setMaximumIteration(self, maximumIteration)

    def getMaximumIteration(self):
        return _dist_bundle3.Rice_getMaximumIteration(self)

    def __init__(self, *args):
        this = _dist_bundle3.new_Rice(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Rice
    __del__ = lambda self: None
Rice_swigregister = _dist_bundle3.Rice_swigregister
Rice_swigregister(Rice)

class RiceFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Rice factory.

    Available constructor:
        RiceFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RiceFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RiceFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.RiceFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.RiceFactory_build(self, *args)


    def buildAsRice(self, *args):
        return _dist_bundle3.RiceFactory_buildAsRice(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_RiceFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_RiceFactory
    __del__ = lambda self: None
RiceFactory_swigregister = _dist_bundle3.RiceFactory_swigregister
RiceFactory_swigregister(RiceFactory)

class Skellam(openturns.model_copula.DiscreteDistribution):
    """
    Skellam distribution.

    Available constructors:
        Skellam(*lambda1=1.0, lambda2=1.0*)

    Parameters
    ----------
    lambda1 : float, :math:`\\lambda_1 > 0`
        First :class:`~openturns.Poisson` distribution's parameter.

    lambda2 : float, :math:`\\lambda_2 > 0`
        Second :class:`~openturns.Poisson` distribution's parameter.

    Notes
    -----
    The Skellan distribution takes its values in :math:`\\Zset`.
    It is the distribution of :math:`(X_1 - X_2)` for :math:`(X_1, X_2)` independant
    and respectively distributed according to Poisson(:math:`\\lambda_i`).

    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = 2 \\Prob{Y = 2 \\lambda_1},
                       \\quad \\forall k \\in \\Zset

    where Y is distributed according to the :class:`~openturns.NonCentralChiSquare`
    distribution :math:`\\chi^2_{\\nu, \\delta}`, with :math:`\\nu=2(k+1)` and
    :math:`\\delta=2\\lambda_2`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\lambda_1 - \\lambda_2 \\\\
            \\Var{X} & = & \\lambda_1 + \\lambda_2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Skellam(10.0, 5.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Skellam, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Skellam, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Skellam_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Skellam___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Skellam___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Skellam___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Skellam_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Skellam_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Skellam_computeCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Skellam_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Skellam_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Skellam_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.Skellam_computeLogCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle3.Skellam_computeGeneratingFunction(self, z)


    def computeLogGeneratingFunction(self, z):
        """
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input `X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle3.Skellam_computeLogGeneratingFunction(self, z)


    def computeScalarQuantile(self, prob, tail=False):
        """
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : float
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_X(p) = F_X^{-1}(p), \\quad p \\in [0; 1]

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle3.Skellam_computeScalarQuantile(self, prob, tail)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.Skellam_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Skellam_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Skellam_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Skellam_getKurtosis(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Skellam_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Skellam_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Skellam_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Skellam_isElliptical(self)


    def setLambda1Lambda2(self, lambda1, lambda2):
        """
        Accessor to the Poisson distributions' parameters.

        Namely :math:`\\lambda_1` and :math:`\\lambda_2`.

        Parameters
        ----------
        lambda1 : float, :math:`\\lambda_1 >0`
            First Poisson distribution's parameter :math:`\\lambda_1`.
        lambda2 : float, :math:`\\lambda_2 >0`
            Second Poisson distribution's parameter :math:`\\lambda_2`.
        """
        return _dist_bundle3.Skellam_setLambda1Lambda2(self, lambda1, lambda2)


    def setLambda1(self, lambda1):
        """
        Accessor to the first Poisson distribution's parameter :math:`\\lambda_1`.

        Parameters
        ----------
        lambda1 : float, :math:`\\lambda_1 >0`
            First Poisson distribution's parameter :math:`\\lambda_1`.
        """
        return _dist_bundle3.Skellam_setLambda1(self, lambda1)


    def getLambda1(self):
        """
        Accessor to the first Poisson distribution's parameter :math:`\\lambda_1`.

        Returns
        -------
        lambda1 : float
            First Poisson distribution's parameter :math:`\\lambda_1`.
        """
        return _dist_bundle3.Skellam_getLambda1(self)


    def setLambda2(self, lambda2):
        """
        Accessor to the second Poisson distribution's parameter :math:`\\lambda_2`.

        Parameters
        ----------
        lambda2 : float, :math:`\\lambda_2 >0`
            Second Poisson distribution's parameter :math:`\\lambda_2`.
        """
        return _dist_bundle3.Skellam_setLambda2(self, lambda2)


    def getLambda2(self):
        """
        Accessor to the second Poisson distribution's parameter :math:`\\lambda_2`.

        Returns
        -------
        lambda2 : float
            Second Poisson distribution's parameter :math:`\\lambda_2`.
        """
        return _dist_bundle3.Skellam_getLambda2(self)


    def setMaximumIteration(self, maximumIteration):
        return _dist_bundle3.Skellam_setMaximumIteration(self, maximumIteration)

    def getMaximumIteration(self):
        return _dist_bundle3.Skellam_getMaximumIteration(self)

    def __init__(self, *args):
        this = _dist_bundle3.new_Skellam(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Skellam
    __del__ = lambda self: None
Skellam_swigregister = _dist_bundle3.Skellam_swigregister
Skellam_swigregister(Skellam)

class SkellamFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Skellam factory.

    Available constructor:
        SkellamFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle \\Hat{\\lambda_1} & = \\frac{1}{2}(\\Hat{\\sigma}_x + \\Hat{x}_n) \\\\
          \\displaystyle \\Hat{\\lambda_2} & = \\frac{1}{2}(\\Hat{\\sigma}_x - \\Hat{x}_n)
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, Skellam
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SkellamFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SkellamFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.SkellamFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.SkellamFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle3.SkellamFactory_buildEstimator(self, *args)


    def buildAsSkellam(self, *args):
        return _dist_bundle3.SkellamFactory_buildAsSkellam(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_SkellamFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_SkellamFactory
    __del__ = lambda self: None
SkellamFactory_swigregister = _dist_bundle3.SkellamFactory_swigregister
SkellamFactory_swigregister(SkellamFactory)

class Student(openturns.model_copula.EllipticalDistribution):
    """
    Student distribution.

    Available constructors:
        Student(*nu=3.0, d=1*)

        Student(*nu, mu, sigma=1.0*)

        Student(*nu, mu, sigma, R*)

    Parameters
    ----------
    d : int, :math:`d \\geq 1`
        Dimension.
    nu : float, :math:`\\nu > 0`
        Generalised number degrees of freedom.
    mu : float :math:`\\mu`, sequence of float, :math:`\\vect{\\mu} \\in \\Rset^d`, optional
        If :math:`\\nu > 1`: mean.

        If :math:`\\nu = 1`: location parameter.

        Default is :math:`\\vect{\\mu} = (0, \\dots, 0) \\in \\Rset^d`.
    sigma : float :math:`\\sigma`, sequence of float, :math:`\\vect{\\sigma} \\in \\Rset^{*d}_+`, optional
        Scale parameter.

        Default is :math:`\\vect{\\sigma} = (1, \\dots, 1) \\in \\Rset^d`.
    R : :class:`~openturns.CorrelationMatrix` :math:`\\mat{R} \\in \\Rset^d \\times \\Rset^d`, optional
        If :math:`\\nu > 2`: correlation matrix.

        If :math:`\\nu \\leq 2`: generalized correlation matrix.

        Default is :math:`\\mat{R} = I_d \\in \\Rset^d \\times \\Rset^d`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\Gamma \\left(\\frac{\\nu + d}{2}\\right)}
                      {(\\pi \\nu) ^ {\\frac{d}{2}} \\Gamma \\left(\\frac{\\nu}{2}\\right)}
                 \\frac{\\left| \\mathrm{det}(\\mat{R}) \\right| ^ {-1/2}}
                      {\\prod_{k = 1} ^ d \\sigma_k}
                 \\left(1 + \\frac{\\vect{z} ^ t \\mat{R} ^ {-1} \\vect{z}}{\\nu}
                 \\right) ^ {-\\frac{\\nu + d}{2}}, \\quad x \\in \\Rset

    with :math:`\\nu > 0, d \\geq 1, \\mat{R} \\in \\Rset^d \\times \\Rset^d,
    \\sigma_k > 0, k=1, \\dots, d` .

    where :math:`\\vect{z}=\\mat{\\Delta}^{-1}\\left(\\vect{x}-\\vect{\\mu}\\right)`, 
    :math:`\\mat{\\Delta} = \\mat{\\mathrm{diag}}(\\vect{\\sigma})` and :math:`\\Gamma`
    denotes Euler's Gamma function :class:`~openturns.SpecFunc_Gamma`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\vect{\\Expect{X}} & = & \\vect{\\mu} \\quad \\text{ if }\\nu>1\\\\
            \\mat{\\Cov{X}} & = & \\displaystyle \\frac{\\nu}{\\nu-2}
                                \\Tr{\\mat{\\Delta}}\\,\\mat{R}\\,\\mat{\\Delta}
                              \\quad \\text{ if }\\nu>2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Student(5.0, -0.5, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.EllipticalDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Student, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.EllipticalDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Student, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Student_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Student___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Student___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Student___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Student_getRealization(self)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Student_computeCDF(self, *args)


    def computeProbability(self, interval):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle3.Student_computeProbability(self, interval)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Student_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Student_computeCDFGradient(self, *args)


    def computeRadialDistributionCDF(self, radius, tail=False):
        """
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \\leq r^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input `r2`.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \\sqrt{\\sum\\limits_{i=1}^n U_i^2}
        """
        return _dist_bundle3.Student_computeRadialDistributionCDF(self, radius, tail)


    def computeConditionalPDF(self, *args):
        """
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input `Xn`, `Xcond`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle3.Student_computeConditionalPDF(self, *args)


    def computeConditionalCDF(self, *args):
        """
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input `Xn`, `Xcond`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \\mid X_1, \\ldots, X_{n - 1}}(x_n) =
                \\Prob{X_n \\leq x_n \\mid X_1=x_1, \\ldots, X_{n-1}=x_{n-1}},
                \\quad x_n \\in \\supp{X_n}
        """
        return _dist_bundle3.Student_computeConditionalCDF(self, *args)


    def computeConditionalQuantile(self, *args):
        """
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input `p`, `Xcond`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle3.Student_computeConditionalQuantile(self, *args)


    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.Student_getMarginal(self, *args)


    def getMean(self):
        """
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \\vect{\\mu} = \\Tr{\\left(\\Expect{X_i}, \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Student_getMean(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Student_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Student_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Student_getKurtosis(self)


    def getCovariance(self):
        """
        Accessor to the covariance matrix.

        Returns
        -------
        Sigma : :class:`~openturns.CovarianceMatrix`
            Covariance matrix.

        Notes
        -----
        The covariance is the second-order centered moment. It is defined as:

        .. math::

            \\mat{\\Sigma} & = \\Cov{\\vect{X}} \\\\
                         & = \\Expect{\\left(\\vect{X} - \\vect{\\mu}\\right)
                                     \\Tr{\\left(\\vect{X} - \\vect{\\mu}\\right)}}
        """
        return _dist_bundle3.Student_getCovariance(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Student_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Student_getStandardRepresentative(self)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Student_getParametersCollection(self)


    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Student_setParametersCollection(self, *args)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Student_getParameter(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Student_setParameter(self, parameter)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Student_getParameterDescription(self)


    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.Student_hasIndependentCopula(self)


    def setNu(self, nu):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Generalised number degrees of freedom.
        """
        return _dist_bundle3.Student_setNu(self, nu)


    def getNu(self):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom.
        """
        return _dist_bundle3.Student_getNu(self)


    def setMu(self, mu):
        """
        Accessor to the distribution's mean.

        Parameters
        ----------
        mu : float
            Mean.
        """
        return _dist_bundle3.Student_setMu(self, mu)


    def getMu(self):
        """
        Accessor to the distribution's mean.

        Returns
        -------
        mu : float
            Mean.
            Only defined when the dimension is 1
            (else, use the :func:`getMean()` method inherited from the
            EllipticalDistribution class).
        """
        return _dist_bundle3.Student_getMu(self)


    def computeDensityGenerator(self, betaSquare):
        """
        Compute the probability density function of the characteristic generator.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator value at input `X`.

        Notes
        -----
        This is the function :math:`\\phi` such that the probability density function
        rewrites:

        .. math::

            f_{\\vect{X}}(\\vect{x}) =
                \\phi\\left(\\Tr{\\left(\\vect{x} - \\vect{\\mu}\\right)}
                              \\mat{\\Sigma}^{-1}
                              \\left(\\vect{x} - \\vect{\\mu}\\right)
                    \\right),
                \\quad \\vect{x} \\in \\supp{\\vect{X}}

        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle3.Student_computeDensityGenerator(self, betaSquare)


    def computeDensityGeneratorDerivative(self, betaSquare):
        """
        Compute the first-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator first-order derivative value at input `X`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle3.Student_computeDensityGeneratorDerivative(self, betaSquare)


    def computeDensityGeneratorSecondDerivative(self, betaSquare):
        """
        Compute the second-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator second-order derivative value at input `X`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle3.Student_computeDensityGeneratorSecondDerivative(self, betaSquare)


    def __init__(self, *args):
        this = _dist_bundle3.new_Student(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Student
    __del__ = lambda self: None
Student_swigregister = _dist_bundle3.Student_swigregister
Student_swigregister(Student)

class StudentFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Student factory.

    Available constructor:
        StudentFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle \\Hat{\\nu} = 2 + \\frac{2}{(\\Hat{\\sigma}_x)^2 - 1}\\\\
          \\displaystyle \\Hat{\\mu} = \\Hat{\\mu}_x
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, Student
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StudentFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StudentFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.StudentFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.StudentFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle3.StudentFactory_buildEstimator(self, *args)


    def buildAsStudent(self, *args):
        return _dist_bundle3.StudentFactory_buildAsStudent(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_StudentFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_StudentFactory
    __del__ = lambda self: None
StudentFactory_swigregister = _dist_bundle3.StudentFactory_swigregister
StudentFactory_swigregister(StudentFactory)

class Trapezoidal(openturns.model_copula.ContinuousDistribution):
    """
    Trapezoidal distribution.

    Available constructors:
        Trapezoidal(*a=-2.0, b=-1.0, c=1.0, d=2.0*)

    Parameters
    ----------
    a : float, :math:`a < d`
        Lower bound.
    b : float, :math:`a \\leq b < c`
        Level start.
    c : float, :math:`b < c \\leq d`
        Level end.
    d : float, :math:`c \\leq d`
        Upper bound.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\left\\{
                     \\begin{array}{ll}
                     \\displaystyle h \\frac{x - a}{b - a} & a \\leq x < b \\\\
                     \\displaystyle h                     & b \\leq x < c \\\\
                     \\displaystyle h \\frac{d - x}{d - c} & c \\leq x \\leq d \\\\
                     \\end{array}
                 \\right., \\quad x \\in [a, d]

    with: :math:`h=\\frac{2}{d+c-a-b}`

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{h}{6}(d^2 + cd + c^2 - b^2 - ab - a^2)  \\\\
            \\Var{X} & = &  \\frac{h^2}{72}(d^4 + 2cd^3 - 3bd^3 - 3ad^3 ...\\\\
                        & & - 3bcd^2 - 3acd^2 + 4b^2d^2 + 4abd^2 ...\\\\
                        & & + 4a^2d^2 + 2c^3d - 3bc^2d - 3ac^2d ...\\\\
                        & & + 4b^2cd + 4abcd + 4a^2cd - 3b^3d - 3ab^2d ...\\\\
                        & & - 3a^2bd - 3a^3d + c^4 - 3bc^3 - 3ac^3 + 4b^2c^2 ...\\\\
                        & & + 4abc^2 + 4a^2c^2 - 3b^3c - 3ab^2c - 3a^2bc ...\\\\
                        & & - 3a^3c + b^4 + 2ab^3 + 2a^3b + a^4)
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Trapezoidal(1.0, 2.3, 4.5, 5.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Trapezoidal, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Trapezoidal, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Trapezoidal_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Trapezoidal___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Trapezoidal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Trapezoidal___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Trapezoidal_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Trapezoidal_computeCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Trapezoidal_computeCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Trapezoidal_computePDFGradient(self, *args)


    def computeLogPDFGradient(self, *args):
        """
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Trapezoidal_computeLogPDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Trapezoidal_computeCDFGradient(self, *args)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Trapezoidal_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Trapezoidal_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Trapezoidal_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Trapezoidal_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Trapezoidal_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Trapezoidal_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Trapezoidal_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Trapezoidal_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Trapezoidal_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Trapezoidal_isElliptical(self)


    def setA(self, a):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float, :math:`a \\leq b < c \\leq d`
            Lower bound.
        """
        return _dist_bundle3.Trapezoidal_setA(self, a)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Trapezoidal_getA(self)


    def setB(self, b):
        """
        Accessor to the distribution's level start.

        Returns
        -------
        b : float, :math:`a \\leq b < c \\leq d`
            Level start.
        """
        return _dist_bundle3.Trapezoidal_setB(self, b)


    def getB(self):
        """
        Accessor to the distribution's level start.

        Returns
        -------
        b : float
            Level start.
        """
        return _dist_bundle3.Trapezoidal_getB(self)


    def setC(self, c):
        """
        Accessor to the distribution's level end.

        Returns
        -------
        c : float, :math:`a \\leq b < c \\leq d`
            Level end.
        """
        return _dist_bundle3.Trapezoidal_setC(self, c)


    def getC(self):
        """
        Accessor to the distribution's level end.

        Returns
        -------
        c : float
            Level end.
        """
        return _dist_bundle3.Trapezoidal_getC(self)


    def setD(self, d):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        d : float, :math:`a \\leq b < c \\leq d`
            Upper bound.
        """
        return _dist_bundle3.Trapezoidal_setD(self, d)


    def getD(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        d : float
            Upper bound.
        """
        return _dist_bundle3.Trapezoidal_getD(self)


    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.Trapezoidal_getSingularities(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Trapezoidal(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Trapezoidal
    __del__ = lambda self: None
Trapezoidal_swigregister = _dist_bundle3.Trapezoidal_swigregister
Trapezoidal_swigregister(Trapezoidal)

class TrapezoidalFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Trapezoidal factory.

    Available constructor:
        TrapezoidalFactory()

    The parameters are estimated by numerical maximum likelihood estimation.

    See also
    --------
    DistributionFactory, Trapezoidal
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrapezoidalFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrapezoidalFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TrapezoidalFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.TrapezoidalFactory_build(self, *args)


    def buildAsTrapezoidal(self, *args):
        return _dist_bundle3.TrapezoidalFactory_buildAsTrapezoidal(self, *args)

    def getOptimizationAlgorithm(self):
        """
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle3.TrapezoidalFactory_getOptimizationAlgorithm(self)


    def setOptimizationAlgorithm(self, solver):
        """
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle3.TrapezoidalFactory_setOptimizationAlgorithm(self, solver)


    def getOptimizationSolver(self):
        return _dist_bundle3.TrapezoidalFactory_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _dist_bundle3.TrapezoidalFactory_setOptimizationSolver(self, solver)

    def __init__(self, *args):
        this = _dist_bundle3.new_TrapezoidalFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_TrapezoidalFactory
    __del__ = lambda self: None
TrapezoidalFactory_swigregister = _dist_bundle3.TrapezoidalFactory_swigregister
TrapezoidalFactory_swigregister(TrapezoidalFactory)

class Triangular(openturns.model_copula.ContinuousDistribution):
    """
    Triangular distribution.

    Available constructors:
        Triangular(*a=-1.0, m=0.0, b=1.0*)

    Parameters
    ----------
    a : float
        Lower bound.
    m : float, :math:`a \\leq m \\leq b`
        Mode.
    b : float, :math:`a < b`
        Upper bound.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\left\\{
                     \\begin{array}{ll}
                     \\displaystyle \\frac{2(x - a)}{(m - a)(b - a)}
                                   & a \\leq x \\leq m \\\\
                     \\displaystyle \\frac{2(b - x)}{(b - m)(b - a)}
                                   & m \\leq x \\leq b
                     \\end{array}
                 \\right., \\quad x \\in [a, b]

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & =  & \\frac{1}{3}\\,(a+m+b) \\\\
            \\Var{X} & = & \\frac{1}{18} (a^2+b^2+m^2-ab-am-bm)
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Triangular(1.0, 2.5, 4.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Triangular, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Triangular, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Triangular_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Triangular___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Triangular___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Triangular___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Triangular_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Triangular_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Triangular_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Triangular_computeCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Triangular_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.Triangular_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Triangular_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Triangular_computeCDFGradient(self, *args)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Triangular_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Triangular_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Triangular_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Triangular_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Triangular_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Triangular_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Triangular_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Triangular_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Triangular_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Triangular_isElliptical(self)


    def setAMB(self, a, m, b):
        """
        Accessor to the distribution's parameters.

        Parameters
        ----------
        a : float
            Lower bound.
        m : float, :math:`a \\leq m \\leq b`
            Mode.
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle3.Triangular_setAMB(self, a, m, b)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Triangular_getA(self)


    def getM(self):
        """
        Accessor to the distribution's mode.

        Returns
        -------
        m : float
            Mode.
        """
        return _dist_bundle3.Triangular_getM(self)


    def getB(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.Triangular_getB(self)


    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.Triangular_getSingularities(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Triangular(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Triangular
    __del__ = lambda self: None
Triangular_swigregister = _dist_bundle3.Triangular_swigregister
Triangular_swigregister(Triangular)

class TriangularFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Triangular factory.

    Available constructor:
        TriangularFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TriangularFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TriangularFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TriangularFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.TriangularFactory_build(self, *args)


    def buildAsTriangular(self, *args):
        return _dist_bundle3.TriangularFactory_buildAsTriangular(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_TriangularFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_TriangularFactory
    __del__ = lambda self: None
TriangularFactory_swigregister = _dist_bundle3.TriangularFactory_swigregister
TriangularFactory_swigregister(TriangularFactory)

class TruncatedDistribution(openturns.model_copula.DistributionImplementation):
    """
    Truncated distribution.

    Available constructors:
        TruncatedDistribution(*distribution, lowerBound, upperBound, threshold=0.5*)

        TruncatedDistribution(*distribution, bound, side=ot.TruncatedDistribution.LOWER, threshold=0.5*)

        TruncatedDistribution(*distribution, truncationInterval, threshold=0.5*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution to be truncated.
    lowerBound, upperBound : float
        Define a new distribution range :math:`[lowerBound, upperBound]` with
        finite bounds. The upper bound must be strictly greater than the lower
        bound.
    bound : float
        Scalar used when one of the bounds of the distribution is not finite.

        If *side = ot.TruncatedDistribution.LOWER*: the interval
        :math:`[bound, +\\infty)` is used to bound the distribution.

        If *side = ot.TruncatedDistribution.UPPER*: the interval
        :math:`(-\\infty, bound]` is used to bound the distribution.
    side : int, optional
        Integer used when one of the bounds of the distribution is not finite.
        (Amongst ot.TruncatedDistribution.LOWER and ot.TruncatedDistribution.UPPER).
    truncationInterval : :class:`~openturns.Interval`
        Define a new distribution range :math:`[lowerBound, upperBound]` with
        finite bounds.
    threshold : float, :math:`\\tau \\in [0, 1]`
        This threshold is used when generating an evaluation of the distribution.
        We note :math:`F` the CDF of the non truncated distribution:

        If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

        If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection.

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.TruncatedDistribution(ot.Normal(2.0, 1.5), 1.0, 4.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TruncatedDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TruncatedDistribution, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TruncatedDistribution_getClassName(self)

    LOWER = _dist_bundle3.TruncatedDistribution_LOWER
    UPPER = _dist_bundle3.TruncatedDistribution_UPPER

    def __eq__(self, *args):
        return _dist_bundle3.TruncatedDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.TruncatedDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.TruncatedDistribution___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.TruncatedDistribution_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedDistribution_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedDistribution_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedDistribution_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.TruncatedDistribution_computeComplementaryCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.TruncatedDistribution_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.TruncatedDistribution_computeCDFGradient(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.TruncatedDistribution_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.TruncatedDistribution_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.TruncatedDistribution_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.TruncatedDistribution_isElliptical(self)


    def setDistribution(self, distribution):
        """
        Set the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The distribution to be truncated.
        """
        return _dist_bundle3.TruncatedDistribution_setDistribution(self, distribution)


    def getDistribution(self):
        """
        Get the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The distribution to be truncated.
        """
        return _dist_bundle3.TruncatedDistribution_getDistribution(self)


    def setLowerBound(self, lowerBound):
        """
        Set the lower bound.

        Parameters
        ----------
        lowerBound : float
            Lower bound. The upper bound must be strictly greater than the lower bound. 
        """
        return _dist_bundle3.TruncatedDistribution_setLowerBound(self, lowerBound)


    def getLowerBound(self):
        """
        Get the lower bound.

        Returns
        -------
        lowerBound : float
            Lower bound.
        """
        return _dist_bundle3.TruncatedDistribution_getLowerBound(self)


    def setFiniteLowerBound(self, finiteLowerBound):
        """
        Set the finite lower bound flag.

        Parameters
        ----------
        isLowerBoundFinite : bool
            Flag telling if the lower bound is finite or not.
        """
        return _dist_bundle3.TruncatedDistribution_setFiniteLowerBound(self, finiteLowerBound)


    def getFiniteLowerBound(self):
        """
        Get the finite lower bound flag.

        Returns
        -------
        isLowerBoundFinite : bool
            Flag telling if the lower bound is finite or not.
        """
        return _dist_bundle3.TruncatedDistribution_getFiniteLowerBound(self)


    def setUpperBound(self, upperBound):
        """
        Set the upper bound.

        Parameters
        ----------
        upperBound : float
            Upper bound. The upper bound must be strictly greater than the lower bound.
        """
        return _dist_bundle3.TruncatedDistribution_setUpperBound(self, upperBound)


    def getUpperBound(self):
        """
        Get the upper bound.

        Returns
        -------
        upperBound : float
            Upper bound.
        """
        return _dist_bundle3.TruncatedDistribution_getUpperBound(self)


    def setFiniteUpperBound(self, finiteUpperBound):
        """
        Set the finite upper bound flag.

        Parameters
        ----------
        isUpperBoundFinite : bool
            Flag telling if the upper bound is finite or not.
        """
        return _dist_bundle3.TruncatedDistribution_setFiniteUpperBound(self, finiteUpperBound)


    def getFiniteUpperBound(self):
        """
        Get the finite upper bound flag.

        Returns
        -------
        isUpperBoundFinite : bool
            Flag telling if the upper bound is finite or not.
        """
        return _dist_bundle3.TruncatedDistribution_getFiniteUpperBound(self)


    def setThresholdRealization(self, thresholdRealization):
        """
        Set the threshold used when generating an evaluation of the distribution.

        Parameters
        ----------
        threshold : float, :math:`\\tau \\in [0, 1]`
            This threshold is used when generating an evaluation of the distribution.
            We note :math:`F` the CDF of the non truncated distribution:

            If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

            If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection.
        """
        return _dist_bundle3.TruncatedDistribution_setThresholdRealization(self, thresholdRealization)


    def getThresholdRealization(self):
        """
        Get the threshold used when generating an evaluation of the distribution.

        Returns
        -------
        threshold : float, :math:`\\tau \\in [0, 1]`
            This threshold is used when generating an evaluation of the distribution.
            We note :math:`F` the CDF of the non truncated distribution:

            If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

            If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection.
        """
        return _dist_bundle3.TruncatedDistribution_getThresholdRealization(self)


    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.TruncatedDistribution_isContinuous(self)


    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.TruncatedDistribution_isDiscrete(self)


    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.TruncatedDistribution_isIntegral(self)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.TruncatedDistribution_getSupport(self, *args)


    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle3.TruncatedDistribution_getSingularities(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_TruncatedDistribution(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_TruncatedDistribution
    __del__ = lambda self: None
TruncatedDistribution_swigregister = _dist_bundle3.TruncatedDistribution_swigregister
TruncatedDistribution_swigregister(TruncatedDistribution)

class TruncatedNormal(openturns.model_copula.ContinuousDistribution):
    """
    TruncatedNormal distribution.

    Available constructors:
        TruncatedNormal(*mu=0.0, sigma=1.0, a=-1.0, b=1.0*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float, :math:`\\sigma > 0`
        Standard deviation.
    a : float
        Lower bound.
    b : float, :math:`a < b`
        Upper bound.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{\\sigma}
                 \\frac{ \\phi \\left(\\frac{x - \\mu}{\\sigma}\\right)}
                      { \\Phi \\left(\\frac{b - \\mu}{\\sigma}\\right)
                      - \\Phi \\left(\\frac{a - \\mu}{\\sigma}\\right)},
                 \\quad x \\in [a; b]

    where :math:`\\phi` and :math:`\\Phi` are, respectively, the probability density
    distribution function and the cumulative distribution function of a standard
    normal distribution.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\mu + \\frac{\\phi(\\frac{a - \\mu}{\\sigma})
                                       - \\phi(\\frac{b - \\mu}{\\sigma})}
                                        {\\Phi(\\frac{b - \\mu}{\\sigma})
                                       - \\Phi(\\frac{a - \\mu}{\\sigma})}\\sigma \\\\
            \\Var{X} & = & \\sigma
                      \\left[1
                        +\\frac{\\frac{a - \\mu}{\\sigma} \\phi(\\frac{a - \\mu}{\\sigma})
                             - \\frac{b - \\mu}{\\sigma} \\phi(\\frac{b - \\mu}{\\sigma})}
                              {\\Phi(\\frac{b - \\mu}{\\sigma})
                             - \\Phi(\\frac{a - \\mu}{\\sigma})}
                        -\\left(
                         \\frac{\\phi(\\frac{a - \\mu}{\\sigma})
                             - \\phi(\\frac{b - \\mu}{\\sigma})}
                              {\\Phi(\\frac{b - \\mu}{\\sigma})
                             - \\Phi(\\frac{a - \\mu}{\\sigma})}
                          \\right)^2
                      \\right]^\\frac{1}{2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.TruncatedNormal(0.5, 3.0, -2.0, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TruncatedNormal, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TruncatedNormal, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TruncatedNormal_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.TruncatedNormal___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.TruncatedNormal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.TruncatedNormal___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.TruncatedNormal_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.TruncatedNormal_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.TruncatedNormal_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.TruncatedNormal_computeComplementaryCDF(self, *args)


    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        """
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)

        """
        return _dist_bundle3.TruncatedNormal_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.TruncatedNormal_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.TruncatedNormal_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle3.TruncatedNormal_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.TruncatedNormal_computePDFGradient(self, *args)


    def computeLogPDFGradient(self, *args):
        """
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.TruncatedNormal_computeLogPDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.TruncatedNormal_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.TruncatedNormal_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.TruncatedNormal_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.TruncatedNormal_getKurtosis(self)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.TruncatedNormal_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.TruncatedNormal_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.TruncatedNormal_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.TruncatedNormal_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.TruncatedNormal_isElliptical(self)


    def setMu(self, mu):
        """
        Accessor to the distribution's mean.

        Parameters
        ----------
        mu : float
            Mean.
        """
        return _dist_bundle3.TruncatedNormal_setMu(self, mu)


    def getMu(self):
        """
        Accessor to the distribution's mean.

        Returns
        -------
        mu : float
            Mean.
        """
        return _dist_bundle3.TruncatedNormal_getMu(self)


    def setSigma(self, sigma):
        """
        Accessor to the distribution's standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Standard deviation.
        """
        return _dist_bundle3.TruncatedNormal_setSigma(self, sigma)


    def getSigma(self):
        """
        Accessor to the distribution's standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation.
        """
        return _dist_bundle3.TruncatedNormal_getSigma(self)


    def setA(self, a):
        """
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle3.TruncatedNormal_setA(self, a)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.TruncatedNormal_getA(self)


    def setB(self, b):
        """
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`b > a`
            Upper bound.
        """
        return _dist_bundle3.TruncatedNormal_setB(self, b)


    def getB(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.TruncatedNormal_getB(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_TruncatedNormal(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_TruncatedNormal
    __del__ = lambda self: None
TruncatedNormal_swigregister = _dist_bundle3.TruncatedNormal_swigregister
TruncatedNormal_swigregister(TruncatedNormal)

class TruncatedNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Truncated Normal factory.

    Available constructor:
        TruncatedNormalFactory()

    The parameters are estimated by numerical maximum likelihood estimation.

    See also
    --------
    DistributionFactory, TruncatedNormal
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TruncatedNormalFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TruncatedNormalFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.TruncatedNormalFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.TruncatedNormalFactory_build(self, *args)


    def buildAsTruncatedNormal(self, *args):
        return _dist_bundle3.TruncatedNormalFactory_buildAsTruncatedNormal(self, *args)

    def getOptimizationAlgorithm(self):
        return _dist_bundle3.TruncatedNormalFactory_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        return _dist_bundle3.TruncatedNormalFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationSolver(self):
        return _dist_bundle3.TruncatedNormalFactory_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _dist_bundle3.TruncatedNormalFactory_setOptimizationSolver(self, solver)

    def __init__(self, *args):
        this = _dist_bundle3.new_TruncatedNormalFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_TruncatedNormalFactory
    __del__ = lambda self: None
TruncatedNormalFactory_swigregister = _dist_bundle3.TruncatedNormalFactory_swigregister
TruncatedNormalFactory_swigregister(TruncatedNormalFactory)

class Uniform(openturns.model_copula.ContinuousDistribution):
    """
    Uniform distribution.

    Available constructors:
        Uniform(*a=-1.0, b=1.0*)

    Parameters
    ----------
    a : float
        Lower bound.
    b : float, :math:`b > a`
        Upper bound.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{b-a}, \\quad x \\in [a; b]

    with :math:`a < b`.

    Its first moments are defined as:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{a+b}{2} \\\\
            \\Var{X} & = & \\frac{(b-a)^2}{12}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Uniform(2.0, 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Uniform, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Uniform, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Uniform_getClassName(self)


    def __eq__(self, *args):
        return _dist_bundle3.Uniform___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.Uniform___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Uniform___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Uniform_getRealization(self)


    def getSample(self, size):
        """
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator
        """
        return _dist_bundle3.Uniform_getSample(self, size)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Uniform_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Uniform_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Uniform_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Uniform_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Uniform_computeCharacteristicFunction(self, x)


    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        """
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)

        """
        return _dist_bundle3.Uniform_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)


    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        """
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the bilateral confidence interval at level 0.9 with marginal probability:

        >>> confInt, marginalProb = paramDist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _dist_bundle3.Uniform_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle3.Uniform_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Uniform_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Uniform_computeCDFGradient(self, *args)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle3.Uniform_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Uniform_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Uniform_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Uniform_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Uniform_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Uniform_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Uniform_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Uniform_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Uniform_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.Uniform_isElliptical(self)


    def setA(self, a):
        """
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle3.Uniform_setA(self, a)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle3.Uniform_getA(self)


    def setB(self, b):
        """
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle3.Uniform_setB(self, b)


    def getB(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle3.Uniform_getB(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Uniform(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Uniform
    __del__ = lambda self: None
Uniform_swigregister = _dist_bundle3.Uniform_swigregister
Uniform_swigregister(Uniform)

class UniformFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Uniform factory.

    Available constructor:
        UniformFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniformFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniformFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UniformFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.UniformFactory_build(self, *args)


    def buildAsUniform(self, *args):
        return _dist_bundle3.UniformFactory_buildAsUniform(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_UniformFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_UniformFactory
    __del__ = lambda self: None
UniformFactory_swigregister = _dist_bundle3.UniformFactory_swigregister
UniformFactory_swigregister(UniformFactory)

class UserDefined(openturns.model_copula.DiscreteDistribution):
    """
    UserDefined distribution.

    Available constructors:
        UserDefined(*points*)

        UserDefined(*points, weights*)

    Parameters
    ----------
    points : 2-d sequence of float
        `n` lists of `d` points :math:`x_{ij}, i = 1, \\ldots, n, j = 1, \\ldots, d`.
    weights : sequence of float
        List of `n` weights :math:`p_i, i = 1, \\ldots, n`.
        If not :math:`\\sum_1^n  p_i = 1.0`, the weights are normalized.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = x_{ij}} = p_i, \\quad i = 1,\\ldots,n

    where :math:`j =1, \\ldots, d`, `d` the distribution's dimension and
    `n` the size of the multivariate d-dimensional distribution.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X_j} & = & \\Tr{(\\sum_{i=1}^n x_i p_i)}\\\\
            \\Var{X_j} & = & \\Expect{X_j} - (\\Expect{X_j})^2
        \\end{eqnarray*}

    with :math:`j =1, \\ldots, d` and `d` the distribution's dimension.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> points = ot.Sample(4, 3)
    >>> for i in range(4):
    ...     for j in range(3):
    ...         points[i, j] = 10 * (i + 1) + 0.1 * (j + 1)

    >>> distribution = ot.UserDefined(points, [0.3,0.2,0.25,0.25])
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserDefined, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserDefined, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UserDefined_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.UserDefined___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.UserDefined___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.UserDefined___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.UserDefined_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.UserDefined_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.UserDefined_computeCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.UserDefined_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.UserDefined_computeCDFGradient(self, *args)


    def computeRange(self):
        return _dist_bundle3.UserDefined_computeRange(self)

    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.UserDefined_getSupport(self, *args)


    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.UserDefined_isIntegral(self)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.UserDefined_getParametersCollection(self)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.UserDefined_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.UserDefined_getParameterDescription(self)


    def setData(self, points, weights):
        """
        Accessor to the distribution's :math:`x` and :math:`p` parameters.

        Parameters
        ----------
        points : :class:`~openturns.Sample`
            Collection of points
        weights : :class:`~openturns.Point`
            Associated weights
        """
        return _dist_bundle3.UserDefined_setData(self, points, weights)


    def getX(self):
        """
        Accessor to the distribution's :math:`x` parameter.

        Returns
        -------
        coll : :class:`~openturns.Sample`
            Collection of points.
        """
        return _dist_bundle3.UserDefined_getX(self)


    def getP(self):
        """
        Accessor to the distribution's :math:`p` parameter.

        Returns
        -------
        coll : :class:`~openturns.Point`
            Collection of weights.
        """
        return _dist_bundle3.UserDefined_getP(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle3.UserDefined_getMarginal(self, *args)


    def compactSupport(self, *args):
        """
        Compact the support of the distribution.

        Compact by concatenating points of distance less than :math:`\\varepsilon`
        and adding their weights.

        Notes
        -----
        The :math:`\\varepsilon` has a default value stored in the ResourceMap: to
        change the default value the new value :math:`1.3e-3`, use the command:

        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsScalar('DiscreteDistribution-SupportEpsilon', 1e-3)

        The method is always used for any univariate distributions and for upper
        dimensions, it is only used when the number of points defining the support is
        less than a limit specified in the ResourceMap in the key
        'UserDefined-SmallSize'. By default, the size limit is equal to :math:`1e4`.

        """
        return _dist_bundle3.UserDefined_compactSupport(self, *args)


    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle3.UserDefined_hasEllipticalCopula(self)


    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle3.UserDefined_hasIndependentCopula(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_UserDefined(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_UserDefined
    __del__ = lambda self: None
UserDefined_swigregister = _dist_bundle3.UserDefined_swigregister
UserDefined_swigregister(UserDefined)

class UserDefinedFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    UserDefined factory.

    Available constructor:
        UserDefinedFactory()

    See also
    --------
    DistributionFactory, UserDefined
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserDefinedFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserDefinedFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.UserDefinedFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.UserDefinedFactory_build(self, *args)


    def buildAsUserDefined(self, *args):
        return _dist_bundle3.UserDefinedFactory_buildAsUserDefined(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_UserDefinedFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_UserDefinedFactory
    __del__ = lambda self: None
UserDefinedFactory_swigregister = _dist_bundle3.UserDefinedFactory_swigregister
UserDefinedFactory_swigregister(UserDefinedFactory)

class VonMises(openturns.model_copula.ContinuousDistribution):
    """
    von Mises distribution.

    Available constructors:
        VonMises(*mu=0.0, kappa=1.0*)

    Parameters
    ----------
    mu : float
        Location parameter
    kappa : float, :math:`\\kappa > 0`
        Concentration parameter

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{e^{\\kappa\\cos(x-\\mu)}}
                      {2\\pi \\mathrm{I}_0(\\kappa)}, \\quad x \\in [-\\pi, \\pi]

    with :math:`\\kappa > 0` and :math:`\\mathrm{I}_0` the modified Bessel function of order 0.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.VonMises(1.0, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VonMises, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, VonMises, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.VonMises_getClassName(self)


    def __eq__(self, *args):
        return _dist_bundle3.VonMises___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.VonMises___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.VonMises___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.VonMises_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.VonMises_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.VonMises_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.VonMises_computeLogPDF(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.VonMises_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.VonMises_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.VonMises_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.VonMises_isElliptical(self)


    def setMu(self, mu):
        """
        Accessor to the location parameter.

        Parameters
        ----------
        mu : float
            Location parameter.
        """
        return _dist_bundle3.VonMises_setMu(self, mu)


    def getMu(self):
        """
        Accessor to the location parameter.

        Returns
        -------
        mu : float
            Location parameter.
        """
        return _dist_bundle3.VonMises_getMu(self)


    def setKappa(self, kappa):
        """
        Accessor to the concentration parameter.

        Parameters
        ----------
        kappa : float, :math:`\\kappa > 0`
            Concentration parameter.
        """
        return _dist_bundle3.VonMises_setKappa(self, kappa)


    def getKappa(self):
        """
        Accessor to the concentration parameter.

        Returns
        -------
        kappa : float
            Concentration parameter.
        """
        return _dist_bundle3.VonMises_getKappa(self)


    def getCircularMean(self):
        return _dist_bundle3.VonMises_getCircularMean(self)

    def getCircularVariance(self):
        return _dist_bundle3.VonMises_getCircularVariance(self)

    def __init__(self, *args):
        this = _dist_bundle3.new_VonMises(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_VonMises
    __del__ = lambda self: None
VonMises_swigregister = _dist_bundle3.VonMises_swigregister
VonMises_swigregister(VonMises)

class Weibull(openturns.model_copula.ContinuousDistribution):
    """
    Weibull distribution.

    Available constructors:
        Weibull(*alpha=1.0, beta=1.0, gamma=0.0*)

    Parameters
    ----------
    alpha : float
        scale parameter :math:`\\alpha > 0`.
    beta : float
        shape parameter :math:`\\beta > 0`.
    gamma : float, optional
        Location parameter :math:`\\gamma < \\mu`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\beta}{\\alpha}
                 \\left(\\frac{x - \\gamma}{\\alpha} \\right) ^ {\\beta-1}
                 exp \\left(-\\left(\\frac{x - \\gamma}{\\alpha}\\right)^{\\beta}\\right),
                 \\quad x \\in [\\gamma; +\\infty[

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\alpha \\,\\Gamma\\left(1 + \\frac{1}{\\beta}\\right)
                           + \\gamma \\\\
            \\Var{X} & = & \\alpha^2 \\Gamma\\left(1 + \\frac{2}{\\beta}\\right) -
                         \\Gamma^2 \\left(1 + \\frac{1}{\\beta}\\right)
        \\end{eqnarray*}

    where :math:`\\Gamma` denotes Euler's Gamma function
    :class:`~openturns.SpecFunc_Gamma`.

    It is possible to create a Weibull distribution from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`: see  :class:`~openturns.WeibullMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\\mu, \\sigma, \\gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\\alpha, \\beta, \\gamma)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(\\alpha, \\beta, \\gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.Weibull(2.0, 1.5, 1.0)

    Create a it from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`:

    >>> myDist2 = ot.Weibull()
    >>> myDist2.setParameter(ot.WeibullMuSigma()([2.8, 1.2, 1.0]))

    Create it from :math:`(\\mu, \\sigma,\\gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.WeibullMuSigma(2.8, 1.2, 1.0)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Weibull, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Weibull, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Weibull_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Weibull___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Weibull___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Weibull___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Weibull_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Weibull_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Weibull_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.Weibull_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Weibull_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle3.Weibull_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle3.Weibull_computeCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Weibull_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle3.Weibull_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Weibull_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Weibull_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.Weibull_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle3.Weibull_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle3.Weibull_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Weibull_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Weibull_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Weibull_getParameterDescription(self)


    def setBeta(self, beta):
        """
        Accessor to the distribution's shape parameter :math:`\\beta`.

        Parameters
        ----------
        beta : float, :math:`\\beta > 0`
            Shape parameter :math:`\\beta`.
        """
        return _dist_bundle3.Weibull_setBeta(self, beta)


    def getBeta(self):
        """
        Accessor to the distribution's shape parameter :math:`\\beta`.

        Returns
        -------
        beta : float
            Shape parameter :math:`\\beta`.
        """
        return _dist_bundle3.Weibull_getBeta(self)


    def setAlpha(self, alpha):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\\alpha > 0`
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle3.Weibull_setAlpha(self, alpha)


    def getAlpha(self):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Returns
        -------
        alpha : float
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle3.Weibull_getAlpha(self)


    def setGamma(self, gamma):
        """
        Accessor to the distribution's location parameter :math:`\\gamma`.

        Parameters
        ----------
        gamma : float
            Location parameter :math:`\\gamma`.
        """
        return _dist_bundle3.Weibull_setGamma(self, gamma)


    def getGamma(self):
        """
        Accessor to the distribution's shift parameter :math:`\\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\\gamma`.
        """
        return _dist_bundle3.Weibull_getGamma(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Weibull(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Weibull
    __del__ = lambda self: None
Weibull_swigregister = _dist_bundle3.Weibull_swigregister
Weibull_swigregister(Weibull)

class WeibullFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Weibull factory.

    Available constructor:
        WeibullFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeibullFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeibullFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.WeibullFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle3.WeibullFactory_build(self, *args)


    def buildAsWeibull(self, *args):
        return _dist_bundle3.WeibullFactory_buildAsWeibull(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_WeibullFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_WeibullFactory
    __del__ = lambda self: None
WeibullFactory_swigregister = _dist_bundle3.WeibullFactory_swigregister
WeibullFactory_swigregister(WeibullFactory)

class WeibullMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    Weibull distribution parameters.

    Available constructors:
        WeibullMuSigma(*mu=1.0, sigma=1.0, gamma=0.*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.
    gamma : float, optional
        Shift parameter :math:`\\gamma > \\mu`.

    Notes
    -----
    The native parameters :math:`\\alpha` and :math:`\\beta` are searched such as:

    .. math::

        \\alpha &= \\frac{\\mu - \\gamma}{\\Gamma(1+\\frac{1}{\\beta})} \\\\
        \\sigma^2 &= \\alpha^2 \\Gamma\\left(1 + \\frac{2}{\\beta}\\right) -
                       \\Gamma^2 \\left(1 + \\frac{1}{\\beta}\\right)

    See also
    --------
    Weibull

    Examples
    --------
    Create the parameters of the Weibull distribution:

    >>> import openturns as ot
    >>> parameters = ot.WeibullMuSigma(1.3, 1.23, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [1.99222,1.48961,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  1.25624   0.897176  0        ]
     [ -0.218715 -1.31294   0        ]
     [ -1.25624  -0.897176  1        ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeibullMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeibullMuSigma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.WeibullMuSigma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.WeibullMuSigma___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle3.WeibullMuSigma_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle3.WeibullMuSigma_gradient(self)


    def __call__(self, inP):
        return _dist_bundle3.WeibullMuSigma___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle3.WeibullMuSigma_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle3.WeibullMuSigma_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle3.WeibullMuSigma_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle3.WeibullMuSigma_getDescription(self)


    def __repr__(self):
        return _dist_bundle3.WeibullMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.WeibullMuSigma___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle3.new_WeibullMuSigma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_WeibullMuSigma
    __del__ = lambda self: None
WeibullMuSigma_swigregister = _dist_bundle3.WeibullMuSigma_swigregister
WeibullMuSigma_swigregister(WeibullMuSigma)

class Wishart(openturns.model_copula.ContinuousDistribution):
    """
    Wishart distribution.

    Parameters
    ----------
    v : 2-d sequence of float
        Scale matrix, positive definite of size :math:`p`.
    nu : float, :math:`\\nu > p - 1`
        Degrees of freedom.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Wishart(ot.CovarianceMatrix([[1.0]]), 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Wishart, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Wishart, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.Wishart_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle3.Wishart___eq__(self, other)

    def __repr__(self):
        return _dist_bundle3.Wishart___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.Wishart___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.Wishart_getRealization(self)


    def getRealizationAsMatrix(self):
        """
        Get one realization of the distribution as a covariance matrix.

        Returns
        -------
        v : :class:`~openturns.CovarianceMatrix`
            A realization as a matrix
        """
        return _dist_bundle3.Wishart_getRealizationAsMatrix(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Wishart_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle3.Wishart_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.Wishart_computeCDF(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.Wishart_getStandardDeviation(self)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Wishart_getParametersCollection(self)


    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle3.Wishart_setParametersCollection(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.Wishart_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.Wishart_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.Wishart_getParameterDescription(self)


    def setV(self, v):
        """
        Accessor to the scale parameter.

        Parameters
        ----------
        v : 2-d sequence of float
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle3.Wishart_setV(self, v)


    def getV(self):
        """
        Accessor to the scale parameter.

        Returns
        -------
        v : :class:`~openturns.CovarianceMatrix`
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle3.Wishart_getV(self)


    def setNu(self, nu):
        """
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle3.Wishart_setNu(self, nu)


    def getNu(self):
        """
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle3.Wishart_getNu(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_Wishart(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_Wishart
    __del__ = lambda self: None
Wishart_swigregister = _dist_bundle3.Wishart_swigregister
Wishart_swigregister(Wishart)

class ZipfMandelbrot(openturns.model_copula.DiscreteDistribution):
    """
    ZipfMandelbrot distribution.

    Available constructors:
        ZipfMandelbrot(*N=1.0, q=0., s=1.0*)

    Parameters
    ----------
    N : int, :math:`N > 0`
    q : float, :math:`q \\geq 0`
    s : float, :math:`s > 0`

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = \\frac{1}{(k+q)^s \\mathrm{H}(N,q,s)},
                       \\quad \\forall k \\in [1, N]

    where :math:`\\mathrm{H}(N,q,s)` is the Generalized Harmonic Number:
    :math:`\\mathrm{H}(N,q,s) = \\sum_{i=1}^{N} \\frac{1}{(i+q)^s}`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & =  & \\frac{\\mathrm{H}_{N,q,s-1}}{\\mathrm{H}_{N,q,s}}-q \\\\
            \\Var{X} & = & \\frac{\\displaystyle \\sum_{i=1}^N
                                    \\frac{(i - \\Expect{X})^2}{(i+q)^s}}{\\mathrm{H}_{N,q,s}}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.ZipfMandelbrot(15, 1.2, 2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ZipfMandelbrot, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ZipfMandelbrot, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle3.ZipfMandelbrot_getClassName(self)


    def __eq__(self, *args):
        return _dist_bundle3.ZipfMandelbrot___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle3.ZipfMandelbrot___repr__(self)

    def __str__(self, *args):
        return _dist_bundle3.ZipfMandelbrot___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle3.ZipfMandelbrot_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ZipfMandelbrot_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle3.ZipfMandelbrot_computeCDF(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle3.ZipfMandelbrot_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.ZipfMandelbrot_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle3.ZipfMandelbrot_getKurtosis(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle3.ZipfMandelbrot_isElliptical(self)


    def setQ(self, q):
        """
        Accessor to the parameter :math:`q`.

        Parameters
        ----------
        q : float, :math:`q >= 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setQ(self, q)


    def getQ(self):
        """
        Accessor to the parameter :math:`q`.

        Returns
        -------
        q : float
        """
        return _dist_bundle3.ZipfMandelbrot_getQ(self)


    def setS(self, s):
        """
        Accessor to the parameter :math:`s`.

        Parameters
        ----------
        s : float, :math:`s > 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setS(self, s)


    def getS(self):
        """
        Accessor to the parameter :math:`s`.

        Returns
        -------
        s : float
        """
        return _dist_bundle3.ZipfMandelbrot_getS(self)


    def setN(self, n):
        """
        Accessor to the parameter :math:`N`.

        Parameters
        ----------
        N : int, :math:`N > 0`
        """
        return _dist_bundle3.ZipfMandelbrot_setN(self, n)


    def getN(self):
        """
        Accessor to the parameter :math:`N`.

        Returns
        -------
        N : int
        """
        return _dist_bundle3.ZipfMandelbrot_getN(self)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle3.ZipfMandelbrot_getSupport(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle3.ZipfMandelbrot_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle3.ZipfMandelbrot_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle3.ZipfMandelbrot_getParameterDescription(self)


    def __init__(self, *args):
        this = _dist_bundle3.new_ZipfMandelbrot(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle3.delete_ZipfMandelbrot
    __del__ = lambda self: None
ZipfMandelbrot_swigregister = _dist_bundle3.ZipfMandelbrot_swigregister
ZipfMandelbrot_swigregister(ZipfMandelbrot)

# This file is compatible with both classic and new-style classes.


