# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Probabilistic distributions."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_dist_bundle1')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_dist_bundle1')
    _dist_bundle1 = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_dist_bundle1', [dirname(__file__)])
        except ImportError:
            import _dist_bundle1
            return _dist_bundle1
        try:
            _mod = imp.load_module('_dist_bundle1', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _dist_bundle1 = swig_import_helper()
    del swig_import_helper
else:
    import _dist_bundle1
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle1.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _dist_bundle1.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _dist_bundle1.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _dist_bundle1.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _dist_bundle1.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _dist_bundle1.SwigPyIterator_equal(self, x)

    def copy(self):
        return _dist_bundle1.SwigPyIterator_copy(self)

    def next(self):
        return _dist_bundle1.SwigPyIterator_next(self)

    def __next__(self):
        return _dist_bundle1.SwigPyIterator___next__(self)

    def previous(self):
        return _dist_bundle1.SwigPyIterator_previous(self)

    def advance(self, n):
        return _dist_bundle1.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _dist_bundle1.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _dist_bundle1.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _dist_bundle1.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _dist_bundle1.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _dist_bundle1.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _dist_bundle1.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _dist_bundle1.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _dist_bundle1.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class DistFunc(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistFunc, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DistFunc, name)
    __repr__ = _swig_repr
    if _newclass:
        pBeta = staticmethod(_dist_bundle1.DistFunc_pBeta)
    else:
        pBeta = _dist_bundle1.DistFunc_pBeta
    if _newclass:
        qBeta = staticmethod(_dist_bundle1.DistFunc_qBeta)
    else:
        qBeta = _dist_bundle1.DistFunc_qBeta
    if _newclass:
        rBeta = staticmethod(_dist_bundle1.DistFunc_rBeta)
    else:
        rBeta = _dist_bundle1.DistFunc_rBeta
    if _newclass:
        rBinomial = staticmethod(_dist_bundle1.DistFunc_rBinomial)
    else:
        rBinomial = _dist_bundle1.DistFunc_rBinomial
    if _newclass:
        pGamma = staticmethod(_dist_bundle1.DistFunc_pGamma)
    else:
        pGamma = _dist_bundle1.DistFunc_pGamma
    if _newclass:
        qGamma = staticmethod(_dist_bundle1.DistFunc_qGamma)
    else:
        qGamma = _dist_bundle1.DistFunc_qGamma
    if _newclass:
        rGamma = staticmethod(_dist_bundle1.DistFunc_rGamma)
    else:
        rGamma = _dist_bundle1.DistFunc_rGamma
    if _newclass:
        pKolmogorov = staticmethod(_dist_bundle1.DistFunc_pKolmogorov)
    else:
        pKolmogorov = _dist_bundle1.DistFunc_pKolmogorov
    if _newclass:
        dNonCentralChiSquare = staticmethod(_dist_bundle1.DistFunc_dNonCentralChiSquare)
    else:
        dNonCentralChiSquare = _dist_bundle1.DistFunc_dNonCentralChiSquare
    if _newclass:
        pNonCentralChiSquare = staticmethod(_dist_bundle1.DistFunc_pNonCentralChiSquare)
    else:
        pNonCentralChiSquare = _dist_bundle1.DistFunc_pNonCentralChiSquare
    if _newclass:
        rNonCentralChiSquare = staticmethod(_dist_bundle1.DistFunc_rNonCentralChiSquare)
    else:
        rNonCentralChiSquare = _dist_bundle1.DistFunc_rNonCentralChiSquare
    if _newclass:
        dNonCentralStudent = staticmethod(_dist_bundle1.DistFunc_dNonCentralStudent)
    else:
        dNonCentralStudent = _dist_bundle1.DistFunc_dNonCentralStudent
    if _newclass:
        dNonCentralStudentAlt0 = staticmethod(_dist_bundle1.DistFunc_dNonCentralStudentAlt0)
    else:
        dNonCentralStudentAlt0 = _dist_bundle1.DistFunc_dNonCentralStudentAlt0
    if _newclass:
        pNonCentralStudent = staticmethod(_dist_bundle1.DistFunc_pNonCentralStudent)
    else:
        pNonCentralStudent = _dist_bundle1.DistFunc_pNonCentralStudent
    if _newclass:
        rNonCentralStudent = staticmethod(_dist_bundle1.DistFunc_rNonCentralStudent)
    else:
        rNonCentralStudent = _dist_bundle1.DistFunc_rNonCentralStudent

    def pNormal(x, tail=False):
        """
        CDF of an unit-variance centered Normal distribution.

        Parameters
        ----------
        x : float
            Location
        tail : bool, default=False
            Tail flag

        Returns
        -------
        cdf : float

        Examples
        --------
        >>> import openturns as ot
        >>> cdf = ot.DistFunc.pNormal(0.9)
        """
        return _dist_bundle1.DistFunc_pNormal(x, tail)

    pNormal = staticmethod(pNormal)
    if _newclass:
        pNormal2D = staticmethod(_dist_bundle1.DistFunc_pNormal2D)
    else:
        pNormal2D = _dist_bundle1.DistFunc_pNormal2D
    if _newclass:
        pNormal3D = staticmethod(_dist_bundle1.DistFunc_pNormal3D)
    else:
        pNormal3D = _dist_bundle1.DistFunc_pNormal3D

    def qNormal(p, tail=False):
        """
        Quantile of an unit-variance centered Normal distribution.

        Parameters
        ----------
        prob : float

        Returns
        -------
        q : float

        Examples
        --------
        >>> import openturns as ot
        >>> q = ot.DistFunc.qNormal(0.95)
        """
        return _dist_bundle1.DistFunc_qNormal(p, tail)

    qNormal = staticmethod(qNormal)

    def rNormal(*args):
        """
        Realization of an unit-variance centered Normal distribution.

        Returns
        -------
        realization : float

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> r = ot.DistFunc.rNormal()
        """
        return _dist_bundle1.DistFunc_rNormal(*args)

    rNormal = staticmethod(rNormal)
    if _newclass:
        qPoisson = staticmethod(_dist_bundle1.DistFunc_qPoisson)
    else:
        qPoisson = _dist_bundle1.DistFunc_qPoisson
    if _newclass:
        rPoisson = staticmethod(_dist_bundle1.DistFunc_rPoisson)
    else:
        rPoisson = _dist_bundle1.DistFunc_rPoisson
    if _newclass:
        pStudent = staticmethod(_dist_bundle1.DistFunc_pStudent)
    else:
        pStudent = _dist_bundle1.DistFunc_pStudent
    if _newclass:
        qStudent = staticmethod(_dist_bundle1.DistFunc_qStudent)
    else:
        qStudent = _dist_bundle1.DistFunc_qStudent
    if _newclass:
        rStudent = staticmethod(_dist_bundle1.DistFunc_rStudent)
    else:
        rStudent = _dist_bundle1.DistFunc_rStudent
    if _newclass:
        rUniformTriangle = staticmethod(_dist_bundle1.DistFunc_rUniformTriangle)
    else:
        rUniformTriangle = _dist_bundle1.DistFunc_rUniformTriangle
    if _newclass:
        eZ1 = staticmethod(_dist_bundle1.DistFunc_eZ1)
    else:
        eZ1 = _dist_bundle1.DistFunc_eZ1

    def kFactorPooled(n, m, p, alpha):
        """
        Exact margin factor for bilateral covering interval of pooled Normal populations.

        Parameters
        ----------
        n : int
            The size of the population

        m : int
            The size of the pool

        p : float :math:`0<p<1`
            The probability level of the covering interval

        alpha : float :math:`0<\\alpha<1`
            The confidence level of the covering interval

        Returns
        -------
        k : float
            The margin factor

        Notes
        -----
        This method allows to compute the *exact* margin factor :math:`k` of a
        pool of :math:`m` Normal populations of size :math:`n` with unknown
        means :math:`\\mu_i` and unknown common variance :math:`\\sigma^2`.
        Let :math:`m_i=\\dfrac{1}{n}\\sum_{j=1}^nX_{ij}` be the empirical mean
        of the ith population :math:`(X_{i1},\\dots,X_{in})` and
        :math:`\\sigma^2_{mn}=\\dfrac{}{}\\sum_{i=1}^m\\sum_{j=1}^n(X_{ij}-m_i)^2`
        the empirical *pooled* variance. The covering factor :math:`k` is such
        that the intervals :math:`[m_i-k\\sigma_{mn},m_i+k\\sigma_{mn}]` satisfy:

        .. math::
            \\Prob{\\Prob{X_i\\in[m_i-k\\sigma_{mn},m_i+k\\sigma_{mn}]}\\geq p}=\\alpha

        for :math:`i\\in\\{1,\\dots,m\\}`. It reduces to find :math:`k` such that:

        .. math::
            \\int_{\\Rset}F(x,k;\\nu_{m,n},p)\\phi_{0,1/\\sqrt{n}}(x)\\,\\di x = \\alpha

        where :math:`phi_{0,1/\\sqrt{n}}` is the density function of the normal
        distribution with a mean equals to 0 and a variance equals to
        :math:`1/n`, :math:`\\nu_{m,n}=m(n-1)` and :math:`F(x,k;\\nu_{m,n},p)`
        the function defined by:

        .. math::
            F(x,k;\\nu_{m,n},p)=\\bar{F}_{\\chi^2_{\\nu_{m,n}}}(\\nu_{m,n} R^2(x;p)/k^2)

        where :math:`\\bar{F}_{\\chi^2_{\\nu_{m,n}}}` is the complementary distribution
        function of a chi-square distribution with :math:`\\nu_{m,n}` degrees
        of freedom and :math:`R(x;p)` the solution of:

        .. math::
            \\Phi(x + R) - \\Phi(x - R) = p

        Examples
        --------
        >>> import openturns as ot
        >>> k = ot.DistFunc.kFactorPooled(5, 3, 0.95, 0.9)
        """
        return _dist_bundle1.DistFunc_kFactorPooled(n, m, p, alpha)

    kFactorPooled = staticmethod(kFactorPooled)

    def kFactor(n, p, alpha):
        """
        Exact margin factor for bilateral covering interval of a Normal population.

        Parameters
        ----------
        n : int
            The size of the population

        p : float :math:`0<p<1`
            The probability level of the covering interval

        alpha : float :math:`0<\\alpha<1`
            The confidence level of the covering interval

        Returns
        -------
        k : float
            The margin factor

        Notes
        -----
        This method allows to compute the *exact* margin factor :math:`k` of a
        Normal population of size :math:`n` with unknown
        means :math:`\\mu_i` and unknown common variance :math:`\\sigma^2`. It
        is equivalent to the pooled version with :math:`m=1`.

        Examples
        --------
        >>> import openturns as ot
        >>> k = ot.DistFunc.kFactor(5, 0.95, 0.9)
        """
        return _dist_bundle1.DistFunc_kFactor(n, p, alpha)

    kFactor = staticmethod(kFactor)
    if _newclass:
        pDickeyFullerTrend = staticmethod(_dist_bundle1.DistFunc_pDickeyFullerTrend)
    else:
        pDickeyFullerTrend = _dist_bundle1.DistFunc_pDickeyFullerTrend
    if _newclass:
        pDickeyFullerConstant = staticmethod(_dist_bundle1.DistFunc_pDickeyFullerConstant)
    else:
        pDickeyFullerConstant = _dist_bundle1.DistFunc_pDickeyFullerConstant
    if _newclass:
        pDickeyFullerNoConstant = staticmethod(_dist_bundle1.DistFunc_pDickeyFullerNoConstant)
    else:
        pDickeyFullerNoConstant = _dist_bundle1.DistFunc_pDickeyFullerNoConstant
    if _newclass:
        qDickeyFullerTrend = staticmethod(_dist_bundle1.DistFunc_qDickeyFullerTrend)
    else:
        qDickeyFullerTrend = _dist_bundle1.DistFunc_qDickeyFullerTrend
    if _newclass:
        qDickeyFullerConstant = staticmethod(_dist_bundle1.DistFunc_qDickeyFullerConstant)
    else:
        qDickeyFullerConstant = _dist_bundle1.DistFunc_qDickeyFullerConstant
    if _newclass:
        qDickeyFullerNoConstant = staticmethod(_dist_bundle1.DistFunc_qDickeyFullerNoConstant)
    else:
        qDickeyFullerNoConstant = _dist_bundle1.DistFunc_qDickeyFullerNoConstant

    def __init__(self):
        this = _dist_bundle1.new_DistFunc()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_DistFunc
    __del__ = lambda self: None
DistFunc_swigregister = _dist_bundle1.DistFunc_swigregister
DistFunc_swigregister(DistFunc)
cvar = _dist_bundle1.cvar
DistFunc.NumberOfBandNormalZigurrat = _dist_bundle1.cvar.DistFunc_NumberOfBandNormalZigurrat
DistFunc.NormalZigguratTail = _dist_bundle1.cvar.DistFunc_NormalZigguratTail
DistFunc.NormalZigguratAbscissa = _dist_bundle1.cvar.DistFunc_NormalZigguratAbscissa
DistFunc.NormalZigguratRatio = _dist_bundle1.cvar.DistFunc_NormalZigguratRatio

def DistFunc_pBeta(p1, p2, x, tail=False):
    return _dist_bundle1.DistFunc_pBeta(p1, p2, x, tail)
DistFunc_pBeta = _dist_bundle1.DistFunc_pBeta

def DistFunc_qBeta(p1, p2, p, tail=False):
    return _dist_bundle1.DistFunc_qBeta(p1, p2, p, tail)
DistFunc_qBeta = _dist_bundle1.DistFunc_qBeta

def DistFunc_rBeta(*args):
    return _dist_bundle1.DistFunc_rBeta(*args)
DistFunc_rBeta = _dist_bundle1.DistFunc_rBeta

def DistFunc_rBinomial(*args):
    return _dist_bundle1.DistFunc_rBinomial(*args)
DistFunc_rBinomial = _dist_bundle1.DistFunc_rBinomial

def DistFunc_pGamma(k, x, tail=False):
    return _dist_bundle1.DistFunc_pGamma(k, x, tail)
DistFunc_pGamma = _dist_bundle1.DistFunc_pGamma

def DistFunc_qGamma(k, p, tail=False):
    return _dist_bundle1.DistFunc_qGamma(k, p, tail)
DistFunc_qGamma = _dist_bundle1.DistFunc_qGamma

def DistFunc_rGamma(*args):
    return _dist_bundle1.DistFunc_rGamma(*args)
DistFunc_rGamma = _dist_bundle1.DistFunc_rGamma

def DistFunc_pKolmogorov(n, x, tail=False):
    return _dist_bundle1.DistFunc_pKolmogorov(n, x, tail)
DistFunc_pKolmogorov = _dist_bundle1.DistFunc_pKolmogorov

def DistFunc_dNonCentralChiSquare(*args):
    return _dist_bundle1.DistFunc_dNonCentralChiSquare(*args)
DistFunc_dNonCentralChiSquare = _dist_bundle1.DistFunc_dNonCentralChiSquare

def DistFunc_pNonCentralChiSquare(*args):
    return _dist_bundle1.DistFunc_pNonCentralChiSquare(*args)
DistFunc_pNonCentralChiSquare = _dist_bundle1.DistFunc_pNonCentralChiSquare

def DistFunc_rNonCentralChiSquare(*args):
    return _dist_bundle1.DistFunc_rNonCentralChiSquare(*args)
DistFunc_rNonCentralChiSquare = _dist_bundle1.DistFunc_rNonCentralChiSquare

def DistFunc_dNonCentralStudent(nu, delta, x):
    return _dist_bundle1.DistFunc_dNonCentralStudent(nu, delta, x)
DistFunc_dNonCentralStudent = _dist_bundle1.DistFunc_dNonCentralStudent

def DistFunc_dNonCentralStudentAlt0(*args):
    return _dist_bundle1.DistFunc_dNonCentralStudentAlt0(*args)
DistFunc_dNonCentralStudentAlt0 = _dist_bundle1.DistFunc_dNonCentralStudentAlt0

def DistFunc_pNonCentralStudent(nu, delta, x, tail=False):
    return _dist_bundle1.DistFunc_pNonCentralStudent(nu, delta, x, tail)
DistFunc_pNonCentralStudent = _dist_bundle1.DistFunc_pNonCentralStudent

def DistFunc_rNonCentralStudent(*args):
    return _dist_bundle1.DistFunc_rNonCentralStudent(*args)
DistFunc_rNonCentralStudent = _dist_bundle1.DistFunc_rNonCentralStudent

def DistFunc_pNormal(x, tail=False):
    """
    CDF of an unit-variance centered Normal distribution.

    Parameters
    ----------
    x : float
        Location
    tail : bool, default=False
        Tail flag

    Returns
    -------
    cdf : float

    Examples
    --------
    >>> import openturns as ot
    >>> cdf = ot.DistFunc.pNormal(0.9)
    """
    return _dist_bundle1.DistFunc_pNormal(x, tail)

def DistFunc_pNormal2D(x1, x2, rho, tail=False):
    return _dist_bundle1.DistFunc_pNormal2D(x1, x2, rho, tail)
DistFunc_pNormal2D = _dist_bundle1.DistFunc_pNormal2D

def DistFunc_pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail=False):
    return _dist_bundle1.DistFunc_pNormal3D(x1, x2, x3, rho12, rho13, rho23, tail)
DistFunc_pNormal3D = _dist_bundle1.DistFunc_pNormal3D

def DistFunc_qNormal(p, tail=False):
    """
    Quantile of an unit-variance centered Normal distribution.

    Parameters
    ----------
    prob : float

    Returns
    -------
    q : float

    Examples
    --------
    >>> import openturns as ot
    >>> q = ot.DistFunc.qNormal(0.95)
    """
    return _dist_bundle1.DistFunc_qNormal(p, tail)

def DistFunc_rNormal(*args):
    """
    Realization of an unit-variance centered Normal distribution.

    Returns
    -------
    realization : float

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> r = ot.DistFunc.rNormal()
    """
    return _dist_bundle1.DistFunc_rNormal(*args)

def DistFunc_qPoisson(arg1, p, tail=False):
    return _dist_bundle1.DistFunc_qPoisson(arg1, p, tail)
DistFunc_qPoisson = _dist_bundle1.DistFunc_qPoisson

def DistFunc_rPoisson(*args):
    return _dist_bundle1.DistFunc_rPoisson(*args)
DistFunc_rPoisson = _dist_bundle1.DistFunc_rPoisson

def DistFunc_pStudent(nu, x, tail=False):
    return _dist_bundle1.DistFunc_pStudent(nu, x, tail)
DistFunc_pStudent = _dist_bundle1.DistFunc_pStudent

def DistFunc_qStudent(nu, p, tail=False):
    return _dist_bundle1.DistFunc_qStudent(nu, p, tail)
DistFunc_qStudent = _dist_bundle1.DistFunc_qStudent

def DistFunc_rStudent(*args):
    return _dist_bundle1.DistFunc_rStudent(*args)
DistFunc_rStudent = _dist_bundle1.DistFunc_rStudent

def DistFunc_rUniformTriangle(*args):
    return _dist_bundle1.DistFunc_rUniformTriangle(*args)
DistFunc_rUniformTriangle = _dist_bundle1.DistFunc_rUniformTriangle

def DistFunc_eZ1(n):
    return _dist_bundle1.DistFunc_eZ1(n)
DistFunc_eZ1 = _dist_bundle1.DistFunc_eZ1

def DistFunc_kFactorPooled(n, m, p, alpha):
    """
    Exact margin factor for bilateral covering interval of pooled Normal populations.

    Parameters
    ----------
    n : int
        The size of the population

    m : int
        The size of the pool

    p : float :math:`0<p<1`
        The probability level of the covering interval

    alpha : float :math:`0<\\alpha<1`
        The confidence level of the covering interval

    Returns
    -------
    k : float
        The margin factor

    Notes
    -----
    This method allows to compute the *exact* margin factor :math:`k` of a
    pool of :math:`m` Normal populations of size :math:`n` with unknown
    means :math:`\\mu_i` and unknown common variance :math:`\\sigma^2`.
    Let :math:`m_i=\\dfrac{1}{n}\\sum_{j=1}^nX_{ij}` be the empirical mean
    of the ith population :math:`(X_{i1},\\dots,X_{in})` and
    :math:`\\sigma^2_{mn}=\\dfrac{}{}\\sum_{i=1}^m\\sum_{j=1}^n(X_{ij}-m_i)^2`
    the empirical *pooled* variance. The covering factor :math:`k` is such
    that the intervals :math:`[m_i-k\\sigma_{mn},m_i+k\\sigma_{mn}]` satisfy:

    .. math::
        \\Prob{\\Prob{X_i\\in[m_i-k\\sigma_{mn},m_i+k\\sigma_{mn}]}\\geq p}=\\alpha

    for :math:`i\\in\\{1,\\dots,m\\}`. It reduces to find :math:`k` such that:

    .. math::
        \\int_{\\Rset}F(x,k;\\nu_{m,n},p)\\phi_{0,1/\\sqrt{n}}(x)\\,\\di x = \\alpha

    where :math:`phi_{0,1/\\sqrt{n}}` is the density function of the normal
    distribution with a mean equals to 0 and a variance equals to
    :math:`1/n`, :math:`\\nu_{m,n}=m(n-1)` and :math:`F(x,k;\\nu_{m,n},p)`
    the function defined by:

    .. math::
        F(x,k;\\nu_{m,n},p)=\\bar{F}_{\\chi^2_{\\nu_{m,n}}}(\\nu_{m,n} R^2(x;p)/k^2)

    where :math:`\\bar{F}_{\\chi^2_{\\nu_{m,n}}}` is the complementary distribution
    function of a chi-square distribution with :math:`\\nu_{m,n}` degrees
    of freedom and :math:`R(x;p)` the solution of:

    .. math::
        \\Phi(x + R) - \\Phi(x - R) = p

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactorPooled(5, 3, 0.95, 0.9)
    """
    return _dist_bundle1.DistFunc_kFactorPooled(n, m, p, alpha)

def DistFunc_kFactor(n, p, alpha):
    """
    Exact margin factor for bilateral covering interval of a Normal population.

    Parameters
    ----------
    n : int
        The size of the population

    p : float :math:`0<p<1`
        The probability level of the covering interval

    alpha : float :math:`0<\\alpha<1`
        The confidence level of the covering interval

    Returns
    -------
    k : float
        The margin factor

    Notes
    -----
    This method allows to compute the *exact* margin factor :math:`k` of a
    Normal population of size :math:`n` with unknown
    means :math:`\\mu_i` and unknown common variance :math:`\\sigma^2`. It
    is equivalent to the pooled version with :math:`m=1`.

    Examples
    --------
    >>> import openturns as ot
    >>> k = ot.DistFunc.kFactor(5, 0.95, 0.9)
    """
    return _dist_bundle1.DistFunc_kFactor(n, p, alpha)

def DistFunc_pDickeyFullerTrend(x, tail=False):
    return _dist_bundle1.DistFunc_pDickeyFullerTrend(x, tail)
DistFunc_pDickeyFullerTrend = _dist_bundle1.DistFunc_pDickeyFullerTrend

def DistFunc_pDickeyFullerConstant(x, tail=False):
    return _dist_bundle1.DistFunc_pDickeyFullerConstant(x, tail)
DistFunc_pDickeyFullerConstant = _dist_bundle1.DistFunc_pDickeyFullerConstant

def DistFunc_pDickeyFullerNoConstant(x, tail=False):
    return _dist_bundle1.DistFunc_pDickeyFullerNoConstant(x, tail)
DistFunc_pDickeyFullerNoConstant = _dist_bundle1.DistFunc_pDickeyFullerNoConstant

def DistFunc_qDickeyFullerTrend(p, tail=False):
    return _dist_bundle1.DistFunc_qDickeyFullerTrend(p, tail)
DistFunc_qDickeyFullerTrend = _dist_bundle1.DistFunc_qDickeyFullerTrend

def DistFunc_qDickeyFullerConstant(p, tail=False):
    return _dist_bundle1.DistFunc_qDickeyFullerConstant(p, tail)
DistFunc_qDickeyFullerConstant = _dist_bundle1.DistFunc_qDickeyFullerConstant

def DistFunc_qDickeyFullerNoConstant(p, tail=False):
    return _dist_bundle1.DistFunc_qDickeyFullerNoConstant(p, tail)
DistFunc_qDickeyFullerNoConstant = _dist_bundle1.DistFunc_qDickeyFullerNoConstant

class Arcsine(openturns.model_copula.ContinuousDistribution):
    """
    Arcsine distribution.

    Available constructors:
        Arcsine(*a=-1.0, b=1.0*)

    Parameters
    ----------
    a : float
        lower bound.
    b : float
        upper bound, :math:`b > a`

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{\\pi \\sqrt{(x - a)(b - x)}},
                 \\quad x \\in [a, b]

    with :math:`a < b`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{a + b}{2} \\\\
            \\Var{X} & = & \\frac{(b - a)^2}{8}
        \\end{eqnarray*}

    It is possible to create an Arcsine distribution from the alternative parametrization :math:`(\\mu, \\sigma)`: see  :class:`~openturns.ArcsineMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\\mu, \\sigma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(a, b)`

    Examples
    --------
    Create a distribution from its native parameters :math:`(a, b)`:

    >>> import openturns as ot
    >>> myDist = ot.Arcsine(2.0, 3.0)

    Create a it from the alternative parametrization :math:`(\\mu, \\sigma)`:

    >>> myDist2 = ot.Arcsine()
    >>> myDist2.setParameter(ot.ArcsineMuSigma()([2.5, 0.35]))

    Create it from :math:`(\\mu, \\sigma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.ArcsineMuSigma(2.5, 0.35)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Arcsine, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Arcsine, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Arcsine_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Arcsine___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Arcsine___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Arcsine___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Arcsine_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Arcsine_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Arcsine_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Arcsine_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Arcsine_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Arcsine_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Arcsine_computeCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Arcsine_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Arcsine_computeCDFGradient(self, *args)


    def computeScalarQuantile(self, prob, tail=False):
        """
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : float
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_X(p) = F_X^{-1}(p), \\quad p \\in [0; 1]

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Arcsine_computeScalarQuantile(self, prob, tail)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Arcsine_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Arcsine_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Arcsine_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Arcsine_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Arcsine_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Arcsine_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Arcsine_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Arcsine_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Arcsine_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Arcsine_isElliptical(self)


    def setA(self, a):
        """
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle1.Arcsine_setA(self, a)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle1.Arcsine_getA(self)


    def setB(self, b):
        """
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`a < b`
            Upper bound.
        """
        return _dist_bundle1.Arcsine_setB(self, b)


    def getB(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle1.Arcsine_getB(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Arcsine(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Arcsine
    __del__ = lambda self: None
Arcsine_swigregister = _dist_bundle1.Arcsine_swigregister
Arcsine_swigregister(Arcsine)

class ArcsineFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Arcsine factory.

    Available constructor:
        ArcsineFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle\\Hat{a} = \\Hat{\\mu}_x - \\Hat{\\sigma}_x \\sqrt{2}\\\\
          \\displaystyle\\Hat{b} = \\Hat{\\mu}_x + \\Hat{\\sigma}_x \\sqrt{2}
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, Arcsine
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArcsineFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ArcsineFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ArcsineFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.ArcsineFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle1.ArcsineFactory_buildEstimator(self, *args)


    def buildAsArcsine(self, *args):
        return _dist_bundle1.ArcsineFactory_buildAsArcsine(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_ArcsineFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ArcsineFactory
    __del__ = lambda self: None
ArcsineFactory_swigregister = _dist_bundle1.ArcsineFactory_swigregister
ArcsineFactory_swigregister(ArcsineFactory)

class ArcsineMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    Arcsine distribution parameters.

    Available constructors:
        ArcsineMuSigma(*mu=1.0, sigma=1.0*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        a &= \\mu - \\sigma \\sqrt{2} \\\\
        b &= \\mu + \\sigma \\sqrt{2}

    See also
    --------
    Arcsine

    Examples
    --------
    Create the parameters of the Arcsine distribution:

    >>> import openturns as ot
    >>> parameters = ot.ArcsineMuSigma(8.4, 2.25)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [5.21802,11.582]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  1        1       ]
     [ -1.41421  1.41421 ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ArcsineMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ArcsineMuSigma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ArcsineMuSigma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.ArcsineMuSigma___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.ArcsineMuSigma_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle1.ArcsineMuSigma_gradient(self)


    def __call__(self, inP):
        return _dist_bundle1.ArcsineMuSigma___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.ArcsineMuSigma_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.ArcsineMuSigma_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.ArcsineMuSigma_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.ArcsineMuSigma_getDescription(self)


    def __repr__(self):
        return _dist_bundle1.ArcsineMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.ArcsineMuSigma___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_ArcsineMuSigma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ArcsineMuSigma
    __del__ = lambda self: None
ArcsineMuSigma_swigregister = _dist_bundle1.ArcsineMuSigma_swigregister
ArcsineMuSigma_swigregister(ArcsineMuSigma)

class Bernoulli(openturns.model_copula.DiscreteDistribution):
    """
    Bernoulli distribution.

    Available constructors:
        Bernoulli(*p=0.5*)

    Parameters
    ----------
    p : float, :math:`0 \\leq p \\leq 1`
        Success probability.

    Notes
    -----
    Its probability density function is defined as:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Prob{X = 1} & = & p \\\\
            \\Prob{X = 0} & = & 1 - p
        \\end{eqnarray*}

    with :math:`0 \\leq p \\leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & p \\\\
            \\Var{X} & = & p\\,(1 - p)
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Bernoulli(0.2)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Bernoulli, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Bernoulli, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Bernoulli_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Bernoulli___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Bernoulli___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Bernoulli___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Bernoulli_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Bernoulli_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Bernoulli_computeCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Bernoulli_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Bernoulli_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Bernoulli_computeCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Bernoulli_computeGeneratingFunction(self, z)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Bernoulli_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Bernoulli_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Bernoulli_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Bernoulli_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Bernoulli_getStandardMoment(self, n)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Bernoulli_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Bernoulli_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Bernoulli_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Bernoulli_isElliptical(self)


    def setP(self, p):
        """
        Accessor to the distribution's *success probability* parameter.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            Success probability.
        """
        return _dist_bundle1.Bernoulli_setP(self, p)


    def getP(self):
        """
        Accessor to the distribution's *success probability* parameter.

        Returns
        -------
        p : float
            Success probability.
        """
        return _dist_bundle1.Bernoulli_getP(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Bernoulli(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Bernoulli
    __del__ = lambda self: None
Bernoulli_swigregister = _dist_bundle1.Bernoulli_swigregister
Bernoulli_swigregister(Bernoulli)

class BernoulliFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Bernoulli factory.

    Available constructor:
        BernoulliFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BernoulliFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BernoulliFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BernoulliFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.BernoulliFactory_build(self, *args)


    def buildAsBernoulli(self, *args):
        return _dist_bundle1.BernoulliFactory_buildAsBernoulli(self, *args)

    def buildEstimator(self, sample):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle1.BernoulliFactory_buildEstimator(self, sample)


    def __init__(self, *args):
        this = _dist_bundle1.new_BernoulliFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BernoulliFactory
    __del__ = lambda self: None
BernoulliFactory_swigregister = _dist_bundle1.BernoulliFactory_swigregister
BernoulliFactory_swigregister(BernoulliFactory)

class BernsteinCopulaFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    BernsteinCopula copula factory.

    Available constructors:
        BernsteinCopulaFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BernsteinCopulaFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BernsteinCopulaFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BernsteinCopulaFactory_getClassName(self)


    def build(self, *args):
        """
        Build the nonparametric Bernstein copula estimator based on the empirical copula.

        **Available usages**:

            build(*sample*)

            build(*sample, m*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension *d*
            The sample of size :math:`n>0` from which the copula is estimated.
        m : int
            The number of sub-intervals in which all the edges of the unit cube :math:`[0, 1]^d` are regularly partitioned. 

        Notes
        -----
        If not given, the number of bins is computed by minimizing the asymptotic mean integrated squared error (AMISE), leading to

        .. math::

            m = 1+\\left\\lfloor n^{\\dfrac{2}{4+n}} \\right\\rfloor

        where :math:`\\lfloor x \\rfloor` is the largest integer less than or equal to :math:`x`.

        Then, the copula is estimated by a mixture of products of Beta distributions, ie its density function :math:`\\hat{c}` is given by:

        .. math::

            \\forall (u_1,\\hdots,u_d)\\in[0,1]^d,\\quad\\hat{c}(u_1,\\hdots,u_d) = \\frac{1}{n}\\sum_{i=1}^n\\prod_{j=1}^d\\beta_{\\nu^i_j+1, m+1}(u_j)

        where :math:`\\nu_j=\\left\\lfloor \\dfrac{m}{n}\\mathrm{rank}(X^i_j)\\right\\rfloor` is the index of the bin to which the normalized rank of the component :math:`j` of the observation :math:`j` belongs and :math:`\\beta_{r,t}` is the density of the beta distribution supported by [0,1], see :class:`~openturns.Beta`.

        This estimator is called the Bernstein estimator because of the fact that, for integer shape parameters :math:`r` and :math:`t`, the density function of the beta distribution is equal to the Bernstein polynomial :math:`P_{r,t}`:

        .. math::

            \\beta_{r+1,t+1}(u)=(t+1)\\binom{t}{r}u^r(1-u)^{t-r-1}=P_{r,t-r-1}(u)

        """
        return _dist_bundle1.BernsteinCopulaFactory_build(self, *args)


    def computeBinNumber(self, sample):
        """
        Compute the optimal AMISE number of bins.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the optimal AMISE bin number is computed.

        Notes
        -----
        The number of bins is computed by minimizing the asymptotic mean integrated squared error (AMISE), leading to

        .. math::

            m = 1+\\left\\lfloor n^{\\dfrac{2}{4+n}} \\right\\rfloor

        where :math:`\\lfloor x \\rfloor` is the largest integer less than or equal to :math:`x`.

        """
        return _dist_bundle1.BernsteinCopulaFactory_computeBinNumber(self, sample)


    def setParallel(self, flag):
        return _dist_bundle1.BernsteinCopulaFactory_setParallel(self, flag)

    def isParallel(self):
        return _dist_bundle1.BernsteinCopulaFactory_isParallel(self)

    def __init__(self, *args):
        this = _dist_bundle1.new_BernsteinCopulaFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BernsteinCopulaFactory
    __del__ = lambda self: None
BernsteinCopulaFactory_swigregister = _dist_bundle1.BernsteinCopulaFactory_swigregister
BernsteinCopulaFactory_swigregister(BernsteinCopulaFactory)

class Beta(openturns.model_copula.ContinuousDistribution):
    """
    Beta distribution.

    Available constructors:
        Beta(*r=2.0, t=4.0, a=-1.0, b=1.0*)

    Parameters
    ----------
    r : float
        shape parameter :math:`r > 0` with :math:`r = t * (\\mu - a) / (b - a)`.
    t : float
        shape parameter :math:`t > r` with :math:`t = (b - \\mu) * (\\mu - a) / \\sigma^2 - 1`.
    a : float
        Lower bound.
    b : float, :math:`b > a`
        Upper bound.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{(x - a)^{r - 1} (b - x)^{t - r - 1}}
                      {(b - a)^{t - 1} {\\rm B}(r, t - r)},
                      \\quad x \\in [a, b]

    with :math:`r < t` and :math:`a < b` and where :math:`\\rm B` denotes
    Euler's beta function :class:`~openturns.SpecFunc_Beta`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & a + \\frac{(b - a)\\,r}{t} \\\\
            \\Var{X} & = & \\left(\\frac{b - a}{t}\\right)^2 \\frac{r\\,(t - r)}{t + 1}
        \\end{eqnarray*}


    It is possible to create a Beta distribution from the alternative parametrization :math:`(\\mu, \\sigma, a, b)`: see  :class:`~openturns.BetaMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\\mu, \\sigma, a, b)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(r, t, a, b)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(r, t, a, b)`:

    >>> import openturns as ot
    >>> myDist = ot.Beta(1.0, 2.0, 1.0, 5.0)

    Create a it from the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

    >>> myDist2 = ot.Beta()
    >>> myDist2.setParameter(ot.BetaMuSigma()([3.0, 1.15, 1.0, 5.0]))

    Create it from :math:`(\\mu, \\sigma, a, b)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.BetaMuSigma(3.0, 1.15, 1.0, 5.0)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Beta, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Beta, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Beta_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Beta___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Beta___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Beta___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Beta_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Beta_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Beta_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Beta_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Beta_computeCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Beta_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Beta_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Beta_computeCharacteristicFunction(self, x)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Beta_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Beta_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Beta_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Beta_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Beta_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Beta_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Beta_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Beta_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Beta_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Beta_isElliptical(self)


    def setR(self, r):
        """
        Accessor to the distribution's shape parameter :math:`r`.

        Parameters
        ----------
        r : float, :math:`r > 0`
            Shape parameter :math:`r`.
        """
        return _dist_bundle1.Beta_setR(self, r)


    def getR(self):
        """
        Accessor to the distribution's shape parameter :math:`r`.

        Returns
        -------
        r : float
            Shape parameter :math:`r`.
        """
        return _dist_bundle1.Beta_getR(self)


    def setT(self, t):
        """
        Accessor to the distribution's shape parameter :math:`t`.

        Parameters
        ----------
        t : float, :math:`t > r`
            Shape parameter :math:`t`.
        """
        return _dist_bundle1.Beta_setT(self, t)


    def getT(self):
        """
        Accessor to the distribution's shape parameter :math:`t`.

        Returns
        -------
        t : float
            Shape parameter :math:`t`.
        """
        return _dist_bundle1.Beta_getT(self)


    def setA(self, a):
        """
        Accessor to the distribution's lower bound.

        Parameters
        ----------
        a : float, :math:`a < b`
            Lower bound.
        """
        return _dist_bundle1.Beta_setA(self, a)


    def getA(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        a : float
            Lower bound.
        """
        return _dist_bundle1.Beta_getA(self)


    def setB(self, b):
        """
        Accessor to the distribution's upper bound.

        Parameters
        ----------
        b : float, :math:`b > a`
            Upper bound.
        """
        return _dist_bundle1.Beta_setB(self, b)


    def getB(self):
        """
        Accessor to the distribution's upper bound.

        Returns
        -------
        b : float
            Upper bound.
        """
        return _dist_bundle1.Beta_getB(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Beta(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Beta
    __del__ = lambda self: None
Beta_swigregister = _dist_bundle1.Beta_swigregister
Beta_swigregister(Beta)

class BetaFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Beta factory.

    Available constructor:
        BetaFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BetaFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BetaFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BetaFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.BetaFactory_build(self, *args)


    def buildAsBeta(self, *args):
        return _dist_bundle1.BetaFactory_buildAsBeta(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_BetaFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BetaFactory
    __del__ = lambda self: None
BetaFactory_swigregister = _dist_bundle1.BetaFactory_swigregister
BetaFactory_swigregister(BetaFactory)

class BetaMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    Beta distribution parameters.

    Available constructors:
        BetaMuSigma(*mu=0.5, sigma=* :math:`1/(2\\sqrt{5})` *, a=0.0, b=1.0*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.
    a : float
        Lower bound.
    b : float, :math:`b > a`
        Upper bound.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        t &= \\frac{(b - \\mu) (\\mu - a)}{\\sigma^2} - 1.0 \\\\
        r &= \\frac{\\mu - a}{b - a} t

    See also
    --------
    Beta

    Examples
    --------
    Create the parameters of the Beta distribution:

    >>> import openturns as ot
    >>> parameters = ot.BetaMuSigma(0.2, 0.6, -1, 2)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [2,5,-1,2]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[   2.33333    1.66667    0          0        ]
     [  -8        -20          0          0        ]
     [  -3         -5          1          0        ]
     [   0.666667   3.33333    0          1        ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BetaMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BetaMuSigma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BetaMuSigma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.BetaMuSigma___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.BetaMuSigma_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle1.BetaMuSigma_gradient(self)


    def __call__(self, inP):
        return _dist_bundle1.BetaMuSigma___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.BetaMuSigma_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.BetaMuSigma_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.BetaMuSigma_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.BetaMuSigma_getDescription(self)


    def isElliptical(self):
        return _dist_bundle1.BetaMuSigma_isElliptical(self)

    def __repr__(self):
        return _dist_bundle1.BetaMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.BetaMuSigma___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_BetaMuSigma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BetaMuSigma
    __del__ = lambda self: None
BetaMuSigma_swigregister = _dist_bundle1.BetaMuSigma_swigregister
BetaMuSigma_swigregister(BetaMuSigma)

class Binomial(openturns.model_copula.DiscreteDistribution):
    """
    Binomial distribution.

    Available constructors:
        Binomial(*n=1, p=0.5*)

    Parameters
    ----------
    n : int, :math:`n \\in \\Nset`
        The number of Bernoulli trials.
    p : float, :math:`0 \\leq p \\leq 1`
        The success probability of the Bernoulli trial.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = C_n^k p^k (1-p)^{n-k},
                       \\quad \\forall k \\in \\{0, \\ldots, n\\}

    with :math:`n \\in \\Nset` and :math:`0 \\leq p \\leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & n\\,p \\\\
            \\Var{X} & = & n\\,p\\,(1-p)
        \\end{eqnarray*}

    See Also
    --------
    Bernoulli

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Binomial(10, 0.5)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Binomial, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Binomial, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Binomial_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Binomial___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Binomial___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Binomial___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Binomial_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Binomial_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Binomial_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Binomial_computeComplementaryCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Binomial_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Binomial_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Binomial_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Binomial_computeLogCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Binomial_computeGeneratingFunction(self, z)


    def computeLogGeneratingFunction(self, z):
        """
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input `X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle1.Binomial_computeLogGeneratingFunction(self, z)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Binomial_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Binomial_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Binomial_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Binomial_getKurtosis(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Binomial_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Binomial_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Binomial_getParameterDescription(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Binomial_isElliptical(self)


    def setP(self, p):
        """
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Binomial_setP(self, p)


    def getP(self):
        """
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Binomial_getP(self)


    def setN(self, n):
        """
        Accessor to the number of trials.

        Parameters
        ----------
        n : int, :math:`n \\in \\Nset`
            The number of Bernoulli trials.
        """
        return _dist_bundle1.Binomial_setN(self, n)


    def getN(self):
        """
        Accessor to the number of trials.

        Returns
        -------
        n : int
            The number of Bernoulli trials.
        """
        return _dist_bundle1.Binomial_getN(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Binomial(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Binomial
    __del__ = lambda self: None
Binomial_swigregister = _dist_bundle1.Binomial_swigregister
Binomial_swigregister(Binomial)

class BinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Binomial factory.

    Available constructor:
        BinomialFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BinomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BinomialFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BinomialFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.BinomialFactory_build(self, *args)


    def buildAsBinomial(self, *args):
        return _dist_bundle1.BinomialFactory_buildAsBinomial(self, *args)
    if _newclass:
        ComputeLogLikelihood = staticmethod(_dist_bundle1.BinomialFactory_ComputeLogLikelihood)
    else:
        ComputeLogLikelihood = _dist_bundle1.BinomialFactory_ComputeLogLikelihood

    def __init__(self, *args):
        this = _dist_bundle1.new_BinomialFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BinomialFactory
    __del__ = lambda self: None
BinomialFactory_swigregister = _dist_bundle1.BinomialFactory_swigregister
BinomialFactory_swigregister(BinomialFactory)

def BinomialFactory_ComputeLogLikelihood(n, p, sample):
    return _dist_bundle1.BinomialFactory_ComputeLogLikelihood(n, p, sample)
BinomialFactory_ComputeLogLikelihood = _dist_bundle1.BinomialFactory_ComputeLogLikelihood

class Burr(openturns.model_copula.ContinuousDistribution):
    """
    Burr distribution.

    Available constructors:
        Burr(*c=1.0, k=1.0*)

    Parameters
    ----------
    c : float, :math:`c > 0`
    k : float, :math:`k > 0`

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = c k \\frac{x^{c - 1}}{(1 + x^c)^{k + 1}}, \\quad x \\in \\Rset^{+*}

    with :math:`c, k > 0`.

    Its only, first-order moment is:

    .. math::

        \\Expect{X} = k {\\rm B}(k - 1 / c, 1 + 1 / c)

    where :math:`\\rm B` denotes Euler's beta function.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Burr(2.0, 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Burr, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Burr, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Burr_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Burr___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Burr___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Burr___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Burr_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Burr_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Burr_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Burr_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Burr_computeCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Burr_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Burr_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Burr_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Burr_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Burr_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Burr_getStandardMoment(self, n)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Burr_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Burr_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Burr_getParameterDescription(self)


    def setC(self, c):
        """
        Accessor to the parameter :math:`c`.

        Parameters
        ----------
        c : float, :math:`c > 0`
        """
        return _dist_bundle1.Burr_setC(self, c)


    def getC(self):
        """
        Accessor to the parameter :math:`c`.

        Returns
        -------
        c : float
        """
        return _dist_bundle1.Burr_getC(self)


    def setK(self, k):
        """
        Accessor to the parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
        """
        return _dist_bundle1.Burr_setK(self, k)


    def getK(self):
        """
        Accessor to the parameter :math:`k`.

        Returns
        -------
        k : float
        """
        return _dist_bundle1.Burr_getK(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Burr(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Burr
    __del__ = lambda self: None
Burr_swigregister = _dist_bundle1.Burr_swigregister
Burr_swigregister(Burr)

class BurrFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Burr factory.

    Available constructor:
        BurrFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BurrFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BurrFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.BurrFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.BurrFactory_build(self, *args)


    def buildAsBurr(self, *args):
        return _dist_bundle1.BurrFactory_buildAsBurr(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_BurrFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_BurrFactory
    __del__ = lambda self: None
BurrFactory_swigregister = _dist_bundle1.BurrFactory_swigregister
BurrFactory_swigregister(BurrFactory)

class Chi(openturns.model_copula.ContinuousDistribution):
    """
    :math:`\\chi` distribution.

    Available constructors:
        Chi(*nu=1.0*)

    Parameters
    ----------
    nu : float, :math:`\\nu > 0`
        Degrees of freedom.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{2^{1 - \\nu / 2} x^{\\nu - 1} \\exp(- x^2 / 2)}
                      {\\Gamma(\\nu / 2)}, \\quad x \\in \\Rset^{+*}

    with :math:`\\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\sqrt{2}\\,\\frac{\\Gamma((\\nu + 1) / 2)}
                                            {\\Gamma(\\nu / 2)} \\\\
            \\Var{X} & = & \\nu - \\mu^2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Chi(2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Chi, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Chi, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Chi_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Chi___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Chi___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Chi___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Chi_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Chi_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Chi_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Chi_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Chi_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Chi_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Chi_computeCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Chi_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Chi_computeCDFGradient(self, *args)


    def computeScalarQuantile(self, prob, tail=False):
        """
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : float
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_X(p) = F_X^{-1}(p), \\quad p \\in [0; 1]

        See Also
        --------
        computeQuantile
        """
        return _dist_bundle1.Chi_computeScalarQuantile(self, prob, tail)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Chi_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Chi_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Chi_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Chi_getStandardMoment(self, n)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Chi_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Chi_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Chi_getParameterDescription(self)


    def setNu(self, nu):
        """
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle1.Chi_setNu(self, nu)


    def getNu(self):
        """
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle1.Chi_getNu(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Chi(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Chi
    __del__ = lambda self: None
Chi_swigregister = _dist_bundle1.Chi_swigregister
Chi_swigregister(Chi)

class ChiFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Chi factory.

    Available constructor:
        ChiFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChiFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ChiFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.ChiFactory_build(self, *args)


    def buildAsChi(self, *args):
        return _dist_bundle1.ChiFactory_buildAsChi(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_ChiFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ChiFactory
    __del__ = lambda self: None
ChiFactory_swigregister = _dist_bundle1.ChiFactory_swigregister
ChiFactory_swigregister(ChiFactory)

class ChiSquare(openturns.model_copula.ContinuousDistribution):
    """
    :math:`\\chi^2` distribution.

    Available constructors:
        ChiSquare(*nu=1.0*)

    Parameters
    ----------
    nu : float, :math:`\\nu > 0`
        Degrees of freedom.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{2^{- \\nu / 2} x^{\\nu / 2 - 1} \\exp(- x / 2)}
                      {\\Gamma(\\nu / 2)}, \\quad x \\in \\Rset^{+*}

    with :math:`\\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\nu \\\\
            \\Var{X} & = & 2 \\nu
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.ChiSquare(2.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChiSquare, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ChiSquare, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiSquare_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.ChiSquare___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.ChiSquare___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.ChiSquare___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.ChiSquare_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.ChiSquare_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.ChiSquare_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.ChiSquare_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.ChiSquare_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.ChiSquare_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.ChiSquare_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.ChiSquare_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.ChiSquare_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.ChiSquare_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.ChiSquare_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.ChiSquare_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.ChiSquare_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.ChiSquare_getStandardMoment(self, n)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.ChiSquare_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.ChiSquare_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.ChiSquare_getParameterDescription(self)


    def setNu(self, nu):
        """
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle1.ChiSquare_setNu(self, nu)


    def getNu(self):
        """
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle1.ChiSquare_getNu(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_ChiSquare(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ChiSquare
    __del__ = lambda self: None
ChiSquare_swigregister = _dist_bundle1.ChiSquare_swigregister
ChiSquare_swigregister(ChiSquare)

class ChiSquareFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Chi-Square factory.

    Available constructor:
        ChiSquareFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle \\Hat{\\nu} = \\bar{x}
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, ChiSquare
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChiSquareFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ChiSquareFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ChiSquareFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.ChiSquareFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle1.ChiSquareFactory_buildEstimator(self, *args)


    def buildAsChiSquare(self, *args):
        return _dist_bundle1.ChiSquareFactory_buildAsChiSquare(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_ChiSquareFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ChiSquareFactory
    __del__ = lambda self: None
ChiSquareFactory_swigregister = _dist_bundle1.ChiSquareFactory_swigregister
ChiSquareFactory_swigregister(ChiSquareFactory)

class CompositeDistribution(openturns.model_copula.DistributionImplementation):
    """
    Composite distribution.

    Helper class for defining the push-forward distribution of a given univariate
    distribution by a given scalar function.

    Available constructors:
        CompositeDistribution(*g=Function('x', 'x'), distX=Uniform(0.0,1.0)*)

        CompositeDistribution(*g, distX, a, v*)

    Parameters
    ----------
    g : :class:`~openturns.Function`, :math:`\\Rset \\rightarrow \\Rset`
    distX : :class:`~openturns.Distribution`, univariate
    a : sequence of float of dimension :math:`N+1`, :math:`a[0]=\\inf \\supp{distX}`, :math:`a[N]=\\sup \\supp{distX}`
        The bounds of the intervals on which :math:`g` is monotone, sorted in
        ascending order.
    v : sequence of float of dimension :math:`N+1`,
        The values taken by :math:`g` on each bound: :math:`v[k]=g(a[k])`.

    Returns
    -------
    distY : :class:`~openturns.Distribution`, univariate
        :math:`distY` is the push-forward distribution of :math:`distX` by :math:`g`.


    Notes
    -----
    We note :math:`X` a scalar random variable which distribution is :math:`distX`,
    which probability density function is :math:`f_X`.

    Then :math:`distY` is the distribution of the scalar random variable
    :math:`Y=g(X)`, which probability density function :math:`f_Y` is defined as:

    .. math::

        \\displaystyle f_Y(y) = \\sum_{k =0}^{k=N} \\frac{f_X (g^{-1}(y))}{|g'\\circ g^{-1}(y)|}1_{y \\in g^{-1}([a_k, a_{k+1}))}

    with :math:`a_0=\\inf \\supp{f_X}`, :math:`a_N=\\sup \\supp{f_X}` and
    :math:`(a_1, \\dots, a_N)` such that :math:`g` is monotone over
    :math:`[a_k, a_{k+1})` for :math:`0 \\leq k \\leq N`.

    Its first moments are obtained by numerical integration.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> g = ot.SymbolicFunction(['x'], ['sin(x) + cos(x)'])
    >>> distY = ot.CompositeDistribution(g, ot.Normal(1.0, 0.5))

    >>> g = ot.SymbolicFunction(['x'], ['abs(x)'])
    >>> a = [-1.0, 0.0, 2.0]
    >>> v = [1.0, 0.0, 2.0]
    >>> distZ = ot.CompositeDistribution(g, ot.Uniform(-1.0, 2.0), a, v)

    >>> distX = ot.Normal(0.0, 1.0)
    >>> a0 = distX.getRange().getLowerBound()
    >>> aN = distX.getRange().getUpperBound()
    >>> a = [a0[0], 0.0, 0.0, aN[0]]
    >>> g = ot.SymbolicFunction(['x'], ['1.0/x'])
    >>> v = [g(a0)[0], -ot.SpecFunc.MaxScalar, ot.SpecFunc.MaxScalar, g(aN)[0]]
    >>> distT = ot.CompositeDistribution(g, distX, a, v)


    Draw a sample:

    >>> sample = distT.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompositeDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CompositeDistribution, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.CompositeDistribution_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.CompositeDistribution___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.CompositeDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.CompositeDistribution___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.CompositeDistribution_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.CompositeDistribution_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.CompositeDistribution_computeCDF(self, *args)


    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        """
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)

        """
        return _dist_bundle1.CompositeDistribution_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.CompositeDistribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.CompositeDistribution_getParametersCollection(self)


    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.CompositeDistribution_setParametersCollection(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.CompositeDistribution_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.CompositeDistribution_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.CompositeDistribution_getParameterDescription(self)


    def setFunction(self, function):
        """
        Fix the function through wich the distribution is push-forwarded.

        Parameters
        ----------
        g :  :class:`~openturns.Function`, :math:`\\Rset \\rightarrow \\Rset`
            the function :math:`g`.
        """
        return _dist_bundle1.CompositeDistribution_setFunction(self, function)


    def getFunction(self):
        """
        Accessor to the function.

        Returns
        -------
        g :  :class:`~openturns.Function`, :math:`\\Rset \\rightarrow \\Rset`
            the function :math:`g`.
        """
        return _dist_bundle1.CompositeDistribution_getFunction(self)


    def setAntecedent(self, antecedent):
        """
        Fix the antecedent distribution which is push-forwarded.

        Parameters
        ----------
        distX : :class:`~openturns.Distribution`, univariate
           Distribution of the antecedent :math:`distX`.
        """
        return _dist_bundle1.CompositeDistribution_setAntecedent(self, antecedent)


    def getAntecedent(self):
        """
        Accessor to the antecedent distribution.

        Returns
        -------
        distX : :class:`~openturns.Distribution`, univariate
            Antecedent distribution :math:`distX`.
        """
        return _dist_bundle1.CompositeDistribution_getAntecedent(self)


    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.CompositeDistribution_isContinuous(self)


    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.CompositeDistribution_isDiscrete(self)


    def setSolver(self, solver):
        return _dist_bundle1.CompositeDistribution_setSolver(self, solver)

    def getSolver(self):
        return _dist_bundle1.CompositeDistribution_getSolver(self)

    def computeShiftedMomentContinuous(self, n, shift):
        return _dist_bundle1.CompositeDistribution_computeShiftedMomentContinuous(self, n, shift)

    def __init__(self, *args):
        this = _dist_bundle1.new_CompositeDistribution(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_CompositeDistribution
    __del__ = lambda self: None
CompositeDistribution_swigregister = _dist_bundle1.CompositeDistribution_swigregister
CompositeDistribution_swigregister(CompositeDistribution)

class Dirac(openturns.model_copula.DiscreteDistribution):
    """
    Dirac distribution.

    Available constructors:
        Dirac(*x=0.*)

    Parameters
    ----------
    x : float, sequence of float, :math:`\\vect{x} \\in \\Rset^n`
        The deterministic value.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{\\vect{X} = \\vect{x}} = 1

    with :math:`\\vect{x} \\in \\Rset^n`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{\\vect{X}} & = & \\vect{x} \\\\
            \\Var{X_i} & = & 0, \\quad i = 1, \\ldots, n
        \\end{eqnarray*}

    Notes
    -----
    This is intended to be used for modelling deterministic parameters.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Dirac([1.0, 2.0, 3.0])

    Draw a sample:

    >>> sample = distribution.getSample(2)
    >>> sample[0] == sample[1]
    True
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dirac, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Dirac, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Dirac_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Dirac___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Dirac___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Dirac___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Dirac_getRealization(self)


    def getSample(self, size):
        """
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator
        """
        return _dist_bundle1.Dirac_getSample(self, size)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Dirac_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Dirac_computeCDF(self, *args)


    def computeQuantile(self, *args):
        """
        Compute the quantile function.

        Parameters
        ----------
        p : float, :math:`0 < p < 1`
            Quantile function input (a probability).

        Returns
        -------
        X : :class:`~openturns.Point`
            Quantile at probability level `p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\\vect{X}}(p) = F_{\\vect{X}}^{-1}(p),
                              \\quad p \\in [0; 1]
        """
        return _dist_bundle1.Dirac_computeQuantile(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Dirac_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Dirac_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Dirac_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Dirac_computeLogCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Dirac_computeGeneratingFunction(self, z)


    def computeLogGeneratingFunction(self, z):
        """
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input `X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle1.Dirac_computeLogGeneratingFunction(self, z)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Dirac_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Dirac_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Dirac_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Dirac_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Dirac_getStandardMoment(self, n)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirac_getParametersCollection(self)


    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirac_setParametersCollection(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Dirac_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Dirac_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Dirac_getParameterDescription(self)


    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle1.Dirac_hasEllipticalCopula(self)


    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirac_hasIndependentCopula(self)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Dirac_isElliptical(self)


    def setPoint(self, point):
        """
        Accessor to the distribution's unique value.

        Parameters
        ----------
        x : float, sequence of float, :math:`\\vect{x} \\in \\Rset^n`
            The deterministic value.
        """
        return _dist_bundle1.Dirac_setPoint(self, point)


    def getPoint(self):
        """
        Accessor to the distribution's unique value.

        Returns
        -------
        x : float, :class:`~openturns.Point`
            The deterministic value.
        """
        return _dist_bundle1.Dirac_getPoint(self)


    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle1.Dirac_getMarginal(self, *args)


    def __init__(self, *args):
        this = _dist_bundle1.new_Dirac(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Dirac
    __del__ = lambda self: None
Dirac_swigregister = _dist_bundle1.Dirac_swigregister
Dirac_swigregister(Dirac)

class DiracFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Dirac factory.

    Available constructor:
        DiracFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiracFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiracFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DiracFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.DiracFactory_build(self, *args)


    def buildAsDirac(self, *args):
        return _dist_bundle1.DiracFactory_buildAsDirac(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_DiracFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_DiracFactory
    __del__ = lambda self: None
DiracFactory_swigregister = _dist_bundle1.DiracFactory_swigregister
DiracFactory_swigregister(DiracFactory)

class Dirichlet(openturns.model_copula.ContinuousDistribution):
    """
    Dirichlet distribution.

    Available constructors:
        Dirichlet(*theta=[1.0, 1.0]*)

    Parameters
    ----------
    theta : sequence of float, :math:`\\theta_i > 0, i = 1, \\ldots, n+1`
            theta must be at least bidimensional.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{\\vect{X}}(\\vect{x}) = \\frac{\\Gamma(|\\vect{\\theta}|_1)}
                                      {\\prod_{j=1}^{n + 1} \\Gamma(\\theta_j)}
                                 \\left[1 - \\sum_{j=1}^{n} x_j
                                       \\right]^{\\theta_{n+1} - 1}
                                 \\prod_{j=1}^n x_j^{\\theta_j - 1},
                                 \\quad \\vect{x} \\in \\Delta(\\vect{X})

    with :math:`\\Delta(\\vect{X}) = \\{ \\vect{x} \\in \\Rset^n : x_i \\geq 0, \\sum_{i=1}^n x_i \\leq 1, i = 1, \\ldots, n \\}`
    and :math:`\\theta_i > 0, i = 1, \\ldots, n+1` and where :math:`|\\vect{\\theta}|_1 = \\sum_{i=1}^{n+1} \\theta_i`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{\\vect{X}} & = & \\Tr{(\\theta_i/|\\vect{\\theta}|_1,
                                         \\quad i = 1, \\ldots, n)} \\\\
            \\Cov{\\vect{X}} & = & \\left[- \\frac{\\theta_i \\theta_j}
                                              {|\\vect{\\theta}|_1^2
                                               (|\\vect{\\theta}|_1+1)},
                                       \\quad i,j = 1, \\ldots, n \\right]
        \\end{eqnarray*}

    .. warning::
        The present implementation does not model the :math:`n+1`-th component of
        the Dirichlet distribution as it is fixed:

        .. math::

            X_{n + 1} = 1 - \\sum_{i=1}^{n} X_i

    See Also
    --------
    Multinomial

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Dirichlet([1.0, 1.0, 1.0])

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dirichlet, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Dirichlet, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Dirichlet_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Dirichlet___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Dirichlet___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Dirichlet___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Dirichlet_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Dirichlet_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Dirichlet_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Dirichlet_computeCDF(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Dirichlet_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Dirichlet_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Dirichlet_getKurtosis(self)


    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirichlet_getParametersCollection(self)


    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle1.Dirichlet_setParametersCollection(self, *args)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Dirichlet_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Dirichlet_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Dirichlet_getParameterDescription(self)


    def setTheta(self, theta):
        """
        Accessor to the distribution's vector parameter.

        Parameters
        ----------
        theta : float, sequence of float, :math:`\\theta_i > 0, i = 1, \\ldots, n+1`
        """
        return _dist_bundle1.Dirichlet_setTheta(self, theta)


    def getTheta(self):
        """
        Accessor to the distribution's vector parameter.

        Returns
        -------
        theta : float, :class:`~openturns.Point`
        """
        return _dist_bundle1.Dirichlet_getTheta(self)


    def computeConditionalPDF(self, *args):
        """
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input `Xn`, `Xcond`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle1.Dirichlet_computeConditionalPDF(self, *args)


    def computeConditionalCDF(self, *args):
        """
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input `Xn`, `Xcond`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \\mid X_1, \\ldots, X_{n - 1}}(x_n) =
                \\Prob{X_n \\leq x_n \\mid X_1=x_1, \\ldots, X_{n-1}=x_{n-1}},
                \\quad x_n \\in \\supp{X_n}
        """
        return _dist_bundle1.Dirichlet_computeConditionalCDF(self, *args)


    def computeConditionalQuantile(self, *args):
        """
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input `p`, `Xcond`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle1.Dirichlet_computeConditionalQuantile(self, *args)


    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle1.Dirichlet_getMarginal(self, *args)


    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle1.Dirichlet_hasIndependentCopula(self)


    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle1.Dirichlet_hasEllipticalCopula(self)


    def getSpearmanCorrelation(self):
        """
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \\mat{\\rho_S} = \\left[\\frac{\\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\\sqrt{\\Var{F_{X_i}(X_i)} \\Var{F_{X_j}(X_j)}}},
                                 \\quad i,j = 1, \\ldots, n\\right]

        See Also
        --------
        getKendallTau
        """
        return _dist_bundle1.Dirichlet_getSpearmanCorrelation(self)


    def getKendallTau(self):
        """
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau: :class:`~openturns.SquareMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \\mat{\\tau} = \\Big[& \\Prob{X_i < x_i \\cap X_j < x_j
                                      \\cup
                                      X_i > x_i \\cap X_j > x_j} \\\\
                              & - \\Prob{X_i < x_i \\cap X_j > x_j
                                        \\cup
                                        X_i > x_i \\cap X_j < x_j},
                              \\quad i,j = 1, \\ldots, n\\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _dist_bundle1.Dirichlet_getKendallTau(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Dirichlet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Dirichlet
    __del__ = lambda self: None
Dirichlet_swigregister = _dist_bundle1.Dirichlet_swigregister
Dirichlet_swigregister(Dirichlet)

class DirichletFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Dirichlet factory.

    Available constructor:
        DirichletFactory()

    Notes
    -----
    The estimation is done by maximizing the likelihood of the sample, using the algorithm described in [Minka2012]_.

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirichletFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DirichletFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.DirichletFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.DirichletFactory_build(self, *args)


    def buildAsDirichlet(self, *args):
        return _dist_bundle1.DirichletFactory_buildAsDirichlet(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_DirichletFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_DirichletFactory
    __del__ = lambda self: None
DirichletFactory_swigregister = _dist_bundle1.DirichletFactory_swigregister
DirichletFactory_swigregister(DirichletFactory)

class Epanechnikov(openturns.model_copula.ContinuousDistribution):
    """
    Epanechnikov distribution.

    Available constructor:
        Epanechnikov()

    Notes
    -----

    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{3}{4}\\,(1 - x^2), \\quad x \\in [-1; 1]

    It has no parameters and is intended to be used as a kernel within a
    :class:`~openturns.KernelSmoothing`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & 0 \\\\
            \\Var{X} & = & \\frac{1}{5}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Epanechnikov()

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Epanechnikov, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Epanechnikov, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Epanechnikov_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Epanechnikov___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Epanechnikov___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Epanechnikov___str__(self, *args)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Epanechnikov_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Epanechnikov_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Epanechnikov_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Epanechnikov_computeComplementaryCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Epanechnikov_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Epanechnikov_computeCDFGradient(self, *args)


    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle1.Epanechnikov_getRoughness(self)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Epanechnikov_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Epanechnikov_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Epanechnikov_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Epanechnikov_getStandardMoment(self, n)


    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle1.Epanechnikov_isElliptical(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Epanechnikov(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Epanechnikov
    __del__ = lambda self: None
Epanechnikov_swigregister = _dist_bundle1.Epanechnikov_swigregister
Epanechnikov_swigregister(Epanechnikov)

class Exponential(openturns.model_copula.ContinuousDistribution):
    """
    Exponential distribution.

    Available constructors:
        Exponential(*lambda=1.0, gamma=0.0*)

    Parameters
    ----------
    lambda : float, :math:`\\lambda > 0`
        Failure rate parameter.
    gamma : float, optional
        Shift parameter :math:`\\gamma`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\lambda \\exp\\left(- \\lambda\\,(x - \\gamma)\\right),
                 \\quad x \\in [\\gamma; +\\infty[

    with :math:`\\lambda > 0` and :math:`\\gamma \\in \\Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\gamma + \\frac{1}{\\lambda} \\\\
            \\Var{X} & = & \\frac{1}{\\lambda^2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Exponential(1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Exponential, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Exponential, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Exponential_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Exponential___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Exponential___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Exponential___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Exponential_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Exponential_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Exponential_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Exponential_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Exponential_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Exponential_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Exponential_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Exponential_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Exponential_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Exponential_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Exponential_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Exponential_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Exponential_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Exponential_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Exponential_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Exponential_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Exponential_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Exponential_getParameterDescription(self)


    def setLambda(self, arg2):
        """
        Accessor to the failure rate parameter.

        Parameters
        ----------
        lambda : float, :math:`\\lambda > 0`
            Failure rate parameter.
        """
        return _dist_bundle1.Exponential_setLambda(self, arg2)


    def getLambda(self):
        """
        Accessor to the failure rate parameter.

        Returns
        -------
        lambda : float
            Failure rate parameter.
        """
        return _dist_bundle1.Exponential_getLambda(self)


    def setGamma(self, gamma):
        """
        Accessor to the shift parameter.

        Parameters
        ----------
        gamma : float, :math:`\\gamma \\in \\Rset`
            Shift parameter.
        """
        return _dist_bundle1.Exponential_setGamma(self, gamma)


    def getGamma(self):
        """
        Accessor to the shift parameter.

        Returns
        -------
        gamma : float
            Shift parameter.
        """
        return _dist_bundle1.Exponential_getGamma(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Exponential(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Exponential
    __del__ = lambda self: None
Exponential_swigregister = _dist_bundle1.Exponential_swigregister
Exponential_swigregister(Exponential)

class ExponentialFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Exponential factory.

    Available constructor:
        ExponentialFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExponentialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExponentialFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.ExponentialFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.ExponentialFactory_build(self, *args)


    def buildAsExponential(self, *args):
        return _dist_bundle1.ExponentialFactory_buildAsExponential(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_ExponentialFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_ExponentialFactory
    __del__ = lambda self: None
ExponentialFactory_swigregister = _dist_bundle1.ExponentialFactory_swigregister
ExponentialFactory_swigregister(ExponentialFactory)

class FisherSnedecor(openturns.model_copula.ContinuousDistribution):
    """
    Fisher-Snedecor distribution.

    Available constructors:
        FisherSnedecor(*d1=1.0, d2=5.0*)

    Parameters
    ----------
    d1 : float, :math:`d_1 > 0`
        First :class:`~openturns.ChiSquare` degrees of freedom (numerator).
    d2 : float, :math:`d_2 > 0`
        Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{x {\\rm B}(d_1 / 2, d_2 / 2)}
                 \\left[\\left(\\frac{d_1 x}{d_1 x + d_2}\\right)^{d_1 / 2}
                       \\left(1 - \\frac{d_1 x}{d_1 x + d_2}\\right)^{d_2 / 2}\\right],
                 \\quad x \\in \\Rset^{+*}

    with :math:`d_1, d_2 > 0` and where :math:`\\rm B` denotes Euler's beta
    function.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{d_2}{d_2 - 2} \\\\
            \\Var{X} & = & \\frac{d_1 - 2}{d_1}\\,\\frac{d_2}{d_2 + 2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.FisherSnedecor(2.0, 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FisherSnedecor, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FisherSnedecor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.FisherSnedecor_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.FisherSnedecor___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.FisherSnedecor___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.FisherSnedecor___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.FisherSnedecor_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.FisherSnedecor_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.FisherSnedecor_computeLogPDF(self, *args)


    def computeLogPDFGradient(self, *args):
        """
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.FisherSnedecor_computeLogPDFGradient(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.FisherSnedecor_computePDFGradient(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.FisherSnedecor_computeCDF(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.FisherSnedecor_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.FisherSnedecor_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.FisherSnedecor_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.FisherSnedecor_getStandardMoment(self, n)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.FisherSnedecor_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.FisherSnedecor_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.FisherSnedecor_getParameterDescription(self)


    def setD1(self, d1):
        """
        Accessor to the parameter :math:`d_1`.

        Parameters
        ----------
        d1 : float, :math:`d_1 > 0`
            First :class:`~openturns.ChiSquare` degrees of freedom (numerator).
        """
        return _dist_bundle1.FisherSnedecor_setD1(self, d1)


    def getD1(self):
        """
        Accessor to the parameter :math:`d_1`.

        Returns
        -------
        d1 : float
            First :class:`~openturns.ChiSquare` degrees of freedom (numerator).
        """
        return _dist_bundle1.FisherSnedecor_getD1(self)


    def setD2(self, d2):
        """
        Accessor to the parameter :math:`d_2`.

        Parameters
        ----------
        d2 : float, :math:`d_2 > 0`
            Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).
        """
        return _dist_bundle1.FisherSnedecor_setD2(self, d2)


    def getD2(self):
        """
        Accessor to the parameter :math:`d_2`.

        Returns
        -------
        d2 : float
            Second :class:`~openturns.ChiSquare` degrees of freedom (denominator).
        """
        return _dist_bundle1.FisherSnedecor_getD2(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_FisherSnedecor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_FisherSnedecor
    __del__ = lambda self: None
FisherSnedecor_swigregister = _dist_bundle1.FisherSnedecor_swigregister
FisherSnedecor_swigregister(FisherSnedecor)

class FisherSnedecorFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Fisher-Snedecor factory.

    Available constructor:
        FisherSnedecorFactory()

    The parameters are estimated by numerical maximum likelihood estimation.

    See also
    --------
    DistributionFactory, FisherSnedecor
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FisherSnedecorFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FisherSnedecorFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.FisherSnedecorFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.FisherSnedecorFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle1.FisherSnedecorFactory_buildEstimator(self, *args)


    def buildAsFisherSnedecor(self, *args):
        return _dist_bundle1.FisherSnedecorFactory_buildAsFisherSnedecor(self, *args)

    def getOptimizationAlgorithm(self):
        return _dist_bundle1.FisherSnedecorFactory_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        return _dist_bundle1.FisherSnedecorFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationSolver(self):
        return _dist_bundle1.FisherSnedecorFactory_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _dist_bundle1.FisherSnedecorFactory_setOptimizationSolver(self, solver)

    def __init__(self, *args):
        this = _dist_bundle1.new_FisherSnedecorFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_FisherSnedecorFactory
    __del__ = lambda self: None
FisherSnedecorFactory_swigregister = _dist_bundle1.FisherSnedecorFactory_swigregister
FisherSnedecorFactory_swigregister(FisherSnedecorFactory)

class Frechet(openturns.model_copula.ContinuousDistribution):
    """
    Frechet distribution.

    Available constructors:
        Frechet(*alpha=1.0, beta=1.0, gamma=0.0*)

    Parameters
    ----------
    alpha : float, :math:`\\alpha > 0`
        Shape parameter
    beta : float, :math:`\\beta > 0`
        Concentration parameter
    gamma : float
        Location parameter

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\alpha}{\\beta}(\\frac{x-\\gamma}{\\beta})^{-1-\\alpha}e^{-\\left(\\frac{x-\\gamma}{\\beta}\\right)^{-\\alpha}}

    with :math:`\\alpha > 0` and :math:`\\beta > 0`.

    Its cumulative density function is defined as:

    .. math::

        F_X(x) = e^{-\\left(\\frac{x-\\gamma}{\\beta}\\right)^{-\\alpha}}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Frechet(3.0, 1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Frechet, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Frechet, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Frechet_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Frechet___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Frechet___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Frechet___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Frechet_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Frechet_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Frechet_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Frechet_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Frechet_computeCDF(self, *args)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.Frechet_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Frechet_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Frechet_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Frechet_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Frechet_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Frechet_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Frechet_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Frechet_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Frechet_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Frechet_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Frechet_getParameterDescription(self)


    def setAlpha(self, alpha):
        """
        Accessor to the shape parameter.

        Parameters
        ----------
        alpha : float, :math:`\\alpha > 0`
            Shape parameter.
        """
        return _dist_bundle1.Frechet_setAlpha(self, alpha)


    def getAlpha(self):
        """
        Accessor to the shape parameter.

        Returns
        -------
        alpha : float
            Shape parameter.
        """
        return _dist_bundle1.Frechet_getAlpha(self)


    def setBeta(self, beta):
        """
        Accessor to the scale parameter.

        Parameters
        ----------
        beta : float, :math:`\\beta > 0`
            Scale parameter.
        """
        return _dist_bundle1.Frechet_setBeta(self, beta)


    def getBeta(self):
        """
        Accessor to the scale parameter.

        Returns
        -------
        beta : float
            Scale parameter.
        """
        return _dist_bundle1.Frechet_getBeta(self)


    def setGamma(self, gamma):
        """
        Accessor to the location parameter.

        Parameters
        ----------
        gamma : float, :math:`\\gamma > 0`
            Location parameter.
        """
        return _dist_bundle1.Frechet_setGamma(self, gamma)


    def getGamma(self):
        """
        Accessor to the location parameter.

        Returns
        -------
        gamma : float
            Location parameter.
        """
        return _dist_bundle1.Frechet_getGamma(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Frechet(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Frechet
    __del__ = lambda self: None
Frechet_swigregister = _dist_bundle1.Frechet_swigregister
Frechet_swigregister(Frechet)

class Gamma(openturns.model_copula.ContinuousDistribution):
    """
    Gamma distribution.

    Available constructors:
        Gamma(*k=1.0, lambda=1.0, gamma=0.0*)

    Parameters
    ----------
    k : float
        shape parameter :math:`k > 0` with :math:`k = (\\mu - \\gamma)^2 / \\sigma^2`.
    lambda : float
        scale parameter :math:`\\lambda > 0` with :math:`\\lambda = (\\mu - \\gamma) / \\sigma^2`.
    gamma : float, optional
        Shift parameter :math:`\\gamma`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\lambda}{\\Gamma(k)}
                 \\left(\\lambda (x - \\gamma)\\right)^{k - 1}
                 \\exp\\left(- \\lambda (x - \\gamma)\\right),
                 \\quad x \\in [\\gamma; +\\infty[

    with :math:`k, \\lambda > 0` and :math:`\\gamma \\in \\Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{k}{\\lambda} + \\gamma \\\\
            \\Var{X} & = & \\frac{\\sqrt{k}}{\\lambda}
        \\end{eqnarray*}


    It is possible to create a Gamma distribution from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`: see  :class:`~openturns.GammaMuSigma`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization :math:`(\\mu, \\sigma, \\gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(k, \\lambda, \\gamma)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(k, \\lambda, \\gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.Gamma(1.0, 1.0, 0.0)

    Create a it from the alternative parametrization :math:`(\\mu, \\lambda, \\gamma)`:

    >>> myDist2 = ot.Gamma()
    >>> myDist2.setParameter(ot.GammaMuSigma()([1.0, 1.0, 0.0]))

    Create it from :math:`(\\mu, \\lambda, \\gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GammaMuSigma(1.5, 2.5, -0.5)
    >>> myDist3 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Gamma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Gamma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Gamma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Gamma___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Gamma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Gamma___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Gamma_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gamma_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gamma_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Gamma_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gamma_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Gamma_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Gamma_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Gamma_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Gamma_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Gamma_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Gamma_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Gamma_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Gamma_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.Gamma_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Gamma_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Gamma_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Gamma_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Gamma_getParameterDescription(self)


    def setK(self, k):
        """
        Accessor to the distribution's shape parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
            Shape parameter :math:`k`.
        """
        return _dist_bundle1.Gamma_setK(self, k)


    def getK(self):
        """
        Accessor to the distribution's shape parameter :math:`k`.

        Returns
        -------
        k : float
            Shape parameter :math:`k`.
        """
        return _dist_bundle1.Gamma_getK(self)


    def setLambda(self, arg2):
        """
        Accessor to the distribution's scale parameter :math:`\\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\\lambda > 0`
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle1.Gamma_setLambda(self, arg2)


    def getLambda(self):
        """
        Accessor to the distribution's scale parameter :math:`\\lambda`.

        Returns
        -------
        lambda : float
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle1.Gamma_getLambda(self)


    def setKLambda(self, k, arg3):
        """
        Set the distribution's parameters.

        For scale parameter :math:`\\lambda` and shape parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
            Shape parameter :math:`k`.
        lambda : float, :math:`\\lambda > 0`
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle1.Gamma_setKLambda(self, k, arg3)


    def setGamma(self, gamma):
        """
        Accessor to the distribution's shift parameter :math:`\\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\\gamma \\in \\Rset`
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle1.Gamma_setGamma(self, gamma)


    def getGamma(self):
        """
        Accessor to the distribution's shift parameter :math:`\\gamma`.

        Returns
        -------
        gamma : float
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle1.Gamma_getGamma(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Gamma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Gamma
    __del__ = lambda self: None
Gamma_swigregister = _dist_bundle1.Gamma_swigregister
Gamma_swigregister(Gamma)

class GammaFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Gamma factory.

    Available constructor:
        GammaFactory()

    The parameters are estimated by maximum likelihood:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle\\Hat{k}_n= \\frac{(\\bar{x}_n-\\Hat{\\gamma}_n)^2}{(\\sigma_n^X)^2}\\\\
          \\displaystyle\\Hat{\\lambda}_n= \\frac{\\bar{x}_n-\\Hat{\\gamma}_n}{(\\sigma_n^X)^2}\\\\
          \\displaystyle\\Hat{\\gamma}_n = (1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, Gamma
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GammaFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GammaFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GammaFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.GammaFactory_build(self, *args)


    def buildAsGamma(self, *args):
        return _dist_bundle1.GammaFactory_buildAsGamma(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GammaFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GammaFactory
    __del__ = lambda self: None
GammaFactory_swigregister = _dist_bundle1.GammaFactory_swigregister
GammaFactory_swigregister(GammaFactory)

class GammaMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    Gamma distribution parameters.

    Available constructors:
        GammaMuSigma(*mu=1.0, sigma=1.0, gamma=0.0*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.
    gamma : float, optional
        Shift parameter.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        k &= \\left( \\frac{\\mu-\\gamma}{\\sigma} \\right)^2 \\\\
        \\lambda &= \\frac{\\mu-\\gamma}{\\sigma^2}

    See also
    --------
    Gamma

    Examples
    --------
    Create the parameters of the Gamma distribution:

    >>> import openturns as ot
    >>> parameters = ot.GammaMuSigma(1.5, 2.5, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [0.64,0.32,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0.64   0.16   0     ]
     [ -0.512 -0.256  0     ]
     [ -0.64  -0.16   1     ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GammaMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GammaMuSigma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GammaMuSigma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.GammaMuSigma___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GammaMuSigma_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle1.GammaMuSigma_gradient(self)


    def __call__(self, inP):
        return _dist_bundle1.GammaMuSigma___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GammaMuSigma_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GammaMuSigma_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GammaMuSigma_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GammaMuSigma_getDescription(self)


    def __repr__(self):
        return _dist_bundle1.GammaMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GammaMuSigma___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GammaMuSigma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GammaMuSigma
    __del__ = lambda self: None
GammaMuSigma_swigregister = _dist_bundle1.GammaMuSigma_swigregister
GammaMuSigma_swigregister(GammaMuSigma)

class GeneralizedExtremeValue(openturns.model_copula.ContinuousDistribution):
    """
    Generalized ExtremeValue distribution.

    Available constructors:
        GeneralizedExtremeValue(*mu=0.0, sigma=1.0, xi=0.0*)

    Parameters
    ----------
    mu : float
        Location parameter :math:`\\sigma`.
    sigma : float, :math:`\\sigma > 0`
        Scale parameter :math:`\\sigma`.
    xi : float
        Shape parameter :math:`\\xi`.

    Notes
    -----
    Its cumulative distribution function is defined as:

    .. math::

        F_X(x) = \\left\\{\\begin{array}{ll}
                   \\displaystyle \\exp\\left\\{-\\left[1+\\xi\\left(\\dfrac{x-\\mu}{\\sigma}\\right)\\right]^{-1/\\xi}\\right\\}
                        & \\text{ if } \\xi \\neq 0 \\\\
                   \\displaystyle \\exp\\left\\{-\\left(\\dfrac{x-\\mu}{\\sigma}\\right)\\right\\}
                        & \\text{ if } \\xi = 0
                \\end{array}\\right.

    for :math:`\\quad x \\in [\\mu-\\sigma/\\xi, +\\infty) \\text{ if } \\xi>0, x \\in \\Rset \\text{ if } \\xi=0, x \\in (-\\infty,\\mu-\\sigma/\\xi] \\text{ if } \\xi<0.`, with :math:`\\sigma > 0` and :math:`\\xi \\in \\Rset`.

    :math:`F_X` is zero for :math:`x` less than the lower bound of the support and one for :math:`x` greater than the upper bound of the support.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
        \\Expect{X} & = & \\left\\{\\begin{array}{ll}
                         \\mu+\\sigma\\dfrac{\\Gamma(1-\\xi)-1}{\\xi} & \\text{ if } \\xi < 1, \\xi\\neq 0 \\\\
                         \\mu + \\sigma\\gamma & \\text{ if } \\xi= 0 \\\\
                         \\infty & \\text{ if } \\xi \\geq 1
                         \\end{array}
                         \\right.\\\\
            \\Var{X} & = &  \\left\\{\\begin{array}{ll}
                         \\sigma^2\\dfrac{\\Gamma(1-2\\xi)-\\Gamma^2(1-\\xi)}{\\xi^2} & \\text{ if } \\xi < 1/2, \\xi\\neq 0 \\\\
                         \\sigma^2\\dfrac{\\pi^2}{6} & \\text{ if } \\xi= 0 \\\\
                         \\infty & \\text{ if } \\xi \\geq 1/2
                         \\end{array}
                         \\right.
        \\end{eqnarray*}

    where :math:`\\gamma` is Euler's constant.

    Link with other distributions: if :math:`X\\sim`:class:`~openturns.GeneralizedExtremeValue`:math:`(\\mu, \\sigma, \\xi)`, then :math:`X\\sim`:class:`~openturns.Frechet`:math:`(1/\\xi, \\sigma/\\xi, \\mu-\\sigma/\\xi)` if :math:`\\xi>0`, :math:`-X\\sim`:class:`~openturns.Weibull`:math:`(sigma/\\xi, -1/\\xi, \\sigma/\\xi-\\mu)` if :math:`\\xi<0` (note the minus sign) and :math:`X\\sim`:class:`~openturns.Gumbel`:math:`(1/\\sigma, \\mu)` if :math:`\\xi=0`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.GeneralizedExtremeValue(1.0, 2.0, -0.2)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralizedExtremeValue, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralizedExtremeValue, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.GeneralizedExtremeValue___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.GeneralizedExtremeValue___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GeneralizedExtremeValue___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.GeneralizedExtremeValue_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedExtremeValue_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.GeneralizedExtremeValue_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.GeneralizedExtremeValue_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.GeneralizedExtremeValue_getKurtosis(self)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getParameterDescription(self)


    def setMu(self, mu):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Parameters
        ----------
        mu : float
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setMu(self, mu)


    def getMu(self):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Returns
        -------
        mu : float
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getMu(self)


    def setSigma(self, sigma):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setSigma(self, sigma)


    def getSigma(self):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getSigma(self)


    def setXi(self, xi):
        """
        Accessor to the distribution's shape parameter :math:`\\xi`.

        Parameters
        ----------
        xi : float, :math:`\\xi \\in \\Rset`
            Shape parameter :math:`\\xi`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_setXi(self, xi)


    def getXi(self):
        """
        Accessor to the distribution's shape parameter :math:`\\xi`.

        Returns
        -------
        xi : float
            Shape parameter :math:`\\xi`.
        """
        return _dist_bundle1.GeneralizedExtremeValue_getXi(self)


    def setActualDistribution(self, distribution):
        """
        Accessor to the internal distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
             The actual distribution in charge of the computation (:class:`~openturns.Weibull`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_setActualDistribution(self, distribution)


    def getActualDistribution(self):
        """
        Accessor to the internal distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
             The actual distribution in charge of the computation (:class:`~openturns.Weibull`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`).
        """
        return _dist_bundle1.GeneralizedExtremeValue_getActualDistribution(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_GeneralizedExtremeValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedExtremeValue
    __del__ = lambda self: None
GeneralizedExtremeValue_swigregister = _dist_bundle1.GeneralizedExtremeValue_swigregister
GeneralizedExtremeValue_swigregister(GeneralizedExtremeValue)

class GeneralizedPareto(openturns.model_copula.ContinuousDistribution):
    """
    Generalized Pareto distribution.

    Available constructors:
        GeneralizedPareto(*sigma=1.0, xi=0.0*)

    Parameters
    ----------
    sigma : float, :math:`\\sigma > 0`
        Scale parameter :math:`\\sigma`.
    xi : float
        Shape parameter :math:`\\xi`.

    Notes
    -----
    Its cumulative distribution function is defined as:

    .. math::

        F_X(x) = \\left\\{\\begin{array}{ll}
                   \\displaystyle 1 - \\left[1 + \\xi \\frac{x}{\\sigma}\\right]^{-1/\\xi}
                        & \\text{ if } \\xi \\neq 0 \\\\
                   \\displaystyle 1 - \\exp\\left(-\\frac{x}{\\sigma}\\right)
                        & \\text{ if } \\xi = 0
                \\end{array}\\right.,
                \\quad x \\in [0; +\\infty[

    with :math:`\\sigma > 0` and :math:`\\xi \\in \\Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{\\sigma}{1 - \\xi}
                             \\quad \\text{ if } \\xi < 1 \\\\
            \\Var{X} & = & \\frac{\\sigma^2}{(1 - 2 \\xi) (1 - \\xi)^2}
                          \\quad \\text{ if } \\xi < \\frac{1}{2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.GeneralizedPareto(1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralizedPareto, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralizedPareto, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedPareto_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.GeneralizedPareto___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.GeneralizedPareto___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GeneralizedPareto___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.GeneralizedPareto_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedPareto_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedPareto_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.GeneralizedPareto_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.GeneralizedPareto_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.GeneralizedPareto_computeComplementaryCDF(self, *args)


    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        """
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level :math:`\\alpha`.
        marginalProb : float
            The value :math:`\\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)

        """
        return _dist_bundle1.GeneralizedPareto_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)


    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle1.GeneralizedPareto_computeMinimumVolumeLevelSetWithThreshold(self, prob)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.GeneralizedPareto_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.GeneralizedPareto_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.GeneralizedPareto_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.GeneralizedPareto_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.GeneralizedPareto_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.GeneralizedPareto_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.GeneralizedPareto_getKurtosis(self)


    def getStandardMoment(self, n):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle1.GeneralizedPareto_getStandardMoment(self, n)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.GeneralizedPareto_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.GeneralizedPareto_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.GeneralizedPareto_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.GeneralizedPareto_getParameterDescription(self)


    def setSigma(self, sigma):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle1.GeneralizedPareto_setSigma(self, sigma)


    def getSigma(self):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma`.

        Returns
        -------
        sigma : float
            Scale parameter :math:`\\sigma`.
        """
        return _dist_bundle1.GeneralizedPareto_getSigma(self)


    def setXi(self, xi):
        """
        Accessor to the distribution's shape parameter :math:`\\xi`.

        Parameters
        ----------
        xi : float, :math:`\\xi \\in \\Rset`
            Shape parameter :math:`\\xi`.
        """
        return _dist_bundle1.GeneralizedPareto_setXi(self, xi)


    def getXi(self):
        """
        Accessor to the distribution's shape parameter :math:`\\xi`.

        Returns
        -------
        xi : float
            Shape parameter :math:`\\xi`.
        """
        return _dist_bundle1.GeneralizedPareto_getXi(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_GeneralizedPareto(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedPareto
    __del__ = lambda self: None
GeneralizedPareto_swigregister = _dist_bundle1.GeneralizedPareto_swigregister
GeneralizedPareto_swigregister(GeneralizedPareto)

class GeneralizedParetoFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Generalized Pareto factory.

    Available constructor:
        GeneralizedParetoFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralizedParetoFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralizedParetoFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeneralizedParetoFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.GeneralizedParetoFactory_build(self, *args)


    def buildAsGeneralizedPareto(self, *args):
        return _dist_bundle1.GeneralizedParetoFactory_buildAsGeneralizedPareto(self, *args)

    def getOptimizationAlgorithm(self):
        """
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle1.GeneralizedParetoFactory_getOptimizationAlgorithm(self)


    def setOptimizationAlgorithm(self, solver):
        """
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle1.GeneralizedParetoFactory_setOptimizationAlgorithm(self, solver)


    def getOptimizationSolver(self):
        return _dist_bundle1.GeneralizedParetoFactory_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _dist_bundle1.GeneralizedParetoFactory_setOptimizationSolver(self, solver)

    def __init__(self, *args):
        this = _dist_bundle1.new_GeneralizedParetoFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GeneralizedParetoFactory
    __del__ = lambda self: None
GeneralizedParetoFactory_swigregister = _dist_bundle1.GeneralizedParetoFactory_swigregister
GeneralizedParetoFactory_swigregister(GeneralizedParetoFactory)

class Geometric(openturns.model_copula.DiscreteDistribution):
    """
    Geometric distribution.

    Available constructors:
        Geometric(*p=0.5*)

    Parameters
    ----------
    p : float, :math:`0 < p \\leq 1`
        Success probability of the Bernoulli trial.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = p (1 - p)^{k - 1},
                       \\quad \\forall k \\in \\Nset^*

    with :math:`0 < p \\leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{1}{p} \\\\
            \\Var{X} & = & \\frac{1 - p}{p^2}
        \\end{eqnarray*}

    See Also
    --------
    Bernoulli

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Geometric(0.5)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Geometric, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Geometric, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Geometric_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Geometric___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Geometric___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Geometric___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Geometric_getRealization(self)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Geometric_computePDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Geometric_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Geometric_computeComplementaryCDF(self, *args)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Geometric_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Geometric_computeCDFGradient(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Geometric_computeCharacteristicFunction(self, x)


    def computeGeneratingFunction(self, z):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle1.Geometric_computeGeneratingFunction(self, z)


    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle1.Geometric_getSupport(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Geometric_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Geometric_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Geometric_getKurtosis(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Geometric_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Geometric_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Geometric_getParameterDescription(self)


    def setP(self, p):
        """
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 < p \\leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Geometric_setP(self, p)


    def getP(self):
        """
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle1.Geometric_getP(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Geometric(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Geometric
    __del__ = lambda self: None
Geometric_swigregister = _dist_bundle1.Geometric_swigregister
Geometric_swigregister(Geometric)

class GeometricFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Geometric factory.

    Available constructor:
        GeometricFactory()

    See also
    --------
    DistributionFactory
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeometricFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeometricFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GeometricFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.GeometricFactory_build(self, *args)


    def buildAsGeometric(self, *args):
        return _dist_bundle1.GeometricFactory_buildAsGeometric(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GeometricFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GeometricFactory
    __del__ = lambda self: None
GeometricFactory_swigregister = _dist_bundle1.GeometricFactory_swigregister
GeometricFactory_swigregister(GeometricFactory)

class Gumbel(openturns.model_copula.ContinuousDistribution):
    """
    Gumbel distribution.

    Available constructors:
        Gumbel(*alpha=1.0, beta=0.0*)

    Parameters
    ----------
    alpha : float
        scale parameter :math:`\\alpha > 0`.
    beta : float
        location parameter :math:`\\beta`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\alpha
                 \\exp\\left[- \\alpha (x - \\beta)
                           - \\exp\\left(- \\alpha (x - \\beta)\\right)\\right],
                 \\quad x \\in \\Rset

    with :math:`\\alpha > 0` and :math:`\\beta \\in \\Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\beta + \\frac{\\gamma}{\\alpha} \\\\
            \\Var{X} & = & \\frac{\\pi^2}{6 \\alpha^2}
        \\end{eqnarray*}

    where :math:`\\gamma` is the Euler-Mascheroni constant.


    It is possible to create a Gumbel distribution from the alternative parametrizations :math:`(\\mu, \\sigma)`: see  :class:`~openturns.GumbelMuSigma` or :math:`(a,b)`: see  :class:`~openturns.GumbelAB`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\\alpha, \\beta)`.

    Examples
    --------
    Create a distribution in its native parameters :math:`(\\alpha, \\beta)`:

    >>> import openturns as ot
    >>> myDist = ot.Gumbel(1.0, 0.0)

    Create a it with the alternative parametrization :math:`(\\mu, \\sigma)`:

    >>> myDist2 = ot.Gumbel()
    >>> myDist2.setParameter(ot.GumbelMuSigma()([0.58, 1.28]))

    Create a it with the alternative parametrization :math:`(a,b)`:

    >>> myDist3 = ot.Gumbel()
    >>> myDist3.setParameter(ot.GumbelAB()([0.0, 1.0]))

    Create it from :math:`(\\mu, \\sigma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GumbelMuSigma(0.58, 1.28)
    >>> myDist4 = ot.ParametrizedDistribution(myParam)

    Create it from :math:`(a,b)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.GumbelAB(0.0, 1.0)
    >>> myDist5 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Gumbel, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Gumbel, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.Gumbel_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.Gumbel___eq__(self, other)

    def __repr__(self):
        return _dist_bundle1.Gumbel___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.Gumbel___str__(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle1.Gumbel_getRealization(self)


    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gumbel_computeDDF(self, *args)


    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gumbel_computePDF(self, *args)


    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle1.Gumbel_computeLogPDF(self, *args)


    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle1.Gumbel_computeCDF(self, *args)


    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle1.Gumbel_computeComplementaryCDF(self, *args)


    def computeCharacteristicFunction(self, x):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle1.Gumbel_computeCharacteristicFunction(self, x)


    def computeLogCharacteristicFunction(self, x):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle1.Gumbel_computeLogCharacteristicFunction(self, x)


    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Gumbel_computePDFGradient(self, *args)


    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle1.Gumbel_computeCDFGradient(self, *args)


    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle1.Gumbel_getStandardDeviation(self)


    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Gumbel_getSkewness(self)


    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle1.Gumbel_getKurtosis(self)


    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle1.Gumbel_getStandardRepresentative(self)


    def setParameter(self, parameter):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle1.Gumbel_setParameter(self, parameter)


    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle1.Gumbel_getParameter(self)


    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle1.Gumbel_getParameterDescription(self)


    def setAlpha(self, alpha):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\\alpha > 0`
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle1.Gumbel_setAlpha(self, alpha)


    def getAlpha(self):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Returns
        -------
        alpha : float
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle1.Gumbel_getAlpha(self)


    def setBeta(self, beta):
        """
        Accessor to the distribution's scale parameter :math:`\\beta`.

        Parameters
        ----------
        beta : float, :math:`\\beta \\in \\Rset`
            Location parameter :math:`\\beta`.
        """
        return _dist_bundle1.Gumbel_setBeta(self, beta)


    def getBeta(self):
        """
        Accessor to the distribution's location parameter :math:`\\beta`.

        Returns
        -------
        beta : float
            Location parameter :math:`\\beta`.
        """
        return _dist_bundle1.Gumbel_getBeta(self)


    def __init__(self, *args):
        this = _dist_bundle1.new_Gumbel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_Gumbel
    __del__ = lambda self: None
Gumbel_swigregister = _dist_bundle1.Gumbel_swigregister
Gumbel_swigregister(Gumbel)

class GumbelFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Gumbel factory.

    Available constructor:
        GumbelFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle\\Hat{\\alpha} =\\frac{\\pi}{\\Hat{\\sigma}_x\\sqrt{6}}\\\\
          \\displaystyle\\Hat{\\beta} =\\bar{x}_n-\\frac{\\gamma\\sqrt{6}}{\\pi}\\Hat{\\sigma}_x\\\\
        \\end{eqnarray*}

    with :math:`\\gamma \\simeq 0.57721` as Euler's constant.

    See also
    --------
    DistributionFactory, Gumbel
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GumbelFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GumbelFactory, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelFactory_getClassName(self)


    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle1.GumbelFactory_build(self, *args)


    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle1.GumbelFactory_buildEstimator(self, *args)


    def buildAsGumbel(self, *args):
        return _dist_bundle1.GumbelFactory_buildAsGumbel(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GumbelFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GumbelFactory
    __del__ = lambda self: None
GumbelFactory_swigregister = _dist_bundle1.GumbelFactory_swigregister
GumbelFactory_swigregister(GumbelFactory)

class GumbelAB(openturns.model_copula.DistributionParametersImplementation):
    """
    Gumbel distribution parameters.

    Available constructors:
        GumbelAB(*a=0.0, b=1.0*)

    Parameters
    ----------
    a : float
        Location parameter.
    b : float
        Scale parameter :math:`b > 0`.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        \\alpha &= \\frac{1}{b} \\\\
        \\beta &= a

    See also
    --------
    Gumbel

    Examples
    --------
    Create the parameters of the Gumbel distribution:

    >>> import openturns as ot
    >>> parameters = ot.GumbelAB(-0.5, 0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [2,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0  1 ]
     [ -4  0 ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GumbelAB, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GumbelAB, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelAB_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.GumbelAB___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GumbelAB_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle1.GumbelAB_gradient(self)


    def __call__(self, inP):
        return _dist_bundle1.GumbelAB___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GumbelAB_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GumbelAB_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GumbelAB_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GumbelAB_getDescription(self)


    def __repr__(self):
        return _dist_bundle1.GumbelAB___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GumbelAB___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GumbelAB(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GumbelAB
    __del__ = lambda self: None
GumbelAB_swigregister = _dist_bundle1.GumbelAB_swigregister
GumbelAB_swigregister(GumbelAB)

class GumbelMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    Gumbel distribution parameters.

    Available constructors:
        GumbelMuSigma(*mu=* :math:`\\gamma` *, sigma=* :math:`\\pi/\\sqrt{6}`)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        \\alpha &= \\frac{\\pi}{\\sigma \\sqrt{6}} \\\\
        \\beta &= \\mu - \\frac{\\gamma \\sigma \\sqrt{6}}{\\pi}

    where :math:`\\gamma` is the Euler-Mascheroni constant.

    See also
    --------
    Gumbel

    Examples
    --------
    Create the parameters of the Gumbel distribution:

    >>> import openturns as ot
    >>> parameters = ot.GumbelMuSigma(1.5, 1.3)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [0.986577,0.914931]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0         1        ]
     [ -0.758905 -0.450053 ]]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GumbelMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GumbelMuSigma, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle1.GumbelMuSigma_getClassName(self)


    def __eq__(self, other):
        return _dist_bundle1.GumbelMuSigma___eq__(self, other)

    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle1.GumbelMuSigma_getDistribution(self)


    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle1.GumbelMuSigma_gradient(self)


    def __call__(self, inP):
        return _dist_bundle1.GumbelMuSigma___call__(self, inP)

    def inverse(self, inP):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle1.GumbelMuSigma_inverse(self, inP)


    def setValues(self, values):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle1.GumbelMuSigma_setValues(self, values)


    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle1.GumbelMuSigma_getValues(self)


    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle1.GumbelMuSigma_getDescription(self)


    def __repr__(self):
        return _dist_bundle1.GumbelMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle1.GumbelMuSigma___str__(self, *args)

    def __init__(self, *args):
        this = _dist_bundle1.new_GumbelMuSigma(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _dist_bundle1.delete_GumbelMuSigma
    __del__ = lambda self: None
GumbelMuSigma_swigregister = _dist_bundle1.GumbelMuSigma_swigregister
GumbelMuSigma_swigregister(GumbelMuSigma)

# This file is compatible with both classic and new-style classes.


