# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Utility classes."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_common')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_common')
    _common = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_common', [dirname(__file__)])
        except ImportError:
            import _common
            return _common
        try:
            _mod = imp.load_module('_common', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _common = swig_import_helper()
    del swig_import_helper
else:
    import _common
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _common.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _common.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _common.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _common.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _common.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _common.SwigPyIterator_equal(self, x)

    def copy(self):
        return _common.SwigPyIterator_copy(self)

    def next(self):
        return _common.SwigPyIterator_next(self)

    def __next__(self):
        return _common.SwigPyIterator___next__(self)

    def previous(self):
        return _common.SwigPyIterator_previous(self)

    def advance(self, n):
        return _common.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _common.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _common.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _common.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _common.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _common.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _common.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _common.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _common.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self


def GetMemoryUsage():
    return _common.GetMemoryUsage()
GetMemoryUsage = _common.GetMemoryUsage

def GetFullMemoryUsage():
    return _common.GetFullMemoryUsage()
GetFullMemoryUsage = _common.GetFullMemoryUsage

def GetMaxMemoryUsage():
    return _common.GetMaxMemoryUsage()
GetMaxMemoryUsage = _common.GetMaxMemoryUsage

def GetMaxFullMemoryUsage():
    return _common.GetMaxFullMemoryUsage()
GetMaxFullMemoryUsage = _common.GetMaxFullMemoryUsage

def printMemoryUsage():
    return _common.printMemoryUsage()
printMemoryUsage = _common.printMemoryUsage

def printMemorySpectrum():
    return _common.printMemorySpectrum()
printMemorySpectrum = _common.printMemorySpectrum

def SetMemoryFlag(arg1):
    return _common.SetMemoryFlag(arg1)
SetMemoryFlag = _common.SetMemoryFlag
class TBB(_object):
    """Threading parameters."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TBB, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TBB, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsAvailable():
        """
        Ask whether threading support is available.

        Returns
        -------
        available : bool
            Whether threading support is available.
        """
        return _common.TBB_IsAvailable()

    IsAvailable = staticmethod(IsAvailable)

    def Enable():
        """
        Enable threading.

        The number of threads is the value associated to the `parallel-threads` key
        in :class:`~openturns.ResourceMap`.
        """
        return _common.TBB_Enable()

    Enable = staticmethod(Enable)

    def Disable():
        """Disable threading."""
        return _common.TBB_Disable()

    Disable = staticmethod(Disable)
    __swig_destroy__ = _common.delete_TBB
    __del__ = lambda self: None
TBB_swigregister = _common.TBB_swigregister
TBB_swigregister(TBB)

def TBB_IsAvailable():
    """
    Ask whether threading support is available.

    Returns
    -------
    available : bool
        Whether threading support is available.
    """
    return _common.TBB_IsAvailable()

def TBB_Enable():
    """
    Enable threading.

    The number of threads is the value associated to the `parallel-threads` key
    in :class:`~openturns.ResourceMap`.
    """
    return _common.TBB_Enable()

def TBB_Disable():
    """Disable threading."""
    return _common.TBB_Disable()

class Object(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Object, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Object_getClassName(self)

    __swig_destroy__ = _common.delete_Object
    __del__ = lambda self: None

    def __repr__(self):
        return _common.Object___repr__(self)

    def __str__(self, *args):
        return _common.Object___str__(self, *args)
Object_swigregister = _common.Object_swigregister
Object_swigregister(Object)


import os

def Object___getstate__(self):

    state = dict()
    study = Study()
    filename = Path.BuildTemporaryFileName('xmlfileXXXXXX')

# assume xml support
# should use BinaryStorageManager
    with open(filename, 'rb+') as infile:
        study.setStorageManager(XMLStorageManager(filename)) 
        study.add('instance', self)
        study.save()
        infile.seek(0)
        state['xmldata'] = infile.read()

    os.remove(filename)
    return state

Object.__getstate__ = Object___getstate__

def Object___setstate__(self, state):

# call ctor to initialize underlying cxx obj
# as it is instanciated from object.__new__
    self.__init__()

    study = Study()
    filename = Path.BuildTemporaryFileName('xmlfileXXXXXX')
    with open(filename, 'rb+') as outfile:
        outfile.write(state['xmldata'])
        outfile.seek(0)
        study.setStorageManager(XMLStorageManager(filename)) 
        study.load()

    study.fillObject('instance', self)
    os.remove(filename)

Object.__setstate__ = Object___setstate__

def Object__repr_html_(self):
    lines = str(self).splitlines()
    html = '<p>'
    for i in range(len(lines)):
            html += lines[i]+'<br>'+'\n'
    html += '</p>'
    return html
Object._repr_html_ = Object__repr_html_

class PersistentObject(Object):
    """PersistentObject saves and reloads the object's internal state."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PersistentObject, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PersistentObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.PersistentObject_getClassName(self)

    __swig_destroy__ = _common.delete_PersistentObject
    __del__ = lambda self: None

    def __eq__(self, arg2):
        return _common.PersistentObject___eq__(self, arg2)

    def __ne__(self, other):
        return _common.PersistentObject___ne__(self, other)

    def __repr__(self):
        return _common.PersistentObject___repr__(self)

    def __str__(self, *args):
        return _common.PersistentObject___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.PersistentObject_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObject_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObject_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObject_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObject_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.PersistentObject_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.PersistentObject_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_setName(self, name)

PersistentObject_swigregister = _common.PersistentObject_swigregister
PersistentObject_swigregister(PersistentObject)

class dynamic_cast_tag(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, dynamic_cast_tag, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, dynamic_cast_tag, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_dynamic_cast_tag()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_dynamic_cast_tag
    __del__ = lambda self: None
dynamic_cast_tag_swigregister = _common.dynamic_cast_tag_swigregister
dynamic_cast_tag_swigregister(dynamic_cast_tag)

class InterfaceObject(Object):
    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InterfaceObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.InterfaceObject_getClassName(self)


    def __repr__(self):
        return _common.InterfaceObject___repr__(self)

    def __str__(self, *args):
        return _common.InterfaceObject___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.InterfaceObject_getId(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_getName(self)

    __swig_destroy__ = _common.delete_InterfaceObject
    __del__ = lambda self: None
InterfaceObject_swigregister = _common.InterfaceObject_swigregister
InterfaceObject_swigregister(InterfaceObject)

class Study(Object):
    """
    Study.

    The study allows the user to save all its data to a structure looking like a
    map. The data are copied verbatim to the study. This is not a link, so future
    modification of the original won't affect the data saved in the study. To
    update the data saved in the study, the user has to explicitely save it again.
    Study allows the user to retrieve previously saved objects either by their name
    if a name was defined for the object or by their Id.

    Examples
    --------
    >>> import openturns as ot

    Create a Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))

    Add PersistentObjects to the study:

    >>> # a Point:
    >>> point = ot.Point(3, 0.0)
    >>> point[0] = 10.0
    >>> point[1] = 11.0
    >>> point[2] = 12.0
    >>> myStudy.add('point', point)
    >>> # a Simulation::Result:
    >>> simulationResult = ot.SimulationResult(ot.Event(), 0.5, 0.01, 150, 4)
    >>> myStudy.add('simulationResult', simulationResult)

    Get objects from the study:

    >>> print(myStudy.getObject('point'))
    [10,11,12]

    Save the Study:

    >>> myStudy.save()

    Create a new Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))

    Load data from the study:

    >>> myStudy.load()

    Create data from the ones stored in the study:

    >>> # a Point:
    >>> otherPoint = ot.Point()
    >>> myStudy.fillObject('point', otherPoint)
    >>> # a Simulation::Result:
    >>> otherSimulationResult = ot.SimulationResult()
    >>> myStudy.fillObject('simulationResult', otherSimulationResult)

    Get information from the study:

    >>> myStudy.printLabels()
    'point;simulationResult'

    Remove data:

    >>> myStudy.hasObject(otherSimulationResult.getId())
    True
    >>> myStudy.remove(otherSimulationResult)
    >>> myStudy.hasObject('simulationResult')
    False
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Study, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Study, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Study_getClassName(self)


    def __repr__(self):
        return _common.Study___repr__(self)

    def __str__(self, *args):
        return _common.Study___str__(self, *args)

    def save(self):
        """Save the study through the storage manager."""
        return _common.Study_save(self)


    def load(self):
        """Reload the study from the storage manager."""
        return _common.Study_load(self)


    def setStorageManager(self, smgr):
        """
        Set the storage manager used by the study.

        Returns
        -------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_setStorageManager(self, smgr)


    def getStorageManager(self):
        """
        Get the storage manager used by the study.

        Parameters
        ----------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_getStorageManager(self)


    def add(self, *args):
        """
        Add an object to the study.

        :Available usages:
            add(*object*)

            add(*name, object, force=False*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            Object to add in the study.
        name : str
            Name to associate with the object.
        force : bool
            If *force=True* and *name* is already defined in the study, the previous
            object associated with this name is removed. A error message is emitted
            otherwise.
        """
        return _common.Study_add(self, *args)


    def remove(self, *args):
        """
        Remove an object from the study.

        :Available usages:
            remove(*object*)

            remove(*name*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`
            An object to be removed.
        name : str
            Name of the object to be removed.
        """
        return _common.Study_remove(self, *args)


    def hasObject(self, *args):
        """
        Query if object is stored in study.

        :Available usages:
            hasObject(*id*)

            hasObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        hasObject : bool
            *True* if the object is stored in the study.
        """
        return _common.Study_hasObject(self, *args)


    def getObject(self, *args):
        """
        Get object from the study.

        :Available usages:
            getObject(*id*)

            getObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        object : :class:`~openturns.PersistentObject`
            The object saved in the study.
        """
        return _common.Study_getObject(self, *args)


    def fillObjectByName(self, *args):
        """
        Fill an object with one got from study.

        :Available usages:
            fillObjectByName(*object, name*)

            fillObjectByName(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObjectByName(self, *args)


    def fillObject(self, *args):
        """
        Fill an object with one got from study.

        :Available usages:
            fillObject(*name, object*)

            fillObject(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObject(self, *args)


    def printLabels(self):
        """
        Print all the names of the objects stored in the study.

        Returns
        -------
        names : str
            Names of the objects stored in the study.
        """
        return _common.Study_printLabels(self)


    def __init__(self, *args):
        this = _common.new_Study(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Study
    __del__ = lambda self: None
Study_swigregister = _common.Study_swigregister
Study_swigregister(Study)

class SaveAction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SaveAction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SaveAction, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_SaveAction()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_SaveAction
    __del__ = lambda self: None
SaveAction_swigregister = _common.SaveAction_swigregister
SaveAction_swigregister(SaveAction)

class LoadAction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LoadAction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LoadAction, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_LoadAction()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_LoadAction
    __del__ = lambda self: None
LoadAction_swigregister = _common.LoadAction_swigregister
LoadAction_swigregister(LoadAction)

class StorageManager(Object):
    """
    Define the way OpenTURNS' objects are saved and reloaded.

    Available constructors:
        StorageManager(*defaultVersion=1*)

    Parameters
    ----------
    defaultVersion : positive int
        Argument interpreted as the name of the object in a user point of view.
        This name is never used in another way than for user information. This name
        has no meaning to the platform.

    Notes
    -----
    A StorageManager object can be used only through its derived class
    :class:`~openturns.XMLStorageManager`.

    See also
    --------
    XMLStorageManager
    """

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StorageManager, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StorageManager, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.StorageManager_getClassName(self)


    def __init__(self, defaultVersion=1):
        this = _common.new_StorageManager(defaultVersion)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _common.StorageManager___repr__(self)

    def save(self, obj, label, fromStudy=False):
        """
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.StorageManager_save(self, obj, label, fromStudy)


    def load(self, study):
        """
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.StorageManager_load(self, study)


    def getStudy(self):
        """
        Get the study bound to the manager.

        Returns
        -------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManager_getStudy(self)


    def setStudy(self, p_study):
        """
        Set the study bound to the manager.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManager_setStudy(self, p_study)


    def getDefaultStudyVersion(self):
        """
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common.StorageManager_getDefaultStudyVersion(self)


    def getStudyVersion(self):
        """
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common.StorageManager_getStudyVersion(self)


    def setStudyVersion(self, version):
        """
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common.StorageManager_setStudyVersion(self, version)


    def initialize(self, *args):
        """
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.StorageManager_initialize(self, *args)


    def finalize(self, *args):
        """
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.StorageManager_finalize(self, *args)


    def read(self):
        """Read and create the internal representation."""
        return _common.StorageManager_read(self)


    def write(self):
        """Write the internal representation."""
        return _common.StorageManager_write(self)


    def isSavedObject(self, id):
        """
        Tell if an object is already saved.

        Returns
        -------
        isSaved : bool
            *True* if an object is already saved.
        """
        return _common.StorageManager_isSavedObject(self, id)


    def markObjectAsSaved(self, id):
        """
        Tell that an object is saved.

        Parameters
        ----------
        Id : int
            Internal identifier of the object.
        """
        return _common.StorageManager_markObjectAsSaved(self, id)

    __swig_destroy__ = _common.delete_StorageManager
    __del__ = lambda self: None
StorageManager_swigregister = _common.StorageManager_swigregister
StorageManager_swigregister(StorageManager)

class VersionList(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VersionList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VersionList, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_VersionList()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def contains(self, v):
        return _common.VersionList_contains(self, v)
    __swig_destroy__ = _common.delete_VersionList
    __del__ = lambda self: None
VersionList_swigregister = _common.VersionList_swigregister
VersionList_swigregister(VersionList)

class XMLStorageManager(StorageManager):
    """
    Storage manager that drives a XML file.

    Available constructors:
        XMLStorageManager(*filename*)

    Parameters
    ----------
    fileName : str
        Name of the file containing the study.

    Notes
    -----
    *XMLStorageManager* enables to read and write OPENTURNS' objects from a XML
    file.

    See also
    --------
    StorageManager

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a study:
    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))
    >>> # Add an object in the study:
    >>> simulationResult = ot.SimulationResult(ot.Event(), 0.5, 0.01, 150, 4)
    >>> myStudy.add('simulationResult', simulationResult)
    >>> # Save the Study in the file myStudy.xml:
    >>> myStudy.save()
    """

    __swig_setmethods__ = {}
    for _s in [StorageManager]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLStorageManager, name, value)
    __swig_getmethods__ = {}
    for _s in [StorageManager]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, XMLStorageManager, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.XMLStorageManager_getClassName(self)


    def __init__(self, filename):
        this = _common.new_XMLStorageManager(filename)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _common.XMLStorageManager___repr__(self)

    def getFileName(self):
        """
        Get the name of the file containing the study.

        Returns
        -------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_getFileName(self)


    def setFileName(self, fileName):
        """
        Set the name of the file containing the study.

        Parameters
        ----------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_setFileName(self, fileName)


    def save(self, obj, label, fromStudy=False):
        """
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.XMLStorageManager_save(self, obj, label, fromStudy)


    def load(self, study):
        """
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.XMLStorageManager_load(self, study)


    def initialize(self, *args):
        """
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.XMLStorageManager_initialize(self, *args)


    def finalize(self, *args):
        """
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.XMLStorageManager_finalize(self, *args)


    def read(self):
        """Read and create the internal representation."""
        return _common.XMLStorageManager_read(self)


    def write(self):
        """Write the internal representation."""
        return _common.XMLStorageManager_write(self)

    __swig_destroy__ = _common.delete_XMLStorageManager
    __del__ = lambda self: None
XMLStorageManager_swigregister = _common.XMLStorageManager_swigregister
XMLStorageManager_swigregister(XMLStorageManager)
cvar = _common.cvar
XMLStorageManager.SupportedVersions = _common.cvar.XMLStorageManager_SupportedVersions
XMLStorageManager.Precision_ = _common.cvar.XMLStorageManager_Precision_

class TTY(_object):
    """
    Console utilities.

    No constructor, only static methods are available.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TTY, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TTY, name)
    __repr__ = _swig_repr
    DEFAULT = _common.TTY_DEFAULT
    BOLD = _common.TTY_BOLD
    UNDERLINE = _common.TTY_UNDERLINE
    BLINK = _common.TTY_BLINK
    BLACKFG = _common.TTY_BLACKFG
    REDFG = _common.TTY_REDFG
    GREENFG = _common.TTY_GREENFG
    YELLOWFG = _common.TTY_YELLOWFG
    BLUEFG = _common.TTY_BLUEFG
    PURPLEFG = _common.TTY_PURPLEFG
    CYANFG = _common.TTY_CYANFG
    WHITEFG = _common.TTY_WHITEFG
    BLACKBG = _common.TTY_BLACKBG
    REDBG = _common.TTY_REDBG
    GREENBG = _common.TTY_GREENBG
    YELLOWBG = _common.TTY_YELLOWBG
    BLUEBG = _common.TTY_BLUEBG
    PURPLEBG = _common.TTY_PURPLEBG
    CYANBG = _common.TTY_CYANBG
    WHITEBG = _common.TTY_WHITEBG
    LASTCOLOR = _common.TTY_LASTCOLOR
    if _newclass:
        GetColor = staticmethod(_common.TTY_GetColor)
    else:
        GetColor = _common.TTY_GetColor

    def ShowColors(flag):
        """
        Accessor to the color flag.

        Parameters
        ----------
        flag : bool
            Enable or disable colored output.
        """
        return _common.TTY_ShowColors(flag)

    ShowColors = staticmethod(ShowColors)

    def ColoredOutput():
        """
        Accessor to the color flag.

        Returns
        -------
        flag : bool
            Whether colored output is enabled or disabled.
        """
        return _common.TTY_ColoredOutput()

    ColoredOutput = staticmethod(ColoredOutput)

    def __init__(self):
        this = _common.new_TTY()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_TTY
    __del__ = lambda self: None
TTY_swigregister = _common.TTY_swigregister
TTY_swigregister(TTY)

def TTY_GetColor(c):
    return _common.TTY_GetColor(c)
TTY_GetColor = _common.TTY_GetColor

def TTY_ShowColors(flag):
    """
    Accessor to the color flag.

    Parameters
    ----------
    flag : bool
        Enable or disable colored output.
    """
    return _common.TTY_ShowColors(flag)

def TTY_ColoredOutput():
    """
    Accessor to the color flag.

    Returns
    -------
    flag : bool
        Whether colored output is enabled or disabled.
    """
    return _common.TTY_ColoredOutput()

class Log(_object):
    """
    Logging utilities.

    No constructor, only static methods are available.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Log, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Log, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    if _newclass:
        Debug = staticmethod(_common.Log_Debug)
    else:
        Debug = _common.Log_Debug
    if _newclass:
        HasDebug = staticmethod(_common.Log_HasDebug)
    else:
        HasDebug = _common.Log_HasDebug
    if _newclass:
        Info = staticmethod(_common.Log_Info)
    else:
        Info = _common.Log_Info
    if _newclass:
        HasInfo = staticmethod(_common.Log_HasInfo)
    else:
        HasInfo = _common.Log_HasInfo
    if _newclass:
        User = staticmethod(_common.Log_User)
    else:
        User = _common.Log_User
    if _newclass:
        HasUser = staticmethod(_common.Log_HasUser)
    else:
        HasUser = _common.Log_HasUser
    if _newclass:
        Warn = staticmethod(_common.Log_Warn)
    else:
        Warn = _common.Log_Warn
    if _newclass:
        HasWarn = staticmethod(_common.Log_HasWarn)
    else:
        HasWarn = _common.Log_HasWarn
    if _newclass:
        Error = staticmethod(_common.Log_Error)
    else:
        Error = _common.Log_Error
    if _newclass:
        HasError = staticmethod(_common.Log_HasError)
    else:
        HasError = _common.Log_HasError
    if _newclass:
        Trace = staticmethod(_common.Log_Trace)
    else:
        Trace = _common.Log_Trace
    if _newclass:
        HasTrace = staticmethod(_common.Log_HasTrace)
    else:
        HasTrace = _common.Log_HasTrace
    if _newclass:
        SetFile = staticmethod(_common.Log_SetFile)
    else:
        SetFile = _common.Log_SetFile

    def Show(flags):
        """
        Accessor to the log flags.

        Parameters
        ----------
        flags : int
            Log flags to enable.

            Available values to be ORed:
            - DBG
            - INFO
            - USER
            - WARN
            - ERROR
            - TRACE
            - DEFAULT
            - NONE
            - ALL

        Examples
        --------
        >>> import openturns as ot
        >>> ot.Log.Show(ot.Log.DEFAULT)
        """
        return _common.Log_Show(flags)

    Show = staticmethod(Show)

    def Flags():
        """
        Accessor to the log flags.

        Returns
        ----------
        flags : int
            The enabled log flags.
        """
        return _common.Log_Flags()

    Flags = staticmethod(Flags)
    if _newclass:
        Flush = staticmethod(_common.Log_Flush)
    else:
        Flush = _common.Log_Flush
    if _newclass:
        Repeat = staticmethod(_common.Log_Repeat)
    else:
        Repeat = _common.Log_Repeat
    if _newclass:
        SetColor = staticmethod(_common.Log_SetColor)
    else:
        SetColor = _common.Log_SetColor
    if _newclass:
        GetColor = staticmethod(_common.Log_GetColor)
    else:
        GetColor = _common.Log_GetColor
    __swig_destroy__ = _common.delete_Log
    __del__ = lambda self: None
Log_swigregister = _common.Log_swigregister
Log_swigregister(Log)
Log.DBG = _common.cvar.Log_DBG
Log.INFO = _common.cvar.Log_INFO
Log.USER = _common.cvar.Log_USER
Log.WARN = _common.cvar.Log_WARN
Log.ERROR = _common.cvar.Log_ERROR
Log.TRACE = _common.cvar.Log_TRACE
Log.DEFAULT = _common.cvar.Log_DEFAULT
Log.NONE = _common.cvar.Log_NONE
Log.ALL = _common.cvar.Log_ALL

def Log_Debug(msg):
    return _common.Log_Debug(msg)
Log_Debug = _common.Log_Debug

def Log_HasDebug():
    return _common.Log_HasDebug()
Log_HasDebug = _common.Log_HasDebug

def Log_Info(msg):
    return _common.Log_Info(msg)
Log_Info = _common.Log_Info

def Log_HasInfo():
    return _common.Log_HasInfo()
Log_HasInfo = _common.Log_HasInfo

def Log_User(msg):
    return _common.Log_User(msg)
Log_User = _common.Log_User

def Log_HasUser():
    return _common.Log_HasUser()
Log_HasUser = _common.Log_HasUser

def Log_Warn(msg):
    return _common.Log_Warn(msg)
Log_Warn = _common.Log_Warn

def Log_HasWarn():
    return _common.Log_HasWarn()
Log_HasWarn = _common.Log_HasWarn

def Log_Error(msg):
    return _common.Log_Error(msg)
Log_Error = _common.Log_Error

def Log_HasError():
    return _common.Log_HasError()
Log_HasError = _common.Log_HasError

def Log_Trace(msg):
    return _common.Log_Trace(msg)
Log_Trace = _common.Log_Trace

def Log_HasTrace():
    return _common.Log_HasTrace()
Log_HasTrace = _common.Log_HasTrace

def Log_SetFile(file):
    return _common.Log_SetFile(file)
Log_SetFile = _common.Log_SetFile

def Log_Show(flags):
    """
    Accessor to the log flags.

    Parameters
    ----------
    flags : int
        Log flags to enable.

        Available values to be ORed:
        - DBG
        - INFO
        - USER
        - WARN
        - ERROR
        - TRACE
        - DEFAULT
        - NONE
        - ALL

    Examples
    --------
    >>> import openturns as ot
    >>> ot.Log.Show(ot.Log.DEFAULT)
    """
    return _common.Log_Show(flags)

def Log_Flags():
    """
    Accessor to the log flags.

    Returns
    ----------
    flags : int
        The enabled log flags.
    """
    return _common.Log_Flags()

def Log_Flush():
    return _common.Log_Flush()
Log_Flush = _common.Log_Flush

def Log_Repeat(repeat):
    return _common.Log_Repeat(repeat)
Log_Repeat = _common.Log_Repeat

def Log_SetColor(*args):
    return _common.Log_SetColor(*args)
Log_SetColor = _common.Log_SetColor

def Log_GetColor(severity):
    return _common.Log_GetColor(severity)
Log_GetColor = _common.Log_GetColor

class Log_init(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Log_init, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Log_init, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_Log_init()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Log_init
    __del__ = lambda self: None
Log_init_swigregister = _common.Log_init_swigregister
Log_init_swigregister(Log_init)

class DirectoryList(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectoryList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DirectoryList, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _common.DirectoryList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _common.DirectoryList___nonzero__(self)

    def __bool__(self):
        return _common.DirectoryList___bool__(self)

    def __len__(self):
        return _common.DirectoryList___len__(self)

    def __getslice__(self, i, j):
        return _common.DirectoryList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _common.DirectoryList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _common.DirectoryList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _common.DirectoryList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _common.DirectoryList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _common.DirectoryList___setitem__(self, *args)

    def pop(self):
        return _common.DirectoryList_pop(self)

    def append(self, x):
        return _common.DirectoryList_append(self, x)

    def empty(self):
        return _common.DirectoryList_empty(self)

    def size(self):
        return _common.DirectoryList_size(self)

    def swap(self, v):
        return _common.DirectoryList_swap(self, v)

    def begin(self):
        return _common.DirectoryList_begin(self)

    def end(self):
        return _common.DirectoryList_end(self)

    def rbegin(self):
        return _common.DirectoryList_rbegin(self)

    def rend(self):
        return _common.DirectoryList_rend(self)

    def clear(self):
        return _common.DirectoryList_clear(self)

    def get_allocator(self):
        return _common.DirectoryList_get_allocator(self)

    def pop_back(self):
        return _common.DirectoryList_pop_back(self)

    def erase(self, *args):
        return _common.DirectoryList_erase(self, *args)

    def __init__(self, *args):
        this = _common.new_DirectoryList(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x):
        return _common.DirectoryList_push_back(self, x)

    def front(self):
        return _common.DirectoryList_front(self)

    def back(self):
        return _common.DirectoryList_back(self)

    def assign(self, n, x):
        return _common.DirectoryList_assign(self, n, x)

    def resize(self, *args):
        return _common.DirectoryList_resize(self, *args)

    def insert(self, *args):
        return _common.DirectoryList_insert(self, *args)

    def reserve(self, n):
        return _common.DirectoryList_reserve(self, n)

    def capacity(self):
        return _common.DirectoryList_capacity(self)
    __swig_destroy__ = _common.delete_DirectoryList
    __del__ = lambda self: None
DirectoryList_swigregister = _common.DirectoryList_swigregister
DirectoryList_swigregister(DirectoryList)

class Path(_object):
    """
    Path utilities.

    No constructor, only static methods are available.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Path, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Path, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetInstallationDirectory():
        """
        Accessor to the installation directory.

        Returns
        -------
        installDir : str
            The installation prefix.
        """
        return _common.Path_GetInstallationDirectory()

    GetInstallationDirectory = staticmethod(GetInstallationDirectory)

    def GetConfigDirectoryList():
        """
        Accessor to config directories.

        Returns
        -------
        dirList : list of str
            The list of directories searched for config files.
        """
        return _common.Path_GetConfigDirectoryList()

    GetConfigDirectoryList = staticmethod(GetConfigDirectoryList)

    def FindFileByNameInDirectoryList(name, dirList):
        """
        Find a file.

        Parameters
        ----------
        name : str
            Filename to be found.
        dirList : sequence of str
            The list of directories to search in.


        Returns
        -------
        dirList : list of str
            The list of directories searched for config files.
        """
        return _common.Path_FindFileByNameInDirectoryList(name, dirList)

    FindFileByNameInDirectoryList = staticmethod(FindFileByNameInDirectoryList)

    def GetTemporaryDirectory():
        """
        Accessor to the temporary directory.

        Returns
        -------
        tempDir : str
            The absolute temporary directory.
        """
        return _common.Path_GetTemporaryDirectory()

    GetTemporaryDirectory = staticmethod(GetTemporaryDirectory)

    def BuildTemporaryFileName(pattern):
        """
        Create a new temporary file.

        Parameters
        ----------
        pattern : str
            Filename pattern, eg 'tmpXXXXXX'.
            The 'XXXXXXX' part will be replaced by random chars.

        Returns
        -------
        fileName : str
            The unique newly created file.
        """
        return _common.Path_BuildTemporaryFileName(pattern)

    BuildTemporaryFileName = staticmethod(BuildTemporaryFileName)

    def CreateTemporaryDirectory(directoryPrefix):
        """
        Create a new temporary directory.

        Parameters
        ----------
        directoryPrefix : str
            A subdirectory name.

        Returns
        -------
        tempDir : str
            The newly created directory.
        """
        return _common.Path_CreateTemporaryDirectory(directoryPrefix)

    CreateTemporaryDirectory = staticmethod(CreateTemporaryDirectory)

    def DeleteTemporaryDirectory(directoryName):
        """
        Remove a temporary directory.

        Parameters
        ----------
        directoryName : str
            The directory to remove.
        """
        return _common.Path_DeleteTemporaryDirectory(directoryName)

    DeleteTemporaryDirectory = staticmethod(DeleteTemporaryDirectory)
    __swig_destroy__ = _common.delete_Path
    __del__ = lambda self: None
Path_swigregister = _common.Path_swigregister
Path_swigregister(Path)

def Path_GetInstallationDirectory():
    """
    Accessor to the installation directory.

    Returns
    -------
    installDir : str
        The installation prefix.
    """
    return _common.Path_GetInstallationDirectory()

def Path_GetConfigDirectoryList():
    """
    Accessor to config directories.

    Returns
    -------
    dirList : list of str
        The list of directories searched for config files.
    """
    return _common.Path_GetConfigDirectoryList()

def Path_FindFileByNameInDirectoryList(name, dirList):
    """
    Find a file.

    Parameters
    ----------
    name : str
        Filename to be found.
    dirList : sequence of str
        The list of directories to search in.


    Returns
    -------
    dirList : list of str
        The list of directories searched for config files.
    """
    return _common.Path_FindFileByNameInDirectoryList(name, dirList)

def Path_GetTemporaryDirectory():
    """
    Accessor to the temporary directory.

    Returns
    -------
    tempDir : str
        The absolute temporary directory.
    """
    return _common.Path_GetTemporaryDirectory()

def Path_BuildTemporaryFileName(pattern):
    """
    Create a new temporary file.

    Parameters
    ----------
    pattern : str
        Filename pattern, eg 'tmpXXXXXX'.
        The 'XXXXXXX' part will be replaced by random chars.

    Returns
    -------
    fileName : str
        The unique newly created file.
    """
    return _common.Path_BuildTemporaryFileName(pattern)

def Path_CreateTemporaryDirectory(directoryPrefix):
    """
    Create a new temporary directory.

    Parameters
    ----------
    directoryPrefix : str
        A subdirectory name.

    Returns
    -------
    tempDir : str
        The newly created directory.
    """
    return _common.Path_CreateTemporaryDirectory(directoryPrefix)

def Path_DeleteTemporaryDirectory(directoryName):
    """
    Remove a temporary directory.

    Parameters
    ----------
    directoryName : str
        The directory to remove.
    """
    return _common.Path_DeleteTemporaryDirectory(directoryName)

class Catalog(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Catalog, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Catalog, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    if _newclass:
        Add = staticmethod(_common.Catalog_Add)
    else:
        Add = _common.Catalog_Add
    if _newclass:
        Get = staticmethod(_common.Catalog_Get)
    else:
        Get = _common.Catalog_Get
    if _newclass:
        GetKeys = staticmethod(_common.Catalog_GetKeys)
    else:
        GetKeys = _common.Catalog_GetKeys
    __swig_destroy__ = _common.delete_Catalog
    __del__ = lambda self: None

    def __repr__(self):
        return _common.Catalog___repr__(self)

    def __str__(self):
        return _common.Catalog___str__(self)
Catalog_swigregister = _common.Catalog_swigregister
Catalog_swigregister(Catalog)

def Catalog_Add(factoryName, p_factory):
    return _common.Catalog_Add(factoryName, p_factory)
Catalog_Add = _common.Catalog_Add

def Catalog_Get(factoryName):
    return _common.Catalog_Get(factoryName)
Catalog_Get = _common.Catalog_Get

def Catalog_GetKeys():
    return _common.Catalog_GetKeys()
Catalog_GetKeys = _common.Catalog_GetKeys

class Catalog_init(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Catalog_init, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Catalog_init, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_Catalog_init()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Catalog_init
    __del__ = lambda self: None
Catalog_init_swigregister = _common.Catalog_init_swigregister
Catalog_init_swigregister(Catalog_init)

class StringStringMap(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringStringMap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringStringMap, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _common.StringStringMap_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _common.StringStringMap___nonzero__(self)

    def __bool__(self):
        return _common.StringStringMap___bool__(self)

    def __len__(self):
        return _common.StringStringMap___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _common.StringStringMap___getitem__(self, key)

    def __delitem__(self, key):
        return _common.StringStringMap___delitem__(self, key)

    def has_key(self, key):
        return _common.StringStringMap_has_key(self, key)

    def keys(self):
        return _common.StringStringMap_keys(self)

    def values(self):
        return _common.StringStringMap_values(self)

    def items(self):
        return _common.StringStringMap_items(self)

    def __contains__(self, key):
        return _common.StringStringMap___contains__(self, key)

    def key_iterator(self):
        return _common.StringStringMap_key_iterator(self)

    def value_iterator(self):
        return _common.StringStringMap_value_iterator(self)

    def __setitem__(self, *args):
        return _common.StringStringMap___setitem__(self, *args)

    def asdict(self):
        return _common.StringStringMap_asdict(self)

    def __init__(self, *args):
        this = _common.new_StringStringMap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def empty(self):
        return _common.StringStringMap_empty(self)

    def size(self):
        return _common.StringStringMap_size(self)

    def swap(self, v):
        return _common.StringStringMap_swap(self, v)

    def begin(self):
        return _common.StringStringMap_begin(self)

    def end(self):
        return _common.StringStringMap_end(self)

    def rbegin(self):
        return _common.StringStringMap_rbegin(self)

    def rend(self):
        return _common.StringStringMap_rend(self)

    def clear(self):
        return _common.StringStringMap_clear(self)

    def get_allocator(self):
        return _common.StringStringMap_get_allocator(self)

    def count(self, x):
        return _common.StringStringMap_count(self, x)

    def erase(self, *args):
        return _common.StringStringMap_erase(self, *args)

    def find(self, x):
        return _common.StringStringMap_find(self, x)

    def lower_bound(self, x):
        return _common.StringStringMap_lower_bound(self, x)

    def upper_bound(self, x):
        return _common.StringStringMap_upper_bound(self, x)
    __swig_destroy__ = _common.delete_StringStringMap
    __del__ = lambda self: None
StringStringMap_swigregister = _common.StringStringMap_swigregister
StringStringMap_swigregister(StringStringMap)

class ResourceMap(_object):
    """
    The ResourceMap allows to manage constants that are associated to key strings.

    Find below the ResourceMap's content:

    .. execforresourcemap::

    Examples
    --------
    Get some keys:

    >>> import openturns as ot
    >>> for key in ot.ResourceMap.GetKeys()[:4]:
    ...     print(key)
    ARMA-MeanEpsilon
    ARMALikelihoodFactory-DefaultMaxFun
    ARMALikelihoodFactory-DefaultRhoBeg
    ARMALikelihoodFactory-DefaultRhoEnd
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResourceMap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ResourceMap, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def Get(key):
        """
        Access a parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Get('DiscreteDistribution-SupportEpsilon')
        '1.0e-14'
        """
        return _common.ResourceMap_Get(key)

    Get = staticmethod(Get)

    def GetAsBool(key):
        """
        Access a boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : bool
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals')
        True
        """
        return _common.ResourceMap_GetAsBool(key)

    GetAsBool = staticmethod(GetAsBool)

    def GetAsUnsignedInteger(key):
        """
        Access an integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : int
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsUnsignedInteger('MCMC-DefaultBurnIn')
        0...
        """
        return _common.ResourceMap_GetAsUnsignedInteger(key)

    GetAsUnsignedInteger = staticmethod(GetAsUnsignedInteger)

    def GetAsScalar(key):
        """
        Access a floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : float
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsScalar('SQP-DefaultTau')
        0.5
        """
        return _common.ResourceMap_GetAsScalar(key)

    GetAsScalar = staticmethod(GetAsScalar)
    if _newclass:
        GetAsNumericalScalar = staticmethod(_common.ResourceMap_GetAsNumericalScalar)
    else:
        GetAsNumericalScalar = _common.ResourceMap_GetAsNumericalScalar

    def Set(key, value):
        """
        Access a parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Set('DiscreteDistribution-SupportEpsilon', '1.0e-14')
        """
        return _common.ResourceMap_Set(key, value)

    Set = staticmethod(Set)

    def SetAsBool(key, value):
        """
        Access a boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : bool
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals', True)
        """
        return _common.ResourceMap_SetAsBool(key, value)

    SetAsBool = staticmethod(SetAsBool)

    def SetAsUnsignedInteger(key, value):
        """
        Access an integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : int
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsUnsignedInteger('MCMC-DefaultBurnIn', 0)
        """
        return _common.ResourceMap_SetAsUnsignedInteger(key, value)

    SetAsUnsignedInteger = staticmethod(SetAsUnsignedInteger)

    def SetAsScalar(key, value):
        """
        Access a floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : float
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsScalar('SQP-DefaultTau', 0.5)
        """
        return _common.ResourceMap_SetAsScalar(key, value)

    SetAsScalar = staticmethod(SetAsScalar)
    if _newclass:
        SetAsNumericalScalar = staticmethod(_common.ResourceMap_SetAsNumericalScalar)
    else:
        SetAsNumericalScalar = _common.ResourceMap_SetAsNumericalScalar

    def GetSize():
        """
        Get the size of the ResourceMap.

        Returns
        -------
        size : positive int
            The number of constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetSize()

    GetSize = staticmethod(GetSize)

    def GetKeys():
        """
        Get the keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of identifiers.
        """
        return _common.ResourceMap_GetKeys()

    GetKeys = staticmethod(GetKeys)

    def __repr__(self):
        return _common.ResourceMap___repr__(self)

    def __len__(self):
        return _common.ResourceMap___len__(self)
    __swig_destroy__ = _common.delete_ResourceMap
    __del__ = lambda self: None
ResourceMap_swigregister = _common.ResourceMap_swigregister
ResourceMap_swigregister(ResourceMap)

def ResourceMap_Get(key):
    """
    Access a parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : str
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.Get('DiscreteDistribution-SupportEpsilon')
    '1.0e-14'
    """
    return _common.ResourceMap_Get(key)

def ResourceMap_GetAsBool(key):
    """
    Access a boolean parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : bool
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals')
    True
    """
    return _common.ResourceMap_GetAsBool(key)

def ResourceMap_GetAsUnsignedInteger(key):
    """
    Access an integer parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : int
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsUnsignedInteger('MCMC-DefaultBurnIn')
    0...
    """
    return _common.ResourceMap_GetAsUnsignedInteger(key)

def ResourceMap_GetAsScalar(key):
    """
    Access a floating-point parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : float
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsScalar('SQP-DefaultTau')
    0.5
    """
    return _common.ResourceMap_GetAsScalar(key)

def ResourceMap_GetAsNumericalScalar(key):
    return _common.ResourceMap_GetAsNumericalScalar(key)
ResourceMap_GetAsNumericalScalar = _common.ResourceMap_GetAsNumericalScalar

def ResourceMap_Set(key, value):
    """
    Access a parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : str
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.Set('DiscreteDistribution-SupportEpsilon', '1.0e-14')
    """
    return _common.ResourceMap_Set(key, value)

def ResourceMap_SetAsBool(key, value):
    """
    Access a boolean parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : bool
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals', True)
    """
    return _common.ResourceMap_SetAsBool(key, value)

def ResourceMap_SetAsUnsignedInteger(key, value):
    """
    Access an integer parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : int
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsUnsignedInteger('MCMC-DefaultBurnIn', 0)
    """
    return _common.ResourceMap_SetAsUnsignedInteger(key, value)

def ResourceMap_SetAsScalar(key, value):
    """
    Access a floating-point parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : float
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsScalar('SQP-DefaultTau', 0.5)
    """
    return _common.ResourceMap_SetAsScalar(key, value)

def ResourceMap_SetAsNumericalScalar(key, value):
    return _common.ResourceMap_SetAsNumericalScalar(key, value)
ResourceMap_SetAsNumericalScalar = _common.ResourceMap_SetAsNumericalScalar

def ResourceMap_GetSize():
    """
    Get the size of the ResourceMap.

    Returns
    -------
    size : positive int
        The number of constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetSize()

def ResourceMap_GetKeys():
    """
    Get the keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of identifiers.
    """
    return _common.ResourceMap_GetKeys()

class ResourceMap_init(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResourceMap_init, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ResourceMap_init, name)
    __repr__ = _swig_repr

    def __init__(self):
        this = _common.new_ResourceMap_init()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_ResourceMap_init
    __del__ = lambda self: None
ResourceMap_init_swigregister = _common.ResourceMap_init_swigregister
ResourceMap_init_swigregister(ResourceMap_init)

class ComparisonOperatorImplementation(PersistentObject):
    __swig_setmethods__ = {}
    for _s in [PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComparisonOperatorImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComparisonOperatorImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperatorImplementation_getClassName(self)


    def __repr__(self):
        return _common.ComparisonOperatorImplementation___repr__(self)

    def __call__(self, a, b):
        return _common.ComparisonOperatorImplementation___call__(self, a, b)

    def __init__(self, *args):
        this = _common.new_ComparisonOperatorImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementation
    __del__ = lambda self: None
ComparisonOperatorImplementation_swigregister = _common.ComparisonOperatorImplementation_swigregister
ComparisonOperatorImplementation_swigregister(ComparisonOperatorImplementation)

class ComparisonOperatorImplementationTypedInterfaceObject(InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComparisonOperatorImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComparisonOperatorImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _common.new_ComparisonOperatorImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _common.ComparisonOperatorImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementationTypedInterfaceObject
    __del__ = lambda self: None
ComparisonOperatorImplementationTypedInterfaceObject_swigregister = _common.ComparisonOperatorImplementationTypedInterfaceObject_swigregister
ComparisonOperatorImplementationTypedInterfaceObject_swigregister(ComparisonOperatorImplementationTypedInterfaceObject)

class ComparisonOperator(ComparisonOperatorImplementationTypedInterfaceObject):
    """
    Base class for comparison operators.

    Notes
    -----
    Comparison operators are defined through the following implementations : 
    :class:`~openturns.Equal`, :class:`~openturns.Greater`,
    :class:`~openturns.GreaterOrEqual`, :class:`~openturns.Less` or 
    :class:`~openturns.LessOrEqual`

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComparisonOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComparisonOperator, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperator_getClassName(self)


    def __call__(self, a, b):
        return _common.ComparisonOperator___call__(self, a, b)

    def compare(self, a, b):
        """
        Compare two values.

        Parameters
        ----------
        a : float
            First input to compare.
        b : float
            Second input to compare.
        """
        return _common.ComparisonOperator_compare(self, a, b)


    def __str__(self):
        return _common.ComparisonOperator___str__(self)

    def __init__(self, *args):
        this = _common.new_ComparisonOperator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_ComparisonOperator
    __del__ = lambda self: None
ComparisonOperator_swigregister = _common.ComparisonOperator_swigregister
ComparisonOperator_swigregister(ComparisonOperator)

class Equal(ComparisonOperatorImplementation):
    """
    Equal comparison operator.

    Available constructors:
        Equal()

    See also
    --------
    Greater, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Equal()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Equal, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Equal, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Equal_getClassName(self)


    def __repr__(self):
        return _common.Equal___repr__(self)

    def __call__(self, a, b):
        return _common.Equal___call__(self, a, b)

    def __str__(self):
        return _common.Equal___str__(self)

    def __init__(self, *args):
        this = _common.new_Equal(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Equal
    __del__ = lambda self: None
Equal_swigregister = _common.Equal_swigregister
Equal_swigregister(Equal)

class Greater(ComparisonOperatorImplementation):
    """
    Greater comparison operator.

    Available constructors:
        Greater()

    See also
    --------
    Equal, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Greater()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    False

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Greater, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Greater, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Greater_getClassName(self)


    def __repr__(self):
        return _common.Greater___repr__(self)

    def __call__(self, a, b):
        return _common.Greater___call__(self, a, b)

    def __str__(self):
        return _common.Greater___str__(self)

    def __init__(self, *args):
        this = _common.new_Greater(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Greater
    __del__ = lambda self: None
Greater_swigregister = _common.Greater_swigregister
Greater_swigregister(Greater)

class GreaterOrEqual(ComparisonOperatorImplementation):
    """
    Greater or equal comparison operator.

    Available constructors:
        GreaterOrEqual()

    See also
    --------
    Equal, Greater, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.GreaterOrEqual()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    True

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GreaterOrEqual, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GreaterOrEqual, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.GreaterOrEqual_getClassName(self)


    def __repr__(self):
        return _common.GreaterOrEqual___repr__(self)

    def __call__(self, a, b):
        return _common.GreaterOrEqual___call__(self, a, b)

    def __str__(self):
        return _common.GreaterOrEqual___str__(self)

    def __init__(self, *args):
        this = _common.new_GreaterOrEqual(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_GreaterOrEqual
    __del__ = lambda self: None
GreaterOrEqual_swigregister = _common.GreaterOrEqual_swigregister
GreaterOrEqual_swigregister(GreaterOrEqual)

class Less(ComparisonOperatorImplementation):
    """
    Less comparison operator.

    Available constructors:
        Less()

    See also
    --------
    Equal, Greater, GreaterOrEqual, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Less()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    False

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Less, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Less, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Less_getClassName(self)


    def __repr__(self):
        return _common.Less___repr__(self)

    def __call__(self, a, b):
        return _common.Less___call__(self, a, b)

    def __str__(self):
        return _common.Less___str__(self)

    def __init__(self, *args):
        this = _common.new_Less(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_Less
    __del__ = lambda self: None
Less_swigregister = _common.Less_swigregister
Less_swigregister(Less)

class LessOrEqual(ComparisonOperatorImplementation):
    """
    Less or equal comparison operator.

    Available constructors:
        LessOrEqual()

    See also
    --------
    Equal, Greater, GreaterOrEqual, Less

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.LessOrEqual()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    __swig_setmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LessOrEqual, name, value)
    __swig_getmethods__ = {}
    for _s in [ComparisonOperatorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LessOrEqual, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.LessOrEqual_getClassName(self)


    def __repr__(self):
        return _common.LessOrEqual___repr__(self)

    def __call__(self, a, b):
        return _common.LessOrEqual___call__(self, a, b)

    def __str__(self):
        return _common.LessOrEqual___str__(self)

    def __init__(self, *args):
        this = _common.new_LessOrEqual(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_LessOrEqual
    __del__ = lambda self: None
LessOrEqual_swigregister = _common.LessOrEqual_swigregister
LessOrEqual_swigregister(LessOrEqual)

class PlatformInfo(_object):
    """
    Informations about platform.

    No constructor, only static methods are available.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PlatformInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PlatformInfo, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetVersion():
        """
        Accessor to the version string.

        Returns
        -------
        version : str
            Version string.
        """
        return _common.PlatformInfo_GetVersion()

    GetVersion = staticmethod(GetVersion)
    if _newclass:
        GetName = staticmethod(_common.PlatformInfo_GetName)
    else:
        GetName = _common.PlatformInfo_GetName

    def GetRevision():
        """
        Accessor to the revision string.

        Returns
        -------
        revision : str
            Git revision.
        """
        return _common.PlatformInfo_GetRevision()

    GetRevision = staticmethod(GetRevision)
    if _newclass:
        GetDate = staticmethod(_common.PlatformInfo_GetDate)
    else:
        GetDate = _common.PlatformInfo_GetDate
    if _newclass:
        GetInstallationDirectory = staticmethod(_common.PlatformInfo_GetInstallationDirectory)
    else:
        GetInstallationDirectory = _common.PlatformInfo_GetInstallationDirectory
    if _newclass:
        GetConfigureCommandLine = staticmethod(_common.PlatformInfo_GetConfigureCommandLine)
    else:
        GetConfigureCommandLine = _common.PlatformInfo_GetConfigureCommandLine

    def GetNumericalPrecision():
        """
        Accessor to the output numerical precision.

        Returns
        -------
        int : precision
            String ouput numerical precision.
        """
        return _common.PlatformInfo_GetNumericalPrecision()

    GetNumericalPrecision = staticmethod(GetNumericalPrecision)

    def SetNumericalPrecision(precision):
        """
        Accessor to the output numerical precision.

        Parameters
        ----------
        int : precision
            String ouput numerical precision.
        """
        return _common.PlatformInfo_SetNumericalPrecision(precision)

    SetNumericalPrecision = staticmethod(SetNumericalPrecision)
    __swig_destroy__ = _common.delete_PlatformInfo
    __del__ = lambda self: None
PlatformInfo_swigregister = _common.PlatformInfo_swigregister
PlatformInfo_swigregister(PlatformInfo)

def PlatformInfo_GetVersion():
    """
    Accessor to the version string.

    Returns
    -------
    version : str
        Version string.
    """
    return _common.PlatformInfo_GetVersion()

def PlatformInfo_GetName():
    return _common.PlatformInfo_GetName()
PlatformInfo_GetName = _common.PlatformInfo_GetName

def PlatformInfo_GetRevision():
    """
    Accessor to the revision string.

    Returns
    -------
    revision : str
        Git revision.
    """
    return _common.PlatformInfo_GetRevision()

def PlatformInfo_GetDate():
    return _common.PlatformInfo_GetDate()
PlatformInfo_GetDate = _common.PlatformInfo_GetDate

def PlatformInfo_GetInstallationDirectory():
    return _common.PlatformInfo_GetInstallationDirectory()
PlatformInfo_GetInstallationDirectory = _common.PlatformInfo_GetInstallationDirectory

def PlatformInfo_GetConfigureCommandLine():
    return _common.PlatformInfo_GetConfigureCommandLine()
PlatformInfo_GetConfigureCommandLine = _common.PlatformInfo_GetConfigureCommandLine

def PlatformInfo_GetNumericalPrecision():
    """
    Accessor to the output numerical precision.

    Returns
    -------
    int : precision
        String ouput numerical precision.
    """
    return _common.PlatformInfo_GetNumericalPrecision()

def PlatformInfo_SetNumericalPrecision(precision):
    """
    Accessor to the output numerical precision.

    Parameters
    ----------
    int : precision
        String ouput numerical precision.
    """
    return _common.PlatformInfo_SetNumericalPrecision(precision)

class ComparisonOperatorImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComparisonOperatorImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ComparisonOperatorImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _common.ComparisonOperatorImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _common.ComparisonOperatorImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_common.ComparisonOperatorImplementationPointer_ptr__get, _common.ComparisonOperatorImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _common.new_ComparisonOperatorImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _common.ComparisonOperatorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _common.ComparisonOperatorImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _common.ComparisonOperatorImplementationPointer___deref__(self)

    def isNull(self):
        return _common.ComparisonOperatorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _common.ComparisonOperatorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.ComparisonOperatorImplementationPointer_get(self)

    def getImplementation(self):
        return _common.ComparisonOperatorImplementationPointer_getImplementation(self)

    def unique(self):
        return _common.ComparisonOperatorImplementationPointer_unique(self)

    def use_count(self):
        return _common.ComparisonOperatorImplementationPointer_use_count(self)

    def swap(self, other):
        return _common.ComparisonOperatorImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperatorImplementationPointer_getClassName(self)


    def __repr__(self):
        return _common.ComparisonOperatorImplementationPointer___repr__(self)

    def __call__(self, a, b):
        return _common.ComparisonOperatorImplementationPointer___call__(self, a, b)

    def __eq__(self, arg2):
        return _common.ComparisonOperatorImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _common.ComparisonOperatorImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _common.ComparisonOperatorImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.ComparisonOperatorImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.ComparisonOperatorImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.ComparisonOperatorImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.ComparisonOperatorImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationPointer_setName(self, name)

ComparisonOperatorImplementationPointer_swigregister = _common.ComparisonOperatorImplementationPointer_swigregister
ComparisonOperatorImplementationPointer_swigregister(ComparisonOperatorImplementationPointer)

class PersistentObjectPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PersistentObjectPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PersistentObjectPointer, name)
    __swig_setmethods__["ptr_"] = _common.PersistentObjectPointer_ptr__set
    __swig_getmethods__["ptr_"] = _common.PersistentObjectPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_common.PersistentObjectPointer_ptr__get, _common.PersistentObjectPointer_ptr__set)

    def __init__(self, *args):
        this = _common.new_PersistentObjectPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_PersistentObjectPointer
    __del__ = lambda self: None

    def reset(self):
        return _common.PersistentObjectPointer_reset(self)

    def __ref__(self, *args):
        return _common.PersistentObjectPointer___ref__(self, *args)

    def __deref__(self):
        return _common.PersistentObjectPointer___deref__(self)

    def isNull(self):
        return _common.PersistentObjectPointer_isNull(self)

    def __nonzero__(self):
        return _common.PersistentObjectPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.PersistentObjectPointer_get(self)

    def getImplementation(self):
        return _common.PersistentObjectPointer_getImplementation(self)

    def unique(self):
        return _common.PersistentObjectPointer_unique(self)

    def use_count(self):
        return _common.PersistentObjectPointer_use_count(self)

    def swap(self, other):
        return _common.PersistentObjectPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.PersistentObjectPointer_getClassName(self)


    def __eq__(self, arg2):
        return _common.PersistentObjectPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _common.PersistentObjectPointer___ne__(self, other)

    def __repr__(self):
        return _common.PersistentObjectPointer___repr__(self)

    def __str__(self, *args):
        return _common.PersistentObjectPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.PersistentObjectPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObjectPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObjectPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObjectPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObjectPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.PersistentObjectPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.PersistentObjectPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.PersistentObjectPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.PersistentObjectPointer_setName(self, name)

PersistentObjectPointer_swigregister = _common.PersistentObjectPointer_swigregister
PersistentObjectPointer_swigregister(PersistentObjectPointer)

class StorageManagerPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StorageManagerPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StorageManagerPointer, name)
    __swig_setmethods__["ptr_"] = _common.StorageManagerPointer_ptr__set
    __swig_getmethods__["ptr_"] = _common.StorageManagerPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_common.StorageManagerPointer_ptr__get, _common.StorageManagerPointer_ptr__set)

    def __init__(self, *args):
        this = _common.new_StorageManagerPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _common.delete_StorageManagerPointer
    __del__ = lambda self: None

    def reset(self):
        return _common.StorageManagerPointer_reset(self)

    def __ref__(self, *args):
        return _common.StorageManagerPointer___ref__(self, *args)

    def __deref__(self):
        return _common.StorageManagerPointer___deref__(self)

    def isNull(self):
        return _common.StorageManagerPointer_isNull(self)

    def __nonzero__(self):
        return _common.StorageManagerPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.StorageManagerPointer_get(self)

    def getImplementation(self):
        return _common.StorageManagerPointer_getImplementation(self)

    def unique(self):
        return _common.StorageManagerPointer_unique(self)

    def use_count(self):
        return _common.StorageManagerPointer_use_count(self)

    def swap(self, other):
        return _common.StorageManagerPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.StorageManagerPointer_getClassName(self)


    def __repr__(self):
        return _common.StorageManagerPointer___repr__(self)

    def save(self, obj, label, fromStudy=False):
        """
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.StorageManagerPointer_save(self, obj, label, fromStudy)


    def load(self, study):
        """
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.StorageManagerPointer_load(self, study)


    def getStudy(self):
        """
        Get the study bound to the manager.

        Returns
        -------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManagerPointer_getStudy(self)


    def setStudy(self, p_study):
        """
        Set the study bound to the manager.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManagerPointer_setStudy(self, p_study)


    def getDefaultStudyVersion(self):
        """
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common.StorageManagerPointer_getDefaultStudyVersion(self)


    def getStudyVersion(self):
        """
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common.StorageManagerPointer_getStudyVersion(self)


    def setStudyVersion(self, version):
        """
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common.StorageManagerPointer_setStudyVersion(self, version)


    def initialize(self, *args):
        """
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.StorageManagerPointer_initialize(self, *args)


    def finalize(self, *args):
        """
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.StorageManagerPointer_finalize(self, *args)


    def read(self):
        """Read and create the internal representation."""
        return _common.StorageManagerPointer_read(self)


    def write(self):
        """Write the internal representation."""
        return _common.StorageManagerPointer_write(self)


    def isSavedObject(self, id):
        """
        Tell if an object is already saved.

        Returns
        -------
        isSaved : bool
            *True* if an object is already saved.
        """
        return _common.StorageManagerPointer_isSavedObject(self, id)


    def markObjectAsSaved(self, id):
        """
        Tell that an object is saved.

        Parameters
        ----------
        Id : int
            Internal identifier of the object.
        """
        return _common.StorageManagerPointer_markObjectAsSaved(self, id)


    def __str__(self, *args):
        return _common.StorageManagerPointer___str__(self, *args)
StorageManagerPointer_swigregister = _common.StorageManagerPointer_swigregister
StorageManagerPointer_swigregister(StorageManagerPointer)

# This file is compatible with both classic and new-style classes.


