# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Classification algorithms."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_classification')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_classification')
    _classification = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_classification', [dirname(__file__)])
        except ImportError:
            import _classification
            return _classification
        try:
            _mod = imp.load_module('_classification', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _classification = swig_import_helper()
    del swig_import_helper
else:
    import _classification
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _classification.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _classification.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _classification.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _classification.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _classification.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _classification.SwigPyIterator_equal(self, x)

    def copy(self):
        return _classification.SwigPyIterator_copy(self)

    def next(self):
        return _classification.SwigPyIterator_next(self)

    def __next__(self):
        return _classification.SwigPyIterator___next__(self)

    def previous(self):
        return _classification.SwigPyIterator_previous(self)

    def advance(self, n):
        return _classification.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _classification.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _classification.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _classification.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _classification.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _classification.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _classification.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _classification.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _classification.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.dist_bundle1
import openturns.dist_bundle2
class MixtureClassifier(openturns.algo.ClassifierImplementation):
    """
    Particular classifier based on a mixture distribution.

    Available constructors:
        MixtureClassifier(*mixtDist*)

    Parameters
    ----------
    mixtDist : :class:`~openturns.Mixture`
        A mixture distribution.

    See also
    --------
    Classifier, ExpertMixture

    Notes
    -----
    This implements a mixture classifier which is a particular classifier based on
    a mixture distribution:

    .. math::

        p( \\vect{x} ) = \\sum_{i=1}^N w_i p_i ( \\vect{x} )

    The classifier proposes :math:`N` classes. The rule to assign a point 
    :math:`\\vect{x}` to a class :math:`i` is defined as follows: 

    .. math::

        i = \\argmax_k \\log w_k p_k( \\vect{x} )

    See useful methods :meth:`classify` and :meth:`grade`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.algo.ClassifierImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MixtureClassifier, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.algo.ClassifierImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MixtureClassifier, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _classification.MixtureClassifier_getClassName(self)


    def __repr__(self):
        return _classification.MixtureClassifier___repr__(self)

    def classify(self, *args):
        """
        Classify points according to the classifier.

        **Available usages**:

            classify(*inputPoint*)

            classify(*inputSample*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to classify.
        inputSample : 2-d a sequence of float
            A set of point to classify.

        Notes
        -----
        The classifier proposes :math:`N` classes where :math:`N` is the dimension of
        the mixture distribution *mixtDist*. The rule to assign a point :math:`\\vect{x}`
        to a class :math:`i` is defined as follows: 

        .. math::

            i = \\argmax_k \\log w_k p_k( \\vect{x} )

        In the first usage, it returns an integer which corresponds to the class where
        *inputPoint* has been assigned.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        class of each point of *inputSample*.
        """
        return _classification.MixtureClassifier_classify(self, *args)


    def grade(self, inP, outC):
        """
        Grade points according to the classifier.

        **Available usages**:

            grade(*inputPoint, k*)

            grade(*inputSample, classList*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to grade.
        inputSample : 2-d a sequence of float
            A set of point to grade.
        k : integer
            The class number.
        classList : sequence of integer
            The list of class number.

        Notes
        -----
        The grade of :math:`\\vect{x}` with respect to the class *k* is
        :math:`log w_k p_k ( \\vect{x} )`.

        In the first usage, it returns a real that grades *inputPoint* with respect to
        the class *k*. The greatest, the best.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        grades of the :math:`i^{th}` point of *inputSample* with respect to the
        :math:`i^{th}` class of *classList*.
        """
        return _classification.MixtureClassifier_grade(self, inP, outC)


    def getMixture(self):
        """
        Accessor to the mixture distribution.

        Returns
        -------
        mixtDist : :class:`~openturns.Mixture`
            The mixture distribution.
        """
        return _classification.MixtureClassifier_getMixture(self)


    def setMixture(self, mixture):
        """
        Accessor to the mixture distribution.

        Parameters
        ----------
        mixtDist : :class:`~openturns.Mixture`
            The mixture distribution.
        """
        return _classification.MixtureClassifier_setMixture(self, mixture)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dim : integer
            The dimension of the classifier.
        """
        return _classification.MixtureClassifier_getDimension(self)


    def __init__(self, *args):
        this = _classification.new_MixtureClassifier(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _classification.delete_MixtureClassifier
    __del__ = lambda self: None
MixtureClassifier_swigregister = _classification.MixtureClassifier_swigregister
MixtureClassifier_swigregister(MixtureClassifier)

# This file is compatible with both classic and new-style classes.


