# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Bayesian algorithms."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_bayesian')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_bayesian')
    _bayesian = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_bayesian', [dirname(__file__)])
        except ImportError:
            import _bayesian
            return _bayesian
        try:
            _mod = imp.load_module('_bayesian', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _bayesian = swig_import_helper()
    del swig_import_helper
else:
    import _bayesian
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _bayesian.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _bayesian.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _bayesian.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _bayesian.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _bayesian.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _bayesian.SwigPyIterator_equal(self, x)

    def copy(self):
        return _bayesian.SwigPyIterator_copy(self)

    def next(self):
        return _bayesian.SwigPyIterator_next(self)

    def __next__(self):
        return _bayesian.SwigPyIterator___next__(self)

    def previous(self):
        return _bayesian.SwigPyIterator_previous(self)

    def advance(self, n):
        return _bayesian.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _bayesian.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _bayesian.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _bayesian.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _bayesian.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _bayesian.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _bayesian.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _bayesian.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _bayesian.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.randomvector
class CalibrationStrategyImplementation(openturns.common.PersistentObject):
    """
    Calibration strategy.

    Available constructors:
        CalibrationStrategy(*range*)

        CalibrationStrategy(*range=[0.117, 0.468], expansionFactor=1.2, shrinkFactor=0.8, calibrationStep=100*)

    Parameters
    ----------
    range : :class:`~openturns.Interval` of dimension 1 :math:`[m,M]`
        Acceptance rate values for which no update of the *calibration* coefficient
        is performed.
    expansionFactor : float, :math:`e > 1`
        Expansion factor :math:`e` to use to rescale the *calibration* coefficient
        if the latter is too high (greater than the upper bound of range).
    shrinkFactor : float, :math:`0 < s < 1`
        Shrink factor :math:`s` to use to rescale the *calibration* coefficient if
        the latter is too low (smaller than the lower bound of range). If
        *expansionFactor* is specified, *shrinkFactor* must be mentioned too.
    calibrationStep : positive int
        Calibration step corresponding for example to :math:`q` in the description
        of the method
        :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
        of the RandomWalkMetropolisHastings class.

    Notes
    -----
    A CalibrationStrategy can be used by a
    :class:`~openturns.RandomWalkMetropolisHastings` for example (see the
    description of the method
    :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
    ).
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CalibrationStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CalibrationStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategyImplementation_getClassName(self)


    def __repr__(self):
        return _bayesian.CalibrationStrategyImplementation___repr__(self)

    def setRange(self, range):
        """
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setRange(self, range)


    def getRange(self):
        """
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getRange(self)


    def setExpansionFactor(self, expansionFactor):
        """
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setExpansionFactor(self, expansionFactor)


    def getExpansionFactor(self):
        """
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getExpansionFactor(self)


    def setShrinkFactor(self, shrinkFactor):
        """
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setShrinkFactor(self, shrinkFactor)


    def getShrinkFactor(self):
        """
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getShrinkFactor(self)


    def setCalibrationStep(self, calibrationStep):
        """
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementation_setCalibrationStep(self, calibrationStep)


    def getCalibrationStep(self):
        """
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementation_getCalibrationStep(self)


    def computeUpdateFactor(self, rho):
        """
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\\phi(\\rho)` such that :math:`\\phi(\\rho) \\lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

        .. math::

            \\phi(\\rho) = \\left\\{
                         \\begin{array}{l}
                             \\displaystyle s  \\quad if \\; \\rho < m \\\\
                             \\displaystyle e  \\quad if \\; \\rho > M \\\\
                             \\displaystyle 1  \\quad otherwise
                         \\end{array}
                         \\right.

        with :math:`s \\in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
        respectively, by the methods :meth:`getShrinkFactor`,
        :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategyImplementation_computeUpdateFactor(self, rho)


    def __init__(self, *args):
        this = _bayesian.new_CalibrationStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementation
    __del__ = lambda self: None
CalibrationStrategyImplementation_swigregister = _bayesian.CalibrationStrategyImplementation_swigregister
CalibrationStrategyImplementation_swigregister(CalibrationStrategyImplementation)

class CalibrationStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CalibrationStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CalibrationStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _bayesian.new_CalibrationStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
CalibrationStrategyImplementationTypedInterfaceObject_swigregister = _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_swigregister
CalibrationStrategyImplementationTypedInterfaceObject_swigregister(CalibrationStrategyImplementationTypedInterfaceObject)

class CalibrationStrategyCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CalibrationStrategyCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CalibrationStrategyCollection, name)
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _bayesian.CalibrationStrategyCollection_clear(self)


    def __len__(self):
        return _bayesian.CalibrationStrategyCollection___len__(self)

    def __eq__(self, rhs):
        return _bayesian.CalibrationStrategyCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _bayesian.CalibrationStrategyCollection___contains__(self, val)

    def __getitem__(self, i):
        return _bayesian.CalibrationStrategyCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _bayesian.CalibrationStrategyCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _bayesian.CalibrationStrategyCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _bayesian.CalibrationStrategyCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _bayesian.CalibrationStrategyCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _bayesian.CalibrationStrategyCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _bayesian.CalibrationStrategyCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _bayesian.CalibrationStrategyCollection_isEmpty(self)


    def __repr__(self):
        return _bayesian.CalibrationStrategyCollection___repr__(self)

    def __str__(self, *args):
        return _bayesian.CalibrationStrategyCollection___str__(self, *args)

    def __init__(self, *args):
        this = _bayesian.new_CalibrationStrategyCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
CalibrationStrategyCollection_swigregister = _bayesian.CalibrationStrategyCollection_swigregister
CalibrationStrategyCollection_swigregister(CalibrationStrategyCollection)

class CalibrationStrategy(CalibrationStrategyImplementationTypedInterfaceObject):
    """
    Calibration strategy.

    Available constructors:
        CalibrationStrategy(*range*)

        CalibrationStrategy(*range=[0.117, 0.468], expansionFactor=1.2, shrinkFactor=0.8, calibrationStep=100*)

    Parameters
    ----------
    range : :class:`~openturns.Interval` of dimension 1 :math:`[m,M]`
        Acceptance rate values for which no update of the *calibration* coefficient
        is performed.
    expansionFactor : float, :math:`e > 1`
        Expansion factor :math:`e` to use to rescale the *calibration* coefficient
        if the latter is too high (greater than the upper bound of range).
    shrinkFactor : float, :math:`0 < s < 1`
        Shrink factor :math:`s` to use to rescale the *calibration* coefficient if
        the latter is too low (smaller than the lower bound of range). If
        *expansionFactor* is specified, *shrinkFactor* must be mentioned too.
    calibrationStep : positive int
        Calibration step corresponding for example to :math:`q` in the description
        of the method
        :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
        of the RandomWalkMetropolisHastings class.

    Notes
    -----
    A CalibrationStrategy can be used by a
    :class:`~openturns.RandomWalkMetropolisHastings` for example (see the
    description of the method
    :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
    ).
    """

    __swig_setmethods__ = {}
    for _s in [CalibrationStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CalibrationStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [CalibrationStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CalibrationStrategy, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategy_getClassName(self)


    def setRange(self, range):
        """
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setRange(self, range)


    def getRange(self):
        """
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getRange(self)


    def setExpansionFactor(self, expansionFactor):
        """
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setExpansionFactor(self, expansionFactor)


    def getExpansionFactor(self):
        """
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getExpansionFactor(self)


    def setShrinkFactor(self, shrinkFactor):
        """
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setShrinkFactor(self, shrinkFactor)


    def getShrinkFactor(self):
        """
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getShrinkFactor(self)


    def setCalibrationStep(self, calibrationStep):
        """
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategy_setCalibrationStep(self, calibrationStep)


    def getCalibrationStep(self):
        """
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategy_getCalibrationStep(self)


    def computeUpdateFactor(self, rho):
        """
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\\phi(\\rho)` such that :math:`\\phi(\\rho) \\lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

        .. math::

            \\phi(\\rho) = \\left\\{
                         \\begin{array}{l}
                             \\displaystyle s  \\quad if \\; \\rho < m \\\\
                             \\displaystyle e  \\quad if \\; \\rho > M \\\\
                             \\displaystyle 1  \\quad otherwise
                         \\end{array}
                         \\right.

        with :math:`s \\in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
        respectively, by the methods :meth:`getShrinkFactor`,
        :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategy_computeUpdateFactor(self, rho)


    def __str__(self):
        return _bayesian.CalibrationStrategy___str__(self)

    def __init__(self, *args):
        this = _bayesian.new_CalibrationStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_CalibrationStrategy
    __del__ = lambda self: None
CalibrationStrategy_swigregister = _bayesian.CalibrationStrategy_swigregister
CalibrationStrategy_swigregister(CalibrationStrategy)

class SamplerImplementation(openturns.common.PersistentObject):
    """
    Sampler.

    Available constructors:
        Sampler(*aSampler*)

    Parameters
    ----------
    aSampler : :class:`~openturns.Sampler`
        Particular sampler. By default it is a
        :class:`~openturns.RandomWalkMetropolisHastings`.

    Notes
    -----
    A Sampler is an object whose fundamental ability is to produce samples
    according to a certain distribution.

    See also
    --------
    MCMC, RandomWalkMetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> sampler = ot.Sampler()
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplerImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplerImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.SamplerImplementation_getClassName(self)


    def setVerbose(self, verbose):
        """
        Set the verbose mode.

        Parameters
        ----------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.SamplerImplementation_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Tell whether the verbose mode is activated or not.

        Returns
        -------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.SamplerImplementation_getVerbose(self)


    def __repr__(self):
        return _bayesian.SamplerImplementation___repr__(self)

    def getDimension(self):
        """
        Get the dimension of the samples generated.

        Returns
        -------
        dimension : int
            Dimension of the samples that the Sampler can generate.
        """
        return _bayesian.SamplerImplementation_getDimension(self)


    def getRealization(self):
        """
        Return a realization.

        Returns
        -------
        realization : :class:`~openturns.Point`
            A new realization.
        """
        return _bayesian.SamplerImplementation_getRealization(self)


    def getSample(self, size):
        """
        Return several realizations.

        Parameters
        ----------
        size : int, :math:`size \\leq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            Sequence composed of *size* new realizations.
        """
        return _bayesian.SamplerImplementation_getSample(self, size)


    def __init__(self, *args):
        this = _bayesian.new_SamplerImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_SamplerImplementation
    __del__ = lambda self: None
SamplerImplementation_swigregister = _bayesian.SamplerImplementation_swigregister
SamplerImplementation_swigregister(SamplerImplementation)

class SamplerImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplerImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplerImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _bayesian.new_SamplerImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _bayesian.SamplerImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.SamplerImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.SamplerImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _bayesian.SamplerImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _bayesian.delete_SamplerImplementationTypedInterfaceObject
    __del__ = lambda self: None
SamplerImplementationTypedInterfaceObject_swigregister = _bayesian.SamplerImplementationTypedInterfaceObject_swigregister
SamplerImplementationTypedInterfaceObject_swigregister(SamplerImplementationTypedInterfaceObject)

class Sampler(SamplerImplementationTypedInterfaceObject):
    """
    Sampler.

    Available constructors:
        Sampler(*aSampler*)

    Parameters
    ----------
    aSampler : :class:`~openturns.Sampler`
        Particular sampler. By default it is a
        :class:`~openturns.RandomWalkMetropolisHastings`.

    Notes
    -----
    A Sampler is an object whose fundamental ability is to produce samples
    according to a certain distribution.

    See also
    --------
    MCMC, RandomWalkMetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> sampler = ot.Sampler()
    """

    __swig_setmethods__ = {}
    for _s in [SamplerImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sampler, name, value)
    __swig_getmethods__ = {}
    for _s in [SamplerImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sampler, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.Sampler_getClassName(self)


    def setVerbose(self, verbose):
        """
        Set the verbose mode.

        Parameters
        ----------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.Sampler_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Tell whether the verbose mode is activated or not.

        Returns
        -------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.Sampler_getVerbose(self)


    def getDimension(self):
        """
        Get the dimension of the samples generated.

        Returns
        -------
        dimension : int
            Dimension of the samples that the Sampler can generate.
        """
        return _bayesian.Sampler_getDimension(self)


    def getRealization(self):
        """
        Return a realization.

        Returns
        -------
        realization : :class:`~openturns.Point`
            A new realization.
        """
        return _bayesian.Sampler_getRealization(self)


    def getSample(self, size):
        """
        Return several realizations.

        Parameters
        ----------
        size : int, :math:`size \\leq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            Sequence composed of *size* new realizations.
        """
        return _bayesian.Sampler_getSample(self, size)


    def __str__(self):
        return _bayesian.Sampler___str__(self)

    def __init__(self, *args):
        this = _bayesian.new_Sampler(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_Sampler
    __del__ = lambda self: None
Sampler_swigregister = _bayesian.Sampler_swigregister
Sampler_swigregister(Sampler)

class MCMC(SamplerImplementation):
    """
    Monte-Carlo Markov Chain.

    Available constructor:
        MCMC(*prior, conditional, observations, initialState*)

        MCMC(*prior, conditional, model, parameters, observations, initialState*)

    Parameters
    ----------
    prior : :class:`~openturns.Distribution`
        Prior distribution of the parameters of the underlying Bayesian statistical
        model.
    conditional : :class:`~openturns.Distribution`
        Required distribution to define the likelihood of the underlying Bayesian
        statistical model.
    model : :class:`~openturns.Function`
        Function required to define the likelihood.
    observations : 2-d sequence of float
        Observations required to define the likelihood.
    initialState : sequence of float
        Initial state of the Monte-Carlo Markov chain on which the Sampler is
        based.
    parameters : 2-d sequence of float
        Parameters of the model to be fixed.

    Notes
    -----
    MCMC provides a implementation of the concept of sampler, using a Monte-Carlo
    Markov Chain (MCMC) algorithm starting from *initialState*. More precisely,
    let :math:`t(.)` be the PDF of its target distribution and :math:`d_{\\theta}`
    its dimension, :math:`\\pi(.)` be the PDF of the *prior* distribution,
    :math:`f(.|\\vect{w})` be the PDF of the *conditional* distribution
    when its parameters are set to :math:`\\vect{w}`, :math:`d_w` be the number of
    scalar parameters of *conditional* distribution (which corresponds to the
    dimension of the above :math:`\\vect{w}`), :math:`g(.)` be the function
    corresponding to model and :math:`(\\vect{y}^1, \\dots, \\vect{y}^n)` be the
    sample *observations* (of size :math:`n`):

    In the first usage, it creates a sampler based on a MCMC algorithm whose target
    distribution is defined by:

    .. _PDF_target_formula:

    .. math::

        t(\\vect{\\theta})
        \\quad \\propto \\quad
        \\underbrace{~\\pi(\\vect{\\theta})~}_{\\mbox{prior}} \\quad
        \\underbrace{~\\prod_{i=1}^n f(\\vect{y}^i|\\vect{\\theta})~}_{\\mbox{likelihood}}


    In the first usage, it creates a sampler based on a MCMC algorithm whose target
    distribution is defined by:

    .. _second_PDF_target_formula:

    .. math::

        t(\\vect{\\theta})
        \\quad \\propto \\quad
        \\underbrace{~\\pi(\\vect{\\theta})~}_{\\mbox{prior}} \\quad
        \\underbrace{~\\prod_{i=1}^n f(\\vect{y}^i|g^i(\\vect{\\theta}))~}_{\\mbox{likelihood}}

    where the :math:`g^i: \\Rset^{d_{\\theta}} \\rightarrow\\Rset^{d_w}`
    (:math:`1\\leq{}i\\leq{}n`) are such that:

    .. math::

        \\begin{array}{rcl}
            g:\\Rset^{d_\\theta} & \\longrightarrow & \\Rset^{n\\,d_w}\\\\
            \\vect{\\theta} & \\longmapsto &
            g(\\vect{\\theta}) = \\Tr{(\\Tr{g^1(\\vect{\\theta})}, \\cdots, \\Tr{g^n(\\vect{\\theta})})}
            \\end{array}

    In fact, the first usage is a particular case of the second.


    The MCMC method implemented in OpenTURNS is the Random Walk Metropolis-Hastings
    algorithm. A sample can be generated only through the MCMC's derived class:
    :class:`~openturns.RandomWalkMetropolisHastings`.
    """

    __swig_setmethods__ = {}
    for _s in [SamplerImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MCMC, name, value)
    __swig_getmethods__ = {}
    for _s in [SamplerImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MCMC, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.MCMC_getClassName(self)


    def __repr__(self):
        return _bayesian.MCMC___repr__(self)

    def computeLogLikelihood(self, currentState):
        """
        Compute the logarithm of the likelihood w.r.t. observations.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logLikelihood : float
            Logarithm of the likelihood w.r.t. observations
            :math:`(\\vect{y}^1, \\dots, \\vect{y}^n)`.
        """
        return _bayesian.MCMC_computeLogLikelihood(self, currentState)


    def setPrior(self, prior):
        """
        Set the *prior* distribution.

        Parameters
        ----------
        prior : :class:`~openturns.Distribution`
            The prior distribution of the parameter of the underlying Bayesian
            statistical model, whose PDF corresponds to :math:`\\pi` in the equations of
            the :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_setPrior(self, prior)


    def getPrior(self):
        """
        Get the *prior* distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The prior distribution of the parameter of the underlying Bayesian
            statistical model, whose PDF corresponds to :math:`\\pi` in the equations of
            the :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getPrior(self)


    def getConditional(self):
        """
        Get the *conditional* distribution.

        Returns
        -------
        conditional : :class:`~openturns.Distribution`
            Distribution taken into account in the definition of the likelihood, whose
            PDF with parameters :math:`\\vect{w}` corresponds to :math:`f(.|\\vect{w})`
            in the equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getConditional(self)


    def getModel(self):
        """
        Get the model.

        Returns
        -------
        model : :class:`~openturns.Function`
            Model take into account in the definition of the likelihood, which
            corresponds to :math:`g`, that is the functions :math:`g^i`
            (:math:`1\\leq i \\leq n`) in the equation of the
            :ref:`target distribution's PDF <second_PDF_target_formula>`.
        """
        return _bayesian.MCMC_getModel(self)


    def setObservations(self, observations):
        """
        Set the observations.

        Parameters
        ----------
        observations : 2-d sequence of float
            Sample taken into account in the definition of the likelihood, which
            corresponds to the :math:`n`-tuple of the :math:`\\vect{y}^i`
            (:math:`1\\leq i \\leq n`) in the equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_setObservations(self, observations)


    def getObservations(self):
        """
        Get the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            Sample taken into account in the definition of the likelihood, which
            corresponds to the :math:`n`-tuple of the :math:`\\vect{y}^i`
            (:math:`1\\leq i \\leq n`) in equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getObservations(self)


    def setParameters(self, parameters):
        """
        Set the parameters.

        Parameters
        ----------
        parameters : sequence of float
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MCMC_setParameters(self, parameters)


    def getParameters(self):
        """
        Get the parameters.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MCMC_getParameters(self)


    def setBurnIn(self, burnIn):
        """
        Set the length of the burn-in period.

        Parameters
        ----------
        lenght : int
            Length of the burn-in period, that is the number of first iterates of the
            MCMC chain which will be thrown away when generating the sample.
        """
        return _bayesian.MCMC_setBurnIn(self, burnIn)


    def getBurnIn(self):
        """
        Get the length of the burn-in period.

        Returns
        -------
        lenght : int
            Length of the burn-in period, that is the number of first iterates of the
            MCMC chain which will be thrown away when generating the sample.
        """
        return _bayesian.MCMC_getBurnIn(self)


    def setThinning(self, thinning):
        """
        Set the thinning parameter.

        Parameters
        ----------
        thinning : int, :math:`k \\geq 0`
            Thinning parameter: storing only every :math:`k^{th}` point after the
            burn-in period.

        Notes
        -----
        When generating a sample of size :math:`q`, the number of MCMC iterations
        performed is :math:`l+1+(q-1)k` where :math:`l` is the burn-in period length
        and :math:`k` the thinning parameter.
        """
        return _bayesian.MCMC_setThinning(self, thinning)


    def getThinning(self):
        """
        Get the thinning parameter.

        Returns
        -------
        thinning : int
            Thinning parameter: storing only every :math:`k^{th}` point after the
            burn-in period.

        Notes
        -----
        When generating a sample of size :math:`q`, the number of MCMC iterations
        performed is :math:`l+1+(q-1)k` where :math:`l` is the burn-in period length
        and :math:`k` the thinning parameter.
        """
        return _bayesian.MCMC_getThinning(self)


    def setHistory(self, strategy):
        """
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MCMC_setHistory(self, strategy)


    def getHistory(self):
        """
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MCMC_getHistory(self)


    def setNonRejectedComponents(self, nonRejectedComponents):
        """
        Set the components to be always accepted.

        Parameters
        ----------
        nonRejectedComponents : sequence of int 
            The indices of the components that are not tuned, and sampled according to
            the prior distribution in order to take into account the intrinsic
            uncertainty, as opposed to the epistemic uncertainty corresponding to the
            tuned variables.
        """
        return _bayesian.MCMC_setNonRejectedComponents(self, nonRejectedComponents)


    def getNonRejectedComponents(self):
        """
        Get the components to be always accepted.

        Returns
        -------
        nonRejectedComponents : :class:`~openturns.Indices`
            The indices of the components that are not tuned, and sampled according to
            the prior distribution in order to take into account the intrinsic
            uncertainty, as opposed to the epistemic uncertainty corresponding to the
            tuned variables.
        """
        return _bayesian.MCMC_getNonRejectedComponents(self)


    def getDimension(self):
        """
        Get the dimension of the samples generated.

        Returns
        -------
        dimension : int
            Dimension of the samples that the Sampler can generate.
        """
        return _bayesian.MCMC_getDimension(self)


    def __init__(self, *args):
        this = _bayesian.new_MCMC(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_MCMC
    __del__ = lambda self: None
MCMC_swigregister = _bayesian.MCMC_swigregister
MCMC_swigregister(MCMC)

class RandomWalkMetropolisHastings(MCMC):
    """
    Random Walk Metropolis-Hastings method.

    Available constructor:
        RandomWalkMetropolisHastings(*prior, conditional, observations, initialState, proposal*)

        RandomWalkMetropolisHastings(*prior, conditional, model, parameters, observations, initialState, proposal*)

    Parameters
    ----------
    prior : :class:`~openturns.Distribution`
        Prior distribution of the parameters of the underlying Bayesian statistical
        model.
    conditional : :class:`~openturns.Distribution`
        Required distribution to define the likelihood of the underlying Bayesian
        statistical model.
    model : :class:`~openturns.Function`
        Function required to define the likelihood.
    observations : 2-d sequence of float
        Observations required to define the likelihood.
    initialState : sequence of float
        Initial state of the Monte-Carlo Markov chain on which the Sampler is
        based.
    parameters : 2-d sequence of float
        Parameters of the model to be fixed.
    proposal : list of :class:`~openturns.Distribution`
        Distributions from which the transition kernels of the
        :class:`~openturns.MCMC` are defined, as explained hereafter. In the
        following of this paragraph, :math:`\\delta \\sim p_j` means that the
        realization :math:`\\delta` is obtained according to the :math:`j^{th}`
        Distribution of the list *proposal* of size :math:`d`. The underlying
        MCMC algorithm is a Metropolis-Hastings one which draws candidates (for the
        next state of the chain) using a random walk: from the current state
        :math:`\\vect{\\theta}^k`, the candidate :math:`\\vect{c}^k` for
        :math:`\\vect{\\theta}^{k+1}` can be expressed as
        :math:`\\vect{c}^k = \\vect{\\theta}^k +\\vect{\\delta}^k` where the
        distribution of :math:`\\vect{\\delta}^k` does not depend on
        :math:`\\vect{\\theta}^k`. More precisely, here, during the :math:`k^{th}`
        Metropolis-Hastings iteration, only the :math:`j^{th}` component
        :math:`\\delta_j^k` of :math:`\\vect{\\delta}^k` , with :math:`j=k \\mod d`, is
        not zero and :math:`\\delta_j^k = \\lambda_j^k \\delta^k` where
        :math:`\\lambda_j^k` is a deterministic scalar *calibration* coefficient and
        where :math:`\\delta^k \\sim p_j`. Moreover, :math:`\\lambda_j^k = 1` by default,
        but adaptive strategy based on the acceptance rate of each component can be
        defined using the method :meth:`setCalibrationStrategyPerComponent`.

    Notes
    -----
    A RandomWalkMetropolisHastings enables to carry out :class:`~openturns.MCMC`
    sampling according to the preceding statements. It is important to note that
    sampling one new realization comes to carrying out :math:`d` Metropolis-
    Hastings iterations (such as described above): all of the components of the new
    realization can differ from the corresponding components of the previous
    realization. Besides, the burn-in and thinning parameters do not take into
    consideration the number of MCMC iterations indeed, but the number of sampled
    realizations.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> chainDim = 3
    >>> # Observations
    >>> obsDim = 1
    >>> obsSize = 10
    >>> y = [-9.50794871493506, -3.83296694500105, -2.44545713047953,
    ...      0.0803625289211318, 1.01898069723583, 0.661725805623086,
    ...      -1.57581204592385, -2.95308465670895, -8.8878164296758,
    ...      -13.0812290405651]
    >>> y_obs = ot.Sample(y, obsDim)
    >>> # Parameters
    >>> p = ot.Sample(obsSize, chainDim)
    >>> for i in range(obsSize):
    ...     for j in range(chainDim):
    ...         p[i, j] = (-2 + 5.0 * i / 9.0) ** j
    >>> # Model
    >>> fullModel = ot.SymbolicFunction(
    ...          ['p1', 'p2', 'p3', 'x1', 'x2', 'x3'],
    ...          ['p1*x1+p2*x2+p3*x3', '1.0'])
    >>> parametersSet = range(chainDim)
    >>> parametersValue = [0.0] * len(parametersSet)
    >>> model = ot.ParametricFunction(fullModel, parametersSet, parametersValue)
    >>> # Calibration parameters
    >>> calibrationColl = [ot.CalibrationStrategy()]*chainDim
    >>> # Proposal distribution
    >>> proposalColl = [ot.Uniform(-1.0, 1.0)]*chainDim
    >>> # Prior distribution
    >>> sigma0 = [10.0]*chainDim
    >>> #  Covariance matrix
    >>> Q0_inv = ot.CorrelationMatrix(chainDim)
    >>> for i in range(chainDim): 
    ...     Q0_inv[i, i] = sigma0[i] * sigma0[i]
    >>> mu0 = [0.0]*chainDim
    >>> #  x0 ~ N(mu0, sigma0)
    >>> prior = ot.Normal(mu0, Q0_inv)
    >>> # Conditional distribution y~N(z, 1.0)
    >>> conditional = ot.Normal()
    >>> # Create a metropolis-hastings sampler
    >>> # prior =a distribution of dimension chainDim, the a priori distribution of the parameter
    >>> # conditional =a distribution of dimension 1, the observation error on the output
    >>> # model =the link between the parameters and the output
    >>> # y_obs =noisy observations of the output
    >>> # mu0 =starting point of the chain
    >>> sampler = ot.RandomWalkMetropolisHastings(
    ...     prior, conditional, model, p, y_obs, mu0, proposalColl)
    >>> sampler.setCalibrationStrategyPerComponent(calibrationColl)
    >>> sampler.setBurnIn(200)
    >>> sampler.setThinning(10)
    >>> # Get a realization
    >>> print(sampler.getRealization())
    [1.22816,1.0049,-1.99008]
    """

    __swig_setmethods__ = {}
    for _s in [MCMC]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomWalkMetropolisHastings, name, value)
    __swig_getmethods__ = {}
    for _s in [MCMC]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomWalkMetropolisHastings, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.RandomWalkMetropolisHastings_getClassName(self)


    def __repr__(self):
        return _bayesian.RandomWalkMetropolisHastings___repr__(self)

    def getRealization(self):
        """
        Return a realization.

        Returns
        -------
        realization : :class:`~openturns.Point`
            A new realization.
        """
        return _bayesian.RandomWalkMetropolisHastings_getRealization(self)


    def setCalibrationStrategy(self, calibrationStrategy):
        """
        Set the calibration strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.CalibrationStrategy`
            Same strategy applied for each component :math:`\\lambda_j^k`.

        See also
        --------
        setCalibrationStrategyPerComponent
        """
        return _bayesian.RandomWalkMetropolisHastings_setCalibrationStrategy(self, calibrationStrategy)


    def setCalibrationStrategyPerComponent(self, calibrationStrategy):
        """
        Set the calibration strategy per component.

        Parameters
        ----------
        strategy : list of :class:`~openturns.CalibrationStrategy`
            A list of CalibrationStrategy *strategy*, whose :math:`j^{th}` component
            :math:`strategy[j]` defines whether and how the :math:`\\lambda_j^k` (see the
            paragraph dedicated to the constructors of the class above) are rescaled,
            on the basis of the last :math:`j^{th}` component acceptance rate
            :math:`\\rho_j^k` . The *calibration* coefficients are rescaled every
            :math:`q\\times d` MCMC iterations with
            :math:`q = strategy[j].getCalibrationStep()`, thus on the basis of the
            acceptances or refusals of the last :math:`q` candidates obtained by only
            changing the :math:`j^{th}` component of the current state:
            :math:`\\lambda_j^k = \\Phi_j (\\rho_j^k)\\lambda_j^{k-qd}` where
            :math:`\\Phi_j(.)` is defined by :math:`strategy[j].computeUpdateFactor()`.
        """
        return _bayesian.RandomWalkMetropolisHastings_setCalibrationStrategyPerComponent(self, calibrationStrategy)


    def getCalibrationStrategyPerComponent(self):
        """
        Get the calibration strategy per component.

        Returns
        -------
        strategy : list of :class:`~openturns.CalibrationStrategy`
            A list of CalibrationStrategy *strategy*, whose :math:`j^{th}` component
            :math:`strategy[j]` defines whether and how the :math:`\\lambda_j^k` (see the
            paragraph dedicated to the constructors of the class above) are rescaled,
            on the basis of the last :math:`j^{th}` component acceptance rate
            :math:`\\rho_j^k` . The *calibration* coefficients are rescaled every
            :math:`q\\times d` MCMC iterations with
            :math:`q = strategy[j].getCalibrationStep()`, thus on the basis of the
            acceptances or refusals of the last :math:`q` candidates obtained by only
            changing the :math:`j^{th}` component of the current state:
            :math:`\\lambda_j^k = \\Phi_j (\\rho_j^k)\\lambda_j^{k-qd}` where
            :math:`\\Phi_j(.)` is defined by :math:`strategy[j].computeUpdateFactor()`.
        """
        return _bayesian.RandomWalkMetropolisHastings_getCalibrationStrategyPerComponent(self)


    def setProposal(self, proposal):
        """
        Set the proposal.

        Parameters
        ----------
        proposal : list of :class:`~openturns.Distribution`
            The :math:`d`-tuple of Distributions :math:`p_j (1 \\leq j \\leq d)` from
            which the transition kernels of the random walk Metropolis-Hastings
            algorithm are defined; look at the paragraph dedicated to the constructors
            of the class above.
        """
        return _bayesian.RandomWalkMetropolisHastings_setProposal(self, proposal)


    def getProposal(self):
        """
        Get the proposal.

        Returns
        -------
        proposal : list of :class:`~openturns.Distribution`
            The :math:`d`-tuple of Distributions :math:`p_j (1 \\leq j \\leq d)` from
            which the transition kernels of the random walk Metropolis-Hastings
            algorithm are defined; look at the paragraph dedicated to the constructors
            of the class above.
        """
        return _bayesian.RandomWalkMetropolisHastings_getProposal(self)


    def getAcceptanceRate(self):
        """
        Get acceptance rate.

        Returns
        -------
        acceptanceRate : :class:`~openturns.Point` of dimension :math:`d`
            Sequence whose the :math:`j^{th}` component corresponds to the acceptance
            rate of the candidates :math:`\\vect{c}^k` obtained from a state
            :math:`\\vect{\\theta}^k` by only changing its :math:`j^{th}` component, that
            is to the acceptance rate only relative to the :math:`k^{th}` MCMC
            iterations such that :math:`k \\mod d=j` (see the paragraph dedicated to the
            constructors of the class above). These are global acceptance rates over
            all the MCMC iterations performed.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAcceptanceRate(self)


    def __init__(self, *args):
        this = _bayesian.new_RandomWalkMetropolisHastings(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_RandomWalkMetropolisHastings
    __del__ = lambda self: None
RandomWalkMetropolisHastings_swigregister = _bayesian.RandomWalkMetropolisHastings_swigregister
RandomWalkMetropolisHastings_swigregister(RandomWalkMetropolisHastings)

class PosteriorRandomVector(openturns.randomvector.RandomVectorImplementation):
    """
    Random vectors based on samplers.

    Available constructors:
        PosteriorRandomVector(*sampler*)

    Parameters
    ----------
    sampler : :class:`~openturns.Sampler`
        A sampler.

    Notes
    -----
    A *PosteriorRandomVector* corresponds to a random vector whose distribution
    poses some particular numerical difficulties such as evaluating its PDF, but
    which can be more easily sampled. By sampling a random vector, we means
    computing an i.i.d. sample according to its distribution or computing the
    realization of an ergodic Markov chain whose stationary distribution is the
    one of the random vector. Such random vector is typically encountered in
    Bayesian inference, where a common practice is to sample the posterior random
    vector of the infered parameters by Monte-Carlo Markov Chain.

    See also
    --------
    RandomVector, MCMC

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # observations
    >>> realDist = ot.Normal(31.0, 1.2)
    >>> data = realDist.getSample(10)
    >>> # proposal distribution
    >>> proposalColl = [ot.Uniform(-2.0, 2.0)]*2
    >>> # prior distribution
    >>> prior = ot.ComposedDistribution([ot.Normal(25.0, 0.1), ot.Dirac(2.0)])
    >>> # choose the initial state within the prior
    >>> initState = prior.getRealization()
    >>> # conditional distribution
    >>> cond = ot.Normal()
    >>> # create a metropolis-hastings sampler
    >>> sampler = ot.RandomWalkMetropolisHastings(prior, cond, data, initState, proposalColl)
    >>> sampler.setVerbose(True)
    >>> sampler.setThinning(10)
    >>> sampler.setBurnIn(100)

    >>> # create a PosteriorRandomVector
    >>> randomVector = ot.PosteriorRandomVector(sampler)
    >>> # get a realization
    >>> print(randomVector.getRealization())
    [25.0658,2]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PosteriorRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PosteriorRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.PosteriorRandomVector_getClassName(self)


    def __repr__(self):
        return _bayesian.PosteriorRandomVector___repr__(self)

    def getSampler(self):
        """
        Get the sampler.

        Returns
        -------
        sampler : :class:`~openturns.Sampler`
            The sampler used to create the RandomVector.
        """
        return _bayesian.PosteriorRandomVector_getSampler(self)


    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian.PosteriorRandomVector_getDimension(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian.PosteriorRandomVector_getRealization(self)


    def getSample(self, size):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _bayesian.PosteriorRandomVector_getSample(self, size)


    def __init__(self, *args):
        this = _bayesian.new_PosteriorRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_PosteriorRandomVector
    __del__ = lambda self: None
PosteriorRandomVector_swigregister = _bayesian.PosteriorRandomVector_swigregister
PosteriorRandomVector_swigregister(PosteriorRandomVector)

class CalibrationStrategyImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CalibrationStrategyImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CalibrationStrategyImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _bayesian.CalibrationStrategyImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _bayesian.CalibrationStrategyImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_bayesian.CalibrationStrategyImplementationPointer_ptr__get, _bayesian.CalibrationStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _bayesian.new_CalibrationStrategyImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _bayesian.CalibrationStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _bayesian.CalibrationStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _bayesian.CalibrationStrategyImplementationPointer___deref__(self)

    def isNull(self):
        return _bayesian.CalibrationStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _bayesian.CalibrationStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _bayesian.CalibrationStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _bayesian.CalibrationStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _bayesian.CalibrationStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _bayesian.CalibrationStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _bayesian.CalibrationStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getClassName(self)


    def __repr__(self):
        return _bayesian.CalibrationStrategyImplementationPointer___repr__(self)

    def setRange(self, range):
        """
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setRange(self, range)


    def getRange(self):
        """
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getRange(self)


    def setExpansionFactor(self, expansionFactor):
        """
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setExpansionFactor(self, expansionFactor)


    def getExpansionFactor(self):
        """
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getExpansionFactor(self)


    def setShrinkFactor(self, shrinkFactor):
        """
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setShrinkFactor(self, shrinkFactor)


    def getShrinkFactor(self):
        """
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getShrinkFactor(self)


    def setCalibrationStep(self, calibrationStep):
        """
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setCalibrationStep(self, calibrationStep)


    def getCalibrationStep(self):
        """
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getCalibrationStep(self)


    def computeUpdateFactor(self, rho):
        """
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\\phi(\\rho)` such that :math:`\\phi(\\rho) \\lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

        .. math::

            \\phi(\\rho) = \\left\\{
                         \\begin{array}{l}
                             \\displaystyle s  \\quad if \\; \\rho < m \\\\
                             \\displaystyle e  \\quad if \\; \\rho > M \\\\
                             \\displaystyle 1  \\quad otherwise
                         \\end{array}
                         \\right.

        with :math:`s \\in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
        respectively, by the methods :meth:`getShrinkFactor`,
        :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategyImplementationPointer_computeUpdateFactor(self, rho)


    def __eq__(self, arg2):
        return _bayesian.CalibrationStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _bayesian.CalibrationStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _bayesian.CalibrationStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setName(self, name)

CalibrationStrategyImplementationPointer_swigregister = _bayesian.CalibrationStrategyImplementationPointer_swigregister
CalibrationStrategyImplementationPointer_swigregister(CalibrationStrategyImplementationPointer)

# This file is compatible with both classic and new-style classes.


