# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Weighted designs of experiments."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_weightedexperiment')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_weightedexperiment')
    _weightedexperiment = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_weightedexperiment', [dirname(__file__)])
        except ImportError:
            import _weightedexperiment
            return _weightedexperiment
        try:
            _mod = imp.load_module('_weightedexperiment', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _weightedexperiment = swig_import_helper()
    del swig_import_helper
else:
    import _weightedexperiment
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _weightedexperiment.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _weightedexperiment.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _weightedexperiment.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _weightedexperiment.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _weightedexperiment.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _weightedexperiment.SwigPyIterator_equal(self, x)

    def copy(self):
        return _weightedexperiment.SwigPyIterator_copy(self)

    def next(self):
        return _weightedexperiment.SwigPyIterator_next(self)

    def __next__(self):
        return _weightedexperiment.SwigPyIterator___next__(self)

    def previous(self):
        return _weightedexperiment.SwigPyIterator_previous(self)

    def advance(self, n):
        return _weightedexperiment.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _weightedexperiment.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _weightedexperiment.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _weightedexperiment.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _weightedexperiment.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _weightedexperiment.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _weightedexperiment.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _weightedexperiment.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _weightedexperiment.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class WeightedExperimentImplementation(openturns.experiment.ExperimentImplementation):
    """
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\\Xi_i` so that the
    mean :math:`E_{\\mu}` is approximated as follows:

    .. math::

        \\Expect{ f(\\vect{Z})}_{\\mu} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where :math:`\\mu` is a distribution, :math:`f` is a function :math:`L_1(\\mu)`
    and :math:`\\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """

    __swig_setmethods__ = {}
    for _s in [openturns.experiment.ExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperimentImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.experiment.ExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperimentImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperimentImplementation_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.WeightedExperimentImplementation___repr__(self)

    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setDistribution(self, distribution)


    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getDistribution(self)


    def setSize(self, size):
        """
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setSize(self, size)


    def getSize(self):
        """
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getSize(self)


    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\\Xi_i)_{i \\in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generate(self)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_WeightedExperimentImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementation
    __del__ = lambda self: None
WeightedExperimentImplementation_swigregister = _weightedexperiment.WeightedExperimentImplementation_swigregister
WeightedExperimentImplementation_swigregister(WeightedExperimentImplementation)

class WeightedExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperimentImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperimentImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _weightedexperiment.new_WeightedExperimentImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementationTypedInterfaceObject
    __del__ = lambda self: None
WeightedExperimentImplementationTypedInterfaceObject_swigregister = _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_swigregister
WeightedExperimentImplementationTypedInterfaceObject_swigregister(WeightedExperimentImplementationTypedInterfaceObject)

class WeightedExperiment(WeightedExperimentImplementationTypedInterfaceObject):
    """
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\\Xi_i` so that the
    mean :math:`E_{\\mu}` is approximated as follows:

    .. math::

        \\Expect{ f(\\vect{Z})}_{\\mu} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where :math:`\\mu` is a distribution, :math:`f` is a function :math:`L_1(\\mu)`
    and :math:`\\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.WeightedExperiment___repr__(self)

    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_setDistribution(self, distribution)


    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_getDistribution(self)


    def setSize(self, size):
        """
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_setSize(self, size)


    def getSize(self):
        """
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_getSize(self)


    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\\Xi_i)_{i \\in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperiment_generate(self)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_WeightedExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperiment
    __del__ = lambda self: None
WeightedExperiment_swigregister = _weightedexperiment.WeightedExperiment_swigregister
WeightedExperiment_swigregister(WeightedExperiment)

class BootstrapExperiment(WeightedExperimentImplementation):
    """
    Bootstrap experiment.

    Available constructors:
        BootstrapExperiment(*sample*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Points to defined a :class:`~openturns.UserDefined` distribution
        :math:`\\mu`.

    Notes
    -----
    BootstrapExperiment is a random weighted design of experiments.
    To call the BootstrapExperiment constructor is equivalent to call the
    :class:`~openturns.WeightedExperiment` constructor as follows:
    *WeightedExperiment(UserDefined(sample), sample.getSize())*.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> myPlane = ot.BootstrapExperiment(sample)
    >>> print(myPlane.generate())
        [ v0 v1 ]
    0 : [ 4  5  ]
    1 : [ 1  2  ]
    2 : [ 1  2  ]
    3 : [ 1  2  ]
    4 : [ 2  3  ]
    >>> print(myPlane.getDistribution())
    UserDefined({x = [0,1], p = 0.2}, {x = [1,2], p = 0.2}, {x = [2,3], p = 0.2}, {x = [3,4], p = 0.2}, {x = [4,5], p = 0.2})
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BootstrapExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BootstrapExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.BootstrapExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.BootstrapExperiment___repr__(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.BootstrapExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_BootstrapExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_BootstrapExperiment
    __del__ = lambda self: None
BootstrapExperiment_swigregister = _weightedexperiment.BootstrapExperiment_swigregister
BootstrapExperiment_swigregister(BootstrapExperiment)

class FixedExperiment(WeightedExperimentImplementation):
    """
    Fixed experiment.

    Available constructors:
        FixedExperiment(*aSample*)

        FixedExperiment(*aSample, weights*)

    Parameters
    ----------
    aSample : 2-d sequence of float
        Sample that already exists.
    weights : sequence of float
        Weights of each point of *aSample*.

    Notes
    -----
    FixedExperiment is a deterministic weighted design of experiments.
    It enables to take into account a random sample which has been obtained outside
    the OpenTURNS study or at another step of the OpenTURNS study. The
    :meth:`generate` method always gives the same sample, *aSample*, if it is
    recalled. When not specified, the weights associated to the points are all
    equal to :math:`1/cardI`. Then the sample *aSample* is considered as generated
    from the limit distribution
    :math:`\\lim\\limits_{cardI \\to \\infty} \\sum_{i \\in I} \\omega_i \\delta_{\\vect{X}_i}=\\mu`.
    The :meth:`setDistribution` method has no side effect, as the distribution is
    fixed by the initial sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> myPlane = ot.FixedExperiment(sample)
    >>> print(myPlane.generate())
    0 : [ 0 1 ]
    1 : [ 1 2 ]
    2 : [ 2 3 ]
    3 : [ 3 4 ]
    4 : [ 4 5 ]
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FixedExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FixedExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.FixedExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.FixedExperiment___repr__(self)

    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.FixedExperiment_setDistribution(self, distribution)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.FixedExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_FixedExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_FixedExperiment
    __del__ = lambda self: None
FixedExperiment_swigregister = _weightedexperiment.FixedExperiment_swigregister
FixedExperiment_swigregister(FixedExperiment)

class GaussProductExperiment(WeightedExperimentImplementation):
    """
    Gauss product experiment.

    Available constructors:
        GaussProductExperiment(*marginalDegrees*)

        GaussProductExperiment(*distribution*)

        GaussProductExperiment(*distribution, marginalDegrees*)

    Parameters
    ----------
    marginalDegrees : sequence of positive int
        Numbers of points :math:`N_i` for each direction. Then, the total number of
        points generated is :math:`cardI=\\prod_{i=1}^n N_i`. If not specified,
        each value :math:`N_i` is :math:`5`.
    distribution :
        Distribution :math:`\\mu` of dimension :math:`n` with an independent copula.

    Notes
    -----
    The number of points for each direction doesn't change and the :meth:`generate`
    method always gives the same sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Exponential(), ot.Triangular(-1.0, -0.5, 1.0)])
    >>> marginalDegrees = [3, 2]
    >>> myPlane = ot.GaussProductExperiment(distribution, marginalDegrees)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [  0.415775 -0.511215 ]
    1 : [  2.29428  -0.511215 ]
    2 : [  6.28995  -0.511215 ]
    3 : [  0.415775  0.357369 ]
    4 : [  2.29428   0.357369 ]
    5 : [  6.28995   0.357369 ]
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GaussProductExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GaussProductExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GaussProductExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.GaussProductExperiment___repr__(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.GaussProductExperiment_generateWithWeights(self)


    def setMarginalDegrees(self, marginalDegrees):
        """
        Set the marginal degrees.

        Parameters
        ----------
        marginalDegrees : sequence of positive int
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_setMarginalDegrees(self, marginalDegrees)


    def getMarginalDegrees(self):
        """
        Get the marginal degrees.

        Returns
        -------
        marginalDegrees : :class:`~openturns.Indices`
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_getMarginalDegrees(self)


    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.GaussProductExperiment_setDistribution(self, distribution)


    def __init__(self, *args):
        this = _weightedexperiment.new_GaussProductExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_GaussProductExperiment
    __del__ = lambda self: None
GaussProductExperiment_swigregister = _weightedexperiment.GaussProductExperiment_swigregister
GaussProductExperiment_swigregister(GaussProductExperiment)

class ImportanceSamplingExperiment(WeightedExperimentImplementation):
    """
    Importance Sampling experiment.

    Available constructors:
        ImportanceSamplingExperiment(*distribution, size*)

        ImportanceSamplingExperiment(*distribution, importanceDistribution, size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.
    importanceDistribution : :class:`~openturns.Distribution`
        Distribution :math:`p` according to which the points of the design of
        experiments will be generated with the Importance Sampling technique.

    Notes
    -----
    ImportanceSamplingExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. When the :meth:`generate`
    method is recalled, the generated sample changes.
    The weights associated to the points are all equal to:
    :math:`\\frac{1}{\\Xi_i}\\frac{\\mu(\\Xi_i)}{p(\\Xi_i)}`

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> importanceDistribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> myPlane = ot.ImportanceSamplingExperiment(distribution, importanceDistribution, 5)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [ 0.629877  0.882805  ]
    1 : [ 0.135276  0.0325028 ]
    2 : [ 0.347057  0.969423  ]
    3 : [ 0.92068   0.50304   ]
    4 : [ 0.0632061 0.292757  ]
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ImportanceSamplingExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ImportanceSamplingExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.ImportanceSamplingExperiment_getClassName(self)


    def getImportanceDistribution(self):
        return _weightedexperiment.ImportanceSamplingExperiment_getImportanceDistribution(self)

    def __repr__(self):
        return _weightedexperiment.ImportanceSamplingExperiment___repr__(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.ImportanceSamplingExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_ImportanceSamplingExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_ImportanceSamplingExperiment
    __del__ = lambda self: None
ImportanceSamplingExperiment_swigregister = _weightedexperiment.ImportanceSamplingExperiment_swigregister
ImportanceSamplingExperiment_swigregister(ImportanceSamplingExperiment)

class LHSExperiment(WeightedExperimentImplementation):
    """
    LHS experiment.

    Available constructors:
        LHSExperiment(*size, alwaysShuffle, randomShift*)

        LHSExperiment(*distribution, size, alwaysShuffle, randomShift*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`\\mathrm{card}\\,I` of points that will be generated in the experiment.
    alwaysShuffle : bool
        Flag to tell if the shuffle must be regenerated at each call to generate
        or not.
        Default is *False*: the shuffle is generated once and for all.

    randomShift : bool
        Flag to tell if the point selected in each cell of the shuffle is the center
        of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
        of the distribution to the cell.
        Default is *True*.

    Notes
    -----
    LHSExperiment is a random weighted design of experiments.
    The method generates a sample of points :math:`\\Xi_i` according to the
    distribution :math:`\\mu` with the LHS technique: some cells are determined,
    with the same probabilistic content according to the distribution, each line
    and each column contains exactly one cell, then points are selected among these
    selected cells. The weights associated to the points are all equal to
    :math:`1/\\mathrm{card}\\,I`. When recalled, the :meth:`generate` method generates a new
    sample: the point selection within the cells changes but not the cells
    selection. To change the cell selection, it is necessary to create a new LHS
    Experiment.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    Create an *LHSExperiment*:

    >>> import openturns as ot

    Generate the sample reusing the initial shuffle and using a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [  1.52938   -0.343515  ]
    1 : [ -0.0703427  2.36353   ]
    2 : [  0.576091  -1.79398   ]
    3 : [ -2.11636    0.619315  ]
    4 : [ -0.699601  -0.0570674 ]

    Generate the sample using a new shuffle and a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [ -1.72695   -0.591043  ]
    1 : [ -0.240653  -0.0406593 ]
    2 : [  0.828719   2.12547   ]
    3 : [  2.37061    0.508903  ]
    4 : [ -0.668296  -1.11573   ]

    Generate the sample reusing the initial shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]

    Generate the sample using a new shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.524401 -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [ -1.28155   0        ]
    3 : [ -0.524401  0.524401 ]
    4 : [  1.28155  -1.28155  ]

    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHSExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHSExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.LHSExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LHSExperiment___str__(self, *args)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LHSExperiment_generateWithWeights(self)


    def ComputeShuffle(dimension, totalSize):
        """
        Generate a new cell randomization for external use.

        Parameters
        ----------
        dimension : positive int
            Number of input dimension.
        totalSize : positive int
            Number :math:`\\mathrm{card}\\,I` of points that need to be shuffled.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_ComputeShuffle(dimension, totalSize)

    ComputeShuffle = staticmethod(ComputeShuffle)

    def getShuffle(self):
        """
        Return the cell randomization.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_getShuffle(self)


    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LHSExperiment_setDistribution(self, distribution)


    def getAlwaysShuffle(self):
        """
        Cell randomization flag accessor.

        Returns
        -------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_getAlwaysShuffle(self)


    def setAlwaysShuffle(self, alwaysShuffle):
        """
        Cell randomization flag accessor.

        Parameters
        ----------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_setAlwaysShuffle(self, alwaysShuffle)


    def getRandomShift(self):
        """
        Randomization flag accessor.

        Returns
        -------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_getRandomShift(self)


    def setRandomShift(self, randomShift):
        """
        Randomization flag accessor.

        Parameters
        ----------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_setRandomShift(self, randomShift)


    def __init__(self, *args):
        this = _weightedexperiment.new_LHSExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LHSExperiment
    __del__ = lambda self: None
LHSExperiment_swigregister = _weightedexperiment.LHSExperiment_swigregister
LHSExperiment_swigregister(LHSExperiment)

def LHSExperiment_ComputeShuffle(dimension, totalSize):
    """
    Generate a new cell randomization for external use.

    Parameters
    ----------
    dimension : positive int
        Number of input dimension.
    totalSize : positive int
        Number :math:`\\mathrm{card}\\,I` of points that need to be shuffled.

    Returns
    -------
    shuffle : :class:`~openturns.Matrix`
        For each point, the indices of the shuffled components.
    """
    return _weightedexperiment.LHSExperiment_ComputeShuffle(dimension, totalSize)

class TemperatureProfileImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementationdInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _weightedexperiment.new_TemperatureProfileImplementationdInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_getName(self)


    def __eq__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject___eq__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementationdInterfaceObject
    __del__ = lambda self: None
TemperatureProfileImplementationdInterfaceObject_swigregister = _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_swigregister
TemperatureProfileImplementationdInterfaceObject_swigregister(TemperatureProfileImplementationdInterfaceObject)

class TemperatureProfileImplementation(openturns.common.PersistentObject):
    """
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfileImplementation_getClassName(self)


    def __call__(self, i):
        """
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfileImplementation___call__(self, i)


    def getT0(self):
        """
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfileImplementation_getT0(self)


    def getIMax(self):
        """
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfileImplementation_getIMax(self)


    def __repr__(self):
        return _weightedexperiment.TemperatureProfileImplementation___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_TemperatureProfileImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementation
    __del__ = lambda self: None
TemperatureProfileImplementation_swigregister = _weightedexperiment.TemperatureProfileImplementation_swigregister
TemperatureProfileImplementation_swigregister(TemperatureProfileImplementation)

class TemperatureProfileImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _weightedexperiment.new_TemperatureProfileImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementationTypedInterfaceObject
    __del__ = lambda self: None
TemperatureProfileImplementationTypedInterfaceObject_swigregister = _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_swigregister
TemperatureProfileImplementationTypedInterfaceObject_swigregister(TemperatureProfileImplementationTypedInterfaceObject)

class TemperatureProfile(TemperatureProfileImplementationdInterfaceObject):
    """
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementationdInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementationdInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfile, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfile_getClassName(self)


    def __call__(self, i):
        """
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfile___call__(self, i)


    def getT0(self):
        """
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfile_getT0(self)


    def getIMax(self):
        """
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfile_getIMax(self)


    def __repr__(self):
        return _weightedexperiment.TemperatureProfile___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_TemperatureProfile(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfile
    __del__ = lambda self: None
TemperatureProfile_swigregister = _weightedexperiment.TemperatureProfile_swigregister
TemperatureProfile_swigregister(TemperatureProfile)

class GeometricProfile(TemperatureProfileImplementation):
    """
    Geometric temperature profile.

    Available constructor:
        GeometricProfile()

        GeometricProfile(*T0, c, iMax*)


    Parameters
    ----------
    T0 : float
        Initial temperature
    c : float
        The geometric ratio
        Should be in ]0,1[
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \\begin{equation*}
            T(i) = T_0 * c^{i} \\in [0,iMax]
        \\end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> c = 0.90
    >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)

    """

    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeometricProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeometricProfile, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GeometricProfile_getClassName(self)


    def __call__(self, i):
        """
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> c = 0.90
        >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)
        >>> temperature = geometricProfile(5)
        >>> print(temperature)
        5.9049...
        """
        return _weightedexperiment.GeometricProfile___call__(self, i)


    def __repr__(self):
        return _weightedexperiment.GeometricProfile___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_GeometricProfile(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_GeometricProfile
    __del__ = lambda self: None
GeometricProfile_swigregister = _weightedexperiment.GeometricProfile_swigregister
GeometricProfile_swigregister(GeometricProfile)

class LinearProfile(TemperatureProfileImplementation):
    """
    Linear temperature profile.

    Available constructor:
        LinearProfile(*T0, iMax*)


    Parameters
    ----------
    T0 : float
        Initial temperature
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \\begin{equation*}
            T(i) = T_0*(1 - \\frac{i}{iMax}), i \\in [0,iMax]
        \\end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> linearProfile = ot.LinearProfile(T0, iMax)

    """

    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearProfile, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LinearProfile_getClassName(self)


    def __call__(self, i):
        """
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> linearProfile = ot.LinearProfile(T0, iMax)
        >>> temperature = linearProfile(10)
        >>> print(temperature)
        9.0
        """
        return _weightedexperiment.LinearProfile___call__(self, i)


    def __repr__(self):
        return _weightedexperiment.LinearProfile___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_LinearProfile(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LinearProfile
    __del__ = lambda self: None
LinearProfile_swigregister = _weightedexperiment.LinearProfile_swigregister
LinearProfile_swigregister(LinearProfile)

class SpaceFillingImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementationdInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingImplementationdInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_getName(self)


    def __eq__(self, other):
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject___eq__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementationdInterfaceObject
    __del__ = lambda self: None
SpaceFillingImplementationdInterfaceObject_swigregister = _weightedexperiment.SpaceFillingImplementationdInterfaceObject_swigregister
SpaceFillingImplementationdInterfaceObject_swigregister(SpaceFillingImplementationdInterfaceObject)

class SpaceFillingImplementation(openturns.common.PersistentObject):
    """
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingImplementation_getClassName(self)


    def evaluate(self, sample):
        """
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_evaluate(self, sample)


    def isMinimizationProblem(self):
        """
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFillingImplementation_isMinimizationProblem(self)


    def __repr__(self):
        return _weightedexperiment.SpaceFillingImplementation___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        """
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)


    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementation
    __del__ = lambda self: None
SpaceFillingImplementation_swigregister = _weightedexperiment.SpaceFillingImplementation_swigregister
SpaceFillingImplementation_swigregister(SpaceFillingImplementation)

class SpaceFillingImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementationTypedInterfaceObject
    __del__ = lambda self: None
SpaceFillingImplementationTypedInterfaceObject_swigregister = _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_swigregister
SpaceFillingImplementationTypedInterfaceObject_swigregister(SpaceFillingImplementationTypedInterfaceObject)

class SpaceFilling(SpaceFillingImplementationdInterfaceObject):
    """
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementationdInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFilling, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementationdInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFilling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFilling_getClassName(self)


    def evaluate(self, sample):
        """
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFilling_evaluate(self, sample)


    def isMinimizationProblem(self):
        """
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFilling_isMinimizationProblem(self)


    def __repr__(self):
        return _weightedexperiment.SpaceFilling___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        """
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFilling_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)


    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFilling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SpaceFilling
    __del__ = lambda self: None
SpaceFilling_swigregister = _weightedexperiment.SpaceFilling_swigregister
SpaceFilling_swigregister(SpaceFilling)

class SpaceFillingC2(SpaceFillingImplementation):
    """
    Space filling C2 (centered L2-discrepancy) computation.

    Notes
    -----
    Compute the centered L2 discrepancy:

    .. math::
        :nowrap:

        \\begin{multline*}
        C^2(X_{d}^N) = \\left(\\frac{13}{12}\\right)^{d} - \\frac{2}{N} \\sum_{i=1}^{N} \\prod_{k=1}^{d} \\left( 1 + \\frac{1}{2} |x_k^{(i)} - 0.5| - \\frac{1}{2} |x_k^{(i)} - 0.5|^2 \\right)\\\\
                 + \\frac{1}{N^2} \\sum_{i,j=1}^{N} \\prod_{k=1}^{d} \\left( 1 + \\frac{1}{2} |x_k^{(i)} - 0.5| + \\frac{1}{2} |x_k^{(j)} - 0.5| - \\frac{1}{2} |x_k^{(i)} - x_k^{(j)}| \\right)
        \\end{multline*}

    """

    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingC2, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingC2, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingC2_getClassName(self)


    def evaluate(self, sample):
        """
        Compute the C2 criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The C2 criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the C2 criterion
        >>> crit = ot.SpaceFillingC2().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingC2_evaluate(self, sample)


    def __repr__(self):
        return _weightedexperiment.SpaceFillingC2___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        """
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingC2_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)


    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingC2(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingC2
    __del__ = lambda self: None
SpaceFillingC2_swigregister = _weightedexperiment.SpaceFillingC2_swigregister
SpaceFillingC2_swigregister(SpaceFillingC2)

class SpaceFillingMinDist(SpaceFillingImplementation):
    """
    Space filling minimal distance criterion.

    Notes
    -----
    Compute the minimal distance of sample points

    """

    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingMinDist, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingMinDist, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingMinDist_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.SpaceFillingMinDist___repr__(self)

    def evaluate(self, sample):
        """
        Compute the MinDist criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2-d array like
            The design

        Returns
        -------
        crit : float
            The MinDist criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the MinDist criterion
        >>> crit = ot.SpaceFillingMinDist().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingMinDist_evaluate(self, sample)


    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingMinDist(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingMinDist
    __del__ = lambda self: None
SpaceFillingMinDist_swigregister = _weightedexperiment.SpaceFillingMinDist_swigregister
SpaceFillingMinDist_swigregister(SpaceFillingMinDist)

class SpaceFillingPhiP(SpaceFillingImplementation):
    """
    Space filling PhiP.

    Parameters
    ----------
    p : int
        Parameter for parametrizing the criterion 

    Notes
    -----
    Computes the criterion:

    .. math::
        :nowrap:

        \\begin{equation*}
          \\phi_p(X) = \\sum_{i=1}^{j} \\sum_{j=1}^{n} \\left( |x^{(i)} - x^{(j)}|^{-p} \\right)^{\\frac{1}{p}}
        \\end{equation*}

    This criterion is knwon to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.

    """

    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingPhiP, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingPhiP, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingPhiP_getClassName(self)


    def evaluate(self, sample):
        """
        Compute the PhiP criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The phiP criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the PhiP criterion
        >>> crit = ot.SpaceFillingPhiP(50).evaluate(design)
        """
        return _weightedexperiment.SpaceFillingPhiP_evaluate(self, sample)


    def __repr__(self):
        return _weightedexperiment.SpaceFillingPhiP___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        """
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingPhiP_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)


    def __init__(self, *args):
        this = _weightedexperiment.new_SpaceFillingPhiP(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingPhiP
    __del__ = lambda self: None
SpaceFillingPhiP_swigregister = _weightedexperiment.SpaceFillingPhiP_swigregister
SpaceFillingPhiP_swigregister(SpaceFillingPhiP)

class LHSResult(openturns.common.PersistentObject):
    """
    Summarize the results of an LHS optimization.

    Available constructor:
        LHSResult(*bounds, spaceFilling, nRestart*)

    Parameters
    ----------
    spaceFilling : :class:`~ot.SpaceFilling`
        The space filling criteria used by optimization algorithm
    nRestart : int
        The number of restarts performed by optimization algorithm

    Notes
    -----
    This class is not intendeted to be built by hand, but returned by optimization algorithms.

    Examples
    --------
    >>> import openturns as ot
    >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> profile = ot.GeometricProfile()
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Optim algo
    >>> algo = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
    >>> # first, generate a design
    >>> design = algo.generate()
    >>> # then, get the result
    >>> result = algo.getResult()

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHSResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHSResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSResult_getClassName(self)


    def getNumberOfRestarts(self):
        """
        Restart number accessor.

        Returns
        -------
        restart : int (optional)
            The number of restart.
        """
        return _weightedexperiment.LHSResult_getNumberOfRestarts(self)


    def getOptimalDesign(self, *args):
        """
        Accessor to the optimal design.

        Returns
        -------
        design : :class:`~openturns.Sample`
            The design that optimizes the criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> spaceFilling = ot.SpaceFillingPhiP(10)
        >>> # By Monte Carlo
        >>> algoMC = ot.MonteCarloLHS(lhs, 1000, spaceFilling)
        >>> # Get LHSResult
        >>> optimalDesignMC = algoMC.generate()
        >>> resultMC = algoMC.getResult()
        >>> # By simulated annealing, with restart
        >>> profile = ot.GeometricProfile()
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> optimalDesignSA = algoSA.generateWithRestart(5)
        >>> resultSA = algoSA.getResult()
        >>> # Get optimal results for all restarts
        >>> optimRestart = [resultSA.getOptimalDesign(i) for i in range(resultSA.getNumberOfRestarts())]
        """
        return _weightedexperiment.LHSResult_getOptimalDesign(self, *args)


    def getOptimalValue(self, *args):
        """
        Optimal value accessor.

        Returns
        -------
        value : float (optional)
            The optimal value.
        """
        return _weightedexperiment.LHSResult_getOptimalValue(self, *args)


    def getAlgoHistory(self, *args):
        """
        Accessor to the internal values computed during optimization algorithm.

        Returns
        -------
        history : :class:`~openturns.Point`
            Some internal values computed during optimization algorithm.
            SimulatedAnnealingLHS stores criterion value, temperature
            and probability at each iteration.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> design = algoSA.generateWithRestart(5)
        >>> resultSA = algoSA.getResult()
        >>> criterionHistory = resultSA.getAlgoHistory()
        """
        return _weightedexperiment.LHSResult_getAlgoHistory(self, *args)


    def getC2(self, *args):
        """
        Accessor to the C2 criterion evaluated on the optimal design.

        Returns
        -------
        c2 : float
            The C2 criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> design = algoSA.generate()
        >>> resultSA = algoSA.getResult()
        >>> c2 = resultSA.getC2()
        """
        return _weightedexperiment.LHSResult_getC2(self, *args)


    def getPhiP(self, *args):
        """
        Accessor the PhiP criterion evaluated on the optimal design.

        Returns
        -------
        phiP : float
            The PhiP criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> design = algoSA.generate()
        >>> # Get LHSResult
        >>> resultSA = algoSA.getResult()
        >>> phip = resultSA.getPhiP()
        """
        return _weightedexperiment.LHSResult_getPhiP(self, *args)


    def getMinDist(self, *args):
        """
        Minimum distance accessor.

        Parameters
        ----------
        restart : int (optional)
            The restart index.

        Returns
        -------
        minDist : float
            The minimum distance of sample points.
        """
        return _weightedexperiment.LHSResult_getMinDist(self, *args)


    def drawHistoryCriterion(self, *args):
        """
        Draw criterion history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryCriterion(self, *args)


    def drawHistoryProbability(self, *args):
        """
        Draw probability history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryProbability(self, *args)


    def drawHistoryTemperature(self, *args):
        """
        Draw temperature history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryTemperature(self, *args)


    def add(self, optimalDesign, criterion, C2, PhiP, MinDist, algoHistory):
        return _weightedexperiment.LHSResult_add(self, optimalDesign, criterion, C2, PhiP, MinDist, algoHistory)

    def __repr__(self):
        return _weightedexperiment.LHSResult___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_LHSResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LHSResult
    __del__ = lambda self: None
LHSResult_swigregister = _weightedexperiment.LHSResult_swigregister
LHSResult_swigregister(LHSResult)

class OptimalLHSExperiment(WeightedExperimentImplementation):
    """
    OptimalLHS base class.

    Notes
    -----
    Perform the generation of optimal LHS designs.
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimalLHSExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimalLHSExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.OptimalLHSExperiment_getClassName(self)


    def getLHS(self):
        """
        Return the LHS design.

        Returns
        -------
        value : :class:`~openturns.LHSExperiment`
            Result the factory that builds initial design to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getLHS(self)


    def getSpaceFilling(self):
        """
        Return the space-filling criterion to be optimized.

        Returns
        -------
        value : :class:`~ot.SpaceFilling`
            Criterion function to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getSpaceFilling(self)


    def getResult(self):
        """
        Result accessor.

        Returns
        -------
        value : :class:`~ot.LHSResult`
            Result of generation that contains the optimal design, some criteria and history
        """
        return _weightedexperiment.OptimalLHSExperiment_getResult(self)


    def __repr__(self):
        return _weightedexperiment.OptimalLHSExperiment___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_OptimalLHSExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_OptimalLHSExperiment
    __del__ = lambda self: None
OptimalLHSExperiment_swigregister = _weightedexperiment.OptimalLHSExperiment_swigregister
OptimalLHSExperiment_swigregister(OptimalLHSExperiment)

class MonteCarloLHS(OptimalLHSExperiment):
    """
    Monte Carlo LHS optimization.

    Performs the optimization of an LHS using Monte Carlo simulations.

    Available constructors:
        MonteCarloLHS(*lhsDesign, N*)

        MonteCarloLHS(*lhsDesign, N, spaceFilling*)

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
         Factory that generate designs
    N : int
        Number of simulations
    spaceFilling : :class:`~ot.SpaceFilling`
        Criterion to be optimized
        Default spaceFilling is MinDist

    Notes
    -----
    MonteCarloLHS generate N designs using lhsDesign and returns the optimal one with respect to spaceFilling

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # RandomBruteForce MonteCarlo with N designs (LHS with C2 optimization)
    >>> N = 10000
    >>> optimalLHSAlgorithm = ot.MonteCarloLHS(lhs, N, spaceFilling)

    """

    __swig_setmethods__ = {}
    for _s in [OptimalLHSExperiment]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarloLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimalLHSExperiment]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarloLHS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloLHS_getClassName(self)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloLHS_generateWithWeights(self)


    def __repr__(self):
        return _weightedexperiment.MonteCarloLHS___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_MonteCarloLHS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloLHS
    __del__ = lambda self: None
MonteCarloLHS_swigregister = _weightedexperiment.MonteCarloLHS_swigregister
MonteCarloLHS_swigregister(MonteCarloLHS)

class SimulatedAnnealingLHS(OptimalLHSExperiment):
    """
    LHS optimization using simulated annealing.

    Performs the optimization of an LHS using simulated annealing algorithm.

    Available constructors:

        SimulatedAnnealingLHS(*lhsDesign*)

        SimulatedAnnealingLHS(*lhsDesign, profile*)

        SimulatedAnnealingLHS(*lhsDesign, profile, spaceFilling*)

        SimulatedAnnealingLHS(*initialDesign, distribution*)

        SimulatedAnnealingLHS(*initialDesign, distribution, profile*)

        SimulatedAnnealingLHS(*initialDesign, distribution, profile, spaceFilling*)

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
        Factory that generate designs
    initialDesign : 2d-array sequence
        Initial design to be optimized
    distribution : :class:`~openturns.Distribution`
        Distribution of designs
    profile : :class:`~ot.TemperatureProfile`
        Temperature profile used by the simulated annealing algorithm
        Default one is GeometricProfile
    spaceFilling : :class:`~ot.SpaceFilling`
        Criterion to be optimized
        Default one is SpaceFillingMinDist

    Notes
    -----

    With the first constructor, the initial design is generated thanks to lhsDesign. With the second usage, we fix it.
    Starting from this design, a new design is obtained by permuting one random coordinate of two randomly chosen elements; by construction, this design is also an LHS design. 
    If the new design is better than the previous one, it is kept.  
    If it is worse, it may anyway be kept with some probability, which depends on how these designs compare, but also on a temperature profile 
    T which decreases over time.  This means that jumping away from local extrema becomes less probable over time.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Geometric profile
    >>> geomProfile = ot.GeometricProfile(10.0, 0.95, 2000)
    >>> # Simulated Annealing LHS with geometric temperature profile, C2 optimization
    >>> optimalLHSAlgorithm = ot.SimulatedAnnealingLHS(lhs, geomProfile, spaceFilling)
    """

    __swig_setmethods__ = {}
    for _s in [OptimalLHSExperiment]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulatedAnnealingLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimalLHSExperiment]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulatedAnnealingLHS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SimulatedAnnealingLHS_getClassName(self)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithWeights(self)


    def generateWithRestart(self, nRestart):
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithRestart(self, nRestart)

    def __repr__(self):
        return _weightedexperiment.SimulatedAnnealingLHS___repr__(self)

    def __init__(self, *args):
        this = _weightedexperiment.new_SimulatedAnnealingLHS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_SimulatedAnnealingLHS
    __del__ = lambda self: None
SimulatedAnnealingLHS_swigregister = _weightedexperiment.SimulatedAnnealingLHS_swigregister
SimulatedAnnealingLHS_swigregister(SimulatedAnnealingLHS)

class LowDiscrepancyExperiment(WeightedExperimentImplementation):
    """
    LowDiscrepancy experiment.

    Available constructors:
        LowDiscrepancyExperiment(*size, restart*)

        LowDiscrepancyExperiment(*sequence, size, restart*)

        LowDiscrepancyExperiment(*sequence, distribution, size, restart*)

    Parameters
    ----------
    size : positive int
        Number :math:`N` of points of the sequence.
    sequence : :class:`~openturns.LowDiscrepancySequence`
        Sequence of points :math:`(u_1, \\cdots, u_N)` with low discrepancy.
        If not specified, the sequence is a :class:`~openturns.SobolSequence`.
    distribution :
        Distribution :math:`\\mu` of dimension :math:`n` with an independent copula.
        The low discrepancy sequence :math:`(u_1, \\cdots, u_N)` is uniformly
        distributed over :math:`[0,1]^n`. We use the marginal transformation
        :math:`\\Xi_i =F_i^{-1}(u_i)` to generate points :math:`(\\Xi_i)_{i\\in I}`
        according to the distribution :math:`\\mu`. The weights are all equal to
        :math:`1/N`.
    restart : bool
        Flag to tell if the low discrepancy sequence must be restarted from
        its initial state at each change of distribution or not.
        Default is *True*: the sequence is restarted at each change of
        distribution.

    Notes
    -----
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. When the :meth:`generate`
    method is recalled, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)] * 2)

    Generate the sample with a reinitialization of the sequence at each change
    of distribution:

    >>> myPlane = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, True)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> myPlane.setDistribution(distribution)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]

    Generate the sample keeping the previous state of the sequence at each change
    of distribution:

    >>> myPlane = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> myPlane.setDistribution(distribution)
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.4375 0.5625 ]
    1 : [ 0.3125 0.1875 ]
    2 : [ 0.8125 0.6875 ]
    3 : [ 0.5625 0.4375 ]
    4 : [ 0.0625 0.9375 ]

    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LowDiscrepancyExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LowDiscrepancyExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.LowDiscrepancyExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LowDiscrepancyExperiment___str__(self, *args)

    def setDistribution(self, distribution):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_setDistribution(self, distribution)


    def getSequence(self):
        """
        Return the sequence.

        Returns
        -------
        sequence : :class:`~openturns.LowDiscrepancySequence`
            Sequence of points :math:`(u_1, \\cdots, u_N)` with low discrepancy.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getSequence(self)


    def getRestart(self):
        """
        Return the value of the *restart* flag.

        Returns
        -------
        restart : bool
            The value of the *restart* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRestart(self)


    def setRestart(self, restart):
        """
        Set the value of the *restart* flag.

        Parameters
        ----------
        restart : bool
            The value of the *restart* flag. If equals to *True*, the low
            discrepancy sequence is restarted at each change of distribution,
            else it is changed only if the new distribution has a dimension
            different from the current one.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRestart(self, restart)


    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LowDiscrepancyExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_LowDiscrepancyExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LowDiscrepancyExperiment
    __del__ = lambda self: None
LowDiscrepancyExperiment_swigregister = _weightedexperiment.LowDiscrepancyExperiment_swigregister
LowDiscrepancyExperiment_swigregister(LowDiscrepancyExperiment)

class MonteCarloExperiment(WeightedExperimentImplementation):
    """
    MonteCarlo experiment.

    Available constructors:
        MonteCarloExperiment(*distribution, size*)

        MonteCarloExperiment(*size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    MonteCarloExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. The weights associated to the
    points are all equal to :math:`1/\\mathrm{card}\\,I`. When the :meth:`generate` method is
    recalled, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myPlane = ot.MonteCarloExperiment(ot.Normal(2), 5)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [  0.608202 -1.26617  ]
    1 : [ -0.438266  1.20548  ]
    2 : [ -2.18139   0.350042 ]
    3 : [ -0.355007  1.43725  ]
    4 : [  0.810668  0.793156 ]
    """

    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarloExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarloExperiment, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloExperiment_getClassName(self)


    def __repr__(self):
        return _weightedexperiment.MonteCarloExperiment___repr__(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloExperiment_generateWithWeights(self)


    def __init__(self, *args):
        this = _weightedexperiment.new_MonteCarloExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloExperiment
    __del__ = lambda self: None
MonteCarloExperiment_swigregister = _weightedexperiment.MonteCarloExperiment_swigregister
MonteCarloExperiment_swigregister(MonteCarloExperiment)

# This file is compatible with both classic and new-style classes.


