# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Internal data types."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_typ')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_typ')
    _typ = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_typ', [dirname(__file__)])
        except ImportError:
            import _typ
            return _typ
        try:
            _mod = imp.load_module('_typ', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _typ = swig_import_helper()
    del swig_import_helper
else:
    import _typ
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


def getCorrelationMatrixFromMap(Vars, Map):
    """
    Convert dictionary to CorrelationMatrix.

    Transform a two-dimension dict whose keys are listed in Vars into a CorrelationMatrix.
    The values are numerical.
    No need to define all the elements in the map since CorrelationMatrix is symmetric.

    Examples
    --------
      Vars=['X','Y','Z']
      Map={}
      Map['X']={}
      Map['X']['Y']= 0.1
      Map['X']['Z']= 0.7
      Map['Y']={}
      Map['Y']['Z']= 0.8
      R = getCorrelationMatrixFromMap(Vars,Map)
    """
    corr = CorrelationMatrix(len(Vars))
    i = 0
    for first in Vars:
        j = 0
        for second in Vars:
            if first in Map and second in Map[first]:
                corr[i, j] = Map[first][second]
            j += 1
        i += 1
    return corr

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _typ.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _typ.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _typ.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _typ.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _typ.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _typ.SwigPyIterator_equal(self, x)

    def copy(self):
        return _typ.SwigPyIterator_copy(self)

    def next(self):
        return _typ.SwigPyIterator_next(self)

    def __next__(self):
        return _typ.SwigPyIterator___next__(self)

    def previous(self):
        return _typ.SwigPyIterator_previous(self)

    def advance(self, n):
        return _typ.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _typ.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _typ.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _typ.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _typ.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _typ.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _typ.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _typ.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _typ.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
class UnsignedIntegerCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UnsignedIntegerCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UnsignedIntegerCollection, name)
    __swig_destroy__ = _typ.delete_UnsignedIntegerCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.UnsignedIntegerCollection_clear(self)


    def __len__(self):
        return _typ.UnsignedIntegerCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.UnsignedIntegerCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.UnsignedIntegerCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.UnsignedIntegerCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.UnsignedIntegerCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.UnsignedIntegerCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.UnsignedIntegerCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.UnsignedIntegerCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.UnsignedIntegerCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.UnsignedIntegerCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.UnsignedIntegerCollection_isEmpty(self)


    def __repr__(self):
        return _typ.UnsignedIntegerCollection___repr__(self)

    def __str__(self, *args):
        return _typ.UnsignedIntegerCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_UnsignedIntegerCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
UnsignedIntegerCollection_swigregister = _typ.UnsignedIntegerCollection_swigregister
UnsignedIntegerCollection_swigregister(UnsignedIntegerCollection)

class UnsignedIntegerPersistentCollection(openturns.common.PersistentObject, UnsignedIntegerCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, UnsignedIntegerCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UnsignedIntegerPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, UnsignedIntegerCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UnsignedIntegerPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.UnsignedIntegerPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_UnsignedIntegerPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.UnsignedIntegerPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.UnsignedIntegerPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_UnsignedIntegerPersistentCollection
    __del__ = lambda self: None
UnsignedIntegerPersistentCollection_swigregister = _typ.UnsignedIntegerPersistentCollection_swigregister
UnsignedIntegerPersistentCollection_swigregister(UnsignedIntegerPersistentCollection)

class StringCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringCollection, name)
    __swig_destroy__ = _typ.delete_StringCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.StringCollection_clear(self)


    def __len__(self):
        return _typ.StringCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.StringCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.StringCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.StringCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.StringCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.StringCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.StringCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.StringCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.StringCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.StringCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.StringCollection_isEmpty(self)


    def __repr__(self):
        return _typ.StringCollection___repr__(self)

    def __str__(self, *args):
        return _typ.StringCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_StringCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
StringCollection_swigregister = _typ.StringCollection_swigregister
StringCollection_swigregister(StringCollection)

class StringPersistentCollection(openturns.common.PersistentObject, StringCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, StringCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, StringCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StringPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.StringPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_StringPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.StringPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.StringPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_StringPersistentCollection
    __del__ = lambda self: None
StringPersistentCollection_swigregister = _typ.StringPersistentCollection_swigregister
StringPersistentCollection_swigregister(StringPersistentCollection)

class Description(StringPersistentCollection):
    """
    Collection of strings.

    Available constructors:
        Description(*size=0, value=' '*)

        Description(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \\geq 0`
        Size of the collection.
    value : str
        Value set to the *size* elements.
    sequence : sequence of str
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> ot.Description()
    []
    >>> ot.Description(2)
    [,]
    >>> ot.Description(2, 'C')
    [C,C]

    Use the second constructor:

    >>> vector = ot.Description(['P1', 'P2', 'P3'])
    >>> vector
    [P1,P2,P3]

    Use some functionalities:

    >>> vector[1] = 'P4'
    >>> vector
    [P1,P4,P3]
    >>> vector.add('P5')
    >>> vector
    [P1,P4,P3,P5]
    """

    __swig_setmethods__ = {}
    for _s in [StringPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Description, name, value)
    __swig_getmethods__ = {}
    for _s in [StringPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Description, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Description_getClassName(self)


    def isBlank(self):
        """
        Check if the description is blank.

        Returns
        -------
        isBlank : bool
            *True* if all the components are empty.

        Examples
        --------
        >>> import openturns as ot
        >>> vector = ot.Description(3)
        >>> vector.isBlank()
        True
        >>> vector = ot.Description(['P1', 'P2', ' '])
        >>> vector.isBlank()
        False
        """
        return _typ.Description_isBlank(self)

    __swig_destroy__ = _typ.delete_Description
    __del__ = lambda self: None

    def __repr__(self):
        return _typ.Description___repr__(self)

    def __str__(self, *args):
        return _typ.Description___str__(self, *args)

    def sort(self):
        return _typ.Description_sort(self)

    def BuildDefault(*args):
        """
        Build a default description.

        Parameters
        ----------
        size : int, :math:`size \\geq 0`
            Size of the collection.
        value : str
            Prefixed label of the final labels. By default, it is equal to *Component*.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of dimension *size* built as: *value0, ..., valueN with N=size-1*.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.Description.BuildDefault(3)
        [Component0,Component1,Component2]
        >>> ot.Description.BuildDefault(3, 'C')
        [C0,C1,C2]
        """
        return _typ.Description_BuildDefault(*args)

    BuildDefault = staticmethod(BuildDefault)

    def __init__(self, *args):
        this = _typ.new_Description(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __setitem__(self, arg, valObj):
        return _typ.Description___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Description___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Description___eq__(self, other)

    def __ne__(self, other):
        return _typ.Description___ne__(self, other)
Description_swigregister = _typ.Description_swigregister
Description_swigregister(Description)

def Description_BuildDefault(*args):
    """
    Build a default description.

    Parameters
    ----------
    size : int, :math:`size \\geq 0`
        Size of the collection.
    value : str
        Prefixed label of the final labels. By default, it is equal to *Component*.

    Returns
    -------
    description : :class:`~openturns.Description`
        Description of dimension *size* built as: *value0, ..., valueN with N=size-1*.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.Description.BuildDefault(3)
    [Component0,Component1,Component2]
    >>> ot.Description.BuildDefault(3, 'C')
    [C0,C1,C2]
    """
    return _typ.Description_BuildDefault(*args)

class Indices(UnsignedIntegerPersistentCollection):
    """
    Collection of unsigned integers.

    Available constructors:
        Indices(*size=0, value=0*)

        Indices(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \\geq 0`
        Size of the collection.
    value : positive int
        Value set to the *size* elements.
    sequence : sequence of int
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> ot.Indices(3)
    [0,0,0]
    >>> ot.Indices(3, 4)
    [4,4,4]

    Use the second constructor:

    >>> vector = ot.Indices([100, 30, 70])
    >>> vector
    [100,30,70]

    Use some functionalities:

    >>> vector[1] = 20
    >>> vector
    [100,20,70]
    >>> vector.add(50)
    >>> vector
    [100,20,70,50]
    """

    __swig_setmethods__ = {}
    for _s in [UnsignedIntegerPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Indices, name, value)
    __swig_getmethods__ = {}
    for _s in [UnsignedIntegerPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Indices, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Indices_getClassName(self)

    __swig_destroy__ = _typ.delete_Indices
    __del__ = lambda self: None

    def check(self, bound):
        """
        Check that no value is repeated and no value exceeds the given bound.

        Parameters
        ----------
        bound : positive int
            The bound value.

        Returns
        -------
        check : bool
            *True* if no value is repeated and all values are < bound.
        """
        return _typ.Indices_check(self, bound)


    def isIncreasing(self):
        """
        Check if the indices are increasing.

        Returns
        -------
        isIncreasing : bool
            *True* if the indices are increasing.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices(3)
        >>> indices.fill()
        >>> indices.isIncreasing()
        True
        """
        return _typ.Indices_isIncreasing(self)


    def fill(self, initialValue=0, stepSize=1):
        """
        Fill the indices with a linear progression.

        Starting from the start value *initialValue* by step *stepSize*.

        Parameters
        ----------
        initialValue : positive int
            Initial value. By default it is equal to 0.
        stepSize : positive int
            Step size. By default it is equal to 1.

        Examples
        --------
        >>> import openturns as ot
        >>> indices = ot.Indices(3)
        >>> indices.fill()
        >>> print(indices)
        [0,1,2]
        >>> indices = ot.Indices(3)
        >>> indices.fill(2, 4)
        >>> print(indices)
        [2,6,10]
        """
        return _typ.Indices_fill(self, initialValue, stepSize)


    def __repr__(self):
        return _typ.Indices___repr__(self)

    def __str__(self, *args):
        return _typ.Indices___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_Indices(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __setitem__(self, arg, valObj):
        return _typ.Indices___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Indices___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Indices___eq__(self, other)

    def __ne__(self, other):
        return _typ.Indices___ne__(self, other)
Indices_swigregister = _typ.Indices_swigregister
Indices_swigregister(Indices)

class ScalarCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarCollection, name)
    __swig_destroy__ = _typ.delete_ScalarCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ScalarCollection_clear(self)


    def __len__(self):
        return _typ.ScalarCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.ScalarCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.ScalarCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.ScalarCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ScalarCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ScalarCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ScalarCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ScalarCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ScalarCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ScalarCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.ScalarCollection_isEmpty(self)


    def __repr__(self):
        return _typ.ScalarCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ScalarCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_ScalarCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ScalarCollection_swigregister = _typ.ScalarCollection_swigregister
ScalarCollection_swigregister(ScalarCollection)

class ScalarPersistentCollection(openturns.common.PersistentObject, ScalarCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, ScalarCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ScalarPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, ScalarCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ScalarPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ScalarPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_ScalarPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.ScalarPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ScalarPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_ScalarPersistentCollection
    __del__ = lambda self: None
ScalarPersistentCollection_swigregister = _typ.ScalarPersistentCollection_swigregister
ScalarPersistentCollection_swigregister(ScalarPersistentCollection)

class PointCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PointCollection, name)
    __swig_destroy__ = _typ.delete_PointCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.PointCollection_clear(self)


    def __len__(self):
        return _typ.PointCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.PointCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.PointCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.PointCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.PointCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.PointCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.PointCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.PointCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.PointCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.PointCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.PointCollection_isEmpty(self)


    def __repr__(self):
        return _typ.PointCollection___repr__(self)

    def __str__(self, *args):
        return _typ.PointCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_PointCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
PointCollection_swigregister = _typ.PointCollection_swigregister
PointCollection_swigregister(PointCollection)

class PointPersistentCollection(openturns.common.PersistentObject, PointCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, PointCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, PointCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PointPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.PointPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_PointPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.PointPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.PointPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_PointPersistentCollection
    __del__ = lambda self: None
PointPersistentCollection_swigregister = _typ.PointPersistentCollection_swigregister
PointPersistentCollection_swigregister(PointPersistentCollection)

OT_TYPECHECK_NUMERICALPOINT = _typ.OT_TYPECHECK_NUMERICALPOINT
class Point(ScalarPersistentCollection):
    """
    Real vector.

    Parameters
    ----------
    dimension : int, :math:`n > 0`, optional
        The number of components.
    value : float, optional
        The components value.
        Default creates a null vector.

    Examples
    --------
    Create a Point

    >>> import openturns as ot
    >>> x = ot.Point(3, 1.0)
    >>> x
    class=Point name=Unnamed dimension=3 values=[1,1,1]

    Get or set terms

    >>> print(x[0])
    1.0
    >>> x[0] = 0.0
    >>> print(x[0])
    0.0
    >>> print(x[:2])
    [0,1]

    Create a Point from a flat (1d) array, list or tuple

    >>> import numpy as np
    >>> y = ot.Point((0.0, 1.0, 2.0))
    >>> y = ot.Point(range(3))
    >>> y = ot.Point(np.arange(3))

    and back

    >>> np.array(y)
    array([ 0.,  1.,  2.])

    Addition, subtraction (with compatible dimensions)

    >>> print(x + y)
    [0,2,3]
    >>> print(x - y)
    [0,0,-1]

    Multiplication, division with a scalar

    >>> print(x * 3.0)
    [0,3,3]
    >>> print(x / 3.0)
    [0,0.333333,0.333333]
    """

    __swig_setmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Point, name, value)
    __swig_getmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Point, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Point_getClassName(self)


    def setDescription(self, description):
        """
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components.
        """
        return _typ.Point_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components.

        See Also
        --------
        setDescription
        """
        return _typ.Point_getDescription(self)


    def __repr__(self):
        return _typ.Point___repr__(self)

    def __str__(self, *args):
        return _typ.Point___str__(self, *args)

    def clean(self, threshold):
        return _typ.Point_clean(self, threshold)

    def getDimension(self):
        """
        Accessor to the vector's dimension.

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.Point_getDimension(self)


    def getSize(self):
        """
        Accessor to the vector's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.Point_getSize(self)


    def __imul__(self, scalar):
        return _typ.Point___imul__(self, scalar)

    def __itruediv__(self, *args):
        return _typ.Point___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def norm(self):
        """
        Compute the Euclidean (:math:`L^2`) norm.

        The Euclidean (:math:`L^2`) norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}} = \\norm{\\vect{x}}_2
                            = \\sqrt{\\sum_{i=1}^n x_i^2}

        Returns
        -------
        norm : float
            The vector's Euclidean norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm()
        3.741657...
        """
        return _typ.Point_norm(self)


    def norm1(self):
        """
        Compute the :math:`L^1` norm.

        The :math:`L^1` norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}}_1 = \\sum_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^1` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm1()
        6.0
        """
        return _typ.Point_norm1(self)


    def normInf(self):
        """
        Compute the :math:`L^{\\inf}` norm.

        The :math:`L^{\\inf}` norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}}_{\\inf} = \\max_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^{\\inf}` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normInf()
        3.0
        """
        return _typ.Point_normInf(self)


    def normSquare(self):
        """
        Compute the squared Euclidean norm.

        Returns
        -------
        norm : float
            The vector's squared Euclidean norm.

        See Also
        --------
        norm

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normSquare()
        14.0
        """
        return _typ.Point_normSquare(self)


    def normalize(self):
        """
        Compute the normalized vector with respect to its Euclidean norm.

        Returns
        -------
        normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its Euclidean norm.

        See Also
        --------
        norm

        Raises
        ------
        RuntimeError : If the Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalize())
        [0.267261,0.534522,0.801784]
        """
        return _typ.Point_normalize(self)


    def normalizeSquare(self):
        """
        Compute the normalized vector with respect to its squared Euclidean norm.

        Returns
        -------
        normalized_vector : normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its squared Euclidean norm.

        See Also
        --------
        normSquare

        Raises
        ------
        RuntimeError : If the squared Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalizeSquare())
        [0.0714286,0.285714,0.642857]
        """
        return _typ.Point_normalizeSquare(self)


    def __init__(self, *args):
        this = _typ.new_Point(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __setitem__(self, arg, valObj):
        return _typ.Point___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.Point___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.Point___eq__(self, other)

    def __ne__(self, other):
        return _typ.Point___ne__(self, other)

    def __add__(self, other):
        return _typ.Point___add__(self, other)

    def __sub__(self, other):
        return _typ.Point___sub__(self, other)

    def __mul__(self, s):
        return _typ.Point___mul__(self, s)

    def __rmul__(self, s):
        return _typ.Point___rmul__(self, s)

    def __div__(self, s):
        return _typ.Point___div__(self, s)

    def __truediv__(self, s):
        return _typ.Point___truediv__(self, s)

    def __iadd__(self, other):
        return _typ.Point___iadd__(self, other)

    def __isub__(self, other):
        return _typ.Point___isub__(self, other)
    __swig_destroy__ = _typ.delete_Point
    __del__ = lambda self: None
Point_swigregister = _typ.Point_swigregister
Point_swigregister(Point)


def dot(lhs, rhs):
    return _typ.dot(lhs, rhs)
dot = _typ.dot

# deprecated
class NumericalPoint(Point):
    def __init__(self, *args):
        super(NumericalPoint, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalPoint is deprecated in favor of Point')

class NumericalScalarCollection(ScalarCollection):
    def __init__(self, *args):
        super(NumericalScalarCollection, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalScalarCollection is deprecated in favor of ScalarCollection')


class PointWithDescription(Point):
    """
    Collection of real values with a description for each component.

    Available constructors:
        PointWithDescription(*size=0, value=0.0*)

        PointWithDescription(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \\geq 0`
        Size of the vector.
    value : float
        Value set to the *size* elements.
    sequence : sequence of pair (string, float)
        Components of the vector.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> print(ot.PointWithDescription(2))
    [ : 0,  : 0]
    >>> vector = ot.PointWithDescription(2, 3.0)
    >>> print(vector)
    [ : 3,  : 3]
    >>> vector.setDescription(['c1', 'c2'])
    >>> print(vector)
    [c1 : 3, c2 : 3]

    Use the second constructor:

    >>> vector = ot.PointWithDescription([('C1', 2.0), ('C2', 3.0), ('C3', 4.5)])
    >>> print(vector)
    [C1 : 2, C2 : 3, C3 : 4.5]
    >>> print(vector.getDescription())
    [C1,C2,C3]

    Use some functionalities:

    >>> vector[1] = 7.1
    >>> print(vector)
    [C1 : 2, C2 : 7.1, C3 : 4.5]
    >>> vector.add(6.2)
    >>> print(vector)
    [C1 : 2, C2 : 7.1, C3 : 4.5,  : 6.2]
    """

    __swig_setmethods__ = {}
    for _s in [Point]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointWithDescription, name, value)
    __swig_getmethods__ = {}
    for _s in [Point]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PointWithDescription, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.PointWithDescription_getClassName(self)

    __swig_destroy__ = _typ.delete_PointWithDescription
    __del__ = lambda self: None

    def setDescription(self, description):
        """
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components.
        """
        return _typ.PointWithDescription_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components.

        See Also
        --------
        setDescription
        """
        return _typ.PointWithDescription_getDescription(self)


    def __repr__(self):
        return _typ.PointWithDescription___repr__(self)

    def __str__(self, *args):
        return _typ.PointWithDescription___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_PointWithDescription(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
PointWithDescription_swigregister = _typ.PointWithDescription_swigregister
PointWithDescription_swigregister(PointWithDescription)

class PointWithDescriptionCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointWithDescriptionCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PointWithDescriptionCollection, name)
    __swig_destroy__ = _typ.delete_PointWithDescriptionCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.PointWithDescriptionCollection_clear(self)


    def __len__(self):
        return _typ.PointWithDescriptionCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.PointWithDescriptionCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.PointWithDescriptionCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.PointWithDescriptionCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.PointWithDescriptionCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.PointWithDescriptionCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.PointWithDescriptionCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.PointWithDescriptionCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.PointWithDescriptionCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.PointWithDescriptionCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.PointWithDescriptionCollection_isEmpty(self)


    def __repr__(self):
        return _typ.PointWithDescriptionCollection___repr__(self)

    def __str__(self, *args):
        return _typ.PointWithDescriptionCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_PointWithDescriptionCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
PointWithDescriptionCollection_swigregister = _typ.PointWithDescriptionCollection_swigregister
PointWithDescriptionCollection_swigregister(PointWithDescriptionCollection)

class PointWithDescriptionPersistentCollection(openturns.common.PersistentObject, PointWithDescriptionCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, PointWithDescriptionCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointWithDescriptionPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, PointWithDescriptionCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PointWithDescriptionPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.PointWithDescriptionPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_PointWithDescriptionPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.PointWithDescriptionPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.PointWithDescriptionPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_PointWithDescriptionPersistentCollection
    __del__ = lambda self: None
PointWithDescriptionPersistentCollection_swigregister = _typ.PointWithDescriptionPersistentCollection_swigregister
PointWithDescriptionPersistentCollection_swigregister(PointWithDescriptionPersistentCollection)


# deprecated
class NumericalPointWithDescription(PointWithDescription):
    def __init__(self, *args):
        super(NumericalPointWithDescription, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalPointWithDescription is deprecated in favor of PointWithDescription')

class DomainImplementation(openturns.common.PersistentObject):
    """
    Domain.

    Available constructors:
        Domain(*lowerBound, upperBound*)

    Parameters
    ----------
    lowerBound, upperBound : sequence of float of dimension *dim*
        Define a finite :class:`interval <openturns.Interval>`
        :math:`[lowerBound_0, upperBound_0]\\times \\dots \\times [lowerBound_{dim-1}, upperBound_{dim-1}]`.
        It is allowed to have :math:`lowerBound_i \\geq upperBound_i` for some
        :math:`i`: it simply defines an empty interval.
        By default, an empty interval is created.

    Notes
    -----
    A Domain object can be created through its derived classes:

    - :class:`~openturns.Mesh`

    - :class:`~openturns.RegularGrid`

    - :class:`~openturns.Interval`

    - :class:`~openturns.LevelSet`

    Examples
    --------
    >>> import openturns as ot
    >>> # Create the interval [a, b]
    >>> a = 1
    >>> b = 3
    >>> print(ot.Domain([a], [b]))
    [1, 3]
    >>> print(ot.Domain(ot.Interval(a, b)))
    [1, 3]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DomainImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DomainImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.DomainImplementation_getClassName(self)


    def isEmpty(self):
        """
        Test whether the domain is empty or not.

        Returns
        -------
        isInside : bool
            *True* if the interior of the geometric domain is empty.
        """
        return _typ.DomainImplementation_isEmpty(self)


    def isNumericallyEmpty(self):
        """
        Check if the domain is numerically empty.

        Returns
        -------
        isInside : bool
            Flag telling whether the domain is numerically empty, i.e. if its numerical
            volume is inferior or equal to :math:`\\epsilon` (defined in the
            :class:`~openturns.ResourceMap`:
            :math:`\\epsilon` = DomainImplementation-SmallVolume).

        Examples
        --------
        >>> import openturns as ot
        >>> domain = ot.Domain([1.0, 2.0], [1.0, 2.0]) 
        >>> print(domain.isNumericallyEmpty())
        True
        """
        return _typ.DomainImplementation_isNumericallyEmpty(self)


    def contains(self, point):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _typ.DomainImplementation_contains(self, point)


    def numericallyContains(self, point):
        """
        Check if the given point is inside of the discretization of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside the discretized domain associated
            to the domain. For now, by default, the discretized domain is equal to the
            geometrical domain.
        """
        return _typ.DomainImplementation_numericallyContains(self, point)


    def getNumericalVolume(self):
        """
        Get the volume of the domain.

        Returns
        -------
        volume : float
            Volume of the underlying mesh which is the discretization of the domain.
            For now, by default, it is equal to the geometrical volume.
        """
        return _typ.DomainImplementation_getNumericalVolume(self)


    def getVolume(self):
        """
        Get the geometric volume of the domain.

        Returns
        -------
        volume : float
            Geometrical volume of the domain.
        """
        return _typ.DomainImplementation_getVolume(self)


    def __repr__(self):
        return _typ.DomainImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.DomainImplementation___str__(self, *args)

    def getDimension(self):
        """
        Get the dimension of the domain.

        Returns
        -------
        dim : int
            Dimension of the domain.
        """
        return _typ.DomainImplementation_getDimension(self)


    def getLowerBound(self):
        """
        Get the lower bound of the domain.

        Returns
        -------
        lower : :class:`~openturns.Point`
            The lower bound of an axes-aligned bounding box of the domain.
        """
        return _typ.DomainImplementation_getLowerBound(self)


    def getUpperBound(self):
        """
        Get the upper bound of the domain.

        Returns
        -------
        upper : :class:`~openturns.Point`
            The upper bound of an axes-aligned bounding box of the domain.
        """
        return _typ.DomainImplementation_getUpperBound(self)


    def __init__(self, *args):
        this = _typ.new_DomainImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_DomainImplementation
    __del__ = lambda self: None
DomainImplementation_swigregister = _typ.DomainImplementation_swigregister
DomainImplementation_swigregister(DomainImplementation)

class Interval(DomainImplementation):
    """
    Numerical interval.

    Available constructors:
        Interval(*dim=0*)

        Interval(*lowerBound, upperBound, finiteLowerBound=[True]*dim, finiteUpperBound=[True]*dim*)

    Parameters
    ----------
    dim : int, :math:`dim \\geq 0`
        Dimension of the interval. If only *dim* is mentioned, it leads to create
        the finite interval :math:`[0, 1]^{dim}`.
        By default, an empty interval is created.
    lowerBound, upperBound : float or sequence of float of dimension *dim*
        Define an interval
        :math:`[lowerBound_0, upperBound_0]\\times \\dots \\times [lowerBound_{dim-1}, upperBound_{dim-1}]`.
        It is allowed to have :math:`lowerBound_i \\geq upperBound_i` for some
        :math:`i`: it simply defines an empty interval.
        The *lowerBound* and the *upperBound* must be of the same type. If
        *finiteLowerBound* and *finiteUpperBound* are mentioned, they must be
        sequences.
    finiteLowerBound : sequence of bool of dimension *dim*
        Flags telling for each component of the lower bound whether it is finite or
        not.
    finiteUpperBound : sequence of bool of dimension *dim*
        Flags telling for each component of the upper bound whether it is finite or
        not.

    Notes
    -----
    The meaning of a flag is: if flag :math:`i` is *True*, the corresponding
    component of the given bound is finite and its value is given by bound
    :math:`i`. If not, the corresponding component is infinite and its value is
    either :math:`-\\infty` if bound :math:`i < 0` or :math:`+\\infty` if bound
    :math:`i \\geq 0`.

    It is possible to add or substract two intervals and multiply an interval by a
    scalar.

    Examples
    --------
    >>> import openturns as ot
    >>> # A finite interval
    >>> print(ot.Interval([2.0, 3.0], [4.0, 5.0]))
    [2, 4]
    [3, 5]
    >>> # Not finite intervals
    >>> a = 2.0
    >>> print(ot.Interval([a], [1], [True], [False]))
    [2, (1) +inf[
    >>> print(ot.Interval([1], [a], [False], [True]))
    ]-inf (1), 2]
    >>> # Operations with intervals:
    >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
    >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
    >>> # Addition
    >>> print(interval1 + interval2)
    [3, 11]
    [7, 21]
    >>> # Substraction
    >>> print(interval1 - interval2)
    [-4, 4]
    [-10, 4]
    >>> # Multiplication
    >>> print(interval1 * 3)
    [6, 15]
    [9, 24]
    """

    __swig_setmethods__ = {}
    for _s in [DomainImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Interval, name, value)
    __swig_getmethods__ = {}
    for _s in [DomainImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Interval, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Interval_getClassName(self)


    def isEmpty(self):
        """
        Test whether the domain is empty or not.

        Returns
        -------
        isInside : bool
            *True* if the interior of the geometric domain is empty.
        """
        return _typ.Interval_isEmpty(self)


    def contains(self, point):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _typ.Interval_contains(self, point)


    def numericallyContains(self, point):
        """
        Check if the given point is inside of the discretization of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside the discretized domain associated
            to the domain. For now, by default, the discretized domain is equal to the
            geometrical domain.
        """
        return _typ.Interval_numericallyContains(self, point)


    def intersect(self, other):
        """
        Get the intersection with an other interval.

        Parameters
        ----------
        otherInterval : :class:`~openturns.Interval`
            Interval of the same dimension.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            An interval corresponding to the intersection of the current interval with
            *otherInterval*.

        Examples
        --------
        >>> import openturns as ot
        >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
        >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
        >>> print(interval1.intersect(interval2))
        [2, 5]
        [4, 8]
        """
        return _typ.Interval_intersect(self, other)


    def join(self, other):
        """
        Get the smallest interval containing both the current interval and another one.

        Parameters
        ----------
        otherInterval : :class:`~openturns.Interval`
            Interval of the same dimension.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Smallest interval containing both the current interval and
            *otherInterval*.

        Examples
        --------
        >>> import openturns as ot
        >>> interval1 = ot.Interval([2.0, 3.0], [5.0, 8.0])
        >>> interval2 = ot.Interval([1.0, 4.0], [6.0, 13.0])
        >>> print(interval1.join(interval2))
        [1, 6]
        [3, 13]
        """
        return _typ.Interval_join(self, other)


    def __add__(self, rhs):
        return _typ.Interval___add__(self, rhs)

    def __sub__(self, rhs):
        return _typ.Interval___sub__(self, rhs)

    def __iadd__(self, other):
        return _typ.Interval___iadd__(self, other)

    def __isub__(self, other):
        return _typ.Interval___isub__(self, other)

    def __mul__(self, scalar):
        return _typ.Interval___mul__(self, scalar)

    def __imul__(self, scalar):
        return _typ.Interval___imul__(self, scalar)

    def __eq__(self, *args):
        return _typ.Interval___eq__(self, *args)

    def __ne__(self, *args):
        return _typ.Interval___ne__(self, *args)

    def getLowerBound(self):
        """
        Get the lower bound.

        Returns
        -------
        lowerBound : :class:`~openturns.Point`
            Value of the lower bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getLowerBound())
        [2,3]
        """
        return _typ.Interval_getLowerBound(self)


    def setLowerBound(self, lowerBound):
        """
        Set the lower bound.

        Parameters
        ----------
        lowerBound : sequence of float
            Value of the lower bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setLowerBound([-4, -5])
        >>> print(interval)
        [-4, 1]
        [-5, 1]
        """
        return _typ.Interval_setLowerBound(self, lowerBound)


    def getUpperBound(self):
        """
        Get the upper bound.

        Returns
        -------
        upperBound : :class:`~openturns.Point`
            Value of the upper bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getUpperBound())
        [4,5]
        """
        return _typ.Interval_getUpperBound(self)


    def setUpperBound(self, upperBound):
        """
        Set the upper bound.

        Parameters
        ----------
        upperBound : sequence of float
            Value of the upper bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setUpperBound([4, 5])
        >>> print(interval)
        [0, 4]
        [0, 5]
        """
        return _typ.Interval_setUpperBound(self, upperBound)


    def getFiniteLowerBound(self):
        """
        Tell for each component of the lower bound whether it is finite or not.

        Returns
        -------
        flags : :class:`~openturns.BoolCollection`
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the lower bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getFiniteLowerBound())
        [1,0]
        """
        return _typ.Interval_getFiniteLowerBound(self)


    def setFiniteLowerBound(self, finiteLowerBound):
        """
        Tell for each component of the lower bound whether it is finite or not.

        Parameters
        ----------
        flags : sequence of bool
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the lower bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setFiniteLowerBound([True, False])
        >>> print(interval)
        [0, 1]
        ]-inf (0), 1]
        """
        return _typ.Interval_setFiniteLowerBound(self, finiteLowerBound)


    def getFiniteUpperBound(self):
        """
        Tell for each component of the upper bound whether it is finite or not.

        Returns
        -------
        flags : :class:`~openturns.BoolCollection`
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the upper bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getFiniteUpperBound())
        [1,1]
        """
        return _typ.Interval_getFiniteUpperBound(self)


    def setFiniteUpperBound(self, finiteUpperBound):
        """
        Tell for each component of the upper bound whether it is finite or not.

        Parameters
        ----------
        flags : sequence of bool
            If the :math:`i^{th}` element is *False*, the corresponding component of
            the upper bound is infinite. Otherwise, it is finite.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval(2)
        >>> interval.setFiniteUpperBound([True, False])
        >>> print(interval)
        [0, 1]
        [0, (1) +inf[
        """
        return _typ.Interval_setFiniteUpperBound(self, finiteUpperBound)


    def __repr__(self):
        return _typ.Interval___repr__(self)

    def __str__(self, *args):
        return _typ.Interval___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_Interval(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_Interval
    __del__ = lambda self: None
Interval_swigregister = _typ.Interval_swigregister
Interval_swigregister(Interval)

class MatrixImplementation(ScalarPersistentCollection):
    __swig_setmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.MatrixImplementation_getClassName(self)


    def __repr__(self):
        return _typ.MatrixImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.MatrixImplementation___str__(self, *args)

    def __call__(self, *args):
        return _typ.MatrixImplementation___call__(self, *args)

    def getNbRows(self):
        return _typ.MatrixImplementation_getNbRows(self)

    def getNbColumns(self):
        return _typ.MatrixImplementation_getNbColumns(self)

    def getDimension(self):
        return _typ.MatrixImplementation_getDimension(self)

    def transpose(self):
        return _typ.MatrixImplementation_transpose(self)

    def getRow(self, rowIndex):
        return _typ.MatrixImplementation_getRow(self, rowIndex)

    def getRowSym(self, rowIndex):
        return _typ.MatrixImplementation_getRowSym(self, rowIndex)

    def getColumn(self, columnIndex):
        return _typ.MatrixImplementation_getColumn(self, columnIndex)

    def getColumnSym(self, columnIndex):
        return _typ.MatrixImplementation_getColumnSym(self, columnIndex)

    def __add__(self, matrix):
        return _typ.MatrixImplementation___add__(self, matrix)

    def __iadd__(self, matrix):
        return _typ.MatrixImplementation___iadd__(self, matrix)

    def __sub__(self, matrix):
        return _typ.MatrixImplementation___sub__(self, matrix)

    def __isub__(self, matrix):
        return _typ.MatrixImplementation___isub__(self, matrix)

    def genProd(self, matrix, transposeLeft=False, transposeRight=False):
        return _typ.MatrixImplementation_genProd(self, matrix, transposeLeft, transposeRight)

    def symProd(self, m, symSide):
        return _typ.MatrixImplementation_symProd(self, m, symSide)

    def genPower(self, n):
        return _typ.MatrixImplementation_genPower(self, n)

    def symPower(self, n):
        return _typ.MatrixImplementation_symPower(self, n)

    def genVectProd(self, pt, transpose=False):
        return _typ.MatrixImplementation_genVectProd(self, pt, transpose)

    def symVectProd(self, pt):
        return _typ.MatrixImplementation_symVectProd(self, pt)

    def triangularVectProd(self, *args):
        return _typ.MatrixImplementation_triangularVectProd(self, *args)

    def __mul__(self, s):
        return _typ.MatrixImplementation___mul__(self, s)

    def __imul__(self, s):
        return _typ.MatrixImplementation___imul__(self, s)

    def __truediv__(self, *args):
        return _typ.MatrixImplementation___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv__(self, *args):
        return _typ.MatrixImplementation___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def symmetrize(self):
        return _typ.MatrixImplementation_symmetrize(self)

    def triangularize(self, isLowerTriangular):
        return _typ.MatrixImplementation_triangularize(self, isLowerTriangular)

    def solveLinearSystemRect(self, *args):
        return _typ.MatrixImplementation_solveLinearSystemRect(self, *args)

    def solveLinearSystemSquare(self, *args):
        return _typ.MatrixImplementation_solveLinearSystemSquare(self, *args)

    def solveLinearSystemTri(self, *args):
        return _typ.MatrixImplementation_solveLinearSystemTri(self, *args)

    def solveLinearSystemSym(self, *args):
        return _typ.MatrixImplementation_solveLinearSystemSym(self, *args)

    def solveLinearSystemCov(self, *args):
        return _typ.MatrixImplementation_solveLinearSystemCov(self, *args)

    def triangularProd(self, *args):
        return _typ.MatrixImplementation_triangularProd(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        return _typ.MatrixImplementation_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        return _typ.MatrixImplementation_computeDeterminant(self, keepIntact)

    def computeLogAbsoluteDeterminantSym(self, keepIntact=True):
        return _typ.MatrixImplementation_computeLogAbsoluteDeterminantSym(self, keepIntact)

    def computeDeterminantSym(self, keepIntact=True):
        return _typ.MatrixImplementation_computeDeterminantSym(self, keepIntact)

    def computeTrace(self):
        return _typ.MatrixImplementation_computeTrace(self)

    def computeEigenValuesSquare(self, keepIntact=True):
        return _typ.MatrixImplementation_computeEigenValuesSquare(self, keepIntact)

    def computeEVSquare(self, v, keepIntact=True):
        return _typ.MatrixImplementation_computeEVSquare(self, v, keepIntact)

    def computeEigenValuesSym(self, keepIntact=True):
        return _typ.MatrixImplementation_computeEigenValuesSym(self, keepIntact)

    def computeEVSym(self, v, keepIntact=True):
        return _typ.MatrixImplementation_computeEVSym(self, v, keepIntact)

    def computeSingularValues(self, keepIntact=True):
        return _typ.MatrixImplementation_computeSingularValues(self, keepIntact)

    def computeSVD(self, fullSVD=False, keepIntact=True):
        return _typ.MatrixImplementation_computeSVD(self, fullSVD, keepIntact)

    def isSymmetric(self):
        return _typ.MatrixImplementation_isSymmetric(self)

    def isPositiveDefinite(self, keepIntact=True):
        return _typ.MatrixImplementation_isPositiveDefinite(self, keepIntact)

    def hasUnitRange(self):
        return _typ.MatrixImplementation_hasUnitRange(self)

    def clean(self, threshold):
        return _typ.MatrixImplementation_clean(self, threshold)

    def cleanSym(self, threshold):
        return _typ.MatrixImplementation_cleanSym(self, threshold)

    def computeCholesky(self, keepIntact=True):
        return _typ.MatrixImplementation_computeCholesky(self, keepIntact)
    if _newclass:
        CholeskyUpdate = staticmethod(_typ.MatrixImplementation_CholeskyUpdate)
    else:
        CholeskyUpdate = _typ.MatrixImplementation_CholeskyUpdate
    if _newclass:
        CholeskyDowndate = staticmethod(_typ.MatrixImplementation_CholeskyDowndate)
    else:
        CholeskyDowndate = _typ.MatrixImplementation_CholeskyDowndate

    def computeQR(self, fullQR=False, keepIntact=True):
        return _typ.MatrixImplementation_computeQR(self, fullQR, keepIntact)

    def computeGram(self, transpose=True):
        return _typ.MatrixImplementation_computeGram(self, transpose)

    def __eq__(self, rhs):
        return _typ.MatrixImplementation___eq__(self, rhs)

    def __ne__(self, rhs):
        return _typ.MatrixImplementation___ne__(self, rhs)

    def isEmpty(self):
        return _typ.MatrixImplementation_isEmpty(self)

    def isTriangular(self, lower=True):
        return _typ.MatrixImplementation_isTriangular(self, lower)

    def __baseaddress__(self):
        return _typ.MatrixImplementation___baseaddress__(self)

    def __elementsize__(self):
        return _typ.MatrixImplementation___elementsize__(self)

    def __stride__(self, dim):
        return _typ.MatrixImplementation___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_MatrixImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_MatrixImplementation
    __del__ = lambda self: None
MatrixImplementation_swigregister = _typ.MatrixImplementation_swigregister
MatrixImplementation_swigregister(MatrixImplementation)

def MatrixImplementation_CholeskyUpdate(cholesky, vector):
    return _typ.MatrixImplementation_CholeskyUpdate(cholesky, vector)
MatrixImplementation_CholeskyUpdate = _typ.MatrixImplementation_CholeskyUpdate

def MatrixImplementation_CholeskyDowndate(cholesky, vector):
    return _typ.MatrixImplementation_CholeskyDowndate(cholesky, vector)
MatrixImplementation_CholeskyDowndate = _typ.MatrixImplementation_CholeskyDowndate

class MatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_MatrixImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.MatrixImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.MatrixImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.MatrixImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.MatrixImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_MatrixImplementationTypedInterfaceObject
    __del__ = lambda self: None
MatrixImplementationTypedInterfaceObject_swigregister = _typ.MatrixImplementationTypedInterfaceObject_swigregister
MatrixImplementationTypedInterfaceObject_swigregister(MatrixImplementationTypedInterfaceObject)

class Matrix(MatrixImplementationTypedInterfaceObject):
    """
    Real rectangular matrix.

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`, optional
        Number of rows.
        Default is 1.
    n_columns : int, :math:`n_c > 0`, optional
        Number of columns.
        Default is 1.
    values : sequence of float with size :math:`n_r \\times n_c`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.Matrix(2, 2, range(2 * 2))
    >>> print(M)
    [[ 0 2 ]
     [ 1 3 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 1 ]]

    Create an openturns matrix from a numpy 2d-array (or matrix, or 2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]])
    >>> ot_matrix = ot.Matrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)

    Basic linear algebra operations (provided the dimensions are compatible)

    >>> A = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
    >>> B = ot.Matrix(np.eye(2))
    >>> C = ot.Matrix(3, 2, [1.] * 3 * 2)
    >>> print(A * B - C)
    [[ 0 1 ]
     [ 2 3 ]
     [ 4 5 ]]
    """

    __swig_setmethods__ = {}
    for _s in [MatrixImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Matrix, name, value)
    __swig_getmethods__ = {}
    for _s in [MatrixImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Matrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Matrix_getClassName(self)


    def clean(self, threshold):
        """
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_matrix : :class:`~openturns.Matrix`
            Input matrix with elements smaller than the threshold set to zero.
        """
        return _typ.Matrix_clean(self, threshold)


    def __repr__(self):
        return _typ.Matrix___repr__(self)

    def __str__(self, *args):
        return _typ.Matrix___str__(self, *args)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.Matrix_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.Matrix_getNbColumns(self)


    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.Matrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]
         [ 5 6 ]]
        >>> print(M.transpose())
        [[ 1 3 5 ]
         [ 2 4 6 ]]
        """
        return _typ.Matrix_transpose(self)


    def __add__(self, *args):
        return _typ.Matrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.Matrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.Matrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.Matrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystem(self, *args):
        """
        Solve a rectangular linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : :class:`~openturns.Point` or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the rectangular linear system.

        Notes
        -----

        This will handle both matrices and vectors, as well as underdetermined, square
        or overdetermined linear systems although you'd better type explicitely your
        matrix if it has some properties that could simplify the resolution (see
        :class:`~openturns.TriangularMatrix`, :class:`~openturns.SquareMatrix`).

        This uses LAPACK's `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_.
        The `RCOND` parameter of this routine can be changed through the `MatrixImplementation-DefaultSmallPivot`
        key of the :class:`~openturns.ResourceMap`.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> b = ot.Point([1.0] * 3)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.Matrix_solveLinearSystem(self, *args)


    def computeSingularValues(self, keepIntact=True):
        """
        Compute the singular values.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitely stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \\min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \\times n_c` matrix
            :math:`\\mat{\\Sigma}` of the SVD decomposition.

        See also
        --------
        computeSVD

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M.computeSingularValues(True))
        [9.52552,0.514301]
        """
        return _typ.Matrix_computeSingularValues(self, keepIntact)


    def computeSVD(self, fullSVD=False, keepIntact=True):
        """
        Compute the singular values decomposition (SVD).

        The singular values decomposition of a rectangular matrix :math:`\\mat{M}` with
        size :math:`n_r > n_c` reads:

        .. math::

            \\mat{M} = \\mat{U} \\mat{\\Sigma} \\Tr{\\mat{V}}

        where :math:`\\mat{U}` is an :math:`n_r \\times n_r` orthogonal matrix,
        :math:`\\mat{\\Sigma}` is an :math:`n_r \\times n_c` diagonal matrix and
        :math:`\\mat{V}` is an :math:`n_c \\times n_c` orthogonal matrix.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitely stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \\min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \\times n_c` matrix
            :math:`\\mat{\\Sigma}` of the SVD.
        U : :class:`~openturns.SquareMatrix`
            The left orthogonal matrix of the SVD.
        VT : :class:`~openturns.SquareMatrix`
            The transposed right orthogonal matrix of the SVD.

        Notes
        -----
        This uses LAPACK's `DGESDD <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesdd.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> singular_values, U, VT = M.computeSVD(True)
        >>> Sigma = ot.Matrix(M.getNbRows(), M.getNbColumns())
        >>> for i in range(singular_values.getSize()):
        ...     Sigma[i, i] = singular_values[i]
        >>> np.testing.assert_array_almost_equal(U * Sigma * VT, M)
        """
        return _typ.Matrix_computeSVD(self, fullSVD, keepIntact)


    def computeQR(self, fullQR=False, keepIntact=True):
        """
        Compute the QR factorization. By default, it is the *economic* decomposition which is computed.

        The economic QR factorization of a rectangular matrix :math:`\\mat{M}` with
        :math:`n_r \\geq n_c` (more rows than columns) is defined as follows:

        .. math::

            \\mat{M} = \\mat{Q} \\mat{R}
                    = \\mat{Q} \\begin{bmatrix} \\mat{R_1} \\\\ \\mat{0} \\end{bmatrix}
                    = \\begin{bmatrix} \\mat{Q_1}, \\mat{Q_2} \\end{bmatrix}
                      \\begin{bmatrix} \\mat{R_1} \\\\ \\mat{0} \\end{bmatrix}
                    = \\mat{Q_1} \\mat{R_1}

        where :math:`\\mat{R_1}` is an :math:`n_c \\times n_c` upper triangular matrix,
        :math:`\\mat{Q_1}` is :math:`n_r \\times n_c`, :math:`\\mat{Q_2}` is
        :math:`n_r \\times (n_r - n_c)`, and :math:`\\mat{Q_1}` and :math:`\\mat{Q_2}`
        both have orthogonal columns.

        Parameters
        ----------
        full_qr : bool, optional
            A flag telling whether `Q`, `R` or `Q1`, `R1` are returned.
            Default is *False* and returns `Q1`, `R1`.
        keep_intact : bool, optional
            A flag telling whether the present matrix is preserved or not in the computation of the decomposition.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        Q1 : :class:`~openturns.Matrix`
            The orthogonal matrix of the economic QR factorization.
        R1 : :class:`~openturns.TriangularMatrix`
            The right (upper) triangular matrix of the economic QR factorization.
        Q : :class:`~openturns.Matrix`
            The orthogonal matrix of the full QR factorization.
        R : :class:`~openturns.TriangularMatrix`
            The right (upper) triangular matrix of the full QR factorization.

        Notes
        -----
        The economic QR factorization is often used for solving overdetermined linear
        systems (where the operator :math:`\\mat{M}` has :math:`n_r \\geq n_c`) in the
        least-square sense because it implies solving a (simple) triangular system:

        .. math::

            \\vect{\\hat{x}} = \\arg\\min\\limits_{\\vect{x} \\in \\Rset^{n_r}} \\|\\mat{M} \\vect{x} - \\vect{b}\\|
                           = \\mat{R_1}^{-1} (\\Tr{\\mat{Q_1}} \\vect{b})

        This uses LAPACK's `DGEQRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dgeqrf.f.html>`_
        and `DORGQR <http://www.netlib.org/lapack/lapack-3.1.1/html/dorgqr.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> Q1, R1 = M.computeQR()
        >>> np.testing.assert_array_almost_equal(Q1 * R1, M)
        """
        return _typ.Matrix_computeQR(self, fullQR, keepIntact)


    def computeGram(self, transpose=True):
        """
        Compute the associated Gram matrix.

        Parameters
        ----------
        transposed : bool
            Tells if matrix is to be transposed or not.
            Default value is True

        Returns
        -------
        MMT : :class:`~openturns.Matrix`
            The Gram matrix.

        Notes
        -----
        When transposed is set to `True`, the method computes :math:`cM^t \\times \\cM`.
        Otherwise it computes :math:`\\cM \\ times \\cM^t`

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> MtM = M.computeGram()
        >>> print(MtM)
        [[ 35 44 ]
         [ 44 56 ]]
        >>> MMt = M.computeGram(False)
        >>> print(MMt)
        [[  5 11 17 ]
         [ 11 25 39 ]
         [ 17 39 61 ]]
        """
        return _typ.Matrix_computeGram(self, transpose)


    def __eq__(self, rhs):
        return _typ.Matrix___eq__(self, rhs)

    def isEmpty(self):
        """
        Tell if the matrix is empty.

        Returns
        -------
        is_empty : bool
            True if the matrix contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[]])
        >>> M.isEmpty()
        True
        """
        return _typ.Matrix_isEmpty(self)


    def __baseaddress__(self):
        return _typ.Matrix___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Matrix___elementsize__(self)

    def __stride__(self, dim):
        return _typ.Matrix___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_Matrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.Matrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.Matrix___setitem__(self, args, valObj)

    def __rmul__(self, s):
        return _typ.Matrix___rmul__(self, s)

    def __matmul__(self, other):
        return _typ.Matrix___matmul__(self, other)
    __swig_destroy__ = _typ.delete_Matrix
    __del__ = lambda self: None
Matrix_swigregister = _typ.Matrix_swigregister
Matrix_swigregister(Matrix)


# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Matrix (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def Matrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__()), True),
                                                'strides': (self.__stride__(0), self.__stride__(1)),
                                                'version': 3,
                                                }
    return super(Matrix, self).__getattribute__(name)
Matrix.__getattribute__ = Matrix___getattribute__

class SquareMatrix(Matrix):
    """
    Real square matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SquareMatrix(2, range(2 * 2))
    >>> print(M)
    [[ 0 2 ]
     [ 1 3 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 1 ]]

    Create an openturns matrix from a **square** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [3.0, 4.0]])
    >>> ot_matrix = ot.SquareMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)

    Basic linear algebra operations (provided the dimensions are compatible)

    >>> A = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
    >>> B = ot.SquareMatrix(np.eye(2))
    >>> C = ot.Matrix(3, 2, [1.0] * 3 * 2)
    >>> print(A * B - C)
    [[ 0 1 ]
     [ 2 3 ]
     [ 4 5 ]]
    >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
    >>> print(A ** 2)
    [[  7 10 ]
     [ 15 22 ]]
    """

    __swig_setmethods__ = {}
    for _s in [Matrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SquareMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Matrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SquareMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SquareMatrix_getClassName(self)


    def __repr__(self):
        return _typ.SquareMatrix___repr__(self)

    def getDimension(self):
        """
        Accessor to the dimension (the number of rows).

        Returns
        -------
        dimension : int
        """
        return _typ.SquareMatrix_getDimension(self)


    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.SquareMatrix_transpose(self)


    def __add__(self, *args):
        return _typ.SquareMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SquareMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SquareMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SquareMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SquareMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystem(self, *args):
        """
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitely the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = ot.Point([1.0] * 2)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.SquareMatrix_solveLinearSystem(self, *args)


    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        """
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.SquareMatrix_computeLogAbsoluteDeterminant(self, keepIntact)


    def computeDeterminant(self, keepIntact=True):
        """
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.SquareMatrix_computeDeterminant(self, keepIntact)


    def computeTrace(self):
        """
        Compute the trace of the matrix.

        Returns
        -------
        trace : float
            The trace of the matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> M.computeTrace()
        5.0
        """
        return _typ.SquareMatrix_computeTrace(self)


    def computeEigenValues(self, keepIntact=True):
        """
        Compute eigen values.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.ComplexCollection`
            Eigen values.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> M.computeEigenValues()
        [(-0.372281,0),(5.37228,0)]
        """
        return _typ.SquareMatrix_computeEigenValues(self, keepIntact)


    def computeEV(self, keepIntact=True):
        """
        Compute the eigen values decomposition (EVD).

        The eigen values decomposition of a square matrix :math:`\\mat{M}` with
        size :math:`n` reads:

        .. math::

            \\mat{M} = \\mat{\\Phi} \\mat{\\Lambda} \\mat{\\Phi}^{-1}

        where :math:`\\mat{\\Lambda}` is an :math:`n \\times n` diagonal matrix and
        :math:`\\mat{\\Phi}` is an :math:`n \\times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigen_values : :class:`~openturns.ComplexCollection`
            The vector of eigen values with size :math:`n` that form the diagonal of
            the :math:`n \\times n` matrix :math:`\\mat{\\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DGEEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgeev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareComplexMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> from scipy.linalg import inv # SquareComplexMatrix does not implement solveLinearSystem
        >>> Phi, Lambda = np.matrix(Phi), np.matrix(Lambda)
        >>> np.testing.assert_array_almost_equal(Phi * Lambda * inv(Phi), M)
        """
        return _typ.SquareMatrix_computeEV(self, keepIntact)


    def isDiagonal(self):
        """
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.SquareMatrix_isDiagonal(self)


    def __init__(self, *args):
        this = _typ.new_SquareMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.SquareMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SquareMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_SquareMatrix
    __del__ = lambda self: None
SquareMatrix_swigregister = _typ.SquareMatrix_swigregister
SquareMatrix_swigregister(SquareMatrix)

class SymmetricMatrix(SquareMatrix):
    """
    Real symmetric matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Raises
    ------
    TypeError : If the matrix is not symmetric.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SymmetricMatrix(2, [0.0, 2.0, 2.0, 1.0])
    >>> print(M)
    [[ 0 2 ]
     [ 2 1 ]]

    Get or set terms

    >>> print(M[0, 0])
    0.0
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    1.0
    >>> print(M[:, 0])
    [[ 1 ]
     [ 2 ]]

    Create an openturns matrix from a **symmetric** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [2.0, 4.0]])
    >>> ot_matrix = ot.SymmetricMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    __swig_setmethods__ = {}
    for _s in [SquareMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymmetricMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SquareMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymmetricMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SymmetricMatrix_getClassName(self)


    def checkSymmetry(self):
        """Check if the internal representation is really symmetric."""
        return _typ.SymmetricMatrix_checkSymmetry(self)


    def isDiagonal(self):
        """
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.SymmetricMatrix_isDiagonal(self)


    def __repr__(self):
        return _typ.SymmetricMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.SymmetricMatrix___str__(self, *args)

    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.SymmetricMatrix_transpose(self)


    def __add__(self, *args):
        return _typ.SymmetricMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SymmetricMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SymmetricMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SymmetricMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SymmetricMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystem(self, *args):
        """
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitely the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = ot.Point([1.0] * 2)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.SymmetricMatrix_solveLinearSystem(self, *args)


    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        """
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.SymmetricMatrix_computeLogAbsoluteDeterminant(self, keepIntact)


    def computeDeterminant(self, keepIntact=True):
        """
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.SymmetricMatrix_computeDeterminant(self, keepIntact)


    def computeEigenValues(self, keepIntact=True):
        """
        Compute eigen values.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            Eigen values.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> print(M.computeEigenValues())
        [-4.70156,1.70156]
        """
        return _typ.SymmetricMatrix_computeEigenValues(self, keepIntact)


    def computeEV(self, keepIntact=True):
        """
        Compute the eigen values decomposition (EVD).

        The eigen values decomposition of a square matrix :math:`\\mat{M}` with
        size :math:`n` reads:

        .. math::

            \\mat{M} = \\mat{\\Phi} \\mat{\\Lambda} \\Tr{\\mat{\\Phi}}

        where :math:`\\mat{\\Lambda}` is an :math:`n \\times n` diagonal matrix and
        :math:`\\mat{\\Phi}` is an :math:`n \\times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigen_values : :class:`~openturns.Point`
            The vector of eigen values with size :math:`n` that form the diagonal of
            the :math:`n \\times n` matrix :math:`\\mat{\\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DSYEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dsyev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> np.testing.assert_array_almost_equal(Phi * Lambda * Phi.transpose(), M)
        """
        return _typ.SymmetricMatrix_computeEV(self, keepIntact)


    def __eq__(self, rhs):
        return _typ.SymmetricMatrix___eq__(self, rhs)

    def __init__(self, *args):
        this = _typ.new_SymmetricMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.SymmetricMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SymmetricMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.SymmetricMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_SymmetricMatrix
    __del__ = lambda self: None
SymmetricMatrix_swigregister = _typ.SymmetricMatrix_swigregister
SymmetricMatrix_swigregister(SymmetricMatrix)


def SymmetricMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkSymmetry()
    return super(SymmetricMatrix, self).__getattribute__(name)
SymmetricMatrix.__getattribute__ = SymmetricMatrix___getattribute__

class TensorImplementation(ScalarPersistentCollection):
    """
    Tensor.

    Available constructors:
        Tensor(*n_rows, n_columns, n_sheets*)

        Tensor(*n_rows, n_columns, n_sheets, values*)

        Tensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows.
    n_columns : int, :math:`n_c > 0`
        Number of columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of float with size :math:`n_r \\times n_c \\times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of float
        Values.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Tensor(2, 2, 2, [1]))
    sheet #0
    [[ 1 0 ]
     [ 0 0 ]]
    sheet #1
    [[ 0 0 ]
     [ 0 0 ]]
    >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
    >>> print(T)
    sheet #0
    [[  0  2 ]
     [  1  3 ]]
    sheet #1
    [[  4  6 ]
     [  5  7 ]]
    sheet #2
    [[  8 10 ]
     [  9 11 ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0.0
    >>> T[0, 0, 0] = 1.
    >>> print(T[0, 0, 0])
    1.0

    Create an openturns tensor from a sequence:

    >>> T = ot.Tensor([[[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> print(T)
    sheet #0
    [[  1  4 ]
     [  7 10 ]]
    sheet #1
    [[  2  5 ]
     [  8 11 ]]
    sheet #2
    [[  3  6 ]
     [  9 12 ]]
    """

    __swig_setmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [ScalarPersistentCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TensorImplementation_getClassName(self)


    def clean(self, threshold):
        """
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.Tensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.TensorImplementation_clean(self, threshold)


    def __repr__(self):
        return _typ.TensorImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.TensorImplementation___str__(self, *args)

    def __call__(self, *args):
        return _typ.TensorImplementation___call__(self, *args)

    def getSheet(self, k):
        """
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.TensorImplementation_getSheet(self, k)


    def setSheet(self, k, m):
        """
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.TensorImplementation_setSheet(self, k, m)


    def getSheetSym(self, k):
        return _typ.TensorImplementation_getSheetSym(self, k)

    def setSheetSym(self, k, m):
        return _typ.TensorImplementation_setSheetSym(self, k, m)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.TensorImplementation_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.TensorImplementation_getNbColumns(self)


    def getNbSheets(self):
        """
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getNbSheets())
        3
        """
        return _typ.TensorImplementation_getNbSheets(self)


    def isSymmetric(self):
        return _typ.TensorImplementation_isSymmetric(self)

    def symmetrize(self):
        return _typ.TensorImplementation_symmetrize(self)

    def __eq__(self, rhs):
        return _typ.TensorImplementation___eq__(self, rhs)

    def isEmpty(self):
        """
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            *True* if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor()
        >>> T.isEmpty()
        True
        """
        return _typ.TensorImplementation_isEmpty(self)


    def __baseaddress__(self):
        return _typ.TensorImplementation___baseaddress__(self)

    def __elementsize__(self):
        return _typ.TensorImplementation___elementsize__(self)

    def __stride__(self, dim):
        return _typ.TensorImplementation___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_TensorImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_TensorImplementation
    __del__ = lambda self: None
TensorImplementation_swigregister = _typ.TensorImplementation_swigregister
TensorImplementation_swigregister(TensorImplementation)

class TensorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_TensorImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.TensorImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.TensorImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.TensorImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.TensorImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_TensorImplementationTypedInterfaceObject
    __del__ = lambda self: None
TensorImplementationTypedInterfaceObject_swigregister = _typ.TensorImplementationTypedInterfaceObject_swigregister
TensorImplementationTypedInterfaceObject_swigregister(TensorImplementationTypedInterfaceObject)

class Tensor(TensorImplementationTypedInterfaceObject):
    """
    Tensor.

    Available constructors:
        Tensor(*n_rows, n_columns, n_sheets*)

        Tensor(*n_rows, n_columns, n_sheets, values*)

        Tensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows.
    n_columns : int, :math:`n_c > 0`
        Number of columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of float with size :math:`n_r \\times n_c \\times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of float
        Values.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Tensor(2, 2, 2, [1]))
    sheet #0
    [[ 1 0 ]
     [ 0 0 ]]
    sheet #1
    [[ 0 0 ]
     [ 0 0 ]]
    >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
    >>> print(T)
    sheet #0
    [[  0  2 ]
     [  1  3 ]]
    sheet #1
    [[  4  6 ]
     [  5  7 ]]
    sheet #2
    [[  8 10 ]
     [  9 11 ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0.0
    >>> T[0, 0, 0] = 1.
    >>> print(T[0, 0, 0])
    1.0

    Create an openturns tensor from a sequence:

    >>> T = ot.Tensor([[[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> print(T)
    sheet #0
    [[  1  4 ]
     [  7 10 ]]
    sheet #1
    [[  2  5 ]
     [  8 11 ]]
    sheet #2
    [[  3  6 ]
     [  9 12 ]]
    """

    __swig_setmethods__ = {}
    for _s in [TensorImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Tensor, name, value)
    __swig_getmethods__ = {}
    for _s in [TensorImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Tensor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Tensor_getClassName(self)


    def clean(self, threshold):
        """
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.Tensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.Tensor_clean(self, threshold)


    def __repr__(self):
        return _typ.Tensor___repr__(self)

    def __str__(self, *args):
        return _typ.Tensor___str__(self, *args)

    def getSheet(self, k):
        """
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.Tensor_getSheet(self, k)


    def setSheet(self, k, m):
        """
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.Tensor_setSheet(self, k, m)


    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.Tensor_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.Tensor_getNbColumns(self)


    def getNbSheets(self):
        """
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getNbSheets())
        3
        """
        return _typ.Tensor_getNbSheets(self)


    def __eq__(self, rhs):
        return _typ.Tensor___eq__(self, rhs)

    def isEmpty(self):
        """
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            *True* if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor()
        >>> T.isEmpty()
        True
        """
        return _typ.Tensor_isEmpty(self)


    def __baseaddress__(self):
        return _typ.Tensor___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Tensor___elementsize__(self)

    def __stride__(self, dim):
        return _typ.Tensor___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_Tensor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.Tensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.Tensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_Tensor
    __del__ = lambda self: None
Tensor_swigregister = _typ.Tensor_swigregister
Tensor_swigregister(Tensor)


# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Tensor (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def Tensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns(), self.getNbSheets()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__()), True),
                                                'strides': (self.__stride__(0), self.__stride__(1), self.__stride__(2)),
                                                'version': 3,
                                                }
    return super(Tensor, self).__getattribute__(name)
Tensor.__getattribute__ = Tensor___getattribute__

class SymmetricTensor(Tensor):
    """
    Symmetric tensor.

    Available constructors:
        SymmetricTensor(*n_rows, n_sheets*)

        SymmetricTensor(*n_rows, n_sheets, values*)

        SymmetricTensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows and columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of float with size :math:`n_r \\times n_r \\times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of float
        Values.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.SymmetricTensor(2, 2, [0, 1]))
    sheet #0
    [[ 0 1 ]
     [ 1 0 ]]
    sheet #1
    [[ 0 0 ]
     [ 0 0 ]]
    >>> T = ot.SymmetricTensor(2, 3, range(2*2*3))
    >>> print(T)
    sheet #0
    [[  0  1 ]
     [  1  3 ]]
    sheet #1
    [[  4  5 ]
     [  5  7 ]]
    sheet #2
    [[  8  9 ]
     [  9 11 ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0.0
    >>> T[0, 0, 0] = 1.0
    >>> print(T[0, 0, 0])
    1.0

    Create an openturns tensor from a sequence:

    >>> T = ot.SymmetricTensor([[[1.0, 2.0, 3.0], [7.0, 8.0, 9.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> print(T)
    sheet #0
    [[  1  7 ]
     [  7 10 ]]
    sheet #1
    [[  2  8 ]
     [  8 11 ]]
    sheet #2
    [[  3  9 ]
     [  9 12 ]]
    """

    __swig_setmethods__ = {}
    for _s in [Tensor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SymmetricTensor, name, value)
    __swig_getmethods__ = {}
    for _s in [Tensor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SymmetricTensor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SymmetricTensor_getClassName(self)


    def __repr__(self):
        return _typ.SymmetricTensor___repr__(self)

    def __str__(self, *args):
        return _typ.SymmetricTensor___str__(self, *args)

    def checkSymmetry(self):
        """Check if the internal representation is really symmetric."""
        return _typ.SymmetricTensor_checkSymmetry(self)


    def getSheet(self, k):
        """
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.SymmetricTensor_getSheet(self, k)


    def setSheet(self, k, m):
        """
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.SymmetricTensor_setSheet(self, k, m)


    def __init__(self, *args):
        this = _typ.new_SymmetricTensor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.SymmetricTensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.SymmetricTensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_SymmetricTensor
    __del__ = lambda self: None
SymmetricTensor_swigregister = _typ.SymmetricTensor_swigregister
SymmetricTensor_swigregister(SymmetricTensor)


def SymmetricTensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkSymmetry()
    return super(SymmetricTensor, self).__getattribute__(name)
SymmetricTensor.__getattribute__ = SymmetricTensor___getattribute__

class ComplexCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexCollection, name)
    __swig_destroy__ = _typ.delete_ComplexCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ComplexCollection_clear(self)


    def __len__(self):
        return _typ.ComplexCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.ComplexCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.ComplexCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.ComplexCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ComplexCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ComplexCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ComplexCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ComplexCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ComplexCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ComplexCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.ComplexCollection_isEmpty(self)


    def __repr__(self):
        return _typ.ComplexCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_ComplexCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
ComplexCollection_swigregister = _typ.ComplexCollection_swigregister
ComplexCollection_swigregister(ComplexCollection)

class ComplexPersistenCollection(openturns.common.PersistentObject, ComplexCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, ComplexCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexPersistenCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, ComplexCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexPersistenCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexPersistenCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_ComplexPersistenCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.ComplexPersistenCollection___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexPersistenCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_ComplexPersistenCollection
    __del__ = lambda self: None
ComplexPersistenCollection_swigregister = _typ.ComplexPersistenCollection_swigregister
ComplexPersistenCollection_swigregister(ComplexPersistenCollection)

class ComplexMatrixImplementation(ComplexPersistenCollection):
    """
    Complex Matrix.

    Available constructors:
        ComplexMatrix(*nr, nc*)

        ComplexMatrix(*nr, nc, values*)

    Parameters
    ----------
    nr : integer
        The number of rows of the complex matrix.
    nc : integer
        The number of columns of the complex matrix.
    values : sequence of complex number
        The sequence must have :math:`n_r \\times n_c` elements. It might be a
        :class:`~openturns.ComplexCollection` or a :class:`~openturns.ScalarCollection`. Default is (0, 0).

    See also
    --------
    ComplexTensor

    Examples
    --------
    >>> import openturns as ot
    >>> m = ot.ComplexMatrix(2, 2, [1+2j, 3+4j , 5+6j, 7+8j])
    >>> print(m)
    [[ (1,2) (5,6) ]
     [ (3,4) (7,8) ]]
    >>> m = ot.ComplexMatrix(2, 3, range(2*3))
    >>> print(m)
    [[ (0,0) (2,0) (4,0) ]
     [ (1,0) (3,0) (5,0) ]]

    Create a matrix from a numpy array:

    >>> import numpy as np
    >>> array = np.array([[1, 2], [3, 4], [5, 6]])
    >>> m = ot.ComplexMatrix(array)
    >>> print(m)
    [[ (1,0) (2,0) ]
     [ (3,0) (4,0) ]
     [ (5,0) (6,0) ]]

    """

    __swig_setmethods__ = {}
    for _s in [ComplexPersistenCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexMatrixImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [ComplexPersistenCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexMatrixImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexMatrixImplementation_getClassName(self)


    def solveLinearSystemRect(self, *args):
        return _typ.ComplexMatrixImplementation_solveLinearSystemRect(self, *args)

    def clean(self, threshold):
        """
        Clean the matrix according to a specific threshold.

        Parameters
        ----------
        threshold : positive float
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.ComplexMatrixImplementation_clean(self, threshold)


    def cleanHerm(self, threshold):
        return _typ.ComplexMatrixImplementation_cleanHerm(self, threshold)

    def __repr__(self):
        return _typ.ComplexMatrixImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexMatrixImplementation___str__(self, *args)

    def __call__(self, *args):
        return _typ.ComplexMatrixImplementation___call__(self, *args)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        nr : integer
            The number of rows of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrixImplementation_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        nc : integer
            The number of columns of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrixImplementation_getNbColumns(self)


    def getDimension(self):
        return _typ.ComplexMatrixImplementation_getDimension(self)

    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.ComplexMatrixImplementation_transpose(self)


    def transposeHerm(self):
        return _typ.ComplexMatrixImplementation_transposeHerm(self)

    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.ComplexMatrixImplementation_conjugate(self)


    def conjugateHerm(self):
        return _typ.ComplexMatrixImplementation_conjugateHerm(self)

    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.ComplexMatrixImplementation_conjugateTranspose(self)


    def hermitianize(self):
        return _typ.ComplexMatrixImplementation_hermitianize(self)

    def realRect(self):
        return _typ.ComplexMatrixImplementation_realRect(self)

    def realSym(self):
        return _typ.ComplexMatrixImplementation_realSym(self)

    def imagRect(self):
        return _typ.ComplexMatrixImplementation_imagRect(self)

    def imagSym(self):
        return _typ.ComplexMatrixImplementation_imagSym(self)

    def __add__(self, *args):
        return _typ.ComplexMatrixImplementation___add__(self, *args)

    def __sub__(self, *args):
        return _typ.ComplexMatrixImplementation___sub__(self, *args)

    def __mul__(self, s):
        return _typ.ComplexMatrixImplementation___mul__(self, s)

    def __truediv__(self, *args):
        return _typ.ComplexMatrixImplementation___truediv__(self, *args)
    __div__ = __truediv__



    def genProd(self, matrix):
        return _typ.ComplexMatrixImplementation_genProd(self, matrix)

    def symProd(self, m, symSide):
        return _typ.ComplexMatrixImplementation_symProd(self, m, symSide)

    def hermProd(self, m, hermSide):
        return _typ.ComplexMatrixImplementation_hermProd(self, m, hermSide)

    def triangularProd(self, *args):
        return _typ.ComplexMatrixImplementation_triangularProd(self, *args)

    def genPower(self, n):
        return _typ.ComplexMatrixImplementation_genPower(self, n)

    def symPower(self, n):
        return _typ.ComplexMatrixImplementation_symPower(self, n)

    def hermPower(self, n):
        return _typ.ComplexMatrixImplementation_hermPower(self, n)

    def genVectProd(self, *args):
        return _typ.ComplexMatrixImplementation_genVectProd(self, *args)

    def hermVectProd(self, *args):
        return _typ.ComplexMatrixImplementation_hermVectProd(self, *args)

    def triangularVectProd(self, *args):
        return _typ.ComplexMatrixImplementation_triangularVectProd(self, *args)

    def isHermitian(self):
        return _typ.ComplexMatrixImplementation_isHermitian(self)

    def isHermitianPositiveDefinite(self, keepIntact=True):
        return _typ.ComplexMatrixImplementation_isHermitianPositiveDefinite(self, keepIntact)

    def computeCholesky(self, keepIntact=True):
        return _typ.ComplexMatrixImplementation_computeCholesky(self, keepIntact)

    def __eq__(self, rhs):
        return _typ.ComplexMatrixImplementation___eq__(self, rhs)

    def __ne__(self, rhs):
        return _typ.ComplexMatrixImplementation___ne__(self, rhs)

    def isEmpty(self):
        """
        Test whether the matrix is empty or not.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the dimensions of the matrix is zero.
        """
        return _typ.ComplexMatrixImplementation_isEmpty(self)


    def isTriangular(self, lower=True):
        return _typ.ComplexMatrixImplementation_isTriangular(self, lower)

    def __baseaddress__(self):
        return _typ.ComplexMatrixImplementation___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexMatrixImplementation___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexMatrixImplementation___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_ComplexMatrixImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_ComplexMatrixImplementation
    __del__ = lambda self: None
ComplexMatrixImplementation_swigregister = _typ.ComplexMatrixImplementation_swigregister
ComplexMatrixImplementation_swigregister(ComplexMatrixImplementation)


class NumericalComplexCollection(ComplexCollection):
    def __init__(self, *args):
        super(NumericalComplexCollection, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalComplexCollection is deprecated in favor of ComplexCollection')

class ComplexMatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexMatrixImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexMatrixImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_ComplexMatrixImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.ComplexMatrixImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.ComplexMatrixImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.ComplexMatrixImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.ComplexMatrixImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_ComplexMatrixImplementationTypedInterfaceObject
    __del__ = lambda self: None
ComplexMatrixImplementationTypedInterfaceObject_swigregister = _typ.ComplexMatrixImplementationTypedInterfaceObject_swigregister
ComplexMatrixImplementationTypedInterfaceObject_swigregister(ComplexMatrixImplementationTypedInterfaceObject)

class ComplexMatrix(ComplexMatrixImplementationTypedInterfaceObject):
    """
    Complex Matrix.

    Available constructors:
        ComplexMatrix(*nr, nc*)

        ComplexMatrix(*nr, nc, values*)

    Parameters
    ----------
    nr : integer
        The number of rows of the complex matrix.
    nc : integer
        The number of columns of the complex matrix.
    values : sequence of complex number
        The sequence must have :math:`n_r \\times n_c` elements. It might be a
        :class:`~openturns.ComplexCollection` or a :class:`~openturns.ScalarCollection`. Default is (0, 0).

    See also
    --------
    ComplexTensor

    Examples
    --------
    >>> import openturns as ot
    >>> m = ot.ComplexMatrix(2, 2, [1+2j, 3+4j , 5+6j, 7+8j])
    >>> print(m)
    [[ (1,2) (5,6) ]
     [ (3,4) (7,8) ]]
    >>> m = ot.ComplexMatrix(2, 3, range(2*3))
    >>> print(m)
    [[ (0,0) (2,0) (4,0) ]
     [ (1,0) (3,0) (5,0) ]]

    Create a matrix from a numpy array:

    >>> import numpy as np
    >>> array = np.array([[1, 2], [3, 4], [5, 6]])
    >>> m = ot.ComplexMatrix(array)
    >>> print(m)
    [[ (1,0) (2,0) ]
     [ (3,0) (4,0) ]
     [ (5,0) (6,0) ]]

    """

    __swig_setmethods__ = {}
    for _s in [ComplexMatrixImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [ComplexMatrixImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexMatrix_getClassName(self)


    def clean(self, threshold):
        """
        Clean the matrix according to a specific threshold.

        Parameters
        ----------
        threshold : positive float
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.ComplexMatrix_clean(self, threshold)


    def solveLinearSystem(self, *args):
        return _typ.ComplexMatrix_solveLinearSystem(self, *args)

    def __repr__(self):
        return _typ.ComplexMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexMatrix___str__(self, *args)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        nr : integer
            The number of rows of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrix_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        nc : integer
            The number of columns of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrix_getNbColumns(self)


    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.ComplexMatrix_transpose(self)


    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.ComplexMatrix_conjugate(self)


    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.ComplexMatrix_conjugateTranspose(self)


    def real(self):
        """
        Accessor to the real part.

        Returns
        -------
        rmat : :class:`~openturns.Matrix`
            A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
            :math:`A_{i, j} = \\mathrm{Re} (M_{i, j})`.
        """
        return _typ.ComplexMatrix_real(self)


    def imag(self):
        """
        Accessor to the imaginary part.

        Returns
        -------
        imat : :class:`~openturns.Matrix`
            A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
            :math:`A_{i, j} = \\mathrm{Im} (M_{i, j})`.
        """
        return _typ.ComplexMatrix_imag(self)


    def __add__(self, *args):
        return _typ.ComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.ComplexMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.ComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.ComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __eq__(self, rhs):
        return _typ.ComplexMatrix___eq__(self, rhs)

    def isEmpty(self):
        """
        Test whether the matrix is empty or not.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the dimensions of the matrix is zero.
        """
        return _typ.ComplexMatrix_isEmpty(self)


    def __baseaddress__(self):
        return _typ.ComplexMatrix___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexMatrix___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexMatrix___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_ComplexMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.ComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.ComplexMatrix___setitem__(self, args, valObj)

    def __rmul__(self, s):
        return _typ.ComplexMatrix___rmul__(self, s)

    def __matmul__(self, *args):
        return _typ.ComplexMatrix___matmul__(self, *args)
    __swig_destroy__ = _typ.delete_ComplexMatrix
    __del__ = lambda self: None
ComplexMatrix_swigregister = _typ.ComplexMatrix_swigregister
ComplexMatrix_swigregister(ComplexMatrix)


# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the ComplexMatrix (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def ComplexMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns()),
                                                'typestr': "|c" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__()), True),
                                                'strides': (self.__stride__(0), self.__stride__(1)),
                                                'version': 3,
                                                }
    return super(ComplexMatrix, self).__getattribute__(name)
ComplexMatrix.__getattribute__ = ComplexMatrix___getattribute__

class SquareComplexMatrix(ComplexMatrix):
    """
    Complex square matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of complex with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates a zero matrix.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.SquareComplexMatrix(2, range(2 * 2))
    >>> print(M)
    [[ (0,0) (2,0) ]
     [ (1,0) (3,0) ]]

    Get or set terms

    >>> print(M[0, 0])
    0j
    >>> M[0, 0] = 1.0
    >>> print(M[0, 0])
    (1+0j)
    >>> print(M[:, 0])
    [[ (1,0) ]
     [ (1,0) ]]


    Create an openturns matrix from a **square** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 2.0], [3.0, 4.0]])
    >>> ot_matrix = ot.SquareComplexMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    __swig_setmethods__ = {}
    for _s in [ComplexMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SquareComplexMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [ComplexMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SquareComplexMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SquareComplexMatrix_getClassName(self)


    def __repr__(self):
        return _typ.SquareComplexMatrix___repr__(self)

    def getDimension(self):
        return _typ.SquareComplexMatrix_getDimension(self)

    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.SquareComplexMatrix_transpose(self)


    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.SquareComplexMatrix_conjugate(self)


    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.SquareComplexMatrix_conjugateTranspose(self)


    def __add__(self, *args):
        return _typ.SquareComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SquareComplexMatrix___sub__(self, *args)

    def __pow__(self, n):
        return _typ.SquareComplexMatrix___pow__(self, n)

    def __mul__(self, *args):
        return _typ.SquareComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SquareComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __init__(self, *args):
        this = _typ.new_SquareComplexMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.SquareComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.SquareComplexMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_SquareComplexMatrix
    __del__ = lambda self: None
SquareComplexMatrix_swigregister = _typ.SquareComplexMatrix_swigregister
SquareComplexMatrix_swigregister(SquareComplexMatrix)

class HermitianMatrix(SquareComplexMatrix):
    """
    Hermitian Matrix.

    Available constructors:
        HermitianMatrix(*dim*)

    Parameters
    ----------
    dim : integer
        The dimension of the Hermitian matrix (square matrix with *dim* rows and 
        *dim* columns).

    See also
    --------
    ComplexMatrix

    Notes
    -----
    The Hermitian matrix is filled with :math:`(0, 0)`. It is not possible to fill
    the matrix from a collection of complex values (to be done later).
    """

    __swig_setmethods__ = {}
    for _s in [SquareComplexMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HermitianMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SquareComplexMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HermitianMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HermitianMatrix_getClassName(self)


    def __repr__(self):
        return _typ.HermitianMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.HermitianMatrix___str__(self, *args)

    def getDimension(self):
        """
        Accessor to the matrix dimension.

        Returns
        -------
        dim : integer
            The dimension of the Hermitian matrix.
        """
        return _typ.HermitianMatrix_getDimension(self)


    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.HermitianMatrix_transpose(self)


    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.HermitianMatrix_conjugate(self)


    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.HermitianMatrix_conjugateTranspose(self)


    def real(self):
        """
        Accessor to the real part.

        Returns
        -------
        rmat : :class:`~openturns.Matrix`
            A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
            :math:`A_{i, j} = \\mathrm{Re} (M_{i, j})`.
        """
        return _typ.HermitianMatrix_real(self)


    def imag(self):
        """
        Accessor to the imaginary part.

        Returns
        -------
        imat : :class:`~openturns.Matrix`
            A real matix :math:`\\mat{A}` of size :math:`n_r \\times n_c` such 
            :math:`A_{i, j} = \\mathrm{Im} (M_{i, j})`.
        """
        return _typ.HermitianMatrix_imag(self)


    def checkHermitian(self):
        """Check if the internal representation is really hermitian."""
        return _typ.HermitianMatrix_checkHermitian(self)


    def __add__(self, *args):
        return _typ.HermitianMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.HermitianMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.HermitianMatrix___mul__(self, *args)

    def __pow__(self, n):
        return _typ.HermitianMatrix___pow__(self, n)

    def __truediv__(self, *args):
        return _typ.HermitianMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def computeCholesky(self, keepIntact=True):
        """
        Compute the Cholesky factor.

        Returns
        -------
        G : :class:`~openturns.ComplexMatrix`
            The Cholesky factor :math:`\\mat{G}`, i.e. the complex matrix such as
            :math:`\\mat{G} \\times \\Tr{\\mat{G}}` is the initial matrix.
        """
        return _typ.HermitianMatrix_computeCholesky(self, keepIntact)


    def __init__(self, *args):
        this = _typ.new_HermitianMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.HermitianMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.HermitianMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.HermitianMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_HermitianMatrix
    __del__ = lambda self: None
HermitianMatrix_swigregister = _typ.HermitianMatrix_swigregister
HermitianMatrix_swigregister(HermitianMatrix)


def HermitianMatrix___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.checkHermitian()
    return super(HermitianMatrix, self).__getattribute__(name)
HermitianMatrix.__getattribute__ = HermitianMatrix___getattribute__

class TriangularMatrix(SquareMatrix):
    """
    Hermitian Matrix.

    Available constructors:
        TriangularMatrix(*dim*)

        TriangularMatrix(*dim, isLower*)

    Parameters
    ----------
    dim : integer
        The dimension of the triangular matrix (square matrix with *dim* rows and 
        *dim* columns).
    isLower : bool
        Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        Default is *True*.

    See also
    --------
    Matrix

    Notes
    -----
    The triangular matrix is filled with 0.
    """

    __swig_setmethods__ = {}
    for _s in [SquareMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TriangularMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SquareMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TriangularMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TriangularMatrix_getClassName(self)


    def checkTriangularity(self):
        return _typ.TriangularMatrix_checkTriangularity(self)

    def isDiagonal(self):
        """
        Test whether the matrix is diagonal or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.TriangularMatrix_isDiagonal(self)


    def __repr__(self):
        return _typ.TriangularMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.TriangularMatrix___str__(self, *args)

    def getDimension(self):
        """
        Accessor to the dimension (the number of rows).

        Returns
        -------
        dimension : int
        """
        return _typ.TriangularMatrix_getDimension(self)


    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.TriangularMatrix_transpose(self)


    def isLowerTriangular(self):
        """
        Test whether the matrix is lower triangular or upper triangular.

        Returns
        -------
        isLower : bool
            Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        """
        return _typ.TriangularMatrix_isLowerTriangular(self)


    def __add__(self, *args):
        return _typ.TriangularMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.TriangularMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.TriangularMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.TriangularMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def solveLinearSystem(self, *args):
        """
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitely the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = ot.Point([1.0] * 2)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.TriangularMatrix_solveLinearSystem(self, *args)


    def __init__(self, *args):
        this = _typ.new_TriangularMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.TriangularMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.TriangularMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.TriangularMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_TriangularMatrix
    __del__ = lambda self: None
TriangularMatrix_swigregister = _typ.TriangularMatrix_swigregister
TriangularMatrix_swigregister(TriangularMatrix)

class TriangularComplexMatrix(SquareComplexMatrix):
    """
    Hermitian Matrix.

    Available constructors:
        TriangularComplexMatrix(*dim*)

        TriangularComplexMatrix(*dim, isLower*)

    Parameters
    ----------
    dim : integer
        The dimension of the triangular matrix (square matrix with *dim* rows and 
        *dim* columns).
    isLower : bool
        Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        Default is *True*.

    See also
    --------
    ComplexMatrix

    Notes
    -----
    The triangular complex matrix is filled with :math:`(0, 0)`. It is not possible to fill
    the matrix from a collection of complex values (to be done later).
    """

    __swig_setmethods__ = {}
    for _s in [SquareComplexMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TriangularComplexMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SquareComplexMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TriangularComplexMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TriangularComplexMatrix_getClassName(self)


    def __repr__(self):
        return _typ.TriangularComplexMatrix___repr__(self)

    def __str__(self, *args):
        return _typ.TriangularComplexMatrix___str__(self, *args)

    def getDimension(self):
        """
        Accessor to the matrix dimension.

        Returns
        -------
        dim : integer
            The dimension of the matrix.
        """
        return _typ.TriangularComplexMatrix_getDimension(self)


    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.TriangularComplexMatrix_transpose(self)


    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.TriangularComplexMatrix_conjugate(self)


    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.TriangularComplexMatrix_conjugateTranspose(self)


    def isLowerTriangular(self):
        """
        Test whether the matrix is lower triangular or upper triangular.

        Returns
        -------
        isLower : bool
            Flag telling if the matrix is triangular lower (*True*) or upper (*False*).
        """
        return _typ.TriangularComplexMatrix_isLowerTriangular(self)


    def __add__(self, *args):
        return _typ.TriangularComplexMatrix___add__(self, *args)

    def __sub__(self, *args):
        return _typ.TriangularComplexMatrix___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.TriangularComplexMatrix___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.TriangularComplexMatrix___truediv__(self, *args)
    __div__ = __truediv__



    def __init__(self, *args):
        this = _typ.new_TriangularComplexMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.TriangularComplexMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.TriangularComplexMatrix___setitem__(self, args, valObj)

    def __rmul__(self, *args):
        return _typ.TriangularComplexMatrix___rmul__(self, *args)
    __swig_destroy__ = _typ.delete_TriangularComplexMatrix
    __del__ = lambda self: None
TriangularComplexMatrix_swigregister = _typ.TriangularComplexMatrix_swigregister
TriangularComplexMatrix_swigregister(TriangularComplexMatrix)


def __mul__(*args):
    return _typ.__mul__(*args)
__mul__ = _typ.__mul__
class ComplexTensorImplementation(ComplexPersistenCollection):
    __swig_setmethods__ = {}
    for _s in [ComplexPersistenCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexTensorImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [ComplexPersistenCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexTensorImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexTensorImplementation_getClassName(self)


    def clean(self, threshold):
        return _typ.ComplexTensorImplementation_clean(self, threshold)

    def __repr__(self):
        return _typ.ComplexTensorImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexTensorImplementation___str__(self, *args)

    def __call__(self, *args):
        return _typ.ComplexTensorImplementation___call__(self, *args)

    def getSheet(self, k):
        return _typ.ComplexTensorImplementation_getSheet(self, k)

    def setSheet(self, k, m):
        return _typ.ComplexTensorImplementation_setSheet(self, k, m)

    def getSheetSym(self, k):
        return _typ.ComplexTensorImplementation_getSheetSym(self, k)

    def setSheetSym(self, k, m):
        return _typ.ComplexTensorImplementation_setSheetSym(self, k, m)

    def getNbRows(self):
        return _typ.ComplexTensorImplementation_getNbRows(self)

    def getNbColumns(self):
        return _typ.ComplexTensorImplementation_getNbColumns(self)

    def getNbSheets(self):
        return _typ.ComplexTensorImplementation_getNbSheets(self)

    def isSymmetric(self):
        return _typ.ComplexTensorImplementation_isSymmetric(self)

    def hermitianize(self):
        return _typ.ComplexTensorImplementation_hermitianize(self)

    def __eq__(self, rhs):
        return _typ.ComplexTensorImplementation___eq__(self, rhs)

    def isEmpty(self):
        return _typ.ComplexTensorImplementation_isEmpty(self)

    def __baseaddress__(self):
        return _typ.ComplexTensorImplementation___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexTensorImplementation___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexTensorImplementation___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_ComplexTensorImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_ComplexTensorImplementation
    __del__ = lambda self: None
ComplexTensorImplementation_swigregister = _typ.ComplexTensorImplementation_swigregister
ComplexTensorImplementation_swigregister(ComplexTensorImplementation)

class ComplexTensorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexTensorImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexTensorImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_ComplexTensorImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.ComplexTensorImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.ComplexTensorImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.ComplexTensorImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.ComplexTensorImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_ComplexTensorImplementationTypedInterfaceObject
    __del__ = lambda self: None
ComplexTensorImplementationTypedInterfaceObject_swigregister = _typ.ComplexTensorImplementationTypedInterfaceObject_swigregister
ComplexTensorImplementationTypedInterfaceObject_swigregister(ComplexTensorImplementationTypedInterfaceObject)

class ComplexTensor(ComplexTensorImplementationTypedInterfaceObject):
    """
    Complex tensor.

    Available constructors:
        ComplexTensor(*n_rows, n_columns, n_sheets*)

        ComplexTensor(*n_rows, n_columns, n_sheets, values*)

        ComplexTensor(*sequence*)

    Parameters
    ----------
    n_rows : int, :math:`n_r > 0`
        Number of rows.
    n_columns : int, :math:`n_c > 0`
        Number of columns.
    n_sheets : int, :math:`n_s > 0`
        Number of sheets.
    values : sequence of complex with size :math:`n_r \\times n_c \\times n_s`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        If not mentioned, a zero tensor is created.
    sequence : sequence of complex
        Values.

    Examples
    --------
    Create a tensor of complex values:

    >>> import openturns as ot
    >>> T = ot.ComplexTensor(2, 2, 2, range(2 * 2 * 2))
    >>> print(T)
    sheet #0
    [[ (0,0) (2,0) ]
     [ (1,0) (3,0) ]]
    sheet #1
    [[ (4,0) (6,0) ]
     [ (5,0) (7,0) ]]

    Get or set terms:

    >>> print(T[0, 0, 0])
    0j
    >>> T[0, 0, 0] = 1.0
    >>> print(T[0, 0, 0])
    (1+0j)

    Create an openturns tensor from a numpy 3d-array:

    >>> import numpy as np
    >>> np_3d_array = np.array([[[1.0, 2.0, 3.0], [4.0, 5.0, 6.0]], [[7.0, 8.0, 9.0], [10.0, 11.0, 12.0]]])
    >>> ot_tensor = ot.ComplexTensor(np_3d_array)

    and back

    >>> np_tensor = np.array(ot_tensor)
    """

    __swig_setmethods__ = {}
    for _s in [ComplexTensorImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexTensor, name, value)
    __swig_getmethods__ = {}
    for _s in [ComplexTensorImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexTensor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexTensor_getClassName(self)


    def clean(self, threshold):
        """
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.ComplexTensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.ComplexTensor_clean(self, threshold)


    def __repr__(self):
        return _typ.ComplexTensor___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexTensor___str__(self, *args)

    def getSheet(self, k):
        """
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.ComplexMatrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor(2,2,3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  (0,0)  (2,0) ]
         [  (1,0)  (3,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        >>> print(T.getSheet(0))
        [[ (0,0) (2,0) ]
         [ (1,0) (3,0) ]]
        """
        return _typ.ComplexTensor_getSheet(self, k)


    def setSheet(self, k, m):
        """
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.ComplexMatrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor(2,2,3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  (0,0)  (2,0) ]
         [  (1,0)  (3,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        >>> M = ot.ComplexMatrix([[1,2],[3,4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  (1,0)  (2,0) ]
         [  (3,0)  (4,0) ]]
        sheet #1
        [[  (4,0)  (6,0) ]
         [  (5,0)  (7,0) ]]
        sheet #2
        [[  (8,0) (10,0) ]
         [  (9,0) (11,0) ]]
        """
        return _typ.ComplexTensor_setSheet(self, k, m)


    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.ComplexTensor_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.ComplexTensor_getNbColumns(self)


    def getNbSheets(self):
        """
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int
        """
        return _typ.ComplexTensor_getNbSheets(self)


    def __eq__(self, rhs):
        return _typ.ComplexTensor___eq__(self, rhs)

    def isEmpty(self):
        """
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            True if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.ComplexTensor()
        >>> T.isEmpty()
        True
        """
        return _typ.ComplexTensor_isEmpty(self)


    def __baseaddress__(self):
        return _typ.ComplexTensor___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexTensor___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexTensor___stride__(self, dim)

    def __init__(self, *args):
        this = _typ.new_ComplexTensor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.ComplexTensor___getitem__(self, args)

    def __setitem__(self, args, val):
        return _typ.ComplexTensor___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_ComplexTensor
    __del__ = lambda self: None
ComplexTensor_swigregister = _typ.ComplexTensor_swigregister
ComplexTensor_swigregister(ComplexTensor)


# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the ComplexTensor (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def ComplexTensor___getattribute__(self, name):
    """Implement attribute accesses."""
    if (name == '__array_interface__'):
        self.__dict__['__array_interface__'] = {'shape': (self.getNbRows(), self.getNbColumns(), self.getNbSheets()),
                                                'typestr': "|c" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__()), True),
                                                'strides': (self.__stride__(0), self.__stride__(1), self.__stride__(2)),
                                                'version': 3,
                                                }
    return object.__getattribute__(self, name)
ComplexTensor.__getattribute__ = ComplexTensor___getattribute__

class CovarianceMatrixCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceMatrixCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceMatrixCollection, name)
    __swig_destroy__ = _typ.delete_CovarianceMatrixCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.CovarianceMatrixCollection_clear(self)


    def __len__(self):
        return _typ.CovarianceMatrixCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.CovarianceMatrixCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.CovarianceMatrixCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.CovarianceMatrixCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.CovarianceMatrixCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.CovarianceMatrixCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.CovarianceMatrixCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.CovarianceMatrixCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.CovarianceMatrixCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.CovarianceMatrixCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.CovarianceMatrixCollection_isEmpty(self)


    def __repr__(self):
        return _typ.CovarianceMatrixCollection___repr__(self)

    def __str__(self, *args):
        return _typ.CovarianceMatrixCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_CovarianceMatrixCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
CovarianceMatrixCollection_swigregister = _typ.CovarianceMatrixCollection_swigregister
CovarianceMatrixCollection_swigregister(CovarianceMatrixCollection)

class CovarianceMatrixPersistentCollection(openturns.common.PersistentObject, CovarianceMatrixCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, CovarianceMatrixCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceMatrixPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, CovarianceMatrixCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceMatrixPersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.CovarianceMatrixPersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _typ.new_CovarianceMatrixPersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _typ.CovarianceMatrixPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _typ.CovarianceMatrixPersistentCollection___str__(self, *args)
    __swig_destroy__ = _typ.delete_CovarianceMatrixPersistentCollection
    __del__ = lambda self: None
CovarianceMatrixPersistentCollection_swigregister = _typ.CovarianceMatrixPersistentCollection_swigregister
CovarianceMatrixPersistentCollection_swigregister(CovarianceMatrixPersistentCollection)

class CovarianceMatrix(SymmetricMatrix):
    """
    Covariance (real symmetric positive definite) matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.
    values : sequence of float with size :math:`n^2`, optional
        Values. OpenTURNS uses **column-major** ordering (like Fortran) for
        reshaping the flat list of values.
        Default creates an identity matrix.

    Raises
    ------
    TypeError : If the matrix is not symmetric.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> C = ot.CovarianceMatrix(2, [1.0, 0.5, 0.5, 1.0])
    >>> print(C)
    [[ 1   0.5 ]
     [ 0.5 1   ]]

    Get or set terms

    >>> print(C[0, 1])
    0.5
    >>> C[0, 1] = 0.6
    >>> print(C[0, 1])
    0.6
    >>> print(C[:, 0])
    [[ 1   ]
     [ 0.6 ]]

    Create an openturns matrix from a **symmetric** numpy 2d-array (or matrix, or
    2d-list)...

    >>> import numpy as np
    >>> np_2d_array = np.array([[1.0, 0.5], [0.5, 1.0]])
    >>> ot_matrix = ot.CovarianceMatrix(np_2d_array)

    and back

    >>> np_matrix = np.matrix(ot_matrix)
    """

    __swig_setmethods__ = {}
    for _s in [SymmetricMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SymmetricMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.CovarianceMatrix_getClassName(self)


    def __repr__(self):
        return _typ.CovarianceMatrix___repr__(self)

    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.CovarianceMatrix_transpose(self)


    def __add__(self, *args):
        return _typ.CovarianceMatrix___add__(self, *args)

    def __mul__(self, *args):
        return _typ.CovarianceMatrix___mul__(self, *args)

    def isPositiveDefinite(self, keepIntact=True):
        """
        Test whether the matrix is positive definite or not.

        A matrix :math:`\\mat{M}` is positive definite if :math:`\\Tr{\\vect{z}} \\mat{M} \\vect{z}`
        is positive for every compatible non-zero column vector :math:`\\vect{z}`.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.CovarianceMatrix_isPositiveDefinite(self, keepIntact)


    def computeCholesky(self, keepIntact=True):
        """
        Compute the Cholesky factor.

        The Cholesky factor of a covariance (real symmetric positive definite) matrix
        :math:`\\mat{C}` is the lower triangular matrix :math:`\\mat{L}` such that:

        .. math::

            \\mat{C} = \\mat{L} \\Tr{\\mat{L}}

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        cholesky_factor : :class:`~openturns.SquareMatrix`
            The left (lower) Cholesky factor.
        """
        return _typ.CovarianceMatrix_computeCholesky(self, keepIntact)


    def solveLinearSystem(self, *args):
        """
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitely the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = ot.Point([1.0] * 2)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.CovarianceMatrix_solveLinearSystem(self, *args)


    def __init__(self, *args):
        this = _typ.new_CovarianceMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.CovarianceMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.CovarianceMatrix___setitem__(self, args, valObj)
    __swig_destroy__ = _typ.delete_CovarianceMatrix
    __del__ = lambda self: None
CovarianceMatrix_swigregister = _typ.CovarianceMatrix_swigregister
CovarianceMatrix_swigregister(CovarianceMatrix)

class CorrelationMatrix(CovarianceMatrix):
    """
    Correlation Matrix.

    Available constructors:
        CorrelationMatrix(*dim*)

        CorrelationMatrix(*dim, values*)

    Parameters
    ----------
    dim : integer
        The dimension of the correlation matrix (square matrix with *dim* rows and 
        *dim* columns).
    values : sequence of float
        Collection of :math:`dim^2` scalar values to put in the correlation matrix,
        filled by rows. When not specified, the correlation matrix is initialized to
        the identity matrix.

    See also
    --------
    CovarianceMatrix

    Notes
    -----
    In the first usage, the correlation matrix is the identity matrix.

    In the second usage, the correlation matrix contains the specified values,
    filled by rows.

    .. warning::

        No check is made on the values, in particular the diagonal elements are not
        forced to be equal to 1 and the positiveness of the matrix is not checked.
    """

    __swig_setmethods__ = {}
    for _s in [CovarianceMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CorrelationMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CorrelationMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.CorrelationMatrix_getClassName(self)


    def __repr__(self):
        return _typ.CorrelationMatrix___repr__(self)

    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.CorrelationMatrix_transpose(self)


    def __init__(self, *args):
        this = _typ.new_CorrelationMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, args):
        return _typ.CorrelationMatrix___getitem__(self, args)

    def __setitem__(self, args, valObj):
        return _typ.CorrelationMatrix___setitem__(self, args, valObj)

    def __mul__(self, *args):
        return _typ.CorrelationMatrix___mul__(self, *args)
    __swig_destroy__ = _typ.delete_CorrelationMatrix
    __del__ = lambda self: None
CorrelationMatrix_swigregister = _typ.CorrelationMatrix_swigregister
CorrelationMatrix_swigregister(CorrelationMatrix)

class IdentityMatrix(CorrelationMatrix):
    """
    Identity matrix.

    Parameters
    ----------
    size : int, :math:`n > 0`, optional
        Matrix size.
        Default is 1.

    Examples
    --------
    Create a matrix

    >>> import openturns as ot
    >>> M = ot.IdentityMatrix(2)
    >>> print(M)
    [[ 1 0 ]
     [ 0 1 ]]
    """

    __swig_setmethods__ = {}
    for _s in [CorrelationMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IdentityMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CorrelationMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IdentityMatrix, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.IdentityMatrix_getClassName(self)


    def __repr__(self):
        return _typ.IdentityMatrix___repr__(self)

    def transpose(self):
        """
        Transpose the matrix.

        Returns
        -------
        MT : :class:`~openturns.SquareMatrix`
            The transposed matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> print(M)
        [[ 1 2 ]
         [ 3 4 ]]
        >>> print(M.transpose())
        [[ 1 3 ]
         [ 2 4 ]]
        """
        return _typ.IdentityMatrix_transpose(self)


    def __mul__(self, *args):
        return _typ.IdentityMatrix___mul__(self, *args)

    def solveLinearSystem(self, *args):
        """
        Solve a square linear system whose the present matrix is the operator.

        Parameters
        ----------
        rhs : sequence of float or :class:`~openturns.Matrix` with :math:`n_r` values or rows, respectively
            The right hand side member of the linear system.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        solution : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            The solution of the square linear system.

        Notes
        -----
        This will handle both matrices and vectors. Note that you'd better type
        explicitely the matrix if it has some properties that could simplify the
        resolution (see :class:`~openturns.TriangularMatrix`).

        This uses LAPACK'S `DGESV <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesv.f.html>`_
        for matrices and `DGELSY <http://www.netlib.org/lapack/lapack-3.1.1/html/dgelsy.f.html>`_
        for vectors.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> b = ot.Point([1.0] * 2)
        >>> x = M.solveLinearSystem(b)
        >>> np.testing.assert_array_almost_equal(M * x, b)
        """
        return _typ.IdentityMatrix_solveLinearSystem(self, *args)


    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        """
        Compute the logarithm of the absolute value of the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The logarithm of the absolute value of the square matrix determinant.
        sign : float
            The sign of the determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeLogAbsoluteDeterminant()
        [0.693147..., -1.0]
        """
        return _typ.IdentityMatrix_computeLogAbsoluteDeterminant(self, keepIntact)


    def computeDeterminant(self, keepIntact=True):
        """
        Compute the determinant.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        determinant : float
            The square matrix determinant.

        Examples
        --------
        >>> import openturns as ot
        >>> A = ot.SquareMatrix([[1.0, 2.0], [3.0, 4.0]])
        >>> A.computeDeterminant()
        -2.0
        """
        return _typ.IdentityMatrix_computeDeterminant(self, keepIntact)


    def computeEigenValues(self, keepIntact=True):
        """
        Compute eigen values.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigenvalues : :class:`~openturns.Point`
            Eigen values.

        See Also
        --------
        computeEV

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> print(M.computeEigenValues())
        [-4.70156,1.70156]
        """
        return _typ.IdentityMatrix_computeEigenValues(self, keepIntact)


    def computeEV(self, keepIntact=True):
        """
        Compute the eigen values decomposition (EVD).

        The eigen values decomposition of a square matrix :math:`\\mat{M}` with
        size :math:`n` reads:

        .. math::

            \\mat{M} = \\mat{\\Phi} \\mat{\\Lambda} \\Tr{\\mat{\\Phi}}

        where :math:`\\mat{\\Lambda}` is an :math:`n \\times n` diagonal matrix and
        :math:`\\mat{\\Phi}` is an :math:`n \\times n` orthogonal matrix.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        eigen_values : :class:`~openturns.Point`
            The vector of eigen values with size :math:`n` that form the diagonal of
            the :math:`n \\times n` matrix :math:`\\mat{\\Lambda}` of the EVD.
        Phi : :class:`~openturns.SquareComplexMatrix`
            The left matrix of the EVD.

        Notes
        -----
        This uses LAPACK'S `DSYEV <http://www.netlib.org/lapack/lapack-3.1.1/html/dsyev.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.SymmetricMatrix([[1.0, 2.0], [2.0, -4.0]])
        >>> eigen_values, Phi = M.computeEV()
        >>> Lambda = ot.SquareMatrix(M.getDimension())
        >>> for i in range(eigen_values.getSize()):
        ...     Lambda[i, i] = eigen_values[i]
        >>> np.testing.assert_array_almost_equal(Phi * Lambda * Phi.transpose(), M)
        """
        return _typ.IdentityMatrix_computeEV(self, keepIntact)


    def isPositiveDefinite(self, keepIntact=True):
        """
        Test whether the matrix is positive definite or not.

        A matrix :math:`\\mat{M}` is positive definite if :math:`\\Tr{\\vect{z}} \\mat{M} \\vect{z}`
        is positive for every compatible non-zero column vector :math:`\\vect{z}`.

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        test : bool
            Answer.
        """
        return _typ.IdentityMatrix_isPositiveDefinite(self, keepIntact)


    def computeCholesky(self, keepIntact=True):
        """
        Compute the Cholesky factor.

        The Cholesky factor of a covariance (real symmetric positive definite) matrix
        :math:`\\mat{C}` is the lower triangular matrix :math:`\\mat{L}` such that:

        .. math::

            \\mat{C} = \\mat{L} \\Tr{\\mat{L}}

        Parameters
        ----------
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Notes
        -----
        This uses LAPACK's `DPOTRF <http://www.netlib.org/lapack/lapack-3.1.1/html/dpotrf.f.html>`_.

        Returns
        -------
        cholesky_factor : :class:`~openturns.SquareMatrix`
            The left (lower) Cholesky factor.
        """
        return _typ.IdentityMatrix_computeCholesky(self, keepIntact)


    def computeSingularValues(self, keepIntact=True):
        """
        Compute the singular values.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitely stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \\min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \\times n_c` matrix
            :math:`\\mat{\\Sigma}` of the SVD decomposition.

        See also
        --------
        computeSVD

        Examples
        --------
        >>> import openturns as ot
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> print(M.computeSingularValues(True))
        [9.52552,0.514301]
        """
        return _typ.IdentityMatrix_computeSingularValues(self, keepIntact)


    def computeSVD(self, fullSVD=False, keepIntact=True):
        """
        Compute the singular values decomposition (SVD).

        The singular values decomposition of a rectangular matrix :math:`\\mat{M}` with
        size :math:`n_r > n_c` reads:

        .. math::

            \\mat{M} = \\mat{U} \\mat{\\Sigma} \\Tr{\\mat{V}}

        where :math:`\\mat{U}` is an :math:`n_r \\times n_r` orthogonal matrix,
        :math:`\\mat{\\Sigma}` is an :math:`n_r \\times n_c` diagonal matrix and
        :math:`\\mat{V}` is an :math:`n_c \\times n_c` orthogonal matrix.

        Parameters
        ----------
        fullSVD : bool, optional
            Whether the null parts of the orthogonal factors are explicitely stored
            or not.
            Default is *False* and computes a reduced SVD.
        keep_intact : bool, optional
            A flag telling whether the present matrix can be overwritten or not.
            Default is *True* and leaves the present matrix unchanged.

        Returns
        -------
        singular_values : :class:`~openturns.Point`
            The vector of singular values with size :math:`n = \\min(n_r, n_c)` that
            form the diagonal of the :math:`n_r \\times n_c` matrix
            :math:`\\mat{\\Sigma}` of the SVD.
        U : :class:`~openturns.SquareMatrix`
            The left orthogonal matrix of the SVD.
        VT : :class:`~openturns.SquareMatrix`
            The transposed right orthogonal matrix of the SVD.

        Notes
        -----
        This uses LAPACK's `DGESDD <http://www.netlib.org/lapack/lapack-3.1.1/html/dgesdd.f.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> import numpy as np
        >>> M = ot.Matrix([[1.0, 2.0], [3.0, 4.0], [5.0, 6.0]])
        >>> singular_values, U, VT = M.computeSVD(True)
        >>> Sigma = ot.Matrix(M.getNbRows(), M.getNbColumns())
        >>> for i in range(singular_values.getSize()):
        ...     Sigma[i, i] = singular_values[i]
        >>> np.testing.assert_array_almost_equal(U * Sigma * VT, M)
        """
        return _typ.IdentityMatrix_computeSVD(self, fullSVD, keepIntact)


    def __init__(self, *args):
        this = _typ.new_IdentityMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __setitem__(self, args, val):
        return _typ.IdentityMatrix___setitem__(self, args, val)
    __swig_destroy__ = _typ.delete_IdentityMatrix
    __del__ = lambda self: None
IdentityMatrix_swigregister = _typ.IdentityMatrix_swigregister
IdentityMatrix_swigregister(IdentityMatrix)

class SampleImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SampleImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SampleImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_SampleImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.SampleImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.SampleImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.SampleImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.SampleImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_SampleImplementationTypedInterfaceObject
    __del__ = lambda self: None
SampleImplementationTypedInterfaceObject_swigregister = _typ.SampleImplementationTypedInterfaceObject_swigregister
SampleImplementationTypedInterfaceObject_swigregister(SampleImplementationTypedInterfaceObject)

class SampleCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SampleCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SampleCollection, name)
    __swig_destroy__ = _typ.delete_SampleCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.SampleCollection_clear(self)


    def __len__(self):
        return _typ.SampleCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.SampleCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.SampleCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.SampleCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.SampleCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.SampleCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.SampleCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.SampleCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.SampleCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.SampleCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.SampleCollection_isEmpty(self)


    def __repr__(self):
        return _typ.SampleCollection___repr__(self)

    def __str__(self, *args):
        return _typ.SampleCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_SampleCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SampleCollection_swigregister = _typ.SampleCollection_swigregister
SampleCollection_swigregister(SampleCollection)

OT_TYPECHECK_NUMERICALSAMPLE = _typ.OT_TYPECHECK_NUMERICALSAMPLE
class SampleImplementation(openturns.common.PersistentObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SampleImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SampleImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SampleImplementation_getClassName(self)

    CSV = _typ.SampleImplementation_CSV
    if _newclass:
        BuildFromCSVFile = staticmethod(_typ.SampleImplementation_BuildFromCSVFile)
    else:
        BuildFromCSVFile = _typ.SampleImplementation_BuildFromCSVFile
    if _newclass:
        BuildFromTextFile = staticmethod(_typ.SampleImplementation_BuildFromTextFile)
    else:
        BuildFromTextFile = _typ.SampleImplementation_BuildFromTextFile

    def storeToTemporaryFile(self):
        return _typ.SampleImplementation_storeToTemporaryFile(self)

    def streamToRFormat(self):
        return _typ.SampleImplementation_streamToRFormat(self)

    def __init__(self, *args):
        this = _typ.new_SampleImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __baseaddress__(self):
        return _typ.SampleImplementation___baseaddress__(self)

    def __elementsize__(self):
        return _typ.SampleImplementation___elementsize__(self)

    def setDescription(self, description):
        return _typ.SampleImplementation_setDescription(self, description)

    def getDescription(self):
        return _typ.SampleImplementation_getDescription(self)

    def __repr__(self):
        return _typ.SampleImplementation___repr__(self)

    def __str__(self, *args):
        return _typ.SampleImplementation___str__(self, *args)

    def __eq__(self, rhs):
        return _typ.SampleImplementation___eq__(self, rhs)

    def contains(self, val):
        return _typ.SampleImplementation_contains(self, val)

    def getSize(self):
        return _typ.SampleImplementation_getSize(self)

    def getDimension(self):
        return _typ.SampleImplementation_getDimension(self)

    def add(self, *args):
        return _typ.SampleImplementation_add(self, *args)

    def stack(self, sample):
        return _typ.SampleImplementation_stack(self, sample)

    def computeMean(self):
        return _typ.SampleImplementation_computeMean(self)

    def computeCovariance(self):
        return _typ.SampleImplementation_computeCovariance(self)

    def computeStandardDeviation(self):
        return _typ.SampleImplementation_computeStandardDeviation(self)

    def computeStandardDeviationPerComponent(self):
        return _typ.SampleImplementation_computeStandardDeviationPerComponent(self)

    def computeLinearCorrelation(self):
        return _typ.SampleImplementation_computeLinearCorrelation(self)

    def computePearsonCorrelation(self):
        return _typ.SampleImplementation_computePearsonCorrelation(self)

    def computeSpearmanCorrelation(self):
        return _typ.SampleImplementation_computeSpearmanCorrelation(self)

    def computeKendallTau(self):
        return _typ.SampleImplementation_computeKendallTau(self)

    def computeRange(self):
        return _typ.SampleImplementation_computeRange(self)

    def computeMedian(self):
        return _typ.SampleImplementation_computeMedian(self)

    def computeVariance(self):
        return _typ.SampleImplementation_computeVariance(self)

    def computeSkewness(self):
        return _typ.SampleImplementation_computeSkewness(self)

    def computeKurtosis(self):
        return _typ.SampleImplementation_computeKurtosis(self)

    def computeCenteredMoment(self, k):
        return _typ.SampleImplementation_computeCenteredMoment(self, k)

    def computeRawMoment(self, k):
        return _typ.SampleImplementation_computeRawMoment(self, k)

    def computeQuantilePerComponent(self, prob):
        return _typ.SampleImplementation_computeQuantilePerComponent(self, prob)

    def computeQuantile(self, prob):
        return _typ.SampleImplementation_computeQuantile(self, prob)

    def computeEmpiricalCDF(self, point, tail=False):
        return _typ.SampleImplementation_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        return _typ.SampleImplementation_getMax(self)

    def getMin(self):
        return _typ.SampleImplementation_getMin(self)

    def rank(self, *args):
        return _typ.SampleImplementation_rank(self, *args)

    def sort(self, *args):
        return _typ.SampleImplementation_sort(self, *args)

    def sortAccordingToAComponent(self, index):
        return _typ.SampleImplementation_sortAccordingToAComponent(self, index)

    def sortUnique(self):
        return _typ.SampleImplementation_sortUnique(self)

    def getMarginal(self, *args):
        return _typ.SampleImplementation_getMarginal(self, *args)

    def __iadd__(self, *args):
        return _typ.SampleImplementation___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ.SampleImplementation___isub__(self, *args)

    def __add__(self, *args):
        return _typ.SampleImplementation___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SampleImplementation___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.SampleImplementation___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SampleImplementation___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ.SampleImplementation___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ.SampleImplementation___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def exportToCSVFile(self, *args):
        return _typ.SampleImplementation_exportToCSVFile(self, *args)
    __swig_destroy__ = _typ.delete_SampleImplementation
    __del__ = lambda self: None
SampleImplementation_swigregister = _typ.SampleImplementation_swigregister
SampleImplementation_swigregister(SampleImplementation)

def SampleImplementation_BuildFromCSVFile(*args):
    return _typ.SampleImplementation_BuildFromCSVFile(*args)
SampleImplementation_BuildFromCSVFile = _typ.SampleImplementation_BuildFromCSVFile

def SampleImplementation_BuildFromTextFile(*args):
    return _typ.SampleImplementation_BuildFromTextFile(*args)
SampleImplementation_BuildFromTextFile = _typ.SampleImplementation_BuildFromTextFile


def __eq__(lhs, rhs):
    return _typ.__eq__(lhs, rhs)
__eq__ = _typ.__eq__
class Sample(SampleImplementationTypedInterfaceObject):
    """
    Sample of real vectors.

    Available constructors:
        Sample(*size, dim*)

        Sample(*size, point*)

        Sample(*other, first, last*)

    Parameters
    ----------
    size : int, :math:`m > 0`, optional
        The sample size.
        Default creates an empty sample with dimension 1.
    dimension : int, :math:`n > 0`, optional
        The real vectors dimension.
        Default creates an empty sample with dimension 1.
    point : :class:`~openturns.Point` or flat (1d) array, list or tuple of floats, optional
        The point that will be repeated along the sample.
        Default creates a sample filled with zeros (null vectors).
    other : :class:`~openturns.Sample`
        The sample contains points to copy.
    first : int, :math:`0 \\leq first < m`
        The index of the first point to copy.
    last : int, :math:`first < last \\leq m`, optional
        The index after the last point to copy.

    See Also
    --------
    ImportFromCSVFile, ImportFromTextFile

    Examples
    --------
    Create a Sample

    >>> import openturns as ot
    >>> import numpy as np
    >>> sample = ot.Sample(3, 2)
    >>> print(sample)
    0 : [ 0 0 ]
    1 : [ 0 0 ]
    2 : [ 0 0 ]
    >>> sample = ot.Sample(3, [1.0, 2.0])
    >>> print(sample)
    0 : [ 1 2 ]
    1 : [ 1 2 ]
    2 : [ 1 2 ]

    Create a Sample from a (2d) array, list or tuple

    >>> import numpy as np
    >>> sample = ot.Sample(np.array([(1.0, 2.0), (3.0, 4.0), (5.0, 6.0)]))

    and back

    >>> np.array(sample)
    array([[ 1.,  2.],
           [ 3.,  4.],
           [ 5.,  6.]])

    Eventually samples may also be generated from probability distributions or
    experiments

    >>> random_sample = ot.Normal(2).getSample(10)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 10).generate()

    **Translation:** addition or subtraction of a (compatible) sample or a point, or a scalar which is promoted into a point of compatible dimension with equal components

    >>> print(sample + sample)
    0 : [  2  4 ]
    1 : [  6  8 ]
    2 : [ 10 12 ]
    >>> print(sample - sample)
    0 : [ 0 0 ]
    1 : [ 0 0 ]
    2 : [ 0 0 ]
    >>> print(sample - sample[0])
    0 : [ 0 0 ]
    1 : [ 2 2 ]
    2 : [ 4 4 ]
    >>> print(sample - sample[0, 0])
    0 : [ 0 1 ]
    1 : [ 2 3 ]
    2 : [ 4 5 ]

    **Scaling:** right multiplication or division of a (compatible) square matrix
    with the points in the sample (this can be used e.g. for rotating all the
    points in a sample)

    >>> angle = np.pi / 4.0
    >>> rotation_matrix = ot.SquareMatrix([[np.cos(angle), -np.sin(angle)],
    ...                                    [np.sin(angle),  np.cos(angle)]])
    >>> rotated_sample = sample * rotation_matrix
    >>> np.testing.assert_array_almost_equal(rotated_sample / rotation_matrix, sample)
    """

    __swig_setmethods__ = {}
    for _s in [SampleImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sample, name, value)
    __swig_getmethods__ = {}
    for _s in [SampleImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sample, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.Sample_getClassName(self)


    def ImportFromCSVFile(*args):
        """
        Static method for building a sample from a CSV file.

        Parameters
        ----------
        file_name : str
            Path to CSV file.
        separator : str
            Separating string.
            Default uses `csv-file-separator` from the :class:`~openturns.ResourceMap`.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample loaded from the CSV file.

        Notes
        -----
        The file may or may not contain a header line (columns spanned with strings
        delimited with quotes). If it does contain such a header line, it will be
        used for setting the sample description using :py:meth:`setDescription`.

        See Also
        --------
        exportToCSVFile

        Examples
        --------
        >>> import openturns as ot

        Let's first create a sample CSV file

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.csv')

        And load it back

        >>> loaded_sample = ot.Sample.ImportFromCSVFile('sample.csv')
        >>> assert sample == loaded_sample
        """
        return _typ.Sample_ImportFromCSVFile(*args)

    ImportFromCSVFile = staticmethod(ImportFromCSVFile)

    def ImportFromTextFile(*args):
        """
        Static method for building a sample from a text file.

        Parameters
        ----------
        file_name : str
            Path to text file.
        separator : str
            Separating string.
            Default uses a blank space.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample loaded from the text file.

        Notes
        -----
        The file may or may not contain a header line (columns spanned with strings
        delimited with quotes). If it does contain such a header line, it will be
        used for setting the sample description using :py:meth:`setDescription`.

        See Also
        --------
        exportToCSVFile

        Examples
        --------
        >>> import openturns as ot

        Let's first create a sample text file

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.txt', ' ')

        And load it back

        >>> loaded_sample = ot.Sample.ImportFromTextFile('sample.txt')
        >>> assert sample == loaded_sample
        """
        return _typ.Sample_ImportFromTextFile(*args)

    ImportFromTextFile = staticmethod(ImportFromTextFile)

    def exportToCSVFile(self, *args):
        """
        Dump the sample to a CSV file.

        Parameters
        ----------
        file_name : str
            Path to CSV file.
        separator : str
            Separating string.
            Default uses `csv-file-separator` from the :class:`~openturns.ResourceMap`.

        Notes
        -----
        This will create a header line with componentwise descriptions (obtained from
        :py:meth:`getDescription`) between quotes as column names.

        See Also
        --------
        ImportFromCSVFile, ImportFromTextFile

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> sample.exportToCSVFile('sample.csv', '; ')
        """
        return _typ.Sample_exportToCSVFile(self, *args)


    def __ne__(self, other):
        return _typ.Sample___ne__(self, other)

    def __baseaddress__(self):
        return _typ.Sample___baseaddress__(self)

    def __elementsize__(self):
        return _typ.Sample___elementsize__(self)

    def __contains__(self, val):
        return _typ.Sample___contains__(self, val)

    def erase(self, *args):
        """
        Erase point(s) at or between index(es) (in-place).

        Parameters
        ----------
        f : int, :math:`0 \\leq f < m`
            The index of the first point to erase.
        l : int, :math:`f < l \\leq m`, optional
            The index after the last point to erase.
            Default uses `l = f + 1` and only removes `sample[f]`.
        Returns
        -------
        erased_sample : :class:`~openturns.Sample`
            Erased sample `[sample[:i_start:], sample[i_stop::]]`.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample([[i] for i in range(5)])
        >>> print(sample)
        0 : [ 0 ]
        1 : [ 1 ]
        2 : [ 2 ]
        3 : [ 3 ]
        4 : [ 4 ]
        >>> sample.erase(1, 3)
        >>> print(sample)
        0 : [ 0 ]
        1 : [ 3 ]
        2 : [ 4 ]
        """
        return _typ.Sample_erase(self, *args)


    def clear(self):
        return _typ.Sample_clear(self)

    def __repr__(self):
        return _typ.Sample___repr__(self)

    def __str__(self, *args):
        return _typ.Sample___str__(self, *args)

    def setDescription(self, description):
        """
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the sample's components.

        See Also
        --------
        getDescription
        """
        return _typ.Sample_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the sample's components.

        See Also
        --------
        setDescription
        """
        return _typ.Sample_getDescription(self)


    def getDimension(self):
        """
        Accessor to the sample's dimension.

        Returns
        -------
        n : int
            The number of components of the points in the sample.
        """
        return _typ.Sample_getDimension(self)


    def getSize(self):
        """
        Accessor to the sample size.

        Returns
        -------
        m : int
            The number points in the sample.
        """
        return _typ.Sample_getSize(self)


    def getMax(self):
        """
        Accessor to the componentwise maximum values.

        Returns
        -------
        maximum_values : :class:`~openturns.Point`
            Componentwise maximum values.
        """
        return _typ.Sample_getMax(self)


    def getMin(self):
        """
        Accessor to the componentwise minimum values.

        Returns
        -------
        minimum_values : :class:`~openturns.Point`
            Componentwise minimum values.
        """
        return _typ.Sample_getMin(self)


    def add(self, *args):
        """
        Append a vector (in-place).

        Parameters
        ----------
        point : sequence of float
            The point to append.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample(3, 2)
        >>> sample.add([1.0, 2.0])
        >>> print(sample)
        0 : [ 0 0 ]
        1 : [ 0 0 ]
        2 : [ 0 0 ]
        3 : [ 1 2 ]
        """
        return _typ.Sample_add(self, *args)


    def stack(self, sample):
        """
        Stack (horizontally) the given sample to the current one (in-place).

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Sample to stack with compatible size.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> another_sample = ot.Normal(2).getSample(3)
        >>> print(another_sample)
            [ X0        X1        ]
        0 : [ -0.355007  1.43725  ]
        1 : [  0.810668  0.793156 ]
        2 : [ -0.470526  0.261018 ]
        >>> sample.stack(another_sample)
        >>> print(sample)
            [ X0        X1        X0        X1        ]
        0 : [  0.608202 -1.26617  -0.355007  1.43725  ]
        1 : [ -0.438266  1.20548   0.810668  0.793156 ]
        2 : [ -2.18139   0.350042 -0.470526  0.261018 ]
        """
        return _typ.Sample_stack(self, sample)


    def split(self, index):
        """
        Trunk the sample.

        It splits the sample before the index passed as argument and returns the
        remainder as new sample.

        Parameters
        ----------
        index : int, :math:`0 \\leq i < m`
            The truncation index.

        Returns
        -------
        remainder_sample : :class:`~openturns.Sample`
            The remainder sample (everyting that comes after the truncation index).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> remainder_sample = sample.split(1)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        >>> print(remainder_sample)
            [ X0        X1        ]
        0 : [ -0.438266  1.20548  ]
        1 : [ -2.18139   0.350042 ]
        """
        return _typ.Sample_split(self, index)


    def computeMean(self):
        """
        Estimate the mean vector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean vector estimated from the sample.

        Notes
        -----
        The mean is estimated as follows:

        .. math::

            \\vect{\\widehat{\\mu}} = \\Tr{\\left(\\frac{1}{m}
                                             \\sum_{j=1}^m x_i^{(j)},
                                             \\quad i = 1, \\ldots, n\\right)}

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeMean())
        [-0.0512622,0.136653]
        """
        return _typ.Sample_computeMean(self)


    def computeCovariance(self):
        """
        Estimate the covariance matrix.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance matrix estimated from the sample.

        Notes
        -----
        The covariance matrix is estimated as follows:

        .. math::

            \\mat{\\widehat{\\Sigma}} = \\left[\\frac{1}{m - 1}
                                           \\sum_{k=1}^m
                                           \\left(x_i^{(k)} - \\widehat{\\mu}_i\\right)
                                           \\left(x_j^{(k)} - \\widehat{\\mu}_j\\right),
                                           \\quad i, j = 1, \\ldots, n\\right]

        where :math:`\\vect{\\widehat{\\mu}}` denotes the estimate of the mean.

        This is an unbiased estimator.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeCovariance())
        [[ 0.946682  0.0182104 ]
         [ 0.0182104 0.903226  ]]
        """
        return _typ.Sample_computeCovariance(self)


    def computeStandardDeviation(self):
        """
        Compute the Cholesky factor of the covariance matrix.

        Estimated from the sample.

        Returns
        -------
        L : :class:`~openturns.TriangularMatrix`
            Lower (left) Cholesky factor of the covariance matrix estimated from the
            sample.

        Raises
        ------
        RuntimeError : If the estimated covariance matrix is not positive definite. In
            this case, you might want to estimate the covariance and manually shrink
            negative eigen values.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeStandardDeviation())
        [[ 0.972976  0         ]
         [ 0.0187161 0.950198  ]]
        """
        return _typ.Sample_computeStandardDeviation(self)


    def computeVariance(self):
        """
        Estimate the componentwise variances.

        Returns
        -------
        variances : :class:`~openturns.Point`
            Componentwise variances estimated from the sample.

        Notes
        -----
        The componentwise variances are estimated as follows:

        .. math::

            \\vect{\\widehat{\\sigma^2}} = \\Tr{\\left(\\frac{1}{m-1}
                                                  \\sum_{j=1}^m
                                                  \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^2,
                                                  \\quad i = 1, \\ldots, n\\right)}

        where :math:`\\vect{\\widehat{\\mu}}` is the estimate of the mean.

        This estimator is unbiased.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeVariance())
        [0.946682,0.903226]
        """
        return _typ.Sample_computeVariance(self)


    def computeStandardDeviationPerComponent(self):
        """
        Estimate the componentwise standard deviations.

        Returns
        -------
        standard_deviations : :class:`~openturns.Point`
            Componentwise standard deviation estimated from the sample.

        Notes
        -----
        The componentwise standard deviations are estimated as the square root of the
        componentwise variances.

        See Also
        --------
        computeVariance

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeStandardDeviationPerComponent())
        [0.972976,0.950382]
        """
        return _typ.Sample_computeStandardDeviationPerComponent(self)


    def computeLinearCorrelation(self):
        """**(ditch me?)**"""
        return _typ.Sample_computeLinearCorrelation(self)


    def computePearsonCorrelation(self):
        """
        Estimate the Pearson correlation matrix.

        Returns
        -------
        rho : :class:`~openturns.CorrelationMatrix`
            Pearson correlation matrix estimated from the sample.

        Notes
        -----
        The Pearson correlation matrix is estimated as follows:

        .. math::

            \\mat{\\widehat{\\rho}} = \\left[\\frac{\\widehat{\\Sigma}_{i,j}}
                                              {\\widehat{\\Sigma}_{i,i} \\widehat{\\Sigma}_{j,j}},
                                         \\quad i,j = 1, \\ldots, n\\right]

        where :math:`\\mat{\\widehat{\\Sigma}}` denotes the estimate of the covariance.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computePearsonCorrelation())
        [[ 1         0.0196933 ]
         [ 0.0196933 1         ]]
        """
        return _typ.Sample_computePearsonCorrelation(self)


    def computeSpearmanCorrelation(self):
        """
        Estimate the Spearman correlation matrix.

        Returns
        -------
        rho : :class:`~openturns.CorrelationMatrix`
            Spearman correlation matrix estimated from the sample.

        Notes
        -----
        The Spearman correlation matrix is estimated as the Pearson correlation matrix
        of the ranks sample (i.e. using `self.rank().computePearsonCorrelation()`).

        See Also
        --------
        rank, computePearsonCorrelation

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeSpearmanCorrelation())
        [[  1          -0.00556174 ]
         [ -0.00556174  1          ]]
        """
        return _typ.Sample_computeSpearmanCorrelation(self)


    def computeKendallTau(self):
        """
        Estimate the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix estimated from the sample.

        Notes
        -----
        This uses an external implementation provided under the Boost Software License
        by David Simcha based on the paper by [Knight1966]_. It actually switches
        between two implementations depending on the sample size:

            - The most basic implementation performing in :math:`O(m^2)` is used when
              the sample size is less than `SampleImplementation-SmallKendallTau`
              from the :class:`~openturns.ResourceMap`.
            - The other more complex implementation performing in :math:`O(m\\log(m))`
              is used for larger samples.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeKendallTau())
        [[ 1          0.00689655 ]
         [ 0.00689655 1          ]]
        """
        return _typ.Sample_computeKendallTau(self)


    def computeRange(self):
        """
        Compute the range per component.

        Returns
        -------
        range : :class:`~openturns.Point`
            Componentwise ranges estimated from the sample.

        Notes
        -----
        The *statistical range* is defined as the deviation between the maximal and
        the minimal value of the sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeRange())
        [4.02827,3.49949]
        """
        return _typ.Sample_computeRange(self)


    def computeMedian(self):
        """
        Estimate the componentwise medians (50%-quantiles).

        Returns
        -------
        median : :class:`~openturns.Point`
            Median vector estimated from the sample.

        See Also
        --------
        computeQuantilePerComponent

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeMedian())
        [0.221141,0.108703]
        """
        return _typ.Sample_computeMedian(self)


    def computeSkewness(self):
        """
        Estimate the componentwise skewness (3rd order centered normalized moment).

        Returns
        -------
        skewness : :class:`~openturns.Point`
            Componentwise skewness estimated from the sample.

        Notes
        -----
        The componentwise skewnesses are estimated as follows:

        .. math::

            \\vect{\\widehat{\\delta}} = \\Tr{\\left(m \\frac{\\sqrt{m-1}}{m-2}
                                                \\frac{\\sum_{j=1}^m
                                                      \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^3}
                                                     {\\left(\\sum_{j=1}^m
                                                            \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^2
                                                      \\right)^{3/2}},
                                                \\quad i = 1, \\ldots, n\\right)}

        where :math:`\\vect{\\widehat{\\mu}}` is the estimate of the mean.

        This is an unbiased estimator.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeSkewness())
        [-0.69393,0.231931]
        """
        return _typ.Sample_computeSkewness(self)


    def computeKurtosis(self):
        """
        Estimate the componentwise kurtosis (4th order centered normalized moment).

        Returns
        -------
        kurtosis : :class:`~openturns.Point`
            Componentwise kurtosis estimated from the sample.

        Notes
        -----
        The componentwise kurtosis are estimated as follows:

        .. math::

            \\vect{\\widehat{\\kappa}} = \\Tr{\\left(\\frac{m (m-1) (m+1)}{(m-2) (m-3)}
                                                \\frac{\\sum_{j=1}^m
                                                      \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^4}
                                                     {\\left(\\sum_{j=1}^m
                                                            \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^2
                                                      \\right)^2}
                                                - 3 \\frac{3 (m-5)}{(m-2) (m-3)},
                                                \\quad i = 1, \\ldots, n\\right)}

        where :math:`\\vect{\\widehat{\\mu}}` is the estimate of the mean.

        This estimator is unbiased.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeKurtosis())
        [3.27647,2.40275]
        """
        return _typ.Sample_computeKurtosis(self)


    def computeCenteredMoment(self, k):
        """
        Estimate componentwise centered moments.

        Parameters
        ----------
        k : int
            The centered moment's order.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise centered moment of order :math:`k` estimated from the sample.

        Notes
        -----
        The centered moment of order :math:`k` is estimated as follows:

        .. math::

            \\vect{\\widehat{m}}^{(k)}_0 = \\Tr{\\left(\\frac{1}{m}
                                                   \\sum_{j=1}^m
                                                   \\left(x_i^{(j)} - \\widehat{\\mu}_i\\right)^k,
                                                   \\quad i = 1, \\ldots, n\\right)}

        where :math:`\\vect{\\widehat{\\mu}}` is the estimator of the mean.

        These estimators are the natural (possibly biased) estimators.
        For unbiased estimators use the other dedicated methods such as
        :py:meth:`computeVariance` for the variance.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeCenteredMoment(2))
        [0.915126,0.873119]
        """
        return _typ.Sample_computeCenteredMoment(self, k)


    def computeRawMoment(self, k):
        """
        Compute the raw (non-centered) moment per component.

        Parameters
        ----------
        k : int, :math:`k \\geq 0`
            Componentwise moment's order.

        Returns
        -------
        moments : :class:`~openturns.Point`
            Componentwise moments estimated from the sample.

        Notes
        -----
        The (raw) moment of order :math:`k` is estimated as follows:

        .. math::

            \\vect{\\widehat{m}}^{(k)} = \\Tr{\\left(\\frac{1}{m}
                                                 \\sum_{j=1}^m {x_i^{(j)}}^k,
                                                 \\quad i = 1, \\ldots, n\\right)}

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeRawMoment(2))
        [0.917754,0.891793]
        """
        return _typ.Sample_computeRawMoment(self, k)


    def computeQuantilePerComponent(self, prob):
        """
        Estimate the componentwise quantiles.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            Input probability level.

        Returns
        -------
        quantile : :class:`~openturns.Point`
            Componentwise quantile at probability level :math:`p`, estimated from the
            sample.

        Notes
        -----
        The present implementation interpolates the quantile between the two adjacent
        empirical quantiles (:math:`\\widehat{x}_i^-` and :math:`\\widehat{x}_i^+`):

        .. math::

            \\widehat{q}_i = \\alpha \\widehat{x}_i^- + (1 - \\alpha) \\widehat{x}_i^+

        where :math:`\\alpha = p m - 0.5`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeQuantilePerComponent(0.2))
        [-0.696412,-0.767092]
        """
        return _typ.Sample_computeQuantilePerComponent(self, prob)


    def computeQuantile(self, prob):
        """
        Estimate the quantile of the **joint** distribution underlying the sample.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            Input probability level.

        Returns
        -------
        quantile : :class:`~openturns.Point`
            Quantile of the joint distribution at probability level :math:`p`,
            estimated from the sample.

        Raises
        ------
        NotImplementedYetError : If the dimension is greater than 1.

        See Also
        --------
        computeQuantilePerComponent

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(1).getSample(30)
        >>> print(sample.computeQuantile(.2))
        [-0.947394]
        """
        return _typ.Sample_computeQuantile(self, prob)


    def computeEmpiricalCDF(self, point, tail=False):
        """
        Estimate the empirical cumulative distribution function (ECDF).

        Parameters
        ----------
        x : sequence of float
            CDF input.
        survival : bool, optional
            A flag telling whether this should estimate the empirical cumulative
            distribution function or the empirical survival function.
            Default is `False` and estimates the CDF.

        Returns
        -------
        p : float, :math:`0 \\leq p \\leq 1`
            Empirical CDF or SF value at point x.

        Notes
        -----
        The empirical cumulative distribution function (CDF) is estimated as follows:

        .. math::

            \\hat{F}(\\vect{x}) = \\frac{1}{m} \\sum_{j=1}^m
                                \\mathbf{1}_{\\cap_{i=1}^n x_i^{(j)} \\leq x_i}(\\vect{x})

        The empirical survival function (SF) is estimated in a similar way:

        .. math::

            \\hat{S}(\\vect{x}) = \\frac{1}{m} \\sum_{j=1}^m
                                \\mathbf{1}_{\\cap_{i=1}^n x_i^{(j)} > x_i}(\\vect{x})

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.computeEmpiricalCDF(sample[0]))
        0.1
        """
        return _typ.Sample_computeEmpiricalCDF(self, point, tail)


    def find(self, point):
        """
        Get the position of a point in the sample.

        Parameters
        ----------
        point : sequence of float
            The wanted point.

        Returns
        -------
        index : int,
            Returns :math:`m` if the point does not belong to the sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(30)
        >>> print(sample.find(sample[10]))
        10
        >>> print(sample.find([0.0, 0.0]))
        30
        """
        return _typ.Sample_find(self, point)


    def __iadd__(self, *args):
        return _typ.Sample___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ.Sample___isub__(self, *args)

    def __add__(self, *args):
        return _typ.Sample___add__(self, *args)

    def __sub__(self, *args):
        return _typ.Sample___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.Sample___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.Sample___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ.Sample___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ.Sample___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def rank(self, *args):
        """
        Compute the sample (componentwise) ranks.

        Parameters
        ----------
        marginal_index : int, :math:`0 \\leq i < n`, optional
            The component whose ranks are wanted.
            Default computes the ranks of all the components.

        Notes
        -----
        The ranks of a 1d sample is a list of indices that sorts the points in the
        ascending order. Ties (equal points) are averaged.

        Returns
        -------
        ranks : :class:`~openturns.Sample`
            The requested ranks.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.rank())
            [ X0 X1 ]
        0 : [ 2  0  ]
        1 : [ 1  2  ]
        2 : [ 0  1  ]
        """
        return _typ.Sample_rank(self, *args)


    def sort(self, *args):
        """
        Sort the sample.

        Parameters
        ----------
        marginal_index : int, :math:`0 \\leq i < n`, optional
            The component to sort.
            Default sorts the whole sample.

        Returns
        -------
        sorted_sample : :class:`~openturns.Sample`
            The requested sorted sample.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.sort())
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        """
        return _typ.Sample_sort(self, *args)


    def sortAccordingToAComponent(self, index):
        """
        Sort the sample according to the given component.

        Parameters
        ----------
        marginal_index : int, :math:`0 \\leq i < n`
            The component to use for sorting the sample.

        Returns
        -------
        sorted_sample : :class:`~openturns.Sample`
            The sample sorted according to the given component.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(2).getSample(3)
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        >>> print(sample.sortAccordingToAComponent(0))
            [ X0        X1        ]
        0 : [ -2.18139   0.350042 ]
        1 : [ -0.438266  1.20548  ]
        2 : [  0.608202 -1.26617  ]
        """
        return _typ.Sample_sortAccordingToAComponent(self, index)


    def sortUnique(self):
        """
        Sort the sample and remove duplicate points.

        Returns
        -------
        unique_sample : :class:`~openturns.Sample`
            The requested sorted sample with duplicate points removed.

        Examples
        --------
        >>> import openturns as ot
        >>> sample = ot.Sample([[3, 0, 3], [1, 1, 0], [0, 2, 2], [1, 1, 0]])
        >>> print(sample)
        0 : [ 3 0 3 ]
        1 : [ 1 1 0 ]
        2 : [ 0 2 2 ]
        3 : [ 1 1 0 ]
        >>> print(sample.sortUnique())
        0 : [ 0 2 2 ]
        1 : [ 1 1 0 ]
        2 : [ 3 0 3 ]
        """
        return _typ.Sample_sortUnique(self)


    def getMarginal(self, *args):
        """
        Accessor to sample marginal(s) (column(s)).

        Parameters
        ----------
        indices : int or sequence of int, :math:`0 \\leq i < n`
            The index(es) of the wanted marginal(s).

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A subsample of the present sample with the requested marginal(s).

        Notes
        -----
        The :class:`~openturns.Sample` also implements slicing in its
        `__getitem__` method.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(10).getSample(3)
        >>> print(sample.getMarginal([1, 4]))
            [ X1        X4        ]
        0 : [ -1.26617  -2.18139  ]
        1 : [  0.261018 -1.31178  ]
        2 : [  0.445785  0.473617 ]
        """
        return _typ.Sample_getMarginal(self, *args)


    def __len__(self):
        return _typ.Sample___len__(self)

    def __getitem__(self, *args):
        return _typ.Sample___getitem__(self, *args)

    def __setitem__(self, *args):
        return _typ.Sample___setitem__(self, *args)

    def __init__(self, *args):
        this = _typ.new_Sample(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __eq__(self, *args):
        return _typ.Sample___eq__(self, *args)
    __swig_destroy__ = _typ.delete_Sample
    __del__ = lambda self: None
Sample_swigregister = _typ.Sample_swigregister
Sample_swigregister(Sample)

def Sample_ImportFromCSVFile(*args):
    """
    Static method for building a sample from a CSV file.

    Parameters
    ----------
    file_name : str
        Path to CSV file.
    separator : str
        Separating string.
        Default uses `csv-file-separator` from the :class:`~openturns.ResourceMap`.

    Returns
    -------
    sample : :class:`~openturns.Sample`
        Sample loaded from the CSV file.

    Notes
    -----
    The file may or may not contain a header line (columns spanned with strings
    delimited with quotes). If it does contain such a header line, it will be
    used for setting the sample description using :py:meth:`setDescription`.

    See Also
    --------
    exportToCSVFile

    Examples
    --------
    >>> import openturns as ot

    Let's first create a sample CSV file

    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal(2).getSample(30)
    >>> sample.exportToCSVFile('sample.csv')

    And load it back

    >>> loaded_sample = ot.Sample.ImportFromCSVFile('sample.csv')
    >>> assert sample == loaded_sample
    """
    return _typ.Sample_ImportFromCSVFile(*args)

def Sample_ImportFromTextFile(*args):
    """
    Static method for building a sample from a text file.

    Parameters
    ----------
    file_name : str
        Path to text file.
    separator : str
        Separating string.
        Default uses a blank space.

    Returns
    -------
    sample : :class:`~openturns.Sample`
        Sample loaded from the text file.

    Notes
    -----
    The file may or may not contain a header line (columns spanned with strings
    delimited with quotes). If it does contain such a header line, it will be
    used for setting the sample description using :py:meth:`setDescription`.

    See Also
    --------
    exportToCSVFile

    Examples
    --------
    >>> import openturns as ot

    Let's first create a sample text file

    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal(2).getSample(30)
    >>> sample.exportToCSVFile('sample.txt', ' ')

    And load it back

    >>> loaded_sample = ot.Sample.ImportFromTextFile('sample.txt')
    >>> assert sample == loaded_sample
    """
    return _typ.Sample_ImportFromTextFile(*args)


# This code has been added to conform to Numpy ndarray interface
# that tries to reuse the data stored in the Sample (zero copy)
# see http://docs.scipy.org/doc/numpy/reference/arrays.interface.html#arrays-interface
# for details.
# See python doc http://docs.python.org/reference/datamodel.html?highlight=getattribute#object.__getattribute__
# for details on how to write such a method.
def Sample___getattribute__(self, name):
    """Implement attribute accesses."""
    if name == '__array_interface__':
        self.__dict__['__array_interface__'] = {'shape': (self.getSize(), self.getDimension()),
                                                'typestr': "|f" + str(self.__elementsize__()),
                                                'data': (int(self.__baseaddress__()), True),
                                                'version': 3, 
                                                }
    return super(Sample, self).__getattribute__(name)
Sample.__getattribute__ = Sample___getattribute__


def Sample__repr_html_(self):
    """Get HTML representation."""
    html = '<TABLE>'
    desc = self.getDescription()
    if not desc.isBlank():
        html += '<TR>'
        html += '<TD></TD>'
        for j in range(self.getDimension()):
            html += '<TH>' + desc[j] + '</TH>'
        html += '</TR>'
    for i in range(self.getSize()):
        html += '<TR>'
        html += '<TH>' + str(i) + '</TH>'
        for j in range(self.getDimension()):
            html += '<TD>' + str(self[i, j]) + '</TD>'
        html += '</TR>'
    html += '</TABLE>'
    return html

Sample._repr_html_ = Sample__repr_html_


# deprecated
class NumericalSample(Sample):
    def __init__(self, *args):
        super(NumericalSample, self).__init__(*args)
        openturns.common.Log.Warn('class NumericalSample is deprecated in favor of Sample')

class HistoryStrategyImplementation(openturns.common.PersistentObject):
    """
    History storage strategy.

    Available constructors:
        HistoryStrategy()

        HistoryStrategy(*historyStrategyImp*)

    Parameters
    ----------
    historyStrategyImp : HistoryStrategyImplementation
        An implementation of a history strategy which is provided by
        :class:`~openturns.Compact`, :class:`~openturns.Full`,
        :class:`~openturns.Last` or :class:`~openturns.Null` class.

    See also
    --------
    Compact, Full, Last, Null

    Notes
    -----
    In order to prevent a memory problem, the User has the possibility to choose the 
    storage strategy used to save the numerical samples. Four strategies are proposed :

    - the :class:`~openturns.Null` strategy where nothing is stored. This class
      does not require to specify arguments.
    - the :class:`~openturns.Full` strategy where every point is stored. Be careful!
      The memory will be exhausted for huge samples. This class does not require to
      specify arguments.
    - the :class:`~openturns.Last` strategy where only the :math:`N` last points are
      stored, where :math:`N` is specified by the User. This class requires to
      specify the number of points to store.
    - the :class:`~openturns.Compact` strategy where a regularly spaced sub-sample
      is stored. The minimum size :math:`N` of the stored numerical sample is
      specified by the User. OpenTURNS proceeds as follows :

      1. it stores the first :math:`2N` simulations : the size of the stored
         sample is :math:`2N`,
      2. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N` (this is the *compact* step),
      3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
         next simulations : the size of the stored sample is :math:`2N`,
      4. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N`,
      5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
         next simulations : the size of the stored sample is :math:`2N`,
      6. then it keeps on until reaching the stopping criteria.

      The stored numerical sample will have a size within :math:`N` and :math:`2N`.
      This class requires to specify the number of points to store.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistoryStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistoryStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HistoryStrategyImplementation_getClassName(self)


    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _typ.HistoryStrategyImplementation_store(self, *args)


    def clear(self):
        """
        Clear the stored points.

        Notes
        -----
        It erases the previously stored points
        """
        return _typ.HistoryStrategyImplementation_clear(self)


    def getSample(self):
        """
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.HistoryStrategyImplementation_getSample(self)


    def __repr__(self):
        return _typ.HistoryStrategyImplementation___repr__(self)

    def __init__(self, *args):
        this = _typ.new_HistoryStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_HistoryStrategyImplementation
    __del__ = lambda self: None
HistoryStrategyImplementation_swigregister = _typ.HistoryStrategyImplementation_swigregister
HistoryStrategyImplementation_swigregister(HistoryStrategyImplementation)

class HistoryStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistoryStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistoryStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _typ.new_HistoryStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _typ.HistoryStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.HistoryStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.HistoryStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _typ.HistoryStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _typ.delete_HistoryStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
HistoryStrategyImplementationTypedInterfaceObject_swigregister = _typ.HistoryStrategyImplementationTypedInterfaceObject_swigregister
HistoryStrategyImplementationTypedInterfaceObject_swigregister(HistoryStrategyImplementationTypedInterfaceObject)

class HistoryStrategy(HistoryStrategyImplementationTypedInterfaceObject):
    """
    History storage strategy.

    Available constructors:
        HistoryStrategy()

        HistoryStrategy(*historyStrategyImp*)

    Parameters
    ----------
    historyStrategyImp : HistoryStrategyImplementation
        An implementation of a history strategy which is provided by
        :class:`~openturns.Compact`, :class:`~openturns.Full`,
        :class:`~openturns.Last` or :class:`~openturns.Null` class.

    See also
    --------
    Compact, Full, Last, Null

    Notes
    -----
    In order to prevent a memory problem, the User has the possibility to choose the 
    storage strategy used to save the numerical samples. Four strategies are proposed :

    - the :class:`~openturns.Null` strategy where nothing is stored. This class
      does not require to specify arguments.
    - the :class:`~openturns.Full` strategy where every point is stored. Be careful!
      The memory will be exhausted for huge samples. This class does not require to
      specify arguments.
    - the :class:`~openturns.Last` strategy where only the :math:`N` last points are
      stored, where :math:`N` is specified by the User. This class requires to
      specify the number of points to store.
    - the :class:`~openturns.Compact` strategy where a regularly spaced sub-sample
      is stored. The minimum size :math:`N` of the stored numerical sample is
      specified by the User. OpenTURNS proceeds as follows :

      1. it stores the first :math:`2N` simulations : the size of the stored
         sample is :math:`2N`,
      2. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N` (this is the *compact* step),
      3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
         next simulations : the size of the stored sample is :math:`2N`,
      4. it selects only 1 out of 2 of the stored simulations : then the size of
         the stored sample decreases to :math:`N`,
      5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
         next simulations : the size of the stored sample is :math:`2N`,
      6. then it keeps on until reaching the stopping criteria.

      The stored numerical sample will have a size within :math:`N` and :math:`2N`.
      This class requires to specify the number of points to store.
    """

    __swig_setmethods__ = {}
    for _s in [HistoryStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistoryStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [HistoryStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistoryStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.HistoryStrategy_getClassName(self)


    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _typ.HistoryStrategy_store(self, *args)


    def clear(self):
        """
        Clear the stored points.

        Notes
        -----
        It erases the previously stored points
        """
        return _typ.HistoryStrategy_clear(self)


    def getSample(self):
        """
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.HistoryStrategy_getSample(self)


    def __repr__(self):
        return _typ.HistoryStrategy___repr__(self)

    def __init__(self, *args):
        this = _typ.new_HistoryStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_HistoryStrategy
    __del__ = lambda self: None
HistoryStrategy_swigregister = _typ.HistoryStrategy_swigregister
HistoryStrategy_swigregister(HistoryStrategy)

class SampleImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SampleImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SampleImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _typ.SampleImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.SampleImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.SampleImplementationPointer_ptr__get, _typ.SampleImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_SampleImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_SampleImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.SampleImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ.SampleImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.SampleImplementationPointer___deref__(self)

    def isNull(self):
        return _typ.SampleImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ.SampleImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.SampleImplementationPointer_get(self)

    def getImplementation(self):
        return _typ.SampleImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ.SampleImplementationPointer_unique(self)

    def use_count(self):
        return _typ.SampleImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ.SampleImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.SampleImplementationPointer_getClassName(self)


    def BuildFromCSVFile(self, *args):
        return _typ.SampleImplementationPointer_BuildFromCSVFile(self, *args)

    def BuildFromTextFile(self, *args):
        return _typ.SampleImplementationPointer_BuildFromTextFile(self, *args)

    def storeToTemporaryFile(self):
        return _typ.SampleImplementationPointer_storeToTemporaryFile(self)

    def streamToRFormat(self):
        return _typ.SampleImplementationPointer_streamToRFormat(self)

    def __baseaddress__(self):
        return _typ.SampleImplementationPointer___baseaddress__(self)

    def __elementsize__(self):
        return _typ.SampleImplementationPointer___elementsize__(self)

    def setDescription(self, description):
        return _typ.SampleImplementationPointer_setDescription(self, description)

    def getDescription(self):
        return _typ.SampleImplementationPointer_getDescription(self)

    def __repr__(self):
        return _typ.SampleImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ.SampleImplementationPointer___str__(self, *args)

    def __eq__(self, rhs):
        return _typ.SampleImplementationPointer___eq__(self, rhs)

    def contains(self, val):
        return _typ.SampleImplementationPointer_contains(self, val)

    def getSize(self):
        return _typ.SampleImplementationPointer_getSize(self)

    def getDimension(self):
        return _typ.SampleImplementationPointer_getDimension(self)

    def add(self, *args):
        return _typ.SampleImplementationPointer_add(self, *args)

    def stack(self, sample):
        return _typ.SampleImplementationPointer_stack(self, sample)

    def computeMean(self):
        return _typ.SampleImplementationPointer_computeMean(self)

    def computeCovariance(self):
        return _typ.SampleImplementationPointer_computeCovariance(self)

    def computeStandardDeviation(self):
        return _typ.SampleImplementationPointer_computeStandardDeviation(self)

    def computeStandardDeviationPerComponent(self):
        return _typ.SampleImplementationPointer_computeStandardDeviationPerComponent(self)

    def computeLinearCorrelation(self):
        return _typ.SampleImplementationPointer_computeLinearCorrelation(self)

    def computePearsonCorrelation(self):
        return _typ.SampleImplementationPointer_computePearsonCorrelation(self)

    def computeSpearmanCorrelation(self):
        return _typ.SampleImplementationPointer_computeSpearmanCorrelation(self)

    def computeKendallTau(self):
        return _typ.SampleImplementationPointer_computeKendallTau(self)

    def computeRange(self):
        return _typ.SampleImplementationPointer_computeRange(self)

    def computeMedian(self):
        return _typ.SampleImplementationPointer_computeMedian(self)

    def computeVariance(self):
        return _typ.SampleImplementationPointer_computeVariance(self)

    def computeSkewness(self):
        return _typ.SampleImplementationPointer_computeSkewness(self)

    def computeKurtosis(self):
        return _typ.SampleImplementationPointer_computeKurtosis(self)

    def computeCenteredMoment(self, k):
        return _typ.SampleImplementationPointer_computeCenteredMoment(self, k)

    def computeRawMoment(self, k):
        return _typ.SampleImplementationPointer_computeRawMoment(self, k)

    def computeQuantilePerComponent(self, prob):
        return _typ.SampleImplementationPointer_computeQuantilePerComponent(self, prob)

    def computeQuantile(self, prob):
        return _typ.SampleImplementationPointer_computeQuantile(self, prob)

    def computeEmpiricalCDF(self, point, tail=False):
        return _typ.SampleImplementationPointer_computeEmpiricalCDF(self, point, tail)

    def getMax(self):
        return _typ.SampleImplementationPointer_getMax(self)

    def getMin(self):
        return _typ.SampleImplementationPointer_getMin(self)

    def rank(self, *args):
        return _typ.SampleImplementationPointer_rank(self, *args)

    def sort(self, *args):
        return _typ.SampleImplementationPointer_sort(self, *args)

    def sortAccordingToAComponent(self, index):
        return _typ.SampleImplementationPointer_sortAccordingToAComponent(self, index)

    def sortUnique(self):
        return _typ.SampleImplementationPointer_sortUnique(self)

    def getMarginal(self, *args):
        return _typ.SampleImplementationPointer_getMarginal(self, *args)

    def __iadd__(self, *args):
        return _typ.SampleImplementationPointer___iadd__(self, *args)

    def __isub__(self, *args):
        return _typ.SampleImplementationPointer___isub__(self, *args)

    def __add__(self, *args):
        return _typ.SampleImplementationPointer___add__(self, *args)

    def __sub__(self, *args):
        return _typ.SampleImplementationPointer___sub__(self, *args)

    def __mul__(self, *args):
        return _typ.SampleImplementationPointer___mul__(self, *args)

    def __truediv__(self, *args):
        return _typ.SampleImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def __imul__(self, *args):
        return _typ.SampleImplementationPointer___imul__(self, *args)

    def __itruediv__(self, *args):
        return _typ.SampleImplementationPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def exportToCSVFile(self, *args):
        return _typ.SampleImplementationPointer_exportToCSVFile(self, *args)

    def __ne__(self, other):
        return _typ.SampleImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.SampleImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.SampleImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.SampleImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.SampleImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.SampleImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.SampleImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.SampleImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.SampleImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.SampleImplementationPointer_setName(self, name)

SampleImplementationPointer_swigregister = _typ.SampleImplementationPointer_swigregister
SampleImplementationPointer_swigregister(SampleImplementationPointer)

class MatrixImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatrixImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MatrixImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _typ.MatrixImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.MatrixImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.MatrixImplementationPointer_ptr__get, _typ.MatrixImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_MatrixImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_MatrixImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.MatrixImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ.MatrixImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.MatrixImplementationPointer___deref__(self)

    def isNull(self):
        return _typ.MatrixImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ.MatrixImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.MatrixImplementationPointer_get(self)

    def getImplementation(self):
        return _typ.MatrixImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ.MatrixImplementationPointer_unique(self)

    def use_count(self):
        return _typ.MatrixImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ.MatrixImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.MatrixImplementationPointer_getClassName(self)


    def __repr__(self):
        return _typ.MatrixImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ.MatrixImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _typ.MatrixImplementationPointer___call__(self, *args)

    def getNbRows(self):
        return _typ.MatrixImplementationPointer_getNbRows(self)

    def getNbColumns(self):
        return _typ.MatrixImplementationPointer_getNbColumns(self)

    def getDimension(self):
        return _typ.MatrixImplementationPointer_getDimension(self)

    def transpose(self):
        return _typ.MatrixImplementationPointer_transpose(self)

    def getRow(self, rowIndex):
        return _typ.MatrixImplementationPointer_getRow(self, rowIndex)

    def getRowSym(self, rowIndex):
        return _typ.MatrixImplementationPointer_getRowSym(self, rowIndex)

    def getColumn(self, columnIndex):
        return _typ.MatrixImplementationPointer_getColumn(self, columnIndex)

    def getColumnSym(self, columnIndex):
        return _typ.MatrixImplementationPointer_getColumnSym(self, columnIndex)

    def __add__(self, matrix):
        return _typ.MatrixImplementationPointer___add__(self, matrix)

    def __iadd__(self, matrix):
        return _typ.MatrixImplementationPointer___iadd__(self, matrix)

    def __sub__(self, matrix):
        return _typ.MatrixImplementationPointer___sub__(self, matrix)

    def __isub__(self, matrix):
        return _typ.MatrixImplementationPointer___isub__(self, matrix)

    def genProd(self, matrix, transposeLeft=False, transposeRight=False):
        return _typ.MatrixImplementationPointer_genProd(self, matrix, transposeLeft, transposeRight)

    def symProd(self, m, symSide):
        return _typ.MatrixImplementationPointer_symProd(self, m, symSide)

    def genPower(self, n):
        return _typ.MatrixImplementationPointer_genPower(self, n)

    def symPower(self, n):
        return _typ.MatrixImplementationPointer_symPower(self, n)

    def genVectProd(self, pt, transpose=False):
        return _typ.MatrixImplementationPointer_genVectProd(self, pt, transpose)

    def symVectProd(self, pt):
        return _typ.MatrixImplementationPointer_symVectProd(self, pt)

    def triangularVectProd(self, *args):
        return _typ.MatrixImplementationPointer_triangularVectProd(self, *args)

    def __mul__(self, s):
        return _typ.MatrixImplementationPointer___mul__(self, s)

    def __imul__(self, s):
        return _typ.MatrixImplementationPointer___imul__(self, s)

    def __truediv__(self, *args):
        return _typ.MatrixImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv__(self, *args):
        return _typ.MatrixImplementationPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def symmetrize(self):
        return _typ.MatrixImplementationPointer_symmetrize(self)

    def triangularize(self, isLowerTriangular):
        return _typ.MatrixImplementationPointer_triangularize(self, isLowerTriangular)

    def solveLinearSystemRect(self, *args):
        return _typ.MatrixImplementationPointer_solveLinearSystemRect(self, *args)

    def solveLinearSystemSquare(self, *args):
        return _typ.MatrixImplementationPointer_solveLinearSystemSquare(self, *args)

    def solveLinearSystemTri(self, *args):
        return _typ.MatrixImplementationPointer_solveLinearSystemTri(self, *args)

    def solveLinearSystemSym(self, *args):
        return _typ.MatrixImplementationPointer_solveLinearSystemSym(self, *args)

    def solveLinearSystemCov(self, *args):
        return _typ.MatrixImplementationPointer_solveLinearSystemCov(self, *args)

    def triangularProd(self, *args):
        return _typ.MatrixImplementationPointer_triangularProd(self, *args)

    def computeLogAbsoluteDeterminant(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeLogAbsoluteDeterminant(self, keepIntact)

    def computeDeterminant(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeDeterminant(self, keepIntact)

    def computeLogAbsoluteDeterminantSym(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeLogAbsoluteDeterminantSym(self, keepIntact)

    def computeDeterminantSym(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeDeterminantSym(self, keepIntact)

    def computeTrace(self):
        return _typ.MatrixImplementationPointer_computeTrace(self)

    def computeEigenValuesSquare(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeEigenValuesSquare(self, keepIntact)

    def computeEVSquare(self, v, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeEVSquare(self, v, keepIntact)

    def computeEigenValuesSym(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeEigenValuesSym(self, keepIntact)

    def computeEVSym(self, v, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeEVSym(self, v, keepIntact)

    def computeSingularValues(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeSingularValues(self, keepIntact)

    def computeSVD(self, fullSVD=False, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeSVD(self, fullSVD, keepIntact)

    def isSymmetric(self):
        return _typ.MatrixImplementationPointer_isSymmetric(self)

    def isPositiveDefinite(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_isPositiveDefinite(self, keepIntact)

    def hasUnitRange(self):
        return _typ.MatrixImplementationPointer_hasUnitRange(self)

    def clean(self, threshold):
        return _typ.MatrixImplementationPointer_clean(self, threshold)

    def cleanSym(self, threshold):
        return _typ.MatrixImplementationPointer_cleanSym(self, threshold)

    def computeCholesky(self, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeCholesky(self, keepIntact)

    def CholeskyUpdate(self, cholesky, vector):
        return _typ.MatrixImplementationPointer_CholeskyUpdate(self, cholesky, vector)

    def CholeskyDowndate(self, cholesky, vector):
        return _typ.MatrixImplementationPointer_CholeskyDowndate(self, cholesky, vector)

    def computeQR(self, fullQR=False, keepIntact=True):
        return _typ.MatrixImplementationPointer_computeQR(self, fullQR, keepIntact)

    def computeGram(self, transpose=True):
        return _typ.MatrixImplementationPointer_computeGram(self, transpose)

    def __eq__(self, rhs):
        return _typ.MatrixImplementationPointer___eq__(self, rhs)

    def __ne__(self, rhs):
        return _typ.MatrixImplementationPointer___ne__(self, rhs)

    def isEmpty(self):
        return _typ.MatrixImplementationPointer_isEmpty(self)

    def isTriangular(self, lower=True):
        return _typ.MatrixImplementationPointer_isTriangular(self, lower)

    def __baseaddress__(self):
        return _typ.MatrixImplementationPointer___baseaddress__(self)

    def __elementsize__(self):
        return _typ.MatrixImplementationPointer___elementsize__(self)

    def __stride__(self, dim):
        return _typ.MatrixImplementationPointer___stride__(self, dim)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.MatrixImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.MatrixImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.MatrixImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.MatrixImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.MatrixImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.MatrixImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.MatrixImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.MatrixImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.MatrixImplementationPointer_setName(self, name)


    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.MatrixImplementationPointer_clear(self)


    def __len__(self):
        return _typ.MatrixImplementationPointer___len__(self)

    def __contains__(self, val):
        return _typ.MatrixImplementationPointer___contains__(self, val)

    def __getitem__(self, i):
        return _typ.MatrixImplementationPointer___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.MatrixImplementationPointer___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.MatrixImplementationPointer___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.MatrixImplementationPointer_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.MatrixImplementationPointer_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.MatrixImplementationPointer_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.MatrixImplementationPointer_resize(self, newSize)

MatrixImplementationPointer_swigregister = _typ.MatrixImplementationPointer_swigregister
MatrixImplementationPointer_swigregister(MatrixImplementationPointer)

class PointPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PointPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PointPointer, name)
    __swig_setmethods__["ptr_"] = _typ.PointPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.PointPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.PointPointer_ptr__get, _typ.PointPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_PointPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_PointPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.PointPointer_reset(self)

    def __ref__(self, *args):
        return _typ.PointPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.PointPointer___deref__(self)

    def isNull(self):
        return _typ.PointPointer_isNull(self)

    def __nonzero__(self):
        return _typ.PointPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.PointPointer_get(self)

    def getImplementation(self):
        return _typ.PointPointer_getImplementation(self)

    def unique(self):
        return _typ.PointPointer_unique(self)

    def use_count(self):
        return _typ.PointPointer_use_count(self)

    def swap(self, other):
        return _typ.PointPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.PointPointer_getClassName(self)


    def setDescription(self, description):
        """
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components.
        """
        return _typ.PointPointer_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components.

        See Also
        --------
        setDescription
        """
        return _typ.PointPointer_getDescription(self)


    def __repr__(self):
        return _typ.PointPointer___repr__(self)

    def __str__(self, *args):
        return _typ.PointPointer___str__(self, *args)

    def clean(self, threshold):
        return _typ.PointPointer_clean(self, threshold)

    def getDimension(self):
        """
        Accessor to the vector's dimension.

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.PointPointer_getDimension(self)


    def getSize(self):
        """
        Accessor to the vector's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the vector.
        """
        return _typ.PointPointer_getSize(self)


    def __imul__(self, scalar):
        return _typ.PointPointer___imul__(self, scalar)

    def __itruediv__(self, *args):
        return _typ.PointPointer___itruediv__(self, *args)
    __idiv__ = __itruediv__



    def norm(self):
        """
        Compute the Euclidean (:math:`L^2`) norm.

        The Euclidean (:math:`L^2`) norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}} = \\norm{\\vect{x}}_2
                            = \\sqrt{\\sum_{i=1}^n x_i^2}

        Returns
        -------
        norm : float
            The vector's Euclidean norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm()
        3.741657...
        """
        return _typ.PointPointer_norm(self)


    def norm1(self):
        """
        Compute the :math:`L^1` norm.

        The :math:`L^1` norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}}_1 = \\sum_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^1` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.norm1()
        6.0
        """
        return _typ.PointPointer_norm1(self)


    def normInf(self):
        """
        Compute the :math:`L^{\\inf}` norm.

        The :math:`L^{\\inf}` norm of a vector is defined as:

        .. math::

            \\norm{\\vect{x}}_{\\inf} = \\max_{i=1}^n |x_i|

        Returns
        -------
        norm : float
            The vector's :math:`L^{\\inf}` norm.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normInf()
        3.0
        """
        return _typ.PointPointer_normInf(self)


    def normSquare(self):
        """
        Compute the squared Euclidean norm.

        Returns
        -------
        norm : float
            The vector's squared Euclidean norm.

        See Also
        --------
        norm

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> x.normSquare()
        14.0
        """
        return _typ.PointPointer_normSquare(self)


    def normalize(self):
        """
        Compute the normalized vector with respect to its Euclidean norm.

        Returns
        -------
        normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its Euclidean norm.

        See Also
        --------
        norm

        Raises
        ------
        RuntimeError : If the Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalize())
        [0.267261,0.534522,0.801784]
        """
        return _typ.PointPointer_normalize(self)


    def normalizeSquare(self):
        """
        Compute the normalized vector with respect to its squared Euclidean norm.

        Returns
        -------
        normalized_vector : normalized_vector : :class:`~openturns.Point`
            The normalized vector with respect to its squared Euclidean norm.

        See Also
        --------
        normSquare

        Raises
        ------
        RuntimeError : If the squared Euclidean norm is zero.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point([1.0, 2.0, 3.0])
        >>> print(x.normalizeSquare())
        [0.0714286,0.285714,0.642857]
        """
        return _typ.PointPointer_normalizeSquare(self)


    def __setitem__(self, arg, valObj):
        return _typ.PointPointer___setitem__(self, arg, valObj)

    def __getitem__(self, arg):
        return _typ.PointPointer___getitem__(self, arg)

    def __eq__(self, other):
        return _typ.PointPointer___eq__(self, other)

    def __ne__(self, other):
        return _typ.PointPointer___ne__(self, other)

    def __add__(self, other):
        return _typ.PointPointer___add__(self, other)

    def __sub__(self, other):
        return _typ.PointPointer___sub__(self, other)

    def __mul__(self, s):
        return _typ.PointPointer___mul__(self, s)

    def __rmul__(self, s):
        return _typ.PointPointer___rmul__(self, s)

    def __div__(self, s):
        return _typ.PointPointer___div__(self, s)

    def __truediv__(self, s):
        return _typ.PointPointer___truediv__(self, s)

    def __iadd__(self, other):
        return _typ.PointPointer___iadd__(self, other)

    def __isub__(self, other):
        return _typ.PointPointer___isub__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.PointPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.PointPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.PointPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.PointPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.PointPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.PointPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.PointPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.PointPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.PointPointer_setName(self, name)


    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.PointPointer_clear(self)


    def __len__(self):
        return _typ.PointPointer___len__(self)

    def __contains__(self, val):
        return _typ.PointPointer___contains__(self, val)

    def __delitem__(self, i):
        return _typ.PointPointer___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.PointPointer_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.PointPointer_add(self, *args)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.PointPointer_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.PointPointer_isEmpty(self)

PointPointer_swigregister = _typ.PointPointer_swigregister
PointPointer_swigregister(PointPointer)

class TensorImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TensorImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _typ.TensorImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.TensorImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.TensorImplementationPointer_ptr__get, _typ.TensorImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_TensorImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_TensorImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.TensorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ.TensorImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.TensorImplementationPointer___deref__(self)

    def isNull(self):
        return _typ.TensorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ.TensorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.TensorImplementationPointer_get(self)

    def getImplementation(self):
        return _typ.TensorImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ.TensorImplementationPointer_unique(self)

    def use_count(self):
        return _typ.TensorImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ.TensorImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.TensorImplementationPointer_getClassName(self)


    def clean(self, threshold):
        """
        Set elements smaller than a threshold to zero.

        Parameters
        ----------
        threshold : float
            Threshold for zeroing elements.

        Returns
        -------
        cleaned_tensor : :class:`~openturns.Tensor`
            Input tensor with elements smaller than the threshold set to zero.
        """
        return _typ.TensorImplementationPointer_clean(self, threshold)


    def __repr__(self):
        return _typ.TensorImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ.TensorImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _typ.TensorImplementationPointer___call__(self, *args)

    def getSheet(self, k):
        """
        Get a sheet of the tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        Returns
        -------
        M : :class:`~openturns.Matrix`
            The sheet element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getSheet(1))
        [[ 4 6 ]
         [ 5 7 ]]
        """
        return _typ.TensorImplementationPointer_getSheet(self, k)


    def setSheet(self, k, m):
        """
        Set a matrix as a sheet of the complex tensor.

        Parameters
        ----------
        sheet : int
            Index of sheet element.

        M : :class:`~openturns.Matrix`
            The matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T)
        sheet #0
        [[  0  2 ]
         [  1  3 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        >>> M = ot.Matrix([[1, 2],[3, 4]])
        >>> T.setSheet(0, M)
        >>> print(T)
        sheet #0
        [[  1  2 ]
         [  3  4 ]]
        sheet #1
        [[  4  6 ]
         [  5  7 ]]
        sheet #2
        [[  8 10 ]
         [  9 11 ]]
        """
        return _typ.TensorImplementationPointer_setSheet(self, k, m)


    def getSheetSym(self, k):
        return _typ.TensorImplementationPointer_getSheetSym(self, k)

    def setSheetSym(self, k, m):
        return _typ.TensorImplementationPointer_setSheetSym(self, k, m)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        n_rows : int
        """
        return _typ.TensorImplementationPointer_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        n_columns : int
        """
        return _typ.TensorImplementationPointer_getNbColumns(self)


    def getNbSheets(self):
        """
        Accessor to the number of sheets.

        Returns
        -------
        n_sheets : int

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor(2, 2, 3, range(2*2*3))
        >>> print(T.getNbSheets())
        3
        """
        return _typ.TensorImplementationPointer_getNbSheets(self)


    def isSymmetric(self):
        return _typ.TensorImplementationPointer_isSymmetric(self)

    def symmetrize(self):
        return _typ.TensorImplementationPointer_symmetrize(self)

    def __eq__(self, rhs):
        return _typ.TensorImplementationPointer___eq__(self, rhs)

    def isEmpty(self):
        """
        Tell if the tensor is empty.

        Returns
        -------
        is_empty : bool
            *True* if the tensor contains no element.

        Examples
        --------
        >>> import openturns as ot
        >>> T = ot.Tensor()
        >>> T.isEmpty()
        True
        """
        return _typ.TensorImplementationPointer_isEmpty(self)


    def __baseaddress__(self):
        return _typ.TensorImplementationPointer___baseaddress__(self)

    def __elementsize__(self):
        return _typ.TensorImplementationPointer___elementsize__(self)

    def __stride__(self, dim):
        return _typ.TensorImplementationPointer___stride__(self, dim)

    def __ne__(self, other):
        return _typ.TensorImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.TensorImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.TensorImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.TensorImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.TensorImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.TensorImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.TensorImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.TensorImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.TensorImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.TensorImplementationPointer_setName(self, name)


    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.TensorImplementationPointer_clear(self)


    def __len__(self):
        return _typ.TensorImplementationPointer___len__(self)

    def __contains__(self, val):
        return _typ.TensorImplementationPointer___contains__(self, val)

    def __getitem__(self, i):
        return _typ.TensorImplementationPointer___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.TensorImplementationPointer___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.TensorImplementationPointer___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.TensorImplementationPointer_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.TensorImplementationPointer_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.TensorImplementationPointer_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.TensorImplementationPointer_resize(self, newSize)

TensorImplementationPointer_swigregister = _typ.TensorImplementationPointer_swigregister
TensorImplementationPointer_swigregister(TensorImplementationPointer)

class ComplexMatrixImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexMatrixImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexMatrixImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _typ.ComplexMatrixImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.ComplexMatrixImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.ComplexMatrixImplementationPointer_ptr__get, _typ.ComplexMatrixImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_ComplexMatrixImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_ComplexMatrixImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.ComplexMatrixImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.ComplexMatrixImplementationPointer___deref__(self)

    def isNull(self):
        return _typ.ComplexMatrixImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ.ComplexMatrixImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.ComplexMatrixImplementationPointer_get(self)

    def getImplementation(self):
        return _typ.ComplexMatrixImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ.ComplexMatrixImplementationPointer_unique(self)

    def use_count(self):
        return _typ.ComplexMatrixImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ.ComplexMatrixImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexMatrixImplementationPointer_getClassName(self)


    def solveLinearSystemRect(self, *args):
        return _typ.ComplexMatrixImplementationPointer_solveLinearSystemRect(self, *args)

    def clean(self, threshold):
        """
        Clean the matrix according to a specific threshold.

        Parameters
        ----------
        threshold : positive float
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _typ.ComplexMatrixImplementationPointer_clean(self, threshold)


    def cleanHerm(self, threshold):
        return _typ.ComplexMatrixImplementationPointer_cleanHerm(self, threshold)

    def __repr__(self):
        return _typ.ComplexMatrixImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___call__(self, *args)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        nr : integer
            The number of rows of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrixImplementationPointer_getNbRows(self)


    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        nc : integer
            The number of columns of :math:`\\mat{M}`.
        """
        return _typ.ComplexMatrixImplementationPointer_getNbColumns(self)


    def getDimension(self):
        return _typ.ComplexMatrixImplementationPointer_getDimension(self)

    def transpose(self):
        """
        Accessor to the transposed complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = M_{j, i}`.
        """
        return _typ.ComplexMatrixImplementationPointer_transpose(self)


    def transposeHerm(self):
        return _typ.ComplexMatrixImplementationPointer_transposeHerm(self)

    def conjugate(self):
        """
        Accessor to the conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The conjugate matrix :math:`\\mat{N}` of size :math:`n_r \\times n_c`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{i, j}`.
        """
        return _typ.ComplexMatrixImplementationPointer_conjugate(self)


    def conjugateHerm(self):
        return _typ.ComplexMatrixImplementationPointer_conjugateHerm(self)

    def conjugateTranspose(self):
        """
        Accessor to the transposed conjugate complex matrix.

        Returns
        -------
        N : :class:`~openturns.ComplexMatrix`
            The transposed conjugate matrix :math:`\\mat{N}` of size :math:`n_c \\times n_r`
            associated with the given complex matrix :math:`\\mat{M}` such as
            :math:`N_{i, j} = \\overline{M}_{j, i}`.
        """
        return _typ.ComplexMatrixImplementationPointer_conjugateTranspose(self)


    def hermitianize(self):
        return _typ.ComplexMatrixImplementationPointer_hermitianize(self)

    def realRect(self):
        return _typ.ComplexMatrixImplementationPointer_realRect(self)

    def realSym(self):
        return _typ.ComplexMatrixImplementationPointer_realSym(self)

    def imagRect(self):
        return _typ.ComplexMatrixImplementationPointer_imagRect(self)

    def imagSym(self):
        return _typ.ComplexMatrixImplementationPointer_imagSym(self)

    def __add__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___add__(self, *args)

    def __sub__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___sub__(self, *args)

    def __mul__(self, s):
        return _typ.ComplexMatrixImplementationPointer___mul__(self, s)

    def __truediv__(self, *args):
        return _typ.ComplexMatrixImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def genProd(self, matrix):
        return _typ.ComplexMatrixImplementationPointer_genProd(self, matrix)

    def symProd(self, m, symSide):
        return _typ.ComplexMatrixImplementationPointer_symProd(self, m, symSide)

    def hermProd(self, m, hermSide):
        return _typ.ComplexMatrixImplementationPointer_hermProd(self, m, hermSide)

    def triangularProd(self, *args):
        return _typ.ComplexMatrixImplementationPointer_triangularProd(self, *args)

    def genPower(self, n):
        return _typ.ComplexMatrixImplementationPointer_genPower(self, n)

    def symPower(self, n):
        return _typ.ComplexMatrixImplementationPointer_symPower(self, n)

    def hermPower(self, n):
        return _typ.ComplexMatrixImplementationPointer_hermPower(self, n)

    def genVectProd(self, *args):
        return _typ.ComplexMatrixImplementationPointer_genVectProd(self, *args)

    def hermVectProd(self, *args):
        return _typ.ComplexMatrixImplementationPointer_hermVectProd(self, *args)

    def triangularVectProd(self, *args):
        return _typ.ComplexMatrixImplementationPointer_triangularVectProd(self, *args)

    def isHermitian(self):
        return _typ.ComplexMatrixImplementationPointer_isHermitian(self)

    def isHermitianPositiveDefinite(self, keepIntact=True):
        return _typ.ComplexMatrixImplementationPointer_isHermitianPositiveDefinite(self, keepIntact)

    def computeCholesky(self, keepIntact=True):
        return _typ.ComplexMatrixImplementationPointer_computeCholesky(self, keepIntact)

    def __eq__(self, rhs):
        return _typ.ComplexMatrixImplementationPointer___eq__(self, rhs)

    def __ne__(self, rhs):
        return _typ.ComplexMatrixImplementationPointer___ne__(self, rhs)

    def isEmpty(self):
        """
        Test whether the matrix is empty or not.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the dimensions of the matrix is zero.
        """
        return _typ.ComplexMatrixImplementationPointer_isEmpty(self)


    def isTriangular(self, lower=True):
        return _typ.ComplexMatrixImplementationPointer_isTriangular(self, lower)

    def __baseaddress__(self):
        return _typ.ComplexMatrixImplementationPointer___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexMatrixImplementationPointer___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexMatrixImplementationPointer___stride__(self, dim)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.ComplexMatrixImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.ComplexMatrixImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.ComplexMatrixImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.ComplexMatrixImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.ComplexMatrixImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.ComplexMatrixImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.ComplexMatrixImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.ComplexMatrixImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.ComplexMatrixImplementationPointer_setName(self, name)


    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ComplexMatrixImplementationPointer_clear(self)


    def __len__(self):
        return _typ.ComplexMatrixImplementationPointer___len__(self)

    def __contains__(self, val):
        return _typ.ComplexMatrixImplementationPointer___contains__(self, val)

    def __getitem__(self, i):
        return _typ.ComplexMatrixImplementationPointer___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ComplexMatrixImplementationPointer___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ComplexMatrixImplementationPointer___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ComplexMatrixImplementationPointer_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ComplexMatrixImplementationPointer_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ComplexMatrixImplementationPointer_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ComplexMatrixImplementationPointer_resize(self, newSize)

ComplexMatrixImplementationPointer_swigregister = _typ.ComplexMatrixImplementationPointer_swigregister
ComplexMatrixImplementationPointer_swigregister(ComplexMatrixImplementationPointer)

class HermitianMatrixCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HermitianMatrixCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HermitianMatrixCollection, name)
    __swig_destroy__ = _typ.delete_HermitianMatrixCollection
    __del__ = lambda self: None

    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.HermitianMatrixCollection_clear(self)


    def __len__(self):
        return _typ.HermitianMatrixCollection___len__(self)

    def __eq__(self, rhs):
        return _typ.HermitianMatrixCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _typ.HermitianMatrixCollection___contains__(self, val)

    def __getitem__(self, i):
        return _typ.HermitianMatrixCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.HermitianMatrixCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.HermitianMatrixCollection___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.HermitianMatrixCollection_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.HermitianMatrixCollection_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.HermitianMatrixCollection_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.HermitianMatrixCollection_resize(self, newSize)


    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _typ.HermitianMatrixCollection_isEmpty(self)


    def __repr__(self):
        return _typ.HermitianMatrixCollection___repr__(self)

    def __str__(self, *args):
        return _typ.HermitianMatrixCollection___str__(self, *args)

    def __init__(self, *args):
        this = _typ.new_HermitianMatrixCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
HermitianMatrixCollection_swigregister = _typ.HermitianMatrixCollection_swigregister
HermitianMatrixCollection_swigregister(HermitianMatrixCollection)

class ComplexTensorImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComplexTensorImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ComplexTensorImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _typ.ComplexTensorImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _typ.ComplexTensorImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_typ.ComplexTensorImplementationPointer_ptr__get, _typ.ComplexTensorImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _typ.new_ComplexTensorImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _typ.delete_ComplexTensorImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _typ.ComplexTensorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _typ.ComplexTensorImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _typ.ComplexTensorImplementationPointer___deref__(self)

    def isNull(self):
        return _typ.ComplexTensorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _typ.ComplexTensorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _typ.ComplexTensorImplementationPointer_get(self)

    def getImplementation(self):
        return _typ.ComplexTensorImplementationPointer_getImplementation(self)

    def unique(self):
        return _typ.ComplexTensorImplementationPointer_unique(self)

    def use_count(self):
        return _typ.ComplexTensorImplementationPointer_use_count(self)

    def swap(self, other):
        return _typ.ComplexTensorImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _typ.ComplexTensorImplementationPointer_getClassName(self)


    def clean(self, threshold):
        return _typ.ComplexTensorImplementationPointer_clean(self, threshold)

    def __repr__(self):
        return _typ.ComplexTensorImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _typ.ComplexTensorImplementationPointer___str__(self, *args)

    def __call__(self, *args):
        return _typ.ComplexTensorImplementationPointer___call__(self, *args)

    def getSheet(self, k):
        return _typ.ComplexTensorImplementationPointer_getSheet(self, k)

    def setSheet(self, k, m):
        return _typ.ComplexTensorImplementationPointer_setSheet(self, k, m)

    def getSheetSym(self, k):
        return _typ.ComplexTensorImplementationPointer_getSheetSym(self, k)

    def setSheetSym(self, k, m):
        return _typ.ComplexTensorImplementationPointer_setSheetSym(self, k, m)

    def getNbRows(self):
        return _typ.ComplexTensorImplementationPointer_getNbRows(self)

    def getNbColumns(self):
        return _typ.ComplexTensorImplementationPointer_getNbColumns(self)

    def getNbSheets(self):
        return _typ.ComplexTensorImplementationPointer_getNbSheets(self)

    def isSymmetric(self):
        return _typ.ComplexTensorImplementationPointer_isSymmetric(self)

    def hermitianize(self):
        return _typ.ComplexTensorImplementationPointer_hermitianize(self)

    def __eq__(self, rhs):
        return _typ.ComplexTensorImplementationPointer___eq__(self, rhs)

    def isEmpty(self):
        return _typ.ComplexTensorImplementationPointer_isEmpty(self)

    def __baseaddress__(self):
        return _typ.ComplexTensorImplementationPointer___baseaddress__(self)

    def __elementsize__(self):
        return _typ.ComplexTensorImplementationPointer___elementsize__(self)

    def __stride__(self, dim):
        return _typ.ComplexTensorImplementationPointer___stride__(self, dim)

    def __ne__(self, other):
        return _typ.ComplexTensorImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _typ.ComplexTensorImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _typ.ComplexTensorImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _typ.ComplexTensorImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _typ.ComplexTensorImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _typ.ComplexTensorImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _typ.ComplexTensorImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _typ.ComplexTensorImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _typ.ComplexTensorImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _typ.ComplexTensorImplementationPointer_setName(self, name)


    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _typ.ComplexTensorImplementationPointer_clear(self)


    def __len__(self):
        return _typ.ComplexTensorImplementationPointer___len__(self)

    def __contains__(self, val):
        return _typ.ComplexTensorImplementationPointer___contains__(self, val)

    def __getitem__(self, i):
        return _typ.ComplexTensorImplementationPointer___getitem__(self, i)

    def __setitem__(self, i, val):
        return _typ.ComplexTensorImplementationPointer___setitem__(self, i, val)

    def __delitem__(self, i):
        return _typ.ComplexTensorImplementationPointer___delitem__(self, i)

    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _typ.ComplexTensorImplementationPointer_at(self, *args)


    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _typ.ComplexTensorImplementationPointer_add(self, *args)


    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _typ.ComplexTensorImplementationPointer_getSize(self)


    def resize(self, newSize):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _typ.ComplexTensorImplementationPointer_resize(self, newSize)

ComplexTensorImplementationPointer_swigregister = _typ.ComplexTensorImplementationPointer_swigregister
ComplexTensorImplementationPointer_swigregister(ComplexTensorImplementationPointer)


class BoolCollection(UnsignedIntegerCollection):
    """Proxy of C++ OT::BoolCollection class"""
    pass

# This file is compatible with both classic and new-style classes.


