# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Simulation uncertainty propagation algorithms."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_simulation')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_simulation')
    _simulation = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_simulation', [dirname(__file__)])
        except ImportError:
            import _simulation
            return _simulation
        try:
            _mod = imp.load_module('_simulation', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _simulation = swig_import_helper()
    del swig_import_helper
else:
    import _simulation
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _simulation.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _simulation.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _simulation.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _simulation.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _simulation.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _simulation.SwigPyIterator_equal(self, x)

    def copy(self):
        return _simulation.SwigPyIterator_copy(self)

    def next(self):
        return _simulation.SwigPyIterator_next(self)

    def __next__(self):
        return _simulation.SwigPyIterator___next__(self)

    def previous(self):
        return _simulation.SwigPyIterator_previous(self)

    def advance(self, n):
        return _simulation.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _simulation.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _simulation.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _simulation.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _simulation.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _simulation.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _simulation.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _simulation.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _simulation.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.transformation
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
import openturns.analytical
class SimulationResultImplementation(openturns.common.PersistentObject):
    """
    Simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.Simulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mecanism in order to use the getImportanceFactors method
    >>> limitState.enableHistory()
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.RandomVector(limitState, ot.RandomVector(myDistribution))
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> myLHS = ot.LHS(myEvent)
    >>> myLHS.run()
    >>> SimulationLHSResult = myLHS.getResult()
    >>> print(SimulationLHSResult.getImportanceFactors())
    [X0 : 0.000722617, X1 : 0.635094, X2 : 0.275692, X3 : 0.0884917]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulationResultImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulationResultImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationResultImplementation_getClassName(self)


    def getEvent(self):
        """
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.Event`
            Event we want to evaluate the probability.
        """
        return _simulation.SimulationResultImplementation_getEvent(self)


    def setEvent(self, event):
        """
        Accessor to the event.

        Parameters
        ----------
        event : :class:`~openturns.Event`
            Event we want to evaluate the probability.
        """
        return _simulation.SimulationResultImplementation_setEvent(self, event)


    def getProbabilityEstimate(self):
        """
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _simulation.SimulationResultImplementation_getProbabilityEstimate(self)


    def setProbabilityEstimate(self, probabilityEstimate):
        """
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \\leq P_e \\leq 1`
            Estimate of the event probability.
        """
        return _simulation.SimulationResultImplementation_setProbabilityEstimate(self, probabilityEstimate)


    def getVarianceEstimate(self):
        """
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _simulation.SimulationResultImplementation_getVarianceEstimate(self)


    def setVarianceEstimate(self, varianceEstimate):
        """
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \\geq 0`
            Variance estimate.
        """
        return _simulation.SimulationResultImplementation_setVarianceEstimate(self, varianceEstimate)


    def getCoefficientOfVariation(self):
        """
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.SimulationResultImplementation_getCoefficientOfVariation(self)


    def getStandardDeviation(self):
        """
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _simulation.SimulationResultImplementation_getStandardDeviation(self)


    def getMeanPointInEventDomain(self):
        """
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.Simulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :meth:`~openturns.Function.enableHistory`).
        """
        return _simulation.SimulationResultImplementation_getMeanPointInEventDomain(self)


    def getImportanceFactors(self):
        """
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \\alpha_i = \\displaystyle \\frac{\\left(U_{i}^*\\right)^2}{||\\vect{U}^*||^2}

        where :math:`\\vect{U}^* = T(\\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\\vect{X}^*_{event} = \\displaystyle \\frac{1}{n} \\sum_{i=1}^{n} \\vect{X}_i 1_{event}(\\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :meth:`~openturns.Function.enableHistory`).

        See also
        --------
        drawImportanceFactors
        """
        return _simulation.SimulationResultImplementation_getImportanceFactors(self)


    def drawImportanceFactors(self):
        """
        Draw the importance factors as an OpenTURNS :class:`~openturns.Graph`.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :meth:`~openturns.Function.enableHistory`).

        See also
        --------
        getImportanceFactors
        """
        return _simulation.SimulationResultImplementation_drawImportanceFactors(self)


    def getOuterSampling(self):
        """
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResultImplementation_getOuterSampling(self)


    def setOuterSampling(self, outerSampling):
        """
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \\geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResultImplementation_setOuterSampling(self, outerSampling)


    def getBlockSize(self):
        """
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResultImplementation_getBlockSize(self)


    def setBlockSize(self, blockSize):
        """
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \\geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResultImplementation_setBlockSize(self, blockSize)


    def getConfidenceLength(self, *args):
        """
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \\in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _simulation.SimulationResultImplementation_getConfidenceLength(self, *args)


    def __repr__(self):
        return _simulation.SimulationResultImplementation___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SimulationResultImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SimulationResultImplementation
    __del__ = lambda self: None
SimulationResultImplementation_swigregister = _simulation.SimulationResultImplementation_swigregister
SimulationResultImplementation_swigregister(SimulationResultImplementation)

class SimulationResultImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulationResultImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulationResultImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _simulation.new_SimulationResultImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.SimulationResultImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SimulationResultImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SimulationResultImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _simulation.SimulationResultImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _simulation.delete_SimulationResultImplementationTypedInterfaceObject
    __del__ = lambda self: None
SimulationResultImplementationTypedInterfaceObject_swigregister = _simulation.SimulationResultImplementationTypedInterfaceObject_swigregister
SimulationResultImplementationTypedInterfaceObject_swigregister(SimulationResultImplementationTypedInterfaceObject)

class SimulationResult(SimulationResultImplementationTypedInterfaceObject):
    """
    Simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.Simulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mecanism in order to use the getImportanceFactors method
    >>> limitState.enableHistory()
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.RandomVector(limitState, ot.RandomVector(myDistribution))
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> myLHS = ot.LHS(myEvent)
    >>> myLHS.run()
    >>> SimulationLHSResult = myLHS.getResult()
    >>> print(SimulationLHSResult.getImportanceFactors())
    [X0 : 0.000722617, X1 : 0.635094, X2 : 0.275692, X3 : 0.0884917]
    """

    __swig_setmethods__ = {}
    for _s in [SimulationResultImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulationResult, name, value)
    __swig_getmethods__ = {}
    for _s in [SimulationResultImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulationResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationResult_getClassName(self)


    def getEvent(self):
        """
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.Event`
            Event we want to evaluate the probability.
        """
        return _simulation.SimulationResult_getEvent(self)


    def getProbabilityEstimate(self):
        """
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _simulation.SimulationResult_getProbabilityEstimate(self)


    def setProbabilityEstimate(self, probabilityEstimate):
        """
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \\leq P_e \\leq 1`
            Estimate of the event probability.
        """
        return _simulation.SimulationResult_setProbabilityEstimate(self, probabilityEstimate)


    def getVarianceEstimate(self):
        """
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _simulation.SimulationResult_getVarianceEstimate(self)


    def setVarianceEstimate(self, varianceEstimate):
        """
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \\geq 0`
            Variance estimate.
        """
        return _simulation.SimulationResult_setVarianceEstimate(self, varianceEstimate)


    def getCoefficientOfVariation(self):
        """
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.SimulationResult_getCoefficientOfVariation(self)


    def getStandardDeviation(self):
        """
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _simulation.SimulationResult_getStandardDeviation(self)


    def getMeanPointInEventDomain(self):
        """
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.Simulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :meth:`~openturns.Function.enableHistory`).
        """
        return _simulation.SimulationResult_getMeanPointInEventDomain(self)


    def getImportanceFactors(self):
        """
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \\alpha_i = \\displaystyle \\frac{\\left(U_{i}^*\\right)^2}{||\\vect{U}^*||^2}

        where :math:`\\vect{U}^* = T(\\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\\vect{X}^*_{event} = \\displaystyle \\frac{1}{n} \\sum_{i=1}^{n} \\vect{X}_i 1_{event}(\\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :meth:`~openturns.Function.enableHistory`).

        See also
        --------
        drawImportanceFactors
        """
        return _simulation.SimulationResult_getImportanceFactors(self)


    def drawImportanceFactors(self):
        """
        Draw the importance factors as an OpenTURNS :class:`~openturns.Graph`.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :meth:`~openturns.Function.enableHistory`).

        See also
        --------
        getImportanceFactors
        """
        return _simulation.SimulationResult_drawImportanceFactors(self)


    def getOuterSampling(self):
        """
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_getOuterSampling(self)


    def setOuterSampling(self, outerSampling):
        """
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \\geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_setOuterSampling(self, outerSampling)


    def getBlockSize(self):
        """
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_getBlockSize(self)


    def setBlockSize(self, blockSize):
        """
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \\geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_setBlockSize(self, blockSize)


    def getConfidenceLength(self, *args):
        """
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \\in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _simulation.SimulationResult_getConfidenceLength(self, *args)


    def __repr__(self):
        return _simulation.SimulationResult___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SimulationResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SimulationResult
    __del__ = lambda self: None
SimulationResult_swigregister = _simulation.SimulationResult_swigregister
SimulationResult_swigregister(SimulationResult)

class Simulation(openturns.common.PersistentObject):
    """
    Base class for sampling methods.

    Available constructor:
        Simulation(*event, verbose=True, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        The event we are computing the probability of.
    verbose : bool
        If *True*, make the computation verbose.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Base class for sampling methods, using the probability distribution of a random
    vector :math:`\\vect{X}` to evaluate the failure probability:

    .. math::

        P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
            = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
    :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

    A Simulation object can be created only through its derived classes:

    - :class:`~openturns.DirectionalSampling`

    - :class:`~openturns.ImportanceSampling`,

    - :class:`~openturns.LHS`,

    - :class:`~openturns.MonteCarlo`,

    - :class:`~openturns.QuasiMonteCarlo`,

    - :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

    - :class:`~openturns.PostAnalyticalImportanceSampling`,

    - :class:`~openturns.RandomizedLHS`,

    - :class:`~openturns.RandomizedQuasiMonteCarlo`.

    See also
    --------
    SimulationResult
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Simulation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Simulation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.Simulation_getClassName(self)


    def getEvent(self):
        """
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.Event`
            Event we want to evaluate the probability.
        """
        return _simulation.Simulation_getEvent(self)


    def getResult(self):
        """
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _simulation.Simulation_getResult(self)


    def setMaximumOuterSampling(self, maximumOuterSampling):
        """
        Accessor to the maximum sample size.

        Parameters
        ----------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _simulation.Simulation_setMaximumOuterSampling(self, maximumOuterSampling)


    def getMaximumOuterSampling(self):
        """
        Accessor to the maximum sample size.

        Returns
        -------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _simulation.Simulation_getMaximumOuterSampling(self)


    def setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation):
        """
        Accessor to the maximum coefficient of variation.

        Parameters
        ----------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.Simulation_setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation)


    def getMaximumCoefficientOfVariation(self):
        """
        Accessor to the maximum coefficient of variation.

        Returns
        -------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.Simulation_getMaximumCoefficientOfVariation(self)


    def setMaximumStandardDeviation(self, maximumStandardDeviation):
        """
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.Simulation_setMaximumStandardDeviation(self, maximumStandardDeviation)


    def getMaximumStandardDeviation(self):
        """
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigma : float, :math:`\\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.Simulation_getMaximumStandardDeviation(self)


    def setBlockSize(self, blockSize):
        """
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \\geq 1`
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.

        Notes
        -----
        For Monte Carlo, LHS and Importance Sampling methods, this allows to save space
        while allowing multithreading, when available we recommend
        to use the number of available CPUs; for the Directional Sampling, we recommend
        to set it to 1.
        """
        return _simulation.Simulation_setBlockSize(self, blockSize)


    def getBlockSize(self):
        """
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.
        """
        return _simulation.Simulation_getBlockSize(self)


    def setVerbose(self, verbose):
        """
        Accessor to verbosity.

        Parameters
        ----------
        verbosity_enabled : bool
            If *True*, make the computation verbose. By default it is verbose.
        """
        return _simulation.Simulation_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to verbosity.

        Returns
        -------
        verbosity_enabled : bool
            If *True*, the computation is verbose. By default it is verbose.
        """
        return _simulation.Simulation_getVerbose(self)


    def setConvergenceStrategy(self, convergenceStrategy):
        """
        Accessor to the convergence strategy.

        Parameters
        ----------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.Simulation_setConvergenceStrategy(self, convergenceStrategy)


    def getConvergenceStrategy(self):
        """
        Accessor to the convergence strategy.

        Returns
        -------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.Simulation_getConvergenceStrategy(self)


    def __repr__(self):
        return _simulation.Simulation___repr__(self)

    def run(self):
        """
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.Simulation_run(self)


    def drawProbabilityConvergence(self, *args):
        """
        Draw the probability convergence at a given level.

        Parameters
        ----------
        level : float, optional
            The probability convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            probability convergence graph
        """
        return _simulation.Simulation_drawProbabilityConvergence(self, *args)


    def __init__(self, *args):
        this = _simulation.new_Simulation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def setProgressCallback(self, *args):
        """
        Set up a progress callback.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.
        """
        return _simulation.Simulation_setProgressCallback(self, *args)


    def setStopCallback(self, *args):
        """
        Set up a stop callback.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.
        """
        return _simulation.Simulation_setStopCallback(self, *args)

    __swig_destroy__ = _simulation.delete_Simulation
    __del__ = lambda self: None
Simulation_swigregister = _simulation.Simulation_swigregister
Simulation_swigregister(Simulation)

class PostAnalyticalSimulation(Simulation):
    """
    Post analytical simulation.

    See also
    --------
    PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

    Notes
    -----
    This class inherits from Simulation.

    The principle is to perform a simulation study to evaluate the threshold
    exceedance probability according to an importance density centered around the
    design point, in the standard space. The importance distribution is the standard
    distribution of the standard space.

    A PostAnalyticalSimulation object can be created only through its derivative
    classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
    :class:`~openturns.PostAnalyticalControlledImportanceSampling`.
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PostAnalyticalSimulation, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PostAnalyticalSimulation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalSimulation_getClassName(self)


    def getAnalyticalResult(self):
        """
        Accessor to the analytical result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result of the analytical study which has been performed just before the 
            simulation study centered around the importance factor.
        """
        return _simulation.PostAnalyticalSimulation_getAnalyticalResult(self)


    def getControlProbability(self):
        return _simulation.PostAnalyticalSimulation_getControlProbability(self)

    def __repr__(self):
        return _simulation.PostAnalyticalSimulation___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_PostAnalyticalSimulation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_PostAnalyticalSimulation
    __del__ = lambda self: None
PostAnalyticalSimulation_swigregister = _simulation.PostAnalyticalSimulation_swigregister
PostAnalyticalSimulation_swigregister(PostAnalyticalSimulation)

class Wilks(openturns.common.Object):
    """
    Class to evaluate the Wilks number.

    Available constructor:
        Wilks(*randomVector*)

    Parameters
    ----------
    randomVector : :class:`~openturns.RandomVector` of dimension 1
        Output variable of interest.

    Notes
    -----
    This class is a static class which enables the evaluation of the Wilks number:
    the minimal sample size :math:`N_{\\alpha, \\beta, i}` to perform in order to
    garantee that the empirical quantile :math:`\\alpha`, noted
    :math:`\\tilde{q}_{\\alpha} N_{\\alpha, \\beta, i}` evaluated with the
    :math:`(n - i)^{th}` maximum of the sample, noted :math:`X_{n - i}` be greater
    than the theoretical quantile :math:`q_{\\alpha}` with a probability at least
    :math:`\\beta`:

    .. math::

        \\Pset (\\tilde{q}_{\\alpha} N_{\\alpha, \\beta, i} > q_{\\alpha}) > \\beta

    where :math:`\\tilde{q}_{\\alpha} N_{\\alpha, \\beta, i} = X_{n-i}`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Wilks, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Wilks, name)
    __repr__ = _swig_repr

    def ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
        """
        Evaluate the size of the sample.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        w : int
            the Wilks number.
        """
        return _simulation.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

    ComputeSampleSize = staticmethod(ComputeSampleSize)

    def computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex=0):
        """
        Evaluate the bound of the quantile.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        q : :class:`~openturns.Point`
            The estimate of the quantile upper bound for the given quantile level, at
            the given confidence level and using the given upper statistics.
        """
        return _simulation.Wilks_computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex)


    def __init__(self, *args):
        this = _simulation.new_Wilks(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_Wilks
    __del__ = lambda self: None
Wilks_swigregister = _simulation.Wilks_swigregister
Wilks_swigregister(Wilks)

def Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
    """
    Evaluate the size of the sample.

    Parameters
    ----------
    alpha : positive float :math:`< 1`
        The order of the quantile we want to evaluate.
    beta : positive float :math:`< 1`
        Confidence on the evaluation of the empirical quantile.
    i : int
        Rank of the maximum which will evaluate the empirical quantile. Default
        :math:`i = 0` (maximum of the sample)

    Returns
    -------
    w : int
        the Wilks number.
    """
    return _simulation.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

class MonteCarlo(Simulation):
    """
    Monte Carlo method.

    Available constructors:
        MonteCarlo(*event=ot.Event()*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event 

    .. math::

        \\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\} 

    If we have the set :math:`\\left\\{ \\vect{x}_1,\\ldots,\\vect{x}_N \\right\\}` of
    :math:`N` independent samples of the random vector :math:`\\vect{X}`, we can
    estimate :math:`\\widehat{P}_f` as follows:

    .. math::

        \\widehat{P}_{f,MC} = \\frac{1}{N}
                             \\sum_{i=1}^N \\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }

    where :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\\vect{X}`, for which the event
    :math:`\\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \\lim_{N\\rightarrow\\infty}\\Prob{P_f\\in[\\widehat{P}_{f,\\inf},\\widehat{P}_{f,\\sup}]}=\\alpha

    with :math:`\\widehat{P}_{f,\\inf}=\\widehat{P}_f - q_{\\alpha}\\sqrt{\\frac{\\widehat{P}_f(1-\\widehat{P}_f)}{N}}`,
    :math:`\\widehat{P}_{f,\\sup}=\\widehat{P}_f + q_{\\alpha}\\sqrt{\\frac{\\widehat{P}_f(1-\\widehat{P}_f)}{N}}`
    and :math:`q_\\alpha` is the :math:`(1+\\alpha)/2`-quantile of the standard
    normal distribution.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.RandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create a Monte Carlo algorithm
    >>> myAlgo = ot.MonteCarlo(myEvent)
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarlo, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarlo, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MonteCarlo_getClassName(self)


    def __repr__(self):
        return _simulation.MonteCarlo___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_MonteCarlo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_MonteCarlo
    __del__ = lambda self: None
MonteCarlo_swigregister = _simulation.MonteCarlo_swigregister
MonteCarlo_swigregister(MonteCarlo)

class LHS(Simulation):
    """
    Latin Hypercube Sampling (LHS) method.

    Available constructors:
        LHS(*event=ot.Event()*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
            = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
    :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

    LHS or Latin Hypercube Sampling is a sampling method enabling to better cover
    the domain of variations of the input variables, thanks to a stratified
    sampling strategy. This method is applicable in the case of independent input
    variables. The sampling procedure is based on dividing the range of each
    variable into several intervals of equal probability. The sampling is
    undertaken as follows:

    - Step 1: The range of each input variable is stratified into isoprobabilistic
      cells,

    - Step 2: A cell is uniformly chosen among all the available cells,

    - Step 3: The random number is obtained by inverting the Cumulative Density
      Function locally in the chosen cell,

    - Step 4: All the cells having a common strate with the previous cell are put
      apart from the list of available cells.

    The estimator of the probability of failure with LHS is given by:

    .. math::

        \\widehat{P}_{f,LHS} = \\frac{1}{N}
                              \\sum_{i=1}^N \\mathbf{1}_{\\{g(\\uX^i,\\vect{d}) \\leq 0 \\}}

    where the sample of :math:`\\{ \\uX^i,i=1 \\hdots N \\}` is obtained as described
    previously.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.RandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create a LHS algorithm
    >>> myAlgo = ot.LHS(myEvent)
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.151667
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHS, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.LHS_getClassName(self)


    def run(self):
        """
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.LHS_run(self)


    def __repr__(self):
        return _simulation.LHS___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_LHS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_LHS
    __del__ = lambda self: None
LHS_swigregister = _simulation.LHS_swigregister
LHS_swigregister(LHS)

class RandomizedLHS(Simulation):
    """
    Randomized Latin Hypercube Sampling.

    Available constructor:
        RandomizedLHS(*event*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        The event we are computing the probability of.

    See also
    --------
    Simulation

    Notes
    -----
    Be carefull, to be valid, the RandomizedLHS sampling method requires
    that the multivariate distribution have an independent copula. All events can be
    reduced to this case using the Rosenblatt transformation.
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomizedLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomizedLHS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RandomizedLHS_getClassName(self)


    def __repr__(self):
        return _simulation.RandomizedLHS___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RandomizedLHS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RandomizedLHS
    __del__ = lambda self: None
RandomizedLHS_swigregister = _simulation.RandomizedLHS_swigregister
RandomizedLHS_swigregister(RandomizedLHS)

class ImportanceSampling(Simulation):
    """
    Importance simulation.

    Available constructors:
        ImportanceSampling(*event=ot.Event(), importanceDistribution*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.
    importanceDistribution : :class:`~openturns.Distribution`
        Importance distribution of the Importance Sampling simulation method.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\vect{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
            = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
    :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

    The main idea of the Importance Sampling method is to replace the initial
    probability distribution of the input variables by a more *efficient* one.
    *Efficient* means that more events will be counted in the failure domain
    :math:`\\cD_f` and thus reduce the variance of the estimator of the probability
    of exceeding a threshold. Let :math:`\\vect{Y}` be a random vector such that its
    probability density function :math:`f_{\\vect{Y}}(\\vect{y}) > 0` almost
    everywhere in the domain :math:`\\cD_f`,

    .. math::

        P_f &= \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\vect{d}) \\leq 0 \\}}
               f_{\\uX}(\\ux)\\di{\\ux} \\\\
            &= \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\vect{d}) \\leq 0 \\}}
               \\frac{f_{\\uX}(\\ux)}{f_{\\vect{Y}}(\\ux)}f_{\\vect{Y}}(\\ux)\\di{\\ux}

    The estimator built by Importance Sampling method is:

    .. math::

        \\widehat{P}_{f,IS} = \\frac{1}{N}
                             \\sum_{i=1}^N \\mathbf{1}_{\\{g(\\vect{Y}_{\\:i}),\\vect{d}) \\leq 0 \\}}
                                          \\frac{f_{\\uX}(\\vect{Y}_{\\:i})}
                                               {f_{\\vect{Y}}(\\vect{Y}_{\\:i})}

    where:

    - :math:`N` is the total number of computations,

    - the random vectors :math:`\\{\\vect{Y}_i, i=1\\hdots N\\}` are independent,
      identically distributed and following the probability density function
      :math:`f_{\\uY}`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.RandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create a ImportanceSampling algorithm
    >>> myImportance = ot.Normal([49.969, 1.84194, 10.4454, 4.66776], [1.0]*4, ot.IdentityMatrix(4))
    >>> myAlgo = ot.ImportanceSampling(myEvent, myImportance)
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.153314
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ImportanceSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ImportanceSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ImportanceSampling_getClassName(self)


    def getImportanceDistribution(self):
        """
        Get the importance distribution.

        Returns
        -------
        importanceDistribution : :class:`~openturns.Distribution`
            Importance distribution of the Importance Sampling simulation method.
        """
        return _simulation.ImportanceSampling_getImportanceDistribution(self)


    def __repr__(self):
        return _simulation.ImportanceSampling___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_ImportanceSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_ImportanceSampling
    __del__ = lambda self: None
ImportanceSampling_swigregister = _simulation.ImportanceSampling_swigregister
ImportanceSampling_swigregister(ImportanceSampling)

class PostAnalyticalControlledImportanceSampling(PostAnalyticalSimulation):
    """
    Post analytical controlled importance sampling.

    Available constructor:
        Solver(*analyticalResult*)

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalSimulation, PostAnalyticalImportanceSampling
    """

    __swig_setmethods__ = {}
    for _s in [PostAnalyticalSimulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PostAnalyticalControlledImportanceSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [PostAnalyticalSimulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PostAnalyticalControlledImportanceSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalControlledImportanceSampling_getClassName(self)


    def __repr__(self):
        return _simulation.PostAnalyticalControlledImportanceSampling___repr__(self)

    def computeBlockSample(self):
        return _simulation.PostAnalyticalControlledImportanceSampling_computeBlockSample(self)

    def __init__(self, *args):
        this = _simulation.new_PostAnalyticalControlledImportanceSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_PostAnalyticalControlledImportanceSampling
    __del__ = lambda self: None
PostAnalyticalControlledImportanceSampling_swigregister = _simulation.PostAnalyticalControlledImportanceSampling_swigregister
PostAnalyticalControlledImportanceSampling_swigregister(PostAnalyticalControlledImportanceSampling)

class PostAnalyticalImportanceSampling(PostAnalyticalSimulation):
    """
    Post analytical importance sampling.

    Available constructor:
        Solver(*analyticalResult*)

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study : in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalSimulation, PostAnalyticalControlledImportanceSampling
    """

    __swig_setmethods__ = {}
    for _s in [PostAnalyticalSimulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PostAnalyticalImportanceSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [PostAnalyticalSimulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PostAnalyticalImportanceSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalImportanceSampling_getClassName(self)


    def __repr__(self):
        return _simulation.PostAnalyticalImportanceSampling___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_PostAnalyticalImportanceSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_PostAnalyticalImportanceSampling
    __del__ = lambda self: None
PostAnalyticalImportanceSampling_swigregister = _simulation.PostAnalyticalImportanceSampling_swigregister
PostAnalyticalImportanceSampling_swigregister(PostAnalyticalImportanceSampling)

class RootStrategyImplementation(openturns.common.PersistentObject):
    """
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RootStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RootStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategyImplementation_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategyImplementation_solve(self, function, value)


    def setSolver(self, solver):
        """
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_setSolver(self, solver)


    def getSolver(self):
        """
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_getSolver(self)


    def setMaximumDistance(self, maximumDistance):
        """
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setMaximumDistance(self, maximumDistance)


    def getMaximumDistance(self):
        """
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getMaximumDistance(self)


    def setStepSize(self, stepSize):
        """
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setStepSize(self, stepSize)


    def getStepSize(self):
        """
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getStepSize(self)


    def setOriginValue(self, originValue):
        """
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_setOriginValue(self, originValue)


    def getOriginValue(self):
        """
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_getOriginValue(self)


    def __repr__(self):
        return _simulation.RootStrategyImplementation___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RootStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RootStrategyImplementation
    __del__ = lambda self: None
RootStrategyImplementation_swigregister = _simulation.RootStrategyImplementation_swigregister
RootStrategyImplementation_swigregister(RootStrategyImplementation)

class RootStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RootStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RootStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _simulation.new_RootStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _simulation.RootStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _simulation.delete_RootStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
RootStrategyImplementationTypedInterfaceObject_swigregister = _simulation.RootStrategyImplementationTypedInterfaceObject_swigregister
RootStrategyImplementationTypedInterfaceObject_swigregister(RootStrategyImplementationTypedInterfaceObject)

class RootStrategy(RootStrategyImplementationTypedInterfaceObject):
    """
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    __swig_setmethods__ = {}
    for _s in [RootStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RootStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [RootStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RootStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategy_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategy_solve(self, function, value)


    def setSolver(self, solver):
        """
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_setSolver(self, solver)


    def getSolver(self):
        """
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_getSolver(self)


    def setMaximumDistance(self, maximumDistance):
        """
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setMaximumDistance(self, maximumDistance)


    def getMaximumDistance(self):
        """
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getMaximumDistance(self)


    def setStepSize(self, stepSize):
        """
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setStepSize(self, stepSize)


    def getStepSize(self):
        """
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getStepSize(self)


    def setOriginValue(self, originValue):
        """
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_setOriginValue(self, originValue)


    def getOriginValue(self):
        """
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_getOriginValue(self)


    def __repr__(self):
        return _simulation.RootStrategy___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RootStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RootStrategy
    __del__ = lambda self: None
RootStrategy_swigregister = _simulation.RootStrategy_swigregister
RootStrategy_swigregister(RootStrategy)

class SamplingStrategyImplementation(openturns.common.PersistentObject):
    """
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplingStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplingStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategyImplementation_getClassName(self)


    def generate(self):
        """
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategyImplementation_generate(self)


    def getUniformUnitVectorRealization(self, *args):
        """
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation.SamplingStrategyImplementation_getUniformUnitVectorRealization(self, *args)


    def setDimension(self, dimension):
        """
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_setDimension(self, dimension)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_getDimension(self)


    def __repr__(self):
        return _simulation.SamplingStrategyImplementation___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SamplingStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementation
    __del__ = lambda self: None
SamplingStrategyImplementation_swigregister = _simulation.SamplingStrategyImplementation_swigregister
SamplingStrategyImplementation_swigregister(SamplingStrategyImplementation)

class SamplingStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplingStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplingStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _simulation.new_SamplingStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
SamplingStrategyImplementationTypedInterfaceObject_swigregister = _simulation.SamplingStrategyImplementationTypedInterfaceObject_swigregister
SamplingStrategyImplementationTypedInterfaceObject_swigregister(SamplingStrategyImplementationTypedInterfaceObject)

class SamplingStrategy(SamplingStrategyImplementationTypedInterfaceObject):
    """
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    __swig_setmethods__ = {}
    for _s in [SamplingStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplingStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [SamplingStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplingStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategy_getClassName(self)


    def generate(self):
        """
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategy_generate(self)


    def setDimension(self, dimension):
        """
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_setDimension(self, dimension)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_getDimension(self)


    def __repr__(self):
        return _simulation.SamplingStrategy___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SamplingStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SamplingStrategy
    __del__ = lambda self: None
SamplingStrategy_swigregister = _simulation.SamplingStrategy_swigregister
SamplingStrategy_swigregister(SamplingStrategy)

class DirectionalSampling(Simulation):
    """
    Directional simulation.

    Available constructors:
        DirectionalSampling(*event=ot.Event()*)

        DirectionalSampling(*event, rootStrategy, samplingStrategy*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability. By default,
        *rootStrategy = ot.RootStrategy(ot.SafeAndSlow())*.
    samplingStrategy : :class:`~openturns.SamplingStrategy`
        Strategy adopted to sample directions. By default,
        *samplingStrategy=ot.SamplingStrategy(ot.RandomDirection())*.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
            = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
    :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

    The directional simulation method is an accelerated sampling method. It implies
    a preliminary iso-probabilistic transformation, as for :class:`~openturns.FORM`
    and :class:`~openturns.SORM` methods; however, it remains based on sampling and
    is thus not an approximation method.
    In the transformed space, the (transformed) uncertain variables :math:`\\vect{U}`
    are independent standard gaussian variables (mean equal to zero and standard
    deviation equal to 1).

    Roughly speaking, each simulation of the directional simulation algorithm is
    made of three steps. For the :math:`i^\\textrm{th}` iteration, these steps are
    the following:

    - Let :math:`\\cS = \\big\\{ \\vect{u} \\big| ||\\vect{u}|| = 1 \\big\\}`. A point
      :math:`P_i` is drawn randomly on :math:`\\cS` according to an uniform
      distribution.

    - In the direction starting from the origin and passing through :math:`P_i`,
      solutions of the equation :math:`g(\\vect{X},\\vect{d}) = 0` (i.e. limits of
      :math:`\\cD_f`) are searched. The set of values of :math:`\\vect{u}` that
      belong to :math:`\\cD_f` is deduced for these solutions: it is a subset
      :math:`I_i \\subset \\Rset`.

    - Then, one calculates the probability :math:`q_i = \\Prob{ ||\\vect{U}|| \\in I_i }`.
      By property of independent standard variable, :math:`||\\vect{U}||^2` is a
      random variable distributed according to a chi-square distribution, which
      makes the computation effortless.

    Finally, the estimate of the probability :math:`P_f` after :math:`N` simulations
    is the following:

    .. math::

        \\widehat{P}_{f,DS} = \\frac{1}{N} \\sum_{i=1}^N q_i

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.RandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create a DirectionalSampling algorithm
    >>> myAlgo = ot.DirectionalSampling(myEvent, ot.MediumSafe(), ot.OrthogonalDirection())
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.169716
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DirectionalSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DirectionalSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.DirectionalSampling_getClassName(self)


    def setRootStrategy(self, rootStrategy):
        """
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.DirectionalSampling_setRootStrategy(self, rootStrategy)


    def getRootStrategy(self):
        """
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.DirectionalSampling_getRootStrategy(self)


    def setSamplingStrategy(self, samplingStrategy):
        """
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.DirectionalSampling_setSamplingStrategy(self, samplingStrategy)


    def getSamplingStrategy(self):
        """
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.DirectionalSampling_getSamplingStrategy(self)


    def __repr__(self):
        return _simulation.DirectionalSampling___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_DirectionalSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_DirectionalSampling
    __del__ = lambda self: None
DirectionalSampling_swigregister = _simulation.DirectionalSampling_swigregister
DirectionalSampling_swigregister(DirectionalSampling)

class OrthogonalDirection(SamplingStrategyImplementation):
    """
    Sampling following the orthogonal direction strategy.

    Available constructor:
        OrthogonalDirection()

        OrthogonalDirection(*dimension, k*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.
    k : int
        The number of elements in the linear combinations. By default,
        :math:`k = 1` but automatically updated by the calling class.

    See also
    --------
    RandomDirection

    Notes
    -----
    This strategy is parameterized by :math:`k \\in \\{1, \\ldots, n\\}`, where :math:`n` is
    the dimension of the input random vector :math:`\\vect{X}`. We generate one
    direct orthonormalized basis :math:`(\\vect{e}_1, \\ldots, \\vect{e}_n)` uniformly distributed in
    the set of direct orthonormal bases. We consider all the normalized linear
    combinations of :math:`k` vectors chosen within the :math:`n` vectors of the basis, where
    the coefficients of the linear combinations are in :math:`\\{+1, -1\\}`. This
    generates :math:`\\binom{k}{n} 2^k` new vectors :math:`\\vect{v}_i`. We sample according
    to all the directions defined by the vectors :math:`\\vect{v}_i`.

    If :math:`k = 1`, we consider all the axes of the standard space.
    """

    __swig_setmethods__ = {}
    for _s in [SamplingStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalDirection, name, value)
    __swig_getmethods__ = {}
    for _s in [SamplingStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalDirection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.OrthogonalDirection_getClassName(self)


    def generate(self):
        """
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the orthogonal direction strategy.
        """
        return _simulation.OrthogonalDirection_generate(self)


    def __repr__(self):
        return _simulation.OrthogonalDirection___repr__(self)

    def getUniformOrientationRealization(self):
        return _simulation.OrthogonalDirection_getUniformOrientationRealization(self)

    def __init__(self, *args):
        this = _simulation.new_OrthogonalDirection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_OrthogonalDirection
    __del__ = lambda self: None
OrthogonalDirection_swigregister = _simulation.OrthogonalDirection_swigregister
OrthogonalDirection_swigregister(OrthogonalDirection)

class RandomDirection(SamplingStrategyImplementation):
    """
    Sampling following the random direction strategy.

    Available constructor:
        RandomDirection()

        RandomDirection(*dimension*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    OrthogonalDirection

    Notes
    -----
    The RandomDirection strategy is the following : we generate some points on the
    sphere unity in the standard space according to the uniform distribution and we
    consider both opposite directions so built.
    """

    __swig_setmethods__ = {}
    for _s in [SamplingStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomDirection, name, value)
    __swig_getmethods__ = {}
    for _s in [SamplingStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomDirection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RandomDirection_getClassName(self)


    def generate(self):
        """
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated in two opposite random directions.
        """
        return _simulation.RandomDirection_generate(self)


    def __repr__(self):
        return _simulation.RandomDirection___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RandomDirection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RandomDirection
    __del__ = lambda self: None
RandomDirection_swigregister = _simulation.RandomDirection_swigregister
RandomDirection_swigregister(RandomDirection)

class MediumSafe(RootStrategyImplementation):
    """
    MediumSafe method.

    Available constructors:
        MediumSafe(*solver=ot.Brent()*)

        MediumSafe(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *MediumSafe* strategy is the following: for each direction, we go along the
    direction by step of length *stepSize* from the origin to the maximum distant
    point (at distance *maximumDistance* from the center of the standard space) and
    we check whether there is a sign changement on each segment so formed.

    At the first sign changement, we research one root in the concerned segment
    with the selected non linear solver. Then, the segment
    *[root, maximum distant point]* is considered within the failure space.

    If *stepSize* is small enough, this strategy garantees us to find the root which
    is the nearest from the origin.
    """

    __swig_setmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MediumSafe, name, value)
    __swig_getmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MediumSafe, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MediumSafe_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.MediumSafe_solve(self, function, value)


    def __repr__(self):
        return _simulation.MediumSafe___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_MediumSafe(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_MediumSafe
    __del__ = lambda self: None
MediumSafe_swigregister = _simulation.MediumSafe_swigregister
MediumSafe_swigregister(MediumSafe)

class RiskyAndFast(RootStrategyImplementation):
    """
    RiskyAndFast method.

    Available constructors:
        RiskyAndFast(*solver=ot.Brent()*)

        RiskyAndFast(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *RiskyAndFast* strategy is the following: for each direction, we check
    whether there is a sign changement of the standard limit state function between
    the maximum distant point (at distance *maximumDistance* from the center of the
    standard space) and the center of the standard space.

    In case of sign changement, we search one root in the segment
    *[origin, maximum distant point]* with the selected non linear solver.

    As soon as founded, the segment *[root, infinity point]* is considered within
    the failure space.
    """

    __swig_setmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RiskyAndFast, name, value)
    __swig_getmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RiskyAndFast, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RiskyAndFast_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RiskyAndFast_solve(self, function, value)


    def __repr__(self):
        return _simulation.RiskyAndFast___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RiskyAndFast(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RiskyAndFast
    __del__ = lambda self: None
RiskyAndFast_swigregister = _simulation.RiskyAndFast_swigregister
RiskyAndFast_swigregister(RiskyAndFast)

class SafeAndSlow(RootStrategyImplementation):
    """
    SafeAndSlow method.

    Available constructors:
        SafeAndSlow(*solver=ot.Brent()*)

        SafeAndSlow(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *SafeAndSlow* strategy is the following: for each direction, we go along
    the direction by step of length *stepSize* from the origin to the maximum
    distant point(at distance *maximumDistance* from the center of the standard
    space) and we check whether there is a sign changement on each segment so
    formed.

    We go until the maximum distant point. Then, for all the segments where we
    detected the presence of a root, we research the root with the selected non
    linear solver. We evaluate the contribution to the failure probability of each
    segment.

    If *stepSize* is small enough, this strategy garantees us to find all the roots
    in the direction and the contribution of this direction to the failure
    probability is precisely evaluated.
    """

    __swig_setmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SafeAndSlow, name, value)
    __swig_getmethods__ = {}
    for _s in [RootStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SafeAndSlow, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SafeAndSlow_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.SafeAndSlow_solve(self, function, value)


    def __repr__(self):
        return _simulation.SafeAndSlow___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SafeAndSlow(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SafeAndSlow
    __del__ = lambda self: None
SafeAndSlow_swigregister = _simulation.SafeAndSlow_swigregister
SafeAndSlow_swigregister(SafeAndSlow)

class QuasiMonteCarlo(Simulation):
    """
    Quasi-Monte Carlo method.

    Available constructors:
        QuasiMonteCarlo(*event=ot.Event(), lowDiscrepancySequence=ot.SobolSequence()*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.
    lowDiscrepancySequence : :class:`~openturns.LowDiscrepancySequence`
        Low-discrepancy sequence used to generate the samples.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
            = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

    Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
    vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
    :math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
    describes the indicator function equal to 1 if
    :math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

    Quasi-Monte Carlo method approximates the probability of failure using low
    :class:`discrepancy sequences <openturns.LowDiscrepancySequence>`
    :math:`\\{\\vect{x}_1, ..., \\vect{x}_N\\}` instead of randomly generated
    sequences, as follows:

    .. math::

        P_f \\approx \\frac{1}{N}\\,\\sum_{i=1}^N \\mathbf{1}_{\\cD_f}(\\ux_i) f(\\ux_i).

    In general, the integral of a function :math:`f` on :math:`\\Delta = [0,1]^s`
    can be approximated by using some low discrepancy sequence
    :math:`\\{\\vect{x}_1, \\hdots, \\vect{x}_N\\}`  as follows:

    .. math::

        \\int_{\\Delta} f(\\vect{u})\\di{\\vect{u}} \\approx \\frac{1}{N}\\,\\sum_{i=1}^N f(\\vect{x}_i).

    The low discrepancy sequence is generated on :math:`\\Delta` according to the
    Lebesgue measure then may be transformed to any measure :math:`\\mu` thanks to
    the inverse CDF technique in order to approximate the integral:

    .. math::

        \\int_{\\Rset^s} f(\\vect{u})\\di{\\vect{u}} \\approx \\frac{1}{N}\\,\\sum_{i=1}^N f(\\vect{x}_i)

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.RandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create a QuasiMonteCarlo algorithm
    >>> myAlgo = ot.QuasiMonteCarlo(myEvent)
    >>> myAlgo.setMaximumOuterSampling(50)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.125000
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuasiMonteCarlo, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuasiMonteCarlo, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.QuasiMonteCarlo_getClassName(self)


    def __repr__(self):
        return _simulation.QuasiMonteCarlo___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_QuasiMonteCarlo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_QuasiMonteCarlo
    __del__ = lambda self: None
QuasiMonteCarlo_swigregister = _simulation.QuasiMonteCarlo_swigregister
QuasiMonteCarlo_swigregister(QuasiMonteCarlo)

class RandomizedQuasiMonteCarlo(Simulation):
    """
    Randomized quasi Monte Carlo.

    Available constructor:
        RandomizedQuasiMonteCarlo(*event*)

        RandomizedQuasiMonteCarlo(*event, sequence*)

    Parameters
    ----------
    event : :class:`~openturns.Event`
        The event we are computing the probability of.
    sequence : :class:`~openturns.LowDiscrepancySequence`
        A low discrepancy sequence used to generate the samples. Default is the 
        Sobol sequence.

    See also
    --------
    Simulation

    Notes
    -----
    Be careful, to be valid, the RandomizedQuasiMonteCarlo sampling method requires
    that the multivariate distribution have an independent copula. All events can be
    reduced to this case using the Rosenblatt transformation.
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomizedQuasiMonteCarlo, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomizedQuasiMonteCarlo, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RandomizedQuasiMonteCarlo_getClassName(self)


    def __repr__(self):
        return _simulation.RandomizedQuasiMonteCarlo___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_RandomizedQuasiMonteCarlo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RandomizedQuasiMonteCarlo
    __del__ = lambda self: None
RandomizedQuasiMonteCarlo_swigregister = _simulation.RandomizedQuasiMonteCarlo_swigregister
RandomizedQuasiMonteCarlo_swigregister(RandomizedQuasiMonteCarlo)

class QuasiMonteCarloResult(SimulationResultImplementation):
    """
    Quasi Monte Carlo simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.Simulation`,
    and obtained thanks to the method getResult().
    """

    __swig_setmethods__ = {}
    for _s in [SimulationResultImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuasiMonteCarloResult, name, value)
    __swig_getmethods__ = {}
    for _s in [SimulationResultImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuasiMonteCarloResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.QuasiMonteCarloResult_getClassName(self)


    def getCoefficientOfVariation(self):
        """
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.QuasiMonteCarloResult_getCoefficientOfVariation(self)


    def getStandardDeviation(self):
        """
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _simulation.QuasiMonteCarloResult_getStandardDeviation(self)


    def getConfidenceLength(self, *args):
        """
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \\in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _simulation.QuasiMonteCarloResult_getConfidenceLength(self, *args)


    def __repr__(self):
        return _simulation.QuasiMonteCarloResult___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_QuasiMonteCarloResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_QuasiMonteCarloResult
    __del__ = lambda self: None
QuasiMonteCarloResult_swigregister = _simulation.QuasiMonteCarloResult_swigregister
QuasiMonteCarloResult_swigregister(QuasiMonteCarloResult)

class SimulationSensitivityAnalysis(openturns.common.PersistentObject):
    """
    Class to perform a sensitivity analysis based on a reliability event.

    Available constructor:
        SimulationSensitivityAnalysis(*inputSample, outputSample, transformation, comparisonOp, threshold*)

        SimulationSensitivityAnalysis(*event*)

        SimulationSensitivityAnalysis(*simulationRes*)

    Parameters
    ----------
    inputSample, outputSample : 2-d sequence of float
        Input sample and output sample of a model evaluated apart.
    transformation : :class:`~openturns.Function`
        An isoprobabilistic transformation function.
    comparisonOp : :class:`~openturns.ComparisonOperator`
        A comparison operator.
    threshold : float
        A threshold.
    event : :class:`~openturns.Event`
        An event which it composite (test is with the method
        :meth:`isComposite <openturns.Event.isComposite>`).
    simulationRes : :class:`~openturns.SimulationResult`
        A simulation result.

    Notes
    -----
    The simulation sensitivity analysis is based on:

    - in the first usage, the *inputSample* and *outputSample* given:
    - in the second usage, the samples which have been stored by the function
      defining the event. Care if the sample is not a statistical sample: post
      treatment proposed by the object might not be right.
    - in the third usage, the samples generated by the
      :class:`simulation <openturns.Simulation>` that produced *simulationRes*.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulationSensitivityAnalysis, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulationSensitivityAnalysis, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationSensitivityAnalysis_getClassName(self)


    def computeMeanPointInEventDomain(self, *args):
        """
        Accessor to the mean point.

        Returns
        -------
        mean : :class:`~openturns.Point`
            The mean point in the failure domain.

        Notes
        -----
        This method computes the mean point in the physical space of all the simulations
        generated by the simulation that failed into the event domain.

        Be carefull: this notion is only valid for Monte Carlo or LHS sampling as the
        mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
        the realizations :math:`\\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeMeanPointInEventDomain(self, *args)


    def computeImportanceFactors(self, *args):
        """
        Compute the importance factors.

        Returns
        -------
        impFactors : :class:`~openturns.Point`
            The importance factors.

        Notes
        -----
        The importance factors, given in :eq:`importance_factor`, are evaluated from the
        coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
        the standard space as follows:

        .. math::
            :label: mean_point

            \\vect{X}^*_{event} = \\frac{1}{n} \\sum_{i=1}^n \\vect{X}_i 1_{event} (\\vect{X}_i)

        .. math::
            :label: importance_factor

            \\alpha_i = \\frac{ (U_i^*)^2 }{ \\left\\| \\vect{U}^* \\right\\| }

        where

        .. math::

            \\vect{U}^* = T(\\vect{X}^*_{event})

        Be careful: this notion is only valid for :class:`~openturns.MonteCarlo` or
        :class:`~openturns.LHS` sampling as the mean is evaluated from the equation
        :eq:`importance_factor` (only uniform weights over the realizations
        :math:`\\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeImportanceFactors(self, *args)


    def drawImportanceFactors(self):
        """
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the probabilistic variables.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactors(self)


    def drawImportanceFactorsRange(self, *args):
        """
        Draw the importance factors evolution.

        Parameters
        ----------
        probabilityScale : boolean
            Set True if the limits are the probability levels; set False if the limits are
            the thresholds defining the event.
        lower, upper : floats
            Define the boundaries of the probability levels :math:`p_{min}` and
            :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph that draws the evolution of the importance factors of each direction
            with respect to :math:`p \\in [p_{min}, p_{max}]` or
            :math:`s \\in [s_{min}, s_{max}]`. The importance factors are evaluated from
            the definition :eq:`importance_factor` for each threshold *s* or probability
            *p*.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactorsRange(self, *args)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getOutputSample(self)


    def getThreshold(self):
        """
        Accessor to the threshold.

        Returns
        -------
        s : float
            The threshold.
        """
        return _simulation.SimulationSensitivityAnalysis_getThreshold(self)


    def setThreshold(self, threshold):
        """
        Accessor to the threshold.

        Parameters
        ----------
        s : float
            The threshold.
        """
        return _simulation.SimulationSensitivityAnalysis_setThreshold(self, threshold)


    def getTransformation(self):
        """
        Accessor to the isoprobabilistic transformation function.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The isoprobabilistic transformation function.
        """
        return _simulation.SimulationSensitivityAnalysis_getTransformation(self)


    def getComparisonOperator(self):
        """
        Accessor to the comparison operator.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _simulation.SimulationSensitivityAnalysis_getComparisonOperator(self)


    def setComparisonOperator(self, comparisonOperator):
        """
        Accessor to the comparison operator.

        Parameters
        ----------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _simulation.SimulationSensitivityAnalysis_setComparisonOperator(self, comparisonOperator)


    def __repr__(self):
        return _simulation.SimulationSensitivityAnalysis___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SimulationSensitivityAnalysis(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SimulationSensitivityAnalysis
    __del__ = lambda self: None
SimulationSensitivityAnalysis_swigregister = _simulation.SimulationSensitivityAnalysis_swigregister
SimulationSensitivityAnalysis_swigregister(SimulationSensitivityAnalysis)

class SubsetSamplingResult(SimulationResultImplementation):
    """
    Subset sampling result.

    See also
    --------
    SubsetSampling, SimulationResult
    """

    __swig_setmethods__ = {}
    for _s in [SimulationResultImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SubsetSamplingResult, name, value)
    __swig_getmethods__ = {}
    for _s in [SimulationResultImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SubsetSamplingResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSamplingResult_getClassName(self)


    def getCoefficientOfVariation(self):
        """
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.SubsetSamplingResult_getCoefficientOfVariation(self)


    def __repr__(self):
        return _simulation.SubsetSamplingResult___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SubsetSamplingResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SubsetSamplingResult
    __del__ = lambda self: None
SubsetSamplingResult_swigregister = _simulation.SubsetSamplingResult_swigregister
SubsetSamplingResult_swigregister(SubsetSamplingResult)

class SubsetSampling(Simulation):
    """
    Subset simulation.

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.
    proposalRange : float, optional
        Proposal range length
    targetProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the following probability

    .. math::

        P_f = \\int_{\\mathcal D_f} f_{\\uX}(\\ux)\\di{\\ux}\\\\
            = \\int_{\\mathbb R^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\:\\leq 0\\: \\}}f_{\\uX}(\\ux)\\di{\\ux}\\\\
            = \\Prob {\\{g(\\uX,\\underline{d}) \\leq 0\\}}


    The idea of the subset simulation method [Au2001]_ is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i`

    .. math::

        F_1 \\supset F_2 \\supset \\dots \\supset F_m = F


    The original probability estimate rewrites

    .. math::

        P_f = P(F_m) = P(\\bigcap \\limits_{i=1}^m F_i) = P(F_1) \\prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1`

    .. math::

        F_i =\\Prob {\\{g(\\uX,\\underline{d}) \\leq g_i\\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \\delta^2 = \\sum_{i=1}^m \\delta^2_i = \\sum_{i=1}^m (1+\\gamma_i) \\frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    See also
    --------
    Simulation
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SubsetSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SubsetSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSampling_getClassName(self)


    def setProposalRange(self, proposalRange):
        """
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_setProposalRange(self, proposalRange)


    def getProposalRange(self):
        """
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_getProposalRange(self)


    def setConditionalProbability(self, conditionalProbability):
        """
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_setConditionalProbability(self, conditionalProbability)


    def getConditionalProbability(self):
        """
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_getConditionalProbability(self)


    def getNumberOfSteps(self):
        """
        Subset steps number accesor.

        Returns
        -------
        n : int
            Number of subset steps.
        """
        return _simulation.SubsetSampling_getNumberOfSteps(self)


    def getThresholdPerStep(self):
        """
        Threshold accessor.

        Returns
        -------
        threshold : `~openturns.Point`
            Threshold values.
        """
        return _simulation.SubsetSampling_getThresholdPerStep(self)


    def getGammaPerStep(self):
        """
        Autocorrelation accessor.

        Returns
        -------
        prob : `~openturns.Point`
            Autocorrelation values.
        """
        return _simulation.SubsetSampling_getGammaPerStep(self)


    def getCoefficientOfVariationPerStep(self):
        """
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : `~openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _simulation.SubsetSampling_getCoefficientOfVariationPerStep(self)


    def getProbabilityEstimatePerStep(self):
        """
        Probability estimate accessor.

        Returns
        -------
        prob : `~openturns.Point`
            Probability estimate values.
        """
        return _simulation.SubsetSampling_getProbabilityEstimatePerStep(self)


    def setKeepEventSample(self, keepEventSample):
        """
        Sample storage accessor.

        Parameters
        ----------
        prob : bool
            Whether to keep the event samples.
        """
        return _simulation.SubsetSampling_setKeepEventSample(self, keepEventSample)


    def getEventInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : `~openturns.Sample`
            Input sample.
        """
        return _simulation.SubsetSampling_getEventInputSample(self)


    def getEventOutputSample(self):
        """
        Output sample accessor.

        Returns
        -------
        outputSample : `~openturns.Sample`
            Ouput sample.
        """
        return _simulation.SubsetSampling_getEventOutputSample(self)


    def setISubset(self, iSubset):
        """
        Conditonal simulation flag accessor.

        Parameters
        ----------
        isubset : bool
            Whether to enable conditional simulation for the first step of the
            simulation.
        """
        return _simulation.SubsetSampling_setISubset(self, iSubset)


    def setBetaMin(self, betaMin):
        """
        Hypersphere radius accessor.

        Parameters
        ----------
        beta : float
            Radius value of the exclusion hypershere when the conditional simulation
            is enabled.
        """
        return _simulation.SubsetSampling_setBetaMin(self, betaMin)


    def run(self):
        """
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SubsetSampling_run(self)


    def __repr__(self):
        return _simulation.SubsetSampling___repr__(self)

    def __init__(self, *args):
        this = _simulation.new_SubsetSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SubsetSampling
    __del__ = lambda self: None
SubsetSampling_swigregister = _simulation.SubsetSampling_swigregister
SubsetSampling_swigregister(SubsetSampling)

class AdaptiveDirectionalSampling(Simulation):
    """
    Adaptative directional simulation.

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability.
        Set to :class:`~openturns.SafeAndSlow` by default.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy adopted to sample directions.
        Set to :class:`~openturns.RandomDirection` by default.

    Notes
    -----
    Let :math:`\\mathcal D_f` denote the failure domain defined as
    :math:`\\mathcal D_f = \\{\\ux \\in \\mathbb R^{n_X} | g(\\ux) \\leq 0\\}`, where
    :math:`\\ux` are realization of the random vector :math:`\\uX` and :math:`g` is the limit-state
    function as defined elsewhere in the documentation.

    The purpose of the ADS-2 algorithm and its variants is to estimate the
    following probability:

    .. math::

      P_f = \\int_{\\mathcal D_f} f_{\\uX}(\\ux)\\di{\\ux} \\\\
          = \\int_{\\mathbb R^{n_X}} \\mathbf{1}_{\\{g(\\ux) \\:\\leq 0\\: \\}}\\,f_{\\uX}(\\ux)\\di{\\ux} \\\\
          = \\Prob{\\{g(\\uX) \\leq 0\\}}.

    Principles

    The ADS-2 method [Munoz2011]_ combines the stratified and directional sampling concepts.
    Stratified sampling consists in splitting the support of the random vector
    :math:`\\ux` into :math:`m` mutually exclusive and collectively exhaustive subsets.
    Here, ADS-2 splits the standard space into :math:`m = 2^d` quadrants, where
    :math:`d` is the dimension of the random vector :math:`\\uX`.
    Stratified sampling is often run in two steps: (i) a learning step is used for
    polling the input space and detect the subsets that contribute most to the
    probability and (ii) an estimation step is used for estimating
    the probability by weighted sampling (some subsets are more sampled than the others).
    Directional sampling uses the spheric symmetry of the standard space for
    estimating the failure probability as the average of conditional probabilities
    calculated on directions drawn at random in the standard space.

    The learning step uses an a priori number of random directions that is
    uniformly distributed over the quadrants, meaning the weights are as follows:

    .. math::

        \\omega^1_i = \\frac{1}{m}, \\quad i = 1, \\ldots, m.


    Directional sampling is used for estimating the failure probability in each quadrant:

    .. math::

        \\hat P_i^{DS} = \\Prob{\\{g(\\uX) \\leq 0\\} \\mid \\uX \\in \\mathbb{Q}_i},\\,i = 1, \\ldots, m.


    and the corresponding estimation variances are denoted as :math:`\\sigma_i^{DS\\,2}`.
    These probabilities are estimated using the same number :math:`N^0_i` of random
    directions per quadrant as told by the uniform weights distribution.

    The probability of interest is then computed as a weighted average of the
    previously defined conditional probabilities:

    .. math::

        \\hat P_f = \\sum\\limits_{i=1}^m \\omega_i \\hat P_i^{DS}


    where :math:`\\hat P_i^{DS}` is the conditional probability estimator in the i-th quadrant. The corresponding variance of the stratified estimator reads:

    .. math::

        \\sigma^2 = \\frac{1}{N_l} \\left( \\sum\\limits_{i=1}^m \\omega_i \\sigma_i^{DS} \\right) ^2


    where :math:`\\sigma_i^{DS\\,2}` is the variance of the conditional probability
    estimator in the i-th quadrant.

    At the end of the learning step, the weights :math:`\\omega_i` are updated so
    as to minimize the stratified estimator variance.
    Indeed, it can be shown that the updated weights:

    .. math::

        \\omega^2_i = \\frac{\\omega^1_i \\sigma_i^{DS}}{\\sum\\limits_{j=1}^m \\omega^1_j \\sigma_j^{DS}}, i = 1, \\ldots, m,


    minimize the final estimation variance in \\eqref{eq:pf_est_sda2_var}.
    Note that some weights might be zero (due to a somewhat arbitrary rounding of
    the conditional probabilities' estimation variance). The quadrants associated
    with a zero-weight will not be sampled in the estimation step.

    Eventually, the estimation step proceeds in essentially the same way as the
    learning step with different weights for the quadrants though.
    \\eqref{eq:pf_est_sda2} and \\eqref{eq:pf_est_sda2_var} are used for evaluating
    the final probability probability estimate and its variance.

    The computational budget per step is parametrized by a fraction
    :math:`\\gamma_l, l = 1,\\,2` of the total budget :math:`N`, such that :math:`\\gamma_1 + \\gamma_2 = 1`.
    The number of directions sampled in quadrant :math:`i` at step :math:`l` is then defined as follows:

    .. math::

        N^l_i = N * \\gamma_l * \\omega_i.


    The number of evaluation of the limit-state function :math:`g` is of course
    greater than the total budget :math:`N` since directional sampling is used.

    Variants

    The ADS-2+ variant performs a dimension reduction step after the learning step
    for reducing the number of stratified quadrants. The statistic :math:`\\tilde T_k`
    aggregates the sensitivity of expectation along dimension :math:`k`.
    It is defined as follows:

    .. math::

        \\tilde T_k = \\sum\\limits_{i_l \\in \\lbrace -1,1 \\rbrace,l \\neq k} \\lvert \\tilde I_{(i_1,\\dots,i_{k-1},-1,i_{k+1},\\dots,i_p)} - \\tilde I_{(i_1,\\dots,i_{k-1},1,i_{k+1},\\dots,i_p)} \\rvert.

    It is used for ranking the contributions of the quadrants.
    Then, only the :math:`d' < d` most influential variables according to
    :math:`\\tilde T_k` are stratified, leaving the remaining variables simulated without
    stratification. The corresponding quadrants will not be sampled.

    The DP-ADS-2 variant combines the ADS method with a rotation of the quadrants.
    The idea is to get a possible design point (available e.g. after a
    preliminary FORM analysis) on the bisector of one of the quadrants to make the
    stratification even more efficient and thus save some evaluations of the model.

    This 2-step algorithm can be generalized to :math:`L > 2` steps by adding more
    than one learning step. For now, only ADS-2 is implemented.

    See also
    --------
    Simulation
    """

    __swig_setmethods__ = {}
    for _s in [Simulation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AdaptiveDirectionalSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [Simulation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AdaptiveDirectionalSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.AdaptiveDirectionalSampling_getClassName(self)


    def __repr__(self):
        return _simulation.AdaptiveDirectionalSampling___repr__(self)

    def setRootStrategy(self, rootStrategy):
        """
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_setRootStrategy(self, rootStrategy)


    def getRootStrategy(self):
        """
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_getRootStrategy(self)


    def setSamplingStrategy(self, samplingStrategy):
        """
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_setSamplingStrategy(self, samplingStrategy)


    def getSamplingStrategy(self):
        """
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_getSamplingStrategy(self)


    def setGamma(self, gamma):
        """
        Gamma accessor.

        The computational budget per step :math:`\\gamma_l`.

        Parameters
        ----------
        gamma : sequence of float
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalSampling_setGamma(self, gamma)


    def getGamma(self):
        """
        Gamma accessor.

        The computational budget per step :math:`\\gamma_l`.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalSampling_getGamma(self)


    def setQuadrantOrientation(self, quadrantOrientation):
        """
        Quadrant orientation accessor.

        Parameters
        ----------
        orientation : sequence of float
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalSampling_setQuadrantOrientation(self, quadrantOrientation)


    def getQuadrantOrientation(self):
        """
        Quadrant orientation accessor.

        Returns
        -------
        orientation : :class:`~openturns.Point`
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalSampling_getQuadrantOrientation(self)


    def setPartialStratification(self, partialStratification):
        """
        Partial stratification accessor.

        Parameters
        ----------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalSampling_setPartialStratification(self, partialStratification)


    def getPartialStratification(self):
        """
        Partial stratification accessor.

        Returns
        -------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalSampling_getPartialStratification(self)


    def setMaximumStratificationDimension(self, maximumStratificationDimension):
        """
        Maximum stratification dimension accessor.

        Parameters
        ----------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalSampling_setMaximumStratificationDimension(self, maximumStratificationDimension)


    def getMaximumStratificationDimension(self):
        """
        Maximum stratification dimension accessor.

        Returns
        -------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalSampling_getMaximumStratificationDimension(self)


    def getTStatistic(self):
        """
        T statistic accessor.

        The statistic :math:`\\tilde T_k` aggregates the sensitivity of expectation.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            T statistic value.
        """
        return _simulation.AdaptiveDirectionalSampling_getTStatistic(self)


    def run(self):
        """
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.AdaptiveDirectionalSampling_run(self)


    def __init__(self, *args):
        this = _simulation.new_AdaptiveDirectionalSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_AdaptiveDirectionalSampling
    __del__ = lambda self: None
AdaptiveDirectionalSampling_swigregister = _simulation.AdaptiveDirectionalSampling_swigregister
AdaptiveDirectionalSampling_swigregister(AdaptiveDirectionalSampling)

class RootStrategyImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RootStrategyImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RootStrategyImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _simulation.RootStrategyImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _simulation.RootStrategyImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_simulation.RootStrategyImplementationPointer_ptr__get, _simulation.RootStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _simulation.new_RootStrategyImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_RootStrategyImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _simulation.RootStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation.RootStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _simulation.RootStrategyImplementationPointer___deref__(self)

    def isNull(self):
        return _simulation.RootStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation.RootStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation.RootStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation.RootStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation.RootStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation.RootStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation.RootStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategyImplementationPointer_getClassName(self)


    def solve(self, function, value):
        """
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\\Rset` to :math:`\\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategyImplementationPointer_solve(self, function, value)


    def setSolver(self, solver):
        """
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementationPointer_setSolver(self, solver)


    def getSolver(self):
        """
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementationPointer_getSolver(self)


    def setMaximumDistance(self, maximumDistance):
        """
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_setMaximumDistance(self, maximumDistance)


    def getMaximumDistance(self):
        """
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_getMaximumDistance(self)


    def setStepSize(self, stepSize):
        """
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_setStepSize(self, stepSize)


    def getStepSize(self):
        """
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_getStepSize(self)


    def setOriginValue(self, originValue):
        """
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementationPointer_setOriginValue(self, originValue)


    def getOriginValue(self):
        """
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementationPointer_getOriginValue(self)


    def __repr__(self):
        return _simulation.RootStrategyImplementationPointer___repr__(self)

    def __eq__(self, arg2):
        return _simulation.RootStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _simulation.RootStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation.RootStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _simulation.RootStrategyImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _simulation.RootStrategyImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation.RootStrategyImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _simulation.RootStrategyImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationPointer_setName(self, name)

RootStrategyImplementationPointer_swigregister = _simulation.RootStrategyImplementationPointer_swigregister
RootStrategyImplementationPointer_swigregister(RootStrategyImplementationPointer)

class SamplingStrategyImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplingStrategyImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SamplingStrategyImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _simulation.SamplingStrategyImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _simulation.SamplingStrategyImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_simulation.SamplingStrategyImplementationPointer_ptr__get, _simulation.SamplingStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _simulation.new_SamplingStrategyImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _simulation.SamplingStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation.SamplingStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _simulation.SamplingStrategyImplementationPointer___deref__(self)

    def isNull(self):
        return _simulation.SamplingStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation.SamplingStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation.SamplingStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation.SamplingStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation.SamplingStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation.SamplingStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation.SamplingStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategyImplementationPointer_getClassName(self)


    def generate(self):
        """
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategyImplementationPointer_generate(self)


    def getUniformUnitVectorRealization(self, *args):
        """
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation.SamplingStrategyImplementationPointer_getUniformUnitVectorRealization(self, *args)


    def setDimension(self, dimension):
        """
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementationPointer_setDimension(self, dimension)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementationPointer_getDimension(self)


    def __repr__(self):
        return _simulation.SamplingStrategyImplementationPointer___repr__(self)

    def __eq__(self, arg2):
        return _simulation.SamplingStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _simulation.SamplingStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation.SamplingStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _simulation.SamplingStrategyImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _simulation.SamplingStrategyImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation.SamplingStrategyImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _simulation.SamplingStrategyImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationPointer_setName(self, name)

SamplingStrategyImplementationPointer_swigregister = _simulation.SamplingStrategyImplementationPointer_swigregister
SamplingStrategyImplementationPointer_swigregister(SamplingStrategyImplementationPointer)

# This file is compatible with both classic and new-style classes.


