# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Meta-modelling."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_metamodel')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_metamodel')
    _metamodel = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_metamodel', [dirname(__file__)])
        except ImportError:
            import _metamodel
            return _metamodel
        try:
            _mod = imp.load_module('_metamodel', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _metamodel = swig_import_helper()
    del swig_import_helper
else:
    import _metamodel
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _metamodel.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _metamodel.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _metamodel.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _metamodel.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _metamodel.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _metamodel.SwigPyIterator_equal(self, x)

    def copy(self):
        return _metamodel.SwigPyIterator_copy(self)

    def next(self):
        return _metamodel.SwigPyIterator_next(self)

    def __next__(self):
        return _metamodel.SwigPyIterator___next__(self)

    def previous(self):
        return _metamodel.SwigPyIterator_previous(self)

    def advance(self, n):
        return _metamodel.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _metamodel.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _metamodel.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _metamodel.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _metamodel.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _metamodel.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _metamodel.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _metamodel.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _metamodel.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
class MetaModelResult(openturns.common.PersistentObject):
    """
    Data structure containing a metamodel.

    Available constructor:
        MetaModelResult(model, metaModel, residuals, relativeErrors)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Physical model approximated by a metamodel.
    metaModel : :class:`~openturns.Function`
        Definition of the response surface(s) of the model's output(s).
    residuals : sequence of float
        The residual values defined as follows for each output of the model:
        :math:`\\displaystyle \\frac{\\sqrt{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}}{N}`
        with :math:`y_i` the :math:`N` model's values and :math:`\\hat{y_i}` the
        metamodel's values.
    relativeErrors : sequence of float
        The relative errors defined as follows for each output of the model:
        :math:`\\displaystyle \\frac{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}{N \\Var{\\vect{Y}}}`
        with :math:`\\vect{Y}` the vector of the :math:`N` model's values
        :math:`y_i` and :math:`\\hat{y_i}` the metamodel's values.

    Notes
    -----
    Structure created by the method run() of :class:`~openturns.KrigingAlgorithm`
    or :class:`~openturns.FunctionalChaosAlgorithm` and obtained thanks to the
    method getResult() of these classes.

    See also
    --------
    FunctionalChaosResult
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MetaModelResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MetaModelResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.MetaModelResult_getClassName(self)


    def setModel(self, model):
        """
        Accessor to the model.

        Parameters
        ----------
        model : :class:`~openturns.Function`
            Physical model approximated by a metamodel.
        """
        return _metamodel.MetaModelResult_setModel(self, model)


    def getModel(self):
        """
        Accessor to the model.

        Returns
        -------
        model : :class:`~openturns.Function`
            Physical model approximated by a metamodel.
        """
        return _metamodel.MetaModelResult_getModel(self)


    def setMetaModel(self, metaModel):
        """
        Accessor to the metamodel.

        Parameters
        ----------
        metaModel : :class:`~openturns.Function`
            Metamodel.
        """
        return _metamodel.MetaModelResult_setMetaModel(self, metaModel)


    def getMetaModel(self):
        """
        Accessor to the metamodel.

        Returns
        -------
        metaModel : :class:`~openturns.Function`
            Metamodel.
        """
        return _metamodel.MetaModelResult_getMetaModel(self)


    def setResiduals(self, residuals):
        """
        Accessor to the residuals.

        Parameters
        ----------
        residuals : sequence of float
            The residual values defined as follows for each output of the model:
            :math:`\\displaystyle \\frac{\\sqrt{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}}{N}`
            with :math:`y_i` the :math:`N` model's values and :math:`\\hat{y_i}` the
            metamodel's values.
        """
        return _metamodel.MetaModelResult_setResiduals(self, residuals)


    def getResiduals(self):
        """
        Accessor to the residuals.

        Returns
        -------
        residuals : :class:`~openturns.Point`
            The residual values defined as follows for each output of the model:
            :math:`\\displaystyle \\frac{\\sqrt{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}}{N}`
            with :math:`y_i` the :math:`N` model's values and :math:`\\hat{y_i}` the
            metamodel's values.
        """
        return _metamodel.MetaModelResult_getResiduals(self)


    def setRelativeErrors(self, relativeErrors):
        """
        Accessor to the relative errors.

        Parameters
        ----------
        relativeErrors : sequence of float
            The relative errors defined as follows for each output of the model:
            :math:`\\displaystyle \\frac{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}{N \\Var{\\vect{Y}}}`
            with :math:`\\vect{Y}` the vector of the :math:`N` model's values
            :math:`y_i` and :math:`\\hat{y_i}` the metamodel's values.
        """
        return _metamodel.MetaModelResult_setRelativeErrors(self, relativeErrors)


    def getRelativeErrors(self):
        """
        Accessor to the relative errors.

        Returns
        -------
        relativeErrors : :class:`~openturns.Point`
            The relative errors  defined as follows for each output of the model:
            :math:`\\displaystyle \\frac{\\sum_{i=1}^N (y_i - \\hat{y_i})^2}{N \\Var{\\vect{Y}}}`
            with :math:`\\vect{Y}` the vector of the :math:`N` model's values
            :math:`y_i` and :math:`\\hat{y_i}` the metamodel's values.
        """
        return _metamodel.MetaModelResult_getRelativeErrors(self)


    def __repr__(self):
        return _metamodel.MetaModelResult___repr__(self)

    def __init__(self, *args):
        this = _metamodel.new_MetaModelResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_MetaModelResult
    __del__ = lambda self: None
MetaModelResult_swigregister = _metamodel.MetaModelResult_swigregister
MetaModelResult_swigregister(MetaModelResult)

class KrigingResult(MetaModelResult):
    """
    Kriging result.

    Available constructors:
        KrigingResult(*inputSample, outputSample, metaModel, residuals, relativeErrors, basis, trendCoefficients, covarianceModel, covarianceCoefficients*)

        KrigingResult(*inputSample, outputSample, metaModel, residuals, relativeErrors, basis, trendCoefficients, covarianceModel, covarianceCoefficients, covarianceCholeskyFactor, covarianceHMatrix*)


    Parameters
    ----------
    inputSample, outputSample : 2-d sequence of float
        The samples :math:`(\\vect{x}_k)_{1 \\leq k \\leq N} \\in \\Rset^d` and :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}\\in \\Rset^p`.
    metaModel : :class:`~openturns.Function`
        The meta model: :math:`\\tilde{\\cM}: \\Rset^d \\rightarrow \\Rset^p`, defined in :eq:`metaModelKrigFinal`.
    residuals : :class:`~openturns.Point`
        The residual errors.
    relativeErrors : :class:`~openturns.Point`
        The relative errors.
    basis : collection of :class:`~openturns.Basis`
        Collection of the  :math:`p` functional basis: :math:`(\\varphi_j^l)_{1 \\leq j \\leq n_l}` for each :math:`l \\in [1, p]` with :math:`\\varphi_j^l: \\Rset^d \\rightarrow \\Rset`.
        Its size must be equal to zero if the trend is not estimated.
    trendCoefficients : collection of :class:`~openturns.Point`
       The trend coeffient vectors :math:`(\\vect{\\alpha}^1, \\dots, \\vect{\\alpha}^p)`.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Covariance function of the normal process.
    covarianceCoefficients : 2-d sequence of float
        The :math:`\\vect{\\gamma}` defined in :eq:`gammaEq`.
    covarianceCholeskyFactor : :class:`~openturns.TriangularMatrix`
        The Cholesky factor :math:`\\mat{L}` of :math:`\\mat{C}`.
    covarianceHMatrix :  :class:`~openturns.HMatrix`
        The *hmat* implementation of :math:`\\mat{L}`.


    Notes
    -----
    The Kriging meta model :math:`\\tilde{\\cM}` is defined by:

    .. math::
        :label: metaModelKrig

        \\tilde{\\cM}(\\vect{x}) =  \\vect{\\mu}(\\vect{x}) + \\Expect{\\vect{Y}(\\omega, \\vect{x})\\,| \\,\\cC}

    where :math:`\\cC` is the condition :math:`\\vect{Y}(\\omega, \\vect{x}_k) = \\vect{y}_k` for each :math:`k \\in [1, N]`.

    Equation :eq:`metaModelKrig` writes:

    .. math::

        \\tilde{\\cM}(\\vect{x}) = \\vect{\\mu}(\\vect{x}) + \\Cov{\\vect{Y}(\\omega, \\vect{x}), (\\vect{Y}(\\omega,\\vect{x}_1),\\dots,\\vect{Y}(\\omega, \\vect{x}_N))}\\vect{\\gamma}

    where 

    .. math::

        \\Cov{\\vect{Y}(\\omega, \\vect{x}), (\\vect{Y}(\\omega, \\vect{x}_1),\\dots,\\vect{Y}(\\omega, \\vect{x}_N))} = \\left(\\mat{C}(\\vect{x},\\vect{x}_1)|\\dots|\\mat{C}(\\vect{x},\\vect{x}_N)\\right)\\in \\cM_{p,NP}(\\Rset)

    and 

    .. math::
        :label: gammaEq

        \\vect{\\gamma} = \\mat{C}^{-1}(\\vect{y}-\\vect{m})

    At the end, the meta model writes:

    .. math::
        :label: metaModelKrigFinal

        \\tilde{\\cM}(\\vect{x}) = \\vect{\\mu}(\\vect{x}) + \\sum_{i=1}^N \\gamma_i  \\mat{C}(\\vect{x},\\vect{x}_i)




    Examples
    --------
    Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0]]
    >>> sampleY = f(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.GeneralizedExponential([2.0], 2.0)
    >>> algoKriging = ot.KrigingAlgorithm(sampleX, sampleY, covarianceModel, basis)
    >>> algoKriging.run()

    Get the result:

    >>> resKriging = algoKriging.getResult()

    Get the meta model:

    >>> metaModel = resKriging.getMetaModel()

    """

    __swig_setmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KrigingResult, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KrigingResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.KrigingResult_getClassName(self)


    def __repr__(self):
        return _metamodel.KrigingResult___repr__(self)

    def __str__(self, *args):
        return _metamodel.KrigingResult___str__(self, *args)

    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _metamodel.KrigingResult_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _metamodel.KrigingResult_getOutputSample(self)


    def getBasisCollection(self):
        """
        Accessor to the collection of basis.

        Returns
        -------
        basisCollection : collection of :class:`~openturns.Basis`
            Collection of the :math:`p` function basis: :math:`(\\varphi_j^l)_{1 \\leq j \\leq n_l}` for each :math:`l \\in [1, p]` with :math:`\\varphi_j^l: \\Rset^d \\rightarrow \\Rset`.

        Notes
        -----
        If the trend is not estimated, the collection is empty. 

        """
        return _metamodel.KrigingResult_getBasisCollection(self)


    def getTrendCoefficients(self):
        """
        Accessor to the trend coefficients.

        Returns
        -------
        trendCoef : collection of :class:`~openturns.Point`
            The trend coefficients vectors :math:`(\\vect{\\alpha}^1, \\dots, \\vect{\\alpha}^p)`

        """
        return _metamodel.KrigingResult_getTrendCoefficients(self)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model of the Normal process *W* with its optimized parameters.

        """
        return _metamodel.KrigingResult_getCovarianceModel(self)


    def getCovarianceCoefficients(self):
        """
        Accessor to the covariance coefficients.

        Returns
        -------
        covCoeff : :class:`~openturns.Sample`
            The :math:`\\vect{\\gamma}` defined in :eq:`gammaEq`.

        """
        return _metamodel.KrigingResult_getCovarianceCoefficients(self)


    def getTransformation(self):
        """
        Accessor to the normalizing transformation.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The transformation *T* that normalizes the input sample.
        """
        return _metamodel.KrigingResult_getTransformation(self)


    def setTransformation(self, transformation):
        """
        Accessor to the normalizing transformation.

        Parameters
        ----------
        transformation : :class:`~openturns.Function`
            The transformation *T* that normalizes the input sample.
        """
        return _metamodel.KrigingResult_setTransformation(self, transformation)


    def getConditionalMean(self, *args):
        """
        Compute the expected mean of the Gaussian process on a point or a sample of points.

        Available usages:
            getConditionalMean(x)

            getConditionalMean(sampleX)

        Parameters
        ----------
        x : sequence of float
            The point :math:`\\vect{x}` where the conditional mean of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\\vect{\\xi}_1, \\dots, \\vect{\\xi}_M)` where the conditional mean of the output has to be evaluated (*M* can be equal to 1).

        Returns
        -------
        condMean : :class:`~openturns.Point`
            The conditional mean :math:`\\Expect{\\vect{Y}(\\omega, \\vect{x})\\, | \\,  \\cC}` at point :math:`\\vect{x}`.

            Or the conditional mean matrix at the sample :math:`(\\vect{\\xi}_1, \\dots, \\vect{\\xi}_M)`:

        .. math::

            \\left(
              \\begin{array}{l}
                 \\Expect{\\vect{Y}(\\omega, \\vect{\\xi}_1)\\, | \\,  \\cC}\\\\
                \\dots  \\\\
                \\Expect{\\vect{Y}(\\omega, \\vect{\\xi}_M)\\, | \\,  \\cC}
               \\end{array}
             \\right)


        """
        return _metamodel.KrigingResult_getConditionalMean(self, *args)


    def getConditionalCovariance(self, *args):
        """
        Compute the expected covariance of the Gaussian process on a point (or several points).

        Available usages:
            getConditionalCovariance(x)

            getConditionalCovariance(sampleX)

        Parameters
        ----------
        x : sequence of float
            The point :math:`\\vect{x}` where the conditional mean of the output has to be evaluated.
        sampleX : 2-d sequence of float
             The sample :math:`(\\vect{\\xi}_1, \\dots, \\vect{\\xi}_M)` where the conditional mean of the output has to be evaluated (*M* can be equal to 1).

        Returns
        -------
        condCov : :class:`~openturns.CovarianceMatrix`
            The conditional covariance :math:`\\Cov{\\vect{Y}(\\omega, \\vect{x})\\, | \\,  \\cC}` at point :math:`\\vect{x}`.

            Or the conditional covariance matrix at the sample :math:`(\\vect{\\xi}_1, \\dots, \\vect{\\xi}_M)`:

        .. math::

            \\left(
              \\begin{array}{lcl}
                 \\Sigma_{11} & \\dots & \\Sigma_{1M} \\\\
                \\dots  \\\\
                \\Sigma_{M1} & \\dots & \\Sigma_{MM}
               \\end{array}
             \\right)

        where :math:`\\Sigma_{ij} = \\Cov{\\vect{Y}(\\omega, \\vect{\\xi}_i), \\vect{Y}(\\omega, \\vect{\\xi}_j)\\, | \\,  \\cC}`.

        """
        return _metamodel.KrigingResult_getConditionalCovariance(self, *args)


    def __call__(self, *args):
        return _metamodel.KrigingResult___call__(self, *args)

    def __init__(self, *args):
        this = _metamodel.new_KrigingResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_KrigingResult
    __del__ = lambda self: None
KrigingResult_swigregister = _metamodel.KrigingResult_swigregister
KrigingResult_swigregister(KrigingResult)

class MetaModelAlgorithm(openturns.common.PersistentObject):
    """
    Base class to compute a metamodel.

    Available constructor:
        MetaModelAlgorithm(*distribution, model*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Joint probability density function of the physical input vector.
    model : :class:`~openturns.Function`
        Physical model to be approximated by a metamodel.

    Notes
    -----
    A MetaModelAlgorithm object can be used only through its derived classes:

    - :class:`~openturns.KrigingAlgorithm`

    - :class:`~openturns.FunctionalChaosAlgorithm`
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MetaModelAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MetaModelAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.MetaModelAlgorithm_getClassName(self)


    def __repr__(self):
        return _metamodel.MetaModelAlgorithm___repr__(self)

    def setDistribution(self, distribution):
        """
        Accessor to the joint probability density function of the physical input vector.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Joint probability density function of the physical input vector.
        """
        return _metamodel.MetaModelAlgorithm_setDistribution(self, distribution)


    def getDistribution(self):
        """
        Accessor to the joint probability density function of the physical input vector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Joint probability density function of the physical input vector.
        """
        return _metamodel.MetaModelAlgorithm_getDistribution(self)


    def run(self):
        """
        Compute the response surfaces.

        Notes
        -----
        It computes the response surfaces and creates a
        :class:`~openturns.MetaModelResult` structure containing all the results.
        """
        return _metamodel.MetaModelAlgorithm_run(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample of a model evaluated apart.
        """
        return _metamodel.MetaModelAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample of a model evaluated apart.
        """
        return _metamodel.MetaModelAlgorithm_getOutputSample(self)


    def __init__(self, *args):
        this = _metamodel.new_MetaModelAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_MetaModelAlgorithm
    __del__ = lambda self: None
MetaModelAlgorithm_swigregister = _metamodel.MetaModelAlgorithm_swigregister
MetaModelAlgorithm_swigregister(MetaModelAlgorithm)

class LinearTaylor(openturns.common.PersistentObject):
    """
    First order polynomial response surface by Taylor expansion.

    Available constructors:
        LinearTaylor(*center, function*)

    Parameters
    ----------
    center : sequence of float
        Point :math:`\\vect{x}_0` where the Taylor expansion of the function
        :math:`h` is performed.
    function : :class:`~openturns.Function`
        Function :math:`h` to be approximated.

    Notes
    -----
    The approximation of the model response :math:`\\vect{y} = h(\\vect{x})` around a
    specific set :math:`\\vect{x}_0 = (x_{0,1},\\dots,x_{0,n_{X}})` of input
    parameters may be of interest. One may then substitute :math:`h` for its Taylor
    expansion at point :math:`\\vect{x}_0`. Hence :math:`h` is replaced with a first
    or second-order polynomial :math:`\\widehat{h}` whose evaluation is inexpensive,
    allowing the analyst to apply the uncertainty anaysis methods.

    We consider here the first order Taylor expansion around :math:`\\ux=\\vect{x}_0`.

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\,
          = \\, h(\\vect{x}_0) \\, +
            \\, \\sum_{i=1}^{n_{X}} \\; \\frac{\\partial h}{\\partial x_i}(\\vect{x}_0).\\left(x_i - x_{0,i} \\right)

    Introducing a vector notation, the previous equation rewrites:

    .. math::

        \\vect{y} \\, \\approx \\, \\vect{y}_0 \\, + \\, \\vect{\\vect{L}} \\: \\left(\\vect{x}-\\vect{x}_0\\right)

    where:

    - :math:`\\vect{y_0} = (y_{0,1} , \\dots, y_{0,n_Y})^{\\textsf{T}} = h(\\vect{x}_0)`
      is the vector model response evaluated at :math:`\\vect{x}_0`;
    - :math:`\\vect{x}` is the current set of input parameters;
    - :math:`\\vect{\\vect{L}} = \\left( \\frac{\\partial y_{0,j}}{\\partial x_i} \\,,\\, i=1,\\ldots, n_X \\,,\\, j=1,\\ldots, n_Y \\right)`
      is the transposed Jacobian matrix evaluated at :math:`\\vect{x}_0`.

    See also
    --------
    QuadraticTaylor, LinearLeastSquares, QuadraticLeastSquares

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
    >>> myTaylor = ot.LinearTaylor([1, 2], myFunc)
    >>> myTaylor.run()
    >>> responseSurface = myTaylor.getResponseSurface()
    >>> print(responseSurface([1.2,1.9]))
    [1.13277,-1.0041,0.204127]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearTaylor, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearTaylor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.LinearTaylor_getClassName(self)


    def __repr__(self):
        return _metamodel.LinearTaylor___repr__(self)

    def run(self):
        """Perform the Linear Taylor expansion around :math:`\\vect{x}_0`."""
        return _metamodel.LinearTaylor_run(self)


    def getCenter(self):
        """
        Get the center.

        Returns
        -------
        center : :class:`~openturns.Point`
            Point :math:`\\vect{x}_0` where the Taylor expansion of the function is
            performed.
        """
        return _metamodel.LinearTaylor_getCenter(self)


    def getConstant(self):
        """
        Get the constant vector of the approximation.

        Returns
        -------
        constantVector : :class:`~openturns.Point`
            Constant vector of the approximation, equal to :math:`h(x_0)`.
        """
        return _metamodel.LinearTaylor_getConstant(self)


    def getLinear(self):
        """
        Get the gradient of the function at :math:`\\vect{x}_0`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function :math:`h` at the point :math:`\\vect{x}_0` (the
            transposition of the jacobian matrix).
        """
        return _metamodel.LinearTaylor_getLinear(self)


    def getInputFunction(self):
        """
        Get the function.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function :math:`h` to be approximated.
        """
        return _metamodel.LinearTaylor_getInputFunction(self)


    def getResponseSurface(self):
        """
        Get an approximation of the function.

        Returns
        -------
        approximation : :class:`~openturns.Function`
            An approximation of the function :math:`h` by a Linear Taylor expansion at
            the point :math:`\\vect{x}_0`.
        """
        return _metamodel.LinearTaylor_getResponseSurface(self)


    def __init__(self, *args):
        this = _metamodel.new_LinearTaylor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_LinearTaylor
    __del__ = lambda self: None
LinearTaylor_swigregister = _metamodel.LinearTaylor_swigregister
LinearTaylor_swigregister(LinearTaylor)

class QuadraticTaylor(openturns.common.PersistentObject):
    """
    Second order polynomial response surface by Taylor expansion.

    Available constructors:
        QuadraticTaylor(*center, function*)

    Parameters
    ----------
    center : sequence of float
        Point :math:`\\vect{x}_0` where the Taylor expansion of the function
        :math:`h` is performed.
    function : :class:`~openturns.Function`
        Function :math:`h` to be approximated.

    Notes
    -----
    The approximation of the model response :math:`\\vect{y} = h(\\vect{x})` around a
    specific set :math:`\\vect{x}_0 = (x_{0,1},\\dots,x_{0,n_{X}})` of input
    parameters may be of interest. One may then substitute :math:`h` for its Taylor
    expansion at point :math:`\\vect{x}_0`. Hence :math:`h` is replaced with a first
    or second-order polynomial :math:`\\widehat{h}` whose evaluation is inexpensive,
    allowing the analyst to apply the uncertainty anaysis methods.

    We consider here the second order Taylor expansion around :math:`\\ux=\\vect{x}_0`.

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\, = \\,
         h(\\vect{x}_0) \\, + \\, \\sum_{i=1}^{n_{X}} \\;
          \\frac{\\partial h}{\\partial x_i}(\\vect{x}_0).\\left(x_i - x_{0,i} \\right) \\, +
         \\, \\frac{1}{2} \\; \\sum_{i,j=1}^{n_X} \\;
          \\frac{\\partial^2 h}{\\partial x_i \\partial x_j}(\\vect{x}_0).\\left(x_i - x_{0,i} \\right).\\left(x_j - x_{0,j} \\right)

    Introducing a vector notation, the previous equation rewrites:

    .. math::

        \\vect{y} \\, \\approx \\,
         \\vect{y}_0 \\, +
         \\, \\vect{\\vect{L}} \\: \\left(\\vect{x}-\\vect{x}_0\\right) \\, +
         \\, \\frac{1}{2} \\; \\left\\langle \\left\\langle\\vect{\\vect{\\vect{Q}}}\\:,
                                                          \\vect{x}-\\vect{x}_0 \\right\\rangle,
                                                    \\:\\vect{x}-\\vect{x}_0 \\right\\rangle

    where

    - :math:`\\vect{y_0} = (y_{0,1} , \\dots, y_{0,n_Y})^{\\textsf{T}} = h(\\vect{x}_0)`
      is the vector model response evaluated at :math:`\\vect{x}_0` ;
    - :math:`\\vect{x}` is the current set of input parameters ;
    - :math:`\\vect{\\vect{L}} = \\left( \\frac{\\partial y_{0,j}}{\\partial x_i} \\,,\\, i=1,\\ldots, n_X \\,,\\, j=1,\\ldots, n_Y \\right)`
      is the transposed Jacobian matrix evaluated at :math:`\\vect{x}_0` ;
    - :math:`\\vect{\\vect{Q}} = \\left\\{ \\frac{\\partial^2 y_{0,k}}{\\partial x_i \\partial x_j} \\, \\, , \\, \\, i,j=1,\\ldots, n_X \\, \\, , \\, \\, k=1, \\ldots, n_Y \\right\\}`
      is the transposed Hessian matrix.

    See also
    --------
    LinearTaylor, LinearLeastSquares, QuadraticLeastSquares

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
    >>> myTaylor = ot.QuadraticTaylor([1, 2], myFunc)
    >>> myTaylor.run()
    >>> responseSurface = myTaylor.getResponseSurface()
    >>> print(responseSurface([1.2,1.9]))
    [1.13655,-0.999155,0.214084]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticTaylor, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticTaylor, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.QuadraticTaylor_getClassName(self)


    def __repr__(self):
        return _metamodel.QuadraticTaylor___repr__(self)

    def run(self):
        """Perform the Quadratic Taylor expansion around :math:`\\vect{x}_0`."""
        return _metamodel.QuadraticTaylor_run(self)


    def getCenter(self):
        """
        Get the center.

        Returns
        -------
        center : :class:`~openturns.Point`
            Point :math:`\\vect{x}_0` where the Taylor expansion of the function is
            performed.
        """
        return _metamodel.QuadraticTaylor_getCenter(self)


    def getConstant(self):
        """
        Get the constant vector of the approximation.

        Returns
        -------
        constantVector : :class:`~openturns.Point`
            Constant vector of the approximation, equal to :math:`h(x_0)`.
        """
        return _metamodel.QuadraticTaylor_getConstant(self)


    def getLinear(self):
        """
        Get the gradient of the function at :math:`\\vect{x}_0`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function :math:`h` at the point :math:`\\vect{x}_0` (the
            transposition of the jacobian matrix).
        """
        return _metamodel.QuadraticTaylor_getLinear(self)


    def getQuadratic(self):
        """
        Get the hessian of the function at :math:`\\vect{x}_0`.

        Returns
        -------
        tensor : :class:`~openturns.SymmetricTensor`
            Hessian of the function :math:`h` at the point :math:`\\vect{x}_0`.
        """
        return _metamodel.QuadraticTaylor_getQuadratic(self)


    def getInputFunction(self):
        """
        Get the function.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function :math:`h` to be approximated.
        """
        return _metamodel.QuadraticTaylor_getInputFunction(self)


    def getResponseSurface(self):
        """
        Get an approximation of the function.

        Returns
        -------
        approximation : :class:`~openturns.Function`
            An approximation of the function :math:`h` by a Quadratic Taylor expansion
            at the point :math:`\\vect{x}_0`.
        """
        return _metamodel.QuadraticTaylor_getResponseSurface(self)


    def __init__(self, *args):
        this = _metamodel.new_QuadraticTaylor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_QuadraticTaylor
    __del__ = lambda self: None
QuadraticTaylor_swigregister = _metamodel.QuadraticTaylor_swigregister
QuadraticTaylor_swigregister(QuadraticTaylor)

class LinearLeastSquares(openturns.common.PersistentObject):
    """
    First order polynomial response surface by least squares.

    Available constructors:
        LinearLeastSquares(*dataIn, function*)

        LinearLeastSquares(*dataIn, dataOut*)

    Parameters
    ----------
    dataIn : 2-d sequence of float
        Input data.
    function : :class:`~openturns.Function`
        Function :math:`h` to be approximated.
    dataOut : 2-d sequence of float
        Output data. If not specified, this sample is computed such as:
        :math:`dataOut = h(dataIn)`.

    Notes
    -----
    Instead of replacing the model response :math:`h(\\vect{x})` for a *local*
    approximation around a given set :math:`\\vect{x}_0` of input parameters as in
    Taylor approximations, one may seek a *global* approximation of
    :math:`h(\\vect{x})` over its whole domain of definition. A common choice to
    this end is global polynomial approximation.

    We consider here a global approximation of the model response using  a linear
    function:

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\,
                          = \\, \\sum_{j=0}^{n_X} \\; a_j \\; \\psi_j(\\vect{x})

    where :math:`(a_j  \\, , \\, j=0, \\cdots,n_X)` is a set of unknown coefficients
    and the family :math:`(\\psi_j,j=0,\\cdots, n_X)` gathers the constant monomial
    :math:`1` and the monomials of degree one :math:`x_i`. Using the vector
    notation :math:`\\vect{a} \\, = \\, (a_{0} , \\cdots , a_{n_X} )^{\\textsf{T}}` and
    :math:`\\vect{\\psi}(\\vect{x}) \\, = \\, (\\psi_0(\\vect{x}), \\cdots, \\psi_{n_X}(\\vect{x}) )^{\\textsf{T}}`,
    this rewrites:

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\,
                          = \\, \\vect{a}^{\\textsf{T}} \\; \\vect{\\psi}(\\vect{x})

    A *global* approximation of the model response over its whole definition domain
    is sought. To this end, the coefficients :math:`a_j` may be computed using a
    least squares regression approach. In this context, an experimental design
    :math:`\\vect{\\cX} =(x^{(1)},\\cdots,x^{(N)})`, i.e. a set of realizations of
    input parameters is required, as well as the corresponding model evaluations
    :math:`\\vect{\\cY} =(y^{(1)},\\cdots,y^{(N)})`.

    The following minimization problem has to be solved:

    .. math::

        \\mbox{Find} \\quad \\widehat{\\vect{a}} \\quad \\mbox{that minimizes}
          \\quad \\cJ(\\vect{a}) \\, = \\, \\sum_{i=1}^N \\;
                                    \\left(
                                    y^{(i)} \\; - \\;
                                    \\vect{a}^{\\textsf{T}} \\vect{\\psi}(\\vect{x}^{(i)})
                                    \\right)^2

    The solution is given by:

    .. math::

        \\widehat{\\vect{a}} \\, = \\, \\left(
                                   \\vect{\\vect{\\Psi}}^{\\textsf{T}} \\vect{\\vect{\\Psi}}
                                   \\right)^{-1} \\;
                                   \\vect{\\vect{\\Psi}}^{\\textsf{T}}  \\; \\vect{\\cY}

    where:

    .. math::

        \\vect{\\vect{\\Psi}} \\, = \\, (\\psi_{j}(\\vect{x}^{(i)}) \\; , \\; i=1,\\cdots,N \\; , \\; j = 0,\\cdots,n_X)

    See also
    --------
    QuadraticLeastSquares, LinearTaylor, QuadraticTaylor

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
    >>> data  = [[0.5,0.5], [-0.5,-0.5], [-0.5,0.5], [0.5,-0.5]]
    >>> data += [[0.25,0.25], [-0.25,-0.25], [-0.25,0.25], [0.25,-0.25]]
    >>> myLeastSquares = ot.LinearLeastSquares(data, myFunc)
    >>> myLeastSquares.run()
    >>> responseSurface = myLeastSquares.getResponseSurface()
    >>> print(responseSurface([0.1,0.1]))
    [0.854471,1.06031]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearLeastSquares, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearLeastSquares, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.LinearLeastSquares_getClassName(self)


    def __repr__(self):
        return _metamodel.LinearLeastSquares___repr__(self)

    def run(self):
        """Perform the least squares approximation."""
        return _metamodel.LinearLeastSquares_run(self)


    def getConstant(self):
        """
        Get the constant vector of the approximation.

        Returns
        -------
        constantVector : :class:`~openturns.Point`
            Constant vector of the approximation, equal to :math:`a_0`.
        """
        return _metamodel.LinearLeastSquares_getConstant(self)


    def getLinear(self):
        """
        Get the linear matrix of the approximation.

        Returns
        -------
        linearMatrix : :class:`~openturns.Matrix`
            Linear matrix of the approximation of the function :math:`h`.
        """
        return _metamodel.LinearLeastSquares_getLinear(self)


    def getInputFunction(self):
        """
        Get the function.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function :math:`h` to be approximated.
        """
        return _metamodel.LinearLeastSquares_getInputFunction(self)


    def getResponseSurface(self):
        """
        Get an approximation of the function.

        Returns
        -------
        approximation : :class:`~openturns.Function`
            An approximation of the function :math:`h` by Linear Least Squares.
        """
        return _metamodel.LinearLeastSquares_getResponseSurface(self)


    def getDataIn(self):
        """
        Get the input data.

        Returns
        -------
        dataIn : :class:`~openturns.Sample`
            Input data.
        """
        return _metamodel.LinearLeastSquares_getDataIn(self)


    def setDataOut(self, dataOut):
        """
        Set the output data.

        Parameters
        ----------
        dataOut : 2-d sequence of float
            Output data.
        """
        return _metamodel.LinearLeastSquares_setDataOut(self, dataOut)


    def getDataOut(self):
        """
        Get the output data.

        Returns
        -------
        dataOut : :class:`~openturns.Sample`
            Output data. If not specified in the constructor, the sample is computed
            such as: :math:`dataOut = h(dataIn)`.
        """
        return _metamodel.LinearLeastSquares_getDataOut(self)


    def __init__(self, *args):
        this = _metamodel.new_LinearLeastSquares(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_LinearLeastSquares
    __del__ = lambda self: None
LinearLeastSquares_swigregister = _metamodel.LinearLeastSquares_swigregister
LinearLeastSquares_swigregister(LinearLeastSquares)

class QuadraticLeastSquares(openturns.common.PersistentObject):
    """
    Second order polynomial response surface by least squares.

    Available constructors:
        QuadraticLeastSquares(*dataIn, function*)

        QuadraticLeastSquares(*dataIn, dataOut*)

    Parameters
    ----------
    dataIn : 2-d sequence of float
        Input data.
    function : :class:`~openturns.Function`
        Function :math:`h` to be approximated.
    dataOut : 2-d sequence of float
        Output data. If not specified, this sample is computed such as:
        :math:`dataOut = h(dataIn)`.

    Notes
    -----
    Instead of replacing the model response :math:`h(\\vect{x})` for a *local*
    approximation around a given set :math:`\\vect{x}_0` of input parameters as in
    Taylor approximations, one may seek a *global* approximation of
    :math:`h(\\vect{x})` over its whole domain of definition. A common choice to
    this end is global polynomial approximation.

    We consider here a global approximation of the model response using  a
    quadratic function:

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\,
                          = \\, \\sum_{j=0}^{P-1} \\; a_j \\; \\psi_j(\\vect{x})

    where :math:`P = 1+2n_X +n_X (n_X -1)/2` denotes the number of terms,
    :math:`(a_j  \\, , \\, j=0, \\cdots,P-1)` is a set of unknown coefficients and the
    family :math:`(\\psi_j,j=0,\\cdots, P-1)` gathers the constant monomial :math:`1`,
    the monomials of degree one :math:`x_i`, the cross-terms :math:`x_i x_j` as
    well as the monomials of degree two :math:`x_i^2`. Using the vector notation
    :math:`\\vect{a} \\, = \\, (a_{0} , \\cdots , a_{P-1} )^{\\textsf{T}}` and
    :math:`\\vect{\\psi}(\\vect{x}) \\, = \\, (\\psi_0(\\vect{x}), \\cdots, \\psi_{P-1}(\\vect{x}) )^{\\textsf{T}}`,
    this rewrites:

    .. math::

        \\vect{y} \\, \\approx \\, \\widehat{h}(\\vect{x}) \\,
                          = \\, \\vect{a}^{\\textsf{T}} \\; \\vect{\\psi}(\\vect{x})

    A *global* approximation of the model response over its whole definition domain
    is sought. To this end, the coefficients :math:`a_j` may be computed using a
    least squares regression approach. In this context, an experimental design
    :math:`\\vect{\\cX} =(x^{(1)},\\cdots,x^{(N)})`, i.e. a set of realizations of
    input parameters is required, as well as the corresponding model evaluations
    :math:`\\vect{\\cY} =(y^{(1)},\\cdots,y^{(N)})`.

    The following minimization problem has to be solved:

    .. math::

        \\mbox{Find} \\quad \\widehat{\\vect{a}} \\quad \\mbox{that minimizes}
          \\quad \\cJ(\\vect{a}) \\, = \\, \\sum_{i=1}^N \\;
                                    \\left(
                                    y^{(i)} \\; - \\;
                                    \\Tr{\\vect{a}} \\vect{\\psi}(\\vect{x}^{(i)})
                                    \\right)^2

    The solution is given by:

    .. math::

        \\widehat{\\vect{a}} \\, = \\, \\left(
                                   \\Tr{\\mat{\\Psi}} \\mat{\\Psi}
                                   \\right)^{-1} \\;
                                   \\Tr{\\mat{\\Psi}}  \\; \\vect{\\cY}

    where:

    .. math::

        \\mat{\\Psi} \\, = \\, (\\psi_{j}(\\vect{x}^{(i)}) \\; , \\; i=1,\\cdots,N \\; , \\; j = 0,\\cdots,n_X)

    See also
    --------
    LinearLeastSquares, LinearTaylor, QuadraticTaylor

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.SymbolicFunction(['x1', 'x2'], formulas)
    >>> data  = [[0.5,0.5], [-0.5,-0.5], [-0.5,0.5], [0.5,-0.5]]
    >>> data += [[0.25,0.25], [-0.25,-0.25], [-0.25,0.25], [0.25,-0.25]]
    >>> myLeastSquares = ot.QuadraticLeastSquares(data, myFunc)
    >>> myLeastSquares.run()
    >>> responseSurface = myLeastSquares.getResponseSurface()
    >>> print(responseSurface([0.1,0.1]))
    [0.00960661,0.976781,1.0138]
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticLeastSquares, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticLeastSquares, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.QuadraticLeastSquares_getClassName(self)


    def __repr__(self):
        return _metamodel.QuadraticLeastSquares___repr__(self)

    def run(self):
        """Perform the least squares approximation."""
        return _metamodel.QuadraticLeastSquares_run(self)


    def getConstant(self):
        """
        Get the constant vector of the approximation.

        Returns
        -------
        constantVector : :class:`~openturns.Point`
            Constant vector of the approximation, equal to :math:`a_0`.
        """
        return _metamodel.QuadraticLeastSquares_getConstant(self)


    def getLinear(self):
        """
        Get the linear matrix of the approximation.

        Returns
        -------
        linearMatrix : :class:`~openturns.Matrix`
            Linear matrix of the approximation of the function :math:`h`.
        """
        return _metamodel.QuadraticLeastSquares_getLinear(self)


    def getQuadratic(self):
        """
        Get the quadratic term of the approximation.

        Returns
        -------
        tensor : :class:`~openturns.SymmetricTensor`
            Quadratic term of the approximation of the function :math:`h`.
        """
        return _metamodel.QuadraticLeastSquares_getQuadratic(self)


    def getInputFunction(self):
        """
        Get the function.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function :math:`h` to be approximated.
        """
        return _metamodel.QuadraticLeastSquares_getInputFunction(self)


    def getResponseSurface(self):
        """
        Get an approximation of the function.

        Returns
        -------
        approximation : :class:`~openturns.Function`
            An approximation of the function :math:`h` by Quadratic Least Squares.
        """
        return _metamodel.QuadraticLeastSquares_getResponseSurface(self)


    def getDataIn(self):
        """
        Get the input data.

        Returns
        -------
        dataIn : :class:`~openturns.Sample`
            Input data.
        """
        return _metamodel.QuadraticLeastSquares_getDataIn(self)


    def setDataOut(self, dataOut):
        """
        Set the output data.

        Parameters
        ----------
        dataOut : 2-d sequence of float
            Output data.
        """
        return _metamodel.QuadraticLeastSquares_setDataOut(self, dataOut)


    def getDataOut(self):
        """
        Get the output data.

        Returns
        -------
        dataOut : :class:`~openturns.Sample`
            Output data. If not specified in the constructor, the sample is computed
            such as: :math:`dataOut = h(dataIn)`.
        """
        return _metamodel.QuadraticLeastSquares_getDataOut(self)


    def __init__(self, *args):
        this = _metamodel.new_QuadraticLeastSquares(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_QuadraticLeastSquares
    __del__ = lambda self: None
QuadraticLeastSquares_swigregister = _metamodel.QuadraticLeastSquares_swigregister
QuadraticLeastSquares_swigregister(QuadraticLeastSquares)

class AdaptiveStrategyImplementation(openturns.common.PersistentObject):
    """
    Base class for the construction of the truncated multivariate orthogonal basis.

    Available constructors:
        AdaptiveStrategy(*orthogonalBasis, dimension*)

        AdaptiveStrategy(*adaptiveStrategyImplementation*)

    Parameters
    ----------
    orthogonalBasis : :class:`~openturns.OrthogonalBasis`
        An OrthogonalBasis.
    dimension : positive int
        Number of terms of the basis. This first usage has the same implementation
        as the second with a :class:`~openturns.FixedStrategy`. 
    adaptiveStrategyImplementation : AdaptiveStrategyImplementation
        Adaptive strategy implementation which is a :class:`~openturns.FixedStrategy`, 
        :class:`~openturns.SequentialStrategy` or a :class:`~openturns.CleaningStrategy`.

    See also
    --------
    FunctionalChaosAlgorithm, FixedStrategy, SequentialStrategy, CleaningStrategy

    Notes
    -----
    A strategy must be chosen for the selection of the different terms of the
    multivariate basis in which the response surface by functional chaos is expressed.
    The selected terms are regrouped in the finite subset :math:`K` of :math:`\\Nset`.

    There are three different strategies in OpenTURNS :

    - :class:`~openturns.FixedStrategy`,
    - :class:`~openturns.SequentialStrategy`,
    - :class:`~openturns.CleaningStrategy`.

    These strategies are conceived in such a way to be adapted for other orthogonal
    expansions (other than polynomial). For the moment, their implementation are
    only useful for the polynomial chaos expansion.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AdaptiveStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AdaptiveStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.AdaptiveStrategyImplementation_getClassName(self)


    def setMaximumDimension(self, maximumDimension):
        """
        Accessor to the maximum dimension of the orthogonal basis.

        Parameters
        ----------
        P : integer
            Maximum dimension of the truncated basis.
        """
        return _metamodel.AdaptiveStrategyImplementation_setMaximumDimension(self, maximumDimension)


    def getMaximumDimension(self):
        """
        Accessor to the maximum dimension of the orthogonal basis.

        Returns
        -------
        P : integer
            Maximum dimension of the truncated basis.
        """
        return _metamodel.AdaptiveStrategyImplementation_getMaximumDimension(self)


    def computeInitialBasis(self):
        """
        Compute initial basis for the approximation.

        See also
        --------
        getPsi
        """
        return _metamodel.AdaptiveStrategyImplementation_computeInitialBasis(self)


    def updateBasis(self, alpha_k, residual, relativeError):
        """
        Update the basis for the next iteration of approximation.

        Notes
        -----
        No changes are made to the basis in the fixed strategy.
        """
        return _metamodel.AdaptiveStrategyImplementation_updateBasis(self, alpha_k, residual, relativeError)


    def __repr__(self):
        return _metamodel.AdaptiveStrategyImplementation___repr__(self)

    def getBasis(self):
        """
        Accessor to the underlying orthogonal basis.

        Returns
        -------
        basis : :class:`~openturns.OrthogonalBasis`
            Orthogonal basis of which the adaptive strategy is based.
        """
        return _metamodel.AdaptiveStrategyImplementation_getBasis(self)


    def getPsi(self):
        """
        Accessor to the orthogonal polynomials of the basis.

        Returns
        -------
        polynomials : list of polynomials
            Sequence of :math:`P` analytical polynomials.

        Notes
        -----
        The method :meth:`computeInitialBasis` must be applied first.

        Examples
        --------
        >>> import openturns as ot
        >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()])
        >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 3)
        >>> adaptiveStrategy.computeInitialBasis()
        >>> print(adaptiveStrategy.getPsi())
        [1,x0,-0.707107 + 0.707107 * x0^2]
        """
        return _metamodel.AdaptiveStrategyImplementation_getPsi(self)


    def __init__(self, *args):
        this = _metamodel.new_AdaptiveStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_AdaptiveStrategyImplementation
    __del__ = lambda self: None
AdaptiveStrategyImplementation_swigregister = _metamodel.AdaptiveStrategyImplementation_swigregister
AdaptiveStrategyImplementation_swigregister(AdaptiveStrategyImplementation)

class FixedStrategy(AdaptiveStrategyImplementation):
    """
    Fixed truncation strategy.

    Available constructors:
        FixedStrategy(*orthogonalBasis, dimension*)

    Parameters
    ----------
    orthogonalBasis : :class:`~openturns.OrthogonalBasis`
        An OrthogonalBasis.
    dimension : positive int
        Number of terms of the basis.

    See also
    --------
    AdaptiveStrategy, SequentialStrategy, CleaningStrategy

    Notes
    -----
    The so-called fixed strategy simply consists in retaining the first :math:`P`
    elements of the PC basis, the latter being ordered according to a given
    :class:`~openturns.EnumerateFunction` (hyperbolic or not). The retained set is
    built in a single pass. The truncated PC expansion is given by:

    .. math::

        \\hat{h} (\\uX) = \\sum_{j=0}^{P-1} \\vect{a}_j \\Psi_j (\\uX)

    In case of a :class:`~openturns.LinearEnumerateFunction`, for a given natural
    integer :math:`p`, a usual choice is to set :math:`P` equals to:

    .. math::

        P = \\binom{n_X + p}{p} = \\frac{(n_X + p)!}{n_X!\\,p!}

    This way the set of retained basis functions :math:`\\{\\Psi_j, j = 0, \\ldots, P-1\\}`
    gathers all the polynomials with total degree not greater than :math:`p`.
    The number of terms :math:`P` grows polynomially both in :math:`n_X` and :math:`p`
    though, which may lead to difficulties in terms of computational efficiency and
    memory requirements when dealing with high-dimensional problems.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Define the model
    >>> inputDim = 1
    >>> model = ot.SymbolicFunction(['x'], ['x*sin(x)'])
    >>> # Create the input distribution
    >>> distribution = ot.ComposedDistribution([ot.Uniform()]*inputDim)
    >>> # Construction of the multivariate orthonormal basis
    >>> polyColl = [0.0]*inputDim
    >>> for i in range(distribution.getDimension()):
    ...     polyColl[i] = ot.StandardDistributionPolynomialFactory(distribution.getMarginal(i))
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDim)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
    >>> # Truncature strategy of the multivariate orthonormal basis
    >>> # We choose all the polynomials of degree <= 4
    >>> degree = 4
    >>> indexMax = enumerateFunction.getStrataCumulatedCardinal(degree)
    >>> print(indexMax)
    5
    >>> # We keep all the polynomials of degree <= 4
    >>> # which corresponds to the 5 first ones
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, indexMax)
    """

    __swig_setmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FixedStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FixedStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.FixedStrategy_getClassName(self)


    def computeInitialBasis(self):
        """
        Compute initial basis for the approximation.

        See also
        --------
        getPsi
        """
        return _metamodel.FixedStrategy_computeInitialBasis(self)


    def updateBasis(self, alpha_k, residual, relativeError):
        """
        Update the basis for the next iteration of approximation.

        Notes
        -----
        No changes are made to the basis in the fixed strategy.
        """
        return _metamodel.FixedStrategy_updateBasis(self, alpha_k, residual, relativeError)


    def __repr__(self):
        return _metamodel.FixedStrategy___repr__(self)

    def __init__(self, *args):
        this = _metamodel.new_FixedStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_FixedStrategy
    __del__ = lambda self: None
FixedStrategy_swigregister = _metamodel.FixedStrategy_swigregister
FixedStrategy_swigregister(FixedStrategy)

class SequentialStrategy(AdaptiveStrategyImplementation):
    """
    Sequential truncation strategy.

    Available constructors:
        SequentialStrategy(*orthogonalBasis, maximumDimension*)

    Parameters
    ----------
    orthogonalBasis : :class:`~openturns.OrthogonalBasis`
        An OrthogonalBasis.
    maximumDimension : positive int
        Maximum number of terms of the basis.

    See also
    --------
    AdaptiveStrategy, SequentialStrategy, CleaningStrategy

    Notes
    -----
    The sequential strategy consists in constructing the basis of the truncated PC
    iteratively. Precisely, one begins with the first term :math:`\\Psi_0`, that is
    :math:`K_0 = \\{0\\}`, and one complements the current basis as follows:
    :math:`K_{k+1} = K_k \\cup \\{\\Psi_{k+1}\\}`. The construction process is
    stopped when a given accuracy criterion, defined in the
    :class:`~openturns.ProjectionStrategy`, is reached, or when :math:`k` is equal to
    a prescribed maximum basis size :math:`P`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Define the model
    >>> inputDim = 1
    >>> model = ot.SymbolicFunction(['x'], ['x*sin(x)'])
    >>> # Create the input distribution
    >>> distribution = ot.ComposedDistribution([ot.Uniform()]*inputDim)
    >>> # Construction of the multivariate orthonormal basis
    >>> polyColl = [0.0]*inputDim
    >>> for i in range(distribution.getDimension()):
    ...     polyColl[i] = ot.StandardDistributionPolynomialFactory(distribution.getMarginal(i))
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDim)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
    >>> # Truncature strategy of the multivariate orthonormal basis
    >>> # We want to select among the maximumDimension = 20 first polynomials of the
    >>> # multivariate basis those verifying the convergence criterion.
    >>> maximumDimension = 20
    >>> adaptiveStrategy = ot.SequentialStrategy(productBasis, maximumDimension)
    """

    __swig_setmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SequentialStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SequentialStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.SequentialStrategy_getClassName(self)


    def computeInitialBasis(self):
        """
        Compute initial basis for the approximation.

        See also
        --------
        getPsi
        """
        return _metamodel.SequentialStrategy_computeInitialBasis(self)


    def updateBasis(self, alpha_k, residual, relativeError):
        """
        Update the basis for the next iteration of approximation.

        Notes
        -----
        No changes are made to the basis in the fixed strategy.
        """
        return _metamodel.SequentialStrategy_updateBasis(self, alpha_k, residual, relativeError)


    def __repr__(self):
        return _metamodel.SequentialStrategy___repr__(self)

    def __init__(self, *args):
        this = _metamodel.new_SequentialStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_SequentialStrategy
    __del__ = lambda self: None
SequentialStrategy_swigregister = _metamodel.SequentialStrategy_swigregister
SequentialStrategy_swigregister(SequentialStrategy)

class CleaningStrategy(AdaptiveStrategyImplementation):
    """
    Cleaning truncation strategy.

    Available constructors:
        CleaningStrategy(*orthogonalBasis, maximumDimension*)

        CleaningStrategy(*orthogonalBasis, maximumDimension, verbose*)

        CleaningStrategy(*orthogonalBasis, maximumDimension, maximumSize, 
        significanceFactor*)

        CleaningStrategy(*orthogonalBasis, maximumDimension, maximumSize, 
        significanceFactor, verbose*)

    Parameters
    ----------
    orthogonalBasis : :class:`~openturns.OrthogonalBasis`
        An OrthogonalBasis.
    maximumDimension : positive int
        Maximum index that can be used by the :class:`~openturns.EnumerateFunction`
        to determine the last term of the basis.
    maximumSize : positve int
        Parameter that characterizes the cleaning strategy. It represents the 
        number of efficient coefficients of the basis. Its default value is set to 
        20.
    significanceFactor : float 
        Parameter used as a threshold for selecting the efficient coefficients of
        the basis. The real threshold represents the multiplication of the
        significanceFactor with the maximum magnitude of the current determined 
        coefficients. Its default value is equal to :math:`1e^{-4}`.
    verbose : bool
        Used for the online monitoring of the current basis updates (removed or
        added coefficients).


    See also
    --------
    AdaptiveStrategy, FixedStrategy, SequentialStrategy

    Notes
    -----
    The cleaning strategy aims at building a PC expansion containing at most
    :math:`P` significant coefficients, i.e. at most :math:`P` significant basis
    functions. It proceeds as follows:

    - Generate an initial PC basis made of the :math:`P` first polynomials
      (according to the adopted :class:`~openturns.EnumerateFunction`), or
      equivalently an initial set of indices :math:`K = \\{0, \\ldots, P-1\\}`.

    - Discard from the basis all those polynomials :math:`\\Psi_j` associated with 
      insignificance coefficients, i.e. the coefficients that satisfy:

    .. math::

        |a_j| \\leq \\epsilon \\times \\max_{ k \\in K } |a_k|

    where :math:`\\epsilon` is the significance factor, default is
    :math:`\\epsilon = 10^{-4}`.

    - Add the next basis term :math:`\\Psi_{k+1}` to the current basis :math:`K`.
    - Reiterate the procedure until either :math:`P` terms have been retained or if
      the given maximum index :math:`P_{max}` has been reached.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Define the model
    >>> inputDim = 1
    >>> model = ot.SymbolicFunction(['x'], ['x*sin(x)'])
    >>> # Create the input distribution
    >>> distribution = ot.ComposedDistribution([ot.Uniform()]*inputDim)
    >>> # Construction of the multivariate orthonormal basis
    >>> polyColl = [0.0]*inputDim
    >>> for i in range(distribution.getDimension()):
    ...     polyColl[i] = ot.StandardDistributionPolynomialFactory(distribution.getMarginal(i))
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDim)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
    >>> # Truncature strategy of the multivariate orthonormal basis
    >>> # We want to select, among the maximumDimension = 100 first polynomials of
    >>> # the multivariate basis, those which have the maximumSize = 20 most 
    >>> # significant contribution (greatest coefficients), with respect to the 
    >>> # significance factor = 10^-4.
    >>> maximumDimension = 100
    >>> maximumSize = 20
    >>> significanceFactor = 1e-4
    >>> adaptiveStrategy = ot.CleaningStrategy(productBasis, maximumDimension,
    ...                                          maximumSize, significanceFactor)
    """

    __swig_setmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CleaningStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [AdaptiveStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CleaningStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.CleaningStrategy_getClassName(self)


    def computeInitialBasis(self):
        """
        Compute initial basis for the approximation.

        See also
        --------
        getPsi
        """
        return _metamodel.CleaningStrategy_computeInitialBasis(self)


    def updateBasis(self, alpha_k, residual, relativeError):
        """
        Update the basis for the next iteration of approximation.

        Notes
        -----
        No changes are made to the basis in the fixed strategy.
        """
        return _metamodel.CleaningStrategy_updateBasis(self, alpha_k, residual, relativeError)


    def __repr__(self):
        return _metamodel.CleaningStrategy___repr__(self)

    def getCurrentVectorIndex(self):
        """
        Accessor to the current vector index.

        Returns
        -------
        index : integer
            Current index of the basis term.
        """
        return _metamodel.CleaningStrategy_getCurrentVectorIndex(self)


    def getMaximumSize(self):
        """
        Accessor to the maximum size of the orthogonal basis.

        Returns
        -------
        size : integer
            Maximum number of significant terms of the basis.

        See also
        --------
        setMaximumSize
        """
        return _metamodel.CleaningStrategy_getMaximumSize(self)


    def setMaximumSize(self, maximumSize):
        """
        Accessor to the maximum size of the orthogonal basis.

        Parameters
        ----------
        size : integer
            Maximum number of significant terms of the basis.

        See also
        --------
        getMaximumSize
        """
        return _metamodel.CleaningStrategy_setMaximumSize(self, maximumSize)


    def getSignificanceFactor(self):
        """
        Accessor to the significance factor.

        Returns
        -------
        factor : float
            Value of the significance factor.

        See also
        --------
        setSignificanceFactor
        """
        return _metamodel.CleaningStrategy_getSignificanceFactor(self)


    def setSignificanceFactor(self, significanceFactor):
        """
        Accessor to the significance factor.

        Parameters
        ----------
        factor : float
            Value of the significance factor.

        See also
        --------
        getSignificanceFactor
        """
        return _metamodel.CleaningStrategy_setSignificanceFactor(self, significanceFactor)


    def getVerbose(self):
        """
        Accessor to the verbose.

        Returns
        -------
        verbose : bool
            Return if the online monitoring of the current basis updates is enabled or not.

        See also
        --------
        setVerbose
        """
        return _metamodel.CleaningStrategy_getVerbose(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbose.

        Parameters
        ----------
        verbose : bool
            Enable the online monitoring of the current basis updates or not.

        See also
        --------
        getVerbose
        """
        return _metamodel.CleaningStrategy_setVerbose(self, verbose)


    def __init__(self, *args):
        this = _metamodel.new_CleaningStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_CleaningStrategy
    __del__ = lambda self: None
CleaningStrategy_swigregister = _metamodel.CleaningStrategy_swigregister
CleaningStrategy_swigregister(CleaningStrategy)

class AdaptiveStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AdaptiveStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AdaptiveStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _metamodel.new_AdaptiveStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _metamodel.AdaptiveStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _metamodel.AdaptiveStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _metamodel.AdaptiveStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _metamodel.AdaptiveStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _metamodel.delete_AdaptiveStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
AdaptiveStrategyImplementationTypedInterfaceObject_swigregister = _metamodel.AdaptiveStrategyImplementationTypedInterfaceObject_swigregister
AdaptiveStrategyImplementationTypedInterfaceObject_swigregister(AdaptiveStrategyImplementationTypedInterfaceObject)

class AdaptiveStrategy(AdaptiveStrategyImplementationTypedInterfaceObject):
    """
    Base class for the construction of the truncated multivariate orthogonal basis.

    Available constructors:
        AdaptiveStrategy(*orthogonalBasis, dimension*)

        AdaptiveStrategy(*adaptiveStrategyImplementation*)

    Parameters
    ----------
    orthogonalBasis : :class:`~openturns.OrthogonalBasis`
        An OrthogonalBasis.
    dimension : positive int
        Number of terms of the basis. This first usage has the same implementation
        as the second with a :class:`~openturns.FixedStrategy`. 
    adaptiveStrategyImplementation : AdaptiveStrategyImplementation
        Adaptive strategy implementation which is a :class:`~openturns.FixedStrategy`, 
        :class:`~openturns.SequentialStrategy` or a :class:`~openturns.CleaningStrategy`.

    See also
    --------
    FunctionalChaosAlgorithm, FixedStrategy, SequentialStrategy, CleaningStrategy

    Notes
    -----
    A strategy must be chosen for the selection of the different terms of the
    multivariate basis in which the response surface by functional chaos is expressed.
    The selected terms are regrouped in the finite subset :math:`K` of :math:`\\Nset`.

    There are three different strategies in OpenTURNS :

    - :class:`~openturns.FixedStrategy`,
    - :class:`~openturns.SequentialStrategy`,
    - :class:`~openturns.CleaningStrategy`.

    These strategies are conceived in such a way to be adapted for other orthogonal
    expansions (other than polynomial). For the moment, their implementation are
    only useful for the polynomial chaos expansion.
    """

    __swig_setmethods__ = {}
    for _s in [AdaptiveStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AdaptiveStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [AdaptiveStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AdaptiveStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.AdaptiveStrategy_getClassName(self)


    def setMaximumDimension(self, maximumDimension):
        """
        Accessor to the maximum dimension of the orthogonal basis.

        Parameters
        ----------
        P : integer
            Maximum dimension of the truncated basis.
        """
        return _metamodel.AdaptiveStrategy_setMaximumDimension(self, maximumDimension)


    def getMaximumDimension(self):
        """
        Accessor to the maximum dimension of the orthogonal basis.

        Returns
        -------
        P : integer
            Maximum dimension of the truncated basis.
        """
        return _metamodel.AdaptiveStrategy_getMaximumDimension(self)


    def computeInitialBasis(self):
        """
        Compute initial basis for the approximation.

        See also
        --------
        getPsi
        """
        return _metamodel.AdaptiveStrategy_computeInitialBasis(self)


    def updateBasis(self, alpha_k, residual, relativeError):
        """
        Update the basis for the next iteration of approximation.

        Notes
        -----
        No changes are made to the basis in the fixed strategy.
        """
        return _metamodel.AdaptiveStrategy_updateBasis(self, alpha_k, residual, relativeError)


    def getBasis(self):
        """
        Accessor to the underlying orthogonal basis.

        Returns
        -------
        basis : :class:`~openturns.OrthogonalBasis`
            Orthogonal basis of which the adaptive strategy is based.
        """
        return _metamodel.AdaptiveStrategy_getBasis(self)


    def getPsi(self):
        """
        Accessor to the orthogonal polynomials of the basis.

        Returns
        -------
        polynomials : list of polynomials
            Sequence of :math:`P` analytical polynomials.

        Notes
        -----
        The method :meth:`computeInitialBasis` must be applied first.

        Examples
        --------
        >>> import openturns as ot
        >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()])
        >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 3)
        >>> adaptiveStrategy.computeInitialBasis()
        >>> print(adaptiveStrategy.getPsi())
        [1,x0,-0.707107 + 0.707107 * x0^2]
        """
        return _metamodel.AdaptiveStrategy_getPsi(self)


    def __repr__(self):
        return _metamodel.AdaptiveStrategy___repr__(self)

    def __str__(self, *args):
        return _metamodel.AdaptiveStrategy___str__(self, *args)

    def __init__(self, *args):
        this = _metamodel.new_AdaptiveStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_AdaptiveStrategy
    __del__ = lambda self: None
AdaptiveStrategy_swigregister = _metamodel.AdaptiveStrategy_swigregister
AdaptiveStrategy_swigregister(AdaptiveStrategy)

class ProjectionStrategyImplementation(openturns.common.PersistentObject):
    """
    Base class for the evaluation strategies of the approximation coefficients.

    Available constructors:
        ProjectionStrategy(*projectionStrategy*)

    Parameters
    ----------
    projectionStrategy : :class:`~openturns.ProjectionStrategy`
        A projection strategy which is a :class:`~openturns.LeastSquaresStrategy` or
        an :class:`~openturns.IntegrationStrategy`.

    See also
    --------
    FunctionalChaosAlgorithm, LeastSquaresStrategy, IntegrationStrategy

    Notes
    -----
    Consider :math:`\\vect{Y} = g(\\vect{X})` with :math:`g: \\Rset^d \\rightarrow \\Rset^p`,
    :math:`\\vect{X} \\sim \\cL_{\\vect{X}}` and :math:`\\vect{Y}` with finite variance:
    :math:`g\\in L_{\\cL_{\\vect{X}}}^2(\\Rset^d, \\Rset^p)`.

    The functional chaos  expansion approximates :math:`\\vect{Y}` using an isoprobabilistic 
    transformation *T* and an orthonormal multivariate basis :math:`(\\Psi_k)_{k \\in \\Nset}` 
    of :math:`L^2_{\\mu}(\\Rset^d,\\Rset)`. See :class:`~openturns.FunctionalChaosAlgorithm` 
    to get more details. 

    The meta model of :math:`g`, based on the functional chaos decomposition of 
    :math:`f = g \\circ T^{-1}` writes:

    .. math::

        \\tilde{g} = \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k  \\circ T

    where *K* is a non empty finite set of indices, whose cardinality is denoted by *P*.

    We detail the case where :math:`p=1`.

    The vector  :math:`\\vect{\\alpha} = (\\alpha_k)_{k \\in K}`  is  equivalently defined by:

    .. math::
        :label: defArgMin

        \\vect{\\alpha} = \\argmin_{\\vect{\\alpha} \\in \\Rset^K} \\Expect{ \\left( g \\circ T^{-1}(\\vect{Z}) -  \\sum_{k \\in K} \\alpha_k \\Psi_k (\\vect{Z})\\right)^2 }

    and:

    .. math::
        :label: defEsp

        \\alpha_k =  <g \\circ T^{-1}(\\vect{Z}), \\Psi_k (\\vect{Z})>_{\\mu} = \\Expect{  g \\circ T^{-1}(\\vect{Z}) \\Psi_k (\\vect{Z}) }

    where :math:`\\vect{Z} = T(\\vect{X})` and the mean :math:`\\Expect{.}` is evaluated with respect to the measure :math:`\\mu`.

    It corresponds to two points of view: 

        - relation :eq:`defArgMin`  means that the coefficients 
          :math:`(\\alpha_k)_{k \\in K}` minimize the quadratic error between  the model and 
          the polynomial approximation. Use :class:`~openturns.LeastSquaresStrategy`.

        - relation :eq:`defEsp` means that :math:`\\alpha_k` is the scalar product of the 
          model with the *k-th* element of the orthonormal basis :math:`(\\Psi_k)_{k \\in \\Nset}`.
          Use :class:`~openturns.IntegrationStrategy`.

    In both cases, the mean :math:`\\Expect{.}` is approximated by a linear quadrature formula:

    .. math::
        :label: approxEsp

        \\Expect{ f(\\vect{Z})} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where *f* is a function in :math:`L^1(\\mu)`. 

    In the approximation :eq:`approxEsp`, the set *I*, the points :math:`(\\Xi_i)_{i \\in I}` 
    and the weights :math:`(\\omega_i)_{i \\in I}` are evaluated from different methods 
    implemented in OpenTURNS in the :class:`~openturns.WeightedExperiment`.

    The convergence criterion used to evaluate the coefficients is based on the residual value 
    defined in the :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProjectionStrategyImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProjectionStrategyImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.ProjectionStrategyImplementation_getClassName(self)


    def __repr__(self):
        return _metamodel.ProjectionStrategyImplementation___repr__(self)

    def setMeasure(self, measure):
        """
        Accessor to the measure.

        Parameters
        ----------
        m : Distribution
            Measure :math:`\\mu` defining the scalar product.
        """
        return _metamodel.ProjectionStrategyImplementation_setMeasure(self, measure)


    def getMeasure(self):
        """
        Accessor to the measure.

        Returns
        -------
        mu : Distribution
            Measure :math:`\\mu` defining the scalar product.
        """
        return _metamodel.ProjectionStrategyImplementation_getMeasure(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        X : :class:`~openturns.Sample`
            Input Sample.
        """
        return _metamodel.ProjectionStrategyImplementation_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        Y : :class:`~openturns.Sample`
            Output Sample.
        """
        return _metamodel.ProjectionStrategyImplementation_getOutputSample(self)


    def getWeights(self):
        """
        Accessor to the weights.

        Returns
        -------
        w : :class:`~openturns.Point`
            Weights of the design of experiments.
        """
        return _metamodel.ProjectionStrategyImplementation_getWeights(self)


    def getResidual(self):
        """
        Accessor to the residual.

        Returns
        -------
        er : float
            Residual error.
        """
        return _metamodel.ProjectionStrategyImplementation_getResidual(self)


    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        e : float
            Relative error.
        """
        return _metamodel.ProjectionStrategyImplementation_getRelativeError(self)


    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coef : :class:`~openturns.Point`
            Coefficients :math:`(\\alpha_k)_{k \\in K}`.
        """
        return _metamodel.ProjectionStrategyImplementation_getCoefficients(self)


    def setExperiment(self, weightedExperiment):
        """
        Accessor to the design of experiment.

        Parameters
        ----------
        exp : :class:`~openturns.WeightedExperiment`
            Weighted design of experiment.
        """
        return _metamodel.ProjectionStrategyImplementation_setExperiment(self, weightedExperiment)


    def getExperiment(self):
        """
        Accessor to the experiments.

        Returns
        -------
        exp : :class:`~openturns.WeightedExperiment`
            Weighted experiment used to evaluate the coefficients.
        """
        return _metamodel.ProjectionStrategyImplementation_getExperiment(self)


    def computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex=0):
        return _metamodel.ProjectionStrategyImplementation_computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex)

    def __init__(self, *args):
        this = _metamodel.new_ProjectionStrategyImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_ProjectionStrategyImplementation
    __del__ = lambda self: None
ProjectionStrategyImplementation_swigregister = _metamodel.ProjectionStrategyImplementation_swigregister
ProjectionStrategyImplementation_swigregister(ProjectionStrategyImplementation)

class LeastSquaresStrategy(ProjectionStrategyImplementation):
    """
    Least squares strategy for the approximation coefficients.

    Available constructors:
        LeastSquaresStrategy(*weightedExp*)

        LeastSquaresStrategy(*weightedExp, approxAlgoImpFact*)

        LeastSquaresStrategy(*measure, approxAlgoImpFact*)

        LeastSquaresStrategy(*measure, weightedExp, approxAlgoImpFact*)

        LeastSquaresStrategy(*inputSample, outputSample, approxAlgoImpFact*)

        LeastSquaresStrategy(*inputSample, weights, outputSample, approxAlgoImpFact*)

    Parameters
    ----------
    weightedExp : :class:`~openturns.WeightedExperiment`
        Experimental design used for the transformed input data. When not precised,
        OpenTURNS uses a :class:`~openturns.MonteCarloExperiment`.
    approxAlgoImpFact : ApproximationAlgorithmImplementationFactory
        The factory that builds the desired :class:`~openturns.ApproximationAlgorithm`.
        When not precised, OpenTURNS uses the 
        :class:`~openturns.PenalizedLeastSquaresAlgorithmFactory`.
    measure : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with respect to which the basis is orthonormal.
        When not precised, OpenTURNS uses the limit measure defined within the
        :class:`~openturns.WeightedExperiment`.
    inputSample, outputSample : 2-d sequence of float
        The input random variables :math:`\\vect{X}=(X_1, \\dots, X_{n_X})^T`
        and the output samples :math:`\\vect{Y}` that describe the model.
    weights : sequence of float
        Numerical point that are the weights associated to the input sample points
        such that the corresponding weighted experiment is a good approximation of
        :math:`\\mu`. If not precised, all weights are equals to 
        :math:`\\omega_i = \\frac{1}{size}`, where :math:`size` is the size of the
        sample.

    See also
    --------
    FunctionalChaosAlgorithm, ProjectionStrategy, IntegrationStrategy

    Notes
    -----
    This class is not usable because it has sense only within the
    :class:`~openturns.FunctionalChaosAlgorithm` : the least squares strategy
    evaluates the coefficients :math:`(a_k)_{k \\in K}` of the polynomials
    decomposition as follows:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} E_{\\mu} \\left[ \\left( g \\circ T^{-1}
                (\\vect{U}) - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U}) \\right)^2 \\right]

    where :math:`\\vect{U} = T(\\vect{X})`.

    The mean expectation :math:`E_{\\mu}` is approximated by a relation of type:

    .. math::

        E_{\\mu} \\left[ f(\\vect{U}) \\right] \\approx \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where is a function :math:`L_1(\\mu)` defined as:

    .. math::

        f(\\vect{U} = \\left( g \\circ T^{-1} (\\vect{U}) - \\vect{b}^{\\intercal}
                                     \\vect{\\Psi}(\\vect{U}) \\right)^2 

    In the approximation of the mean expectation, the set *I*, the points 
    :math:`(\\Xi_i)_{i \\in I}` and the weights :math:`(\\omega_i)_{i \\in I}` are
    evaluated from methods implemented in the :class:`~openturns.WeightedExperiment`.
    """

    __swig_setmethods__ = {}
    for _s in [ProjectionStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [ProjectionStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.LeastSquaresStrategy_getClassName(self)


    def __repr__(self):
        return _metamodel.LeastSquaresStrategy___repr__(self)

    def computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex=0):
        return _metamodel.LeastSquaresStrategy_computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex)

    def __init__(self, *args):
        this = _metamodel.new_LeastSquaresStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_LeastSquaresStrategy
    __del__ = lambda self: None
LeastSquaresStrategy_swigregister = _metamodel.LeastSquaresStrategy_swigregister
LeastSquaresStrategy_swigregister(LeastSquaresStrategy)

class IntegrationStrategy(ProjectionStrategyImplementation):
    """
    Integration strategy for the approximation coefficients.

    Available constructors:
        LeastSquaresStrategy(*measure*)

        LeastSquaresStrategy(*weightedExp*)

        LeastSquaresStrategy(*measure, weightedExp*)

        LeastSquaresStrategy(*inputSample, outputSample*)

        LeastSquaresStrategy(*inputSample, weights, outputSample*)

    Parameters
    ----------
    weightedExp : :class:`~openturns.WeightedExperiment`
        Experimental design used for the transformed input data. When not precised,
        OpenTURNS uses a :class:`~openturns.MonteCarloExperiment`.
    measure : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with respect to which the basis is orthonormal.
        When not precised, OpenTURNS uses the limit measure defined within the
        :class:`~openturns.WeightedExperiment`.
    inputSample, outputSample : 2-d sequence of float
        The input random variables :math:`\\vect{X}=(X_1, \\dots, X_{n_X})^T`
        and the output samples :math:`\\vect{Y}` that describe the model.
    weights : sequence of float
        Numerical point that are the weights associated to the input sample points
        such that the corresponding weighted experiment is a good approximation of
        :math:`\\mu`. If not precised, all weights are equals to 
        :math:`\\omega_i = \\frac{1}{size}`, where :math:`size` is the size of the
        sample.

    See also
    --------
    FunctionalChaosAlgorithm, ProjectionStrategy, LeastSquaresStrategy

    Notes
    -----
    This class is not usable because it has sense only within the
    :class:`~openturns.FunctionalChaosAlgorithm` : the integration strategy
    evaluates the coefficients :math:`(a_k)_{k \\in K}` of the polynomials
    decomposition as follows:

    .. math::

        \\vect{a} = E_{\\mu} \\left[ g \\circ T^{-1} (\\vect{U}) \\vect{\\Psi}(\\vect{U}) \\right]

    where :math:`\\vect{U} = T(\\vect{X})`.

    The mean expectation :math:`E_{\\mu}` is approximated by a relation of type:

    .. math::

        E_{\\mu} \\left[ f(\\vect{U}) \\right] \\approx \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where is a function :math:`L_1(\\mu)` defined as:

    .. math::

        f(\\vect{U} = g \\circ T^{-1} (\\vect{U}) \\vect{\\Psi}(\\vect{U})

    In the approximation of the mean expectation, the set *I*, the points 
    :math:`(\\Xi_i)_{i \\in I}` and the weights :math:`(\\omega_i)_{i \\in I}` are
    evaluated from methods implemented in the :class:`~openturns.WeightedExperiment`.
    """

    __swig_setmethods__ = {}
    for _s in [ProjectionStrategyImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntegrationStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [ProjectionStrategyImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntegrationStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.IntegrationStrategy_getClassName(self)


    def __repr__(self):
        return _metamodel.IntegrationStrategy___repr__(self)

    def computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex=0):
        return _metamodel.IntegrationStrategy_computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex)

    def __init__(self, *args):
        this = _metamodel.new_IntegrationStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_IntegrationStrategy
    __del__ = lambda self: None
IntegrationStrategy_swigregister = _metamodel.IntegrationStrategy_swigregister
IntegrationStrategy_swigregister(IntegrationStrategy)

class ProjectionStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProjectionStrategyImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProjectionStrategyImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _metamodel.new_ProjectionStrategyImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _metamodel.ProjectionStrategyImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _metamodel.ProjectionStrategyImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _metamodel.ProjectionStrategyImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _metamodel.ProjectionStrategyImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _metamodel.delete_ProjectionStrategyImplementationTypedInterfaceObject
    __del__ = lambda self: None
ProjectionStrategyImplementationTypedInterfaceObject_swigregister = _metamodel.ProjectionStrategyImplementationTypedInterfaceObject_swigregister
ProjectionStrategyImplementationTypedInterfaceObject_swigregister(ProjectionStrategyImplementationTypedInterfaceObject)

class ProjectionStrategy(ProjectionStrategyImplementationTypedInterfaceObject):
    """
    Base class for the evaluation strategies of the approximation coefficients.

    Available constructors:
        ProjectionStrategy(*projectionStrategy*)

    Parameters
    ----------
    projectionStrategy : :class:`~openturns.ProjectionStrategy`
        A projection strategy which is a :class:`~openturns.LeastSquaresStrategy` or
        an :class:`~openturns.IntegrationStrategy`.

    See also
    --------
    FunctionalChaosAlgorithm, LeastSquaresStrategy, IntegrationStrategy

    Notes
    -----
    Consider :math:`\\vect{Y} = g(\\vect{X})` with :math:`g: \\Rset^d \\rightarrow \\Rset^p`,
    :math:`\\vect{X} \\sim \\cL_{\\vect{X}}` and :math:`\\vect{Y}` with finite variance:
    :math:`g\\in L_{\\cL_{\\vect{X}}}^2(\\Rset^d, \\Rset^p)`.

    The functional chaos  expansion approximates :math:`\\vect{Y}` using an isoprobabilistic 
    transformation *T* and an orthonormal multivariate basis :math:`(\\Psi_k)_{k \\in \\Nset}` 
    of :math:`L^2_{\\mu}(\\Rset^d,\\Rset)`. See :class:`~openturns.FunctionalChaosAlgorithm` 
    to get more details. 

    The meta model of :math:`g`, based on the functional chaos decomposition of 
    :math:`f = g \\circ T^{-1}` writes:

    .. math::

        \\tilde{g} = \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k  \\circ T

    where *K* is a non empty finite set of indices, whose cardinality is denoted by *P*.

    We detail the case where :math:`p=1`.

    The vector  :math:`\\vect{\\alpha} = (\\alpha_k)_{k \\in K}`  is  equivalently defined by:

    .. math::
        :label: defArgMin

        \\vect{\\alpha} = \\argmin_{\\vect{\\alpha} \\in \\Rset^K} \\Expect{ \\left( g \\circ T^{-1}(\\vect{Z}) -  \\sum_{k \\in K} \\alpha_k \\Psi_k (\\vect{Z})\\right)^2 }

    and:

    .. math::
        :label: defEsp

        \\alpha_k =  <g \\circ T^{-1}(\\vect{Z}), \\Psi_k (\\vect{Z})>_{\\mu} = \\Expect{  g \\circ T^{-1}(\\vect{Z}) \\Psi_k (\\vect{Z}) }

    where :math:`\\vect{Z} = T(\\vect{X})` and the mean :math:`\\Expect{.}` is evaluated with respect to the measure :math:`\\mu`.

    It corresponds to two points of view: 

        - relation :eq:`defArgMin`  means that the coefficients 
          :math:`(\\alpha_k)_{k \\in K}` minimize the quadratic error between  the model and 
          the polynomial approximation. Use :class:`~openturns.LeastSquaresStrategy`.

        - relation :eq:`defEsp` means that :math:`\\alpha_k` is the scalar product of the 
          model with the *k-th* element of the orthonormal basis :math:`(\\Psi_k)_{k \\in \\Nset}`.
          Use :class:`~openturns.IntegrationStrategy`.

    In both cases, the mean :math:`\\Expect{.}` is approximated by a linear quadrature formula:

    .. math::
        :label: approxEsp

        \\Expect{ f(\\vect{Z})} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where *f* is a function in :math:`L^1(\\mu)`. 

    In the approximation :eq:`approxEsp`, the set *I*, the points :math:`(\\Xi_i)_{i \\in I}` 
    and the weights :math:`(\\omega_i)_{i \\in I}` are evaluated from different methods 
    implemented in OpenTURNS in the :class:`~openturns.WeightedExperiment`.

    The convergence criterion used to evaluate the coefficients is based on the residual value 
    defined in the :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [ProjectionStrategyImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProjectionStrategy, name, value)
    __swig_getmethods__ = {}
    for _s in [ProjectionStrategyImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProjectionStrategy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.ProjectionStrategy_getClassName(self)


    def setMeasure(self, measure):
        """
        Accessor to the measure.

        Parameters
        ----------
        m : Distribution
            Measure :math:`\\mu` defining the scalar product.
        """
        return _metamodel.ProjectionStrategy_setMeasure(self, measure)


    def getMeasure(self):
        """
        Accessor to the measure.

        Returns
        -------
        mu : Distribution
            Measure :math:`\\mu` defining the scalar product.
        """
        return _metamodel.ProjectionStrategy_getMeasure(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        X : :class:`~openturns.Sample`
            Input Sample.
        """
        return _metamodel.ProjectionStrategy_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        Y : :class:`~openturns.Sample`
            Output Sample.
        """
        return _metamodel.ProjectionStrategy_getOutputSample(self)


    def getWeights(self):
        """
        Accessor to the weights.

        Returns
        -------
        w : :class:`~openturns.Point`
            Weights of the design of experiments.
        """
        return _metamodel.ProjectionStrategy_getWeights(self)


    def getResidual(self):
        """
        Accessor to the residual.

        Returns
        -------
        er : float
            Residual error.
        """
        return _metamodel.ProjectionStrategy_getResidual(self)


    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        e : float
            Relative error.
        """
        return _metamodel.ProjectionStrategy_getRelativeError(self)


    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coef : :class:`~openturns.Point`
            Coefficients :math:`(\\alpha_k)_{k \\in K}`.
        """
        return _metamodel.ProjectionStrategy_getCoefficients(self)


    def setExperiment(self, weightedExperiment):
        """
        Accessor to the design of experiment.

        Parameters
        ----------
        exp : :class:`~openturns.WeightedExperiment`
            Weighted design of experiment.
        """
        return _metamodel.ProjectionStrategy_setExperiment(self, weightedExperiment)


    def getExperiment(self):
        """
        Accessor to the experiments.

        Returns
        -------
        exp : :class:`~openturns.WeightedExperiment`
            Weighted experiment used to evaluate the coefficients.
        """
        return _metamodel.ProjectionStrategy_getExperiment(self)


    def computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex=0):
        return _metamodel.ProjectionStrategy_computeCoefficients(self, function, basis, indices, addedRanks, conservedRanks, removedRanks, marginalIndex)

    def __repr__(self):
        return _metamodel.ProjectionStrategy___repr__(self)

    def __str__(self, *args):
        return _metamodel.ProjectionStrategy___str__(self, *args)

    def __init__(self, *args):
        this = _metamodel.new_ProjectionStrategy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_ProjectionStrategy
    __del__ = lambda self: None
ProjectionStrategy_swigregister = _metamodel.ProjectionStrategy_swigregister
ProjectionStrategy_swigregister(ProjectionStrategy)

class FunctionalChaosResult(MetaModelResult):
    """
    Functional chaos result.

    Notes
    -----
    Structure created by the method run() of
    :class:`~openturns.FunctionalChaosAlgorithm`, and obtained thanks to the method
    getResult().
    """

    __swig_setmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalChaosResult, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalChaosResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.FunctionalChaosResult_getClassName(self)


    def __repr__(self):
        return _metamodel.FunctionalChaosResult___repr__(self)

    def __str__(self, *args):
        return _metamodel.FunctionalChaosResult___str__(self, *args)

    def getDistribution(self):
        """
        Get the input distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the  input random vector :math:`\\vect{X}`.
        """
        return _metamodel.FunctionalChaosResult_getDistribution(self)


    def getTransformation(self):
        """
        Get the isoprobabilistic transformation.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            Transformation :math:`T` such that :math:`T(\\vect{X}) = \\vect{Z}`.
        """
        return _metamodel.FunctionalChaosResult_getTransformation(self)


    def getInverseTransformation(self):
        """
        Get the inverse isoprobabilistic transformation.

        Returns
        -------
        invTransf : :class:`~openturns.Function`
             :math:`T^{-1}` such that :math:`T(\\vect{X}) = \\vect{Z}`.
        """
        return _metamodel.FunctionalChaosResult_getInverseTransformation(self)


    def getComposedModel(self):
        """
        Get the composed model.

        Returns
        -------
        composedModel : :class:`~openturns.Function`
            :math:`f = g\\circ T^{-1}`.
        """
        return _metamodel.FunctionalChaosResult_getComposedModel(self)


    def getOrthogonalBasis(self):
        """
        Get the orthogonal basis.

        Returns
        -------
        basis : :class:`~openturns.OrthogonalBasis`
            Factory of the orthogonal basis.
        """
        return _metamodel.FunctionalChaosResult_getOrthogonalBasis(self)


    def getIndices(self):
        """
        Get the indices of the final basis.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the elements of the multivariate basis used in the decomposition.
        """
        return _metamodel.FunctionalChaosResult_getIndices(self)


    def getCoefficients(self):
        """
        Get the coefficients.

        Returns
        -------
        coefficients : 2-d sequence of float
            Coefficients :math:`(\\vect{\\alpha_k})_{k \\in K}`.
        """
        return _metamodel.FunctionalChaosResult_getCoefficients(self)


    def getReducedBasis(self):
        """
        Get the reduced basis.

        Returns
        -------
        basis : list of :class:`~openturns.Function`
            Collection of the *K* functions  :math:`(\\Psi_k)_{k\\in K}`  used in the 
            decomposition.
        """
        return _metamodel.FunctionalChaosResult_getReducedBasis(self)


    def getComposedMetaModel(self):
        """
        Get the composed metamodel.

        Returns
        -------
        composedMetamodel : :class:`~openturns.Function`
            :math:`\\tilde{f} =  \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k`
        """
        return _metamodel.FunctionalChaosResult_getComposedMetaModel(self)


    def __init__(self, *args):
        this = _metamodel.new_FunctionalChaosResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_FunctionalChaosResult
    __del__ = lambda self: None
FunctionalChaosResult_swigregister = _metamodel.FunctionalChaosResult_swigregister
FunctionalChaosResult_swigregister(FunctionalChaosResult)

class FunctionalChaosAlgorithm(MetaModelAlgorithm):
    """
    Functional chaos algorithm.

    Available constructors:
        FunctionalChaosAlgorithm(*inputSample, outputSample*)

        FunctionalChaosAlgorithm(*inputSample, outputSample, distribution, adaptiveStrategy*)

        FunctionalChaosAlgorithm(*inputSample, outputSample, distribution, adaptiveStrategy, projectionStrategy*)

        FunctionalChaosAlgorithm(*model, distribution, adaptiveStrategy*)

        FunctionalChaosAlgorithm(*model, distribution, adaptiveStrategy, projectionStrategy*)

        FunctionalChaosAlgorithm(*inputSample, weights, outputSample, distribution, adaptiveStrategy*)

        FunctionalChaosAlgorithm(*inputSample, weights, outputSample, distribution, adaptiveStrategy, projectionStrategy*)

    Parameters
    ----------
    inputSample, outputSample : 2-d sequence of float
        Sample of the input - output random vectors
    model : :class:`~openturns.Function`
        Model :math:`g` such as :math:`\\vect{Y} = g(\\vect{X})`.
    distribution : :class:`~openturns.Distribution`
        Distribution of the random vector :math:`\\vect{X}`
    adaptiveStrategy : :class:`~openturns.AdaptiveStrategy`
        Strategy of selection of the different terms of the multivariate basis.
    projectionStrategy : :class:`~openturns.ProjectionStrategy`
        Strategy of evaluation of the coefficients :math:`\\alpha_k`
    weights : sequence of float
        Weights :math:`\\omega_i` associated to the data base

        Default values are :math:`\\omega_i = \\frac{1}{N}` where 
        *N=inputSample.getSize()*

    See also
    --------
    FunctionalChaosResult

    Notes
    -----
    Consider :math:`\\vect{Y} = g(\\vect{X})` with :math:`g: \\Rset^d \\rightarrow \\Rset^p`, 
    :math:`\\vect{X} \\sim \\cL_{\\vect{X}}` and :math:`\\vect{Y}` with finite variance: 
    :math:`g\\in L_{\\cL_{\\vect{X}}}^2(\\Rset^d, \\Rset^p)`.

    When  :math:`p>1`, the functional chaos algorithm is used on each marginal 
    of :math:`\\vect{Y}`, using the same multivariate orthonormal basis for all the marginals. 
    Thus, the algorithm is detailed here for a scalar output :math:`Y` and 
    :math:`g: \\Rset^d \\rightarrow \\Rset`.

    Let :math:`T: \\Rset^d \\rightarrow \\Rset^d` be an isoprobabilistic transformation
    such that :math:`\\vect{Z} = T(\\vect{X}) \\sim \\mu`. We note :math:`f = g \\circ T^{-1}`, then :math:`f \\in L_{\\mu}^2(\\Rset^d, \\Rset)`.

    Let :math:`(\\Psi_k)_{k \\in \\Nset}` be an orthonormal multivariate basis of 
    :math:`L^2_{\\mu}(\\Rset^d,\\Rset)`.

    Then the functional chaos decomposition of *f* writes:

    .. math::

        f = g\\circ T^{-1} = \\sum_{k=0}^{\\infty} \\vect{\\alpha}_k \\Psi_k 


    which can be truncated to the finite set :math:`K \\in \\Nset`:

    .. math::

        \\tilde{f} =  \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k 


    The approximation :math:`\\tilde{f}` can be used to build an efficient random 
    generator of :math:`Y` based on the random vector :math:`\\vect{Z}`. 
    It writes:

    .. math::

        \\tilde{Y} = \\tilde{f}(\\vect{Z})

    For more details, see :class:`~openturns.FunctionalChaosRandomVector`.

    The functional chaos decomposition can be used to build a meta model of *g*, 
    which writes:

    .. math::

        \\tilde{g} = \\tilde{f} \\circ T

    If the basis :math:`(\\Psi_k)_{k \\in \\Nset}` has been obtained by tensorisation of
    univariate orthonormal basis, then the distribution :math:`\\mu` writes  
    :math:`\\mu = \\prod_{i=1}^d \\mu_i`. In that case only, the Sobol indices can
    easily be deduced from the coefficients :math:`\\alpha_k`.

    We detail here all the steps required in order to create a functional chaos 
    algorithm.

    **Step 1 - Construction of the multivariate orthonormal basis**: the
    multivariate orthonornal basis :math:`(\\Psi_k(\\vect{x}))_{k \\in \\Nset}` is built
    as the tensor product of orthonormal univariate families.

    The univariate bases may be:

        - *polynomials*: the associated distribution :math:`\\mu_i` is continuous or discrete. 
          Note that it is possible to build the polynomial family orthonormal to any univariate 
          distribution :math:`\\mu_i` under some conditions. 
          For more details, see :class:`~openturns.StandardDistributionPolynomialFactory`;

        - Haar wavelets: they enable to approximate functions with discontinuities.
          For more details, see :class:`~openturns.HaarWaveletFactory`,;

        - Fourier series: for more details, see :class:`~openturns.FourierSeriesFactory`.

    Furthermore, the numerotation of the multivariate orthonormal basis :math:`(\\Psi_k(\\vect{z}))_k` 
    is given by an enumerate function which defines a regular way to generate the collection of degres 
    used for the univariate polynomials : an enumerate function represents a bijection 
    :math:`\\Nset \\rightarrow \\Nset^d`. See :class:`~openturns.LinearEnumerateFunction` or :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` 
    for more details.

    **Step 2 - Truncation strategy of the multivariate orthonormal basis**: a
    strategy must be chosen for the selection of the different terms of the
    multivariate basis. The selected terms are gathered in the subset *K*.

    For more details on the possible strategies, see :class:`~openturns.FixedStrategy`,
    :class:`~openturns.SequentialStrategy` and :class:`~openturns.CleaningStrategy`.

    **Step 3 -  Evaluation strategy of the coefficients**: a
    strategy must be chosen for the estimation of te coefficients :math:`\\alpha_k`. 
    The vector :math:`\\vect{\\alpha} = (\\alpha_k)_{k \\in K}` is equivalently defined by:

    .. math::
        :label: quadEr

        \\vect{\\alpha} = \\argmin_{\\vect{\\alpha} \\in \\Rset^K}\\Expect{\\left( g \\circ T^{-1}(\\vect{Z}) - \\sum_{k \\in K} \\alpha_k \\Psi_k (\\vect{Z})\\right)^2}

    or

    .. math::
        :label: scalProd

        \\alpha_k =  <g \\circ T^{-1}(\\vect{Z}), \\Psi_k (\\vect{Z})>_{\\mu} = \\Expect{  g \\circ T^{-1}(\\vect{Z}) \\Psi_k (\\vect{Z}) }

    where the mean :math:`\\Expect{.}` is evaluated with respect to the measure :math:`\\mu`.

    Relation :eq:`quadEr` means that the coefficients :math:`(\\alpha_k)_{k \\in K}`
    minimize the quadratic error between the model and the polynomial approximation.
    For more details, see :class:`~openturns.LeastSquaresStrategy`.

    Relation  :eq:`scalProd` means that :math:`\\alpha_k` is the scalar product of the
    model with the *k-th* element of the orthonormal basis :math:`(\\Psi_k)_{k \\in \\Nset}`.
    For more details, see :class:`~openturns.IntegrationStrategy`.

    Examples
    --------
    Create the model:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> inputDim = 1
    >>> model = ot.SymbolicFunction(['x'], ['x*sin(x)'])
    >>> distribution = ot.ComposedDistribution([ot.Uniform()]*inputDim)

    Build the multivariate orthonormal basis:

    >>> polyColl = [0.0]*inputDim
    >>> for i in range(distribution.getDimension()):
    ...     polyColl[i] = ot.StandardDistributionPolynomialFactory(distribution.getMarginal(i))
    >>> enumerateFunction = ot.LinearEnumerateFunction(inputDim)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)

    Define the  strategy to truncate the multivariate orthonormal basis:
    We choose all the polynomials of degree <= 4

    >>> degree = 4
    >>> indexMax = enumerateFunction.getStrataCumulatedCardinal(degree)
    >>> print(indexMax)
    5

    We keep all the polynomials of degree <= 4 (which corresponds to the 5 first ones):

    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, indexMax)

    Define the evaluation strategy of the  coefficients:

    >>> samplingSize = 50
    >>> experiment = ot.MonteCarloExperiment(samplingSize)
    >>> projectionStrategy = ot.LeastSquaresStrategy(experiment)

    Create the Functional Chaos Algorithm:

    >>> algo = ot.FunctionalChaosAlgorithm(model, distribution, adaptiveStrategy,
    ...                                    projectionStrategy)
    >>> algo.run()

    Get the result:

    >>> functionalChaosResult = algo.getResult()
    >>> metamodel = functionalChaosResult.getMetaModel()

    Test it:

    >>> X = [0.5]
    >>> print(model(X))
    [0.239713]
    >>> print(metamodel(X))
    [0.239514]

    """

    __swig_setmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalChaosAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalChaosAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.FunctionalChaosAlgorithm_getClassName(self)


    def __repr__(self):
        return _metamodel.FunctionalChaosAlgorithm___repr__(self)

    def setMaximumResidual(self, residual):
        """
        Set the maximum residual.

        Parameters
        ----------
        residual : float
            Residual value needed in the projection strategy. 

            Default value is :math:`0`.
        """
        return _metamodel.FunctionalChaosAlgorithm_setMaximumResidual(self, residual)


    def getMaximumResidual(self):
        """
        Get the maximum residual.

        Returns
        -------
        residual : float
            Residual value needed in the projection strategy. 

            Default value is :math:`0`.
        """
        return _metamodel.FunctionalChaosAlgorithm_getMaximumResidual(self)


    def setProjectionStrategy(self, projectionStrategy):
        """
        Set the projection strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.ProjectionStrategy`
            Strategy to estimate the coefficients :math:`\\alpha_k`.
        """
        return _metamodel.FunctionalChaosAlgorithm_setProjectionStrategy(self, projectionStrategy)


    def getProjectionStrategy(self):
        """
        Get the projection strategy.

        Returns
        -------
        strategy : :class:`~openturns.ProjectionStrategy`
            Projection strategy.

        Notes
        -----
        The projection strategy selects the different terms of the
        multivariate basis to define the subset *K*.
        """
        return _metamodel.FunctionalChaosAlgorithm_getProjectionStrategy(self)


    def getAdaptiveStrategy(self):
        """
        Get the adaptive strategy.

        Returns
        -------
        adaptiveStrategy : :class:`~openturns.AdaptiveStrategy`
            Strategy of selection of the different terms of the multivariate basis.
        """
        return _metamodel.FunctionalChaosAlgorithm_getAdaptiveStrategy(self)


    def run(self):
        """
        Compute the metamodel.

        Notes
        -----
        Evaluates the metamodel and stores all the results in a result structure.
        """
        return _metamodel.FunctionalChaosAlgorithm_run(self)


    def getResult(self):
        """
        Get the results of the metamodel computation.

        Returns
        -------
        result : :class:`~openturns.FunctionalChaosResult`
            Result structure, created by the method :py:meth:`run`.
        """
        return _metamodel.FunctionalChaosAlgorithm_getResult(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample of a model evaluated apart.
        """
        return _metamodel.FunctionalChaosAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample of a model evaluated apart.
        """
        return _metamodel.FunctionalChaosAlgorithm_getOutputSample(self)


    def __init__(self, *args):
        this = _metamodel.new_FunctionalChaosAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_FunctionalChaosAlgorithm
    __del__ = lambda self: None
FunctionalChaosAlgorithm_swigregister = _metamodel.FunctionalChaosAlgorithm_swigregister
FunctionalChaosAlgorithm_swigregister(FunctionalChaosAlgorithm)

class KrigingAlgorithm(MetaModelAlgorithm):
    """
    Kriging algorithm.

    Available constructors:
        KrigingAlgorithm(*inputSample, outputSample, covarianceModel, basis, normalize=True*)

        KrigingAlgorithm(*inputSample, inputTransformation, outputSample, covarianceModel, basis*)

        KrigingAlgorithm(*inputSample, outputSample, covarianceModel, basisCollection, normalize=True*)

        KrigingAlgorithm(*inputSample, inputTransformation, outputSample, covarianceModel, basisCollection*)

    Parameters
    ----------
    inputSample, outputSample : 2-d sequence of float
        The samples :math:`(\\vect{x}_k)_{1 \\leq k \\leq N} \\in \\Rset^d` and :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}\\in \\Rset^p` upon which the meta-model is built.
    inputTransformation : :class:`~openturns.Function`
        Function :math:`T` used to normalize the input sample.

        If used, the meta model is built on the transformed data.
    basis : :class:`~openturns.Basis`
        Functional basis to estimate the trend (universal kriging): :math:`(\\varphi_j)_{1 \\leq j \\leq n_1}: \\Rset^d \\rightarrow \\Rset`.

        If :math:`p>1`, the same basis is used for each marginal output.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Covariance model used for the underlying Gaussian process assumption.
    basisCollection : sequence of :class:`~openturns.Basis`
        Collection of :math:`p` functional basis: one basis for each marginal output: :math:`\\left[(\\varphi_j^1)_{1 \\leq j \\leq n_1}, \\dots, (\\varphi_j^p)_{1 \\leq j \\leq n_p}\\right]`. If the sequence is empty, no trend coefficient is estimated (simple kriging).
    normalize : bool, optional
        Indicates whether the input sample has to be normalized.

        OpenTURNS uses the transformation fixed by the User in *inputTransformation* or the empirical mean and variance of the input sample.
        Default is set in resource map key `GeneralLinearModelAlgorithm-NormalizeData`

    Notes
    -----
    We suppose we have a sample :math:`(\\vect{x}_k, \\vect{y}_k)_{1 \\leq k \\leq N}` where :math:`\\vect{y}_k = \\cM(\\vect{x}_k)` for all *k*, with :math:`\\cM:\\Rset^d \\mapsto \\Rset^p` the model.

    The meta model *Kriging* is based on the same principles as those of the generalized linear model: it assumes that the sample :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}` is considered as the trace of a normal process :math:`\\vect{Y}(\\omega, \\vect{x})` on :math:`(\\vect{x}_k)_{1 \\leq k \\leq N}`. The normal process :math:`\\vect{Y}(\\omega, \\vect{x})` is defined by:


    .. math::
        :label: metaModelKrigAlgo

        \\vect{Y}(\\omega, \\vect{x}) = \\vect{\\mu}(\\vect{x}) + W(\\omega, \\vect{x})

    where:

    .. math::

        \\vect{\\mu}(\\vect{x}) = \\left(
          \\begin{array}{l}
            \\mu_1(\\vect{x}) \\\\
            \\dots  \\\\
            \\mu_p(\\vect{x}) 
           \\end{array}
         \\right)

    with :math:`\\mu_l(\\vect{x}) = \\sum_{j=1}^{n_l} \\alpha_j^l \\varphi_j^l(\\vect{x})` and :math:`\\varphi_j^l: \\Rset^d \\rightarrow \\Rset` the trend functions.

    :math:`W` is a normal process of dimension *p* with zero mean and covariance function :math:`C = C(\\vect{\\theta}, \\vect{\\sigma}, \\mat{R}, \\vect{\\lambda})` (see :class:`~openturns.CovarianceModel` for the notations).

    The estimation of the parameters :math:`\\alpha_j^l, \\vect{\\theta}, \\vect{\\sigma}` are made by the :class:`~openturns.GeneralLinearModelAlgorithm` class.

    The Kriging algorithm makes the generalized linear model interpolary on the input samples. The Kriging meta model :math:`\\tilde{\\cM}` is defined by:


    .. math::

        \\tilde{\\cM}(\\vect{x}) =  \\vect{\\mu}(\\vect{x}) + \\Expect{\\vect{Y}(\\omega, \\vect{x})\\, | \\,  \\cC}

    where :math:`\\cC` is the condition :math:`\\vect{Y}(\\omega, \\vect{x}_k) = \\vect{y}_k` for each :math:`k \\in [1, N]`.

    :eq:`metaModelKrigAlgo` writes:

    .. math::

        \\tilde{\\cM}(\\vect{x}) = \\vect{\\mu}(\\vect{x}) + \\Cov{\\vect{Y}(\\omega, \\vect{x}), (\\vect{Y}(\\omega, \\vect{x}_1), \\dots, \\vect{Y}(\\omega, \\vect{x}_N))} \\vect{\\gamma}

    where :math:`\\Cov{\\vect{Y}(\\omega, \\vect{x}), (\\vect{Y}(\\omega, \\vect{x}_1), \\dots, \\vect{Y}(\\omega, \\vect{x}_N))} = \\left( \\mat{C}( \\vect{x},  \\vect{x}_1) | \\dots | \\mat{C}( \\vect{x},  \\vect{x}_N)  \\right)` is a matrix in :math:`\\cM_{p,NP}(\\Rset)` and :math:`\\vect{\\gamma} = \\mat{C}^{-1}(\\vect{y}-\\vect{m})`.

    A known centered gaussian observation noise :math:`\\epsilon_k` can be taken into account
    with :func:`setNoise()`:

    .. math:: \\hat{\\vect{y}}_k = \\vect{y}_k + \\epsilon_k, \\epsilon_k \\sim \\mathcal{N}(0, \\tau_k^2)

    Examples
    --------
    Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

    >>> import openturns as ot
    >>> # use of Hmat implementation
    >>> # ot.ResourceMap.Set('KrigingAlgorithm-LinearAlgebra', 'HMAT')
    >>> f = ot.SymbolicFunction(['x'], ['x * sin(x)'])
    >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
    >>> outputSample = f(inputSample)

    Create the algorithm:

    >>> basis = ot.ConstantBasisFactory().build()
    >>> covarianceModel = ot.SquaredExponential(1)
    >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, covarianceModel, basis)
    >>> algo.run()

    Get the resulting meta model:

    >>> result = algo.getResult()
    >>> metamodel = result.getMetaModel()
    """

    __swig_setmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KrigingAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KrigingAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.KrigingAlgorithm_getClassName(self)


    def __repr__(self):
        return _metamodel.KrigingAlgorithm___repr__(self)

    def run(self):
        """
        Compute the response surface.

        Notes
        -----
        It computes the kriging response surface and creates a
        :class:`~openturns.KrigingResult` structure containing all the results.
        """
        return _metamodel.KrigingAlgorithm_run(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample :math:`(\\vect{x}_k)_{1 \\leq k \\leq N}`.

        """
        return _metamodel.KrigingAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}` .

        """
        return _metamodel.KrigingAlgorithm_getOutputSample(self)


    def getResult(self):
        """
        Get the results of the metamodel computation.

        Returns
        -------
        result : :class:`~openturns.KrigingResult`
            Structure containing all the results obtained after computation
            and created by the method :py:meth:`run`.

        """
        return _metamodel.KrigingAlgorithm_getResult(self)


    def getOptimizationAlgorithm(self):
        """
        Accessor to solver used to optimize the covariance model parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.
        """
        return _metamodel.KrigingAlgorithm_getOptimizationAlgorithm(self)


    def setOptimizationAlgorithm(self, solver):
        """
        Accessor to the solver used to optimize the covariance model parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.

        Examples
        --------
        Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

        >>> import openturns as ot
        >>> input_data = ot.Uniform(-1.0, 2.0).getSample(10)
        >>> model = ot.SymbolicFunction(['x'], ['x-1+sin(_pi*x/(1+0.25*x^2))'])
        >>> output_data = model(input_data)

        Create the Kriging algorithm with the optimizer option:

        >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['0.0'])])
        >>> thetaInit = 1.0
        >>> covariance = ot.GeneralizedExponential([thetaInit], 2.0)
        >>> bounds = ot.Interval(1e-2,1e2)
        >>> algo = ot.KrigingAlgorithm(input_data, output_data, covariance, basis)
        >>> algo.setOptimizationBounds(bounds)

        """
        return _metamodel.KrigingAlgorithm_setOptimizationAlgorithm(self, solver)


    def getOptimizationSolver(self):
        return _metamodel.KrigingAlgorithm_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _metamodel.KrigingAlgorithm_setOptimizationSolver(self, solver)

    def setOptimizationBounds(self, optimizationBounds):
        """
        Accessor to the optimization bounds.

        Parameters
        ----------
        problem : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _metamodel.KrigingAlgorithm_setOptimizationBounds(self, optimizationBounds)


    def getOptimizationBounds(self):
        """
        Accessor to the optimization bounds.

        Returns
        -------
        problem : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _metamodel.KrigingAlgorithm_getOptimizationBounds(self)


    def getReducedLogLikelihoodFunction(self):
        """
        Accessor to the reduced log-likelihood function that writes as argument of the covariance's model parameters.

        Returns
        -------
        reducedLogLikelihood : :class:`~openturns.Function`
            The reduced log-likelihood function as a function of :math:`(\\vect{\\theta}, \\vect{\\sigma})`.

        Notes
        -----
        The reduced log-likelihood function may be useful for some pre/postprocessing: vizuaisation of the maximizer, use of an external optimizers to maximize the reduced log-likelihood etc.


        Examples
        --------
        Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
        >>> outputSample = f(inputSample)

        Create the algorithm:

        >>> basis = ot.ConstantBasisFactory().build()
        >>> covarianceModel = ot.SquaredExponential(1)
        >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, covarianceModel, basis)
        >>> algo.run()

        Get the reduced log-likelihood function:

        >>> reducedLogLikelihoodFunction = algo.getReducedLogLikelihoodFunction()

        """
        return _metamodel.KrigingAlgorithm_getReducedLogLikelihoodFunction(self)


    def getOptimizeParameters(self):
        """
        Accessor to the covariance model parameters optimization flag.

        Returns
        -------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _metamodel.KrigingAlgorithm_getOptimizeParameters(self)


    def setOptimizeParameters(self, optimizeParameters):
        """
        Accessor to the covariance model parameters optimization flag.

        Parameters
        ----------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _metamodel.KrigingAlgorithm_setOptimizeParameters(self, optimizeParameters)


    def setNoise(self, noise):
        """
        Observation noise variance accessor.

        Parameters
        ----------
        noise : sequence of positive float
            The noise variance :math:`\\tau_k^2` of each output value.
        """
        return _metamodel.KrigingAlgorithm_setNoise(self, noise)


    def getNoise(self):
        """
        Observation noise variance accessor.

        Returns
        -------
        noise : sequence of positive float
            The noise variance :math:`\\tau_k^2` of each output value.
        """
        return _metamodel.KrigingAlgorithm_getNoise(self)


    def __init__(self, *args):
        this = _metamodel.new_KrigingAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_KrigingAlgorithm
    __del__ = lambda self: None
KrigingAlgorithm_swigregister = _metamodel.KrigingAlgorithm_swigregister
KrigingAlgorithm_swigregister(KrigingAlgorithm)

class MetaModelValidation(openturns.common.PersistentObject):
    """
    Base class to score a metamodel and perform validations.

    Available constructor:
        MetaModelValidation(*inputValidationSample, outputValidationSample, metaModel*)

    Parameters
    ----------
    inputValidationSample, outputValidationSample : 2-d sequence of float
        The input and output validation samples, not used during the learning step.

    metaModel : :class:`~openturns.Function`
        Metamodel to validate.

    Notes
    -----
    A MetaModelValidation object is used for the validation process of a metamodel.
    For that purpose, a dataset independent of the learning step, is used to score the surrogate model.
    Its main functionalities are :

    - To compute the predictivity factor :math:`Q_2`
    - To get the residual sample, its non parametric distribution
    - To draw a `model vs metamodel` validation graph.


    Currently only one dimensional output models are available.

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi
    >>> dist = ot.Uniform(-pi/2, pi/2)
    >>> # Model here is sin(x)
    >>> model = ot.SymbolicFunction(['x'], ['sin(x)'])
    >>> # We can build several types of models (kriging, pc, ...)
    >>> # We use a Taylor developement (order 5) and compare the metamodel with the model
    >>> metaModel = ot.SymbolicFunction(['x'], ['x - x^3/6.0 + x^5/120.0'])
    >>> x = dist.getSample(10)
    >>> y = model(x)
    >>> # Validation of the model
    >>> val = ot.MetaModelValidation(x, y, metaModel)
    >>> # Compute the first indicator : q2
    >>> q2 = val.computePredictivityFactor()
    >>> # Get the residual
    >>> residual = val.getResidualSample()
    >>> # Get the histogram of residual
    >>> histoResidual = val.getResidualDistribution(False)
    >>> # Draw the validation graph
    >>> graph = val.drawValidation()

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MetaModelValidation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MetaModelValidation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.MetaModelValidation_getClassName(self)


    def __repr__(self):
        return _metamodel.MetaModelValidation___repr__(self)

    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample of a model evaluated apart.
        """
        return _metamodel.MetaModelValidation_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample of a model evaluated apart.
        """
        return _metamodel.MetaModelValidation_getOutputSample(self)


    def computePredictivityFactor(self):
        """
        Compute the predictivity factor.

        Returns
        -------
        q2 : float
            The predictivity factor

        Notes
        -----
        The predictivity factor :math:`Q_2` is given by :

        .. math::
            Q_2 = 1 - \\frac{\\sum_{l=1}^{N} Y_{l} -\\hat{f}(X_l)}{Var(Y)}
        """
        return _metamodel.MetaModelValidation_computePredictivityFactor(self)


    def getResidualSample(self):
        """
        Compute the residual sample.

        Returns
        -------
        residual : :class:`~openturns.Sample`
            The residual sample.

        Notes
        -----
        The residual sample is given by :

        .. math::
            \\epsilon_{l} = Y_{l} -\\hat{f}(X_l)
        """
        return _metamodel.MetaModelValidation_getResidualSample(self)


    def getResidualDistribution(self, smooth=True):
        """
        Compute the non parametric distribution of the residual sample.

        Parameters
        ----------
        smooth : bool
            Tells if distribution is smooth (true) or not.
            Default argument is true.

        Returns
        -------
        residualDistribution : :class:`~openturns.Distribution`
            The residual distribution.

        Notes
        -----
        The residual distribution is built thanks to :class:`~openturns.KernelSmoothing` if `smooth` argument is true. Otherwise, an histogram distribution is returned, thanks to :class:`~openturns.HistogramFactory`.
        """
        return _metamodel.MetaModelValidation_getResidualDistribution(self, smooth)


    def drawValidation(self):
        """
        Plot a model vs metamodel graph for visual validation.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The visual validation graph.
        """
        return _metamodel.MetaModelValidation_drawValidation(self)


    def __init__(self, *args):
        this = _metamodel.new_MetaModelValidation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_MetaModelValidation
    __del__ = lambda self: None
MetaModelValidation_swigregister = _metamodel.MetaModelValidation_swigregister
MetaModelValidation_swigregister(MetaModelValidation)

class GeneralLinearModelResult(MetaModelResult):
    """
    Generalized linear model result.

    Available constructors:
        GeneralLinearModelResult(*inputSample, outputSample, metaModel, residuals, relativeErrors, basis, trendCoefficients, covarianceModel, optimalLogLikelihood*)

        GeneralLinearModelResult(*inputSample, outputSample, metaModel, residuals, relativeErrors, basis, trendCoefficients, covarianceModel, covarianceCholeskyFactor, covarianceHMatrix, optimalLogLikelihood*)


    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample`
        The samples :math:`(\\vect{x}_k)_{1 \\leq k \\leq N} \\in \\Rset^d` and :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}\\in \\Rset^p`.
    metaModel : :class:`~openturns.Function`
        The meta model: :math:`\\tilde{\\cM}: \\Rset^d \\rightarrow \\Rset^p`, defined in :eq:'metaModel'.
    residuals : :class:`~openturns.Point`
        The residual errors.
    relativeErrors : :class:`~openturns.Point`
        The relative errors.
    basis : collection of :class:`~openturns.Basis`
        Collection of the  :math:`p` functional basis: :math:`(\\varphi_j^l: \\Rset^d \\rightarrow \\Rset)_{1 \\leq j \\leq n_l}` for each :math:`l \\in [1, p]`.
        Its size should be equal to zero if the trend is not estimated.
    trendCoefficients : collection of :class:`~openturns.Point`
       The trend coefficients vectors :math:`(\\vect{\\alpha}^1, \\dots, \\vect{\\alpha}^p)`.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Covariance function of the normal process with its optimized parameters.
    covarianceCholeskyFactor : :class:`~openturns.TriangularMatrix`
        The Cholesky factor :math:`\\mat{L}` of :math:`\\mat{C}`.
    covarianceHMatrix :  :class:`~openturns.HMatrix`
        The *hmat* implementation of :math:`\\mat{L}`.
    optimalLogLikelihood : float
        The maximum log-likelihood corresponding to the model.

    Notes
    -----
    The structure is usually created by the method *run()* of a :class:`~openturns.GeneralLinearModelAlgorithm`, and obtained thanks to the *getResult()* method.

    The meta model :math:`\\tilde{\\cM}: \\Rset^d \\rightarrow \\Rset^p` is defined by:

    .. math::
        :label: metaModel

        \\tilde{\\cM}(\\vect{x}) = \\left(
          \\begin{array}{l}
            \\mu_1(\\vect{x}) \\\\
            \\dots  \\\\
            \\mu_p(\\vect{x}) 
           \\end{array}
         \\right)

    where :math:`\\mu_l(\\vect{x}) = \\sum_{j=1}^{n_l} \\alpha_j^l \\varphi_j^l(\\vect{x})` and :math:`\\varphi_j^l: \\Rset^d \\rightarrow \\Rset` are the trend functions.

    If a normalizing transformation *T* has been used, the meta model is built on the inputs :math:`\\vect{z}_k = T(\\vect{x}_k)` and the meta model writes:

    .. math::
        :label: metaModelWithT

        \\tilde{\\cM}(\\vect{x}) = \\left(
          \\begin{array}{l}
            \\mu_1\\circ T(\\vect{x}) \\\\
            \\dots  \\\\
            \\mu_p\\circ T(\\vect{x}) 
           \\end{array}
         \\right)

    Examples
    --------
    Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x'],  ['x * sin(x)'])
    >>> sampleX = [[1.0], [2.0], [3.0], [4.0], [5.0], [6.0]]
    >>> sampleY = f(sampleX)

    Create the algorithm:

    >>> basis = ot.Basis([ot.SymbolicFunction(['x'], ['x']), ot.SymbolicFunction(['x'], ['x^2'])])
    >>> covarianceModel = ot.GeneralizedExponential([2.0], 2.0)
    >>> algo = ot.GeneralLinearModelAlgorithm(sampleX, sampleY, covarianceModel, basis)
    >>> algo.run()

    Get the result:

    >>> result = algo.getResult()

    Get the meta model:

    >>> metaModel = result.getMetaModel()
    >>> graph = metaModel.draw(0.0, 7.0)
    >>> cloud = ot.Cloud(sampleX, sampleY)
    >>> cloud.setPointStyle('fcircle')
    >>> graph = ot.Graph()
    >>> graph.add(cloud)
    >>> graph.add(f.draw(0.0, 7.0))
    >>> graph.setColors(['black', 'blue', 'red'])

    """

    __swig_setmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralLinearModelResult, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralLinearModelResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.GeneralLinearModelResult_getClassName(self)


    def __repr__(self):
        return _metamodel.GeneralLinearModelResult___repr__(self)

    def __str__(self, *args):
        return _metamodel.GeneralLinearModelResult___str__(self, *args)

    def getBasisCollection(self):
        """
        Accessor to the collection of basis.

        Returns
        -------
        basisCollection : collection of :class:`~openturns.Basis`
            Collection of the :math:`p` function basis: :math:`(\\varphi_j^l: \\Rset^d \\rightarrow \\Rset)_{1 \\leq j \\leq n_l}` for each :math:`l \\in [1, p]`.

        Notes
        -----
        If the trend is not estimated, the collection is empty. 

        """
        return _metamodel.GeneralLinearModelResult_getBasisCollection(self)


    def getTrendCoefficients(self):
        """
        Accessor to the trend coefficients.

        Returns
        -------
        trendCoef : collection of :class:`~openturns.Point`
            The trend coefficients vectors :math:`(\\vect{\\alpha}^1, \\dots, \\vect{\\alpha}^p)`

        """
        return _metamodel.GeneralLinearModelResult_getTrendCoefficients(self)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model of the Normal process *W*.

        """
        return _metamodel.GeneralLinearModelResult_getCovarianceModel(self)


    def getTransformation(self):
        """
        Accessor to the normalizing transformation.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The transformation *T* that normalizes the input sample.

        """
        return _metamodel.GeneralLinearModelResult_getTransformation(self)


    def setTransformation(self, transformation):
        """
        Set accessor to the normalizing transformation.

        Parameters
        ----------
        transformation : :class:`~openturns.Function`
            The transformation *T* that normalizes the input sample.

        """
        return _metamodel.GeneralLinearModelResult_setTransformation(self, transformation)


    def getNoise(self):
        """
        Accessor to the normal process.

        Returns
        -------
        process : :class:`~openturns.Process`
            Returns the normal process :math:`W` with the optimized parameters.

        """
        return _metamodel.GeneralLinearModelResult_getNoise(self)


    def getOptimalLogLikelihood(self):
        """
        Accessor to the optimal log-likelihood of the model.

        Returns
        -------
        optimalLogLikelihood : float
            The value of the log-likelihood corresponding to the model.

        """
        return _metamodel.GeneralLinearModelResult_getOptimalLogLikelihood(self)


    def __init__(self, *args):
        this = _metamodel.new_GeneralLinearModelResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_GeneralLinearModelResult
    __del__ = lambda self: None
GeneralLinearModelResult_swigregister = _metamodel.GeneralLinearModelResult_swigregister
GeneralLinearModelResult_swigregister(GeneralLinearModelResult)


# deprecated
class GeneralizedLinearModelResult(GeneralLinearModelResult):
    def __init__(self, *args):
        super(GeneralizedLinearModelResult, self).__init__(*args)
        openturns.common.Log.Warn('class GeneralizedLinearModelResult is deprecated in favor of GeneralLinearModelResult')

class GeneralLinearModelAlgorithm(MetaModelAlgorithm):
    """
    Algorithm for the evaluation of general linear models.

    Available constructors:
        GeneralLinearModelAlgorithm(*inputSample, outputSample, covarianceModel, basis, normalize=True, keepCovariance=True*)

        GeneralLinearModelAlgorithm(*inputSample, inputTransformation, outputSample, covarianceModel, basis, keepCovariance=True*)

        GeneralLinearModelAlgorithm(*inputSample, outputSample, covarianceModel, basisCollection, normalize=True, keepCovariance=True*)

        GeneralLinearModelAlgorithm(*inputSample, inputTransformation, outputSample, covarianceModel, basisCollection, keepCovariance=True*)

    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample` or 2d-array
        The samples :math:`(\\vect{x}_k)_{1 \\leq k \\leq N} \\in \\Rset^n` and :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}\\in \\Rset^d`.
    inputTransformation : :class:`~openturns.Function`
        Function :math:`T` used to normalize the input sample.

        If used, the meta model is built on the transformed data.
    basis : :class:`~openturns.Basis`
        Functional basis to estimate the trend: :math:`(\\varphi_j)_{1 \\leq j \\leq n_1}: \\Rset^n \\rightarrow \\Rset`. 

        If :math:`d>1`, the same basis is used for each marginal output.
    basisCollection : collection of :class:`~openturns.Basis`
        Collection of :math:`d` functional basis: one basis for each marginal output.

        An empty collection means that no trend is estimated.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Covariance model of the normal process. See notes for the details.
    normalize : bool, optional
        Indicates whether the input sample has to be normalized.

        OpenTURNS uses the transformation fixed by the User in *inputTransformation* or the empirical mean and variance of the input sample.
        Default is set in resource map key `GeneralLinearModelAlgorithm-NormalizeData`
    keepCovariance : bool, optional
        Indicates whether the covariance matrix has to be stored in the result structure *GeneralLinearModelResult*.
        Default is set in resource map key `GeneralLinearModelAlgorithm-KeepCovariance`

    Notes
    -----
    We suppose we have a sample :math:`(\\vect{x}_k, \\vect{y}_k)_{1 \\leq k \\leq N}` where :math:`\\vect{y}_k = \\cM(\\vect{x}_k)` for all :math:`k`, with :math:`\\cM:\\Rset^n \\mapsto \\Rset^d` a given function.

    The objective is to build a metamodel :math:`\\tilde{\\cM}`, using a **generalized linear model**: the sample :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}` is considered as the restriction of a normal process :math:`\\vect{Y}(\\omega, \\vect{x})` on :math:`(\\vect{x}_k)_{1 \\leq k \\leq N}`. The normal process :math:`\\vect{Y}(\\omega, \\vect{x})` is defined by:

    .. math::

        \\vect{Y}(\\omega, \\vect{x}) = \\vect{\\mu}(\\vect{x}) + \\vect{W}(\\omega, \\vect{x})

    where:

    .. math::

        \\vect{\\mu}(\\vect{x}) = \\left(
          \\begin{array}{l}
            \\mu_1(\\vect{x}) \\\\
            \\dots  \\\\
            \\mu_d(\\vect{x}) 
           \\end{array}
         \\right)

    with :math:`\\mu_\\ell(\\vect{x}) = \\sum_{j=1}^{n_\\ell} \\beta_j^\\ell \\varphi_j^\\ell(\\vect{x})` and :math:`\\varphi_j^\\ell: \\Rset^n \\rightarrow \\Rset` the trend functions.

    :math:`\\vect{W}` is a normal process of dimension :math:`d` with zero mean and covariance function :math:`C = C(\\vect{\\theta}, \\vect{\\sigma}, \\mat{R}, \\vect{\\lambda})` (see :class:`~openturns.CovarianceModel` for the notations).

    We note:

    .. math::

        \\vect{\\beta}^\\ell = \\left(
          \\begin{array}{l}
            \\beta_1^\\ell \\\\
            \\dots  \\\\
            \\beta_{n_\\ell}^\\ell
           \\end{array}
         \\right) \\in \\Rset^{n_\\ell}
         \\quad \\mbox{ and } \\quad 
         \\vect{\\beta} = \\left(
          \\begin{array}{l}
             \\vect{\\beta}^1\\\\
            \\dots  \\\\
             \\vect{\\beta}^d
           \\end{array}
         \\right)\\in \\Rset^{\\sum_{\\ell=1}^p n_\\ell}


    The *GeneralLinearModelAlgorithm* class estimates the coefficients :math:`\\beta_j^\\ell, \\vect{p}` where :math:`\\vect{p}` is the vector of parameters of the covariance model (a subset of :math:`\\vect{\\theta}, \\vect{\\sigma}, \\mat{R}, \\vect{\\lambda}`) that has been declared as *active* (by default, the full vectors :math:`\\vect{\\theta}` and :math:`\\vect{\\sigma}`).

    The estimation is done by maximizing the *reduced* log-likelihood of the model, see its expression below.

    If a normalizing transformation :math:`T` has been used, the meta model is built on the inputs :math:`\\vect{z}_k = T(\\vect{x}_k)`.

    **Estimation of the parameters** :math:`\\beta_j^\\ell, \\vect{p}`

    We note:

    .. math::

        \\vect{y} = \\left(
          \\begin{array}{l}
            \\vect{y}_1 \\\\
            \\dots  \\\\
            \\vect{y}_N
           \\end{array}
         \\right) \\in \\Rset^{dN},
         \\quad 
         \\vect{m}_{\\vect{\\beta}} = \\left(
          \\begin{array}{l}
            \\vect{\\mu}(\\vect{x}_1) \\\\
            \\dots  \\\\
            \\vect{\\mu}(\\vect{x}_N)
           \\end{array}
         \\right) \\in \\Rset^{dN}

     and 

    .. math::

        \\mat{C}_{\\vect{p}} = \\left(
          \\begin{array}{lcl}
            \\mat{C}_{11} & \\dots &  \\mat{C}_{1N}\\\\
            \\dots & \\dots & \\\\
            \\mat{C}_{N1} & \\dots &  \\mat{C}_{NN}
           \\end{array}
         \\right) \\in \\cS_{dN}^+(\\Rset)

    where :math:`\\mat{C}_{ij} = C_{\\vect{p}}(\\vect{x}_i, \\vect{x}_j)`. 

    The model likelihood writes:

    .. math::

        \\cL(\\vect{\\beta}, \\vect{p};(\\vect{x}_k, \\vect{y}_k)_{1 \\leq k \\leq N}) = \\dfrac{1}{(2\\pi)^{dN/2} |\\det \\mat{C}_{\\vect{p}}|^{1/2}} \\exp\\left[ -\\dfrac{1}{2}\\Tr{\\left( \\vect{y}-\\vect{m} \\right)} \\mat{C}_{\\vect{p}}^{-1}  \\left( \\vect{y}-\\vect{m} \\right)  \\right]

    If :math:`\\mat{L}` is the Cholesky factor of :math:`\\mat{C}`, ie the lower triangular matrix with positive diagonal such that :math:`\\mat{L}\\,\\Tr{\\mat{L}} = \\mat{C}`, then:

    .. math::
        :label: logLikelihood

        \\log \\cL(\\vect{\\beta}, \\vect{p};(\\vect{x}_k, \\vect{y}_k)_{1 \\leq k \\leq N}) = cste - \\log \\det \\mat{L}_{\\vect{p}} -\\dfrac{1}{2}  \\| \\mat{L}_{\\vect{p}}^{-1}(\\vect{y}-\\vect{m}_{\\vect{\\beta}}) \\|^2

    The maximization of :eq:`logLikelihood` leads to the following optimality condition for $\\vect{\\beta}$:

    .. math::

        \\vect{\\beta}^*(\\vect{p}^*)=\\argmin_{\\vect{\\beta}} \\| \\mat{L}_{\\vect{p}^*}^{-1}(\\vect{y}-\\vect{m}_{\\vect{\\beta}}) \\|^2

    This expression of :math:`\\vect{\\beta}^*` as a function of :math:`\\vect{p}^*` is taken as a general relation between :math:`\\vect{\\beta}` and :math:`_vect{p}` and is substituted into :eq:`logLikelihood`, leading to a *reduced log-likelihood* function depending solely on :math:`\\vect{p}`.

    In the particular case where :math:`d=\\dim(\\vect{\\sigma})=1` and :math:`\\sigma` is a part of :math:`\\vect{p}`, then a further reduction is possible. In this case, if :math:`\\vect{q}` is the vector :math:`\\vect{p}` in which :math:`\\sigma` has been substituted by 1, then:

    .. math::

        \\| \\mat{L}_{\\vect{p}}^{-1}(\\vect{y}-\\vect{m}_{\\vect{\\beta}}) \\|^2=\\| \\mat{L}_{\\vect{q}}^{-1}(\\vect{y}-\\vect{m}_{\\vect{\\beta}}) \\|^2/\\sigma^2

    showing that :math:`\\vect{\\beta}^*` is a function of :math:`\\vect{q}^*` only, and the optimality condition for :math:`\\sigma` reads:

    .. math::

        \\vect{\\sigma}^*(\\vect{q}^*)=\\dfrac{1}{N}\\| \\mat{L}_{\\vect{q}^*}^{-1}(\\vect{y}-\\vect{m}_{\\vect{\\beta}^*(\\vect{q}^*)}) \\|^2

    which leads to a further reduction of the log-likelihood function where both :math:`\\vect{\\beta}` and :math:`\\sigma` are replaced by their expression in terms of :math:`\\vect{q}`.

    The default optimizer is :class:`~openturns.TNC` and can be changed thanks to the *setOptimizationAlgorithm* method. User could also change the default optimization solver by setting the `GeneralLinearModelAlgorithm-DefaultOptimizationAlgorithm` resource map key to `NELDER-MEAD` or `LBFGS` respectively for Nelder-Mead and LBFGS-B solvers.

    It is also possible to proceed as follows:

        - ask for the reduced log-likelihood function of the *GeneralLinearModelAlgorithm* thanks to the *getObjectiveFunction()* method
        - optimize it with respect to the parameters :math:`\\vect{\\theta}` and  :math:`\\vect{\\sigma}` using any optimisation algorithms (that can take into account some additional constraints if needed)
        - set the optimal parameter value into the covariance model used in the *GeneralLinearModelAlgorithm*
        - tell the algorithm not to optimize the parameter using *setOptimizeParameter*

    The behaviour of the reduction is controlled by the following keys in :class:`~openturns.ResourceMap`:
        - *ResourceMap.SetAsBooletAsBool('GeneralLinearModelAlgorithm-UseAnalyticalAmplitudeEstimate', true)* to use the reduction associated to :math:`\\sigma`. It has no effect if :math:`d>1` or if :math:`d=1` and :math:`\\sigma` is not part of :math:`\\vect{p}`
        - *ResourceMap.SetAsBool('GeneralLinearModelAlgorithm-UnbiasedVariance', true)* allows to use the *unbiased* estimate of :math:`sigma` where :math:`\\dfrac{1}{N}` is replaced by :math:`\\dfrac{1}{N-p}` in the optimality condition for :math:`\\sigma`.

    With huge samples, the `hierarchical matrix <http://en.wikipedia.org/wiki/Hierarchical_matrix>`_  implementation could be used if OpenTURNS had been compiled with `hmat-oss` support.

    This implementation, which is based on a compressed representation of an approximated covariance matrix (and its Cholesky factor), has a better complexity both in terms of memory requirements and floating point operations. To use it, the `GeneralLinearModelAlgorithm-LinearAlgebra` resource map key should be instancied to `HMAT`. Default value of the key is `LAPACK`.

    A known centered gaussian observation noise :math:`\\epsilon_k` can be taken into account
    with :func:`setNoise()`:

    .. math:: \\hat{\\vect{y}}_k = \\vect{y}_k + \\epsilon_k, \\epsilon_k \\sim \\mathcal{N}(0, \\tau_k^2)

    Examples
    --------
    Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['x'], ['x * sin(x)'])
    >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
    >>> outputSample = f(inputSample)

    Create the algorithm:

    >>> basis = ot.ConstantBasisFactory().build()
    >>> covarianceModel = ot.SquaredExponential(1)
    >>> algo = ot.GeneralLinearModelAlgorithm(inputSample, outputSample, covarianceModel, basis)
    >>> algo.run()

    Get the resulting meta model:

    >>> result = algo.getResult()
    >>> metamodel = result.getMetaModel()
    """

    __swig_setmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralLinearModelAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralLinearModelAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.GeneralLinearModelAlgorithm_getClassName(self)


    def __repr__(self):
        return _metamodel.GeneralLinearModelAlgorithm___repr__(self)

    def run(self):
        """
        Compute the response surface.

        Notes
        -----
        It computes the response surface and creates a
        :class:`~openturns.GeneralLinearModelResult` structure containing all the results.
        """
        return _metamodel.GeneralLinearModelAlgorithm_run(self)


    def setInputTransformation(self, inputTransformation):
        """
        Set the function normalizing the input.

        Parameters
        ----------
        transformation : :class:`~openturns.Function`
            Function that normalizes the input.
            The input dimension should be the same as input's sample dimension, output dimension
            should be output sample's dimension
        """
        return _metamodel.GeneralLinearModelAlgorithm_setInputTransformation(self, inputTransformation)


    def getInputTransformation(self):
        """
        Get the function normalizing the input.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            Function *T* that normalizes the input.
        """
        return _metamodel.GeneralLinearModelAlgorithm_getInputTransformation(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample :math:`(\\vect{x}_k)_{1 \\leq k \\leq N}`.
        """
        return _metamodel.GeneralLinearModelAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample :math:`(\\vect{y}_k)_{1 \\leq k \\leq N}` .
        """
        return _metamodel.GeneralLinearModelAlgorithm_getOutputSample(self)


    def getResult(self):
        """
        Get the results of the metamodel computation.

        Returns
        -------
        result : :class:`~openturns.GeneralLinearModelResult`
            Structure containing all the results obtained after computation
            and created by the method :py:meth:`run`.

        """
        return _metamodel.GeneralLinearModelAlgorithm_getResult(self)


    def getObjectiveFunction(self):
        """
        Accessor to the log-likelihood function that writes as argument of the covariance's model parameters.

        Returns
        -------
        logLikelihood : :class:`~openturns.Function`
            The log-likelihood function degined in :eq:`logLikelihood` as a function of :math:`(\\vect{\\theta}, \\vect{\\sigma})`.

        Notes
        -----
        The log-likelihood function may be useful for some postprocessing: maximization using external optimizers for example.


        Examples
        --------
        Create the model :math:`\\cM: \\Rset \\mapsto \\Rset` and the samples:

        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> inputSample = ot.Sample([[1.0], [3.0], [5.0], [6.0], [7.0], [8.0]])
        >>> outputSample = f(inputSample)

        Create the algorithm:

        >>> basis = ot.ConstantBasisFactory().build()
        >>> covarianceModel = ot.SquaredExponential(1)
        >>> algo = ot.GeneralLinearModelAlgorithm(inputSample, outputSample, covarianceModel, basis)
        >>> algo.run()

        Get the log-likelihood function:

        >>> likelihoodFunction = algo.getObjectiveFunction()

        """
        return _metamodel.GeneralLinearModelAlgorithm_getObjectiveFunction(self)


    def getOptimizationAlgorithm(self):
        """
        Accessor to solver used to optimize the covariance model parameters.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.
            Default optimizer is :class:`~openturns.TNC`
        """
        return _metamodel.GeneralLinearModelAlgorithm_getOptimizationAlgorithm(self)


    def setOptimizationAlgorithm(self, solver):
        """
        Accessor to the solver used to optimize the covariance model parameters.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationAlgorithm`
            Solver used to optimize the covariance model parameters.
        """
        return _metamodel.GeneralLinearModelAlgorithm_setOptimizationAlgorithm(self, solver)


    def getOptimizationSolver(self):
        return _metamodel.GeneralLinearModelAlgorithm_getOptimizationSolver(self)

    def setOptimizationSolver(self, solver):
        return _metamodel.GeneralLinearModelAlgorithm_setOptimizationSolver(self, solver)

    def getOptimizeParameters(self):
        """
        Accessor to the covariance model parameters optimization flag.

        Returns
        -------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _metamodel.GeneralLinearModelAlgorithm_getOptimizeParameters(self)


    def setOptimizeParameters(self, optimizeParameters):
        """
        Accessor to the covariance model parameters optimization flag.

        Parameters
        ----------
        optimizeParameters : bool
            Whether to optimize the covariance model parameters.
        """
        return _metamodel.GeneralLinearModelAlgorithm_setOptimizeParameters(self, optimizeParameters)


    def setOptimizationBounds(self, optimizationBounds):
        """
        Optimization bounds accessor.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Bounds for covariance model parameter optimization.
        """
        return _metamodel.GeneralLinearModelAlgorithm_setOptimizationBounds(self, optimizationBounds)


    def getOptimizationBounds(self):
        """
        Optimization bounds accessor.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Bounds for covariance model parameter optimization.
        """
        return _metamodel.GeneralLinearModelAlgorithm_getOptimizationBounds(self)


    def setNoise(self, noise):
        """
        Observation noise variance accessor.

        Parameters
        ----------
        noise : sequence of positive float
            The noise variance :math:`\\tau_k^2` of each output value.
        """
        return _metamodel.GeneralLinearModelAlgorithm_setNoise(self, noise)


    def getNoise(self):
        """
        Observation noise variance accessor.

        Parameters
        ----------
        noise : sequence of positive float
            The noise variance :math:`\\tau_k^2` of each output value.
        """
        return _metamodel.GeneralLinearModelAlgorithm_getNoise(self)


    def __init__(self, *args):
        this = _metamodel.new_GeneralLinearModelAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_GeneralLinearModelAlgorithm
    __del__ = lambda self: None
GeneralLinearModelAlgorithm_swigregister = _metamodel.GeneralLinearModelAlgorithm_swigregister
GeneralLinearModelAlgorithm_swigregister(GeneralLinearModelAlgorithm)


# deprecated
class GeneralizedLinearModelAlgorithm(GeneralLinearModelAlgorithm):
    def __init__(self, *args):
        super(GeneralizedLinearModelAlgorithm, self).__init__(*args)
        openturns.common.Log.Warn('class GeneralizedLinearModelAlgorithm is deprecated in favor of GeneralLinearModelAlgorithm')


class PythonRandomVector(object):
    """
    Allow to overload RandomVector from Python.

    Parameters
    ----------
    dim : positive int
        Vector dimension.
        Default is 0.

    See also
    --------
    RandomVector

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)

    Overload RandomVector from Python:

    >>> class RVEC(ot.PythonRandomVector):
    ...    def __init__(self):
    ...        super(RVEC, self).__init__(2)
    ...        self.setDescription(['R', 'S'])
    ...
    ...    def getRealization(self):
    ...        X = [ot.RandomGenerator.Generate(), 2 + ot.RandomGenerator.Generate()]
    ...        return X
    ...
    ...    def getSample(self, size):
    ...        X = []
    ...        for i in range(size):
    ...            X.append([ot.RandomGenerator.Generate(), 2 + ot.RandomGenerator.Generate()])
    ...        return X
    ...
    ...    def getMean(self):
    ...        return [0.5, 2.5]
    ...
    ...    def getCovariance(self):
    ...        return [[0.0833333, 0.], [0., 0.0833333]]

    Use the overloaded class:

    >>> R = RVEC()
    >>> # Instance creation
    >>> myRV = ot.RandomVector(R)
    >>> # Realization
    >>> print(myRV.getRealization())
    [0.629877,2.88281]
    >>> # Sample
    >>> print(myRV.getSample(5))
    0 : [ 0.135276  2.0325    ]
    1 : [ 0.347057  2.96942   ]
    2 : [ 0.92068   2.50304   ]
    3 : [ 0.0632061 2.29276   ]
    4 : [ 0.714382  2.38336   ]
    >>> # Mean
    >>> print(myRV.getMean())
    [0.5,2.5]
    >>> # Covariance
    >>> print(myRV.getCovariance())
    [[ 0.0833333 0         ]
     [ 0         0.0833333 ]]

    """
    def __init__(self, dim=0):
# Warning: these names are used in PythonRandomVectorImplementation class. Synchronize the files if changed
        self.__dim = dim
        self.__desc = list(map(lambda i: 'x' + str(i), range(dim)))

    def __str__(self):
        return 'PythonRandomVector -> %s #%d' % (self.__desc, self.__dim)

    def __repr__(self):
        return self.__str__()

    def getDimension(self):
        """
        Get the dimension.

        Returns
        -------
        dim : positive int
            Dimension of the RandomVector.
        """
        return self.__dim

    def setDescription(self, desc):
        """
        Set the description.

        Parameters
        ----------
        desc : sequence of str
            *desc* describes the components of the RandomVector.
            Its size must be equal to the dimension of the RandomVector.
        """
        if (len(desc) != self.__dim):
            raise ValueError('Description size does NOT match dimension')
        self.__desc = desc

    def getDescription(self):
        """
        Get the description.

        Returns
        -------
        desc : :class:`~openturns.Description`
            *desc* describes the components of the RandomVector.
        """
        return self.__desc

    def getRealization(self):
        """
        Get a realization of the random vector.

        Returns
        -------
        realization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
        """
        raise RuntimeError('You must define a method getRealization() -> X, where X is a Point')

    def getMean(self):
        """
        Get the mean.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the RandomVector.
        """
        raise RuntimeError('You must define a method mean -> X, where X is a Point')

    def getCovariance(self):
        """
        Get the covariance.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the RandomVector.
        """
        raise RuntimeError('You must define a method var -> M, where M is a CovarianceMatrix')

class SciPyRandomVector(PythonRandomVector):
    """
    Build a PythonRandomVector from a scipy distribution.

    Parameters
    ----------
    dist : a scipy.stats distribution
        the distribution to wrap
    """
    def __init__(self, dist):
        super(SciPyRandomVector, self).__init__(1)
        if dist.__class__.__name__ != 'rv_frozen':
            raise TypeError('Argument is not a scipy distribution')
        self._dist = dist

    def getRealization(self):
        rvs = self._dist.rvs()
        return [rvs]

    def getSample(self, size):
        rvs = self._dist.rvs(size)
        return rvs.reshape(size, 1)

    def getMean(self):
        mean = float(self._dist.stats('m'))
        return [mean]

    def getCovariance(self):
        var = float(self._dist.stats('v'))
        return [[var]]


class RandomVectorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomVectorImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomVectorImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _metamodel.new_RandomVectorImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _metamodel.RandomVectorImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _metamodel.RandomVectorImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _metamodel.RandomVectorImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _metamodel.RandomVectorImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _metamodel.delete_RandomVectorImplementationTypedInterfaceObject
    __del__ = lambda self: None
RandomVectorImplementationTypedInterfaceObject_swigregister = _metamodel.RandomVectorImplementationTypedInterfaceObject_swigregister
RandomVectorImplementationTypedInterfaceObject_swigregister(RandomVectorImplementationTypedInterfaceObject)

class RandomVector(RandomVectorImplementationTypedInterfaceObject):
    """
    Random vectors.

    Available constructors:
        RandomVector(*points*)

        RandomVector(*distribution*)

        RandomVector(*distribution, randomParameters*)

        RandomVector(*function, antecedent*)

        RandomVector(*functionalChaosResult*)

    Parameters
    ----------
    points : sequence of float
        Sequence of values defining a :class:`~openturns.ConstantRandomVector`.
    distribution : :class:`~openturns.Distribution`
        Distribution of the :class:`~openturns.UsualRandomVector` to define.
    randomParameters : :class:`~openturns.RandomVector`
        RandomVector to define a distribution-based conditional vector.
        It defines random parameters for *distribution*.
    antecedent : :class:`~openturns.RandomVector`
        RandomVector :math:`\\vect{X}` of Usual type to define a
        :class:`~openturns.CompositeRandomVector` as the image through the function
        :math:`f` of :math:`\\vect{X}`: :math:`\\vect{Y}=f(\\vect{X})`.
    function : :class:`~openturns.Function`
        Function :math:`f` to define a :class:`~openturns.CompositeRandomVector` as
        the image through this function of the antecedent :math:`\\vect{X}`:
        :math:`\\vect{Y}=f(\\vect{X})`.
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Result to define a :class:`~openturns.FunctionalChaosRandomVector` as the
        image through a functional chaos approximation model of the associated
        :class:`~openturns.UsualRandomVector`.


    Notes
    -----
    A :class:`~openturns.RandomVector` provides at least a way to generate realizations. OpenTURNS provides two kinds of  :class:`~openturns.RandomVector` :

        - those described by their :class:`~openturns.Distribution`: :class:`~openturns.UsualRandomVector` which provide some extra probbilistic methods.
        - those described as the image through a function of a :class:`~openturns.UsualRandomVector`: :math:`Y=f(X)`: :class:`~openturns.CompositeRandomVector` whcih can only generate realizations.

    See also
    --------
    UsualRandomVector, CompositeRandomVector, ConditionalRandomVector,
    ConstantRandomVector, PosteriorRandomVector, FunctionalChaosRandomVector, Event,
    PythonRandomVector
    """

    __swig_setmethods__ = {}
    for _s in [RandomVectorImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [RandomVectorImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.RandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.RandomVector___repr__(self)

    def __str__(self, *args):
        return _metamodel.RandomVector___str__(self, *args)

    def setDescription(self, description):
        """
        Accessor to the description of the RandomVector.

        Parameters
        ----------
        description : str or sequence of str
            Describes the components of the RandomVector.
        """
        return _metamodel.RandomVector_setDescription(self, description)


    def getDescription(self):
        """
        Accessor to the description of the RandomVector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Describes the components of the RandomVector.
        """
        return _metamodel.RandomVector_getDescription(self)


    def isComposite(self):
        """
        Accessor to know if the RandomVector is a composite one.

        Returns
        -------
        isComposite : bool
            Indicates if the RandomVector is of type Composite or not.
        """
        return _metamodel.RandomVector_isComposite(self)


    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.RandomVector_getDimension(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.RandomVector_getRealization(self)


    def getSample(self, size):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _metamodel.RandomVector_getSample(self, size)


    def getMarginal(self, *args):
        """
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\\vect{Y}=\\Tr{(Y_1,\\dots,Y_n)}` a random vector and
        :math:`I \\in [1,n]` a set of indices. If :math:`\\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\\tilde{\\vect{Y}}=\\Tr{(Y_i)}_{i \\in I}`. If :math:`\\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\\vect{Y}=f(\\vect{X})` with :math:`f=(f_1,\\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\\tilde{\\vect{Y}}=(f_i(\\vect{X}))_{i \\in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _metamodel.RandomVector_getMarginal(self, *args)


    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _metamodel.RandomVector_getMean(self)


    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _metamodel.RandomVector_getCovariance(self)


    def getAntecedent(self):
        """
        Accessor to the antecedent RandomVector in case of a composite RandomVector.

        Returns
        -------
        antecedent : :class:`~openturns.RandomVector`
            Antecedent RandomVector :math:`\\vect{X}` in case of a
            :class:`~openturns.CompositeRandomVector` such as:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _metamodel.RandomVector_getAntecedent(self)


    def getFunction(self):
        """
        Accessor to the Function in case of a composite RandomVector.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function used to define a :class:`~openturns.CompositeRandomVector` as the
            image through this function of the antecedent :math:`\\vect{X}`:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _metamodel.RandomVector_getFunction(self)


    def getDistribution(self):
        """
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _metamodel.RandomVector_getDistribution(self)


    def getOperator(self):
        """
        Accessor to the comparaison operator of the Event.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            Comparaison operator used to define the :class:`~openturns.Event`.
        """
        return _metamodel.RandomVector_getOperator(self)


    def getThreshold(self):
        """
        Accessor to the threshold of the Event.

        Returns
        -------
        threshold : float
            Threshold of the :class:`~openturns.Event`.
        """
        return _metamodel.RandomVector_getThreshold(self)


    def __init__(self, *args):
        this = _metamodel.new_RandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_RandomVector
    __del__ = lambda self: None
RandomVector_swigregister = _metamodel.RandomVector_swigregister
RandomVector_swigregister(RandomVector)

class CompositeRandomVector(openturns.randomvector.RandomVectorImplementation):
    """Proxy of C++ OT::CompositeRandomVector"""

    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompositeRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CompositeRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.CompositeRandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.CompositeRandomVector___repr__(self)

    def isComposite(self):
        """
        Accessor to know if the RandomVector is a composite one.

        Returns
        -------
        isComposite : bool
            Indicates if the RandomVector is of type Composite or not.
        """
        return _metamodel.CompositeRandomVector_isComposite(self)


    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.CompositeRandomVector_getDimension(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.CompositeRandomVector_getRealization(self)


    def getSample(self, size):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _metamodel.CompositeRandomVector_getSample(self, size)


    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _metamodel.CompositeRandomVector_getMean(self)


    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _metamodel.CompositeRandomVector_getCovariance(self)


    def getMarginal(self, *args):
        """
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\\vect{Y}=\\Tr{(Y_1,\\dots,Y_n)}` a random vector and
        :math:`I \\in [1,n]` a set of indices. If :math:`\\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\\tilde{\\vect{Y}}=\\Tr{(Y_i)}_{i \\in I}`. If :math:`\\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\\vect{Y}=f(\\vect{X})` with :math:`f=(f_1,\\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\\tilde{\\vect{Y}}=(f_i(\\vect{X}))_{i \\in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _metamodel.CompositeRandomVector_getMarginal(self, *args)


    def getAntecedent(self):
        """
        Accessor to the antecedent RandomVector in case of a composite RandomVector.

        Returns
        -------
        antecedent : :class:`~openturns.RandomVector`
            Antecedent RandomVector :math:`\\vect{X}` in case of a
            :class:`~openturns.CompositeRandomVector` such as:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _metamodel.CompositeRandomVector_getAntecedent(self)


    def getFunction(self):
        """
        Accessor to the Function in case of a composite RandomVector.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function used to define a :class:`~openturns.CompositeRandomVector` as the
            image through this function of the antecedent :math:`\\vect{X}`:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _metamodel.CompositeRandomVector_getFunction(self)


    def getDistribution(self):
        """
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _metamodel.CompositeRandomVector_getDistribution(self)


    def __init__(self, *args):
        this = _metamodel.new_CompositeRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_CompositeRandomVector
    __del__ = lambda self: None
CompositeRandomVector_swigregister = _metamodel.CompositeRandomVector_swigregister
CompositeRandomVector_swigregister(CompositeRandomVector)

class EventRandomVector(CompositeRandomVector):
    __swig_setmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EventRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EventRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.EventRandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.EventRandomVector___repr__(self)

    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.EventRandomVector_getDimension(self)


    def getOperator(self):
        """
        Accessor to the comparaison operator of the Event.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            Comparaison operator used to define the :class:`~openturns.Event`.
        """
        return _metamodel.EventRandomVector_getOperator(self)


    def getThreshold(self):
        """
        Accessor to the threshold of the Event.

        Returns
        -------
        threshold : float
            Threshold of the :class:`~openturns.Event`.
        """
        return _metamodel.EventRandomVector_getThreshold(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.EventRandomVector_getRealization(self)


    def getSample(self, size):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _metamodel.EventRandomVector_getSample(self, size)


    def __init__(self, *args):
        this = _metamodel.new_EventRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_EventRandomVector
    __del__ = lambda self: None
EventRandomVector_swigregister = _metamodel.EventRandomVector_swigregister
EventRandomVector_swigregister(EventRandomVector)

class EventDomain(CompositeRandomVector):
    __swig_setmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EventDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EventDomain, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.EventDomain_getClassName(self)


    def __repr__(self):
        return _metamodel.EventDomain___repr__(self)

    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.EventDomain_getDimension(self)


    def getDomain(self):
        """
        Get the domain failure.

        Returns
        -------
        domain : :class:`~openturns.Domain`
            Domain failure used to define the :class:`~openturns.Event`.
        """
        return _metamodel.EventDomain_getDomain(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.EventDomain_getRealization(self)


    def getSample(self, size):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _metamodel.EventDomain_getSample(self, size)


    def __init__(self, *args):
        this = _metamodel.new_EventDomain(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_EventDomain
    __del__ = lambda self: None
EventDomain_swigregister = _metamodel.EventDomain_swigregister
EventDomain_swigregister(EventDomain)

class EventProcess(openturns.randomvector.RandomVectorImplementation):
    """Proxy of C++ OT::EventProcess"""

    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EventProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EventProcess, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.EventProcess_getClassName(self)


    def __repr__(self):
        return _metamodel.EventProcess___repr__(self)

    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.EventProcess_getDimension(self)


    def getDomain(self):
        """
        Get the domain failure.

        Returns
        -------
        domain : :class:`~openturns.Domain`
            Domain failure used to define the :class:`~openturns.Event`.
        """
        return _metamodel.EventProcess_getDomain(self)


    def getProcess(self):
        """
        Get the stochastic process.

        Returns
        -------
        process : :class:`~openturns.Process`
            Stochastic process used to define the :class:`~openturns.Event`.
        """
        return _metamodel.EventProcess_getProcess(self)


    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.EventProcess_getRealization(self)


    def __init__(self, *args):
        this = _metamodel.new_EventProcess(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_EventProcess
    __del__ = lambda self: None
EventProcess_swigregister = _metamodel.EventProcess_swigregister
EventProcess_swigregister(EventProcess)

class ConditionalRandomVector(openturns.randomvector.RandomVectorImplementation):
    """
    Conditional random vector.

    Helper class for defining the random vector :math:`\\vect{X}` such that  :math:`\\vect{X}|\\vect{\\Theta}` follows the distribution :math:`\\mathcal{L}_{\\vect{X}|\\vect{\\Theta}}`, with :math:`\\vect{\\Theta}` a random vector of dimension the dimension of :math:`\\vect{\\Theta}`.

    Available constructors:
       ConditionalRandomVector(*conditionedDist, randomParameters*)

    Parameters
    ----------

    conditionedDist : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`\\vect{\\Theta}`.

    randomParameters : :class:`~openturns.RandomVector`, the random parameters :math:`\\vect{\\Theta}` of the `conditionedDist` distribution. 

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{\\vect{X}}(\\vect{x}) = \\int f_{\\vect{X}|\\vect{\\Theta}=\\vect{\\theta}}(\\vect{x}|\\vect{\\theta}) f_{\\vect{\\Theta}}(\\vect{\\theta})\\di{\\vect{\\theta}}

    with  :math:`f_{\\vect{X}|\\vect{\\Theta}=\\vect{\\theta}}` the PDF of the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, where :math:`\\vect{\\Theta}` has been replaced by :math:`\\vect{\\theta}`, :math:`f_{\\vect{\\Theta}}` the PDF of :math:`\\vect{\\Theta}`.

    Note that there exist other (quasi) equivalent modellings using a combination of the classes :class:`~openturns.ConditionalDistribution` and :class:`~openturns.RandomVector` (see the Use Cases Guide).

    Examples
    --------
    Create a random vector:

    >>> import openturns as ot
    >>> distXgivenT = ot.Exponential()
    >>> distGamma = ot.Uniform(1.0, 2.0)
    >>> distAlpha = ot.Uniform(0.0, 0.1)
    >>> distTheta = ot.ComposedDistribution([distGamma, distAlpha])
    >>> rvTheta = ot.RandomVector(distTheta)
    >>> rvX = ot.ConditionalRandomVector(distXgivenT, rvTheta)

    Draw a sample:

    >>> sample = rvX.getSample(5)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConditionalRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.RandomVectorImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConditionalRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.ConditionalRandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.ConditionalRandomVector___repr__(self)

    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _metamodel.ConditionalRandomVector_getDimension(self)


    def getRealization(self, *args):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _metamodel.ConditionalRandomVector_getRealization(self, *args)


    def getDistribution(self):
        """
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}=\\vect{\\theta}`, where the parameters :math:`\\vect{\\theta}` are equal to the  values used to generate the last realization of :math:`\\vect{X}`.

        """
        return _metamodel.ConditionalRandomVector_getDistribution(self)


    def getRandomParameters(self):
        """
        Accessor to the distribution's random parameter `randomParameters`.

        Returns
        -------
        randomParameters : :class:`~openturns.RandomVector`, the random parameters :math:`\\vect{\\Theta}`.

        """
        return _metamodel.ConditionalRandomVector_getRandomParameters(self)


    def __init__(self, *args):
        this = _metamodel.new_ConditionalRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_ConditionalRandomVector
    __del__ = lambda self: None
ConditionalRandomVector_swigregister = _metamodel.ConditionalRandomVector_swigregister
ConditionalRandomVector_swigregister(ConditionalRandomVector)

class Event(RandomVector):
    """
    Event.

    Available constructor:
        Event()

        Event(*antecedent, comparisonOperator, threshold*)

        Event(*antecedent, domain*)

        Event(*process, domain*)

    Parameters
    ----------
    antecedent : :class:`~openturns.RandomVector` of dimension 1
        Output variable of interest.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator used to compare *antecedent* with *threshold*.
    threshold : float
        *threshold* we want to compare to *antecedent*.
    domain : :class:`~openturns.Domain`
        Domain failure.
    process : :class:`~openturns.Process`
        Stochastic process.

    Notes
    -----
    An event is defined as follows:

    .. math::

        \\cD_f = \\{\\vect{X} \\in \\Rset^n \\, / \\, g(\\vect{X},\\vect{d}) \\le 0\\}

    where :math:`\\vect{X}` denotes a random input vector, representing the sources
    of uncertainties, :math:`\\vect{d}` is a determinist vector, representing the
    fixed variables and :math:`g(\\vect{X},\\vect{d})` is the limit state function of
    the model.
    The probability content of the event :math:`\\cD_f` is :math:`P_f`:

    .. math::

        P_f = \\int_{g(\\vect{X},\\vect{d})\\le 0}f_\\vect{X}(\\vect{x})\\di{\\vect{x}}

    Here, the event considered is explicited directly from the limit state function
    :math:`g(\\vect{X}\\,,\\,\\vect{d})` : this is the classical structural reliability
    formulation. However, if the event is a threshold exceedance, it is useful to
    explicite the variable of interest :math:`Z=\\tilde{g}(\\vect{X}\\,,\\,\\vect{d})`,
    evaluated from the model :math:`\\tilde{g}(.)`. In that case, the event
    considered, associated to the threshold :math:`z_s` has the formulation:

    .. math::

        \\cD_f = \\{ \\vect{X} \\in \\Rset^n \\, / \\, Z=\\tilde{g}(\\vect{X}\\,,\\,\\vect{d}) > z_s \\}

    and the limit state function is:

    .. math::

        g(\\vect{X}\\,,\\,\\vect{d}) &= z_s - Z \\\\
                                 &= z_s - \\tilde{g}(\\vect{X}\\,,\\,\\vect{d})

    :math:`P_f` is the threshold exceedance probability, defined as:

    .. math::

        P_f &= P(Z \\geq z_s) \\\\
            &= \\int_{g(\\vect{X}, \\vect{d}) \\le 0} \\pdf\\di{\\vect{x}}

    Examples
    --------
    An event created from a limit state function:

    >>> import openturns as ot
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)

    A composite random vector based event:

    >>> X = ot.RandomVector(ot.Normal(2))
    >>> model = ot.SymbolicFunction(['x0', 'x1'], ['x0', 'x1'])
    >>> Y = ot.RandomVector(model, X)
    >>> # The domain: [0, 1]^2
    >>> domain = ot.Interval(2)
    >>> # The event
    >>> event = ot.Event(Y, domain)

    A process based event:

    >>> # The input process
    >>> X = ot.WhiteNoise(ot.Normal(2))
    >>> # The domain: [0, 1]^2
    >>> domain = ot.Interval(2)
    >>> # The event
    >>> event = ot.Event(X, domain)

    """

    __swig_setmethods__ = {}
    for _s in [RandomVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Event, name, value)
    __swig_getmethods__ = {}
    for _s in [RandomVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Event, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.Event_getClassName(self)


    def __repr__(self):
        return _metamodel.Event___repr__(self)

    def __str__(self, *args):
        return _metamodel.Event___str__(self, *args)

    def __init__(self, *args):
        this = _metamodel.new_Event(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_Event
    __del__ = lambda self: None
Event_swigregister = _metamodel.Event_swigregister
Event_swigregister(Event)

class StandardEvent(Event):
    """
    Event defined in the standard space.

    Available constructor:
        StandardEvent(*antecedent, comparisonOperator, threshold*)

        StandardEvent(*event*)

    Parameters
    ----------
    antecedent : :class:`~openturns.RandomVector` of dimension 1
        Output variable of interest.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator used to compare *antecedent* with *threshold*.
    threshold : float
        *threshold* we want to compare to *antecedent*.
    event : :class:`~openturns.Event`
        Physical event associated with the standard event to be created.

    Notes
    -----
    An event is defined as follows:

    .. math::

        \\cD_f = \\{\\vect{X} \\in \\Rset^n \\, / \\, g(\\vect{X},\\vect{d}) \\le 0\\}

    where :math:`\\vect{X}` denotes a random input vector, representing the sources
    of uncertainties, :math:`\\vect{d}` is a determinist vector, representing the
    fixed variables and :math:`g(\\vect{X},\\vect{d})` is the limit state function of
    the model.

    One way to evaluate the probability content :math:`P_f` of the event :math:`\\cD_f`:

    .. math::

        P_f = \\int_{g(\\vect{X},\\vect{d})\\le 0}f_\\vect{X}(\\vect{x})\\di{\\vect{x}}

    is to use an isoprobabilistic transformation to move from the physical space
    to a standard normal space (U-space) where distributions are spherical
    (invariant by rotation by definition), with zero mean, unit variance and unit
    correlation matrix. The usual isoprobabilistic transformations are the
    Generalized Nataf transformation and the Rosenblatt one.

    In that new U-space, the event has the new expression defined
    from the transformed limit state function of the model
    :math:`G : \\cD_f = \\{\\vect{U} \\in \\Rset^n \\, | \\, G(\\vect{U}\\,,\\,\\vect{d}) \\le 0\\}`
    and its boundary :
    :math:`\\{\\vect{U} \\in \\Rset^n \\, | \\,G(\\vect{U}\\,,\\,\\vect{d}) = 0\\}`.

    See also
    --------
    Analytical, SORM, FORM, SORMResult, FORMResult, StrongMaximumTest

    Examples
    --------

    A StandardEvent created from a limit state function :

    >>> import openturns as ot
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal(4)
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> myStandardEvent = ot.StandardEvent(output, ot.Less(), 1.0)

    A StandardEvent based on an event :

    >>> myEvent = ot.Event(output, ot.Less(), 1.0)
    >>> myStandardEvent = ot.StandardEvent(myEvent)
    """

    __swig_setmethods__ = {}
    for _s in [Event]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StandardEvent, name, value)
    __swig_getmethods__ = {}
    for _s in [Event]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StandardEvent, name)
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.StandardEvent_getClassName(self)


    def __init__(self, *args):
        this = _metamodel.new_StandardEvent(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_StandardEvent
    __del__ = lambda self: None
StandardEvent_swigregister = _metamodel.StandardEvent_swigregister
StandardEvent_swigregister(StandardEvent)

class FunctionalChaosRandomVector(CompositeRandomVector):
    """
    Functional chaos random vector used to evaluate the Sobol indices.

    Available constructors:
        FunctionalChaosRandomVector(functionalChaosResult)

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        A functional chaos result resulting from a polynomial chaos decomposition.

    See also
    --------
    FunctionalChaosAlgorithm, FunctionalChaosResult

    Notes
    -----
    This structure is created from a FunctionalChaosResult in order to evaluate the
    Sobol indices associated to the polynomial chaos decomposition of the model.

    """

    __swig_setmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalChaosRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [CompositeRandomVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalChaosRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.FunctionalChaosRandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.FunctionalChaosRandomVector___repr__(self)

    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _metamodel.FunctionalChaosRandomVector_getMean(self)


    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _metamodel.FunctionalChaosRandomVector_getCovariance(self)


    def getSobolIndex(self, *args):
        """
        Get the Sobol indices.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d - 1`
            Indice(s) of the variable(s) we want the associated Sobol indices. :math:`d`
            is the dimension of the input variables.
        out_marginal : int
            Output marginal
            Default value is 0

        Returns
        -------
        s : float
            The Sobol indice.
        """
        return _metamodel.FunctionalChaosRandomVector_getSobolIndex(self, *args)


    def getSobolTotalIndex(self, *args):
        """
        Get the aggregated Sobol indices.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d - 1`
            Indice(s) of the variable(s) we want the associated aggregated Sobol indices.
            :math:`d` is the dimension of the input variables.

        Returns
        -------
        s : float
            The aggregated Sobol indice.
        """
        return _metamodel.FunctionalChaosRandomVector_getSobolTotalIndex(self, *args)


    def getSobolGroupedIndex(self, *args):
        return _metamodel.FunctionalChaosRandomVector_getSobolGroupedIndex(self, *args)

    def getFunctionalChaosResult(self):
        """
        Accessor to the functional chaos result.

        Returns
        -------
        functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
            The functional chaos result resulting from a polynomial chaos decomposition.
        """
        return _metamodel.FunctionalChaosRandomVector_getFunctionalChaosResult(self)


    def __init__(self, *args):
        this = _metamodel.new_FunctionalChaosRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_FunctionalChaosRandomVector
    __del__ = lambda self: None
FunctionalChaosRandomVector_swigregister = _metamodel.FunctionalChaosRandomVector_swigregister
FunctionalChaosRandomVector_swigregister(FunctionalChaosRandomVector)

class KrigingRandomVector(openturns.randomvector.UsualRandomVector):
    """
    KrigingRandom vector, a conditioned Gaussian process.

    Available constructors:
        KrigingRandomVector(*krigingResult, points*)


    Parameters
    ----------
    krigingResult : :class:`~openturns.KrigingResult`
        Structure that contains elements of computation of a kriging algorithm
    points : 1-d or 2-d sequence of float
        Sequence of values defining a :class:`~openturns.Point` or a :class:`~openturns.Sample`.

    Notes
    ------

    KrigingRandomVector helps to create Gaussian random vector, :math:`Y: \\Rset^n \\mapsto \\Rset^d`, with stationary covariance function  :math:`\\cC^{stat}: \\Rset^n \\mapsto \\cM_{d \\times d}(\\Rset)`, conditionally to some observations.

    Let :math:`Y(x=x_1)=y_1,\\cdots,Y(x=x_n)=y_n` be the observations of the Gaussian process. We assume the same Gaussian prior as in the :class:`~openturns.KrigingAlgorithm`:

    .. math::

        Y(\\vect{x}) = \\Tr{\\vect{f}(\\vect{x})} \\vect{\\beta} + Z(\\vect{x})

    with :math:`\\Tr{\\vect{f}(\\vect{x})} \\vect{\\beta}` a generalized linear model, :math:`Z(\\vect{x})` a zero-mean Gaussian process with a stationary autocorrelation function :math:`\\cC^{stat}`:

    .. math::

        \\mathbb{E}[Z(\\vect{x}), Z(\\vect{\\tilde{x}})] = \\sigma^2 \\cC^{stat}_{\\theta}(\\vect{x} - \\vect{\\tilde{x}})

    The objective is to generate realizations of the random vector :math:`Y`, on new points :math:`\\vect{\\tilde{x}}`, conditionally to these observations. For that purpose, :class:`~openturns.KrigingAlgorithm` build such a prior and stores results in a :class:`~openturns.KrigingResult` structure on a first step. This structure is given as input argument.

    Then, in a second step, both the prior and the covariance on input points :math:`\\vect{\\tilde{x}}`, conditionally to the previous observations, are evaluated (respectively :math:`Y(\\vect{\\tilde{x}})` and :math:`\\cC^{stat}_{\\theta}(\\vect{\\tilde{x}})`).

    Finally realizations are randomly generated by the Gaussian distribution :math:`\\cN ( Y(\\vect{\\tilde{x}}), \\cC^{stat}_{\\theta}(\\vect{\\tilde{x}}) )`

    KrigingRandomVector class inherits from :class:`~openturns.UsualRandomVector`. Thus it stores the previous distribution and returns elements thanks to that distribution (realization, mean, covariance, sample...)


    """

    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.UsualRandomVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KrigingRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.UsualRandomVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KrigingRandomVector, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.KrigingRandomVector_getClassName(self)


    def __repr__(self):
        return _metamodel.KrigingRandomVector___repr__(self)

    def getRealization(self):
        """
        Compute a realization of the conditional Gaussian process (conditional on the learning set).

        The realization predicts the value on the given input *points*.

        Returns
        -------
        realization : :class:`~openturns.Point`
            Sequence of values of the Gaussian process.

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sampleSize = 6
        >>> dimension = 1
        >>> f = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> X = ot.Sample(sampleSize, dimension)
        >>> for i in range(sampleSize):
        ...     X[i, 0] = 3.0 + i
        >>> X[0, 0] = 1.0
        >>> X[1, 0] = 3.0
        >>> Y = f(X)
        >>> # create algorithm
        >>> basis = ot.ConstantBasisFactory(dimension).build()
        >>> covarianceModel = ot.SquaredExponential([2.23606797749979])
        >>> algo = ot.KrigingAlgorithm(X, Y, covarianceModel, basis)
        >>> algo.run()
        >>> # get the results
        >>> result = algo.getResult()
        >>> # Random vector evaluation
        >>> rvector = ot.KrigingRandomVector(result, [[0]])
        >>> # Realization of the random vector
        >>> realization = rvector.getRealization()

        """
        return _metamodel.KrigingRandomVector_getRealization(self)


    def getSample(self, *args):
        """
        Compute a sample of realizations of the conditional Gaussian process (conditional on the learning set).

        The realization predicts the value on the given input *points*.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            2-d float sequence of values of the Gaussian process.

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sampleSize = 6
        >>> dimension = 1
        >>> f = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> X = ot.Sample(sampleSize, dimension)
        >>> for i in range(sampleSize):
        ...    X[i, 0] = 3.0 + i
        >>> X[0, 0] = 1.0
        >>> X[1, 0] = 3.0
        >>> Y = f(X)
        >>> # create algorithm
        >>> basis = ot.ConstantBasisFactory(dimension).build()
        >>> covarianceModel = ot.SquaredExponential([2.23606797749979])
        >>> algo = ot.KrigingAlgorithm(X, Y, covarianceModel, basis)
        >>> algo.run()
        >>> # get the results
        >>> result = algo.getResult()
        >>> # Random vector evaluation
        >>> rvector = ot.KrigingRandomVector(result, [[0.0]])
        >>> # Realization of the random vector
        >>> realizations = rvector.getSample(5)

        """
        return _metamodel.KrigingRandomVector_getSample(self, *args)


    def getKrigingResult(self):
        """
        Return the kriging result structure.

        Returns
        -------
        krigResult : :class:`~openturns.KrigingResult`
            The structure containing the elements of a KrigingAlgorithm.


        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sampleSize = 6
        >>> dimension = 1
        >>> f = ot.SymbolicFunction(['x0'], ['x0 * sin(x0)'])
        >>> X = ot.Sample(sampleSize, dimension)
        >>> for i in range(sampleSize):
        ...    X[i, 0] = 3.0 + i
        >>> X[0, 0] = 1.0
        >>> X[1, 0] = 3.0
        >>> Y = f(X)
        >>> # create algorithm
        >>> basis = ot.ConstantBasisFactory(dimension).build()
        >>> covarianceModel = ot.SquaredExponential([2.23606797749979])
        >>> algo = ot.KrigingAlgorithm(X, Y, covarianceModel, basis)
        >>> algo.run()
        >>> # get the results
        >>> result = algo.getResult()
        >>> # Random vector evaluation
        >>> rvector = ot.KrigingRandomVector(result, [[0.0]])
        >>> # Get the kriging result
        >>> krigResult = rvector.getKrigingResult()
        """
        return _metamodel.KrigingRandomVector_getKrigingResult(self)


    def __init__(self, *args):
        this = _metamodel.new_KrigingRandomVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_KrigingRandomVector
    __del__ = lambda self: None
KrigingRandomVector_swigregister = _metamodel.KrigingRandomVector_swigregister
KrigingRandomVector_swigregister(KrigingRandomVector)

class TensorApproximationResult(MetaModelResult):
    """
    Functional chaos result.

    Notes
    -----
    Structure created by the method run() of
    :class:`~openturns.TensorApproximationAlgorithm`, and obtained thanks to the method
    getResult().
    """

    __swig_setmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorApproximationResult, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorApproximationResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.TensorApproximationResult_getClassName(self)


    def __repr__(self):
        return _metamodel.TensorApproximationResult___repr__(self)

    def __str__(self, *args):
        return _metamodel.TensorApproximationResult___str__(self, *args)

    def getDistribution(self):
        """
        Get the input distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the  input random vector :math:`\\vect{X}`.
        """
        return _metamodel.TensorApproximationResult_getDistribution(self)


    def getTransformation(self):
        """
        Get the isoprobabilistic transformation.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            Transformation :math:`T` such that :math:`T(\\vect{X}) = \\vect{Z}`.
        """
        return _metamodel.TensorApproximationResult_getTransformation(self)


    def getInverseTransformation(self):
        """
        Get the inverse isoprobabilistic transformation.

        Returns
        -------
        invTransf : :class:`~openturns.Function`
             :math:`T^{-1}` such that :math:`T(\\vect{X}) = \\vect{Z}`.
        """
        return _metamodel.TensorApproximationResult_getInverseTransformation(self)


    def getComposedModel(self):
        """
        Get the composed model.

        Returns
        -------
        composedModel : :class:`~openturns.Function`
            :math:`f = g\\circ T^{-1}`.
        """
        return _metamodel.TensorApproximationResult_getComposedModel(self)


    def getComposedMetaModel(self):
        """
        Get the composed metamodel.

        Returns
        -------
        composedMetamodel : :class:`~openturns.Function`
            :math:`\\tilde{f} =  \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k`
        """
        return _metamodel.TensorApproximationResult_getComposedMetaModel(self)


    def getTensor(self, marginalIndex=0):
        """
        Accessor to the tensor.

        Parameters
        ----------
        marginalIndex : int
            Index of the marginal

        Returns
        -------
        tensor : :class:`~openturns.CanonicalTensorEvaluation`
            Tensor data.
        """
        return _metamodel.TensorApproximationResult_getTensor(self, marginalIndex)


    def __init__(self, *args):
        this = _metamodel.new_TensorApproximationResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_TensorApproximationResult
    __del__ = lambda self: None
TensorApproximationResult_swigregister = _metamodel.TensorApproximationResult_swigregister
TensorApproximationResult_swigregister(TensorApproximationResult)

class TensorApproximationAlgorithm(MetaModelAlgorithm):
    """
    Tensor approximation algorithm.

    Available constructors:
        TensorApproximationAlgorithm(*inputSample, outputSample, distribution, functionFactory, nk*)

    Parameters
    ----------
    inputSample, outputSample : 2-d sequence of float
        The input random variables :math:`\\vect{X}=(X_1, \\dots, X_{n_X})^T`
        and the output samples :math:`\\vect{Y}` of a model evaluated apart.
    distribution : :class:`~openturns.Distribution`
        Joint probability density function :math:`f_{\\vect{X}}(\\vect{x})`
        of the physical input vector :math:`\\vect{X}`.
    functionFactory : :class:`~openturns.OrthogonalProductFunctionFactory`
        The basis factory.
    degrees : sequence of int
        The size of the basis for each component
        Of size equal to the input dimension.
    maxRank : int, optional (default=1)
        The maximum rank

    See also
    --------
    FunctionalChaosAlgorithm, KrigingAlgorithm

    Notes
    -----
    TensorApproximationAlgorithm allows to perform a low-rank approximation in the canonical
    tensor format (refer to [Rai2015]_ for other tensor formats and more details).

    The canonical tensor approximation of rank :math:`1` reads:

    .. math::

        f(X_1, \\dots, X_d) = \\prod_{j=1}^d v_j^{(1)} (x_j)

    The available alternating least-squares algorithm consists in successive approximations
    of the coefficients in the basis of the j-th component:

    .. math::

        v_j^{(i)} (x_j) = \\sum_{k=1}^{n_j} \\beta_{j,k}^{(i)} \\phi_{j,k} (x_j)

    The full canonical tensor approximation of rank :math:`m` reads:

    .. math::

        f(X_1, \\dots, X_d) = \\sum_{i=1}^m \\prod_{j=1}^d v_j^{(i)} (x_j)

    The decomposition algorithm can be tweaked using the key
    `TensorApproximationAlgorithm-DecompositionMethod`.

    Examples
    --------
    >>> import openturns as ot
    >>> # Define the model
    >>> dim = 1
    >>> model = ot.SymbolicFunction(['x'], ['x*sin(x)'])
    >>> # Create the input distribution
    >>> distribution = ot.ComposedDistribution([ot.Uniform()]*dim)
    >>> factoryCollection = [ot.FourierSeriesFactory()] * dim
    >>> functionFactory = ot.OrthogonalProductFunctionFactory(factoryCollection)
    >>> size = 10
    >>> X = distribution.getSample(size)
    >>> Y = model(X)
    >>> nk = [5] * dim
    >>> maxRank = 1
    >>> algo = ot.TensorApproximationAlgorithm(X, Y, distribution, functionFactory, nk, maxRank)
    >>> algo.run()
    >>> result = algo.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorApproximationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [MetaModelAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorApproximationAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _metamodel.TensorApproximationAlgorithm_getClassName(self)


    def __repr__(self):
        return _metamodel.TensorApproximationAlgorithm___repr__(self)

    def run(self):
        """Compute the response surface."""
        return _metamodel.TensorApproximationAlgorithm_run(self)


    def getResult(self):
        """
        Result accessor.

        Returns
        -------
        result : :class:`~openturns.TensorApproximationResult`
            The result of the approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_getResult(self)


    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample of a model evaluated apart.
        """
        return _metamodel.TensorApproximationAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            Output sample of a model evaluated apart.
        """
        return _metamodel.TensorApproximationAlgorithm_getOutputSample(self)


    def setMaximumAlternatingLeastSquaresIteration(self, maximumAlternatingLeastSquaresIteration):
        """
        Maximum ALS algorithm iteration accessor.

        Parameters
        ----------
        maxALSIteration : int
            The maximum number of iterations for the alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_setMaximumAlternatingLeastSquaresIteration(self, maximumAlternatingLeastSquaresIteration)


    def getMaximumAlternatingLeastSquaresIteration(self):
        """
        Maximum ALS algorithm iteration accessor.

        Returns
        -------
        maxALSIteration : int
            The maximum number of iterations for the alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_getMaximumAlternatingLeastSquaresIteration(self)


    def setMaximumRadiusError(self, maximumRadiusError):
        """
        Maximum radius error accessor.

        Parameters
        ----------
        maxRadiusError : float
            Convergence criterion on the radius during alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_setMaximumRadiusError(self, maximumRadiusError)


    def getMaximumRadiusError(self):
        """
        Maximum radius error accessor.

        Returns
        -------
        maxRadiusError : float
            Convergence criterion on the radius during alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_getMaximumRadiusError(self)


    def setMaximumResidualError(self, maximumResidualError):
        """
        Maximum residual error accessor.

        Parameters
        ----------
        maxResErr : float
            Convergence criterion on the residual during alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_setMaximumResidualError(self, maximumResidualError)


    def getMaximumResidualError(self):
        """
        Maximum residual error accessor.

        Returns
        -------
        maxResErr : float
            Convergence criterion on the residual during alternating least-squares
            algorithm used for the rank-1 approximation.
        """
        return _metamodel.TensorApproximationAlgorithm_getMaximumResidualError(self)


    def __init__(self, *args):
        this = _metamodel.new_TensorApproximationAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _metamodel.delete_TensorApproximationAlgorithm
    __del__ = lambda self: None
TensorApproximationAlgorithm_swigregister = _metamodel.TensorApproximationAlgorithm_swigregister
TensorApproximationAlgorithm_swigregister(TensorApproximationAlgorithm)

# This file is compatible with both classic and new-style classes.


