# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Approximation algorithms."""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_algo')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_algo')
    _algo = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_algo', [dirname(__file__)])
        except ImportError:
            import _algo
            return _algo
        try:
            _mod = imp.load_module('_algo', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _algo = swig_import_helper()
    del swig_import_helper
else:
    import _algo
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _algo.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _algo.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _algo.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _algo.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _algo.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _algo.SwigPyIterator_equal(self, x)

    def copy(self):
        return _algo.SwigPyIterator_copy(self)

    def next(self):
        return _algo.SwigPyIterator_next(self)

    def __next__(self):
        return _algo.SwigPyIterator___next__(self)

    def previous(self):
        return _algo.SwigPyIterator_previous(self)

    def advance(self, n):
        return _algo.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _algo.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _algo.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _algo.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _algo.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _algo.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _algo.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _algo.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _algo.GCC_VERSION

class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.func
import openturns.geom
import openturns.graph
import openturns.statistics
class ApproximationAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Approximation algorithm.

    See also
    --------
    LeastSquaresStrategy, ApproximationAlgorithmImplementationFactory,
    LeastSquaresMetaModelSelectionFactory

    Notes
    -----
    The ApproximationAlgorithm is built from an approximation algorithm
    implementation factory which is a
    :class:`~openturns.ApproximationAlgorithmImplementationFactory` or a
    :class:`~openturns.LeastSquaresMetaModelSelectionFactory`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationAlgorithmImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ApproximationAlgorithmImplementation_getClassName(self)


    def getX(self):
        """
        Accessor to the input sample.

        Returns
        -------
        x : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithmImplementation_getX(self)


    def getY(self):
        """
        Accessor to the output sample.

        Returns
        -------
        y : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithmImplementation_getY(self)


    def getWeight(self):
        """
        Accessor to the weights.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Output weights
        """
        return _algo.ApproximationAlgorithmImplementation_getWeight(self)


    def getPsi(self):
        """
        Accessor to the basis.

        Returns
        -------
        coefficients : :class:`~openturns.Basis`
            The basis
        """
        return _algo.ApproximationAlgorithmImplementation_getPsi(self)


    def __repr__(self):
        return _algo.ApproximationAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _algo.ApproximationAlgorithmImplementation___str__(self, *args)

    def run(self):
        """Run the algorithm."""
        return _algo.ApproximationAlgorithmImplementation_run(self)


    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            The coefficients
        """
        return _algo.ApproximationAlgorithmImplementation_getCoefficients(self)


    def getResidual(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : float
            The residual
        """
        return _algo.ApproximationAlgorithmImplementation_getResidual(self)


    def getRelativeError(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        relativeError : float
            The relative error
        """
        return _algo.ApproximationAlgorithmImplementation_getRelativeError(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        v : bool
            Enable or disable the verbosity.
        """
        return _algo.ApproximationAlgorithmImplementation_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        -------
        v : bool.
            Verbosity
        """
        return _algo.ApproximationAlgorithmImplementation_getVerbose(self)


    def __init__(self, *args):
        this = _algo.new_ApproximationAlgorithmImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ApproximationAlgorithmImplementation
    __del__ = lambda self: None
ApproximationAlgorithmImplementation_swigregister = _algo.ApproximationAlgorithmImplementation_swigregister
ApproximationAlgorithmImplementation_swigregister(ApproximationAlgorithmImplementation)

class ApproximationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_ApproximationAlgorithmImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.ApproximationAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.ApproximationAlgorithmImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.ApproximationAlgorithmImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.ApproximationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_ApproximationAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self: None
ApproximationAlgorithmImplementationTypedInterfaceObject_swigregister = _algo.ApproximationAlgorithmImplementationTypedInterfaceObject_swigregister
ApproximationAlgorithmImplementationTypedInterfaceObject_swigregister(ApproximationAlgorithmImplementationTypedInterfaceObject)

class ApproximationAlgorithm(ApproximationAlgorithmImplementationTypedInterfaceObject):
    """
    Approximation algorithm.

    See also
    --------
    LeastSquaresStrategy, ApproximationAlgorithmImplementationFactory,
    LeastSquaresMetaModelSelectionFactory

    Notes
    -----
    The ApproximationAlgorithm is built from an approximation algorithm
    implementation factory which is a
    :class:`~openturns.ApproximationAlgorithmImplementationFactory` or a
    :class:`~openturns.LeastSquaresMetaModelSelectionFactory`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ApproximationAlgorithm_getClassName(self)


    def getX(self):
        """
        Accessor to the input sample.

        Returns
        -------
        x : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithm_getX(self)


    def getY(self):
        """
        Accessor to the output sample.

        Returns
        -------
        y : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithm_getY(self)


    def getWeight(self):
        """
        Accessor to the weights.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Output weights
        """
        return _algo.ApproximationAlgorithm_getWeight(self)


    def getPsi(self):
        """
        Accessor to the basis.

        Returns
        -------
        coefficients : :class:`~openturns.Basis`
            The basis
        """
        return _algo.ApproximationAlgorithm_getPsi(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        v : bool
            Enable or disable the verbosity.
        """
        return _algo.ApproximationAlgorithm_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        -------
        v : bool.
            Verbosity
        """
        return _algo.ApproximationAlgorithm_getVerbose(self)


    def __repr__(self):
        return _algo.ApproximationAlgorithm___repr__(self)

    def __str__(self, *args):
        return _algo.ApproximationAlgorithm___str__(self, *args)

    def run(self):
        """Run the algorithm."""
        return _algo.ApproximationAlgorithm_run(self)


    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            The coefficients
        """
        return _algo.ApproximationAlgorithm_getCoefficients(self)


    def getResidual(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : float
            The residual
        """
        return _algo.ApproximationAlgorithm_getResidual(self)


    def getRelativeError(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        relativeError : float
            The relative error
        """
        return _algo.ApproximationAlgorithm_getRelativeError(self)


    def __init__(self, *args):
        this = _algo.new_ApproximationAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ApproximationAlgorithm
    __del__ = lambda self: None
ApproximationAlgorithm_swigregister = _algo.ApproximationAlgorithm_swigregister
ApproximationAlgorithm_swigregister(ApproximationAlgorithm)

class ApproximationAlgorithmImplementationFactory(openturns.common.PersistentObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationAlgorithmImplementationFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationAlgorithmImplementationFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ApproximationAlgorithmImplementationFactory_getClassName(self)


    def build(self, *args):
        return _algo.ApproximationAlgorithmImplementationFactory_build(self, *args)

    def __repr__(self):
        return _algo.ApproximationAlgorithmImplementationFactory___repr__(self)

    def __init__(self, *args):
        this = _algo.new_ApproximationAlgorithmImplementationFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ApproximationAlgorithmImplementationFactory
    __del__ = lambda self: None
ApproximationAlgorithmImplementationFactory_swigregister = _algo.ApproximationAlgorithmImplementationFactory_swigregister
ApproximationAlgorithmImplementationFactory_swigregister(ApproximationAlgorithmImplementationFactory)

class ClassifierImplementation(openturns.common.PersistentObject):
    """
    Classifier.

    Available constructors:
        Classifier(*classifierImp*)

    Parameters
    ----------
    classifierImp : classifier implementation
        A classifier implementation. It can be a :class:`~openturns.MixtureClassifier`.

    See also
    --------
    MixtureClassifier, ExpertMixture

    Notes
    -----
    The classifier enables to define rules that assign a vector to a particular
    class.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClassifierImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClassifierImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ClassifierImplementation_getClassName(self)


    def classify(self, *args):
        """
        Classify points according to the classifier.

        **Available usages**:

            classify(*inputPoint*)

            classify(*inputSample*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to classify.
        inputSample : 2-d a sequence of float
            A set of point to classify.

        Notes
        -----
        The rules to assign a point to a class are specific to each *classifierImp*.

        In the first usage, it returns an integer which corresponds to the class where
        *inputPoint* has been assigned.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        class of each point of *inputSample*.
        """
        return _algo.ClassifierImplementation_classify(self, *args)


    def grade(self, *args):
        """
        Grade points according to the classifier.

        **Available usages**:

            grade(*inputPoint, k*)

            grade(*inputSample, classList*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to grade.
        inputSample : 2-d a sequence of float
            A set of point to grade.
        k : integer
            The class number.
        classList : sequence of integer
            The list of class number.

        Notes
        -----
        The rules to grade a point with respect to a class are specific to each
        *classifierImp*.

        In the first usage, it returns a real that grades *inputPoint* with respect to
        the class *k*. The greatest, the best.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        grades of the :math:`i^{th}` point of *inputSample* with respect to the
        :math:`i^{th}` class of *classList*.
        """
        return _algo.ClassifierImplementation_grade(self, *args)


    def __repr__(self):
        return _algo.ClassifierImplementation___repr__(self)

    def __str__(self, *args):
        return _algo.ClassifierImplementation___str__(self, *args)

    def setVerbose(self, verbose):
        """
        Accessor to the verbosity.

        Parameters
        ----------
        verb : bool
            Logical value telling if the verbose mode has been activated.
        """
        return _algo.ClassifierImplementation_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity.

        Returns
        -------
        verb : bool
            Logical value telling if the verbose mode has been activated.
        """
        return _algo.ClassifierImplementation_getVerbose(self)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dim : integer
            The dimension of the classifier.
        """
        return _algo.ClassifierImplementation_getDimension(self)


    def setParallel(self, flag):
        """
        Accessor to the parallel flag.

        Parameters
        ----------
        flag : bool
            Logical value telling if the classification and grading are done in parallel. 

        """
        return _algo.ClassifierImplementation_setParallel(self, flag)


    def isParallel(self):
        """
        Accessor to the parallel flag.

        Returns
        -------
        flag : bool
            Logical value telling if the parallel mode has been activated.

        """
        return _algo.ClassifierImplementation_isParallel(self)


    def __init__(self, *args):
        this = _algo.new_ClassifierImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ClassifierImplementation
    __del__ = lambda self: None
ClassifierImplementation_swigregister = _algo.ClassifierImplementation_swigregister
ClassifierImplementation_swigregister(ClassifierImplementation)

class ClassifierImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClassifierImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ClassifierImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_ClassifierImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.ClassifierImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.ClassifierImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.ClassifierImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.ClassifierImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_ClassifierImplementationTypedInterfaceObject
    __del__ = lambda self: None
ClassifierImplementationTypedInterfaceObject_swigregister = _algo.ClassifierImplementationTypedInterfaceObject_swigregister
ClassifierImplementationTypedInterfaceObject_swigregister(ClassifierImplementationTypedInterfaceObject)

class Classifier(ClassifierImplementationTypedInterfaceObject):
    """
    Classifier.

    Available constructors:
        Classifier(*classifierImp*)

    Parameters
    ----------
    classifierImp : classifier implementation
        A classifier implementation. It can be a :class:`~openturns.MixtureClassifier`.

    See also
    --------
    MixtureClassifier, ExpertMixture

    Notes
    -----
    The classifier enables to define rules that assign a vector to a particular
    class.
    """

    __swig_setmethods__ = {}
    for _s in [ClassifierImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Classifier, name, value)
    __swig_getmethods__ = {}
    for _s in [ClassifierImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Classifier, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.Classifier_getClassName(self)


    def classify(self, *args):
        """
        Classify points according to the classifier.

        **Available usages**:

            classify(*inputPoint*)

            classify(*inputSample*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to classify.
        inputSample : 2-d a sequence of float
            A set of point to classify.

        Notes
        -----
        The rules to assign a point to a class are specific to each *classifierImp*.

        In the first usage, it returns an integer which corresponds to the class where
        *inputPoint* has been assigned.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        class of each point of *inputSample*.
        """
        return _algo.Classifier_classify(self, *args)


    def grade(self, *args):
        """
        Grade points according to the classifier.

        **Available usages**:

            grade(*inputPoint, k*)

            grade(*inputSample, classList*)

        Parameters
        ----------
        inputPoint : sequence of float
            A point to grade.
        inputSample : 2-d a sequence of float
            A set of point to grade.
        k : integer
            The class number.
        classList : sequence of integer
            The list of class number.

        Notes
        -----
        The rules to grade a point with respect to a class are specific to each
        *classifierImp*.

        In the first usage, it returns a real that grades *inputPoint* with respect to
        the class *k*. The greatest, the best.

        In the second usage, it returns an :class:`~openturns.Indices` that collects the
        grades of the :math:`i^{th}` point of *inputSample* with respect to the
        :math:`i^{th}` class of *classList*.
        """
        return _algo.Classifier_grade(self, *args)


    def setParallel(self, flag):
        """
        Accessor to the parallel flag.

        Parameters
        ----------
        flag : bool
            Logical value telling if the classification and grading are done in parallel. 

        """
        return _algo.Classifier_setParallel(self, flag)


    def isParallel(self):
        """
        Accessor to the parallel flag.

        Returns
        -------
        flag : bool
            Logical value telling if the parallel mode has been activated.

        """
        return _algo.Classifier_isParallel(self)


    def getDimension(self):
        """
        Accessor to the dimension.

        Returns
        -------
        dim : integer
            The dimension of the classifier.
        """
        return _algo.Classifier_getDimension(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity.

        Parameters
        ----------
        verb : bool
            Logical value telling if the verbose mode has been activated.
        """
        return _algo.Classifier_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity.

        Returns
        -------
        verb : bool
            Logical value telling if the verbose mode has been activated.
        """
        return _algo.Classifier_getVerbose(self)


    def __repr__(self):
        return _algo.Classifier___repr__(self)

    def __str__(self, *args):
        return _algo.Classifier___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_Classifier(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_Classifier
    __del__ = lambda self: None
Classifier_swigregister = _algo.Classifier_swigregister
Classifier_swigregister(Classifier)

class FittingAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Fitting algorithm.

    Available constructors:
        FittingAlgorithm(*fittingAlgoImp*)

    Parameters
    ----------
    fittingAlgoImp : a FittingAlgorithmImplementation
        A fitting algorithm implementation which is the
        :class:`~openturns.CorrectedLeaveOneOut` or :class:`~openturns.KFold`.

    See also
    --------
    CorrectedLeaveOneOut, KFold

    Notes
    -----
    FittingAlgorithm is the interface of the FittingAlgorithmImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FittingAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FittingAlgorithmImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.FittingAlgorithmImplementation_getClassName(self)


    def __repr__(self):
        return _algo.FittingAlgorithmImplementation___repr__(self)

    def run(self, *args):
        return _algo.FittingAlgorithmImplementation_run(self, *args)

    def __init__(self, *args):
        this = _algo.new_FittingAlgorithmImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_FittingAlgorithmImplementation
    __del__ = lambda self: None
FittingAlgorithmImplementation_swigregister = _algo.FittingAlgorithmImplementation_swigregister
FittingAlgorithmImplementation_swigregister(FittingAlgorithmImplementation)

class FittingAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FittingAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FittingAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_FittingAlgorithmImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.FittingAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.FittingAlgorithmImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.FittingAlgorithmImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.FittingAlgorithmImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_FittingAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self: None
FittingAlgorithmImplementationTypedInterfaceObject_swigregister = _algo.FittingAlgorithmImplementationTypedInterfaceObject_swigregister
FittingAlgorithmImplementationTypedInterfaceObject_swigregister(FittingAlgorithmImplementationTypedInterfaceObject)

class FittingAlgorithm(FittingAlgorithmImplementationTypedInterfaceObject):
    """
    Fitting algorithm.

    Available constructors:
        FittingAlgorithm(*fittingAlgoImp*)

    Parameters
    ----------
    fittingAlgoImp : a FittingAlgorithmImplementation
        A fitting algorithm implementation which is the
        :class:`~openturns.CorrectedLeaveOneOut` or :class:`~openturns.KFold`.

    See also
    --------
    CorrectedLeaveOneOut, KFold

    Notes
    -----
    FittingAlgorithm is the interface of the FittingAlgorithmImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [FittingAlgorithmImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FittingAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [FittingAlgorithmImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FittingAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.FittingAlgorithm_getClassName(self)


    def __repr__(self):
        return _algo.FittingAlgorithm___repr__(self)

    def __str__(self, *args):
        return _algo.FittingAlgorithm___str__(self, *args)

    def run(self, *args):
        return _algo.FittingAlgorithm_run(self, *args)

    def __init__(self, *args):
        this = _algo.new_FittingAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_FittingAlgorithm
    __del__ = lambda self: None
FittingAlgorithm_swigregister = _algo.FittingAlgorithm_swigregister
FittingAlgorithm_swigregister(FittingAlgorithm)

class KDTree(openturns.common.PersistentObject):
    """
    Partition tree data structure.

    Allows to store and search points fast.

    Parameters
    ----------
    sample : 2-d sequence of float
        Points.

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal(2).getSample(10)
    >>> tree = ot.KDTree(sample)
    >>> neighbour = tree.getNearestNeighbour([0.1, 0.2])
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KDTree, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KDTree, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KDTree_getClassName(self)


    def __repr__(self):
        return _algo.KDTree___repr__(self)

    def isEmpty(self):
        """
        Empty flag accessor.

        Returns
        -------
        empty : bool
            Whether the collection is empty.
        """
        return _algo.KDTree_isEmpty(self)


    def insert(self, point):
        """
        Insert a point in the tree.

        Parameters
        ----------
        x : sequence of float
            Given point.
        """
        return _algo.KDTree_insert(self, point)


    def getNearestNeighboursIndices(self, x, k, sorted=False):
        """
        Accessor to the nearest neighbours indices.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of points to return
        sorted : bool
            Whether to return the points sorted

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the k nearest neighbours.
        """
        return _algo.KDTree_getNearestNeighboursIndices(self, x, k, sorted)


    def getNearestNeighbours(self, x, k):
        """
        Accessor to the nearest neighbours.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of points to return

        Returns
        -------
        neighbours : :class:`~openturns.Sample`
            Nearest neighbours.
        """
        return _algo.KDTree_getNearestNeighbours(self, x, k)


    def getNearestNeighbourIndex(self, x):
        """
        Accessor to the nearest neighbour index.

        Parameters
        ----------
        x : sequence of float
            Given point.

        Returns
        -------
        index : int
            Index of the nearest neighbour.
        """
        return _algo.KDTree_getNearestNeighbourIndex(self, x)


    def getNearestNeighbour(self, x):
        """
        Accessor to the nearest neighbour.

        Parameters
        ----------
        x : sequence of float
            Given point.

        Returns
        -------
        neighbour : :class:`~openturns.Point`
            Nearest neighbour.
        """
        return _algo.KDTree_getNearestNeighbour(self, x)


    def getPoints(self):
        """
        Collection of points accessor.

        Returns
        -------
        points : :class:`~openturns.Sample`
            Collection of points.
        """
        return _algo.KDTree_getPoints(self)


    def __init__(self, *args):
        this = _algo.new_KDTree(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KDTree
    __del__ = lambda self: None
KDTree_swigregister = _algo.KDTree_swigregister
KDTree_swigregister(KDTree)

class KFold(FittingAlgorithmImplementation):
    """
    K-fold.

    Available constructors:
        KFold()

        KFold(*k*)

    Parameters
    ----------
    k : positive integer
        Number of folds in which the sample is splitted. If not provided, default is
        :math:`k = 10`.

    See also
    --------
    FittingAlgorithm, CorrectedLeaveOneOut

    Notes
    -----
    KFold inherits from :class:`~openturns.FittingAlgorithm`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [FittingAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KFold, name, value)
    __swig_getmethods__ = {}
    for _s in [FittingAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KFold, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KFold_getClassName(self)


    def __repr__(self):
        return _algo.KFold___repr__(self)

    def run(self, x, y, weight, basis, indices):
        return _algo.KFold_run(self, x, y, weight, basis, indices)

    def setK(self, p):
        """
        Accessor to the number of folds.

        Parameters
        ----------
        k : integer
            Number of folds in which the sample is splitted.
        """
        return _algo.KFold_setK(self, p)


    def getK(self):
        """
        Accessor to the number of folds.

        Returns
        -------
        k : integer
            Number of folds in which the sample is splitted.
        """
        return _algo.KFold_getK(self)


    def __init__(self, *args):
        this = _algo.new_KFold(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KFold
    __del__ = lambda self: None
KFold_swigregister = _algo.KFold_swigregister
KFold_swigregister(KFold)

class CorrectedLeaveOneOut(FittingAlgorithmImplementation):
    """
    Corrected leave one out.

    Available constructors:
        CorrectedLeaveOneOut()

    See also
    --------
    FittingAlgorithm, KFold

    Notes
    -----
    CorrectedLeaveOneOut inherits from :class:`~openturns.FittingAlgorithm`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [FittingAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CorrectedLeaveOneOut, name, value)
    __swig_getmethods__ = {}
    for _s in [FittingAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CorrectedLeaveOneOut, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.CorrectedLeaveOneOut_getClassName(self)


    def __repr__(self):
        return _algo.CorrectedLeaveOneOut___repr__(self)

    def run(self, x, y, weight, psi, indices):
        return _algo.CorrectedLeaveOneOut_run(self, x, y, weight, psi, indices)

    def __init__(self, *args):
        this = _algo.new_CorrectedLeaveOneOut(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_CorrectedLeaveOneOut
    __del__ = lambda self: None
CorrectedLeaveOneOut_swigregister = _algo.CorrectedLeaveOneOut_swigregister
CorrectedLeaveOneOut_swigregister(CorrectedLeaveOneOut)

class DesignProxy(openturns.common.Object):
    """
    Design matrix cache.

    Helps to cache evaluations of the design matrix.

    Can be useful for an iterative least squares problem resolution.

    Parameters
    ----------
    x : :class:`~openturns.Sample`
        Input sample
    psi : :class:`~openturns.Basis`
        Functional basis
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DesignProxy, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DesignProxy, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.DesignProxy_getClassName(self)


    def __repr__(self):
        return _algo.DesignProxy___repr__(self)

    def getInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _algo.DesignProxy_getInputSample(self)


    def getBasis(self):
        """
        Basis accessor.

        Returns
        -------
        basis : :class:`~openturns.getBasis`
            Basis.
        """
        return _algo.DesignProxy_getBasis(self)


    def computeDesign(self, indices):
        """
        Build the design matrix.

        Parameters
        ----------
        indices : sequence of int
            Indices of the current basis in the global basis

        Returns
        -------
        psiAk : :class:`~openturns.Matrix`
            The design matrix
        """
        return _algo.DesignProxy_computeDesign(self, indices)


    def setRowFilter(self, rowFilter):
        """
        Row filter accessor.

        Parameters
        ----------
        rowFilter : sequence of int
            Sub-indices in of the sample in the current indices
        """
        return _algo.DesignProxy_setRowFilter(self, rowFilter)


    def getRowFilter(self):
        """
        Row filter accessor.

        Returns
        -------
        rowFilter : :class:`~openturns.Indices`
            Sub-indices in of the sample in the current indices
        """
        return _algo.DesignProxy_getRowFilter(self)


    def hasRowFilter(self):
        """
        Row filter flag accessor.

        Returns
        -------
        hasRowFilter : bool
            Whether sub-indices of the basis are set
        """
        return _algo.DesignProxy_hasRowFilter(self)


    def getSampleSize(self):
        """
        Sample size accessor.

        Returns
        -------
        sampleSize : int
            Size of sample accounting for row filter
        """
        return _algo.DesignProxy_getSampleSize(self)


    def setWeight(self, weight):
        """
        Weights accessor.

        Parameters
        ----------
        weight : sequence of float
            Weights on each basis term
        """
        return _algo.DesignProxy_setWeight(self, weight)


    def getWeight(self):
        """
        Weights accessor.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Weights on each basis term
        """
        return _algo.DesignProxy_getWeight(self)


    def hasWeight(self):
        """
        Weight flag accessor.

        Returns
        -------
        hasWeight : bool
            Whether weights are set
        """
        return _algo.DesignProxy_hasWeight(self)


    def __init__(self, *args):
        this = _algo.new_DesignProxy(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_DesignProxy
    __del__ = lambda self: None
DesignProxy_swigregister = _algo.DesignProxy_swigregister
DesignProxy_swigregister(DesignProxy)

class LeastSquaresMethodImplementation(openturns.common.PersistentObject):
    """
    Base class for least square solvers.

    Available constructors:
        LeastSquaresMethod(*proxy, weight, indices*)

        LeastSquaresMethod(*proxy, indices*)

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    See also
    --------
    CholeskyMethod, SVDMethod, QRMethod

    Notes
    -----
    Solve the least-squares problem:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} ||y - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U})||^2

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresMethodImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresMethodImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.LeastSquaresMethodImplementation_getClassName(self)


    def __repr__(self):
        return _algo.LeastSquaresMethodImplementation___repr__(self)

    def getInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _algo.LeastSquaresMethodImplementation_getInputSample(self)


    def getWeight(self):
        """
        Weights accessor.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Weights.
        """
        return _algo.LeastSquaresMethodImplementation_getWeight(self)


    def getBasis(self):
        """
        Basis accessor.

        Returns
        -------
        basis : :class:`~openturns.getBasis`
            Basis.
        """
        return _algo.LeastSquaresMethodImplementation_getBasis(self)


    def getCurrentIndices(self):
        """
        Current indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the current decomposition in the global basis.
        """
        return _algo.LeastSquaresMethodImplementation_getCurrentIndices(self)


    def getInitialIndices(self):
        """
        Initial indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Initial indices of the terms in the global basis.
        """
        return _algo.LeastSquaresMethodImplementation_getInitialIndices(self)


    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.LeastSquaresMethodImplementation_solve(self, rhs)


    def solveNormal(self, rhs):
        """
        Solve the least-squares problem using normal equation.

        .. math::

            M^T*M*x=M^T*b

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        x : :class:`~openturns.Point`
            The solution.
        """
        return _algo.LeastSquaresMethodImplementation_solveNormal(self, rhs)


    def getGramInverse(self):
        """
        Get the inverse Gram matrix of input sample.

        .. math::

            G^{-1} = (X^T * X)^{-1}

        Returns
        -------
        c : :class:`~openturns.CovarianceMatrix`
            The inverse Gram matrix.
        """
        return _algo.LeastSquaresMethodImplementation_getGramInverse(self)


    def getH(self):
        """
        Get the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        h : :class:`~openturns.SymmetricMatrix`
            The projection matrix H.
        """
        return _algo.LeastSquaresMethodImplementation_getH(self)


    def getHDiag(self):
        """
        Get the diagonal of the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of H.
        """
        return _algo.LeastSquaresMethodImplementation_getHDiag(self)


    def getGramInverseDiag(self):
        """
        Get the diagonal of the inverse Gram matrix.

        .. math::

            diag(G^{-1}) = diag((X^T * X)^{-1})

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of the inverse Gram matrix.
        """
        return _algo.LeastSquaresMethodImplementation_getGramInverseDiag(self)


    def getGramInverseTrace(self):
        """
        Get the trace of the inverse Gram matrix.

        .. math::

            Tr(G^{-1}) = Tr(x^T * x)^{-1}

        Returns
        -------
        x : :class:`~openturns.Scalar`
            The trace of inverse Gram matrix.
        """
        return _algo.LeastSquaresMethodImplementation_getGramInverseTrace(self)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.LeastSquaresMethodImplementation_update(self, addedIndices, conservedIndices, removedIndices, row)


    def trashDecomposition(self):
        """Drop the current decomposition."""
        return _algo.LeastSquaresMethodImplementation_trashDecomposition(self)


    def buildCurrentBasis(self):
        """
        Build the current basis.

        Returns
        -------
        phi : :class:`~openturns.Basis`
            The basis according to current indices.
        """
        return _algo.LeastSquaresMethodImplementation_buildCurrentBasis(self)


    def computeWeightedDesign(self, whole=False):
        """
        Build the design matrix.

        Parameters
        ----------
        whole : bool, defaults to False
            Whether to use the initial indices instead of the current indices

        Returns
        -------
        psiAk : :class:`~openturns.Matrix`
            The design matrix
        """
        return _algo.LeastSquaresMethodImplementation_computeWeightedDesign(self, whole)


    def __init__(self, *args):
        this = _algo.new_LeastSquaresMethodImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_LeastSquaresMethodImplementation
    __del__ = lambda self: None
LeastSquaresMethodImplementation_swigregister = _algo.LeastSquaresMethodImplementation_swigregister
LeastSquaresMethodImplementation_swigregister(LeastSquaresMethodImplementation)

class LeastSquaresMethodImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresMethodImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresMethodImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_LeastSquaresMethodImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.LeastSquaresMethodImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.LeastSquaresMethodImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.LeastSquaresMethodImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.LeastSquaresMethodImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_LeastSquaresMethodImplementationTypedInterfaceObject
    __del__ = lambda self: None
LeastSquaresMethodImplementationTypedInterfaceObject_swigregister = _algo.LeastSquaresMethodImplementationTypedInterfaceObject_swigregister
LeastSquaresMethodImplementationTypedInterfaceObject_swigregister(LeastSquaresMethodImplementationTypedInterfaceObject)

class LeastSquaresMethod(LeastSquaresMethodImplementationTypedInterfaceObject):
    """
    Base class for least square solvers.

    Available constructors:
        LeastSquaresMethod(*proxy, weight, indices*)

        LeastSquaresMethod(*proxy, indices*)

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    See also
    --------
    CholeskyMethod, SVDMethod, QRMethod

    Notes
    -----
    Solve the least-squares problem:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} ||y - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U})||^2

    """

    __swig_setmethods__ = {}
    for _s in [LeastSquaresMethodImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresMethod, name, value)
    __swig_getmethods__ = {}
    for _s in [LeastSquaresMethodImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresMethod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.LeastSquaresMethod_getClassName(self)


    def __repr__(self):
        return _algo.LeastSquaresMethod___repr__(self)

    def __str__(self, *args):
        return _algo.LeastSquaresMethod___str__(self, *args)

    def getInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _algo.LeastSquaresMethod_getInputSample(self)


    def getWeight(self):
        """
        Weights accessor.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Weights.
        """
        return _algo.LeastSquaresMethod_getWeight(self)


    def getBasis(self):
        """
        Basis accessor.

        Returns
        -------
        basis : :class:`~openturns.getBasis`
            Basis.
        """
        return _algo.LeastSquaresMethod_getBasis(self)


    def getCurrentIndices(self):
        """
        Current indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the current decomposition in the global basis.
        """
        return _algo.LeastSquaresMethod_getCurrentIndices(self)


    def getInitialIndices(self):
        """
        Initial indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Initial indices of the terms in the global basis.
        """
        return _algo.LeastSquaresMethod_getInitialIndices(self)


    def buildCurrentBasis(self):
        """
        Build the current basis.

        Returns
        -------
        phi : :class:`~openturns.Basis`
            The basis according to current indices.
        """
        return _algo.LeastSquaresMethod_buildCurrentBasis(self)


    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.LeastSquaresMethod_solve(self, rhs)


    def solveNormal(self, rhs):
        """
        Solve the least-squares problem using normal equation.

        .. math::

            M^T*M*x=M^T*b

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        x : :class:`~openturns.Point`
            The solution.
        """
        return _algo.LeastSquaresMethod_solveNormal(self, rhs)


    def getHDiag(self):
        """
        Get the diagonal of the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of H.
        """
        return _algo.LeastSquaresMethod_getHDiag(self)


    def getGramInverseDiag(self):
        """
        Get the diagonal of the inverse Gram matrix.

        .. math::

            diag(G^{-1}) = diag((X^T * X)^{-1})

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of the inverse Gram matrix.
        """
        return _algo.LeastSquaresMethod_getGramInverseDiag(self)


    def getGramInverseTrace(self):
        """
        Get the trace of the inverse Gram matrix.

        .. math::

            Tr(G^{-1}) = Tr(x^T * x)^{-1}

        Returns
        -------
        x : :class:`~openturns.Scalar`
            The trace of inverse Gram matrix.
        """
        return _algo.LeastSquaresMethod_getGramInverseTrace(self)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.LeastSquaresMethod_update(self, addedIndices, conservedIndices, removedIndices, row)


    def computeWeightedDesign(self, whole=False):
        """
        Build the design matrix.

        Parameters
        ----------
        whole : bool, defaults to False
            Whether to use the initial indices instead of the current indices

        Returns
        -------
        psiAk : :class:`~openturns.Matrix`
            The design matrix
        """
        return _algo.LeastSquaresMethod_computeWeightedDesign(self, whole)


    def Build(*args):
        """
        Instanciate a decomposition method from its name.

        Parameters
        ----------
        proxy : :class:`~openturns.DesignProxy`
            Input sample
        weight : sequence of float, optional
            Output weights
        indices : sequence of int
            Indices allowed in the basis

        Returns
        -------
        method : :class:`~openturns.LeastSquaresMethod`
            The built method
        """
        return _algo.LeastSquaresMethod_Build(*args)

    Build = staticmethod(Build)

    def __init__(self, *args):
        this = _algo.new_LeastSquaresMethod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_LeastSquaresMethod
    __del__ = lambda self: None
LeastSquaresMethod_swigregister = _algo.LeastSquaresMethod_swigregister
LeastSquaresMethod_swigregister(LeastSquaresMethod)

def LeastSquaresMethod_Build(*args):
    """
    Instanciate a decomposition method from its name.

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float, optional
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    Returns
    -------
    method : :class:`~openturns.LeastSquaresMethod`
        The built method
    """
    return _algo.LeastSquaresMethod_Build(*args)

class CholeskyMethod(LeastSquaresMethodImplementation):
    """
    Least squares solver using Cholesky decomposition.

    Available constructors:
        CholeskyMethod(*proxy, weight, indices*)

        CholeskyMethod(*proxy, indices*)

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    See also
    --------
    LeastSquaresMethod
    """

    __swig_setmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CholeskyMethod, name, value)
    __swig_getmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CholeskyMethod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.CholeskyMethod_getClassName(self)


    def __repr__(self):
        return _algo.CholeskyMethod___repr__(self)

    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.CholeskyMethod_solve(self, rhs)


    def solveNormal(self, rhs):
        """
        Solve the least-squares problem using normal equation.

        .. math::

            M^T*M*x=M^T*b

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        x : :class:`~openturns.Point`
            The solution.
        """
        return _algo.CholeskyMethod_solveNormal(self, rhs)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.CholeskyMethod_update(self, addedIndices, conservedIndices, removedIndices, row)


    def trashDecomposition(self):
        """Drop the current decomposition."""
        return _algo.CholeskyMethod_trashDecomposition(self)


    def getGramInverse(self):
        """
        Get the inverse Gram matrix of input sample.

        .. math::

            G^{-1} = (X^T * X)^{-1}

        Returns
        -------
        c : :class:`~openturns.CovarianceMatrix`
            The inverse Gram matrix.
        """
        return _algo.CholeskyMethod_getGramInverse(self)


    def getH(self):
        """
        Get the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        h : :class:`~openturns.SymmetricMatrix`
            The projection matrix H.
        """
        return _algo.CholeskyMethod_getH(self)


    def getGramInverseDiag(self):
        """
        Get the diagonal of the inverse Gram matrix.

        .. math::

            diag(G^{-1}) = diag((X^T * X)^{-1})

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of the inverse Gram matrix.
        """
        return _algo.CholeskyMethod_getGramInverseDiag(self)


    def getHDiag(self):
        """
        Get the diagonal of the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of H.
        """
        return _algo.CholeskyMethod_getHDiag(self)


    def getGramInverseTrace(self):
        """
        Get the trace of the inverse Gram matrix.

        .. math::

            Tr(G^{-1}) = Tr(x^T * x)^{-1}

        Returns
        -------
        x : :class:`~openturns.Scalar`
            The trace of inverse Gram matrix.
        """
        return _algo.CholeskyMethod_getGramInverseTrace(self)


    def __init__(self, *args):
        this = _algo.new_CholeskyMethod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_CholeskyMethod
    __del__ = lambda self: None
CholeskyMethod_swigregister = _algo.CholeskyMethod_swigregister
CholeskyMethod_swigregister(CholeskyMethod)

class QRMethod(LeastSquaresMethodImplementation):
    """
    Least squares solver using the QR decomposition.

    Available constructors:
        QRMethod(*proxy, weight, indices*)

        QRMethod(*proxy, indices*)

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    See also
    --------
    LeastSquaresMethod
    """

    __swig_setmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QRMethod, name, value)
    __swig_getmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, QRMethod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.QRMethod_getClassName(self)


    def __repr__(self):
        return _algo.QRMethod___repr__(self)

    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.QRMethod_solve(self, rhs)


    def solveNormal(self, rhs):
        """
        Solve the least-squares problem using normal equation.

        .. math::

            M^T*M*x=M^T*b

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        x : :class:`~openturns.Point`
            The solution.
        """
        return _algo.QRMethod_solveNormal(self, rhs)


    def getGramInverse(self):
        """
        Get the inverse Gram matrix of input sample.

        .. math::

            G^{-1} = (X^T * X)^{-1}

        Returns
        -------
        c : :class:`~openturns.CovarianceMatrix`
            The inverse Gram matrix.
        """
        return _algo.QRMethod_getGramInverse(self)


    def getGramInverseDiag(self):
        """
        Get the diagonal of the inverse Gram matrix.

        .. math::

            diag(G^{-1}) = diag((X^T * X)^{-1})

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of the inverse Gram matrix.
        """
        return _algo.QRMethod_getGramInverseDiag(self)


    def getHDiag(self):
        """
        Get the diagonal of the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of H.
        """
        return _algo.QRMethod_getHDiag(self)


    def getGramInverseTrace(self):
        """
        Get the trace of the inverse Gram matrix.

        .. math::

            Tr(G^{-1}) = Tr(x^T * x)^{-1}

        Returns
        -------
        x : :class:`~openturns.Scalar`
            The trace of inverse Gram matrix.
        """
        return _algo.QRMethod_getGramInverseTrace(self)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.QRMethod_update(self, addedIndices, conservedIndices, removedIndices, row)


    def trashDecomposition(self):
        """Drop the current decomposition."""
        return _algo.QRMethod_trashDecomposition(self)


    def __init__(self, *args):
        this = _algo.new_QRMethod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_QRMethod
    __del__ = lambda self: None
QRMethod_swigregister = _algo.QRMethod_swigregister
QRMethod_swigregister(QRMethod)

class SVDMethod(LeastSquaresMethodImplementation):
    """
    Least squares solver using SVD decomposition.

    Available constructors:
        SVDMethod(*proxy, weight, indices*)

        SVDMethod(*proxy, indices*)

    Parameters
    ----------
    proxy : :class:`~openturns.DesignProxy`
        Input sample
    weight : sequence of float
        Output weights
    indices : sequence of int
        Indices allowed in the basis

    See also
    --------
    LeastSquaresMethod
    """

    __swig_setmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SVDMethod, name, value)
    __swig_getmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SVDMethod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.SVDMethod_getClassName(self)


    def __repr__(self):
        return _algo.SVDMethod___repr__(self)

    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.SVDMethod_solve(self, rhs)


    def solveNormal(self, rhs):
        """
        Solve the least-squares problem using normal equation.

        .. math::

            M^T*M*x=M^T*b

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        x : :class:`~openturns.Point`
            The solution.
        """
        return _algo.SVDMethod_solveNormal(self, rhs)


    def getGramInverse(self):
        """
        Get the inverse Gram matrix of input sample.

        .. math::

            G^{-1} = (X^T * X)^{-1}

        Returns
        -------
        c : :class:`~openturns.CovarianceMatrix`
            The inverse Gram matrix.
        """
        return _algo.SVDMethod_getGramInverse(self)


    def getGramInverseDiag(self):
        """
        Get the diagonal of the inverse Gram matrix.

        .. math::

            diag(G^{-1}) = diag((X^T * X)^{-1})

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of the inverse Gram matrix.
        """
        return _algo.SVDMethod_getGramInverseDiag(self)


    def getHDiag(self):
        """
        Get the diagonal of the projection matrix H.

        .. math::

            H = X * (X^T * X)^{-1} * X^T

        Returns
        -------
        d : :class:`~openturns.Point`
            The diagonal of H.
        """
        return _algo.SVDMethod_getHDiag(self)


    def getGramInverseTrace(self):
        """
        Get the trace of the inverse Gram matrix.

        .. math::

            Tr(G^{-1}) = Tr(x^T * x)^{-1}

        Returns
        -------
        x : :class:`~openturns.Scalar`
            The trace of inverse Gram matrix.
        """
        return _algo.SVDMethod_getGramInverseTrace(self)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.SVDMethod_update(self, addedIndices, conservedIndices, removedIndices, row)


    def trashDecomposition(self):
        """Drop the current decomposition."""
        return _algo.SVDMethod_trashDecomposition(self)


    def __init__(self, *args):
        this = _algo.new_SVDMethod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_SVDMethod
    __del__ = lambda self: None
SVDMethod_swigregister = _algo.SVDMethod_swigregister
SVDMethod_swigregister(SVDMethod)

class SparseMethod(LeastSquaresMethodImplementation):
    """
    Least squares solver using a sparse representation.

    Available constructors:
        SparseMethod(*method*)

        SparseMethod(*method, basisSequenceFactory, fittingAlgorithm*)

    Parameters
    ----------
    method : :class:`~openturns.LeastSquaresMethod`
        Least squares resolution method
    basisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
        Basis enumeration algorithm
    fittingAlgorithm : :class:`~openturns.FittingAlgorithm`
        Validation algorithm

    See also
    --------
    LeastSquaresMethod
    """

    __swig_setmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SparseMethod, name, value)
    __swig_getmethods__ = {}
    for _s in [LeastSquaresMethodImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SparseMethod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.SparseMethod_getClassName(self)


    def __repr__(self):
        return _algo.SparseMethod___repr__(self)

    def getInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            Input sample.
        """
        return _algo.SparseMethod_getInputSample(self)


    def getWeight(self):
        """
        Weights accessor.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Weights.
        """
        return _algo.SparseMethod_getWeight(self)


    def getBasis(self):
        """
        Basis accessor.

        Returns
        -------
        basis : :class:`~openturns.getBasis`
            Basis.
        """
        return _algo.SparseMethod_getBasis(self)


    def getCurrentIndices(self):
        """
        Current indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the current decomposition in the global basis.
        """
        return _algo.SparseMethod_getCurrentIndices(self)


    def getInitialIndices(self):
        """
        Initial indices accessor.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Initial indices of the terms in the global basis.
        """
        return _algo.SparseMethod_getInitialIndices(self)


    def solve(self, rhs):
        """
        Solve the least-squares problem.

        .. math::

            \\vect{a} = \\argmin_{\\vect{x} \\in \\Rset^P} ||M\\vect{x}-\\vect{b}||^2

        Parameters
        ----------
        b : sequence of float
            Second term of the equation

        Returns
        -------
        a : :class:`~openturns.Point`
            The solution.
        """
        return _algo.SparseMethod_solve(self, rhs)


    def getGramInverse(self):
        """
        Get the inverse Gram matrix of input sample.

        .. math::

            G^{-1} = (X^T * X)^{-1}

        Returns
        -------
        c : :class:`~openturns.CovarianceMatrix`
            The inverse Gram matrix.
        """
        return _algo.SparseMethod_getGramInverse(self)


    def update(self, addedIndices, conservedIndices, removedIndices, row=False):
        """
        Update the current decomposition.

        Parameters
        ----------
        addedIndices : sequence of int
            Indices of added basis terms.
        conservedIndices : sequence of int
            Indices of conserved basis terms.
        removedIndices : sequence of int
            Indices of removed basis terms.
        """
        return _algo.SparseMethod_update(self, addedIndices, conservedIndices, removedIndices, row)


    def trashDecomposition(self):
        """Drop the current decomposition."""
        return _algo.SparseMethod_trashDecomposition(self)


    def buildCurrentBasis(self):
        """
        Build the current basis.

        Returns
        -------
        phi : :class:`~openturns.Basis`
            The basis according to current indices.
        """
        return _algo.SparseMethod_buildCurrentBasis(self)


    def computeWeightedDesign(self, whole=False):
        """
        Build the design matrix.

        Parameters
        ----------
        whole : bool, defaults to False
            Whether to use the initial indices instead of the current indices

        Returns
        -------
        psiAk : :class:`~openturns.Matrix`
            The design matrix
        """
        return _algo.SparseMethod_computeWeightedDesign(self, whole)


    def __init__(self, *args):
        this = _algo.new_SparseMethod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_SparseMethod
    __del__ = lambda self: None
SparseMethod_swigregister = _algo.SparseMethod_swigregister
SparseMethod_swigregister(SparseMethod)

class LeastSquaresMetaModelSelection(ApproximationAlgorithmImplementation):
    """
    Least squares metamodel selection factory.

    Adaptative sparse selection, as proposed in [Blatman2009]_.

    See also
    --------
    ApproximationAlgorithm, PenalizedLeastSquaresAlgorithm

    Notes
    -----
    The LeastSquaresMetaModelSelection is built from a least squares metamodel
    selection factory.
    """

    __swig_setmethods__ = {}
    for _s in [ApproximationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresMetaModelSelection, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresMetaModelSelection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.LeastSquaresMetaModelSelection_getClassName(self)


    def __repr__(self):
        return _algo.LeastSquaresMetaModelSelection___repr__(self)

    def setBasisSequenceFactory(self, basisSequenceFactory):
        return _algo.LeastSquaresMetaModelSelection_setBasisSequenceFactory(self, basisSequenceFactory)

    def getBasisSequenceFactory(self):
        return _algo.LeastSquaresMetaModelSelection_getBasisSequenceFactory(self)

    def setFittingAlgorithm(self, fittingAlgorithm):
        return _algo.LeastSquaresMetaModelSelection_setFittingAlgorithm(self, fittingAlgorithm)

    def getFittingAlgorithm(self):
        return _algo.LeastSquaresMetaModelSelection_getFittingAlgorithm(self)

    def run(self, *args):
        """Run the algorithm."""
        return _algo.LeastSquaresMetaModelSelection_run(self, *args)


    def __init__(self, *args):
        this = _algo.new_LeastSquaresMetaModelSelection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_LeastSquaresMetaModelSelection
    __del__ = lambda self: None
LeastSquaresMetaModelSelection_swigregister = _algo.LeastSquaresMetaModelSelection_swigregister
LeastSquaresMetaModelSelection_swigregister(LeastSquaresMetaModelSelection)

class LeastSquaresMetaModelSelectionFactory(ApproximationAlgorithmImplementationFactory):
    """
    Least squares metamodel selection factory.

    Available constructors:
        LeastSquaresMetaModelSelectionFactory()

        LeastSquaresMetaModelSelectionFactory(*basisSeqFac*)

        LeastSquaresMetaModelSelectionFactory(*basisSeqFac, fittingAlgo*)

    Parameters
    ----------
    basisSeqFac : :class:`~openturns.BasisSequenceFactory`
        A basis sequence factory.
    fittingAlgo : :class:`~openturns.FittingAlgorithm`
        A fitting algorithm.

    See also
    --------
    ApproximationAlgorithm, PenalizedLeastSquaresAlgorithmFactory

    Notes
    -----
    Implementation of an approximation algorithm implementation factory which builds
    an :class:`~openturns.ApproximationAlgorithm`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.

    Examples
    --------
    >>> import openturns as ot
    >>> basisSequenceFactory = ot.LARS()
    >>> fittingAlgorithm = ot.CorrectedLeaveOneOut()
    >>> approximationAlgorithm = ot.LeastSquaresMetaModelSelectionFactory(
    ...                                     basisSequenceFactory, fittingAlgorithm)
    """

    __swig_setmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeastSquaresMetaModelSelectionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeastSquaresMetaModelSelectionFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.LeastSquaresMetaModelSelectionFactory_getClassName(self)


    def getBasisSequenceFactory(self):
        """
        Accessor to the basis sequence factory.

        Returns
        -------
        basis : :class:`~openturns.BasisSequenceFactory`
            Basis sequence factory.
        """
        return _algo.LeastSquaresMetaModelSelectionFactory_getBasisSequenceFactory(self)


    def getFittingAlgorithm(self):
        """
        Accessor to the fitting algorithm.

        Returns
        -------
        algo : :class:`~openturns.FittingAlgorithm`
            Fitting algorithm.
        """
        return _algo.LeastSquaresMetaModelSelectionFactory_getFittingAlgorithm(self)


    def build(self, x, y, weight, psi, indices):
        return _algo.LeastSquaresMetaModelSelectionFactory_build(self, x, y, weight, psi, indices)

    def __repr__(self):
        return _algo.LeastSquaresMetaModelSelectionFactory___repr__(self)

    def __init__(self, *args):
        this = _algo.new_LeastSquaresMetaModelSelectionFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_LeastSquaresMetaModelSelectionFactory
    __del__ = lambda self: None
LeastSquaresMetaModelSelectionFactory_swigregister = _algo.LeastSquaresMetaModelSelectionFactory_swigregister
LeastSquaresMetaModelSelectionFactory_swigregister(LeastSquaresMetaModelSelectionFactory)

class PenalizedLeastSquaresAlgorithm(ApproximationAlgorithmImplementation):
    """
    Penalized least squares algorithm.

    Available constructors:
        PenalizedLeastSquaresAlgorithm(*x, y, psi, indices, penalizationFactor=0, useNormal=False*)

        PenalizedLeastSquaresAlgorithm(*x, y, weight, psi, indices, penalizationFactor=0, useNormal=False*)

        PenalizedLeastSquaresAlgorithm(*x, y, weight, psi, indices, penalizationFactor=0, penalizationMatrix, useNormal=False*)

    Parameters
    ----------
    x : :class:`~openturns.Sample`
        Input sample
    y : :class:`~openturns.Sample`
        Output sample
    weight : sequence of float
        Output weights
    psi : :class:`~openturns.Basis`
        Functional basis
    indices : sequence of int
        Indices allowed in the basis
    penalizationFactor : float, optional
        Penalization factor
    penalizationMatrix : 2-d sequence of float
        Penalization matrix
    useNormal : bool, optional
        Solve the normal equation

    See also
    --------
    ApproximationAlgorithm, LeastSquaresMetaModelSelection

    Notes
    -----
    Solve the least-squares problem:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} ||y - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U})||^2

    """

    __swig_setmethods__ = {}
    for _s in [ApproximationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PenalizedLeastSquaresAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PenalizedLeastSquaresAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.PenalizedLeastSquaresAlgorithm_getClassName(self)


    def __repr__(self):
        return _algo.PenalizedLeastSquaresAlgorithm___repr__(self)

    def run(self):
        """Run the algorithm."""
        return _algo.PenalizedLeastSquaresAlgorithm_run(self)


    def __init__(self, *args):
        this = _algo.new_PenalizedLeastSquaresAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_PenalizedLeastSquaresAlgorithm
    __del__ = lambda self: None
PenalizedLeastSquaresAlgorithm_swigregister = _algo.PenalizedLeastSquaresAlgorithm_swigregister
PenalizedLeastSquaresAlgorithm_swigregister(PenalizedLeastSquaresAlgorithm)

class PenalizedLeastSquaresAlgorithmFactory(ApproximationAlgorithmImplementationFactory):
    """
    Penalized least squares algorithm factory.

    Available constructors:
        PenalizedLeastSquaresAlgorithmFactory()

    See also
    --------
    ApproximationAlgorithm, LeastSquaresMetaModelSelectionFactory

    Notes
    -----
    Implementation of an approximation algorithm implementation factory which builds
    an :class:`~openturns.ApproximationAlgorithm`.

    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """

    __swig_setmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PenalizedLeastSquaresAlgorithmFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [ApproximationAlgorithmImplementationFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PenalizedLeastSquaresAlgorithmFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.PenalizedLeastSquaresAlgorithmFactory_getClassName(self)


    def build(self, x, y, weight, psi, indices):
        return _algo.PenalizedLeastSquaresAlgorithmFactory_build(self, x, y, weight, psi, indices)

    def __repr__(self):
        return _algo.PenalizedLeastSquaresAlgorithmFactory___repr__(self)

    def __init__(self, *args):
        this = _algo.new_PenalizedLeastSquaresAlgorithmFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_PenalizedLeastSquaresAlgorithmFactory
    __del__ = lambda self: None
PenalizedLeastSquaresAlgorithmFactory_swigregister = _algo.PenalizedLeastSquaresAlgorithmFactory_swigregister
PenalizedLeastSquaresAlgorithmFactory_swigregister(PenalizedLeastSquaresAlgorithmFactory)

class KissFFT(openturns.statistics.FFTImplementation):
    """
    Kiss FFT.

    See also
    --------
    FFT

    Notes
    -----
    The KissFFT class inherits from the :class:`~openturns.FFT` class. The methods
    are the same as the FFT class (there is no additional method). This class
    interacts with the kissfft implemented and return results as OpenTURNS objects
    (:class:`~openturns.ComplexCollection`).
    """

    __swig_setmethods__ = {}
    for _s in [openturns.statistics.FFTImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KissFFT, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.statistics.FFTImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KissFFT, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KissFFT_getClassName(self)


    def transform(self, *args):
        """
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} x_n exp(-2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _algo.KissFFT_transform(self, *args)


    def inverseTransform(self, *args):
        """
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} \\frac{1}{N} x_n exp(2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.ComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _algo.KissFFT_inverseTransform(self, *args)


    def transform2D(self, *args):
        """
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _algo.KissFFT_transform2D(self, *args)


    def inverseTransform2D(self, *args):
        """
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l}} = \\frac{1}{M\\times N}\\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _algo.KissFFT_inverseTransform2D(self, *args)


    def transform3D(self, *args):
        """
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N}) exp(-2 i \\pi \\frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _algo.KissFFT_transform3D(self, *args)


    def inverseTransform3D(self, *args):
        """
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} \\frac{1}{M\\times N \\times P} Z_{m,n,p} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N}) exp(2 i \\pi \\frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _algo.KissFFT_inverseTransform3D(self, *args)


    def __repr__(self):
        return _algo.KissFFT___repr__(self)

    def __str__(self, *args):
        return _algo.KissFFT___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KissFFT(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KissFFT
    __del__ = lambda self: None
KissFFT_swigregister = _algo.KissFFT_swigregister
KissFFT_swigregister(KissFFT)

class IntegrationAlgorithmImplementation(openturns.common.PersistentObject):
    """Base class for integration algorithms."""

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntegrationAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntegrationAlgorithmImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.IntegrationAlgorithmImplementation_getClassName(self)


    def integrate(self, *args):
        """
        Integrate a function on an interval.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            The function to integrate.
        interval : :class:`~openturns.Interval`
            The integration domain.

        Returns
        -------
        value : :class:`~openturns.Point`
            The integral value.
        """
        return _algo.IntegrationAlgorithmImplementation_integrate(self, *args)


    def __repr__(self):
        return _algo.IntegrationAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _algo.IntegrationAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_IntegrationAlgorithmImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_IntegrationAlgorithmImplementation
    __del__ = lambda self: None
IntegrationAlgorithmImplementation_swigregister = _algo.IntegrationAlgorithmImplementation_swigregister
IntegrationAlgorithmImplementation_swigregister(IntegrationAlgorithmImplementation)

class IntegrationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntegrationAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntegrationAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_IntegrationAlgorithmImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.IntegrationAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.IntegrationAlgorithmImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.IntegrationAlgorithmImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.IntegrationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_IntegrationAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self: None
IntegrationAlgorithmImplementationTypedInterfaceObject_swigregister = _algo.IntegrationAlgorithmImplementationTypedInterfaceObject_swigregister
IntegrationAlgorithmImplementationTypedInterfaceObject_swigregister(IntegrationAlgorithmImplementationTypedInterfaceObject)

class IntegrationAlgorithm(IntegrationAlgorithmImplementationTypedInterfaceObject):
    """Base class for integration algorithms."""

    __swig_setmethods__ = {}
    for _s in [IntegrationAlgorithmImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntegrationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [IntegrationAlgorithmImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntegrationAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.IntegrationAlgorithm_getClassName(self)


    def integrate(self, *args):
        """
        Integrate a function on an interval.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            The function to integrate.
        interval : :class:`~openturns.Interval`
            The integration domain.

        Returns
        -------
        value : :class:`~openturns.Point`
            The integral value.
        """
        return _algo.IntegrationAlgorithm_integrate(self, *args)


    def __repr__(self):
        return _algo.IntegrationAlgorithm___repr__(self)

    def __str__(self, *args):
        return _algo.IntegrationAlgorithm___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_IntegrationAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_IntegrationAlgorithm
    __del__ = lambda self: None
IntegrationAlgorithm_swigregister = _algo.IntegrationAlgorithm_swigregister
IntegrationAlgorithm_swigregister(IntegrationAlgorithm)

class GaussKronrodRule(openturns.common.PersistentObject):
    """
    Gauss-Kronrod rule used in the integration algorithm.

    Parameters
    ----------
    myGaussKronrodPair : :class:`~openturns.GaussKronrodPair`
        It encodes the selected rule. 

        Available rules: 

        - GaussKronrodRule.G1K3, 
        - GaussKronrodRule.G3K7, 
        - GaussKronrodRule.G7K15, 
        - GaussKronrodRule.G11K23,
        - GaussKronrodRule.G15K31, 
        - GaussKronrodRule.G25K51. 

    Notes
    -----
    The Gauss-Kronrod rules :math:`G_mK_{2m+1}` with  :math:`m=2n+1` enable to build two approximations of the definite integral :math:`\\int_{-1}^1 f(t)\\di{t}` defined by:

    .. math::

        \\int_{-1}^1 f(t)\\di{t} \\simeq  \\omega_0f(0) + \\sum_{k=1}^n \\omega_k (f(\\xi_k)+f(-\\xi_k))

    and:

    .. math::

      \\int_{-1}^1 f(t)\\di{t}\\simeq  \\alpha_0f(0) + \\sum_{k=1}^{m} \\alpha_k (f(\\zeta_k)+f(-\\zeta_k))

    We have :math:`\\xi_k>0`,  :math:`\\zeta_k>0`, :math:`\\zeta_{2j}=\\xi_j`, :math:`\\omega_k>0` and :math:`\\alpha_k>0`.

    The rule :math:`G_mK_{2m+1}` combines a :math:`m`-point Gauss rule and a :math:`(2m+1)`-point Kronrod rule (re-using the :math:`m` nodes of the Gauss method). The nodes are defined on :math:`[-1, 1]` and always contain the node 0 when :math:`m`  is odd. 

    Examples
    --------
    Create an Gauss-Kronrod rule:

    >>> import openturns as ot
    >>> myRule = ot.GaussKronrodRule(ot.GaussKronrodRule.G15K31)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GaussKronrodRule, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GaussKronrodRule, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.GaussKronrodRule_getClassName(self)

    G1K3 = _algo.GaussKronrodRule_G1K3
    G3K7 = _algo.GaussKronrodRule_G3K7
    G7K15 = _algo.GaussKronrodRule_G7K15
    G11K23 = _algo.GaussKronrodRule_G11K23
    G15K31 = _algo.GaussKronrodRule_G15K31
    G25K51 = _algo.GaussKronrodRule_G25K51

    def __repr__(self):
        return _algo.GaussKronrodRule___repr__(self)

    def __str__(self, *args):
        return _algo.GaussKronrodRule___str__(self, *args)

    def getPair(self):
        """
        Accessor to pair definig the rule.

        Returns
        -------
        gkPair : :class:`~openturns.GaussKronrodPair`
            Id of the Gauss-Kronrod rule.
        """
        return _algo.GaussKronrodRule_getPair(self)


    def getOrder(self):
        """
        Accessor to :math:`m` parameter.

        Returns
        -------
        m : int
            The number of points used for the Gauss approximation.
        """
        return _algo.GaussKronrodRule_getOrder(self)


    def getZeroGaussWeight(self):
        """
        Accessor to the first Gauss weight.

        Returns
        -------
        zeroKronrodWeight : float
            The  first weight :math:`\\omega_0`.

        """
        return _algo.GaussKronrodRule_getZeroGaussWeight(self)


    def getOtherGaussWeights(self):
        """
        Accessor to the weights used in the Gauss approximation.

        Returns
        -------
        otherGaussWeights : :class:`~openturns.Point`
            The  weights :math:`(\\omega_k)_{1 \\leq k \\leq n}`
        """
        return _algo.GaussKronrodRule_getOtherGaussWeights(self)


    def getOtherKronrodNodes(self):
        """
        Accessor to the positive nodes used in the Gauss-Kronrod approximation.

        Returns
        -------
        otherKronrodNodes : :class:`~openturns.Point`
            The  positive nodes :math:`(\\zeta_k)_{1 \\leq k \\leq m}`
            It contains the positive Gauss nodes as we have :math:`\\zeta_{2j}=\\xi_j`.

        """
        return _algo.GaussKronrodRule_getOtherKronrodNodes(self)


    def getZeroKronrodWeight(self):
        """
        Accessor to the first Kronrod weight.

        Returns
        -------
        zeroKronrodWeight : float
            The  first weight :math:`\\alpha_0`.

        """
        return _algo.GaussKronrodRule_getZeroKronrodWeight(self)


    def getOtherKronrodWeights(self):
        """
        Accessor to the  positive nodes used in the Gauss-Kronrod approximation.

        Returns
        -------
        otherKronrodWeights : :class:`~openturns.Point`
            The  weights :math:`(\\alpha_k)_{1 \\leq k \\leq m}`.

        """
        return _algo.GaussKronrodRule_getOtherKronrodWeights(self)


    def __init__(self, *args):
        this = _algo.new_GaussKronrodRule(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_GaussKronrodRule
    __del__ = lambda self: None
GaussKronrodRule_swigregister = _algo.GaussKronrodRule_swigregister
GaussKronrodRule_swigregister(GaussKronrodRule)

class GaussKronrod(IntegrationAlgorithmImplementation):
    """
    Adaptive integration algorithm of Gauss-Kronrod.

    Parameters
    ----------
    maximumSubIntervals : int
        The maximal number of subdivisions of the interval :math:`[a,b]`
    maximumError : float
        The maximal error between Gauss and Kronrod approximations.
    GKRule : :class:`~openturns.GaussKronrodRule`
        The rule that fixes the number of points used in the Gauss and Kronrod approximations. 

    Notes
    -----
    The Gauss-Kronrod algorithm enables to approximate the definite integral:

    .. math::

        \\int_{a}^b f(t)\\di{t}


    with :math:`f: \\Rset \\mapsto \\Rset^p`, using both approximations : Gauss and Kronrod ones defined by:

    .. math::

        \\int_{-1}^1 f(t)\\d{t} \\simeq  \\omega_0f(0) + \\sum_{k=1}^n \\omega_k (f(\\xi_k)+f(-\\xi_k))

    and:

    .. math::

      \\int_{-1}^1 f(t)\\di{t}\\simeq  \\alpha_0f(0) + \\sum_{k=1}^{m} \\alpha_k (f(\\zeta_k)+f(-\\zeta_k))

    where :math:`\\xi_k>0`,  :math:`\\zeta_k>0`, :math:`\\zeta_{2j}=\\xi_j`, :math:`\\omega_k>0` and :math:`\\alpha_k>0`.



    The Gauss-Kronrod algorithm evaluates the integral using the Gauss and the Konrod approximations. If the difference between both approximations is greater that *maximumError*, then the interval :math:`[a,b]` is subdivided into 2 subintervals with the same length. The Gauss-Kronrod algorithm is then applied on both subintervals with the sames rules. The algorithm is iterative until the  difference between both approximations is less that *maximumError*. In that case, the integral on the subinterval is approximated by the Kronrod sum. The subdivision process is limited by *maximumSubIntervals* that imposes the maximum number of subintervals.

    The final integral is the sum of the integrals evaluated on the subintervals.

    Examples
    --------
    Create a Gauss-Kronrod algorithm:

    >>> import openturns as ot
    >>> algo = ot.GaussKronrod(100, 1e-8, ot.GaussKronrodRule(ot.GaussKronrodRule.G11K23))
    """

    __swig_setmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GaussKronrod, name, value)
    __swig_getmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GaussKronrod, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.GaussKronrod_getClassName(self)


    def integrate(self, *args):
        """
        Evaluation of the integral of :math:`f` on an interval.

        Available usages:
            integrate(*f, interval*)

            integrate(*f, interval, error*)

            integrate(*f, a, b, error, ai, bi, fi, ei*)

        Parameters
        ----------
        f : :class:`~openturns.Function`, :math:`f: \\Rset \\mapsto \\Rset^p`
            The integrand function.
        interval : :class:`~openturns.Interval`, :math:`interval \\in \\Rset` 
            The integration domain. 
        error : :class:`~openturns.Point`
            The error estimation of the approximation.
        a,b : float 
            Bounds of the integration interval.
        ai, bi, ei : :class:`~openturns.Point`; 
            *ai* is the set of lower bounds of the subintervals; 

            *bi* the corresponding upper bounds; 

            *ei* the associated error estimation. 
        fi : :class:`~openturns.Sample`
            *fi* is the set of :math:`\\int_{ai}^{bi} f(t)\\di{t}`

        Returns
        -------
        value : :class:`~openturns.Point`
            Approximation of the integral.


        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x'], ['abs(sin(x))'])
        >>> a = -2.5
        >>> b = 4.5
        >>> algoGK = ot.GaussKronrod(100, 1e-8, ot.GaussKronrodRule(ot.GaussKronrodRule.G11K23))

        Use the high-level usage:

        >>> value = algoGK.integrate(f, ot.Interval(a, b))[0]
        >>> print(value)
        4.590...

        Use the low-level usage:

        >>> error = ot.Point()
        >>> ai = ot.Point()
        >>> bi = ot.Point()
        >>> ei = ot.Point()
        >>> fi = ot.Sample()
        >>> value2 = algoGK.integrate(f, a, b, error, ai, bi, fi, ei)[0]
        >>> print(value2)
        4.590...
        """
        return _algo.GaussKronrod_integrate(self, *args)


    def getMaximumSubIntervals(self):
        """
        Accessor to the maximal  number of subdivisions of :math:`[a,b]`.

        Returns
        -------
        maximumSubIntervals : float, positive
            The maximal number of subdivisions of the interval :math:`[a,b]`.
        """
        return _algo.GaussKronrod_getMaximumSubIntervals(self)


    def setMaximumSubIntervals(self, maximumSubIntervals):
        """
        Set the maximal  number of subdivisions of :math:`[a,b]`.

        Parameters
        ----------
        maximumSubIntervals : float, positive
            The maximal number of subdivisions of the interval :math:`[a,b]`.
        """
        return _algo.GaussKronrod_setMaximumSubIntervals(self, maximumSubIntervals)


    def getMaximumError(self):
        """
        Accessor to the maximal error between Gauss and Kronrod approximations.

        Returns
        -------
        maximumErrorvalue : float, positive
            The maximal error between Gauss and Kronrod approximations.
        """
        return _algo.GaussKronrod_getMaximumError(self)


    def setMaximumError(self, maximumError):
        """
        Set the maximal error between Gauss and Kronrod approximations.

        Parameters
        ----------
        maximumErrorvalue : float, positive
            The maximal error between Gauss and Kronrod approximations.
        """
        return _algo.GaussKronrod_setMaximumError(self, maximumError)


    def getRule(self):
        """
        Accessor to the Gauss-Kronrod rule used in the integration algorithm.

        Returns
        -------
        rule : :class:`~openturns.GaussKronrodRule`
            The Gauss-Kronrod rule used in the integration algorithm.
        """
        return _algo.GaussKronrod_getRule(self)


    def setRule(self, rule):
        """
        Set the Gauss-Kronrod rule used in the integration algorithm.

        Parameters
        ----------
        rule : :class:`~openturns.GaussKronrodRule`
            The Gauss-Kronrod rule used in the integration algorithm.
        """
        return _algo.GaussKronrod_setRule(self, rule)


    def __repr__(self):
        return _algo.GaussKronrod___repr__(self)

    def __str__(self, *args):
        return _algo.GaussKronrod___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_GaussKronrod(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_GaussKronrod
    __del__ = lambda self: None
GaussKronrod_swigregister = _algo.GaussKronrod_swigregister
GaussKronrod_swigregister(GaussKronrod)

class GaussLegendre(IntegrationAlgorithmImplementation):
    """
    Tensorized integration algorithm of Gauss-Legendre.

    Available constructors:
        GaussLegendre(*dimension=1*)

        GaussLegendre(*discretization*)

    Parameters
    ----------
    dimension : int, :math:`dimension>0`
        The dimension of the functions to integrate. The default discretization is *GaussLegendre-DefaultMarginalIntegrationPointsNumber* in each dimension, see :class:`~openturns.ResourceMap`.
    discretization : sequence of int
        The number of nodes in each dimension. The sequence must be non-empty and must contain only positive values.

    Notes
    -----
    The Gauss-Legendre algorithm enables to approximate the definite integral:

    .. math::

        \\int_{\\vect{a}}^\\vect{b} f(\\vect{t})\\di{\\vect{t}}


    with :math:`f: \\Rset^d \\mapsto \\Rset^p`, :math:`\\vect{a}, \\vect{b}\\in\\Rset^d` using a fixed tensorized Gauss-Legendre approximation:

    .. math::

        \\int_{\\vect{a}}^\\vect{b} f(\\vect{t})\\di{\\vect{t}} = \\sum_{\\vect{n}\\in \\cN}\\left(\\prod_{i=1}^d w^{N_i}_{n_i}\\right)f(\\xi^{N_1}_{n_1},\\dots,\\xi^{N_d}_{n_d})

    where :math:`\\xi^{N_i}_{n_i}` is the :math:`n_i`th node of the :math:`N_i`-points Gauss-Legendre 1D integration rule and :math:`w^{N_i}_{n_i}` the associated weight.

    Examples
    --------
    Create a Gauss-Legendre algorithm:

    >>> import openturns as ot
    >>> algo = ot.GaussLegendre(2)
    >>> algo = ot.GaussLegendre([2, 4, 5])
    """

    __swig_setmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GaussLegendre, name, value)
    __swig_getmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GaussLegendre, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.GaussLegendre_getClassName(self)


    def integrate(self, *args):
        """
        Evaluation of the integral of :math:`f` on an interval.

        Available usages:
            integrate(*f, interval*)

            integrate(*f, interval, xi*)

        Parameters
        ----------
        f : :class:`~openturns.Function`, :math:`f: \\Rset^d \\mapsto \\Rset^p`
            The integrand function.
        interval : :class:`~openturns.Interval`, :math:`interval \\in \\Rset^d` 
            The integration domain. 
        xi : :class:`~openturns.Sample`
            The integration nodes.

        Returns
        -------
        value : :class:`~openturns.Point`
            Approximation of the integral.


        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x'], ['sin(x)'])
        >>> a = -2.5
        >>> b = 4.5
        >>> algoGL = ot.GaussLegendre([10])
        >>> value = algoGL.integrate(f, ot.Interval(a, b))[0]
        >>> print(value)
        -0.590...

        """
        return _algo.GaussLegendre_integrate(self, *args)


    def integrateWithNodes(self, function, interval):
        return _algo.GaussLegendre_integrateWithNodes(self, function, interval)

    def getDiscretization(self):
        """
        Accessor to the discretization of the tensorized rule.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            The number of integration point in each dimension.
        """
        return _algo.GaussLegendre_getDiscretization(self)


    def getNodes(self):
        """
        Accessor to the integration nodes.

        Returns
        -------
        nodes : :class:`~openturns.Sample`
            The tensorized Gauss-Legendre integration nodes on :math:`[0,1]^d` where :math:`d>0` is the dimension of the integration algorithm.
        """
        return _algo.GaussLegendre_getNodes(self)


    def getWeights(self):
        """
        Accessor to the integration weights.

        Returns
        -------
        weights : :class:`~openturns.Point`
            The tensorized Gauss-Legendre integration weights on :math:`[0,1]^d` where :math:`d>0` is the dimension of the integration algorithm.
        """
        return _algo.GaussLegendre_getWeights(self)


    def __repr__(self):
        return _algo.GaussLegendre___repr__(self)

    def __str__(self, *args):
        return _algo.GaussLegendre___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_GaussLegendre(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_GaussLegendre
    __del__ = lambda self: None
GaussLegendre_swigregister = _algo.GaussLegendre_swigregister
GaussLegendre_swigregister(GaussLegendre)

class IteratedQuadrature(IntegrationAlgorithmImplementation):
    """
    Multivariate integration algorithm.

    Parameters
    ----------
    univariateQuadrature : :class:`~openturns.IntegrationAlgorithm`
        By default, the integration algorithm is the Gauss-Kronrod algorithm (:class:`~openturns.GaussKronrod`)  with the following parameters: maximumSubIntervals=32, maximumError= :math:`1e-7` and GKRule = G3K7. 
        Note that the default parametrisation of the :class:`~openturns.GaussKronrod` class leads to a more precise evaluation of the integral but the cost is greater. It is recommended to increase the order of the quadratic rule and the number of sub intervals if the integrand or one of the bound functions is smooth but with many oscillations. 

    Notes
    -----
    This class enables to approximate the following integral:

    .. math::

        I_f = \\int_{a}^{b}\\, \\int_{l_1(x_0)}^{u_1(x_0)}\\, \\int_{l_2(x_0, x_1)}^{u_2(x_0,x_1)}\\, \\int_{l_{n-1}(x_0, \\dots, x_{n-2})}^{u_{n-1}(x_0, \\dots, x_{n-2})} \\, f(x_0, \\dots, x_{n-1})\\di{x_{n-1}}\\dots\\di{x_0}

    with :math:`f: \\Rset^n \\mapsto \\Rset^p`, :math:`l_k, u_k: \\Rset^k \\mapsto \\Rset` and :math:`n\\geq 1`. For :math:`n=1`, there is no bound functions :math:`l_k` and :math:`u_k`.


    Examples
    --------
    Create an iterated quadrature algorithm:

    >>> import openturns as ot
    >>> import math as m
    >>> a = -m.pi
    >>> b = m.pi
    >>> f = ot.SymbolicFunction(['x', 'y'], ['1+cos(x)*sin(y)'])
    >>> l = [ot.SymbolicFunction(['x'], [' 2+cos(x)'])]
    >>> u = [ot.SymbolicFunction(['x'], ['-2-cos(x)'])]

    Draw the graph of the integrand and the bounds:

    >>> g = ot.Graph('Integration nodes', 'x', 'y', True, 'topright')
    >>> g.add(f.draw([a,a],[b,b]))
    >>> curve = l[0].draw(a, b).getDrawable(0)
    >>> curve.setLineWidth(2)
    >>> curve.setColor('red')
    >>> g.add(curve)
    >>> curve = u[0].draw(a, b).getDrawable(0)
    >>> curve.setLineWidth(2)
    >>> curve.setColor('red')
    >>> g.add(curve)

    Evaluate the integral with high precision:

    >>> Iref = ot.IteratedQuadrature(ot.GaussKronrod(100000, 1e-13, ot.GaussKronrodRule(ot.GaussKronrodRule.G11K23))).integrate(f, a, b, l, u)

    Evaluate the integral with the default GaussKronrod algorithm:

    >>> f.enableHistory()
    >>> I1 = ot.IteratedQuadrature(ot.GaussKronrod()).integrate(f, a, b, l, u)
    >>> sample1 = f.getHistoryInput().getSample()
    >>> print(I1)
    [-25.132...]
    >>> n_evals = sample1.getSize()
    >>> print(n_evals)
    2116
    >>> err = abs(100.0*(1.0-I1[0]/Iref[0]))
    >>> print(err)
    2.2...e-14
    >>> cloud = ot.Cloud(sample1)
    >>> cloud.setPointStyle('fcircle')
    >>> cloud.setColor('green')
    >>> g.add(cloud)
    >>> f.clearHistory()

    Evaluate the integral with the default IteratedQuadrature algorithm:

    >>> I2 = ot.IteratedQuadrature().integrate(f, a, b, l, u)
    >>> sample2 = f.getHistoryInput().getSample()
    >>> print(I2)
    [-25.132...]
    >>> n_evals = sample2.getSize()
    >>> print(n_evals)
    5236
    >>> err = abs(100.0*(1.0-I2[0]/Iref[0]))
    >>> print(err)
    4.6...e-10
    >>> cloud = ot.Cloud(sample2)
    >>> cloud.setPointStyle('fcircle')
    >>> cloud.setColor('gold')
    >>> g.add(cloud)
    """

    __swig_setmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IteratedQuadrature, name, value)
    __swig_getmethods__ = {}
    for _s in [IntegrationAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IteratedQuadrature, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.IteratedQuadrature_getClassName(self)


    def integrate(self, *args):
        """
        Evaluation of the integral of :math:`f` on a domain.

        Available usages:
            integrate(*f, interval*)

            integrate(*f, a, b, lowerBoundFunctions, upperBoundFunctions*)

        Parameters
        ----------
        f : :class:`~openturns.Function`, :math:`f: \\Rset^n \\mapsto \\Rset^p`
            The integrand function.
        interval : :class:`~openturns.Interval`, :math:`interval \\in \\Rset^n` 
            The integration domain. 
        a,b : float 
            Bounds of the integration interval of the first scalar input :math:`x_0`
        lowerBoundFunctions, upperBoundFunctions : list of :class:`~openturns.Function`
            List of :math:`n` functions :math:`(l_0, \\dots, l_{n-1})` and :math:`(u_0, \\dots, u_{n-1})` where :math:`l_k, u_k: \\Rset^k \\mapsto \\Rset` defining the integration domain as defined above.
            The bound functions can cross each other. 

        Returns
        -------
        value : :class:`~openturns.Point`
            Approximation of the integral.
        """
        return _algo.IteratedQuadrature_integrate(self, *args)


    def __repr__(self):
        return _algo.IteratedQuadrature___repr__(self)

    def __str__(self, *args):
        return _algo.IteratedQuadrature___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_IteratedQuadrature(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_IteratedQuadrature
    __del__ = lambda self: None
IteratedQuadrature_swigregister = _algo.IteratedQuadrature_swigregister
IteratedQuadrature_swigregister(IteratedQuadrature)

class ExpertMixture(openturns.func.EvaluationImplementation):
    """
    Expert mixture defining a piece wise function according to a classifier.

    Available constructors:
        ExpertMixture(*basis, classifier*)

    Parameters
    ----------
    basis : :class:`~openturns.Basis`
        A basis which is a collection of :class:`~openturns.Function`.
    classifier : :class:`~openturns.Classifier`
        A classifier

    See also
    --------
    Classifier, MixtureClassifier

    Notes
    -----
    This implements an expert mixture which is a piece wise function :math:`f` 
    defined by the collection of functions :math:`(f_i)_{i=1, \\ldots, N}` given in
    *basis* and according to the classifier *classifier*:

    .. math::

        f(\\vect{x}) &= f_1(\\vect{x}) \\hspace{1em} \\forall \\vect{x} \\in \\text{Classe} 1 \\\\
                    &= f_k(\\vect{x}) \\hspace{1em} \\forall \\vect{x} \\in \\text{Classe} k \\\\
                    &= f_N(\\vect{x}) \\hspace{1em} \\forall \\vect{x} \\in \\text{Classe} N

    where the :math:`N` classes are defined by the classifier.

    Usage:

    - ExpertMixture(*input*)

    where *input* is a sequence of float or a 2-d sequence of float. It represents a
    point or a set of points to evaluate using the expert mixture.

    The input vector *input* is assigned to a particular class according to the
    rules defined by *classifier* and the associated marginal function :math:`f_i`
    is used to evaluate :math:`f(input)`.

    """

    __swig_setmethods__ = {}
    for _s in [openturns.func.EvaluationImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExpertMixture, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.EvaluationImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExpertMixture, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ExpertMixture_getClassName(self)


    def __eq__(self, other):
        return _algo.ExpertMixture___eq__(self, other)

    def __repr__(self):
        return _algo.ExpertMixture___repr__(self)

    def __str__(self, *args):
        return _algo.ExpertMixture___str__(self, *args)

    def __call__(self, *args):
        return _algo.ExpertMixture___call__(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _algo.ExpertMixture_getInputDimension(self)


    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _algo.ExpertMixture_getOutputDimension(self)


    def getExperts(self):
        """
        Accessor the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            The collection of functions :math:`(f_i)_{i=1, \\ldots, N}`.
        """
        return _algo.ExpertMixture_getExperts(self)


    def setExperts(self, experts):
        """
        Accessor the basis.

        Parameters
        ----------
        basis : :class:`~openturns.Basis`
            The collection of functions :math:`(f_i)_{i=1, \\ldots, N}`.
        """
        return _algo.ExpertMixture_setExperts(self, experts)


    def getClassifier(self):
        """
        Accessor the classifier.

        Returns
        -------
        classifier : :class:`~openturns.Classifier`
            The classifier.
        """
        return _algo.ExpertMixture_getClassifier(self)


    def setClassifier(self, classifier):
        """
        Accessor the classifier.

        Parameters
        ----------
        classifier : :class:`~openturns.Classifier`
            The classifier.
        """
        return _algo.ExpertMixture_setClassifier(self, classifier)


    def __init__(self, *args):
        this = _algo.new_ExpertMixture(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ExpertMixture
    __del__ = lambda self: None
ExpertMixture_swigregister = _algo.ExpertMixture_swigregister
ExpertMixture_swigregister(ExpertMixture)

class KarhunenLoeveP1Factory(openturns.common.PersistentObject):
    """
    Computation of Karhunen-Loeve decomposition using P1 approximation.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh on which the covariance model and the Karhunen-Loeve eigenfunctions (modes) are discretized.
    threshold : float
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

    Notes
    -----
    The Karhunen-Loeve decomposition using P1 approximation allows to approximate the solution of the second kind Fredholm equation:

    .. math::

        \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t})\\vect{\\phi}_n(\\vect{s})\\di{\\vect{s}}=\\lambda_n\\vect{\\phi}_n(\\vect{t})


    with :math:`\\mat{C}: \\cD\\times\\cD \\mapsto \\cS^+_d(\\Rset)` a given covariance function, :math:`\\lambda_n` a nonincreasing sequence of nonnegative values (the **eigenvalues** of the equation) and :math:`\\vect{\\phi}_n: \\cD\\mapsto\\Rset^d` the associated sequence of **eigenfunctions**, normalized by :math:`\\int_{\\cD_N}\\|\\vect{\\phi}_n(\\vect{s})\\|^2\\di{\\vect{s}}=1`.

    The Karhunen-Loeve P1 approximation consists in replacing the covariance model :math:`\\mat{C}` by its P1 approximation :math:`\\hat{\\mat{C}}` on a mesh :math:`\\cD_N` which approximates the domain :math:`\\cD`:

    .. math::
        \\forall \\vect{s},\\vect{t}\\in\\cD_N,\\quad \\hat{\\mat{C}}(\\vect{s},\\vect{t})=\\sum_{\\vect{\\xi}_i,\\vect{\\xi}_j\\in\\cV_N}\\mat{C}(\\vect{\\xi}_i,\\vect{\\xi}_j)\\theta_i(\\vect{s})\\theta_j(\\vect{t})

    Where :math:`\\theta_n: \\cD_N \\mapsto \\Rset` are the basis functions of the P1 finite element space associated to :math:`\\cD_N`, see :class:`~openturns.P1LagrangeEvaluation`.

    Examples
    --------
    Create a Karhunen-Loeve P1 factory:

    >>> import openturns as ot
    >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
    >>> threshold = 0.01
    >>> factory = ot.KarhunenLoeveP1Factory(mesh, threshold)
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveP1Factory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveP1Factory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveP1Factory_getClassName(self)


    def build(self, covarianceModel, eigenvalues):
        """
        Computation of the eigenvalues and eigen functions.

        Parameters
        ----------
        C : :class:`~openturns.CovarianceModel`, :math:`\\mat{C}: \\cD\\times\\cD \\mapsto \\cS^+_d(\\Rset)`
            The covariance model.
        ev : :class:`~openturns.Point`
            The eigenvalues :math:`\\lambda_n` in descending order such that :math:`\\lambda_n/\\lambda_0\\geq\\mathrm{threshold}`

        Returns
        -------
        functions : :class:`~openturns.Basis`
            Eigen functions of the covariance model as a basis of functions using :class:`~openturns.P1LagrangeEvaluation`.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
        >>> threshold = 0.01
        >>> factory = ot.KarhunenLoeveP1Factory(mesh, threshold)
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> ev = ot.Point()
        >>> functions = factory.build(model, ev)
        """
        return _algo.KarhunenLoeveP1Factory_build(self, covarianceModel, eigenvalues)


    def buildAsProcessSample(self, covarianceModel, eigenvalues):
        """
        Computation of the eigenvalues and eigen functions values at nodes.

        Parameters
        ----------
        C : :class:`~openturns.CovarianceModel`, :math:`\\mat{C}: \\cD\\times\\cD \\mapsto \\cS^+_d(\\Rset)`
            The covariance model.
        ev : :class:`~openturns.Point`
            The eigenvalues :math:`\\lambda_n` in descending order such that :math:`\\lambda_n\\geq\\mathrm{threshold}\\,\\lambda_0`

        Returns
        -------
        modes : :class:`~openturns.ProcessSample`
            Values of the eigen functions at the nodes :math:`\\cV_N` of the mesh :math:`\\cD_N`.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
        >>> threshold = 0.01
        >>> factory = ot.KarhunenLoeveP1Factory(mesh, threshold)
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> ev = ot.Point()
        >>> modes = factory.buildAsProcessSample(model, ev)
        """
        return _algo.KarhunenLoeveP1Factory_buildAsProcessSample(self, covarianceModel, eigenvalues)


    def __repr__(self):
        return _algo.KarhunenLoeveP1Factory___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveP1Factory___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveP1Factory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveP1Factory
    __del__ = lambda self: None
KarhunenLoeveP1Factory_swigregister = _algo.KarhunenLoeveP1Factory_swigregister
KarhunenLoeveP1Factory_swigregister(KarhunenLoeveP1Factory)

class KarhunenLoeveResultImplementation(openturns.common.PersistentObject):
    """
    Result structure of a Karhunen Loeve algorithm.

    Available constructors:
        KarhunenLoeveResult(*implementation*)

        KarhunenLoeveResult(*covModel, s, lambda, modes, modesAsProcessSample, projection*)

    Parameters
    ----------
    implementation : :class:`~openturns.KarhunenLoeveResultImplementation`
        A specific implementation.
    covModel : :class:`~openturns.CovarianceModel`
        The covariance model.
    s : float, positive
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.
    lambda : :class:`~openturns.Point`
        The first eigenvalues of the Fredholm problem.
    modes : :class:`~openturns.Basis`
        The first modes  of the Fredholm problem.
    modesAsProcessSample : :class:`~openturns.ProcessSample`
        The values of the modes on the mesh associated to the KarhunenLoeve algorithm.
    projection : :class:`~openturns.Matrix`
        The projection matrix.

    Notes
    -----
    Structure generally created by the method run() of a :class:`~openturns.KarhunenLoeveAlgorithm` and obtained thanks to the method getResult().

    We consider :math:`C:\\cD \\times \\cD \\rightarrow  \\cS^+_d(\\Rset)` a covariance function defined on :math:`\\cD \\in \\Rset^n`, continuous at :math:`\\vect{0}`.

    We note :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{1 \\leq k \\leq K}` the solutions of the Fredholm problem associated to  :math:`C` where *K* is the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.

    We note :math:`\\vect{\\lambda}` the eigenvalues sequence and :math:`\\vect{\\varphi}` the eigenfunctions sequence.

    Then we define the linear projection function :math:`\\pi_{ \\vect{\\lambda}, \\vect{\\varphi}}` by:

    .. math::
        :label: projection

        \\pi_{\\vect{\\lambda}, \\vect{\\varphi}}: \\left|
          \\begin{array}{ccl}
            L^2(\\cD, \\Rset^d) & \\rightarrow & \\cS^{\\Nset} \\\\
            f & \\mapsto &\\left(\\dfrac{1}{\\sqrt{\\lambda_k}}\\int_{\\cD}f(\\vect{t}) \\vect{\\varphi}_k(\\vect{t})\\, d\\vect{t}\\right)_{k \\geq 1}
          \\end{array}
        \\right.

    where :math:`\\cS^{\\Nset}  = \\left \\{ (\\zeta_k)_{k \\geq 1} \\in  \\Rset^{\\Nset} \\, | \\, \\sum_{k=1}^{\\infty}\\lambda_k \\zeta_k^2 < +\\infty \\right \\}`. 

    The integral of :eq:`projection` can be discretized according to the chosen Karhunen Loeve algorithm: on the vertices of the domain :math:`\\cD_N` in the case of a :math:`P_1` algorithm, on the weighted experiment in the case of the quadrature method.  Then function :math:`f` can be reduced to its values on that discretization domain. Besides, we can restrict the sequences  :math:`(\\vect{\\lambda}, \\vect{\\varphi})` to the :math:`K` terms associated to the highest eigenvalues. Thus, following these discretizations, the function :math:`\\pi_{\\vect{\\lambda}, \\vect{\\varphi}}` has a matrical representation.

    The inverse of :math:`\\pi_{\\vect{\\lambda}, \\vect{\\varphi}}` is the lift function defined by:

    .. math::
        :label: lift

        \\pi_{\\vect{\\lambda}, \\vect{\\varphi}}^{-1}: \\left|
          \\begin{array}{ccl}
             \\cS^{\\Nset} & \\rightarrow & L^2(\\cD, \\Rset^d)\\\\
            (\\xi_k)_{k \\geq 1} & \\mapsto & f(.) = \\sum_{k \\geq 1} \\sqrt{\\lambda_k}\\xi_k \\vect{\\varphi}_k(.)
          \\end{array}
        \\right.

    If the function :math:`f(.) = X(\\omega_0, .)` where :math:`X` is the centered process which covariance function is associated to the eigenvalues and eigenfunctions :math:`(\\vect{\\lambda}, \\vect{\\varphi})`, then the *getEigenValues* method enables to obtain the :math:`K` first eigenvalues of the Karhunen Loeve decomposition of :math:`X` and the method *getModes* enables to get the associated modes.

    Examples
    --------
    >>> import openturns as ot
    >>> N = 256
    >>> mesh = ot.IntervalMesher([N - 1]).build(ot.Interval(-1, 1))
    >>> covariance_X = ot.AbsoluteExponential([1])
    >>> process_X = ot.GaussianProcess(covariance_X, mesh)
    >>> threshold = 0.001
    >>> algo_X = ot.KarhunenLoeveP1Algorithm(mesh, covariance_X, threshold)
    >>> algo_X.run()
    >>> result_X = algo_X.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveResultImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveResultImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveResultImplementation_getClassName(self)


    def getThreshold(self):
        """
        Accessor to the limit ratio on eigenvalues.

        Returns
        -------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveResultImplementation_getThreshold(self)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveResultImplementation_getCovarianceModel(self)


    def getEigenValues(self):
        """
        Accessor to the eigen values of the Karhunen Loeve decomposition.

        Returns
        -------
        eigenVal : :class:`~openturns.Point`
            The most significant eigenvalues.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1` where :math:`s` is the threshold fixed by the User.
        """
        return _algo.KarhunenLoeveResultImplementation_getEigenValues(self)


    def getModes(self):
        """
        Get the modes as functions.

        Returns
        -------
        modes : :class:`~openturns.Basis`
            The truncated basis :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`.

        Notes
        -----
        The basis is truncated to :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` where
        :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResultImplementation_getModes(self)


    def getModesAsProcessSample(self):
        """
        Accessor to the modes as a process sample.

        Returns
        -------
        modesAsProcessSample : :class:`~openturns.ProcessSample`
            The values of each mode on a mesh whose vertices were used to discretize the
            Fredholm equation.

        Notes
        -----
        The modes :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` are evaluated on the vertices of the mesh defining the process sample. The values of the i-th field are the values of the i-th mode on these vertices.

        The mesh corresponds to the discretization points of the integral in :eq:`projection`.
        """
        return _algo.KarhunenLoeveResultImplementation_getModesAsProcessSample(self)


    def getScaledModes(self):
        """
        Get the modes as functions scaled by the square-root of the corresponding eigenvalue.

        Returns
        -------
        modes : :class:`~openturns.Basis`
            The truncated basis :math:`(\\sqrt{\\lambda_k}\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`.

        Notes
        -----
        The basis is truncated to :math:`(\\sqrt{\\lambda_k}\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`
        where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResultImplementation_getScaledModes(self)


    def getScaledModesAsProcessSample(self):
        """
        Accessor to the scaled modes as a process sample.

        Returns
        -------
        modesAsProcessSample : :class:`~openturns.ProcessSample`
            The values of each scaled mode on a mesh whose vertices were used to
            discretize the Fredholm equation.

        Notes
        -----
        The modes :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` are evaluated on the
        vertices of the mesh defining the process sample. The values of the i-th field
        are the values of the i-th mode on these vertices.

        The mesh corresponds to the discretization points of the integral in
         :eq:`projection`.
        """
        return _algo.KarhunenLoeveResultImplementation_getScaledModesAsProcessSample(self)


    def getProjectionMatrix(self):
        """
        Accessor to the projection matrix.

        Returns
        -------
        projection : :class:`~openturns.Matrix`
            The projection matrix associated to the discretized version of :eq:`projection`.
        """
        return _algo.KarhunenLoeveResultImplementation_getProjectionMatrix(self)


    def project(self, *args):
        """
        Project a function or a field on the eigen modes basis.

        Available constructors:
            project(*function*)

            project(*field*)

        Parameters
        ----------
        function : :class:`~openturns.Function`
            A function.
        field :  :class:`~openturns.Field`
            A field.

        Notes
        -----
        The *project* method calculates the projection :eq:`projection` on a field or a
        function where only the first :math:`K` elements of the sequence are calculated.
        :math:`K` is determined by the :math:`s` parameter fixed by the User.
        """
        return _algo.KarhunenLoeveResultImplementation_project(self, *args)


    def lift(self, coefficients):
        """
        Lift the coefficients into a function.

        Parameters
        ----------
        coef : :class:`~openturns.Point`
            The coefficients :math:`(\\xi_1, \\dots, \\xi_K)`.

        Returns
        -------
        modes : :class:`~openturns.Function`
            The function :math:`f` defined in :eq:`lift`.

        Notes
        -----
        The sum defining :math:`f` is truncated to the first :math:`K` terms, where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResultImplementation_lift(self, coefficients)


    def liftAsField(self, coefficients):
        """
        Lift the coefficients into a field.

        Parameters
        ----------
        coef : :class:`~openturns.Point`
            The coefficients :math:`(\\xi_1, \\dots, \\xi_K)`.

        Returns
        -------
        modes : :class:`~openturns.Field`
            The function :math:`f` defined in :eq:`lift` evaluated on the mesh associated to the discretization of :eq:`projection`.

        Notes
        -----
        The sum defining :math:`f` is truncated to the first :math:`K` terms, where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResultImplementation_liftAsField(self, coefficients)


    def __repr__(self):
        return _algo.KarhunenLoeveResultImplementation___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveResultImplementation___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveResultImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveResultImplementation
    __del__ = lambda self: None
KarhunenLoeveResultImplementation_swigregister = _algo.KarhunenLoeveResultImplementation_swigregister
KarhunenLoeveResultImplementation_swigregister(KarhunenLoeveResultImplementation)

class KarhunenLoeveResultImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveResultImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveResultImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveResultImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.KarhunenLoeveResultImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.KarhunenLoeveResultImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.KarhunenLoeveResultImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.KarhunenLoeveResultImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_KarhunenLoeveResultImplementationTypedInterfaceObject
    __del__ = lambda self: None
KarhunenLoeveResultImplementationTypedInterfaceObject_swigregister = _algo.KarhunenLoeveResultImplementationTypedInterfaceObject_swigregister
KarhunenLoeveResultImplementationTypedInterfaceObject_swigregister(KarhunenLoeveResultImplementationTypedInterfaceObject)

class KarhunenLoeveResult(KarhunenLoeveResultImplementationTypedInterfaceObject):
    """
    Result structure of a Karhunen Loeve algorithm.

    Available constructors:
        KarhunenLoeveResult(*implementation*)

        KarhunenLoeveResult(*covModel, s, lambda, modes, modesAsProcessSample, projection*)

    Parameters
    ----------
    implementation : :class:`~openturns.KarhunenLoeveResultImplementation`
        A specific implementation.
    covModel : :class:`~openturns.CovarianceModel`
        The covariance model.
    s : float, positive
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.
    lambda : :class:`~openturns.Point`
        The first eigenvalues of the Fredholm problem.
    modes : :class:`~openturns.Basis`
        The first modes  of the Fredholm problem.
    modesAsProcessSample : :class:`~openturns.ProcessSample`
        The values of the modes on the mesh associated to the KarhunenLoeve algorithm.
    projection : :class:`~openturns.Matrix`
        The projection matrix.

    Notes
    -----
    Structure generally created by the method run() of a :class:`~openturns.KarhunenLoeveAlgorithm` and obtained thanks to the method getResult().

    We consider :math:`C:\\cD \\times \\cD \\rightarrow  \\cS^+_d(\\Rset)` a covariance function defined on :math:`\\cD \\in \\Rset^n`, continuous at :math:`\\vect{0}`.

    We note :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{1 \\leq k \\leq K}` the solutions of the Fredholm problem associated to  :math:`C` where *K* is the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.

    We note :math:`\\vect{\\lambda}` the eigenvalues sequence and :math:`\\vect{\\varphi}` the eigenfunctions sequence.

    Then we define the linear projection function :math:`\\pi_{ \\vect{\\lambda}, \\vect{\\varphi}}` by:

    .. math::
        :label: projection

        \\pi_{\\vect{\\lambda}, \\vect{\\varphi}}: \\left|
          \\begin{array}{ccl}
            L^2(\\cD, \\Rset^d) & \\rightarrow & \\cS^{\\Nset} \\\\
            f & \\mapsto &\\left(\\dfrac{1}{\\sqrt{\\lambda_k}}\\int_{\\cD}f(\\vect{t}) \\vect{\\varphi}_k(\\vect{t})\\, d\\vect{t}\\right)_{k \\geq 1}
          \\end{array}
        \\right.

    where :math:`\\cS^{\\Nset}  = \\left \\{ (\\zeta_k)_{k \\geq 1} \\in  \\Rset^{\\Nset} \\, | \\, \\sum_{k=1}^{\\infty}\\lambda_k \\zeta_k^2 < +\\infty \\right \\}`. 

    The integral of :eq:`projection` can be discretized according to the chosen Karhunen Loeve algorithm: on the vertices of the domain :math:`\\cD_N` in the case of a :math:`P_1` algorithm, on the weighted experiment in the case of the quadrature method.  Then function :math:`f` can be reduced to its values on that discretization domain. Besides, we can restrict the sequences  :math:`(\\vect{\\lambda}, \\vect{\\varphi})` to the :math:`K` terms associated to the highest eigenvalues. Thus, following these discretizations, the function :math:`\\pi_{\\vect{\\lambda}, \\vect{\\varphi}}` has a matrical representation.

    The inverse of :math:`\\pi_{\\vect{\\lambda}, \\vect{\\varphi}}` is the lift function defined by:

    .. math::
        :label: lift

        \\pi_{\\vect{\\lambda}, \\vect{\\varphi}}^{-1}: \\left|
          \\begin{array}{ccl}
             \\cS^{\\Nset} & \\rightarrow & L^2(\\cD, \\Rset^d)\\\\
            (\\xi_k)_{k \\geq 1} & \\mapsto & f(.) = \\sum_{k \\geq 1} \\sqrt{\\lambda_k}\\xi_k \\vect{\\varphi}_k(.)
          \\end{array}
        \\right.

    If the function :math:`f(.) = X(\\omega_0, .)` where :math:`X` is the centered process which covariance function is associated to the eigenvalues and eigenfunctions :math:`(\\vect{\\lambda}, \\vect{\\varphi})`, then the *getEigenValues* method enables to obtain the :math:`K` first eigenvalues of the Karhunen Loeve decomposition of :math:`X` and the method *getModes* enables to get the associated modes.

    Examples
    --------
    >>> import openturns as ot
    >>> N = 256
    >>> mesh = ot.IntervalMesher([N - 1]).build(ot.Interval(-1, 1))
    >>> covariance_X = ot.AbsoluteExponential([1])
    >>> process_X = ot.GaussianProcess(covariance_X, mesh)
    >>> threshold = 0.001
    >>> algo_X = ot.KarhunenLoeveP1Algorithm(mesh, covariance_X, threshold)
    >>> algo_X.run()
    >>> result_X = algo_X.getResult()
    """

    __swig_setmethods__ = {}
    for _s in [KarhunenLoeveResultImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveResult, name, value)
    __swig_getmethods__ = {}
    for _s in [KarhunenLoeveResultImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveResult_getClassName(self)


    def getThreshold(self):
        """
        Accessor to the limit ratio on eigenvalues.

        Returns
        -------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveResult_getThreshold(self)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveResult_getCovarianceModel(self)


    def getEigenValues(self):
        """
        Accessor to the eigen values of the Karhunen Loeve decomposition.

        Returns
        -------
        eigenVal : :class:`~openturns.Point`
            The most significant eigenvalues.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1` where :math:`s` is the threshold fixed by the User.
        """
        return _algo.KarhunenLoeveResult_getEigenValues(self)


    def getModes(self):
        """
        Get the modes as functions.

        Returns
        -------
        modes : :class:`~openturns.Basis`
            The truncated basis :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`.

        Notes
        -----
        The basis is truncated to :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` where
        :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResult_getModes(self)


    def getModesAsProcessSample(self):
        """
        Accessor to the modes as a process sample.

        Returns
        -------
        modesAsProcessSample : :class:`~openturns.ProcessSample`
            The values of each mode on a mesh whose vertices were used to discretize the
            Fredholm equation.

        Notes
        -----
        The modes :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` are evaluated on the vertices of the mesh defining the process sample. The values of the i-th field are the values of the i-th mode on these vertices.

        The mesh corresponds to the discretization points of the integral in :eq:`projection`.
        """
        return _algo.KarhunenLoeveResult_getModesAsProcessSample(self)


    def getScaledModes(self):
        """
        Get the modes as functions scaled by the square-root of the corresponding eigenvalue.

        Returns
        -------
        modes : :class:`~openturns.Basis`
            The truncated basis :math:`(\\sqrt{\\lambda_k}\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`.

        Notes
        -----
        The basis is truncated to :math:`(\\sqrt{\\lambda_k}\\vect{\\varphi}_k)_{1 \\leq k \\leq K}`
        where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResult_getScaledModes(self)


    def getScaledModesAsProcessSample(self):
        """
        Accessor to the scaled modes as a process sample.

        Returns
        -------
        modesAsProcessSample : :class:`~openturns.ProcessSample`
            The values of each scaled mode on a mesh whose vertices were used to
            discretize the Fredholm equation.

        Notes
        -----
        The modes :math:`(\\vect{\\varphi}_k)_{1 \\leq k \\leq K}` are evaluated on the
        vertices of the mesh defining the process sample. The values of the i-th field
        are the values of the i-th mode on these vertices.

        The mesh corresponds to the discretization points of the integral in
         :eq:`projection`.
        """
        return _algo.KarhunenLoeveResult_getScaledModesAsProcessSample(self)


    def getProjectionMatrix(self):
        """
        Accessor to the projection matrix.

        Returns
        -------
        projection : :class:`~openturns.Matrix`
            The projection matrix associated to the discretized version of :eq:`projection`.
        """
        return _algo.KarhunenLoeveResult_getProjectionMatrix(self)


    def project(self, *args):
        """
        Project a function or a field on the eigen modes basis.

        Available constructors:
            project(*function*)

            project(*field*)

        Parameters
        ----------
        function : :class:`~openturns.Function`
            A function.
        field :  :class:`~openturns.Field`
            A field.

        Notes
        -----
        The *project* method calculates the projection :eq:`projection` on a field or a
        function where only the first :math:`K` elements of the sequence are calculated.
        :math:`K` is determined by the :math:`s` parameter fixed by the User.
        """
        return _algo.KarhunenLoeveResult_project(self, *args)


    def lift(self, coefficients):
        """
        Lift the coefficients into a function.

        Parameters
        ----------
        coef : :class:`~openturns.Point`
            The coefficients :math:`(\\xi_1, \\dots, \\xi_K)`.

        Returns
        -------
        modes : :class:`~openturns.Function`
            The function :math:`f` defined in :eq:`lift`.

        Notes
        -----
        The sum defining :math:`f` is truncated to the first :math:`K` terms, where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResult_lift(self, coefficients)


    def liftAsField(self, coefficients):
        """
        Lift the coefficients into a field.

        Parameters
        ----------
        coef : :class:`~openturns.Point`
            The coefficients :math:`(\\xi_1, \\dots, \\xi_K)`.

        Returns
        -------
        modes : :class:`~openturns.Field`
            The function :math:`f` defined in :eq:`lift` evaluated on the mesh associated to the discretization of :eq:`projection`.

        Notes
        -----
        The sum defining :math:`f` is truncated to the first :math:`K` terms, where :math:`K` is fixed by the User through the :math:`s` parameter.
        """
        return _algo.KarhunenLoeveResult_liftAsField(self, coefficients)


    def __repr__(self):
        return _algo.KarhunenLoeveResult___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveResult___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveResult
    __del__ = lambda self: None
KarhunenLoeveResult_swigregister = _algo.KarhunenLoeveResult_swigregister
KarhunenLoeveResult_swigregister(KarhunenLoeveResult)

class KarhunenLoeveAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Base class for Karhunen Loeve algorithms.

    Available constructors:
        KarhunenLoeveAlgorithm(*covModel, s*)

    Parameters
    ----------
    covModel : :class:`~openturns.CovarianceModel`
        The covariance model.
    s : float, positive
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

    Notes
    -----
    The Karhunen Loeve decomposition enables to build some finite approximations of stochastic processes which are optimal with respect to the norm :math:`L^2`.

    We suppose that :math:`C:\\cD \\times \\cD \\rightarrow  \\cS^+_d(\\Rset)` is a covariance function defined on :math:`\\cD \\in \\Rset^n`, continuous at :math:`\\vect{0}`. 

    The class :class:`~openturns.KarhunenLoeveAlgorithm` enables to determine the solutions of the second kind Fredholm equation associated to  :math:`C`, ie to find the :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}` such that: 

    .. math::
        :label: fredholm

        \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\vect{\\varphi}_k(\\vect{t})\\,  d\\vect{t} = \\lambda_k  \\vect{\\varphi}_k(\\vect{s}) \\quad \\forall \\vect{s} \\in \\cD


    where :math:`(\\lambda_k)_{k \\geq 1}` is a nonincreasing sequence of nonnegative values (the **eigenvalues**) and :math:`(\\vect{\\varphi}_k)_{k \\geq 1}` the   associated sequence of **eigenfunctions**, normalized by :math:`\\int_{\\cD}\\|\\vect{\\varphi}_k(\\vect{s})\\|^2\\di{\\vect{s}}=1`. They form an hilbertian basis of :math:`L^2(\\cD, \\Rset^d)`.


    The Mercer theorem shows that the covariance function  :math:`C` writes:

    .. math::
        :label: covFuncMercer

        \\mat{C}(\\vect{s},\\vect{t}) = \\sum_{k=1}^{+\\infty} \\lambda_k \\vect{\\varphi}_k(\\vect{s}) \\Tr{\\vect{\\varphi}}_k(\\vect{t}) \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD


    OpenTURNS uses the threshold :math:`s` in order to select the most significant eigenvalues, ie all the eigenvalues such that :math:`\\lambda_k \\geq s \\lambda_1`.

    To solve :eq:`fredholm`, we use the functional basis :math:`(\\theta_p)_{1 \\leq p \\leq P}` of :math:`L^2(\\cD, \\Rset)` with :math:`P` elements defined on :math:`\\cD`. We search the solutions of type:

    .. math::

        \\tilde{\\vect{\\varphi}}_k(\\vect{t})=\\sum_{p=1}^{P} \\vect{\\phi}_{pk}\\theta_p(\\vect{t})

    where :math:`\\vect{\\phi}_{pk} \\in \\Rset^d`. We note:

    .. math::

        \\begin{align*}
            \\vect{\\Phi}_k =
            \\left(
              \\begin{array}{l}
                \\vect{\\phi}_{1k} \\\\
                \\dots \\\\
                \\vect{\\phi}_{Pk}
              \\end{array}
            \\right) \\in \\Rset^{Pd}
         \\end{align*}

    and :math:`\\mat{\\vect{\\Phi}} = (\\vect{\\Phi}_1\\, |\\, \\dots \\, | \\vect{\\Phi}_K)` the matrix of the :math:`K` first modes of the Karhunen Loeve decomposition.

    The approximated Fredholm problem writes for all :math:`k \\geq 1`:

    .. math::

       \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\tilde{\\vect{\\varphi}}_k(\\vect{t})\\,  d\\vect{t} = \\lambda_k   \\tilde{\\vect{\\varphi}}_k(\\vect{s}) \\quad  \\forall \\vect{s} \\in \\cD

    which enables to define the **residual function** :math:`\\vect{r}: \\cD \\rightarrow \\Rset^d` defined by

    .. math::
        :label: fredholmApprox

        \\vect{r}(\\vect{s}) = \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\tilde{\\vect{\\varphi}}_k(\\vect{t})\\,  d\\vect{t} - \\lambda_k  \\tilde{\\vect{\\varphi}}_k(\\vect{s})

    The Fredholm problem writes:

    .. math::
        :label: pbResidu

        \\vect{r}(\\vect{s}) = \\vect{0} \\quad \\forall \\vect{s} \\in \\cD

    which is solved either by the **Galerkin** approach or the **collocation** approach.

    The integrals in :eq:`fredholmApprox` can be evaluated with:

        - a :math:`P_1` -approach: see :class:`~openturns.KarhunenLoeveP1Algorithm`,
        - a quadrature approach: see :class:`~openturns.KarhunenLoeveQuadratureAlgorithm`,
        - a singular values decomposition approach: see :class:`~openturns.KarhunenLoeveSVDAlgorithm`.

    See also
    --------
    KarhunenLoeveResult
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveAlgorithmImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_getClassName(self)


    def getThreshold(self):
        """
        Accessor to the limit ratio on eigenvalues.

        Returns
        -------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_getThreshold(self)


    def setThreshold(self, threshold):
        """
        Accessor to the limit ratio on eigenvalues.

        Parameters
        ----------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates  the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}` at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_setThreshold(self, threshold)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_getCovarianceModel(self)


    def setCovarianceModel(self, covariance):
        """
        Accessor to the covariance model.

        Parameters
        ----------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_setCovarianceModel(self, covariance)


    def run(self):
        """
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.KarhunenLoeveResult`,
        structure containing all the results.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_run(self)


    def getResult(self):
        """
        Get the result structure.

        Returns
        -------
        resKL : :class:`~openturns.KarhunenLoeveResult`
            The structure containing all the results of the Fredholm problem.

        Notes
        -----
        The structure contains all the results of the Fredholm problem.
        """
        return _algo.KarhunenLoeveAlgorithmImplementation_getResult(self)


    def __repr__(self):
        return _algo.KarhunenLoeveAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveAlgorithmImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveAlgorithmImplementation
    __del__ = lambda self: None
KarhunenLoeveAlgorithmImplementation_swigregister = _algo.KarhunenLoeveAlgorithmImplementation_swigregister
KarhunenLoeveAlgorithmImplementation_swigregister(KarhunenLoeveAlgorithmImplementation)

class KarhunenLoeveAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveAlgorithmImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _algo.KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _algo.KarhunenLoeveAlgorithmImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _algo.delete_KarhunenLoeveAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self: None
KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_swigregister = _algo.KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_swigregister
KarhunenLoeveAlgorithmImplementationTypedInterfaceObject_swigregister(KarhunenLoeveAlgorithmImplementationTypedInterfaceObject)

class KarhunenLoeveAlgorithm(KarhunenLoeveAlgorithmImplementationTypedInterfaceObject):
    """
    Base class for Karhunen Loeve algorithms.

    Available constructors:
        KarhunenLoeveAlgorithm(*covModel, s*)

    Parameters
    ----------
    covModel : :class:`~openturns.CovarianceModel`
        The covariance model.
    s : float, positive
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

    Notes
    -----
    The Karhunen Loeve decomposition enables to build some finite approximations of stochastic processes which are optimal with respect to the norm :math:`L^2`.

    We suppose that :math:`C:\\cD \\times \\cD \\rightarrow  \\cS^+_d(\\Rset)` is a covariance function defined on :math:`\\cD \\in \\Rset^n`, continuous at :math:`\\vect{0}`. 

    The class :class:`~openturns.KarhunenLoeveAlgorithm` enables to determine the solutions of the second kind Fredholm equation associated to  :math:`C`, ie to find the :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}` such that: 

    .. math::
        :label: fredholm

        \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\vect{\\varphi}_k(\\vect{t})\\,  d\\vect{t} = \\lambda_k  \\vect{\\varphi}_k(\\vect{s}) \\quad \\forall \\vect{s} \\in \\cD


    where :math:`(\\lambda_k)_{k \\geq 1}` is a nonincreasing sequence of nonnegative values (the **eigenvalues**) and :math:`(\\vect{\\varphi}_k)_{k \\geq 1}` the   associated sequence of **eigenfunctions**, normalized by :math:`\\int_{\\cD}\\|\\vect{\\varphi}_k(\\vect{s})\\|^2\\di{\\vect{s}}=1`. They form an hilbertian basis of :math:`L^2(\\cD, \\Rset^d)`.


    The Mercer theorem shows that the covariance function  :math:`C` writes:

    .. math::
        :label: covFuncMercer

        \\mat{C}(\\vect{s},\\vect{t}) = \\sum_{k=1}^{+\\infty} \\lambda_k \\vect{\\varphi}_k(\\vect{s}) \\Tr{\\vect{\\varphi}}_k(\\vect{t}) \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD


    OpenTURNS uses the threshold :math:`s` in order to select the most significant eigenvalues, ie all the eigenvalues such that :math:`\\lambda_k \\geq s \\lambda_1`.

    To solve :eq:`fredholm`, we use the functional basis :math:`(\\theta_p)_{1 \\leq p \\leq P}` of :math:`L^2(\\cD, \\Rset)` with :math:`P` elements defined on :math:`\\cD`. We search the solutions of type:

    .. math::

        \\tilde{\\vect{\\varphi}}_k(\\vect{t})=\\sum_{p=1}^{P} \\vect{\\phi}_{pk}\\theta_p(\\vect{t})

    where :math:`\\vect{\\phi}_{pk} \\in \\Rset^d`. We note:

    .. math::

        \\begin{align*}
            \\vect{\\Phi}_k =
            \\left(
              \\begin{array}{l}
                \\vect{\\phi}_{1k} \\\\
                \\dots \\\\
                \\vect{\\phi}_{Pk}
              \\end{array}
            \\right) \\in \\Rset^{Pd}
         \\end{align*}

    and :math:`\\mat{\\vect{\\Phi}} = (\\vect{\\Phi}_1\\, |\\, \\dots \\, | \\vect{\\Phi}_K)` the matrix of the :math:`K` first modes of the Karhunen Loeve decomposition.

    The approximated Fredholm problem writes for all :math:`k \\geq 1`:

    .. math::

       \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\tilde{\\vect{\\varphi}}_k(\\vect{t})\\,  d\\vect{t} = \\lambda_k   \\tilde{\\vect{\\varphi}}_k(\\vect{s}) \\quad  \\forall \\vect{s} \\in \\cD

    which enables to define the **residual function** :math:`\\vect{r}: \\cD \\rightarrow \\Rset^d` defined by

    .. math::
        :label: fredholmApprox

        \\vect{r}(\\vect{s}) = \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\tilde{\\vect{\\varphi}}_k(\\vect{t})\\,  d\\vect{t} - \\lambda_k  \\tilde{\\vect{\\varphi}}_k(\\vect{s})

    The Fredholm problem writes:

    .. math::
        :label: pbResidu

        \\vect{r}(\\vect{s}) = \\vect{0} \\quad \\forall \\vect{s} \\in \\cD

    which is solved either by the **Galerkin** approach or the **collocation** approach.

    The integrals in :eq:`fredholmApprox` can be evaluated with:

        - a :math:`P_1` -approach: see :class:`~openturns.KarhunenLoeveP1Algorithm`,
        - a quadrature approach: see :class:`~openturns.KarhunenLoeveQuadratureAlgorithm`,
        - a singular values decomposition approach: see :class:`~openturns.KarhunenLoeveSVDAlgorithm`.

    See also
    --------
    KarhunenLoeveResult
    """

    __swig_setmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementationTypedInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementationTypedInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveAlgorithm_getClassName(self)


    def getThreshold(self):
        """
        Accessor to the limit ratio on eigenvalues.

        Returns
        -------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}`  at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveAlgorithm_getThreshold(self)


    def setThreshold(self, threshold):
        """
        Accessor to the limit ratio on eigenvalues.

        Parameters
        ----------
        s : float, positive
            The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

        Notes
        -----
        OpenTURNS truncates  the sequence :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}` at the highest index :math:`K` such that :math:`\\lambda_K \\geq s \\lambda_1`.
        """
        return _algo.KarhunenLoeveAlgorithm_setThreshold(self, threshold)


    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveAlgorithm_getCovarianceModel(self)


    def setCovarianceModel(self, covariance):
        """
        Accessor to the covariance model.

        Parameters
        ----------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveAlgorithm_setCovarianceModel(self, covariance)


    def getResult(self):
        """
        Get the result structure.

        Returns
        -------
        resKL : :class:`~openturns.KarhunenLoeveResult`
            The structure containing all the results of the Fredholm problem.

        Notes
        -----
        The structure contains all the results of the Fredholm problem.
        """
        return _algo.KarhunenLoeveAlgorithm_getResult(self)


    def __repr__(self):
        return _algo.KarhunenLoeveAlgorithm___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveAlgorithm___str__(self, *args)

    def run(self):
        """
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.KarhunenLoeveResult`,
        structure containing all the results.
        """
        return _algo.KarhunenLoeveAlgorithm_run(self)


    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveAlgorithm
    __del__ = lambda self: None
KarhunenLoeveAlgorithm_swigregister = _algo.KarhunenLoeveAlgorithm_swigregister
KarhunenLoeveAlgorithm_swigregister(KarhunenLoeveAlgorithm)

class KarhunenLoeveP1Algorithm(KarhunenLoeveAlgorithmImplementation):
    """
    Computation of Karhunen-Loeve decomposition using P1 approximation.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh :math:`\\cD_N` that discretizes the domain :math:`\\cD`.
    covariance : :class:`~openturns.CovarianceModel`
        The covariance function to decompose.
    threshold : float
        The minimal relative amplitude of the eigenvalues to consider in
        the decomposition wrt the sum of the preceeding eigenvalues. The default value is 0.

    Notes
    -----
    The Karhunen-Loeve :math:`P_1` algorithm solves the Fredholm problem  associated to the covariance function :math:`C`: see :class:`~openturns.KarhunenLoeveAlgorithm` to get the notations.


    The Karhunen-Loeve :math:`P_1` approximation uses the :math:`P_1` functional basis :math:`(\\theta_p)_{1 \\leq p \\leq N}` where  :math:`\\theta_p: \\cD_N \\mapsto \\Rset` are the basis functions of the :math:`P_1` finite element space associated to :math:`\\cD_N`, which vertices are :math:`(\\vect{s}_i)_{1 \\leq i \\leq N}`.

    The covariance function :math:`\\mat{C}` is approximated by its :math:`P_1` approximation :math:`\\hat{\\mat{C}}` on :math:`\\cD_N`:

    .. math::

       \\hat{\\mat{C}}(\\vect{s},\\vect{t})=\\sum_{\\vect{s}_i,\\vect{s}_j\\in\\cV_N}\\mat{C}(\\vect{s}_i,\\vect{s}_j)\\theta_i(\\vect{s})\\theta_j(\\vect{t}), \\quad  \\forall \\vect{s},\\vect{t}\\in\\cD_N

    The Galerkin approach and the collocation one are equivalent in the :math:`P_1` approach and both lead to the following formulation:

    .. math::

        \\mat{C}\\, \\mat{G}\\, \\mat{\\Phi}  =   \\mat{\\Phi}\\, \\mat{\\Lambda}


    where :math:`\\mat{G} = (G_{ij})_{1\\leq i,j \\leq N}` with :math:`G_{i\\ell}= \\int_{\\cD} \\theta_i(\\vect{s})\\theta_\\ell(\\vect{s})\\,  d\\vect{s}`, :math:`\\mat{\\Lambda}=diag(\\vect{\\lambda})`.


    Examples
    --------
    Create a Karhunen-Loeve P1 algorithm:

    >>> import openturns as ot
    >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
    >>> threshold = 0.01
    >>> model = ot.AbsoluteExponential([1.0]*2)
    >>> algorithm = ot.KarhunenLoeveP1Algorithm(mesh, model, threshold)
    """

    __swig_setmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveP1Algorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveP1Algorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveP1Algorithm_getClassName(self)


    def run(self):
        """
        Computation of the eigenvalues and eigen functions values at nodes.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
        >>> threshold = 0.01
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> algorithm = ot.KarhunenLoeveP1Algorithm(mesh, model, threshold)
        >>> algorithm.run()
        >>> result = algorithm.getResult()
        """
        return _algo.KarhunenLoeveP1Algorithm_run(self)


    def getMesh(self):
        """
        Accessor to the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh :math:`\\cD_N` that discretizes the domain :math:`\\cD`.
        """
        return _algo.KarhunenLoeveP1Algorithm_getMesh(self)


    def __repr__(self):
        return _algo.KarhunenLoeveP1Algorithm___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveP1Algorithm___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveP1Algorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveP1Algorithm
    __del__ = lambda self: None
KarhunenLoeveP1Algorithm_swigregister = _algo.KarhunenLoeveP1Algorithm_swigregister
KarhunenLoeveP1Algorithm_swigregister(KarhunenLoeveP1Algorithm)

class KarhunenLoeveSVDAlgorithm(KarhunenLoeveAlgorithmImplementation):
    """
    Computation of Karhunen-Loeve decomposition using SVD approximation.

    Available constructors:
        KarhunenLoeveSVDAlgorithm(*sample, threshold, centeredFlag*)

        KarhunenLoeveSVDAlgorithm(*sample, verticesWeights, threshold, centeredFlag*)

        KarhunenLoeveSVDAlgorithm(*sample, verticesWeights, sampleWeights, threshold, centeredFlag*)

    Parameters
    ----------
    sample : :class:`~openturns.ProcessSample`
        The sample containing the observations.
    verticesWeights : sequence of float
        The weights associated to the vertices of the mesh defining the sample.
    sampleWeights : sequence of float
        The weights associated to the fields of the sample.
    threshold : float
        The minimal relative amplitude of the eigenvalues to consider in
        the decomposition wrt the sum of the preceeding eigenvalues. The default value is 0.
    centeredFlag : logical
        Flag to tell if the sample is drawn according to a centered
        process or if it has to be centered using the empirical mean. The
        default value is *False*.

    Notes
    -----
    The Karhunen-Loeve SVD algorithm solves the Fredholm problem  associated to the covariance function :math:`C`: see :class:`~openturns.KarhunenLoeveAlgorithm` to get the notations.

    The SVD approach is a particular case of the quadrature approach (see :class:`~openturns.KarhunenLoeveQuadratureAlgorithm`)  where we consider the functional basis  :math:`((\\vect{\\theta}_p^j(\\vect{s}))_{1 \\leq j \\leq d, 1 \\leq p \\leq P}` of :math:`L^2(\\cD, \\Rset^d)` defined on :math:`\\cD` by:

    .. math:: 

        \\vect{\\theta}_p^j(\\vect{s})= \\left[\\mat{C}(\\vect{s}, \\vect{s}_p) \\right]_{:, j}

    The SVD approach is used when the covariance function is not explicitely known but only through :math:`K` fields of the associated stochastic process :math:`\\vect{X}`: :math:`(\\vect{X}_1, \\dots, \\vect{X}_K)`.

    It consists in :

        - approximating :math:`\\mat{C}` by its empirical estimator  :math:`\\dfrac{1}{\\tilde{K}} \\mat{X}\\, \\Tr{\\mat{X}}` where :math:`\\mat{X}~=~(\\vect{X}_1 | \\dots | \\vect{X}_K)` and :math:`\\tilde{K}=K` if the process is centered and :math:`\\tilde{K}=K-1` otherwise;
        - taking the :math:`L` vertices of the mesh of :math:`\\vect{X}` as the :math:`L` quadrature points.

    We suppose now that :math:`K < dL`, and we note :math:`\\mat{Y} = \\sqrt{\\mat{W}} \\,\\mat{X}`.

    As the matrix :math:`\\mat{\\Theta} = \\mat{C}` is invertible, the Galerkin and collocation approaches are equivalent and both lead to the following singular value problem for :math:`\\mat{Y}`:

    .. math::
        :label: QuadCollDim1_ter

         \\mat{Y}\\,\\Tr{\\mat{Y}}\\,\\mat{\\Psi}_k  & = \\tilde{K} \\lambda_k \\mat{\\Psi}_k

    The SVD decomposition of :math:`\\mat{Y}\\in \\mathcal{M}_{dL,\\tilde{K}}(\\Rset)` writes:

    .. math::

        \\mat{Y} = \\mat{U}\\, \\mat{\\Sigma} \\, \\Tr{\\mat{V}}

    where  we have :math:`\\mat{U} \\in \\mathcal{M}_{dL,\\tilde{K}}(\\Rset)`, :math:`\\mat{\\Sigma}\\in \\mathcal{M}_{\\tilde{K},\\tilde{K}}(\\Rset)`, :math:`\\mat{V} \\in \\mathcal{M}_{\\tilde{K},\\tilde{K}}(\\Rset)` such that :

        - :math:`\\Tr{\\mat{V}}\\mat{V} =\\mat{V}\\Tr{\\mat{V}}= \\mat{I}_{\\tilde{K}}`,  
        - :math:`\\Tr{\\mat{U}}\\mat{U} = \\mat{I}_{\\tilde{K}}` ,
        - :math:`\\mat{\\Sigma} = diag(\\sigma_1, \\dots, \\sigma_{\\tilde{K}})`.

    Then the columns of :math:`\\mat{U}` are the eigen vectors of :math:`\\mat{Y}\\Tr{\\mat{Y}}` associated to the eigen values :math:`\\sigma_k^2`.

    We deduce the modes and eigen values of the Fredholm problem for :math:`k \\leq \\tilde{K}`:

    .. math::

        \\begin{align*}
          \\mat{\\Phi}_k = \\dfrac{1}{\\lambda_k} \\sqrt{\\mat{W}}\\, \\mat{U}_k
          \\lambda_k = \\dfrac{\\sigma_k^2}{\\tilde{K}}
        \\end{align*}

    We have:

    .. math::

        \\tilde{\\vect{\\varphi}}_k(\\vect{t})= \\sum_{\\ell=1}^L  C(\\vect{t}, \\vect{\\xi}_\\ell) \\vect{\\phi}_{\\ell,k} \\quad \\mbox{pour} \\quad k \\leq \\tilde{K}




    Examples
    --------
    Create a Karhunen-Loeve SVD algorithm:

    >>> import openturns as ot
    >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
    >>> threshold = 0.01
    >>> model = ot.AbsoluteExponential([1.0]*2)
    >>> sample = ot.GaussianProcess(model, mesh).getSample(8)
    >>> algorithm = ot.KarhunenLoeveSVDAlgorithm(sample, threshold)
    """

    __swig_setmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveSVDAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [KarhunenLoeveAlgorithmImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveSVDAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.KarhunenLoeveSVDAlgorithm_getClassName(self)


    def run(self):
        """
        Computation of the eigenvalues and eigen functions values at nodes.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
        >>> threshold = 0.01
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> sample = ot.GaussianProcess(model, mesh).getSample(8)
        >>> algorithm = ot.KarhunenLoeveSVDAlgorithm(sample, threshold)
        >>> algorithm.run()
        >>> result = algorithm.getResult()
        """
        return _algo.KarhunenLoeveSVDAlgorithm_run(self)


    def getSample(self):
        """
        Accessor to the process sample.

        Returns
        -------
        sample : :class:`~openturns.ProcessSample`
            The process sample containing the observations of the process.

        """
        return _algo.KarhunenLoeveSVDAlgorithm_getSample(self)


    def getVerticesWeights(self):
        return _algo.KarhunenLoeveSVDAlgorithm_getVerticesWeights(self)

    def getSampleWeights(self):
        return _algo.KarhunenLoeveSVDAlgorithm_getSampleWeights(self)

    def getCovarianceModel(self):
        """
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _algo.KarhunenLoeveSVDAlgorithm_getCovarianceModel(self)


    def __repr__(self):
        return _algo.KarhunenLoeveSVDAlgorithm___repr__(self)

    def __str__(self, *args):
        return _algo.KarhunenLoeveSVDAlgorithm___str__(self, *args)

    def __init__(self, *args):
        this = _algo.new_KarhunenLoeveSVDAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_KarhunenLoeveSVDAlgorithm
    __del__ = lambda self: None
KarhunenLoeveSVDAlgorithm_swigregister = _algo.KarhunenLoeveSVDAlgorithm_swigregister
KarhunenLoeveSVDAlgorithm_swigregister(KarhunenLoeveSVDAlgorithm)

class ApproximationAlgorithmImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ApproximationAlgorithmImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ApproximationAlgorithmImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _algo.ApproximationAlgorithmImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _algo.ApproximationAlgorithmImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_algo.ApproximationAlgorithmImplementationPointer_ptr__get, _algo.ApproximationAlgorithmImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _algo.new_ApproximationAlgorithmImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_ApproximationAlgorithmImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _algo.ApproximationAlgorithmImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _algo.ApproximationAlgorithmImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _algo.ApproximationAlgorithmImplementationPointer___deref__(self)

    def isNull(self):
        return _algo.ApproximationAlgorithmImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _algo.ApproximationAlgorithmImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _algo.ApproximationAlgorithmImplementationPointer_get(self)

    def getImplementation(self):
        return _algo.ApproximationAlgorithmImplementationPointer_getImplementation(self)

    def unique(self):
        return _algo.ApproximationAlgorithmImplementationPointer_unique(self)

    def use_count(self):
        return _algo.ApproximationAlgorithmImplementationPointer_use_count(self)

    def swap(self, other):
        return _algo.ApproximationAlgorithmImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getClassName(self)


    def getX(self):
        """
        Accessor to the input sample.

        Returns
        -------
        x : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getX(self)


    def getY(self):
        """
        Accessor to the output sample.

        Returns
        -------
        y : :class:`~openturns.Sample`
            Input sample
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getY(self)


    def getWeight(self):
        """
        Accessor to the weights.

        Returns
        -------
        weight : :class:`~openturns.Point`
            Output weights
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getWeight(self)


    def getPsi(self):
        """
        Accessor to the basis.

        Returns
        -------
        coefficients : :class:`~openturns.Basis`
            The basis
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getPsi(self)


    def __repr__(self):
        return _algo.ApproximationAlgorithmImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _algo.ApproximationAlgorithmImplementationPointer___str__(self, *args)

    def run(self):
        """Run the algorithm."""
        return _algo.ApproximationAlgorithmImplementationPointer_run(self)


    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.Point`
            The coefficients
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getCoefficients(self)


    def getResidual(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coefficients : float
            The residual
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getResidual(self)


    def getRelativeError(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        relativeError : float
            The relative error
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getRelativeError(self)


    def setVerbose(self, verbose):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        v : bool
            Enable or disable the verbosity.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_setVerbose(self, verbose)


    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        -------
        v : bool.
            Verbosity
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getVerbose(self)


    def __eq__(self, arg2):
        return _algo.ApproximationAlgorithmImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _algo.ApproximationAlgorithmImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.ApproximationAlgorithmImplementationPointer_setName(self, name)

ApproximationAlgorithmImplementationPointer_swigregister = _algo.ApproximationAlgorithmImplementationPointer_swigregister
ApproximationAlgorithmImplementationPointer_swigregister(ApproximationAlgorithmImplementationPointer)

class FFTImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FFTImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FFTImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _algo.FFTImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _algo.FFTImplementationPointer_ptr__get
    if _newclass:
        ptr_ = _swig_property(_algo.FFTImplementationPointer_ptr__get, _algo.FFTImplementationPointer_ptr__set)

    def __init__(self, *args):
        this = _algo.new_FFTImplementationPointer(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _algo.delete_FFTImplementationPointer
    __del__ = lambda self: None

    def reset(self):
        return _algo.FFTImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _algo.FFTImplementationPointer___ref__(self, *args)

    def __deref__(self):
        return _algo.FFTImplementationPointer___deref__(self)

    def isNull(self):
        return _algo.FFTImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _algo.FFTImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _algo.FFTImplementationPointer_get(self)

    def getImplementation(self):
        return _algo.FFTImplementationPointer_getImplementation(self)

    def unique(self):
        return _algo.FFTImplementationPointer_unique(self)

    def use_count(self):
        return _algo.FFTImplementationPointer_use_count(self)

    def swap(self, other):
        return _algo.FFTImplementationPointer_swap(self, other)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _algo.FFTImplementationPointer_getClassName(self)


    def transform(self, *args):
        """
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} x_n exp(-2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _algo.FFTImplementationPointer_transform(self, *args)


    def inverseTransform(self, *args):
        """
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} \\frac{1}{N} x_n exp(2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.ComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _algo.FFTImplementationPointer_inverseTransform(self, *args)


    def transform2D(self, *args):
        """
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _algo.FFTImplementationPointer_transform2D(self, *args)


    def inverseTransform2D(self, *args):
        """
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l}} = \\frac{1}{M\\times N}\\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _algo.FFTImplementationPointer_inverseTransform2D(self, *args)


    def transform3D(self, *args):
        """
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N}) exp(-2 i \\pi \\frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _algo.FFTImplementationPointer_transform3D(self, *args)


    def inverseTransform3D(self, *args):
        """
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} \\frac{1}{M\\times N \\times P} Z_{m,n,p} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N}) exp(2 i \\pi \\frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _algo.FFTImplementationPointer_inverseTransform3D(self, *args)


    def __repr__(self):
        return _algo.FFTImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _algo.FFTImplementationPointer___str__(self, *args)

    def __eq__(self, arg2):
        return _algo.FFTImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _algo.FFTImplementationPointer___ne__(self, other)

    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _algo.FFTImplementationPointer_getId(self)


    def setShadowedId(self, id):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _algo.FFTImplementationPointer_setShadowedId(self, id)


    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _algo.FFTImplementationPointer_getShadowedId(self)


    def setVisibility(self, visible):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _algo.FFTImplementationPointer_setVisibility(self, visible)


    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _algo.FFTImplementationPointer_getVisibility(self)


    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _algo.FFTImplementationPointer_hasName(self)


    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _algo.FFTImplementationPointer_hasVisibleName(self)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _algo.FFTImplementationPointer_getName(self)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _algo.FFTImplementationPointer_setName(self, name)

FFTImplementationPointer_swigregister = _algo.FFTImplementationPointer_swigregister
FFTImplementationPointer_swigregister(FFTImplementationPointer)

# This file is compatible with both classic and new-style classes.


