# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Statistical classes.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_statistics', [dirname(__file__)])
        except ImportError:
            import _statistics
            return _statistics
        if fp is not None:
            try:
                _mod = imp.load_module('_statistics', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _statistics = swig_import_helper()
    del swig_import_helper
else:
    import _statistics
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _statistics.SwigPyIterator_value(self)
    def incr(self, n=1): return _statistics.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _statistics.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _statistics.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _statistics.SwigPyIterator_equal(self, *args)
    def copy(self): return _statistics.SwigPyIterator_copy(self)
    def next(self): return _statistics.SwigPyIterator_next(self)
    def __next__(self): return _statistics.SwigPyIterator___next__(self)
    def previous(self): return _statistics.SwigPyIterator_previous(self)
    def advance(self, *args): return _statistics.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _statistics.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _statistics.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _statistics.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _statistics.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _statistics.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _statistics.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _statistics.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _statistics.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.graph
import openturns.func
import openturns.geom
class Compact(openturns.typ.HistoryStrategyImplementation):
    """
    Compact history storage strategy.

    Available constructors:
        Compact(*N*)

    Parameters
    ----------
    N : integer
        minimum number of points to store.

    See also
    --------
    HistoryStrategy, Null, Full, Last

    Notes
    -----
    The compact strategy stores a regularly spaced sub-sample where the minimum size
    of the stored numerical sample is :math:`N`. OpenTURNS proceeds as follows :

    1. it stores the first :math:`2N` simulations : the size of the stored
       sample is :math:`2N`,
    2. it selects only 1 out of 2 of the stored simulations : then the size of
       the stored sample decreases to :math:`N` (this is the *compact* step),
    3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
       next simulations : the size of the stored sample is :math:`2N`,
    4. it selects only 1 out of 2 of the stored simulations : then the size of
       the stored sample decreases to :math:`N`,
    5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
       next simulations : the size of the stored sample is :math:`2N`,
    6. then it keeps on until reaching the stopping criteria.

    The stored numerical sample will have a size within :math:`N` and :math:`2N` if at least one cycle has been done, else it will be at most :math:`N`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Compact, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Compact, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Compact_getClassName(self)

    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Compact_store(self, *args)

    def getSample(self):
        """
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _statistics.Compact_getSample(self)

    def getHalfMaximumSize(self):
        """
        Accessor to the half maximum number of points to store.

        Returns
        -------
        N : integer
            The half maximum number of points to store.
        """
        return _statistics.Compact_getHalfMaximumSize(self)

    def getIndex(self):
        """
        Accessor to the index.

        Returns
        -------
        index : integer
            The number of the stored points.
        """
        return _statistics.Compact_getIndex(self)

    def __repr__(self): return _statistics.Compact___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_Compact(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Compact
    __del__ = lambda self : None;
Compact_swigregister = _statistics.Compact_swigregister
Compact_swigregister(Compact)

class Full(openturns.typ.HistoryStrategyImplementation):
    """
    Full history storage strategy.

    Available constructors:
        Full()

    See also
    --------
    HistoryStrategy, Compact, Null, Last

    Notes
    -----
    The full strategy stores every points. Be careful! The memory will be exhausted
    for huge samples.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Full, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Full, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Full_getClassName(self)

    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Full_store(self, *args)

    def __repr__(self): return _statistics.Full___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_Full(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Full
    __del__ = lambda self : None;
Full_swigregister = _statistics.Full_swigregister
Full_swigregister(Full)

class Last(openturns.typ.HistoryStrategyImplementation):
    """
    Last history storage strategy.

    Available constructors:
        Last(*N*)

    Parameters
    ----------
    N : integer
        Number of points to store.

    See also
    --------
    HistoryStrategy, Compact, Null, Full

    Notes
    -----
    The last strategy stores only the *N* last points.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Last, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Last, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Last_getClassName(self)

    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Last_store(self, *args)

    def getSample(self):
        """
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _statistics.Last_getSample(self)

    def getMaximumSize(self):
        """
        Accessor to the maximum size of the storage strategy.

        Returns
        -------
        N : integer
            The maximum number of points to store.
        """
        return _statistics.Last_getMaximumSize(self)

    def getIndex(self):
        """
        Accessor to the index.

        Returns
        -------
        index : integer
            The index of the storage position.
        """
        return _statistics.Last_getIndex(self)

    def getHasWrapped(self):
        """
        Accessor to a wrapped flag.

        Returns
        -------
        wrapped : bool
            Return *True* if the storage has been wrapped.
        """
        return _statistics.Last_getHasWrapped(self)

    def __repr__(self): return _statistics.Last___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_Last(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Last
    __del__ = lambda self : None;
Last_swigregister = _statistics.Last_swigregister
Last_swigregister(Last)

class Null(openturns.typ.HistoryStrategyImplementation):
    """
    Null history storage strategy.

    Available constructors:
        Null()

    See also
    --------
    HistoryStrategy, Compact, Full, Last

    Notes
    -----
    The null strategy does not store anything.

    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Null, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.HistoryStrategyImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Null, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Null_getClassName(self)

    def store(self, *args):
        """
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Null_store(self, *args)

    def __repr__(self): return _statistics.Null___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_Null(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Null
    __del__ = lambda self : None;
Null_swigregister = _statistics.Null_swigregister
Null_swigregister(Null)

class HMatrixParameters(openturns.common.PersistentObject):
    """
    Parameters for HMatrix class.

    Notes
    -----
    This class regroups the parameters used by :class:`~openturns.HMatrix`

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixParameters, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixParameters, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixParameters_getClassName(self)

    def setAssemblyEpsilon(self, *args):
        """
        Set the epsilon used for the assembly.

        Parameters
        ----------
        epsilon : float
            assembly epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_setAssemblyEpsilon(self, *args)

    def getAssemblyEpsilon(self):
        """
        Return the epsilon used for the assembly.

        Returns
        -------
        epsilon : float
            assembly epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_getAssemblyEpsilon(self)

    def setRecompressionEpsilon(self, *args):
        """
        Set the epsilon used for the recompression.

        Parameters
        ----------
        epsilon : float
            recompression epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_setRecompressionEpsilon(self, *args)

    def getRecompressionEpsilon(self):
        """
        Return the epsilon used for the recompression.

        Returns
        -------
        epsilon : float
            recompression epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_getRecompressionEpsilon(self)

    def setAdmissibilityFactor(self, *args):
        """
        Set the admissibility factor used for cluster blocks.

        Parameters
        ----------
        epsilon : float
            admissibility factor for HMatrix.
        """
        return _statistics.HMatrixParameters_setAdmissibilityFactor(self, *args)

    def getAdmissibilityFactor(self):
        """
        Return the admissibility factor used for cluster blocks.

        Returns
        -------
        epsilon : float
            admissibility factor for HMatrix.
        """
        return _statistics.HMatrixParameters_getAdmissibilityFactor(self)

    def setClusteringAlgorithm(self, *args):
        """
        Set the clustering algorithm.

        Parameters
        ----------
        algorithm : str
            clustering algorithm (either 'median', 'geometric' or 'hybrid').
        """
        return _statistics.HMatrixParameters_setClusteringAlgorithm(self, *args)

    def getClusteringAlgorithm(self):
        """
        Return the clustering algorithm.

        Returns
        -------
        algorithm : str
            clustering algorithm (either 'median', 'geometric' or 'hybrid').
        """
        return _statistics.HMatrixParameters_getClusteringAlgorithm(self)

    def setCompressionMethod(self, *args):
        """
        Set the compression method.

        Parameters
        ----------
        method : str
            compression method (either 'SVD', 'ACA full', 'ACA partial' or 'ACA+'.
        """
        return _statistics.HMatrixParameters_setCompressionMethod(self, *args)

    def getCompressionMethod(self):
        """
        Return the compression method.

        Returns
        -------
        method : str
            compression method (either 'SVD', 'ACA full', 'ACA partial' or 'ACA+'.
        """
        return _statistics.HMatrixParameters_getCompressionMethod(self)

    def __repr__(self): return _statistics.HMatrixParameters___repr__(self)
    def __str__(self, offset=""): return _statistics.HMatrixParameters___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_HMatrixParameters(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_HMatrixParameters
    __del__ = lambda self : None;
HMatrixParameters_swigregister = _statistics.HMatrixParameters_swigregister
HMatrixParameters_swigregister(HMatrixParameters)

class LinearModel(openturns.common.PersistentObject):
    """
    The linear model class is created through the method build of a LinearModelFactory.

    See Also
    --------
    LinearModelFactory

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModel, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.LinearModel_getClassName(self)

    def __repr__(self): return _statistics.LinearModel___repr__(self)
    def __str__(self, offset=""): return _statistics.LinearModel___str__(self, offset)
    def getRegression(self):
        """
        Accessor to the regression coefficients.

        Returns
        -------
        coef : :class:`~openturns.NumericalPoint`
            The coefficients of the linear model: :math:`(a_0, a_1, \\ldots, a_n)`.
        """
        return _statistics.LinearModel_getRegression(self)

    def getConfidenceIntervals(self):
        """
        Accessor to the confidence intervals.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence intervals of the linear model coefficients,
            corresponding to the level precised when the LinearModel class has been
            created through the method *build*.
        """
        return _statistics.LinearModel_getConfidenceIntervals(self)

    def getPValues(self):
        """
        Accessor to the p-values.

        Returns
        -------
        pvalues : collection of :class:`~openturns.NumericalScalar`
            The collection of the p-values of the linear model coefficients.
        """
        return _statistics.LinearModel_getPValues(self)

    def getPredicted(self, *args):
        """
        Accessor to the evaluation function of linear model.

        Parameters
        ----------
        sampleX : 2-d sequence of float
            The input sample to be evaluated by the linear model.

        Returns
        -------
        Y : :class:`~openturns.NumericalSample`
            The response :math:`Y` evaluated through the linear model on the sample
            *sampleX*.
        """
        return _statistics.LinearModel_getPredicted(self, *args)

    def getResidual(self, *args):
        """
        Accessor to the residuals.

        Parameters
        ----------
        Xsample: 2-d sequence of float
            The input sample on which the linear model has been built.
        Ysample: 2-d sequence of float
            The 1d output sample on which the linear model has been built.

        Returns
        -------
        residual : :class:`~openturns.NumericalSample`
            The residuals computed on each point.
        """
        return _statistics.LinearModel_getResidual(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_LinearModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_LinearModel
    __del__ = lambda self : None;
LinearModel_swigregister = _statistics.LinearModel_swigregister
LinearModel_swigregister(LinearModel)


def LinearModel_operator___eq__(*args):
  return _statistics.LinearModel_operator___eq__(*args)
LinearModel_operator___eq__ = _statistics.LinearModel_operator___eq__
class LinearModelFactory(_object):
    """
    Class used to create a linear model from numerical samples.

    **Available usages**:

        LinearModelFactory()

    See Also
    --------
    LinearModel

    Notes
    -----
    This class is used in order to create a linear model from numerical samples. The
    linear regression model between the scalar variable :math:`Y` and the :math:`n`
    -dimensional one :math:`\\vect{X} = (X_i)_{i \\leq n}` writes as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    Each coefficient :math:`a_i` is evaluated from both samples :math:`Ysample` and
    :math:`Xsample` and is accompagnied by a confidence interval and a p-value (which
    tests if they are significantly different from 0.0).

    This class enables to test the quality of the model. It provides only numerical
    tests. If :math:`X` is scalar, a graphical validation test exists, that draws
    the residual couples :math:`(\\epsilon_i, \\epsilon_{i+1})`, where the residual
    :math:`\\epsilon_i` is evaluated on the samples :math:`(Xsample, Ysample)`:
    :math:`\\epsilon_i  = Ysample_i - \\tilde{Y}_i` with
    :math:`\\tilde{Y}_i = a_0 + a_1 + Xsample_i`. The OpenTURNS method is 
    :class:`~openturns.VisualTest_DrawLinearModelResidual`.

    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelFactory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelFactory, name)
    __repr__ = _swig_repr
    def build(self, *args):
        """
        Build the linear model from numerical samples.

        **Available usages**:

            build(*Xsample, Ysample*)

            build(*Xsample, Ysample, level*)

        Parameters
        ----------
        Xsample : 2-d sequence of float
            Input sample, of dimension :math:`n \\geq 1`.
        Ysample : 2-d sequence of float
            Output sample, of dimension 1.
        level : positive float :math:`< 1`
            The level value of the confidence intervals of each coefficient of the
            linear model, equal to 0.95 by default.

        Returns
        -------
        linearModel : :class:`~openturns.LinearModel`
            The linear model built from the samples :math:`(Xsample, Ysample)`:
            :math:`a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon`, where :math:`\\epsilon` is the
            random residual with zero mean.

        See Also
        --------
        LinearModel


        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> Xsample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> Ysample = func(Xsample) + ot.Normal().getSample(30)
        >>> LMF = ot.LinearModelFactory()
        >>> linearModel = LMF.build(Xsample, Ysample)
        >>> print(linearModel)
        LinearModel name=Unnamed regression=[1.1802,2.0034] confidence intervals=[0.887852, 1.47256]
        [1.70439, 2.3024] p-Values=[1.87486e-07,5.10531e-12]

        """
        return _statistics.LinearModelFactory_build(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_LinearModelFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_LinearModelFactory
    __del__ = lambda self : None;
LinearModelFactory_swigregister = _statistics.LinearModelFactory_swigregister
LinearModelFactory_swigregister(LinearModelFactory)

class TestResultCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TestResultCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TestResultCollection, name)
    __swig_destroy__ = _statistics.delete_TestResultCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _statistics.TestResultCollection_clear(self)

    def __len__(self): return _statistics.TestResultCollection___len__(self)
    def __eq__(self, *args): return _statistics.TestResultCollection___eq__(self, *args)
    def __contains__(self, *args): return _statistics.TestResultCollection___contains__(self, *args)
    def __getitem__(self, *args): return _statistics.TestResultCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _statistics.TestResultCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _statistics.TestResultCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _statistics.TestResultCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _statistics.TestResultCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _statistics.TestResultCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _statistics.TestResultCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _statistics.TestResultCollection_isEmpty(self)

    def __repr__(self): return _statistics.TestResultCollection___repr__(self)
    def __str__(self, offset=""): return _statistics.TestResultCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_TestResultCollection(*args)
        try: self.this.append(this)
        except: self.this = this
TestResultCollection_swigregister = _statistics.TestResultCollection_swigregister
TestResultCollection_swigregister(TestResultCollection)

class TestResult(openturns.common.PersistentObject):
    """
    Test result data structure.

    .. warning::

        Tests results are not intended to be created manually. They are returned
        by the statistical tests implemented in the :mod:`~openturns.stattests`
        subpackage. Constructor is therefore intentionally not documented.

    Notes
    -----
    The p-value of a test can be seen as the probability of observing a sample
    having a worst or equal statistic than the one that has been calculated on the
    tested sample, under the null hypothesis. This is the metric that is used for
    concluding the test with respect to the given accepted risk of committing a
    Type I error, that is an incorrect rejection of a true null hypothesis.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.FittingTest.Kolmogorov(sample, ot.NormalFactory(), 0.99)
    >>> print(test_result.getPValue())
    0.846896...
    >>> print(test_result.getThreshold())
    0.01...
    >>> print(test_result.getBinaryQualityMeasure())
    True
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TestResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TestResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.TestResult_getClassName(self)

    def setDescription(self, *args): return _statistics.TestResult_setDescription(self, *args)
    def getDescription(self): return _statistics.TestResult_getDescription(self)
    def __repr__(self): return _statistics.TestResult___repr__(self)
    def getBinaryQualityMeasure(self):
        """
        Accessor to the test's binary conclusion.

        Returns
        -------
        binary_measure : bool, optional
            Test conclusion: `False` if it can reject the null hypothesis, `True` if
            it cannot.
        """
        return _statistics.TestResult_getBinaryQualityMeasure(self)

    def getPValue(self):
        """
        Accessor to the test's p-value.

        Returns
        -------
        p_value : float, :math:`0 \\leq p \\leq 1`
            The test's p-value.
        """
        return _statistics.TestResult_getPValue(self)

    def getThreshold(self):
        """
        Accessor to the accepted risk of committing a Type I error.

        Returns
        -------
        threshold : float, :math:`0 \\leq \\alpha \\leq 1`
            Accepted risk of committing a Type I error.
        """
        return _statistics.TestResult_getThreshold(self)

    def getTestType(self): return _statistics.TestResult_getTestType(self)
    def __eq__(self, *args): return _statistics.TestResult___eq__(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_TestResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_TestResult
    __del__ = lambda self : None;
TestResult_swigregister = _statistics.TestResult_swigregister
TestResult_swigregister(TestResult)

class RandomGeneratorState(openturns.common.PersistentObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomGeneratorState, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomGeneratorState, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.RandomGeneratorState_getClassName(self)

    def __repr__(self): return _statistics.RandomGeneratorState___repr__(self)
    def __str__(self, offset=""): return _statistics.RandomGeneratorState___str__(self, offset)
    def getBuffer(self): return _statistics.RandomGeneratorState_getBuffer(self)
    def getIndex(self): return _statistics.RandomGeneratorState_getIndex(self)
    def __init__(self, *args): 
        this = _statistics.new_RandomGeneratorState(*args)
        try: self.this.append(this)
        except: self.this = this
    def __eq__(self, *args): return _statistics.RandomGeneratorState___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_RandomGeneratorState
    __del__ = lambda self : None;
RandomGeneratorState_swigregister = _statistics.RandomGeneratorState_swigregister
RandomGeneratorState_swigregister(RandomGeneratorState)

class RandomGenerator(_object):
    """
    Uniform random generator.

    The random generator of uniform(0,1) sample of OpenTURNS is based on the DSFTM
    (Double precision SIMD oriented Fast Mersenne Twister) algorithm described in
    the Reference Guide.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomGenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RandomGenerator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def SetSeed(*args):
        """
        Set the seed of the random generator.

        Parameters
        ----------
        n : int :math:`\\in [0, 2^{32}-1]`

        Notes
        -----
        This method fixes a particular state of the random generator algorithm
        thanks to the seed :math:`n`. The seed of the random generator is automatically
        initialized to 0 when a session is launched.
        """
        return _statistics.RandomGenerator_SetSeed(*args)

    if _newclass:SetSeed = staticmethod(SetSeed)
    __swig_getmethods__["SetSeed"] = lambda x: SetSeed
    def SetState(*args):
        """
        Set the state of the random generator.

        Parameters
        ----------
        particularState : :class:`~openturns.RandomGeneratorState`
            State of the random generator.

        Notes
        -----
        This method fixes the entire state of the random generator algorithm
        thanks the specification of the entire state *particularState* usually
        previously obtained thanks to the :meth:`GetState` method.
        """
        return _statistics.RandomGenerator_SetState(*args)

    if _newclass:SetState = staticmethod(SetState)
    __swig_getmethods__["SetState"] = lambda x: SetState
    def GetState():
        """
        Get the state of the random generator.

        Returns
        -------
        particularState : :class:`~openturns.RandomGeneratorState`
            State of the random generator.
        """
        return _statistics.RandomGenerator_GetState()

    if _newclass:GetState = staticmethod(GetState)
    __swig_getmethods__["GetState"] = lambda x: GetState
    def Generate(*args):
        """
        Generate a pseudo-random vector.

        Parameters
        ----------
        size : positive int
            Number of realizations required. When not given, by default it is equal to
            1.

        Returns
        -------
        numbers : float, :class:`~openturns.NumericalPoint`
            Pseudo-random numbers uniformly distributed over :math:`[0, 1[`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print('%.6f' % ot.RandomGenerator.Generate())
        0.629877
        >>> print(ot.RandomGenerator.Generate(2))
        [0.882805,0.135276]
        """
        return _statistics.RandomGenerator_Generate(*args)

    if _newclass:Generate = staticmethod(Generate)
    __swig_getmethods__["Generate"] = lambda x: Generate
    def IntegerGenerate(*args):
        """
        Generate a pseudo-random integer.

        :Available usages:
            IntegerGenerate(*n*)

            IntegerGenerate(*size, n*)

        Parameters
        ----------
        n : positive int
            Upper bound of the interval where the pseudo-random integers are.
        size : positive int
            Number of integers to generate. When not given, by default it is equal to
            1.

        Returns
        -------
        integer : int, :class:`~openturns.UnsignedIntegerCollection`
            Pseudo-random integers uniformly distributed over :math:`[0,...,n-1]`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(ot.RandomGenerator.IntegerGenerate(30))
        24
        >>> print(ot.RandomGenerator.IntegerGenerate(5, 30))
        [26,21,21,22,26]
        """
        return _statistics.RandomGenerator_IntegerGenerate(*args)

    if _newclass:IntegerGenerate = staticmethod(IntegerGenerate)
    __swig_getmethods__["IntegerGenerate"] = lambda x: IntegerGenerate
    __swig_destroy__ = _statistics.delete_RandomGenerator
    __del__ = lambda self : None;
RandomGenerator_swigregister = _statistics.RandomGenerator_swigregister
RandomGenerator_swigregister(RandomGenerator)

def RandomGenerator_SetSeed(*args):
  """
    Set the seed of the random generator.

    Parameters
    ----------
    n : int :math:`\\in [0, 2^{32}-1]`

    Notes
    -----
    This method fixes a particular state of the random generator algorithm
    thanks to the seed :math:`n`. The seed of the random generator is automatically
    initialized to 0 when a session is launched.
    """
  return _statistics.RandomGenerator_SetSeed(*args)

def RandomGenerator_SetState(*args):
  """
    Set the state of the random generator.

    Parameters
    ----------
    particularState : :class:`~openturns.RandomGeneratorState`
        State of the random generator.

    Notes
    -----
    This method fixes the entire state of the random generator algorithm
    thanks the specification of the entire state *particularState* usually
    previously obtained thanks to the :meth:`GetState` method.
    """
  return _statistics.RandomGenerator_SetState(*args)

def RandomGenerator_GetState():
  """
    Get the state of the random generator.

    Returns
    -------
    particularState : :class:`~openturns.RandomGeneratorState`
        State of the random generator.
    """
  return _statistics.RandomGenerator_GetState()

def RandomGenerator_Generate(*args):
  """
    Generate a pseudo-random vector.

    Parameters
    ----------
    size : positive int
        Number of realizations required. When not given, by default it is equal to
        1.

    Returns
    -------
    numbers : float, :class:`~openturns.NumericalPoint`
        Pseudo-random numbers uniformly distributed over :math:`[0, 1[`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> print('%.6f' % ot.RandomGenerator.Generate())
    0.629877
    >>> print(ot.RandomGenerator.Generate(2))
    [0.882805,0.135276]
    """
  return _statistics.RandomGenerator_Generate(*args)

def RandomGenerator_IntegerGenerate(*args):
  """
    Generate a pseudo-random integer.

    :Available usages:
        IntegerGenerate(*n*)

        IntegerGenerate(*size, n*)

    Parameters
    ----------
    n : positive int
        Upper bound of the interval where the pseudo-random integers are.
    size : positive int
        Number of integers to generate. When not given, by default it is equal to
        1.

    Returns
    -------
    integer : int, :class:`~openturns.UnsignedIntegerCollection`
        Pseudo-random integers uniformly distributed over :math:`[0,...,n-1]`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> print(ot.RandomGenerator.IntegerGenerate(30))
    24
    >>> print(ot.RandomGenerator.IntegerGenerate(5, 30))
    [26,21,21,22,26]
    """
  return _statistics.RandomGenerator_IntegerGenerate(*args)

class LowDiscrepancySequenceImplementation(openturns.common.PersistentObject):
    """
    Base class to generate low discrepancy sequences.

    Available constructors:
        LowDiscrepancySequence(*dimension=1*)

    Parameters
    ----------
    dimension : int
        Dimension of the points of the low discrepancy sequence.

    Notes
    -----
    The low discrepancy sequences, also called 'quasi-random' sequences, are a
    deterministic alternative to random sequences for use in Monte Carlo methods.
    These sequences are sets of equidistributed points which the error in uniformity
    is measured by its discrepancy.

    The **discrepancy** of a set :math:`P = \\{x_1, \\hdots, x_N\\}` is defined,
    using Niederreiter's notation, as:

    .. math::

        D_N(P) = \\sup_{B\\in J} \\left| \\frac{A(B;P)}{N} - \\lambda_s(B) \\right|

    where :math:`\\lambda_s` is the s-dimensional Lebesgue measure, :math:`A(B;P)`
    is the number of points in :math:`P` that fall into :math:`B`, and :math:`J` is
    the set of s-dimensional intervals or boxes of the form:

    .. math::

        \\prod_{i=1}^s [a_i, b_i) = \\{ \\mathbf{x} \\in \\mathbf{R}^s : a_i \\le x_i < b_i \\} \\,

    where :math:`0 \\le a_i < b_i \\le 1`.

    The star-discrepancy :math:`D_N^*(P)` is defined similarly, except that the
    supremum is taken over the set :math:`J^*` of intervals of the form:

    .. math::

        \\prod_{i=1}^s [0, u_i)

    where :math:`u_i` is in the half-open interval :math:`[0, 1)`.

    A low-discrepancy sequence can be generated only through the derived classes of
    LowDiscrepancySequence. OpenTURNS proposes the
    :class:`Faure <openturns.FaureSequence>`,
    :class:`Halton <openturns.HaltonSequence>`,
    :class:`Reverse Halton <openturns.ReverseHaltonSequence>`,
    :class:`Haselgrove <openturns.HaselgroveSequence>` and
    :class:`Sobol <openturns.SobolSequence>` sequences.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> print(sequence.generate(3))
    0 : [ 0.5  0.5  ]
    1 : [ 0.75 0.25 ]
    2 : [ 0.25 0.75 ]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LowDiscrepancySequenceImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LowDiscrepancySequenceImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.LowDiscrepancySequenceImplementation_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequenceImplementation_initialize(self, *args)

    def getDimension(self):
        """
        Accessor to the dimension of the points of the low discrepancy sequence.

        Returns
        -------
        dimension : int
            Dimension of the points of the low discrepancy sequence.
        """
        return _statistics.LowDiscrepancySequenceImplementation_getDimension(self)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequenceImplementation_generate(self, *args)

    def ComputeStarDiscrepancy(*args):
        """
        Compute the star discrepancy of a sample uniformly distributed over [0, 1).

        Parameters
        ----------
        sample : 2-d sequence of float

        Returns
        -------
        starDiscrepancy : float
            Star discrepancy of a sample uniformly distributed over [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> sample = sequence.generate(16)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.12890625
        >>> sample = sequence.generate(64)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.0537109375
        """
        return _statistics.LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(*args)

    if _newclass:ComputeStarDiscrepancy = staticmethod(ComputeStarDiscrepancy)
    __swig_getmethods__["ComputeStarDiscrepancy"] = lambda x: ComputeStarDiscrepancy
    def __repr__(self): return _statistics.LowDiscrepancySequenceImplementation___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_LowDiscrepancySequenceImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequenceImplementation
    __del__ = lambda self : None;
LowDiscrepancySequenceImplementation_swigregister = _statistics.LowDiscrepancySequenceImplementation_swigregister
LowDiscrepancySequenceImplementation_swigregister(LowDiscrepancySequenceImplementation)

def LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(*args):
  """
    Compute the star discrepancy of a sample uniformly distributed over [0, 1).

    Parameters
    ----------
    sample : 2-d sequence of float

    Returns
    -------
    starDiscrepancy : float
        Star discrepancy of a sample uniformly distributed over [0, 1).

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> sample = sequence.generate(16)
    >>> print(sequence.computeStarDiscrepancy(sample))
    0.12890625
    >>> sample = sequence.generate(64)
    >>> print(sequence.computeStarDiscrepancy(sample))
    0.0537109375
    """
  return _statistics.LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(*args)

class LowDiscrepancySequenceImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LowDiscrepancySequenceImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LowDiscrepancySequenceImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_LowDiscrepancySequenceImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequenceImplementationTypedInterfaceObject
    __del__ = lambda self : None;
LowDiscrepancySequenceImplementationTypedInterfaceObject_swigregister = _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_swigregister
LowDiscrepancySequenceImplementationTypedInterfaceObject_swigregister(LowDiscrepancySequenceImplementationTypedInterfaceObject)

class LowDiscrepancySequence(LowDiscrepancySequenceImplementationTypedInterfaceObject):
    """
    Base class to generate low discrepancy sequences.

    Available constructors:
        LowDiscrepancySequence(*dimension=1*)

    Parameters
    ----------
    dimension : int
        Dimension of the points of the low discrepancy sequence.

    Notes
    -----
    The low discrepancy sequences, also called 'quasi-random' sequences, are a
    deterministic alternative to random sequences for use in Monte Carlo methods.
    These sequences are sets of equidistributed points which the error in uniformity
    is measured by its discrepancy.

    The **discrepancy** of a set :math:`P = \\{x_1, \\hdots, x_N\\}` is defined,
    using Niederreiter's notation, as:

    .. math::

        D_N(P) = \\sup_{B\\in J} \\left| \\frac{A(B;P)}{N} - \\lambda_s(B) \\right|

    where :math:`\\lambda_s` is the s-dimensional Lebesgue measure, :math:`A(B;P)`
    is the number of points in :math:`P` that fall into :math:`B`, and :math:`J` is
    the set of s-dimensional intervals or boxes of the form:

    .. math::

        \\prod_{i=1}^s [a_i, b_i) = \\{ \\mathbf{x} \\in \\mathbf{R}^s : a_i \\le x_i < b_i \\} \\,

    where :math:`0 \\le a_i < b_i \\le 1`.

    The star-discrepancy :math:`D_N^*(P)` is defined similarly, except that the
    supremum is taken over the set :math:`J^*` of intervals of the form:

    .. math::

        \\prod_{i=1}^s [0, u_i)

    where :math:`u_i` is in the half-open interval :math:`[0, 1)`.

    A low-discrepancy sequence can be generated only through the derived classes of
    LowDiscrepancySequence. OpenTURNS proposes the
    :class:`Faure <openturns.FaureSequence>`,
    :class:`Halton <openturns.HaltonSequence>`,
    :class:`Reverse Halton <openturns.ReverseHaltonSequence>`,
    :class:`Haselgrove <openturns.HaselgroveSequence>` and
    :class:`Sobol <openturns.SobolSequence>` sequences.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> print(sequence.generate(3))
    0 : [ 0.5  0.5  ]
    1 : [ 0.75 0.25 ]
    2 : [ 0.25 0.75 ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LowDiscrepancySequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LowDiscrepancySequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.LowDiscrepancySequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequence_initialize(self, *args)

    def getDimension(self):
        """
        Accessor to the dimension of the points of the low discrepancy sequence.

        Returns
        -------
        dimension : int
            Dimension of the points of the low discrepancy sequence.
        """
        return _statistics.LowDiscrepancySequence_getDimension(self)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequence_generate(self, *args)

    def computeStarDiscrepancy(self, *args):
        """
        Compute the star discrepancy of a sample uniformly distributed over [0, 1).

        Parameters
        ----------
        sample : 2-d sequence of float

        Returns
        -------
        starDiscrepancy : float
            Star discrepancy of a sample uniformly distributed over [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> sample = sequence.generate(16)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.12890625
        >>> sample = sequence.generate(64)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.0537109375
        """
        return _statistics.LowDiscrepancySequence_computeStarDiscrepancy(self, *args)

    def __repr__(self): return _statistics.LowDiscrepancySequence___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_LowDiscrepancySequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequence
    __del__ = lambda self : None;
LowDiscrepancySequence_swigregister = _statistics.LowDiscrepancySequence_swigregister
LowDiscrepancySequence_swigregister(LowDiscrepancySequence)

class SobolSequence(LowDiscrepancySequenceImplementation):
    """
    Sobol sequence.

    Available constructors:
        SobolSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.SobolSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SobolSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SobolSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SobolSequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.SobolSequence_initialize(self, *args)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.SobolSequence_generate(self, *args)

    def __repr__(self): return _statistics.SobolSequence___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_SobolSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SobolSequence
    __del__ = lambda self : None;
SobolSequence_swigregister = _statistics.SobolSequence_swigregister
SobolSequence_swigregister(SobolSequence)
cvar = _statistics.cvar
SobolSequence.MaximumNumberOfDimension = _statistics.cvar.SobolSequence_MaximumNumberOfDimension
SobolSequence.MaximumBase2Logarithm = _statistics.cvar.SobolSequence_MaximumBase2Logarithm
SobolSequence.Epsilon = _statistics.cvar.SobolSequence_Epsilon
SobolSequence.MaximumInitialDegree = _statistics.cvar.SobolSequence_MaximumInitialDegree
SobolSequence.InitialBase = _statistics.cvar.SobolSequence_InitialBase
SobolSequence.PrimitivePolynomial = _statistics.cvar.SobolSequence_PrimitivePolynomial

class FaureSequence(LowDiscrepancySequenceImplementation):
    """
    Faure sequence.

    Available constructors:
        FaureSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.FaureSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5   0.5   ]
    1 : [ 0.25  0.75  ]
    2 : [ 0.75  0.25  ]
    3 : [ 0.125 0.625 ]
    4 : [ 0.625 0.125 ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FaureSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FaureSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FaureSequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.FaureSequence_initialize(self, *args)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.FaureSequence_generate(self, *args)

    def __repr__(self): return _statistics.FaureSequence___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_FaureSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_FaureSequence
    __del__ = lambda self : None;
FaureSequence_swigregister = _statistics.FaureSequence_swigregister
FaureSequence_swigregister(FaureSequence)

class HaltonSequence(LowDiscrepancySequenceImplementation):
    """
    Halton sequence.

    Available constructors:
        HaltonSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.HaltonSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5      0.333333 ]
    1 : [ 0.25     0.666667 ]
    2 : [ 0.75     0.111111 ]
    3 : [ 0.125    0.444444 ]
    4 : [ 0.625    0.777778 ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HaltonSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HaltonSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HaltonSequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaltonSequence_initialize(self, *args)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaltonSequence_generate(self, *args)

    def __repr__(self): return _statistics.HaltonSequence___repr__(self)
    def __str__(self, offset=""): return _statistics.HaltonSequence___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_HaltonSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_HaltonSequence
    __del__ = lambda self : None;
HaltonSequence_swigregister = _statistics.HaltonSequence_swigregister
HaltonSequence_swigregister(HaltonSequence)

class HaselgroveSequence(LowDiscrepancySequenceImplementation):
    """
    Haselgrove sequence.

    Available constructors:
        HaselgroveSequence(*dimension=1*)

        HaselgroveSequence(*base*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.
    base : sequence of positive float
        Sequence of positive real values linearly independent over the integer
        ring, i.e. no linear combination with integer coefficients of these values
        can be zero excepted if all the coefficients are zero. The dimension of the
        sequence is given by the dimension of the base.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.HaselgroveSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.414214  0.732051  ]
    1 : [ 0.828427  0.464102  ]
    2 : [ 0.242641  0.196152  ]
    3 : [ 0.656854  0.928203  ]
    4 : [ 0.0710678 0.660254  ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HaselgroveSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HaselgroveSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HaselgroveSequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaselgroveSequence_initialize(self, *args)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaselgroveSequence_generate(self, *args)

    def __repr__(self): return _statistics.HaselgroveSequence___repr__(self)
    def __str__(self, offset=""): return _statistics.HaselgroveSequence___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_HaselgroveSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_HaselgroveSequence
    __del__ = lambda self : None;
HaselgroveSequence_swigregister = _statistics.HaselgroveSequence_swigregister
HaselgroveSequence_swigregister(HaselgroveSequence)

class ReverseHaltonSequence(LowDiscrepancySequenceImplementation):
    """
    Reverse Halton sequence.

    Available constructors:
        ReverseHaltonSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.ReverseHaltonSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5      0.666667 ]
    1 : [ 0.25     0.333333 ]
    2 : [ 0.75     0.222222 ]
    3 : [ 0.125    0.888889 ]
    4 : [ 0.625    0.555556 ]
    """
    __swig_setmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ReverseHaltonSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [LowDiscrepancySequenceImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ReverseHaltonSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ReverseHaltonSequence_getClassName(self)

    def initialize(self, *args):
        """
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.ReverseHaltonSequence_initialize(self, *args)

    def generate(self, *args):
        """
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.ReverseHaltonSequence_generate(self, *args)

    def __repr__(self): return _statistics.ReverseHaltonSequence___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_ReverseHaltonSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_ReverseHaltonSequence
    __del__ = lambda self : None;
ReverseHaltonSequence_swigregister = _statistics.ReverseHaltonSequence_swigregister
ReverseHaltonSequence_swigregister(ReverseHaltonSequence)

class CorrelationAnalysis(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CorrelationAnalysis, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CorrelationAnalysis, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def PearsonCorrelation(*args):
        """
        Correlation evaluation based on the Pearson correlation coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension = 1.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : float
            The Pearson correlation coefficients evaluated between the *sample2* and the
            *sample1*.

        See Also
        --------
        CorrelationAnalysis_PCC, CorrelationAnalysis_SRC,
        CorrelationAnalysis_SpearmanCorrelation
        """
        return _statistics.CorrelationAnalysis_PearsonCorrelation(*args)

    if _newclass:PearsonCorrelation = staticmethod(PearsonCorrelation)
    __swig_getmethods__["PearsonCorrelation"] = lambda x: PearsonCorrelation
    def SpearmanCorrelation(*args):
        """
        Correlation evaluation based on the Spearman correlation coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension = 1.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : float
            The Spearman correlation coefficients evaluated between the *sample2* and the
            *sample1* (based on the rank values).

        See Also
        --------
        CorrelationAnalysis_PRCC, CorrelationAnalysis_SRRC,
        CorrelationAnalysis_PearsonCorrelation
        """
        return _statistics.CorrelationAnalysis_SpearmanCorrelation(*args)

    if _newclass:SpearmanCorrelation = staticmethod(SpearmanCorrelation)
    __swig_getmethods__["SpearmanCorrelation"] = lambda x: SpearmanCorrelation
    def SRC(*args):
        """
        Correlation evaluation based on the Standard Regression Coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \\geq 1`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.NumericalPoint`
            The SRC evaluated between the *sample2* and each coordinate of the *sample1*.

        See Also
        --------
        CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_PCC,
        CorrelationAnalysis_SRRC
        """
        return _statistics.CorrelationAnalysis_SRC(*args)

    if _newclass:SRC = staticmethod(SRC)
    __swig_getmethods__["SRC"] = lambda x: SRC
    def PCC(*args):
        """
        Correlation evaluation based on the Partial Correlation Coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \\geq 2`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.NumericalPoint`
            The PCC coefficients evaluated between the *sample2* and each coordinate of
            *sample1*.

        See Also
        --------
        CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_SRC, 
        CorrelationAnalysis_PRCC
        """
        return _statistics.CorrelationAnalysis_PCC(*args)

    if _newclass:PCC = staticmethod(PCC)
    __swig_getmethods__["PCC"] = lambda x: PCC
    def SRRC(*args):
        """
        Correlation evaluation based on the Standard Rank Regression Coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \\geq 1`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.NumericalPoint`
            The SRRC evaluated between the *sample2* and each coordinate of the
            *sample1* (based on the rank value).

        See Also
        --------
        CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
        CorrelationAnalysis_SRC
        """
        return _statistics.CorrelationAnalysis_SRRC(*args)

    if _newclass:SRRC = staticmethod(SRRC)
    __swig_getmethods__["SRRC"] = lambda x: SRRC
    def PRCC(*args):
        """
        Correlation evaluation based on the Partial Rank Correlation Coefficient.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \\geq 2`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.NumericalPoint`
            The PRCC coefficients evaluated between the *sample2* and each coordinate of
            *sample1* (based on the rank values).

        See Also
        --------
        CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_SRRC,
        CorrelationAnalysis_PCC
        """
        return _statistics.CorrelationAnalysis_PRCC(*args)

    if _newclass:PRCC = staticmethod(PRCC)
    __swig_getmethods__["PRCC"] = lambda x: PRCC
    __swig_destroy__ = _statistics.delete_CorrelationAnalysis
    __del__ = lambda self : None;
CorrelationAnalysis_swigregister = _statistics.CorrelationAnalysis_swigregister
CorrelationAnalysis_swigregister(CorrelationAnalysis)

def CorrelationAnalysis_PearsonCorrelation(*args):
  """
    Correlation evaluation based on the Pearson correlation coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension = 1.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : float
        The Pearson correlation coefficients evaluated between the *sample2* and the
        *sample1*.

    See Also
    --------
    CorrelationAnalysis_PCC, CorrelationAnalysis_SRC,
    CorrelationAnalysis_SpearmanCorrelation
    """
  return _statistics.CorrelationAnalysis_PearsonCorrelation(*args)

def CorrelationAnalysis_SpearmanCorrelation(*args):
  """
    Correlation evaluation based on the Spearman correlation coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension = 1.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : float
        The Spearman correlation coefficients evaluated between the *sample2* and the
        *sample1* (based on the rank values).

    See Also
    --------
    CorrelationAnalysis_PRCC, CorrelationAnalysis_SRRC,
    CorrelationAnalysis_PearsonCorrelation
    """
  return _statistics.CorrelationAnalysis_SpearmanCorrelation(*args)

def CorrelationAnalysis_SRC(*args):
  """
    Correlation evaluation based on the Standard Regression Coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \\geq 1`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.NumericalPoint`
        The SRC evaluated between the *sample2* and each coordinate of the *sample1*.

    See Also
    --------
    CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_PCC,
    CorrelationAnalysis_SRRC
    """
  return _statistics.CorrelationAnalysis_SRC(*args)

def CorrelationAnalysis_PCC(*args):
  """
    Correlation evaluation based on the Partial Correlation Coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \\geq 2`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.NumericalPoint`
        The PCC coefficients evaluated between the *sample2* and each coordinate of
        *sample1*.

    See Also
    --------
    CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_SRC, 
    CorrelationAnalysis_PRCC
    """
  return _statistics.CorrelationAnalysis_PCC(*args)

def CorrelationAnalysis_SRRC(*args):
  """
    Correlation evaluation based on the Standard Rank Regression Coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \\geq 1`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.NumericalPoint`
        The SRRC evaluated between the *sample2* and each coordinate of the
        *sample1* (based on the rank value).

    See Also
    --------
    CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
    CorrelationAnalysis_SRC
    """
  return _statistics.CorrelationAnalysis_SRRC(*args)

def CorrelationAnalysis_PRCC(*args):
  """
    Correlation evaluation based on the Partial Rank Correlation Coefficient.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \\geq 2`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.NumericalPoint`
        The PRCC coefficients evaluated between the *sample2* and each coordinate of
        *sample1* (based on the rank values).

    See Also
    --------
    CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_SRRC,
    CorrelationAnalysis_PCC
    """
  return _statistics.CorrelationAnalysis_PRCC(*args)

class FilteringWindowsImplementation(openturns.common.PersistentObject):
    """Base class for filtering windows."""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FilteringWindowsImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FilteringWindowsImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FilteringWindowsImplementation_getClassName(self)

    def __call__(self, *args): return _statistics.FilteringWindowsImplementation___call__(self, *args)
    def __repr__(self): return _statistics.FilteringWindowsImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.FilteringWindowsImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_FilteringWindowsImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_FilteringWindowsImplementation
    __del__ = lambda self : None;
FilteringWindowsImplementation_swigregister = _statistics.FilteringWindowsImplementation_swigregister
FilteringWindowsImplementation_swigregister(FilteringWindowsImplementation)

class FilteringWindowsImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FilteringWindowsImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FilteringWindowsImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_FilteringWindowsImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.FilteringWindowsImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_FilteringWindowsImplementationTypedInterfaceObject
    __del__ = lambda self : None;
FilteringWindowsImplementationTypedInterfaceObject_swigregister = _statistics.FilteringWindowsImplementationTypedInterfaceObject_swigregister
FilteringWindowsImplementationTypedInterfaceObject_swigregister(FilteringWindowsImplementationTypedInterfaceObject)

class FilteringWindows(FilteringWindowsImplementationTypedInterfaceObject):
    """Base class for filtering windows."""
    __swig_setmethods__ = {}
    for _s in [FilteringWindowsImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FilteringWindows, name, value)
    __swig_getmethods__ = {}
    for _s in [FilteringWindowsImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FilteringWindows, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FilteringWindows_getClassName(self)

    def __repr__(self): return _statistics.FilteringWindows___repr__(self)
    def __str__(self, offset=""): return _statistics.FilteringWindows___str__(self, offset)
    def __call__(self, *args): return _statistics.FilteringWindows___call__(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_FilteringWindows(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_FilteringWindows
    __del__ = lambda self : None;
FilteringWindows_swigregister = _statistics.FilteringWindows_swigregister
FilteringWindows_swigregister(FilteringWindows)

class Hamming(FilteringWindowsImplementation):
    """
    Hamming filtering windows.

    Available constructors:
        Hamming()
       


    Notes
    -----
    The Hamming windows is implemented using the formula:

    .. math::

        w(t) =  C(\\alpha - (1-\\alpha)\\cos(2\\pi t))\\fcar{[0,1]}{t}

    with :math:`C = \\frac{1}{\\alpha^2 + (1-\\alpha)^2/2}` and :math:`\\alpha=25/46`.

    The value of :math:`\\alpha` minimizes the amplitude of the first side lobe of its Fourier transform.

    The normalization constant :math:`C` is such that :math:`\\int_{0}^{1} w(t)^2\\di{t} = 1`.

    """
    __swig_setmethods__ = {}
    for _s in [FilteringWindowsImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Hamming, name, value)
    __swig_getmethods__ = {}
    for _s in [FilteringWindowsImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Hamming, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Hamming_getClassName(self)

    def __repr__(self): return _statistics.Hamming___repr__(self)
    def __str__(self, offset=""): return _statistics.Hamming___str__(self, offset)
    def __call__(self, *args): return _statistics.Hamming___call__(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_Hamming(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Hamming
    __del__ = lambda self : None;
Hamming_swigregister = _statistics.Hamming_swigregister
Hamming_swigregister(Hamming)

class Hanning(FilteringWindowsImplementation):
    """
    Hanning filtering windows.

    Available constructors:
        Hanning()
       


    Notes
    -----
    The Hanning windows is implemented using the formula:

    .. math::

        w(t) =  \\sqrt{\\dfrac{8}{3}} \\sin(\\pi t)^2\\fcar{[0,1]}{t}


    """
    __swig_setmethods__ = {}
    for _s in [FilteringWindowsImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Hanning, name, value)
    __swig_getmethods__ = {}
    for _s in [FilteringWindowsImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Hanning, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Hanning_getClassName(self)

    def __repr__(self): return _statistics.Hanning___repr__(self)
    def __str__(self, offset=""): return _statistics.Hanning___str__(self, offset)
    def __call__(self, *args): return _statistics.Hanning___call__(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_Hanning(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_Hanning
    __del__ = lambda self : None;
Hanning_swigregister = _statistics.Hanning_swigregister
Hanning_swigregister(Hanning)

class FFTImplementation(openturns.common.PersistentObject):
    """
    Base class for Fast Fourier Transform (FFT) and Inverse Fast Fourier Transform (IFFT).

    Notes
    -----
    Perform FFT and IFFT with array of ndim=1,2,3

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FFTImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FFTImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FFTImplementation_getClassName(self)

    def transform(self, *args):
        """
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.NumericalComplexCollection` or :class:`~openturns.NumericalScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.NumericalComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} x_n exp(-2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _statistics.FFTImplementation_transform(self, *args)

    def inverseTransform(self, *args):
        """
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.NumericalComplexCollection` or :class:`~openturns.NumericalScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.NumericalComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} \\frac{1}{N} x_n exp(2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.NumericalComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _statistics.FFTImplementation_inverseTransform(self, *args)

    def transform2D(self, *args):
        """
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _statistics.FFTImplementation_transform2D(self, *args)

    def inverseTransform2D(self, *args):
        """
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l}} = \\frac{1}{M\\times N}\\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _statistics.FFTImplementation_inverseTransform2D(self, *args)

    def transform3D(self, *args):
        """
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N}) exp(-2 i \\pi \\frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _statistics.FFTImplementation_transform3D(self, *args)

    def inverseTransform3D(self, *args):
        """
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} \\frac{1}{M\\times N \\times P} Z_{m,n,p} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N}) exp(2 i \\pi \\frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _statistics.FFTImplementation_inverseTransform3D(self, *args)

    def __repr__(self): return _statistics.FFTImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.FFTImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_FFTImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_FFTImplementation
    __del__ = lambda self : None;
FFTImplementation_swigregister = _statistics.FFTImplementation_swigregister
FFTImplementation_swigregister(FFTImplementation)

class FFTImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FFTImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FFTImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_FFTImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.FFTImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_FFTImplementationTypedInterfaceObject
    __del__ = lambda self : None;
FFTImplementationTypedInterfaceObject_swigregister = _statistics.FFTImplementationTypedInterfaceObject_swigregister
FFTImplementationTypedInterfaceObject_swigregister(FFTImplementationTypedInterfaceObject)

class FFT(FFTImplementationTypedInterfaceObject):
    """
    Base class for Fast Fourier Transform (FFT) and Inverse Fast Fourier Transform (IFFT).

    Notes
    -----
    Perform FFT and IFFT with array of ndim=1,2,3

    """
    __swig_setmethods__ = {}
    for _s in [FFTImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FFT, name, value)
    __swig_getmethods__ = {}
    for _s in [FFTImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FFT, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FFT_getClassName(self)

    def transform(self, *args):
        """
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.NumericalComplexCollection` or :class:`~openturns.NumericalScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.NumericalComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} x_n exp(-2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _statistics.FFT_transform(self, *args)

    def transform2D(self, *args):
        """
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _statistics.FFT_transform2D(self, *args)

    def transform3D(self, *args):
        """
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\\rm Z_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \\pi \\frac{km}{M}) exp(-2 i \\pi \\frac{ln}{N}) exp(-2 i \\pi \\frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _statistics.FFT_transform3D(self, *args)

    def inverseTransform(self, *args):
        """
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.NumericalComplexCollection` or :class:`~openturns.NumericalScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.NumericalComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm y_k} = \\sum_{n=0}^{N-1} \\frac{1}{N} x_n exp(2 i \\pi \\frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.NumericalComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _statistics.FFT_inverseTransform(self, *args)

    def inverseTransform2D(self, *args):
        """
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l}} = \\frac{1}{M\\times N}\\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _statistics.FFT_inverseTransform2D(self, *args)

    def inverseTransform3D(self, *args):
        """
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\\rm Y_{k,l,r}} = \\sum_{m=0}^{M-1}\\sum_{n=0}^{N-1}\\sum_{p=0}^{P-1} \\frac{1}{M\\times N \\times P} Z_{m,n,p} exp(2 i \\pi \\frac{km}{M}) exp(2 i \\pi \\frac{ln}{N}) exp(2 i \\pi \\frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _statistics.FFT_inverseTransform3D(self, *args)

    def __repr__(self): return _statistics.FFT___repr__(self)
    def __str__(self, offset=""): return _statistics.FFT___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_FFT(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_FFT
    __del__ = lambda self : None;
FFT_swigregister = _statistics.FFT_swigregister
FFT_swigregister(FFT)

class SpectralModelImplementation(openturns.common.PersistentObject):
    """
    Spectral density model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    If the process is a second order process, zero-mean and weakly **stationary**, we define its *bilateral spectral density function*
    :math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` with:

    - :math:`\\cH^+(d) \\in \\cM^+(d)(\\Cset)` is the set of *d-dimensional* positive hermitian matrices

    Using the *stationary covariance function* :math:`C^{stat}` with :math:`C^{stat} : \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` and the Fourier transform, the spectral density writes:


    .. math::

       \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\int_{\\Rset^n} \\exp\\left(-2i \\pi <\\vect{f}, \\vect{\\tau}>\\right) C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}

    A SpectralModel object can be created only through its derived classes:
    :class:`~openturns.CauchyModel`
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelImplementation_getClassName(self)

    def getDimension(self):
        """
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementation_getDimension(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementation_getSpatialDimension(self)

    def __call__(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModelImplementation___call__(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SpectralModelImplementation_computeStandardRepresentative(self, *args)

    def getFrequencyGrid(self):
        """
        Return the RegularGrid associated to the SpectralModel.

        Returns
        -------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModelImplementation_getFrequencyGrid(self)

    def setFrequencyGrid(self, *args):
        """
        Set the RegularGrid associated to the SpectralModel.

        Parameters
        ----------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModelImplementation_setFrequencyGrid(self, *args)

    def getAmplitude(self):
        """
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The used amplitude parameter.
        """
        return _statistics.SpectralModelImplementation_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModelImplementation_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The used scale parameter.
        """
        return _statistics.SpectralModelImplementation_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModelImplementation_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\mathcal{M}_{dimension \\times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModelImplementation_getSpatialCorrelation(self)

    def __repr__(self): return _statistics.SpectralModelImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.SpectralModelImplementation___str__(self, offset)
    def draw(self, rowIndex=0, columnIndex=0, module=True):
        """
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int
            i-th row component to draw.
            Default value is 0

        columnIndex : int
            j-th column component to draw .
            Default value is 0

        module : bool
            Tells if module has to be drawn(True) or if it is
            the argument to be drawn (False).
            Default value is True.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        Notes
        -----
        The method plots a specific component of the spectral density function over a frequency grid. Thus, this last one should be specified thanks to the `setFrequencyGrid` method.
        """
        return _statistics.SpectralModelImplementation_draw(self, rowIndex, columnIndex, module)

    def __init__(self, *args): 
        this = _statistics.new_SpectralModelImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SpectralModelImplementation
    __del__ = lambda self : None;
SpectralModelImplementation_swigregister = _statistics.SpectralModelImplementation_swigregister
SpectralModelImplementation_swigregister(SpectralModelImplementation)

class SpectralModelImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_SpectralModelImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.SpectralModelImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_SpectralModelImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SpectralModelImplementationTypedInterfaceObject_swigregister = _statistics.SpectralModelImplementationTypedInterfaceObject_swigregister
SpectralModelImplementationTypedInterfaceObject_swigregister(SpectralModelImplementationTypedInterfaceObject)

class SpectralModel(SpectralModelImplementationTypedInterfaceObject):
    """
    Spectral density model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    If the process is a second order process, zero-mean and weakly **stationary**, we define its *bilateral spectral density function*
    :math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` with:

    - :math:`\\cH^+(d) \\in \\cM^+(d)(\\Cset)` is the set of *d-dimensional* positive hermitian matrices

    Using the *stationary covariance function* :math:`C^{stat}` with :math:`C^{stat} : \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` and the Fourier transform, the spectral density writes:


    .. math::

       \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\int_{\\Rset^n} \\exp\\left(-2i \\pi <\\vect{f}, \\vect{\\tau}>\\right) C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}

    A SpectralModel object can be created only through its derived classes:
    :class:`~openturns.CauchyModel`
    """
    __swig_setmethods__ = {}
    for _s in [SpectralModelImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModel, name, value)
    __swig_getmethods__ = {}
    for _s in [SpectralModelImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModel_getClassName(self)

    def getDimension(self):
        """
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModel_getDimension(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModel_getSpatialDimension(self)

    def __call__(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModel___call__(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SpectralModel_computeStandardRepresentative(self, *args)

    def getFrequencyGrid(self):
        """
        Return the RegularGrid associated to the SpectralModel.

        Returns
        -------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModel_getFrequencyGrid(self)

    def setFrequencyGrid(self, *args):
        """
        Set the RegularGrid associated to the SpectralModel.

        Parameters
        ----------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModel_setFrequencyGrid(self, *args)

    def draw(self, rowIndex=0, columnIndex=0, module=True):
        """
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int
            i-th row component to draw.
            Default value is 0

        columnIndex : int
            j-th column component to draw .
            Default value is 0

        module : bool
            Tells if module has to be drawn(True) or if it is
            the argument to be drawn (False).
            Default value is True.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        Notes
        -----
        The method plots a specific component of the spectral density function over a frequency grid. Thus, this last one should be specified thanks to the `setFrequencyGrid` method.
        """
        return _statistics.SpectralModel_draw(self, rowIndex, columnIndex, module)

    def getAmplitude(self):
        """
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The used amplitude parameter.
        """
        return _statistics.SpectralModel_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModel_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The used scale parameter.
        """
        return _statistics.SpectralModel_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModel_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\mathcal{M}_{dimension \\times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModel_getSpatialCorrelation(self)

    def __repr__(self): return _statistics.SpectralModel___repr__(self)
    def __str__(self, offset=""): return _statistics.SpectralModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_SpectralModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SpectralModel
    __del__ = lambda self : None;
SpectralModel_swigregister = _statistics.SpectralModel_swigregister
SpectralModel_swigregister(SpectralModel)

class CovarianceModelImplementation(openturns.common.PersistentObject):
    """
    Covariance model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    If the process is a second order process, we note:

    - :math:`m : \\cD \\mapsto  \\Rset^d` its *mean function*, defined by
      :math:`m(\\vect{t})=\\Expect{X_{\\vect{t}}}`,
    - :math:`C : \\cD \\times \\cD \\mapsto  \\cS_d^+(\\Rset)` its
      *covariance function*, defined by
      :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}`,
    - :math:`R : \\cD \\times \\cD \\mapsto  \\cS_d^+(\\Rset)` its
      *correlation function*, defined for all :math:`(\\vect{s}, \\vect{t})`,
      by :math:`R(\\vect{s}, \\vect{t})` such that for all :math:`(i,j)`,
      :math:`R_{ij}(\\vect{s}, \\vect{t})=C_{ij}(\\vect{s}, \\vect{t})/\\sqrt{C_{ii}(\\vect{s}, \\vect{t})C_{jj}(\\vect{s}, \\vect{t})}`.


    In a general way, the covariance models write:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\mat{L}_{\\rho}\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                \\dfrac{\\vect{t}}{\\theta}\\right)\\, 
                                \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\, 
                                \\mbox{Diag}(\\vect{\\sigma}) \\, 
                                \\Tr{\\mat{L}}_{\\rho}\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                \\dfrac{\\vect{t}}{\\theta}\\right), \\quad 
                                \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    where:

    - :math:`\\vect{\\theta} \\in \\Rset^n` is the *scale* parameter
    - :math:`\\vect{\\sigma} \\in \\Rset^d` id the *amplitude* parameter
    - :math:`\\mat{L}_{\\rho}(\\vect{s}, \\vect{t})` is the Cholesky factor of 
      :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})`: 

    .. math::

        \\mat{L}_{\\rho}(\\vect{s}, \\vect{t})\\,\\Tr{\\mat{L}_{\\rho}(\\vect{s}, \\vect{t})}
        = \\mat{\\rho}(\\vect{s}, \\vect{t})

    The correlation function :math:`\\mat{\\rho}` may depend on additional
    specific parameters which are not made explicit here.

    The global correlation is given by two separate correlations: 

        - the spatial correlation between the components of :math:`X_{\\vect{t}}`
          which is given by the correlation matrix
          :math:`\\mat{R} \\in \\cS_d^+(\\Rset)` and the vector of marginal variances
          :math:`\\vect{\\sigma} \\in \\Rset^d`.
          The spatial correlation does not depend on :math:`\\vect{t} \\in \\cD`.
          For each  :math:`\\vect{t}`, it links together the components of
          :math:`X_{\\vect{t}}`.
        - the correlation between :math:`X_{\\vect{s}}` and  :math:`X_{\\vect{t}}`
          which is given by :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})`. 

            - In the general case, the correlation links each component
              :math:`X^i_{\\vect{t}}` to all the components of :math:`X_{\\vect{s}}`
              and :math:`\\mat{\\rho}(\\vect{s}, \\vect{t}) \\in \\cS_d^+(\\Rset)`;

            - In some particular cases, the correlation is such that
              :math:`X^i_{\\vect{t}}` depends only on the component
              :math:`X^i_{\\vect{s}}` and that link does not depend on the component
              :math:`i`. In that case, :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})` can be
              defined from the scalar function :math:`\\rho(\\vect{s}, \\vect{t})` by
              :math:`\\mat{\\rho}(\\vect{s}, \\vect{t}) = \\rho(\\vect{s}, \\vect{t})\\, \\mat{I}_d`.
              Then, the covariance model writes:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\rho\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                          \\dfrac{\\vect{t}}{\\theta}\\right)\\,
                                \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\,
                                \\mbox{Diag}(\\vect{\\sigma}), \\quad
                                \\forall (\\vect{s}, \\vect{t}) \\in \\cD



    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelImplementation_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension :math:`n` of the covariance function.

        Returns
        -------
        spatialDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \\cD \\times \\cD \\mapsto \\cS_d^+(\\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModelImplementation_getDimension(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.CovarianceModelImplementation_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModelImplementation___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.CovarianceModelImplementation_computeAsScalar(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_partialGradient(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.CovarianceModelImplementation_discretize(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.CovarianceModelImplementation_discretizeRow(self, *args)

    def discretizeAndFactorize(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\\in \\cM_{nd\\times nd}(\\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModelImplementation_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        """
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\\in\\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementation_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementation_discretizeAndFactorizeHMatrix(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.CovarianceModelImplementation_isStationary(self)

    def isDiagonal(self):
        """
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModelImplementation_isDiagonal(self)

    def getAmplitude(self):
        """
        Get the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModelImplementation_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModelImplementation_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+(\\Rset)`.
        """
        return _statistics.CovarianceModelImplementation_getSpatialCorrelation(self)

    def setSpatialCorrelation(self, *args):
        """
        Set the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModelImplementation_setSpatialCorrelation(self, *args)

    def setNuggetFactor(self, *args):
        """
        Set the nugget factor for the regularization.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used for the regularization of the discretized
            covariance matrix.
        """
        return _statistics.CovarianceModelImplementation_setNuggetFactor(self, *args)

    def getNuggetFactor(self):
        """
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used for the regularization of the discretized covariance
            matrix.
        """
        return _statistics.CovarianceModelImplementation_getNuggetFactor(self)

    def setParameter(self, *args):
        """
        Set the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModelImplementation_setParameter(self, *args)

    def getParameter(self):
        """
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPoint`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModelImplementation_getParameter(self)

    def getParameterDescription(self):
        """
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModelImplementation_getParameterDescription(self)

    def setActiveParameter(self, *args):
        """
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementation_setActiveParameter(self, *args)

    def getActiveParameter(self):
        """
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementation_getActiveParameter(self)

    def __repr__(self): return _statistics.CovarianceModelImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModelImplementation___str__(self, offset)
    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.CovarianceModelImplementation_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementation
    __del__ = lambda self : None;
CovarianceModelImplementation_swigregister = _statistics.CovarianceModelImplementation_swigregister
CovarianceModelImplementation_swigregister(CovarianceModelImplementation)

class CovarianceModelImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.CovarianceModelImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementationTypedInterfaceObject
    __del__ = lambda self : None;
CovarianceModelImplementationTypedInterfaceObject_swigregister = _statistics.CovarianceModelImplementationTypedInterfaceObject_swigregister
CovarianceModelImplementationTypedInterfaceObject_swigregister(CovarianceModelImplementationTypedInterfaceObject)

class CovarianceModelCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelCollection, name)
    __swig_destroy__ = _statistics.delete_CovarianceModelCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _statistics.CovarianceModelCollection_clear(self)

    def __len__(self): return _statistics.CovarianceModelCollection___len__(self)
    def __eq__(self, *args): return _statistics.CovarianceModelCollection___eq__(self, *args)
    def __contains__(self, *args): return _statistics.CovarianceModelCollection___contains__(self, *args)
    def __getitem__(self, *args): return _statistics.CovarianceModelCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _statistics.CovarianceModelCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _statistics.CovarianceModelCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _statistics.CovarianceModelCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _statistics.CovarianceModelCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _statistics.CovarianceModelCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _statistics.CovarianceModelCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _statistics.CovarianceModelCollection_isEmpty(self)

    def __repr__(self): return _statistics.CovarianceModelCollection___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModelCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelCollection(*args)
        try: self.this.append(this)
        except: self.this = this
CovarianceModelCollection_swigregister = _statistics.CovarianceModelCollection_swigregister
CovarianceModelCollection_swigregister(CovarianceModelCollection)

class CovarianceModel(CovarianceModelImplementationTypedInterfaceObject):
    """
    Covariance model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    If the process is a second order process, we note:

    - :math:`m : \\cD \\mapsto  \\Rset^d` its *mean function*, defined by
      :math:`m(\\vect{t})=\\Expect{X_{\\vect{t}}}`,
    - :math:`C : \\cD \\times \\cD \\mapsto  \\cS_d^+(\\Rset)` its
      *covariance function*, defined by
      :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}`,
    - :math:`R : \\cD \\times \\cD \\mapsto  \\cS_d^+(\\Rset)` its
      *correlation function*, defined for all :math:`(\\vect{s}, \\vect{t})`,
      by :math:`R(\\vect{s}, \\vect{t})` such that for all :math:`(i,j)`,
      :math:`R_{ij}(\\vect{s}, \\vect{t})=C_{ij}(\\vect{s}, \\vect{t})/\\sqrt{C_{ii}(\\vect{s}, \\vect{t})C_{jj}(\\vect{s}, \\vect{t})}`.


    In a general way, the covariance models write:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\mat{L}_{\\rho}\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                \\dfrac{\\vect{t}}{\\theta}\\right)\\, 
                                \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\, 
                                \\mbox{Diag}(\\vect{\\sigma}) \\, 
                                \\Tr{\\mat{L}}_{\\rho}\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                \\dfrac{\\vect{t}}{\\theta}\\right), \\quad 
                                \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    where:

    - :math:`\\vect{\\theta} \\in \\Rset^n` is the *scale* parameter
    - :math:`\\vect{\\sigma} \\in \\Rset^d` id the *amplitude* parameter
    - :math:`\\mat{L}_{\\rho}(\\vect{s}, \\vect{t})` is the Cholesky factor of 
      :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})`: 

    .. math::

        \\mat{L}_{\\rho}(\\vect{s}, \\vect{t})\\,\\Tr{\\mat{L}_{\\rho}(\\vect{s}, \\vect{t})}
        = \\mat{\\rho}(\\vect{s}, \\vect{t})

    The correlation function :math:`\\mat{\\rho}` may depend on additional
    specific parameters which are not made explicit here.

    The global correlation is given by two separate correlations: 

        - the spatial correlation between the components of :math:`X_{\\vect{t}}`
          which is given by the correlation matrix
          :math:`\\mat{R} \\in \\cS_d^+(\\Rset)` and the vector of marginal variances
          :math:`\\vect{\\sigma} \\in \\Rset^d`.
          The spatial correlation does not depend on :math:`\\vect{t} \\in \\cD`.
          For each  :math:`\\vect{t}`, it links together the components of
          :math:`X_{\\vect{t}}`.
        - the correlation between :math:`X_{\\vect{s}}` and  :math:`X_{\\vect{t}}`
          which is given by :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})`. 

            - In the general case, the correlation links each component
              :math:`X^i_{\\vect{t}}` to all the components of :math:`X_{\\vect{s}}`
              and :math:`\\mat{\\rho}(\\vect{s}, \\vect{t}) \\in \\cS_d^+(\\Rset)`;

            - In some particular cases, the correlation is such that
              :math:`X^i_{\\vect{t}}` depends only on the component
              :math:`X^i_{\\vect{s}}` and that link does not depend on the component
              :math:`i`. In that case, :math:`\\mat{\\rho}(\\vect{s}, \\vect{t})` can be
              defined from the scalar function :math:`\\rho(\\vect{s}, \\vect{t})` by
              :math:`\\mat{\\rho}(\\vect{s}, \\vect{t}) = \\rho(\\vect{s}, \\vect{t})\\, \\mat{I}_d`.
              Then, the covariance model writes:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\rho\\left(\\dfrac{\\vect{s}}{\\theta}, 
                                          \\dfrac{\\vect{t}}{\\theta}\\right)\\,
                                \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\,
                                \\mbox{Diag}(\\vect{\\sigma}), \\quad
                                \\forall (\\vect{s}, \\vect{t}) \\in \\cD



    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModel_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension :math:`n` of the covariance function.

        Returns
        -------
        spatialDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModel_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \\cD \\times \\cD \\mapsto \\cS_d^+(\\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModel_getDimension(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.CovarianceModel_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModel___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.CovarianceModel_computeAsScalar(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModel_partialGradient(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.CovarianceModel_discretize(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.CovarianceModel_discretizeRow(self, *args)

    def discretizeAndFactorize(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\\in \\cM_{nd\\times nd}(\\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModel_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        """
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\\in\\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModel_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModel_discretizeAndFactorizeHMatrix(self, *args)

    def getAmplitude(self):
        """
        Get the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModel_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModel_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModel_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.CovarianceModel_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+(\\Rset)`.
        """
        return _statistics.CovarianceModel_getSpatialCorrelation(self)

    def setSpatialCorrelation(self, *args):
        """
        Set the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModel_setSpatialCorrelation(self, *args)

    def setNuggetFactor(self, *args):
        """
        Set the nugget factor for the regularization.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used for the regularization of the discretized
            covariance matrix.
        """
        return _statistics.CovarianceModel_setNuggetFactor(self, *args)

    def getNuggetFactor(self):
        """
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used for the regularization of the discretized covariance
            matrix.
        """
        return _statistics.CovarianceModel_getNuggetFactor(self)

    def setParameter(self, *args):
        """
        Set the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModel_setParameter(self, *args)

    def getParameter(self):
        """
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPoint`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModel_getParameter(self)

    def getParameterDescription(self):
        """
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModel_getParameterDescription(self)

    def setActiveParameter(self, *args):
        """
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModel_setActiveParameter(self, *args)

    def getActiveParameter(self):
        """
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModel_getActiveParameter(self)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.CovarianceModel_isStationary(self)

    def isDiagonal(self):
        """
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModel_isDiagonal(self)

    def __repr__(self): return _statistics.CovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModel___str__(self, offset)
    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.CovarianceModel_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_CovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CovarianceModel
    __del__ = lambda self : None;
CovarianceModel_swigregister = _statistics.CovarianceModel_swigregister
CovarianceModel_swigregister(CovarianceModel)

class StationaryCovarianceModel(CovarianceModelImplementation):
    """Proxy of C++ OT::StationaryCovarianceModel"""
    __swig_setmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StationaryCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, StationaryCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.StationaryCovarianceModel___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.StationaryCovarianceModel_computeAsScalar(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.StationaryCovarianceModel_computeStandardRepresentative(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.StationaryCovarianceModel_discretize(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.StationaryCovarianceModel_isStationary(self)

    def __repr__(self): return _statistics.StationaryCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.StationaryCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_StationaryCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModel
    __del__ = lambda self : None;
StationaryCovarianceModel_swigregister = _statistics.StationaryCovarianceModel_swigregister
StationaryCovarianceModel_swigregister(StationaryCovarianceModel)

class SecondOrderModelImplementation(openturns.common.PersistentObject):
    """
    Second order model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    The *SecondOrderModel* class enable to get both spectral information of such process thanks to the :class:`SpectralModel` class and spatial/temporal information using the :class:`CovarianceModel` information.

    A SecondOrderModel object can be created only through its derived classes:
    :class:`~openturns.ExponentialCauchy`
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SecondOrderModelImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SecondOrderModelImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SecondOrderModelImplementation_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModelImplementation_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the *SecondOrderModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModelImplementation_getDimension(self)

    def computeCovariance(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            computeCovariance(s, t)

            computeCovariance(tau)

        Parameters
        ----------
        s, t : floats or sequence of floats.
            Inputs.
        tau : float or sequence of floats.
            Input.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.

        Notes
        -----
        *computeCovariance* evaluates the covariance model
        :math:`C : \\cD \\times \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` at
        :math:`(s,t)\\in \\Rset^n`:

        .. math::

            C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}


        We note that the first usage calls the second as model is stationary. Thus,
         :math:`C(\\vect{s}, \\vect{t})` = :math:`C^{stat}(\\vect{\\tau})` with
         :math:`\\vect{\\tau}=\\vect{s}-\\vect{t}`. 
        """
        return _statistics.SecondOrderModelImplementation_computeCovariance(self, *args)

    def getSpectralModel(self):
        """
        Return the spectral model.

        Returns
        -------
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModelImplementation_getSpectralModel(self)

    def getCovarianceModel(self):
        """
        Return the covariance model.

        Returns
        -------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        """
        return _statistics.SecondOrderModelImplementation_getCovarianceModel(self)

    def setModels(self, *args):
        """
        Set both the covariance and spectral models of a second order model.

        Parameters
        ----------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModelImplementation_setModels(self, *args)

    def discretize(self, *args):
        """
        Discretize the second order  on a given RegularGrid/Mesh model using its covariance function.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in\\cM_{nd\\times nd}(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the covariance model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.SecondOrderModelImplementation_discretize(self, *args)

    def computeSpectralDensity(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.

        Notes
        -----
        *computeSpectralDensity* evaluates the spectral model :math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` at :math:`f\\in \\Rset^n`:

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SecondOrderModelImplementation_computeSpectralDensity(self, *args)

    def __repr__(self): return _statistics.SecondOrderModelImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.SecondOrderModelImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_SecondOrderModelImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SecondOrderModelImplementation
    __del__ = lambda self : None;
SecondOrderModelImplementation_swigregister = _statistics.SecondOrderModelImplementation_swigregister
SecondOrderModelImplementation_swigregister(SecondOrderModelImplementation)

class ExponentialCauchy(SecondOrderModelImplementation):
    """
    Absolute exponential covariance model.

    Available constructors:

        ExponentialCauchy(*theta, sigma*)

    Parameters
    ----------
    theta : sequence of floats
        Scale coefficients.
        The spatial dimension is the size of vector.
    sigma : sequence of floats
        Amplitude coefficients :math:`\\sigma`.
        Should be of size 1

    Notes
    -----
    The second order model instanciate both a :class:`openturns.AbsoluteExponential` as covariance function and :class:`openturns.CauchyModel` as
    spectral model.

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.ExponentialCauchy([10.0, 10.0], [1.0])
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(model.computeCovariance(s, t))
    [[ 0.980199 ]]
    >>> tau = [0.1, 0.3]
    >>> print(model.computeCovariance(tau))
    [[ 0.960789 ]]
    >>> f = 0.3
    >>> print(model.computeSpectralDensity(f))
    [[ (0.00315075,0) ]]
    >>> f = 10
    >>> print(model.computeSpectralDensity(f))
    [[ (2.56648e-09,0) ]]
    """
    __swig_setmethods__ = {}
    for _s in [SecondOrderModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExponentialCauchy, name, value)
    __swig_getmethods__ = {}
    for _s in [SecondOrderModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExponentialCauchy, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ExponentialCauchy_getClassName(self)

    def __repr__(self): return _statistics.ExponentialCauchy___repr__(self)
    def __str__(self, offset=""): return _statistics.ExponentialCauchy___str__(self, offset)
    def getAmplitude(self):
        """
        Get the amplitude parameter of the second order model.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The used amplitude parameter.
        """
        return _statistics.ExponentialCauchy_getAmplitude(self)

    def getScale(self):
        """
        Get the scale parameter of the second order model.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The used scale parameter.
        """
        return _statistics.ExponentialCauchy_getScale(self)

    def __init__(self, *args): 
        this = _statistics.new_ExponentialCauchy(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_ExponentialCauchy
    __del__ = lambda self : None;
ExponentialCauchy_swigregister = _statistics.ExponentialCauchy_swigregister
ExponentialCauchy_swigregister(ExponentialCauchy)

class SecondOrderModelImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SecondOrderModelImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SecondOrderModelImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_SecondOrderModelImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.SecondOrderModelImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SecondOrderModelImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SecondOrderModelImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.SecondOrderModelImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_SecondOrderModelImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SecondOrderModelImplementationTypedInterfaceObject_swigregister = _statistics.SecondOrderModelImplementationTypedInterfaceObject_swigregister
SecondOrderModelImplementationTypedInterfaceObject_swigregister(SecondOrderModelImplementationTypedInterfaceObject)

class SecondOrderModel(SecondOrderModelImplementationTypedInterfaceObject):
    """
    Second order model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\\omega \\in \\Omega`
    is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`,
    :math:`\\vect{t}\\in \\cD` is a multivariate index and
    :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    We note :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by
    :math:`X_{\\vect{t}}(\\omega)=X(\\omega, \\vect{t})` and
    :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` a realization of the process
    :math:`X`, for a given :math:`\\omega \\in \\Omega` defined by
    :math:`X(\\omega)(\\vect{t})=X(\\omega, \\vect{t})`.

    The *SecondOrderModel* class enable to get both spectral information of such process thanks to the :class:`SpectralModel` class and spatial/temporal information using the :class:`CovarianceModel` information.

    A SecondOrderModel object can be created only through its derived classes:
    :class:`~openturns.ExponentialCauchy`
    """
    __swig_setmethods__ = {}
    for _s in [SecondOrderModelImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SecondOrderModel, name, value)
    __swig_getmethods__ = {}
    for _s in [SecondOrderModelImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SecondOrderModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SecondOrderModel_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModel_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the *SecondOrderModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModel_getDimension(self)

    def getSpectralModel(self):
        """
        Return the spectral model.

        Returns
        -------
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModel_getSpectralModel(self)

    def getCovarianceModel(self):
        """
        Return the covariance model.

        Returns
        -------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        """
        return _statistics.SecondOrderModel_getCovarianceModel(self)

    def setModels(self, *args):
        """
        Set both the covariance and spectral models of a second order model.

        Parameters
        ----------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModel_setModels(self, *args)

    def computeCovariance(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            computeCovariance(s, t)

            computeCovariance(tau)

        Parameters
        ----------
        s, t : floats or sequence of floats.
            Inputs.
        tau : float or sequence of floats.
            Input.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.

        Notes
        -----
        *computeCovariance* evaluates the covariance model
        :math:`C : \\cD \\times \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` at
        :math:`(s,t)\\in \\Rset^n`:

        .. math::

            C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}


        We note that the first usage calls the second as model is stationary. Thus,
         :math:`C(\\vect{s}, \\vect{t})` = :math:`C^{stat}(\\vect{\\tau})` with
         :math:`\\vect{\\tau}=\\vect{s}-\\vect{t}`. 
        """
        return _statistics.SecondOrderModel_computeCovariance(self, *args)

    def computeSpectralDensity(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.

        Notes
        -----
        *computeSpectralDensity* evaluates the spectral model :math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` at :math:`f\\in \\Rset^n`:

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SecondOrderModel_computeSpectralDensity(self, *args)

    def discretize(self, *args):
        """
        Discretize the second order  on a given RegularGrid/Mesh model using its covariance function.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in\\cM_{nd\\times nd}(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the covariance model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.SecondOrderModel_discretize(self, *args)

    def __repr__(self): return _statistics.SecondOrderModel___repr__(self)
    def __str__(self, offset=""): return _statistics.SecondOrderModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_SecondOrderModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SecondOrderModel
    __del__ = lambda self : None;
SecondOrderModel_swigregister = _statistics.SecondOrderModel_swigregister
SecondOrderModel_swigregister(SecondOrderModel)

class SpectralModelFactoryImplementation(openturns.common.PersistentObject):
    """
    Base class for spectral model factory.

    Parameters
    ----------
    mySpectralModelFactoryImplementation : :class:`~openturns.SpectralModelFactoryImplementation`
        One spectral factory algorithm.

        By default, the Welch factory algorithm :class:`~openturns.WelchFactory`.
       
    Notes
    -----
    Let :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\\cD \\in \\Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (*n=1*).

    If we note :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \\Rset^n \\rightarrow \\Rset^n` is :math:`\\cL^1(\\Rset^n)` (ie :math:`\\int_{\\Rset^n} |C^{stat}_{i,j}(\\vect{\\tau})|\\di{\\vect{\\tau}}\\, < +\\infty`), with :math:`C^{stat}(\\vect{\\tau}) = C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as this quantity does not depend on :math:`\\vect{s}`. 

    The bilateral spectral density function :math:`S : \\Rset^n \\rightarrow \\mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \\forall \\vect{f} \\in \\Rset^n, \\,S(\\vect{f}) = \\int_{\\Rset^n}\\exp\\left\\{-2i\\pi <\\vect{f},\\vect{\\tau}> \\right\\} C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}


    where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    Depending on the available data, we proceed differently :

        -if the data correspond to  several independent  realizations of the  process, the estimation is done using the empirical estimator;

        - if the data correspond to one realization of the  process,  we suppose the process is ergodic to split the realization into several ones.

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelFactoryImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelFactoryImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelFactoryImplementation_getClassName(self)

    def getFrequencyGrid(self):
        """
        Accessor to the frequency grid.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid` 
            Grid on which the  spectral model is estimated.
         
        """
        return _statistics.SpectralModelFactoryImplementation_getFrequencyGrid(self)

    def setFrequencyGrid(self, *args):
        """
        Accessor to the frequency grid.

        Parameters
        ----------
        freqGrid : :class:`~openturns.RegularGrid` 
            Grid on which the  spectral model is estimated.
         
        """
        return _statistics.SpectralModelFactoryImplementation_setFrequencyGrid(self, *args)

    def getFFTAlgorithm(self):
        """
        Accessor to the FFT algorithm used for the Fourier transform.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.
         
        """
        return _statistics.SpectralModelFactoryImplementation_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, *args):
        """
        Accessor to the FFT algorithm used for the Fourier transform.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.
         
        """
        return _statistics.SpectralModelFactoryImplementation_setFFTAlgorithm(self, *args)

    def __repr__(self): return _statistics.SpectralModelFactoryImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.SpectralModelFactoryImplementation___str__(self, offset)
    def build(self, *args):
        """
        Estimate the spectral model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the spectral model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the spectral model is estimated.

        Returns
        -------
        mySpectralModel : :class:`~openturns.SpectralModel`
            The estimated spectral model.
         
        """
        return _statistics.SpectralModelFactoryImplementation_build(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_SpectralModelFactoryImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SpectralModelFactoryImplementation
    __del__ = lambda self : None;
SpectralModelFactoryImplementation_swigregister = _statistics.SpectralModelFactoryImplementation_swigregister
SpectralModelFactoryImplementation_swigregister(SpectralModelFactoryImplementation)

class SpectralModelFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelFactoryImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelFactoryImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_SpectralModelFactoryImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_SpectralModelFactoryImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SpectralModelFactoryImplementationTypedInterfaceObject_swigregister = _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_swigregister
SpectralModelFactoryImplementationTypedInterfaceObject_swigregister(SpectralModelFactoryImplementationTypedInterfaceObject)

class SpectralModelFactory(SpectralModelFactoryImplementationTypedInterfaceObject):
    """
    Base class for spectral model factory.

    Parameters
    ----------
    mySpectralModelFactoryImplementation : :class:`~openturns.SpectralModelFactoryImplementation`
        One spectral factory algorithm.

        By default, the Welch factory algorithm :class:`~openturns.WelchFactory`.
       
    Notes
    -----
    Let :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\\cD \\in \\Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (*n=1*).

    If we note :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \\Rset^n \\rightarrow \\Rset^n` is :math:`\\cL^1(\\Rset^n)` (ie :math:`\\int_{\\Rset^n} |C^{stat}_{i,j}(\\vect{\\tau})|\\di{\\vect{\\tau}}\\, < +\\infty`), with :math:`C^{stat}(\\vect{\\tau}) = C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as this quantity does not depend on :math:`\\vect{s}`. 

    The bilateral spectral density function :math:`S : \\Rset^n \\rightarrow \\mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \\forall \\vect{f} \\in \\Rset^n, \\,S(\\vect{f}) = \\int_{\\Rset^n}\\exp\\left\\{-2i\\pi <\\vect{f},\\vect{\\tau}> \\right\\} C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}


    where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    Depending on the available data, we proceed differently :

        -if the data correspond to  several independent  realizations of the  process, the estimation is done using the empirical estimator;

        - if the data correspond to one realization of the  process,  we suppose the process is ergodic to split the realization into several ones.

    """
    __swig_setmethods__ = {}
    for _s in [SpectralModelFactoryImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [SpectralModelFactoryImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelFactory_getClassName(self)

    def getFrequencyGrid(self):
        """
        Accessor to the frequency grid.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid` 
            Grid on which the  spectral model is estimated.
         
        """
        return _statistics.SpectralModelFactory_getFrequencyGrid(self)

    def setFrequencyGrid(self, *args):
        """
        Accessor to the frequency grid.

        Parameters
        ----------
        freqGrid : :class:`~openturns.RegularGrid` 
            Grid on which the  spectral model is estimated.
         
        """
        return _statistics.SpectralModelFactory_setFrequencyGrid(self, *args)

    def getFFTAlgorithm(self):
        """
        Accessor to the FFT algorithm used for the Fourier transform.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.
         
        """
        return _statistics.SpectralModelFactory_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, *args):
        """
        Accessor to the FFT algorithm used for the Fourier transform.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.
         
        """
        return _statistics.SpectralModelFactory_setFFTAlgorithm(self, *args)

    def __repr__(self): return _statistics.SpectralModelFactory___repr__(self)
    def __str__(self, offset=""): return _statistics.SpectralModelFactory___str__(self, offset)
    def build(self, *args):
        """
        Estimate the spectral model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the spectral model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the spectral model is estimated.

        Returns
        -------
        mySpectralModel : :class:`~openturns.SpectralModel`
            The estimated spectral model.
         
        """
        return _statistics.SpectralModelFactory_build(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_SpectralModelFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SpectralModelFactory
    __del__ = lambda self : None;
SpectralModelFactory_swigregister = _statistics.SpectralModelFactory_swigregister
SpectralModelFactory_swigregister(SpectralModelFactory)

class UserDefinedSpectralModel(SpectralModelImplementation):
    """
    Spectral model defined by the User.

    Parameters
    ----------
    frequency : :class:`~openturns.RegularGrid`
        The frequency grid :math:`(-f_c, \\dots, f_c)` with step :math:`\\delta f` on which the model is built.
    densityCollectionFunction : :class:`~openturns.HermitianMatrixCollection`
        Collection of hermitian matrices :math:`\\in \\mathbb{M}_d(\\mathbb{C})` which are the images of each point of the frequency grid through the density spectral function.

    Notes
    -----
    We consider a multivariate process :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d` of dimension *d* where :math:`\\cD \\in \\Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (*n=1*).

    We denote :math:`(\\vect{t}_0, \\dots, \\vect{t}_{N-1})` the time stamps of the time grid.

    *X* is supposed to be a stationary second order process and we suppose that its spectral density function :math:`S : \\Rset \\rightarrow \\mathcal{H}^+(d)` defined by:

    .. math::
        :label: fourier_transform

        \\forall \\vect{f} \\in \\Rset^n, \\,S(\\vect{f}) = \\int_{\\Rset^n}\\exp\\left\\{  -2i\\pi <\\vect{f},\\vect{\\tau}> \\right\\} C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}

    exists, where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    We get a piecewise constant function on :math:`[-f_c,f_c]`, where the intervals on which the density spectral function is constant are centered on the points of the frequency grid, of length :math:`\\delta f`. 

    Then, it is  possible to evaluate the spectral density function for a given frequency thanks to the method *computeSpectralDensity*: if the frequency is not inside the interval :math:`[-f_c,f_c]`, OpenTURNS returns an exception. Otherwise, it returns the hermitian matrix of the subinterval of :math:`[-f_c,f_c]` that contains the given frequency.

    Examples
    --------
    Create the frequency grid:

    >>> import openturns as ot
    >>> from math import exp
    >>> fmin = 0.1
    >>> df = 0.5
    >>> N = int((10.0 - fmin)/ df)
    >>> myFrequencyGrid =  ot.RegularGrid(fmin, df, N)

    Define the spectral function:

    >>> def s(f):
    ...     if(f <= 5.0):
    ...         return 1.0
    ...     else:
    ...         x = f - 5.0
    ...         return exp(-2.0 * x * x)

    Create the collection of HermitianMatrix:

    >>> myCollection = ot.HermitianMatrixCollection()
    >>> for k in range(N):
    ...     frequency = myFrequencyGrid.getValue(k)
    ...     matrix = ot.HermitianMatrix(1)
    ...     matrix[0, 0] = s(frequency)
    ...     myCollection.add(matrix)

    Create the spectral model:

    >>> mySpectralModel = ot.UserDefinedSpectralModel(myFrequencyGrid, myCollection)

    """
    __swig_setmethods__ = {}
    for _s in [SpectralModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserDefinedSpectralModel, name, value)
    __swig_getmethods__ = {}
    for _s in [SpectralModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserDefinedSpectralModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedSpectralModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.UserDefinedSpectralModel___call__(self, *args)

    def __repr__(self): return _statistics.UserDefinedSpectralModel___repr__(self)
    def __str__(self, offset=""): return _statistics.UserDefinedSpectralModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_UserDefinedSpectralModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_UserDefinedSpectralModel
    __del__ = lambda self : None;
UserDefinedSpectralModel_swigregister = _statistics.UserDefinedSpectralModel_swigregister
UserDefinedSpectralModel_swigregister(UserDefinedSpectralModel)

class WelchFactory(SpectralModelFactoryImplementation):
    """
    Welch estimator of the spectral model of a  stationary process.

    Parameters
    ----------
    window : :class:`~openturns.FilteringWindows`
        The filtering window model.

        By default, the filtering window model is the Hanning model.
    blockNumber : int
        Number of blocks. 

        By default, *blockNumber=1*.
    overlap : float, :math:`0 \\leq overlap \\leq 0.5`.
        Overlap rate parameter of the segments of the time series.

        By default, *overlap=0.5*.

    Notes
    -----
    Let :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\\cD \\in \\Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (*n=1*).

    If we note :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \\Rset^n \\rightarrow \\Rset^n` is :math:`\\cL^1(\\Rset^n)` (ie :math:`\\int_{\\Rset^n} |C^{stat}_{i,j}(\\vect{\\tau})|\\di{\\vect{\\tau}}\\, < +\\infty`), with :math:`C^{stat}(\\vect{\\tau}) = C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as this quantity does not depend on :math:`\\vect{s}`. 

    The bilateral spectral density function :math:`S : \\Rset^n \\rightarrow \\mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \\forall \\vect{f} \\in \\Rset^n, \\,S(\\vect{f}) = \\int_{\\Rset^n}\\exp\\left\\{  -2i\\pi <\\vect{f},\\vect{\\tau}> \\right\\} C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}


    where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.


    The Welch estimator is a non parametric estimator based on the segmentation of the time series into *blockNumber* segments  possibly overlapping (size of overlap *overlap*). The length of each segment is deduced.


    Examples
    --------
    Create a time series from a stationary second order process:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 2**8)
    >>> model = ot.ExponentialCauchy([5.0], [3.0])
    >>> myNormalProcess = ot.SpectralNormalProcess(model, myTimeGrid)
    >>> myTimeSeries = myNormalProcess.getRealization()

    Estimate the spectral model ith the WelchFactory:

    >>> mySegmentNumber = 10
    >>> myOverlapSize = 0.3
    >>> myFactory = ot.WelchFactory(ot.Hanning(), mySegmentNumber , myOverlapSize)
    >>> myEstimatedModel_TS = myFactory.build(myTimeSeries)

    Change the filtering window: 

    >>> myFactory.setFilteringWindows(ot.Hamming())


    """
    __swig_setmethods__ = {}
    for _s in [SpectralModelFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WelchFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [SpectralModelFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WelchFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.WelchFactory_getClassName(self)

    def __repr__(self): return _statistics.WelchFactory___repr__(self)
    def __str__(self, offset=""): return _statistics.WelchFactory___str__(self, offset)
    def getFilteringWindows(self):
        """
        Accessor to the filtering window.

        Returns
        -------
        filteringWindow : :class:`~openturns.FilteringWindows`
            The filtering window used.

            By default, the :class:`~openturns.Hanning` one.

        """
        return _statistics.WelchFactory_getFilteringWindows(self)

    def setFilteringWindows(self, *args):
        """
        Accessor to the filtering window.

        Parameters
        ----------
        filteringWindow : :class:`~openturns.FilteringWindows`
            The filtering window used.

        """
        return _statistics.WelchFactory_setFilteringWindows(self, *args)

    def getBlockNumber(self):
        """
        Accessor to the block number.

        Returns
        -------
        blockNumber : int
            The number of blocks used in the Welch estimator.

            By default, *blockNumber = 1*.


        """
        return _statistics.WelchFactory_getBlockNumber(self)

    def setBlockNumber(self, *args):
        """
        Accessor to the block number.

        Parameters
        ----------
        blockNumber : positive int
            The number of blocks used in the Welch estimator.

        """
        return _statistics.WelchFactory_setBlockNumber(self, *args)

    def getOverlap(self):
        """
        Accessor to the overlap rate.

        Returns
        -------
        overlap : float, :math:`0 \\leq overlap \\leq 0.5`.
            The overlap rate of the time series.

            By default, *overlap = 0.5*.


        """
        return _statistics.WelchFactory_getOverlap(self)

    def setOverlap(self, *args):
        """
        Accessor to the block number.

        Parameters
        ----------
        blockNumber : int, :math:`0 \\leq overlap \\leq 0.5`.
            The overlap rate of the times series.

        """
        return _statistics.WelchFactory_setOverlap(self, *args)

    def build(self, *args):
        """
        Estimate the spetral model.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        mySpectralModel : :class:`~openturns.UserDefinedSpectralModel`
            The  spectral model estimated with the Welch estimator.


        """
        return _statistics.WelchFactory_build(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_WelchFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_WelchFactory
    __del__ = lambda self : None;
WelchFactory_swigregister = _statistics.WelchFactory_swigregister
WelchFactory_swigregister(WelchFactory)

class ExponentialModel(StationaryCovarianceModel):
    """
    Multivariate stationary exponential covariance function.

    Available constructors:
        ExponentialModel(*spatialDim=1*)

        ExponentialModel(*scale, amplitude*)

        ExponentialModel(*scale, amplitude, spatialCorrelation*)

        ExponentialModel(*scale, spatialCovariance*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, the spatial dimension is deduced from the :math:`\\vect{\\theta}` parameter. If this one is not specified, then :math:`n=1`.
    scale : sequence of floats
         Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma}\\in \\Rset^d`.    
    spatialCorrelation : :class:`~openturns.CorrelationMatrix`
        Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1, 1])`
        By default, :math:`\\mat{R}= \\mat{I}_d` where the dimension :math:`d` is deduced from the amplitude :math:`\\vect{\\sigma}`.
    spatialCovariance : :class:`~openturns.CovarianceMatrix`
        Covariance matrix :math:`C^{stat} \\in \\cS_d^+(\\Rset)`.

    Notes
    -----
    The *exponential* function is a stationary covariance function whith dimension :math:`d\\geq1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset^d`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *exponential* function is defined by:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)\\, \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\, \\mbox{Diag}(\\vect{\\sigma}), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    where the spatial covariance function :math:`\\rho` writes:

    .. math::
        \\rho(\\vect{s}, \\vect{t} ) = e^{-\\left\\| \\vect{s}- \\vect{t} \\right\\|_2} \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    The spatial covariance matrix  writes:

    .. math::
        C^{stat}(\\vect{s}, \\vect{t})= \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R} \\,  \\mbox{Diag}(\\vect{\\sigma}) 


    Examples
    --------
    Create an exponential model from the amplitude :math:`\\vect{\\sigma}` and the scale :math:`\\vect{\\theta}`:

    >>> import openturns as ot
    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> myCovarianceModel = ot.ExponentialModel(scale, amplitude)

    Create an exponential model from the amplitude, scale and the correlation matrix:

    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(2)
    >>> spatialCorrelation[0,1] = 0.8
    >>> myCovarianceModel = ot.ExponentialModel(scale, amplitude, spatialCorrelation)

    Create an exponential model from the scale and covariance matrix:

    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCovariance = ot.CovarianceMatrix(2)
    >>> spatialCovariance[0,0] = 4.0
    >>> spatialCovariance[1,1] = 5.0
    >>> spatialCovariance[0,1] = 1.2
    >>> spatialDimension = 2
    >>> myCovarianceModel = ot.ExponentialModel(scale, spatialCovariance)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExponentialModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExponentialModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ExponentialModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.ExponentialModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.ExponentialModel_partialGradient(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.ExponentialModel_discretize(self, *args)

    def __repr__(self): return _statistics.ExponentialModel___repr__(self)
    def __str__(self, offset=""): return _statistics.ExponentialModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_ExponentialModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_ExponentialModel
    __del__ = lambda self : None;
ExponentialModel_swigregister = _statistics.ExponentialModel_swigregister
ExponentialModel_swigregister(ExponentialModel)

class ExponentiallyDampedCosineModel(StationaryCovarianceModel):
    """
    Exponentially damped cosine covariance function.

    Available constructors:
        ExponentiallyDampedCosineModel(*spatialDim=1*)

        ExponentiallyDampedCosineModel(*scale, amplitude, f*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma} \\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    f : positive float
        Frequency parameter.

    Notes
    -----
    The *exponentially damped cosine* function is a stationary covariance function whith dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *exponentially damped cosine* covariance function is defined by:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\sigma^2 e^{\\left(-\\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2\\right)} \\cos\\left(2 \\pi f \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2 \\right), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = e^{\\left(-\\left\\| \\vect{s}- \\vect{t}\\right\\|_2\\right)} \\cos\\left(2 \\pi f \\left\\| \\vect{s}-\\vect{t} \\right\\|_2 \\right), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD




    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard exponentially damped cosine covariance function:

    >>> import openturns as ot
    >>> covModel = ot.ExponentiallyDampedCosineModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.5, 0.4]
    >>> print(covModel(s, t))
    [[ -0.564137 ]]
    >>> tau = [0.1, 0.1]
    >>> print(covModel(tau))
    [[ 0.547367 ]]

    Create a exponentially damped cosine  covariance function specifying the amplitude and the scale:

    >>> covModel2 = ot.ExponentiallyDampedCosineModel([3.3], [1.2], 5.0)

    Create a  exponentially damped cosine  covariance function specifying the amplitude and the scale:

    >>> covModel3 = ot.ExponentiallyDampedCosineModel([1.5, 2.5], [3.5], 5.0)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExponentiallyDampedCosineModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExponentiallyDampedCosineModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ExponentiallyDampedCosineModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.ExponentiallyDampedCosineModel_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.ExponentiallyDampedCosineModel___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.ExponentiallyDampedCosineModel_computeAsScalar(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.ExponentiallyDampedCosineModel_discretize(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.ExponentiallyDampedCosineModel_isStationary(self)

    def __repr__(self): return _statistics.ExponentiallyDampedCosineModel___repr__(self)
    def __str__(self, offset=""): return _statistics.ExponentiallyDampedCosineModel___str__(self, offset)
    def setFrequency(self, *args):
        """
        Frequency accessor.

        Parameters
        ----------
        f : positive float
            Frequency parameter.
        """
        return _statistics.ExponentiallyDampedCosineModel_setFrequency(self, *args)

    def getFrequency(self):
        """
        Frequency accessor.

        Returns
        -------
        f : positive float
            Frequency parameter.
        """
        return _statistics.ExponentiallyDampedCosineModel_getFrequency(self)

    def __init__(self, *args): 
        this = _statistics.new_ExponentiallyDampedCosineModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_ExponentiallyDampedCosineModel
    __del__ = lambda self : None;
ExponentiallyDampedCosineModel_swigregister = _statistics.ExponentiallyDampedCosineModel_swigregister
ExponentiallyDampedCosineModel_swigregister(ExponentiallyDampedCosineModel)

class SphericalModel(StationaryCovarianceModel):
    """
    Spherical covariance function.

    Available constructors:
        SphericalModel(*spatialDim=1*)

        SphericalModel(*scale, amplitude*)

        SphericalModel(*scale, amplitude, radius*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    scale : sequence of positive floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma} \\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    radius : float, :math:`a > 0`
        Radius of the sphere on which the covariance model is not zero.
        By default, equal to 1.


    Notes
    -----
    The *spherical* function is a stationary covariance function whith dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *spherical*  function is defined on the sphere which ray is :math:`a`:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\sigma^2  \\left[1 - \\frac{1}{2a} \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2  \\left(3 -  \\frac{1}{a^2}\\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2^2\\right) \\right], \\quad \\forall (\\vect{s}, \\vect{t}), \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2 \\leq a

    The function is equal to zero outside the sphere.

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = 1 - \\frac{1}{2a} \\left\\|\\vect{s} - \\vect{t}\\right\\|_2 \\left(3 - \\frac{1}{a^2}\\left\\| \\vect{s} - \\vect{t} \\right\\|_2^2\\right), \\quad \\forall (\\vect{s}, \\vect{t}), \\left\\|  \\vect{s} - \\vect{t} \\right\\|_2 \\leq a

    and is equal to zero outside the sphere.


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard spherical covariance function:

    >>> import openturns as ot
    >>> covModel = ot.SphericalModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.789282 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.54147 ]]

    Create a  spherical covariance function specifying the scale, amplitude vectors:

    >>> covarianceModel = ot.SphericalModel([0.2, 0.3], [2.5])

    Create a  squared exponential covariance function specifying the scale vector, the amplitude and radius:

    >>> covModel3 = ot.SphericalModel([0.2, 0.3], [2.5], 2.3)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SphericalModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SphericalModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SphericalModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.SphericalModel_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.SphericalModel___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.SphericalModel_computeAsScalar(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.SphericalModel_discretize(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.SphericalModel_isStationary(self)

    def __repr__(self): return _statistics.SphericalModel___repr__(self)
    def __str__(self, offset=""): return _statistics.SphericalModel___str__(self, offset)
    def getRadius(self):
        """
        Radius accessor.

        Returns
        -------
        radius : float, :math:`a > 0`
            Radius of the sphere on which the covariance model is not zero.
        """
        return _statistics.SphericalModel_getRadius(self)

    def setRadius(self, *args):
        """
        Radius accessor.

        Parameters
        ----------
        radius : float, :math:`a > 0`
            Radius of the sphere on which the covariance model is not zero.
        """
        return _statistics.SphericalModel_setRadius(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_SphericalModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SphericalModel
    __del__ = lambda self : None;
SphericalModel_swigregister = _statistics.SphericalModel_swigregister
SphericalModel_swigregister(SphericalModel)

class CauchyModel(SpectralModelImplementation):
    """
    Cauchy spectral model.

    Available constructors:
        CauchyModel(*theta, sigma*)

    Parameters
    ----------
    theta : sequence of float
        Scale coefficients :math:`\\theta` of the spectral density function.
        Vector of size n
    sigma : sequence of float
        Amplitude coefficients :math:`\\sigma` of the spectral density function.
        Vector of size p

    Notes
    -----
    The spectral density function of input dimension **n** and output dimension **p** writes:

    .. math::

       \\forall (i,j) \\in [0,p-1]^2, S(f)_{i,j} =  \\Sigma_{i,j} \\prod_{k=1}^{n} \\frac{\\theta_k}{1 + (2\\pi \\theta_k f)^2}


    Examples
    --------
    >>> import openturns as ot
    >>> spectralModel = ot.CauchyModel([3.0, 2.0], [2.0])
    >>> f = 0.3
    >>> print(spectralModel(f))
    [[ (0.191364,0) ]]
    >>> f = 10
    >>> print(spectralModel(f))
    [[ (1.71084e-07,0) ]]
    """
    __swig_setmethods__ = {}
    for _s in [SpectralModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CauchyModel, name, value)
    __swig_getmethods__ = {}
    for _s in [SpectralModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CauchyModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CauchyModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        Using definitions in :class:`~openturns.SpectralModel`: the standard representative function writes:

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\rho(\\vect{f} \\odot \\vect{\\theta}) =  \\prod_{k=1}^{n} \\frac{1}{1 + (2\\pi \\theta_k f)^2}

        where :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.CauchyModel_computeStandardRepresentative(self, *args)

    def __repr__(self): return _statistics.CauchyModel___repr__(self)
    def __str__(self, offset=""): return _statistics.CauchyModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_CauchyModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CauchyModel
    __del__ = lambda self : None;
CauchyModel_swigregister = _statistics.CauchyModel_swigregister
CauchyModel_swigregister(CauchyModel)

class CovarianceModelFactoryImplementation(openturns.common.PersistentObject):
    """
    Estimation of the covariance model of a process.

    Notes
    -----
    This class is an interface class for all the classes that build covariance models. OpenTURNS provides two covariance model factories: :class:`~openturns.StationaryCovarianceModelFactory` for stationary processes and :class:`~openturns.NonStationaryCovarianceModelFactory` for all processes. This factory does not make any hypothesis on the stationarity of the process.

    See also
    --------
    StationaryCovarianceModelFactory, NonStationaryCovarianceModelFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelFactoryImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelFactoryImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelFactoryImplementation_getClassName(self)

    def __repr__(self): return _statistics.CovarianceModelFactoryImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModelFactoryImplementation___str__(self, offset)
    def build(self, *args): return _statistics.CovarianceModelFactoryImplementation_build(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelFactoryImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CovarianceModelFactoryImplementation
    __del__ = lambda self : None;
CovarianceModelFactoryImplementation_swigregister = _statistics.CovarianceModelFactoryImplementation_swigregister
CovarianceModelFactoryImplementation_swigregister(CovarianceModelFactoryImplementation)

class CovarianceModelFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelFactoryImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelFactoryImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelFactoryImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_CovarianceModelFactoryImplementationTypedInterfaceObject
    __del__ = lambda self : None;
CovarianceModelFactoryImplementationTypedInterfaceObject_swigregister = _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_swigregister
CovarianceModelFactoryImplementationTypedInterfaceObject_swigregister(CovarianceModelFactoryImplementationTypedInterfaceObject)

class CovarianceModelFactory(CovarianceModelFactoryImplementationTypedInterfaceObject):
    """
    Estimation of the covariance model of a process.

    Notes
    -----
    This class is an interface class for all the classes that build covariance models. OpenTURNS provides two covariance model factories: :class:`~openturns.StationaryCovarianceModelFactory` for stationary processes and :class:`~openturns.NonStationaryCovarianceModelFactory` for all processes. This factory does not make any hypothesis on the stationarity of the process.

    See also
    --------
    StationaryCovarianceModelFactory, NonStationaryCovarianceModelFactory
    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelFactoryImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelFactoryImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelFactory_getClassName(self)

    def __repr__(self): return _statistics.CovarianceModelFactory___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModelFactory___str__(self, offset)
    def build(self, *args): return _statistics.CovarianceModelFactory_build(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CovarianceModelFactory
    __del__ = lambda self : None;
CovarianceModelFactory_swigregister = _statistics.CovarianceModelFactory_swigregister
CovarianceModelFactory_swigregister(CovarianceModelFactory)

class UserDefinedCovarianceModel(CovarianceModelImplementation):
    """
    Covariance model defined by the User.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        A mesh which contains `N` vertices.
    sample : :class:`~openturns.CovarianceMatrixCollection`
        A collection of :math:`N(N+1)/2` covariance matrices.

    Notes
    -----
    The covariance model is built as follows.
    We consider a process :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d` with :math:`\\cD \\in \\Rset^n`. We note :math:`(\\vect{t}_0,\\dots, \\vect{t}_{N-1})` the vertices of :math:`\\cM \\in \\cD` and :math:`(\\mat{C}_{k,\\ell})_{0 \\leq \\ell \\leq k \\leq N-1}` where :math:`\\mat{C}_{k,\\ell} \\in \\cS_d^+(\\Rset)`.

    Care: The covariance matrices :math:`(\\mat{C}_{i,j})_{0 \\leq j \\leq i \\leq N-1}` must be given in the following order:

    .. math::

        \\mat{C}_{0,0}, \\, \\mat{C}_{1, 0}, \\, \\mat{C}_{1,1}, \\, \\mat{C}_{2,0},  \\,\\mat{C}_{2,1},\\, \\mat{C}_{2,2}, \\,\\dots

    which corresponds to the global covariance matrix, which lower part is:

    .. math::

        \\left(
        \\begin{array}{cccc}
        \\mat{C}_{0,0}& & & \\\\
        \\mat{C}_{1,0}&  \\mat{C}_{1,1}& & \\\\
        \\mat{C}_{2,0}&   \\mat{C}_{2,1}& \\mat{C}_{2,2}& \\\\
        \\dots & \\dots & \\dots & \\dots
        \\end{array}
        \\right)


    We build a covariance function which is a  piecewise constant function defined on :math:`\\cD \\times \\cD` by:

    .. math::

        \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD, \\, \\quad C(\\vect{s}, \\vect{t}) =  \\mat{C}_{k(\\vect{s}),k(\\vect{t})}


    where :math:`k(\\vect{s})` is such that :math:`\\vect{t}_{k(\\vect{s})}` is the  vertex of :math:`\\cM` the nearest to :math:`\\vect{s}`.

    Note that:

        - the  matrix :math:`\\mat{C}_{k,\\ell}` has the index :math:`n=\\ell +\\dfrac{k(k+1)}{2}` in the collection of covariance matrcies fixed by the User;
        - inversely, the matrix stored at index `n` in the collection is the matrix :math:`\\mat{C}_{k,\\ell}` where:

    .. math::

        k=\\left\\lfloor \\dfrac{1}{2}\\left( \\sqrt{8n+1}-1 \\right) \\right\\rfloor, \\quad  \\ell= n-\\dfrac{k(k+1)}{2}



    Examples
    --------
    >>> import openturns as ot
    >>> import math as m

    Create the covariance function at (s,t):

    >>> def C(s, t):
    ...     return m.exp( -4.0 * abs(s - t) / (1 + (s * s + t * t)))

    Create the time grid:

    >>> N = 32
    >>> a = 4.0
    >>> myMesh = ot.IntervalMesher([N]).build(ot.Interval(-a, a))

    Create the collection of elementary covariance matrices 
    ie the n(n+1)/2 small covariance matrices quantifying
    the covariance between X(s) and X(t) for s, t in the
    vertices of the mesh and index(s) <= index(t):

    >>> myCovarianceCollection = ot.CovarianceMatrixCollection()
    >>> for k in range(myMesh.getVerticesNumber()):
    ...     t = myMesh.getVertices()[k]
    ...     for l in range(k + 1):
    ...         s = myMesh.getVertices()[l]
    ...         matrix = ot.CovarianceMatrix(1)
    ...         matrix[0, 0] = C(s[0], t[0])
    ...         myCovarianceCollection.add(matrix)

    Create the covariance model:

    >>> myCovarianceModel = ot.UserDefinedCovarianceModel(myMesh, myCovarianceCollection)

    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserDefinedCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserDefinedCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedCovarianceModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.UserDefinedCovarianceModel___call__(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.UserDefinedCovarianceModel_discretize(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.UserDefinedCovarianceModel_discretizeRow(self, *args)

    def getMesh(self):
        """
        Accessor to the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh associated to the collection of covariance matrices.

        """
        return _statistics.UserDefinedCovarianceModel_getMesh(self)

    def getTimeGrid(self):
        """
        Accessor to the time grid.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid associated to the collection of covariance matrices when the mesh can be interpreted as a regular time grid.

        """
        return _statistics.UserDefinedCovarianceModel_getTimeGrid(self)

    def __repr__(self): return _statistics.UserDefinedCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.UserDefinedCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_UserDefinedCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_UserDefinedCovarianceModel
    __del__ = lambda self : None;
UserDefinedCovarianceModel_swigregister = _statistics.UserDefinedCovarianceModel_swigregister
UserDefinedCovarianceModel_swigregister(UserDefinedCovarianceModel)

class NonStationaryCovarianceModelFactory(CovarianceModelFactoryImplementation):
    """
    Estimation of a non stationary covariance model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d` be a multivariate process of dimension *d* where :math:`\\cD \\in \\Rset^n`. 
    We denote :math:`(\\vect{t}_0, \\dots, \\vect{t}_{N-1})` the vertices of the mesh :math:`\\cM \\in \\cD`.

    *X* is supposed to be a second order process and we note :math:`C : \\cD \\times \\cD \\rightarrow \\mathcal{M}_{d \\times d}(\\mathbb{R})` its covariance function. *X* may be stationary or non stationary as well.

    We suppose that we have *K* fields and we note :math:`(\\vect{x}_0^k, \\dots, \\vect{x}_{N-1}^k)` the values of the field *k* on the mesh :math:`\\cM`.

    We recall that the covariance function *C* writes:

    .. math::

        \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD, \\quad C(\\vect{s}, \\vect{t}) = \\Expect{\\left(X_{\\vect{s}}-m(\\vect{s})\\right)\\Tr{\\left(X_{\\vect{t}}-m(\\vect{t})\\right)}}


    where the mean function :math:`m: \\cD \\rightarrow \\Rset^d` is defined by:

    .. math::

        \\forall \\vect{t}\\in \\cD , \\quad m(\\vect{t}) = \\Expect{X_{\\vect{t}}}


    First, we estimate the covariance function *C* on the vertices of the mesh :math:`\\cM` using the empirical mean estimator:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            & \\forall \\vect{t}_i \\in \\cM, \\quad m(\\vect{t}_i) \\simeq \\frac{1}{K} \\sum_{k=1}^{K} \\vect{x}_i^k \\\\
            & \\forall (\\vect{t}_i, \\vect{t}_j) \\in \\cD \\times \\cD, \\quad C(\\vect{t}_i, \\vect{t}_j) \\simeq \\frac{1}{K} \\sum_{k=1}^{K} \\left( \\vect{x}_i^k - m(\\vect{t}_i) \\right) \\Tr{\\left( \\vect{x}_j^k - m(\\vect{t}_j) \\right)}
        \\end{eqnarray*}


    Then, we build a covariance function defined on :math:`\\cD \\times \\cD` which is a piecewise constant function defined on :math:`\\cD \\times \\cD` by:

    .. math::

        \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD, \\, C(\\vect{s}, \\vect{t}) = C(\\vect{t}_k, \\vect{t}_l)

    where *k* is such that :math:`\\vect{t}_k` is the vertex of :math:`\\cM` the nearest to :math:`\\vect{s}` and :math:`\\vect{t}_l` the nearest to :math:`\\vect{t}`.

    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NonStationaryCovarianceModelFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NonStationaryCovarianceModelFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.NonStationaryCovarianceModelFactory_getClassName(self)

    def __repr__(self): return _statistics.NonStationaryCovarianceModelFactory___repr__(self)
    def __str__(self, offset=""): return _statistics.NonStationaryCovarianceModelFactory___str__(self, offset)
    def build(self, *args):
        """
        Estimate the covariance model.

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model which is not supposed to be stationary.

        Returns
        -------
        covEst : :class:`~openturns.CovarianceModelImplementation`
            The estimated covariance model.

        Examples
        --------
        Create the covariance model, a mesh and a process:

        >>> import openturns as ot
        >>> myModel = ot.AbsoluteExponential([0.1]*2)
        >>> myMesh = ot.IntervalMesher([10]*2).build(ot.Interval([0.0]*2, [1.0]*2))
        >>> myProcess = ot.TemporalNormalProcess(myModel, myMesh)

        Generate 10 fields:

        >>> mySample = myProcess.getSample(10)

        Estimate the covariance model without supposing the stationarity:

        >>> myEstCov = ot.NonStationaryCovarianceModelFactory().build(mySample)

        """
        return _statistics.NonStationaryCovarianceModelFactory_build(self, *args)

    def buildAsUserDefinedCovarianceModel(self, *args):
        """
        Estimate the covariance model as a User defined covariance model.

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model which is not supposed to be stationary.

        Returns
        -------
        covEst : :class:`~openturns.UserDefinedCovarianceModel`
            The estimated covariance model that can be used as  a :class:`~openturns.UserDefinedCovarianceModel`.

        """
        return _statistics.NonStationaryCovarianceModelFactory_buildAsUserDefinedCovarianceModel(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_NonStationaryCovarianceModelFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_NonStationaryCovarianceModelFactory
    __del__ = lambda self : None;
NonStationaryCovarianceModelFactory_swigregister = _statistics.NonStationaryCovarianceModelFactory_swigregister
NonStationaryCovarianceModelFactory_swigregister(NonStationaryCovarianceModelFactory)

class UserDefinedStationaryCovarianceModel(StationaryCovarianceModel):
    """
    Stationary covariance model defined by the User.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        A mesh that contains `N` vertices.
    sample : :class:`~openturns.CovarianceMatrixCollection`
        A collection of *N* covariance matrices.

    Notes
    -----
    The covariance model is built as follows.

    We consider a process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` with :math:`\\cD \\in \\Rset^n`. 

    We note :math:`(\\vect{t}_0,\\dots, \\vect{t}_{N-1})` the vertices of :math:`\\cM \\in \\cD` and :math:`(\\mat{C}_{k})_{0 \\leq  k \\leq N-1}` where :math:`\\mat{C}_{k} \\in \\cS_d^+(\\Rset)` the collection of covariance matrices fixed by the User.

    Then we build a stationary covariance function :math:`C^{stat}` which is a  piecewise constant function defined on :math:`\\cD \\times \\cD` by:

    .. math::

        \\forall \\vect{\\tau} \\in \\cD, \\, \\quad C^{stat}(\\vect{\\tau}) =  \\mat{C}_k


    where *k* is such that :math:`\\vect{t}_k` is the  vertex of :math:`\\cM` the nearest to :math:`\\vect{\\tau}`.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> # Create the time grid
    >>> t0 = 0.0
    >>> dt = 0.5
    >>> N = int((20.0 - t0)/ dt)
    >>> myShiftMesh =  ot.RegularGrid(t0, dt, N)

    Create the stationary covariance function:

    >>> def gamma(tau):
    ...     return 1.0 / (1.0 + tau * tau)

    Create the collection of N covariance matrices:

    >>> myCovarianceCollection = ot.CovarianceMatrixCollection()
    >>> for k in range(N):
    ...     t = myShiftMesh.getValue(k)
    ...     matrix = ot.CovarianceMatrix(1)
    ...     matrix[0, 0] = gamma(t)
    ...     myCovarianceCollection.add(matrix)

    Create the User defined stationary covariance model:

    >>> myCovarianceModel = ot.UserDefinedStationaryCovarianceModel(myShiftMesh,myCovarianceCollection)

    Compute the covariance function at the vertex tau:

    >>> tau = 1.5
    >>> myCovModelMatrix = myCovarianceModel(tau)

    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserDefinedStationaryCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserDefinedStationaryCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedStationaryCovarianceModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.UserDefinedStationaryCovarianceModel___call__(self, *args)

    def getMesh(self):
        """
        Accessor to the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh associated to the collection of covariance matrices.

        """
        return _statistics.UserDefinedStationaryCovarianceModel_getMesh(self)

    def getTimeGrid(self):
        """
        Accessor to the time grid.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid associated to the collection of covariance matrices when the mesh can be interpreted as a reglar time grid.

        """
        return _statistics.UserDefinedStationaryCovarianceModel_getTimeGrid(self)

    def __repr__(self): return _statistics.UserDefinedStationaryCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.UserDefinedStationaryCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_UserDefinedStationaryCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_UserDefinedStationaryCovarianceModel
    __del__ = lambda self : None;
UserDefinedStationaryCovarianceModel_swigregister = _statistics.UserDefinedStationaryCovarianceModel_swigregister
UserDefinedStationaryCovarianceModel_swigregister(UserDefinedStationaryCovarianceModel)

class StationaryCovarianceModelFactory(CovarianceModelFactoryImplementation):
    """
    Estimation of the covariance model of a stationary process.

    Parameters
    ----------
    spectralModelFactory : :class:`~openturns.SpectralModelFactory`
        The spectral model factory. 

        By default, it is the Welch factory model.

    Notes
    -----
    We consider :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d`  be a multivariate   process of dimension *d* where :math:`\\cD \\in \\Rset^n`.  We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (:math:`n=1`). 
    We denote :math:`(\\vect{t}_0, \\dots, \\vect{t}_{N-1})` the vertices of the  mesh :math:`\\cM \\in \\cD` which is a time grid supposed regular.

    *X* is supposed to be a stationary second order process with zero mean. We note its covariance function :math:`C^{stat}:  \\cD \\rightarrow  \\mathcal{M}_{d \\times d}(\\Rset)`, defined by :math:`C^{stat}(\\tau)=\\Expect{X_s\\Tr{X_{s+\\tau}}}` for all :math:`s\\in \\cD`.

    In addition, we suppose that its spectral density function :math:`S : \\Rset \\rightarrow \\mathcal{H}^+(d)` is defined,  where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    OpenTURNS estimates  :math:`C^{stat}` from a field or a sample of fields of *X*, using first the estimation of the spectral density function and then mapping *S* into :math:`C^{stat}` using the inversion relation :

    .. math::

        C^{stat}(\\vect{\\tau})  = \\int_{\\Rset^n}\\exp\\left\\{  2i\\pi <\\vect{f}, \\vect{\\tau}> \\right\\}S(\\vect{f})\\di{\\vect{f}}

    when it is possible.

    As the mesh is a time grid (:math:`n=1`), the fields can be interpreted as time series.

    The estimation  algorithm is outlined hereafter.

    Let :math:`(\\vect{X}^0, \\dots, , \\vect{X}^{M-1})` be *M* independent realizations of *X* or *M* segments of one realization of the process. 

    Using the relation between the covariance model end the spectral function, the covariance function writes:

    .. math::
        :label: eq2

        C_{i,j}^{stat}(\\tau)  = \\int_{\\mathbb{R}}\\exp\\left\\{  2i\\pi f \\tau \\right\\} S_{i,j}(f)\\di{f}

    where :math:`C_{i,j}^{stat}` is the element *(i,j)* of the matrix :math:`C^{stat}(\\tau)` and :math:`S_{i,j}(f)` the one of :math:`S(f)`. The integral :eq:`eq2` is approximated by its evaluation on the finite domain :math:`\\Omega \\in \\Rset`:

    .. math::
        :label: eq3

        C_{i,j}^{stat}(\\tau)  = \\int_{\\Omega}\\exp\\left\\{  2i\\pi f \\tau \\right\\} S_{i,j}(f)\\di{f}


    Let us consider the partition of the domain as follows:

        - :math:`\\Omega =[-\\Omega_c, \\Omega_c]` is subdivised into *M* segments :math:`\\Omega = \\cup_{k=1}^{M} \\mathcal{M}_k` with :math:`\\mathcal{M}_k=[f_k - \\frac{\\Delta f}{2}, f_k + \\frac{\\Delta f}{2}]`

        - :math:`\\Delta f` be the frequency step, :math:`\\Delta f = \\frac{2 \\Omega_c}{M}`

        - :math:`f_k` be the frequences on which the spectral density is computed, :math:`f_k = -\\Omega_c + \\left(k - \\frac{1}{2} \\right) \\Delta f = \\left( 2 k - 1 - M \\right) \\frac{\\Delta f}{2}` with :math:`k=1,\\hdots,M`

    The equation :eq:`eq3` can be rewritten as:

    .. math::

        C_{i,j}^{stat}(\\tau)  = \\sum_{k=1}^{M}\\int_{\\mathcal{M}_k}\\exp\\left\\{  2i\\pi f \\tau \\right\\} S_{i,j}(f)\\di{f}

    We focus on the integral on each subdomain :math:`\\mathcal{M}_k`. Using numerical approximation, we have:

    .. math::

        \\int_{\\mathcal{M}_k}\\exp\\left\\{  2i\\pi f \\tau \\right\\} S_{i,j}(f)\\di{f} \\approx \\Delta f S_{i,j}(f_k) \\exp\\left\\{  2i\\pi f_k \\tau \\right\\}

    :math:`\\tau` must be in correspondance with frequency values with respect to the Shannon criteria. Thus the temporal domain of estimation is the following:

        - :math:`\\Delta t` is the time step, :math:`\\Delta t = \\frac{1}{2 \\Omega_c}` such as :math:`\\Delta f \\Delta t = \\frac{1}{M}`

        - :math:`\\tilde{\\mathcal{T}} = [-T, T]` is subdivised into *M* segments :math:`\\tilde{{\\mathcal{T}}} = \\cup_{m=1}^{M} \\mathcal{T}_m` with :math:`\\mathcal{T}_m=[t_m - \\frac{\\Delta t}{2}, t_m + \\frac{\\Delta t}{2}]`

        - :math:`t_m` be the time values on which the covariance is estimated, :math:`t_m = -\\frac{M}{2 \\Omega_c} + \\left(m - \\frac{1}{2} \\right) \\Delta t = \\left(2 m - 1 - M \\right) \\frac{\\Delta t}{2}`

    The estimate of the covariance value at time value :math:`\\tau_{m}` depends on the quantities of form:

    .. math::
        :label: eq4

        \\int_{\\mathcal{M}_k}\\exp\\left\\{  2i\\pi f \\tau_{m} \\right\\} S_{i,j}(f)\\di{f} \\approx \\Delta f S_{i,j}(f_k) \\exp\\left\\{  2i\\pi f_k \\tau_{m} \\right\\}


    We develop the expression of :math:`f_k` and :math:`\\tau_{m}` and we get:

    .. math::

        \\left\\{
         \\begin{array}{l}
           2m - 1 - M = 2 (m-1) - (M-1) \\\\
           2k - 1 - M = 2 (k-1) - (M-1)
         \\end{array}
         \\right.

    Thus:

    .. math::

        (2m - 1 - M) (2k - 1 - M) = 4 (m-1)(k-1) - (M-1)(2m -1 -M) - 2 (k-1)(M-1)

    and:

    .. math::

        (2m - 1 - M) (2k - 1 - M)\\frac{\\Delta t}{2}\\frac{\\Delta f}{2} = \\frac{(m-1)(k-1)}{M} - \\frac{(M-1)(2m -1 -M)}{4M} - \\frac{(k-1)(M-1)}{2M}


    We denote:

    .. math::

        \\left\\{
          \\begin{array}{l}
            \\delta(m) = \\exp\\left\\{-i \\frac{\\pi}{2M} (M-1)(2m -1 -M) \\right\\}\\\\
            \\phi_k = \\exp\\left\\{-i \\frac{\\pi}{M} (k-1)(M-1) \\right\\} S_{i,j}(f_k)
          \\end{array}
          \\right.


    Finally, we get the followig expression for integral in :eq:`eq4`:

    .. math::

        \\int_{\\mathcal{M}_k}\\exp\\left\\{  2i\\pi f \\tau_{m} \\right\\} S_{i,j}(f)\\di{f} \\approx \\Delta f \\exp\\left\\{2i \\frac{\\pi}{M} (m-1)(k-1)  \\right\\} \\delta(m) \\phi_k

    It follows that:

    .. math::
        :label: eq5

        C_{i,j}^{stat}(\\tau_m)  = \\Delta f \\delta(m) \\sum_{k=1}^{M} \\phi_k \\exp\\left\\{2i \\frac{\\pi}{M} (m-1)(k-1)  \\right\\}

    In the equation :eq:`eq5`, we notice a discret inverse Fourier transform.

    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StationaryCovarianceModelFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, StationaryCovarianceModelFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModelFactory_getClassName(self)

    def getSpectralModelFactory(self):
        """
        Accessor to the spectral factory algorithm.

        Returns
        -------
        spectModel : :class:`~openturns.SpectralModelFactory`
            The spectral factory algorithm.

        """
        return _statistics.StationaryCovarianceModelFactory_getSpectralModelFactory(self)

    def setSpectralModelFactory(self, *args):
        """
        Accessor to the spectral factory algorithm.

        Parameters
        ----------
        spectModel : :class:`~openturns.SpectralModelFactory`
            The spectral factory algorithm.

        """
        return _statistics.StationaryCovarianceModelFactory_setSpectralModelFactory(self, *args)

    def __repr__(self): return _statistics.StationaryCovarianceModelFactory___repr__(self)
    def __str__(self, offset=""): return _statistics.StationaryCovarianceModelFactory___str__(self, offset)
    def build(self, *args):
        """
        Estimate a stationary covariance model.

        Available usages:
            build(*sampleFields*)

            build(*myField*)

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model.
        myField : :class:`~openturns.Field`
            One field used to estimate the covariance model. 

        Returns
        -------
        covEst : :class:`~openturns.CovarianceModelImplementation`
            The estimated covariance model.

        Notes
        -----
        The fields are in fact time series.

        The estimated :class:`~openturns.CovarianceModelImplementation` which is a :class:`~openturns.UserDefinedStationaryCovarianceModel` composed of a time grid and a collection of *K* square matrices of dimension *d* where *K* corresponds to the number of time steps of the final time grid on which the covariance is estimated.

        When estimated from a time series, the :class:`~openturns.UserDefinedStationaryCovarianceModel` may have a  time grid different from the initial time grid of the time series.

        Examples
        --------
        Create the stationary covariance model, a mesh and a process:

        >>> import openturns as ot
        >>> myModel = ot.AbsoluteExponential([0.1])
        >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 10)
        >>> myProcess = ot.TemporalNormalProcess(myModel, myTimeGrid)

        Generate 20 fields:

        >>> mySample = myProcess.getSample(20)

        Estimate the covariance model  supposing the stationarity:

        >>> myEstCov = ot.StationaryCovarianceModelFactory().build(mySample)

        """
        return _statistics.StationaryCovarianceModelFactory_build(self, *args)

    def buildAsUserDefinedStationaryCovarianceModel(self, *args):
        """
        Estimate the covariance model as a User defined covariance model.

        Available usages:
            buildAsUserDefinedStationaryCovarianceModel(*sampleFields*)

            buildAsUserDefinedStationaryCovarianceModel(*myField*)

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model which is  supposed to be stationary.

        Returns
        -------
        covEst : :class:`~openturns.UserDefinedStationaryCovarianceModel`
            The estimated covariance model that can be used as  a :class:`~openturns.UserDefinedStationaryCovarianceModel`.

        """
        return _statistics.StationaryCovarianceModelFactory_buildAsUserDefinedStationaryCovarianceModel(self, *args)

    def __init__(self, *args): 
        this = _statistics.new_StationaryCovarianceModelFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModelFactory
    __del__ = lambda self : None;
StationaryCovarianceModelFactory_swigregister = _statistics.StationaryCovarianceModelFactory_swigregister
StationaryCovarianceModelFactory_swigregister(StationaryCovarianceModelFactory)

class SquaredExponential(StationaryCovarianceModel):
    """
    Squared exponential covariance function.

    Available constructors:
        SquaredExponential(*spatialDim=1*)

        SquaredExponential(*scale*)

        SquaredExponential(*scale, amplitude*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the spatial dimension is equal to the  size of the parameter :math:`\\vect{\\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma}\\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.

    Notes
    -----
    The *squared exponential function* is a stationary covariance function whith dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *squared exponential* function is defined by:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\sigma^2 e^{-\\frac{1}{2}  \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_{2}^{2}}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = e^{-\\frac{1}{2}  \\left\\| \\vect{s}- \\vect{t} \\right\\|_{2}^{2}}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard squared exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.SquaredExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.99005 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.951229 ]]

    Create a squared exponential covariance function specifying the scale vector (amplitude is fixed to 1):

    >>> covModel2 = ot.SquaredExponential([1.5, 2.5])
    >>> covModel2bis = ot.SquaredExponential([1.5] * 3)

    Create a  squared exponential covariance function specifying the scale vector and the amplitude :

    >>> covModel3 = ot.SquaredExponential([1.5, 2.5], [3.5])
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SquaredExponential, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SquaredExponential, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SquaredExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.SquaredExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.SquaredExponential_partialGradient(self, *args)

    def __repr__(self): return _statistics.SquaredExponential___repr__(self)
    def __str__(self, offset=""): return _statistics.SquaredExponential___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_SquaredExponential(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SquaredExponential
    __del__ = lambda self : None;
SquaredExponential_swigregister = _statistics.SquaredExponential_swigregister
SquaredExponential_swigregister(SquaredExponential)

class GeneralizedExponential(StationaryCovarianceModel):
    """
    Absolute exponential covariance function.

    Available constructors:
        GeneralizedExponential(*spatialDim=1*)

        GeneralizedExponential(*scale, p*)

        GeneralizedExponential(*scale, amplitude, p*)


    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the spatial dimension is equal to the  size of the parameter :math:`\\vect{\\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma}\\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    p : int, :math:`p \\geq 1`
        Define the norm that is used within the model.


    Notes
    -----
    The *generalized exponential function* is a stationary covariance function whith dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *generalized exponential* function is defined by:

    .. math::
        C(\\vect{s}, \\vect{t}) = \\sigma^2 e^{-\\left|\\left|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right|\\right|_{2}^p}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = e^{-\\left\\| \\vect{s}-\\vect{t} \\right\\||_{2}^p}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard generalized exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.GeneralizedExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.868123 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.728893 ]]

    Create a  generalized exponential covariance function specifying the scale vector and p:

    >>> covModel2 = ot.GeneralizedExponential([1.5, 2.5], 3)
    >>> covModel2bis = ot.GeneralizedExponential([1.5] * 2, 3)

    Create a  generalized exponential covariance function specifying the scale vector, the amplitude and p:

    >>> covModel3 = ot.GeneralizedExponential([1.5, 2.5], [3.5], 3)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeneralizedExponential, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeneralizedExponential, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.GeneralizedExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.GeneralizedExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.GeneralizedExponential_partialGradient(self, *args)

    def getP(self):
        """
        P accessor.

        Returns
        -------
        p : int, :math:`p \\geq 1`
            Define the norm that is used within the model.
        """
        return _statistics.GeneralizedExponential_getP(self)

    def setP(self, *args):
        """
        P accessor.

        Parameters
        ----------
        p : int, :math:`p \\geq 1`
            Define the norm that is used within the model.
        """
        return _statistics.GeneralizedExponential_setP(self, *args)

    def __repr__(self): return _statistics.GeneralizedExponential___repr__(self)
    def __str__(self, offset=""): return _statistics.GeneralizedExponential___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_GeneralizedExponential(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_GeneralizedExponential
    __del__ = lambda self : None;
GeneralizedExponential_swigregister = _statistics.GeneralizedExponential_swigregister
GeneralizedExponential_swigregister(GeneralizedExponential)

class AbsoluteExponential(StationaryCovarianceModel):
    """
    Absolute exponential covariance function.

    Available constructors:
        AbsoluteExponential(*spatialDim=1*)

        AbsoluteExponential(*scale*)

        AbsoluteExponential(*scale, amplitude*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the spatial dimension is equal to the  size of the parameter :math:`\\vect{\\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude  :math:`\\vect{\\sigma}\\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.


    Notes
    -----
    The *absolute exponential* function is a stationary covariance function whith dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *absolute exponential* function is defined by:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\sigma^2 e^{- \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_{1}}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = e^{- \\left\\| \\vect{s}- \\vect{t} \\right\\|_{1}}, \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard absolute exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.AbsoluteExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.818731 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.67032 ]]

    Create an absolute exponential covariance function specifying only the scale vector (amplitude is fixed to 1):

    >>> covModel2 = ot.AbsoluteExponential([1.5, 2.5])
    >>> covModel2bis = ot.AbsoluteExponential([1.5]*3)

    Create an absolute exponential covariance function specifying the scale vector and the amplitude :

    >>> covModel3 = ot.AbsoluteExponential([1.5, 2.5], [3.5])
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbsoluteExponential, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbsoluteExponential, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.AbsoluteExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.AbsoluteExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.AbsoluteExponential_partialGradient(self, *args)

    def __repr__(self): return _statistics.AbsoluteExponential___repr__(self)
    def __str__(self, offset=""): return _statistics.AbsoluteExponential___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_AbsoluteExponential(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_AbsoluteExponential
    __del__ = lambda self : None;
AbsoluteExponential_swigregister = _statistics.AbsoluteExponential_swigregister
AbsoluteExponential_swigregister(AbsoluteExponential)

class MaternModel(StationaryCovarianceModel):
    """
    Matern covariance function.

    Available constructors:
        MaternModel(*spatialDim=1*)

        MaternModel(*scale, nu*)

        MaternModel(*scale, amplitude, nu*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the spatial dimension is equal to the  size of the parameter :math:`\\vect{\\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\\vect{\\theta}\\in \\Rset^n`.
        The size of :math:`\\vect{\\theta}` is the spatial dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma}\\in \\Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    nu : float, :math:`\\nu \\geq 0`
        Coefficient :math:`\\nu`.

    Notes
    -----
    The *Matern* function is a stationary covariance function whith dimension :math:`d=1`.


    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *Matern* function is defined by:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\sigma^2 \\dfrac{ 2^{1-\\nu} }{\\Gamma(\\nu) } \\left(\\sqrt{2 \\nu} \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2\\right)^{\\nu} \\mathrm{K}_{\\nu} \\left(\\sqrt{2 \\nu} \\left\\|\\dfrac{\\vect{s}-\\vect{t}}{\\vect{\\theta}}\\right\\|_2\\right), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = \\dfrac{ 2^{1-\\nu} }{\\Gamma(\\nu) } \\left(\\sqrt{2 \\nu} \\left\\| \\vect{s}- \\vect{t}  \\right\\|_2\\right)^{\\nu} \\mathrm{K}_{\\nu} \\left(\\sqrt{2 \\nu} \\left\\| \\vect{s}- \\vect{t}  \\right\\|_2\\right), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD



    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard Matern covariance function:

    >>> import openturns as ot
    >>> covModel = ot.MaternModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.974477 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.894994 ]]

    Create a  Matern covariance function specifying the scale vector and :math:`\\nu`:

    >>> covModel2 = ot.MaternModel([1.5, 2.5], 2.3)
    >>> covModel2bis = ot.MaternModel([1.5]*3, 2.3)

    Create a  Matern covariance function specifying the scale vector, the amplitude and :math:`\\nu`:

    >>> covModel3 = ot.MaternModel([1.5, 2.5], [3.5], 4.5)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaternModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaternModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.MaternModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.MaternModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.MaternModel_partialGradient(self, *args)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.MaternModel_setScale(self, *args)

    def getNu(self):
        """
        Nu accessor.

        Returns
        -------
        nu : float, :math:`\\nu \\geq 0`
            Coefficient :math:`\\nu`.
        """
        return _statistics.MaternModel_getNu(self)

    def setNu(self, *args):
        """
        Nu accessor.

        Parameters
        ----------
        nu : float, :math:`\\nu \\geq 0`
            Coefficient :math:`\\nu`.
        """
        return _statistics.MaternModel_setNu(self, *args)

    def __repr__(self): return _statistics.MaternModel___repr__(self)
    def __str__(self, offset=""): return _statistics.MaternModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_MaternModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_MaternModel
    __del__ = lambda self : None;
MaternModel_swigregister = _statistics.MaternModel_swigregister
MaternModel_swigregister(MaternModel)

class DiracCovarianceModel(StationaryCovarianceModel):
    """
    Dirac covariance function.

    Available constructors:
        DiracCovarianceModel(*spatialDim=1*)

        DiracCovarianceModel(*spatialDim, amplitude*)

        DiracCovarianceModel(*spatialDim, amplitude, spatialCorrelation*)

        DiracCovarianceModel(*spatialDim, spatialCovariance*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\\vect{\\sigma}\\in \\Rset^d`.
        Its size is the dimension :math:`d` of the process.
        By default, equal to :math:`[1]`.
    spatialCorrelation : :class:`~openturns.CorrelationMatrix`
        Correlation matrix :math:`\\mat{R} \\in \\cS^+_d([-1, 1])`.
        By default, Identity matrix.
    spatialCovariance : :class:`~openturns.CovarianceMatrix`
        Covariance matrix :math:`\\mat{C}^{stat} \\in \\cS_d^+(\\Rset)`.
        By default, Identity matrix.

    Notes
    -----
    The *Dirac* covariance function is a stationary covariance function whith dimension :math:`d \\geq 1`.

    We consider the stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The  *Dirac* covariance function is defined by:

    .. math::
        
        C(\\vect{s}, \\vect{t}) =  1_{\\{\\vect{s}=\\vect{t}\\}} \\, \\mbox{Diag}(\\vect{\\sigma}) \\, \\mat{R}\\,  \\mbox{Diag}(\\vect{\\sigma}), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    where :math:`\\mat{R} \\in \\cS_d^+([-1,1])` is the spatial correlation matrix. We can define the spatial covariance matrix :math:`\\mat{C}^{stat}` as:

    .. math::
        
        \\mat{C}^{stat} = \\mbox{Diag}(\\vect{\\sigma}) \\, mat{R}\\,  \\mbox{Diag}(\\vect{\\sigma})

    The correlation function :math:`\\rho` writes:

    .. math::

        \\rho(\\vect{s}, \\vect{t}) = 1_{\\{\\vect{s}=\\vect{t}\\}}


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard Dirac covariance function:


    >>> import openturns as ot
    >>> covModel = ot.DiracCovarianceModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.1, 0.3]
    >>> print(covModel(s, t))
    [[ 1 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0 ]]

    Create a  Dirac covariance function specifying the amplitude vector:

    >>> covModel2 = ot.DiracCovarianceModel(2, [1.5, 2.5])

    Create a  Dirac covariance function specifying the amplitude vector and the correlation matrix:

    >>> corrMat = ot.CorrelationMatrix(2)
    >>> corrMat[1,0] = 0.1
    >>> covModel3 =  ot.DiracCovarianceModel(2, [1.5, 2.5], corrMat)
    """
    __swig_setmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DiracCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [StationaryCovarianceModel]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DiracCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.DiracCovarianceModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.DiracCovarianceModel___call__(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.DiracCovarianceModel_discretize(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.DiracCovarianceModel_discretizeRow(self, *args)

    def discretizeAndFactorize(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\\in \\cM_{nd\\times nd}(\\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.DiracCovarianceModel_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        """
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\\in\\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.DiracCovarianceModel_discretizeHMatrix(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.DiracCovarianceModel_partialGradient(self, *args)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.DiracCovarianceModel_setScale(self, *args)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.DiracCovarianceModel_setAmplitude(self, *args)

    def setSpatialCorrelation(self, *args):
        """
        Set the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1,1])`.
        """
        return _statistics.DiracCovarianceModel_setSpatialCorrelation(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.DiracCovarianceModel_isStationary(self)

    def __repr__(self): return _statistics.DiracCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.DiracCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_DiracCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_DiracCovarianceModel
    __del__ = lambda self : None;
DiracCovarianceModel_swigregister = _statistics.DiracCovarianceModel_swigregister
DiracCovarianceModel_swigregister(DiracCovarianceModel)

class ProductCovarianceModel(CovarianceModelImplementation):
    """
    Univariate covariance function defined as a product.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.CovarianceModel`
        Collection of covariance models :math:`(C_k)_{1 \\leq k \\leq K}` of dimension :math:`d=1`.

    Notes
    -----
    The *product* covariance function is a covariance function whith dimension :math:`d=1`. It defines a covariance model from the given collection as follows.

    We consider the scalar stochastic process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    The product covariance function writes:

    .. math::

        C(\\vect{s}, \\vect{t}) = \\prod_{k=1}^K  C_k(\\vect{s}_k, \\vect{t}_k), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD

    where :math:`C_k : \\cD_k \\times \\cD_k \\rightarrow  \\cS_d^+(\\Rset)`  with :math:`\\cD_k \\in \\Rset^{d_k}`, :math:`\\cD = \\cD_1 \\times \\dots \\times \\cD_K`, :math:`\\cD_k \\subset \\Rset^{n_k}` and :math:`n1 + \\dots + n_K=n`.

    :math:`C` also writes:

    .. math::

        C(\\vect{s}, \\vect{t}) =  \\sigma^2 \\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right), \\quad \\forall (\\vect{s}, \\vect{t}) \\in \\cD


    where the amplitude is:

    .. math::

        \\sigma= \\prod_{k=1}^K \\sigma_k

    the scale is:

    .. math::

        \\Tr{\\vect{\\theta}}= \\left(\\Tr{\\vect{\\theta}}_1, \\dots, \\Tr{\\vect{\\theta}}_K \\right)

    and the correlation function :math:`\\rho` is:

    .. math::

        \\rho \\left( \\vect{s}, \\vect{t} \\right) = \\prod_{k=1}^K \\rho_k\\left( \\vect{s}_k, \\vect{t}_k \\right)


    Examples
    --------
    Create a product covariance function from two exponential functions, each one defined on :math:`\\Rset \\times \\Rset \\rightarrow \\cS_1^+(\\Rset)`:

    >>> import openturns as ot
    >>> amplitude = [1.0]
    >>> scale1 = [4.0]
    >>> scale2 = [4.0]
    >>> cov1 = ot.ExponentialModel(scale1, amplitude)
    >>> cov2 = ot.ExponentialModel(scale2, amplitude)
    >>> myCovarianceModel = ot.ProductCovarianceModel([cov1, cov2])
    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ProductCovarianceModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.ProductCovarianceModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.ProductCovarianceModel_partialGradient(self, *args)

    def getCollection(self): return _statistics.ProductCovarianceModel_getCollection(self)
    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.ProductCovarianceModel_getMarginal(self, *args)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.ProductCovarianceModel_setScale(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.ProductCovarianceModel_isStationary(self)

    def __repr__(self): return _statistics.ProductCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.ProductCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_ProductCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_ProductCovarianceModel
    __del__ = lambda self : None;
ProductCovarianceModel_swigregister = _statistics.ProductCovarianceModel_swigregister
ProductCovarianceModel_swigregister(ProductCovarianceModel)

class TensorizedCovarianceModel(CovarianceModelImplementation):
    """
    Multivariate covariance function defined as a tensorization of covariance models.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.CovarianceModel`
        Collection of covariance models :math:`(C_k)_{1 \\leq k \\leq K}` of dimension :math:`d_k`.

    Notes
    -----
    The tensorized covariance model defines a multivariate covariance model of dimension :math:`d\\geq 1` from the tensorization of a given covariance models.

    We consider the stochastic process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d`, where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of :math:`\\Rset^n`.

    Its covariance function :math:`C : \\cD \\times \\cD \\rightarrow  \\cS_d^+(\\Rset)` is defined from the collection of covariance functions :math:`C_k: \\cD \\times \\cD \\mapsto  \\cS_{d_k}^+(\\Rset)` where :math:`d_1+\\dots+d_k=d`, as follows:

    .. math::
        C(\\vect{s}, \\vect{t}) =    \\left(
            \\begin{array}{cccc}
            C_1(\\vect{s}, \\vect{t}) & 0 & \\dots & 0 \\\\
            0 & C_2(\\vect{s}, \\vect{t}) & 0 &  \\\\
            \\dots & \\dots & \\ddots & \\dots \\\\
            0 & \\dots & \\dots &  C_K(\\vect{s}, \\vect{t})
            \\end{array} \\right)

    The amplitude of the covariance function is :math:`\\Tr{\\sigma} =(\\Tr{\\sigma}_{1}, \\dots, \\Tr{\\sigma}_{K})` and each model :math:`C_k` is parameterized by its scale :math:`\\vect{\\theta}_k \\in \\Rset^n`.

    The method :math:`setScale(\\vect{\\theta})` updates the scale the following way. Let :math:`\\vect{\\theta}_k^0=(\\theta_{k,1}^0,\\hdots,\\theta_{k,n}^0)` be the initial scale of the covariance model :math:`C_k`. After the update, :math:`C_k` has the scale :math:`\\vect{\\theta}_k=\\left(\\theta_1\\rho_{k,1}^0,\\hdots,\\theta_n\\rho_{k,n}^0\\right)` where :math:`\\rho_{k,j}^0=\\dfrac{\\theta^0_{k,j}}{\\theta^0_{1,j}}`.

    Examples
    --------

    Create a tensorized covariance function from the tensorization of an absolute exponential function, a squared exponential function and an exponential function:

    >>> import openturns as ot
    >>> spatialDimension = 2

    Create the each covariance models:

    >>> myCov1 = ot.AbsoluteExponential([3.0] * spatialDimension)
    >>> myCov2 = ot.SquaredExponential(spatialDimension *[2.0])

    >>> amplitude= [4.0, 2.0]
    >>> scale = [1.0, 1.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(spatialDimension)
    >>> spatialCorrelation[1,0] = 0.3
    >>> myCov3 = ot.ExponentialModel(scale, amplitude, spatialCorrelation)

    Define the scale of the tensorized model:

    >>> scale = [0.3, 0.8]

    Create the tensorized model:

    >>> covarianceModel = ot.TensorizedCovarianceModel([myCov1, myCov2, myCov3], scale)

    Fix the same scale to each model:

    >>> covarianceModel.setScale([1.0]*spatialDimension)
    """
    __swig_setmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorizedCovarianceModel, name, value)
    __swig_getmethods__ = {}
    for _s in [CovarianceModelImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorizedCovarianceModel, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.TensorizedCovarianceModel_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel___call__(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_partialGradient(self, *args)

    def getCollection(self): return _statistics.TensorizedCovarianceModel_getCollection(self)
    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.TensorizedCovarianceModel_getMarginal(self, *args)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_setScale(self, *args)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_setAmplitude(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.TensorizedCovarianceModel_isStationary(self)

    def isDiagonal(self):
        """
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.TensorizedCovarianceModel_isDiagonal(self)

    def __repr__(self): return _statistics.TensorizedCovarianceModel___repr__(self)
    def __str__(self, offset=""): return _statistics.TensorizedCovarianceModel___str__(self, offset)
    def __init__(self, *args): 
        this = _statistics.new_TensorizedCovarianceModel(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_TensorizedCovarianceModel
    __del__ = lambda self : None;
TensorizedCovarianceModel_swigregister = _statistics.TensorizedCovarianceModel_swigregister
TensorizedCovarianceModel_swigregister(TensorizedCovarianceModel)

class HMatrixFactory(openturns.common.PersistentObject):
    """
    Empty HMatrix builder.

    See also
    --------
    HMatrix
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixFactory_getClassName(self)

    def build(self, *args):
        """
        Create the compressed skeleton representation.

        Parameters
        ----------
        sample : 2-d sequence of float
            Vertex locations
        outputDimension : int
            Number of degrees of freedom by vertex location
        symmetric : bool
            Whether matrix is symmetric.
        parameters : :class:`~openturns.HMatrixParameters`
            User-defined settings for hmatrix

        Returns
        -------
        mat : :class:`~openturns.HMatrix`
            The compressed representation.
        """
        return _statistics.HMatrixFactory_build(self, *args)

    def IsAvailable():
        """
        Ask whether hmat support is available.

        Returns
        -------
        available : bool
            Whether hmat support is enabled.
        """
        return _statistics.HMatrixFactory_IsAvailable()

    if _newclass:IsAvailable = staticmethod(IsAvailable)
    __swig_getmethods__["IsAvailable"] = lambda x: IsAvailable
    def __repr__(self): return _statistics.HMatrixFactory___repr__(self)
    def __init__(self, *args): 
        this = _statistics.new_HMatrixFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_HMatrixFactory
    __del__ = lambda self : None;
HMatrixFactory_swigregister = _statistics.HMatrixFactory_swigregister
HMatrixFactory_swigregister(HMatrixFactory)

def HMatrixFactory_IsAvailable():
  """
    Ask whether hmat support is available.

    Returns
    -------
    available : bool
        Whether hmat support is enabled.
    """
  return _statistics.HMatrixFactory_IsAvailable()

class HMatrixRealAssemblyFunction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixRealAssemblyFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixRealAssemblyFunction, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_HMatrixRealAssemblyFunction
    __del__ = lambda self : None;
    def __call__(self, *args): return _statistics.HMatrixRealAssemblyFunction___call__(self, *args)
HMatrixRealAssemblyFunction_swigregister = _statistics.HMatrixRealAssemblyFunction_swigregister
HMatrixRealAssemblyFunction_swigregister(HMatrixRealAssemblyFunction)

class HMatrixTensorRealAssemblyFunction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixTensorRealAssemblyFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixTensorRealAssemblyFunction, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_HMatrixTensorRealAssemblyFunction
    __del__ = lambda self : None;
    def getDimension(self): return _statistics.HMatrixTensorRealAssemblyFunction_getDimension(self)
    def compute(self, *args): return _statistics.HMatrixTensorRealAssemblyFunction_compute(self, *args)
HMatrixTensorRealAssemblyFunction_swigregister = _statistics.HMatrixTensorRealAssemblyFunction_swigregister
HMatrixTensorRealAssemblyFunction_swigregister(HMatrixTensorRealAssemblyFunction)

class HMatrixClusterTree(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixClusterTree, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixClusterTree, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_HMatrixClusterTree(*args)
        try: self.this.append(this)
        except: self.this = this
    def get(self): return _statistics.HMatrixClusterTree_get(self)
    def getSize(self): return _statistics.HMatrixClusterTree_getSize(self)
    __swig_destroy__ = _statistics.delete_HMatrixClusterTree
    __del__ = lambda self : None;
HMatrixClusterTree_swigregister = _statistics.HMatrixClusterTree_swigregister
HMatrixClusterTree_swigregister(HMatrixClusterTree)

class HMatrixImplementation(openturns.common.PersistentObject):
    """
    Hierarchical matrices (or HMatrix) are a compressed representation of dense
    matrices.  In many applications, matrix coefficients represent an interaction
    between two degrees of freedom; when these interactions are smooth, it is
    possible to approximate sub-blocks by a local low-rank approximation B =~ UV^T
    where B has dimension (m,n), U (m,k), and V (n,k).
    Of course, this is interesting only if k is much lower than m and n.

    In order to obtain this compressed representation, several different steps must
    be performed:

    1. Clustering: creation of rows and columns cluster trees
       Vertices where interactions are computed are reordered to improve locality.
       A binary space partition algorithm is used to recursively divide vertex set.
       Root cell contains all vertices.  At each recursion step, a cell is divided
       into two new cells until it contains less than a given number of vertices.
       Space partition is performed orthogonally to original axis, by cutting its
       longest dimension.

       * The 'median' clustering algorithm divides a cell into two cells containing
         the same number of degrees of freedom.
       * The 'geometric' clustering algorithm divides a cell into two cells of the
         same geometric size
       * The 'hybrid' clustering algorithm is a mix.  It first performs a 'median'
         bisection; if volumes of these new cells are very different, a 'geometric'
         clustering is performed instead.

    2. Admissibility: creation of an empty HMatrix structure
       The first step created a full binary tree for rows and columns degrees of
       freedom.  We will now create a hierarchical representation of our matrix by
       checking whether some blocks can be replaced by low-rank approximations.
       The whole matrix represents the interactions of all rows degrees of freedom
       against all columns degrees of freedom.  It can not be approximated by a
       low-rank approximation, and thus it is replaced by 4 blocks obtained by
       considering interactions between rows and columns children nodes.  This
       operation is performed recursively.  At each step, we compute axis aligned
       bounding boxes rows_bbox and cols_bbox: if
       min(diameter(rows_bbox), diameter(cols_bbox)) <= eta*distance(rows_bbox, cols_bbox)
       then we consider that interaction between rows and columns degrees of
       freedom can have a local low-rank approximation, and recursion is stopped.
       Otherwise, we recurse until bottom cluster tree is reached.
       The whole matrix is thus represented by a 4-tree where leaves will contain
       either low-rank approximation or full blocks.
       The eta parameter is called the admissibility factor, and it can be modified.

    3. Assembly: coefficients computations
       The hierarchical structure of the matrix has been computed during step 2.
       To compute coefficients, we call the assembleReal method and provide a
       callable to compute interaction between two nodes.  Full blocks are computed
       by calling this callable for the whole block.  If compression method is
       'SVD', low-rank approximation is computed by first computing the whole
       block, then finding its singular value decomposition, and rank is truncated
       so that error does not exceed assemblyEpsilon.  This method is precise, but
       very costly.  If compression method is a variant of ACA, only few rows and
       columns are computed.  This is much more efficient, but error may be larger
       than expected on some problems.

    4. Matrix computations
       Once an HMatrix is computed, usual linear algebra operations can be
       performed.  Matrix can be factorized in-place, in order to solve systems.
       Or we can compute its product by a matrix or vector.  But keep in mind that
       rows and columns are reordered internally, and thus results may differ
       sensibly from standard dense representation (for instance when computing a
       Cholesky or LU decomposition).

    See also
    --------
    HMatrixFactory, HMatrixParameters
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixImplementation_getClassName(self)

    def __init__(self, *args): 
        this = _statistics.new_HMatrixImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_HMatrixImplementation
    __del__ = lambda self : None;
    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        nbRows : int
            Number of rows.
        """
        return _statistics.HMatrixImplementation_getNbRows(self)

    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        nbColumns : int
            Number of columns.
        """
        return _statistics.HMatrixImplementation_getNbColumns(self)

    def assemble(self, *args): return _statistics.HMatrixImplementation_assemble(self, *args)
    def factorize(self, *args):
        """
        Factorize matrix.

        Parameters
        ----------
        method : str
            Factorization method, either one of: LDLt, LLt or LU
        """
        return _statistics.HMatrixImplementation_factorize(self, *args)

    def gemv(self, *args):
        """
        Multiply vector in-place y=alpha*op(A)*x+beta*y.

        Parameters
        ----------
        trans : str
            Whether to use A or A^t: either N or T.
        alpha : float
            Coefficient
        x : sequence of float
            Vector to multiply.
        beta : float
            Coefficient.
        y : :class:`~openturns.NumericalPoint`
            Vector multiplied in-place.
        """
        return _statistics.HMatrixImplementation_gemv(self, *args)

    def gemm(self, *args):
        """
        Multiply matrix in-place self=alpha*op(A)*op(B)+beta*self.

        Parameters
        ----------
        transA : str
            Whether to use A or A^t: either N or T.
        transB : str
            Whether to use B or B^t: either N or T.
        alpha : float
            Coefficient
        a : :class:`~openturns.HMatrix`
            Multiplied matrix A.
        b : :class:`~openturns.HMatrix`
            Multiplied matrix B.    
        beta : float
            Coefficient.
        """
        return _statistics.HMatrixImplementation_gemm(self, *args)

    def transpose(self):
        """Transpose matrix in-place."""
        return _statistics.HMatrixImplementation_transpose(self)

    def norm(self):
        """
        Compute norm value.

        Returns
        -------
        norm : float
            Frobenius norm.
        """
        return _statistics.HMatrixImplementation_norm(self)

    def getDiagonal(self):
        """
        Diagonal values accessor.

        Returns
        -------
        diag : :class:`~openturns.NumericalPoint`
            Diagonal values.
        """
        return _statistics.HMatrixImplementation_getDiagonal(self)

    def solve(self, *args):
        """
        Solve linear system op(A)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with A (False) or A^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.NumericalPoint` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrixImplementation_solve(self, *args)

    def solveLower(self, *args):
        """
        Solve lower linear system op(L)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with L (False) or L^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.NumericalPoint` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrixImplementation_solveLower(self, *args)

    def compressionRatio(self):
        """
        Compression ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in the compressed and uncompressed forms.
        """
        return _statistics.HMatrixImplementation_compressionRatio(self)

    def fullrkRatio(self):
        """
        Block ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in full blocks and low rank blocks.
        """
        return _statistics.HMatrixImplementation_fullrkRatio(self)

    def dump(self, *args):
        """
        Save matrix to a file.

        Parameters
        ----------
        fileName : str
            File name to save to.
        """
        return _statistics.HMatrixImplementation_dump(self, *args)

    def setKey(self, *args): return _statistics.HMatrixImplementation_setKey(self, *args)
    def __repr__(self): return _statistics.HMatrixImplementation___repr__(self)
    def __str__(self, offset=""): return _statistics.HMatrixImplementation___str__(self, offset)
HMatrixImplementation_swigregister = _statistics.HMatrixImplementation_swigregister
HMatrixImplementation_swigregister(HMatrixImplementation)

class CovarianceAssemblyFunction(HMatrixRealAssemblyFunction):
    __swig_setmethods__ = {}
    for _s in [HMatrixRealAssemblyFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceAssemblyFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [HMatrixRealAssemblyFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceAssemblyFunction, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_CovarianceAssemblyFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    def __call__(self, *args): return _statistics.CovarianceAssemblyFunction___call__(self, *args)
    __swig_destroy__ = _statistics.delete_CovarianceAssemblyFunction
    __del__ = lambda self : None;
CovarianceAssemblyFunction_swigregister = _statistics.CovarianceAssemblyFunction_swigregister
CovarianceAssemblyFunction_swigregister(CovarianceAssemblyFunction)

class CovarianceBlockAssemblyFunction(HMatrixTensorRealAssemblyFunction):
    __swig_setmethods__ = {}
    for _s in [HMatrixTensorRealAssemblyFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceBlockAssemblyFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [HMatrixTensorRealAssemblyFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceBlockAssemblyFunction, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_CovarianceBlockAssemblyFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    def compute(self, *args): return _statistics.CovarianceBlockAssemblyFunction_compute(self, *args)
    __swig_destroy__ = _statistics.delete_CovarianceBlockAssemblyFunction
    __del__ = lambda self : None;
CovarianceBlockAssemblyFunction_swigregister = _statistics.CovarianceBlockAssemblyFunction_swigregister
CovarianceBlockAssemblyFunction_swigregister(CovarianceBlockAssemblyFunction)

class HMatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrixImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrixImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_HMatrixImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _statistics.HMatrixImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_HMatrixImplementationTypedInterfaceObject
    __del__ = lambda self : None;
HMatrixImplementationTypedInterfaceObject_swigregister = _statistics.HMatrixImplementationTypedInterfaceObject_swigregister
HMatrixImplementationTypedInterfaceObject_swigregister(HMatrixImplementationTypedInterfaceObject)

class pairlonglong(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, pairlonglong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, pairlonglong, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _statistics.new_pairlonglong(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_setmethods__["first"] = _statistics.pairlonglong_first_set
    __swig_getmethods__["first"] = _statistics.pairlonglong_first_get
    if _newclass:first = _swig_property(_statistics.pairlonglong_first_get, _statistics.pairlonglong_first_set)
    __swig_setmethods__["second"] = _statistics.pairlonglong_second_set
    __swig_getmethods__["second"] = _statistics.pairlonglong_second_get
    if _newclass:second = _swig_property(_statistics.pairlonglong_second_get, _statistics.pairlonglong_second_set)
    def __len__(self): return 2
    def __repr__(self): return str((self.first, self.second))
    def __getitem__(self, index): 
      if not (index % 2): 
        return self.first
      else:
        return self.second
    def __setitem__(self, index, val):
      if not (index % 2): 
        self.first = val
      else:
        self.second = val
    __swig_destroy__ = _statistics.delete_pairlonglong
    __del__ = lambda self : None;
pairlonglong_swigregister = _statistics.pairlonglong_swigregister
pairlonglong_swigregister(pairlonglong)

class HMatrix(HMatrixImplementationTypedInterfaceObject):
    """
    Hierarchical matrices (or HMatrix) are a compressed representation of dense
    matrices.  In many applications, matrix coefficients represent an interaction
    between two degrees of freedom; when these interactions are smooth, it is
    possible to approximate sub-blocks by a local low-rank approximation B =~ UV^T
    where B has dimension (m,n), U (m,k), and V (n,k).
    Of course, this is interesting only if k is much lower than m and n.

    In order to obtain this compressed representation, several different steps must
    be performed:

    1. Clustering: creation of rows and columns cluster trees
       Vertices where interactions are computed are reordered to improve locality.
       A binary space partition algorithm is used to recursively divide vertex set.
       Root cell contains all vertices.  At each recursion step, a cell is divided
       into two new cells until it contains less than a given number of vertices.
       Space partition is performed orthogonally to original axis, by cutting its
       longest dimension.

       * The 'median' clustering algorithm divides a cell into two cells containing
         the same number of degrees of freedom.
       * The 'geometric' clustering algorithm divides a cell into two cells of the
         same geometric size
       * The 'hybrid' clustering algorithm is a mix.  It first performs a 'median'
         bisection; if volumes of these new cells are very different, a 'geometric'
         clustering is performed instead.

    2. Admissibility: creation of an empty HMatrix structure
       The first step created a full binary tree for rows and columns degrees of
       freedom.  We will now create a hierarchical representation of our matrix by
       checking whether some blocks can be replaced by low-rank approximations.
       The whole matrix represents the interactions of all rows degrees of freedom
       against all columns degrees of freedom.  It can not be approximated by a
       low-rank approximation, and thus it is replaced by 4 blocks obtained by
       considering interactions between rows and columns children nodes.  This
       operation is performed recursively.  At each step, we compute axis aligned
       bounding boxes rows_bbox and cols_bbox: if
       min(diameter(rows_bbox), diameter(cols_bbox)) <= eta*distance(rows_bbox, cols_bbox)
       then we consider that interaction between rows and columns degrees of
       freedom can have a local low-rank approximation, and recursion is stopped.
       Otherwise, we recurse until bottom cluster tree is reached.
       The whole matrix is thus represented by a 4-tree where leaves will contain
       either low-rank approximation or full blocks.
       The eta parameter is called the admissibility factor, and it can be modified.

    3. Assembly: coefficients computations
       The hierarchical structure of the matrix has been computed during step 2.
       To compute coefficients, we call the assembleReal method and provide a
       callable to compute interaction between two nodes.  Full blocks are computed
       by calling this callable for the whole block.  If compression method is
       'SVD', low-rank approximation is computed by first computing the whole
       block, then finding its singular value decomposition, and rank is truncated
       so that error does not exceed assemblyEpsilon.  This method is precise, but
       very costly.  If compression method is a variant of ACA, only few rows and
       columns are computed.  This is much more efficient, but error may be larger
       than expected on some problems.

    4. Matrix computations
       Once an HMatrix is computed, usual linear algebra operations can be
       performed.  Matrix can be factorized in-place, in order to solve systems.
       Or we can compute its product by a matrix or vector.  But keep in mind that
       rows and columns are reordered internally, and thus results may differ
       sensibly from standard dense representation (for instance when computing a
       Cholesky or LU decomposition).

    See also
    --------
    HMatrixFactory, HMatrixParameters
    """
    __swig_setmethods__ = {}
    for _s in [HMatrixImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [HMatrixImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMatrix, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrix_getClassName(self)

    def getNbRows(self):
        """
        Accessor to the number of rows.

        Returns
        -------
        nbRows : int
            Number of rows.
        """
        return _statistics.HMatrix_getNbRows(self)

    def getNbColumns(self):
        """
        Accessor to the number of columns.

        Returns
        -------
        nbColumns : int
            Number of columns.
        """
        return _statistics.HMatrix_getNbColumns(self)

    def factorize(self, *args):
        """
        Factorize matrix.

        Parameters
        ----------
        method : str
            Factorization method, either one of: LDLt, LLt or LU
        """
        return _statistics.HMatrix_factorize(self, *args)

    def gemv(self, *args):
        """
        Multiply vector in-place y=alpha*op(A)*x+beta*y.

        Parameters
        ----------
        trans : str
            Whether to use A or A^t: either N or T.
        alpha : float
            Coefficient
        x : sequence of float
            Vector to multiply.
        beta : float
            Coefficient.
        y : :class:`~openturns.NumericalPoint`
            Vector multiplied in-place.
        """
        return _statistics.HMatrix_gemv(self, *args)

    def gemm(self, *args):
        """
        Multiply matrix in-place self=alpha*op(A)*op(B)+beta*self.

        Parameters
        ----------
        transA : str
            Whether to use A or A^t: either N or T.
        transB : str
            Whether to use B or B^t: either N or T.
        alpha : float
            Coefficient
        a : :class:`~openturns.HMatrix`
            Multiplied matrix A.
        b : :class:`~openturns.HMatrix`
            Multiplied matrix B.    
        beta : float
            Coefficient.
        """
        return _statistics.HMatrix_gemm(self, *args)

    def transpose(self):
        """Transpose matrix in-place."""
        return _statistics.HMatrix_transpose(self)

    def norm(self):
        """
        Compute norm value.

        Returns
        -------
        norm : float
            Frobenius norm.
        """
        return _statistics.HMatrix_norm(self)

    def getDiagonal(self):
        """
        Diagonal values accessor.

        Returns
        -------
        diag : :class:`~openturns.NumericalPoint`
            Diagonal values.
        """
        return _statistics.HMatrix_getDiagonal(self)

    def solve(self, *args):
        """
        Solve linear system op(A)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with A (False) or A^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.NumericalPoint` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrix_solve(self, *args)

    def solveLower(self, *args):
        """
        Solve lower linear system op(L)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with L (False) or L^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.NumericalPoint` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrix_solveLower(self, *args)

    def compressionRatio(self):
        """
        Compression ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in the compressed and uncompressed forms.
        """
        return _statistics.HMatrix_compressionRatio(self)

    def fullrkRatio(self):
        """
        Block ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in full blocks and low rank blocks.
        """
        return _statistics.HMatrix_fullrkRatio(self)

    def dump(self, *args):
        """
        Save matrix to a file.

        Parameters
        ----------
        fileName : str
            File name to save to.
        """
        return _statistics.HMatrix_dump(self, *args)

    def __repr__(self): return _statistics.HMatrix___repr__(self)
    def __str__(self, offset=""): return _statistics.HMatrix___str__(self, offset)
    def __eq__(self, *args): return _statistics.HMatrix___eq__(self, *args)
    def __init__(self, *args): 
        this = _statistics.new_HMatrix(*args)
        try: self.this.append(this)
        except: self.this = this
    def assembleReal(self, *args):
        """
        Assemble matrix.

        Parameters
        ----------
        f : assembly function
            Callable that takes i,j int parameters and returns a float
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrix_assembleReal(self, *args)

    def assembleTensor(self, *args):
        """
        Assemble matrix by block.

        Parameters
        ----------
        f : assembly function
            Callable that takes i,j int parameters and returns a Matrix
        outputDimension : int
            Block dimension
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrix_assembleTensor(self, *args)

    __swig_destroy__ = _statistics.delete_HMatrix
    __del__ = lambda self : None;
HMatrix_swigregister = _statistics.HMatrix_swigregister
HMatrix_swigregister(HMatrix)

class CovarianceModelImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CovarianceModelImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CovarianceModelImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _statistics.CovarianceModelImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _statistics.CovarianceModelImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_statistics.CovarianceModelImplementationPointer_ptr__get, _statistics.CovarianceModelImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _statistics.new_CovarianceModelImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _statistics.CovarianceModelImplementationPointer_reset(self)
    def __ref__(self, *args): return _statistics.CovarianceModelImplementationPointer___ref__(self, *args)
    def __deref__(self): return _statistics.CovarianceModelImplementationPointer___deref__(self)
    def isNull(self): return _statistics.CovarianceModelImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _statistics.CovarianceModelImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _statistics.CovarianceModelImplementationPointer_get(self)
    def getImplementation(self): return _statistics.CovarianceModelImplementationPointer_getImplementation(self)
    def unique(self): return _statistics.CovarianceModelImplementationPointer_unique(self)
    def use_count(self): return _statistics.CovarianceModelImplementationPointer_use_count(self)
    def swap(self, *args): return _statistics.CovarianceModelImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelImplementationPointer_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension :math:`n` of the covariance function.

        Returns
        -------
        spatialDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \\cD \\times \\cD \\mapsto \\cS_d^+(\\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModelImplementationPointer_getDimension(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer___call__(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.CovarianceModelImplementationPointer_computeStandardRepresentative(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.CovarianceModelImplementationPointer_computeAsScalar(self, *args)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_partialGradient(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.CovarianceModelImplementationPointer_discretize(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.CovarianceModelImplementationPointer_discretizeRow(self, *args)

    def discretizeAndFactorize(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\\in \\cM_{nd\\times nd}(\\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModelImplementationPointer_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        """
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\\in\\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementationPointer_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementationPointer_discretizeAndFactorizeHMatrix(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.CovarianceModelImplementationPointer_isStationary(self)

    def isDiagonal(self):
        """
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModelImplementationPointer_isDiagonal(self)

    def getAmplitude(self):
        """
        Get the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModelImplementationPointer_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+(\\Rset)`.
        """
        return _statistics.CovarianceModelImplementationPointer_getSpatialCorrelation(self)

    def setSpatialCorrelation(self, *args):
        """
        Set the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModelImplementationPointer_setSpatialCorrelation(self, *args)

    def setNuggetFactor(self, *args):
        """
        Set the nugget factor for the regularization.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used for the regularization of the discretized
            covariance matrix.
        """
        return _statistics.CovarianceModelImplementationPointer_setNuggetFactor(self, *args)

    def getNuggetFactor(self):
        """
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used for the regularization of the discretized covariance
            matrix.
        """
        return _statistics.CovarianceModelImplementationPointer_getNuggetFactor(self)

    def setParameter(self, *args):
        """
        Set the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModelImplementationPointer_setParameter(self, *args)

    def getParameter(self):
        """
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPoint`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModelImplementationPointer_getParameter(self)

    def getParameterDescription(self):
        """
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModelImplementationPointer_getParameterDescription(self)

    def setActiveParameter(self, *args):
        """
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementationPointer_setActiveParameter(self, *args)

    def getActiveParameter(self):
        """
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementationPointer_getActiveParameter(self)

    def __repr__(self): return _statistics.CovarianceModelImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _statistics.CovarianceModelImplementationPointer___str__(self, offset)
    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.CovarianceModelImplementationPointer_getMarginal(self, *args)

    def __eq__(self, *args): return _statistics.CovarianceModelImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _statistics.CovarianceModelImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.CovarianceModelImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.CovarianceModelImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.CovarianceModelImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.CovarianceModelImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationPointer_setName(self, *args)

CovarianceModelImplementationPointer_swigregister = _statistics.CovarianceModelImplementationPointer_swigregister
CovarianceModelImplementationPointer_swigregister(CovarianceModelImplementationPointer)

class SpectralModelImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralModelImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralModelImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _statistics.SpectralModelImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _statistics.SpectralModelImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_statistics.SpectralModelImplementationPointer_ptr__get, _statistics.SpectralModelImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _statistics.new_SpectralModelImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SpectralModelImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _statistics.SpectralModelImplementationPointer_reset(self)
    def __ref__(self, *args): return _statistics.SpectralModelImplementationPointer___ref__(self, *args)
    def __deref__(self): return _statistics.SpectralModelImplementationPointer___deref__(self)
    def isNull(self): return _statistics.SpectralModelImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _statistics.SpectralModelImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _statistics.SpectralModelImplementationPointer_get(self)
    def getImplementation(self): return _statistics.SpectralModelImplementationPointer_getImplementation(self)
    def unique(self): return _statistics.SpectralModelImplementationPointer_unique(self)
    def use_count(self): return _statistics.SpectralModelImplementationPointer_use_count(self)
    def swap(self, *args): return _statistics.SpectralModelImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelImplementationPointer_getClassName(self)

    def getDimension(self):
        """
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementationPointer_getDimension(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementationPointer_getSpatialDimension(self)

    def __call__(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModelImplementationPointer___call__(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SpectralModelImplementationPointer_computeStandardRepresentative(self, *args)

    def getFrequencyGrid(self):
        """
        Return the RegularGrid associated to the SpectralModel.

        Returns
        -------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModelImplementationPointer_getFrequencyGrid(self)

    def setFrequencyGrid(self, *args):
        """
        Set the RegularGrid associated to the SpectralModel.

        Parameters
        ----------
        grid : :class:`~openturns.RegularGrid`
            Associated frequency grid of the SpectralModel.
        """
        return _statistics.SpectralModelImplementationPointer_setFrequencyGrid(self, *args)

    def getAmplitude(self):
        """
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The used amplitude parameter.
        """
        return _statistics.SpectralModelImplementationPointer_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModelImplementationPointer_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The used scale parameter.
        """
        return _statistics.SpectralModelImplementationPointer_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModelImplementationPointer_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\mathcal{M}_{dimension \\times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModelImplementationPointer_getSpatialCorrelation(self)

    def __repr__(self): return _statistics.SpectralModelImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _statistics.SpectralModelImplementationPointer___str__(self, offset)
    def draw(self, rowIndex=0, columnIndex=0, module=True):
        """
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int
            i-th row component to draw.
            Default value is 0

        columnIndex : int
            j-th column component to draw .
            Default value is 0

        module : bool
            Tells if module has to be drawn(True) or if it is
            the argument to be drawn (False).
            Default value is True.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        Notes
        -----
        The method plots a specific component of the spectral density function over a frequency grid. Thus, this last one should be specified thanks to the `setFrequencyGrid` method.
        """
        return _statistics.SpectralModelImplementationPointer_draw(self, rowIndex, columnIndex, module)

    def __eq__(self, *args): return _statistics.SpectralModelImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _statistics.SpectralModelImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.SpectralModelImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.SpectralModelImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.SpectralModelImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.SpectralModelImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationPointer_setName(self, *args)

SpectralModelImplementationPointer_swigregister = _statistics.SpectralModelImplementationPointer_swigregister
SpectralModelImplementationPointer_swigregister(SpectralModelImplementationPointer)

class SecondOrderModelImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SecondOrderModelImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SecondOrderModelImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _statistics.SecondOrderModelImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _statistics.SecondOrderModelImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_statistics.SecondOrderModelImplementationPointer_ptr__get, _statistics.SecondOrderModelImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _statistics.new_SecondOrderModelImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_SecondOrderModelImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _statistics.SecondOrderModelImplementationPointer_reset(self)
    def __ref__(self, *args): return _statistics.SecondOrderModelImplementationPointer___ref__(self, *args)
    def __deref__(self): return _statistics.SecondOrderModelImplementationPointer___deref__(self)
    def isNull(self): return _statistics.SecondOrderModelImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _statistics.SecondOrderModelImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _statistics.SecondOrderModelImplementationPointer_get(self)
    def getImplementation(self): return _statistics.SecondOrderModelImplementationPointer_getImplementation(self)
    def unique(self): return _statistics.SecondOrderModelImplementationPointer_unique(self)
    def use_count(self): return _statistics.SecondOrderModelImplementationPointer_use_count(self)
    def swap(self, *args): return _statistics.SecondOrderModelImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SecondOrderModelImplementationPointer_getClassName(self)

    def getSpatialDimension(self):
        """
        Get the spatial dimension of the spectral density function.

        Returns
        -------
        spatialDimension : int
            SpatialDimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModelImplementationPointer_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the *SecondOrderModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SecondOrderModel*.
        """
        return _statistics.SecondOrderModelImplementationPointer_getDimension(self)

    def computeCovariance(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            computeCovariance(s, t)

            computeCovariance(tau)

        Parameters
        ----------
        s, t : floats or sequence of floats.
            Inputs.
        tau : float or sequence of floats.
            Input.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.

        Notes
        -----
        *computeCovariance* evaluates the covariance model
        :math:`C : \\cD \\times \\cD \\mapsto  \\cM_{d \\times d}(\\Rset)` at
        :math:`(s,t)\\in \\Rset^n`:

        .. math::

            C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}


        We note that the first usage calls the second as model is stationary. Thus,
         :math:`C(\\vect{s}, \\vect{t})` = :math:`C^{stat}(\\vect{\\tau})` with
         :math:`\\vect{\\tau}=\\vect{s}-\\vect{t}`. 
        """
        return _statistics.SecondOrderModelImplementationPointer_computeCovariance(self, *args)

    def getSpectralModel(self):
        """
        Return the spectral model.

        Returns
        -------
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModelImplementationPointer_getSpectralModel(self)

    def getCovarianceModel(self):
        """
        Return the covariance model.

        Returns
        -------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        """
        return _statistics.SecondOrderModelImplementationPointer_getCovarianceModel(self)

    def setModels(self, *args):
        """
        Set both the covariance and spectral models of a second order model.

        Parameters
        ----------
        covarianceModel : :class:`~openturns.CovarianceModel`
            The covariance model of the second order model.
        spectralModel : :class:`~openturns.SpectralModel`
            The spectral model of the second order model.
        """
        return _statistics.SecondOrderModelImplementationPointer_setModels(self, *args)

    def discretize(self, *args):
        """
        Discretize the second order  on a given RegularGrid/Mesh model using its covariance function.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in\\cM_{nd\\times nd}(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the covariance model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.SecondOrderModelImplementationPointer_discretize(self, *args)

    def computeSpectralDensity(self, *args):
        """
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.

        Notes
        -----
        *computeSpectralDensity* evaluates the spectral model :math:`S : \\Rset^n \\mapsto  \\cH^+_{d}` at :math:`f\\in \\Rset^n`:

        .. math::

          \\forall \\vect{f} \\in \\Rset^n, \\cS(\\vect{f}) = \\prod_{k=1}^{n} \\vect{\\theta}_k \\mat{\\Sigma} \\rho(\\vect{f} \\odot \\vect{\\theta})

        where :math:`\\mat{\\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\\vect{f} \\odot \\vect{\\theta})_k = \\vect{f}_k \\vect{\\theta}_k`
        """
        return _statistics.SecondOrderModelImplementationPointer_computeSpectralDensity(self, *args)

    def __repr__(self): return _statistics.SecondOrderModelImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _statistics.SecondOrderModelImplementationPointer___str__(self, offset)
    def __eq__(self, *args): return _statistics.SecondOrderModelImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _statistics.SecondOrderModelImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.SecondOrderModelImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.SecondOrderModelImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.SecondOrderModelImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.SecondOrderModelImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.SecondOrderModelImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.SecondOrderModelImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.SecondOrderModelImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SecondOrderModelImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SecondOrderModelImplementationPointer_setName(self, *args)

SecondOrderModelImplementationPointer_swigregister = _statistics.SecondOrderModelImplementationPointer_swigregister
SecondOrderModelImplementationPointer_swigregister(SecondOrderModelImplementationPointer)

class StationaryCovarianceModelPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StationaryCovarianceModelPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StationaryCovarianceModelPointer, name)
    __swig_setmethods__["ptr_"] = _statistics.StationaryCovarianceModelPointer_ptr__set
    __swig_getmethods__["ptr_"] = _statistics.StationaryCovarianceModelPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_statistics.StationaryCovarianceModelPointer_ptr__get, _statistics.StationaryCovarianceModelPointer_ptr__set)
    def __init__(self, *args): 
        this = _statistics.new_StationaryCovarianceModelPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModelPointer
    __del__ = lambda self : None;
    def reset(self): return _statistics.StationaryCovarianceModelPointer_reset(self)
    def __ref__(self, *args): return _statistics.StationaryCovarianceModelPointer___ref__(self, *args)
    def __deref__(self): return _statistics.StationaryCovarianceModelPointer___deref__(self)
    def isNull(self): return _statistics.StationaryCovarianceModelPointer_isNull(self)
    def __nonzero__(self):
        return _statistics.StationaryCovarianceModelPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _statistics.StationaryCovarianceModelPointer_get(self)
    def getImplementation(self): return _statistics.StationaryCovarianceModelPointer_getImplementation(self)
    def unique(self): return _statistics.StationaryCovarianceModelPointer_unique(self)
    def use_count(self): return _statistics.StationaryCovarianceModelPointer_use_count(self)
    def swap(self, *args): return _statistics.StationaryCovarianceModelPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModelPointer_getClassName(self)

    def __call__(self, *args):
        """
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer___call__(self, *args)

    def computeAsScalar(self, *args):
        """
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the  dimension of the process is :math:`d=1`. It
         evaluates :math:`C(\\vect{s}, \\vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\\vect{\\tau})` for :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as
        this quantity does not depend on :math:`\\vect{s}`.
        """
        return _statistics.StationaryCovarianceModelPointer_computeAsScalar(self, *args)

    def computeStandardRepresentative(self, *args):
        """
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.
        tau : float or sequence of float
            Multivariate index :math:`\\vect{\\tau} \\in \\cD`.

        Returns
        -------
        rho : float
            Correlation model :math:`\\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\\rho\\left(\\dfrac{\\vect{s}}{\\theta}, \\dfrac{\\vect{t}}{\\theta}\\right)` or 
        :math:`\\rho\\left(\\dfrac{\\vect{\\tau}}{\\theta}\\right)` if the model is stationary.
        """
        return _statistics.StationaryCovarianceModelPointer_computeStandardRepresentative(self, *args)

    def discretize(self, *args):
        """
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \\mat{C}_{1,\\dots,k} = \\left(
                \\begin{array}{cccc}
                C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\dots & 
                C(\\vect{t}_1, \\vect{t}_{k}) \\\\
                \\dots & C(\\vect{t}_2, \\vect{t}_2)  & \\dots & 
                C(\\vect{t}_2, \\vect{t}_{k}) \\\\
                \\dots & \\dots & \\dots & \\dots \\\\
                \\dots & \\dots & \\dots & C(\\vect{t}_{k}, \\vect{t}_{k})
                \\end{array} \\right)
        """
        return _statistics.StationaryCovarianceModelPointer_discretize(self, *args)

    def isStationary(self):
        """
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \\forall(\\vect{s},\\vect{t},\\vect{h}) \\in \\cD \\times \\cD, & \\, \\quad
            C(\\vect{s}, \\vect{s}+\\vect{h}) = C(\\vect{t}, \\vect{t}+\\vect{h})

        We note :math:`C^{stat}(\\vect{\\tau})` for 
                :math:`C(\\vect{s}, \\vect{s}+\\vect{\\tau})`.
        """
        return _statistics.StationaryCovarianceModelPointer_isStationary(self)

    def __repr__(self): return _statistics.StationaryCovarianceModelPointer___repr__(self)
    def __str__(self, offset=""): return _statistics.StationaryCovarianceModelPointer___str__(self, offset)
    def getSpatialDimension(self):
        """
        Get the spatial dimension :math:`n` of the covariance function.

        Returns
        -------
        spatialDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \\cD \\times \\cD \\mapsto \\cS_d^+(\\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.StationaryCovarianceModelPointer_getDimension(self)

    def partialGradient(self, *args):
        """
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\\vect{s}, \\vect{t}) \\in \\cD \\times \\cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_partialGradient(self, *args)

    def discretizeRow(self, *args):
        """**(TODO)**"""
        return _statistics.StationaryCovarianceModelPointer_discretizeRow(self, *args)

    def discretizeAndFactorize(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\\in \\cM_{nd\\times nd}(\\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\\vect{t}_1, \\dots, \\vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.StationaryCovarianceModelPointer_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        """
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\\in\\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.StationaryCovarianceModelPointer_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        """
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        nuggetFactor: float
            nugget factor to be added to the discretized matrix
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\\in \\cS_{nd}^+(\\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, NumericalSample) 
        as its compress data.

        """
        return _statistics.StationaryCovarianceModelPointer_discretizeAndFactorizeHMatrix(self, *args)

    def isDiagonal(self):
        """
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.StationaryCovarianceModelPointer_isDiagonal(self)

    def getAmplitude(self):
        """
        Get the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance 
            function.
        """
        return _statistics.StationaryCovarianceModelPointer_getAmplitude(self)

    def setAmplitude(self, *args):
        """
        Set the amplitude parameter :math:`\\vect{\\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.NumericalPoint`
            The amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_setAmplitude(self, *args)

    def getScale(self):
        """
        Get the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` used in the 
            covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_getScale(self)

    def setScale(self, *args):
        """
        Set the scale parameter :math:`\\vect{\\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.NumericalPoint`
            The scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` to be used in the
            covariance function.
            Its size must be equal to the spatial dimension of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_setScale(self, *args)

    def getSpatialCorrelation(self):
        """
        Get the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+(\\Rset)`.
        """
        return _statistics.StationaryCovarianceModelPointer_getSpatialCorrelation(self)

    def setSpatialCorrelation(self, *args):
        """
        Set the spatial correlation matrix :math:`\\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\\mat{R} \\in \\cS_d^+([-1,1])`.
        """
        return _statistics.StationaryCovarianceModelPointer_setSpatialCorrelation(self, *args)

    def setNuggetFactor(self, *args):
        """
        Set the nugget factor for the regularization.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used for the regularization of the discretized
            covariance matrix.
        """
        return _statistics.StationaryCovarianceModelPointer_setNuggetFactor(self, *args)

    def getNuggetFactor(self):
        """
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used for the regularization of the discretized covariance
            matrix.
        """
        return _statistics.StationaryCovarianceModelPointer_getNuggetFactor(self)

    def setParameter(self, *args):
        """
        Set the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.StationaryCovarianceModelPointer_setParameter(self, *args)

    def getParameter(self):
        """
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPoint`
            List of the scale parameter :math:`\\vect{\\theta} \\in \\Rset^n` and the
            amplitude parameter :math:`\\vect{\\sigma} \\in \\Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.StationaryCovarianceModelPointer_getParameter(self)

    def getParameterDescription(self):
        """
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.StationaryCovarianceModelPointer_getParameterDescription(self)

    def setActiveParameter(self, *args):
        """
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.StationaryCovarianceModelPointer_setActiveParameter(self, *args)

    def getActiveParameter(self):
        """
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.StationaryCovarianceModelPointer_getActiveParameter(self)

    def getMarginal(self, *args):
        """
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int
            index of marginal of the model.
        """
        return _statistics.StationaryCovarianceModelPointer_getMarginal(self, *args)

    def __eq__(self, *args): return _statistics.StationaryCovarianceModelPointer___eq__(self, *args)
    def __ne__(self, *args): return _statistics.StationaryCovarianceModelPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.StationaryCovarianceModelPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.StationaryCovarianceModelPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.StationaryCovarianceModelPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.StationaryCovarianceModelPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.StationaryCovarianceModelPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.StationaryCovarianceModelPointer_setName(self, *args)

StationaryCovarianceModelPointer_swigregister = _statistics.StationaryCovarianceModelPointer_swigregister
StationaryCovarianceModelPointer_swigregister(StationaryCovarianceModelPointer)

# This file is compatible with both classic and new-style classes.


