# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Random vectors.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_randomvector', [dirname(__file__)])
        except ImportError:
            import _randomvector
            return _randomvector
        if fp is not None:
            try:
                _mod = imp.load_module('_randomvector', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _randomvector = swig_import_helper()
    del swig_import_helper
else:
    import _randomvector
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _randomvector.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _randomvector.SwigPyIterator_value(self)
    def incr(self, n=1): return _randomvector.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _randomvector.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _randomvector.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _randomvector.SwigPyIterator_equal(self, *args)
    def copy(self): return _randomvector.SwigPyIterator_copy(self)
    def next(self): return _randomvector.SwigPyIterator_next(self)
    def __next__(self): return _randomvector.SwigPyIterator___next__(self)
    def previous(self): return _randomvector.SwigPyIterator_previous(self)
    def advance(self, *args): return _randomvector.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _randomvector.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _randomvector.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _randomvector.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _randomvector.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _randomvector.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _randomvector.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _randomvector.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _randomvector.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
class ProcessImplementation(openturns.common.PersistentObject):
    """
    Base class for stochastic processes.

    Notes
    -----
    The Process class enables to model a stochastic process.

    A multivariate stochastic process :math:`X` of dimension :math:`d` is defined
    by:

    .. math::

        X: \\Omega \\times\\cD \\mapsto \\Rset^d

    where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of
    :math:`\\Rset^n` discretized on the mesh :math:`\\cM`, :math:`\\vect{t}\\in \\cD` is
    a multivariate index and :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    A realization of the process :math:`X`, for a given :math:`\\omega \\in \\Omega`
    is :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` defined by:

    .. math::

        X(\\omega)(\\vect{t}) = X(\\omega, \\vect{t})

    :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` is the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by:

    .. math::

        X_{\\vect{t}}(\\omega) = X(\\omega, \\vect{t})


    A Process object can be created only through its derived classes:

    :class:`~openturns.SpectralNormalProcess`,
    :class:`~openturns.TemporalNormalProcess`,
    :class:`~openturns.CompositeProcess`, :class:`~openturns.ARMA`,
    :class:`~openturns.RandomWalk`, :class:`~openturns.FunctionalBasisProcess`
    and :class:`~openturns.WhiteNoise`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ProcessImplementation_getClassName(self)

    def __repr__(self): return _randomvector.ProcessImplementation___repr__(self)
    def __str__(self, offset=""): return _randomvector.ProcessImplementation___str__(self, offset)
    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.ProcessImplementation_isNormal(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _randomvector.ProcessImplementation_isStationary(self)

    def isComposite(self):
        """
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.ProcessImplementation_isComposite(self)

    def getCovarianceModel(self): return _randomvector.ProcessImplementation_getCovarianceModel(self)
    def getTrend(self): return _randomvector.ProcessImplementation_getTrend(self)
    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _randomvector.ProcessImplementation_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\\cD`.
        """
        return _randomvector.ProcessImplementation_getDimension(self)

    def getTimeGrid(self):
        """
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementation_getTimeGrid(self)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementation_setTimeGrid(self, *args)

    def getMesh(self):
        """
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.ProcessImplementation_getMesh(self)

    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.ProcessImplementation_setMesh(self, *args)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.ProcessImplementation_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \\geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.ProcessImplementation_getContinuousRealization(self)

    def getSample(self, *args):
        """
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\\cM \\in \\Rset^n`.
        """
        return _randomvector.ProcessImplementation_getSample(self, *args)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.ProcessImplementation_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.ProcessImplementation_getMarginal(self, *args)

    def setDescription(self, *args):
        """
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.ProcessImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.ProcessImplementation_getDescription(self)

    def __init__(self, *args): 
        this = _randomvector.new_ProcessImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_ProcessImplementation
    __del__ = lambda self : None;
ProcessImplementation_swigregister = _randomvector.ProcessImplementation_swigregister
ProcessImplementation_swigregister(ProcessImplementation)

class ProcessImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _randomvector.new_ProcessImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _randomvector.ProcessImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _randomvector.delete_ProcessImplementationTypedInterfaceObject
    __del__ = lambda self : None;
ProcessImplementationTypedInterfaceObject_swigregister = _randomvector.ProcessImplementationTypedInterfaceObject_swigregister
ProcessImplementationTypedInterfaceObject_swigregister(ProcessImplementationTypedInterfaceObject)

class Process(ProcessImplementationTypedInterfaceObject):
    """
    Base class for stochastic processes.

    Notes
    -----
    The Process class enables to model a stochastic process.

    A multivariate stochastic process :math:`X` of dimension :math:`d` is defined
    by:

    .. math::

        X: \\Omega \\times\\cD \\mapsto \\Rset^d

    where :math:`\\omega \\in \\Omega` is an event, :math:`\\cD` is a domain of
    :math:`\\Rset^n` discretized on the mesh :math:`\\cM`, :math:`\\vect{t}\\in \\cD` is
    a multivariate index and :math:`X(\\omega, \\vect{t}) \\in \\Rset^d`.

    A realization of the process :math:`X`, for a given :math:`\\omega \\in \\Omega`
    is :math:`X(\\omega): \\cD  \\mapsto \\Rset^d` defined by:

    .. math::

        X(\\omega)(\\vect{t}) = X(\\omega, \\vect{t})

    :math:`X_{\\vect{t}}: \\Omega \\rightarrow \\Rset^d` is the random variable at
    index :math:`\\vect{t} \\in \\cD` defined by:

    .. math::

        X_{\\vect{t}}(\\omega) = X(\\omega, \\vect{t})


    A Process object can be created only through its derived classes:

    :class:`~openturns.SpectralNormalProcess`,
    :class:`~openturns.TemporalNormalProcess`,
    :class:`~openturns.CompositeProcess`, :class:`~openturns.ARMA`,
    :class:`~openturns.RandomWalk`, :class:`~openturns.FunctionalBasisProcess`
    and :class:`~openturns.WhiteNoise`.
    """
    __swig_setmethods__ = {}
    for _s in [ProcessImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Process, name, value)
    __swig_getmethods__ = {}
    for _s in [ProcessImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Process, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.Process_getClassName(self)

    def __repr__(self): return _randomvector.Process___repr__(self)
    def __str__(self, offset=""): return _randomvector.Process___str__(self, offset)
    def setDescription(self, *args):
        """
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.Process_setDescription(self, *args)

    def getDescription(self):
        """
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.Process_getDescription(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.Process_isNormal(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _randomvector.Process_isStationary(self)

    def isComposite(self):
        """
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.Process_isComposite(self)

    def getCovarianceModel(self): return _randomvector.Process_getCovarianceModel(self)
    def getTrend(self): return _randomvector.Process_getTrend(self)
    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _randomvector.Process_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\\cD`.
        """
        return _randomvector.Process_getDimension(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.Process_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \\geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.Process_getContinuousRealization(self)

    def getTimeGrid(self):
        """
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.Process_getTimeGrid(self)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.Process_setTimeGrid(self, *args)

    def getMesh(self):
        """
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.Process_getMesh(self)

    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.Process_setMesh(self, *args)

    def getSample(self, *args):
        """
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\\cM \\in \\Rset^n`.
        """
        return _randomvector.Process_getSample(self, *args)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.Process_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.Process_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _randomvector.new_Process(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_Process
    __del__ = lambda self : None;
Process_swigregister = _randomvector.Process_swigregister
Process_swigregister(Process)

class RandomVectorImplementation(openturns.common.PersistentObject):
    """
    Random vectors.

    Available constructors:
        RandomVector(*points*)

        RandomVector(*distribution*)

        RandomVector(*distribution, randomParameters*)

        RandomVector(*function, antecedent*)

        RandomVector(*functionalChaosResult*)

    Parameters
    ----------
    points : sequence of float
        Sequence of values defining a :class:`~openturns.ConstantRandomVector`.
    distribution : :class:`~openturns.Distribution`
        Distribution of the :class:`~openturns.UsualRandomVector` to define.
    randomParameters : :class:`~openturns.RandomVector`
        RandomVector to define a distribution-based conditional vector.
        It defines random parameters for *distribution*.
    antecedent : :class:`~openturns.RandomVector`
        RandomVector :math:`\\vect{X}` of Usual type to define a
        :class:`~openturns.CompositeRandomVector` as the image through the function
        :math:`f` of :math:`\\vect{X}`: :math:`\\vect{Y}=f(\\vect{X})`.
    function : :class:`~openturns.NumericalMathFunction`
        Function :math:`f` to define a :class:`~openturns.CompositeRandomVector` as
        the image through this function of the antecedent :math:`\\vect{X}`:
        :math:`\\vect{Y}=f(\\vect{X})`.
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Result to define a :class:`~openturns.FunctionalChaosRandomVector` as the
        image through a functional chaos approximation model of the associated
        :class:`~openturns.UsualRandomVector`.


    Notes
    -----
    A :class:`~openturns.RandomVector` provides at least a way to generate realizations. OpenTURNS provides two kinds of  :class:`~openturns.RandomVector` :

        - those described by their :class:`~openturns.Distribution`: :class:`~openturns.UsualRandomVector` which provide some extra probbilistic methods.
        - those described as the image through a function of a :class:`~openturns.UsualRandomVector`: :math:`Y=f(X)`: :class:`~openturns.CompositeRandomVector` whcih can only generate realizations.

    See also
    --------
    UsualRandomVector, CompositeRandomVector, ConditionalRandomVector,
    ConstantRandomVector, PosteriorRandomVector, FunctionalChaosRandomVector, Event,
    PythonRandomVector
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomVectorImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomVectorImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.RandomVectorImplementation_getClassName(self)

    def __repr__(self): return _randomvector.RandomVectorImplementation___repr__(self)
    def isComposite(self):
        """
        Accessor to know if the RandomVector is a composite one.

        Returns
        -------
        isComposite : bool
            Indicates if the RandomVector is of type Composite or not.
        """
        return _randomvector.RandomVectorImplementation_isComposite(self)

    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_getDimension(self)

    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.NumericalPoint`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.RandomVectorImplementation_getRealization(self)

    def getSample(self, *args):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.NumericalSample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.RandomVectorImplementation_getSample(self, *args)

    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.NumericalPoint`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.RandomVectorImplementation_getMean(self)

    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.RandomVectorImplementation_getCovariance(self)

    def getMarginal(self, *args):
        """
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\\vect{Y}=\\Tr{(Y_1,\\dots,Y_n)}` a random vector and
        :math:`I \\in [1,n]` a set of indices. If :math:`\\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\\tilde{\\vect{Y}}=\\Tr{(Y_i)}_{i \\in I}`. If :math:`\\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\\vect{Y}=f(\\vect{X})` with :math:`f=(f_1,\\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\\tilde{\\vect{Y}}=(f_i(\\vect{X}))_{i \\in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.RandomVectorImplementation_getMarginal(self, *args)

    def getAntecedent(self):
        """
        Accessor to the antecedent RandomVector in case of a composite RandomVector.

        Returns
        -------
        antecedent : :class:`~openturns.RandomVector`
            Antecedent RandomVector :math:`\\vect{X}` in case of a
            :class:`~openturns.CompositeRandomVector` such as:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _randomvector.RandomVectorImplementation_getAntecedent(self)

    def getFunction(self):
        """
        Accessor to the NumericalMathFunction in case of a composite RandomVector.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            Function used to define a :class:`~openturns.CompositeRandomVector` as the
            image through this function of the antecedent :math:`\\vect{X}`:
            :math:`\\vect{Y}=f(\\vect{X})`.
        """
        return _randomvector.RandomVectorImplementation_getFunction(self)

    def getDistribution(self):
        """
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.RandomVectorImplementation_getDistribution(self)

    def getOperator(self):
        """
        Accessor to the comparaison operator of the Event.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            Comparaison operator used to define the :class:`~openturns.Event`.
        """
        return _randomvector.RandomVectorImplementation_getOperator(self)

    def getDomain(self):
        """
        Get the domain failure.

        Returns
        -------
        domain : :class:`~openturns.Domain`
            Domain failure used to define the :class:`~openturns.Event`.
        """
        return _randomvector.RandomVectorImplementation_getDomain(self)

    def getProcess(self):
        """
        Get the stochastic process.

        Returns
        -------
        process : :class:`~openturns.Process`
            Stochastic process used to define the :class:`~openturns.Event`.
        """
        return _randomvector.RandomVectorImplementation_getProcess(self)

    def getThreshold(self):
        """
        Accessor to the threshold of the Event.

        Returns
        -------
        threshold : float
            Threshold of the :class:`~openturns.Event`.
        """
        return _randomvector.RandomVectorImplementation_getThreshold(self)

    def setDescription(self, *args):
        """
        Accessor to the description of the RandomVector.

        Parameters
        ----------
        description : str or sequence of str
            Describes the components of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the RandomVector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Describes the components of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_getDescription(self)

    def __init__(self, *args): 
        this = _randomvector.new_RandomVectorImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_RandomVectorImplementation
    __del__ = lambda self : None;
RandomVectorImplementation_swigregister = _randomvector.RandomVectorImplementation_swigregister
RandomVectorImplementation_swigregister(RandomVectorImplementation)

class ConstantRandomVector(RandomVectorImplementation):
    """Proxy of C++ OT::ConstantRandomVector"""
    __swig_setmethods__ = {}
    for _s in [RandomVectorImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [RandomVectorImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantRandomVector, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ConstantRandomVector_getClassName(self)

    def __repr__(self): return _randomvector.ConstantRandomVector___repr__(self)
    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.ConstantRandomVector_getDimension(self)

    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.NumericalPoint`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.ConstantRandomVector_getRealization(self)

    def getSample(self, *args):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.NumericalSample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.ConstantRandomVector_getSample(self, *args)

    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.NumericalPoint`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.ConstantRandomVector_getMean(self)

    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.ConstantRandomVector_getCovariance(self)

    def getMarginal(self, *args):
        """
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\\vect{Y}=\\Tr{(Y_1,\\dots,Y_n)}` a random vector and
        :math:`I \\in [1,n]` a set of indices. If :math:`\\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\\tilde{\\vect{Y}}=\\Tr{(Y_i)}_{i \\in I}`. If :math:`\\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\\vect{Y}=f(\\vect{X})` with :math:`f=(f_1,\\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\\tilde{\\vect{Y}}=(f_i(\\vect{X}))_{i \\in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.ConstantRandomVector_getMarginal(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.ConstantRandomVector_getDistribution(self)

    def __init__(self, *args): 
        this = _randomvector.new_ConstantRandomVector(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_ConstantRandomVector
    __del__ = lambda self : None;
ConstantRandomVector_swigregister = _randomvector.ConstantRandomVector_swigregister
ConstantRandomVector_swigregister(ConstantRandomVector)

class UsualRandomVector(RandomVectorImplementation):
    """Proxy of C++ OT::UsualRandomVector"""
    __swig_setmethods__ = {}
    for _s in [RandomVectorImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UsualRandomVector, name, value)
    __swig_getmethods__ = {}
    for _s in [RandomVectorImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UsualRandomVector, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.UsualRandomVector_getClassName(self)

    def __repr__(self): return _randomvector.UsualRandomVector___repr__(self)
    def getDimension(self):
        """
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.UsualRandomVector_getDimension(self)

    def getRealization(self):
        """
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.NumericalPoint`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.UsualRandomVector_getRealization(self)

    def getSample(self, *args):
        """
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.NumericalSample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.UsualRandomVector_getSample(self, *args)

    def getMean(self):
        """
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.NumericalPoint`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.UsualRandomVector_getMean(self)

    def getCovariance(self):
        """
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.UsualRandomVector_getCovariance(self)

    def getMarginal(self, *args):
        """
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\\vect{Y}=\\Tr{(Y_1,\\dots,Y_n)}` a random vector and
        :math:`I \\in [1,n]` a set of indices. If :math:`\\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\\tilde{\\vect{Y}}=\\Tr{(Y_i)}_{i \\in I}`. If :math:`\\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\\vect{Y}=f(\\vect{X})` with :math:`f=(f_1,\\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\\tilde{\\vect{Y}}=(f_i(\\vect{X}))_{i \\in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.UsualRandomVector_getMarginal(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.UsualRandomVector_getDistribution(self)

    def __init__(self, *args): 
        this = _randomvector.new_UsualRandomVector(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_UsualRandomVector
    __del__ = lambda self : None;
UsualRandomVector_swigregister = _randomvector.UsualRandomVector_swigregister
UsualRandomVector_swigregister(UsualRandomVector)

class ProcessImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _randomvector.ProcessImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _randomvector.ProcessImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_randomvector.ProcessImplementationPointer_ptr__get, _randomvector.ProcessImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _randomvector.new_ProcessImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _randomvector.delete_ProcessImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _randomvector.ProcessImplementationPointer_reset(self)
    def __ref__(self, *args): return _randomvector.ProcessImplementationPointer___ref__(self, *args)
    def __deref__(self): return _randomvector.ProcessImplementationPointer___deref__(self)
    def isNull(self): return _randomvector.ProcessImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _randomvector.ProcessImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _randomvector.ProcessImplementationPointer_get(self)
    def getImplementation(self): return _randomvector.ProcessImplementationPointer_getImplementation(self)
    def unique(self): return _randomvector.ProcessImplementationPointer_unique(self)
    def use_count(self): return _randomvector.ProcessImplementationPointer_use_count(self)
    def swap(self, *args): return _randomvector.ProcessImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ProcessImplementationPointer_getClassName(self)

    def __repr__(self): return _randomvector.ProcessImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _randomvector.ProcessImplementationPointer___str__(self, offset)
    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.ProcessImplementationPointer_isNormal(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _randomvector.ProcessImplementationPointer_isStationary(self)

    def isComposite(self):
        """
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.ProcessImplementationPointer_isComposite(self)

    def getCovarianceModel(self): return _randomvector.ProcessImplementationPointer_getCovarianceModel(self)
    def getTrend(self): return _randomvector.ProcessImplementationPointer_getTrend(self)
    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _randomvector.ProcessImplementationPointer_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\\cD`.
        """
        return _randomvector.ProcessImplementationPointer_getDimension(self)

    def getTimeGrid(self):
        """
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementationPointer_getTimeGrid(self)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementationPointer_setTimeGrid(self, *args)

    def getMesh(self):
        """
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.ProcessImplementationPointer_getMesh(self)

    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _randomvector.ProcessImplementationPointer_setMesh(self, *args)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.ProcessImplementationPointer_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \\geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.ProcessImplementationPointer_getContinuousRealization(self)

    def getSample(self, *args):
        """
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \\geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\\cM \\in \\Rset^n`.
        """
        return _randomvector.ProcessImplementationPointer_getSample(self, *args)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.ProcessImplementationPointer_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.ProcessImplementationPointer_getMarginal(self, *args)

    def setDescription(self, *args):
        """
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.ProcessImplementationPointer_setDescription(self, *args)

    def getDescription(self):
        """
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.ProcessImplementationPointer_getDescription(self)

    def __eq__(self, *args): return _randomvector.ProcessImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _randomvector.ProcessImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _randomvector.ProcessImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _randomvector.ProcessImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _randomvector.ProcessImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _randomvector.ProcessImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationPointer_setName(self, *args)

ProcessImplementationPointer_swigregister = _randomvector.ProcessImplementationPointer_swigregister
ProcessImplementationPointer_swigregister(ProcessImplementationPointer)

# This file is compatible with both classic and new-style classes.


