# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Optimization routines.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_optim', [dirname(__file__)])
        except ImportError:
            import _optim
            return _optim
        if fp is not None:
            try:
                _mod = imp.load_module('_optim', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _optim = swig_import_helper()
    del swig_import_helper
else:
    import _optim
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _optim.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _optim.SwigPyIterator_value(self)
    def incr(self, n=1): return _optim.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _optim.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _optim.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _optim.SwigPyIterator_equal(self, *args)
    def copy(self): return _optim.SwigPyIterator_copy(self)
    def next(self): return _optim.SwigPyIterator_next(self)
    def __next__(self): return _optim.SwigPyIterator___next__(self)
    def previous(self): return _optim.SwigPyIterator_previous(self)
    def advance(self, *args): return _optim.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _optim.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _optim.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _optim.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _optim.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _optim.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _optim.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _optim.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _optim.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
class OptimizationProblemImplementation(openturns.common.PersistentObject):
    """
    Base class to define an optimization problem.

    Available constructors:
        OptimizationProblem()

        OptimizationProblem(*objective, equality, inequality, bounds*)

        OptimizationProblem(*level, value*)

    Parameters
    ----------
    objective : :class:`~openturns.NumericalMathFunction`
        Objective function.
    equality : :class:`~openturns.NumericalMathFunction`
        Equality constraints.
    inequality : :class:`~openturns.NumericalMathFunction`
        Inequality constraints.
    bounds : :class:`~openturns.Interval`
        Bounds.
    level : :class:`~openturns.NumericalMathFunction`
        Level function.
    value : float
        Level value.

    Notes
    -----

    The first form represents a general optimization problem:

    .. math::

        \\min_{x\\in B} f(x) \\\\
        g(x) = 0 \\\\
        h(x) \\ge 0

    where *B* is problem's bounds, *f* is the objective function, *g* are equality constraints, and *h* are inequality constraints.

    The second form represents a nearest point problem:

    .. math::

        \\min_{x} ||x|| \\\\
        g(x) = v

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.NumericalMathFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(rosenbrock)

    Define an optimization problem to find the point with minimum norm which satisfies :math:`x1+2*x2-3*x3+4*x4=3`.

    >>> import openturns as ot
    >>> levelFunction = ot.NumericalMathFunction(
    ...     ['x1', 'x2', 'x3', 'x4'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(levelFunction, 3.0)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblemImplementation_getClassName(self)

    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblemImplementation_getObjective(self)

    def setObjective(self, *args):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblemImplementation_setObjective(self, *args)

    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasMultipleObjective(self)

    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.NumericalMathFunction`
            Describe equality constraints.
        """
        return _optim.OptimizationProblemImplementation_getEqualityConstraint(self)

    def setEqualityConstraint(self, *args):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.NumericalMathFunction`
            Equality constraints.
        """
        return _optim.OptimizationProblemImplementation_setEqualityConstraint(self, *args)

    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasEqualityConstraint(self)

    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.NumericalMathFunction`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblemImplementation_getInequalityConstraint(self)

    def setInequalityConstraint(self, *args):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.NumericalMathFunction`
            Inequality constraints.
        """
        return _optim.OptimizationProblemImplementation_setInequalityConstraint(self, *args)

    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasInequalityConstraint(self)

    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementation_getBounds(self)

    def setBounds(self, *args):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementation_setBounds(self, *args)

    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasBounds(self)

    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblemImplementation_getLevelFunction(self)

    def setLevelFunction(self, *args):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblemImplementation_setLevelFunction(self, *args)

    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_hasLevelFunction(self)

    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblemImplementation_getLevelValue(self)

    def setLevelValue(self, *args):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblemImplementation_setLevelValue(self, *args)

    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblemImplementation_getDimension(self)

    def setMinimization(self, *args):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_setMinimization(self, *args)

    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblemImplementation_isMinimization(self)

    def __repr__(self): return _optim.OptimizationProblemImplementation___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_OptimizationProblemImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementation
    __del__ = lambda self : None;
OptimizationProblemImplementation_swigregister = _optim.OptimizationProblemImplementation_swigregister
OptimizationProblemImplementation_swigregister(OptimizationProblemImplementation)

class OptimizationProblemImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _optim.new_OptimizationProblemImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _optim.OptimizationProblemImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementationTypedInterfaceObject
    __del__ = lambda self : None;
OptimizationProblemImplementationTypedInterfaceObject_swigregister = _optim.OptimizationProblemImplementationTypedInterfaceObject_swigregister
OptimizationProblemImplementationTypedInterfaceObject_swigregister(OptimizationProblemImplementationTypedInterfaceObject)

class OptimizationProblem(OptimizationProblemImplementationTypedInterfaceObject):
    """
    Base class to define an optimization problem.

    Available constructors:
        OptimizationProblem()

        OptimizationProblem(*objective, equality, inequality, bounds*)

        OptimizationProblem(*level, value*)

    Parameters
    ----------
    objective : :class:`~openturns.NumericalMathFunction`
        Objective function.
    equality : :class:`~openturns.NumericalMathFunction`
        Equality constraints.
    inequality : :class:`~openturns.NumericalMathFunction`
        Inequality constraints.
    bounds : :class:`~openturns.Interval`
        Bounds.
    level : :class:`~openturns.NumericalMathFunction`
        Level function.
    value : float
        Level value.

    Notes
    -----

    The first form represents a general optimization problem:

    .. math::

        \\min_{x\\in B} f(x) \\\\
        g(x) = 0 \\\\
        h(x) \\ge 0

    where *B* is problem's bounds, *f* is the objective function, *g* are equality constraints, and *h* are inequality constraints.

    The second form represents a nearest point problem:

    .. math::

        \\min_{x} ||x|| \\\\
        g(x) = v

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.NumericalMathFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(rosenbrock)

    Define an optimization problem to find the point with minimum norm which satisfies :math:`x1+2*x2-3*x3+4*x4=3`.

    >>> import openturns as ot
    >>> levelFunction = ot.NumericalMathFunction(
    ...     ['x1', 'x2', 'x3', 'x4'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(levelFunction, 3.0)
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationProblemImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblem, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationProblemImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblem, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblem_getClassName(self)

    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblem_getObjective(self)

    def setObjective(self, *args):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblem_setObjective(self, *args)

    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblem_hasMultipleObjective(self)

    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.NumericalMathFunction`
            Describe equality constraints.
        """
        return _optim.OptimizationProblem_getEqualityConstraint(self)

    def setEqualityConstraint(self, *args):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.NumericalMathFunction`
            Equality constraints.
        """
        return _optim.OptimizationProblem_setEqualityConstraint(self, *args)

    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasEqualityConstraint(self)

    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.NumericalMathFunction`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblem_getInequalityConstraint(self)

    def setInequalityConstraint(self, *args):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.NumericalMathFunction`
            Inequality constraints.
        """
        return _optim.OptimizationProblem_setInequalityConstraint(self, *args)

    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasInequalityConstraint(self)

    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblem_getBounds(self)

    def setBounds(self, *args):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblem_setBounds(self, *args)

    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasBounds(self)

    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblem_getLevelFunction(self)

    def setLevelFunction(self, *args):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblem_setLevelFunction(self, *args)

    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_hasLevelFunction(self)

    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblem_getLevelValue(self)

    def setLevelValue(self, *args):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblem_setLevelValue(self, *args)

    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblem_getDimension(self)

    def setMinimization(self, *args):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblem_setMinimization(self, *args)

    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblem_isMinimization(self)

    def __repr__(self): return _optim.OptimizationProblem___repr__(self)
    def __str__(self, offset=""): return _optim.OptimizationProblem___str__(self, offset)
    def __init__(self, *args): 
        this = _optim.new_OptimizationProblem(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblem
    __del__ = lambda self : None;
OptimizationProblem_swigregister = _optim.OptimizationProblem_swigregister
OptimizationProblem_swigregister(OptimizationProblem)

class OptimizationResult(openturns.common.PersistentObject):
    """
    Optimization result.

    Returned by optimization solvers, see :class:`~openturns.OptimizationSolver`.

    Available constructors:
        OptimizationResult(*optimalPoint, optimalValue, iterationNumber, absoluteError, relativeError, residualError, constraintError*)

    Parameters
    ----------
    optimalPoint : sequence of float
        Optimal point.
    optimalValue : sequence of float
        Value at optimal point.
    iterationNumber : int
        Number of iterations.
    absoluteError : float
        Parameters for this solver.
    relativeError : float
        Relative error.
    residualError : float
        Residual error.
    constraintError : float
        Constraint error.
    problem : :class:`~openturns.OptimizationProblem`
        Associated problem.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationResult_getClassName(self)

    def setOptimalPoint(self, *args):
        """
        Accessor to the optimal point.

        Parameters
        ----------
        optimalPoint : :class:`~openturns.NumericalPoint`
             Optimal point
        """
        return _optim.OptimizationResult_setOptimalPoint(self, *args)

    def getOptimalPoint(self):
        """
        Accessor to the optimal point.

        Returns
        -------
        optimalPoint : :class:`~openturns.NumericalPoint`
             Optimal point
        """
        return _optim.OptimizationResult_getOptimalPoint(self)

    def setOptimalValue(self, *args):
        """
        Accessor to the optimal value.

        Parameters
        ----------
        optimalValue : :class:`~openturns.NumericalPoint`
             Value at the optimal point
        """
        return _optim.OptimizationResult_setOptimalValue(self, *args)

    def getOptimalValue(self):
        """
        Accessor to the optimal value.

        Returns
        -------
        optimalValue : :class:`~openturns.NumericalPoint`
             Value at the optimal point
        """
        return _optim.OptimizationResult_getOptimalValue(self)

    def setIterationNumber(self, *args):
        """
        Accessor to the number of iterations.

        Parameters
        ----------
        iterationNumber : int
             Number of evaluations.
        """
        return _optim.OptimizationResult_setIterationNumber(self, *args)

    def getIterationNumber(self):
        """
        Accessor to the number of iterations.

        Returns
        -------
        iterationNumber : int
             Number of evaluations.
        """
        return _optim.OptimizationResult_getIterationNumber(self)

    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absoluteError : float
             Absolute error, defined by :math:`\\epsilon^a_n=\\|\\vect{x}_{n+1}-\\vect{x}_n\\|_{\\infty}` where :math:`\\vect{x}_{n+1}` and :math:`\\vect{x}_n` are two consecutive approximations of the optimum.
        """
        return _optim.OptimizationResult_getAbsoluteError(self)

    def getAbsoluteErrorHistory(self):
        """
        Accessor to the evolution of the absolute error.

        Returns
        -------
        absoluteErrorHistory : :class:`~openturns.NumericalSample`
             Value of the absolute error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getAbsoluteErrorHistory(self)

    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relativeError : float
             Relative error, defined by :math:`\\epsilon^r_n=\\epsilon^a_n/\\|\\vect{x}_{n+1}\\|_{\\infty}` if :math:`\\|\\vect{x}_{n+1}\\|_{\\infty}\\neq 0`, else :math:`\\epsilon^r_n=-1`.
        """
        return _optim.OptimizationResult_getRelativeError(self)

    def getRelativeErrorHistory(self):
        """
        Accessor to the evolution of the relative error.

        Returns
        -------
        relativeErrorHistory : :class:`~openturns.NumericalSample`
             Value of the relative error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getRelativeErrorHistory(self)

    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        residualError : float
             Residual error, defined by :math:`\\eta^r_n=\\|\\nabla\\cL{\\vect{x}_n}\\|_{\\infty}` where :math:`\\vect{x}_n` is the current approximation of the optimum and :math:`\\cL` is the Lagrangian of the problem.
        """
        return _optim.OptimizationResult_getResidualError(self)

    def getResidualErrorHistory(self):
        """
        Accessor to the evolution of the residual error.

        Returns
        -------
        residualErrorHistory : :class:`~openturns.NumericalSample`
             Value of the residual error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getResidualErrorHistory(self)

    def getConstraintError(self):
        """
        Accessor to the constraint error.

        Returns
        -------
        constraintError : float
             Constraint error, defined by :math:`\\gamma_n=\\|g(\\vect{x}_n)\\|_{\\infty}` where :math:`\\vect{x}_n` is the current approximation of the optimum and :math:`g` is the function that gather all the equality and inequality constraints.
        """
        return _optim.OptimizationResult_getConstraintError(self)

    def getConstraintErrorHistory(self):
        """
        Accessor to the evolution of the constraint error.

        Returns
        -------
        constraintErrorHistory : :class:`~openturns.NumericalSample`
             Value of the constrainte error at each iteration of the solver.
        """
        return _optim.OptimizationResult_getConstraintErrorHistory(self)

    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.NumericalSample`
             Input points used by the solver
        """
        return _optim.OptimizationResult_getInputSample(self)

    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.NumericalSample`
             Output points used by the solver
        """
        return _optim.OptimizationResult_getOutputSample(self)

    def setProblem(self, *args):
        """
        Accessor to the underlying optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
             Problem corresponding to the result
        """
        return _optim.OptimizationResult_setProblem(self, *args)

    def getProblem(self):
        """
        Accessor to the underlying optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
             Problem corresponding to the result
        """
        return _optim.OptimizationResult_getProblem(self)

    def setLagrangeMultipliers(self, *args):
        """
        Accessor to the Lagrange multipliers.

        Parameters
        ----------
        multipliers : :class:`~openturns.NumericalPoint`
             Lagrange multipliers.

        Notes
        -----
        See :class:`~openturns.OptimizationSolver` for the details on how the multipliers are defined and stored in the result.

        """
        return _optim.OptimizationResult_setLagrangeMultipliers(self, *args)

    def getLagrangeMultipliers(self):
        """
        Accessor to the Lagrange multipliers.

        Returns
        -------
        multipliers : :class:`~openturns.NumericalPoint`
             Lagrange multipliers.

        Notes
        -----
        See :class:`~openturns.OptimizationSolver` for the details on how the multipliers are defined and stored in the result.

        """
        return _optim.OptimizationResult_getLagrangeMultipliers(self)

    def __repr__(self): return _optim.OptimizationResult___repr__(self)
    def store(self, *args): return _optim.OptimizationResult_store(self, *args)
    def drawErrorHistory(self):
        """
        Draw the convergence criteria history.

        Returns
        -------
        graph : :class:`~openturns.Graph`
             Convergence criteria history graph
        """
        return _optim.OptimizationResult_drawErrorHistory(self)

    def __init__(self, *args): 
        this = _optim.new_OptimizationResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationResult
    __del__ = lambda self : None;
OptimizationResult_swigregister = _optim.OptimizationResult_swigregister
OptimizationResult_swigregister(OptimizationResult)

class OptimizationSolverImplementation(openturns.common.PersistentObject):
    """
    Base class for optimization wrappers.

    Available constructors:
        OptimizationSolver(*problem, verbose=False*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem.
    verbose : bool
        Let solver be more verbose.

    Notes
    -----

    Class :class:`~openturns.OptimizationSolver` is an abstract class, which has several implementations.
    The default implementation is :class:`~openturns.Cobyla`, but there are also
    :class:`~openturns.AbdoRackwitz`, :class:`~openturns.SQP` and :class:`~openturns.TNC`.

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.NumericalMathFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(rosenbrock)
    >>> solver = ot.OptimizationSolver(problem)
    >>> solver.setStartingPoint([0, 0])
    >>> solver.setMaximumResidualError(1.e-3)
    >>> solver.setMaximumIterationNumber(100)
    >>> solver.run()
    >>> result = solver.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationSolverImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationSolverImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationSolverImplementation_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationSolverImplementation_run(self)

    def computeLagrangeMultipliers(self, *args):
        """
        Compute the Lagrange multipliers of a problem at a given point.

        Parameters
        ----------
        x : sequence of float
            Point at which the Lagrange multipliers are computed.

        Returns
        -------
        lagrangeMultiplier : sequence of float
            Lagrange multipliers of the problem at the given point.

        Notes
        -----
        The Lagrange multipliers :math:`\\vect{\\lambda}` are associated with the following Lagrangian formulation of the optimization problem:

        .. math::

            \\cL(\\vect{x}, \\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq}) = J(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{eq} g(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{\\ell} (\\vect{x}-\\vect{\\ell})^{+} + \\Tr{\\vect{\\lambda}}_{u} (\\vect{u}-\\vect{x})^{+} + \\Tr{\\vect{\\lambda}}_{ineq}  h^{+}(\\vect{x})

        where :math:`\\vect{\\alpha}^{+}=(\\max(0,\\alpha_1),\\hdots,\\max(0,\\alpha_n))`.

        The Lagrange multipliers are stored as :math:`(\\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq})`, where:
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no equality
              constraint, else of dimension the dimension of :math:`g(\\vect{x})` ie the number of scalar equality constraints
            - :math:`\\vect{\\lambda}_{\\ell}` and :math:`\\vect{\\lambda}_{u}` are of dimension 0 if there is no bound constraint, else of dimension of :math:`\\vect{x}`
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no inequality constraint, else of dimension the dimension of :math:`h(\\vect{x})` ie the number of scalar inequality constraints

        The vector :math:`\\vect{\\lambda}` is solution of the following linear system:

        .. math::

            \\Tr{\\vect{\\lambda}}_{eq}\\left[\\dfrac{\\partial g}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{\\ell}\\left[\\dfrac{\\partial (\\vect{x}-\\vect{\\ell})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{u}\\left[\\dfrac{\\partial (\\vect{u}-\\vect{x})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{ineq}\\left[\\dfrac{\\partial h}{\\partial\\vect{x}}(\\vect{x})\\right]=-\\dfrac{\\partial J}{\\partial\\vect{x}}(\\vect{x})

        If there is no constraint of any kind, :math:`\\vect{\\lambda}` is of dimension 0, as well as if no constraint is active.

        """
        return _optim.OptimizationSolverImplementation_computeLagrangeMultipliers(self, *args)

    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolverImplementation_getStartingPoint(self)

    def setStartingPoint(self, *args):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolverImplementation_setStartingPoint(self, *args)

    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolverImplementation_getProblem(self)

    def setProblem(self, *args):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolverImplementation_setProblem(self, *args)

    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolverImplementation_getResult(self)

    def setResult(self, *args):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolverImplementation_setResult(self, *args)

    def setMaximumIterationNumber(self, *args):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolverImplementation_setMaximumIterationNumber(self, *args)

    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolverImplementation_getMaximumIterationNumber(self)

    def setMaximumEvaluationNumber(self, *args):
        """
        Accessor to maximum allowed number of evaluations.

        Parameters
        ----------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationSolverImplementation_setMaximumEvaluationNumber(self, *args)

    def getMaximumEvaluationNumber(self):
        """
        Accessor to maximum allowed number of evaluations.

        Returns
        -------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationSolverImplementation_getMaximumEvaluationNumber(self)

    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolverImplementation_getMaximumAbsoluteError(self)

    def setMaximumAbsoluteError(self, *args):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolverImplementation_setMaximumAbsoluteError(self, *args)

    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolverImplementation_getMaximumRelativeError(self)

    def setMaximumRelativeError(self, *args):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolverImplementation_setMaximumRelativeError(self, *args)

    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolverImplementation_getMaximumResidualError(self)

    def setMaximumResidualError(self, *args):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolverImplementation_setMaximumResidualError(self, *args)

    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolverImplementation_getMaximumConstraintError(self)

    def setMaximumConstraintError(self, *args):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolverImplementation_setMaximumConstraintError(self, *args)

    def __repr__(self): return _optim.OptimizationSolverImplementation___repr__(self)
    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolverImplementation_getVerbose(self)

    def setVerbose(self, *args):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolverImplementation_setVerbose(self, *args)

    def __init__(self, *args): 
        this = _optim.new_OptimizationSolverImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationSolverImplementation
    __del__ = lambda self : None;
OptimizationSolverImplementation_swigregister = _optim.OptimizationSolverImplementation_swigregister
OptimizationSolverImplementation_swigregister(OptimizationSolverImplementation)

class OptimizationSolverImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationSolverImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationSolverImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _optim.new_OptimizationSolverImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _optim.OptimizationSolverImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationSolverImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationSolverImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _optim.OptimizationSolverImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _optim.delete_OptimizationSolverImplementationTypedInterfaceObject
    __del__ = lambda self : None;
OptimizationSolverImplementationTypedInterfaceObject_swigregister = _optim.OptimizationSolverImplementationTypedInterfaceObject_swigregister
OptimizationSolverImplementationTypedInterfaceObject_swigregister(OptimizationSolverImplementationTypedInterfaceObject)

class OptimizationSolver(OptimizationSolverImplementationTypedInterfaceObject):
    """
    Base class for optimization wrappers.

    Available constructors:
        OptimizationSolver(*problem, verbose=False*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem.
    verbose : bool
        Let solver be more verbose.

    Notes
    -----

    Class :class:`~openturns.OptimizationSolver` is an abstract class, which has several implementations.
    The default implementation is :class:`~openturns.Cobyla`, but there are also
    :class:`~openturns.AbdoRackwitz`, :class:`~openturns.SQP` and :class:`~openturns.TNC`.

    Examples
    --------

    Define an optimization problem to find the minimum of the Rosenbrock function:

    >>> import openturns as ot
    >>> rosenbrock = ot.NumericalMathFunction(['x1', 'x2'], ['(1-x1)^2+100*(x2-x1^2)^2'])
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(rosenbrock)
    >>> solver = ot.OptimizationSolver(problem)
    >>> solver.setStartingPoint([0, 0])
    >>> solver.setMaximumResidualError(1.e-3)
    >>> solver.setMaximumIterationNumber(100)
    >>> solver.run()
    >>> result = solver.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationSolver, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationSolver, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationSolver_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationSolver_run(self)

    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolver_getStartingPoint(self)

    def setStartingPoint(self, *args):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolver_setStartingPoint(self, *args)

    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolver_getProblem(self)

    def setProblem(self, *args):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolver_setProblem(self, *args)

    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolver_getResult(self)

    def setResult(self, *args):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolver_setResult(self, *args)

    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolver_getMaximumIterationNumber(self)

    def setMaximumIterationNumber(self, *args):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolver_setMaximumIterationNumber(self, *args)

    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolver_getMaximumAbsoluteError(self)

    def setMaximumAbsoluteError(self, *args):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolver_setMaximumAbsoluteError(self, *args)

    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolver_getMaximumRelativeError(self)

    def setMaximumRelativeError(self, *args):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolver_setMaximumRelativeError(self, *args)

    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolver_getMaximumResidualError(self)

    def setMaximumResidualError(self, *args):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolver_setMaximumResidualError(self, *args)

    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolver_getMaximumConstraintError(self)

    def setMaximumConstraintError(self, *args):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolver_setMaximumConstraintError(self, *args)

    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolver_getVerbose(self)

    def setVerbose(self, *args):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolver_setVerbose(self, *args)

    def __repr__(self): return _optim.OptimizationSolver___repr__(self)
    def __str__(self, offset=""): return _optim.OptimizationSolver___str__(self, offset)
    def __init__(self, *args): 
        this = _optim.new_OptimizationSolver(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationSolver
    __del__ = lambda self : None;
OptimizationSolver_swigregister = _optim.OptimizationSolver_swigregister
OptimizationSolver_swigregister(OptimizationSolver)

class NearestPointCheckerResult(openturns.common.PersistentObject):
    """Proxy of C++ OT::NearestPointCheckerResult"""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NearestPointCheckerResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NearestPointCheckerResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NearestPointCheckerResult_getClassName(self)

    def getVerifyingConstraintPoints(self): return _optim.NearestPointCheckerResult_getVerifyingConstraintPoints(self)
    def getVerifyingConstraintValues(self): return _optim.NearestPointCheckerResult_getVerifyingConstraintValues(self)
    def getViolatingConstraintPoints(self): return _optim.NearestPointCheckerResult_getViolatingConstraintPoints(self)
    def getViolatingConstraintValues(self): return _optim.NearestPointCheckerResult_getViolatingConstraintValues(self)
    def setVerifyingConstraintPoints(self, *args): return _optim.NearestPointCheckerResult_setVerifyingConstraintPoints(self, *args)
    def setVerifyingConstraintValues(self, *args): return _optim.NearestPointCheckerResult_setVerifyingConstraintValues(self, *args)
    def setViolatingConstraintPoints(self, *args): return _optim.NearestPointCheckerResult_setViolatingConstraintPoints(self, *args)
    def setViolatingConstraintValues(self, *args): return _optim.NearestPointCheckerResult_setViolatingConstraintValues(self, *args)
    def __repr__(self): return _optim.NearestPointCheckerResult___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_NearestPointCheckerResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_NearestPointCheckerResult
    __del__ = lambda self : None;
NearestPointCheckerResult_swigregister = _optim.NearestPointCheckerResult_swigregister
NearestPointCheckerResult_swigregister(NearestPointCheckerResult)

class NearestPointChecker(openturns.common.PersistentObject):
    """Proxy of C++ OT::NearestPointChecker"""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NearestPointChecker, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NearestPointChecker, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NearestPointChecker_getClassName(self)

    def setLevelFunction(self, *args): return _optim.NearestPointChecker_setLevelFunction(self, *args)
    def getLevelFunction(self): return _optim.NearestPointChecker_getLevelFunction(self)
    def setResult(self, *args): return _optim.NearestPointChecker_setResult(self, *args)
    def getResult(self): return _optim.NearestPointChecker_getResult(self)
    def setComparisonOperator(self, *args): return _optim.NearestPointChecker_setComparisonOperator(self, *args)
    def getComparisonOperator(self): return _optim.NearestPointChecker_getComparisonOperator(self)
    def setThreshold(self, *args): return _optim.NearestPointChecker_setThreshold(self, *args)
    def getThreshold(self): return _optim.NearestPointChecker_getThreshold(self)
    def setSample(self, *args): return _optim.NearestPointChecker_setSample(self, *args)
    def getSample(self): return _optim.NearestPointChecker_getSample(self)
    def run(self): return _optim.NearestPointChecker_run(self)
    def __repr__(self): return _optim.NearestPointChecker___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_NearestPointChecker(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_NearestPointChecker
    __del__ = lambda self : None;
NearestPointChecker_swigregister = _optim.NearestPointChecker_swigregister
NearestPointChecker_swigregister(NearestPointChecker)

class AbdoRackwitz(OptimizationSolverImplementation):
    """
    Abdo-Rackwitz solver.

    Available constructors:
        AbdoRackwitz(*problem*)

        AbdoRackwitz(*problem, tau, omega, smooth*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    tau : float
        Multiplicative decrease of linear step.
    omega : float
        Armijo factor.
    smooth : float
        Growing factor in penalization term.

    See also
    --------
    Cobyla, SQP, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> problem = ot.OptimizationProblem(model, 5.0)
    >>> algo = ot.AbdoRackwitz(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbdoRackwitz, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbdoRackwitz, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.AbdoRackwitz_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.AbdoRackwitz_run(self)

    def getTau(self):
        """
        Accessor to tau parameter.

        Returns
        -------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.AbdoRackwitz_getTau(self)

    def setTau(self, *args):
        """
        Accessor to tau parameter.

        Parameters
        ----------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.AbdoRackwitz_setTau(self, *args)

    def getOmega(self):
        """
        Accessor to omega parameter.

        Returns
        -------
        omega : float
            Armijo factor.
        """
        return _optim.AbdoRackwitz_getOmega(self)

    def setOmega(self, *args):
        """
        Accessor to omega parameter.

        Parameters
        ----------
        omega : float
            Armijo factor.
        """
        return _optim.AbdoRackwitz_setOmega(self, *args)

    def getSmooth(self):
        """
        Accessor to smooth parameter.

        Returns
        -------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.AbdoRackwitz_getSmooth(self)

    def setSmooth(self, *args):
        """
        Accessor to smooth parameter.

        Parameters
        ----------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.AbdoRackwitz_setSmooth(self, *args)

    def __repr__(self): return _optim.AbdoRackwitz___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_AbdoRackwitz(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_AbdoRackwitz
    __del__ = lambda self : None;
AbdoRackwitz_swigregister = _optim.AbdoRackwitz_swigregister
AbdoRackwitz_swigregister(AbdoRackwitz)

class Cobyla(OptimizationSolverImplementation):
    """
    Constrained Optimization BY Linear Approximations solver.

    Available constructors:
        Cobyla(*problem*)

        Cobyla(*problem, rhoBeg*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    rhoBeg : float
        A reasonable initial change to the variables.

    Notes
    -----
    It constructs successive linear approximations of the objective function and
    constraints via a simplex of :math:`d+1` points, and optimizes these
    approximations in a trust region at each step.

    See also
    --------
    AbdoRackwitz, SQP, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> problem = ot.OptimizationProblem(model, 5.0)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Cobyla, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Cobyla, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.Cobyla_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.Cobyla_run(self)

    def getRhoBeg(self):
        """
        Accessor to rhoBeg parameter.

        Returns
        -------
        rhoBeg : float
            A reasonable initial change to the variables.
        """
        return _optim.Cobyla_getRhoBeg(self)

    def setRhoBeg(self, *args):
        """
        Accessor to rhoBeg parameter.

        Parameters
        ----------
        rhoBeg : float
            A reasonable initial change to the variables.
        """
        return _optim.Cobyla_setRhoBeg(self, *args)

    def __repr__(self): return _optim.Cobyla___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_Cobyla(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_Cobyla
    __del__ = lambda self : None;
Cobyla_swigregister = _optim.Cobyla_swigregister
Cobyla_swigregister(Cobyla)

class TNC(OptimizationSolverImplementation):
    """
    Truncated Newton Constrained solver.

    Available constructors:
        TNC(*problem*)

        TNC(*problem, scale, offset, maxCGit, eta, stepmx, accuracy, fmin, rescale*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    specificParameters : :class:`~openturns.TNCSpecificParameters`
        Parameters for this solver.
    scale : sequence of float
        Scaling factors to apply to each variables
    offset : sequence of float
        Constant to substract to each variable
    maxCGit : int
        Maximum number of hessian*vector evaluation per main iteration
    eta : float
        Severity of the line search.
    stepmx : float
        Maximum step for the line search. may be increased during call
    accuracy : float
        Relative precision for finite difference calculations
    fmin : float
        Minimum function value estimate.
    rescale : float
        f scaling factor (in log10) used to trigger f value rescaling

    Notes
    -----
    Non-linear optimizer supporting bound constraints.

    See also
    --------
    AbdoRackwitz, SQP, Cobyla, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> bounds = ot.Interval([1.0]*4, [2.0]*4)
    >>> problem = ot.OptimizationProblem(model, ot.NumericalMathFunction(), ot.NumericalMathFunction(), bounds)
    >>> algo = ot.TNC(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TNC, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TNC, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.TNC_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.TNC_run(self)

    def getScale(self):
        """
        Accessor to scale parameter.

        Returns
        -------
        scale : :class:`~openturns.NumericalPoint`
            Scaling factors to apply to each variable

            if empty, the factors are min-max for interval bounded variables

            and 1+|x] for the others.
        """
        return _optim.TNC_getScale(self)

    def setScale(self, *args):
        """
        Accessor to scale parameter.

        Parameters
        ----------
        scale : sequence of float
            Scaling factors to apply to each variable

            if empty, the factors are min-max for interval bounded variables

            and 1+|x] for the others.
        """
        return _optim.TNC_setScale(self, *args)

    def getOffset(self):
        """
        Accessor to offset parameter.

        Returns
        -------
        offset : :class:`~openturns.NumericalPoint`
            Constant to substract to each variable

            if empty, the constant are (min-max)/2 for interval bounded

            variables and x for the others.
        """
        return _optim.TNC_getOffset(self)

    def setOffset(self, *args):
        """
        Accessor to offset parameter.

        Parameters
        ----------
        offset : sequence of float
            Constant to substract to each variable

            if empty, the constant are (min-max)/2 for interval bounded

            variables and x for the others.
        """
        return _optim.TNC_setOffset(self, *args)

    def getMaxCGit(self):
        """
        Accessor to maxCGit parameter.

        Returns
        -------
        maxCGit : int
            Maximum number of hessian*vector evaluation per main iteration

            if maxCGit = 0, the direction chosen is -gradient

            if maxCGit < 0, maxCGit is set to max(1,min(50,n/2)).
        """
        return _optim.TNC_getMaxCGit(self)

    def setMaxCGit(self, *args):
        """
        Accessor to maxCGit parameter.

        Parameters
        ----------
        maxCGit : int
            Maximum number of hessian*vector evaluation per main iteration

            if maxCGit = 0, the direction chosen is -gradient

            if maxCGit < 0, maxCGit is set to max(1,min(50,n/2)).
        """
        return _optim.TNC_setMaxCGit(self, *args)

    def getEta(self):
        """
        Accessor to eta parameter.

        Returns
        -------
        eta : float
            Severity of the line search.

            if < 0 or > 1, set to 0.25.
        """
        return _optim.TNC_getEta(self)

    def setEta(self, *args):
        """
        Accessor to eta parameter.

        Parameters
        ----------
        eta : float
            Severity of the line search.

            if < 0 or > 1, set to 0.25.
        """
        return _optim.TNC_setEta(self, *args)

    def getStepmx(self):
        """
        Accessor to stepmx parameter.

        Returns
        -------
        stepmx : float
            Maximum step for the line search. may be increased during call

            if too small, will be set to 10.0.
        """
        return _optim.TNC_getStepmx(self)

    def setStepmx(self, *args):
        """
        Accessor to stepmx parameter.

        Parameters
        ----------
        stepmx : float
            Maximum step for the line search. may be increased during call

            if too small, will be set to 10.0.
        """
        return _optim.TNC_setStepmx(self, *args)

    def getAccuracy(self):
        """
        Accessor to accuracy parameter.

        Returns
        -------
        accuracy : float
            Relative precision for finite difference calculations

            if <= machine_precision, set to sqrt(machine_precision).
        """
        return _optim.TNC_getAccuracy(self)

    def setAccuracy(self, *args):
        """
        Accessor to accuracy parameter.

        Parameters
        ----------
        accuracy : float
            Relative precision for finite difference calculations

            if <= machine_precision, set to sqrt(machine_precision).
        """
        return _optim.TNC_setAccuracy(self, *args)

    def getFmin(self):
        """
        Accessor to fmin parameter.

        Returns
        -------
        fmin : float
            Minimum function value estimate.
        """
        return _optim.TNC_getFmin(self)

    def setFmin(self, *args):
        """
        Accessor to fmin parameter.

        Parameters
        ----------
        fmin : float
            Minimum function value estimate.
        """
        return _optim.TNC_setFmin(self, *args)

    def getRescale(self):
        """
        Accessor to rescale parameter.

        Returns
        -------
        rescale : float
            f scaling factor (in log10) used to trigger f value rescaling

            if 0, rescale at each iteration

            if a big value, never rescale

            if < 0, rescale is set to 1.3.
        """
        return _optim.TNC_getRescale(self)

    def setRescale(self, *args):
        """
        Accessor to rescale parameter.

        Parameters
        ----------
        rescale : float
            f scaling factor (in log10) used to trigger f value rescaling

            if 0, rescale at each iteration

            if a big value, never rescale

            if < 0, rescale is set to 1.3.
        """
        return _optim.TNC_setRescale(self, *args)

    def __repr__(self): return _optim.TNC___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_TNC(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_TNC
    __del__ = lambda self : None;
TNC_swigregister = _optim.TNC_swigregister
TNC_swigregister(TNC)

class SQP(OptimizationSolverImplementation):
    """
    Sequential Quadratic Programming solver.

    Available constructors:
        SQP(*problem*)

        SQP(*problem, tau, omega, smooth*)

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    tau : float
        Multiplicative decrease of linear step.
    omega : float
        Armijo factor.
    smooth : float
        Growing factor in penalization term.

    Notes
    -----
    SQP methods solve a sequence of optimization subproblems,
    each of which optimizes a quadratic model of the objective
    subject to a linearization of the constraints.

    See also
    --------
    AbdoRackwitz, Cobyla, TNC, NLopt

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.NumericalMathFunction(['x1', 'x2', 'x3', 'x4'], ['y1'], ['x1*cos(x1)+2*x2*x3-3*x3+4*x3*x4'])
    >>> problem = ot.OptimizationProblem(model, -0.5)
    >>> algo = ot.SQP(problem)
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SQP, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SQP, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.SQP_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.SQP_run(self)

    def getTau(self):
        """
        Accessor to tau parameter.

        Returns
        -------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.SQP_getTau(self)

    def setTau(self, *args):
        """
        Accessor to tau parameter.

        Parameters
        ----------
        tau : float
            Multiplicative decrease of linear step.
        """
        return _optim.SQP_setTau(self, *args)

    def getOmega(self):
        """
        Accessor to omega parameter.

        Returns
        -------
        omega : float
            Armijo factor.
        """
        return _optim.SQP_getOmega(self)

    def setOmega(self, *args):
        """
        Accessor to omega parameter.

        Parameters
        ----------
        omega : float
            Armijo factor.
        """
        return _optim.SQP_setOmega(self, *args)

    def getSmooth(self):
        """
        Accessor to smooth parameter.

        Returns
        -------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.SQP_getSmooth(self)

    def setSmooth(self, *args):
        """
        Accessor to smooth parameter.

        Parameters
        ----------
        smooth : float
            Growing factor in penalization term.
        """
        return _optim.SQP_setSmooth(self, *args)

    def __repr__(self): return _optim.SQP___repr__(self)
    def __init__(self, *args): 
        this = _optim.new_SQP(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_SQP
    __del__ = lambda self : None;
SQP_swigregister = _optim.SQP_swigregister
SQP_swigregister(SQP)

class NLopt(OptimizationSolverImplementation):
    """
    Interface to NLopt.

    This class exposes the solvers from the non-linear optimization library [NLopt]_.

    More details about available algorithms are available `here <http://ab-initio.mit.edu/wiki/index.php/NLopt_Algorithms>`_.

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        Optimization problem to solve.
    algoName : str
        The NLopt identifier of the algorithm.
        Use :func:`GetAlgorithmNames()` to list available names.

    See also
    --------
    AbdoRackwitz, Cobyla, SQP, TNC

    Examples
    --------
    >>> import openturns as ot
    >>> dim = 4
    >>> bounds = ot.Interval([-3.0] * dim, [5.0] * dim)
    >>> linear = ot.NumericalMathFunction(['x1', 'x2', 'x3', 'x4'], ['y1'], ['x1+2*x2-3*x3+4*x4'])
    >>> problem = ot.OptimizationProblem(linear, ot.NumericalMathFunction(), ot.NumericalMathFunction(), bounds)
    >>> algo = ot.NLopt(problem, 'LD_MMA')
    >>> algo.setStartingPoint([0.0] * 4)
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NLopt, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NLopt, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NLopt_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.NLopt_run(self)

    def GetAlgorithmNames():
        """
        Accessor to the list of algorithms provided by NLopt, by names.

        Returns
        -------
        names : :class:`~openturns.Description`
            List of algorithm names provided by NLopt, according to its naming convention.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NLopt.GetAlgorithmNames())
        [AUGLAG,AUGLAG_EQ,GD_MLSL,GD_MLSL_LDS,GD_STOGO,GD_STOGO_RAND,GN_CRS2_LM,GN_DIRECT,GN_DIRECT_L,GN_DIRECT_L_NOSCAL,GN_DIRECT_L_RAND,GN_DIRECT_L_RAND_NOSCAL,GN_DIRECT_NOSCAL,GN_ESCH,GN_ISRES,GN_MLSL,GN_MLSL_LDS,GN_ORIG_DIRECT,GN_ORIG_DIRECT_L,G_MLSL,G_MLSL_LDS,LD_AUGLAG,LD_AUGLAG_EQ,LD_CCSAQ,LD_LBFGS,LD_LBFGS_NOCEDAL,LD_MMA,LD_SLSQP,LD_TNEWTON,LD_TNEWTON_PRECOND,LD_TNEWTON_PRECOND_RESTART,LD_TNEWTON_RESTART,LD_VAR1,LD_VAR2,LN_AUGLAG,LN_AUGLAG_EQ,LN_BOBYQA,LN_COBYLA,LN_NELDERMEAD,LN_NEWUOA,LN_NEWUOA_BOUND,LN_PRAXIS,LN_SBPLX]#43
        """
        return _optim.NLopt_GetAlgorithmNames()

    if _newclass:GetAlgorithmNames = staticmethod(GetAlgorithmNames)
    __swig_getmethods__["GetAlgorithmNames"] = lambda x: GetAlgorithmNames
    def setAlgorithmName(self, *args):
        """
        Accessor to the algorithm name.

        Parameters
        ----------
        algoName : str
            The NLopt identifier of the algorithm.
        """
        return _optim.NLopt_setAlgorithmName(self, *args)

    def getAlgorithmName(self):
        """
        Accessor to the algorithm name.

        Returns
        -------
        algoName : str
            The NLopt identifier of the algorithm.
        """
        return _optim.NLopt_getAlgorithmName(self)

    def setInitialStep(self, *args):
        """
        Initial local derivative-free algorithms step accessor.

        Parameters
        ----------
        dx : sequence of float
            The initial step.
        """
        return _optim.NLopt_setInitialStep(self, *args)

    def getInitialStep(self):
        """
        Initial local derivative-free algorithms step accessor.

        Returns
        -------
        dx : :class:`~openturns.NumericalPoint`
            The initial step.
        """
        return _optim.NLopt_getInitialStep(self)

    def setLocalSolver(self, *args):
        """
        Local solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.NLopt`
            The local solver.
        """
        return _optim.NLopt_setLocalSolver(self, *args)

    def getLocalSolver(self):
        """
        Local solver accessor.

        Returns
        -------
        solver : :class:`~openturns.NLopt`
            The local solver.
        """
        return _optim.NLopt_getLocalSolver(self)

    def SetSeed(*args):
        """
        Initialize the random generator seed.

        Parameters
        ----------
        seed : int
            The RNG seed.
        """
        return _optim.NLopt_SetSeed(*args)

    if _newclass:SetSeed = staticmethod(SetSeed)
    __swig_getmethods__["SetSeed"] = lambda x: SetSeed
    def __repr__(self): return _optim.NLopt___repr__(self)
    def __str__(self, offset=""): return _optim.NLopt___str__(self, offset)
    def __init__(self, *args): 
        this = _optim.new_NLopt(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_NLopt
    __del__ = lambda self : None;
NLopt_swigregister = _optim.NLopt_swigregister
NLopt_swigregister(NLopt)

def NLopt_GetAlgorithmNames():
  """
    Accessor to the list of algorithms provided by NLopt, by names.

    Returns
    -------
    names : :class:`~openturns.Description`
        List of algorithm names provided by NLopt, according to its naming convention.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NLopt.GetAlgorithmNames())
    [AUGLAG,AUGLAG_EQ,GD_MLSL,GD_MLSL_LDS,GD_STOGO,GD_STOGO_RAND,GN_CRS2_LM,GN_DIRECT,GN_DIRECT_L,GN_DIRECT_L_NOSCAL,GN_DIRECT_L_RAND,GN_DIRECT_L_RAND_NOSCAL,GN_DIRECT_NOSCAL,GN_ESCH,GN_ISRES,GN_MLSL,GN_MLSL_LDS,GN_ORIG_DIRECT,GN_ORIG_DIRECT_L,G_MLSL,G_MLSL_LDS,LD_AUGLAG,LD_AUGLAG_EQ,LD_CCSAQ,LD_LBFGS,LD_LBFGS_NOCEDAL,LD_MMA,LD_SLSQP,LD_TNEWTON,LD_TNEWTON_PRECOND,LD_TNEWTON_PRECOND_RESTART,LD_TNEWTON_RESTART,LD_VAR1,LD_VAR2,LN_AUGLAG,LN_AUGLAG_EQ,LN_BOBYQA,LN_COBYLA,LN_NELDERMEAD,LN_NEWUOA,LN_NEWUOA_BOUND,LN_PRAXIS,LN_SBPLX]#43
    """
  return _optim.NLopt_GetAlgorithmNames()

def NLopt_SetSeed(*args):
  """
    Initialize the random generator seed.

    Parameters
    ----------
    seed : int
        The RNG seed.
    """
  return _optim.NLopt_SetSeed(*args)

class LBFGS(NLopt):
    __swig_setmethods__ = {}
    for _s in [NLopt]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LBFGS, name, value)
    __swig_getmethods__ = {}
    for _s in [NLopt]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LBFGS, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.LBFGS_getClassName(self)

    def __init__(self, *args): 
        this = _optim.new_LBFGS(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_LBFGS
    __del__ = lambda self : None;
LBFGS_swigregister = _optim.LBFGS_swigregister
LBFGS_swigregister(LBFGS)

class NelderMead(NLopt):
    __swig_setmethods__ = {}
    for _s in [NLopt]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NelderMead, name, value)
    __swig_getmethods__ = {}
    for _s in [NLopt]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NelderMead, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.NelderMead_getClassName(self)

    def __init__(self, *args): 
        this = _optim.new_NelderMead(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_NelderMead
    __del__ = lambda self : None;
NelderMead_swigregister = _optim.NelderMead_swigregister
NelderMead_swigregister(NelderMead)

class SLSQP(NLopt):
    __swig_setmethods__ = {}
    for _s in [NLopt]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SLSQP, name, value)
    __swig_getmethods__ = {}
    for _s in [NLopt]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SLSQP, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.SLSQP_getClassName(self)

    def __init__(self, *args): 
        this = _optim.new_SLSQP(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_SLSQP
    __del__ = lambda self : None;
SLSQP_swigregister = _optim.SLSQP_swigregister
SLSQP_swigregister(SLSQP)

class LevelSet(openturns.typ.DomainImplementation):
    """
    Level set.

    Available constructors:
        LevelSet(*dim=1*)

        LevelSet(*function=ot.NumericalMathFunction('x', '1.0'), level=0.0*)

    Parameters
    ----------
    dim : int, :math:`dim \\geq 0`
        Dimension of the LevelSet.
    function : :class:`~openturns.NumericalMathFunction`
        A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
        LevelSet.
    level : float
        Level :math:`s` defining the LevelSet.

    Notes
    -----
    A LevelSet is a :class:`~openturns.Domain` defined as follows:

    .. math::

        \\{ \\vect{x} \\in \\Rset^{dim} \\, | \\, f(\\vect{x}) \\leq s \\}

    Examples
    --------
    >>> import openturns as ot
    >>> function = ot.NumericalMathFunction(['x1', 'x2'], ['x1^4 + x2^4'])
    >>> s = 1.0
    >>> levelSet = ot.LevelSet(function, s)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelSet, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelSet, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.LevelSet_getClassName(self)

    def contains(self, *args):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _optim.LevelSet_contains(self, *args)

    def intersect(self, *args):
        """
        Return the levelSet equals to the intersection between the LevelSet and another one.

        Parameters
        ----------
        otherLevelSet :
            A LevelSet defined by :math:`(f_2, s_2)`.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            *levelSet* equals to the intersection between the LevelSet and
            *otherLevelSet* i.e. *levelSet* is defined by:
            :math:`\\{\\vect{x} \\in \\Rset^{dim} | f(\\vect{x}) \\leq s \\, \\mbox{and} \\, f_2(\\vect{x}) \\leq s_2\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> # First level set
        >>> function = ot.NumericalMathFunction(['x'], ['3*x-1'])
        >>> levelSet1 = ot.LevelSet(function, 0.5)
        >>> # Second level set
        >>> function = ot.NumericalMathFunction(['x'], ['x'])
        >>> levelSet2 = ot.LevelSet(function, 0.5)
        >>> # Intersection between levelSet1 and levelSet2
        >>> intersection = levelSet1.intersect(levelSet2)
        >>> # Tests
        >>> print(intersection.contains([1.0]))
        False
        >>> print(intersection.contains([0.25]))
        True
        """
        return _optim.LevelSet_intersect(self, *args)

    def join(self, *args):
        """
        Return the levelSet equals to the union between the LevelSet and another one.

        Parameters
        ----------
        otherLevelSet :
            A LevelSet defined by :math:`(f_2, s_2)`.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            *levelSet* equals to the union between the LevelSet and *otherLevelSet*
            i.e. *levelSet* is defined by:
            :math:`\\{\\vect{x} \\in \\Rset^{dim} | f(\\vect{x}) \\leq s \\, \\mbox{or} \\, f_2(\\vect{x}) \\leq s_2\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> # First level set
        >>> function = ot.NumericalMathFunction(['x'], ['3*x-1'])
        >>> levelSet1 = ot.LevelSet(function, 0.0)
        >>> # Second level set
        >>> function = ot.NumericalMathFunction(['x'], ['x'])
        >>> levelSet2 = ot.LevelSet(function, 0.0)
        >>> # Union between levelSet1 and levelSet2
        >>> join = levelSet1.join(levelSet2)
        >>> # Tests
        >>> print(join.contains([0.5]))
        False
        >>> print(join.contains([0.25]))
        True
        """
        return _optim.LevelSet_join(self, *args)

    def __eq__(self, *args): return _optim.LevelSet___eq__(self, *args)
    def getFunction(self):
        """
        Get the function defining the level set.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
            LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> function = ot.NumericalMathFunction(['x'], ['3*x-1'])
        >>> levelSet = ot.LevelSet(function, 0.0)
        >>> print(levelSet.getFunction().getEvaluation())
        [x]->[3*x-1]
        """
        return _optim.LevelSet_getFunction(self)

    def setFunction(self, *args):
        """
        Set the function defining the level set.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            A function such that: :math:`f: \\Rset^{dim} \\mapsto \\Rset` defining the
            LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> levelSet = ot.LevelSet()
        >>> function = ot.NumericalMathFunction(['x'], ['3*x-1'])
        >>> levelSet.setFunction(function)
        """
        return _optim.LevelSet_setFunction(self, *args)

    def getLevel(self):
        """
        Get the level defining the level set.

        Returns
        -------
        level : float
            Level :math:`s` defining the LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> function = ot.NumericalMathFunction(['x'], ['3*x-1'])
        >>> levelSet = ot.LevelSet(function, 0.0)
        >>> print(levelSet.getLevel())
        0.0
        """
        return _optim.LevelSet_getLevel(self)

    def setLevel(self, *args):
        """
        Set the level defining the level set.

        Parameters
        ----------
        level : float
            Level :math:`s` defining the LevelSet.

        Examples
        --------
        >>> import openturns as ot
        >>> levelSet = ot.LevelSet()
        >>> levelSet.setLevel(3.0)
        """
        return _optim.LevelSet_setLevel(self, *args)

    def setLowerBound(self, *args):
        """
        Set the lower bound of the bounding box.

        Parameters
        ----------
        bound : sequence of floats
            Lower bound of the bounding box of the level set. It allows to clip the level set.
        """
        return _optim.LevelSet_setLowerBound(self, *args)

    def getLowerBound(self):
        """
        Get the lower bound of the domain.

        Returns
        -------
        lower : :class:`~openturns.NumericalPoint`
            The lower bound of an axes-aligned bounding box of the domain.
        """
        return _optim.LevelSet_getLowerBound(self)

    def setUpperBound(self, *args):
        """
        Set the upper bound of the bounding box.

        Parameters
        ----------
        bound : sequence of floats
            Upper bound of the bounding box of the level set. It allows to clip the level set.
        """
        return _optim.LevelSet_setUpperBound(self, *args)

    def getUpperBound(self):
        """
        Get the upper bound of the domain.

        Returns
        -------
        upper : :class:`~openturns.NumericalPoint`
            The upper bound of an axes-aligned bounding box of the domain.
        """
        return _optim.LevelSet_getUpperBound(self)

    def __repr__(self): return _optim.LevelSet___repr__(self)
    def __str__(self, offset=""): return _optim.LevelSet___str__(self, offset)
    def __init__(self, *args): 
        this = _optim.new_LevelSet(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_LevelSet
    __del__ = lambda self : None;
LevelSet_swigregister = _optim.LevelSet_swigregister
LevelSet_swigregister(LevelSet)

class LevelSetMesher(openturns.common.PersistentObject):
    """
    Creation of mesh of box type.

    Available constructor:
        LevelSetMesher(*discretization*)

    Parameters
    ----------
    discretization : sequence of int, of dimension :math:`\\leq 3`.
        Discretization of the level set bounding box.
    solver : :class:`~openturns.OptimizationSolver`
        Optimization solver used to project the vertices onto the level set.
        It must be able to solve nearest point problems.
        Default is :class:`~openturns.AbdoRackwitz`.

    Notes
    -----
    The meshing algorithm is based on the :class:`~openturns.IntervalMesher` class.
    First, the bounding box of the level set (provided by the user or automatically
    computed) is meshed. Then, all the simplices with all vertices outside of the
    level set are rejected, while the simplices with all vertices inside of the level
    set are kept. The remaining simplices are adapted the following way :

      * The mean point of the vertices inside of the level set is computed

      * Each vertex outside of the level set is projected onto the level set using
        a linear interpolation

      * If the *project* flag is *True*, then the projection is refined using an
        optimization solver.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> mesher = ot.LevelSetMesher([5, 10])
    >>> level = 1.0
    >>> function = ot.NumericalMathFunction(['x0', 'x1'], ['x0^2+x1^2'])
    >>> levelSet = ot.LevelSet(function, level)
    >>> mesh = mesher.build(levelSet)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LevelSetMesher, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LevelSetMesher, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.LevelSetMesher_getClassName(self)

    def setDiscretization(self, *args):
        """
        Accessor to the discretization.

        Parameters
        ----------
        discretization : sequence of int
            Discretization of the bounding box of the level sets.
        """
        return _optim.LevelSetMesher_setDiscretization(self, *args)

    def getDiscretization(self):
        """
        Accessor to the discretization.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            Discretization of the bounding box of the level sets.
        """
        return _optim.LevelSetMesher_getDiscretization(self)

    def __repr__(self): return _optim.LevelSetMesher___repr__(self)
    def __str__(self, offset=""): return _optim.LevelSetMesher___str__(self, offset)
    def setOptimizationSolver(self, *args):
        """
        Accessor to the optimization solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationSolver`
            The optimization solver used to project vertices onto the level set.
        """
        return _optim.LevelSetMesher_setOptimizationSolver(self, *args)

    def getOptimizationSolver(self):
        """
        Accessor to the optimization solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationSolver`
            The optimization solver used to project vertices onto the level set.
        """
        return _optim.LevelSetMesher_getOptimizationSolver(self)

    def build(self, *args):
        """
        Build the mesh of level set type.

        Parameters
        ----------
        levelSet : :class:`~openturns.LevelSet`
            The level set to be meshed, of dimension equal to the dimension
            of `discretization`.
        boundingBox : :class:`~openturns.Interval`
            The bounding box used to mesh the level set. By default it is automatically computed from the elements of the given level set.
        project : bool
            Flag to tell if the vertices outside of the level set of a simplex partially included into the level set have to be projected onto the level set. Default is *True*.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh built.
        """
        return _optim.LevelSetMesher_build(self, *args)

    def __init__(self, *args): 
        this = _optim.new_LevelSetMesher(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_LevelSetMesher
    __del__ = lambda self : None;
LevelSetMesher_swigregister = _optim.LevelSetMesher_swigregister
LevelSetMesher_swigregister(LevelSetMesher)

class SolverImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementationPointer, name)
    __repr__ = _swig_repr
    __swig_setmethods__["ptr_"] = _optim.SolverImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.SolverImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_optim.SolverImplementationPointer_ptr__get, _optim.SolverImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _optim.new_SolverImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_SolverImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _optim.SolverImplementationPointer_reset(self)
    def __ref__(self, *args): return _optim.SolverImplementationPointer___ref__(self, *args)
    def __deref__(self): return _optim.SolverImplementationPointer___deref__(self)
    def isNull(self): return _optim.SolverImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _optim.SolverImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _optim.SolverImplementationPointer_get(self)
    def getImplementation(self): return _optim.SolverImplementationPointer_getImplementation(self)
    def unique(self): return _optim.SolverImplementationPointer_unique(self)
    def use_count(self): return _optim.SolverImplementationPointer_use_count(self)
    def swap(self, *args): return _optim.SolverImplementationPointer_swap(self, *args)
SolverImplementationPointer_swigregister = _optim.SolverImplementationPointer_swigregister
SolverImplementationPointer_swigregister(SolverImplementationPointer)

class OptimizationProblemImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationProblemImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationProblemImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _optim.OptimizationProblemImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.OptimizationProblemImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_optim.OptimizationProblemImplementationPointer_ptr__get, _optim.OptimizationProblemImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _optim.new_OptimizationProblemImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationProblemImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _optim.OptimizationProblemImplementationPointer_reset(self)
    def __ref__(self, *args): return _optim.OptimizationProblemImplementationPointer___ref__(self, *args)
    def __deref__(self): return _optim.OptimizationProblemImplementationPointer___deref__(self)
    def isNull(self): return _optim.OptimizationProblemImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _optim.OptimizationProblemImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _optim.OptimizationProblemImplementationPointer_get(self)
    def getImplementation(self): return _optim.OptimizationProblemImplementationPointer_getImplementation(self)
    def unique(self): return _optim.OptimizationProblemImplementationPointer_unique(self)
    def use_count(self): return _optim.OptimizationProblemImplementationPointer_use_count(self)
    def swap(self, *args): return _optim.OptimizationProblemImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationProblemImplementationPointer_getClassName(self)

    def getObjective(self):
        """
        Accessor to objective function.

        Returns
        -------
        objective : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblemImplementationPointer_getObjective(self)

    def setObjective(self, *args):
        """
        Accessor to objective function.

        Parameters
        ----------
        objectiveFunction : :class:`~openturns.NumericalMathFunction`
            Objective function.
        """
        return _optim.OptimizationProblemImplementationPointer_setObjective(self, *args)

    def hasMultipleObjective(self):
        """
        Test whether objective function is a scalar or vector function.

        Returns
        -------
        value : bool
            *False* if objective function is scalar, *True* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasMultipleObjective(self)

    def getEqualityConstraint(self):
        """
        Accessor to equality constraints.

        Returns
        -------
        equality : :class:`~openturns.NumericalMathFunction`
            Describe equality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_getEqualityConstraint(self)

    def setEqualityConstraint(self, *args):
        """
        Accessor to equality constraints.

        Parameters
        ----------
        equalityConstraint : :class:`~openturns.NumericalMathFunction`
            Equality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_setEqualityConstraint(self, *args)

    def hasEqualityConstraint(self):
        """
        Test whether equality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if equality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasEqualityConstraint(self)

    def getInequalityConstraint(self):
        """
        Accessor to inequality constraints.

        Returns
        -------
        inequality : :class:`~openturns.NumericalMathFunction`
            Describe inequality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_getInequalityConstraint(self)

    def setInequalityConstraint(self, *args):
        """
        Accessor to inequality constraints.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.NumericalMathFunction`
            Inequality constraints.
        """
        return _optim.OptimizationProblemImplementationPointer_setInequalityConstraint(self, *args)

    def hasInequalityConstraint(self):
        """
        Test whether inequality constraints had been specified.

        Returns
        -------
        value : bool
            *True* if inequality constraints had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasInequalityConstraint(self)

    def getBounds(self):
        """
        Accessor to bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementationPointer_getBounds(self)

    def setBounds(self, *args):
        """
        Accessor to bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Problem bounds.
        """
        return _optim.OptimizationProblemImplementationPointer_setBounds(self, *args)

    def hasBounds(self):
        """
        Test whether bounds had been specified.

        Returns
        -------
        value : bool
            *True* if bounds had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasBounds(self)

    def getLevelFunction(self):
        """
        Accessor to level function.

        Returns
        -------
        level : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblemImplementationPointer_getLevelFunction(self)

    def setLevelFunction(self, *args):
        """
        Accessor to level function.

        Parameters
        ----------
        levelFunction : :class:`~openturns.NumericalMathFunction`
            Level function.
        """
        return _optim.OptimizationProblemImplementationPointer_setLevelFunction(self, *args)

    def hasLevelFunction(self):
        """
        Test whether level function had been specified.

        Returns
        -------
        value : bool
            *True* if level function had been set for this problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_hasLevelFunction(self)

    def getLevelValue(self):
        """
        Accessor to level value.

        Returns
        -------
        value : float
            Level value.
        """
        return _optim.OptimizationProblemImplementationPointer_getLevelValue(self)

    def setLevelValue(self, *args):
        """
        Accessor to level value.

        Parameters
        ----------
        levelValue : float
            Level value.
        """
        return _optim.OptimizationProblemImplementationPointer_setLevelValue(self, *args)

    def getDimension(self):
        """
        Accessor to spatial dimension.

        Returns
        -------
        dimension : int
            Input dimension of objective function.
        """
        return _optim.OptimizationProblemImplementationPointer_getDimension(self)

    def setMinimization(self, *args):
        """
        Tell whether this is a minimization or maximization problem.

        Parameters
        ----------
        minimization : bool
            *True* if this is a minimization problem, *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_setMinimization(self, *args)

    def isMinimization(self):
        """
        Test whether this is a minimization or maximization problem.

        Returns
        -------
        value : bool
            *True* if this is a minimization problem (default), *False* otherwise.
        """
        return _optim.OptimizationProblemImplementationPointer_isMinimization(self)

    def __repr__(self): return _optim.OptimizationProblemImplementationPointer___repr__(self)
    def __eq__(self, *args): return _optim.OptimizationProblemImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _optim.OptimizationProblemImplementationPointer___ne__(self, *args)
    def __str__(self, offset=""): return _optim.OptimizationProblemImplementationPointer___str__(self, offset)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationProblemImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationProblemImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationProblemImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _optim.OptimizationProblemImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _optim.OptimizationProblemImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationProblemImplementationPointer_setName(self, *args)

OptimizationProblemImplementationPointer_swigregister = _optim.OptimizationProblemImplementationPointer_swigregister
OptimizationProblemImplementationPointer_swigregister(OptimizationProblemImplementationPointer)

class OptimizationSolverImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationSolverImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationSolverImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _optim.OptimizationSolverImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _optim.OptimizationSolverImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_optim.OptimizationSolverImplementationPointer_ptr__get, _optim.OptimizationSolverImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _optim.new_OptimizationSolverImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _optim.delete_OptimizationSolverImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _optim.OptimizationSolverImplementationPointer_reset(self)
    def __ref__(self, *args): return _optim.OptimizationSolverImplementationPointer___ref__(self, *args)
    def __deref__(self): return _optim.OptimizationSolverImplementationPointer___deref__(self)
    def isNull(self): return _optim.OptimizationSolverImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _optim.OptimizationSolverImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _optim.OptimizationSolverImplementationPointer_get(self)
    def getImplementation(self): return _optim.OptimizationSolverImplementationPointer_getImplementation(self)
    def unique(self): return _optim.OptimizationSolverImplementationPointer_unique(self)
    def use_count(self): return _optim.OptimizationSolverImplementationPointer_use_count(self)
    def swap(self, *args): return _optim.OptimizationSolverImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _optim.OptimizationSolverImplementationPointer_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _optim.OptimizationSolverImplementationPointer_run(self)

    def computeLagrangeMultipliers(self, *args):
        """
        Compute the Lagrange multipliers of a problem at a given point.

        Parameters
        ----------
        x : sequence of float
            Point at which the Lagrange multipliers are computed.

        Returns
        -------
        lagrangeMultiplier : sequence of float
            Lagrange multipliers of the problem at the given point.

        Notes
        -----
        The Lagrange multipliers :math:`\\vect{\\lambda}` are associated with the following Lagrangian formulation of the optimization problem:

        .. math::

            \\cL(\\vect{x}, \\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq}) = J(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{eq} g(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{\\ell} (\\vect{x}-\\vect{\\ell})^{+} + \\Tr{\\vect{\\lambda}}_{u} (\\vect{u}-\\vect{x})^{+} + \\Tr{\\vect{\\lambda}}_{ineq}  h^{+}(\\vect{x})

        where :math:`\\vect{\\alpha}^{+}=(\\max(0,\\alpha_1),\\hdots,\\max(0,\\alpha_n))`.

        The Lagrange multipliers are stored as :math:`(\\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq})`, where:
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no equality
              constraint, else of dimension the dimension of :math:`g(\\vect{x})` ie the number of scalar equality constraints
            - :math:`\\vect{\\lambda}_{\\ell}` and :math:`\\vect{\\lambda}_{u}` are of dimension 0 if there is no bound constraint, else of dimension of :math:`\\vect{x}`
            - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no inequality constraint, else of dimension the dimension of :math:`h(\\vect{x})` ie the number of scalar inequality constraints

        The vector :math:`\\vect{\\lambda}` is solution of the following linear system:

        .. math::

            \\Tr{\\vect{\\lambda}}_{eq}\\left[\\dfrac{\\partial g}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{\\ell}\\left[\\dfrac{\\partial (\\vect{x}-\\vect{\\ell})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{u}\\left[\\dfrac{\\partial (\\vect{u}-\\vect{x})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
            \\Tr{\\vect{\\lambda}}_{ineq}\\left[\\dfrac{\\partial h}{\\partial\\vect{x}}(\\vect{x})\\right]=-\\dfrac{\\partial J}{\\partial\\vect{x}}(\\vect{x})

        If there is no constraint of any kind, :math:`\\vect{\\lambda}` is of dimension 0, as well as if no constraint is active.

        """
        return _optim.OptimizationSolverImplementationPointer_computeLagrangeMultipliers(self, *args)

    def getStartingPoint(self):
        """
        Accessor to starting point.

        Returns
        -------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolverImplementationPointer_getStartingPoint(self)

    def setStartingPoint(self, *args):
        """
        Accessor to starting point.

        Parameters
        ----------
        startingPoint : :class:`~openturns.NumericalPoint`
            Starting point.
        """
        return _optim.OptimizationSolverImplementationPointer_setStartingPoint(self, *args)

    def getProblem(self):
        """
        Accessor to optimization problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolverImplementationPointer_getProblem(self)

    def setProblem(self, *args):
        """
        Accessor to optimization problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            Optimization problem.
        """
        return _optim.OptimizationSolverImplementationPointer_setProblem(self, *args)

    def getResult(self):
        """
        Accessor to optimization result.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolverImplementationPointer_getResult(self)

    def setResult(self, *args):
        """
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Result class.
        """
        return _optim.OptimizationSolverImplementationPointer_setResult(self, *args)

    def setMaximumIterationNumber(self, *args):
        """
        Accessor to maximum allowed number of iterations.

        Parameters
        ----------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumIterationNumber(self, *args)

    def getMaximumIterationNumber(self):
        """
        Accessor to maximum allowed number of iterations.

        Returns
        -------
        N : int
            Maximum allowed number of iterations.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumIterationNumber(self)

    def setMaximumEvaluationNumber(self, *args):
        """
        Accessor to maximum allowed number of evaluations.

        Parameters
        ----------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumEvaluationNumber(self, *args)

    def getMaximumEvaluationNumber(self):
        """
        Accessor to maximum allowed number of evaluations.

        Returns
        -------
        N : int
            Maximum allowed number of evaluations.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumEvaluationNumber(self)

    def getMaximumAbsoluteError(self):
        """
        Accessor to maximum allowed absolute error.

        Returns
        -------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumAbsoluteError(self)

    def setMaximumAbsoluteError(self, *args):
        """
        Accessor to maximum allowed absolute error.

        Parameters
        ----------
        maximumAbsoluteError : float
            Maximum allowed absolute error.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumAbsoluteError(self, *args)

    def getMaximumRelativeError(self):
        """
        Accessor to maximum allowed relative error.

        Returns
        -------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumRelativeError(self)

    def setMaximumRelativeError(self, *args):
        """
        Accessor to maximum allowed relative error.

        Parameters
        ----------
        maximumRelativeError : float
            Maximum allowed relative error.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumRelativeError(self, *args)

    def getMaximumResidualError(self):
        """
        Accessor to maximum allowed residual error.

        Returns
        -------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumResidualError(self)

    def setMaximumResidualError(self, *args):
        """
        Accessor to maximum allowed residual error.

        Parameters
        ----------
        maximumResidualError : float
            Maximum allowed residual error.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumResidualError(self, *args)

    def getMaximumConstraintError(self):
        """
        Accessor to maximum allowed constraint error.

        Returns
        -------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolverImplementationPointer_getMaximumConstraintError(self)

    def setMaximumConstraintError(self, *args):
        """
        Accessor to maximum allowed constraint error.

        Parameters
        ----------
        maximumConstraintError : float
            Maximum allowed constraint error.
        """
        return _optim.OptimizationSolverImplementationPointer_setMaximumConstraintError(self, *args)

    def __repr__(self): return _optim.OptimizationSolverImplementationPointer___repr__(self)
    def getVerbose(self):
        """
        Accessor to the verbosity flag.

        Returns
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolverImplementationPointer_getVerbose(self)

    def setVerbose(self, *args):
        """
        Accessor to the verbosity flag.

        Parameters
        ----------
        verbose : bool
            Verbosity flag state.
        """
        return _optim.OptimizationSolverImplementationPointer_setVerbose(self, *args)

    def __eq__(self, *args): return _optim.OptimizationSolverImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _optim.OptimizationSolverImplementationPointer___ne__(self, *args)
    def __str__(self, offset=""): return _optim.OptimizationSolverImplementationPointer___str__(self, offset)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _optim.OptimizationSolverImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationSolverImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _optim.OptimizationSolverImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationSolverImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _optim.OptimizationSolverImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _optim.OptimizationSolverImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _optim.OptimizationSolverImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _optim.OptimizationSolverImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _optim.OptimizationSolverImplementationPointer_setName(self, *args)

OptimizationSolverImplementationPointer_swigregister = _optim.OptimizationSolverImplementationPointer_swigregister
OptimizationSolverImplementationPointer_swigregister(OptimizationSolverImplementationPointer)

# This file is compatible with both classic and new-style classes.


