# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Geometrical classes.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_geom', [dirname(__file__)])
        except ImportError:
            import _geom
            return _geom
        if fp is not None:
            try:
                _mod = imp.load_module('_geom', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _geom = swig_import_helper()
    del swig_import_helper
else:
    import _geom
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _geom.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _geom.SwigPyIterator_value(self)
    def incr(self, n=1): return _geom.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _geom.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _geom.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _geom.SwigPyIterator_equal(self, *args)
    def copy(self): return _geom.SwigPyIterator_copy(self)
    def next(self): return _geom.SwigPyIterator_next(self)
    def __next__(self): return _geom.SwigPyIterator___next__(self)
    def previous(self): return _geom.SwigPyIterator_previous(self)
    def advance(self, *args): return _geom.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _geom.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _geom.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _geom.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _geom.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _geom.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _geom.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _geom.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _geom.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.graph
class DomainImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DomainImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DomainImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _geom.new_DomainImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _geom.DomainImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _geom.DomainImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _geom.DomainImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _geom.DomainImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _geom.delete_DomainImplementationTypedInterfaceObject
    __del__ = lambda self : None;
DomainImplementationTypedInterfaceObject_swigregister = _geom.DomainImplementationTypedInterfaceObject_swigregister
DomainImplementationTypedInterfaceObject_swigregister(DomainImplementationTypedInterfaceObject)

class Domain(DomainImplementationTypedInterfaceObject):
    """
    Domain.

    Available constructors:
        Domain(*lowerBound, upperBound*)

    Parameters
    ----------
    lowerBound, upperBound : sequence of float of dimension *dim*
        Define a finite :class:`interval <openturns.Interval>`
        :math:`[lowerBound_0, upperBound_0]\\times \\dots \\times [lowerBound_{dim-1}, upperBound_{dim-1}]`.
        It is allowed to have :math:`lowerBound_i \\geq upperBound_i` for some
        :math:`i`: it simply defines an empty interval.
        By default, an empty interval is created.

    Notes
    -----
    A Domain object can be created through its derived classes:

    - :class:`~openturns.Mesh`

    - :class:`~openturns.RegularGrid`

    - :class:`~openturns.Interval`

    - :class:`~openturns.LevelSet`

    Examples
    --------
    >>> import openturns as ot
    >>> # Create the interval [a, b]
    >>> a = 1
    >>> b = 3
    >>> print(ot.Domain([a], [b]))
    [1, 3]
    >>> print(ot.Domain(ot.Interval(a, b)))
    [1, 3]
    """
    __swig_setmethods__ = {}
    for _s in [DomainImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Domain, name, value)
    __swig_getmethods__ = {}
    for _s in [DomainImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Domain, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.Domain_getClassName(self)

    def isEmpty(self):
        """
        Test whether the domain is empty or not.

        Returns
        -------
        isInside : bool
            *True* if the interior of the geometric domain is empty.
        """
        return _geom.Domain_isEmpty(self)

    def isNumericallyEmpty(self):
        """
        Check if the domain is numerically empty.

        Returns
        -------
        isInside : bool
            Flag telling whether the domain is numerically empty, i.e. if its numerical
            volume is inferior or equal to :math:`\\epsilon` (defined in the
            :class:`~openturns.ResourceMap`:
            :math:`\\epsilon` = DomainImplementation-SmallVolume).

        Examples
        --------
        >>> import openturns as ot
        >>> domain = ot.Domain([1.0, 2.0], [1.0, 2.0]) 
        >>> print(domain.isNumericallyEmpty())
        True
        """
        return _geom.Domain_isNumericallyEmpty(self)

    def contains(self, *args):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _geom.Domain_contains(self, *args)

    def numericallyContains(self, *args):
        """
        Check if the given point is inside of the discretization of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside the discretized domain associated
            to the domain. For now, by default, the discretized domain is equal to the
            geometrical domain.
        """
        return _geom.Domain_numericallyContains(self, *args)

    def getNumericalVolume(self):
        """
        Get the volume of the domain.

        Returns
        -------
        volume : float
            Volume of the underlying mesh which is the discretization of the domain.
            For now, by default, it is equal to the geometrical volume.
        """
        return _geom.Domain_getNumericalVolume(self)

    def getVolume(self):
        """
        Get the geometric volume of the domain.

        Returns
        -------
        volume : float
            Geometrical volume of the domain.
        """
        return _geom.Domain_getVolume(self)

    def getDimension(self):
        """
        Get the dimension of the domain.

        Returns
        -------
        dim : int
            Dimension of the domain.
        """
        return _geom.Domain_getDimension(self)

    def getLowerBound(self):
        """
        Get the lower bound of the domain.

        Returns
        -------
        lower : :class:`~openturns.NumericalPoint`
            The lower bound of an axes-aligned bounding box of the domain.
        """
        return _geom.Domain_getLowerBound(self)

    def getUpperBound(self):
        """
        Get the upper bound of the domain.

        Returns
        -------
        upper : :class:`~openturns.NumericalPoint`
            The upper bound of an axes-aligned bounding box of the domain.
        """
        return _geom.Domain_getUpperBound(self)

    def __init__(self, *args): 
        this = _geom.new_Domain(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _geom.delete_Domain
    __del__ = lambda self : None;
Domain_swigregister = _geom.Domain_swigregister
Domain_swigregister(Domain)

class IndicesCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndicesCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IndicesCollection, name)
    __swig_destroy__ = _geom.delete_IndicesCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _geom.IndicesCollection_clear(self)

    def __len__(self): return _geom.IndicesCollection___len__(self)
    def __eq__(self, *args): return _geom.IndicesCollection___eq__(self, *args)
    def __contains__(self, *args): return _geom.IndicesCollection___contains__(self, *args)
    def __getitem__(self, *args): return _geom.IndicesCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _geom.IndicesCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _geom.IndicesCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _geom.IndicesCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _geom.IndicesCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _geom.IndicesCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _geom.IndicesCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _geom.IndicesCollection_isEmpty(self)

    def __repr__(self): return _geom.IndicesCollection___repr__(self)
    def __str__(self, offset=""): return _geom.IndicesCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _geom.new_IndicesCollection(*args)
        try: self.this.append(this)
        except: self.this = this
IndicesCollection_swigregister = _geom.IndicesCollection_swigregister
IndicesCollection_swigregister(IndicesCollection)

class IndicesPersistentCollection(openturns.common.PersistentObject,IndicesCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,IndicesCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndicesPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,IndicesCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndicesPersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.IndicesPersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _geom.new_IndicesPersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _geom.IndicesPersistentCollection___repr__(self)
    def __str__(self, offset=""): return _geom.IndicesPersistentCollection___str__(self, offset)
    __swig_destroy__ = _geom.delete_IndicesPersistentCollection
    __del__ = lambda self : None;
IndicesPersistentCollection_swigregister = _geom.IndicesPersistentCollection_swigregister
IndicesPersistentCollection_swigregister(IndicesPersistentCollection)

class BipartiteGraph(IndicesPersistentCollection):
    """
    Bipartite red/black graph.

    Available constructors:
        BipartiteGraph(*size=0*)

        BipartiteGraph(*sequence*)

    Parameters
    ----------
    size : int, :math:`size \\geq 0`
        Size of the collection.
    sequence : sequence of :class:`~openturns.Indices`
        Cliques of the red nodes.

    Notes
    -----
    A bipartite graph is an undirected graph in which the nodes can be colored in two colors such that no edge has its two ends with the same colors. Here we force the :math:`n` red nodes to be numbered in consecutive order from 0 to :math:`n-1` and for each red node we give the list of black nodes that are the other end of the edges starting from this red node.

    Examples
    --------
    >>> import openturns as ot

    Use the first constructor:

    >>> ot.BipartiteGraph(3)
    [[],[],[]]

    Use the second constructor:

    >>> graph = ot.BipartiteGraph([[1, 3], [2, 0], [5, 4]])
    >>> graph
    [[1,3],[2,0],[5,4]]

    Use some functionalities:

    >>> graph[1] = [3, 4]
    >>> graph
    [[1,3],[3,4],[5,4]]

    >>> graph.add([1, 6])
    >>> graph
    [[1,3],[3,4],[5,4],[1,6]]
    """
    __swig_setmethods__ = {}
    for _s in [IndicesPersistentCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BipartiteGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [IndicesPersistentCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BipartiteGraph, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.BipartiteGraph_getClassName(self)

    def getRedNodes(self):
        """
        Accessor to the graph red nodes.

        Returns
        -------
        red : sequence of int, :class:`~openturns.Indices`
        """
        return _geom.BipartiteGraph_getRedNodes(self)

    def getBlackNodes(self):
        """
        Accessor to the graph black nodes.

        Returns
        -------
        black : sequence of int, :class:`~openturns.Indices`
        """
        return _geom.BipartiteGraph_getBlackNodes(self)

    def draw(self):
        """
        Draw the graph.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            View of the bipartite graph as a set of red nodes linked to black nodes.
        """
        return _geom.BipartiteGraph_draw(self)

    __swig_destroy__ = _geom.delete_BipartiteGraph
    __del__ = lambda self : None;
    def __repr__(self): return _geom.BipartiteGraph___repr__(self)
    def __str__(self, offset=""): return _geom.BipartiteGraph___str__(self, offset)
    def __init__(self, *args): 
        this = _geom.new_BipartiteGraph(*args)
        try: self.this.append(this)
        except: self.this = this
BipartiteGraph_swigregister = _geom.BipartiteGraph_swigregister
BipartiteGraph_swigregister(BipartiteGraph)

class Mesh(openturns.typ.DomainImplementation):
    """
    Mesh.

    Available constructors:
        Mesh(*dim=1*)

        Mesh(*vertices*)

        Mesh(*vertices, simplices*)

    Parameters
    ----------
    dim : int, :math:`dim \\geq 0`
        The dimension of the vertices. By default, it creates only one
        vertex of dimension :math:`dim` with components equal to 0.
    vertices : 2-d sequence of float
        Vertices' coordinates in :math:`\\Rset^{dim}`.
    simplices : 2-d sequence of int
        List of simplices defining the topology of the mesh. The simplex
        :math:`[i_1, \\dots, i_{dim+1}]` connects the vertices of indices
        :math:`(i_1, \\dots, i_{dim+1})` in :math:`\\Rset^{dim}`. In dimension 1, a
        simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
        triangle :math:`[i_1, i_2, i_3]`.

    See also
    --------
    RegularGrid

    Examples
    --------
    >>> import openturns as ot
    >>> # Define the vertices of the mesh
    >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
    >>> # Define the simplices of the mesh
    >>> simplices = [[0, 1, 2], [1, 2, 3]]
    >>> # Create the mesh of dimension 2
    >>> mesh2d = ot.Mesh(vertices, simplices)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Mesh, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.typ.DomainImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Mesh, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.Mesh_getClassName(self)

    def contains(self, *args):
        """
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _geom.Mesh_contains(self, *args)

    def getDescription(self):
        """
        Get the description of the vertices.

        Returns
        -------
        description : str
            Description of the vertices.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> vertices = ot.NumericalSample([[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]])
        >>> vertices.setDescription(['X', 'Y'])
        >>> mesh.setVertices(vertices)
        >>> print(mesh.getDescription())
        [X,Y]
        """
        return _geom.Mesh_getDescription(self)

    def getVerticesNumber(self):
        """
        Get the number of vertices of the mesh.

        Returns
        -------
        number : int
            Number of vertices of the mesh.
        """
        return _geom.Mesh_getVerticesNumber(self)

    def getSimplicesNumber(self):
        """
        Get the number of simplices of the mesh.

        Returns
        -------
        number : int
            Number of simplices of the mesh.
        """
        return _geom.Mesh_getSimplicesNumber(self)

    def getNearestVertexIndex(self, *args):
        """
        Get the index of the nearest vertex of a given point.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.

        Returns
        -------
        index : int
            Index of the simplex the nearest of *point* according to the Euclidean
            norm.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> point = [0.9, 0.4]
        >>> print(mesh2d.getNearestVertexIndex(point))
        1
        """
        return _geom.Mesh_getNearestVertexIndex(self, *args)

    def getNearestVertex(self, *args):
        """
        Get the nearest vertex of a given point.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.

        Returns
        -------
        vertex : :class:`~openturns.NumericalPoint`
            Coordinates of the nearest vertex of *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> point = [0.9, 0.4]
        >>> print(mesh2d.getNearestVertex(point))
        [1,0]
        """
        return _geom.Mesh_getNearestVertex(self, *args)

    def getVerticesToSimplicesMap(self): return _geom.Mesh_getVerticesToSimplicesMap(self)
    def __eq__(self, *args): return _geom.Mesh___eq__(self, *args)
    def isValid(self):
        """
        Check the mesh validity.

        Returns
        -------
        validity : bool
            Tells if the mesh is valid i.e. if there is non-overlaping simplices,
            no unused vertex, no simplices with duplicate vertices and no coincident
            vertices.
        """
        return _geom.Mesh_isValid(self)

    def checkPointInSimplex(self, *args):
        """
        Check if a point is inside a simplex.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.
        index : int
            Integer characterizes one simplex of the mesh.

        Returns
        -------
        isInside : bool
            Flag telling whether *point* is inside the simplex of index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> # Create a point A inside the simplex
        >>> pointA = [0.6, 0.3]
        >>> print(mesh2d.checkPointInSimplex(pointA, 0))
        True
        >>> # Create a point B outside the simplex
        >>> pointB = [1.1, 0.6]
        >>> print(mesh2d.checkPointInSimplex(pointB, 0))
        False
        """
        return _geom.Mesh_checkPointInSimplex(self, *args)

    def checkPointInSimplexWithCoordinates(self, *args):
        """
        Check if a point is inside a simplex and returns its barycentric coordinates.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.
        index : int
            Integer characterizes one simplex of the mesh.

        Returns
        -------
        isInside : bool
            Flag telling whether *point* is inside the simplex of index *index*.
        coordinates : :class:`~openturns.NumericalPoint`
            The barycentric coordinates of the given point wrt the vertices of the simplex
        .

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> # Create a point A inside the simplex
        >>> pointA = [0.6, 0.3]
        >>> print(mesh2d.checkPointInSimplexWithCoordinates(pointA, 0))
        [True, class=NumericalPoint name=Unnamed dimension=3 values=[0.4,0.3,0.3]]
        >>> # Create a point B outside the simplex
        >>> pointB = [1.1, 0.6]
        >>> print(mesh2d.checkPointInSimplexWithCoordinates(pointB, 0))
        [False, class=NumericalPoint name=Unnamed dimension=3 values=[-0.1,0.5,0.6]]
        """
        return _geom.Mesh_checkPointInSimplexWithCoordinates(self, *args)

    def getVertices(self):
        """
        Get the vertices of the mesh.

        Returns
        -------
        vertices : :class:`~openturns.NumericalSample`
            Coordinates in :math:`\\Rset^{dim}` of the vertices,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getVertices())
        0 : [ 0 0 ]
        1 : [ 1 0 ]
        2 : [ 1 1 ]
        """
        return _geom.Mesh_getVertices(self)

    def setVertices(self, *args):
        """
        Set the vertices of the mesh.

        Parameters
        ----------
        vertices : 2-d sequence of float
            Cordinates in :math:`\\Rset^{dim}` of the vertices,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> mesh.setVertices(vertices)
        """
        return _geom.Mesh_setVertices(self, *args)

    def getVertex(self, *args):
        """
        Get the vertex of a given index.

        Parameters
        ----------
        index : int
            Index characterizing one vertex of the mesh.

        Returns
        -------
        vertex : :class:`~openturns.NumericalPoint`
            Coordinates in :math:`\\Rset^{dim}` of the vertex of index *index*,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getVertex(1))
        [1,0]
        >>> print(mesh2d.getVertex(0))
        [0,0]
        """
        return _geom.Mesh_getVertex(self, *args)

    def setVertex(self, *args):
        """
        Set a vertex of a given index.

        Parameters
        ----------
        index : int
            Index of the vertex to set.
        vertex : sequence of float
            Cordinates in :math:`\\Rset^{dim}` of the vertex of index *index*,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh = ot.Mesh(vertices, simplices)
        >>> vertex = [0.0, 0.5]
        >>> mesh.setVertex(0, vertex)
        >>> print(mesh.getVertices())
        0 : [ 0   0.5 ]
        1 : [ 1   0   ]
        2 : [ 1   1   ]
        """
        return _geom.Mesh_setVertex(self, *args)

    def getSimplices(self):
        """
        Get the simplices of the mesh.

        Returns
        -------
        indicesCollection : collection of :class:`~openturns.Indices`
            List of indices defining all the simplices. The simplex
            :math:`[i_1, \\dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \\dots, i_{n+1})` in :math:`\\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getSimplices())
        [[0,1,2],[1,2,3]]
        """
        return _geom.Mesh_getSimplices(self)

    def setSimplices(self, *args):
        """
        Set the simplices of the mesh.

        Parameters
        ----------
        indices : 2-d sequence of int
            List of indices defining all the simplices. The simplex
            :math:`[i_1, \\dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \\dots, i_{n+1})` in :math:`\\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh.setSimplices(simplices)
        """
        return _geom.Mesh_setSimplices(self, *args)

    def getSimplex(self, *args):
        """
        Get the simplex of a given index.

        Parameters
        ----------
        index : int
            Index characterizing one simplex of the mesh.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices defining the simplex of index *index*. The simplex
            :math:`[i_1, \\dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \\dots, i_{n+1})` in :math:`\\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getSimplex(0))
        [0,1,2]
        >>> print(mesh2d.getSimplex(1))
        [1,2,3]
        """
        return _geom.Mesh_getSimplex(self, *args)

    def computeSimplexVolume(self, *args):
        """
        Compute the volume of a given simplex.

        Parameters
        ----------
        index : int
            Integer characterizes one simplex of the mesh.

        Returns
        -------
        volume : float
            Volume of the simplex of index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> print(mesh2d.computeSimplexVolume(0))
        0.5
        """
        return _geom.Mesh_computeSimplexVolume(self, *args)

    def computeP1Gram(self):
        """
        Compute the P1 Lagrange finite element gram matrix of the mesh.

        Returns
        -------
        gram : :class:`~openturns.CovarianceMatrix`
            P1 Lagrange finite element gram matrix of the mesh.

        Notes
        -----
        The P1 Lagrange finite element space associated to a mesh with vertices :math:`(\\vect{x}_i)_{i=1,\\hdots,n}` is the space of piecewise-linear functions generated by the functions :math:`(\\phi_i)_{i=1,\\hdots,n}`, where :math:`\\phi_i(\\vect{x_i})=1`, :math:`\\phi_i(\\vect{x_j})=0` for :math:`j\\neq i` and the restriction of :math:`\\phi_i` to any simplex is an affine function. The vertices that are not included into at least one simplex are not taken into account.

        The gram matrix of the mesh is defined as the symmetric positive definite matrix :math:`\\mat{K}` whose generic element :math:`K_{i,j}` is given by:

        .. math::

            \\forall i,j=1,\\hdots,n,\\quad K_{i,j}=\\int_{\\cD}\\phi_i(\\vect{x})\\phi_j(\\vect{x})\\di{\\vect{x}}

        This method is used in several algorithms related to stochastic process representation such as the Karhunen-Loeve decomposition.

        Examples
        --------
        >>> import openturns as ot
        >>> # Define the vertices of the mesh
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> # Define the simplices of the mesh
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> # Create the mesh of dimension 2
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.computeP1Gram())
        [[ 0.0416667 0.0208333 0.0208333 0         ]
         [ 0.0208333 0.0625    0.03125   0.0104167 ]
         [ 0.0208333 0.03125   0.0625    0.0104167 ]
         [ 0         0.0104167 0.0104167 0.0208333 ]]

        """
        return _geom.Mesh_computeP1Gram(self)

    def isRegular(self):
        """
        Check if the mesh is regular (only for 1-d meshes).

        Returns
        -------
        isRegular : bool
            Tells if the mesh is regular or not.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.5], [1.5], [2.4], [3.5]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        False
        >>> vertices = [[0.5], [1.5], [2.5], [3.5]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        True
        """
        return _geom.Mesh_isRegular(self)

    def getLowerBound(self):
        """
        Get the lower bound of the domain.

        Returns
        -------
        lower : :class:`~openturns.NumericalPoint`
            The lower bound of an axes-aligned bounding box of the domain.
        """
        return _geom.Mesh_getLowerBound(self)

    def getUpperBound(self):
        """
        Get the upper bound of the domain.

        Returns
        -------
        upper : :class:`~openturns.NumericalPoint`
            The upper bound of an axes-aligned bounding box of the domain.
        """
        return _geom.Mesh_getUpperBound(self)

    def draw(self):
        """
        Draw the mesh.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            If the dimension of the mesh is 1, it draws the corresponding interval,
            using the :meth:`draw1D` method; if the dimension is 2, it draws the
            triangular simplices, using the :meth:`draw2D` method; if the dimension is
            3, it projects the simplices on the plane of the two first components,
            using the :meth:`draw3D` method with its default parameters, superposing
            the simplices.
        """
        return _geom.Mesh_draw(self)

    def draw1D(self):
        """
        Draw the mesh of dimension 1.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the line linking the vertices of the mesh when the mesh is of
            dimension 1.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.5], [1.5], [2.1], [2.7]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh1d.draw1D()
        >>> # Draw the mesh
        >>> aGraph.draw('mesh1D')
        """
        return _geom.Mesh_draw1D(self)

    def draw2D(self):
        """
        Draw the mesh of dimension 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the edges of each simplex, when the mesh is of dimension 2.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh2d.draw2D()
        >>> # Draw the mesh
        >>> aGraph.draw('mesh2D')
        """
        return _geom.Mesh_draw2D(self)

    def draw3D(self, *args):
        """
        Draw the bidimensional projection of the mesh.

        Available usages:
            draw3D(*drawEdge=True, thetaX=0.0, thetaY=0.0, thetaZ=0.0, shading=False, rho=1.0*)

            draw3D(*drawEdge, rotation, shading, rho*)

        Parameters
        ----------
        drawEdge : bool
            Tells if the edge of each simplex has to be drawn.
        thetaX : float
            Gives the value of the rotation along the X axis in radian.
        thetaY : float
            Gives the value of the rotation along the Y axis in radian.
        thetaZ : float
            Gives the value of the rotation along the Z axis in radian.
        rotation : :class:`~openturns.SquareMatrix`
            Operates a rotation on the mesh before its projection of the plane of the
            two first components.
        shading  : bool
            Enables to give a visual perception of depth and orientation.
        rho : float, :math:`0 \\leq \\rho \\leq 1`
            Contraction factor of the simplices. If :math:`\\rho < 1`, all the
            simplices are contracted and appear deconnected: some holes are created,
            which enables to see inside the mesh. If :math:`\\rho = 1`, the simplices
            keep their initial size and appear connected. If :math:`\\rho = 0`, each
            simplex is reduced to its gravity center.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the bidimensional projection of the mesh on the :math:`(x,y)` plane.

        Examples
        --------
        >>> import openturns as ot
        >>> from math import cos, sin, pi
        >>> vertices = [[0.0, 0.0, 0.0], [0.0, 0.0, 1.0], [0.0, 1.0, 0.0],
        ...             [0.0, 1.0, 1.0], [1.0, 0.0, 0.0], [1.0, 0.0, 1.0],
        ...             [1.0, 1.0, 0.0], [1.0, 1.0, 1.0]]
        >>> simplices = [[0, 1, 2, 4], [3, 5, 6, 7],[1, 2, 3, 6],
        ...              [1, 2, 4, 6], [1, 3, 5, 6], [1, 4, 5, 6]]
        >>> mesh3d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh3d.draw3D()
        >>> # Draw the mesh
        >>> aGraph.draw('mesh3D_1')
        >>> rotation = ot.SquareMatrix(3)
        >>> rotation[0, 0] = cos(pi / 3.0)
        >>> rotation[0, 1] = sin(pi / 3.0)
        >>> rotation[1, 0] = -sin(pi / 3.0)
        >>> rotation[1, 1] = cos(pi / 3.0)
        >>> rotation[2, 2] = 1.0
        >>> # Create a graph
        >>> aGraph = mesh3d.draw3D(True, rotation, True, 1.0)
        >>> # Draw the mesh
        >>> aGraph.draw('mesh3D_2')
        """
        return _geom.Mesh_draw3D(self, *args)

    def __repr__(self): return _geom.Mesh___repr__(self)
    def __str__(self, offset=""): return _geom.Mesh___str__(self, offset)
    def ImportFromMSHFile(*args):
        """
        Import mesh from FreeFem 2-d mesh files.

        Parameters
        ----------
        MSHFile : str
            A MSH ASCII file.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh defined in the file *MSHFile*.
        """
        return _geom.Mesh_ImportFromMSHFile(*args)

    if _newclass:ImportFromMSHFile = staticmethod(ImportFromMSHFile)
    __swig_getmethods__["ImportFromMSHFile"] = lambda x: ImportFromMSHFile
    def streamToVTKFormat(self):
        """
        Give a VTK representation of the mesh.

        Returns
        -------
        stream : str
            VTK representation of the mesh.
        """
        return _geom.Mesh_streamToVTKFormat(self)

    def exportToVTKFile(self, *args):
        """
        Export the mesh to a VTK file.

        Parameters
        ----------
        myVTKFile.vtk : str
            Name of the created file which contains the mesh and the associated random
            values that can be visualized with the open source software
            `Paraview <http://www.paraview.org/>`_.
        """
        return _geom.Mesh_exportToVTKFile(self, *args)

    def __init__(self, *args): 
        this = _geom.new_Mesh(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _geom.delete_Mesh
    __del__ = lambda self : None;
Mesh_swigregister = _geom.Mesh_swigregister
Mesh_swigregister(Mesh)

def Mesh_ImportFromMSHFile(*args):
  """
    Import mesh from FreeFem 2-d mesh files.

    Parameters
    ----------
    MSHFile : str
        A MSH ASCII file.

    Returns
    -------
    mesh : :class:`~openturns.Mesh`
        Mesh defined in the file *MSHFile*.
    """
  return _geom.Mesh_ImportFromMSHFile(*args)

class RegularGrid(Mesh):
    """
    Regular Grid.

    Available constructors:
        RegularGrid(*start, step, n*)

        RegularGrid(*mesh*)

    Parameters
    ----------
    start : float
        The start time stamp of the grid.
    step : float, positive
        The step between to consecutive time stamps.
    n : int
        The number of time stamps in the grid, including the start and the end time stamps.
    mesh : :class:`~openturns.Mesh`
        The mesh must be in :math:`\\Rset`, regular and sorted in the increasing order.

    Notes
    -----
    The time stamps of the regular grid are: :math:`(t_0, \\dots, t_{n-1})` where :math:`t_{k} = t_0 + k \\Delta` for :math:`0 \\leq k \\leq n-1` and :math:`\\Delta >0` the step.

    See also
    --------
    Mesh

    Examples
    --------
    >>> import openturns as ot
    >>> myRegularGrid = ot.RegularGrid(0.0, 0.1, 100)
    """
    __swig_setmethods__ = {}
    for _s in [Mesh]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RegularGrid, name, value)
    __swig_getmethods__ = {}
    for _s in [Mesh]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RegularGrid, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.RegularGrid_getClassName(self)

    def __eq__(self, *args): return _geom.RegularGrid___eq__(self, *args)
    def __ne__(self, *args): return _geom.RegularGrid___ne__(self, *args)
    def getStart(self):
        """
        Accessor to the start time stamp.

        Returns
        -------
        start : float
            The start point :math:`t_0` of the grid.
        """
        return _geom.RegularGrid_getStart(self)

    def getEnd(self):
        """
        Accessor to the first time stamp after the last time stamp of the grid.

        Returns
        -------
        endPoint : float
            The first point that follows the last point of the grid: :math:`t_{n-1} + \\Delta`. The end point is not in the grid.
        """
        return _geom.RegularGrid_getEnd(self)

    def getStep(self):
        """
        Accessor to the step.

        Returns
        -------
        step : float
            The step :math:`\\Delta` between two consecutive time stamps.
        """
        return _geom.RegularGrid_getStep(self)

    def getN(self):
        """
        Accessor to the number of time stamps in the grid.

        Returns
        -------
        n : int
            The number :math:`n` of time stamps in the grid.
        """
        return _geom.RegularGrid_getN(self)

    def getValue(self, *args):
        """
        Accessor to the time stamps at a gien index.

        Parameters
        ----------
        k : int, :math:`0 \\leq k \\leq n-1`.
            Index of a time stamp. 

        Returns
        -------
        value : float
            The time stamp :math:`t_{k}`.
        """
        return _geom.RegularGrid_getValue(self, *args)

    def getValues(self):
        """
        Accessor to all the time stamps.

        Returns
        -------
        values : :class:`~openturns.NumericalPoint`
            The collection of the time stamps.
        """
        return _geom.RegularGrid_getValues(self)

    def follows(self, *args):
        """
        Check if the given grid follows the current one.

        Parameters
        ----------
        newGrid : :class:`~openturns.RegularGrid`
            A new regular grid.

        Returns
        -------
        answer : boolean
            The answer is *True* if the *newGrid* directly follows the current one.
        """
        return _geom.RegularGrid_follows(self, *args)

    def isRegular(self):
        """
        Check if the mesh is regular (only for 1-d meshes).

        Returns
        -------
        isRegular : bool
            Tells if the mesh is regular or not.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.5], [1.5], [2.4], [3.5]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        False
        >>> vertices = [[0.5], [1.5], [2.5], [3.5]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        True
        """
        return _geom.RegularGrid_isRegular(self)

    def getNearestVertexIndex(self, *args):
        """
        Get the index of the nearest vertex of a given point.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.

        Returns
        -------
        index : int
            Index of the simplex the nearest of *point* according to the Euclidean
            norm.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> point = [0.9, 0.4]
        >>> print(mesh2d.getNearestVertexIndex(point))
        1
        """
        return _geom.RegularGrid_getNearestVertexIndex(self, *args)

    def __repr__(self): return _geom.RegularGrid___repr__(self)
    def __str__(self, offset=""): return _geom.RegularGrid___str__(self, offset)
    def __init__(self, *args): 
        this = _geom.new_RegularGrid(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _geom.delete_RegularGrid
    __del__ = lambda self : None;
RegularGrid_swigregister = _geom.RegularGrid_swigregister
RegularGrid_swigregister(RegularGrid)

class IntervalMesher(openturns.common.PersistentObject):
    """
    Creation of mesh of box type.

    Available constructor:
        IntervalMesher(*discretization*)

    Parameters
    ----------
    discretization : sequence of int, of dimension :math:`\\leq 3`.
        Number of intervals in each direction of the box.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> mesher = ot.IntervalMesher([5, 10])
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> interval = ot.Interval(lowerbound, upperBound)
    >>> mesh = mesher.build(interval)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntervalMesher, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntervalMesher, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.IntervalMesher_getClassName(self)

    def setDiscretization(self, *args):
        """
        Accessor to the discretization.

        Parameters
        ----------
        discretization : sequence of int
            Number of intervals in each direction of the box.
        """
        return _geom.IntervalMesher_setDiscretization(self, *args)

    def getDiscretization(self):
        """
        Accessor to the discretization.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            Number of intervals in each direction of the box.
        """
        return _geom.IntervalMesher_getDiscretization(self)

    def __repr__(self): return _geom.IntervalMesher___repr__(self)
    def __str__(self, offset=""): return _geom.IntervalMesher___str__(self, offset)
    def build(self, *args):
        """
        Build the mesh of box type.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            The interval to mesh, of dimension equal to the dimension
            of `discretization`.
        diamond : bool
            A flag telling if one want the usual mesh (rectangular cells cut along a
            diagonal in dimension 2) or a diamond like mesh (rectangular cells cut
            into 4 triangles with the center of the cell as shared vertex).
            Default is *IntervalMesher-UseDiamond*, see :class:`~openturns.ResourceMap`.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh built.
        """
        return _geom.IntervalMesher_build(self, *args)

    def __init__(self, *args): 
        this = _geom.new_IntervalMesher(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _geom.delete_IntervalMesher
    __del__ = lambda self : None;
IntervalMesher_swigregister = _geom.IntervalMesher_swigregister
IntervalMesher_swigregister(IntervalMesher)

# This file is compatible with both classic and new-style classes.


