# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Probabilistic distributions.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_dist_bundle2', [dirname(__file__)])
        except ImportError:
            import _dist_bundle2
            return _dist_bundle2
        if fp is not None:
            try:
                _mod = imp.load_module('_dist_bundle2', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _dist_bundle2 = swig_import_helper()
    del swig_import_helper
else:
    import _dist_bundle2
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle2.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _dist_bundle2.SwigPyIterator_value(self)
    def incr(self, n=1): return _dist_bundle2.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _dist_bundle2.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _dist_bundle2.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _dist_bundle2.SwigPyIterator_equal(self, *args)
    def copy(self): return _dist_bundle2.SwigPyIterator_copy(self)
    def next(self): return _dist_bundle2.SwigPyIterator_next(self)
    def __next__(self): return _dist_bundle2.SwigPyIterator___next__(self)
    def previous(self): return _dist_bundle2.SwigPyIterator_previous(self)
    def advance(self, *args): return _dist_bundle2.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _dist_bundle2.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _dist_bundle2.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _dist_bundle2.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _dist_bundle2.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _dist_bundle2.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _dist_bundle2.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _dist_bundle2.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _dist_bundle2.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
class HistogramPair(openturns.common.PersistentObject):
    """
    Histogram Pair.

    Available constructor:
        HistogramPair(*h, l*)

    Parameters
    ----------
    h : positive float
        Height of the element of the histogram distribution.
    l : positive float
        Width of the element of the histogram distribution.

    See also
    --------
    Histogram

    Notes
    -----
    The object is used to build an HistogramPairCollection and then a Histogram
    distribution.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistogramPair, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistogramPair, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.HistogramPair_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.HistogramPair___eq__(self, *args)
    def setWidth(self, *args): return _dist_bundle2.HistogramPair_setWidth(self, *args)
    def setHeight(self, *args): return _dist_bundle2.HistogramPair_setHeight(self, *args)
    def getWidth(self): return _dist_bundle2.HistogramPair_getWidth(self)
    def getHeight(self): return _dist_bundle2.HistogramPair_getHeight(self)
    def getSurface(self): return _dist_bundle2.HistogramPair_getSurface(self)
    def __repr__(self): return _dist_bundle2.HistogramPair___repr__(self)
    def __init__(self, *args): 
        this = _dist_bundle2.new_HistogramPair(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_HistogramPair
    __del__ = lambda self : None;
HistogramPair_swigregister = _dist_bundle2.HistogramPair_swigregister
HistogramPair_swigregister(HistogramPair)

class Histogram(openturns.model_copula.ContinuousDistribution):
    """
    Histogram distribution.

    Available constructors:
        Histogram(*first, l, h*)

    Parameters
    ----------
    first : float
        Lower bound.
    width : positive sequence of float
        :math:`\\ell_i` is the width of the class :math:`i`.
    height : positive sequence of float
        :math:`h_i` is the frequency of the class :math:`i`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\sum_{i=1}^{n}H_i\\;\\boldsymbol{1}_{[x_i,x_{i+1}]}(x)

    where :math:`H_i=h_i/S` is the relative frequency,
    with :math:`S=\\sum_{i=1}^n h_i\\,\\ell_i` the total frequency of data.
    :math:`\\ell_i = x_{i+1} - x_i , 1\\leq i \\leq n` and :math:`n` is the size of the
    width collection :math:`\\ell`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{1}{2 \\sum_{i=1}^n h_i\\,\\ell_i}
                             \\sum_{i=1}^n h_i\\,\\ell_i (x_{i+1} + x_i)\\\\
            \\Var{X} & = & \\frac{1}{3 \\sum_{i=1}^n h_i\\,\\ell_i}
                          \\sum_{i=1}^n h_i\\,\\ell_i (x_{i+1}^2 + x_i\\,x_{i+1} + x_i^2)
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> l = [1.0, 0.7, 1.2, 0.9]
    >>> h = [0.5, 1.5, 3.5, 2.5]
    >>> distribution = ot.Histogram(-1.5, l, h)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Histogram, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Histogram, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Histogram_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.Histogram___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.Histogram___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Histogram___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Histogram_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Histogram_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Histogram_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Histogram_computeCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Histogram_computeCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Histogram_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Histogram_computeCDFGradient(self, *args)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.Histogram_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Histogram_getStandardRepresentative(self)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.Histogram_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Histogram_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Histogram_getParameterDescription(self)

    def setFirst(self, *args):
        """
        Accessor to the lower bound.

        Parameters
        ----------
        first : float
            Lower bound.
        """
        return _dist_bundle2.Histogram_setFirst(self, *args)

    def getFirst(self):
        """
        Accessor to the distribution's lower bound.

        Returns
        -------
        first : float
            Lower bound.
        """
        return _dist_bundle2.Histogram_getFirst(self)

    def setData(self, *args):
        """
        Accessor to the widths and heights.

        Parameters
        ----------
        width : :class:`~openturns.NumericalPoint`
            The collection of :math:`\\ell_i`, the width of class `i`.
        height : :class:`~openturns.NumericalPoint`
            The collection of :math:`h_i`, the height of class `i`.
        """
        return _dist_bundle2.Histogram_setData(self, *args)

    def getWidth(self):
        """
        Accessor to the width.

        Returns
        -------
        width : :class:`~openturns.NumericalPoint`
            The collection of :math:`\\ell_i`, the width of class `i`.
        """
        return _dist_bundle2.Histogram_getWidth(self)

    def getHeight(self):
        """
        Accessor to the height.

        Returns
        -------
        height : :class:`~openturns.NumericalPoint`
            The collection of :math:`h_i`, the height of class `i`.
        """
        return _dist_bundle2.Histogram_getHeight(self)

    def setPairCollection(self, *args): return _dist_bundle2.Histogram_setPairCollection(self, *args)
    def getPairCollection(self): return _dist_bundle2.Histogram_getPairCollection(self)
    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.NumericalPoint`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Histogram_getSingularities(self)

    def drawPDF(self, *args):
        """
        Draw the graph or of iso-lines of probability density function.

        Available constructors:
            drawPDF(*x_min, x_max, pointNumber*)

            drawPDF(*lowerCorner, upperCorner, pointNbrInd*)

            drawPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        x_min : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        computePDF, viewer.View, ResourceMap

        Examples
        --------
        View the PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawPDF()
        >>> graph.setLegends(['normal pdf'])

        View the iso-lines PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawPDF([-10, -5],[5, 10], [511, 511])

        """
        return _dist_bundle2.Histogram_drawPDF(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_Histogram(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Histogram
    __del__ = lambda self : None;
Histogram_swigregister = _dist_bundle2.Histogram_swigregister
Histogram_swigregister(Histogram)

class HistogramPairCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistogramPairCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HistogramPairCollection, name)
    __swig_destroy__ = _dist_bundle2.delete_HistogramPairCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _dist_bundle2.HistogramPairCollection_clear(self)

    def __len__(self): return _dist_bundle2.HistogramPairCollection___len__(self)
    def __eq__(self, *args): return _dist_bundle2.HistogramPairCollection___eq__(self, *args)
    def __contains__(self, *args): return _dist_bundle2.HistogramPairCollection___contains__(self, *args)
    def __getitem__(self, *args): return _dist_bundle2.HistogramPairCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _dist_bundle2.HistogramPairCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _dist_bundle2.HistogramPairCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _dist_bundle2.HistogramPairCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _dist_bundle2.HistogramPairCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _dist_bundle2.HistogramPairCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _dist_bundle2.HistogramPairCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _dist_bundle2.HistogramPairCollection_isEmpty(self)

    def __repr__(self): return _dist_bundle2.HistogramPairCollection___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.HistogramPairCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _dist_bundle2.new_HistogramPairCollection(*args)
        try: self.this.append(this)
        except: self.this = this
HistogramPairCollection_swigregister = _dist_bundle2.HistogramPairCollection_swigregister
HistogramPairCollection_swigregister(HistogramPairCollection)

class HistogramFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Histogram factory.

    Available constructor:
        HistogramFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistogramFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistogramFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.HistogramFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.HistogramFactory_build(self, *args)

    def buildAsHistogram(self, *args): return _dist_bundle2.HistogramFactory_buildAsHistogram(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_HistogramFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_HistogramFactory
    __del__ = lambda self : None;
HistogramFactory_swigregister = _dist_bundle2.HistogramFactory_swigregister
HistogramFactory_swigregister(HistogramFactory)

class BayesDistribution(openturns.model_copula.ContinuousDistribution):
    """
    Bayes distribution.

    Helper class for defining the distribution of the random vector :math:`(\\vect{X},\\vect{Y})` where :math:`\\vect{Y}` follows the distribution :math:`\\mathcal{L}_{\\vect{Y}}` and :math:`\\vect{X}|\\vect{\\Theta}` follows the distribution :math:`\\mathcal{L}_{\\vect{X}|\\vect{\\Theta}}`  where :math:`\\vect{\\Theta}=g(\\vect{Y})` with :math:`g` a given function of input dimension the dimension of :math:`\\mathcal{L}_{\\vect{Y}}` and output dimension the dimension of :math:`\\vect{\\Theta}`.

    Available constructors:
       BayesDistribution(*conditionedDist, conditioningDist, linkFunction*)

       BayesDistribution(*conditionedDist, conditioningDist*)

       BayesDistribution()

    Parameters
    ----------

    conditionedDist : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.
        In the `BayesDistribution()` constructor, `conditionedDist` is taken equal to :math:`\\vect{X} | \\vect{\\Theta} \\sim` :class:`~openturns.Uniform` :math:`(\\vect{\\Theta})`.

    conditioningDist : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.
        In the `BayesDistribution()` constructor,  `conditioningDist` is taken equal to :math:`\\vect{Y} \\sim Uniform(-1,1)`.

    linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.
        In the `BayesDistribution()` constructor, `linkFunction`  is taken equal to :math:`g: \\Rset \\rightarrow \\Rset^2`, :math:`g(y)=(y,y+1)`.
        In the `BayesDistribution(conditionedDist, conditioningDist)` constructor, we need :math:`p=q` and `linkFunction`  is taken equal to  :math:`g(\\vect{y})=\\vect{y}`.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{(\\vect{X}, \\vect{Y})}(\\vect{x}, \\vect{y}) = f_{\\vect{X}|\\vect{\\Theta}=g(\\vect{y})}(\\vect{x}|g(\\vect{y})) f_{\\vect{Y}}( \\vect{y})

    with  :math:`f_{\\vect{X}|\\vect{\\Theta}=g(\\vect{y})}` the PDF of the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, where :math:`\\vect{\\Theta}` has been replaced by :math:`g(\\vect{y})`, :math:`f_{\\vect{Y}}` the PDF of :math:`\\vect{Y}` and :math:`g` the linking function.

    With the default constructor, the resulting random vector :math:`(X,Y)` is uniformly distributed on the parallelogram which vertices are :math:`(-1,-1); (0,-1); (2,1); (1,1)`.


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> conditioningDist = ot.Normal(0.0, 1.0)
    >>> g = ot.NumericalMathFunction(['y'], ['y', '0.1+y^2'])
    >>> conditionedDist = ot.Normal()
    >>> finalDist = ot.ConditionalDistribution(conditionedDist, conditioningDist, g)

    Draw a sample:

    >>> sample = finalDist.getSample(5)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BayesDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BayesDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.BayesDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.BayesDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.BayesDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.BayesDistribution___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.BayesDistribution_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.BayesDistribution_computePDF(self, *args)

    def setConditionedDistribution(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Parameters
        ----------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.

        """
        return _dist_bundle2.BayesDistribution_setConditionedDistribution(self, *args)

    def getConditionedDistribution(self):
        """
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.

        """
        return _dist_bundle2.BayesDistribution_getConditionedDistribution(self)

    def setConditioningDistribution(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Parameters
        ----------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.BayesDistribution_setConditioningDistribution(self, *args)

    def getConditioningDistribution(self):
        """
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Returns
        -------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.BayesDistribution_getConditioningDistribution(self)

    def setLinkFunction(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Parameters
        ----------
        linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.

        """
        return _dist_bundle2.BayesDistribution_setLinkFunction(self, *args)

    def getLinkFunction(self):
        """
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Returns
        -------
        linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.

        """
        return _dist_bundle2.BayesDistribution_getLinkFunction(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.BayesDistribution_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_BayesDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_BayesDistribution
    __del__ = lambda self : None;
BayesDistribution_swigregister = _dist_bundle2.BayesDistribution_swigregister
BayesDistribution_swigregister(BayesDistribution)

class InverseChiSquare(openturns.model_copula.ContinuousDistribution):
    """
    InverseChiSquare distribution.

    Helper class for defining the Inverse ChiSquare distribution which is the inverse of a :math:`\\chi^2` distribution.

    Available constructors:
        InverseChiSquare(*nu*)

    Parameters
    ----------
    nu : float, :math:`\\nu > 0`
        Degrees of freedom.  
        By default, :math:`\\nu =1`.
         

    Notes
    -----
    :math:`X` follows an Inverse ChiSquare distribution of parameter :math:`\\nu` means that :math:`\\dfrac{1}{X}` follows the :math:`\\chi^2(\\nu)` distribution, with :math:`\\nu>0`.
    The Inverse ChiSquare distribution parametered by :math:`\\nu` is exactly the :math:`InverseGamma(\\dfrac{\\nu}{2}, 2)` distribution.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \\dfrac{\\exp \\left( -\\dfrac{1}{2 x}\\right)}{\\Gamma \\left(\\dfrac{\\nu}{2}\\right)\\lambda^{\\frac{\\nu}{2}}x^{\\frac{\\nu}{2}+1}}, \\quad x \\in [0; +\\infty[

    with :math:`\\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\dfrac{1}{\\nu-2}  \\quad \\text{if } \\nu>2\\\\
            \\Var{X} & = &\\dfrac{2}{(\\nu-2)^2(\\nu-4)}\\quad \\text{if } \\nu>4
        \\end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseChiSquare(1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseChiSquare, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseChiSquare, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseChiSquare_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.InverseChiSquare___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.InverseChiSquare___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.InverseChiSquare___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.InverseChiSquare_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.InverseChiSquare_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.InverseChiSquare_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseChiSquare_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseChiSquare_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.InverseChiSquare_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.InverseChiSquare_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseChiSquare_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseChiSquare_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseChiSquare_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.InverseChiSquare_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.InverseChiSquare_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseChiSquare_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.InverseChiSquare_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseChiSquare_getParameterDescription(self)

    def setNu(self, *args):
        """
        Accessor to the distribution parameter :math:`\\nu`.

        Parameters
        ----------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseChiSquare_setNu(self, *args)

    def getNu(self):
        """
        Accessor to the  parameter :math:`nu`.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseChiSquare_getNu(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_InverseChiSquare(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_InverseChiSquare
    __del__ = lambda self : None;
InverseChiSquare_swigregister = _dist_bundle2.InverseChiSquare_swigregister
InverseChiSquare_swigregister(InverseChiSquare)

class InverseGamma(openturns.model_copula.ContinuousDistribution):
    """
    InverseGamma distribution.

    Helper class for defining the Inverse Gamma distribution which is the inverse of a :math:`\\Gamma` distribution.

    Available constructors:
        InverseGamma(*k, lambda*)

    Parameters
    ----------
    k : float, :math:`k > 0`,
        Shape parameter. By default, :math:`k=1`.

    lambda : float, :math:`\\lambda > 0`.
        Scale parameter. By default, :math:`\\lambda=1`.
         

    Notes
    -----
    :math:`X` follows an Inverse Gamma distribution of parameters :math:`(k, \\lambda)` means that :math:`\\dfrac{1}{X}` follows the :math:`\\Gamma(k, \\dfrac{1}{\\lambda})` distribution, with :math:`k>0` and :math:`\\lambda>0`.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \\dfrac{\\exp \\left( -\\dfrac{1}{\\lambda x}\\right)}{\\Gamma(k)\\lambda^kx^{k+1}}, \\quad x \\in [0; +\\infty[

    with :math:`k >0 , \\lambda > 0`.


    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\dfrac{1}{\\lambda(k-1)} \\quad \\text{if } k>1 \\\\
            \\Var{X} & = &\\dfrac{1}{\\lambda^2(k-1)^2(k-2)} \\quad \\text{if } k>2 
        \\end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseGamma(1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseGamma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseGamma, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseGamma_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.InverseGamma___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.InverseGamma___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.InverseGamma___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.InverseGamma_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.InverseGamma_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.InverseGamma_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseGamma_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseGamma_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.InverseGamma_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.InverseGamma_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseGamma_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseGamma_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseGamma_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.InverseGamma_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.InverseGamma_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseGamma_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.InverseGamma_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseGamma_getParameterDescription(self)

    def setK(self, *args):
        """
        Accessor to the distribution's shape parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
            Parameter :math:`k`.
        """
        return _dist_bundle2.InverseGamma_setK(self, *args)

    def getK(self):
        """
        Accessor to the  parameter :math:`k`.

        Returns
        -------
        k : float
            Shape parameter :math:`k`.
        """
        return _dist_bundle2.InverseGamma_getK(self)

    def setLambda(self, *args):
        """
        Accessor to the distribution's scale parameter :math:`\\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\\lambda > 0`
            Parameter :math:`\\lambda`.
        """
        return _dist_bundle2.InverseGamma_setLambda(self, *args)

    def getLambda(self):
        """
        Accessor to the parameter :math:`\\lambda`.

        Returns
        -------
        lambda : float
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle2.InverseGamma_getLambda(self)

    def setKLambda(self, *args): return _dist_bundle2.InverseGamma_setKLambda(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_InverseGamma(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_InverseGamma
    __del__ = lambda self : None;
InverseGamma_swigregister = _dist_bundle2.InverseGamma_swigregister
InverseGamma_swigregister(InverseGamma)

class InverseNormal(openturns.model_copula.ContinuousDistribution):
    """
    Inverse normal distribution.

    Available constructors:
        InverseNormal(*lambda=1.0, mu=1.0*)

    Parameters
    ----------
    lambda : float, :math:`\\lambda > 0`
        Scale parameter :math:`\\lambda`.
    mu : float, :math:`\\mu > 0`
        Location (mean) parameter :math:`\\mu`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\sqrt{\\frac{\\lambda}{2 \\pi x^3}}
                 \\exp\\left(\\frac{- \\lambda (x - \\mu)^2}{2 \\mu^2 x}\\right),
                 \\quad x \\in [0; +\\infty[

    with :math:`\\lambda, \\mu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\mu \\\\
            \\Var{X} & = & \\frac{\\mu^3}{\\lambda}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseNormal(1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseNormal, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseNormal, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseNormal_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.InverseNormal___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.InverseNormal___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.InverseNormal___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.InverseNormal_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseNormal_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.InverseNormal_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseNormal_computeCDF(self, *args)

    def computeMinimumVolumeLevelSetWithThreshold(self, *args):
        """
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\\alpha`.
        level : float
            The value :math:`p_{\\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle2.InverseNormal_computeMinimumVolumeLevelSetWithThreshold(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseNormal_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseNormal_computeLogCharacteristicFunction(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseNormal_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseNormal_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.InverseNormal_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.InverseNormal_getStandardMoment(self, *args)

    def setLambdaMu(self, *args):
        """
        Accessor to the distribution's parameters.

        Parameters
        ----------
        lambda : float, :math:`\\lambda > 0`
            Scale parameter :math:`\\lambda`.
        mu : float, :math:`\\mu > 0`
            Location (mean) parameter :math:`\\mu`.
        """
        return _dist_bundle2.InverseNormal_setLambdaMu(self, *args)

    def getLambda(self):
        """
        Accessor to the distribution's scale parameter.

        Returns
        -------
        lambda : float
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle2.InverseNormal_getLambda(self)

    def getMu(self):
        """
        Accessor to the distribution's location (mean) parameter.

        Returns
        -------
        mu : float
            Location (mean) parameter :math:`\\mu`.
        """
        return _dist_bundle2.InverseNormal_getMu(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseNormal_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.InverseNormal_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseNormal_getParameterDescription(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_InverseNormal(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_InverseNormal
    __del__ = lambda self : None;
InverseNormal_swigregister = _dist_bundle2.InverseNormal_swigregister
InverseNormal_swigregister(InverseNormal)

class InverseNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Inverse Normal factory.

    Available constructor:
        InverseNormalFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseNormalFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseNormalFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseNormalFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.InverseNormalFactory_build(self, *args)

    def buildAsInverseNormal(self, *args): return _dist_bundle2.InverseNormalFactory_buildAsInverseNormal(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_InverseNormalFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_InverseNormalFactory
    __del__ = lambda self : None;
InverseNormalFactory_swigregister = _dist_bundle2.InverseNormalFactory_swigregister
InverseNormalFactory_swigregister(InverseNormalFactory)

class InverseWishart(openturns.model_copula.ContinuousDistribution):
    """
    Inverse-Wishart distribution.

    Parameters
    ----------
    v : 2-d sequence of float
        Scale matrix, positive definite of size :math:`p`.
    nu : float, :math:`\\nu > p - 1`
        Degrees of freedom.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseWishart(ot.CovarianceMatrix([[1.0]]), 3.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseWishart, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseWishart, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseWishart_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.InverseWishart___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.InverseWishart___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.InverseWishart___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.InverseWishart_getRealization(self)

    def getRealizationAsMatrix(self):
        """
        Get one realization of the distribution as a covariance matrix.

        Returns
        -------
        v : :class:`~openturns.CovarianceMatrix`
            A realization as a matrix
        """
        return _dist_bundle2.InverseWishart_getRealizationAsMatrix(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseWishart_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.InverseWishart_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.InverseWishart_computeCDF(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseWishart_getStandardDeviation(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseWishart_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.InverseWishart_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseWishart_getParameterDescription(self)

    def setV(self, *args):
        """
        Accessor to the scale parameter.

        Parameters
        ----------
        v : 2-d sequence of float
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle2.InverseWishart_setV(self, *args)

    def getV(self):
        """
        Accessor to the scale parameter.

        Returns
        -------
        v : :class:`~openturns.CovarianceMatrix`
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle2.InverseWishart_getV(self)

    def setNu(self, *args):
        """
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle2.InverseWishart_setNu(self, *args)

    def getNu(self):
        """
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseWishart_getNu(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_InverseWishart(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_InverseWishart
    __del__ = lambda self : None;
InverseWishart_swigregister = _dist_bundle2.InverseWishart_swigregister
InverseWishart_swigregister(InverseWishart)

class KPermutationsDistribution(openturns.model_copula.DiscreteDistribution):
    """
    KPermutations distribution.

    Available constructors:
        KPermutationsDistribution(*k=1, n=1*)

    Parameters
    ----------
    k : int, :math:`k > 0`
    n : int, :math:`n > 0`

    Notes
    -----
    :class:`~openturns.KPermutationsDistribution` is the discrete uniform
    distribution on the set of injective functions :math:`(i_0, \\hdots, i_{k_1})`
    from :math:`\\{0, \\hdots, k-1\\}` into :math:`\\{0, \\hdots, n-1\\}`.
    Its probability density function is defined as:

    .. math::

        \\Prob{\\vect{X} = (i_0, \\hdots, i_{k-1})} = \\frac{(n-k)!}{n!}

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{\\vect{X}} & = & \\frac{n - 1}{2}\\\\
            \\Cov{\\vect{X}} & = & \\left\\{
                                 \\begin{array}{ll}
                                     \\displaystyle \\frac{n^2-1}{12} \\\\
                                     \\displaystyle -\\frac{1 + n}{12}
                                 \\end{array}
                                 \\right.
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.KPermutationsDistribution(6, 8)

    Draw a sample:

    >>> sample = distribution.getSample(10)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KPermutationsDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KPermutationsDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KPermutationsDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.KPermutationsDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.KPermutationsDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.KPermutationsDistribution___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.KPermutationsDistribution_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.KPermutationsDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.KPermutationsDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.KPermutationsDistribution_computeCDF(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.KPermutationsDistribution_getMarginal(self, *args)

    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.KPermutationsDistribution_getSupport(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.KPermutationsDistribution_getParametersCollection(self)

    def setK(self, *args):
        """
        Accessor to the parameter :math:`k`.

        Parameters
        ----------
        k : int, :math:`k > 0`
        """
        return _dist_bundle2.KPermutationsDistribution_setK(self, *args)

    def getK(self):
        """
        Accessor to the parameter :math:`k`.

        Returns
        -------
        k : int
        """
        return _dist_bundle2.KPermutationsDistribution_getK(self)

    def setN(self, *args):
        """
        Accessor to the parameter :math:`n`.

        Parameters
        ----------
        n : int, :math:`n > 0`
        """
        return _dist_bundle2.KPermutationsDistribution_setN(self, *args)

    def getN(self):
        """
        Accessor to the parameter :math:`n`.

        Returns
        -------
        n : int
        """
        return _dist_bundle2.KPermutationsDistribution_getN(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_KPermutationsDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_KPermutationsDistribution
    __del__ = lambda self : None;
KPermutationsDistribution_swigregister = _dist_bundle2.KPermutationsDistribution_swigregister
KPermutationsDistribution_swigregister(KPermutationsDistribution)

class KernelMixture(openturns.model_copula.ContinuousDistribution):
    """
    Build a particular linear combination of probability density functions.

    Parameters
    ----------
    kernel : :class:`~openturns.Distribution`
        Univariate distribution of the kernel that will be used, :math:`K`.
    bandwidth : sequence of float
        Contains the bandwith in each direction, :math:`(h_1, \\dots, h_d)`.
    sample : 2-d sequence of float
        The data on wich each kernel is centered,
        :math:`(\\vect{X}_1, \\dots, \\vect{X}_N) \\in \\Rset^d`.
    Notes
    -----
    A *KernelMixture* is a particular *Mixture*: all the weights are identical and
    the all the probability density functions of the combination are of the same
    family. They are centered on :math:`N` points. The treatment is optimized.

    The pdf of a *KernelMixture* is defined by:
    ..math::
        f(\\vect{x}) =  \\sum_{i=1}^N \\dfrac{1}{N} \\Pi_{j=1}^d \\dfrac{1}{h_j}K(\\frac{x^j-X^j_i}{h})

    where :math:`N` is the number of points in the sample
    :math:`(\\vect{X}_1, \\dots, \\vect{X}_N) \\in \\Rset^d` and :math:`K` a univariate
    distribution.

    Examples
    --------
    Create a *KernelMixture*:

    >>> import openturns as ot
    >>> kernel = ot.Uniform()
    >>> sample = ot.Normal().getSample(5)
    >>> bandwith = [1.0]
    >>> myKernelMixture = ot.KernelMixture(kernel, bandwith, sample)
     
    See the pdf:
    >>> graph = myKernelMixture.drawPDF(64)
    >>> graph.setLegends(['KernelMixture'])
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KernelMixture, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KernelMixture, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KernelMixture_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.KernelMixture___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.KernelMixture___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.KernelMixture___str__(self, offset)
    def setKernel(self, *args):
        """
        Set the kernel used in the linear combination.

        Parameters
        ----------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.
        """
        return _dist_bundle2.KernelMixture_setKernel(self, *args)

    def getKernel(self):
        """
        Accessor to kernel used in the linear combination.

        Returns
        -------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.
        """
        return _dist_bundle2.KernelMixture_getKernel(self)

    def setBandwidth(self, *args):
        """
        Set the bandwith used in the linear combination.

        Parameters
        ----------
        bandwidth : sequence of float
            Bandwith used in each direction.
        """
        return _dist_bundle2.KernelMixture_setBandwidth(self, *args)

    def getBandwidth(self):
        """
        Accessor to the bandwith used in the linear combination.

        Returns
        -------
        bandwidth : :class:`~openturns.NumericalPoint`
            Bandwith used in each direction.
        """
        return _dist_bundle2.KernelMixture_getBandwidth(self)

    def setInternalSample(self, *args):
        """
        Set the sample used in the linear combination.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample on wich the kernels are centered.
        """
        return _dist_bundle2.KernelMixture_setInternalSample(self, *args)

    def getInternalSample(self): return _dist_bundle2.KernelMixture_getInternalSample(self)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.KernelMixture_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.KernelMixture_computeComplementaryCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        """
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.NumericalPoint`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\\vect{X}` is defined as follows:

        .. math::

         
            S_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^d X_i > x_i}
                     \\quad \\forall \\vect{x} \\in \\Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.KernelMixture_computeSurvivalFunction(self, *args)

    def computeProbability(self, *args):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.KernelMixture_computeProbability(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.KernelMixture_computeCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.KernelMixture_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.KernelMixture_computeCDFGradient(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.KernelMixture_getMarginal(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.KernelMixture_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.KernelMixture_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.KernelMixture_getKurtosis(self)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.KernelMixture_getParametersCollection(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.KernelMixture_isElliptical(self)

    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.KernelMixture_isContinuous(self)

    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.KernelMixture_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.KernelMixture_hasIndependentCopula(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_KernelMixture(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_KernelMixture
    __del__ = lambda self : None;
KernelMixture_swigregister = _dist_bundle2.KernelMixture_swigregister
KernelMixture_swigregister(KernelMixture)

class KernelSmoothing(openturns.model_copula.DistributionFactoryImplementation):
    """
    Non parametric fitting technique with kernel smoothing.

    Parameters
    ----------
    kernel : :class:`~openturns.Distribution`, optional
        Univariate distribution of the kernel that will be used. By default, the standard Normal distribution is used. 
    bined : bool, optional
        Activates bining mecanism only in the univariate or bivariate cases. It allows to speed up the manipulation of the density function of the resulting distribution.  By default, the mecanism is activated.
    binNumber : int, :math:`binNumber \\geq 2`, optional
        Indicates the number of bins used by the bining mecanism. By default, OpenTURNS uses the values stored in the *ResourceMap*.
    boundaryCorrection : bool, optional
        Activates the boundary correction using the mirroring technique.
        By default, the correction is not provided.

    Notes
    -----
    The bining mecanism creates a regular grid of *binNumber* intervals: all the data falling in the same interval are regrouped and replaced by the central point of the interval, weighted by the number of data within the interval.

    When applied to multivariate samples, the kernel is the kernel product of the univariate distribution specified in the constructor. 

    Examples
    --------
    Fit a distribution on data thanks to the kernel smoothing technique:

    >>> import openturns as ot
    >>> sample = ot.Gamma(6.0, 1.0).getSample(100)
    >>> kernel = ot.KernelSmoothing()
    >>> fittedDist = kernel.build(sample)

    Compare the PDFs:

    >>> graph = fittedDist.drawPDF()
    >>> graph.add( ot.Gamma(6.0, 1.0).drawPDF())
    >>> graph.setColors(['blue', 'red'])
    >>> graph.setLegends(['KS dist', 'Gamma'])

    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KernelSmoothing, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KernelSmoothing, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KernelSmoothing_getClassName(self)

    def build(self, *args):
        """
        Fit a kernel smoothing distribution on data.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data on which the distribution is fitted. Any dimension.
        bandwidth : :class:`~openturns.NumericalPoint`, optional
            Contains the bandwith in each direction. If not specified, the bandwith is calculated using the mixed rule from data.

        Returns
        -------
        fittdDist : :class:`~openturns.Distribution`
            The fitted distribution.

        Notes
        -----
        According to the dimension of the data and the specified treatments, the type of the resulting distribution differs:

        - In dimension 1: 

            - if only the bining mecanism is activated, a :class:`~openturns.Mixture` is produced (all the weights differ).
            - if only the boundary correction is activated, a :class:`~openturns.TruncatedDistribution` is produced: the truncation of a :class:`~openturns.KernelMixture`  (all the weights are identical). 
            - if the bining mecanism and the boundary correction is activated, a :class:`~openturns.TruncatedDistribution` is produced: the truncation of a :class:`~openturns.Mixture` (all the weights differ).


        Examples
        --------
        See the effect of the boundary correction:

        >>> import openturns as ot
        >>> sample = ot.Exponential(1.0).getSample(1000)
        >>> smoother = ot.KernelSmoothing()
        >>> fittedDistNoCorr = smoother.build(sample)
        >>> smoother.setBoundaryCorrection(True)
        >>> fittedDistWithCorr = smoother.build(sample)

        Compare the PDFs:

        >>> graph = ot.Exponential(1.0).drawPDF()
        >>> graph.add(fittedDistNoCorr.drawPDF())
        >>> graph.add(fittedDistWithCorr.drawPDF())
        >>> graph.setColors(['black', 'blue', 'red'])
        >>> graph.setLegends(['Exp dist', 'No boundary corr', 'Boundary corr'])

        """
        return _dist_bundle2.KernelSmoothing_build(self, *args)

    def getBandwidth(self):
        """
        Accessor to the bandwith used in the kernel smoothing.

        Returns
        -------
        bandwidth : :class:`~openturns.NumericalPoint`
            Bandwith used in each direction. 

        """
        return _dist_bundle2.KernelSmoothing_getBandwidth(self)

    def getKernel(self):
        """
        Accessor to kernel used in the kernel smoothing.

        Returns
        -------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.

        """
        return _dist_bundle2.KernelSmoothing_getKernel(self)

    def setBoundaryCorrection(self, *args):
        """
        Accessor to the boundary correction flag.

        Parameters
        ----------
        boundaryCorrection : bool
            Activates the boundary correction using the mirroring technique.
        """
        return _dist_bundle2.KernelSmoothing_setBoundaryCorrection(self, *args)

    def computeSilvermanBandwidth(self, *args):
        """
        Compute the bandwith according to the Silverman rule.

        Returns
        -------
        bandwidth : :class:`~openturns.NumericalPoint`
            Bandwith wich components are evaluated according to the Silverman rule supposing a normal distribution. The bandwith is based on the evaluation of the interquartiles rather than the standard deviation of the distribution and the sample.

        """
        return _dist_bundle2.KernelSmoothing_computeSilvermanBandwidth(self, *args)

    def computePluginBandwidth(self, *args):
        """
        Compute the bandwith according to the plugin rule.

        Returns
        -------
        bandwidth : :class:`~openturns.NumericalPoint`
            Bandwith wich components are evaluated according to the plugin rule. 

        Notes
        -----
        Warning! It can take a lot of time for large samples, as the cost is  quadratic with the sample size.

        """
        return _dist_bundle2.KernelSmoothing_computePluginBandwidth(self, *args)

    def computeMixedBandwidth(self, *args):
        """
        Compute the bandwith according to a mixed rule.

        Returns
        -------
        bandwidth : :class:`~openturns.NumericalPoint`
            Bandwith wich components are evaluated according to a mixed rule.

        Notes
        ----- 
        Simply use the plugin rule for small sample, and estimate the ratio between the plugin rule and the Silverman rule on a small sample, then scale the Silverman bandwidth computed on the full sample with this ratio.

        """
        return _dist_bundle2.KernelSmoothing_computeMixedBandwidth(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_KernelSmoothing(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_KernelSmoothing
    __del__ = lambda self : None;
KernelSmoothing_swigregister = _dist_bundle2.KernelSmoothing_swigregister
KernelSmoothing_swigregister(KernelSmoothing)

class Laplace(openturns.model_copula.ContinuousDistribution):
    """
    Laplace distribution.

    Available constructors:
        Laplace(*lambda=1.0, mu=0.0*)

    Parameters
    ----------
    lambda : float, :math:`\\lambda > 0`
        Scale parameter :math:`\\lambda`.
    mu : float
        Location parameter :math:`\\mu`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\lambda}{2}
                 \\exp\\left(- \\lambda |x - \\mu|\\right),
                 \\quad x \\in \\Rset

    with :math:`\\lambda > 0` and :math:`\\mu \\in \\Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\mu \\\\
            \\Var{X} & = & \\frac{2}{\\lambda^2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Laplace(1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Laplace, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Laplace, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Laplace_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.Laplace___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.Laplace___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Laplace___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Laplace_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Laplace_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Laplace_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.Laplace_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Laplace_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Laplace_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Laplace_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Laplace_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Laplace_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Laplace_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.Laplace_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Laplace_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Laplace_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.Laplace_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Laplace_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Laplace_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.Laplace_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Laplace_getParameterDescription(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Laplace_isElliptical(self)

    def setMu(self, *args):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Parameters
        ----------
        mu : float, :math:`\\mu \\in \\Rset`
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle2.Laplace_setMu(self, *args)

    def getMu(self):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Returns
        -------
        mu : float
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle2.Laplace_getMu(self)

    def setLambda(self, *args):
        """
        Accessor to the distribution's scale parameter :math:`\\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\\lambda > 0`
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle2.Laplace_setLambda(self, *args)

    def getLambda(self):
        """
        Accessor to the distribution's scale parameter :math:`\\lambda`.

        Returns
        -------
        lambda : float
            Scale parameter :math:`\\lambda`.
        """
        return _dist_bundle2.Laplace_getLambda(self)

    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.NumericalPoint`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Laplace_getSingularities(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_Laplace(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Laplace
    __del__ = lambda self : None;
Laplace_swigregister = _dist_bundle2.Laplace_swigregister
Laplace_swigregister(Laplace)

class LaplaceFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Laplace factory.

    Available constructor:
        LaplaceFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LaplaceFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LaplaceFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LaplaceFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.LaplaceFactory_build(self, *args)

    def buildAsLaplace(self, *args): return _dist_bundle2.LaplaceFactory_buildAsLaplace(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_LaplaceFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LaplaceFactory
    __del__ = lambda self : None;
LaplaceFactory_swigregister = _dist_bundle2.LaplaceFactory_swigregister
LaplaceFactory_swigregister(LaplaceFactory)

class Logistic(openturns.model_copula.ContinuousDistribution):
    """
    Logistic distribution.

    Available constructors:
        Logistic(*alpha=0.0, beta=1.0*)

    Parameters
    ----------
    alpha : float
        Location parameter :math:`\\alpha`.
    beta : float, :math:`\\beta > 0`
        Scale parameter :math:`\\beta`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\exp\\left(\\left(- \\frac{x - \\alpha}{\\beta}\\right)\\right)}
                      {\\beta \\left(1 + \\exp\\left(- \\frac{x-\\alpha}{\\beta}
                                                 \\right)\\right)^2},
                 \\quad x \\in \\Rset

    with :math:`\\alpha \\in \\Rset` and :math:`\\beta > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\alpha \\\\
            \\Var{X} & = & \\frac{1}{3} \\pi^2 \\beta^2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Logistic(0.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Logistic, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Logistic, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Logistic_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.Logistic___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.Logistic___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Logistic___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Logistic_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Logistic_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Logistic_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.Logistic_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Logistic_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Logistic_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Logistic_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Logistic_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Logistic_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Logistic_computeCDFGradient(self, *args)

    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle2.Logistic_getRoughness(self)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.Logistic_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Logistic_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Logistic_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.Logistic_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Logistic_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Logistic_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.Logistic_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Logistic_getParameterDescription(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Logistic_isElliptical(self)

    def setAlpha(self, *args):
        """
        Accessor to the distribution's location parameter :math:`\\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\\alpha \\in \\Rset`
            Location parameter :math:`\\alpha`.
        """
        return _dist_bundle2.Logistic_setAlpha(self, *args)

    def getAlpha(self):
        """
        Accessor to the distribution's location parameter :math:`\\alpha`.

        Returns
        -------
        alpha : float
            Location parameter :math:`\\alpha`.
        """
        return _dist_bundle2.Logistic_getAlpha(self)

    def setBeta(self, *args):
        """
        Accessor to the distribution's scale parameter :math:`\\beta`.

        Parameters
        ----------
        beta : float, :math:`\\beta > 0`
            Scale parameter :math:`\\beta`.
        """
        return _dist_bundle2.Logistic_setBeta(self, *args)

    def getBeta(self):
        """
        Accessor to the distribution's scale parameter :math:`\\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\\beta`.
        """
        return _dist_bundle2.Logistic_getBeta(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_Logistic(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Logistic
    __del__ = lambda self : None;
Logistic_swigregister = _dist_bundle2.Logistic_swigregister
Logistic_swigregister(Logistic)

class LogisticFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Logistic factory.

    Available constructor:
        LogisticFactory()

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
          \\displaystyle\\Hat{\\alpha} = \\bar{x}\\\\
          \\displaystyle\\Hat{\\beta} = \\Hat{\\sigma}_x
        \\end{eqnarray*}

    See also
    --------
    DistributionFactory, Logistic
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogisticFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogisticFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogisticFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.LogisticFactory_build(self, *args)

    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.


        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle2.LogisticFactory_buildEstimator(self, *args)

    def buildAsLogistic(self, *args): return _dist_bundle2.LogisticFactory_buildAsLogistic(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_LogisticFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogisticFactory
    __del__ = lambda self : None;
LogisticFactory_swigregister = _dist_bundle2.LogisticFactory_swigregister
LogisticFactory_swigregister(LogisticFactory)

class LogNormal(openturns.model_copula.ContinuousDistribution):
    """
    Lognormal distribution.

    Available constructors:
        LogNormal(*muLog=0.0, sigmaLog=1.0, gamma=0.0*)

    Parameters
    ----------
    muLog : float
        location parameter :math:`\\mu_\\ell`.
    sigmaLog : float, :math:`\\sigma_\\ell > 0`
        scale parameter :math:`\\sigma_\\ell`.
    gamma : float, optional
        Shift parameter :math:`\\gamma < \\mu`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{\\sqrt{2\\pi}\\sigma_\\ell (x - \\gamma)}
                 \\exp\\left(- \\frac{1}{2}
                           \\left(\\frac{\\log(x - \\gamma) - \\mu_\\ell}
                                      {\\sigma_\\ell}\\right)^2\\right),
                 \\quad x \\in [\\gamma; +\\infty[

    with :math:`\\gamma, \\mu_\\ell \\in \\Rset` and :math:`\\sigma_\\ell > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\exp\\left(\\mu_\\ell + \\sigma_\\ell^2 / 2\\right) + \\gamma \\\\
            \\Var{X} & = & \\exp\\left(2 \\mu_\\ell + \\sigma_\\ell^2\\right)
                          \\left(\\exp(\\sigma_\\ell^2) - 1\\right)
        \\end{eqnarray*}


    It is possible to create a LogNormal distribution from the alternative parametrizations :math:`(\\mu, \\sigma, \\gamma)`: see  :class:`~openturns.LogNormalMuSigma` or :math:`(\\mu, \\sigma / \\mu, \\gamma)`: see  :class:`~openturns.LogNormalMuSigmaOverMu`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\\mu_\\ell, \\sigma_\\ell, \\gamma)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(\\mu_\\ell, \\sigma_\\ell, \\gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.LogNormal(1.0, 1.0, 0.0)

    Create a it from the alternative parametrization :math:`(\\mu, \\sigma, \\gamma)`:

    >>> myDist2 = ot.LogNormal()
    >>> myDist2.setParameter(ot.LogNormalMuSigma()([4.5, 5.8, 0.0]))

    Create a it from the alternative parametrization :math:`(\\mu, \\sigma/\\mu, \\gamma)`:

    >>> myDist3 = ot.LogNormal()
    >>> myDist3.setParameter(ot.LogNormalMuSigmaOverMu()([4.5, 1.3, 0.0]))

    Create it from :math:`(\\mu, \\sigma, \\gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.LogNormalMuSigma(4.5, 5.8, 0.0)
    >>> myDist4 = ot.ParametrizedDistribution(myParam)

    Create it from :math:`(\\mu, \\sigma/\\mu, \\gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.LogNormalMuSigmaOverMu(4.5, 1.3, 0.0)
    >>> myDist5 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogNormal, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogNormal, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormal_getClassName(self)

    MUSIGMA_LOG = _dist_bundle2.LogNormal_MUSIGMA_LOG
    MUSIGMA = _dist_bundle2.LogNormal_MUSIGMA
    MU_SIGMAOVERMU = _dist_bundle2.LogNormal_MU_SIGMAOVERMU
    def __eq__(self, *args): return _dist_bundle2.LogNormal___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.LogNormal___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.LogNormal___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.LogNormal_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogNormal_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogNormal_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.LogNormal_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogNormal_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.LogNormal_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.LogNormal_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.LogNormal_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.LogNormal_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.LogNormal_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.LogNormal_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.LogNormal_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.LogNormal_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.LogNormal_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.LogNormal_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.LogNormal_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.LogNormal_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.LogNormal_getParameterDescription(self)

    def setMuLog(self, *args):
        """
        Accessor to the distribution's location parameter :math:`\\mu_\\ell`.

        Parameters
        ----------
        mu_log : float, :math:`\\mu_\\ell \\in \\Rset`
            Location parameter :math:`\\mu_\\ell`.
        """
        return _dist_bundle2.LogNormal_setMuLog(self, *args)

    def getMuLog(self):
        """
        Accessor to the distribution's location parameter :math:`\\mu_\\ell`.

        Returns
        -------
        mu_log : float
            Location parameter :math:`\\mu_\\ell`.
        """
        return _dist_bundle2.LogNormal_getMuLog(self)

    def setSigmaLog(self, *args):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma_\\ell`.

        Parameters
        ----------
        sigma_log : float, :math:`\\sigma_\\ell > 0`
            Scale parameter :math:`\\sigma_\\ell`.
        """
        return _dist_bundle2.LogNormal_setSigmaLog(self, *args)

    def getSigmaLog(self):
        """
        Accessor to the distribution's scale parameter :math:`\\sigma_\\ell`.

        Returns
        -------
        sigma_log : float
            Scale parameter :math:`\\sigma_\\ell`.
        """
        return _dist_bundle2.LogNormal_getSigmaLog(self)

    def setMuSigma(self, *args):
        """
        Accessor to the distribution's mean and standard deviation.

        Parameters
        ----------
        mu : float, :math:`\\mu > \\gamma`
            Mean.
        sigma : float, :math:`\\sigma > 0`
            Standard deviation.
        """
        return _dist_bundle2.LogNormal_setMuSigma(self, *args)

    def getMu(self):
        """
        Accessor to the distribution's mean.

        Returns
        -------
        mu : float
            Mean.
        """
        return _dist_bundle2.LogNormal_getMu(self)

    def getSigma(self):
        """
        Accessor to the distribution's standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation.
        """
        return _dist_bundle2.LogNormal_getSigma(self)

    def setGamma(self, *args):
        """
        Accessor to the distribution's shift parameter :math:`\\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\\gamma < \\mu`
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle2.LogNormal_setGamma(self, *args)

    def getGamma(self):
        """
        Accessor to the distribution's shift parameter :math:`\\gamma`.

        Returns
        -------
        gamma : float
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle2.LogNormal_getGamma(self)

    def getSigmaOverMu(self):
        """
        Accessor to the distribution's coefficient of variation (if defined).

        Returns
        -------
        cov : float
            Coefficient of variation :math:`\\sigma/\\mu, \\mu \\neq 0`.
        """
        return _dist_bundle2.LogNormal_getSigmaOverMu(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_LogNormal(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogNormal
    __del__ = lambda self : None;
LogNormal_swigregister = _dist_bundle2.LogNormal_swigregister
LogNormal_swigregister(LogNormal)

class LogNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Lognormal factory distribution.

    Available constructors:
        LogNormalFactory()

    See also
    --------
    DistributionFactory

    Notes
    -----
    OpenTURNS has implemented several estimators to build a LogNormal distribution
    from a scalar sample. Here are detailed the estimators.

    **Moments based estimators:**

    Lets denote:

    - :math:`\\displaystyle \\overline{x}_n = \\frac{1}{n} \\sum_{i=1}^n x_i` the empirical
      mean of the sample, 
    - :math:`\\displaystyle s_n^2 = \\frac{1}{n-1} \\sum_{i=1}^n (x_i - \\overline{x}_n)^2`
      its empirical variance,
    - :math:`\\displaystyle a_{3,n} = \\sqrt{n} \\frac{\\sum_{i=1}^n (x_i - \\overline{x}_n)^3}{ \\left( \\sum_{i=1}^n (x_i - \\overline{x}_n)^2 \\right)^{3/2}}`
      its empirical skewness.

    We note :math:`\\omega = e^{\\sigma_l^2}`. The estimator :math:`\\hat{\\omega}_n` of
    :math:`\\omega` is the positive root of the relation:

    .. math::
        :label: omega_moment_relation

        \\omega^3 + 3 \\omega^2 - (4 + a_{3,n}^2) = 0

    Then we estimate :math:`(\\hat{\\mu}_{ln}, \\hat{\\sigma}_{ln}, \\hat{\\gamma}_{n})`
    using:

    .. math::
        :label: moment_estimators

        \\hat{\\mu}_{ln} &= \\log \\hat{\\beta}_{n} \\\\
        \\hat{\\sigma}_{ln} &= \\sqrt{ \\log \\hat{\\omega}_{n} } \\\\
        \\hat{\\gamma}_{ln} &= \\overline{x}_n - \\hat{\\beta}_{n} \\sqrt{ \\hat{\\omega}_{n} }

    where :math:`\\displaystyle \\hat{\\beta}_{n} = \\frac{s_n}{\\hat{\\omega}_{n} (\\hat{\\omega}_{n} - 1)}`.

    **Modified moments based estimators:**

    we use :math:`\\overline{x}_n` and :math:`s_n^2` defined as previously. The third
    equation is:

    .. math::
        :label: expected_modified_moment

        \\Eset[ \\log (X_{(1)} - \\gamma)] = \\log (x_{(1)} - \\gamma)

    The quantity :math:`\\displaystyle EZ_1 (n) = \\frac{\\Eset[ \\log (X_{(1)} - \\gamma)] - \\mu_l}{\\sigma_l}`
    is the mean of the first order statistics of a standard normal sample of size
    :math:`n`. We have:

    .. math::
        :label: EZ1_equation

        EZ_1(n) = \\int_\\Rset nz\\phi(z) (1 - \\Phi(z))^{n-1}\\di{z}

    where :math:`\\varphi` and :math:`\\Phi` are the pdf and cdf of the standard
    normal distribution. The estimator :math:`\\hat{\\omega}_{n}` of :math:`\\omega` is
    obtained as solution of:

    .. math::
        :label: omega_modified_moment_relation

        \\omega (\\omega - 1) - \\kappa_n \\left[ \\sqrt{\\omega} - e^{EZ_1(n)\\sqrt{\\log \\omega}} \\right]^2 = 0

    where :math:`\\displaystyle \\kappa_n = \\frac{s_n^2}{(\\overline{x}_n - x_{(1)})^2}`.
    The we have :math:`(\\hat{\\mu}_{ln}, \\hat{\\sigma}_{ln}, \\hat{\\gamma}_{n})` using
    the relations defined for the moments based estimators :eq:`moment_estimators`.

    **Local maximum likelihood estimators:**

    The following sums are defined:

    .. math::

        S_0 &= \\sum_{i=1}^n \\frac{1}{x_i - \\gamma} \\\\
        S_1 &= \\sum_{i=1}^n \\log (x_i - \\gamma) \\\\
        S_2 &= \\sum_{i=1}^n \\log^2 (x_i - \\gamma) \\\\
        S_3 &= \\sum_{i=1}^n \\frac{\\log (x_i - \\gamma)}{x_i - \\gamma}

    The Maximum Likelihood estimators of :math:`(\\mu_{l}, \\sigma_{l}, \\gamma)` are 
    defined by:

    .. math::
        :label: mll_estimators

        \\hat{\\mu}_{l,n} &= \\frac{S_1(\\hat{\\gamma})}{n} \\\\
        \\hat{\\sigma}_{l,n}^2 &= \\frac{S_2(\\hat{\\gamma})}{n} - \\hat{\\mu}_{l,n}^2

    This, :math:`\\hat{\\gamma}_n` verifies the relation:

    .. math::
        :label: mll_relation
        
        S_0 (\\gamma) \\left(S_2(\\gamma) - S_1(\\gamma) \\left( 1 + \\frac{S_1(\\gamma)}{n} \\right) \\right) + n S_4(\\gamma) = 0

    under the constraint :math:`\\gamma \\leq \\min x_i`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogNormalFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogNormalFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

            build(*sample, covMat*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.
        covMat : :class:`~openturns.CovarianceMatrix`
            A covariance matrix.

        Notes
        -----
        In the first usage, the parameters are evaluated according the following strategy:

        - OpenTURNS first uses the local likelihood maximum based estimators. 
        - OpenTURNS uses the modified moments based estimators if the resolution of
          :eq:`mll_relation` is not possible.
        - OpenTURNS uses the moments based estimators, which are always defined, if
          the resolution of :eq:`omega_modified_moment_relation` is not possible.

        In the second usage, the covariance matrix *covMat* is fulfilled with the
        covariance of the estimator of the parameter vector :math:`\\vect{\\theta}`. The
        technique used is bootstrap. In case of asymptotical normal convergence of the
        estimator, it enables to build confidence intervals.
        """
        return _dist_bundle2.LogNormalFactory_build(self, *args)

    def buildAsLogNormal(self, *args):
        """
        Build the distribution as a LogNormal type.

        **Available usages**:

            build(*sample*)

            build(*sample, method*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        method : integer
            An integer ranges from 0 to 2 corresponding to a specific estimator method:
            - 0 : Local likelihood maximum estimators
            - 1 : Modified moment estimators
            - 2 : method of moment estimators.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        """
        return _dist_bundle2.LogNormalFactory_buildAsLogNormal(self, *args)

    def buildMethodOfMoments(self, *args):
        """
        Build the distribution based on the method of moments estimators.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfMoments(self, *args)

    def buildMethodOfLocalLikelihoodMaximization(self, *args):
        """
        Build the distribution based on the local likelihood maximum estimators.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfLocalLikelihoodMaximization(self, *args)

    def buildMethodOfModifiedMoments(self, *args):
        """
        Build the distribution based on the modified moments estimators.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfModifiedMoments(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_LogNormalFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogNormalFactory
    __del__ = lambda self : None;
LogNormalFactory_swigregister = _dist_bundle2.LogNormalFactory_swigregister
LogNormalFactory_swigregister(LogNormalFactory)

class LogNormalMuSigma(openturns.model_copula.DistributionParametersImplementation):
    """
    LogNormal distribution parameters.

    Available constructors:
        LogNormalMuSigma(*mu=* :math:`e^{0.5}` *, sigma=* :math:`\\sqrt{e^2-e}` *, gamma=0.*)

    Parameters
    ----------
    mu : float
        Mean.
    sigma : float
        Standard deviation :math:`\\sigma > 0`.
    gamma : float, optional
        Shift parameter.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        \\sigma_l &= \\sqrt{\\log{ \\left( 1+\\frac{\\sigma^2}{(\\mu-\\gamma)^2} \\right) }} \\\\
        \\mu_l &= \\log{(\\mu-\\gamma)} - \\frac{\\sigma_l^2}{2}

    See also
    --------
    LogNormal

    Examples
    --------
    Create the parameters of the LogNormal distribution:

    >>> import openturns as ot
    >>> parameters = ot.LogNormalMuSigma(0.63, 3.3, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [-1.00492,1.50143,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  1.67704  -0.527552  0        ]
     [ -0.271228  0.180647  0        ]
     [ -1.67704   0.527552  1        ]]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogNormalMuSigma, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogNormalMuSigma, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalMuSigma_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.LogNormalMuSigma___eq__(self, *args)
    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle2.LogNormalMuSigma_getDistribution(self)

    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle2.LogNormalMuSigma_gradient(self)

    def __call__(self, *args): return _dist_bundle2.LogNormalMuSigma___call__(self, *args)
    def inverse(self, *args):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.NumericalPoint`
            The native parameters.
        """
        return _dist_bundle2.LogNormalMuSigma_inverse(self, *args)

    def setValues(self, *args):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigma_setValues(self, *args)

    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.NumericalPoint`
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigma_getValues(self)

    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle2.LogNormalMuSigma_getDescription(self)

    def __repr__(self): return _dist_bundle2.LogNormalMuSigma___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.LogNormalMuSigma___str__(self, offset)
    def __init__(self, *args): 
        this = _dist_bundle2.new_LogNormalMuSigma(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogNormalMuSigma
    __del__ = lambda self : None;
LogNormalMuSigma_swigregister = _dist_bundle2.LogNormalMuSigma_swigregister
LogNormalMuSigma_swigregister(LogNormalMuSigma)

class LogNormalMuSigmaOverMu(openturns.model_copula.DistributionParametersImplementation):
    """
    LogNormal distribution parameters.

    Available constructors:
        LogNormalMuSigmaOverMu(*mu=* :math:`\\sqrt{e}` *, delta=* :math:`\\sqrt{e-1}` *, gamma=0.0*)

    Parameters
    ----------
    mu : float
        Mean :math:`\\mu > 0`.
    delta : float
        Variation coefficient :math:`\\delta = \\sigma/\\mu`.
    gamma : float, optional
        Shift parameter.

    Notes
    -----
    The native parameters are defined as follows:

    .. math::

        \\sigma_l &= \\sqrt{\\log{ \\left(1+\\frac{(\\delta \\mu)^2}{(\\mu-\\gamma)^2} \\right)}}\\\\
        \\mu_l &= \\log{(\\mu-\\gamma)} - \\frac{\\sigma_l^2}{2}

    See also
    --------
    LogNormal

    Examples
    --------
    Create the parameters of the LogNormal distribution:

    >>> import openturns as ot
    >>> parameters = ot.LogNormalMuSigmaOverMu(0.63, 5.24, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [-1.00525,1.50164,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0.256272  0.418663  0        ]
     [ -0.170824  0.113758  0        ]
     [ -1.6771    0.527516  1        ]]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogNormalMuSigmaOverMu, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionParametersImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogNormalMuSigmaOverMu, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.LogNormalMuSigmaOverMu___eq__(self, *args)
    def getDistribution(self):
        """
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getDistribution(self)

    def gradient(self):
        """
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \\dots, p_q)` the native parameters and :math:`(p'_1, \\dots, p'_q)` the new ones, then the gradient matrix is :math:`\\left( \\dfrac{\\partial p'_i}{\\partial p_j} \\right)_{1 \\leq i,j \\leq  q}`.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_gradient(self)

    def __call__(self, *args): return _dist_bundle2.LogNormalMuSigmaOverMu___call__(self, *args)
    def inverse(self, *args):
        """
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.NumericalPoint`
            The native parameters.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_inverse(self, *args)

    def setValues(self, *args):
        """
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_setValues(self, *args)

    def getValues(self):
        """
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.NumericalPoint`
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getValues(self)

    def getDescription(self):
        """
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getDescription(self)

    def __repr__(self): return _dist_bundle2.LogNormalMuSigmaOverMu___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.LogNormalMuSigmaOverMu___str__(self, offset)
    def __init__(self, *args): 
        this = _dist_bundle2.new_LogNormalMuSigmaOverMu(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogNormalMuSigmaOverMu
    __del__ = lambda self : None;
LogNormalMuSigmaOverMu_swigregister = _dist_bundle2.LogNormalMuSigmaOverMu_swigregister
LogNormalMuSigmaOverMu_swigregister(LogNormalMuSigmaOverMu)

class LogUniform(openturns.model_copula.ContinuousDistribution):
    """
    LogUniform distribution.

    Available constructors:
        LogUniform(*a_log=-1.0, b_log=1.0*)

    Parameters
    ----------
    a_log : float
        Lower bound in log-scale.
    b_log : float, :math:`b_\\ell > a_\\ell`
        Upper bound in log-scale.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}{x (b_\\ell - a_\\ell)},
                 \\quad \\log(x) \\in [a_\\ell; b_\\ell]

    with :math:`a_\\ell < b_\\ell`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{b - a}{b_\\ell - a_\\ell} \\\\
            \\Var{X} & = & \\frac{1}{2} (b - a)
                          \\frac{  b (b_\\ell - a_\\ell - 2)
                                + a (b_\\ell - a_\\ell + 2)}
                               {(b_\\ell - a_\\ell)^2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.LogUniform(-1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogUniform, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogUniform, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogUniform_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.LogUniform___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.LogUniform___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.LogUniform___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.LogUniform_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogUniform_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogUniform_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.LogUniform_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.LogUniform_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.LogUniform_computeCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.LogUniform_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.LogUniform_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.LogUniform_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.LogUniform_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.LogUniform_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.LogUniform_getStandardMoment(self, *args)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.LogUniform_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.LogUniform_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.LogUniform_getParameterDescription(self)

    def setALog(self, *args):
        """
        Accessor to the distribution's lower bound in log-scale :math:`a_\\ell`.

        Parameters
        ----------
        a_log : float, :math:`a_\\ell < b_\\ell`
            Lower bound in log-scale.
        """
        return _dist_bundle2.LogUniform_setALog(self, *args)

    def getALog(self):
        """
        Accessor to the distribution's lower bound in log-scale :math:`a_\\ell`.

        Returns
        -------
        a_log : float
            Lower bound in log-scale.
        """
        return _dist_bundle2.LogUniform_getALog(self)

    def setBLog(self, *args):
        """
        Accessor to the distribution's upper bound in log-scale :math:`b_\\ell`.

        Parameters
        ----------
        b_log : float, :math:`b_\\ell > a_\\ell`
            Upper bound in log-scale.
        """
        return _dist_bundle2.LogUniform_setBLog(self, *args)

    def getBLog(self):
        """
        Accessor to the distribution's upper bound in log-scale :math:`b_\\ell`.

        Returns
        -------
        b_log : float
            Upper bound in log-scale.
        """
        return _dist_bundle2.LogUniform_getBLog(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_LogUniform(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogUniform
    __del__ = lambda self : None;
LogUniform_swigregister = _dist_bundle2.LogUniform_swigregister
LogUniform_swigregister(LogUniform)

class LogUniformFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Log Uniform factory.

    Available constructor:
        LogUniformFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LogUniformFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LogUniformFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogUniformFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.LogUniformFactory_build(self, *args)

    def buildAsLogUniform(self, *args): return _dist_bundle2.LogUniformFactory_buildAsLogUniform(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_LogUniformFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_LogUniformFactory
    __del__ = lambda self : None;
LogUniformFactory_swigregister = _dist_bundle2.LogUniformFactory_swigregister
LogUniformFactory_swigregister(LogUniformFactory)

class MarginalDistribution(openturns.model_copula.DistributionImplementation):
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MarginalDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MarginalDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MarginalDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.MarginalDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.MarginalDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MarginalDistribution___str__(self, offset)
    def setDistribution(self, *args): return _dist_bundle2.MarginalDistribution_setDistribution(self, *args)
    def getDistribution(self): return _dist_bundle2.MarginalDistribution_getDistribution(self)
    def setIndices(self, *args): return _dist_bundle2.MarginalDistribution_setIndices(self, *args)
    def getIndices(self): return _dist_bundle2.MarginalDistribution_getIndices(self)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.MarginalDistribution_getRealization(self)

    def getSample(self, *args):
        """
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator
        """
        return _dist_bundle2.MarginalDistribution_getSample(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MarginalDistribution_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        """
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.NumericalPoint`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\\vect{X}` is defined as follows:

        .. math::

         
            S_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^d X_i > x_i}
                     \\quad \\forall \\vect{x} \\in \\Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.MarginalDistribution_computeSurvivalFunction(self, *args)

    def computeProbability(self, *args):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.MarginalDistribution_computeProbability(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.MarginalDistribution_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.MarginalDistribution_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.MarginalDistribution_getKurtosis(self)

    def getSpearmanCorrelation(self):
        """
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \\mat{\\rho_S} = \\left[\\frac{\\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\\sqrt{\\Var{F_{X_i}(X_i)} \\Var{F_{X_j}(X_j)}}},
                                 \\quad i,j = 1, \\ldots, n\\right]

        See Also
        --------
        getKendallTau
        """
        return _dist_bundle2.MarginalDistribution_getSpearmanCorrelation(self)

    def getKendallTau(self):
        """
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau: :class:`~openturns.SquareMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \\mat{\\tau} = \\Big[& \\Prob{X_i < x_i \\cap X_j < x_j
                                      \\cup
                                      X_i > x_i \\cap X_j > x_j} \\\\
                              & - \\Prob{X_i < x_i \\cap X_j > x_j
                                        \\cup
                                        X_i > x_i \\cap X_j < x_j},
                              \\quad i,j = 1, \\ldots, n\\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _dist_bundle2.MarginalDistribution_getKendallTau(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MarginalDistribution_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        """
        Accessor to the iso-probabilistic transformation.

        Returns
        -------
        T : :class:`~openturns.NumericalMathFunction`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \\left|\\begin{array}{rcl}
                    \\supp{\\vect{X}} & \\rightarrow & \\Rset^n \\\\
                    \\vect{x} & \\mapsto & \\vect{u}
               \\end{array}\\right.

        **An** iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\\supp{\\vect{X}}` to :math:`\\Rset^d` that maps realizations
        :math:`\\vect{x}` of a random vector :math:`\\vect{X}` into realizations
        :math:`\\vect{y}` of another random vector :math:`\\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \\begin{eqnarray*}
                \\Prob{\\bigcap_{i=1}^d X_i \\leq x_i}
                    & = & \\Prob{\\bigcap_{i=1}^d Y_i \\leq y_i} \\\\
                F_{\\vect{X}}(\\vect{x})
                    & = & F_{\\vect{Y}}(\\vect{y})
            \\end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\\vect{x}` into realizations :math:`\\vect{u}` of a
        random vector :math:`\\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**
              [Nataf1962]_, [Lebrun2009a]_.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation** [Lebrun2009b]_.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation** [Rosenblatt1952]_, [Lebrun2009c]_.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if is invariant by
            rotation. Mathematically, :math:`\\vect{U}` has a spherical distribution
            if:

            .. math::

                \\mat{R}\\,\\vect{U} \\sim \\vect{U},
                \\quad \\forall \\mat{R} \\in \\cS\\cP_n(\\Rset)

        See also
        --------
        getInverseIsoProbabilisticTransformation, isElliptical, hasEllipticalCopula
        """
        return _dist_bundle2.MarginalDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        """
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.NumericalMathFunction`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \\left|\\begin{array}{rcl}
                        \\Rset^n & \\rightarrow & \\supp{\\vect{X}} \\\\
                        \\vect{u} & \\mapsto & \\vect{x}
                    \\end{array}\\right.

        See also
        --------
        getIsoProbabilisticTransformation
        """
        return _dist_bundle2.MarginalDistribution_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        """
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _dist_bundle2.MarginalDistribution_getStandardDistribution(self)

    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.MarginalDistribution_hasEllipticalCopula(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.MarginalDistribution_isElliptical(self)

    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isContinuous(self)

    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isDiscrete(self)

    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isIntegral(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_MarginalDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MarginalDistribution
    __del__ = lambda self : None;
MarginalDistribution_swigregister = _dist_bundle2.MarginalDistribution_swigregister
MarginalDistribution_swigregister(MarginalDistribution)

class MaximumDistribution(openturns.model_copula.DistributionImplementation):
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaximumDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaximumDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.MaximumDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.MaximumDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MaximumDistribution___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.MaximumDistribution_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MaximumDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MaximumDistribution_computeCDF(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumDistribution_setParametersCollection(self, *args)

    def setDistribution(self, *args): return _dist_bundle2.MaximumDistribution_setDistribution(self, *args)
    def getDistribution(self): return _dist_bundle2.MaximumDistribution_getDistribution(self)
    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isContinuous(self)

    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isDiscrete(self)

    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isIntegral(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_MaximumDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MaximumDistribution
    __del__ = lambda self : None;
MaximumDistribution_swigregister = _dist_bundle2.MaximumDistribution_swigregister
MaximumDistribution_swigregister(MaximumDistribution)

class MaximumEntropyOrderStatisticsDistribution(openturns.model_copula.ContinuousDistribution):
    """
    MaximumEntropyOrderStatistics distribution.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The marginals, with range verifying :math:`a_i \\leq a_{i+1}` and :math:`b_i \\leq b_{i+1}`.
    useApproximation : bool
        Indicates whether the expression :math:`\\Phi_k(t)` is approximated with a polynomials (Hermitte with degree 4 on a discretization determined by a Gauss-Kronrod algorithm applied to :math:`\\Phi_k(t)`).
        By default, the approximation is used.
    checkMarginals : bool
        Indicates whether the compatibility tests on the marginals is done.
        By default, the tests are done.

    Notes
    -----
    Its realizations are ordered :math:`X_1 \\leq \\dots \\leq X_n`.

    Its probability density function is defined as:

    .. math::

        f_X(x) = f_1(x_1) \\prod\\limits_{k=2}^d \\phi_k(x_k) \\exp\\left(-\\int_{x_{k-1}}^{x_k} \\phi_k(s)\\di{s}\\right) \\mathbf{1}_{x_1 \\leq \\dots \\leq x_d}

                 \\text{with } \\phi_k(x_k) = \\frac{f_k(x_k)}{F_{k-1}(x_k)-F_k(x_k)}

    We note:

    .. math::

        \\Phi_k(t) = \\exp\\left(-\\int_{a_{k}}^{t} \\phi_k(s)\\di{s}\\right)


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
    >>> distribution = ot.MaximumEntropyOrderStatisticsDistribution(coll)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaximumEntropyOrderStatisticsDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaximumEntropyOrderStatisticsDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___str__(self, offset)
    def setDistributionCollection(self, *args):
        """
        Accessor to the distribution's collection.

        Parameters
        ----------
        coll : sequence
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_setDistributionCollection(self, *args)

    def getDistributionCollection(self):
        """
        Accessor to the distribution's collection.

        Returns
        -------
        coll : sequence
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getDistributionCollection(self)

    def getCopula(self):
        """
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        ComposedDistribution
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getCopula(self)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeCDF(self, *args)

    def computeCDFOld(self, *args): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeCDFOld(self, *args)
    def computeConditionalPDF(self, *args):
        """
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input `Xn`, `Xcond`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        """
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input `Xn`, `Xcond`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \\mid X_1, \\ldots, X_{n - 1}}(x_n) =
                \\Prob{X_n \\leq x_n \\mid X_1=x_1, \\ldots, X_{n-1}=x_{n-1}},
                \\quad x_n \\in \\supp{X_n}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        """
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input `p`, `Xcond`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getMarginal(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_setParametersCollection(self, *args)

    def useApproximation(self, flag=True): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_useApproximation(self, flag)
    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_hasIndependentCopula(self)

    def getApproximation(self, k=0): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getApproximation(self, k)
    def computeExponentialFactor(self, *args): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeExponentialFactor(self, *args)
    def computeFactor(self, *args): return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeFactor(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_MaximumEntropyOrderStatisticsDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MaximumEntropyOrderStatisticsDistribution
    __del__ = lambda self : None;
MaximumEntropyOrderStatisticsDistribution_swigregister = _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_swigregister
MaximumEntropyOrderStatisticsDistribution_swigregister(MaximumEntropyOrderStatisticsDistribution)

class MaximumEntropyOrderStatisticsCopula(openturns.model_copula.SklarCopula):
    """
    MaximumEntropyOrderStatisticsCopula copula.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The margins, with range verifying :math:`a_i \\leq a_{i+1}` and :math:`b_i \\leq b_{i+1}`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_U(u) = \\prod\\limits_{k=2}^d \\frac{\\exp\\left(-\\int_{\\partial_{k-1}^{-1}(u_{k-1})}^{\\partial_k^{-1}(u_k)} \\phi_k(s)\\di{s}\\right)}{\\partial_{k-1}(\\partial_k^{-1}(u_k))-u_k} \\mathbf{1}_{F_1^{-1}(u_1) \\leq \\dots \\leq F_d^{-1}(u_d)}

                 \\text{with } \\partial_k(t) = F_k(G^{-1}(t)) \\text{ and } G(t) = \\frac{1}{t} \\sum\\limits_{k=1}^d F_k(t)

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
    >>> copulaOrderStat = ot.MaximumEntropyOrderStatisticsCopula(coll)

    Draw a sample:

    >>> sample = copulaOrderStat.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.SklarCopula]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaximumEntropyOrderStatisticsCopula, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.SklarCopula]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaximumEntropyOrderStatisticsCopula, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___str__(self, offset)
    def setDistributionCollection(self, *args):
        """
        Accessor to the distribution's collection.

        Parameters
        ----------
        coll : sequence of :class:`~openturns.Distribution`
            The margins.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_setDistributionCollection(self, *args)

    def getDistributionCollection(self):
        """
        Accessor to the distribution's margins collection.

        Returns
        -------
        coll : sequence of :class:`~openturns.Distribution`
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getDistributionCollection(self)

    def getApproximation(self, k=0): return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getApproximation(self, k)
    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getMarginal(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getParametersCollection(self)

    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_setParametersCollection(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_MaximumEntropyOrderStatisticsCopula(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MaximumEntropyOrderStatisticsCopula
    __del__ = lambda self : None;
MaximumEntropyOrderStatisticsCopula_swigregister = _dist_bundle2.MaximumEntropyOrderStatisticsCopula_swigregister
MaximumEntropyOrderStatisticsCopula_swigregister(MaximumEntropyOrderStatisticsCopula)

class MaximumLikelihoodFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Maximum likelihood factory.

    Implements generic maximum likelihood estimation.

    Available constructor:
        MaximumLikelihoodFactory(*distribution*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution defining the parametric model to be adjusted to data.

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaximumLikelihoodFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaximumLikelihoodFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getClassName(self)

    def __repr__(self): return _dist_bundle2.MaximumLikelihoodFactory___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MaximumLikelihoodFactory___str__(self, offset)
    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_build(self, *args)

    def setOptimizationSolver(self, *args):
        """
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationSolver`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setOptimizationSolver(self, *args)

    def getOptimizationSolver(self):
        """
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationSolver`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getOptimizationSolver(self)

    def setOptimizationProblem(self, *args):
        """
        Accessor to the problem.

        Parameters
        ----------
        problem : :class:`~openturns.OptimizationProblem`
            The problem used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setOptimizationProblem(self, *args)

    def getOptimizationProblem(self):
        """
        Accessor to the problem.

        Returns
        -------
        problem : :class:`~openturns.OptimizationProblem`
            The problem used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getOptimizationProblem(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_MaximumLikelihoodFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MaximumLikelihoodFactory
    __del__ = lambda self : None;
MaximumLikelihoodFactory_swigregister = _dist_bundle2.MaximumLikelihoodFactory_swigregister
MaximumLikelihoodFactory_swigregister(MaximumLikelihoodFactory)

class MeixnerDistribution(openturns.model_copula.ContinuousDistribution):
    """
    Meixner distribution.

    Available constructors:
        MeixnerDistribution(*alpha=1.0, beta=0.0, delta=1.0, mu=0.*)

    Parameters
    ----------
    alpha : float, :math:`\\alpha > 0`
        Scale parameter.
    beta : float, :math:`\\beta \\in [-\\pi; \\pi]`
        Skewness parameter.
    delta : float, :math:`\\delta > 0`
        Shape parameter.
    mu : float
        Location parameter :math:`\\mu`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{\\left(2 \\cos(\\beta / 2)\\right)^{2 \\delta}}
                      {2 \\alpha \\pi \\Gamma(2 \\delta)}
                 \\exp\\left(\\frac{\\beta (x - \\mu)}{\\alpha}\\right)
                 \\left|\\Gamma\\left(\\delta + i \\frac{x - \\mu}{\\alpha}
                                   \\right)\\right|^2,
                 \\quad x \\in \\Rset

    with :math:`\\alpha, \\delta > 0`, :math:`\\beta \\in [-\\pi; \\pi]`,
    :math:`\\mu \\in \\Rset` and where :math:`i^2 = -1`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\alpha \\delta \\tan(\\beta / 2) + \\mu \\\\
            \\Var{X} & = & \\frac{\\alpha^2 \\delta}{1 + \\cos(\\beta)}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.MeixnerDistribution(1.0, 0.0, 1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeixnerDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeixnerDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MeixnerDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.MeixnerDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.MeixnerDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.MeixnerDistribution___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.MeixnerDistribution_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MeixnerDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        """
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            Logarithm of the PDF value(s) at input(s) `X`.
        """
        return _dist_bundle2.MeixnerDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.MeixnerDistribution_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.MeixnerDistribution_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.MeixnerDistribution_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.MeixnerDistribution_computeLogCharacteristicFunction(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.MeixnerDistribution_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.MeixnerDistribution_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.MeixnerDistribution_getKurtosis(self)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.MeixnerDistribution_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.MeixnerDistribution_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.MeixnerDistribution_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.MeixnerDistribution_getParameterDescription(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.MeixnerDistribution_isElliptical(self)

    def setAlpha(self, *args):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\\alpha > 0`
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle2.MeixnerDistribution_setAlpha(self, *args)

    def getAlpha(self):
        """
        Accessor to the distribution's scale parameter :math:`\\alpha`.

        Returns
        -------
        alpha : float
            Scale parameter :math:`\\alpha`.
        """
        return _dist_bundle2.MeixnerDistribution_getAlpha(self)

    def setBeta(self, *args):
        """
        Accessor to the distribution's skewness parameter :math:`\\beta`.

        Parameters
        ----------
        beta : float, :math:`\\beta \\in [-\\pi; \\pi]`
            Skewness parameter :math:`\\beta`.
        """
        return _dist_bundle2.MeixnerDistribution_setBeta(self, *args)

    def getBeta(self):
        """
        Accessor to the distribution's skewness parameter :math:`\\beta`.

        Returns
        -------
        beta : float
            Skewness parameter :math:`\\beta`.
        """
        return _dist_bundle2.MeixnerDistribution_getBeta(self)

    def setDelta(self, *args):
        """
        Accessor to the distribution's shape parameter :math:`\\delta`.

        Parameters
        ----------
        delta : float, :math:`\\delta > 0`
            Shape parameter :math:`\\delta`.
        """
        return _dist_bundle2.MeixnerDistribution_setDelta(self, *args)

    def getDelta(self):
        """
        Accessor to the distribution's shape parameter :math:`\\delta`.

        Returns
        -------
        delta : float
            Shape parameter :math:`\\delta`.
        """
        return _dist_bundle2.MeixnerDistribution_getDelta(self)

    def setMu(self, *args):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Parameters
        ----------
        mu : float, :math:`\\mu \\in \\Rset`
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle2.MeixnerDistribution_setMu(self, *args)

    def getMu(self):
        """
        Accessor to the distribution's location parameter :math:`\\mu`.

        Returns
        -------
        mu : float
            Location parameter :math:`\\mu`.
        """
        return _dist_bundle2.MeixnerDistribution_getMu(self)

    def initializeOptimizationSolverParameter(self): return _dist_bundle2.MeixnerDistribution_initializeOptimizationSolverParameter(self)
    def getOptimizationSolver(self): return _dist_bundle2.MeixnerDistribution_getOptimizationSolver(self)
    def setOptimizationSolver(self, *args): return _dist_bundle2.MeixnerDistribution_setOptimizationSolver(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_MeixnerDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MeixnerDistribution
    __del__ = lambda self : None;
MeixnerDistribution_swigregister = _dist_bundle2.MeixnerDistribution_swigregister
MeixnerDistribution_swigregister(MeixnerDistribution)

class MeixnerDistributionFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Meixner Distribution factory.

    Available constructor:
        MeixnerDistributionFactory()

    The parameters are estimated using the following moments estimators:

    .. math::
        :nowrap:

        \\begin{align}
          \\displaystyle\\Hat{\\gamma_1} = \\frac{\\frac{1}{n}\\sum_{i=1}^{n} (x_i-\\Hat{x}_n)^3}{\\Hat{\\sigma}_n^3}\\\\
          \\displaystyle\\Hat{\\gamma_2} = \\frac{\\frac{1}{n}\\sum_{i=1}^{n} (x_i-\\Hat{x}_n)^4}{\\Hat{\\sigma}_n^4}\\\\
          \\displaystyle\\Hat{\\delta} =   \\frac{1}{\\Hat{\\gamma_2}_n-\\Hat{\\gamma_1}_n^2-3}\\\\
          \\displaystyle\\Hat{\\beta} =    sign(\\Hat{\\gamma_1}_n)arcos( 2-\\Hat{\\delta}_n (\\Hat{\\gamma_2}_n-3))\\\\
          \\displaystyle\\Hat{\\alpha} =   (\\Hat{\\sigma}_n^2(\\cos\\Hat{\\beta}_n+1) )^{1/3}
        \\end{align}

    See also
    --------
    DistributionFactory, MeixnerDistribution
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeixnerDistributionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeixnerDistributionFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MeixnerDistributionFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.MeixnerDistributionFactory_build(self, *args)

    def buildAsMeixnerDistribution(self, *args): return _dist_bundle2.MeixnerDistributionFactory_buildAsMeixnerDistribution(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_MeixnerDistributionFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MeixnerDistributionFactory
    __del__ = lambda self : None;
MeixnerDistributionFactory_swigregister = _dist_bundle2.MeixnerDistributionFactory_swigregister
MeixnerDistributionFactory_swigregister(MeixnerDistributionFactory)

class Mixture(openturns.model_copula.DistributionImplementation):
    """
    Build a linear combination of probability density functions.

    Parameters
    ----------
    collDist : :class:`~openturns.Distribution`,
        The collection of distributions wich compose the linear combination.
    weights : sequence of float, optional
        A sequence with each component :math:`\\geq 0`, of dimension equal to the
        size of *collDist*. The collection of weights applied to the collection of
        distributions. By default, OpenTURNS takes the weights fulfilled inside
        each distribution (if any) thanks to the method
        *collDist[i].setWeight(myWeight)*. If not fulfilled, the weights are all
        taken equal to 1. The weights are automatically normalized so that their
        sum is equal to 1.

    Notes
    -----
    The probability density function of a *Mixture* is defined by:

    .. math::

        f(x) =  \\sum_{i=1}^N \\alpha_i p_i(x), \\quad \\alpha_i \\geq 0, \\quad \\sum_i \\alpha_i = 1

    Examples
    --------
    Create a *Mixture*:

    >>> import openturns as ot
    >>> collDist = [ot.Triangular(1.0, 2.0, 4.0), ot.Normal(-1.0, 1.0), ot.Uniform(5.0, 6.0)]
    >>> weight = [0.4, 1.0, 0.2]
    >>> myMixture = ot.Mixture(collDist, weight)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Mixture, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Mixture, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Mixture_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.Mixture___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.Mixture___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Mixture___str__(self, offset)
    def setDistributionCollection(self, *args):
        """
        Set the distribution collection.

        Parameters
        ----------
        collDist : :class:`~openturns.Distribution`,
            The collection of distributions wich compose the linear combination.
        """
        return _dist_bundle2.Mixture_setDistributionCollection(self, *args)

    def getDistributionCollection(self):
        """
        Accessor to the distribution collection.

        Returns
        -------
        collDist : :class:`~openturns.Distribution`,
            The collection of distributions wich compose the linear combination.
        """
        return _dist_bundle2.Mixture_getDistributionCollection(self)

    def getWeights(self):
        """
        Get the weights.

        Returns
        -------
        weights : :class:`~openturns.NumericalPoint` with each component :math:`\\geq 0`.
        """
        return _dist_bundle2.Mixture_getWeights(self)

    def setWeights(self, *args):
        """
        Set the weights.

        Parameters
        ----------
        weights : sequence of float with each component :math:`\\geq 0`.
        """
        return _dist_bundle2.Mixture_setWeights(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Mixture_getRealization(self)

    def computeDDF(self, *args):
        """
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`, :class:`~openturns.NumericalSample`
            DDF value(s) at input(s) `X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\\vect{x}`:

        .. math::

            \\vect{\\nabla}_{\\vect{x}} f_{\\vect{X}}(\\vect{x}) =
                \\Tr{\\left(\\frac{\\partial f_{\\vect{X}}(\\vect{x})}{\\partial x_i},
                          \\quad i = 1, \\ldots, n\\right)},
                \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Mixture_computeDDF(self, *args)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Mixture_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Mixture_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        """
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.NumericalPoint`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\\vect{X}` is defined as follows:

        .. math::

         
            S_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^d X_i > x_i}
                     \\quad \\forall \\vect{x} \\in \\Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.Mixture_computeSurvivalFunction(self, *args)

    def computeProbability(self, *args):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.Mixture_computeProbability(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Mixture_computeCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Mixture_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Mixture_computeCDFGradient(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Mixture_getMarginal(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.Mixture_getParametersCollection(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Mixture_isElliptical(self)

    def isContinuous(self):
        """
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isContinuous(self)

    def isDiscrete(self):
        """
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isDiscrete(self)

    def isIntegral(self):
        """
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isIntegral(self)

    def hasEllipticalCopula(self):
        """
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.Mixture_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_hasIndependentCopula(self)

    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.Mixture_getSupport(self, *args)

    def getSingularities(self):
        """
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.NumericalPoint`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Mixture_getSingularities(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_Mixture(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Mixture
    __del__ = lambda self : None;
Mixture_swigregister = _dist_bundle2.Mixture_swigregister
Mixture_swigregister(Mixture)

class ConditionalDistribution(Mixture):
    """
    Conditional distribution.

    Helper class for defining the distribution of :math:`\\vect{X}` such that :math:`\\vect{X}|\\vect{\\Theta}` follows the distribution :math:`\\mathcal{L}_{\\vect{X}|\\vect{\\Theta}}`, with :math:`\\vect{\\Theta}=g(\\vect{Y})`, :math:`\\vect{Y}` follows the distribution :math:`\\mathcal{L}_{\\vect{Y}}` and :math:`g` is a given function of input dimension the dimension of :math:`\\mathcal{L}_{\\vect{Y}}` and output dimension the dimension of :math:`\\vect{\\Theta}`.

    Available constructors:
       ConditionalDistribution(*conditionedDist, conditioningDist, linkFunction*)

       ConditionalDistribution(*conditionedDist, conditioningDist*)

       ConditionalDistribution()

    Parameters
    ----------

    conditionedDist : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.
        In the `ConditionalDistribution()` constructor, `conditionedDist` is taken equal to :math:`\\vect{X} | \\vect{\\Theta} \\sim` :class:`~openturns.Uniform` :math:`(\\vect{\\Theta})`.

    conditioningDist : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.
        In the `ConditionalDistribution()` constructor,  `conditioningDist` is taken equal to :math:`\\vect{Y} \\sim` :class:`~openturns.Uniform`:math:`(-1,1)`.

    linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.
        In the `ConditionalDistribution()` constructor, `linkFunction`  is taken equal to :math:`g: \\Rset \\rightarrow \\Rset^2` with :math:`g(y)=(y,y+1)`.

        In the `ConditionalDistribution(conditionedDist, conditioningDist)` constructor, we need :math:`p=q` and `linkFunction`  is taken equal to  :math:`g(\\vect{y})=\\vect{y}`.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{\\vect{X}}(\\vect{x}) = \\int f_{\\vect{X}|\\vect{\\Theta}=g(\\vect{y})}(\\vect{x}|g(\\vect{y})) f_{\\vect{Y}}(\\vect{y})\\di{\\vect{y}}

    with  :math:`f_{\\vect{X}|\\vect{\\Theta}=g(\\vect{y})}` the PDF of the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, where :math:`\\vect{\\Theta}` has been replaced by :math:`g(\\vect{y})`, :math:`f_{\\vect{Y}}` the PDF of :math:`\\vect{Y}` and :math:`g` the linking function.

    With the default constructor, the resulting random variable :math:`X` follows a trapezoidal distribution parametered by :math:`(-1, 0, 1, 2)`.

    Note that a :class:`~openturns.ConditionalDistribution` can be obtained as the first marginal distribution of a :class:`~openturns.BayesDistribution`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> conditioningDist = ot.Normal(0.0, 1.0)
    >>> g = ot.NumericalMathFunction(['y'], ['y', '0.1+y^2'])
    >>> conditionedDist = ot.Normal()
    >>> finalDist = ot.ConditionalDistribution(conditionedDist, conditioningDist, g)

    Draw a sample:

    >>> sample = finalDist.getSample(5)

    """
    __swig_setmethods__ = {}
    for _s in [Mixture]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConditionalDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [Mixture]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConditionalDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.ConditionalDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.ConditionalDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.ConditionalDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.ConditionalDistribution___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.ConditionalDistribution_getRealization(self)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.ConditionalDistribution_getParametersCollection(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.ConditionalDistribution_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.ConditionalDistribution_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.ConditionalDistribution_getParameterDescription(self)

    def setConditionedDistribution(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Parameters
        ----------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.

        """
        return _dist_bundle2.ConditionalDistribution_setConditionedDistribution(self, *args)

    def getConditionedDistribution(self):
        """
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{X}|\\vect{\\Theta}`, whose parameters will be overwritten by :math:`g(\\vect{Y})`.

        """
        return _dist_bundle2.ConditionalDistribution_getConditionedDistribution(self)

    def setConditioningDistribution(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Parameters
        ----------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.ConditionalDistribution_setConditioningDistribution(self, *args)

    def getConditioningDistribution(self):
        """
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Returns
        -------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.ConditionalDistribution_getConditioningDistribution(self)

    def setLinkFunction(self, *args):
        """
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Parameters
        ----------
        linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.

        """
        return _dist_bundle2.ConditionalDistribution_setLinkFunction(self, *args)

    def getLinkFunction(self):
        """
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Returns
        -------
        linkFunction : :class:`~openturns.NumericalMathFunction`, the function :math:`g: \\Rset^p \\rightarrow \\Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\\vect{\\Theta}`.

        """
        return _dist_bundle2.ConditionalDistribution_getLinkFunction(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.ConditionalDistribution_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_ConditionalDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_ConditionalDistribution
    __del__ = lambda self : None;
ConditionalDistribution_swigregister = _dist_bundle2.ConditionalDistribution_swigregister
ConditionalDistribution_swigregister(ConditionalDistribution)

class PosteriorDistribution(openturns.model_copula.ContinuousDistribution):
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PosteriorDistribution, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PosteriorDistribution, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.PosteriorDistribution_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.PosteriorDistribution___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.PosteriorDistribution___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.PosteriorDistribution___str__(self, offset)
    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.PosteriorDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.PosteriorDistribution_computeCDF(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.PosteriorDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.PosteriorDistribution_setParametersCollection(self, *args)

    def setConditionalDistribution(self, *args): return _dist_bundle2.PosteriorDistribution_setConditionalDistribution(self, *args)
    def getConditionalDistribution(self): return _dist_bundle2.PosteriorDistribution_getConditionalDistribution(self)
    def setObservations(self, *args): return _dist_bundle2.PosteriorDistribution_setObservations(self, *args)
    def getObservations(self): return _dist_bundle2.PosteriorDistribution_getObservations(self)
    def getLogNormalizationFactor(self): return _dist_bundle2.PosteriorDistribution_getLogNormalizationFactor(self)
    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.PosteriorDistribution_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.PosteriorDistribution_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.PosteriorDistribution_getKurtosis(self)

    def computeLikelihood(self, *args): return _dist_bundle2.PosteriorDistribution_computeLikelihood(self, *args)
    def computeLogLikelihood(self, *args): return _dist_bundle2.PosteriorDistribution_computeLogLikelihood(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_PosteriorDistribution(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_PosteriorDistribution
    __del__ = lambda self : None;
PosteriorDistribution_swigregister = _dist_bundle2.PosteriorDistribution_swigregister
PosteriorDistribution_swigregister(PosteriorDistribution)

class Multinomial(openturns.model_copula.DiscreteDistribution):
    """
    Multinomial distribution.

    Available constructors:
        Multinomial(*N=1, P=[0.5]*)

    Parameters
    ----------
    N : int, :math:`\\sum_{i = 1}^n x_i \\leq N`
        Number of experiments.
    P : sequence of float, :math:`p_i \\geq 0, i = 1, \\ldots, n` and :math:`\\sum_{i = 1}^n p_i \\leq 1`
        Component probabilities (all positive with sum less than unity).

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{\\vect{X} = \\vect{x}} = \\frac{N!}{x_1! \\ldots x_n! (N - s)!}
                                     p_1^{x_1} \\ldots p_n^{x_n} (1 - q)^{N - s},
                                     \\quad \\forall \\vect{x} \\in \\Nset^n:
                                           s = \\sum_{i = 1}^n x_i \\leq N

    with :math:`N \\in \\Nset^*`, :math:`p_i \\geq 0, i = 1, \\ldots, n` and
    :math:`\\sum_{i = 1}^n p_i \\leq 1`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X_i} & = & N p_i, \\quad i = 1, \\ldots, n \\\\
            \\Var{X_i} & = & N p_i (1 - p_i), \\quad i = 1, \\ldots, n \\\\
            \\Cov{X_i, X_j} & = & - N p_i p_j, \\quad i, j = 1, \\ldots, n, i \\neq j
        \\end{eqnarray*}

    See Also
    --------
    Dirichlet

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Multinomial(1, [0.5])

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Multinomial, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Multinomial, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Multinomial_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.Multinomial___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.Multinomial___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Multinomial___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Multinomial_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Multinomial_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Multinomial_computeCDF(self, *args)

    def computeConditionalPDF(self, *args):
        """
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input `Xn`, `Xcond`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.Multinomial_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        """
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input `Xn`, `Xcond`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \\mid X_1, \\ldots, X_{n - 1}}(x_n) =
                \\Prob{X_n \\leq x_n \\mid X_1=x_1, \\ldots, X_{n-1}=x_{n-1}},
                \\quad x_n \\in \\supp{X_n}
        """
        return _dist_bundle2.Multinomial_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        """
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input `p`, `Xcond`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.Multinomial_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Multinomial_getMarginal(self, *args)

    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.Multinomial_getSupport(self, *args)

    def getParametersCollection(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.NumericalPointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.Multinomial_getParametersCollection(self)

    def isElliptical(self):
        """
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \\phi(\\vect{t}) = \\exp\\left(i \\Tr{\\vect{t}} \\vect{\\mu}\\right)
                             \\Psi\\left(\\Tr{\\vect{t}} \\mat{\\Sigma} \\vect{t}\\right),
                             \\quad \\vect{t} \\in \\Rset^n

        for specified vector :math:`\\vect{\\mu}` and positive-definite matrix
        :math:`\\mat{\\Sigma}`. The function :math:`\\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Multinomial_isElliptical(self)

    def setP(self, *args):
        """
        Accessor to the component probabilities parameter :math:`\\vect{p}`.

        Parameters
        ----------
        P : sequence of float, :math:`0 \\leq p_i, i = 1, \\ldots, n` and :math:`\\sum_{i = 1}^n p_i \\leq 1`
            Component probabilities (all positive with sum less than unity).
        """
        return _dist_bundle2.Multinomial_setP(self, *args)

    def getP(self):
        """
        Accessor to the component probabilities parameter :math:`\\vect{p}`.

        Returns
        -------
        P : :class:`~openturns.NumericalPoint`
            Component probabilities :math:`\\vect{p}`.
        """
        return _dist_bundle2.Multinomial_getP(self)

    def setN(self, *args):
        """
        Accessor to the number of experiments parameter :math:`N`.

        Parameters
        ----------
        N : int, :math:`\\sum_{i = 1}^n x_i \\leq N`
            Number of experiments :math:`N`.
        """
        return _dist_bundle2.Multinomial_setN(self, *args)

    def getN(self):
        """
        Accessor to the number of experiments parameter :math:`N`.

        Returns
        -------
        N : int
            Number of experiments :math:`N`.
        """
        return _dist_bundle2.Multinomial_getN(self)

    def setSmallA(self, *args): return _dist_bundle2.Multinomial_setSmallA(self, *args)
    def getSmallA(self): return _dist_bundle2.Multinomial_getSmallA(self)
    def setEta(self, *args): return _dist_bundle2.Multinomial_setEta(self, *args)
    def getEta(self): return _dist_bundle2.Multinomial_getEta(self)
    def __init__(self, *args): 
        this = _dist_bundle2.new_Multinomial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Multinomial
    __del__ = lambda self : None;
Multinomial_swigregister = _dist_bundle2.Multinomial_swigregister
Multinomial_swigregister(Multinomial)

class MultinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Multinomial factory.

    Available constructor:
        MultinomialFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultinomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultinomialFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MultinomialFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.MultinomialFactory_build(self, *args)

    def buildAsMultinomial(self, *args): return _dist_bundle2.MultinomialFactory_buildAsMultinomial(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_MultinomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_MultinomialFactory
    __del__ = lambda self : None;
MultinomialFactory_swigregister = _dist_bundle2.MultinomialFactory_swigregister
MultinomialFactory_swigregister(MultinomialFactory)

class NegativeBinomial(openturns.model_copula.DiscreteDistribution):
    """
    NegativeBinomial distribution.

    Available constructors:
        NegativeBinomial(*r=1.0, p=0.5*)

    Parameters
    ----------
    r : float, :math:`r > 0`
        Number of failures until the Bernoulli trial is stopped.

    p : float, :math:`0 < p < 1`
        Success probability of the Bernoulli trial.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        \\Prob{X = k} = \\frac{\\Gamma(k + r)}{\\Gamma(r)\\Gamma(k+1)}p^k(1-p)^r,
                       \\, \\forall k \\in \\Nset

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\frac{rp}{1-p} \\\\
            \\Var{X} & = & \\frac{rp}{(1-p)^2}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NegativeBinomial(1.0, 0.6)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NegativeBinomial, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DiscreteDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NegativeBinomial, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NegativeBinomial_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.NegativeBinomial___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.NegativeBinomial___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.NegativeBinomial___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.NegativeBinomial_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NegativeBinomial_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NegativeBinomial_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        """
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.NumericalPoint`
            Complementary CDF value(s) at input(s) `X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\\vect{X}}(\\vect{x}) = 1 - \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i}, \\quad \\vect{x} \\in \\supp{\\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.NegativeBinomial_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NegativeBinomial_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NegativeBinomial_computeCDFGradient(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.NegativeBinomial_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.NegativeBinomial_computeLogCharacteristicFunction(self, *args)

    def computeGeneratingFunction(self, *args):
        """
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input `X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \\Expect{z^X}, \\quad z \\in \\Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle2.NegativeBinomial_computeGeneratingFunction(self, *args)

    def computeLogGeneratingFunction(self, *args):
        """
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input `X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle2.NegativeBinomial_computeLogGeneratingFunction(self, *args)

    def getSupport(self, *args):
        """
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\\supp{\\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.NegativeBinomial_getSupport(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NegativeBinomial_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NegativeBinomial_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NegativeBinomial_getKurtosis(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NegativeBinomial_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.NegativeBinomial_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NegativeBinomial_getParameterDescription(self)

    def setP(self, *args):
        """
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle2.NegativeBinomial_setP(self, *args)

    def getP(self):
        """
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle2.NegativeBinomial_getP(self)

    def setR(self, *args):
        """
        Accessor to the number of failures parameter.

        Parameters
        ----------
        r : float, :math:`r > 0`
            Number of failures until the Bernoulli trial is stopped.
        """
        return _dist_bundle2.NegativeBinomial_setR(self, *args)

    def getR(self):
        """
        Accessor to the number of failures parameter.

        Returns
        -------
        r : float
            Number of failures until the Bernoulli trial is stopped.
        """
        return _dist_bundle2.NegativeBinomial_getR(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_NegativeBinomial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NegativeBinomial
    __del__ = lambda self : None;
NegativeBinomial_swigregister = _dist_bundle2.NegativeBinomial_swigregister
NegativeBinomial_swigregister(NegativeBinomial)

class NegativeBinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Negative Binomial factory.

    Available constructor:
        NegativeBinomialFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NegativeBinomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NegativeBinomialFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NegativeBinomialFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.NegativeBinomialFactory_build(self, *args)

    def buildAsNegativeBinomial(self, *args): return _dist_bundle2.NegativeBinomialFactory_buildAsNegativeBinomial(self, *args)
    def __init__(self, *args): 
        this = _dist_bundle2.new_NegativeBinomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NegativeBinomialFactory
    __del__ = lambda self : None;
NegativeBinomialFactory_swigregister = _dist_bundle2.NegativeBinomialFactory_swigregister
NegativeBinomialFactory_swigregister(NegativeBinomialFactory)

class NonCentralChiSquare(openturns.model_copula.ContinuousDistribution):
    """
    NonCentralChiSquare distribution.

    Available constructors:
        NonCentralChiSquare(*nu=5.0, lambda=0.*)

    Parameters
    ----------
    nu : float, :math:`\\nu > 0`
        Generalised number degree of freedom.
    lambda : float, :math:`\\lambda \\geq 0`
        Non-centrality parameter :math:`\\lambda`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\sum_{j=0}^{\\infty} e^{-\\lambda}
                                     \\frac{\\lambda^j}{j!}p_{\\chi^2(\\nu + 2j)}(x),
                 \\quad x \\in [0; +\\infty[

    where :math:`p_{\\chi^2(q)}` is the probability density function of a
    :math:`\\chi^2(q)` random variate.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\nu + \\lambda \\\\
            \\Var{X} & = & 2(\\nu + 2\\lambda)
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NonCentralChiSquare(6.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NonCentralChiSquare, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NonCentralChiSquare, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NonCentralChiSquare_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.NonCentralChiSquare___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.NonCentralChiSquare___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.NonCentralChiSquare___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.NonCentralChiSquare_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NonCentralChiSquare_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NonCentralChiSquare_computeCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.NonCentralChiSquare_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.NonCentralChiSquare_computeLogCharacteristicFunction(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NonCentralChiSquare_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NonCentralChiSquare_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NonCentralChiSquare_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NonCentralChiSquare_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NonCentralChiSquare_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.NonCentralChiSquare_getStandardMoment(self, *args)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NonCentralChiSquare_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.NonCentralChiSquare_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NonCentralChiSquare_getParameterDescription(self)

    def setNu(self, *args):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Generalised number degrees of freedom :math:`\\nu`.
        """
        return _dist_bundle2.NonCentralChiSquare_setNu(self, *args)

    def setNuLambda(self, *args):
        """
        Accessor to the distribution's non-centrality parameters.

        Parameters :math:`\\lambda` and generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Generalised number degrees of freedom :math:`\\nu`.
        lambda : float
            Non-centrality parameter :math:`\\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_setNuLambda(self, *args)

    def getNu(self):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom :math:`\\nu`.
        """
        return _dist_bundle2.NonCentralChiSquare_getNu(self)

    def setLambda(self, *args):
        """
        Accessor to the distribution's non-centrality parameter :math:`\\lambda`.

        Parameters
        ----------
        lambda : float
            Non-centrality parameter :math:`\\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_setLambda(self, *args)

    def getLambda(self):
        """
        Accessor to the distribution's non-centrality parameter :math:`\\lambda`.

        Returns
        -------
        lambda : float
            Non-centrality parameter :math:`\\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_getLambda(self)

    def setMaximumIteration(self, *args): return _dist_bundle2.NonCentralChiSquare_setMaximumIteration(self, *args)
    def getMaximumIteration(self): return _dist_bundle2.NonCentralChiSquare_getMaximumIteration(self)
    def __init__(self, *args): 
        this = _dist_bundle2.new_NonCentralChiSquare(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NonCentralChiSquare
    __del__ = lambda self : None;
NonCentralChiSquare_swigregister = _dist_bundle2.NonCentralChiSquare_swigregister
NonCentralChiSquare_swigregister(NonCentralChiSquare)

class NonCentralStudent(openturns.model_copula.ContinuousDistribution):
    """
    NonCentralStudent distribution.

    Available constructors:
        NonCentralStudent(*nu=5.0, delta=0.0, gamma=0.0*)

    Parameters
    ----------
    nu : float, :math:`\\nu > 0`
        Generalised number degree of freedom.
    delta : float
        Non-centrality parameter :math:`\\delta`.
    gamma : float
        Shift parameter :math:`\\gamma`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{exp \\left(-\\delta^2 / 2 \\right)}
                      {\\sqrt{\\nu\\pi} \\Gamma \\left(\\frac{\\nu}{2} \\right)}
                 \\left(\\frac{\\nu}{\\nu + (x - \\gamma)^2}\\right) ^ {\\frac{\\nu + 1}{2}}
                 \\sum_{j=0}^{\\infty}
                 \\frac{\\Gamma \\left(\\frac{\\nu + j + 1}{2}\\right)}{\\Gamma(j + 1)}
                 \\left(\\delta(x - \\gamma)
                 \\sqrt{\\frac{2}{\\nu + (x - \\gamma)^2}}\\right) ^ j,
                 \\quad x \\in \\Rset

    With :math:`\\Gamma` denotes Euler's Gamma function
    :class:`~openturns.SpecFunc_Gamma`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\gamma + \\delta sqrt{\\frac{\\nu}{2}}
                             \\frac{\\Gamma\\left(\\frac{\\nu - 1}{2}\\right)}
                                  {\\Gamma \\left(\\frac{\\nu}{2}\\right)}
                           \\quad \\text{ if }\\nu > 1\\\\
            \\Var{X} & = & \\frac{\\nu}{\\nu - 2} (1 + \\delta^2) -
                          \\left(\\frac{\\nu}{2}\\delta^2
                          \\frac{\\Gamma \\left(\\frac{\\nu - 1}{2}\\right)}
                               {\\Gamma \\left(\\frac{\\nu}{2}\\right)}
                           - \\gamma \\right)^2
                        \\quad \\text{ if }\\nu>2
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NonCentralStudent(6.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NonCentralStudent, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.ContinuousDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NonCentralStudent, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NonCentralStudent_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.NonCentralStudent___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.NonCentralStudent___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.NonCentralStudent___str__(self, offset)
    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.NonCentralStudent_getRealization(self)

    def computePDF(self, *args):
        """
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.NumericalPoint`
            PDF value(s) at input(s) `X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\\vect{X}}(\\vect{x}) = \\frac{\\partial^n F_{\\vect{X}}(\\vect{x})}
                                          {\\prod_{i=1}^n \\partial x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NonCentralStudent_computePDF(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.NonCentralStudent_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        """
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NonCentralStudent_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.NonCentralStudent_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        """
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.NumericalPoint`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NonCentralStudent_getStandardDeviation(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NonCentralStudent_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.NonCentralStudent_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.NonCentralStudent_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.NonCentralStudent_getStandardRepresentative(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NonCentralStudent_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            Parameter values.
        """
        return _dist_bundle2.NonCentralStudent_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NonCentralStudent_getParameterDescription(self)

    def setNu(self, *args):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\\nu > 0`
            Generalised number degrees of freedom :math:`\\nu`.
        """
        return _dist_bundle2.NonCentralStudent_setNu(self, *args)

    def getNu(self):
        """
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom :math:`\\nu`.
        """
        return _dist_bundle2.NonCentralStudent_getNu(self)

    def setDelta(self, *args):
        """
        Accessor to the distribution's non-centrality parameter.

        Parameters
        ----------
        delta : float
            Non-centrality parameter :math:`\\delta`.
        """
        return _dist_bundle2.NonCentralStudent_setDelta(self, *args)

    def getDelta(self):
        """
        Accessor to the distribution's non-centrality parameter.

        Returns
        -------
        delta : float
            Non-centrality parameter :math:`\\delta`.
        """
        return _dist_bundle2.NonCentralStudent_getDelta(self)

    def setGamma(self, *args):
        """
        Accessor to the distribution's shift from the origin.

        Parameters
        ----------
        gamma : float
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle2.NonCentralStudent_setGamma(self, *args)

    def getGamma(self):
        """
        Accessor to the distribution's shift from the origin.

        Returns
        -------
        gamma : float
            Shift parameter :math:`\\gamma`.
        """
        return _dist_bundle2.NonCentralStudent_getGamma(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_NonCentralStudent(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NonCentralStudent
    __del__ = lambda self : None;
NonCentralStudent_swigregister = _dist_bundle2.NonCentralStudent_swigregister
NonCentralStudent_swigregister(NonCentralStudent)

class Normal(openturns.model_copula.EllipticalDistribution):
    """
    Normal distribution.

    Available constructors:
        Normal(*d=1*)

        Normal(*mu, sigma*)

        Normal(*mu, sigma, R*)

        Normal(*mu, Sigma*)

    Parameters
    ----------
    d : int, :math:`d \\geq 1`
        Dimension.
    mu : float :math:`\\mu`, sequence of float, :math:`\\vect{\\mu} \\in \\Rset^d`, optional
        Mean.

        Default is :math:`\\vect{\\mu} = (0, \\dots, 0) \\in \\Rset^d`.
    sigma : float :math:`\\sigma`, sequence of float, :math:`\\vect{\\sigma} \\in \\Rset^{*d}_+`, optional
        Scale parameter.

        Default is :math:`\\vect{\\sigma}= (1, \\dots, 1) \\in \\Rset^d`.
    R : :class:`~openturns.CorrelationMatrix` :math:`\\mat{R} \\in \\Rset^d \\times \\Rset^d`, optional
        If :math:`\\nu > 2`: correlation matrix.

        If :math:`\\nu \\leq 2`: generalized correlation matrix.

        Default is :math:`\\mat{R} = I_d \\in \\Rset^d \\times \\Rset^d`.
    Sigma : :class:`~openturns.CovarianceMatrix` :math:`\\mat{\\Sigma} \\in \\Rset^d \\times \\Rset^d`
        Covariance matrix.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \\frac{1}
                 {\\displaystyle (2\\pi)^{\\frac{n}{2}}
                                (\\mathrm{det}\\mathbf{\\Sigma})^{\\frac{1}{2}}}
                 \\displaystyle exp \\left(-\\frac{1}{2}\\Tr{(x - \\mu)}
                                         \\mathbf{\\Sigma}^{-1}(x - \\mu)\\right)

    with :math:`\\Sigma = \\Lambda(\\sigma) R \\Lambda(\\sigma)`,
    :math:`\\Lambda(\\sigma) = diag(\\sigma)`,
    :math:`R` symmetric, definite and positive, :math:`\\sigma_i > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            \\Expect{X} & = & \\vect{\\mu} \\\\
            \\Var{X} & = & \\mat{\\Sigma}
        \\end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Normal(0.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.EllipticalDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Normal, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.EllipticalDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Normal, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Normal_getClassName(self)

    def __repr__(self): return _dist_bundle2.Normal___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.Normal___str__(self, offset)
    def computeDensityGenerator(self, *args):
        """
        Compute the probability density function of the characteristic generator.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator value at input `X`.

        Notes
        -----
        This is the function :math:`\\phi` such that the probability density function
        rewrites:

        .. math::

            f_{\\vect{X}}(\\vect{x}) =
                \\phi\\left(\\Tr{\\left(\\vect{x} - \\vect{\\mu}\\right)}
                              \\mat{\\Sigma}^{-1}
                              \\left(\\vect{x} - \\vect{\\mu}\\right)
                    \\right),
                \\quad \\vect{x} \\in \\supp{\\vect{X}}

        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle2.Normal_computeDensityGenerator(self, *args)

    def computeDensityGeneratorDerivative(self, *args):
        """
        Compute the first-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator first-order derivative value at input `X`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle2.Normal_computeDensityGeneratorDerivative(self, *args)

    def computeDensityGeneratorSecondDerivative(self, *args):
        """
        Compute the second-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Density generator second-order derivative value at input `X`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle2.Normal_computeDensityGeneratorSecondDerivative(self, *args)

    def getRealization(self):
        """
        Accessor to a pseudo-random realization from the distribution.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, RandomGenerator
        """
        return _dist_bundle2.Normal_getRealization(self)

    def getSample(self, *args):
        """
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator
        """
        return _dist_bundle2.Normal_getSample(self, *args)

    def computeCDF(self, *args):
        """
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.NumericalPoint`
            CDF value(s) at input(s) `X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\\vect{X}}(\\vect{x}) = \\Prob{\\bigcap_{i=1}^n X_i \\leq x_i},
                                     \\quad \\vect{x} \\in \\supp{\\vect{X}}
        """
        return _dist_bundle2.Normal_computeCDF(self, *args)

    def computeCharacteristicFunction(self, *args):
        """
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input `t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \\phi_X(t) = \\mathbb{E}\\left[\\exp(- i t X)\\right],
                        \\quad t \\in \\Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Normal_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        """
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input `t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of `t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Normal_computeLogCharacteristicFunction(self, *args)

    def computeProbability(self, *args):
        """
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\\vect{a}` and
        :math:`\\vect{b}`:

        .. math::

            \\Prob{\\bigcap\\limits_{i=1}^n a_i < X_i \\leq b_i} =
                \\sum\\limits_{\\vect{c}} (-1)^{n(\\vect{c})}
                    F_{\\vect{X}}\\left(\\vect{c}\\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\\vect{c} = \\Tr{(c_i, i = 1, \\ldots, n)}` with :math:`c_i \\in [a_i, b_i]`,
        and :math:`n(\\vect{c})` is the number of components in
        :math:`\\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.Normal_computeProbability(self, *args)

    def computeCDFGradient(self, *args):
        """
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.NumericalPoint`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input `X`.
        """
        return _dist_bundle2.Normal_computeCDFGradient(self, *args)

    def computeRadialDistributionCDF(self, *args):
        """
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \\leq r^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input `r2`.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \\sqrt{\\sum\\limits_{i=1}^n U_i^2}
        """
        return _dist_bundle2.Normal_computeRadialDistributionCDF(self, *args)

    def computeConditionalPDF(self, *args):
        """
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input `Xn`, `Xcond`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.Normal_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        """
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input `Xn`, `Xcond`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \\mid X_1, \\ldots, X_{n - 1}}(x_n) =
                \\Prob{X_n \\leq x_n \\mid X_1=x_1, \\ldots, X_{n-1}=x_{n-1}},
                \\quad x_n \\in \\supp{X_n}
        """
        return _dist_bundle2.Normal_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        """
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditionning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input `p`, `Xcond`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.Normal_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \\leq i \\leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Normal_getMarginal(self, *args)

    def getRoughness(self):
        """
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\\cL^2`-norm of its
        PDF:

        .. math::

            r = \\int_{\\supp{\\vect{X}}} f_{\\vect{X}}(\\vect{x})^2 \\di{\\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle2.Normal_getRoughness(self)

    def getSkewness(self):
        """
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.NumericalPoint`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\delta} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^3},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Normal_getSkewness(self)

    def getKurtosis(self):
        """
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.NumericalPoint`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order centered moment standardized by the standard deviation:

        .. math::

            \\vect{\\kappa} = \\Tr{\\left(\\Expect{\\left(\\frac{X_i - \\mu_i}
                                                         {\\sigma_i}\\right)^4},
                                      \\quad i = 1, \\ldots, n\\right)}
        """
        return _dist_bundle2.Normal_getKurtosis(self)

    def getStandardMoment(self, *args):
        """
        Accessor to the componentwise standard moments.

        Parameters
        ----------
        k : int
            The order of the standard moment.

        Returns
        -------
        m : :class:`~openturns.NumericalPoint`
            Componentwise standard moment of order `k`.

        Notes
        -----
        Standard moments are the raw moments of the standard representative of the parametric family of distributions.

        See Also
        --------
        getStandardRepresentative
        """
        return _dist_bundle2.Normal_getStandardMoment(self, *args)

    def getStandardRepresentative(self):
        """
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Normal_getStandardRepresentative(self)

    def setCorrelation(self, *args): return _dist_bundle2.Normal_setCorrelation(self, *args)
    def getCopula(self):
        """
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        ComposedDistribution
        """
        return _dist_bundle2.Normal_getCopula(self)

    def hasIndependentCopula(self):
        """
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Normal_hasIndependentCopula(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_Normal(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_Normal
    __del__ = lambda self : None;
Normal_swigregister = _dist_bundle2.Normal_swigregister
Normal_swigregister(Normal)

class NormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    """
    Normal factory.

    Available constructor:
        NormalFactory()

    See also
    --------
    DistributionFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormalFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.model_copula.DistributionFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormalFactory, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NormalFactory_getClassName(self)

    def build(self, *args):
        """
        Build the distribution.

        **Available usages**:

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : Collection of :class:`~openturns.NumericalPointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.
        """
        return _dist_bundle2.NormalFactory_build(self, *args)

    def buildAsNormal(self, *args): return _dist_bundle2.NormalFactory_buildAsNormal(self, *args)
    def buildEstimator(self, *args):
        """
        Build the distribution and the parameter distribution.


        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.


        Examples
        --------
        Create a sample from a Beta distribution:

        >>> import openturns as ot
        >>> sample = ot.Beta().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Beta distribution in the native parameters and create a :class:`~openturns.DistributionFactory`:

        >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

        Fit a Beta distribution  in the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

        >>> fittedRes2 = ot.BetaFactory().buildEstimator(sample, ot.BetaMuSigma())
        """
        return _dist_bundle2.NormalFactory_buildEstimator(self, *args)

    def __init__(self, *args): 
        this = _dist_bundle2.new_NormalFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NormalFactory
    __del__ = lambda self : None;
NormalFactory_swigregister = _dist_bundle2.NormalFactory_swigregister
NormalFactory_swigregister(NormalFactory)

class NormalGamma(BayesDistribution):
    """
    NormalGamma distribution.

    Helper class for defining the distribution of the random vector :math:`(X,Y)` where :math:`Y` follows the distribution :math:`\\Gamma(\\alpha, \\beta)` with :math:`\\alpha>0` and :math:`\\beta>0`, :math:`X|Y` follows the distribution :math:`\\mathcal{N}\\left(\\mu, \\dfrac{1}{\\sqrt{\\kappa Y}}\\right)`.

    Available constructor:
       NormalGamma(*mu, kappa, alpha, beta*)

    Parameters
    ----------

    mu : float :math:`\\mu`,
         Mean of the conditioned Normal distribution of :math:`X|Y`.
         Default is :math:`\\mu=0.`

    kappa : float  :math:`\\kappa >0`,
         Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`.
         Default is :math:`\\kappa=1.`

    alpha : float  :math:`\\alpha >0`,
         Shape parameter of the conditioning Gamma distribution of :math:`Y`.
         Default is :math:`\\alpha=1.`

    beta : float  :math:`\\beta >0`,
         Rate parameter of the conditioning Gamma distribution of :math:`Y`.
         Default is :math:`\\beta=1.`


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{(X,Y)}(x,y) = \\dfrac{\\Gamma(\\alpha)}{\\beta^\\alpha}\\sqrt{\\dfrac{2\\pi}{\\kappa}}y^{\\alpha-1/2}\\exp\\left(-\\dfrac{y}{2}\\left[\\kappa(x-\\mu)^2+2\\beta\\right]\\right)

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NormalGamma(1.0, 2.0, 1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """
    __swig_setmethods__ = {}
    for _s in [BayesDistribution]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormalGamma, name, value)
    __swig_getmethods__ = {}
    for _s in [BayesDistribution]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormalGamma, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NormalGamma_getClassName(self)

    def __eq__(self, *args): return _dist_bundle2.NormalGamma___eq__(self, *args)
    def __repr__(self): return _dist_bundle2.NormalGamma___repr__(self)
    def __str__(self, offset=""): return _dist_bundle2.NormalGamma___str__(self, offset)
    def setMu(self, *args):
        """
        Accessor to the parameter mu.

        Parameters
        ----------
        mu : float, :math:`\\mu`,
             Mean of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_setMu(self, *args)

    def getMu(self):
        """
        Accessor to the parameter mu.

        Returns
        -------
        mu : float, :math:`\\mu`,
             Mean of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_getMu(self)

    def setKappa(self, *args):
        """
        Accessor to the parameter kappa.

        Parameters
        ----------
        kappa : float :math:`\\kappa >0`,
                Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_setKappa(self, *args)

    def getKappa(self):
        """
        Accessor to the parameter kappa.

        Returns
        -------
        kappa : float, :math:`\\kappa`, :math:`\\kappa >0`
                Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_getKappa(self)

    def setAlpha(self, *args):
        """
        Accessor to the parameter alpha.

        Parameters
        ----------
        alpha : float,  :math:`\\alpha >0`,
                Shape parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_setAlpha(self, *args)

    def getAlpha(self):
        """
        Accessor to the parameter alpha.

        Returns
        -------
        alpha : float, :math:`\\alpha`, :math:`\\alpha >0`
                Shape parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_getAlpha(self)

    def setBeta(self, *args):
        """
        Accessor to the parameter beta.

        Parameters
        ----------
        beta : float,  :math:`\\beta >0`,
               Rate parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_setBeta(self, *args)

    def getBeta(self):
        """
        Accessor to the parameter beta.

        Returns
        -------
        beta : float, :math:`\\beta`, :math:`\\beta >0`
               Rate parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_getBeta(self)

    def __init__(self, *args): 
        this = _dist_bundle2.new_NormalGamma(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dist_bundle2.delete_NormalGamma
    __del__ = lambda self : None;
NormalGamma_swigregister = _dist_bundle2.NormalGamma_swigregister
NormalGamma_swigregister(NormalGamma)

# This file is compatible with both classic and new-style classes.


