# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Differential algorithms.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_diff', [dirname(__file__)])
        except ImportError:
            import _diff
            return _diff
        if fp is not None:
            try:
                _mod = imp.load_module('_diff', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _diff = swig_import_helper()
    del swig_import_helper
else:
    import _diff
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _diff.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _diff.SwigPyIterator_value(self)
    def incr(self, n=1): return _diff.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _diff.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _diff.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _diff.SwigPyIterator_equal(self, *args)
    def copy(self): return _diff.SwigPyIterator_copy(self)
    def next(self): return _diff.SwigPyIterator_next(self)
    def __next__(self): return _diff.SwigPyIterator___next__(self)
    def previous(self): return _diff.SwigPyIterator_previous(self)
    def advance(self, *args): return _diff.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _diff.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _diff.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _diff.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _diff.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _diff.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _diff.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _diff.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _diff.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
class FiniteDifferenceStepImplementation(openturns.common.PersistentObject):
    """
    Base class to define finite difference steps.

    Available constructors:
        FiniteDifferenceStep(*epsilon=[1.0]*)

    Parameters
    ----------
    epsilon : sequence of float
        Finite difference steps for each dimension.

    Notes
    -----
    Base class to define how finite difference steps are computed.
    Using *FiniteDifferenceStep* is equivalent to use its derived class
    :class:`~openturns.ConstantStep`. Another way to compute steps
    is through its second derived class :class:`~openturns.BlendedStep`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceStepImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceStepImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.FiniteDifferenceStepImplementation_getClassName(self)

    def __repr__(self): return _diff.FiniteDifferenceStepImplementation___repr__(self)
    def setEpsilon(self, *args):
        """
        Set the finite difference steps.

        Parameters
        ----------
        epsilon : sequence of float
            If :class:`~openturns.ConstantStep` : Finite difference steps for each
            dimension.

            If :class:`~openturns.BlendedStep` : Finite difference step factors for
            each dimension.
        """
        return _diff.FiniteDifferenceStepImplementation_setEpsilon(self, *args)

    def getEpsilon(self):
        """
        Get the finite difference steps.

        Returns
        -------
        epsilon : :class:`~openturns.NumericalPoint`
            If :class:`~openturns.ConstantStep` : Finite difference steps for each
            dimension.

            If :class:`~openturns.BlendedStep` : Finite difference step factors for
            each dimension.
        """
        return _diff.FiniteDifferenceStepImplementation_getEpsilon(self)

    def __call__(self, *args): return _diff.FiniteDifferenceStepImplementation___call__(self, *args)
    def __init__(self, *args): 
        this = _diff.new_FiniteDifferenceStepImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_FiniteDifferenceStepImplementation
    __del__ = lambda self : None;
FiniteDifferenceStepImplementation_swigregister = _diff.FiniteDifferenceStepImplementation_swigregister
FiniteDifferenceStepImplementation_swigregister(FiniteDifferenceStepImplementation)

class FiniteDifferenceStepImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceStepImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceStepImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _diff.new_FiniteDifferenceStepImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _diff.FiniteDifferenceStepImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _diff.FiniteDifferenceStepImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _diff.FiniteDifferenceStepImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _diff.FiniteDifferenceStepImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _diff.delete_FiniteDifferenceStepImplementationTypedInterfaceObject
    __del__ = lambda self : None;
FiniteDifferenceStepImplementationTypedInterfaceObject_swigregister = _diff.FiniteDifferenceStepImplementationTypedInterfaceObject_swigregister
FiniteDifferenceStepImplementationTypedInterfaceObject_swigregister(FiniteDifferenceStepImplementationTypedInterfaceObject)

class FiniteDifferenceStep(FiniteDifferenceStepImplementationTypedInterfaceObject):
    """
    Base class to define finite difference steps.

    Available constructors:
        FiniteDifferenceStep(*epsilon=[1.0]*)

    Parameters
    ----------
    epsilon : sequence of float
        Finite difference steps for each dimension.

    Notes
    -----
    Base class to define how finite difference steps are computed.
    Using *FiniteDifferenceStep* is equivalent to use its derived class
    :class:`~openturns.ConstantStep`. Another way to compute steps
    is through its second derived class :class:`~openturns.BlendedStep`.
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceStepImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceStep, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceStepImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceStep, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.FiniteDifferenceStep_getClassName(self)

    def __repr__(self): return _diff.FiniteDifferenceStep___repr__(self)
    def setEpsilon(self, *args):
        """
        Set the finite difference steps.

        Parameters
        ----------
        epsilon : sequence of float
            If :class:`~openturns.ConstantStep` : Finite difference steps for each
            dimension.

            If :class:`~openturns.BlendedStep` : Finite difference step factors for
            each dimension.
        """
        return _diff.FiniteDifferenceStep_setEpsilon(self, *args)

    def getEpsilon(self):
        """
        Get the finite difference steps.

        Returns
        -------
        epsilon : :class:`~openturns.NumericalPoint`
            If :class:`~openturns.ConstantStep` : Finite difference steps for each
            dimension.

            If :class:`~openturns.BlendedStep` : Finite difference step factors for
            each dimension.
        """
        return _diff.FiniteDifferenceStep_getEpsilon(self)

    def __call__(self, *args): return _diff.FiniteDifferenceStep___call__(self, *args)
    def __init__(self, *args): 
        this = _diff.new_FiniteDifferenceStep(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_FiniteDifferenceStep
    __del__ = lambda self : None;
FiniteDifferenceStep_swigregister = _diff.FiniteDifferenceStep_swigregister
FiniteDifferenceStep_swigregister(FiniteDifferenceStep)

class ConstantStep(FiniteDifferenceStepImplementation):
    """
    Constant step.

    Available constructors:
        ConstantStep(*epsilon=[1.0]*)

    Parameters
    ----------
    epsilon : sequence of float
        Finite difference steps for each dimension.

    Notes
    -----
    *ConstantStep* defines a list of constant finite difference steps equal to
    *epsilon*.

    See also
    --------
    BlendedStep

    Examples
    --------
    >>> import openturns as ot
    >>> epsilon = [1e-4, 2e-4]
    >>> steps = ot.ConstantStep(epsilon)
    >>> print(steps([2.0]*2))
    [0.0001,0.0002]
    >>> print(steps([0.0, 3.0]))
    [0.0001,0.0002]
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceStepImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantStep, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceStepImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantStep, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.ConstantStep_getClassName(self)

    def __repr__(self): return _diff.ConstantStep___repr__(self)
    def __call__(self, *args): return _diff.ConstantStep___call__(self, *args)
    def __init__(self, *args): 
        this = _diff.new_ConstantStep(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_ConstantStep
    __del__ = lambda self : None;
ConstantStep_swigregister = _diff.ConstantStep_swigregister
ConstantStep_swigregister(ConstantStep)

class BlendedStep(FiniteDifferenceStepImplementation):
    """
    Blended step.

    Available constructors:
        BlendedStep(*epsilon, eta=1.0*)

    Parameters
    ----------
    epsilon : sequence of float
        Finite difference step factors for each dimension.
    eta : positive float, sequence of positive float with the same dimension as *epsilon*
        Finite difference step offsets for each dimension.

    Notes
    -----
    *BlendedStep* defines a list of finite difference steps equal to:
    *epsilon (|x| + eta)*.

    See also
    --------
    ConstantStep

    Examples
    --------
    >>> import openturns as ot
    >>> epsilon = [1e-4, 2e-4]
    >>> x = [2.0]*2
    >>> steps = ot.BlendedStep(epsilon)
    >>> print(steps(x))
    [0.0003,0.0006]
    >>> steps = ot.BlendedStep(epsilon, 0.0)
    >>> print(steps(x))
    [0.0002,0.0004]
    >>> steps = ot.BlendedStep(epsilon, [1.0, 2.0])
    >>> print(steps(x))
    [0.0003,0.0008]
    >>> steps = ot.BlendedStep(epsilon, 2.0)
    >>> print(steps(x))
    [0.0004,0.0008]
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceStepImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlendedStep, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceStepImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlendedStep, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.BlendedStep_getClassName(self)

    def __repr__(self): return _diff.BlendedStep___repr__(self)
    def __call__(self, *args): return _diff.BlendedStep___call__(self, *args)
    def setEta(self, *args):
        """
        Set the finite difference step offsets.

        Parameters
        ----------
        eta : sequence of positive float
            Finite difference step offsets for each dimension.
        """
        return _diff.BlendedStep_setEta(self, *args)

    def getEta(self):
        """
        Get the finite difference step offsets.

        Returns
        -------
        eta : :class:`~openturns.NumericalPoint`
            Finite difference step offsets for each dimension.
        """
        return _diff.BlendedStep_getEta(self)

    def __init__(self, *args): 
        this = _diff.new_BlendedStep(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_BlendedStep
    __del__ = lambda self : None;
BlendedStep_swigregister = _diff.BlendedStep_swigregister
BlendedStep_swigregister(BlendedStep)

class FiniteDifferenceGradient(openturns.func.NumericalMathGradientImplementation):
    """
    Base class for first order finite-difference schemes.

    Available constructors:
        FiniteDifferenceGradient(*epsilon, evalImpl*)

        FiniteDifferenceGradient(*step, evalImpl*)

    Parameters
    ----------
    evalImpl : :class:`~openturns.NumericalMathEvaluationImplementation`
        Implementation of the evaluation of a function.
    epsilon : float, sequence of float
        Finite difference steps for each dimension.
    step : :class:`~openturns.FiniteDifferenceStep`
        Defines how finite difference steps values are computed.

    Notes
    -----
    Base class to define first order finite-difference schemes. The gradient
    can be computed only through its derived classes:

    - :class:`~openturns.CenteredFiniteDifferenceGradient`,

    - :class:`~openturns.NonCenteredFiniteDifferenceGradient`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGradient, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.FiniteDifferenceGradient_getClassName(self)

    def __eq__(self, *args): return _diff.FiniteDifferenceGradient___eq__(self, *args)
    def __repr__(self): return _diff.FiniteDifferenceGradient___repr__(self)
    def getInputDimension(self):
        """
        Get the input dimension.

        Returns
        -------
        dimension : int
            Input dimension.
        """
        return _diff.FiniteDifferenceGradient_getInputDimension(self)

    def getOutputDimension(self):
        """
        Get the output dimension.

        Returns
        -------
        dimension : int
            Output dimension.
        """
        return _diff.FiniteDifferenceGradient_getOutputDimension(self)

    def getEpsilon(self):
        """
        Get the finite difference steps.

        Returns
        -------
        epsilon : :class:`~openturns.NumericalPoint`
            Finite difference steps for each dimension.
        """
        return _diff.FiniteDifferenceGradient_getEpsilon(self)

    def getEvaluation(self):
        """
        Get the implementation of the evaluation of the function.

        Returns
        -------
        evalImpl : :class:`~openturns.NumericalMathFunctionEvaluationImplementation`
            Implementation of the evaluation of a function.
        """
        return _diff.FiniteDifferenceGradient_getEvaluation(self)

    def setFiniteDifferenceStep(self, *args):
        """
        Set the finite difference step.

        Parameters
        ----------
        step : :class:`~openturns.FiniteDifferenceStep`
            Defines how finite difference steps values are computed.
        """
        return _diff.FiniteDifferenceGradient_setFiniteDifferenceStep(self, *args)

    def getFiniteDifferenceStep(self):
        """
        Get the finite difference step.

        Returns
        -------
        step : :class:`~openturns.FiniteDifferenceStep`
            Defines how finite difference steps values are computed.
        """
        return _diff.FiniteDifferenceGradient_getFiniteDifferenceStep(self)

    def gradient(self, *args):
        """
        Get the gradient at some point.

        Parameters
        ----------
        point : sequence of float
            Point where the gradient is computed.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Transposed Jacobian matrix evaluated at *point*.
        """
        return _diff.FiniteDifferenceGradient_gradient(self, *args)

    def __init__(self, *args): 
        this = _diff.new_FiniteDifferenceGradient(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_FiniteDifferenceGradient
    __del__ = lambda self : None;
FiniteDifferenceGradient_swigregister = _diff.FiniteDifferenceGradient_swigregister
FiniteDifferenceGradient_swigregister(FiniteDifferenceGradient)

class FiniteDifferenceHessian(openturns.func.NumericalMathHessianImplementation):
    """
    Base class for second order centered finite-difference scheme.

    Available constructors:
        FiniteDifferenceHessian(*epsilon, evalImpl*)

        FiniteDifferenceHessian(*step, evalImpl*)

    Parameters
    ----------
    evalImpl : :class:`~openturns.NumericalMathEvaluationImplementation`
        Implementation of the evaluation of a function.
    epsilon : float, sequence of float
        Finite difference steps for each dimension.
    step : :class:`~openturns.FiniteDifferenceStep`
        Defines how finite difference steps values are computed.

    Notes
    -----
    Base class to define second order finite-difference scheme. The hessian
    can be computed only through its derived class:

    - :class:`~openturns.CenteredFiniteDifferenceHessian`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceHessian, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.FiniteDifferenceHessian_getClassName(self)

    def __eq__(self, *args): return _diff.FiniteDifferenceHessian___eq__(self, *args)
    def __repr__(self): return _diff.FiniteDifferenceHessian___repr__(self)
    def getInputDimension(self):
        """
        Get the input dimension.

        Returns
        -------
        dimension : int
            Input dimension.
        """
        return _diff.FiniteDifferenceHessian_getInputDimension(self)

    def getOutputDimension(self):
        """
        Get the output dimension.

        Returns
        -------
        dimension : int
            Output dimension.
        """
        return _diff.FiniteDifferenceHessian_getOutputDimension(self)

    def getEpsilon(self):
        """
        Get the finite difference steps.

        Returns
        -------
        epsilon : :class:`~openturns.NumericalPoint`
            Finite difference steps for each dimension.
        """
        return _diff.FiniteDifferenceHessian_getEpsilon(self)

    def getEvaluation(self):
        """
        Get the implementation of the evaluation of the function.

        Returns
        -------
        evalImpl : :class:`~openturns.NumericalMathFunctionEvaluationImplementation`
            Implementation of the evaluation of a function.
        """
        return _diff.FiniteDifferenceHessian_getEvaluation(self)

    def setFiniteDifferenceStep(self, *args):
        """
        Set the finite difference step.

        Parameters
        ----------
        step : :class:`~openturns.FiniteDifferenceStep`
            Defines how finite difference steps values are computed.
        """
        return _diff.FiniteDifferenceHessian_setFiniteDifferenceStep(self, *args)

    def getFiniteDifferenceStep(self):
        """
        Get the finite difference step.

        Returns
        -------
        step : :class:`~openturns.FiniteDifferenceStep`
            Defines how finite difference steps values are computed.
        """
        return _diff.FiniteDifferenceHessian_getFiniteDifferenceStep(self)

    def hessian(self, *args):
        """
        Get the hessian at some point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian is computed.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian evaluated at *point*.
        """
        return _diff.FiniteDifferenceHessian_hessian(self, *args)

    def __init__(self, *args): 
        this = _diff.new_FiniteDifferenceHessian(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_FiniteDifferenceHessian
    __del__ = lambda self : None;
FiniteDifferenceHessian_swigregister = _diff.FiniteDifferenceHessian_swigregister
FiniteDifferenceHessian_swigregister(FiniteDifferenceHessian)

class CenteredFiniteDifferenceGradient(FiniteDifferenceGradient):
    """
    First order centered finite-difference scheme.

    Available constructors:
        CenteredFiniteDifferenceGradient(*epsilon, evalImpl*)

        CenteredFiniteDifferenceGradient(*step, evalImpl*)

    Parameters
    ----------
    evalImpl : :class:`~openturns.NumericalMathEvaluationImplementation`
        Implementation of the evaluation of a function.
    epsilon : float, sequence of float
        Finite difference steps for each dimension.
    step : :class:`~openturns.FiniteDifferenceStep`
        Defines how finite difference steps values are computed.

    Notes
    -----
    *CenteredFiniteDifferenceGradient* provides a first order centered finite-
    difference scheme:

    .. math::

      \\frac{\\partial f_j}{\\partial x_i} \\approx \\frac{f_j(x + \\epsilon_i) - f_j(x - \\epsilon_i)}
                                                     {2 \\epsilon_i}

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.NumericalMathFunction(['x1', 'x2'], ['y1', 'y2', 'y3'], formulas)
    >>> epsilon = [0.01]*2
    >>> myGradient = ot.CenteredFiniteDifferenceGradient(epsilon, myFunc.getEvaluation())
    >>> inPoint = [1.]*2
    >>> print(myGradient.gradient(inPoint))
    [[  0.841471 -0.909282  0.735771 ]
     [  0.540293 -0.909282 -1.10366  ]]
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceGradient]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CenteredFiniteDifferenceGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceGradient]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CenteredFiniteDifferenceGradient, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.CenteredFiniteDifferenceGradient_getClassName(self)

    def __repr__(self): return _diff.CenteredFiniteDifferenceGradient___repr__(self)
    def __str__(self, offset=""): return _diff.CenteredFiniteDifferenceGradient___str__(self, offset)
    def gradient(self, *args):
        """
        Get the gradient at some point.

        Parameters
        ----------
        point : sequence of float
            Point where the gradient is computed.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Transposed Jacobian matrix evaluated at *point*.
        """
        return _diff.CenteredFiniteDifferenceGradient_gradient(self, *args)

    def __init__(self, *args): 
        this = _diff.new_CenteredFiniteDifferenceGradient(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_CenteredFiniteDifferenceGradient
    __del__ = lambda self : None;
CenteredFiniteDifferenceGradient_swigregister = _diff.CenteredFiniteDifferenceGradient_swigregister
CenteredFiniteDifferenceGradient_swigregister(CenteredFiniteDifferenceGradient)

class CenteredFiniteDifferenceHessian(FiniteDifferenceHessian):
    """
    Second order centered finite-difference scheme.

    Available constructors:
        CenteredFiniteDifferenceHessian(*epsilon, evalImpl*)

        CenteredFiniteDifferenceHessian(*step, evalImpl*)

    Parameters
    ----------
    evalImpl : :class:`~openturns.NumericalMathEvaluationImplementation`
        Implementation of the evaluation of a function.
    epsilon : float, sequence of float
        Finite difference steps for each dimension.
    step : :class:`~openturns.FiniteDifferenceStep`
        Defines how finite difference steps values are computed.

    Notes
    -----
    *CenteredFiniteDifferenceHessian* provides a second order centered finite-
    difference scheme:

    .. math::

      \\frac{\\partial^2 f_k}{\\partial x_i \\partial x_j} \\approx
                                         \\frac{
                                            f_k(x + \\epsilon_i + \\epsilon_j) -
                                            f_k(x + \\epsilon_i - \\epsilon_j) +
                                            f_k(x - \\epsilon_i - \\epsilon_j) -
                                            f_k(x - \\epsilon_i + \\epsilon_j)}
                                         {4 \\epsilon_i \\epsilon_j}

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.NumericalMathFunction(['x1', 'x2'], ['y1', 'y2', 'y3'], formulas)
    >>> epsilon = [0.01]*2
    >>> myHessian = ot.CenteredFiniteDifferenceHessian(epsilon, myFunc.getEvaluation())
    >>> inPoint = [1.0]*2
    >>> print(myHessian.hessian(inPoint))
    sheet #0
    [[  0         0.540293 ]
     [  0.540293 -0.841443 ]]
    sheet #1
    [[  0.416133  0.416133 ]
     [  0.416133  0.416133 ]]
    sheet #2
    [[  0.735783 -1.10368  ]
     [ -1.10368   1.47152  ]]
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceHessian]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CenteredFiniteDifferenceHessian, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceHessian]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CenteredFiniteDifferenceHessian, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.CenteredFiniteDifferenceHessian_getClassName(self)

    def __eq__(self, *args): return _diff.CenteredFiniteDifferenceHessian___eq__(self, *args)
    def __repr__(self): return _diff.CenteredFiniteDifferenceHessian___repr__(self)
    def __str__(self, offset=""): return _diff.CenteredFiniteDifferenceHessian___str__(self, offset)
    def hessian(self, *args):
        """
        Get the hessian at some point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian is computed.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian evaluated at *point*.
        """
        return _diff.CenteredFiniteDifferenceHessian_hessian(self, *args)

    def __init__(self, *args): 
        this = _diff.new_CenteredFiniteDifferenceHessian(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_CenteredFiniteDifferenceHessian
    __del__ = lambda self : None;
CenteredFiniteDifferenceHessian_swigregister = _diff.CenteredFiniteDifferenceHessian_swigregister
CenteredFiniteDifferenceHessian_swigregister(CenteredFiniteDifferenceHessian)

class NonCenteredFiniteDifferenceGradient(FiniteDifferenceGradient):
    """
    First order non-centered finite-difference scheme.

    Available constructors:
        NonCenteredFiniteDifferenceGradient(*epsilon, evalImpl*)

        NonCenteredFiniteDifferenceGradient(*step, evalImpl*)

    Parameters
    ----------
    evalImpl : :class:`~openturns.NumericalMathEvaluationImplementation`
        Implementation of the evaluation of a function.
    epsilon : float, sequence of float
        Finite difference steps for each dimension.
    step : :class:`~openturns.FiniteDifferenceStep`
        Defines how finite difference steps values are computed.

    Notes
    -----
    *NonCenteredFiniteDifferenceGradient* provides a first order non-centered
    finite-difference scheme:

    .. math::

        \\frac{\\partial f_j}{\\partial x_i} \\approx \\frac{f_j(x + \\epsilon_i) - f_j(x)}
                                                       {\\epsilon_i}

    Examples
    --------
    >>> import openturns as ot
    >>> formulas = ['x1 * sin(x2)', 'cos(x1 + x2)', '(x2 + 1) * exp(x1 - 2 * x2)']
    >>> myFunc = ot.NumericalMathFunction(['x1', 'x2'], ['y1', 'y2', 'y3'], formulas)
    >>> epsilon = [0.01]*2
    >>> myGradient = ot.NonCenteredFiniteDifferenceGradient(epsilon, myFunc.getEvaluation())
    >>> inPoint = [1.0]*2
    >>> print(myGradient.gradient(inPoint))
    [[  0.841471 -0.907202  0.73945  ]
     [  0.536086 -0.907202 -1.09631  ]]
    """
    __swig_setmethods__ = {}
    for _s in [FiniteDifferenceGradient]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NonCenteredFiniteDifferenceGradient, name, value)
    __swig_getmethods__ = {}
    for _s in [FiniteDifferenceGradient]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NonCenteredFiniteDifferenceGradient, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _diff.NonCenteredFiniteDifferenceGradient_getClassName(self)

    def __repr__(self): return _diff.NonCenteredFiniteDifferenceGradient___repr__(self)
    def __str__(self, offset=""): return _diff.NonCenteredFiniteDifferenceGradient___str__(self, offset)
    def gradient(self, *args):
        """
        Get the gradient at some point.

        Parameters
        ----------
        point : sequence of float
            Point where the gradient is computed.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Transposed Jacobian matrix evaluated at *point*.
        """
        return _diff.NonCenteredFiniteDifferenceGradient_gradient(self, *args)

    def __init__(self, *args): 
        this = _diff.new_NonCenteredFiniteDifferenceGradient(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _diff.delete_NonCenteredFiniteDifferenceGradient
    __del__ = lambda self : None;
NonCenteredFiniteDifferenceGradient_swigregister = _diff.NonCenteredFiniteDifferenceGradient_swigregister
NonCenteredFiniteDifferenceGradient_swigregister(NonCenteredFiniteDifferenceGradient)

# This file is compatible with both classic and new-style classes.


