# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Statistical tests.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_stattests', [dirname(__file__)])
        except ImportError:
            import _stattests
            return _stattests
        if fp is not None:
            try:
                _mod = imp.load_module('_stattests', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _stattests = swig_import_helper()
    del swig_import_helper
else:
    import _stattests
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _stattests.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _stattests.SwigPyIterator_value(self)
    def incr(self, n=1): return _stattests.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _stattests.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _stattests.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _stattests.SwigPyIterator_equal(self, *args)
    def copy(self): return _stattests.SwigPyIterator_copy(self)
    def next(self): return _stattests.SwigPyIterator_next(self)
    def __next__(self): return _stattests.SwigPyIterator___next__(self)
    def previous(self): return _stattests.SwigPyIterator_previous(self)
    def advance(self, *args): return _stattests.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _stattests.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _stattests.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _stattests.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _stattests.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _stattests.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _stattests.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _stattests.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _stattests.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
class VisualTest(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VisualTest, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VisualTest, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def DrawEmpiricalCDF(*args):
        """
        Draw an empirical CDF as an OpenTURNS :class:`~openturns.Graph`.

        Available usages:
            VisualTest.DrawEmpiricalCDF(*sample, Xmin, Xmax*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample to draw.
        Xmin, Xmax : float with *Xmin < Xmax*
            Lower and upper boundaries of the graph.

        Notes
        -----
        The created graph contains a staircase curve which is the empirical CDF of the
        sample.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View

        Generate a random sample from a Normal distribution:

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(1).getSample(100)
        >>> Xmin = sample.getMin()[0]
        >>> Xmax = sample.getMax()[0]

        Draw an empirical CDF:

        >>> empiricalCDF = ot.VisualTest.DrawEmpiricalCDF(sample, Xmin - 1.0, Xmax + 1.0)
        >>> View(empiricalCDF).show()
        """
        return _stattests.VisualTest_DrawEmpiricalCDF(*args)

    if _newclass:DrawEmpiricalCDF = staticmethod(DrawEmpiricalCDF)
    __swig_getmethods__["DrawEmpiricalCDF"] = lambda x: DrawEmpiricalCDF
    def DrawHistogram(*args):
        """
        Draw an histogram as an OpenTURNS :class:`~openturns.Graph`.

        Available usages:
            VisualTest.DrawHistogram(*sample*)

            VisualTest.DrawHistogram(*sample, barsNumber*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample to draw.
        barsNumber : positive int
            Number of barplots used to draw the histogram. If not specified, it is
            automatically determined by OpenTURNS according to the Silverman rule.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View

        Generate a random sample from a Normal distribution:

        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample = ot.Normal(1).getSample(100)

        Draw an histogram:

        >>> hist = ot.VisualTest.DrawHistogram(sample)
        >>> View(hist).show()
        """
        return _stattests.VisualTest_DrawHistogram(*args)

    if _newclass:DrawHistogram = staticmethod(DrawHistogram)
    __swig_getmethods__["DrawHistogram"] = lambda x: DrawHistogram
    def DrawQQplot(*args):
        """
        Draw a QQ-plot as an OpenTURNS :class:`~openturns.Graph`.

        Available usages:
            VisualTest.DrawQQplot(*sample1, sample2, n_points*)

            VisualTest.DrawQQplot(*sample1, distribution*);

        Parameters
        ----------
        sample1, sample2 : 2-d sequences of float
            Tested samples.
        ditribution : :class:`~openturns.Distribution`
            Tested model.
        n_points : int, optional
            The number of points that is used for interpolating the empirical CDF of
            the two samples (with possibly different sizes).

            It will default to *DistributionImplementation-DefaultPointNumber* from
            the :class:`~openturns.ResourceMap`.

        Notes
        -----
        The QQ-plot is a visual fitting test for univariate distributions. It
        opposes the sample quantiles to those of the tested quantity (either a
        distribution or another sample) by plotting the following points cloud:

        .. math::

            \\left(x^{(i)},
                  \\theta\\left(\\widehat{F}\\left(x^{(i)}\\right)\\right)
            \\right), \\quad i = 1, \\ldots, m

        where :math:`\\widehat{F}` denotes the empirical CDF of the (first) tested
        sample and :math:`\\theta` denotes either the quantile function of the tested
        distribution or the empirical quantile function of the second tested sample.

        If the given sample fits to the tested distribution or sample, then the points
        should be close to be aligned (up to the uncertainty associated with the
        estimation of the empirical probabilities) with the **first bissector**  whose
        equation reads:

        .. math::

            y = x, \\quad x \\in \\Rset

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View

        Generate a random sample from a Normal distribution:

        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Weibull(2.0, 0.5)
        >>> sample = distribution.getSample(30)
        >>> sample.setDescription(['Sample'])

        Draw a QQ-plot against a given (inferred) distribution:

        >>> tested_distribution = ot.WeibullFactory().build(sample)
        >>> QQ_plot = ot.VisualTest.DrawQQplot(sample, tested_distribution)
        >>> View(QQ_plot).show()

        Draw a two-sample QQ-plot:

        >>> another_sample = distribution.getSample(50)
        >>> another_sample.setDescription(['Another sample'])
        >>> QQ_plot = ot.VisualTest.DrawQQplot(sample, another_sample)
        >>> View(QQ_plot).show()
        """
        return _stattests.VisualTest_DrawQQplot(*args)

    if _newclass:DrawQQplot = staticmethod(DrawQQplot)
    __swig_getmethods__["DrawQQplot"] = lambda x: DrawQQplot
    def DrawHenryLine(*args):
        """
        Draw an Henry plot as an OpenTURNS :class:`~openturns.Graph`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested (univariate) sample.
        normal_distribution : :class:`~openturns.Normal`, optional
            Tested (univariate) normal distribution.

            If not given, this will build a :class:`~openturns.Normal` distribution
            from the given sample using the :class:`~openturns.NormalFactory`.

        Notes
        -----
        The Henry plot is a visual fitting test for the normal distribution. It
        opposes the sample quantiles to those of the standard normal distribution
        (the one with zero mean and unit variance) by plotting the following points
        could:

        .. math::

            \\left(x^{(i)},
                  \\Phi^{-1}\\left(\\widehat{F}\\left(x^{(i)}\\right)\\right)
            \\right), \\quad i = 1, \\ldots, m

        where :math:`\\widehat{F}` denotes the empirical CDF of the sample and
        :math:`\\Phi^{-1}` denotes the quantile function of the standard normal
        distribution.

        If the given sample fits to the tested normal distribution (with mean
        :math:`\\mu` and standard deviation :math:`\\sigma`), then the points should be
        close to be aligned (up to the uncertainty associated with the estimation
        of the empirical probabilities) on the **Henry line** whose equation reads:

        .. math::

            y = \\frac{x - \\mu}{\\sigma}, \\quad x \\in \\Rset

        The Henry plot is a special case of the more general QQ-plot.

        See Also
        --------
        VisualTest_DrawQQplot, FittingTest_Kolmogorov

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View

        Generate a random sample from a Normal distribution:

        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal(2.0, 0.5)
        >>> sample = distribution.getSample(30)

        Draw an Henry plot against a given (wrong) Normal distribution:

        >>> henry_graph = ot.VisualTest.DrawHenryLine(sample, distribution)
        >>> henry_graph.setTitle('Henry plot against given %s' % ot.Normal(3.0, 1.0))
        >>> View(henry_graph).show()

        Draw an Henry plot against an inferred Normal distribution:

        >>> henry_graph = ot.VisualTest.DrawHenryLine(sample)
        >>> henry_graph.setTitle('Henry plot against inferred Normal distribution')
        >>> View(henry_graph).show()
        """
        return _stattests.VisualTest_DrawHenryLine(*args)

    if _newclass:DrawHenryLine = staticmethod(DrawHenryLine)
    __swig_getmethods__["DrawHenryLine"] = lambda x: DrawHenryLine
    __swig_getmethods__["DrawClouds"] = lambda x: _stattests.VisualTest_DrawClouds
    if _newclass:DrawClouds = staticmethod(_stattests.VisualTest_DrawClouds)
    __swig_getmethods__["DrawLinearModel"] = lambda x: _stattests.VisualTest_DrawLinearModel
    if _newclass:DrawLinearModel = staticmethod(_stattests.VisualTest_DrawLinearModel)
    __swig_getmethods__["DrawLinearModelResidual"] = lambda x: _stattests.VisualTest_DrawLinearModelResidual
    if _newclass:DrawLinearModelResidual = staticmethod(_stattests.VisualTest_DrawLinearModelResidual)
    def DrawCobWeb(*args):
        """
        Draw a Cobweb plot as an OpenTURNS :class:`~openturns.Graph`.

        Available usages:
            VisualTest.DrawCobWeb(*inputSample, outputSample, min, max, color, quantileScale=True*)

        Parameters
        ----------
        inputSample : 2-d sequence of float of dimension :math:`n`
            Input sample :math:`\\vect{X}`.
        outputSample : 2-d sequence of float of dimension :math:`1`
            Output sample :math:`Y`.
        Ymin, Ymax : float such that *Ymax > Ymin*
            Values to select lines which will colore in *color*. Must be in
            :math:`[0,1]` if *quantileScale=True*.
        color : str
            Color of the specified curves.
        quantileScale : bool
            Flag indicating the scale of the *Ymin* and *Ymax*. If
            *quantileScale=True*, they are expressed in the rank based scale;
            otherwise, they are expressed in the :math:`Y`-values scale.

        Notes
        -----
        Let's suppose a model :math:`f: \\Rset^n \\mapsto \\Rset`, where
        :math:`f(\\vect{X})=Y`.
        The Cobweb graph enables to visualize all the combinations of the input
        variables which lead to a specific range of the output variable.

        Each column represents one component :math:`X_i` of the input vector
        :math:`\\vect{X}`. The last column represents the scalar output variable
        :math:`Y`.

        For each point :math:`\\vect{X}^j` of *inputSample*, each component :math:`X_i^j`
        is noted on its respective axe and the last mark is the one which corresponds
        to the associated :math:`Y^j`. A line joins all the marks. Thus, each point of
        the sample corresponds to a particular line on the graph.

        The scale of the axes are quantile based : each axe runs between 0 and 1 and
        each value is represented by its quantile with respect to its marginal
        empirical distribution.

        It is interesting to select, among those lines, the ones which correspond to a
        specific range of the output variable. These particular lines selected are
        colored differently in *color*. This specific range is defined with *Ymin* and
        *Ymax* in the quantile based scale of :math:`Y` or in its specific scale. In
        that second case, the range is automatically converted into a quantile based
        scale range.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View

        Generate a random sample from a Normal distribution:

        >>> ot.RandomGenerator.SetSeed(0)
        >>> inputSample = ot.Normal(2).getSample(15)
        >>> inputSample.setDescription(['X0', 'X1'])
        >>> formula = ['cos(X0)+cos(2*X1)']
        >>> model = ot.NumericalMathFunction(['X0', 'X1'], ['y'], formula)
        >>> outputSample = model(inputSample)

        Draw a Cobweb plot:

        >>> cobweb = ot.VisualTest.DrawCobWeb(inputSample, outputSample, 1.0, 2.0, 'red', False)
        >>> View(cobweb).show()
        """
        return _stattests.VisualTest_DrawCobWeb(*args)

    if _newclass:DrawCobWeb = staticmethod(DrawCobWeb)
    __swig_getmethods__["DrawCobWeb"] = lambda x: DrawCobWeb
    __swig_getmethods__["DrawKendallPlot"] = lambda x: _stattests.VisualTest_DrawKendallPlot
    if _newclass:DrawKendallPlot = staticmethod(_stattests.VisualTest_DrawKendallPlot)
    __swig_destroy__ = _stattests.delete_VisualTest
    __del__ = lambda self : None;
VisualTest_swigregister = _stattests.VisualTest_swigregister
VisualTest_swigregister(VisualTest)

def VisualTest_DrawEmpiricalCDF(*args):
  """
    Draw an empirical CDF as an OpenTURNS :class:`~openturns.Graph`.

    Available usages:
        VisualTest.DrawEmpiricalCDF(*sample, Xmin, Xmax*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Sample to draw.
    Xmin, Xmax : float with *Xmin < Xmax*
        Lower and upper boundaries of the graph.

    Notes
    -----
    The created graph contains a staircase curve which is the empirical CDF of the
    sample.

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.viewer import View

    Generate a random sample from a Normal distribution:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal(1).getSample(100)
    >>> Xmin = sample.getMin()[0]
    >>> Xmax = sample.getMax()[0]

    Draw an empirical CDF:

    >>> empiricalCDF = ot.VisualTest.DrawEmpiricalCDF(sample, Xmin - 1.0, Xmax + 1.0)
    >>> View(empiricalCDF).show()
    """
  return _stattests.VisualTest_DrawEmpiricalCDF(*args)

def VisualTest_DrawHistogram(*args):
  """
    Draw an histogram as an OpenTURNS :class:`~openturns.Graph`.

    Available usages:
        VisualTest.DrawHistogram(*sample*)

        VisualTest.DrawHistogram(*sample, barsNumber*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Sample to draw.
    barsNumber : positive int
        Number of barplots used to draw the histogram. If not specified, it is
        automatically determined by OpenTURNS according to the Silverman rule.

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.viewer import View

    Generate a random sample from a Normal distribution:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal(1).getSample(100)

    Draw an histogram:

    >>> hist = ot.VisualTest.DrawHistogram(sample)
    >>> View(hist).show()
    """
  return _stattests.VisualTest_DrawHistogram(*args)

def VisualTest_DrawQQplot(*args):
  """
    Draw a QQ-plot as an OpenTURNS :class:`~openturns.Graph`.

    Available usages:
        VisualTest.DrawQQplot(*sample1, sample2, n_points*)

        VisualTest.DrawQQplot(*sample1, distribution*);

    Parameters
    ----------
    sample1, sample2 : 2-d sequences of float
        Tested samples.
    ditribution : :class:`~openturns.Distribution`
        Tested model.
    n_points : int, optional
        The number of points that is used for interpolating the empirical CDF of
        the two samples (with possibly different sizes).

        It will default to *DistributionImplementation-DefaultPointNumber* from
        the :class:`~openturns.ResourceMap`.

    Notes
    -----
    The QQ-plot is a visual fitting test for univariate distributions. It
    opposes the sample quantiles to those of the tested quantity (either a
    distribution or another sample) by plotting the following points cloud:

    .. math::

        \\left(x^{(i)},
              \\theta\\left(\\widehat{F}\\left(x^{(i)}\\right)\\right)
        \\right), \\quad i = 1, \\ldots, m

    where :math:`\\widehat{F}` denotes the empirical CDF of the (first) tested
    sample and :math:`\\theta` denotes either the quantile function of the tested
    distribution or the empirical quantile function of the second tested sample.

    If the given sample fits to the tested distribution or sample, then the points
    should be close to be aligned (up to the uncertainty associated with the
    estimation of the empirical probabilities) with the **first bissector**  whose
    equation reads:

    .. math::

        y = x, \\quad x \\in \\Rset

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.viewer import View

    Generate a random sample from a Normal distribution:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Weibull(2.0, 0.5)
    >>> sample = distribution.getSample(30)
    >>> sample.setDescription(['Sample'])

    Draw a QQ-plot against a given (inferred) distribution:

    >>> tested_distribution = ot.WeibullFactory().build(sample)
    >>> QQ_plot = ot.VisualTest.DrawQQplot(sample, tested_distribution)
    >>> View(QQ_plot).show()

    Draw a two-sample QQ-plot:

    >>> another_sample = distribution.getSample(50)
    >>> another_sample.setDescription(['Another sample'])
    >>> QQ_plot = ot.VisualTest.DrawQQplot(sample, another_sample)
    >>> View(QQ_plot).show()
    """
  return _stattests.VisualTest_DrawQQplot(*args)

def VisualTest_DrawHenryLine(*args):
  """
    Draw an Henry plot as an OpenTURNS :class:`~openturns.Graph`.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested (univariate) sample.
    normal_distribution : :class:`~openturns.Normal`, optional
        Tested (univariate) normal distribution.

        If not given, this will build a :class:`~openturns.Normal` distribution
        from the given sample using the :class:`~openturns.NormalFactory`.

    Notes
    -----
    The Henry plot is a visual fitting test for the normal distribution. It
    opposes the sample quantiles to those of the standard normal distribution
    (the one with zero mean and unit variance) by plotting the following points
    could:

    .. math::

        \\left(x^{(i)},
              \\Phi^{-1}\\left(\\widehat{F}\\left(x^{(i)}\\right)\\right)
        \\right), \\quad i = 1, \\ldots, m

    where :math:`\\widehat{F}` denotes the empirical CDF of the sample and
    :math:`\\Phi^{-1}` denotes the quantile function of the standard normal
    distribution.

    If the given sample fits to the tested normal distribution (with mean
    :math:`\\mu` and standard deviation :math:`\\sigma`), then the points should be
    close to be aligned (up to the uncertainty associated with the estimation
    of the empirical probabilities) on the **Henry line** whose equation reads:

    .. math::

        y = \\frac{x - \\mu}{\\sigma}, \\quad x \\in \\Rset

    The Henry plot is a special case of the more general QQ-plot.

    See Also
    --------
    VisualTest_DrawQQplot, FittingTest_Kolmogorov

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.viewer import View

    Generate a random sample from a Normal distribution:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal(2.0, 0.5)
    >>> sample = distribution.getSample(30)

    Draw an Henry plot against a given (wrong) Normal distribution:

    >>> henry_graph = ot.VisualTest.DrawHenryLine(sample, distribution)
    >>> henry_graph.setTitle('Henry plot against given %s' % ot.Normal(3.0, 1.0))
    >>> View(henry_graph).show()

    Draw an Henry plot against an inferred Normal distribution:

    >>> henry_graph = ot.VisualTest.DrawHenryLine(sample)
    >>> henry_graph.setTitle('Henry plot against inferred Normal distribution')
    >>> View(henry_graph).show()
    """
  return _stattests.VisualTest_DrawHenryLine(*args)

def VisualTest_DrawClouds(*args):
  return _stattests.VisualTest_DrawClouds(*args)
VisualTest_DrawClouds = _stattests.VisualTest_DrawClouds

def VisualTest_DrawLinearModel(*args):
  return _stattests.VisualTest_DrawLinearModel(*args)
VisualTest_DrawLinearModel = _stattests.VisualTest_DrawLinearModel

def VisualTest_DrawLinearModelResidual(*args):
  return _stattests.VisualTest_DrawLinearModelResidual(*args)
VisualTest_DrawLinearModelResidual = _stattests.VisualTest_DrawLinearModelResidual

def VisualTest_DrawCobWeb(*args):
  """
    Draw a Cobweb plot as an OpenTURNS :class:`~openturns.Graph`.

    Available usages:
        VisualTest.DrawCobWeb(*inputSample, outputSample, min, max, color, quantileScale=True*)

    Parameters
    ----------
    inputSample : 2-d sequence of float of dimension :math:`n`
        Input sample :math:`\\vect{X}`.
    outputSample : 2-d sequence of float of dimension :math:`1`
        Output sample :math:`Y`.
    Ymin, Ymax : float such that *Ymax > Ymin*
        Values to select lines which will colore in *color*. Must be in
        :math:`[0,1]` if *quantileScale=True*.
    color : str
        Color of the specified curves.
    quantileScale : bool
        Flag indicating the scale of the *Ymin* and *Ymax*. If
        *quantileScale=True*, they are expressed in the rank based scale;
        otherwise, they are expressed in the :math:`Y`-values scale.

    Notes
    -----
    Let's suppose a model :math:`f: \\Rset^n \\mapsto \\Rset`, where
    :math:`f(\\vect{X})=Y`.
    The Cobweb graph enables to visualize all the combinations of the input
    variables which lead to a specific range of the output variable.

    Each column represents one component :math:`X_i` of the input vector
    :math:`\\vect{X}`. The last column represents the scalar output variable
    :math:`Y`.

    For each point :math:`\\vect{X}^j` of *inputSample*, each component :math:`X_i^j`
    is noted on its respective axe and the last mark is the one which corresponds
    to the associated :math:`Y^j`. A line joins all the marks. Thus, each point of
    the sample corresponds to a particular line on the graph.

    The scale of the axes are quantile based : each axe runs between 0 and 1 and
    each value is represented by its quantile with respect to its marginal
    empirical distribution.

    It is interesting to select, among those lines, the ones which correspond to a
    specific range of the output variable. These particular lines selected are
    colored differently in *color*. This specific range is defined with *Ymin* and
    *Ymax* in the quantile based scale of :math:`Y` or in its specific scale. In
    that second case, the range is automatically converted into a quantile based
    scale range.

    Examples
    --------
    >>> import openturns as ot
    >>> from openturns.viewer import View

    Generate a random sample from a Normal distribution:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> inputSample = ot.Normal(2).getSample(15)
    >>> inputSample.setDescription(['X0', 'X1'])
    >>> formula = ['cos(X0)+cos(2*X1)']
    >>> model = ot.NumericalMathFunction(['X0', 'X1'], ['y'], formula)
    >>> outputSample = model(inputSample)

    Draw a Cobweb plot:

    >>> cobweb = ot.VisualTest.DrawCobWeb(inputSample, outputSample, 1.0, 2.0, 'red', False)
    >>> View(cobweb).show()
    """
  return _stattests.VisualTest_DrawCobWeb(*args)

def VisualTest_DrawKendallPlot(*args):
  return _stattests.VisualTest_DrawKendallPlot(*args)
VisualTest_DrawKendallPlot = _stattests.VisualTest_DrawKendallPlot

class FittingTest(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FittingTest, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FittingTest, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def BestModelBIC(*args):
        """
        Select the best model according to the Bayesian information criterion.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distributions.

        Returns
        -------
        best_model : :class:`~openturns.Distribution`
            The best distribution for the sample according to Bayesian information
            criterion.
            This may raise a warning if the best model does not perform well.

        See Also
        --------
        FittingTest_BIC

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> tested_distributions = [ot.ExponentialFactory(), ot.NormalFactory()]
        >>> best_model = ot.FittingTest.BestModelBIC(sample, tested_distributions)
        >>> print(best_model)
        Normal(mu = -0.0944924, sigma = 0.989808)
        """
        return _stattests.FittingTest_BestModelBIC(*args)

    if _newclass:BestModelBIC = staticmethod(BestModelBIC)
    __swig_getmethods__["BestModelBIC"] = lambda x: BestModelBIC
    def BestModelKolmogorov(*args):
        """
        Select the best model according to the Kolmogorov goodness-of-fit test.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distributions.

        Returns
        -------
        best_model : :class:`~openturns.Distribution`
            The best distribution for the sample according to Bayesian information
            criterion.
            This may raise a warning if the best model does not perform well.
        best_result : :class:`~openturns.TestResult`
            Best test result.

        See Also
        --------
        FittingTest_Kolmogorov

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> tested_distributions = [ot.ExponentialFactory(), ot.NormalFactory()]
        >>> best_model, best_result = ot.FittingTest.BestModelKolmogorov(sample, tested_distributions)
        >>> print(best_model)
        Normal(mu = -0.0944924, sigma = 0.989808)
        """
        return _stattests.FittingTest_BestModelKolmogorov(*args)

    if _newclass:BestModelKolmogorov = staticmethod(BestModelKolmogorov)
    __swig_getmethods__["BestModelKolmogorov"] = lambda x: BestModelKolmogorov
    def BestModelChiSquared(*args):
        """
        Select the best model according to the :math:`\\chi^2` goodness-of-fit test.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distributions.

        Returns
        -------
        best_model : :class:`~openturns.Distribution`
            The best distribution for the sample according to Bayesian information
            criterion.
            This may raise a warning if the best model does not perform well.
        best_result : :class:`~openturns.TestResult`
            Best test result.

        See Also
        --------
        FittingTest_ChiSquared

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Poisson()
        >>> sample = distribution.getSample(30)
        >>> tested_distributions = [ot.PoissonFactory(), ot.UserDefinedFactory()]
        >>> best_model = ot.FittingTest.BestModelBIC(sample, tested_distributions)
        >>> print(best_model)
        Poisson(lambda = 1.06667)
        """
        return _stattests.FittingTest_BestModelChiSquared(*args)

    if _newclass:BestModelChiSquared = staticmethod(BestModelChiSquared)
    __swig_getmethods__["BestModelChiSquared"] = lambda x: BestModelChiSquared
    def BIC(*args):
        """
        Compute the Bayesian information criterion.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distribution.
        n_parameters : int, :math:`0 \\leq k`, optional
            The number of parameters in the distribution that have been estimated from
            the sample.
            This parameter must not be provided if a :class:`~openturns.DistributionFactory`
            was provided as the second argument (it will internally be set to the
            number of parameters estimated by the :class:`~openturns.DistributionFactory`).
            It can be specified if  a :class:`~openturns.Distribution` was provided
            as the second argument, but if it is not, it will be set equal to 0.

        Returns
        -------
        BIC : float
            The Bayesian information criterion.

        Notes
        -----
        The Bayesian information criterion is defined as follows:

        .. math::

            {\\rm BIC} = \\frac{1}{m}
                        \\left(- 2 \\log L(\\vect{x}^{(i)}, i = 1, \\ldots, m)
                              + k \\log m\\right)

        where :math:`\\log L` denotes the log-likelihood of the sample with respect to
        the given distribution, and :math:`k` denotes the number of estimated
        parameters in the distribution.

        This is used for model selection.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> ot.FittingTest.BIC(sample, distribution)
        2.7938693005063415
        >>> ot.FittingTest.BIC(sample, distribution, 2)
        3.0206157926171517
        >>> ot.FittingTest.BIC(sample, ot.NormalFactory())
        3.0108025506670955
        """
        return _stattests.FittingTest_BIC(*args)

    if _newclass:BIC = staticmethod(BIC)
    __swig_getmethods__["BIC"] = lambda x: BIC
    def Kolmogorov(*args):
        """
        Perform a Kolmogorov goodness-of-fit test for 1-d continuous distributions.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distribution.
        level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
            This is the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
            committing a Type I error, that is an incorrect rejection of a true
            null hypothesis.
        n_parameters : int, :math:`0 \\leq k`, optional
            The number of parameters in the distribution that have been estimated from
            the sample.
            This parameter must not be provided if a :class:`~openturns.DistributionFactory`
            was provided as the second argument (it will internally be set to the
            number of parameters estimated by the :class:`~openturns.DistributionFactory`).
            It can be specified if  a :class:`~openturns.Distribution` was provided
            as the second argument, but if it is not, it will be set equal to 0.

        Returns
        -------
        test_result : :class:`~openturns.TestResult`
            Test result.

        Raises
        ------
        TypeError : If the distribution is not continuous or if the sample is
            multivariate.

        Notes
        -----
        The present implementation of the Kolmogorov goodness-of-fit test is
        two-sided. This uses an external C implementation of the Kolmogorov cumulative
        distribution function by [Simard2011]_.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> ot.FittingTest.Kolmogorov(sample, ot.NormalFactory(), .99)
        class=TestResult name=Unnamed type=KolmogorovDistribution binaryQualityMeasure=true p-value threshold=0.01 p-value=0.846896 description=[Normal(mu = -0.0944924, sigma = 0.989808) vs sample Normal]
        """
        return _stattests.FittingTest_Kolmogorov(*args)

    if _newclass:Kolmogorov = staticmethod(Kolmogorov)
    __swig_getmethods__["Kolmogorov"] = lambda x: Kolmogorov
    def TwoSamplesKolmogorov(*args):
        """
        Perform a Kolmogorov goodness-of-fit test on two samples.

        If the p-value is high, then we cannot reject the hypothesis that the
        distributions of the two samples are the same.

        Parameters
        ----------
        sample1 : 2-d float array
            A continuous distribution sample.
        sample2 : 2-d float array
            Another continuous distribution sample, can be of different size.
        level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
            This the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
            committing a Type I error, that is an incorrect rejection of a true
            null hypothesis.

        Returns
        -------
        test_result : :class:`~openturns.TestResult`
            Test result.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> sample1 = ot.Normal().getSample(20)
        >>> sample2 = ot.Normal(0.1, 1.1).getSample(30)
        >>> ot.FittingTest.TwoSamplesKolmogorov(sample1, sample2)
        class=TestResult name=Unnamed type=Kolmogorov Normal/Normal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.554765 description=[sampleNormal vs sample Normal]
        """
        return _stattests.FittingTest_TwoSamplesKolmogorov(*args)

    if _newclass:TwoSamplesKolmogorov = staticmethod(TwoSamplesKolmogorov)
    __swig_getmethods__["TwoSamplesKolmogorov"] = lambda x: TwoSamplesKolmogorov
    def ChiSquared(*args):
        """
        Perform a :math:`\\chi^2` goodness-of-fit test for 1-d discrete distributions.

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
            Tested distribution.
        level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
            This the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
            committing a Type I error, that is an incorrect rejection of a true
            null hypothesis.
        n_parameters : int, :math:`0 \\leq k`, optional
            The number of parameters in the distribution that have been estimated from
            the sample.
            This parameter must not be provided if a :class:`~openturns.DistributionFactory`
            was provided as the second argument (it will internally be set to the
            number of parameters estimated by the :class:`~openturns.DistributionFactory`).
            It can be specified if  a :class:`~openturns.Distribution` was provided
            as the second argument, but if it is not, it will be set equal to 0.

        Returns
        -------
        test_result : :class:`~openturns.TestResult`
            Test result.

        Raises
        ------
        TypeError : If the distribution is not discrete or if the sample is
            multivariate.

        Notes
        -----
        This is an interface to the `chisq.test function from the
        'stats' R package <http://stat.ethz.ch/R-manual/R-patched/library/stats/html/chisq.test.html>`_.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Poisson()
        >>> sample = distribution.getSample(30)
        >>> ot.FittingTest.ChiSquared(sample, ot.PoissonFactory(), .99)
        class=TestResult name=Unnamed type=ChiSquaredPoisson binaryQualityMeasure=true p-value threshold=0.01 p-value=0.606136 description=[]
        """
        return _stattests.FittingTest_ChiSquared(*args)

    if _newclass:ChiSquared = staticmethod(ChiSquared)
    __swig_getmethods__["ChiSquared"] = lambda x: ChiSquared
    __swig_destroy__ = _stattests.delete_FittingTest
    __del__ = lambda self : None;
FittingTest_swigregister = _stattests.FittingTest_swigregister
FittingTest_swigregister(FittingTest)

def FittingTest_BestModelBIC(*args):
  """
    Select the best model according to the Bayesian information criterion.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distributions.

    Returns
    -------
    best_model : :class:`~openturns.Distribution`
        The best distribution for the sample according to Bayesian information
        criterion.
        This may raise a warning if the best model does not perform well.

    See Also
    --------
    FittingTest_BIC

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> tested_distributions = [ot.ExponentialFactory(), ot.NormalFactory()]
    >>> best_model = ot.FittingTest.BestModelBIC(sample, tested_distributions)
    >>> print(best_model)
    Normal(mu = -0.0944924, sigma = 0.989808)
    """
  return _stattests.FittingTest_BestModelBIC(*args)

def FittingTest_BestModelKolmogorov(*args):
  """
    Select the best model according to the Kolmogorov goodness-of-fit test.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distributions.

    Returns
    -------
    best_model : :class:`~openturns.Distribution`
        The best distribution for the sample according to Bayesian information
        criterion.
        This may raise a warning if the best model does not perform well.
    best_result : :class:`~openturns.TestResult`
        Best test result.

    See Also
    --------
    FittingTest_Kolmogorov

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> tested_distributions = [ot.ExponentialFactory(), ot.NormalFactory()]
    >>> best_model, best_result = ot.FittingTest.BestModelKolmogorov(sample, tested_distributions)
    >>> print(best_model)
    Normal(mu = -0.0944924, sigma = 0.989808)
    """
  return _stattests.FittingTest_BestModelKolmogorov(*args)

def FittingTest_BestModelChiSquared(*args):
  """
    Select the best model according to the :math:`\\chi^2` goodness-of-fit test.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    models : list of :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distributions.

    Returns
    -------
    best_model : :class:`~openturns.Distribution`
        The best distribution for the sample according to Bayesian information
        criterion.
        This may raise a warning if the best model does not perform well.
    best_result : :class:`~openturns.TestResult`
        Best test result.

    See Also
    --------
    FittingTest_ChiSquared

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Poisson()
    >>> sample = distribution.getSample(30)
    >>> tested_distributions = [ot.PoissonFactory(), ot.UserDefinedFactory()]
    >>> best_model = ot.FittingTest.BestModelBIC(sample, tested_distributions)
    >>> print(best_model)
    Poisson(lambda = 1.06667)
    """
  return _stattests.FittingTest_BestModelChiSquared(*args)

def FittingTest_BIC(*args):
  """
    Compute the Bayesian information criterion.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distribution.
    n_parameters : int, :math:`0 \\leq k`, optional
        The number of parameters in the distribution that have been estimated from
        the sample.
        This parameter must not be provided if a :class:`~openturns.DistributionFactory`
        was provided as the second argument (it will internally be set to the
        number of parameters estimated by the :class:`~openturns.DistributionFactory`).
        It can be specified if  a :class:`~openturns.Distribution` was provided
        as the second argument, but if it is not, it will be set equal to 0.

    Returns
    -------
    BIC : float
        The Bayesian information criterion.

    Notes
    -----
    The Bayesian information criterion is defined as follows:

    .. math::

        {\\rm BIC} = \\frac{1}{m}
                    \\left(- 2 \\log L(\\vect{x}^{(i)}, i = 1, \\ldots, m)
                          + k \\log m\\right)

    where :math:`\\log L` denotes the log-likelihood of the sample with respect to
    the given distribution, and :math:`k` denotes the number of estimated
    parameters in the distribution.

    This is used for model selection.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> ot.FittingTest.BIC(sample, distribution)
    2.7938693005063415
    >>> ot.FittingTest.BIC(sample, distribution, 2)
    3.0206157926171517
    >>> ot.FittingTest.BIC(sample, ot.NormalFactory())
    3.0108025506670955
    """
  return _stattests.FittingTest_BIC(*args)

def FittingTest_Kolmogorov(*args):
  """
    Perform a Kolmogorov goodness-of-fit test for 1-d continuous distributions.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distribution.
    level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
        This is the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
        committing a Type I error, that is an incorrect rejection of a true
        null hypothesis.
    n_parameters : int, :math:`0 \\leq k`, optional
        The number of parameters in the distribution that have been estimated from
        the sample.
        This parameter must not be provided if a :class:`~openturns.DistributionFactory`
        was provided as the second argument (it will internally be set to the
        number of parameters estimated by the :class:`~openturns.DistributionFactory`).
        It can be specified if  a :class:`~openturns.Distribution` was provided
        as the second argument, but if it is not, it will be set equal to 0.

    Returns
    -------
    test_result : :class:`~openturns.TestResult`
        Test result.

    Raises
    ------
    TypeError : If the distribution is not continuous or if the sample is
        multivariate.

    Notes
    -----
    The present implementation of the Kolmogorov goodness-of-fit test is
    two-sided. This uses an external C implementation of the Kolmogorov cumulative
    distribution function by [Simard2011]_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> ot.FittingTest.Kolmogorov(sample, ot.NormalFactory(), .99)
    class=TestResult name=Unnamed type=KolmogorovDistribution binaryQualityMeasure=true p-value threshold=0.01 p-value=0.846896 description=[Normal(mu = -0.0944924, sigma = 0.989808) vs sample Normal]
    """
  return _stattests.FittingTest_Kolmogorov(*args)

def FittingTest_TwoSamplesKolmogorov(*args):
  """
    Perform a Kolmogorov goodness-of-fit test on two samples.

    If the p-value is high, then we cannot reject the hypothesis that the
    distributions of the two samples are the same.

    Parameters
    ----------
    sample1 : 2-d float array
        A continuous distribution sample.
    sample2 : 2-d float array
        Another continuous distribution sample, can be of different size.
    level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
        This the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
        committing a Type I error, that is an incorrect rejection of a true
        null hypothesis.

    Returns
    -------
    test_result : :class:`~openturns.TestResult`
        Test result.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample1 = ot.Normal().getSample(20)
    >>> sample2 = ot.Normal(0.1, 1.1).getSample(30)
    >>> ot.FittingTest.TwoSamplesKolmogorov(sample1, sample2)
    class=TestResult name=Unnamed type=Kolmogorov Normal/Normal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.554765 description=[sampleNormal vs sample Normal]
    """
  return _stattests.FittingTest_TwoSamplesKolmogorov(*args)

def FittingTest_ChiSquared(*args):
  """
    Perform a :math:`\\chi^2` goodness-of-fit test for 1-d discrete distributions.

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    model : :class:`~openturns.Distribution` or :class:`~openturns.DistributionFactory`
        Tested distribution.
    level : float, :math:`0 \\leq {\\rm level} \\leq 1`, optional
        This the value such that :math:`\\alpha = 1 - {\\rm level}` is the risk of
        committing a Type I error, that is an incorrect rejection of a true
        null hypothesis.
    n_parameters : int, :math:`0 \\leq k`, optional
        The number of parameters in the distribution that have been estimated from
        the sample.
        This parameter must not be provided if a :class:`~openturns.DistributionFactory`
        was provided as the second argument (it will internally be set to the
        number of parameters estimated by the :class:`~openturns.DistributionFactory`).
        It can be specified if  a :class:`~openturns.Distribution` was provided
        as the second argument, but if it is not, it will be set equal to 0.

    Returns
    -------
    test_result : :class:`~openturns.TestResult`
        Test result.

    Raises
    ------
    TypeError : If the distribution is not discrete or if the sample is
        multivariate.

    Notes
    -----
    This is an interface to the `chisq.test function from the
    'stats' R package <http://stat.ethz.ch/R-manual/R-patched/library/stats/html/chisq.test.html>`_.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Poisson()
    >>> sample = distribution.getSample(30)
    >>> ot.FittingTest.ChiSquared(sample, ot.PoissonFactory(), .99)
    class=TestResult name=Unnamed type=ChiSquaredPoisson binaryQualityMeasure=true p-value threshold=0.01 p-value=0.606136 description=[]
    """
  return _stattests.FittingTest_ChiSquared(*args)

class HypothesisTest(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HypothesisTest, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HypothesisTest, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def ChiSquared(*args):
        """
        Test whether two discrete samples are independent.

        **Available usages**:

            HypothesisTest.ChiSquared(*firstSample, secondSample*)

            HypothesisTest.ChiSquared(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Pearson, HypothesisTest_Spearman

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distCol = [ot.Normal(), ot.Normal()]
        >>> distribution = ot.ComposedDistribution(distCol)
        >>> sample = distribution.getSample(30)
        >>> test_result = ot.HypothesisTest.ChiSquared(sample[:,0], sample[:,1])
        >>> print(test_result)
        class=TestResult name=Unnamed type=TwoSampleChiSquared binaryQualityMeasure=true p-value threshold=0.05 p-value=0.237197 description=[]

        """
        return _stattests.HypothesisTest_ChiSquared(*args)

    if _newclass:ChiSquared = staticmethod(ChiSquared)
    __swig_getmethods__["ChiSquared"] = lambda x: ChiSquared
    def Pearson(*args):
        """
        Test whether two discrete samples are independent.

        **Available usages**:

            HypothesisTest.Pearson(*firstSample, secondSample*)

            HypothesisTest.Pearson(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Smirnov, HypothesisTest_Spearman

        Notes
        -----
        The Pearson Test is used to check whether two samples which are assumed to form
        a gaussian vector are independent (based on the evaluation of the linear
        correlation coefficient).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distCol = [ot.Normal(), ot.Normal()]
        >>> firstSample = ot.Normal().getSample(30)
        >>> secondSample = ot.Normal().getSample(30)
        >>> test_result = ot.HypothesisTest.Pearson(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=TwoSamplePearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.984737 description=[]

        """
        return _stattests.HypothesisTest_Pearson(*args)

    if _newclass:Pearson = staticmethod(Pearson)
    __swig_getmethods__["Pearson"] = lambda x: Pearson
    def Smirnov(*args):
        """
        Test whether two samples follows the same distribution.

        **Available usages**:

            HypothesisTest.Smirnov(*firstSample, secondSample*)

            HypothesisTest.Smirnov(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Pearson, HypothesisTest_Spearman

        Notes
        -----
        Smirnov's test is a tool that may be used to compare two samples
        :math:`\\{x_1, \\ldots, x_N\\}` and :math:`\\{x^{'}_1, \\ldots, x^{'}_M\\}` (of sizes not
        necessarily equal). The goal is to determine whether these two samples come from
        the same probability distribution or not. If this is the case, the two samples
        should be aggregated in order to increase the robustness of further statistical
        analyses.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distCol = [ot.Normal(), ot.Normal()]
        >>> firstSample = ot.Normal().getSample(30)
        >>> secondSample = ot.Normal().getSample(30)
        >>> test_result = ot.HypothesisTest.Smirnov(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=TwoSampleSmirnov binaryQualityMeasure=true p-value threshold=0.05 p-value=0.807963 description=[]

        """
        return _stattests.HypothesisTest_Smirnov(*args)

    if _newclass:Smirnov = staticmethod(Smirnov)
    __swig_getmethods__["Smirnov"] = lambda x: Smirnov
    def Spearman(*args):
        """
        Test whether two discrete samples are not monotonous.

        **Available usages**:

            HypothesisTest.Spearman(*firstSample, secondSample*)

            HypothesisTest.Spearman(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Smirnov, HypothesisTest_Pearson

        Notes
        -----
        The Spearman Test is used to check whether two scalar samples have a monotonous
        relation.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> firstSample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', 'x^2')
        >>> secondSample = func(firstSample)
        >>> test_result = ot.HypothesisTest.Spearman(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=TwoSampleSpearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.44348 description=[]

        """
        return _stattests.HypothesisTest_Spearman(*args)

    if _newclass:Spearman = staticmethod(Spearman)
    __swig_getmethods__["Spearman"] = lambda x: Spearman
    def PartialPearson(*args):
        """
        Test whether two discrete samples are independent.

        **Available usages**:

            HypothesisTest.PartialPearson(*firstSample, secondSample, selection*)

            HypothesisTest.PartialPearson(*firstSample, secondSample, selection, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        selection : sequence of integers, maximum integer value :math:`< n`
            List of indices selecting which subsets of the first sample will successively
            be tested with the second sample through the Pearson test.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Pearson, HypothesisTest_FullPearson

        Notes
        -----
        The Partial Pearson Test is used to check the independence between two samples:
        *firstSample* of dimension *n* and *secondSample* of dimension 1. The parameter
        *selection* enables to select specific subsets of the *firstSample* to be tested.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distCol = [ot.Normal(), ot.Normal(), ot.Normal(), ot.Normal()]
        >>> S = ot.CorrelationMatrix(4)
        >>> S[0, 3] = 0.9
        >>> copula = ot.NormalCopula(S)
        >>> distribution = ot.ComposedDistribution(distCol, copula)
        >>> sample = distribution.getSample(30)
        >>> firstSample = sample[:, :3]
        >>> secondSample = sample[:, 3]
        >>> test_result = ot.HypothesisTest.PartialPearson(firstSample, secondSample, [0, 2])
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=false p-value threshold=0.05 p-value=1.17002e-10 description=[],class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.19193 description=[]]

        """
        return _stattests.HypothesisTest_PartialPearson(*args)

    if _newclass:PartialPearson = staticmethod(PartialPearson)
    __swig_getmethods__["PartialPearson"] = lambda x: PartialPearson
    def PartialRegression(*args):
        """
        Test whether two discrete samples are independent.

        **Available usages**:

            HypothesisTest.PartialRegression(*firstSample, secondSample, selection*)

            HypothesisTest.PartialRegression(*firstSample, secondSample, selection, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        selection : sequence of int, maximum integer value :math:`< n`
            List of indices selecting which subsets of the first sample will successively
            be tested with the second sample through the regression test.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_FullRegression, LinearModelTest_LinearModelFisher

        Notes
        -----
        The Partial Regression Test is used to check the quality of the linear regression
        model between two samples: *firstSample* of dimension *n* and *secondSample* of
        dimension 1. The parameter *selection* enables to select specific subsets of the
        *firstSample* to be tested.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> dim = 3
        >>> distCol = [ot.Normal()] * dim
        >>> S = ot.CorrelationMatrix(dim)
        >>> S[0, dim - 1] = 0.99
        >>> copula = ot.NormalCopula(S)
        >>> distribution = ot.ComposedDistribution(distCol, copula)
        >>> sample = distribution.getSample(30)
        >>> firstSample = sample[:, :2]
        >>> secondSample = sample[:, 2]
        >>> selection = [1]
        >>> test_result = ot.HypothesisTest.PartialRegression(firstSample, secondSample, selection)
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.579638 description=[]]
        """
        return _stattests.HypothesisTest_PartialRegression(*args)

    if _newclass:PartialRegression = staticmethod(PartialRegression)
    __swig_getmethods__["PartialRegression"] = lambda x: PartialRegression
    def PartialSpearman(*args):
        """
        Test whether two discrete samples are not monotonous.

        **Available usages**:

        HypothesisTest_PartialSpearman(*firstSample, secondSample, selection*)

        HypothesisTest_PartialSpearman(*firstSample, secondSample, selection, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        selection : sequence of integers, maximum integer value :math:`< n`
            List of indices selecting which subsets of the first sample will successively
            be tested with the second sample through the Spearman test.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Spearman, HypothesisTest_FullSpearman

        Notes
        -----
        The Partial Spearman Test is used to check hypothesis of non monotonous relation
        between two samples: *firstSample* of dimension *n* and *secondSample* of
        dimension 1. The parameter *selection* enables to select specific subsets of the
        *firstSample* to be tested.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction(['x'], ['x', 'x^2', 'x^3', 'sin(5*x)'])
        >>> testedSample = func(sample)
        >>> test_result = ot.HypothesisTest.PartialSpearman(testedSample, sample, [0,3])
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=false p-value threshold=0.05 p-value=0 description=[],class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.57214 description=[]]

        """
        return _stattests.HypothesisTest_PartialSpearman(*args)

    if _newclass:PartialSpearman = staticmethod(PartialSpearman)
    __swig_getmethods__["PartialSpearman"] = lambda x: PartialSpearman
    def FullPearson(*args):
        """
        Test whether two discrete samples are independent.

        **Available usages**:

            HypothesisTest.FullPearson(*firstSample, secondSample*)

            HypothesisTest.FullPearson(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Pearson, HypothesisTest_PartialPearson

        Notes
        -----
        The Full Pearson Test is the independence Pearson test between 2 samples :
        *firstSample* of dimension *n* and *secondSample* of dimension 1. If
        *firstSample[i]* is the numerical sample extracted from *firstSample*
        (:math:`i^{th}` coordinate of each point of the numerical sample), FullPearson
        performs the independence Pearson test simultaneously on *firstSample[i]* and 
        secondSample. For all *i*, it is supposed that the couple (*firstSample[i]* and
        *secondSample*) is issued from a gaussian vector.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distCol = [ot.Normal()] * 3
        >>> S = ot.CorrelationMatrix(3)
        >>> S[0, 2] = 0.9
        >>> copula = ot.NormalCopula(S)
        >>> distribution = ot.ComposedDistribution(distCol, copula)
        >>> sample = distribution.getSample(30)
        >>> firstSample = sample[:, :2]
        >>> secondSample = sample[:, 2]
        >>> test_result = ot.HypothesisTest.FullPearson(firstSample, secondSample)
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=false p-value threshold=0.05 p-value=7.23...e-14 description=[],class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.895124 description=[]]


        """
        return _stattests.HypothesisTest_FullPearson(*args)

    if _newclass:FullPearson = staticmethod(FullPearson)
    __swig_getmethods__["FullPearson"] = lambda x: FullPearson
    def FullRegression(*args):
        """
        Test whether two discrete samples are not linear.

        **Available usages**:

            HypothesisTest.FullRegression(*firstSample, secondSample*)

            HypothesisTest.FullRegression(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_PartialRegression, LinearModelTest_LinearModelFisher

        Notes
        -----
        The Full Regression Test is used to check the quality of the linear regression
        model between two samples: *firstSample* of dimension *n* and *secondSample* of
        dimension 1. If *firstSample[i]* is the numerical sample extracted from
        *firstSample* (:math:`i^{th}` coordinate of each point of the numerical sample),
        FullRegression performs the linear regression test simultaneously on all
        *firstSample[i]* and *secondSample*. The linear regression test tests if the
        linear regression model between two scalar numerical samples is not significant.
        It is based on the deviation analysis of the regression. The Fisher distribution
        is used.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> dim = 3
        >>> distCol = [ot.Normal()] * dim
        >>> S = ot.CorrelationMatrix(dim)
        >>> S[0, dim - 1] = 0.99
        >>> copula = ot.NormalCopula(S)
        >>> distribution = ot.ComposedDistribution(distCol, copula)
        >>> sample = distribution.getSample(30)
        >>> firstSample = sample[:, :2]
        >>> secondSample = sample[:, 2]
        >>> test_result = ot.HypothesisTest.FullRegression(firstSample, secondSample)
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Regression binaryQualityMeasure=false p-value threshold=0.05 p-value=9.70282e-27 description=[],class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.11352 description=[]]
        """
        return _stattests.HypothesisTest_FullRegression(*args)

    if _newclass:FullRegression = staticmethod(FullRegression)
    __swig_getmethods__["FullRegression"] = lambda x: FullRegression
    def FullSpearman(*args):
        """
        Test whether two discrete samples are not monotonous.

        **Available usages**:

            HypothesisTest.FullSpearman(*firstSample, secondSample*)

            HypothesisTest.FullSpearman(*firstSample, secondSample, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension :math:`n \\geq 1`.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        HypothesisTest_Spearman, HypothesisTest_PartialSpearman

        Notes
        -----
        The Full Spearman Test is used to check hypothesis of non monotonous relation
        between two samples: *firstSample* of dimension *n* and *secondSample* of
        dimension 1. If *firstSample[i]* is the numerical sample extracted from
        *firstSample* (:math:`i^{th}` coordinate of each point of the numerical sample),
        FullSpearman performs the independence Spearman test simultaneously on all
        *firstSample[i]* and *secondSample*.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction(['x'], ['x', 'x^2'])
        >>> testedSample = func(sample)
        >>> test_result = ot.HypothesisTest.FullSpearman(testedSample, sample)
        >>> print(test_result)
        [class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=false p-value threshold=0.05 p-value=0 description=[],class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.44348 description=[]]

        """
        return _stattests.HypothesisTest_FullSpearman(*args)

    if _newclass:FullSpearman = staticmethod(FullSpearman)
    __swig_getmethods__["FullSpearman"] = lambda x: FullSpearman
    __swig_destroy__ = _stattests.delete_HypothesisTest
    __del__ = lambda self : None;
HypothesisTest_swigregister = _stattests.HypothesisTest_swigregister
HypothesisTest_swigregister(HypothesisTest)

def HypothesisTest_ChiSquared(*args):
  """
    Test whether two discrete samples are independent.

    **Available usages**:

        HypothesisTest.ChiSquared(*firstSample, secondSample*)

        HypothesisTest.ChiSquared(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Pearson, HypothesisTest_Spearman

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distCol = [ot.Normal(), ot.Normal()]
    >>> distribution = ot.ComposedDistribution(distCol)
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.HypothesisTest.ChiSquared(sample[:,0], sample[:,1])
    >>> print(test_result)
    class=TestResult name=Unnamed type=TwoSampleChiSquared binaryQualityMeasure=true p-value threshold=0.05 p-value=0.237197 description=[]

    """
  return _stattests.HypothesisTest_ChiSquared(*args)

def HypothesisTest_Pearson(*args):
  """
    Test whether two discrete samples are independent.

    **Available usages**:

        HypothesisTest.Pearson(*firstSample, secondSample*)

        HypothesisTest.Pearson(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Smirnov, HypothesisTest_Spearman

    Notes
    -----
    The Pearson Test is used to check whether two samples which are assumed to form
    a gaussian vector are independent (based on the evaluation of the linear
    correlation coefficient).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distCol = [ot.Normal(), ot.Normal()]
    >>> firstSample = ot.Normal().getSample(30)
    >>> secondSample = ot.Normal().getSample(30)
    >>> test_result = ot.HypothesisTest.Pearson(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=TwoSamplePearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.984737 description=[]

    """
  return _stattests.HypothesisTest_Pearson(*args)

def HypothesisTest_Smirnov(*args):
  """
    Test whether two samples follows the same distribution.

    **Available usages**:

        HypothesisTest.Smirnov(*firstSample, secondSample*)

        HypothesisTest.Smirnov(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Pearson, HypothesisTest_Spearman

    Notes
    -----
    Smirnov's test is a tool that may be used to compare two samples
    :math:`\\{x_1, \\ldots, x_N\\}` and :math:`\\{x^{'}_1, \\ldots, x^{'}_M\\}` (of sizes not
    necessarily equal). The goal is to determine whether these two samples come from
    the same probability distribution or not. If this is the case, the two samples
    should be aggregated in order to increase the robustness of further statistical
    analyses.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distCol = [ot.Normal(), ot.Normal()]
    >>> firstSample = ot.Normal().getSample(30)
    >>> secondSample = ot.Normal().getSample(30)
    >>> test_result = ot.HypothesisTest.Smirnov(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=TwoSampleSmirnov binaryQualityMeasure=true p-value threshold=0.05 p-value=0.807963 description=[]

    """
  return _stattests.HypothesisTest_Smirnov(*args)

def HypothesisTest_Spearman(*args):
  """
    Test whether two discrete samples are not monotonous.

    **Available usages**:

        HypothesisTest.Spearman(*firstSample, secondSample*)

        HypothesisTest.Spearman(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Smirnov, HypothesisTest_Pearson

    Notes
    -----
    The Spearman Test is used to check whether two scalar samples have a monotonous
    relation.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> firstSample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', 'x^2')
    >>> secondSample = func(firstSample)
    >>> test_result = ot.HypothesisTest.Spearman(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=TwoSampleSpearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.44348 description=[]

    """
  return _stattests.HypothesisTest_Spearman(*args)

def HypothesisTest_PartialPearson(*args):
  """
    Test whether two discrete samples are independent.

    **Available usages**:

        HypothesisTest.PartialPearson(*firstSample, secondSample, selection*)

        HypothesisTest.PartialPearson(*firstSample, secondSample, selection, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    selection : sequence of integers, maximum integer value :math:`< n`
        List of indices selecting which subsets of the first sample will successively
        be tested with the second sample through the Pearson test.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Pearson, HypothesisTest_FullPearson

    Notes
    -----
    The Partial Pearson Test is used to check the independence between two samples:
    *firstSample* of dimension *n* and *secondSample* of dimension 1. The parameter
    *selection* enables to select specific subsets of the *firstSample* to be tested.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distCol = [ot.Normal(), ot.Normal(), ot.Normal(), ot.Normal()]
    >>> S = ot.CorrelationMatrix(4)
    >>> S[0, 3] = 0.9
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.ComposedDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :3]
    >>> secondSample = sample[:, 3]
    >>> test_result = ot.HypothesisTest.PartialPearson(firstSample, secondSample, [0, 2])
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=false p-value threshold=0.05 p-value=1.17002e-10 description=[],class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.19193 description=[]]

    """
  return _stattests.HypothesisTest_PartialPearson(*args)

def HypothesisTest_PartialRegression(*args):
  """
    Test whether two discrete samples are independent.

    **Available usages**:

        HypothesisTest.PartialRegression(*firstSample, secondSample, selection*)

        HypothesisTest.PartialRegression(*firstSample, secondSample, selection, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    selection : sequence of int, maximum integer value :math:`< n`
        List of indices selecting which subsets of the first sample will successively
        be tested with the second sample through the regression test.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_FullRegression, LinearModelTest_LinearModelFisher

    Notes
    -----
    The Partial Regression Test is used to check the quality of the linear regression
    model between two samples: *firstSample* of dimension *n* and *secondSample* of
    dimension 1. The parameter *selection* enables to select specific subsets of the
    *firstSample* to be tested.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 3
    >>> distCol = [ot.Normal()] * dim
    >>> S = ot.CorrelationMatrix(dim)
    >>> S[0, dim - 1] = 0.99
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.ComposedDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :2]
    >>> secondSample = sample[:, 2]
    >>> selection = [1]
    >>> test_result = ot.HypothesisTest.PartialRegression(firstSample, secondSample, selection)
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.579638 description=[]]
    """
  return _stattests.HypothesisTest_PartialRegression(*args)

def HypothesisTest_PartialSpearman(*args):
  """
    Test whether two discrete samples are not monotonous.

    **Available usages**:

    HypothesisTest_PartialSpearman(*firstSample, secondSample, selection*)

    HypothesisTest_PartialSpearman(*firstSample, secondSample, selection, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    selection : sequence of integers, maximum integer value :math:`< n`
        List of indices selecting which subsets of the first sample will successively
        be tested with the second sample through the Spearman test.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Spearman, HypothesisTest_FullSpearman

    Notes
    -----
    The Partial Spearman Test is used to check hypothesis of non monotonous relation
    between two samples: *firstSample* of dimension *n* and *secondSample* of
    dimension 1. The parameter *selection* enables to select specific subsets of the
    *firstSample* to be tested.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction(['x'], ['x', 'x^2', 'x^3', 'sin(5*x)'])
    >>> testedSample = func(sample)
    >>> test_result = ot.HypothesisTest.PartialSpearman(testedSample, sample, [0,3])
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=false p-value threshold=0.05 p-value=0 description=[],class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.57214 description=[]]

    """
  return _stattests.HypothesisTest_PartialSpearman(*args)

def HypothesisTest_FullPearson(*args):
  """
    Test whether two discrete samples are independent.

    **Available usages**:

        HypothesisTest.FullPearson(*firstSample, secondSample*)

        HypothesisTest.FullPearson(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Pearson, HypothesisTest_PartialPearson

    Notes
    -----
    The Full Pearson Test is the independence Pearson test between 2 samples :
    *firstSample* of dimension *n* and *secondSample* of dimension 1. If
    *firstSample[i]* is the numerical sample extracted from *firstSample*
    (:math:`i^{th}` coordinate of each point of the numerical sample), FullPearson
    performs the independence Pearson test simultaneously on *firstSample[i]* and 
    secondSample. For all *i*, it is supposed that the couple (*firstSample[i]* and
    *secondSample*) is issued from a gaussian vector.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distCol = [ot.Normal()] * 3
    >>> S = ot.CorrelationMatrix(3)
    >>> S[0, 2] = 0.9
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.ComposedDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :2]
    >>> secondSample = sample[:, 2]
    >>> test_result = ot.HypothesisTest.FullPearson(firstSample, secondSample)
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=false p-value threshold=0.05 p-value=7.23...e-14 description=[],class=TestResult name=Unnamed type=Pearson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.895124 description=[]]


    """
  return _stattests.HypothesisTest_FullPearson(*args)

def HypothesisTest_FullRegression(*args):
  """
    Test whether two discrete samples are not linear.

    **Available usages**:

        HypothesisTest.FullRegression(*firstSample, secondSample*)

        HypothesisTest.FullRegression(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_PartialRegression, LinearModelTest_LinearModelFisher

    Notes
    -----
    The Full Regression Test is used to check the quality of the linear regression
    model between two samples: *firstSample* of dimension *n* and *secondSample* of
    dimension 1. If *firstSample[i]* is the numerical sample extracted from
    *firstSample* (:math:`i^{th}` coordinate of each point of the numerical sample),
    FullRegression performs the linear regression test simultaneously on all
    *firstSample[i]* and *secondSample*. The linear regression test tests if the
    linear regression model between two scalar numerical samples is not significant.
    It is based on the deviation analysis of the regression. The Fisher distribution
    is used.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 3
    >>> distCol = [ot.Normal()] * dim
    >>> S = ot.CorrelationMatrix(dim)
    >>> S[0, dim - 1] = 0.99
    >>> copula = ot.NormalCopula(S)
    >>> distribution = ot.ComposedDistribution(distCol, copula)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample[:, :2]
    >>> secondSample = sample[:, 2]
    >>> test_result = ot.HypothesisTest.FullRegression(firstSample, secondSample)
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Regression binaryQualityMeasure=false p-value threshold=0.05 p-value=9.70282e-27 description=[],class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.11352 description=[]]
    """
  return _stattests.HypothesisTest_FullRegression(*args)

def HypothesisTest_FullSpearman(*args):
  """
    Test whether two discrete samples are not monotonous.

    **Available usages**:

        HypothesisTest.FullSpearman(*firstSample, secondSample*)

        HypothesisTest.FullSpearman(*firstSample, secondSample, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension :math:`n \\geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    HypothesisTest_Spearman, HypothesisTest_PartialSpearman

    Notes
    -----
    The Full Spearman Test is used to check hypothesis of non monotonous relation
    between two samples: *firstSample* of dimension *n* and *secondSample* of
    dimension 1. If *firstSample[i]* is the numerical sample extracted from
    *firstSample* (:math:`i^{th}` coordinate of each point of the numerical sample),
    FullSpearman performs the independence Spearman test simultaneously on all
    *firstSample[i]* and *secondSample*.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction(['x'], ['x', 'x^2'])
    >>> testedSample = func(sample)
    >>> test_result = ot.HypothesisTest.FullSpearman(testedSample, sample)
    >>> print(test_result)
    [class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=false p-value threshold=0.05 p-value=0 description=[],class=TestResult name=Unnamed type=Spearman binaryQualityMeasure=true p-value threshold=0.05 p-value=0.44348 description=[]]

    """
  return _stattests.HypothesisTest_FullSpearman(*args)

class LinearModelTest(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelTest, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelTest, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def LinearModelAdjustedRSquared(*args):
        """
        Test the quality of the linear regression model Test.

        Based on the adjusted :math:`R^2` indicator.

        **Available usages**:

            LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample*)

            LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, level*)

            LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, linearModel, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelFisher,
        LinearModelTest_LinearModelResidualMean

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
        distribution.

        The LinearModelAdjustedRSquared test checks the quality of the linear
        regression model. It evaluates the indicator :math:`R^2` adjusted (regression
        variance analysis) and compares it to a level.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelAdjustedRSquared(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=AdjustedRSquared binaryQualityMeasure=false p-value threshold=0.95 p-value=0.815998 description=[]

        """
        return _stattests.LinearModelTest_LinearModelAdjustedRSquared(*args)

    if _newclass:LinearModelAdjustedRSquared = staticmethod(LinearModelAdjustedRSquared)
    __swig_getmethods__["LinearModelAdjustedRSquared"] = lambda x: LinearModelAdjustedRSquared
    def LinearModelFisher(*args):
        """
        Test the nullity of the linear regression model coefficients.

        **Available usages**:

            LinearModelTest.LinearModelFisher(*firstSample, secondSample*)

            LinearModelTest.LinearModelFisher(*firstSample, secondSample, level*)

            LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModel, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelAdjustedRSquared,
        LinearModelTest_LinearModelResidualMean

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
        distribution.

        The LinearModelFisher test checks the nullity of the regression linear model
        coefficients (Fisher distribution is used).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelFisher(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=Fisher binaryQualityMeasure=false p-value threshold=0.05 p-value=1 description=[]

        """
        return _stattests.LinearModelTest_LinearModelFisher(*args)

    if _newclass:LinearModelFisher = staticmethod(LinearModelFisher)
    __swig_getmethods__["LinearModelFisher"] = lambda x: LinearModelFisher
    def LinearModelResidualMean(*args):
        """
        Test zero mean value of the residual of the linear regression model.

        **Available usages**:

            LinearModelTest.LinearModelResidualMean(*firstSample, secondSample*)

            LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, level*)

            LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModel, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelAdjustedRSquared,  LinearModelTest_LinearModelFisher, LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelHarrisonMcCabe

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
        distribution.

        The LinearModelResidualMean Test checks, under the hypothesis of a gaussian
        sample, if the mean of the residual is equal to zero. It is based on the Student
        test (equality of mean for two gaussian samples).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelResidualMean(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=ResidualMean binaryQualityMeasure=true p-value threshold=0.05 p-value=1 description=[]

        """
        return _stattests.LinearModelTest_LinearModelResidualMean(*args)

    if _newclass:LinearModelResidualMean = staticmethod(LinearModelResidualMean)
    __swig_getmethods__["LinearModelResidualMean"] = lambda x: LinearModelResidualMean
    def LinearModelRSquared(*args):
        """
        Test the quality of the linear regression model based on the :math:`R^2` indicator.

        **Available usages**:

            LinearModelTest.LinearModelRSquared(*firstSample, secondSample*)

            LinearModelTest.LinearModelRSquared(*firstSample, secondSample, level*)

            LinearModelTest.LinearModelRSquared(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelRSquared(*firstSample, secondSample, linearModel, level*)


        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelAdjustedRSquared,  LinearModelTest_LinearModelFisher, LinearModelTest_LinearModelResidualMean

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
        distribution.

        The LinearModelRSquared test checks the quality of the linear
        regression model. It evaluates the indicator :math:`R^2` (regression
        variance analysis) and compares it to a level.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelRSquared(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=RSquared binaryQualityMeasure=false p-value threshold=0.95 p-value=0.822343 description=[]

        """
        return _stattests.LinearModelTest_LinearModelRSquared(*args)

    if _newclass:LinearModelRSquared = staticmethod(LinearModelRSquared)
    __swig_getmethods__["LinearModelRSquared"] = lambda x: LinearModelRSquared
    def LinearModelHarrisonMcCabe(*args):
        """
        Test the homoskedasticity of the linear regression model residuals.

        **Available usages**:

            LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample*)

            LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, level, breakPoint, simulationSize*)

            LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModel, level, breakPoint, simulationSize*)

        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.
        breakPoint : positive float :math:`< 1`
            Percentage of data to be taken as breakPoint in the variances. It must be
            :math:`< 1`, equal to 0.5 by default.
        simulationSize : positive int
            Size of the sample used to compute the p-value. Default is 1000.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelBreuschPagan, LinearModelTest_LinearModelResidualMean,
        LinearModelTest_LinearModelDurbinWatson

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual.

        The Harrison-McCabe test checks the heteroskedasticity of the residuals. The
        breakpoint in the variances is set by default to the half of the sample. The
        p-value is estimed using simulation. If the binary quality measure is false, then
        the homoskedasticity hypothesis can be rejected with respect to the given level.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelHarrisonMcCabe(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=HarrisonMcCabe binaryQualityMeasure=true p-value threshold=0.95 p-value=0.142 description=[]

        """
        return _stattests.LinearModelTest_LinearModelHarrisonMcCabe(*args)

    if _newclass:LinearModelHarrisonMcCabe = staticmethod(LinearModelHarrisonMcCabe)
    __swig_getmethods__["LinearModelHarrisonMcCabe"] = lambda x: LinearModelHarrisonMcCabe
    def LinearModelBreuschPagan(*args):
        """
        Test the homoskedasticity of the linear regression model residuals.

        **Available usages**:

            LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample*)

            LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, level*)

            LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModel, level*)

        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelHarrisonMcCabe, LinearModelTest_LinearModelResidualMean,
        LinearModelTest_LinearModelDurbinWatson

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual.

        The Breusch-Pagan test checks the heteroskedasticity of the residuals. A linear
        regression model is fitted on the squared residuals. The statistic is computed
        using the Studendized version with the chi-squared distribution. If the binary
        quality measure is false, then the homoskedasticity hypothesis can be rejected
        with respect to the given level.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelBreuschPagan(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=BreuschPagan binaryQualityMeasure=true p-value threshold=0.95 p-value=0.700772 description=[]

        """
        return _stattests.LinearModelTest_LinearModelBreuschPagan(*args)

    if _newclass:LinearModelBreuschPagan = staticmethod(LinearModelBreuschPagan)
    __swig_getmethods__["LinearModelBreuschPagan"] = lambda x: LinearModelBreuschPagan
    def LinearModelDurbinWatson(*args):
        """
        Test the autocorrelation of the linear regression model residuals.

        **Available usages**:

            LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample*)

            LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, hypothesis, level*)

            LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModel*)

            LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModel, hypothesis, level*)

        Parameters
        ----------
        fisrtSample : 2-d sequence of float
            First tested sample, of dimension 1.
        secondSample : 2-d sequence of float
            Second tested sample, of dimension 1.
        linearModel : :class:`~openturns.LinearModel`
            A linear model. If not provided, it is built using the given samples.
        hypothesis : string
            Hypothesis H0 for the residuals. It can be : 'Equal' to 0, 'Less' than 0 or
            'Greater' than 0. Default is set to 'Equal' to 0.
        level : positive float :math:`< 1`
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        LinearModelTest_LinearModelBreuschPagan, LinearModelTest_LinearModelHarrisonMcCabe, LinearModelTest_LinearModelResidualMean

        Notes
        -----
        The LinearModelTest class is used through its static methods in order to evaluate
        the quality of the linear regression model between two samples
        (see :class:`~openturns.LinearModel`). The linear regression model between the
        scalar variable :math:`Y` and the :math:`n`-dimensional one
        :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

        .. math::

            \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

        where :math:`\\epsilon` is the residual.

        The Durbin-Watson test checks the autocorrelation of the residuals. It is possible
        to test is the autocorrelation is equal to 0, and less or greater than 0. The
        p-value is computed using a normal approximation with mean and variance of the
        Durbin-Watson test statistic. If the binary quality measure is false, then the
        given autocorrelation hypothesis can be rejected with respect to the given level.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
        >>> firstSample = sample
        >>> secondSample = func(sample) + ot.Normal().getSample(30)
        >>> test_result = ot.LinearModelTest.LinearModelDurbinWatson(firstSample, secondSample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=DurbinWatson binaryQualityMeasure=true p-value threshold=0.95 p-value=0.653603 description=[Hypothesis test: autocorrelation equals 0.]

        """
        return _stattests.LinearModelTest_LinearModelDurbinWatson(*args)

    if _newclass:LinearModelDurbinWatson = staticmethod(LinearModelDurbinWatson)
    __swig_getmethods__["LinearModelDurbinWatson"] = lambda x: LinearModelDurbinWatson
    __swig_destroy__ = _stattests.delete_LinearModelTest
    __del__ = lambda self : None;
LinearModelTest_swigregister = _stattests.LinearModelTest_swigregister
LinearModelTest_swigregister(LinearModelTest)

def LinearModelTest_LinearModelAdjustedRSquared(*args):
  """
    Test the quality of the linear regression model Test.

    Based on the adjusted :math:`R^2` indicator.

    **Available usages**:

        LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample*)

        LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelAdjustedRSquared(*firstSample, secondSample, linearModel, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelFisher,
    LinearModelTest_LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelAdjustedRSquared test checks the quality of the linear
    regression model. It evaluates the indicator :math:`R^2` adjusted (regression
    variance analysis) and compares it to a level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelAdjustedRSquared(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=AdjustedRSquared binaryQualityMeasure=false p-value threshold=0.95 p-value=0.815998 description=[]

    """
  return _stattests.LinearModelTest_LinearModelAdjustedRSquared(*args)

def LinearModelTest_LinearModelFisher(*args):
  """
    Test the nullity of the linear regression model coefficients.

    **Available usages**:

        LinearModelTest.LinearModelFisher(*firstSample, secondSample*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModel, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelAdjustedRSquared,
    LinearModelTest_LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelFisher test checks the nullity of the regression linear model
    coefficients (Fisher distribution is used).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelFisher(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=Fisher binaryQualityMeasure=false p-value threshold=0.05 p-value=1 description=[]

    """
  return _stattests.LinearModelTest_LinearModelFisher(*args)

def LinearModelTest_LinearModelResidualMean(*args):
  """
    Test zero mean value of the residual of the linear regression model.

    **Available usages**:

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModel, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelAdjustedRSquared,  LinearModelTest_LinearModelFisher, LinearModelTest_LinearModelRSquared, LinearModelTest_LinearModelHarrisonMcCabe

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelResidualMean Test checks, under the hypothesis of a gaussian
    sample, if the mean of the residual is equal to zero. It is based on the Student
    test (equality of mean for two gaussian samples).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelResidualMean(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=ResidualMean binaryQualityMeasure=true p-value threshold=0.05 p-value=1 description=[]

    """
  return _stattests.LinearModelTest_LinearModelResidualMean(*args)

def LinearModelTest_LinearModelRSquared(*args):
  """
    Test the quality of the linear regression model based on the :math:`R^2` indicator.

    **Available usages**:

        LinearModelTest.LinearModelRSquared(*firstSample, secondSample*)

        LinearModelTest.LinearModelRSquared(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelRSquared(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelRSquared(*firstSample, secondSample, linearModel, level*)


    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelAdjustedRSquared,  LinearModelTest_LinearModelFisher, LinearModelTest_LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelRSquared test checks the quality of the linear
    regression model. It evaluates the indicator :math:`R^2` (regression
    variance analysis) and compares it to a level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelRSquared(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=RSquared binaryQualityMeasure=false p-value threshold=0.95 p-value=0.822343 description=[]

    """
  return _stattests.LinearModelTest_LinearModelRSquared(*args)

def LinearModelTest_LinearModelHarrisonMcCabe(*args):
  """
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, level, breakPoint, simulationSize*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModel, level, breakPoint, simulationSize*)

    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.
    breakPoint : positive float :math:`< 1`
        Percentage of data to be taken as breakPoint in the variances. It must be
        :math:`< 1`, equal to 0.5 by default.
    simulationSize : positive int
        Size of the sample used to compute the p-value. Default is 1000.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelBreuschPagan, LinearModelTest_LinearModelResidualMean,
    LinearModelTest_LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual.

    The Harrison-McCabe test checks the heteroskedasticity of the residuals. The
    breakpoint in the variances is set by default to the half of the sample. The
    p-value is estimed using simulation. If the binary quality measure is false, then
    the homoskedasticity hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelHarrisonMcCabe(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=HarrisonMcCabe binaryQualityMeasure=true p-value threshold=0.95 p-value=0.142 description=[]

    """
  return _stattests.LinearModelTest_LinearModelHarrisonMcCabe(*args)

def LinearModelTest_LinearModelBreuschPagan(*args):
  """
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModel, level*)

    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelHarrisonMcCabe, LinearModelTest_LinearModelResidualMean,
    LinearModelTest_LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual.

    The Breusch-Pagan test checks the heteroskedasticity of the residuals. A linear
    regression model is fitted on the squared residuals. The statistic is computed
    using the Studendized version with the chi-squared distribution. If the binary
    quality measure is false, then the homoskedasticity hypothesis can be rejected
    with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelBreuschPagan(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=BreuschPagan binaryQualityMeasure=true p-value threshold=0.95 p-value=0.700772 description=[]

    """
  return _stattests.LinearModelTest_LinearModelBreuschPagan(*args)

def LinearModelTest_LinearModelDurbinWatson(*args):
  """
    Test the autocorrelation of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, hypothesis, level*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModel*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModel, hypothesis, level*)

    Parameters
    ----------
    fisrtSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModel : :class:`~openturns.LinearModel`
        A linear model. If not provided, it is built using the given samples.
    hypothesis : string
        Hypothesis H0 for the residuals. It can be : 'Equal' to 0, 'Less' than 0 or
        'Greater' than 0. Default is set to 'Equal' to 0.
    level : positive float :math:`< 1`
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    LinearModelTest_LinearModelBreuschPagan, LinearModelTest_LinearModelHarrisonMcCabe, LinearModelTest_LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples
    (see :class:`~openturns.LinearModel`). The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\\vect{X} = (X_i)_{i \\leq n}` is as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual.

    The Durbin-Watson test checks the autocorrelation of the residuals. It is possible
    to test is the autocorrelation is equal to 0, and less or greater than 0. The
    p-value is computed using a normal approximation with mean and variance of the
    Durbin-Watson test statistic. If the binary quality measure is false, then the
    given autocorrelation hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.NumericalMathFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelDurbinWatson(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=DurbinWatson binaryQualityMeasure=true p-value threshold=0.95 p-value=0.653603 description=[Hypothesis test: autocorrelation equals 0.]

    """
  return _stattests.LinearModelTest_LinearModelDurbinWatson(*args)

class NormalityTest(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormalityTest, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NormalityTest, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def AndersonDarlingNormal(*args):
        """
        Evaluate whether a sample follows a normal distribution.

        Using the Anderson Darling Normal test.

        **Available usages**:

            NormalityTest.AndersonDarlingNormal(*sample*)

            NormalityTest.AndersonDarlingNormal(*sample, level*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        level : positive float
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        NormalityTest_CramerVonMisesNormal

        Notes
        -----
        The test is used to check whether the sample follows a normal distribution. This
        test gives more importance to extreme values.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> test_result = ot.NormalityTest.AndersonDarlingNormal(sample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=AndersonDarlingNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.7268 description=[]

        """
        return _stattests.NormalityTest_AndersonDarlingNormal(*args)

    if _newclass:AndersonDarlingNormal = staticmethod(AndersonDarlingNormal)
    __swig_getmethods__["AndersonDarlingNormal"] = lambda x: AndersonDarlingNormal
    def CramerVonMisesNormal(*args):
        """
        Evaluate whether a sample follows a normal distribution.

        Using the Cramer Von Mises Normal test.

        **Available usages**:

            NormalityTest.CramerVonMisesNormal(*sample*)

            NormalityTest.CramerVonMisesNormal(*sample, level*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Tested sample.
        level : positive float
            Threshold p-value of the test (= 1 - first type risk), it must be
            :math:`< 1`, equal to 0.95 by default.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Structure containing the result of the test.

        See Also
        --------
        NormalityTest_AndersonDarlingNormal

        Notes
        -----
        The test is used to check whether the sample follows a normal distribution. The 
        test concerns the deviation squared and integrated over the entire variation
        domain, it often appears to be more robust than the Kolmogorov-Smirnov test.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Normal()
        >>> sample = distribution.getSample(30)
        >>> test_result = ot.NormalityTest.CramerVonMisesNormal(sample)
        >>> print(test_result)
        class=TestResult name=Unnamed type=CramerVonMisesNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.682524 description=[]

        """
        return _stattests.NormalityTest_CramerVonMisesNormal(*args)

    if _newclass:CramerVonMisesNormal = staticmethod(CramerVonMisesNormal)
    __swig_getmethods__["CramerVonMisesNormal"] = lambda x: CramerVonMisesNormal
    __swig_destroy__ = _stattests.delete_NormalityTest
    __del__ = lambda self : None;
NormalityTest_swigregister = _stattests.NormalityTest_swigregister
NormalityTest_swigregister(NormalityTest)

def NormalityTest_AndersonDarlingNormal(*args):
  """
    Evaluate whether a sample follows a normal distribution.

    Using the Anderson Darling Normal test.

    **Available usages**:

        NormalityTest.AndersonDarlingNormal(*sample*)

        NormalityTest.AndersonDarlingNormal(*sample, level*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    level : positive float
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    NormalityTest_CramerVonMisesNormal

    Notes
    -----
    The test is used to check whether the sample follows a normal distribution. This
    test gives more importance to extreme values.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.NormalityTest.AndersonDarlingNormal(sample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=AndersonDarlingNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.7268 description=[]

    """
  return _stattests.NormalityTest_AndersonDarlingNormal(*args)

def NormalityTest_CramerVonMisesNormal(*args):
  """
    Evaluate whether a sample follows a normal distribution.

    Using the Cramer Von Mises Normal test.

    **Available usages**:

        NormalityTest.CramerVonMisesNormal(*sample*)

        NormalityTest.CramerVonMisesNormal(*sample, level*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Tested sample.
    level : positive float
        Threshold p-value of the test (= 1 - first type risk), it must be
        :math:`< 1`, equal to 0.95 by default.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    NormalityTest_AndersonDarlingNormal

    Notes
    -----
    The test is used to check whether the sample follows a normal distribution. The 
    test concerns the deviation squared and integrated over the entire variation
    domain, it often appears to be more robust than the Kolmogorov-Smirnov test.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> test_result = ot.NormalityTest.CramerVonMisesNormal(sample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=CramerVonMisesNormal binaryQualityMeasure=true p-value threshold=0.05 p-value=0.682524 description=[]

    """
  return _stattests.NormalityTest_CramerVonMisesNormal(*args)

class DickeyFullerTest(openturns.common.PersistentObject):
    """
    The Dickey-Fuller stationarity test.

    Notes
    -----
    The Dickey-Fuller test checks the stationarity of a scalar time series using one time series. It assumes that the :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset` process with :math:`\\cD \\in \\Rset`, discretized on the time grid :math:`(t_0, \\dots, t_{N-1})` writes:

    .. math::
        :label: DFmodel

        X_t = a + bt + \\rho X_{t-1} + \\varepsilon_{t}

    where :math:`\\rho > 0` and where :math:`a` or :math:`b` or both :math:`(a,b)` can be assumed to be equal to 0.

    The Dickey-Fuller test checks whether the random perturbation at time :math:`t` vanishes with time.

    When :math:`a \\neq 0` and :math:`b=0`, the model :eq:`DFmodel` is said to have a *drift*. When :math:`a = 0` and :math:`b \\neq 0`, the model :eq:`DFmodel` is said to have a *linear trend*.

    In the model :eq:`DFmodel`, the only way to have stochastic non stationarity is to have :math:`\\rho = 1` (if :math:`\\rho > 1`, then the process diverges with time which is readily seen in the data). In the general case, the Dickey-Fuller test is a unit root test to detect whether :math:`\\rho=1` against :math:`\\rho < 1`:

    The test statistics and its limit distribution depend on the a priori knowledge we have on :math:`a` and :math:`b`. In case of absence of a priori knowledge on the structure of the model, several authors have proposed a global strategy to cover all the subcases of the model :eq:`DFmodel`, depending on the possible values on :math:`a` and :math:`b`. 

    The strategy implemented in OpenTURNS, is recommended by Enders (*Applied Econometric Times Series*, Enders, W., second edition, John Wiley \\& sons editions, 2004.).



    We note :math:`(X_1, \\hdots, X_n)` the data, by :math:`W(r)` the Wiener process, and :math:`W^{a}(r) = W(r) - \\int_{0}^{1} W(r)\\di{r}`, :math:`W^{b}(r) = W^{a}(r) - 12 \\left(r - \\frac{1}{2} \\right) \\int_{0}^{1} \\left(s - \\frac{1}{2} \\right) W(s)\\di{s}`.


    **1.** We assume the model :eq:`Model1`:

    .. math::
        :label: Model1

        \\boldsymbol{X_t = a + bt + \\rho X_{t-1} + \\varepsilon_{t}}

    The coefficients :math:`(a,b,\\rho)` are estimated by :math:`(\\Hat{a}_n, \\Hat{b}_n, \\Hat{\\rho}_n)` using ordinary least-squares fitting, which leads to:

    .. math::
        :label: Model1Estim

        \\underbrace{\\left(
           \\begin{array}{lll}
             \\displaystyle n-1 &\\sum_{i=1}^n t_{i} &\\sum_{i=2}^n y_{i-1}\\\\
             \\displaystyle \\sum_{i=1}^n t_{i} &\\sum_{i=1}^n t_{i}^2 &\\sum_{i=2}^n t_{i} y_{i-1}\\\\
             \\displaystyle \\sum_{i=2}^n y_{i-1}& \\sum_{i=2}^n t_{i}y_{i-1} &\\sum_{i=2}^n y_{i-1}^2
           \\end{array}
           \\right)}_{\\mat{M}}
         \\left(
           \\begin{array}{c}
            \\hat{a}_n\\\\
            \\hat{b}_n\\\\
            \\hat{\\rho}_n
           \\end{array}
         \\right)=
         \\left(
         \\begin{array}{l}
           \\displaystyle \\sum_{i=1}^n y_{i} \\\\
           \\displaystyle \\sum_{i=1}^n t_{i} y_{i}\\\\
           \\displaystyle \\sum_{i=2}^n y_{i-1} y_{i}
         \\end{array}
         \\right)


    We first test:

    .. math::
        :label: TestModel1

        \\left\\{
        \\begin{array}{lr}
          \\cH_0: & \\rho = 1 \\\\
          \\cH_1: & \\rho < 1
        \\end{array}
        \\right.

    thanks to the Student statistics:

    .. math::

        t_{\\rho=1} = \\frac{\\rho_n-1}{\\hat{\\sigma}_{\\rho_n}}

    where :math:`\\sigma_{\\rho_n}` is the least square estimate of the standard deviation of :math:`\\Hat{\\rho}_n`, given by:

    .. math::

        \\sigma_{\\rho_n}=\\mat{M}^{-1}_{33}\\sqrt{\\frac{1}{n-1}\\sum_{i=2}^n\\left(y_{i}-(\\hat{a}_n+\\hat{b}_nt_i+\\hat{\\rho}_ny_{i-1})\\right)^2}


    which converges in distribution to the Dickey-Fuller distribution associated to the model with drift and trend:

    .. math::

        t_{\\rho = 1} \\stackrel{\\mathcal{L}}{\\longrightarrow} \\frac{\\int_{0}^{1}W^{b}(r) \\di{W(r)}}{\\int_{1}^{0} W^{b}(r)^2 \\di{r}}

    The null hypothesis :math:`\\cH_0` from :eq:`TestModel1` is accepted when :math:`t_{\\rho=1} > C_{\\alpha}` where :math:`C_{\\alpha}` is the test threshold of level :math:`\\alpha`.

    The quantiles of the Dickey-Fuller statistics for the model with drift and linear trend are:

    .. math::
        
        \\left\\{
        \\begin{array}{ll}
            \\alpha = 0.01, & C_{\\alpha} = -3.96 \\\\
            \\alpha = 0.05, & C_{\\alpha} = -3.41 \\\\
            \\alpha = 0.10, & C_{\\alpha} = -3.13
        \\end{array}
        \\right.


    **1.1. Case 1:** The null hypothesis :math:`\\cH_0` from :eq:`TestModel1` is rejected

    We test whether :math:`b=0`:

    .. math::
        :label: TestSousModele1_1

        \\left\\{
        \\begin{array}{lr}
          \\cH_0: & b = 0 \\\\
          \\cH_1: & b \\neq 0
        \\end{array}
        \\right.

    where the statistics :math:`t_n = \\frac{|\\hat{b}_n|}{\\sigma_{b_n}}` converges in distribution to the Student distribution :class:`~openturns.Student` with :math:`\\nu=n-4`, where :math:`\\sigma_{b_n}` is the least square estimate of the standard deviation of :math:`\\Hat{b}_n`, given by:

    .. math::

        \\sigma_{b_n}=\\mat{M}^{-1}_{22}\\sqrt{\\frac{1}{n-1}\\sum_{i=2}^n\\left(y_{i}-(\\hat{a}_n+\\hat{b}_nt_i+\\hat{\\rho}_ny_{i-1})\\right)^2}

    The decision to be taken is:
        - If :math:`\\cH_0` from :eq:`TestSousModele1_1` is rejected, then the model 1 :eq:`Model1` is confirmed. And the test :eq:`TestModel1` proved that the unit root is rejected : :math:`\\rho < 1`. We then conclude that the final model is : :math:`\\boldsymbol{X_t = a + bt + \\rho X_{t-1} + \\varepsilon_{t}}` whith :math:`\\boldsymbol{\\rho < 1}` which is a **trend stationary model**.

        - If :math:`\\cH_0` from :eq:`TestSousModele1_1` is accepted, then the model 1 :eq:`Model1` is not confirmed, since the trend presence is rejected and the test :eq:`TestModel1` is not conclusive (since based on a wrong model). **We then have to test the second model** :eq:`Model2`.


    **1.2. Case 2:** The null hypothesis :math:`\\cH_0` from :eq:`TestModel1` is accepted

    We test whether :math:`(\\rho, b) = (1,0)`:

    .. math::
        :label: TestSousModele1_2

        \\left\\{
        \\begin{array}{lr}
          \\cH_0: & (\\rho, b) = (1,0) \\\\
          \\cH_1: & (\\rho, b) \\neq (1,0)
        \\end{array}
        \\right.

    with the Fisher statistics:

    .. math::

        \\displaystyle \\hat{F}_1 = \\frac{(S_{1,0} - S_{1,b})/2}{S_{1,b}/(n-3)}

    where :math:`S_{1,0}=\\sum_{i=2}^n\\left(y_i-(\\hat{a}_n+y_{i-1})\\right)^2` is the sum of the square errors of the model 1 :eq:`Model1` assuming :math:`\\cH_0` from :eq:`TestSousModele1_2` and :math:`S_{1,b}=\\sum_{i=2}^n\\left(y_i-(\\hat{a}_n+\\hat{b}_nt_i+\\hat{\\rho}_ny_{i-1})\\right)^2` is the same sum when we make no assumption on :math:`\\rho` and :math:`b`.

    The statistics :math:`\\hat{F}_1` converges in distribution to the Fisher-Snedecor distribution :class:`~openturns.FisherSnedecor` with :math:`d_1=2, d_2=n-3`. The null hypothesis :math:`\\cH_0` from :eq:`TestModel1` is accepted when :math:`\\hat{F}_1 < \\Phi_{\\alpha}` where :math:`\\Phi_{\\alpha}` is the test threshold of level :math:`\\alpha`.

    The decision to be taken is:
        - If :math:`\\cH_0` from :eq:`TestSousModele1_2` is rejected, then the model 1 :eq:`Model1` is confirmed since the presence of linear trend is confirmed. And the test :eq:`TestModel1` proved that the unit root is accepted: :math:`\\rho = 1`. We then conclude that the model is: :math:`\\boldsymbol{X_t = a + bt + X_{t-1} + \\varepsilon_{t}}` which is a **non stationary model**.
        
        - If :math:`\\cH_0` from :eq:`TestSousModele1_2` is accepted, then the model 1 :eq:`Model1` is not confirmed, since the presence of the linear trend is rejected and the test :eq:`TestModel1` is not conclusive (since based on a wrong model). **We then have to test the second model** :eq:`Model2`.


    **2.** We assume the model :eq:`Model2`:

    .. math::
        :label: Model2

        \\boldsymbol{X_t = a + \\rho X_{t-1} + \\varepsilon_{t}}


    The coefficients :math:`(a,\\rho)` are estimated as follows:

    .. math::
        :label: Model2Estim

        \\underbrace{\\left(\\begin{array}{lll}
           \\displaystyle n-1 &\\sum_{i=2}^n y_{i-1}\\\\
           \\displaystyle \\sum_{i=2}^n y_{i-1} &\\sum_{i=2}^n y_{i-1}^2
                          \\end{array}
         \\right)}_{\\mat{N}}
         \\left(
          \\begin{array}{c}
            \\hat{a}_n\\\\
            \\hat{\\rho}_n
          \\end{array}
         \\right)=
         \\left(
          \\begin{array}{l}
            \\displaystyle \\sum_{i=1}^n y_{i} \\\\
            \\displaystyle \\sum_{i=2}^n y_{i-1} y_{i}
           \\end{array}
         \\right)
       

    We first test:

    .. math::
        :label: TestModel2

        \\left\\{
         \\begin{array}{lr}
           \\mathcal{H}_0: & \\rho = 1 \\\\
           \\mathcal{H}_1: & \\rho < 1
         \\end{array}
         \\right.

    thanks to the Student statistics:

    .. math::

        t_{\\rho=1} = \\frac{\\rho_n-1}{\\sigma_{\\rho_n}}

    where :math:`\\sigma_{\\rho_n}` is the least square estimate of the standard deviation of :math:`\\Hat{\\rho}_n`, given by:

    .. math::

        \\sigma_{\\rho_n}=\\mat{N}^{-1}_{22}\\sqrt{\\frac{1}{n-1}\\sum_{i=2}^n\\left(y_{i}-(\\hat{a}_n+\\hat{\\rho}_ny_{i-1})\\right)^2}

    which converges in distribution to the Dickey-Fuller distribution associated to the model with drift and no linear trend:

    .. math::

        t_{\\rho = 1} \\stackrel{\\mathcal{L}}{\\longrightarrow} \\frac{\\int_{0}^{1}W^{a}(r) \\di{W(r)}}{\\int_{1}^{0} W^{a}(r)^2 \\di{r}}

    The null hypothesis :math:`\\cH_0` from :eq:`TestModel2` is accepted when :math:`t_{\\rho=1} > C_{\\alpha}` where :math:`C_{\\alpha}` is the test threshold of level :math:`\\alpha`.

    The quantiles of the Dickey-Fuller statistics for the model with drift are:

    .. math::
        
        \\left\\{
        \\begin{array}{ll}
            \\alpha = 0.01, & C_{\\alpha} = -3.43 \\\\
            \\alpha = 0.05, & C_{\\alpha} = -2.86 \\\\
            \\alpha = 0.10, & C_{\\alpha} = -2.57
        \\end{array}
        \\right.


    **2.1. Case 1:** The null hypothesis :math:`\\cH_0` from :eq:`TestModel2` is rejected

    We test whether :math:`a=0`:

    .. math::
        :label: TestSousModele2_1
        
        \\left\\{
        \\begin{array}{lr}
          \\mathcal{H}_0: & a = 0 \\\\
          \\mathcal{H}_1: & a \\neq 0
        \\end{array}
        \\right.

    where the statistics :math:`t_n = \\frac{|\\hat{a}_n|}{\\sigma_{a_n}}` converges in distribution to the Student distribution :class:`~openturns.Student` with :math:`\\nu=n-3`, where :math:`\\sigma_{a_n}` is the least square estimate of the standard deviation of :math:`\\Hat{a}_n`, given by:

    .. math::

        \\sigma_{a_n}=\\mat{N}^{-1}_{11}\\sqrt{\\frac{1}{n-1}\\sum_{i=2}^n\\left(y_{i}-(\\hat{a}_n+\\hat{\\rho}_ny_{i-1})\\right)^2}

    The decision to be taken is:
        - If :math:`\\cH_0` from :eq:`TestSousModele2_1` is rejected, then the model 2 :eq:`Model2` is confirmed. And the test :eq:`TestModel2` proved that the unit root is rejected: :math:`\\rho < 1`. We then conclude that the final model is: :math:`\\boldsymbol{X_t = a + \\rho X_{t-1} + \\varepsilon_{t}}` whith :math:`\\boldsymbol{\\rho < 1}` which is a **stationary model**.

        - If :math:`\\cH_0` from :eq:`TestSousModele2_1` is accepted, then the model 2 :eq:`Model2` is not confirmed, since the drift presence is rejected and the test :eq:`TestModel1` is not conclusive (since based on a wrong model). **We then have to test the third model** :eq:`Model3`.


    **2.2. Case 2:** The null hypothesis :math:`\\cH_0` from :eq:`TestModel2` is accepted

    We test whether :math:`(\\rho, a) = (1,0)`:

    .. math::
        :label: TestSousModele2_2

        \\left\\{
        \\begin{array}{lr}
          \\mathcal{H}_0: & (\\rho, a) = (1,0) \\\\
          \\mathcal{H}_1: & (\\rho, a) \\neq (1,0)
        \\end{array}
        \\right.

    with a Fisher test. The statistics is:

    .. math::

        \\displaystyle \\hat{F}_2 = \\frac{(SCR_{2,c} - SCR_{2})/2}{SCR_{2}/(n-2)}

    where :math:`SCR_{2,c}` is the sum of the square errors of the model 2 :eq:`Model2` assuming :math:`\\cH_0` from :eq:`TestSousModele2_2` and :math:`SCR_{2}` is the same sum when we make no assumption on :math:`\\rho` and :math:`a`.

    The statistics :math:`\\hat{F}_2` converges in distribution to the Fisher-Snedecor distribution :class:`~openturns.FisherSnedecor` with :math:`d_1=2, d_2=n-2`. The null hypothesis :math:`\\cH_0` from :eq:`TestModel1` is accepted if when :math:`\\hat{F}_2 < \\Phi_{\\alpha}` where :math:`\\Phi_{\\alpha}` is the test threshold of level :math:`\\alpha`.

    The decision to be taken is:
        - If :math:`\\cH_0` from :eq:`TestSousModele2_2` is rejected, then the model 2 :eq:`Model2` is confirmed since the presence of the drift is confirmed. And the test :eq:`TestModel2` proved that the unit root is accepted: :math:`\\rho =1`. We then conclude that the model is: :math:`\\boldsymbol{X_t = a + X_{t-1} + \\varepsilon_{t}}` which is a **non stationary model**.

        - If :math:`\\cH_0` from :eq:`TestSousModele2_2` is accepted, then the model 2 :eq:`Model2` is not confirmed, since the drift presence is rejected and the test :eq:`TestModel2` is not conclusive (since based on a wrong model). **We then have to test the third model** :eq:`Model3`.



    **3.** We assume the model :eq:`Model3`:

    .. math::
        :label: Model3

        \\boldsymbol{X_t = \\rho X_{t-1} + \\varepsilon_{t}}

    The coefficients :math:`\\rho` are estimated as follows:

    .. math::
        :label: Model3Estim

        \\hat{\\rho}_n=\\frac{\\sum_{i=2}^ny_{i-1}y_i}{\\sum_{i=2}^ny_{i-1}^2}

    We first test:

    .. math::
        :label: TestModel3
      
        \\left\\{
        \\begin{array}{lr}
          \\mathcal{H}_0: & \\rho = 1 \\\\
          \\mathcal{H}_1: & \\rho < 1
        \\end{array}
        \\right.

    thanks to the Student statistics:

    .. math::

        t_{\\rho=1} = \\frac{\\hat{\\rho}_n-1}{\\sigma_{\\rho_n}}

    where :math:`\\sigma_{\\rho_n}` is the least square estimate of the standard deviation of :math:`\\Hat{\\rho}_n`, given by:

    .. math::

        \\sigma_{\\rho_n}=\\sqrt{\\frac{1}{n-1}\\sum_{i=2}^n\\left(y_{i}-\\hat{\\rho}_ny_{i-1}\\right)^2}/\\sqrt{\\sum_{i=2}^ny_{i-1}^2}

    which converges in distribution to the Dickey-Fuller distribution associated to the random walk model:

    .. math::

        t_{\\rho = 1} \\stackrel{\\mathcal{L}}{\\longrightarrow} \\frac{\\int_{0}^{1}W(r) \\di{W(r)}}{\\int_{1}^{0} W(r)^2 \\di{r}}

    The null hypothesis :math:`\\cH_0` from :eq:`TestModel3` is accepted when :math:`t_{\\rho=1} > C_{\\alpha}` where :math:`C_{\\alpha}` is the test threshold of level :math:`\\alpha`.

    The quantiles of the Dickey-Fuller statistics for the random walk model are:

    .. math::
        
        \\left\\{
        \\begin{array}{ll}
            \\alpha = 0.01, & C_{\\alpha} = -2.57 \\\\
            \\alpha = 0.05, & C_{\\alpha} = -1.94 \\\\
            \\alpha = 0.10, & C_{\\alpha} = -1.62
        \\end{array}
        \\right.

    The decision to be taken is:
        - If :math:`\\cH_0` from :eq:`TestModel3` is rejected, we then conclude that the model is : :math:`\\boldsymbol{X_t = \\rho X_{t-1} + \\varepsilon_{t}}` where :math:`\\rho < 1` which is a **stationary model**.

        - If :math:`\\cH_0` from :eq:`TestModel3` is accepted, we then conclude that the model is: :math:`\\boldsymbol{X_t = X_{t-1} + \\varepsilon_{t}}` which is a **non stationary model**.


    Examples
    --------
    Create an ARMA process and generate a time series:

    >>> import openturns as ot
    >>> arcoefficients = ot.ARMACoefficients([0.3])
    >>> macoefficients = ot.ARMACoefficients(0)
    >>> timeGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> whiteNoise = ot.WhiteNoise(ot.Normal(), timeGrid)
    >>> myARMA = ot.ARMA(arcoefficients, macoefficients, whiteNoise)

    >>> realization = ot.TimeSeries(myARMA.getRealization())
    >>> test = ot.DickeyFullerTest(realization)

    Test the stationarity of the data without any asumption on the model:

    >>> globalRes = test.runStrategy()

    Test the stationarity knowing you have a drift and linear trend model:

    >>> res1 = test.testUnitRootInDriftAndLinearTrendModel(0.95)

    Test the stationarity knowing you have a drift model:

    >>> res2 = test.testUnitRootInDriftModel(0.95)
     
    Test the stationarity knowing you have an AR1 model:

    >>> res3 = test.testUnitRootInAR1Model(0.95)


    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DickeyFullerTest, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DickeyFullerTest, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _stattests.DickeyFullerTest_getClassName(self)

    def testUnitRootInDriftAndLinearTrendModel(self, level=0.95):
        """
        Test for unit root in model with drift and trend.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel1`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInDriftAndLinearTrendModel(self, level)

    def testUnitRootInDriftModel(self, level=0.95):
        """
        Test for unit root in model with drift.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInDriftModel(self, level)

    def testUnitRootInAR1Model(self, level=0.95):
        """
        Test for unit root in AR1 model.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestModel3`.

        """
        return _stattests.DickeyFullerTest_testUnitRootInAR1Model(self, level)

    def runStrategy(self, level=0.95):
        """
        Test the stationarity without any assumption on the model.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the tests. The strategy if the one described above.

        """
        return _stattests.DickeyFullerTest_runStrategy(self, level)

    def testUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level=0.95):
        """
        Test for linear trend in model with unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele1_2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level)

    def testNoUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level=0.95):
        """
        Test for trend in model without unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele1_1`.

        """
        return _stattests.DickeyFullerTest_testNoUnitRootAndNoLinearTrendInDriftAndLinearTrendModel(self, level)

    def testUnitRootAndNoDriftInDriftModel(self, level=0.95):
        """
        Test for null drift in model with unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele2_2`.

        """
        return _stattests.DickeyFullerTest_testUnitRootAndNoDriftInDriftModel(self, level)

    def testNoUnitRootAndNoDriftInDriftModel(self, level=0.95):
        """
        Test for null drift in model without unit root.

        Parameters
        ----------
        alpha : float, :math:`0 < \\alpha < 1`
            The first order error of the test.

            By default, :math:`\\alpha=0.95`.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Results container of the test detailed in :eq:`TestSousModele2_1`.

        """
        return _stattests.DickeyFullerTest_testNoUnitRootAndNoDriftInDriftModel(self, level)

    def setVerbose(self, *args): return _stattests.DickeyFullerTest_setVerbose(self, *args)
    def getVerbose(self): return _stattests.DickeyFullerTest_getVerbose(self)
    def __init__(self, *args): 
        this = _stattests.new_DickeyFullerTest(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _stattests.delete_DickeyFullerTest
    __del__ = lambda self : None;
DickeyFullerTest_swigregister = _stattests.DickeyFullerTest_swigregister
DickeyFullerTest_swigregister(DickeyFullerTest)

# This file is compatible with both classic and new-style classes.


