# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Designs of experiments.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_experiment', [dirname(__file__)])
        except ImportError:
            import _experiment
            return _experiment
        if fp is not None:
            try:
                _mod = imp.load_module('_experiment', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _experiment = swig_import_helper()
    del swig_import_helper
else:
    import _experiment
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _experiment.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _experiment.SwigPyIterator_value(self)
    def incr(self, n=1): return _experiment.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _experiment.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _experiment.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _experiment.SwigPyIterator_equal(self, *args)
    def copy(self): return _experiment.SwigPyIterator_copy(self)
    def next(self): return _experiment.SwigPyIterator_next(self)
    def __next__(self): return _experiment.SwigPyIterator___next__(self)
    def previous(self): return _experiment.SwigPyIterator_previous(self)
    def advance(self, *args): return _experiment.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _experiment.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _experiment.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _experiment.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _experiment.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _experiment.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _experiment.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _experiment.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _experiment.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
class ExperimentImplementation(openturns.common.PersistentObject):
    """
    Base class for design of experiments.

    Considering :math:`\\vect{x}=x^1,\\dots, x^n` a vector of input parameters, this
    class is used to determine a particular set of values of :math:`\\vect{x}`
    according to a particular design of experiments.

    Different types of design of experiments can be determined:

    - some stratified patterns: axial, composite, factorial or box patterns,

    - some weighted patterns that we can split into different categories:
      the random patterns, the low discrepancy sequences and the deterministic
      patterns.

    Examples
    --------
    Define a custom design of experiment:
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> class RandomExp(object):
    ...     def generate(self):
    ...         return ot.Normal(1).getSample(10)
    >>> experiment = ot.Experiment(RandomExp())
    >>> sample = experiment.generate()

    See also
    --------
    StratifiedExperiment, WeightedExperiment
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExperimentImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExperimentImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.ExperimentImplementation_getClassName(self)

    def __repr__(self): return _experiment.ExperimentImplementation___repr__(self)
    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.ExperimentImplementation_generate(self)

    def __init__(self, *args): 
        this = _experiment.new_ExperimentImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_ExperimentImplementation
    __del__ = lambda self : None;
ExperimentImplementation_swigregister = _experiment.ExperimentImplementation_swigregister
ExperimentImplementation_swigregister(ExperimentImplementation)

class StratifiedExperiment(ExperimentImplementation):
    """
    Base class for stratified experiments.

    Available constructor:
        StratifiedExperiment(*center, levels*)

    Parameters
    ----------
    center, levels : two sequences of float
        Sequences which have different meanings according to the nature of the
        stratified experiment: Axial, Composite, Factorial or Box (see
        corresponding documentation).

    Notes
    -----
    A StratifiedExperiment object can be used only through its derived classes:

    - :class:`~openturns.Axial`
    - :class:`~openturns.Box`
    - :class:`~openturns.Composite`
    - :class:`~openturns.Factorial`.
    """
    __swig_setmethods__ = {}
    for _s in [ExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StratifiedExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [ExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, StratifiedExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.StratifiedExperiment_getClassName(self)

    def __repr__(self): return _experiment.StratifiedExperiment___repr__(self)
    def setCenter(self, *args):
        """
        Set the center of the stratified experiment.

        Parameters
        ----------
        center : sequence of float
            Sequence which has different meanings according to the nature of the
            stratified experiment: Axial, Composite, Factorial or Box (see
            corresponding documentation).
        """
        return _experiment.StratifiedExperiment_setCenter(self, *args)

    def getCenter(self):
        """
        Get the center of the stratified experiment.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            Sequence which has different meanings according to the nature of the
            stratified experiment: Axial, Composite, Factorial or Box (see
            corresponding documentation).
        """
        return _experiment.StratifiedExperiment_getCenter(self)

    def setLevels(self, *args):
        """
        Set the levels of the stratified experiment.

        Parameters
        ----------
        levels : sequence of float
            Sequence which has different meanings according to the nature of the
            stratified experiment: Axial, Composite, Factorial or Box (see
            corresponding documentation).
        """
        return _experiment.StratifiedExperiment_setLevels(self, *args)

    def getLevels(self):
        """
        Get the levels of the stratified experiment.

        Returns
        -------
        levels : :class:`~openturns.NumericalPoint`
            Sequence which has different meanings according to the nature of the
            stratified experiment: Axial, Composite, Factorial or Box (see
            corresponding documentation).
        """
        return _experiment.StratifiedExperiment_getLevels(self)

    def __init__(self, *args): 
        this = _experiment.new_StratifiedExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_StratifiedExperiment
    __del__ = lambda self : None;
StratifiedExperiment_swigregister = _experiment.StratifiedExperiment_swigregister
StratifiedExperiment_swigregister(StratifiedExperiment)

class ExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExperimentImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExperimentImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _experiment.new_ExperimentImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _experiment.ExperimentImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experiment.ExperimentImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experiment.ExperimentImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _experiment.ExperimentImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _experiment.delete_ExperimentImplementationTypedInterfaceObject
    __del__ = lambda self : None;
ExperimentImplementationTypedInterfaceObject_swigregister = _experiment.ExperimentImplementationTypedInterfaceObject_swigregister
ExperimentImplementationTypedInterfaceObject_swigregister(ExperimentImplementationTypedInterfaceObject)

class Experiment(ExperimentImplementationTypedInterfaceObject):
    """
    Base class for design of experiments.

    Considering :math:`\\vect{x}=x^1,\\dots, x^n` a vector of input parameters, this
    class is used to determine a particular set of values of :math:`\\vect{x}`
    according to a particular design of experiments.

    Different types of design of experiments can be determined:

    - some stratified patterns: axial, composite, factorial or box patterns,

    - some weighted patterns that we can split into different categories:
      the random patterns, the low discrepancy sequences and the deterministic
      patterns.

    Examples
    --------
    Define a custom design of experiment:
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> class RandomExp(object):
    ...     def generate(self):
    ...         return ot.Normal(1).getSample(10)
    >>> experiment = ot.Experiment(RandomExp())
    >>> sample = experiment.generate()

    See also
    --------
    StratifiedExperiment, WeightedExperiment
    """
    __swig_setmethods__ = {}
    for _s in [ExperimentImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Experiment, name, value)
    __swig_getmethods__ = {}
    for _s in [ExperimentImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Experiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Experiment_getClassName(self)

    def __repr__(self): return _experiment.Experiment___repr__(self)
    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.Experiment_generate(self)

    def setImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Parameters
        ----------
        implementation : ExperimentImplementation
            An ExperimentImplementation object.

        Examples
        --------
        >>> import openturns as ot
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> myExperimentImplementation = myExperiment.getImplementation()
        >>> mySecondExperiment = ot.Experiment()
        >>> mySecondExperiment.setImplementation(myExperimentImplementation)
        """
        return _experiment.Experiment_setImplementation(self, *args)

    def __init__(self, *args): 
        this = _experiment.new_Experiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Experiment
    __del__ = lambda self : None;
Experiment_swigregister = _experiment.Experiment_swigregister
Experiment_swigregister(Experiment)

class Axial(StratifiedExperiment):
    """
    Axial design of experiments.

    Available constructor:
        Axial(*center, levels*)

        Axial(*dimension, levels*)

    Parameters
    ----------
    center : sequence of float
        Center of the design of experiments. If not specified, the design of
        experiments is centered on :math:`\\vect{0} \\in \\Rset^n`.
    levels : sequence of float of dimension :math:`n_{level}`
        The discretisation of directions (the same for each one), without any
        consideration of unit.
    dimension : positive int
        Dimension :math:`n` of the space where the design of experiments is created.

    Notes
    -----
    Axial is a stratified design of experiments enabling to generate a pattern with
    points only along the axes. It is not convenient to model interactions between
    variables. The axial pattern is obtained by discretizing each direction
    according to specified levels, symmetrically with respect to the center of the
    design of experiments.

    The number of points generated is :math:`1 + 2 n_{level}n`.

    In order to scale each direction and translate the grid structure onto the
    proper center, use the operator :math:`*=` and :math:`+=` of
    :class:`~openturns.NumericalSample`.

    See also
    --------
    StratifiedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> levels = [4.0, 2.0, 7.0]
    >>> myCenteredReductedGrid = ot.Axial(2, levels)
    >>> mySample = myCenteredReductedGrid.generate()
    >>> # Translate the grid
    >>> mySample+=4
    >>> # Scale each direction
    >>> mySample*=2
    """
    __swig_setmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Axial, name, value)
    __swig_getmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Axial, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Axial_getClassName(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.Axial_generate(self)

    def __repr__(self): return _experiment.Axial___repr__(self)
    def __init__(self, *args): 
        this = _experiment.new_Axial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Axial
    __del__ = lambda self : None;
Axial_swigregister = _experiment.Axial_swigregister
Axial_swigregister(Axial)

class Composite(StratifiedExperiment):
    """
    Composite design of experiments.

    Available constructor:
        Composite(*center, levels*)

        Composite(*dimension, levels*)

    Parameters
    ----------
    center : sequence of float
        Center of the design of experiments. If not specified, the design of
        experiments is centered on :math:`\\vect{0} \\in \\Rset^n`.
    levels : sequence of float of dimension :math:`n_{level}`
        The discretisation of directions (the same for each one), without any
        consideration of unit.
    dimension : positive int
        Dimension :math:`n` of the space where the design of experiments is created.

    Notes
    -----
    Composite is a stratified design of experiments enabling to create a pattern
    as the union of an :class:`~openturns.Axial` pattern and a
    :class:`~openturns.Factorial` one. The number of points generated is
    :math:`1 + n_{level}(2n+2^n)`.

    In order to scale each direction and translate the grid structure onto the
    proper center, use the operator :math:`*=` and :math:`+=` of
    :class:`~openturns.NumericalSample`.

    See also
    --------
    StratifiedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> levels = [4.0, 2.0, 7.0]
    >>> myCenteredReductedGrid = ot.Composite(2, levels)
    >>> mySample = myCenteredReductedGrid.generate()
    >>> # Translate the grid
    >>> mySample+=4
    >>> # Scale each direction
    >>> mySample*=2
    """
    __swig_setmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Composite, name, value)
    __swig_getmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Composite, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Composite_getClassName(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.Composite_generate(self)

    def __repr__(self): return _experiment.Composite___repr__(self)
    def __init__(self, *args): 
        this = _experiment.new_Composite(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Composite
    __del__ = lambda self : None;
Composite_swigregister = _experiment.Composite_swigregister
Composite_swigregister(Composite)

class Factorial(StratifiedExperiment):
    """
    Factorial design of experiments.

    Available constructor:
        Factorial(*center, levels*)

        Factorial(*dimension, levels*)

    Parameters
    ----------
    center : sequence of float
        Center of the design of experiments. If not specified, the design of
        experiments is centered on :math:`\\vect{0} \\in \\Rset^n`.
    levels : sequence of float of dimension :math:`n_{level}`
        The discretisation of directions (the same for each one), without any
        consideration of unit.
    dimension : positive int
        Dimension :math:`n` of the space where the design of experiments is created.

    Notes
    -----
    Factorial is a stratified design of experiments enabling to generate a pattern
    with points only on diagonals. It is not convenient to model influences of
    single input variables. The factoriel pattern is obtained by discretizing each
    principal diagonal according to the specified levels, symmetrically with
    respect to the center of the design of experiments.

    The number of points generated is :math:`1 + 2^n n_{level}`.

    In order to scale each direction and translate the grid structure onto the
    proper center, use the operator :math:`*=` and :math:`+=` of
    :class:`~openturns.NumericalSample`.

    See also
    --------
    StratifiedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> levels = [4.0, 2.0, 7.0]
    >>> myCenteredReductedGrid = ot.Factorial(2, levels)
    >>> mySample = myCenteredReductedGrid.generate()
    >>> # Translate the grid
    >>> mySample+=4
    >>> # Scale each direction
    >>> mySample*=2
    """
    __swig_setmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Factorial, name, value)
    __swig_getmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Factorial, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Factorial_getClassName(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.Factorial_generate(self)

    def __repr__(self): return _experiment.Factorial___repr__(self)
    def __init__(self, *args): 
        this = _experiment.new_Factorial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Factorial
    __del__ = lambda self : None;
Factorial_swigregister = _experiment.Factorial_swigregister
Factorial_swigregister(Factorial)

class Box(StratifiedExperiment):
    """
    Box design of experiments.

    Available constructor:
        Box(*levels*)

    Parameters
    ----------
    levels : sequence of int or float
        Sequence specifying the number of intermediate points on each direction
        which regularly discretize :math:`[0,1]`. In direction :math:`i`, the
        points number is :math:`levels[i]+2`: the extreme bounds 0 and 1 are
        always taken.

    Notes
    -----
    Box is a stratified design of experiments enabling to create
    a points grid by regularly discretizing the unit pavement :math:`[0,1]^n` with
    the number of intermediate points specified for each direction. The number of
    points generated is :math:`\\prod_{i=1}^n (2+levels[i])`.

    In order to scale each direction and translate the grid structure onto the
    proper center, use the operator :math:`*=` and :math:`+=` of
    :class:`~openturns.NumericalSample`.

    See also
    --------
    StratifiedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> levels = [4.0, 2.0]
    >>> # Here : direction 1 will be discretized with 4 intermediate points
    >>> # and direction 2 with 2 intermediate points
    >>> myCenteredReductedGrid = ot.Box(levels)
    >>> mySample = myCenteredReductedGrid.generate()
    >>> # Translate the grid
    >>> mySample+=4
    >>> # Scale each direction
    >>> mySample*=2
    """
    __swig_setmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Box, name, value)
    __swig_getmethods__ = {}
    for _s in [StratifiedExperiment]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Box, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Box_getClassName(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.Experiment(ot.MonteCarloExperiment(ot.Normal(2),5))
        >>> print(myExperiment.generate())
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _experiment.Box_generate(self)

    def __repr__(self): return _experiment.Box___repr__(self)
    def setLevels(self, *args):
        """
        Set the levels of the stratified experiment.

        Parameters
        ----------
        levels : sequence of float
            Sequence which has different meanings according to the nature of the
            stratified experiment: Axial, Composite, Factorial or Box (see
            corresponding documentation).
        """
        return _experiment.Box_setLevels(self, *args)

    def __init__(self, *args): 
        this = _experiment.new_Box(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Box
    __del__ = lambda self : None;
Box_swigregister = _experiment.Box_swigregister
Box_swigregister(Box)

class CombinatorialGeneratorImplementation(openturns.common.PersistentObject):
    """
    Combinatorial generator base class.

    Available constructors:
        CombinatorialGenerator()

        CombinatorialGenerator(*combinatorialGeneratorImp*)

    Parameters
    ----------
    combinatorialGeneratorImp : CombinatorialGeneratorImplementation
        An implementation of a combinatorial generator which is provided by
        :class:`~openturns.Combinations`, :class:`~openturns.KPermutations` or
        :class:`~openturns.Tuples`.

    See also
    --------
    Combinations, KPermutations, Tuples
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CombinatorialGeneratorImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CombinatorialGeneratorImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.CombinatorialGeneratorImplementation_getClassName(self)

    def __repr__(self): return _experiment.CombinatorialGeneratorImplementation___repr__(self)
    def generate(self):
        """
        Generate the combinatorial sequence.

        Returns
        -------
        indicesCol : collection  of :class:`~openturns.Indices`
            The collection of all the possible values of the combinatorial generator as
            a set of non-negative integer values stored into an
            :class:`~openturns.Indices`.
        """
        return _experiment.CombinatorialGeneratorImplementation_generate(self)

    def __init__(self, *args): 
        this = _experiment.new_CombinatorialGeneratorImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_CombinatorialGeneratorImplementation
    __del__ = lambda self : None;
CombinatorialGeneratorImplementation_swigregister = _experiment.CombinatorialGeneratorImplementation_swigregister
CombinatorialGeneratorImplementation_swigregister(CombinatorialGeneratorImplementation)

class CombinatorialGeneratorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CombinatorialGeneratorImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CombinatorialGeneratorImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _experiment.new_CombinatorialGeneratorImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _experiment.CombinatorialGeneratorImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _experiment.CombinatorialGeneratorImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _experiment.CombinatorialGeneratorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _experiment.CombinatorialGeneratorImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _experiment.delete_CombinatorialGeneratorImplementationTypedInterfaceObject
    __del__ = lambda self : None;
CombinatorialGeneratorImplementationTypedInterfaceObject_swigregister = _experiment.CombinatorialGeneratorImplementationTypedInterfaceObject_swigregister
CombinatorialGeneratorImplementationTypedInterfaceObject_swigregister(CombinatorialGeneratorImplementationTypedInterfaceObject)

class CombinatorialGenerator(CombinatorialGeneratorImplementationTypedInterfaceObject):
    """
    Combinatorial generator base class.

    Available constructors:
        CombinatorialGenerator()

        CombinatorialGenerator(*combinatorialGeneratorImp*)

    Parameters
    ----------
    combinatorialGeneratorImp : CombinatorialGeneratorImplementation
        An implementation of a combinatorial generator which is provided by
        :class:`~openturns.Combinations`, :class:`~openturns.KPermutations` or
        :class:`~openturns.Tuples`.

    See also
    --------
    Combinations, KPermutations, Tuples
    """
    __swig_setmethods__ = {}
    for _s in [CombinatorialGeneratorImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CombinatorialGenerator, name, value)
    __swig_getmethods__ = {}
    for _s in [CombinatorialGeneratorImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CombinatorialGenerator, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.CombinatorialGenerator_getClassName(self)

    def __repr__(self): return _experiment.CombinatorialGenerator___repr__(self)
    def generate(self):
        """
        Generate the combinatorial sequence.

        Returns
        -------
        indicesCol : collection  of :class:`~openturns.Indices`
            The collection of all the possible values of the combinatorial generator as
            a set of non-negative integer values stored into an
            :class:`~openturns.Indices`.
        """
        return _experiment.CombinatorialGenerator_generate(self)

    def setImplementation(self, *args): return _experiment.CombinatorialGenerator_setImplementation(self, *args)
    def __init__(self, *args): 
        this = _experiment.new_CombinatorialGenerator(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_CombinatorialGenerator
    __del__ = lambda self : None;
CombinatorialGenerator_swigregister = _experiment.CombinatorialGenerator_swigregister
CombinatorialGenerator_swigregister(CombinatorialGenerator)

class Combinations(CombinatorialGeneratorImplementation):
    """
    Combinations generator.

    Available constructors:
        Combinations()

        Combinations(*k, n*)

    Parameters
    ----------
    k : integer
        The cardinal of the subsets
    n : integer
        The cardinal of the base set

    See also
    --------
    CombinatorialGenerator, KPermutations, Tuples

    Notes
    -----
    In the first usage, the generator is built using the default values :math:`k = 1`,
    :math:`n = 1`.

    In the second usage, the generator produces all the subsets with *k* elements of
    a base set with *n* elements. The subsets are produced as a collection of 
    :class:`~openturns.Indices` in lexical order, the elements of each subset being
    sorted in increasing order.

    The number of indices generated is:

    .. math::
        
        \\frac{n!}{k! (n - k)!}

    The combinations generator generates a collection of :class:`~openturns.Indices`
    where:

    - the :class:`~openturns.Indices` are sorted in lexical order,
    - the components are sorted within a given :class:`~openturns.Indices`.

    Examples
    --------
    >>> import openturns as ot
    >>> tuples = ot.Combinations(2, 5)
    >>> print(tuples.generate())
    [[0,1],[0,2],[0,3],[0,4],[1,2],[1,3],[1,4],[2,3],[2,4],[3,4]]#10

    """
    __swig_setmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Combinations, name, value)
    __swig_getmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Combinations, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Combinations_getClassName(self)

    def generate(self):
        """
        Generate the combinatorial sequence.

        Returns
        -------
        indicesCol : collection  of :class:`~openturns.Indices`
            The collection of all the possible values of the combinatorial generator as
            a set of non-negative integer values stored into an
            :class:`~openturns.Indices`.
        """
        return _experiment.Combinations_generate(self)

    def __repr__(self): return _experiment.Combinations___repr__(self)
    def setK(self, *args):
        """
        Accessor to the cardinal of the subsets.

        Parameters
        ----------
        k : integer
            The cardinal of the subsets.
        """
        return _experiment.Combinations_setK(self, *args)

    def getK(self):
        """
        Accessor to the cardinal of the subsets.

        Returns
        -------
        k : integer
            The cardinal of the subsets.
        """
        return _experiment.Combinations_getK(self)

    def setN(self, *args):
        """
        Accessor to the cardinal of the base set.

        Parameters
        ----------
        n : integer
            The cardinal of the base set.
        """
        return _experiment.Combinations_setN(self, *args)

    def getN(self):
        """
        Accessor to the cardinal of the base set.

        Returns
        -------
        n : integer
            The cardinal of the base set.
        """
        return _experiment.Combinations_getN(self)

    def __init__(self, *args): 
        this = _experiment.new_Combinations(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Combinations
    __del__ = lambda self : None;
Combinations_swigregister = _experiment.Combinations_swigregister
Combinations_swigregister(Combinations)

class KPermutations(CombinatorialGeneratorImplementation):
    """
    K permutations generator.

    Available constructors:
        KPermutations()

        KPermutations(*n*)

        KPermutations(*k, n*)

    Parameters
    ----------
    k : integer
        The cardinal of the origin set
    n : integer
        The cardinal of the goal set

    See also
    --------
    CombinatorialGenerator, Combinations, Tuples

    Notes
    -----
    In the first usage, the generator is built using the default values :math:`k = 1`,
    :math:`n = 1`.

    In the second usage, the generator is built using the value :math:`k = n`.

    In the third usage, the generator produces all the injective functions from a
    set with :math:`k` elements into a set with :math:`n` elements. If :math:`k = n` it means
    all the permutations of a set with :math:`n` elements.

    The number of indices generated is:

    .. math::
        
        \\frac{n!}{(n - k)!}

    The combinations generator generates a collection of :class:`~openturns.Indices`
    that contains all the :math:`k!` permutations of all the
    :math:`\\frac{n!}{k! (n - k)!}` subsets with :math:`k` elements of a set with
    :math:`n` elements.

    The subsets are generated in lexical order, and for each subset all the
    corresponding injective functions are generated in lexical order.

    Examples
    --------
    >>> import openturns as ot
    >>> kperm = ot.KPermutations(2, 4)
    >>> print(kperm.generate())
    [[0,1],[1,0],[0,2],[2,0],[0,3],[3,0],[1,2],[2,1],[1,3],[3,1],[2,3],[3,2]]#12

    """
    __swig_setmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KPermutations, name, value)
    __swig_getmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KPermutations, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.KPermutations_getClassName(self)

    def generate(self):
        """
        Generate the combinatorial sequence.

        Returns
        -------
        indicesCol : collection  of :class:`~openturns.Indices`
            The collection of all the possible values of the combinatorial generator as
            a set of non-negative integer values stored into an
            :class:`~openturns.Indices`.
        """
        return _experiment.KPermutations_generate(self)

    def __repr__(self): return _experiment.KPermutations___repr__(self)
    def setK(self, *args):
        """
        Accessor to the cardinal of the subsets.

        Parameters
        ----------
        k : integer
            The cardinal of the subsets.
        """
        return _experiment.KPermutations_setK(self, *args)

    def getK(self):
        """
        Accessor to the cardinal of the subsets.

        Returns
        -------
        k : integer
            The cardinal of the subsets.
        """
        return _experiment.KPermutations_getK(self)

    def setN(self, *args):
        """
        Accessor to the cardinal of the base set.

        Parameters
        ----------
        n : integer
            The cardinal of the base set.
        """
        return _experiment.KPermutations_setN(self, *args)

    def getN(self):
        """
        Accessor to the cardinal of the base set.

        Returns
        -------
        n : integer
            The cardinal of the base set.
        """
        return _experiment.KPermutations_getN(self)

    def __init__(self, *args): 
        this = _experiment.new_KPermutations(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_KPermutations
    __del__ = lambda self : None;
KPermutations_swigregister = _experiment.KPermutations_swigregister
KPermutations_swigregister(KPermutations)

class Tuples(CombinatorialGeneratorImplementation):
    """
    Tuples generator.

    Available constructors:
        Tuples()

        Tuples(*bounds*)

    Parameters
    ----------
    bounds : :class:`~openturns.Indices`
        The cardinal of all the sets forming the cartesian product.

    See also
    --------
    CombinatorialGenerator, Combinations, KPermutations

    Notes
    -----
    In the first usage, the generator is built using the default values
    :math:`bounds = [1]`.

    In the second usage, the generator produces all the indices
    :math:`[i_0, \\ldots, i_{d-1}]` with :math:`i_k \\in \\{0, \\ldots, bounds[k] - 1\\}`
    where :math:`d` is the dimension of *bounds*.

    The number of indices generated is:

    .. math::
        
        \\prod_{k = 0}^{d - 1} bounds[k]

    The tuples generator generates a collection of :class:`~openturns.Indices` that
    contains all the elements of the following Cartesian product:

    .. math::
        
        \\prod_{k = 0}^{d - 1} \\{ 0, \\ldots, bounds[k] -1 \\}

    Examples
    --------
    >>> import openturns as ot
    >>> tuples = ot.Tuples([3, 4])
    >>> print(tuples.generate())
    [[0,0],[1,0],[2,0],[0,1],[1,1],[2,1],[0,2],[1,2],[2,2],[0,3],[1,3],[2,3]]#12

    """
    __swig_setmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Tuples, name, value)
    __swig_getmethods__ = {}
    for _s in [CombinatorialGeneratorImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Tuples, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _experiment.Tuples_getClassName(self)

    def generate(self):
        """
        Generate the combinatorial sequence.

        Returns
        -------
        indicesCol : collection  of :class:`~openturns.Indices`
            The collection of all the possible values of the combinatorial generator as
            a set of non-negative integer values stored into an
            :class:`~openturns.Indices`.
        """
        return _experiment.Tuples_generate(self)

    def __repr__(self): return _experiment.Tuples___repr__(self)
    def setBounds(self, *args):
        """
        Accessor to the bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Indices`
            The cardinal of all the sets forming the cartesian product.
        """
        return _experiment.Tuples_setBounds(self, *args)

    def getBounds(self):
        """
        Accessor to the bounds.

        Returns
        -------
        bounds : :class:`~openturns.Indices`
            The cardinal of all the sets forming the cartesian product.
        """
        return _experiment.Tuples_getBounds(self)

    def __init__(self, *args): 
        this = _experiment.new_Tuples(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _experiment.delete_Tuples
    __del__ = lambda self : None;
Tuples_swigregister = _experiment.Tuples_swigregister
Tuples_swigregister(Tuples)

# This file is compatible with both classic and new-style classes.


