# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Analytical uncertainty propagation algorithms.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_analytical', [dirname(__file__)])
        except ImportError:
            import _analytical
            return _analytical
        if fp is not None:
            try:
                _mod = imp.load_module('_analytical', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _analytical = swig_import_helper()
    del swig_import_helper
else:
    import _analytical
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _analytical.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _analytical.SwigPyIterator_value(self)
    def incr(self, n=1): return _analytical.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _analytical.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _analytical.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _analytical.SwigPyIterator_equal(self, *args)
    def copy(self): return _analytical.SwigPyIterator_copy(self)
    def next(self): return _analytical.SwigPyIterator_next(self)
    def __next__(self): return _analytical.SwigPyIterator___next__(self)
    def previous(self): return _analytical.SwigPyIterator_previous(self)
    def advance(self, *args): return _analytical.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _analytical.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _analytical.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _analytical.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _analytical.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _analytical.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _analytical.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _analytical.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _analytical.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
import openturns.transformation
class AnalyticalResult(openturns.common.PersistentObject):
    """
    Analytical result.

    Available constructors:
        AnalyticalResult(*designPoint, limitStateVariable, isInFailureSpace*)

    Notes
    -----
    Structure created by the method run() of the :class:`~openturns.Analytical`
    class and obtained thanks to its method getAnalyticalResult().

    Parameters
    ----------
    designPoint : sequence of float
        Design point in the standard space resulting from the optimization
        algorithm.
    limitStateVariable : :class:`~openturns.Event`
        Event of which the probability is calculated.
    isInFailureSpace : bool
        Indicates whether the origin of the standard space is in the failure space.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnalyticalResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AnalyticalResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.AnalyticalResult_getClassName(self)

    ELLIPTICAL = _analytical.AnalyticalResult_ELLIPTICAL
    CLASSICAL = _analytical.AnalyticalResult_CLASSICAL
    PHYSICAL = _analytical.AnalyticalResult_PHYSICAL
    def getStandardSpaceDesignPoint(self):
        """
        Accessor to the design point in the standard space.

        Returns
        -------
        designPoint : :class:`~openturns.NumericalPoint`
            Design point in the standard space resulting from the optimization
            algorithm.
        """
        return _analytical.AnalyticalResult_getStandardSpaceDesignPoint(self)

    def setStandardSpaceDesignPoint(self, *args):
        """
        Accessor to the design point in the standard space.

        Parameters
        ----------
        designPoint : sequence of float
            Design point in the standard space resulting from the optimization
            algorithm.
        """
        return _analytical.AnalyticalResult_setStandardSpaceDesignPoint(self, *args)

    def getPhysicalSpaceDesignPoint(self):
        """
        Accessor to the design point in the physical space.

        Returns
        -------
        designPoint : :class:`~openturns.NumericalPoint`
            Design point in the physical space resulting from the optimization
            algorithm.
        """
        return _analytical.AnalyticalResult_getPhysicalSpaceDesignPoint(self)

    def getLimitStateVariable(self):
        """
        Accessor to the event of which the probability is calculated.

        Returns
        -------
        limitStateVariable : :class:`~openturns.Event`
            Event of which the probability is calculated.
        """
        return _analytical.AnalyticalResult_getLimitStateVariable(self)

    def getIsStandardPointOriginInFailureSpace(self):
        """
        Accessor to know if the standard point origin is in the failure space.

        Returns
        -------
        isInFailureSpace : bool
            Indicates whether the origin of the standard space is in the failure space.
        """
        return _analytical.AnalyticalResult_getIsStandardPointOriginInFailureSpace(self)

    def setIsStandardPointOriginInFailureSpace(self, *args):
        """
        Accessor to specify if the standard point origin is in the failure space.

        Parameters
        ----------
        isInFailureSpace : bool
            Indicates whether the origin of the standard space is in the failure space.
        """
        return _analytical.AnalyticalResult_setIsStandardPointOriginInFailureSpace(self, *args)

    def getMeanPointInStandardEventDomain(self):
        """
        Accessor to the mean point in the standard event domain.

        Returns
        -------
        meanPoint : :class:`~openturns.NumericalPoint`
            Mean point of the standard space distribution restricted to the event
            domain:
            :math:`\\displaystyle \\frac{1}{E_1(-\\beta)}\\int_{\\beta}^{\\infty} u_1 p_1(u_1)\\di{u_1}`
            where :math:`E_1` is the spheric univariate distribution of the standard
            space and :math:`\\beta` the reliability index.
        """
        return _analytical.AnalyticalResult_getMeanPointInStandardEventDomain(self)

    def setMeanPointInStandardEventDomain(self, *args):
        """
        Accessor to the mean point in the standard event domain.

        Parameters
        ----------
        meanPoint : sequence of float
            Mean point of the standard space distribution restricted to the event
            domain:
            :math:`\\displaystyle \\frac{1}{E_1(-\\beta)}\\int_{\\beta}^{\\infty} u_1 p_1(u_1)\\di{u_1}`
            where :math:`E_1` is the spheric univariate distribution of the standard
            space and :math:`\\beta` the reliability index.
        """
        return _analytical.AnalyticalResult_setMeanPointInStandardEventDomain(self, *args)

    def getImportanceFactors(self, *args):
        """
        Accessor to the importance factors.

        Parameters
        ----------
        type : int, optional
            - When *ot.AnalyticalResult.ELLIPTICAL*, the importance factors
              are evaluated as the square of the co-factors of the design point in the
              elliptical space of the iso-probabilistic transformation (Y-space).

            - When *ot.AnalyticalResult.CLASSICAL* they are evaluated as the square of
              the co-factors of the design point in the U-space.

            - When *ot.AnalyticalResult.PHYSICAL*, the importance factors are evaluated
              as the square of the physical sensitivities.

            By default *type = ot.AnalyticalResult.ELLIPTICAL*.

        Notes
        -----
        - If the importance factors are evaluated as the square of the
          co-factors of the design point in the U-space :

          .. math::

            \\alpha_i^2 = \\frac{(u_i^*)^2}
                              {\\beta_{HL}^2}

        - If the importance factors are evaluated as the square of the co-factors of the
          design point in the Y-space :

          .. math::

            \\alpha_i^2 = \\frac{(y_i^*)^2}
                              {\\|\\vect{y}^*\\|^2}

          where

          .. math::

            Y^* = \\left(
                  \\begin{array}{c}
                      E^{-1}\\circ F_1(X_1^*) \\\\
                      E^{-1}\\circ F_2(X_2^*) \\\\
                      \\vdots \\\\
                      E^{-1}\\circ F_n(X_n^*)
                  \\end{array}
                  \\right)

          with :math:`\\vect{X}^*` is the design point in the physical space and :math:`E`
          the univariate standard CDF of the elliptical space. In the case where the
          input distribution of :math:`\\vect{X}` has an elliptical copula
          :math:`C_E`, then :math:`E` has the same type as :math:`C_E`.
          In the case where the input distribution of :math:`\\vect{X}` has a copula
          :math:`C` which is not elliptical, then :math:`E=\\Phi` where :math:`\\Phi`
          is the CDF of the standard normal.

        - If the importance factors are evaluated as the square of the physical sensitivities :

          .. math::
              \\alpha_i^2 = \\displaystyle \\frac{s_i^2}{{\\|s\\|}^2}

          where

          .. math::
              s_i = \\displaystyle \\frac{\\partial \\beta}{\\partial x_i} (x^*)
                  = \\sum_{j=1}^n \\frac{\\partial \\beta}{\\partial u_i} \\frac{\\partial u_j}{\\partial x_i} (x^*)

        Returns
        -------
        factors : :class:`~openturns.NumericalPointWithDescription`
            Sequence containing the importance factors with a description for each
            component.
        """
        return _analytical.AnalyticalResult_getImportanceFactors(self, *args)

    def drawImportanceFactors(self, *args):
        """
        Draw the importance factors.

        Parameters
        ----------
        type : int, optional
            See :meth:`getImportanceFactors`

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Pie of the importance factors of the probabilistic variables.
        """
        return _analytical.AnalyticalResult_drawImportanceFactors(self, *args)

    def getHasoferReliabilityIndex(self):
        """
        Accessor to the Hasofer Reliability Index.

        Returns
        -------
        index : float
            Hasofer Reliability Index which is the distance of the design point from
            the origin of the standard space :math:`\\beta_{HL}=||\\vect{u}^*||`.
        """
        return _analytical.AnalyticalResult_getHasoferReliabilityIndex(self)

    def getHasoferReliabilityIndexSensitivity(self):
        """
        Accessor to the sensitivities of the Hasofer Reliability Index.

        Returns
        -------
        sensitivity : :class:`~openturns.NumericalPointWithDescription`
            Sequence containing the sensitivities of the Hasofer Reliability Index to
            the parameters of the probabilistic input vector (marginals and dependence
            structure) with a description for each component.
        """
        return _analytical.AnalyticalResult_getHasoferReliabilityIndexSensitivity(self)

    def getOptimizationResult(self):
        """
        Accessor to the result of the optimization problem.

        Returns
        -------
        result : :class:`~openturns.OptimizationResult`
            Contains the design point in the standard space and information concerning
            the convergence of the optimization algorithm.
        """
        return _analytical.AnalyticalResult_getOptimizationResult(self)

    def setOptimizationResult(self, *args):
        """
        Accessor to the result of the optimization problem.

        Parameters
        ----------
        result : :class:`~openturns.OptimizationResult`
            Contains the design point in the standard space and information concerning
            the convergence of the optimization algorithm.
        """
        return _analytical.AnalyticalResult_setOptimizationResult(self, *args)

    def drawHasoferReliabilityIndexSensitivity(self, *args):
        """
        Draw the sensitivity of the Hasofer Reliability Index.

        Parameters
        ----------
        width : float, optional
            Value to calculate the shift position of the :class:`~openturns.BarPlot`.
            By default it is 1.0.

        Returns
        -------
        graphCollection : sequence of two :class:`~openturns.Graph` containing a barplot
            The first graph drawing the sensitivity of the Hasofer Reliability Index to
            the parameters of the marginals of the probabilistic input vector.
            The second graph drawing the sensitivity of the Hasofer Reliability Index
            to the parameters of the dependence structure of the probabilistic input
            vector.
        """
        return _analytical.AnalyticalResult_drawHasoferReliabilityIndexSensitivity(self, *args)

    def __repr__(self): return _analytical.AnalyticalResult___repr__(self)
    def __init__(self, *args): 
        this = _analytical.new_AnalyticalResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_AnalyticalResult
    __del__ = lambda self : None;
AnalyticalResult_swigregister = _analytical.AnalyticalResult_swigregister
AnalyticalResult_swigregister(AnalyticalResult)

class Analytical(openturns.common.PersistentObject):
    """
    Base class to evaluate the probability of failure of a system.

    Available constructors:
        Analytical(*nearestPointAlgorithm, event, physicalStartingPoint*)

    Parameters
    ----------
    nearestPointAlgorithm : :class:`~openturns.OptimizationSolver`
        Optimization algorithm used to research the design point.
    event : :class:`~openturns.Event`
        Failure event.
    physicalStartingPoint : sequence of float
        Starting point of the optimization algorithm, declared in the physical
        space.

    Notes
    -----
    Used in reliability analysis, Analytical is a base class for the approximation
    methods :class:`~openturns.FORM` and :class:`~openturns.SORM` enabling to
    evaluate the failure probability of a system.
    A failure event is defined as follows :
    :math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`
    where :math:`\\vect{X}` denotes a random input vector representing the sources
    of uncertainties, :math:`\\vect{d}` is a determinist vector representing the
    fixed variables. :math:`g(\\vect{X},\\vect{d})` is the limit state function of
    the model separating the failure domain from the safe domain.
    Considering :math:`f_\\vect{X}(\\vect{x})` the joint probability density function
    of the random variables :math:`\\vect{X}`, the probability of failure of the
    event :math:`\\cD_f` is :

    .. math::

        P_f = \\int_{g(\\vect{X},\\vect{d})\\le 0}f_\\vect{X}(\\vect{x})\\di{\\vect{x}}

    The analytical methods use an isoprobabilistic transformation to move from
    the physical space to the standard normal space (U-space) where distributions
    are spherical (invariant by rotation by definition), with zero mean, unit
    variance and unit correlation matrix. The usual isoprobabilistic
    transformations are the Generalized Nataf transformation and the Rosenblatt one.

    In that new U-space, the event has the new expression defined
    from the transformed limit state function of the model
    :math:`G : \\cD_f = \\{\\vect{U} \\in \\Rset^n \\, | \\, G(\\vect{U}\\,,\\,\\vect{d}) \\le 0\\}`
    and its boundary :
    :math:`\\{\\vect{U} \\in \\Rset^n \\, | \\,G(\\vect{U}\\,,\\,\\vect{d}) = 0\\}`.
    Then, the event probability :math:`P_f` rewrites :

    .. math::

        P_f = \\Prob{G(\\vect{U}\\,,\\,\\vect{d})\\leq 0}
            = \\int_{\\Rset^n} \\boldsymbol{1}_{G(\\vect{u}\\,,\\,\\vect{d}) \\leq 0}\\,f_{\\vect{U}}(\\vect{u})\\di{\\vect{u}}

    where :math:`f_{\\vect{U}}` is the density function of the distribution in the
    standard space.

    The analytical methods rely on the assumption that most of the contribution
    to :math:`P_f` comes from points located in the vicinity of a particular point
    :math:`P^*`, the **design point**, defined in the U-space as the point located
    on the limit state surface verifying the event of maximum likelihood. Given the
    probabilistic characteristics of the U-space, :math:`P^*` has a geometrical
    interpretation: it is the point located on the event boundary and at minimal
    distance from the origin of the U-space. Thus, considering :math:`\\vect{u}^*`
    its coordinates in the U-space, the design point is the result of the
    constrained optimization problem :

    .. math::

        \\vect{u}^* = argmin \\{||\\vect{u}|| \\, | \\, G(\\vect{u}) = 0 \\}

    Then the limit state surface is approximated in the standard space by a linear
    surface (:class:`~openturns.FORM`) or by a quadratic surface
    (:class:`~openturns.SORM`) at the design point in order to evaluate the
    failure probability. For more information on this evaluation, see the
    documentation associated with these two methods.

    The result of the optimization problem is recoverable thanks to the method
    :meth:`getAnalyticalResult`.

    The unicity and the strongness of the design point can be checked thanks to the
    :class:`Strong Maximum Test <openturns.StrongMaximumTest>`.

    See also
    --------
    FORM, SORM, StrongMaximumTest, Event, StandardEvent, AnalyticalResult

    Examples
    --------
    >>> import openturns as ot
    >>> myFunction = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # We create an OptimizationSolver algorithm
    >>> myOptim = ot.AbdoRackwitz()
    >>> myAlgo = ot.Analytical(myOptim, myEvent, [50.0, 1.0, 10.0, 5.0])
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Analytical, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Analytical, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.Analytical_getClassName(self)

    def getPhysicalStartingPoint(self):
        """
        Accessor to the starting point of the optimization algorithm.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            Starting point of the optimization algorithm, declared in the physical
            space.
        """
        return _analytical.Analytical_getPhysicalStartingPoint(self)

    def setPhysicalStartingPoint(self, *args):
        """
        Accessor to the starting point of the optimization algorithm.

        Parameters
        ----------
        point : sequence of float
            Starting point of the optimization algorithm, declared in the physical
            space.
        """
        return _analytical.Analytical_setPhysicalStartingPoint(self, *args)

    def getEvent(self):
        """
        Accessor to the event of which the probability is calculated.

        Returns
        -------
        event : :class:`~openturns.Event`
            Event of which the probability is calculated.
        """
        return _analytical.Analytical_getEvent(self)

    def setEvent(self, *args):
        """
        Accessor to the event of which the probability is calculated.

        Parameters
        ----------
        event : :class:`~openturns.Event`
            Event of which the probability is calculated.
        """
        return _analytical.Analytical_setEvent(self, *args)

    def getNearestPointAlgorithm(self):
        """
        Accessor to the optimization algorithm used to find the design point.

        Returns
        -------
        algorithm : :class:`~openturns.OptimizationSolver`
             Optimization algorithm used to research the design point.
        """
        return _analytical.Analytical_getNearestPointAlgorithm(self)

    def setNearestPointAlgorithm(self, *args):
        """
        Accessor to the optimization algorithm used to find the design point.

        Parameters
        ----------
        algorithm : :class:`~openturns.OptimizationSolver`
             Optimization algorithm used to research the design point.
        """
        return _analytical.Analytical_setNearestPointAlgorithm(self, *args)

    def getAnalyticalResult(self):
        """
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result structure which contains the results of the optimisation problem.
        """
        return _analytical.Analytical_getAnalyticalResult(self)

    def __repr__(self): return _analytical.Analytical___repr__(self)
    def run(self):
        """
        Perform the research of the design point.

        Notes
        -----
        Performs the research of the design point and creates a
        :class:`~openturns.AnalyticalResult`, the structure result which is
        accessible with the method :meth:`getAnalyticalResult`.
        """
        return _analytical.Analytical_run(self)

    def __init__(self, *args): 
        this = _analytical.new_Analytical(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_Analytical
    __del__ = lambda self : None;
Analytical_swigregister = _analytical.Analytical_swigregister
Analytical_swigregister(Analytical)

class FORMResult(AnalyticalResult):
    """
    Result of a FORM analysis.

    Available constructors:
        FORMResult(*designPoint, limitStateVariable, isInFailureSpace*)

    Notes
    -----
    Structure created by the method run() of the :class:`~openturns.FORM`
    class and obtained thanks to its method getResult().

    Parameters
    ----------
    designPoint : sequence of float
        Design point in the standard space resulting from the optimization
        algorithm.
    limitStateVariable : :class:`~openturns.Event`
        Event of which the probability is calculated.
    isInFailureSpace : bool
        Indicates whether the origin of the standard space is in the failure space.


    See also
    --------
    Analytical, AnalyticalResult, SORM, SORMResult, FORM, StrongMaximumTest
    """
    __swig_setmethods__ = {}
    for _s in [AnalyticalResult]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FORMResult, name, value)
    __swig_getmethods__ = {}
    for _s in [AnalyticalResult]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FORMResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.FORMResult_getClassName(self)

    def getEventProbability(self):
        """
        Accessor to the failure probability :math:`P_f`.

        Returns
        -------
        probability : positive float
            The FORM failure probability :math:`P_f`.
        """
        return _analytical.FORMResult_getEventProbability(self)

    def getGeneralisedReliabilityIndex(self):
        """
        Accessor to the Generalised Reliability Index.

        Returns
        -------
        index : float
            Generalised reliability index :math:`\\beta_g` from the FORM failure
            probability is equal to :math:`\\pm` the Hasofer reliability index
            :math:`\\beta_{HL}` according to the fact the standard space center
            fulfills the event or not.
        """
        return _analytical.FORMResult_getGeneralisedReliabilityIndex(self)

    def getEventProbabilitySensitivity(self):
        """
        Accessor to the sentivities of the FORM failure probability :math:`P_f`.

        Returns
        -------
        sentivities : :class:`~openturns.NumericalPoint`
            Sentivities of the FORM failure probability with regards to the parameters
            of the probabilistic input vector and to parameters of the dependence
            structure of the probabilistic input vector.
        """
        return _analytical.FORMResult_getEventProbabilitySensitivity(self)

    def drawEventProbabilitySensitivity(self, *args):
        """
        Draw the sensitivities of the FORM failure probability.

        Parameters
        ----------
        width : float, optional
            Value to calculate the shift position of the :class:`~openturns.BarPlot`.
            By default it is 1.0.

        Returns
        -------
        graphCollection : list of two :class:`~openturns.Graph` containing a barplot
            The first graph drawing the sensitivities of the FORM failure probability
            with regards to the parameters of the probabilistic input vector.
            The second graph drawing the sensitivities of the FORM failure probability
            with regards to the parameters of the dependence structure of the
            probabilistic input vector.
        """
        return _analytical.FORMResult_drawEventProbabilitySensitivity(self, *args)

    def __repr__(self): return _analytical.FORMResult___repr__(self)
    def __init__(self, *args): 
        this = _analytical.new_FORMResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_FORMResult
    __del__ = lambda self : None;
FORMResult_swigregister = _analytical.FORMResult_swigregister
FORMResult_swigregister(FORMResult)

class FORM(Analytical):
    """
    First Order Reliability Method (FORM).

    Available constructors:
        FORM(*nearestPointAlgorithm, event, physicalStartingPoint*)

    Parameters
    ----------
    nearestPointAlgorithm : :class:`~openturns.OptimizationSolver`
        Optimization algorithm used to research the design point.
    event : :class:`~openturns.Event`
        Failure event.
    physicalStartingPoint : sequence of float
        Starting point of the optimization algorithm, declared in the physical
        space.

    Notes
    -----
    See :class:`~openturns.Analytical` for the description of the first steps of
    the FORM analysis.

    The First Order Reliability Method (FORM) consists in linearizing the limit state
    function :math:`G(\\vect{U}\\,,\\,\\vect{d})` at the design point, denoted
    :math:`P^*`, which is the point on the limit state surface
    :math:`G(\\vect{U}\\,,\\,\\vect{d})=0` that is closest to the origin of the
    standard space.

    Then, the probability :math:`P_f` where the limit state surface has been
    approximated by a linear surface (hyperplane) can be obtained exactly, thanks
    to the rotation invariance of the standard distribution :math:`f_{\\vect{U}}` :

    .. math::

        P_f = \\left\\{
                  \\begin{array}{ll}
                  \\displaystyle E(-\\beta_{HL})
                  & \\text{if the origin of the }\\vect{u}\\text{-space lies in the domain }\\cD_f \\\\
                  \\displaystyle E(+\\beta_{HL}) & \\text{otherwise}
                  \\end{array}
              \\right.

    where :math:`\\beta_{HL}` is the Hasofer-Lind reliability index, defined as the
    distance of the design point :math:`\\vect{u}^*` to the origin of the standard
    space and :math:`E` the marginal cumulative density function of the spherical
    distributions in the standard space.

    The evaluation of the failure probability is stored in the data structure
    :class:`~openturns.FORMResult` recoverable with the :meth:`getResult` method.

    See also
    --------
    Analytical, AnalyticalResult, SORM, StrongMaximumTest, FORMResult

    Examples
    --------
    >>> import openturns as ot
    >>> myFunction = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> event = ot.Event(output, ot.Less(), -3.0)
    >>> # We create an OptimizationSolver algorithm
    >>> solver = ot.AbdoRackwitz()
    >>> algo = ot.FORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [Analytical]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FORM, name, value)
    __swig_getmethods__ = {}
    for _s in [Analytical]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FORM, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.FORM_getClassName(self)

    def getResult(self):
        """
        Accessor to the result of FORM.

        Returns
        -------
        result : :class:`~openturns.FORMResult`
            Structure containing all the results of the FORM analysis.
        """
        return _analytical.FORM_getResult(self)

    def setResult(self, *args):
        """
        Accessor to the result of FORM.

        Parameters
        ----------
        result : :class:`~openturns.FORMResult`
            Structure containing all the results of the FORM analysis.
        """
        return _analytical.FORM_setResult(self, *args)

    def __repr__(self): return _analytical.FORM___repr__(self)
    def run(self):
        """
        Evaluate the failure probability.

        Notes
        -----
        Evaluate the failure probability and create a :class:`~openturns.FORMResult`,
        the structure result which is accessible with the method :meth:`getResult`.
        """
        return _analytical.FORM_run(self)

    def __init__(self, *args): 
        this = _analytical.new_FORM(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_FORM
    __del__ = lambda self : None;
FORM_swigregister = _analytical.FORM_swigregister
FORM_swigregister(FORM)

class SORMResult(AnalyticalResult):
    """
    Result of a SORM analysis.

    Available constructors:
        SORMResult(*designPoint, limitStateVariable, isInFailureSpace*)

    Notes
    -----
    Structure created by the method run() of the :class:`~openturns.SORM`
    class and obtained thanks to its method getResult().

    Parameters
    ----------
    designPoint : sequence of float
        Design point in the standard space resulting from the optimization
        algorithm.
    limitStateVariable : :class:`~openturns.Event`
        Event of which the probability is calculated.
    isInFailureSpace : bool
        Indicates whether the origin of the standard space is in the failure space.


    See also
    --------
    Analytical, AnalyticalResult, FORM, FORMResult, StrongMaximumTest
    """
    __swig_setmethods__ = {}
    for _s in [AnalyticalResult]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SORMResult, name, value)
    __swig_getmethods__ = {}
    for _s in [AnalyticalResult]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SORMResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.SORMResult_getClassName(self)

    def getEventProbabilityBreitung(self):
        """
        Accessor to the failure probability :math:`P_{Breitung}`.

        Returns
        -------
        probability : positive float
            The SORM failure probability :math:`P_{Breitung}` according to the
            :ref:`Breitung <Breitung_formula>` approximation.
        """
        return _analytical.SORMResult_getEventProbabilityBreitung(self)

    def getEventProbabilityHohenBichler(self):
        """
        Accessor to the failure probability :math:`P_{Hohenbichler}`.

        Returns
        -------
        probability : positive float
            The SORM failure probability :math:`P_{Hohenbichler}` according to the
            :ref:`Hohen Bichler <Hohenbichler_formula>` approximation.
        """
        return _analytical.SORMResult_getEventProbabilityHohenBichler(self)

    def getEventProbabilityTvedt(self):
        """
        Accessor to the failure probability :math:`P_{Tvedt}`.

        Returns
        -------
        probability : positive float
            The SORM failure probability :math:`P_{Tvedt}` according to the
            :ref:`Tvedt <Tvedt_formula>` approximation.
        """
        return _analytical.SORMResult_getEventProbabilityTvedt(self)

    def getGeneralisedReliabilityIndexBreitung(self):
        """
        Accessor to the Generalised Reliability Index Breitung.

        Returns
        -------
        index : float
            Generalised reliability index evaluated from the Breitung SORM failure
            probability.

            .. math::

                \\beta_{Breitung} = \\left \\{
                \\begin{array}{ll}
                \\displaystyle -\\Phi(P_{Breitung})
                & \\text{if the standard space origin is not in the failure space} \\\\
                \\displaystyle \\Phi(P_{Breitung}) & \\text{otherwise}
                \\end{array}
                \\right.
        """
        return _analytical.SORMResult_getGeneralisedReliabilityIndexBreitung(self)

    def getGeneralisedReliabilityIndexHohenBichler(self):
        """
        Accessor to the Generalised Reliability Index HohenBichler.

        Returns
        -------
        index : float
            Generalised reliability index evaluated from the Hohen Bichler SORM failure
            probability.

            .. math::

                \\beta_{Hohenbichler} = \\left \\{
                \\begin{array}{ll}
                \\displaystyle -\\Phi(P_{Hohenbichler})
                & \\text{if the standard space origin is not in the failure space} \\\\
                \\displaystyle \\Phi(P_{Hohenbichler}) & \\text{otherwise}
                \\end{array}
                \\right.
        """
        return _analytical.SORMResult_getGeneralisedReliabilityIndexHohenBichler(self)

    def getGeneralisedReliabilityIndexTvedt(self):
        """
        Accessor to the Generalised Reliability Index Tvedt.

        Returns
        -------
        index : float
            Generalised reliability index evaluated from the Tvedt SORM failure
            probability.

            .. math::

                \\beta_{Tvedt} = \\left \\{
                \\begin{array}{ll}
                \\displaystyle -\\Phi(P_{Tvedt})
                & \\text{if the standard space origin is not in the failure space} \\\\
                \\displaystyle \\Phi(P_{Tvedt}) & \\text{otherwise}
                \\end{array}
                \\right.
        """
        return _analytical.SORMResult_getGeneralisedReliabilityIndexTvedt(self)

    def getSortedCurvatures(self):
        """
        Accessor to the sorted curvatures.

        Returns
        -------
        curvatures : :class:`~openturns.NumericalPoint`
            Curvatures of the standard limite state function at the standard design
            point :math:`(\\kappa_i)_{1 \\leq i \\leq n-1}` with :math:`n` the dimension
            of the random vector :math:`\\vect{X}`.
        """
        return _analytical.SORMResult_getSortedCurvatures(self)

    def __repr__(self): return _analytical.SORMResult___repr__(self)
    def __str__(self, offset=""): return _analytical.SORMResult___str__(self, offset)
    def __init__(self, *args): 
        this = _analytical.new_SORMResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_SORMResult
    __del__ = lambda self : None;
SORMResult_swigregister = _analytical.SORMResult_swigregister
SORMResult_swigregister(SORMResult)

class SORM(Analytical):
    """
    Second Order Reliability Method (SORM).

    Available constructors:
        SORM(*nearestPointAlgorithm, event, physicalStartingPoint*)

    Parameters
    ----------
    nearestPointAlgorithm : :class:`~openturns.OptimizationSolver`
        Optimization algorithm used to research the design point.
    event : :class:`~openturns.Event`
        Failure event.
    physicalStartingPoint : sequence of float
        Starting point of the optimization algorithm, declared in the physical
        space.

    Notes
    -----
    See :class:`~openturns.Analytical` for the description of the first steps of
    the SORM analysis.

    The Second Order Reliability Method (SORM) consists in approximating the limit
    state surface in U-space at the design point :math:`P^*` by a quadratic
    surface. SORM is usually more accurate than FORM e.g. in case when the event
    boundary is highly curved.

    Let us denote by :math:`n` the dimension of the random vector :math:`\\vect{X}`
    and :math:`(\\kappa_i)_{1 \\leq i \\leq n-1}` the :math:`n-1` main curvatures of
    the limit state function at the design point in the standard space.

    Several approximations of the failure probability :math:`P_f` are available in
    the standard version of OpenTURNS, detailed here in the case where the origin
    of the standard space does not belong to the failure domain :

    - Breitung's formula :

      .. _Breitung_formula:

      .. math ::

          P_{Breitung} = E(-\\beta_{HL})\\prod_{i=1}^{n-1} \\frac{1}{\\sqrt{1 + \\beta_{HL}\\kappa_i}}

      :math:`E` the marginal cumulative density function of the spherical
      distributions in the standard space and :math:`\\beta_{HL}` is the Hasofer-Lind
      reliability index, defined as the distance of the design point
      :math:`\\vect{u}^*` to the origin of the standard space.

    - Hohen Bichler's formula is an approximation of the previous equation :

      .. _Hohenbichler_formula:

      .. math ::

          \\displaystyle P_{Hohenbichler} = \\Phi(-\\beta_{HL})
           \\prod_{i=1}^{n-1} \\left(
                             1 + \\frac{\\phi(\\beta_{HL})}{\\Phi(-\\beta_{HL})}\\kappa_i
                             \\right) ^{-1/2}

      where :math:`\\Phi` is the cumulative distribution function of the
      standard 1D normal distribution and :math:`\\phi` is the standard Gaussian
      probability density function.

    - Tvedt's formula :

      .. _Tvedt_formula:

      .. math ::

          \\left\\{
            \\begin{array}{lcl}
              \\displaystyle P_{Tvedt} & = & A_1 + A_2 + A_3 \\\\
              \\displaystyle A_1 & = & \\displaystyle
                \\Phi(-\\beta_{HL}) \\prod_{i=1}^{N-1} \\left( 1 + \\beta_{HL} \\kappa_i \\right) ^{-1/2}\\\\
              \\displaystyle A_2 & = & \\displaystyle
                \\left[ \\beta_{HL} \\Phi(-\\beta_{HL}) - \\phi(\\beta_{HL}) \\right]
                \\left[ \\prod_{j=1}^{N-1} \\left( 1 + \\beta_{HL} \\kappa_i \\right) ^{-1/2} -
                       \\prod_{j=1}^{N-1} \\left( 1 + (1 + \\beta_{HL}) \\kappa_i \\right) ^{-1/2}
                \\right ] \\\\
              \\displaystyle A_3 & = & \\displaystyle (1 + \\beta_{HL})
                \\left[ \\beta_{HL} \\Phi(-\\beta_{HL}) - \\phi(\\beta_{HL}) \\right]
                \\left[ \\prod_{j=1}^{N-1} \\left( 1 + \\beta_{HL} \\kappa_i \\right) ^{-1/2} -
                       {\\cR}e \\left( \\prod_{j=1}^{N-1} \\left( 1 + (i + \\beta_{HL}) \\kappa_j \\right) ^{-1/2}
                \\right)\\right ]
            \\end{array}
          \\right.

      where :math:`{\\cR}e(z)` is the real part of the complex number :math:`z` and
      :math:`i` the complex number such that :math:`i^2 = -1`.

    The evaluation of the failure probability is stored in the data structure
    :class:`~openturns.SORMResult` recoverable with the :meth:`getResult` method.

    See also
    --------
    Analytical, AnalyticalResult, FORM, StrongMaximumTest, SORMResult

    Examples
    --------
    >>> import openturns as ot
    >>> myFunction = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> event = ot.Event(output, ot.Less(), -3.0)
    >>> # We create an OptimizationSolver algorithm
    >>> solver = ot.AbdoRackwitz()
    >>> algo = ot.SORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> algo.run()
    >>> result = algo.getResult()
    """
    __swig_setmethods__ = {}
    for _s in [Analytical]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SORM, name, value)
    __swig_getmethods__ = {}
    for _s in [Analytical]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SORM, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.SORM_getClassName(self)

    def getResult(self):
        """
        Accessor to the result of SORM.

        Returns
        -------
        result : :class:`~openturns.SORMResult`
            Structure containing all the results of the SORM analysis.
        """
        return _analytical.SORM_getResult(self)

    def setResult(self, *args):
        """
        Accessor to the result of SORM.

        Parameters
        ----------
        result : :class:`~openturns.SORMResult`
            Structure containing all the results of the SORM analysis.
        """
        return _analytical.SORM_setResult(self, *args)

    def __repr__(self): return _analytical.SORM___repr__(self)
    def run(self):
        """
        Evaluate the failure probability.

        Notes
        -----
        Evaluate the failure probability and create a :class:`~openturns.SORMResult`,
        the structure result which is accessible with the method :meth:`getResult`.
        """
        return _analytical.SORM_run(self)

    def __init__(self, *args): 
        this = _analytical.new_SORM(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_SORM
    __del__ = lambda self : None;
SORM_swigregister = _analytical.SORM_swigregister
SORM_swigregister(SORM)

class StrongMaximumTest(openturns.common.PersistentObject):
    """
    Strong Maximum Test.

    Available constructors:
        StrongMaximumTest(*event, designPoint, importanceLevel, accuracyLevel, confidenceLevel*)

        StrongMaximumTest(*event, designPoint, importanceLevel, accuracyLevel, pointNumber*)

    Parameters
    ----------
    event : :class:`~openturns.StandardEvent`
        Failure event :math:`\\cD_f` defining in the standard space (U-space).
    designPoint : sequence of float
        Design point in the standard space resulting from the optimization
        algorithm.
    importanceLevel : float, :math:`0 < \\varepsilon < 1`
        Importance level.
    accuracyLevel : float, :math:`\\tau > 0`
        Accuracy level. It is recommanded to take :math:`\\tau \\leq 4`.
    confidenceLevel : positive float, :math:`0 < (1-q) < 1`
        Confidence level.
    pointNumber : int, :math:`N > 0`
        Number of points used to perform the Strong Maximum Test, evaluated by the
        limit state function.

    Notes
    -----
    The Strong Maximum Test helps to evaluate the quality of the design point
    :math:`P^*` resulting from the optimization algorithm launched for example by
    the :class:`~openturns.Analytical` class or its derived classes
    :class:`~openturns.FORM` and :class:`~openturns.SORM`.
    It checks whether the design point computed is :

    - the *true* design point, which means a global maximum point,

    - a *strong* design point, which means that there is no other local maximum
      located on the event boundary and which likelihood is slightly inferior to
      the design point one.

    The Strong Maximum Test will sample the sphere centered on the origin of the
    standard space and of radius :
    :math:`R = \\beta_{HL} (1 + \\tau \\delta_{\\varepsilon})` with :math:`\\tau > 0`,
    :math:`\\delta_{\\varepsilon}=\\sqrt{1 - 2 \\frac{ln(\\varepsilon)}{\\beta_{HL}^2}} - 1`
    and :math:`\\beta_{HL}` the Hasofer-Lind reliability index.

    The number :math:`N` of the simulations sampling the sphere of radius :math:`R`
    is determined to ensure that the test detects with a probability greater than
    :math:`(1-q)` any point of :math:`\\cD_f` outside the design point vicinity
    which contribution to :math:`P_f` is not negligeable (i.e. which density value
    in the U-space is greater than :math:`\\varepsilon` times the density value at
    the design point).

    See also
    --------
    Analytical, SORM, FORM, SORMResult, FORMResult

    Examples
    --------
    >>> import openturns as ot
    >>> myFunction = ot.NumericalMathFunction(['E', 'F', 'L', 'I'], ['d'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(myFunction, vect)
    >>> myEvent = ot.Event(output, ot.Less(), -3.0)
    >>> # FORM analyse to get the design point
    >>> myAlgo = ot.FORM(ot.AbdoRackwitz(), myEvent, [50.0, 1.0, 10.0, 5.0])
    >>> myAlgo.run()
    >>> FORMresult = myAlgo.getResult()
    >>> designPoint = FORMresult.getStandardSpaceDesignPoint()
    >>> # Strong Max Test
    >>> myStandardEvent = ot.StandardEvent(myEvent)
    >>> myTest = ot.StrongMaximumTest(myStandardEvent, designPoint, 0.15, 3, 0.99)
    >>> myTest.run()
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StrongMaximumTest, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, StrongMaximumTest, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _analytical.StrongMaximumTest_getClassName(self)

    def getStandardSpaceDesignPoint(self):
        """
        Accessor to the design point in the standard space.

        Returns
        -------
        point : :class:`~openturns.NumericalPoint`
            Design point in the standard space.
        """
        return _analytical.StrongMaximumTest_getStandardSpaceDesignPoint(self)

    def getEvent(self):
        """
        Accessor to the event in the standard space.

        Returns
        -------
        event : :class:`~openturns.StandardEvent`
            Failure event :math:`\\cD_f` in the standard space on which is based the
            Strong Maximum Test.
        """
        return _analytical.StrongMaximumTest_getEvent(self)

    def getImportanceLevel(self):
        """
        Accessor to the importance level.

        Returns
        -------
        level : float
            Importance level :math:`\\varepsilon`.
        """
        return _analytical.StrongMaximumTest_getImportanceLevel(self)

    def getAccuracyLevel(self):
        """
        Accessor to the accuracy level.

        Returns
        -------
        accuracy : positive float
            Accuracy level :math:`\\tau`.
        """
        return _analytical.StrongMaximumTest_getAccuracyLevel(self)

    def getConfidenceLevel(self):
        """
        Accessor to the confidence level.

        Returns
        -------
        level : positive float
            Confidence level :math:`(1-q)`.
        """
        return _analytical.StrongMaximumTest_getConfidenceLevel(self)

    def getDesignPointVicinity(self):
        """
        Accessor to the design point vinicity.

        Returns
        -------
        vicinity : float, :math:`v > 0`
            Design point vinicity :math:`v = \\frac{1} {1 + \\tau \\delta_{\\varepsilon}}`.
        """
        return _analytical.StrongMaximumTest_getDesignPointVicinity(self)

    def getPointNumber(self):
        """
        Accessor to the number of points.

        Returns
        -------
        number : int, :math:`N > 0`
            Number of points used to perform the Strong Maximum Test, evaluated by the
            limit state function.
        """
        return _analytical.StrongMaximumTest_getPointNumber(self)

    def getDeltaEpsilon(self):
        """
        Accessor to the parameter :math:`\\delta_{\\varepsilon}`.

        Returns
        -------
        delta_epsilon : float
            :math:`\\delta_{\\varepsilon} = \\sqrt{1 - 2 \\frac{ln(\\varepsilon)}{\\beta^2}} - 1`.
        """
        return _analytical.StrongMaximumTest_getDeltaEpsilon(self)

    def run(self):
        """Perform the Strong Maximum Test."""
        return _analytical.StrongMaximumTest_run(self)

    def getNearDesignPointVerifyingEventPoints(self):
        """
        Accessor to the points verifying the event and near of the design point.

        Returns
        -------
        points : :class:`~openturns.NumericalSample`
            The points of the discretized sphere which are inside the vicinity of
            the standard design point and which verify the event.
        """
        return _analytical.StrongMaximumTest_getNearDesignPointVerifyingEventPoints(self)

    def getFarDesignPointVerifyingEventPoints(self):
        """
        Accessor to the points verifying the event and far of the design point.

        Returns
        -------
        points : :class:`~openturns.NumericalSample`
            The points of the discretized sphere which are out of the vicinity of
            the standard design point and which verify the event.
        """
        return _analytical.StrongMaximumTest_getFarDesignPointVerifyingEventPoints(self)

    def getNearDesignPointViolatingEventPoints(self):
        """
        Accessor to the points not verifying the event and near of the design point.

        Returns
        -------
        point : :class:`~openturns.NumericalSample`
            The points of the discretized sphere which are out of the vicinity of
            the standard design point and which don't verify the event.
        """
        return _analytical.StrongMaximumTest_getNearDesignPointViolatingEventPoints(self)

    def getFarDesignPointViolatingEventPoints(self):
        """
        Accessor to the points not verifying the event and far of the design point.

        Returns
        -------
        points : :class:`~openturns.NumericalSample`
            The points of the discretized sphere which are out of the vicinity of
            the standard design point and which don't verify the event.
        """
        return _analytical.StrongMaximumTest_getFarDesignPointViolatingEventPoints(self)

    def getNearDesignPointVerifyingEventValues(self):
        """
        Accessor to values of the limit state function.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            The values of the limit state function on the points of the
            discretized sphere which are inside the vicinity of the standard design
            point and which verify the event.
        """
        return _analytical.StrongMaximumTest_getNearDesignPointVerifyingEventValues(self)

    def getFarDesignPointVerifyingEventValues(self):
        """
        Accessor to values of the limit state function.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            The values of the limit state function on the points of the
            discretized sphere which are out of the vicinity of the standard design
            point and which verify the event.
        """
        return _analytical.StrongMaximumTest_getFarDesignPointVerifyingEventValues(self)

    def getNearDesignPointViolatingEventValues(self):
        """
        Accessor to values of the limit state function.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            The values of the limit state function on the points of the
            discretized sphere which are inside the vicinity of the standard design
            point and which don't verify the event.
        """
        return _analytical.StrongMaximumTest_getNearDesignPointViolatingEventValues(self)

    def getFarDesignPointViolatingEventValues(self):
        """
        Accessor to values of the limit state function.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            The values of the limit state function on the points of the
            discretized sphere which are out of the vicinity of the standard design
            point and which don't verify the event.
        """
        return _analytical.StrongMaximumTest_getFarDesignPointViolatingEventValues(self)

    def __repr__(self): return _analytical.StrongMaximumTest___repr__(self)
    def __init__(self, *args): 
        this = _analytical.new_StrongMaximumTest(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _analytical.delete_StrongMaximumTest
    __del__ = lambda self : None;
StrongMaximumTest_swigregister = _analytical.StrongMaximumTest_swigregister
StrongMaximumTest_swigregister(StrongMaximumTest)

# This file is compatible with both classic and new-style classes.


