# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Weighted designs of experiments.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_weightedexperiment', [dirname(__file__)])
        except ImportError:
            import _weightedexperiment
            return _weightedexperiment
        if fp is not None:
            try:
                _mod = imp.load_module('_weightedexperiment', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _weightedexperiment = swig_import_helper()
    del swig_import_helper
else:
    import _weightedexperiment
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _weightedexperiment.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _weightedexperiment.SwigPyIterator_value(self)
    def incr(self, n=1): return _weightedexperiment.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _weightedexperiment.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _weightedexperiment.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _weightedexperiment.SwigPyIterator_equal(self, *args)
    def copy(self): return _weightedexperiment.SwigPyIterator_copy(self)
    def next(self): return _weightedexperiment.SwigPyIterator_next(self)
    def __next__(self): return _weightedexperiment.SwigPyIterator___next__(self)
    def previous(self): return _weightedexperiment.SwigPyIterator_previous(self)
    def advance(self, *args): return _weightedexperiment.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _weightedexperiment.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _weightedexperiment.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _weightedexperiment.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _weightedexperiment.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _weightedexperiment.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _weightedexperiment.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _weightedexperiment.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _weightedexperiment.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
class WeightedExperimentImplementation(openturns.experiment.ExperimentImplementation):
    """
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\\Xi_i` so that the
    mean :math:`E_{\\mu}` is approximated as follows:

    .. math::

        \\Expect{ f(\\vect{Z})}_{\\mu} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where :math:`\\mu` is a distribution, :math:`f` is a function :math:`L_1(\\mu)`
    and :math:`\\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """
    __swig_setmethods__ = {}
    for _s in [openturns.experiment.ExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperimentImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.experiment.ExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperimentImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperimentImplementation_getClassName(self)

    def __repr__(self): return _weightedexperiment.WeightedExperimentImplementation___repr__(self)
    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setDistribution(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getDistribution(self)

    def setSize(self, *args):
        """
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setSize(self, *args)

    def getSize(self):
        """
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getSize(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Points :math:`(\\Xi_i)_{i \\in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generate(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generateWithWeights(self)

    def getWeight(self):
        """
        Accessor to the weights associated with the points.

        Returns
        -------
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getWeight(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_WeightedExperimentImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementation
    __del__ = lambda self : None;
WeightedExperimentImplementation_swigregister = _weightedexperiment.WeightedExperimentImplementation_swigregister
WeightedExperimentImplementation_swigregister(WeightedExperimentImplementation)

class WeightedExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperimentImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperimentImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _weightedexperiment.new_WeightedExperimentImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementationTypedInterfaceObject
    __del__ = lambda self : None;
WeightedExperimentImplementationTypedInterfaceObject_swigregister = _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_swigregister
WeightedExperimentImplementationTypedInterfaceObject_swigregister(WeightedExperimentImplementationTypedInterfaceObject)

class WeightedExperiment(WeightedExperimentImplementationTypedInterfaceObject):
    """
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\\Xi_i` so that the
    mean :math:`E_{\\mu}` is approximated as follows:

    .. math::

        \\Expect{ f(\\vect{Z})}_{\\mu} \\simeq \\sum_{i \\in I} \\omega_i f(\\Xi_i)

    where :math:`\\mu` is a distribution, :math:`f` is a function :math:`L_1(\\mu)`
    and :math:`\\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WeightedExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WeightedExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.WeightedExperiment___repr__(self)
    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_setDistribution(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_getDistribution(self)

    def setSize(self, *args):
        """
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_setSize(self, *args)

    def getSize(self):
        """
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_getSize(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            Points :math:`(\\Xi_i)_{i \\in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperiment_generate(self)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperiment_generateWithWeights(self)

    def getWeight(self):
        """
        Accessor to the weights associated with the points.

        Returns
        -------
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.
        """
        return _weightedexperiment.WeightedExperiment_getWeight(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_WeightedExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperiment
    __del__ = lambda self : None;
WeightedExperiment_swigregister = _weightedexperiment.WeightedExperiment_swigregister
WeightedExperiment_swigregister(WeightedExperiment)

class BootstrapExperiment(WeightedExperimentImplementation):
    """
    Bootstrap experiment.

    Available constructors:
        BootstrapExperiment(*sample*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Points to defined a :class:`~openturns.UserDefined` distribution
        :math:`\\mu`.

    Notes
    -----
    BootstrapExperiment is a random weighted design of experiments.
    To call the BootstrapExperiment constructor is equivalent to call the
    :class:`~openturns.WeightedExperiment` constructor as follows:
    *WeightedExperiment(UserDefined(sample), sample.getSize())*.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> myPlane = ot.BootstrapExperiment(sample)
    >>> print(myPlane.generate())
        [ v0 v1 ]
    0 : [ 4  5  ]
    1 : [ 1  2  ]
    2 : [ 1  2  ]
    3 : [ 1  2  ]
    4 : [ 2  3  ]
    >>> print(myPlane.getDistribution())
    UserDefined({x = [0,1], p = 0.2}, {x = [1,2], p = 0.2}, {x = [2,3], p = 0.2}, {x = [3,4], p = 0.2}, {x = [4,5], p = 0.2})
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BootstrapExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BootstrapExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.BootstrapExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.BootstrapExperiment___repr__(self)
    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.BootstrapExperiment_generateWithWeights(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_BootstrapExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_BootstrapExperiment
    __del__ = lambda self : None;
BootstrapExperiment_swigregister = _weightedexperiment.BootstrapExperiment_swigregister
BootstrapExperiment_swigregister(BootstrapExperiment)

class FixedExperiment(WeightedExperimentImplementation):
    """
    Fixed experiment.

    Available constructors:
        FixedExperiment(*aSample*)

        FixedExperiment(*aSample, weights*)

    Parameters
    ----------
    aSample : 2-d sequence of float
        Sample that already exists.
    weights : sequence of float
        Weights of each point of *aSample*.

    Notes
    -----
    FixedExperiment is a deterministic weighted design of experiments.
    It enables to take into account a random sample which has been obtained outside
    the OpenTURNS study or at another step of the OpenTURNS study. The
    :meth:`generate` method always gives the same sample, *aSample*, if it is
    recalled. When not specified, the weights associated to the points are all
    equal to :math:`1/cardI`. Then the sample *aSample* is considered as generated
    from the limit distribution
    :math:`\\lim\\limits_{cardI \\to \\infty} \\sum_{i \\in I} \\omega_i \\delta_{\\vect{X}_i}=\\mu`.
    The :meth:`setDistribution` method has no side effect, as the distribution is
    fixed by the initial sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> myPlane = ot.FixedExperiment(sample)
    >>> print(myPlane.generate())
    0 : [ 0 1 ]
    1 : [ 1 2 ]
    2 : [ 2 3 ]
    3 : [ 3 4 ]
    4 : [ 4 5 ]
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FixedExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FixedExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.FixedExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.FixedExperiment___repr__(self)
    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.FixedExperiment_setDistribution(self, *args)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.FixedExperiment_generateWithWeights(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_FixedExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_FixedExperiment
    __del__ = lambda self : None;
FixedExperiment_swigregister = _weightedexperiment.FixedExperiment_swigregister
FixedExperiment_swigregister(FixedExperiment)

class GaussProductExperiment(WeightedExperimentImplementation):
    """
    Gauss product experiment.

    Available constructors:
        GaussProductExperiment(*marginalDegrees*)

        GaussProductExperiment(*distribution*)

        GaussProductExperiment(*distribution, marginalDegrees*)

    Parameters
    ----------
    marginalDegrees : sequence of positive int
        Numbers of points :math:`N_i` for each direction. Then, the total number of
        points generated is :math:`cardI=\\prod_{i=1}^n N_i`. If not specified,
        each value :math:`N_i` is :math:`5`.
    distribution :
        Distribution :math:`\\mu` of dimension :math:`n` with an independent copula.

    Notes
    -----
    The number of points for each direction doesn't change and the :meth:`generate`
    method always gives the same sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Exponential(), ot.Triangular(-1.0, -0.5, 1.0)])
    >>> marginalDegrees = [3, 2]
    >>> myPlane = ot.GaussProductExperiment(distribution, marginalDegrees)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [  0.415775 -0.511215 ]
    1 : [  2.29428  -0.511215 ]
    2 : [  6.28995  -0.511215 ]
    3 : [  0.415775  0.357369 ]
    4 : [  2.29428   0.357369 ]
    5 : [  6.28995   0.357369 ]
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GaussProductExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GaussProductExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GaussProductExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.GaussProductExperiment___repr__(self)
    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.GaussProductExperiment_generateWithWeights(self)

    def setMarginalDegrees(self, *args):
        """
        Set the marginal degrees.

        Parameters
        ----------
        marginalDegrees : sequence of positive int
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_setMarginalDegrees(self, *args)

    def getMarginalDegrees(self):
        """
        Get the marginal degrees.

        Returns
        -------
        marginalDegrees : :class:`~openturns.Indices`
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_getMarginalDegrees(self)

    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.GaussProductExperiment_setDistribution(self, *args)

    def __init__(self, *args): 
        this = _weightedexperiment.new_GaussProductExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_GaussProductExperiment
    __del__ = lambda self : None;
GaussProductExperiment_swigregister = _weightedexperiment.GaussProductExperiment_swigregister
GaussProductExperiment_swigregister(GaussProductExperiment)

class ImportanceSamplingExperiment(WeightedExperimentImplementation):
    """
    Importance Sampling experiment.

    Available constructors:
        ImportanceSamplingExperiment(*distribution, size*)

        ImportanceSamplingExperiment(*distribution, importanceDistribution, size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.
    importanceDistribution : :class:`~openturns.Distribution`
        Distribution :math:`p` according to which the points of the design of
        experiments will be generated with the Importance Sampling technique.

    Notes
    -----
    ImportanceSamplingExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. When the :meth:`generate`
    method is recalled, the generated sample changes.
    The weights associated to the points are all equal to:
    :math:`\\frac{1}{\\Xi_i}\\frac{\\mu(\\Xi_i)}{p(\\Xi_i)}`

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> importanceDistribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> myPlane = ot.ImportanceSamplingExperiment(distribution, importanceDistribution, 5)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [ 0.629877  0.882805  ]
    1 : [ 0.135276  0.0325028 ]
    2 : [ 0.347057  0.969423  ]
    3 : [ 0.92068   0.50304   ]
    4 : [ 0.0632061 0.292757  ]
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ImportanceSamplingExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ImportanceSamplingExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.ImportanceSamplingExperiment_getClassName(self)

    def getImportanceDistribution(self): return _weightedexperiment.ImportanceSamplingExperiment_getImportanceDistribution(self)
    def __repr__(self): return _weightedexperiment.ImportanceSamplingExperiment___repr__(self)
    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.ImportanceSamplingExperiment_generateWithWeights(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_ImportanceSamplingExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_ImportanceSamplingExperiment
    __del__ = lambda self : None;
ImportanceSamplingExperiment_swigregister = _weightedexperiment.ImportanceSamplingExperiment_swigregister
ImportanceSamplingExperiment_swigregister(ImportanceSamplingExperiment)

class LHSExperiment(WeightedExperimentImplementation):
    """
    LHS experiment.

    Available constructors:
        LHSExperiment(*size, alwaysShuffle, randomShift*)

        LHSExperiment(*distribution, size, alwaysShuffle, randomShift*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`\\mathrm{card}\\,I` of points that will be generated in the experiment.
    alwaysShuffle : bool
        Flag to tell if the shuffle must be regenerated at each call to generate
        or not.
        Default is *False*: the shuffle is generated once and for all.

    randomShift : bool
        Flag to tell if the point selected in each cell of the shuffle is the center
        of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
        of the distribution to the cell.
        Default is *True*.

    Notes
    -----
    LHSExperiment is a random weighted design of experiments.
    The method generates a sample of points :math:`\\Xi_i` according to the
    distribution :math:`\\mu` with the LHS technique: some cells are determined,
    with the same probabilistic content according to the distribution, each line
    and each column contains exactly one cell, then points are selected among these
    selected cells. The weights associated to the points are all equal to
    :math:`1/\\mathrm{card}\\,I`. When recalled, the :meth:`generate` method generates a new
    sample: the point selection within the cells changes but not the cells
    selection. To change the cell selection, it is necessary to create a new LHS
    Experiment.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    Create an *LHSExperiment*:

    >>> import openturns as ot

    Generate the sample reusing the initial shuffle and using a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [  1.52938   -0.343515  ]
    1 : [ -0.0703427  2.36353   ]
    2 : [  0.576091  -1.79398   ]
    3 : [ -2.11636    0.619315  ]
    4 : [ -0.699601  -0.0570674 ]

    Generate the sample using a new shuffle and a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [ -1.72695   -0.591043  ]
    1 : [ -0.240653  -0.0406593 ]
    2 : [  0.828719   2.12547   ]
    3 : [  2.37061    0.508903  ]
    4 : [ -0.668296  -1.11573   ]

    Generate the sample reusing the initial shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]

    Generate the sample using a new shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.524401 -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [ -1.28155   0        ]
    3 : [ -0.524401  0.524401 ]
    4 : [  1.28155  -1.28155  ]

    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHSExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHSExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.LHSExperiment___repr__(self)
    def __str__(self, offset=""): return _weightedexperiment.LHSExperiment___str__(self, offset)
    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LHSExperiment_generateWithWeights(self)

    def ComputeShuffle(*args):
        """
        Generate a new cell randomization for external use.

        Parameters
        ----------
        dimension : positive int
            Number of input dimension.
        totalSize : positive int
            Number :math:`\\mathrm{card}\\,I` of points that need to be shuffled.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_ComputeShuffle(*args)

    if _newclass:ComputeShuffle = staticmethod(ComputeShuffle)
    __swig_getmethods__["ComputeShuffle"] = lambda x: ComputeShuffle
    def getShuffle(self):
        """
        Return the cell randomization.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_getShuffle(self)

    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LHSExperiment_setDistribution(self, *args)

    def getAlwaysShuffle(self):
        """
        Cell randomization flag accessor.

        Returns
        -------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_getAlwaysShuffle(self)

    def setAlwaysShuffle(self, *args):
        """
        Cell randomization flag accessor.

        Parameters
        ----------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_setAlwaysShuffle(self, *args)

    def getRandomShift(self):
        """
        Randomization flag accessor.

        Returns
        -------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_getRandomShift(self)

    def setRandomShift(self, *args):
        """
        Randomization flag accessor.

        Parameters
        ----------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_setRandomShift(self, *args)

    def __init__(self, *args): 
        this = _weightedexperiment.new_LHSExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LHSExperiment
    __del__ = lambda self : None;
LHSExperiment_swigregister = _weightedexperiment.LHSExperiment_swigregister
LHSExperiment_swigregister(LHSExperiment)

def LHSExperiment_ComputeShuffle(*args):
  """
    Generate a new cell randomization for external use.

    Parameters
    ----------
    dimension : positive int
        Number of input dimension.
    totalSize : positive int
        Number :math:`\\mathrm{card}\\,I` of points that need to be shuffled.

    Returns
    -------
    shuffle : :class:`~openturns.Matrix`
        For each point, the indices of the shuffled components.
    """
  return _weightedexperiment.LHSExperiment_ComputeShuffle(*args)

class LowDiscrepancyExperiment(WeightedExperimentImplementation):
    """
    LowDiscrepancy experiment.

    Available constructors:
        LowDiscrepancyExperiment(*size, restart*)

        LowDiscrepancyExperiment(*sequence, size, restart*)

        LowDiscrepancyExperiment(*sequence, distribution, size, restart*)

    Parameters
    ----------
    size : positive int
        Number :math:`N` of points of the sequence.
    sequence : :class:`~openturns.LowDiscrepancySequence`
        Sequence of points :math:`(u_1, \\cdots, u_N)` with low discrepancy.
        If not specified, the sequence is a :class:`~openturns.SobolSequence`.
    distribution :
        Distribution :math:`\\mu` of dimension :math:`n` with an independent copula.
        The low discrepancy sequence :math:`(u_1, \\cdots, u_N)` is uniformly
        distributed over :math:`[0,1]^n`. We use the marginal transformation
        :math:`\\Xi_i =F_i^{-1}(u_i)` to generate points :math:`(\\Xi_i)_{i\\in I}`
        according to the distribution :math:`\\mu`. The weights are all equal to
        :math:`1/N`.
    restart : bool
        Flag to tell if the low discrepancy sequence must be restarted from
        its initial state at each change of distribution or not.
        Default is *True*: the sequence is restarted at each change of
        distribution.

    Notes
    -----
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. When the :meth:`generate`
    method is recalled, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)] * 2)

    Generate the sample with a reinitialization of the sequence at each change
    of distribution:

    >>> myPlane = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, True)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> myPlane.setDistribution(distribution)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]

    Generate the sample keeping the previous state of the sequence at each change
    of distribution:

    >>> myPlane = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(myPlane.generate())
        [ X0    X1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> myPlane.setDistribution(distribution)
    >>> print(myPlane.generate())
        [ X0     X1     ]
    0 : [ 0.4375 0.5625 ]
    1 : [ 0.3125 0.1875 ]
    2 : [ 0.8125 0.6875 ]
    3 : [ 0.5625 0.4375 ]
    4 : [ 0.0625 0.9375 ]

    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LowDiscrepancyExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LowDiscrepancyExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.LowDiscrepancyExperiment___repr__(self)
    def __str__(self, offset=""): return _weightedexperiment.LowDiscrepancyExperiment___str__(self, offset)
    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_setDistribution(self, *args)

    def getSequence(self):
        """
        Return the sequence.

        Returns
        -------
        sequence : :class:`~openturns.LowDiscrepancySequence`
            Sequence of points :math:`(u_1, \\cdots, u_N)` with low discrepancy.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getSequence(self)

    def getRestart(self):
        """
        Return the value of the *restart* flag.

        Returns
        -------
        restart : bool
            The value of the *restart* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRestart(self)

    def setRestart(self, *args):
        """
        Set the value of the *restart* flag.

        Parameters
        ----------
        restart : bool
            The value of the *restart* flag. If equals to *True*, the low
            discrepancy sequence is restarted at each change of distribution,
            else it is changed only if the new distribution has a dimension
            different from the current one.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRestart(self, *args)

    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LowDiscrepancyExperiment_generateWithWeights(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_LowDiscrepancyExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_LowDiscrepancyExperiment
    __del__ = lambda self : None;
LowDiscrepancyExperiment_swigregister = _weightedexperiment.LowDiscrepancyExperiment_swigregister
LowDiscrepancyExperiment_swigregister(LowDiscrepancyExperiment)

class MonteCarloExperiment(WeightedExperimentImplementation):
    """
    MonteCarlo experiment.

    Available constructors:
        MonteCarloExperiment(*distribution, size*)

        MonteCarloExperiment(*size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    MonteCarloExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\\Xi_i)_{i \\in I}`
    independently from the distribution :math:`\\mu`. The weights associated to the
    points are all equal to :math:`1/\\mathrm{card}\\,I`. When the :meth:`generate` method is
    recalled, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myPlane = ot.MonteCarloExperiment(ot.Normal(2), 5)
    >>> print(myPlane.generate())
        [ X0        X1        ]
    0 : [  0.608202 -1.26617  ]
    1 : [ -0.438266  1.20548  ]
    2 : [ -2.18139   0.350042 ]
    3 : [ -0.355007  1.43725  ]
    4 : [  0.810668  0.793156 ]
    """
    __swig_setmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarloExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [WeightedExperimentImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarloExperiment, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloExperiment_getClassName(self)

    def __repr__(self): return _weightedexperiment.MonteCarloExperiment___repr__(self)
    def generateWithWeights(self):
        """
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.NumericalSample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.NumericalPoint` of size :math:`cardI`
            Weights :math:`(\\omega_i)_{i \\in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloExperiment_generateWithWeights(self)

    def __init__(self, *args): 
        this = _weightedexperiment.new_MonteCarloExperiment(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloExperiment
    __del__ = lambda self : None;
MonteCarloExperiment_swigregister = _weightedexperiment.MonteCarloExperiment_swigregister
MonteCarloExperiment_swigregister(MonteCarloExperiment)

# This file is compatible with both classic and new-style classes.


