# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Probabilistic meta-package.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_uncertainty', [dirname(__file__)])
        except ImportError:
            import _uncertainty
            return _uncertainty
        if fp is not None:
            try:
                _mod = imp.load_module('_uncertainty', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _uncertainty = swig_import_helper()
    del swig_import_helper
else:
    import _uncertainty
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _uncertainty.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _uncertainty.SwigPyIterator_value(self)
    def incr(self, n=1): return _uncertainty.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _uncertainty.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _uncertainty.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _uncertainty.SwigPyIterator_equal(self, *args)
    def copy(self): return _uncertainty.SwigPyIterator_copy(self)
    def next(self): return _uncertainty.SwigPyIterator_next(self)
    def __next__(self): return _uncertainty.SwigPyIterator___next__(self)
    def previous(self): return _uncertainty.SwigPyIterator_previous(self)
    def advance(self, *args): return _uncertainty.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _uncertainty.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _uncertainty.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _uncertainty.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _uncertainty.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _uncertainty.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _uncertainty.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _uncertainty.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _uncertainty.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
class TaylorExpansionMoments(openturns.common.PersistentObject):
    """
    First and second order Taylor expansion formulas.

    Available constructors:
        TaylorExpansionMoments(*limitStateVariable*)

    Parameters
    ----------
    limitStateVariable : :class:`~openturns.RandomVector`
        This RandomVector must be of type *Composite*, which means it must have
        been defined with the fourth usage of declaration of a RandomVector
        (from a NumericalMathFunction and an antecedent Distribution) or with
        the class :class:`~openturns.CompositeRandomVector`.

    Notes
    -----
    In a probabilistic approach the Taylor expansion can be used
    propagate the uncertainties of the input variables :math:`\\uX` through the
    model :math:`h` towards the output variables :math:`\\uY`. It enables to access
    the central dispersion (Expectation, Variance) of the output variables.

    This method is based on a Taylor decomposition of the output variable
    :math:`\\uY` towards the :math:`\\uX` random vectors around the mean point
    :math:`\\muX`. Depending on the order of the Taylor decomposition (classically
    first order or second order), one can obtain different formulas introduced
    hereafter.

    As :math:`\\uY=h(\\uX)`, the Taylor decomposition around :math:`\\ux = \\muX` at
    the second order yields to:

    .. math::

        \\uY = h(\\muX) + <\\vect{\\vect{\\nabla}}h(\\muX) , \\: \\uX - \\muX> + \\frac{1}{2}<<\\vect{\\vect{\\vect{\\nabla }}}^2 h(\\muX,\\: \\vect{\\mu}_{\\:X}),\\: \\uX - \\muX>,\\: \\uX - \\muX> + o(\\Cov \\uX)

    where:

    - :math:`\\muX = \\Expect{\\uX}` is the vector of the input variables at the mean
      values of each component.

    - :math:`\\Cov \\uX` is the covariance matrix of the random vector `\\uX`. The
      elements are the followings :
      :math:`(\\Cov \\uX)_{ij} = \\Expect{\\left(X^i - \\Expect{X^i} \\right)^2}`

    - :math:`\\vect{\\vect{\\nabla}} h(\\muX) = \\: \\Tr{\\left( \\frac{\\partial y^i}{\\partial x^j}\\right)}_{\\ux\\: =\\: \\muX} = \\: \\Tr{\\left( \\frac{\\partial h^i(\\ux)}{\\partial x^j}\\right)}_{\\ux\\: =\\: \\muX}`
      is the transposed Jacobian matrix with :math:`i=1,\\ldots,n_Y` and
      :math:`j=1,\\ldots,n_X`.

    - :math:`\\vect{\\vect{\\vect{\\nabla^2}}} h(\\ux\\:,\\ux)` is a tensor of order 3. It
      is composed by the second order derivative towards the :math:`i^\\textrm{th}`
      and :math:`j^\\textrm{th}` components of :math:`\\ux` of the
      :math:`k^\\textrm{th}` component of the output vector :math:`h(\\ux)`. It
      yields to:
      :math:`\\left( \\nabla^2 h(\\ux) \\right)_{ijk} = \\frac{\\partial^2 (h^k(\\ux))}{\\partial x^i \\partial x^j}`

    - :math:`<\\vect{\\vect{\\nabla}}h(\\muX) , \\: \\uX - \\muX> = \\sum_{j=1}^{n_X} \\left( \\frac{\\partial {\\uy}}{\\partial {x^j}}\\right)_{\\ux = \\muX} . \\left( X^j-\\muX^j \\right)`

    -
      .. math::

          <<\\vect{\\vect{\\vect{\\nabla }}}^2 h(\\muX,\\: \\vect{\\mu}_{X}),\\: \\uX - \\muX>,\\: \\uX - \\muX> = \\left( \\Tr{(\\uX^i - \\muX^i)}. \\left(\\frac{\\partial^2 y^k}{\\partial x^i \\partial x^k}\\right)_{\\ux = \\muX}. (\\uX^j - \\muX^j) \\right)_{ijk}

    **Approximation at the order 1:**

    Expectation:

    .. math::

        \\Expect{\\uY} \\approx \\vect{h}(\\muX)

    Pay attention that :math:`\\Expect{\\uY}` is a vector. The :math:`k^\\textrm{th}`
    component of this vector is equal to the :math:`k^\\textrm{th}` component of the
    output vector computed by the model :math:`h` at the mean value.
    :math:`\\Expect{\\uY}` is thus the computation of the model at mean.

    Variance:

    .. math::

        \\Cov \\uY \\approx \\Tr{\\vect{\\vect{\\nabla}}}\\:\\vect{h}(\\muX).\\Cov \\uX.\\vect{\\vect{\\nabla}}\\:\\vect{h}(\\muX)

    **Approximation at the order 2:**

    Expectation:

    .. math::

        (\\Expect{\\uY})_k \\approx (\\vect{h}(\\muX))_k +
                                  \\left(
                                  \\sum_{i=1}^{n_X}\\frac{1}{2} (\\Cov \\uX)_{ii}.{(\\nabla^2\\:h(\\uX))}_{iik} +
                                  \\sum_{i=1}^{n_X} \\sum_{j=1}^{i-1} (\\Cov X)_{ij}.{(\\nabla^2\\:h(\\uX))}_{ijk}
                                  \\right)_k

    Variance:

    The decomposition of the variance at the order 2 is not implemented in the
    standard version of OpenTURNS. It requires both the knowledge of higher order
    derivatives of the model and the knowledge of moments of order strictly greater
    than 2 of the PDF.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunc = ot.NumericalMathFunction(['x1', 'x2', 'x3', 'x4'], ['y1', 'y2'],
    ...     ['(x1*x1+x2^3*x1)/(2*x3*x3+x4^4+1)', 'cos(x2*x2+x4)/(x1*x1+1+x3^4)'])
    >>> R = ot.CorrelationMatrix(4)
    >>> for i in range(4):
    ...     R[i, i - 1] = 0.25
    >>> distribution = ot.Normal([0.2]*4, [0.1, 0.2, 0.3, 0.4], R)
    >>> # We create a distribution-based RandomVector
    >>> X = ot.RandomVector(distribution)
    >>> # We create a composite RandomVector Y from X and myFunc
    >>> Y = ot.RandomVector(myFunc, X)
    >>> # We create a Taylor expansion method to approximate moments
    >>> myTaylorExpansionMoments = ot.TaylorExpansionMoments(Y)
    >>> print(myTaylorExpansionMoments.getMeanFirstOrder())
    [0.0384615,0.932544]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TaylorExpansionMoments, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TaylorExpansionMoments, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.TaylorExpansionMoments_getClassName(self)

    def __repr__(self): return _uncertainty.TaylorExpansionMoments___repr__(self)
    def getLimitStateVariable(self):
        """
        Get the limit state variable.

        Returns
        -------
        limitStateVariable : :class:`~openturns.RandomVector`
            Limit state variable.
        """
        return _uncertainty.TaylorExpansionMoments_getLimitStateVariable(self)

    def getMeanFirstOrder(self):
        """
        Get the approximation at the first order of the mean.

        Returns
        -------
        mean : :class:`~openturns.NumericalPoint`
            Approximation at the first order of the mean of the random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getMeanFirstOrder(self)

    def getMeanSecondOrder(self):
        """
        Get the approximation at the second order of the mean.

        Returns
        -------
        mean : :class:`~openturns.NumericalPoint`
            Approximation at the second order of the mean of the random vector
            (it requires that the hessian of the NumericalMathFunction has been defined).
        """
        return _uncertainty.TaylorExpansionMoments_getMeanSecondOrder(self)

    def getCovariance(self):
        """
        Get the approximation at the first order of the covariance matrix.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Approximation at the first order of the covariance matrix of the random
            vector.
        """
        return _uncertainty.TaylorExpansionMoments_getCovariance(self)

    def getValueAtMean(self):
        """
        Get the value of the function.

        Returns
        -------
        value : :class:`~openturns.NumericalPoint`
            Value of the NumericalMathFunction which defines the random vector at
            the mean point of the input random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getValueAtMean(self)

    def getGradientAtMean(self):
        """
        Get the gradient of the function.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the NumericalMathFunction which defines the random vector at
            the mean point of the input random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getGradientAtMean(self)

    def getHessianAtMean(self):
        """
        Get the hessian of the function.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the NumericalMathFunction which defines the random vector at
            the mean point of the input random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getHessianAtMean(self)

    def getImportanceFactors(self):
        """
        Get the importance factors.

        Returns
        -------
        factors : :class:`~openturns.NumericalPoint`
            Importance factors of the inputs : only when randVect is of dimension 1.
        """
        return _uncertainty.TaylorExpansionMoments_getImportanceFactors(self)

    def drawImportanceFactors(self):
        """
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the
            probabilistic variables.
        """
        return _uncertainty.TaylorExpansionMoments_drawImportanceFactors(self)

    def __init__(self, *args): 
        this = _uncertainty.new_TaylorExpansionMoments(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_TaylorExpansionMoments
    __del__ = lambda self : None;
TaylorExpansionMoments_swigregister = _uncertainty.TaylorExpansionMoments_swigregister
TaylorExpansionMoments_swigregister(TaylorExpansionMoments)

# deprecated
class QuadraticCumul(TaylorExpansionMoments):
    def __init__(self, *args):
        super(QuadraticCumul, self).__init__(*args)
        openturns.common.Log.Warn('class QuadraticCumul is deprecated in favor of TaylorExpansionMoments')

class ANCOVA(_object):
    """
    ANalysis of COVAriance method (ANCOVA).

    Available constructor:
        ANCOVA(*functionalChaosResult, correlatedInput*)

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos result approximating the model response with
        uncorrelated inputs.
    correlatedInput : 2-d sequence of float
        Correlated inputs used to compute the real values of the output.
        Its dimension must be equal to the number of inputs of the model.

    Notes
    -----
    ANCOVA, a variance-based method described in [Caniou2012]_, is a generalization
    of the ANOVA (ANalysis Of VAriance) decomposition for models with correlated
    input parameters.

    Let us consider a model :math:`Y = h(\\vect{X})` without making any hypothesis
    on the dependence structure of :math:`\\vect{X} = \\{X^1, \\ldots, X^{n_X} \\}`, a
    n_X-dimensional random vector. The covariance decomposition requires a functional
    decomposition of the model. Thus the model response :math:`Y` is expanded as a
    sum of functions of increasing dimension as follows:

    .. math::
        :label: model

        h(\\vect{X}) = h_0 + \\sum_{u\\subseteq\\{1,\\dots,n_X\\}} h_u(X_u)

    :math:`h_0` is the mean of :math:`Y`. Each function :math:`h_u` represents,
    for any non empty set :math:`u\\subseteq\\{1, \\dots, n_X\\}`, the combined
    contribution of the variables :math:`X_u` to :math:`Y`.

    Using the properties of the covariance, the variance of :math:`Y` can be
    decomposed into a variance part and a covariance part as follows:

    .. math::

        Var[Y]&= Cov\\left[h_0 + \\sum_{u\\subseteq\\{1,\\dots,n_X\\}} h_u(X_u), h_0 + \\sum_{u\\subseteq\\{1,\\dots,n_X\\}} h_u(X_u)\\right] \\\\
              &= \\sum_{u\\subseteq\\{1,\\dots,n_X\\}} \\left[Var[h_u(X_u)] + Cov[h_u(X_u), \\sum_{v\\subseteq\\{1,\\dots,n_X\\}, v\\cap u=\\varnothing} h_v(X_v)]\\right]

    This variance formula enables to define each total part of variance of
    :math:`Y` due to :math:`X_u`, :math:`S_u`, as the sum of a *physical*
    (or *uncorrelated*) part and a *correlated* part such as:

    .. math::

        S_u = \\frac{Cov[Y, h_u(X_u)]} {Var[Y]} = S_u^U + S_u^C

    where :math:`S_u^U` is the uncorrelated part of variance of Y due to :math:`X_u`:

    .. math::

        S_u^U = \\frac{Var[h_u(X_u)]} {Var[Y]}

    and :math:`S_u^C` is the contribution of the correlation of :math:`X_u` with the
    other parameters:

    .. math::

        S_u^C = \\frac{Cov\\left[h_u(X_u), \\displaystyle \\sum_{v\\subseteq\\{1,\\dots,n_X\\}, v\\cap u=\\varnothing} h_v(X_v)\\right]}
                     {Var[Y]}

    As the computational cost of the indices with the numerical model :math:`h`
    can be very high, [Caniou2012]_ suggests to approximate the model response with
    a polynomial chaos expansion:

    .. math::

        Y \\simeq \\hat{h} = \\sum_{j=0}^{P-1} \\alpha_j \\Psi_j(x)

    However, for the sake of computational simplicity, the latter is constructed
    considering *independent* components :math:`\\{X^1,\\dots,X^{n_X}\\}`. Thus the
    chaos basis is not orthogonal with respect to the correlated inputs under
    consideration, and it is only used as a metamodel to generate approximated
    evaluations of the model response and its summands :eq:`model`.

    The next step consists in identifying the component functions. For instance, for
    :math:`u = \\{1\\}`:

    .. math::

        h_1(X_1) = \\sum_{\\alpha | \\alpha_1 \\neq 0, \\alpha_{i \\neq 1} = 0} y_{\\alpha} \\Psi_{\\alpha}(\\vect{X})

    where :math:`\\alpha` is a set of degrees associated to the :math:`n_X` univariate
    polynomial :math:`\\psi_i^{\\alpha_i}(X_i)`.

    Then the model response :math:`Y` is evaluated using a sample
    :math:`X=\\{x_k, k=1,\\dots,N\\}` of the correlated joint distribution. Finally,
    the several indices are computed using the model response and its component
    functions that have been identified on the polynomial chaos.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Model and distribution definition
    >>> model = ot.NumericalMathFunction(['X1','X2'], ['Y'], ['4.*X1 + 5.*X2'])
    >>> distribution = ot.ComposedDistribution([ot.Normal()] * 2)
    >>> S = ot.CorrelationMatrix(2)
    >>> S[1, 0] = 0.3
    >>> R = ot.NormalCopula().GetCorrelationFromSpearmanCorrelation(S)
    >>> CorrelatedInputDistribution = ot.ComposedDistribution([ot.Normal()] * 2, ot.NormalCopula(R))
    >>> sample = CorrelatedInputDistribution.getSample(200)
    >>> # Functional chaos computation
    >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()] * 2, ot.EnumerateFunction(2))
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 15)
    >>> projectionStrategy = ot.LeastSquaresStrategy(ot.MonteCarloExperiment(100))
    >>> algo = ot.FunctionalChaosAlgorithm(model, distribution, adaptiveStrategy, projectionStrategy)
    >>> algo.run()
    >>> ancovaResult = ot.ANCOVA(algo.getResult(), sample)
    >>> indices = ancovaResult.getIndices()
    >>> print(indices)
    [0.408398,0.591602]
    >>> uncorrelatedIndices = ancovaResult.getUncorrelatedIndices()
    >>> print(uncorrelatedIndices)
    [0.284905,0.468108]
    >>> # Get indices measuring the correlated effects
    >>> print(indices - uncorrelatedIndices)
    [0.123494,0.123494]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ANCOVA, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ANCOVA, name)
    __repr__ = _swig_repr
    def getUncorrelatedIndices(self, marginalIndex=0):
        """
        Accessor to the ANCOVA indices measuring uncorrelated effects.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \\leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            List of the ANCOVA indices measuring uncorrelated effects of the inputs.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _uncertainty.ANCOVA_getUncorrelatedIndices(self, marginalIndex)

    def getIndices(self, marginalIndex=0):
        """
        Accessor to the ANCOVA indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \\leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            List of the ANCOVA indices measuring the contribution of the
            input variables to the variance of the model. These indices are made up
            of a *physical* part and a *correlated* part. The first one is obtained
            thanks to :meth:`getUncorrelatedIndices`.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _uncertainty.ANCOVA_getIndices(self, marginalIndex)

    def __init__(self, *args): 
        this = _uncertainty.new_ANCOVA(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_ANCOVA
    __del__ = lambda self : None;
ANCOVA_swigregister = _uncertainty.ANCOVA_swigregister
ANCOVA_swigregister(ANCOVA)

class FAST(_object):
    """
    Fourier Amplitude Sensitivity Testing (FAST).

    Available constructor:
        FAST(*model, distribution, N, Nr=1, M=4*)

    Parameters
    ----------
    model : :class:`~openturns.NumericalMathFunction`
        Definition of the model to analyse.
    distribution : :class:`~openturns.Distribution`
        Contains the distributions of each model's input.
        Its dimension must be equal to the number of inputs.
    N : int, :math:`N > Nr`
        Size of the sample from which the Fourier series are calculated.
        It represents the length of the discretization of the s-space.
    Nr : int, :math:`Nr \\geq 1`
        Number of resamplings. The extended FAST method involves a part of
        randomness in the computation of the indices. So it can be asked to
        realize the procedure *Nr* times and then to calculate the
        arithmetic means of the results over the *Nr* estimates.
    M : int, :math:`0 < M < N`
        Interference factor usually equal to 4 or higher.
        It corresponds to the truncation level of the Fourier series, i.e. the
        number of harmonics that are retained in the decomposition.

    Notes
    -----
    FAST is a sensitivity analysis method which is based upon the ANOVA
    decomposition of the variance of the model response :math:`y = f(\\vect{X})`,
    the latter being represented by its Fourier expansion.
    :math:`\\vect{X}=\\{X^1,\\dots,X^{n_X}\\}` is an input random vector of :math:`n_X`
    independent components.

    OpenTURNS implements the extended FAST method consisting in computing
    alternately the first order and the total-effect indices of each input.
    This approach, widely described in the paper by [Saltelli1999]_, relies upon a
    Fourier decomposition of the model response. Its key idea is to recast this
    representation as a function of a *scalar* parameter :math:`s`, by defining
    parametric curves :math:`s \\mapsto x_i(s), i=1, \\dots, n_X` exploring the
    support of the input random vector :math:`\\vect{X}`.

    Then the Fourier expansion of the model response is:

    .. math::

        f(s) = \\sum_{k \\in \\Zset^N} A_k cos(ks) + B_k sin(ks)

    where :math:`A_k` and :math:`B_k` are Fourier coefficients whose estimates are:

    .. math::

        \\hat{A}_k &= \\frac{1}{N} \\sum_{j=1}^N f(x_j^1,\\dots,x_j^{N_X}) cos\\left(\\frac{2k\\pi (j-1)}{N} \\right) \\quad , \\quad -\\frac{N}{2} \\leq k \\leq \\frac{N}{2} \\\\
        \\hat{B}_k &= \\frac{1}{N} \\sum_{j=1}^N f(x_j^1,\\dots,x_j^{N_X}) sin\\left(\\frac{2k\\pi (j-1)}{N} \\right) \\quad , \\quad -\\frac{N}{2} \\leq k \\leq \\frac{N}{2}


    The first order indices are estimated by:

    .. math::

        \\hat{S}_i = \\frac{\\hat{D}_i}{\\hat{D}}
                  = \\frac{\\sum_{p=1}^M(\\hat{A}_{p\\omega_i}^2 + \\hat{B}_{p\\omega_i}^2)^2}
                          {\\sum_{n=1}^{(N-1)/2}(\\hat{A}_n^2 + \\hat{B}_n^2)^2}

    and the total order indices by:

    .. math::

        \\hat{T}_i = 1 - \\frac{\\hat{D}_{-i}}{\\hat{D}}
                  = 1 - \\frac{\\sum_{k=1}^{\\omega_i/2}(\\hat{A}_k^2 + \\hat{B}_k^2)^2}
                              {\\sum_{n=1}^{(N-1)/2}(\\hat{A}_n^2 + \\hat{B}_n^2)^2}

    where :math:`\\hat{D}` is the total variance, :math:`\\hat{D}_i` the portion
    of :math:`D` arising from the uncertainty of the :math:`i^{th}` input and
    :math:`\\hat{D}_{-i}` is the part of the variance due to all the inputs
    except the :math:`i^{th}` input.

    :math:`N` is the size of the sample using to compute the Fourier series and
    :math:`M` is the interference factor. *Saltelli et al.* (1999) recommanded to
    set :math:`M` to a value in the range :math:`[4, 6]`.
    :math:`\\{\\omega_i\\}, \\forall i=1, \\dots, n_X` is a set of integer frequencies
    assigned to each input :math:`X^i`. The frequency associated with the input
    for which the sensitivity indices are computed, is set to the maximum admissible
    frequency satisfying the Nyquist criterion (which ensures to avoid aliasing effects):

    .. math::

        \\omega_i = \\frac{N - 1}{2M}

    In the paper by Saltelli et al. (1999), for high sample size, it is suggested
    that :math:`16 \\leq \\omega_i/N_r \\leq 64`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formulaIshigami = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> modelIshigami = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['y'], formulaIshigami)
    >>> distributions = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> sensitivityAnalysis = ot.FAST(modelIshigami, distributions, 101)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311097,0.441786,0.000396837]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FAST, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FAST, name)
    __repr__ = _swig_repr
    def getFirstOrderIndices(self, marginalIndex=0):
        """
        Accessor to the first order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \\leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            List of the first order indices of all the inputs.
        """
        return _uncertainty.FAST_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        """
        Accessor to the total order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \\leq i < n`, optional
            Index of the model's  marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            List of the total-effect order indices of all the inputs.
        """
        return _uncertainty.FAST_getTotalOrderIndices(self, marginalIndex)

    def getFFTAlgorithm(self):
        """
        Accessor to the FFT algorithm implementation.

        Returns
        -------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _uncertainty.FAST_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, *args):
        """
        Accessor to the FFT algorithm implementation.

        Parameters
        ----------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _uncertainty.FAST_setFFTAlgorithm(self, *args)

    def setBlockSize(self, *args):
        """
        Set the block size.

        Parameters
        ----------
        k : positive int
            Size of each block the sample is splitted into, this allows to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to :math:`1`.
        """
        return _uncertainty.FAST_setBlockSize(self, *args)

    def getBlockSize(self):
        """
        Get the block size.

        Returns
        -------
        k : positive int
            Size of each block the sample is splitted into, this allows to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to 1.
        """
        return _uncertainty.FAST_getBlockSize(self)

    def __init__(self, *args): 
        this = _uncertainty.new_FAST(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_FAST
    __del__ = lambda self : None;
FAST_swigregister = _uncertainty.FAST_swigregister
FAST_swigregister(FAST)

class SobolIndicesAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Sensitivity analysis.

    Notes
    -----
    This method is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty.

    Here we attempt to evaluate the part of variance of :math:`Y^k` due to the different components :math:`X^i`.

    We denote G the physical model such as :math:`\\vect{Y}=G(\\vect{X})`. Let us consider first the case where :math:`\\vect{Y}` is of dimension 1.

    The objective here is to develop the variability of the random variable :math:`\\vect{Y}` as function of :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)`. Using the Hoeffding decomposition, we got:

    .. math::

       \\Var{\\vect{Y}} = \\sum_{i=1}^{n_X} V_i + \\sum_{i<j} V_{i,j} + \\sum_{i<k<j} V_{i,j,k} + \\cdots + V_{1,2,..,n_X}

    where :

    :math:`V_i = \\Var{\\Expect{ Y \\vert X_i}}` and :math:`V_{i,j} = \\Var{\\Expect{ Y \\vert X_i, X_j}} - V_i - V_j`. Using the previous decomposition, it follows that sensitivity indices are defined as follow:


    .. math::

       \\begin{array}{ccc}
        S_i & = & \\frac{V_i}{\\Var{\\vect{Y}}} \\\\
        S_{i,j} & = & \\frac{V_{i,j}}{\\Var{\\vect{Y}}}
       \\end{array}

    :math:`(S_i)` are the first order sensitivity indices and measure the impact of :math:`X_i` in the variance :math:`\\Var{\\vect{Y}}`,
    :math:`(S_{i,j})` are the second order sensitivity indices and measure the impact of the interaction of :math:`X_i` and :math:`X_j` in the variance :math:`\\Var{\\vect{Y}}`.

    When :math:`n_X >> 1`, we use total sensitivity indices :math:`ST_i`, which is defined as the sum of all indices that count the i-th variable:

    .. math::

        ST_i =  1 - \\frac{V_{-i}}{\\Var{\\vect{Y}}} = \\frac{VT_i}{\\Var{\\vect{Y}}}, \\forall\\ i\\in(1,2,...,n_X)

    where :math:`V_{-i}` is the part of variance of :math:`\\Var{\\vect{Y}}` that do not countain the i-th variable.

    |

    In practice, to estimate these quantities, Sobol proposes to use numerical methods that rely on the two independent realizations of the random vector :math:`\\vect{X}`.
    If we consider `A` and `B` two independent samples (of size `n`) of the previous random vector:

    .. math::

       A = \\left(
       \\begin{array}{cccc}
       a_{1,1} & a_{1,2} & \\cdots & a_{1, n_X} \\\\
       a_{2,1} & a_{2,2} & \\cdots & a_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       a_{n,1} & a_{1,2} & \\cdots & a_{n, n_X}
       \\end{array}
       \\right), \\  B = \\left(
       \\begin{array}{cccc}
       b_{1,1} & b_{1,2} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\vdots \\\\
       b_{n,1} & b_{1,2} & \\cdots & b_{n, n_X}
       \\end{array}
       \\right)


    Each line is a realization of the random vector. The purpose is to mix these two samples to get an estimate of the sensitivities.

    `Sobol` method require respectively :math:`C^i` and :math:`D^{i,j}` sample designs for the evaluation of first order (respectively second order) sensitivity indices. These are defined as hereafter:

    .. math::

       C^i = \\left(
       \\begin{array}{ccccc}
       b_{1,1} & b_{1,2} & a_{1,i} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & a_{2,i} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       b_{n,1} & b_{1,2} & a_{n,i} & \\cdots & b_{n, n_X}
       \\end{array}
       \\right), \\ D^{i,j} = \\left(
       \\begin{array}{ccccccc}
       b_{1,1} & b_{1,2} & a_{1,i} & \\cdots & a_{1,j} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & a_{2,i} & \\cdots & a_{2,j} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\vdots & \\vdots  & \\ddots & \\vdots \\\\
       b_{n,1} & b_{n,2} & a_{n,i} & \\cdots & a_{n,j} & \\cdots & b_{n, n_X} \\\\
       \\end{array}
       \\right)

    It follows that :math:`V_{i}` and :math:`V_{i,j}` terms are defined as follow:

    .. math::

       \\begin{array}{ccc}
        V_i & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k) G(C_k) - V_i - V_j - G_0^2 \\\\
        V_{i,j} & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k) G(D_k) - G_0^2 \\\\
        G_0 & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k)
       \\end{array}

    The implemented second order indices use this formula.

    The major methods (`Saltelli`, `Jansen`, `Mauntz-Kucherenko`, `Martinez`) use the :math:`E^i` matrix to compute the indices (first order and total order). This matrix is defined as follows:

    .. math::

       E^i = \\left(
       \\begin{array}{ccccc}
       a_{1,1} & a_{1,2} & b_{1,i} & \\cdots & a_{1, n_X} \\\\
       a_{2,1} & a_{2,2} & b_{2,i} & \\cdots & a_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       a_{n,1} & a_{1,2} & b_{n,i} & \\cdots & a_{n, n_X}
       \\end{array}
       \\right)

    The formulas for the evaluation of the indices are given in each class documentation:
      - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
      - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
      - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
      - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method

    For multivariate outputs, aggregate indices can be computed thanks to the `getAggregatedFirstOrderIndices` and `getAggregatedTotalOrderIndices`. Such indices write as follow:


    .. math::

       \\begin{array}{ccc}
        S_i & = & \\frac{ \\sum_{k=1}^{q} V_{i}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }  \\\\
        S_{i,j} & = & \\frac{ \\sum_{k=1}^{q} V_{i,j}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }  \\\\
        ST_i & = & \\frac{ \\sum_{k=1}^{q} VT_{i}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }
       \\end{array}

    Aggregated second order indices have not been implemented.

    |

    Note finally that evaluation of intervals for indices might be done for first and total order thanks to
    the `getFirstOrderIndicesInterval` and `getTotalOrderIndicesInterval` methods. Default bootstrap size 
    and confidence level values are parametrized thanks to the resource map keys `SobolIndicesAlgorithm-BootstrapSize`
    and `SobolIndicesAlgorithm-BootstrapConfidenceLevel`. Appropriate setters
    might be called to change their values.

    Also note that for numerical stability reasons the ouputs are centered before indices estimation:

    .. math::

        Y_k = Y_k - \\Eset(Y_k)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SobolIndicesAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SobolIndicesAlgorithmImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        """
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing first order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        """
        Get interval for the merged first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        """
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        """
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing total order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        """
        Get interval for the merged total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        """
        Get the evaluation of merged first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing merged first order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        """
        Get the evaluation of merged total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing merged total order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        """
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, *args):
        """
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_setBootstrapSize(self, *args)

    def getBootstrapConfidenceLevel(self):
        """
        Get the confidence interval level for bootstrap sampling.

        Returns
        -------
        confidenceLevel : float
            Confidence level for boostrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_getBootstrapConfidenceLevel(self)

    def setBootstrapConfidenceLevel(self, *args):
        """
        Set the confidence interval level for bootstrap sampling.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for boostrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_setBootstrapConfidenceLevel(self, *args)

    def __repr__(self): return _uncertainty.SobolIndicesAlgorithmImplementation___repr__(self)
    def __str__(self, offset=""): return _uncertainty.SobolIndicesAlgorithmImplementation___str__(self, offset)
    def Generate(*args):
        """
        Generate the input design of experiment.

        Usage:

          SobolIndicesAlgorithmImplementation.Generate(*distribution, N, computeSecondOrder*)

          SobolIndicesAlgorithmImplementation.Generate(*experiment, computeSecondOrder*)

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Input probabilistic model.
            Should have independent copula
        experiment : :class:`~openturns.WeightedExperiment`
            Experiment for the generation of two independent samples.
        N : int
            Size of samples to generate
        computeSecondOrder : bool
            If True, design that will be generated contains elements for the evaluation
            of second order indices.

        Returns
        -------
        inputDesign : :class:`~openturns.NumericalSample`
            Full input design.

        Notes
        -----
        Sensitivity algorithms rely on the definition of specific designs. The method generates design for the Saltelli method. Such designs could be used for both the Jansen, Martinez and MauntzKucherenko methods.
        This precomputes such input designs using distribution or experiment by generating two independent samples and mixing columns of these ones to define the huge sample (design).
        If computeSecondOrder is disabled, result design is of size :math:`N*(p+2)` where p is the input dimension.
        If computeSecondOrder is enabled, design's size is :math:`N*(2p+2)`.

        Model's answer could be evaluated outside the platform.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
        ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
        >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
        >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
        ...                                         ot.IndependentCopula(3))
        >>> size = 100
        >>> design = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)

        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_Generate(*args)

    if _newclass:Generate = staticmethod(Generate)
    __swig_getmethods__["Generate"] = lambda x: Generate
    def DrawImportanceFactors(*args):
        """
        Draw the importance factors.

        :Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.NumericalPointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

    if _newclass:DrawImportanceFactors = staticmethod(DrawImportanceFactors)
    __swig_getmethods__["DrawImportanceFactors"] = lambda x: DrawImportanceFactors
    def draw(self, *args):
        """
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementation_draw(self, *args)

    def __init__(self, *args): 
        this = _uncertainty.new_SobolIndicesAlgorithmImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_SobolIndicesAlgorithmImplementation
    __del__ = lambda self : None;
SobolIndicesAlgorithmImplementation_swigregister = _uncertainty.SobolIndicesAlgorithmImplementation_swigregister
SobolIndicesAlgorithmImplementation_swigregister(SobolIndicesAlgorithmImplementation)

def SobolIndicesAlgorithmImplementation_Generate(*args):
  """
    Generate the input design of experiment.

    Usage:

      SobolIndicesAlgorithmImplementation.Generate(*distribution, N, computeSecondOrder*)

      SobolIndicesAlgorithmImplementation.Generate(*experiment, computeSecondOrder*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Returns
    -------
    inputDesign : :class:`~openturns.NumericalSample`
        Full input design.

    Notes
    -----
    Sensitivity algorithms rely on the definition of specific designs. The method generates design for the Saltelli method. Such designs could be used for both the Jansen, Martinez and MauntzKucherenko methods.
    This precomputes such input designs using distribution or experiment by generating two independent samples and mixing columns of these ones to define the huge sample (design).
    If computeSecondOrder is disabled, result design is of size :math:`N*(p+2)` where p is the input dimension.
    If computeSecondOrder is enabled, design's size is :math:`N*(2p+2)`.

    Model's answer could be evaluated outside the platform.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
    ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
    ...                                         ot.IndependentCopula(3))
    >>> size = 100
    >>> design = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)

    """
  return _uncertainty.SobolIndicesAlgorithmImplementation_Generate(*args)

def SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args):
  """
    Draw the importance factors.

    :Available usages:
        DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

        DrawImportanceFactors(*values, names, title='Importance Factors'*)

    Parameters
    ----------
    importanceFactors : :class:`~openturns.NumericalPointWithDescription`
        Sequence containing the importance factors with a description for each
        component. The descriptions are used to build labels for the created Pie.
        If they are not mentioned, default labels will be used.
    values : sequence of float
        Importance factors.
    names : sequence of str
        Variables' names used to build labels for the created Pie.
    title : str
        Title of the graph.

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        A graph containing a :class:`~openturns.Pie` of the importance factors of
        the variables.
    """
  return _uncertainty.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

class SobolIndicesAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SobolIndicesAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SobolIndicesAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _uncertainty.new_SobolIndicesAlgorithmImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _uncertainty.SobolIndicesAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _uncertainty.SobolIndicesAlgorithmImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _uncertainty.delete_SobolIndicesAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister = _uncertainty.SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister
SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister(SobolIndicesAlgorithmImplementationTypedInterfaceObject)

class SobolIndicesAlgorithm(SobolIndicesAlgorithmImplementationTypedInterfaceObject):
    """
    Sensitivity analysis.

    Notes
    -----
    This method is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty.

    Here we attempt to evaluate the part of variance of :math:`Y^k` due to the different components :math:`X^i`.

    We denote G the physical model such as :math:`\\vect{Y}=G(\\vect{X})`. Let us consider first the case where :math:`\\vect{Y}` is of dimension 1.

    The objective here is to develop the variability of the random variable :math:`\\vect{Y}` as function of :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)`. Using the Hoeffding decomposition, we got:

    .. math::

       \\Var{\\vect{Y}} = \\sum_{i=1}^{n_X} V_i + \\sum_{i<j} V_{i,j} + \\sum_{i<k<j} V_{i,j,k} + \\cdots + V_{1,2,..,n_X}

    where :

    :math:`V_i = \\Var{\\Expect{ Y \\vert X_i}}` and :math:`V_{i,j} = \\Var{\\Expect{ Y \\vert X_i, X_j}} - V_i - V_j`. Using the previous decomposition, it follows that sensitivity indices are defined as follow:


    .. math::

       \\begin{array}{ccc}
        S_i & = & \\frac{V_i}{\\Var{\\vect{Y}}} \\\\
        S_{i,j} & = & \\frac{V_{i,j}}{\\Var{\\vect{Y}}}
       \\end{array}

    :math:`(S_i)` are the first order sensitivity indices and measure the impact of :math:`X_i` in the variance :math:`\\Var{\\vect{Y}}`,
    :math:`(S_{i,j})` are the second order sensitivity indices and measure the impact of the interaction of :math:`X_i` and :math:`X_j` in the variance :math:`\\Var{\\vect{Y}}`.

    When :math:`n_X >> 1`, we use total sensitivity indices :math:`ST_i`, which is defined as the sum of all indices that count the i-th variable:

    .. math::

        ST_i =  1 - \\frac{V_{-i}}{\\Var{\\vect{Y}}} = \\frac{VT_i}{\\Var{\\vect{Y}}}, \\forall\\ i\\in(1,2,...,n_X)

    where :math:`V_{-i}` is the part of variance of :math:`\\Var{\\vect{Y}}` that do not countain the i-th variable.

    |

    In practice, to estimate these quantities, Sobol proposes to use numerical methods that rely on the two independent realizations of the random vector :math:`\\vect{X}`.
    If we consider `A` and `B` two independent samples (of size `n`) of the previous random vector:

    .. math::

       A = \\left(
       \\begin{array}{cccc}
       a_{1,1} & a_{1,2} & \\cdots & a_{1, n_X} \\\\
       a_{2,1} & a_{2,2} & \\cdots & a_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       a_{n,1} & a_{1,2} & \\cdots & a_{n, n_X}
       \\end{array}
       \\right), \\  B = \\left(
       \\begin{array}{cccc}
       b_{1,1} & b_{1,2} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\vdots \\\\
       b_{n,1} & b_{1,2} & \\cdots & b_{n, n_X}
       \\end{array}
       \\right)


    Each line is a realization of the random vector. The purpose is to mix these two samples to get an estimate of the sensitivities.

    `Sobol` method require respectively :math:`C^i` and :math:`D^{i,j}` sample designs for the evaluation of first order (respectively second order) sensitivity indices. These are defined as hereafter:

    .. math::

       C^i = \\left(
       \\begin{array}{ccccc}
       b_{1,1} & b_{1,2} & a_{1,i} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & a_{2,i} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       b_{n,1} & b_{1,2} & a_{n,i} & \\cdots & b_{n, n_X}
       \\end{array}
       \\right), \\ D^{i,j} = \\left(
       \\begin{array}{ccccccc}
       b_{1,1} & b_{1,2} & a_{1,i} & \\cdots & a_{1,j} & \\cdots & b_{1, n_X} \\\\
       b_{2,1} & b_{2,2} & a_{2,i} & \\cdots & a_{2,j} & \\cdots & b_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\vdots & \\vdots  & \\ddots & \\vdots \\\\
       b_{n,1} & b_{n,2} & a_{n,i} & \\cdots & a_{n,j} & \\cdots & b_{n, n_X} \\\\
       \\end{array}
       \\right)

    It follows that :math:`V_{i}` and :math:`V_{i,j}` terms are defined as follow:

    .. math::

       \\begin{array}{ccc}
        V_i & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k) G(C_k) - V_i - V_j - G_0^2 \\\\
        V_{i,j} & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k) G(D_k) - G_0^2 \\\\
        G_0 & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k)
       \\end{array}

    The implemented second order indices use this formula.

    The major methods (`Saltelli`, `Jansen`, `Mauntz-Kucherenko`, `Martinez`) use the :math:`E^i` matrix to compute the indices (first order and total order). This matrix is defined as follows:

    .. math::

       E^i = \\left(
       \\begin{array}{ccccc}
       a_{1,1} & a_{1,2} & b_{1,i} & \\cdots & a_{1, n_X} \\\\
       a_{2,1} & a_{2,2} & b_{2,i} & \\cdots & a_{2, n_X} \\\\
       \\vdots  & \\vdots  & \\vdots  & \\ddots  & \\vdots \\\\
       a_{n,1} & a_{1,2} & b_{n,i} & \\cdots & a_{n, n_X}
       \\end{array}
       \\right)

    The formulas for the evaluation of the indices are given in each class documentation:
      - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
      - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
      - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
      - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method

    For multivariate outputs, aggregate indices can be computed thanks to the `getAggregatedFirstOrderIndices` and `getAggregatedTotalOrderIndices`. Such indices write as follow:


    .. math::

       \\begin{array}{ccc}
        S_i & = & \\frac{ \\sum_{k=1}^{q} V_{i}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }  \\\\
        S_{i,j} & = & \\frac{ \\sum_{k=1}^{q} V_{i,j}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }  \\\\
        ST_i & = & \\frac{ \\sum_{k=1}^{q} VT_{i}^{(k)} }{ \\sum_{k=1}^{q} \\Var{Y_k} }
       \\end{array}

    Aggregated second order indices have not been implemented.

    |

    Note finally that evaluation of intervals for indices might be done for first and total order thanks to
    the `getFirstOrderIndicesInterval` and `getTotalOrderIndicesInterval` methods. Default bootstrap size 
    and confidence level values are parametrized thanks to the resource map keys `SobolIndicesAlgorithm-BootstrapSize`
    and `SobolIndicesAlgorithm-BootstrapConfidenceLevel`. Appropriate setters
    might be called to change their values.

    Also note that for numerical stability reasons the ouputs are centered before indices estimation:

    .. math::

        Y_k = Y_k - \\Eset(Y_k)

    """
    __swig_setmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SobolIndicesAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SobolIndicesAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.SobolIndicesAlgorithm_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        """
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing first order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        """
        Get interval for the merged first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
        """
        return _uncertainty.SobolIndicesAlgorithm_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        """
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        """
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing total order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        """
        Get interval for the merged total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
        """
        return _uncertainty.SobolIndicesAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        """
        Get the evaluation of merged first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing merged first order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithm_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        """
        Get the evaluation of merged total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.NumericalPoint`
            Sequence containing merged total order Sobol indices.
        """
        return _uncertainty.SobolIndicesAlgorithm_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        """
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithm_getBootstrapSize(self)

    def setBootstrapSize(self, *args):
        """
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithm_setBootstrapSize(self, *args)

    def getBootstrapConfidenceLevel(self):
        """
        Get the confidence interval level for bootstrap sampling.

        Returns
        -------
        confidenceLevel : float
            Confidence level for boostrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithm_getBootstrapConfidenceLevel(self)

    def setBootstrapConfidenceLevel(self, *args):
        """
        Set the confidence interval level for bootstrap sampling.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for boostrap sampling
        """
        return _uncertainty.SobolIndicesAlgorithm_setBootstrapConfidenceLevel(self, *args)

    def draw(self, *args):
        """
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _uncertainty.SobolIndicesAlgorithm_draw(self, *args)

    def __repr__(self): return _uncertainty.SobolIndicesAlgorithm___repr__(self)
    def __str__(self, offset=""): return _uncertainty.SobolIndicesAlgorithm___str__(self, offset)
    def __init__(self, *args): 
        this = _uncertainty.new_SobolIndicesAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_SobolIndicesAlgorithm
    __del__ = lambda self : None;
SobolIndicesAlgorithm_swigregister = _uncertainty.SobolIndicesAlgorithm_swigregister
SobolIndicesAlgorithm_swigregister(SobolIndicesAlgorithm)

class MartinezSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    """
    Sensitivity analysis using Martinez method

    Available constructors:
        MartinezSensitivityAlgorithm(*inputDesign, outputDesign, N, computeSecondOrder*)

        MartinezSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)
        
        MartinezSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a NumericalMathFunction (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [Martinez2011]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \\begin{array}{ccc}
       \\hat{S_i} & = & \\rho_n(G(B), G(E^i)) \\\\
       \\hat{ST_i} & = & 1 - \\rho_n(G(A), G(E^i)) \\\\
       \\end{array}

    where :math:`\\rho_n` is the empirical correlation defined by:

    .. math::

       \\rho_n(X, Y) = \\frac{\\Cov{X,Y}}{\\sqrt{\\Var{X} \\Var{Y}}}

    The class provides also the evaluation of asymptotic confidence interval for first
    and total order indices, relying on the Fisher transformation.

    This could be performed for gaussian output data. The
    `MartinezSensitivityAlgorithm-UseAsmpytoticInterval` resource map key should
    be fixed to True in that case.

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
    ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
    ...                                         ot.IndependentCopula(3))
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.30449,0.448506,-0.0711394]
    """
    __swig_setmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MartinezSensitivityAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MartinezSensitivityAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.MartinezSensitivityAlgorithm_getClassName(self)

    def __repr__(self): return _uncertainty.MartinezSensitivityAlgorithm___repr__(self)
    def getFirstOrderIndicesInterval(self):
        """
        Get interval for the merged first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
        """
        return _uncertainty.MartinezSensitivityAlgorithm_getFirstOrderIndicesInterval(self)

    def getTotalOrderIndicesInterval(self):
        """
        Get interval for the merged total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
        """
        return _uncertainty.MartinezSensitivityAlgorithm_getTotalOrderIndicesInterval(self)

    def __init__(self, *args): 
        this = _uncertainty.new_MartinezSensitivityAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_MartinezSensitivityAlgorithm
    __del__ = lambda self : None;
MartinezSensitivityAlgorithm_swigregister = _uncertainty.MartinezSensitivityAlgorithm_swigregister
MartinezSensitivityAlgorithm_swigregister(MartinezSensitivityAlgorithm)

class SaltelliSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    """
    Sensitivity analysis using Saltelli method.

    Available constructors:
        SaltelliSensitivityAlgorithm(*inputDesign, outputDesign, N, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a NumericalMathFunction (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [Saltelli2002]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \\begin{array}{ccc}
       \\hat{V_i} & = & \\frac{1}{n}\\sum_{k=1}^{n} G(B_k)  G(E_k) - G_0^2 \\\\
       \\hat{V_{-i}} & = & \\frac{1}{n}\\sum_{k=1}^{n} G(A_k)  G(E_k) - G_0^2
       \\end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
    ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
    ...                                         ot.IndependentCopula(3))
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.SaltelliSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.182857,0.357745,-0.128457]
    """
    __swig_setmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SaltelliSensitivityAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SaltelliSensitivityAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.SaltelliSensitivityAlgorithm_getClassName(self)

    def __repr__(self): return _uncertainty.SaltelliSensitivityAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _uncertainty.new_SaltelliSensitivityAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_SaltelliSensitivityAlgorithm
    __del__ = lambda self : None;
SaltelliSensitivityAlgorithm_swigregister = _uncertainty.SaltelliSensitivityAlgorithm_swigregister
SaltelliSensitivityAlgorithm_swigregister(SaltelliSensitivityAlgorithm)

class JansenSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    """
    Sensitivity analysis using Jansen method.

    Available constructors:
        JansenSensitivityAlgorithm(*inputDesign, outputDesign, N, computeSecondOrder*)

        JansenSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        JansenSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a NumericalMathFunction (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [Jansen1999]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \\begin{array}{ccc}
       \\hat{V_i} & = & \\frac{1}{n} \\sum_{k=1}^{n} \\left(G(A_k)^2 - G_0^2\\right) - \\frac{1}{2n} \\sum_{k=1}^{n} \\left( G(E_k) - G(B_k) \\right)^2 \\\\
       \\hat{VT_{i}} & = & \\frac{1}{n} \\sum_{k=1}^{n} \\left( G(A_k) -  G(E_k) \\right)^2
       \\end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
    ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
    ...                                         ot.IndependentCopula(3))
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.JansenSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.403551,0.487879,0.140996]
    """
    __swig_setmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JansenSensitivityAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, JansenSensitivityAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.JansenSensitivityAlgorithm_getClassName(self)

    def __repr__(self): return _uncertainty.JansenSensitivityAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _uncertainty.new_JansenSensitivityAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_JansenSensitivityAlgorithm
    __del__ = lambda self : None;
JansenSensitivityAlgorithm_swigregister = _uncertainty.JansenSensitivityAlgorithm_swigregister
JansenSensitivityAlgorithm_swigregister(JansenSensitivityAlgorithm)

class MauntzKucherenkoSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    """
    Sensitivity analysis using MauntzKucherenko method.

    Available constructors:
        MauntzKucherenkoSensitivityAlgorithm(*inputDesign, outputDesign, N, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.NumericalSample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a NumericalMathFunction (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\\vect{X} = \\left( X^1, \\ldots, X^{n_X} \\right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [Sobol2007]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \\begin{array}{ccc}
       \\hat{V_i} & = & \\frac{1}{n} \\sum_{k=1}^{n} G(B_k) \\left( G(E_k) - G(A_k) \\right) \\\\
       \\hat{VT_{i}} & = & \\frac{1}{n} \\sum_{k=1}^{n} G(A_k) \\left( G(A_k) -  G(E_k) \\right)
       \\end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(_pi*X1)+7*sin(_pi*X2)*sin(_pi*X2)+' + \\
    ...    '0.1*((_pi*X3)*(_pi*X3)*(_pi*X3)*(_pi*X3))*sin(_pi*X1)']
    >>> model = ot.NumericalMathFunction(['X1', 'X2', 'X3'], ['Y'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3, \\
    ...                                         ot.IndependentCopula(3))
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesAlgorithmImplementation.Generate(distribution, size, True)
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.182219,0.357106,-0.129096]
    """
    __swig_setmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MauntzKucherenkoSensitivityAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [SobolIndicesAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MauntzKucherenkoSensitivityAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.MauntzKucherenkoSensitivityAlgorithm_getClassName(self)

    def __repr__(self): return _uncertainty.MauntzKucherenkoSensitivityAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _uncertainty.new_MauntzKucherenkoSensitivityAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _uncertainty.delete_MauntzKucherenkoSensitivityAlgorithm
    __del__ = lambda self : None;
MauntzKucherenkoSensitivityAlgorithm_swigregister = _uncertainty.MauntzKucherenkoSensitivityAlgorithm_swigregister
MauntzKucherenkoSensitivityAlgorithm_swigregister(MauntzKucherenkoSensitivityAlgorithm)

import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
# This file is compatible with both classic and new-style classes.


