# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Solvers.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_solver', [dirname(__file__)])
        except ImportError:
            import _solver
            return _solver
        if fp is not None:
            try:
                _mod = imp.load_module('_solver', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _solver = swig_import_helper()
    del swig_import_helper
else:
    import _solver
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _solver.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _solver.SwigPyIterator_value(self)
    def incr(self, n=1): return _solver.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _solver.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _solver.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _solver.SwigPyIterator_equal(self, *args)
    def copy(self): return _solver.SwigPyIterator_copy(self)
    def next(self): return _solver.SwigPyIterator_next(self)
    def __next__(self): return _solver.SwigPyIterator___next__(self)
    def previous(self): return _solver.SwigPyIterator_previous(self)
    def advance(self, *args): return _solver.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _solver.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _solver.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _solver.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _solver.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _solver.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _solver.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _solver.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _solver.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
class SolverImplementation(openturns.common.PersistentObject):
    """
    SolverImplementation of 1D non linear equations.

    Available constructor:
        SolverImplementation()

        SolverImplementation(*solverImplementation*)

        SolverImplementation(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    solverImplementation : SolverImplementationImplementation
        The implementation of a particular solver which is :class:`~openturns.Bisection`,
        :class:`~openturns.Brent` or :class:`~openturns.Secant`.   
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Bisection, Brent, Secant

    Notes
    -----
    This class enables to solve 1D non linear equations :

    .. math::

        f(x) = value, \\forall x \\in [infPoint, supPoint]

    if :math:`f` is a continuous function from :math:`\\Rset` to :math:`\\Rset`,
    :math:`infPoint, supPoint \\in \\Rset` and if :math:`f` is such that
    :math:`f(infPoint) \\times f(supPoint) < 0`, then :math:`f` has at least a zero
    in the interval :math:`[infPoint, supPoint]`. In particular, it is used in the
    root research of a 
    :class:`Directional Sampling simulation <openturns.DirectionalSampling>`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.SolverImplementation_getClassName(self)

    def __eq__(self, *args): return _solver.SolverImplementation___eq__(self, *args)
    def __repr__(self): return _solver.SolverImplementation___repr__(self)
    def solve(self, *args): return _solver.SolverImplementation_solve(self, *args)
    def setAbsoluteError(self, *args):
        """
        Accessor to the absolute error.

        Parameters
        ----------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.SolverImplementation_setAbsoluteError(self, *args)

    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.SolverImplementation_getAbsoluteError(self)

    def setRelativeError(self, *args):
        """
        Accessor to the relative error.

        Parameters
        ----------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.SolverImplementation_setRelativeError(self, *args)

    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.SolverImplementation_getRelativeError(self)

    def setResidualError(self, *args):
        """
        Accessor to the residual error.

        Parameters
        ----------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.SolverImplementation_setResidualError(self, *args)

    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.SolverImplementation_getResidualError(self)

    def setMaximumFunctionEvaluation(self, *args):
        """
        Accessor to the maximum number of evaluations of the function.

        Parameters
        ----------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.SolverImplementation_setMaximumFunctionEvaluation(self, *args)

    def getMaximumFunctionEvaluation(self):
        """
        Accessor to the maximum number of evaluations of the function.

        Returns
        -------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.SolverImplementation_getMaximumFunctionEvaluation(self)

    def getUsedFunctionEvaluation(self):
        """
        Accessor to the number of evaluations of the function.

        Returns
        -------
        nEval : int
            The number of evaluations of the function.
        """
        return _solver.SolverImplementation_getUsedFunctionEvaluation(self)

    def __init__(self, *args): 
        this = _solver.new_SolverImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_SolverImplementation
    __del__ = lambda self : None;
SolverImplementation_swigregister = _solver.SolverImplementation_swigregister
SolverImplementation_swigregister(SolverImplementation)

class SolverImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SolverImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _solver.new_SolverImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _solver.SolverImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _solver.SolverImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _solver.SolverImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _solver.SolverImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _solver.delete_SolverImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SolverImplementationTypedInterfaceObject_swigregister = _solver.SolverImplementationTypedInterfaceObject_swigregister
SolverImplementationTypedInterfaceObject_swigregister(SolverImplementationTypedInterfaceObject)

class Solver(SolverImplementationTypedInterfaceObject):
    """
    SolverImplementation of 1D non linear equations.

    Available constructor:
        SolverImplementation()

        SolverImplementation(*solverImplementation*)

        SolverImplementation(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    solverImplementation : SolverImplementationImplementation
        The implementation of a particular solver which is :class:`~openturns.Bisection`,
        :class:`~openturns.Brent` or :class:`~openturns.Secant`.   
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Bisection, Brent, Secant

    Notes
    -----
    This class enables to solve 1D non linear equations :

    .. math::

        f(x) = value, \\forall x \\in [infPoint, supPoint]

    if :math:`f` is a continuous function from :math:`\\Rset` to :math:`\\Rset`,
    :math:`infPoint, supPoint \\in \\Rset` and if :math:`f` is such that
    :math:`f(infPoint) \\times f(supPoint) < 0`, then :math:`f` has at least a zero
    in the interval :math:`[infPoint, supPoint]`. In particular, it is used in the
    root research of a 
    :class:`Directional Sampling simulation <openturns.DirectionalSampling>`.
    """
    __swig_setmethods__ = {}
    for _s in [SolverImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Solver, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Solver, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Solver_getClassName(self)

    def __eq__(self, *args): return _solver.Solver___eq__(self, *args)
    def __repr__(self): return _solver.Solver___repr__(self)
    def solve(self, *args): return _solver.Solver_solve(self, *args)
    def setAbsoluteError(self, *args):
        """
        Accessor to the absolute error.

        Parameters
        ----------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.Solver_setAbsoluteError(self, *args)

    def getAbsoluteError(self):
        """
        Accessor to the absolute error.

        Returns
        -------
        absError : float
            The absolute error: distance between two successive iterates at the end point.
        """
        return _solver.Solver_getAbsoluteError(self)

    def setRelativeError(self, *args):
        """
        Accessor to the relative error.

        Parameters
        ----------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.Solver_setRelativeError(self, *args)

    def getRelativeError(self):
        """
        Accessor to the relative error.

        Returns
        -------
        relError : float
            The relative error: distance between the two last successive iterates with
            regards to the last iterate.
        """
        return _solver.Solver_getRelativeError(self)

    def setResidualError(self, *args):
        """
        Accessor to the residual error.

        Parameters
        ----------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.Solver_setResidualError(self, *args)

    def getResidualError(self):
        """
        Accessor to the residual error.

        Returns
        -------
        resError : float
            The residual errors: difference between the last iterate value and the
            expected value.
        """
        return _solver.Solver_getResidualError(self)

    def setMaximumFunctionEvaluation(self, *args):
        """
        Accessor to the maximum number of evaluations of the function.

        Parameters
        ----------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.Solver_setMaximumFunctionEvaluation(self, *args)

    def getMaximumFunctionEvaluation(self):
        """
        Accessor to the maximum number of evaluations of the function.

        Returns
        -------
        maxEval : int
            The maximum number of evaluations of the function.
        """
        return _solver.Solver_getMaximumFunctionEvaluation(self)

    def getUsedFunctionEvaluation(self):
        """
        Accessor to the number of evaluations of the function.

        Returns
        -------
        nEval : int
            The number of evaluations of the function.
        """
        return _solver.Solver_getUsedFunctionEvaluation(self)

    def __init__(self, *args): 
        this = _solver.new_Solver(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_Solver
    __del__ = lambda self : None;
Solver_swigregister = _solver.Solver_swigregister
Solver_swigregister(Solver)

class Bisection(SolverImplementation):
    """
    Bisection algorithm solver for 1D non linear equations.

    Available constructor:
        Bisection()

        Bisection(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Brent, Secant
    """
    __swig_setmethods__ = {}
    for _s in [SolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Bisection, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Bisection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Bisection_getClassName(self)

    def __repr__(self): return _solver.Bisection___repr__(self)
    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        If the function :math:`f` is continuous, the Bisection solver will converge
        towards a root of the equation :math:`function(x) = value` in
        :math:`[infPoint, supPoint]`. If not, it will converge towards either a root or
        a discontinuity point of :math:`f` on :math:`[infPoint, supPoint]`. Bisection
        guarantees a convergence.

        """
        return _solver.Bisection_solve(self, *args)

    def __init__(self, *args): 
        this = _solver.new_Bisection(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_Bisection
    __del__ = lambda self : None;
Bisection_swigregister = _solver.Bisection_swigregister
Bisection_swigregister(Bisection)

class Secant(SolverImplementation):
    """
    Secant algorithm solver for 1D non linear equations.

    Available constructor:
        Secant()

        Secant(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Bisection, Brent

    Notes
    -----
    The Secant solver is based on the evaluation of a segment between the two last
    iterated points.
    """
    __swig_setmethods__ = {}
    for _s in [SolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Secant, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Secant, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Secant_getClassName(self)

    def __repr__(self): return _solver.Secant___repr__(self)
    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        The Secant solver is based on the evaluation of a segment between the two last
        iterated points. Secant might fail and not converge.
        """
        return _solver.Secant_solve(self, *args)

    def __init__(self, *args): 
        this = _solver.new_Secant(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_Secant
    __del__ = lambda self : None;
Secant_swigregister = _solver.Secant_swigregister
Secant_swigregister(Secant)

class Brent(SolverImplementation):
    """
    Brent algorithm solver for 1D non linear equations.

    Available constructor:
        Brent()

        Brent(*absError, relError, resError, maximumFunctionEvaluation*)

    Parameters
    ----------
    absError : positive float
        Absolute error: distance between two successive iterates at the end point.
        Default is :math:`10^{-5}`.
    relError : positive float
        Relative error: distance between the two last successive iterates with
        regards to the last iterate. Default is :math:`10^{-5}`.
    resError : positive float
        Residual error: difference between the last iterate value and the expected
        value. Default is :math:`10^{-8}`.
    maximumFunctionEvaluation : int
        The maximum number of evaluations of the function. Default is :math:`100`.

    See also
    --------
    Solver, Bisection, Secant

    Notes
    -----
    The Brent solver is a mix of Bisection, Secant and inverse quadratic
    interpolation.
    """
    __swig_setmethods__ = {}
    for _s in [SolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Brent, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Brent, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.Brent_getClassName(self)

    def __repr__(self): return _solver.Brent___repr__(self)
    def solve(self, *args):
        """
        Solve an equation.

        **Available usages**:

            solve(*function, value, infPoint, supPoint*)

            solve(*function, value, infPoint, supPoint, infValue, supValue*)

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            The function of the equation :math:`function(x) = value` to be solved in the
            interval :math:`[infPoint, supPoint]`.
        value : float
            The value of which the function must be equal.
        infPoint : float
            Lower bound of the interval definition of the variable :math:`x`.
        supPoint : float
            Upper bound of the interval definition of the variable :math:`x`.
        infValue : float
            The value such that :math:`infValue = function(infPoint)`. It must be of 
            opposite sign of :math:`supValue`.
        supValue : float
            The value such that :math:`supValue = function(supPoint)`. It must be of 
            opposite sign of :math:`infValue`.

        Returns
        -------
        result : float
            The result of the root research.

        Notes
        -----
        If the function :math:`f` is continuous, the Brent solver will
        converge towards a root of the equation :math:`function(x) = value` in
        :math:`[infPoint, supPoint]`. If not, it will converge towards either a root or
        a discontinuity point of :math:`f` on :math:`[infPoint, supPoint]`. Bisection
        guarantees a convergence.
        """
        return _solver.Brent_solve(self, *args)

    def __init__(self, *args): 
        this = _solver.new_Brent(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_Brent
    __del__ = lambda self : None;
Brent_swigregister = _solver.Brent_swigregister
Brent_swigregister(Brent)

class ODESolverImplementation(openturns.common.PersistentObject):
    """Proxy of C++ OT::ODESolverImplementation"""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolverImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolverImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.ODESolverImplementation_getClassName(self)

    def __repr__(self): return _solver.ODESolverImplementation___repr__(self)
    def solve(self, *args): return _solver.ODESolverImplementation_solve(self, *args)
    def setTransitionFunction(self, *args): return _solver.ODESolverImplementation_setTransitionFunction(self, *args)
    def getTransitionFunction(self): return _solver.ODESolverImplementation_getTransitionFunction(self)
    def __init__(self, *args): 
        this = _solver.new_ODESolverImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_ODESolverImplementation
    __del__ = lambda self : None;
ODESolverImplementation_swigregister = _solver.ODESolverImplementation_swigregister
ODESolverImplementation_swigregister(ODESolverImplementation)

class ODESolverImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolverImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolverImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _solver.new_ODESolverImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _solver.ODESolverImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _solver.ODESolverImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _solver.delete_ODESolverImplementationTypedInterfaceObject
    __del__ = lambda self : None;
ODESolverImplementationTypedInterfaceObject_swigregister = _solver.ODESolverImplementationTypedInterfaceObject_swigregister
ODESolverImplementationTypedInterfaceObject_swigregister(ODESolverImplementationTypedInterfaceObject)

class ODESolver(ODESolverImplementationTypedInterfaceObject):
    """Proxy of C++ OT::ODESolver"""
    __swig_setmethods__ = {}
    for _s in [ODESolverImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ODESolver, name, value)
    __swig_getmethods__ = {}
    for _s in [ODESolverImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ODESolver, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.ODESolver_getClassName(self)

    def __repr__(self): return _solver.ODESolver___repr__(self)
    def __str__(self, offset=""): return _solver.ODESolver___str__(self, offset)
    def solve(self, *args): return _solver.ODESolver_solve(self, *args)
    def setTransitionFunction(self, *args): return _solver.ODESolver_setTransitionFunction(self, *args)
    def getTransitionFunction(self): return _solver.ODESolver_getTransitionFunction(self)
    def __init__(self, *args): 
        this = _solver.new_ODESolver(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_ODESolver
    __del__ = lambda self : None;
ODESolver_swigregister = _solver.ODESolver_swigregister
ODESolver_swigregister(ODESolver)

class RungeKutta(ODESolverImplementation):
    """Proxy of C++ OT::RungeKutta"""
    __swig_setmethods__ = {}
    for _s in [ODESolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RungeKutta, name, value)
    __swig_getmethods__ = {}
    for _s in [ODESolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RungeKutta, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _solver.RungeKutta_getClassName(self)

    def __repr__(self): return _solver.RungeKutta___repr__(self)
    def solve(self, *args): return _solver.RungeKutta_solve(self, *args)
    def __init__(self, *args): 
        this = _solver.new_RungeKutta(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _solver.delete_RungeKutta
    __del__ = lambda self : None;
RungeKutta_swigregister = _solver.RungeKutta_swigregister
RungeKutta_swigregister(RungeKutta)

# This file is compatible with both classic and new-style classes.


