# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Polynomial primitives.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_orthogonalbasis', [dirname(__file__)])
        except ImportError:
            import _orthogonalbasis
            return _orthogonalbasis
        if fp is not None:
            try:
                _mod = imp.load_module('_orthogonalbasis', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _orthogonalbasis = swig_import_helper()
    del swig_import_helper
else:
    import _orthogonalbasis
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _orthogonalbasis.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _orthogonalbasis.SwigPyIterator_value(self)
    def incr(self, n=1): return _orthogonalbasis.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _orthogonalbasis.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _orthogonalbasis.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _orthogonalbasis.SwigPyIterator_equal(self, *args)
    def copy(self): return _orthogonalbasis.SwigPyIterator_copy(self)
    def next(self): return _orthogonalbasis.SwigPyIterator_next(self)
    def __next__(self): return _orthogonalbasis.SwigPyIterator___next__(self)
    def previous(self): return _orthogonalbasis.SwigPyIterator_previous(self)
    def advance(self, *args): return _orthogonalbasis.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _orthogonalbasis.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _orthogonalbasis.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _orthogonalbasis.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _orthogonalbasis.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _orthogonalbasis.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _orthogonalbasis.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _orthogonalbasis.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _orthogonalbasis.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.model_copula
import openturns.weightedexperiment
class OrthogonalUniVariatePolynomial(openturns.func.UniVariatePolynomialImplementation):
    """
    Base class for orthogonal univariate polynomials.

    .. warning::

        Orthogonal univariate polynomials are not intended to be created manually.
        They should be constructed with the subclasses of
        :class:`~openturns.OrthogonalUniVariatePolynomialFamily` (like e.g.
        :class:`~openturns.HermiteFactory`). Constructor parameters are therefore
        intentionally not documented.

    See Also
    --------
    OrthogonalUniVariatePolynomialFamily

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> for i in range(3):
    ...     print(ot.OrthogonalUniVariatePolynomialFamily().build(i))
    1
    X
    -0.707107 + 0.707107 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.UniVariatePolynomialImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariatePolynomial, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.UniVariatePolynomialImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariatePolynomial, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getClassName(self)

    def __call__(self, *args): return _orthogonalbasis.OrthogonalUniVariatePolynomial___call__(self, *args)
    def getRecurrenceCoefficients(self):
        """
        Accessor to the recurrence coefficients.

        Returns
        -------
        recurrence_coefficients : list of :class:`NumericalPoint`
            The list of recurrence coefficients that defined the orthogonal univariate
            polynomial from the very first univariate orthogonal polynomial
            :math:`P_0`.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad i > 1

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial = ot.OrthogonalUniVariatePolynomialFamily().build(2)
        >>> print(polynomial.getRecurrenceCoefficients())
        [[1,0,0],[0.707107,0,-0.707107]]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getRecurrenceCoefficients(self)

    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomial_getRoots(self)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariatePolynomial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomial
    __del__ = lambda self : None;
OrthogonalUniVariatePolynomial_swigregister = _orthogonalbasis.OrthogonalUniVariatePolynomial_swigregister
OrthogonalUniVariatePolynomial_swigregister(OrthogonalUniVariatePolynomial)

class OrthogonalUniVariatePolynomialFactory(openturns.common.PersistentObject):
    """
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariatePolynomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariatePolynomialFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getClassName(self)

    ANALYSIS = _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_ANALYSIS
    PROBABILITY = _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_PROBABILITY
    def __repr__(self): return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory___repr__(self)
    def build(self, *args):
        """
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_build(self, *args)

    def buildRecurrenceCoefficientsCollection(self, *args):
        """
        Build the recurrence coefficients.

        Build the recurrence coefficients of the orthogonal univariate polynomial
        family up to the :math:`k`-th order.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Returns
        -------
        recurrence_coefficients : list of :class:`~openturns.NumericalPoint`
            All the tecurrence coefficients up to the requested order.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.buildRecurrenceCoefficientsCollection(2))
        [[1,0,0],[0.707107,0,-0.707107]]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_buildRecurrenceCoefficientsCollection(self, *args)

    def buildCoefficients(self, *args):
        """
        Build the :math:`k`-th order orthogonal univariate polynomial coefficients.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Returns
        -------
        coefficients : :class:`~openturns.NumericalPoint`
            Coefficients of the requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.buildCoefficients(2))
        [-0.707107,0,0.707107]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_buildCoefficients(self, *args)

    def getRoots(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.NumericalPoint`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getRoots(self, *args)

    def getNodesAndWeights(self, *args):
        """
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.NumericalPoint`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.NumericalPoint`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getNodesAndWeights(self, *args)

    def getMeasure(self):
        """
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \\di{x}` if and only if their dot product:

        .. math::

            \\langle P, Q \\rangle = \\int_{\\alpha}^{\\beta} P(x) Q(x) w(x)\\di{x}
                                 = 0

        where :math:`\\alpha \\in \\Rset \\cup \\{-\\infty\\}` and
        :math:`\\beta \\in \\Rset \\cup \\{+\\infty\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getMeasure(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_getRecurrenceCoefficients(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariatePolynomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFactory
    __del__ = lambda self : None;
OrthogonalUniVariatePolynomialFactory_swigregister = _orthogonalbasis.OrthogonalUniVariatePolynomialFactory_swigregister
OrthogonalUniVariatePolynomialFactory_swigregister(OrthogonalUniVariatePolynomialFactory)

class CharlierFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Charlier specific orthonormal univariate polynomial family.

    For :class:`~openturns.Poisson`'s distribution.

    Available constructors:
        CharlierFactory(*lambda=1.0*)

    Parameters
    ----------
    lambda : float, :math:`\\lambda > 0`
        Location parameter of :class:`~openturns.Poisson`'s distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Charlier polynomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle - \\frac{1}{\\sqrt{\\lambda (i + 1)}} \\\\
            b_i & = & \\displaystyle \\frac{i + \\lambda}{\\sqrt{\\lambda (i + 1)}} \\\\
            c_i & = & \\displaystyle - \\sqrt{1 - \\frac{1}{i + 1}}
        \\end{array}, \\quad 1 < i

    where :math:`\\lambda` is the location parameter of
    :class:`~openturns.Poisson`'s distribution.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.CharlierFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1 - X
    0.707107 - 2.12132 * X + 0.707107 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CharlierFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CharlierFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.CharlierFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.CharlierFactory_getRecurrenceCoefficients(self, *args)

    def getLambda(self):
        """
        Accessor to the location parameter of :class:`~openturns.Poisson`.

        Returns
        -------
        lambda : float
            Location parameter of :class:`~openturns.Poisson`'s distribution.
        """
        return _orthogonalbasis.CharlierFactory_getLambda(self)

    def __repr__(self): return _orthogonalbasis.CharlierFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_CharlierFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_CharlierFactory
    __del__ = lambda self : None;
CharlierFactory_swigregister = _orthogonalbasis.CharlierFactory_swigregister
CharlierFactory_swigregister(CharlierFactory)

class ChebychevFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Chebychev specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Arcsine` distribution.

    Available constructors:
        Chebychev()

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad i > 0

    The recurrence coefficients for the Chebychev polynomials come analytically and
    read :math:`a_0=\\sqrt{2}, b_0=0, c_0=0`, :math:`a_1=2, b_1=0,c_1=-\\sqrt{2}` and for :math:`i>1`, :math:`a_i=2, b_i=0, c_i=-1`.


    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.ChebychevFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1.41421 * X
    -1.41421 + 2.82843 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChebychevFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ChebychevFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.ChebychevFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.ChebychevFactory_getRecurrenceCoefficients(self, *args)

    def getRoots(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.NumericalPoint`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.ChebychevFactory_getRoots(self, *args)

    def getNodesAndWeights(self, *args):
        """
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.NumericalPoint`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.NumericalPoint`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.ChebychevFactory_getNodesAndWeights(self, *args)

    def __repr__(self): return _orthogonalbasis.ChebychevFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_ChebychevFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_ChebychevFactory
    __del__ = lambda self : None;
ChebychevFactory_swigregister = _orthogonalbasis.ChebychevFactory_swigregister
ChebychevFactory_swigregister(ChebychevFactory)

class HermiteFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Hermite specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Normal` distribution.

    Available constructor:
        HermiteFactory()

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Hermite polynomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle \\frac{1}{\\sqrt{i + 1}} \\\\
            b_i & = & 0 \\\\
            c_i & = & \\displaystyle - \\sqrt{\\frac{i}{i + 1}}
        \\end{array}, \\quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.HermiteFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    X
    -0.707107 + 0.707107 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HermiteFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HermiteFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HermiteFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.HermiteFactory_getRecurrenceCoefficients(self, *args)

    def __repr__(self): return _orthogonalbasis.HermiteFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_HermiteFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_HermiteFactory
    __del__ = lambda self : None;
HermiteFactory_swigregister = _orthogonalbasis.HermiteFactory_swigregister
HermiteFactory_swigregister(HermiteFactory)

class JacobiFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Jacobi specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Beta` distribution.

    Available constructors:
        Jacobi(*arg1=1.0, arg2=1.0, parameters_set=ot.JacobiFactory.ANALYSIS*)

    Parameters
    ----------
    arg1 : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`r > 0` of the :class:`~openturns.Beta` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`\\alpha = t - r - 1 > -1` of the :class:`~openturns.Beta`
        distribution.
    arg2 : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`t > r` of the :class:`~openturns.Beta` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`\\beta = r - 1` of the :class:`~openturns.Beta`
        distribution.
    parameters_set : int, optional
        Integer telling which parameters set is used for defining the distribution
        (amongst `ot.JacobiFactory.ANALYSIS, ot.JacobiFactory.PROBABILITY`).

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Jacobi polynomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle K_{2,i} (2 i + \\alpha + \\beta + 2) \\\\
            b_i & = & \\displaystyle K_{2,i} \\frac{(\\alpha - \\beta)(\\alpha + \\beta)}
                                                 {2 i + \\alpha + \\beta} \\\\
            c_i & = & \\displaystyle - \\frac{2 i + \\alpha + \\beta + 2}
                                           {2 i + \\alpha + \\beta}
                                    \\left[(i + \\alpha) (i + \\beta)
                                          (i + \\alpha + \\beta) i
                                          \\frac{K_{1,i}}
                                               {2 i + \\alpha + \\beta - 1}
                                          \\right]^{1/2}
        \\end{array}, \\quad 1 < i

    where :math:`\\alpha` and :math:`\\beta` are the alternative shape parameters
    of the :class:`~openturns.Beta` distribution, and:

    .. math::

        \\begin{array}{rcl}
            K_{1,i} & = & \\displaystyle \\frac{2 i + \\alpha + \\beta + 3}
                                             {(i + 1) (i + \\alpha + 1)
                                              (i + \\beta + 1)
                                              (i + \\alpha + \\beta + 1)} \\\\
            K_{2,i} & = & \\displaystyle \\frac{1}{2}
                                        \\sqrt{(2 i + \\alpha + \\beta + 1) K_{1,i}}
        \\end{array}, \\quad i > 1

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.JacobiFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    2.23607 * X
    -0.935414 + 4.67707 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JacobiFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, JacobiFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.JacobiFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.JacobiFactory_getRecurrenceCoefficients(self, *args)

    def getAlpha(self):
        """
        Accessor to the alternative shape parameter :math:`\\alpha`.

        Of the :class:`~openturns.Beta` distribution.

        Returns
        -------
        alpha : float
            Alternative shape parameter :math:`\\alpha = r - 1` of the
            :class:`~openturns.Beta` distribution.
        """
        return _orthogonalbasis.JacobiFactory_getAlpha(self)

    def getBeta(self):
        """
        Accessor to the alternative shape parameter :math:`\\beta`.

        Of the :class:`~openturns.Beta` distribution.

        Returns
        -------
        beta : float
            Alternative shape parameter :math:`\\beta = t - r - 1` of the
            :class:`~openturns.Beta` distribution.
        """
        return _orthogonalbasis.JacobiFactory_getBeta(self)

    def __repr__(self): return _orthogonalbasis.JacobiFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_JacobiFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_JacobiFactory
    __del__ = lambda self : None;
JacobiFactory_swigregister = _orthogonalbasis.JacobiFactory_swigregister
JacobiFactory_swigregister(JacobiFactory)

class KrawtchoukFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Krawtchouk specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Binomial` distribution.

    Available constructors:
        KrawtchoukFactory(*n=1, p=0.5*)

    Parameters
    ----------
    n : int, :math:`n > 0`
        Number of experiment parameter of the :class:`~openturns.Binomial`
        distribution.
    p : float, :math:`0 < p < 1`
        Success probability parameter of the :class:`~openturns.Binomial`
        distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i < n

    The recurrence coefficients for the Krawtchouk polynomials come analytically
    and read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle - \\frac{1}
                                           {\\sqrt{(i + 1) (n - i) p (1 - p)}} \\\\
            b_i & = & \\displaystyle \\frac{p (n - i) + i (1 - p)}
                                         {\\sqrt{(i + 1) (n - i) p (1 - p)}} \\\\
            c_i & = & \\displaystyle - \\sqrt{(1 - \\frac{1}{i + 1})
                                            (1 + \\frac{1}{n - i})}
        \\end{array}, \\quad 1 < i

    where :math:`n` and :math:`p` are the parameters of the
    :class:`~openturns.Binomial` distribution.

    .. warning::

        The Krawtchouk polynomials are only defined up to a degree :math:`m` equal
        to :math:`n - 1`. Indeed, for :math:`i = n`, some factors in the
        denominators of the recurrence coefficients would be equal to zero.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.KrawtchoukFactory(3, 0.5)
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1.73205 + 1.1547 * X
    1.73205 - 3.4641 * X + 1.1547 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KrawtchoukFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KrawtchoukFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.KrawtchoukFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.KrawtchoukFactory_getRecurrenceCoefficients(self, *args)

    def getN(self): return _orthogonalbasis.KrawtchoukFactory_getN(self)
    def getP(self): return _orthogonalbasis.KrawtchoukFactory_getP(self)
    def __repr__(self): return _orthogonalbasis.KrawtchoukFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_KrawtchoukFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_KrawtchoukFactory
    __del__ = lambda self : None;
KrawtchoukFactory_swigregister = _orthogonalbasis.KrawtchoukFactory_swigregister
KrawtchoukFactory_swigregister(KrawtchoukFactory)

class LaguerreFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Laguerre specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Gamma` distribution.

    Available constructors:
        LaguerreFactory(*k=1.0, ot.LaguerreFactory.ANALYSIS*)

    Parameters
    ----------
    k : float
        If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
        parameter :math:`k > 0` of the :class:`~openturns.Gamma` distribution.

        If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
        parameter :math:`k_a = k - 1 > -1` of the :class:`~openturns.Gamma`
        distribution.
    parameters_set : int, optional
        Integer telling which parameters set is used for defining the distribution
        (amongst `ot.LaguerreFactory.ANALYSIS, ot.LaguerreFactory.PROBABILITY`).

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Laguerre polynomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\omega_i \\\\
            b_i & = & - (2 i + k_a + 1) \\omega_i \\\\
            c_i & = & - \\sqrt{(i + k_a) i} \\omega_i
        \\end{array}, \\quad 1 < i

    where :math:`k_a` is the alternative shape parameter of the
    :class:`~openturns.Gamma` distribution, and:

    .. math::

        \\omega_i = \\frac{1}{\\sqrt{(i + 1) (i + k_a + 1)}} , \\quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.LaguerreFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LaguerreFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LaguerreFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.LaguerreFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.LaguerreFactory_getRecurrenceCoefficients(self, *args)

    def getK(self):
        """
        Accessor to the alternative shape parameter :math:`k_a`.

        Of the :class:`~openturns.Gamma` distribution.

        Returns
        -------
        k_a : float
            Alternative shape parameter :math:`k_a = k - 1` of the
            :class:`~openturns.Gamma` distribution.
        """
        return _orthogonalbasis.LaguerreFactory_getK(self)

    def __repr__(self): return _orthogonalbasis.LaguerreFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_LaguerreFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_LaguerreFactory
    __del__ = lambda self : None;
LaguerreFactory_swigregister = _orthogonalbasis.LaguerreFactory_swigregister
LaguerreFactory_swigregister(LaguerreFactory)

class LegendreFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Legendre specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Uniform` distribution.

    Available constructor:
        LegendreFactory()

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Legendre polynomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle \\frac{\\sqrt{(2 i + 1) (2 i + 3)}}
                                         {i + 1} \\\\
            b_i & = & 0 \\\\
            c_i & = & \\displaystyle - \\frac{i \\sqrt{2 i + 3}}
                                           {(i + 1) \\sqrt{2 i - 1}}
        \\end{array}, \\quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.LegendreFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    1.73205 * X
    -1.11803 + 3.3541 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LegendreFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LegendreFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.LegendreFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.LegendreFactory_getRecurrenceCoefficients(self, *args)

    def __repr__(self): return _orthogonalbasis.LegendreFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_LegendreFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_LegendreFactory
    __del__ = lambda self : None;
LegendreFactory_swigregister = _orthogonalbasis.LegendreFactory_swigregister
LegendreFactory_swigregister(LegendreFactory)

class HistogramPolynomialFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Histogram specific orthonormal univariate polynomial family.

    For the :class:`~openturns.Histogram` distribution.

    Available constructor:
        HistogramPolynomialFactory(*first, width, height*)

    Parameters
    ----------
    first : float
        Lower bound.
    width : positive sequence of float
        :math:`\\ell_i` is the width of the class :math:`i`.
    height : positive sequence of float
        :math:`h_i` is the frequency of the class :math:`i`.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the HistogramPolynomial polynomials are computed from the recurrence of the associated monic polynomials (see :class:`~openturns.AdaptiveStieltjesAlgorithm`) but with an exact evaluation of the dot-products.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.HistogramPolynomialFactory(1.0, [1.0, 2.0], [4.0, 2.0])
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -2.56273 + 1.13899 * X
    7.80593 - 7.42767 * X + 1.5268 * X^2

    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistogramPolynomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HistogramPolynomialFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.HistogramPolynomialFactory_getRecurrenceCoefficients(self, *args)

    def getFirst(self): return _orthogonalbasis.HistogramPolynomialFactory_getFirst(self)
    def getWidth(self): return _orthogonalbasis.HistogramPolynomialFactory_getWidth(self)
    def getHeight(self): return _orthogonalbasis.HistogramPolynomialFactory_getHeight(self)
    def __repr__(self): return _orthogonalbasis.HistogramPolynomialFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_HistogramPolynomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_HistogramPolynomialFactory
    __del__ = lambda self : None;
HistogramPolynomialFactory_swigregister = _orthogonalbasis.HistogramPolynomialFactory_swigregister
HistogramPolynomialFactory_swigregister(HistogramPolynomialFactory)

class MeixnerFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Meixner specific orthonormal univariate polynomial family.

    For the :class:`~openturns.NegativeBinomial` distribution.

    Available constructors:
        MeixnerFactory(*r=1.0, p=0.5*)

    Parameters
    ----------
    r : float, :math:`r > 0`
        Number of failures parameter of the :class:`~openturns.NegativeBinomial`
        distribution.
    p : float, :math:`0 < p < 1`
        Success probability parameter of the :class:`~openturns.NegativeBinomial`
        distribution.

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the Meixner polynomials come analytically
    and read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & \\displaystyle \\frac{p - 1}
                                         {\\sqrt{p (i + 1) (i + r)}} \\\\
            b_i & = & \\displaystyle \\frac{p (i + r) + i}
                                         {\\sqrt{p (i + 1) (i + r)}} \\\\
            c_i & = & \\displaystyle - \\frac{\\sqrt{p i (i + r - 1)}}
                                           {\\sqrt{p (i + 1) (i + r)}} \\\\
        \\end{array}, \\quad 1 < i

    where :math:`r` and :math:`p` are the parameters of the
    :class:`~openturns.NegativeBinomial` distribution.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomial_factory = ot.MeixnerFactory()
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    0.707107 - 0.707107 * X
    0.5 - 1.25 * X + 0.25 * X^2
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeixnerFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeixnerFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.MeixnerFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.MeixnerFactory_getRecurrenceCoefficients(self, *args)

    def getR(self):
        """
        Accessor to the number of failures parameter :math:`r`.

        Of the :class:`~openturns.NegativeBinomial` distribution.

        Returns
        -------
        r : int
            Number of failures parameter of the :class:`~openturns.NegativeBinomial`
            distribution.
        """
        return _orthogonalbasis.MeixnerFactory_getR(self)

    def getP(self):
        """
        Accessor to the success probability parameter :math:`p`.

        Of the :class:`~openturns.NegativeBinomial` distribution.

        Returns
        -------
        p : float
            Success probability parameter of the :class:`~openturns.NegativeBinomial`
            distribution.
        """
        return _orthogonalbasis.MeixnerFactory_getP(self)

    def __repr__(self): return _orthogonalbasis.MeixnerFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_MeixnerFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_MeixnerFactory
    __del__ = lambda self : None;
MeixnerFactory_swigregister = _orthogonalbasis.MeixnerFactory_swigregister
MeixnerFactory_swigregister(MeixnerFactory)

class OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _orthogonalbasis.OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject
    __del__ = lambda self : None;
OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_swigregister = _orthogonalbasis.OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_swigregister
OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject_swigregister(OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject)

class PolynomialFamilyCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolynomialFamilyCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PolynomialFamilyCollection, name)
    __swig_destroy__ = _orthogonalbasis.delete_PolynomialFamilyCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_clear(self)

    def __len__(self): return _orthogonalbasis.PolynomialFamilyCollection___len__(self)
    def __eq__(self, *args): return _orthogonalbasis.PolynomialFamilyCollection___eq__(self, *args)
    def __contains__(self, *args): return _orthogonalbasis.PolynomialFamilyCollection___contains__(self, *args)
    def __getitem__(self, *args): return _orthogonalbasis.PolynomialFamilyCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _orthogonalbasis.PolynomialFamilyCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _orthogonalbasis.PolynomialFamilyCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _orthogonalbasis.PolynomialFamilyCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _orthogonalbasis.PolynomialFamilyCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _orthogonalbasis.PolynomialFamilyCollection_isEmpty(self)

    def __repr__(self): return _orthogonalbasis.PolynomialFamilyCollection___repr__(self)
    def __str__(self, offset=""): return _orthogonalbasis.PolynomialFamilyCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_PolynomialFamilyCollection(*args)
        try: self.this.append(this)
        except: self.this = this
PolynomialFamilyCollection_swigregister = _orthogonalbasis.PolynomialFamilyCollection_swigregister
PolynomialFamilyCollection_swigregister(PolynomialFamilyCollection)

class OrthogonalUniVariatePolynomialFamily(OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject):
    """
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariatePolynomialFamily, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactoryTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariatePolynomialFamily, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getClassName(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily___repr__(self)
    def build(self, *args):
        """
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_build(self, *args)

    def getRoots(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`k > 0`
            Polynomial order.

        Returns
        -------
        roots : :class:`~openturns.NumericalPoint`
            The roots of the :math:`k`-th order orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRoots(3))
        [-1.73205,...,1.73205]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getRoots(self, *args)

    def getNodesAndWeights(self, *args):
        """
        Build the :math:`k`-th order quadrature scheme.

        Associated with the orthogonal univariate polynomials family.

        Parameters
        ----------
        k : int, :math:`0 < k`
            Polynomial order.

        Returns
        -------
        nodes : :class:`~openturns.NumericalPoint`
            The nodes of the :math:`k`-th order quadrature scheme.
        weights : :class:`~openturns.NumericalPoint`
            The weights of the :math:`k`-th order quadrature scheme.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> nodes, weights = polynomial_factory.getNodesAndWeights(3)
        >>> print(nodes)
        [-1.73205,...,1.73205]
        >>> print(weights)
        [0.166667,0.666667,0.166667]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getNodesAndWeights(self, *args)

    def getMeasure(self):
        """
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \\di{x}` if and only if their dot product:

        .. math::

            \\langle P, Q \\rangle = \\int_{\\alpha}^{\\beta} P(x) Q(x) w(x)\\di{x}
                                 = 0

        where :math:`\\alpha \\in \\Rset \\cup \\{-\\infty\\}` and
        :math:`\\beta \\in \\Rset \\cup \\{+\\infty\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getMeasure(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_getRecurrenceCoefficients(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariatePolynomialFamily(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFamily
    __del__ = lambda self : None;
OrthogonalUniVariatePolynomialFamily_swigregister = _orthogonalbasis.OrthogonalUniVariatePolynomialFamily_swigregister
OrthogonalUniVariatePolynomialFamily_swigregister(OrthogonalUniVariatePolynomialFamily)

class OrthonormalizationAlgorithmImplementation(openturns.common.PersistentObject):
    """
    Algorithm used to build the orthonormal basis.

    With respect to a specific distribution.

    Available constructors:
        OrthonormalizationAlgorithm(*orthoAlgoImp*)

        OrthonormalizationAlgorithm(*measure*)

    Parameters
    ----------
    orthoAlgoImp : OrthonormalizationAlgorithmImplementation
        An orthonormalization algorithm implementation which is the
        :class:`~openturns.GramSchmidtAlgorithm` or
        the :class:`~openturns.ChebychevAlgorithm`.
    measure : :class:`~openturns.Distribution`
        A distribution for which the orthonormal polynomial basis is built. 

    See also
    --------
    GramSchmidtAlgorithm, ChebychevAlgorithm

    Notes
    -----
    It enables to build the orthonormal polynomial basis with respect to the given 
    distribution.

    In the first usage, the algorithm orthoAlgoImp is used (that specifies the
    associated distribution). In the second usage, the Gram-Schmidt algorithm is
    used by default. Only the distribution *measure* is specified.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthonormalizationAlgorithmImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthonormalizationAlgorithmImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : integer
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \\times x + a_1) \\times P_n(x) + a_2 \\times P_{n-1}(x)`.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getRecurrenceCoefficients(self, *args)

    def __repr__(self): return _orthogonalbasis.OrthonormalizationAlgorithmImplementation___repr__(self)
    def getMeasure(self):
        """
        Accessor to the measure.

        Returns
        -------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_getMeasure(self)

    def setMeasure(self, *args):
        """
        Accessor to the measure.

        Parameters
        ----------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementation_setMeasure(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthonormalizationAlgorithmImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthonormalizationAlgorithmImplementation
    __del__ = lambda self : None;
OrthonormalizationAlgorithmImplementation_swigregister = _orthogonalbasis.OrthonormalizationAlgorithmImplementation_swigregister
OrthonormalizationAlgorithmImplementation_swigregister(OrthonormalizationAlgorithmImplementation)

class OrthonormalizationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthonormalizationAlgorithmImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthonormalizationAlgorithmImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthonormalizationAlgorithmImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _orthogonalbasis.OrthonormalizationAlgorithmImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _orthogonalbasis.delete_OrthonormalizationAlgorithmImplementationTypedInterfaceObject
    __del__ = lambda self : None;
OrthonormalizationAlgorithmImplementationTypedInterfaceObject_swigregister = _orthogonalbasis.OrthonormalizationAlgorithmImplementationTypedInterfaceObject_swigregister
OrthonormalizationAlgorithmImplementationTypedInterfaceObject_swigregister(OrthonormalizationAlgorithmImplementationTypedInterfaceObject)

class OrthonormalizationAlgorithm(OrthonormalizationAlgorithmImplementationTypedInterfaceObject):
    """
    Algorithm used to build the orthonormal basis.

    With respect to a specific distribution.

    Available constructors:
        OrthonormalizationAlgorithm(*orthoAlgoImp*)

        OrthonormalizationAlgorithm(*measure*)

    Parameters
    ----------
    orthoAlgoImp : OrthonormalizationAlgorithmImplementation
        An orthonormalization algorithm implementation which is the
        :class:`~openturns.GramSchmidtAlgorithm` or
        the :class:`~openturns.ChebychevAlgorithm`.
    measure : :class:`~openturns.Distribution`
        A distribution for which the orthonormal polynomial basis is built. 

    See also
    --------
    GramSchmidtAlgorithm, ChebychevAlgorithm

    Notes
    -----
    It enables to build the orthonormal polynomial basis with respect to the given 
    distribution.

    In the first usage, the algorithm orthoAlgoImp is used (that specifies the
    associated distribution). In the second usage, the Gram-Schmidt algorithm is
    used by default. Only the distribution *measure* is specified.
    """
    __swig_setmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthonormalizationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthonormalizationAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : integer
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \\times x + a_1) \\times P_n(x) + a_2 \\times P_{n-1}(x)`.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getRecurrenceCoefficients(self, *args)

    def getMeasure(self):
        """
        Accessor to the measure.

        Returns
        -------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_getMeasure(self)

    def setMeasure(self, *args):
        """
        Accessor to the measure.

        Parameters
        ----------
        m : :class:`~openturns.Distribution`
            The measure for which the orthonormal polynomial basis is built.
        """
        return _orthogonalbasis.OrthonormalizationAlgorithm_setMeasure(self, *args)

    def __repr__(self): return _orthogonalbasis.OrthonormalizationAlgorithm___repr__(self)
    def __str__(self, offset=""): return _orthogonalbasis.OrthonormalizationAlgorithm___str__(self, offset)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthonormalizationAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthonormalizationAlgorithm
    __del__ = lambda self : None;
OrthonormalizationAlgorithm_swigregister = _orthogonalbasis.OrthonormalizationAlgorithm_swigregister
OrthonormalizationAlgorithm_swigregister(OrthonormalizationAlgorithm)

class AdaptiveStieltjesAlgorithm(OrthonormalizationAlgorithmImplementation):
    """
    AdaptiveStieltjes algorithm used to build the orthonormal basis.

    The algorithm builds a polynomial basis orthonormal with respect to a specific distribution.

    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        A measure for which the orthonormal polynomial basis is built. 

    See also
    --------
    OrthonormalizationAlgorithm, ChebychevAlgorithm, GramSchmidtAlgorithm

    Notes
    -----
    It implements an adaptive Stieltjes algorithm that builds the polynomial family
    orthonormal with respect to the distribution *measure*, using the
    :class:`~openturns.GaussKronrod` adaptive integration method to compute the
    following dot-products: :math:`R_n=\\langle Q_n, Q_n\\rangle` and
    :math:`S_n=\\langle xQ_n, Q_n\\rangle` where :math:`Q_n` is the monic polynomial
    associated to the orthonormal polynomial :math:`P_n`, needed to compute the
    coefficients of the three-terms recurrence relation that defines :math:`P_n`
    (see :class:`~openturns.OrthogonalUnivariatePolynomialFamily`):

    .. math::

        a_n = 1/\\sqrt{\\beta_{n+1}}\\quad b_n = -\\alpha_n/sqrt{\\beta_{n+1}}\\quad c_n = -\\sqrt{\\beta_n/\\beta_{n+1}}

    where :math:`\\alpha_n = S_n / R_n` and :math:`\\beta_n  = R_n / R_{n-1}, n>0, \\beta_0 = 0`.

    """
    __swig_setmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AdaptiveStieltjesAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AdaptiveStieltjesAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.AdaptiveStieltjesAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : integer
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \\times x + a_1) \\times P_n(x) + a_2 \\times P_{n-1}(x)`.
        """
        return _orthogonalbasis.AdaptiveStieltjesAlgorithm_getRecurrenceCoefficients(self, *args)

    def __repr__(self): return _orthogonalbasis.AdaptiveStieltjesAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_AdaptiveStieltjesAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_AdaptiveStieltjesAlgorithm
    __del__ = lambda self : None;
AdaptiveStieltjesAlgorithm_swigregister = _orthogonalbasis.AdaptiveStieltjesAlgorithm_swigregister
AdaptiveStieltjesAlgorithm_swigregister(AdaptiveStieltjesAlgorithm)

class ChebychevAlgorithm(OrthonormalizationAlgorithmImplementation):
    """
    Chebychev algorithm used to build the orthonormal basis.

    The algorithm builds the basis With respect to a specific distribution.

    Available constructors:
        ChebychevAlgorithm(*measure*)

        ChebychevAlgorithm(*measure, referenceFamily*)

    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        A measure for which the orthonormal polynomial basis is built. 
    referenceFamily : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        A polynomial family from which the algorithm starts to build the orthonornal
        polynomial family. When not specified, the *referenceFamily* is the
        canonical one: :math:`\\{ 1, x, x^2, \\ldots\\}`.

    See also
    --------
    OrthonormalizationAlgorithm, GramSchmidtAlgorithm

    Notes
    -----
    It implements the Chebychev algorithm that builds the orthonormalized
    polynomial family with respect to the distribution *measure*, where the initial
    polynomial family is the one specified in *referenceFamily*. 
    """
    __swig_setmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChebychevAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ChebychevAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.ChebychevAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : integer
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \\times x + a_1) \\times P_n(x) + a_2 \\times P_{n-1}(x)`.
        """
        return _orthogonalbasis.ChebychevAlgorithm_getRecurrenceCoefficients(self, *args)

    def setReferenceFamily(self, *args):
        """
        Accessor to the reference family.

        Parameters
        ----------
        family : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The polynomial family from which the orthonormal polynomial family is built.
        """
        return _orthogonalbasis.ChebychevAlgorithm_setReferenceFamily(self, *args)

    def getReferenceFamily(self):
        """
        Accessor to the reference family.

        Returns
        -------
        family : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The polynomial family from which the orthonormal polynomial family is built.
        """
        return _orthogonalbasis.ChebychevAlgorithm_getReferenceFamily(self)

    def __repr__(self): return _orthogonalbasis.ChebychevAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_ChebychevAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_ChebychevAlgorithm
    __del__ = lambda self : None;
ChebychevAlgorithm_swigregister = _orthogonalbasis.ChebychevAlgorithm_swigregister
ChebychevAlgorithm_swigregister(ChebychevAlgorithm)

class GramSchmidtAlgorithm(OrthonormalizationAlgorithmImplementation):
    """
    GramSchmidt algorithm used to build the orthonormal basis.

    The algorithm builds the basis with respect to a specific distribution.

    Available constructors:
        GramSchmidtAlgorithm(*measure*)

        GramSchmidtAlgorithm(*measure, referenceFamily*)

    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        A measure for which the orthonormal polynomial basis is built. 
    referenceFamily : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        A polynomial family from which the algorithm starts to build the orthonornal
        polynomial family. When not specified, the *referenceFamily* is the
        canonical one: :math:`\\{ 1, x, x^2, \\ldots\\}`.

    See also
    --------
    OrthonormalizationAlgorithm, ChebychevAlgorithm

    Notes
    -----
    It implements the Gram-Schmidt algorithm that builds the orthonormalized
    polynomial family with respect to the distribution *measure*, where the initial
    polynomial family is the one specified in *referenceFamily*. 
    """
    __swig_setmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GramSchmidtAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthonormalizationAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GramSchmidtAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.GramSchmidtAlgorithm_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients.

        Parameters
        ----------
        n : integer
            Index ot the recurrence step.

        Returns
        -------
        coef : sequence of float
            Calculate the coefficients of recurrence :math:`a_0`, :math:`a_1`, :math:`a_2`
            such that
            :math:`P_{n+1}(x) = (a_0 \\times x + a_1) \\times P_n(x) + a_2 \\times P_{n-1}(x)`.
        """
        return _orthogonalbasis.GramSchmidtAlgorithm_getRecurrenceCoefficients(self, *args)

    def setReferenceFamily(self, *args):
        """
        Accessor to the reference family.

        Parameters
        ----------
        family : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The polynomial family from which the orthonormal polynomial family is built.
        """
        return _orthogonalbasis.GramSchmidtAlgorithm_setReferenceFamily(self, *args)

    def getReferenceFamily(self):
        """
        Accessor to the reference family.

        Returns
        -------
        family : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            The polynomial family from which the orthonormal polynomial family is built.
        """
        return _orthogonalbasis.GramSchmidtAlgorithm_getReferenceFamily(self)

    def __repr__(self): return _orthogonalbasis.GramSchmidtAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_GramSchmidtAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_GramSchmidtAlgorithm
    __del__ = lambda self : None;
GramSchmidtAlgorithm_swigregister = _orthogonalbasis.GramSchmidtAlgorithm_swigregister
GramSchmidtAlgorithm_swigregister(GramSchmidtAlgorithm)

class StandardDistributionPolynomialFactory(OrthogonalUniVariatePolynomialFactory):
    """
    Build orthonormal or orthogonal univariate polynomial families.

    Parameters
    ----------
    arg : :class:`~openturns.Distribution` or :class:`~openturns.OrthonormalizationAlgorithm`
        Either a :class:`~openturns.Distribution` implementing the probability
        measure according to which the polynomial family is orthonormal **or** an
        :class:`~openturns.OrthonormalizationAlgorithm`.

        In the first case, the implementation will switch to the suitable specific
        orthonormal univariate polynomial family if any (see the notes below), or
        it will default to the :class:`~openturns.AdaptiveStieltjesAlgorithm` to build
        an orthonormal univariate polynomial family.

    Notes
    -----
    Use this functionality with caution:

       - The polynomials exist if and only if the distribution admits finite
         moments of all orders. Even if some algorithms manage to compute something, it
         will be plain numerical noise.
       - Even if the polynomials exist, they form an Hilbertian basis wrt the
         dot product induced by the distribution if and only if the distribution is
         **determinate**, ie is characterized by its moments. For example, the
         :class:`~openturns.LogNormal` distribution has orthonormal polynomials of
         arbitrary degree but the projection onto the functional space generated by
         these polynomials (see :class:`~openturns.FunctionalChaosAlgorithm`) may
         converge to a function that differs significantly from the function being
         projected.

    OpenTURNS implements the following **specific orthonormal** [#orthonormal]_
    univariate polynomial families together with their associated **standard
    distributions**:

    .. table::

        +-----------------------------------------------------------------------+---------------------------------------+
        | Standard distribution                                                 | Polynomial                            |
        +=======================================================================+=======================================+
        | :class:`~openturns.Normal`                                            | :class:`~openturns.HermiteFactory`    |
        | :math:`\\cN(\\mu = 0, \\sigma = 1)`                                      |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Uniform`                                           | :class:`~openturns.LegendreFactory`   |
        | :math:`\\cU(a = -1, b = 1)`                                            |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Gamma`                                             | :class:`~openturns.LaguerreFactory`   |
        | :math:`\\Gamma(k = k_a + 1, \\lambda = 1, \\gamma = 0)`                  |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Beta`                                              | :class:`~openturns.JacobiFactory`     |
        | :math:`{\\rm B}(r = \\beta + 1, t = \\alpha + \\beta + 2, a = -1, b = 1)` |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Poisson`                                           | :class:`~openturns.CharlierFactory`   |
        | :math:`\\cP(\\lambda)`                                                  |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.Binomial`                                          | :class:`~openturns.KrawtchoukFactory` |
        | :math:`\\cB(n, p)`                                                     |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+
        | :class:`~openturns.NegativeBinomial`                                  | :class:`~openturns.MeixnerFactory`    |
        | :math:`\\cB^-(r, p)`                                                   |                                       |
        +-----------------------------------------------------------------------+---------------------------------------+

    Aside, OpenTURNS also implements generic algorithms for building orthonormal
    univariate polynomial families with respect to any arbitrary probability
    measure (implemented as a :class:`~openturns.Distribution`).
    OpenTURNS implements the following :class:`~openturns.OrthonormalizationAlgorithm`'s:

       - :class:`~openturns.AdaptiveStieltjesAlgorithm` (default),
       - :class:`~openturns.GramSchmidtAlgorithm`,
       - :class:`~openturns.ChebychevAlgorithm`

    .. [#orthonormal] A polynomial family :math:`(P_n)_{n \\geq 0}` is said to be
        orthonormal with respect to the probability measure :math:`w(x) \\di{x}` if
        and only if:

        .. math::

            \\langle P_i, P_j \\rangle = \\int_{\\supp{w}} P_i(x) P_j(x) w(x) \\di{x}
                                     = \\delta_{ij}, \\quad i, j = 1, \\ldots, n

        where :math:`\\delta_{ij}` denotes Kronecker's delta.

    Examples
    --------
    >>> import openturns as ot

    Build the specific orthonormal polynomial factory associated to the normal
    distribution (Hermite):

    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(ot.Normal())
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    X
    -0.707107 + 0.707107 * X^2

    Build an orthonormal polynomial factory for the Weibull distribution with
    the default orthonormalization algorithm:

    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(ot.Weibull())
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2

    Build an orthonormal polynomial factory for the log-normal distribution with
    Chebychev's othonormalization algorithm:

    >>> algorithm = ot.ChebychevAlgorithm(ot.Weibull())
    >>> polynomial_factory = ot.StandardDistributionPolynomialFactory(algorithm)
    >>> for i in range(3):
    ...     print(polynomial_factory.build(i))
    1
    -1 + X
    1 - 2 * X + 0.5 * X^2

    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StandardDistributionPolynomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariatePolynomialFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, StandardDistributionPolynomialFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getClassName(self)

    def getRecurrenceCoefficients(self, *args):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.NumericalPoint`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _orthogonalbasis.StandardDistributionPolynomialFactory_getRecurrenceCoefficients(self, *args)

    def __repr__(self): return _orthogonalbasis.StandardDistributionPolynomialFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_StandardDistributionPolynomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_StandardDistributionPolynomialFactory
    __del__ = lambda self : None;
StandardDistributionPolynomialFactory_swigregister = _orthogonalbasis.StandardDistributionPolynomialFactory_swigregister
StandardDistributionPolynomialFactory_swigregister(StandardDistributionPolynomialFactory)

class OrthogonalFunctionFactory(openturns.func.FunctionalBasisImplementation):
    """
    Orthogonal basis.

    Notes
    -----
    OrthogonalBasis is the interface class of the OrthogonalFunctionFactory
    implementation, which is an
    :class:`~openturns.OrthogonalProductPolynomialFactory` in the particular case
    of polynomial chaos expansion.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> # Create an orthogonal basis
    >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
    >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.FunctionalBasisImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.FunctionalBasisImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalFunctionFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getClassName(self)

    def build(self, *args):
        """
        Get the term of the basis collection at a given index.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\\Nset` to :math:`\\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The term of the basis collection at the index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        (1.73205 * x0) * (-1 + x1)
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_build(self, *args)

    def getMeasure(self):
        """
        Get the measure upon which the basis is orthogonal.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            Measure upon which the basis is orthogonal.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> measure = productBasis.getMeasure()
        >>> print(measure.getMarginal(0))
        Uniform(a = -1, b = 1)
        >>> print(measure.getMarginal(1))
        Gamma(k = 1, lambda = 1, gamma = 0)
        >>> print(measure.getMarginal(2))
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getMeasure(self)

    def getEnumerateFunction(self):
        """
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_getEnumerateFunction(self)

    def isOrthogonal(self):
        """
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _orthogonalbasis.OrthogonalFunctionFactory_isOrthogonal(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalFunctionFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalFunctionFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalFunctionFactory
    __del__ = lambda self : None;
OrthogonalFunctionFactory_swigregister = _orthogonalbasis.OrthogonalFunctionFactory_swigregister
OrthogonalFunctionFactory_swigregister(OrthogonalFunctionFactory)

class OrthogonalProductPolynomialFactory(OrthogonalFunctionFactory):
    """
    Base class for orthogonal multivariate polynomials.

    Available constructors:
            OrthogonalProductPolynomialFactory(*polynomials*)

            OrthogonalProductPolynomialFactory(*polynomials, enumerateFunction*)

    Parameters
    ----------
    polynomials : list of :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        List of orthogonal univariate polynomials factories with the same
        dimension as the orthogonal basis.
    enumerateFunction : :class:`~openturns.EnumerateFunction`
        Associates to an integer its multi-index image in the :math:`\\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.

    Notes
    -----
    OrthogonalProductPolynomialFactory is a particular case of implementation of
    the :class:`~openturns.OrthogonalBasis` in the case of polynomial chaos
    expansion. It provides to the OrthogonalBasis the persistent types of the
    univariate orthogonal polynomials (e.g. Hermite, Legendre, Laguerre and Jacobi)
    needed to determine the distribution measure of projection of the input
    variable. Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.
    To facilitate the construction of the basis it is recommanded to use the class
    :class:`~openturns.StandardDistributionPolynomialFactory`.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> # Define the model
    >>> myModel = ot.NumericalMathFunction(['x1','x2','x3'], ['y'], ['1+x1*x2 + 2*x3^2'])
    >>> # Create a distribution of dimension 3
    >>> Xdist = ot.ComposedDistribution([ot.Normal(), ot.Uniform(), ot.Gamma(2.75, 1.0)])
    >>> # Construct the multivariate orthonormal basis
    >>> polyColl = [ot.HermiteFactory(), ot.LegendreFactory(), ot.LaguerreFactory(2.75)]
    >>> enumerateFunction = ot.LinearEnumerateFunction(3)
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)

    >>> # Easier way to construct the same multivariate orthonormal basis
    >>> polyColl = [ot.StandardDistributionPolynomialFactory(Xdist.getMarginal(i)) for i in range(Xdist.getDimension())]
    >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalProductPolynomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalProductPolynomialFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getClassName(self)

    def build(self, *args):
        """
        Get the term of the basis collection at a given index.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\\Nset` to :math:`\\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The term of the basis collection at the index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        (1.73205 * x0) * (-1 + x1)
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_build(self, *args)

    def getEnumerateFunction(self):
        """
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getEnumerateFunction(self)

    def getPolynomialFamilyCollection(self):
        """
        Get the collection of univariate orthogonal polynomial families.

        Returns
        -------
        polynomialFamily : list of :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
            List of orthogonal univariate polynomials families.
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getPolynomialFamilyCollection(self)

    def getNodesAndWeights(self, *args):
        """
        Get the nodes and the weights.

        Parameters
        ----------
        degrees : list of positiv int (:math:`k_1, \\dots, k_n`)
            List of :math:`n` polynomial orders associated with the :math:`n`
            univariate polynomials of the basis.

        Returns
        -------
        nodes : :class:`~openturns.NumericalSample`
        weights : :class:`~openturns.NumericalPoint`
            Nodes and weights of the multivariate polynomial associated with the
            marginal degrees (:math:`k_1, \\dots, k_n`) as the tensor product
            of the marginal orthogonal univariate polynomials, to build multivariate
            quadrature rules.

        See also
        --------
        OrthogonalUniVariatePolynomialFamily.getNodesAndWeights

        Examples
        --------
        >>> import openturns as ot
        >>> # Define the model
        >>> myModel = ot.NumericalMathFunction(['x1','x2','x3'], ['y'], ['1+x1*x2 + 2*x3^2'])
        >>> # Create a distribution of dimension 3
        >>> Xdist = ot.ComposedDistribution([ot.Normal(), ot.Uniform(), ot.Gamma(2.75, 1.0)])
        >>> # Construct the multivariate orthonormal basis
        >>> polyColl = [ot.HermiteFactory(), ot.LegendreFactory(), ot.LaguerreFactory(2.75)]
        >>> enumerateFunction = ot.LinearEnumerateFunction(3)
        >>> productBasis = ot.OrthogonalProductPolynomialFactory(polyColl, enumerateFunction)
        >>> nodes, weights = productBasis.getNodesAndWeights([2, 3, 1])
        >>> print(nodes[:2])
            [ v0        v1        v2        ]
        0 : [ -1        -0.774597  3.75     ]
        1 : [  1        -0.774597  3.75     ]
        >>> print(weights[:2])
        [0.138889,0.138889]
        """
        return _orthogonalbasis.OrthogonalProductPolynomialFactory_getNodesAndWeights(self, *args)

    def __repr__(self): return _orthogonalbasis.OrthogonalProductPolynomialFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalProductPolynomialFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalProductPolynomialFactory
    __del__ = lambda self : None;
OrthogonalProductPolynomialFactory_swigregister = _orthogonalbasis.OrthogonalProductPolynomialFactory_swigregister
OrthogonalProductPolynomialFactory_swigregister(OrthogonalProductPolynomialFactory)

class OrthogonalFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalFunctionFactoryTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalFunctionFactoryTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalFunctionFactoryTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _orthogonalbasis.OrthogonalFunctionFactoryTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalFunctionFactoryTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalFunctionFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _orthogonalbasis.OrthogonalFunctionFactoryTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalFunctionFactoryTypedInterfaceObject
    __del__ = lambda self : None;
OrthogonalFunctionFactoryTypedInterfaceObject_swigregister = _orthogonalbasis.OrthogonalFunctionFactoryTypedInterfaceObject_swigregister
OrthogonalFunctionFactoryTypedInterfaceObject_swigregister(OrthogonalFunctionFactoryTypedInterfaceObject)

class OrthogonalBasis(OrthogonalFunctionFactoryTypedInterfaceObject):
    """
    Orthogonal basis.

    Notes
    -----
    OrthogonalBasis is the interface class of the OrthogonalFunctionFactory
    implementation, which is an
    :class:`~openturns.OrthogonalProductPolynomialFactory` in the particular case
    of polynomial chaos expansion.

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> # Create an orthogonal basis
    >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
    >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalFunctionFactoryTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalBasis, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalFunctionFactoryTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalBasis, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalBasis_getClassName(self)

    def build(self, *args):
        """
        Get the term of the basis collection at a given index.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\\Nset` to :math:`\\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The term of the basis collection at the index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        (1.73205 * x0) * (-1 + x1)
        """
        return _orthogonalbasis.OrthogonalBasis_build(self, *args)

    def getMeasure(self):
        """
        Get the measure upon which the basis is orthogonal.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            Measure upon which the basis is orthogonal.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> measure = productBasis.getMeasure()
        >>> print(measure.getMarginal(0))
        Uniform(a = -1, b = 1)
        >>> print(measure.getMarginal(1))
        Gamma(k = 1, lambda = 1, gamma = 0)
        >>> print(measure.getMarginal(2))
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalBasis_getMeasure(self)

    def getEnumerateFunction(self):
        """
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalBasis_getEnumerateFunction(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalBasis___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalBasis(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalBasis
    __del__ = lambda self : None;
OrthogonalBasis_swigregister = _orthogonalbasis.OrthogonalBasis_swigregister
OrthogonalBasis_swigregister(OrthogonalBasis)

class OrthogonalUniVariateFunctionFactory(openturns.common.PersistentObject):
    """Base class for orthogonal univariate function factories."""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariateFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariateFunctionFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory_getClassName(self)

    ANALYSIS = _orthogonalbasis.OrthogonalUniVariateFunctionFactory_ANALYSIS
    PROBABILITY = _orthogonalbasis.OrthogonalUniVariateFunctionFactory_PROBABILITY
    def __repr__(self): return _orthogonalbasis.OrthogonalUniVariateFunctionFactory___repr__(self)
    def build(self, *args):
        """
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory_build(self, *args)

    def getMeasure(self):
        """
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the functions are
            orthogonal).

        Notes
        -----
        Two functions P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \\di{x}` if and only if their scalar product:

        .. math::

            \\langle P, Q \\rangle = \\int_{\\alpha}^{\\beta} P(x) Q(x) w(x) \\di{x}
                                 = 0

        where :math:`\\alpha \\in \\Rset \\cup \\{-\\infty\\}` and
        :math:`\\beta \\in \\Rset \\cup \\{+\\infty\\}`.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactory_getMeasure(self)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariateFunctionFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariateFunctionFactory
    __del__ = lambda self : None;
OrthogonalUniVariateFunctionFactory_swigregister = _orthogonalbasis.OrthogonalUniVariateFunctionFactory_swigregister
OrthogonalUniVariateFunctionFactory_swigregister(OrthogonalUniVariateFunctionFactory)

class OrthogonalUniVariateFunctionFactoryTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariateFunctionFactoryTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariateFunctionFactoryTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariateFunctionFactoryTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _orthogonalbasis.OrthogonalUniVariateFunctionFactoryTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariateFunctionFactoryTypedInterfaceObject
    __del__ = lambda self : None;
OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_swigregister = _orthogonalbasis.OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_swigregister
OrthogonalUniVariateFunctionFactoryTypedInterfaceObject_swigregister(OrthogonalUniVariateFunctionFactoryTypedInterfaceObject)

class FunctionFamilyCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionFamilyCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionFamilyCollection, name)
    __swig_destroy__ = _orthogonalbasis.delete_FunctionFamilyCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _orthogonalbasis.FunctionFamilyCollection_clear(self)

    def __len__(self): return _orthogonalbasis.FunctionFamilyCollection___len__(self)
    def __eq__(self, *args): return _orthogonalbasis.FunctionFamilyCollection___eq__(self, *args)
    def __contains__(self, *args): return _orthogonalbasis.FunctionFamilyCollection___contains__(self, *args)
    def __getitem__(self, *args): return _orthogonalbasis.FunctionFamilyCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _orthogonalbasis.FunctionFamilyCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _orthogonalbasis.FunctionFamilyCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _orthogonalbasis.FunctionFamilyCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _orthogonalbasis.FunctionFamilyCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _orthogonalbasis.FunctionFamilyCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _orthogonalbasis.FunctionFamilyCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _orthogonalbasis.FunctionFamilyCollection_isEmpty(self)

    def __repr__(self): return _orthogonalbasis.FunctionFamilyCollection___repr__(self)
    def __str__(self, offset=""): return _orthogonalbasis.FunctionFamilyCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_FunctionFamilyCollection(*args)
        try: self.this.append(this)
        except: self.this = this
FunctionFamilyCollection_swigregister = _orthogonalbasis.FunctionFamilyCollection_swigregister
FunctionFamilyCollection_swigregister(FunctionFamilyCollection)

class OrthogonalUniVariateFunctionFamily(OrthogonalUniVariateFunctionFactoryTypedInterfaceObject):
    """
    Base class for orthogonal univariate polynomial factories.

    See also
    --------
    StandardDistributionPolynomialFactory
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactoryTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariateFunctionFamily, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactoryTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariateFunctionFamily, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_getClassName(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalUniVariateFunctionFamily___repr__(self)
    def build(self, *args):
        """
        Build the :math:`k`-th order orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Returns
        -------
        polynomial : :class:`~openturns.OrthogonalUniVariatePolynomial`
            Requested orthogonal univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.build(2))
        -0.707107 + 0.707107 * X^2
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_build(self, *args)

    def getMeasure(self):
        """
        Accessor to the associated probability measure.

        Returns
        -------
        measure : :class:`~openturns.Distribution`
            The associated probability measure (according to which the polynomials are
            orthogonal).

        Notes
        -----
        Two polynomials P and Q are orthogonal with respect to the **probability
        measure** :math:`w(x) \\di{x}` if and only if their dot product:

        .. math::

            \\langle P, Q \\rangle = \\int_{\\alpha}^{\\beta} P(x) Q(x) w(x)\\di{x}
                                 = 0

        where :math:`\\alpha \\in \\Rset \\cup \\{-\\infty\\}` and
        :math:`\\beta \\in \\Rset \\cup \\{+\\infty\\}`.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getMeasure())
        Normal(mu = 0, sigma = 1)
        """
        return _orthogonalbasis.OrthogonalUniVariateFunctionFamily_getMeasure(self)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariateFunctionFamily(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariateFunctionFamily
    __del__ = lambda self : None;
OrthogonalUniVariateFunctionFamily_swigregister = _orthogonalbasis.OrthogonalUniVariateFunctionFamily_swigregister
OrthogonalUniVariateFunctionFamily_swigregister(OrthogonalUniVariateFunctionFamily)

class OrthogonalUniVariatePolynomialFunctionFactory(OrthogonalUniVariateFunctionFactory):
    """
    Polynomial specific orthogonal univariate function factory.

    Available constructor:
        OrthogonalUniVariatePolynomialFunctionFactory()

        OrthogonalUniVariatePolynomialFunctionFactory(*polynomialFactory*)

    Parameters
    ----------
    polynomialFactory : :class:`~openturns.OrthogonalUniVariatePolynomialFamily`
        The polynomial factory

    Examples
    --------
    >>> import openturns as ot
    >>> polynomialFactory = ot.HermiteFactory()
    >>> functionFactory = ot.OrthogonalUniVariatePolynomialFunctionFactory(polynomialFactory)
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalUniVariatePolynomialFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalUniVariatePolynomialFunctionFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_getClassName(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory___repr__(self)
    def build(self, *args):
        """
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_build(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalUniVariatePolynomialFunctionFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalUniVariatePolynomialFunctionFactory
    __del__ = lambda self : None;
OrthogonalUniVariatePolynomialFunctionFactory_swigregister = _orthogonalbasis.OrthogonalUniVariatePolynomialFunctionFactory_swigregister
OrthogonalUniVariatePolynomialFunctionFactory_swigregister(OrthogonalUniVariatePolynomialFunctionFactory)

class FourierSeriesFactory(OrthogonalUniVariateFunctionFactory):
    """
    Fourier series function factory.

    Generates the Fourier basis defined as follows:

    .. math::

        \\begin{array}{lcl}
          \\psi_0(x)      & = & 1 \\\\
          \\psi_{2k+1}(x) & = & \\sqrt{2}\\sin(kx) \\\\
          \\psi_{2k+2}(x) & = & \\sqrt{2}\\cos(kx)
        \\end{array}

    See also
    --------
    OrthogonalUniVariatePolynomialFunctionFactory
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FourierSeriesFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FourierSeriesFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.FourierSeriesFactory_getClassName(self)

    def __repr__(self): return _orthogonalbasis.FourierSeriesFactory___repr__(self)
    def build(self, *args):
        """
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.FourierSeriesFactory_build(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_FourierSeriesFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_FourierSeriesFactory
    __del__ = lambda self : None;
FourierSeriesFactory_swigregister = _orthogonalbasis.FourierSeriesFactory_swigregister
FourierSeriesFactory_swigregister(FourierSeriesFactory)

class HaarWaveletFactory(OrthogonalUniVariateFunctionFactory):
    """
    Haar wavelet function factory.

    Generates the Haar basis defined as follows:

    .. math::

        \\begin{array}{lcl}
          \\psi_0(x) & = & \\fcar{[0, 1]}{x} \\\\
          \\psi_n(x) & = & \\frac{1}{2^{j/2}}\\left[\\fcar{[\\frac{k}{2^j},\\frac{k+1/2}{2^j}]}{x}-\\fcar{[\\frac{k+1/2}{2^j},\\frac{k+1}{2^j}]}{x}\\right]
        \\end{array}

    where :math:`n = 2^j + k`, :math:`0 \\leq k < 2^j`, :math:`0 \\leq j`.

    See also
    --------
    OrthogonalUniVariatePolynomialFunctionFactory
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HaarWaveletFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalUniVariateFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HaarWaveletFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.HaarWaveletFactory_getClassName(self)

    def __repr__(self): return _orthogonalbasis.HaarWaveletFactory___repr__(self)
    def build(self, *args):
        """
        Build the :math:`n`-th order orthogonal univariate function.

        Parameters
        ----------
        n : int, :math:`0 \\leq n`
            Function order.

        Returns
        -------
        function : :class:`~openturns.UniVariateFunction`
            Requested orthogonal univariate function.
        """
        return _orthogonalbasis.HaarWaveletFactory_build(self, *args)

    def __init__(self, *args): 
        this = _orthogonalbasis.new_HaarWaveletFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_HaarWaveletFactory
    __del__ = lambda self : None;
HaarWaveletFactory_swigregister = _orthogonalbasis.HaarWaveletFactory_swigregister
HaarWaveletFactory_swigregister(HaarWaveletFactory)

class OrthogonalProductFunctionFactory(OrthogonalFunctionFactory):
    """
    Base class for orthogonal multivariate functions.

    Available constructors:
            OrthogonalProductFunctionFactory(*functions*)

            OrthogonalProductFunctionFactory(*functions, enumerateFunction*)

    Parameters
    ----------
    functions : list of :class:`~openturns.OrthogonalUniVariateFunctionFamily`
        List of orthogonal univariate function factories with the same
        dimension as the orthogonal basis.
    enumerateFunction : :class:`~openturns.EnumerateFunction`
        Associates to an integer its multi-index image in the :math:`\\Nset^d`
        dimension, which is the dimension of the basis. This multi-index represents
        the collection of degrees of the univariate polynomials.

    Notes
    -----
    OrthogonalProductFunctionFactory is a particular case of implementation of
    the :class:`~openturns.OrthogonalBasis` in the case of polynomial chaos
    expansion. It provides to the OrthogonalBasis the persistent types of the
    univariate orthogonal polynomials (e.g. Hermite, Legendre, Laguerre and Jacobi)
    needed to determine the distribution measure of projection of the input
    variable. Let's note that the exact hessian and gradient have been implemented
    for the product of polynomials.
    To facilitate the construction of the basis it is recommanded to use the class
    :class:`~openturns.StandardDistributionPolynomialFactory`.

    See also
    --------
    OrthogonalProductPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi
    >>> funcColl = [ot.HaarWaveletFactory(), ot.FourierSeriesFactory()]
    >>> dim = len(funcColl)
    >>> enumerateFunction = ot.LinearEnumerateFunction(dim)
    >>> productBasis = ot.OrthogonalProductFunctionFactory(funcColl, enumerateFunction)
    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthogonalProductFunctionFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthogonalProductFunctionFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getClassName(self)

    def build(self, *args):
        """
        Get the term of the basis collection at a given index.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\\Nset` to :math:`\\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The term of the basis collection at the index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        (1.73205 * x0) * (-1 + x1)
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_build(self, *args)

    def getEnumerateFunction(self):
        """
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getEnumerateFunction(self)

    def getFunctionFamilyCollection(self):
        """
        Get the collection of univariate orthogonal function families.

        Returns
        -------
        polynomialFamily : list of :class:`~openturns.OrthogonalUniVariateFunctionFamily`
            List of orthogonal univariate function families.
        """
        return _orthogonalbasis.OrthogonalProductFunctionFactory_getFunctionFamilyCollection(self)

    def __repr__(self): return _orthogonalbasis.OrthogonalProductFunctionFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_OrthogonalProductFunctionFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_OrthogonalProductFunctionFactory
    __del__ = lambda self : None;
OrthogonalProductFunctionFactory_swigregister = _orthogonalbasis.OrthogonalProductFunctionFactory_swigregister
OrthogonalProductFunctionFactory_swigregister(OrthogonalProductFunctionFactory)

class SoizeGhanemFactory(OrthogonalFunctionFactory):
    """
    SoizeGhanem orthonormal multivariate functional family.

    For the any multivariate distribution with continuous copula.

    Available constructor:
        SoizeGhanemFactory()

        SoizeGhanemFactory(*measure, useCopula*)

        SoizeGhanemFactory(*measure, phi, useCopula*)


    Parameters
    ----------
    measure : :class:`~openturns.Distribution`
        The measure defining the inner product of the factory.
    phi : :class:`~openturns.EnumerateFunction`
        The function mapping the index of the multivariate basis function to the multi-index of the marginal variables.
        Default is to use the :class:`~openturns.LinearEnumerateFunction`.
    useCopula : bool
        Flag to tell if the copula density has to be used directly or indirectly through the joint PDF of the measure. Default is True.

    Notes
    -----
    This class implements the multivariate orthonormal basis associated with an arbitrary multidimensional distribution with continuous copula and marginals with well-defined orthonormal polyomials of arbitrary order. The details are in [SoizeGhanem2004]_.

    See also
    --------
    StandardDistributionPolynomialFactory, OrthogonalProductPolynomialFactory

    Examples
    --------
    >>> import openturns as ot
    >>> marginals = [ot.Uniform(-1.0, 1.0), ot.Normal(0.0, 1.0)]
    >>> copula = ot.ClaytonCopula(1.0)
    >>> distribution = ot.ComposedDistribution(marginals, copula)
    >>> factory = ot.SoizeGhanemFactory(distribution)
    >>> point = [0.5]*2
    >>> for i in range(3):
    ...     value = factory.build(i)(point)
    ...     print('SoizeGhanem_' + str(i) + '(' + str(point) + ')=' + str(value))
    SoizeGhanem_0([0.5, 0.5])=[0.870518]
    SoizeGhanem_1([0.5, 0.5])=[0.753891]
    SoizeGhanem_2([0.5, 0.5])=[0.435259]

    """
    __swig_setmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SoizeGhanemFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthogonalFunctionFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SoizeGhanemFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _orthogonalbasis.SoizeGhanemFactory_getClassName(self)

    def build(self, *args):
        """
        Get the term of the basis collection at a given index.

        Parameters
        ----------
        index : int
            Indicates the term of the basis which must be constructed. In other words,
            *index* is used by a bijection from :math:`\\Nset` to :math:`\\Nset^d`
            (with :math:`d` the dimension of the basis). The bijection is detailed in
            :class:`~openturns.EnumerateFunction`.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The term of the basis collection at the index *index*.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create an orthogonal basis
        >>> polynomialCollection = [ot.LegendreFactory(), ot.LaguerreFactory(), ot.HermiteFactory()]
        >>> productBasis = ot.OrthogonalBasis(ot.OrthogonalProductPolynomialFactory(polynomialCollection))
        >>> termBasis = productBasis.build(4)
        >>> print(termBasis.getEvaluation())
        -1.11803 + 3.3541 * x0^2
        >>> termBasis = productBasis.build(5)
        >>> print(termBasis.getEvaluation())
        (1.73205 * x0) * (-1 + x1)
        """
        return _orthogonalbasis.SoizeGhanemFactory_build(self, *args)

    def getEnumerateFunction(self):
        """
        Return the enumerate function.

        Returns
        -------
        enumerateFunction : :class:`~openturns.EnumerateFunction`
            Enumerate function that translates unidimensional indices into
            multidimensional indices.
        """
        return _orthogonalbasis.SoizeGhanemFactory_getEnumerateFunction(self)

    def __repr__(self): return _orthogonalbasis.SoizeGhanemFactory___repr__(self)
    def __init__(self, *args): 
        this = _orthogonalbasis.new_SoizeGhanemFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _orthogonalbasis.delete_SoizeGhanemFactory
    __del__ = lambda self : None;
SoizeGhanemFactory_swigregister = _orthogonalbasis.SoizeGhanemFactory_swigregister
SoizeGhanemFactory_swigregister(SoizeGhanemFactory)

# This file is compatible with both classic and new-style classes.


