# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Stochastic process.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_model_process', [dirname(__file__)])
        except ImportError:
            import _model_process
            return _model_process
        if fp is not None:
            try:
                _mod = imp.load_module('_model_process', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _model_process = swig_import_helper()
    del swig_import_helper
else:
    import _model_process
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _model_process.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _model_process.SwigPyIterator_value(self)
    def incr(self, n=1): return _model_process.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _model_process.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _model_process.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _model_process.SwigPyIterator_equal(self, *args)
    def copy(self): return _model_process.SwigPyIterator_copy(self)
    def next(self): return _model_process.SwigPyIterator_next(self)
    def __next__(self): return _model_process.SwigPyIterator___next__(self)
    def previous(self): return _model_process.SwigPyIterator_previous(self)
    def advance(self, *args): return _model_process.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _model_process.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _model_process.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _model_process.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _model_process.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _model_process.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _model_process.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _model_process.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _model_process.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.dist_bundle1
import openturns.model_copula
import openturns.dist_bundle2
import openturns.randomvector
import openturns.weightedexperiment
class WhiteNoise(openturns.randomvector.ProcessImplementation):
    """
    White Noise process.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution` 
        Distribution of dimension :math:`d` of the white noise process.

    mesh : :class:`~openturns.Mesh`, optional
        Mesh in :math:`\\Rset^n` over which the process is discretized. 
        By default, the mesh is reduced to one point in :math:`\\Rset` which coordinate is equal to 0.


    Notes
    -----
    A second order white noise :math:`\\varepsilon: \\Omega \\times \\cD \\rightarrow \\Rset^d`  is a stochastic process of dimension :math:`d` such that the covariance function :math:`C(\\vect{s},\\vect{t})=\\delta(\\vect{t}-\\vect{s})C(\\vect{s},\\vect{s})` where :math:`C(\\vect{s},\\vect{s})`  is the covariance matrix of the process at vertex :math:`\\vect{s}` and :math:`\\delta` the Kroenecker function.

    A process :math:`\\varepsilon` is a white noise if  all finite family of locations  :math:`(\\vect{t}_i)_{i=1, \\dots, n} \\in \\cD`, :math:`(\\varepsilon_{\\vect{t}_i})_{i=1, \\dots, n}` is independent and identically distributed.


    Examples
    --------
    Create a normal normal white noise of dimension 1:

    >>> import openturns as ot
    >>> myDist = ot.Normal()
    >>> myMesh = ot.IntervalMesher([10]*2).build(ot.Interval([0.0]*2, [1.0]*2))
    >>> myWN = ot.WhiteNoise(myDist, myMesh)

    Get a realization:

    >>> myReal =myWN.getRealization()
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WhiteNoise, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WhiteNoise, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhiteNoise_getClassName(self)

    def __repr__(self): return _model_process.WhiteNoise___repr__(self)
    def __str__(self, offset=""): return _model_process.WhiteNoise___str__(self, offset)
    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.WhiteNoise_isStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.WhiteNoise_isNormal(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.WhiteNoise_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \\geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _model_process.WhiteNoise_getContinuousRealization(self)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.WhiteNoise_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to the marginal process.

        Parameters
        ----------
        N : integer
            The  index of the marginal to be extracted.

        indices : :class:`~openturns.Indices`, optional
            The list of the indexes of the marginal to be extracted.

        Returns
        -------
        wn : :class:`~openturns.WhiteNoise` 
            The marginal white noise.
        """
        return _model_process.WhiteNoise_getMarginal(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.WhiteNoise_getDistribution(self)

    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.WhiteNoise_setDistribution(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_WhiteNoise(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_WhiteNoise
    __del__ = lambda self : None;
WhiteNoise_swigregister = _model_process.WhiteNoise_swigregister
WhiteNoise_swigregister(WhiteNoise)

class RandomWalk(openturns.randomvector.ProcessImplementation):
    """
    Random walk process.

    Parameters
    ----------
    origin : :class:`~openturns.NumericalPoint` 
        Origin of the random walk.

    distribution : :class:`~openturns.Distribution` 
        Distribution of dimension equal to the dimension of `origin`.

    timeGrid : :class:`~openturns.TimeGrid`, optional
        The time grid of the process.
        By default, the time grid is  reduced to one time stamp equal to 0.


    Notes
    -----
    A random walk is a process :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d` where :math:`\\cD=\\Rset` discretized on the time grid :math:`(t_i)_{i \\geq 0}` such that:

    .. math::

        \\forall n>0,\\: X_{t_n}  =  X_{t_{n-1}} + \\varepsilon_{t_n}

    where :math:`\\vect{x}_0 \\in \\Rset^d` and :math:`\\varepsilon` is a  white noise of dimension :math:`d`.


    Examples
    --------
    Create a random walk:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0, 0.1, 10)
    >>> myDist = ot.ComposedDistribution([ot.Normal(), ot.Exponential(0.2)], ot.ClaytonCopula(0.5))
    >>> myOrigin = ot.NumericalPoint(myDist.getMean())
    >>> myRandomWalk = ot.RandomWalk(myOrigin, myDist, myTimeGrid)

    Get a realization:

    >>> myReal = myRandomWalk.getRealization()
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RandomWalk, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RandomWalk, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.RandomWalk_getClassName(self)

    def __repr__(self): return _model_process.RandomWalk___repr__(self)
    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.RandomWalk_isStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.RandomWalk_isNormal(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.RandomWalk_getRealization(self)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.RandomWalk_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.RandomWalk_getMarginal(self, *args)

    def getDistribution(self):
        """
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.RandomWalk_getDistribution(self)

    def setDistribution(self, *args):
        """
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.RandomWalk_setDistribution(self, *args)

    def getOrigin(self):
        """
        Accessor to the origin.

        Returns
        -------
        origin : :class:`~openturns.NumericalPoint` 
            The origin of the random walk.
        """
        return _model_process.RandomWalk_getOrigin(self)

    def setOrigin(self, *args):
        """
        Accessor to the origin.

        Parameters
        ----------
        origin : :class:`~openturns.NumericalPoint` 
            The origin of the random walk.
        """
        return _model_process.RandomWalk_setOrigin(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_RandomWalk(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_RandomWalk
    __del__ = lambda self : None;
RandomWalk_swigregister = _model_process.RandomWalk_swigregister
RandomWalk_swigregister(RandomWalk)

class SquareMatrixCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SquareMatrixCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SquareMatrixCollection, name)
    __swig_destroy__ = _model_process.delete_SquareMatrixCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _model_process.SquareMatrixCollection_clear(self)

    def __len__(self): return _model_process.SquareMatrixCollection___len__(self)
    def __eq__(self, *args): return _model_process.SquareMatrixCollection___eq__(self, *args)
    def __contains__(self, *args): return _model_process.SquareMatrixCollection___contains__(self, *args)
    def __getitem__(self, *args): return _model_process.SquareMatrixCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _model_process.SquareMatrixCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _model_process.SquareMatrixCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.SquareMatrixCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.SquareMatrixCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.SquareMatrixCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.SquareMatrixCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.SquareMatrixCollection_isEmpty(self)

    def __repr__(self): return _model_process.SquareMatrixCollection___repr__(self)
    def __str__(self, offset=""): return _model_process.SquareMatrixCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _model_process.new_SquareMatrixCollection(*args)
        try: self.this.append(this)
        except: self.this = this
SquareMatrixCollection_swigregister = _model_process.SquareMatrixCollection_swigregister
SquareMatrixCollection_swigregister(SquareMatrixCollection)

class SquareMatrixPersistentCollection(openturns.common.PersistentObject,SquareMatrixCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,SquareMatrixCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SquareMatrixPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,SquareMatrixCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SquareMatrixPersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.SquareMatrixPersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _model_process.new_SquareMatrixPersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _model_process.SquareMatrixPersistentCollection___repr__(self)
    def __str__(self, offset=""): return _model_process.SquareMatrixPersistentCollection___str__(self, offset)
    __swig_destroy__ = _model_process.delete_SquareMatrixPersistentCollection
    __del__ = lambda self : None;
SquareMatrixPersistentCollection_swigregister = _model_process.SquareMatrixPersistentCollection_swigregister
SquareMatrixPersistentCollection_swigregister(SquareMatrixPersistentCollection)

class ARMACoefficients(SquareMatrixPersistentCollection):
    """
    Coefficients of an ARMA process (MA or AR part).

    Available constructors:
        ARMACoefficients(*size, dimension*)

        ARMACoefficients(*coeffList*)

        ARMACoefficients(*matrixColl*)
       

    Parameters
    ----------
    size : int, 
        The number of elements in the list.
    dimension : int, 
        The dimension of each element in the list.
    coeffList : a list of floats,
        In dimension 1, the list of the coefficients defining the recurrence of the ARMA process (MA or AR part).
    matrixColl : a list of :class:`~openturns.SquareMatrix`
        In dimension :math:`d`, the collection of square matrices in :math:`\\Rset^d \\times \\Rset^d` defining the recurrence of the ARMA process (MA or AR part).

    Notes
    -----

    - In the first constructor:

    The elements are the null elements (scalar in dimension 1 and the null matrix in upper dimension).

    - In the other constructor:

    The elements are specified in the constructor.

    Examples
    --------
    Create the coefficients defining the recurrence of an ARMA process:

    >>> import openturns as ot
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    """
    __swig_setmethods__ = {}
    for _s in [SquareMatrixPersistentCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMACoefficients, name, value)
    __swig_getmethods__ = {}
    for _s in [SquareMatrixPersistentCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMACoefficients, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMACoefficients_getClassName(self)

    def __repr__(self): return _model_process.ARMACoefficients___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMACoefficients___str__(self, offset)
    def getDimension(self):
        """
        Accessor to the dimension of coefficients in the list.

        Returns
        -------
        dimension : int
            The dimension of elements in the list.
        """
        return _model_process.ARMACoefficients_getDimension(self)

    def add(self, *args):
        """
        Add a new element in the list.

        Available usages:
            add(*coeff*)

            add(*squareMat*)

        Parameters
        ----------
        coeff : float
            A new scalar coefficient added to the list composed with scalars.
        squareMat : :class:`~openturns.SquareMatrix`
            A new element in the list composed with square matrices.

        Returns
        -------
        - In the first usage:

        A new list of elements composed with scalars.

        - In the second usage:

        A new list of elements composed with square matrices.


        """
        return _model_process.ARMACoefficients_add(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ARMACoefficients(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMACoefficients
    __del__ = lambda self : None;
ARMACoefficients_swigregister = _model_process.ARMACoefficients_swigregister
ARMACoefficients_swigregister(ARMACoefficients)

class ARMAState(openturns.common.PersistentObject):
    """
    Last state recorded of an ARMA process.

    Parameters
    ----------
    values : :class:`~openturns.NumericalSample`
        Last :math:`p` values of the :math:`ARMA(p,q)` process of dimension :math:`d`. 
    noises : :class:`~openturns.NumericalSample`
        Last :math:`q` values of the white noise defining the :math:`ARMA(p,q)` process of dimension :math:`d`.

    Examples
    --------
    Define a state of an :math:`ARMA(4,2)` process of dimension 1:

    >>> import openturns as ot
    >>> myLastValues = ot.NumericalSample([[0.6], [0.7], [0.3], [0.2]])
    >>> myLastNoiseValues = ot.NumericalSample([[1.2], [1.8]])
    >>> myARMAState = ot.ARMAState(myLastValues, myLastNoiseValues)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMAState, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMAState, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAState_getClassName(self)

    def __repr__(self): return _model_process.ARMAState___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMAState___str__(self, offset)
    def getX(self):
        """
        Accessor to the last values of the ARMA process.

        Returns
        -------
        values : :class:`~openturns.NumericalSample` of size :math:`p` and dimension :math:`d`
            Last :math:`p` values of the :math:`ARMA(p,q)` process of dimension :math:`d`. 

        """
        return _model_process.ARMAState_getX(self)

    def setXEpsilon(self, *args): return _model_process.ARMAState_setXEpsilon(self, *args)
    def getEpsilon(self):
        """
        Accessor to the last values of the noise defining the ARMA process.

        Returns
        -------
        noises : :class:`~openturns.NumericalSample` of size :math:`q` and dimension :math:`d`
            Last :math:`q` values of the white noise of the :math:`ARMA(p,q)` process of dimension :math:`d`. 

        """
        return _model_process.ARMAState_getEpsilon(self)

    def getDimension(self):
        """
        Accessor to the dimension of coefficients in the list.

        Returns
        -------
        dimension : int
            The dimension :math:`d` of the ARMA process.
        """
        return _model_process.ARMAState_getDimension(self)

    def __init__(self, *args): 
        this = _model_process.new_ARMAState(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMAState
    __del__ = lambda self : None;
ARMAState_swigregister = _model_process.ARMAState_swigregister
ARMAState_swigregister(ARMAState)

class ARMA(openturns.randomvector.ProcessImplementation):
    """
    ARMA process.

    Available constructors:
        ARMA()

        ARMA(*ARCoeff, MACoeff, whiteNoise*)

        ARMA(*ARCoeff, MACoeff, whiteNoise, ARMAstate*)
       

    Parameters
    ----------
    ARCoeff : :class:`~openturns.ARMACoefficients`
        The coefficients of the AR part of the recurrence : :math:`(a_1, \\hdots, a_p)` in dimension 1 and :math:`(\\mat{A}_{\\, 1}, \\hdots, \\mat{A}{\\, _p})` in dimension :math:`d`.

        Default is: :math:`0` in dimension 1 and the associated time grid is :math:`\\{0,1\\}`.
    MACoeff :  :class:`~openturns.ARMACoefficients`
        The coefficients of the MA part of the recurrence : :math:`(b_1, \\hdots, b_q)` in dimension 1 and :math:`(\\mat{B}_{\\, 1}, \\hdots, \\mat{B}{\\, _p})` in dimension :math:`d`.

        Default is: :math:`0` in dimension 1 and the associated time grid is :math:`\\{0,1\\}`.
    whiteNoise : :class:`~openturns.WhiteNoise`
        The white noise distribution of the recurrent relation.

        Default is: the Normal distribution with zero mean and unit variance in dimension 1.
    ARMAstate : :class:`~openturns.ARMAState`
        The state of the ARMA process which will be extended to the next time stamps. The state  is composed with :math:`p` values of the process and :math:`q` values of the white noise. This constructor is needed to get possible futurs from the current state.


    Notes
    -----
    An ARMA process in dimension :math:`d` is defined by the linear recurrence :

    .. math::

        \\vect{X}_t + \\mat{A}_{\\, 1}   \\,  \\vect{X}_{t-1} + \\hdots +  \\mat{A}_{\\, p} \\,   \\vect{X}_{t-p} = \\vect{\\varepsilon}_{t}+  \\mat{B}_ {\\, 1} \\,   \\vect{\\varepsilon}_{t-1}+   \\hdots + \\mat{B}_{\\, q}  \\,  \\vect{\\varepsilon}_{t-q}

    where :math:`\\mat{A}_{\\, i} \\in  \\Rset^d \\times \\Rset^d` and :math:`\\mat{B}_{\\, j} \\in  \\Rset^d \\times \\Rset^d`.

    In dimension 1, an ARMA process is defined by:

    .. math::

        X_t +a_1  X_{t-1} + \\hdots +  a_p X_{t-p} = \\varepsilon_{t}+  b_1 \\varepsilon_{t-1}+   \\hdots +b_q \\varepsilon_{t-q}


    where :math:`(a_i,b_i) \\in \\Rset`.

    Examples
    --------
    Create an ARMA(4,2) process:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)

    >>> myLastValues = ot.NumericalSample([[0.6], [0.7], [0.3], [0.2]])
    >>> myLastNoiseValues = ot.NumericalSample([[1.2], [1.8]])
    >>> myARMAState = ot.ARMAState(myLastValues, myLastNoiseValues)
    >>> myARMAProcessWithState = ot.ARMA(myARCoef, myMACoef, myWhiteNoise, myARMAState)

    Generate a realization:

    >>> myTimeSeries = myARMAProcess.getContinuousRealization()
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMA, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMA, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMA_getClassName(self)

    def __repr__(self): return _model_process.ARMA___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMA___str__(self, offset)
    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.ARMA_isStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.ARMA_isNormal(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.ARMA_getRealization(self)

    def getFuture(self, *args):
        """
        Get possible futures from the current state of the ARMA process.

        Parameters
        ----------
        Nit : int, :math:`N_{it} \\geq 1`
            The number of time stamps of the future.

        Nreal : int, :math:`N_{real} \\geq 1`
            The number of possible futures that are generated. 

            Default is: :math:`N_{real} = 1`.

        Notes
        -----

        - If :math:`N_{real} = 1`:

        A :class:`~openturns.TimeSeries`
            One possible future of the ARMA process, from the current state over the next :math:`N_{it}` time stamps.


        - If :math:`N_{real} > 1`:

        A :class:`~openturnsProcessSample`
            :math:`N_{real}`  possible futures of the ARMA process, from the current state over the next :math:`N_{it}` time stamps.

        Note that the time grid of each future begins at the last time stamp of the time grid associated to the time series which is extended.
        """
        return _model_process.ARMA_getFuture(self, *args)

    def getARCoefficients(self):
        """
        Accessor to the AR coefficients of the ARMA process.

        Returns
        -------
        ARCoeff : :class:`~openturns.ARMACoefficients`
            The AR coefficients of the linear recurrence defining the process.
        """
        return _model_process.ARMA_getARCoefficients(self)

    def getMACoefficients(self):
        """
        Accessor to the MA coefficients of the ARMA process.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMACoefficients`
            The MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.ARMA_getMACoefficients(self)

    def getState(self):
        """
        Accessor to the stored state of the ARMA process.

        Returns
        -------
        ARMAstate : :class:`~openturns.ARMAState`
            The state of the ARMA process which will be extended to the next time stamps. The state  is composed with :math:`p` values of the process and :math:`q` values of the white noise.
        """
        return _model_process.ARMA_getState(self)

    def setState(self, *args):
        """
        Accessor to the stored state of the ARMA process.

        Parameters
        ----------
        ARMAstate : :class:`~openturns.ARMAState`
            The state of the ARMA process which will be extended to the next time stamps. The state  is composed with :math:`p` values of the process and :math:`q` values of the white noise.
        """
        return _model_process.ARMA_setState(self, *args)

    def getWhiteNoise(self):
        """
        Accessor to the white noise defining the ARMA process.

        Returns
        -------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise :math:`\\varepsilon` used in the linear recurrence of the ARMA process.
        """
        return _model_process.ARMA_getWhiteNoise(self)

    def setWhiteNoise(self, *args):
        """
        Accessor to the white noise defining the ARMA process.

        Parameters
        ----------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise :math:`\\varepsilon` used in the linear recurrence of the ARMA process.
        """
        return _model_process.ARMA_setWhiteNoise(self, *args)

    def computeNThermalization(self, *args):
        """
        Accessor to the stored state of the ARMA process.

        Parameters
        ----------
        eps : float, :math:`\\epsilon > 0`


        Returns
        -------
        Nther : int, :math:`N_{ther} \\geq 1`
            The number of iterations of the ARMA process before being stationary and independent of its intial state.

        Notes
        -----
        The thermalization number :math:`N_{ther}` is defined as follows:

        .. math::

            N_{ther} > E\\left[ \\displaystyle \\frac{\\ln \\epsilon}{\\ln \\max_{i,j} |r_{ij}|}\\right]

        where :math:`E[]` is the integer part of a float and the :math:`(r_i)_i` are the roots of the polynomials (given here in dimension 1) :

        .. math::

           \\Phi(\\vect{r}) = \\vect{r}^p + \\sum_{i=1}^p a_i\\vect{r}^{p-i}


        """
        return _model_process.ARMA_computeNThermalization(self, *args)

    def getNThermalization(self):
        """
        Accessor to the number of time stamps used to thermalize the process.

        Returns
        -------
        Nther : int, :math:`N_{ther} \\geq 1`
            The number of time stamps used to make the ARMA realization be independent from its actual state.

            Default precision is: :math:`\\varepsilon = 2^{-53} \\equiv 10^{-16}`.
        """
        return _model_process.ARMA_getNThermalization(self)

    def setNThermalization(self, *args):
        """
        Accessor to the number of time stamps used to thermalize the process.

        Parameters
        ----------
        Nther : int, :math:`N_{ther} \\geq 1`
            The number of time stamps used to make the ARMA realization independent from its actual state.
        """
        return _model_process.ARMA_setNThermalization(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.ARMA_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ARMA(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMA
    __del__ = lambda self : None;
ARMA_swigregister = _model_process.ARMA_swigregister
ARMA_swigregister(ARMA)

class SpectralNormalProcess(openturns.randomvector.ProcessImplementation):
    """
    Spectral normal process.

    Available constructors:
        SpectralNormalProcess(*secondOrderModel, timeGrid*)

        SpectralNormalProcess(*spectralModel, timeGrid*)

        SpectralNormalProcess(*secondOrderModel, fmax, N*)

        SpectralNormalProcess(*spectralModel, maxFreq, N*)

    Parameters
    ----------
    secondOrderModel : :class:`~openturns.SecondOrderModel`

    timeGrid : :class:`~openturns.RegularGrid`
        The time grid associated to the process. OpenTURNS has only implemented
        the algorithm when the mesh is a regular grid.
    spectralModel : :class:`~openturns.SpectralModel`
    maxFreq : float
        Equal to the maximal frequency minus :math:`\\Delta f`.
    N : float
        The number of points in the frequency grid, which is equal to the number of
        time stamps of the time grid.

    Notes
    -----

    - In the first usage, we fix the time grid and the second order model (spectral
      density model) which implements the process. The frequency discretization is
      deduced from the time discretization by the formulas
      :math:`f_{max} = \\frac{1}{\\Delta t}, \\quad \\Delta f = \\frac{1}{t_{max}}, N = \\frac{f_{max}}{\\Delta f}= \\frac{t_{max}}{\\Delta t}`

    - In the second usage, the process is fixed in the frequency domain. *fmax*
      value and *N* induce the time grid. Care: the maximal frequency used in the
      computation is not *fmax* but :math:`(1-1/N)fmax = fmax - \\Delta f`.

    - In the third usage, the spectral model is given and the other arguments are
      the same as the first usage.

    - In the fourth usage, the spectral model is given and the other arguments are
      the same as the second usage.

    The first call of :meth:`getRealization` might be time consuming because it
    computes :math:`N` hermitian matrices of size :math:`d \\times \\ d`, where
    :math:`d` is the dimension of the spectral model. These matrices are factorized
    and stored in order to be used for each call of the *getRealization* method.

    Examples
    --------
    Create a *SpectralNormalProcess* from a spectral model and a time grid:

    >>> import openturns as ot
    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(2)
    >>> spatialCorrelation[0,1] = 0.8
    >>> myTimeGrid =  ot.RegularGrid(0.0, 0.1, 20)
    >>> mySpectralModel = ot.CauchyModel(scale, amplitude, spatialCorrelation)
    >>> mySpectNormProc1 = ot.SpectralNormalProcess(mySpectralModel, myTimeGrid)

    Create a *SpectralNormalProcess* from a second order model and a time grid:

    >>> import openturns as ot
    >>> amplitude = [1.0]
    >>> scale = [4.0, 5.0]
    >>> myTimeGrid =  ot.RegularGrid(0.0, 0.1, 20)
    >>> mySecondOrderModel = ot.ExponentialCauchy(scale, amplitude)
    >>> mySpectNormProc2 = ot.SpectralNormalProcess(mySecondOrderModel, myTimeGrid)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpectralNormalProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpectralNormalProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.SpectralNormalProcess_getClassName(self)

    def __repr__(self): return _model_process.SpectralNormalProcess___repr__(self)
    def __str__(self, offset=""): return _model_process.SpectralNormalProcess___str__(self, offset)
    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.SpectralNormalProcess_getRealization(self)

    def getFrequencyGrid(self):
        """
        Get the frequency grid used to discretize the spectral model.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid`
            The frequency grid used to discretize the spectral model.

        """
        return _model_process.SpectralNormalProcess_getFrequencyGrid(self)

    def getMaximalFrequency(self):
        """
        Get the maximal frequency used in the computation.

        Returns
        -------
        freqMax : float
            The maximal frequency used in the computation: :math:`(1-1/N)fmax = fmax - \\Delta f`.

        """
        return _model_process.SpectralNormalProcess_getMaximalFrequency(self)

    def getNFrequency(self):
        """
        Get the  number of points in the frequency grid.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid`
            The number :math:`N` of points in the frequency grid, which is equal to the
            number of time stamps of the time grid.

        """
        return _model_process.SpectralNormalProcess_getNFrequency(self)

    def getFrequencyStep(self):
        """
        Get the frequency step :math:`\\Delta f` used to discretize the spectral model.

        Returns
        -------
        freqStep : float
            The frequency step :math:`\\Delta f` used to discretize the spectral model.

        """
        return _model_process.SpectralNormalProcess_getFrequencyStep(self)

    def getSpectralModel(self):
        """
        Get the spectral model.

        Returns
        -------
        specMod : :class:`~openturns.SpectralModel`
            The spectral model defining the process.

        """
        return _model_process.SpectralNormalProcess_getSpectralModel(self)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.SpectralNormalProcess_setTimeGrid(self, *args)

    def getFFTAlgorithm(self):
        """
        Get the FFT algorithm used to generate realizations of the spectral normal process.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT`
            FFT algorithm used to generate realizations of the spectral normal process.
            By default, it is the :class:`~openturns.KissFFT` algorithm.

        """
        return _model_process.SpectralNormalProcess_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, *args):
        """
        Set the FFT algorithm used to generate realizations of the spectral normal process.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT`
            FFT algorithm that will be used to generate realizations of the spectral
            normal process. OpenTURNS provides the :class:`~openturns.KissFFT`
            algorithm. More efficient implementations are provided by the
            *openturns-fftw* module.

        """
        return _model_process.SpectralNormalProcess_setFFTAlgorithm(self, *args)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.SpectralNormalProcess_isStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.SpectralNormalProcess_isNormal(self)

    __swig_getmethods__["AdaptGrid"] = lambda x: _model_process.SpectralNormalProcess_AdaptGrid
    if _newclass:AdaptGrid = staticmethod(_model_process.SpectralNormalProcess_AdaptGrid)
    def __init__(self, *args): 
        this = _model_process.new_SpectralNormalProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_SpectralNormalProcess
    __del__ = lambda self : None;
SpectralNormalProcess_swigregister = _model_process.SpectralNormalProcess_swigregister
SpectralNormalProcess_swigregister(SpectralNormalProcess)

def SpectralNormalProcess_AdaptGrid(*args):
  return _model_process.SpectralNormalProcess_AdaptGrid(*args)
SpectralNormalProcess_AdaptGrid = _model_process.SpectralNormalProcess_AdaptGrid

class TemporalNormalProcess(openturns.randomvector.ProcessImplementation):
    """
    Temporal normal processes.

    Available constructor:
        TemporalNormalProcess(*trend, secondOrderModel, mesh*)

        TemporalNormalProcess(*trend, covarianceModel, mesh*)

        TemporalNormalProcess(*secondOrderModel, mesh*)

        TemporalNormalProcess(*covarianceModel, mesh*)

    Parameters
    ----------
    trend : :class:`~openturns.TrendTransform`
        Trend function of the process. By default the trend is null.
    secondOrderModel : :class:`~openturns.SecondOrderModel`
        Stationary second order model that insures the coherence between the
        covariance function and the spectral density function.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Temporal covariance model :math:`C`.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\\cM` over which the domain :math:`\\cD` is discretized.

    Notes
    -----
    TemporalNormalProcess creates normal processes,
    :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` where :math:`\\cD \\in \\Rset^n`,
    from their temporal covariance function
    :math:`\\cC: \\cD \\times \\cD \\mapsto \\cM_{d \\times d}(\\Rset)`, which writes, in
    the stationary case: :math:`\\cC^{stat}: \\cD \\mapsto \\cM_{d \\times d}(\\Rset)`. A
    process is *normal*, if all its finite dimensional joint distributions are
    normal (See the method :meth:`~openturns.Process.isNormal` for a detailed definition).

    The temporal normal processes may have a trend: in that case, the normal
    process is the sum of the trend function
    :math:`f_{trend}: \\Rset^n \\mapsto \\Rset^d` and a zero-mean normal process.

    If the zero-mean process is stationary, in order to manipulate the same
    normal process through both the temporal and spectral views, it is necessary to
    create a second order model *secondOrderModel* that insures the coherence
    between the covariance function :math:`C^{stat}` and the spectral density
    function :math:`S: \\Rset \\mapsto \\cH^+(d)`. :math:`\\cH^+(d) \\in \\cM_d(\\Cset)`
    is the set of :math:`d`-dimensional positive definite hermitian matrices.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Default dimension parameter to evaluate the model
    >>> defaultDimension = 1
    >>> # Amplitude values
    >>> amplitude = [1.0]*defaultDimension
    >>> # Scale values
    >>> scale = [1.0]*defaultDimension
    >>> # Second order model with parameters
    >>> myModel = ot.ExponentialCauchy(scale, amplitude)
    >>> # Time grid
    >>> tmin = 0.0
    >>> step = 0.1
    >>> n = 11
    >>> myTimeGrid = ot.RegularGrid(tmin, step, n)
    >>> size = 100
    >>> myProcess = ot.TemporalNormalProcess(myModel, myTimeGrid)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemporalNormalProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemporalNormalProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.TemporalNormalProcess_getClassName(self)

    def __repr__(self): return _model_process.TemporalNormalProcess___repr__(self)
    def __str__(self, offset=""): return _model_process.TemporalNormalProcess___str__(self, offset)
    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _model_process.TemporalNormalProcess_setMesh(self, *args)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.TemporalNormalProcess_setTimeGrid(self, *args)

    def setSamplingMethod(self, *args):
        """
        Set the used method for getRealization.

        Available parameters are :

          * 0 : Cholesky factor sampling (default method)

          * 1 : H-Matrix method (if H-Mat available)

          * 2 : Gibbs method (in dimension 1 only)

        Parameters
        ----------
        samplingMethod : int
            Fix a method for sampling.


        """
        return _model_process.TemporalNormalProcess_setSamplingMethod(self, *args)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.TemporalNormalProcess_getRealization(self)

    def getCovarianceModel(self):
        """
        Get the covariance model.

        Returns
        -------
        covarianceModel : :class:`~openturns.CovarianceModel`
            Temporal covariance model :math:`C`.
        """
        return _model_process.TemporalNormalProcess_getCovarianceModel(self)

    def getTrend(self):
        """
        Get the trend function.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend function.
        """
        return _model_process.TemporalNormalProcess_getTrend(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.TemporalNormalProcess_isStationary(self)

    def isTrendStationary(self):
        """
        Tell if the process is trend stationary or not.

        Returns
        -------
        isTrendStationary : bool
            *True* if the process is trend stationary.
        """
        return _model_process.TemporalNormalProcess_isTrendStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.TemporalNormalProcess_isNormal(self)

    def __init__(self, *args): 
        this = _model_process.new_TemporalNormalProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_TemporalNormalProcess
    __del__ = lambda self : None;
TemporalNormalProcess_swigregister = _model_process.TemporalNormalProcess_swigregister
TemporalNormalProcess_swigregister(TemporalNormalProcess)

class ProcessCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessCollection, name)
    __swig_destroy__ = _model_process.delete_ProcessCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _model_process.ProcessCollection_clear(self)

    def __len__(self): return _model_process.ProcessCollection___len__(self)
    def __eq__(self, *args): return _model_process.ProcessCollection___eq__(self, *args)
    def __contains__(self, *args): return _model_process.ProcessCollection___contains__(self, *args)
    def __getitem__(self, *args): return _model_process.ProcessCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _model_process.ProcessCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _model_process.ProcessCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.ProcessCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.ProcessCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.ProcessCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.ProcessCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.ProcessCollection_isEmpty(self)

    def __repr__(self): return _model_process.ProcessCollection___repr__(self)
    def __str__(self, offset=""): return _model_process.ProcessCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _model_process.new_ProcessCollection(*args)
        try: self.this.append(this)
        except: self.this = this
ProcessCollection_swigregister = _model_process.ProcessCollection_swigregister
ProcessCollection_swigregister(ProcessCollection)

class AggregatedProcess(openturns.randomvector.ProcessImplementation):
    """
    Aggregation of several processes in one process.

    Available constructor:
        AggregatedProcess(*collProc*)

    Parameters
    ----------
    collProc : sequence of :class:`~openturns.Process`
        Collection of processes which all have the same spatial dimension.

    Notes
    -----
    If we note :math:`X_i: \\Omega \\times\\cD_i \\mapsto \\Rset^{d_i}` for :math:`0 \\leq i \\leq N` the collection of processes, where :math:`\\cD_i \\in \\Rset^n` for all :math:`i`.
    Then the resulting aggregated process :math:`Y: \\Omega \\times\\cD_0 \\mapsto \\Rset^d` where :math:`d=\\sum_{i=0}^N d_i`. The mesh of the first process :math:`X_0` has been assigned to the process :math:`Y`.

    Examples
    --------
    Create an aggregated process:

    >>> import openturns as ot
    >>> myMesher = ot.IntervalMesher(ot.Indices([5,10]))
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> myInterval = ot.Interval(lowerbound, upperBound)
    >>> myMesh = myMesher.build(myInterval)
    >>> myProcess1 = ot.WhiteNoise(ot.Normal(), myMesh)
    >>> myProcess2 = ot.WhiteNoise(ot.Triangular(), myMesh)
    >>> myAggregatedProcess = ot.AggregatedProcess([myProcess1, myProcess2])

    Draw one realization:

    >>> myGraph = myAggregatedProcess.getRealization().drawMarginal(0)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AggregatedProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AggregatedProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.AggregatedProcess_getClassName(self)

    def __repr__(self): return _model_process.AggregatedProcess___repr__(self)
    def __str__(self, offset=""): return _model_process.AggregatedProcess___str__(self, offset)
    def getRealization(self):
        """
        Get one realization of the aggregated process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Each process of the collection is realized on the common mesh defined on :math:`\\cD_0`.
        """
        return _model_process.AggregatedProcess_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            Each process of the collection is continuously realized on the common domain :math:`\\cD_0`.
        """
        return _model_process.AggregatedProcess_getContinuousRealization(self)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.AggregatedProcess_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Accessor the marginal processes.

        Available usages:
            getMarginal(*index*)

            getMarginal(*indices*)

        Parameters
        ----------
        index : int
            Index of the selected marginal process.
        indices : :class:`~openturns.Indices`
            List of indices of the selected marginal processes.

        Notes
        -----
        The selected marginal processes are extracted if the list of indices does not mingle the processes of the initial collection: take care to extract all the marginal processes process by process.
        For example, if :math:`X_0=(X_0^0, X_0^1)`, :math:`X_1=(X_1^0, X_1^1)` and :math:`X_2=(X_2^0, X_2^1, X_2^2)` then you can extract `Indices([1,0,2,4,6])` but not `Indices([1,2,0,4,6])`.
        """
        return _model_process.AggregatedProcess_getMarginal(self, *args)

    def setProcessCollection(self, *args):
        """
        Set the collection of processes.

        Parameters
        ----------
        collProc : sequence of :class:`~openturns.Process`
            Collection of processes which all have the same spatial dimension.

        """
        return _model_process.AggregatedProcess_setProcessCollection(self, *args)

    def getProcessCollection(self):
        """
        Get the collection of processes.

        Returns
        -------
        collProc : :class:`~openturns.ProcessCollection`
            Collection of processes which all have the same spatial dimension.

        """
        return _model_process.AggregatedProcess_getProcessCollection(self)

    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _model_process.AggregatedProcess_setMesh(self, *args)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.AggregatedProcess_setTimeGrid(self, *args)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.AggregatedProcess_isNormal(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.AggregatedProcess_isStationary(self)

    def getCovarianceModel(self): return _model_process.AggregatedProcess_getCovarianceModel(self)
    def getTrend(self): return _model_process.AggregatedProcess_getTrend(self)
    def __init__(self, *args): 
        this = _model_process.new_AggregatedProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_AggregatedProcess
    __del__ = lambda self : None;
AggregatedProcess_swigregister = _model_process.AggregatedProcess_swigregister
AggregatedProcess_swigregister(AggregatedProcess)

class CompositeProcess(openturns.randomvector.ProcessImplementation):
    """
    Process obtained by transformation.

    Parameters
    ----------
    fdyn : :class:`~openturns.DynamicalFunction`
        A dynamical function.
    inputProc : :class:`~openturns.Process`
        The input process.

    Notes
    -----
    A composite process is the image of  process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` by the dynamical function :math:`f_{dyn}:\\cD \\times \\Rset^d \\rightarrow \\cD' \\times \\Rset^q`:

    .. math::

        Y = fdyn(X)


    where :math:`\\cD \\in \\Rset^n` and  :math:`\\cD' \\in \\Rset^p`, defined by:

    .. math::

        f_{dyn}(\\vect{t}, \\vect{x}) = (t'(\\vect{t}), v'(\\vect{t}, \\vect{x}))


    with :math:`t': \\cD \\rightarrow \\cD'` and :math:`v': \\cD \\times \\Rset^d \\rightarrow \\Rset^q`.

    The process :math:`Y: \\Omega \\times \\cD' \\rightarrow \\Rset^q` is defined on the domain :math:`\\cD'` associated to the mesh :math:`\\cM'`.

    Examples
    --------
    Create the process X:

    >>> import openturns as ot
    >>> amplitude = [1.0, 1.0]
    >>> scale = [0.2, 0.3]
    >>> myCovModel = ot.ExponentialModel(scale, amplitude)
    >>> myMesh = ot.IntervalMesher([100]*2).build(ot.Interval([0.0]*2, [1.0]*2))
    >>> myXProcess = ot.TemporalNormalProcess(myCovModel, myMesh)

    Create a spatial  dynamical function :math:`g_{dyn}` associated to :math:`g: \\Rset^2 \\mapsto \\Rset^2` where :math:`g(x_1,x_2)= (x_1^2, x_1+x_2)`:

    >>> g = ot.NumericalMathFunction(['x1', 'x2'],  ['x1^2', 'x1+x2'])
    >>> nSpat = 2
    >>> gdyn = ot.SpatialFunction(g, nSpat)

    Create the Y process :math:`Y = g_{dyn}(X)`:

    >>> myYProcess = ot.CompositeProcess(gdyn, myXProcess)

    Add the trend :math:`f_{trend}: \\Rset^2 \\mapsto \\Rset^2` where :math:`f_{trend}(x_1,x_2)= (1+2x_1, 1+3x_2^2)`:

    >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['1+2*x1', '1+3*x2^2'])
    >>> fTrend = ot.TrendTransform(f)

    Create the process :math:`Y(\\omega, \\vect{t}) = X(\\omega, \\vect{t}) + f_{trend}(\\vect{t})`:

    >>> myYProcess2 = ot.CompositeProcess(fTrend, myXProcess)

    Apply the Box Cox transformation :math:`h=(h_1,h_2): \\Rset\\mapsto \\Rset^2` where :math:`h_i(x) = \\dfrac{x^3-1}{3}`:

    >>> h = ot.BoxCoxTransform([3.0, 0.0])
    >>> hBoxCox = ot.SpatialFunction(h, nSpat)

    Create the Y process :math:`Y = hBoxCox(X)`:

    >>> myYProcess3 = ot.CompositeProcess(hBoxCox,  myXProcess)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompositeProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, CompositeProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.CompositeProcess_getClassName(self)

    def __repr__(self): return _model_process.CompositeProcess___repr__(self)
    def __str__(self, offset=""): return _model_process.CompositeProcess___str__(self, offset)
    def isComposite(self):
        """
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _model_process.CompositeProcess_isComposite(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.CompositeProcess_getRealization(self)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.CompositeProcess_getFuture(self, *args)

    def getAntecedent(self):
        """
        Get the antecedent process.

        Returns
        -------
        XProcess : :class:`~openturns.Process`
            The process :math:`X`.
        """
        return _model_process.CompositeProcess_getAntecedent(self)

    def getFunction(self):
        """
        Get the dynamical function.

        Returns
        -------
        fdyn : :class:`~openturns.DynamicalFunction`
            The dynamical function :math:`f_{dyn}`.
        """
        return _model_process.CompositeProcess_getFunction(self)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.CompositeProcess_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_CompositeProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_CompositeProcess
    __del__ = lambda self : None;
CompositeProcess_swigregister = _model_process.CompositeProcess_swigregister
CompositeProcess_swigregister(CompositeProcess)

class FunctionalBasisProcess(openturns.randomvector.ProcessImplementation):
    """
    Functional basis process.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution of the random vector :math:`\\vect{A}=(A_1,\\dots, A_K)`.
    basis : :class:`~openturns.Basis`
        Collection of deterministic functions.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\\cM` over which the domain :math:`\\cD` is discretized.

    Notes
    -----
    A functional basis process :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` where :math:`\\cD \\in \\Rset^n`, writes:

    .. math::

        X(\\omega,\\vect{t})=\\sum_{i=1}^K A_i(\\omega)\\phi_i(\\vect{t}) \\quad  \\forall \\omega \\in \\Omega and \\forall \\vect{t} \\in \\cD

    with :math:`\\phi_i: \\Rset^n \\rightarrow \\Rset^d` for :math:`1 \\leq i \\leq K` and :math:`\\vect{A}=(A_1,\\dots, A_K)` a random vector of dimension :math:`K`.

    Examples
    --------
    Create the coefficients distribution:

    >>> import openturns as ot
    >>> coefDist = ot.Normal([2]*2, [5]*2, ot.CorrelationMatrix(2))

    Create a basis of functions:

    >>> phi_1 = ot.NumericalMathFunction(['t'], ['sin(t)'])
    >>> phi_2 = ot.NumericalMathFunction(['t'], ['cos(t)*cos(t)'])
    >>> myBasis = ot.Basis([phi_1, phi_2])

    Create a mesh:

    >>> myMesh = ot.RegularGrid(0.0, 0.1, 10)

    Create the functional basis process:

    >>> myFBProcess = ot.FunctionalBasisProcess(coefDist, myBasis, myMesh)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasisProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.randomvector.ProcessImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasisProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.FunctionalBasisProcess_getClassName(self)

    def __repr__(self): return _model_process.FunctionalBasisProcess___repr__(self)
    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.FunctionalBasisProcess_isStationary(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.FunctionalBasisProcess_isNormal(self)

    def getRealization(self):
        """
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.FunctionalBasisProcess_getRealization(self)

    def getContinuousRealization(self):
        """
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.NumericalMathFunction`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \\geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _model_process.FunctionalBasisProcess_getContinuousRealization(self)

    def getFuture(self, *args):
        """
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \\geq 0`
            Number of future steps.
        size : int, :math:`size \\geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.FunctionalBasisProcess_getFuture(self, *args)

    def getMarginal(self, *args):
        """
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \\leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.FunctionalBasisProcess_getMarginal(self, *args)

    def getDistribution(self):
        """
        Get the coefficients distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The distribution of the random vector :math:`\\vect{A}=(A_1,\\dots, A_K)` of dimension :math:`K`.
        """
        return _model_process.FunctionalBasisProcess_getDistribution(self)

    def setDistribution(self, *args):
        """
        Set the coefficients distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The distribution of the random vector :math:`\\vect{A}=(A_1,\\dots, A_K)` of dimension :math:`K`.
        """
        return _model_process.FunctionalBasisProcess_setDistribution(self, *args)

    def getBasis(self):
        """
        Get the basis of deterministic functions.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            Collection of functions :math:`(\\phi_i)_{1 \\leq i \\leq K}`.
        """
        return _model_process.FunctionalBasisProcess_getBasis(self)

    def setBasis(self, *args):
        """
        Set the basis of deterministic functions.

        Parameters
        ----------
        basis : :class:`~openturns.Basis`
            Collection of functions :math:`(\\phi_i)_{1 \\leq i \\leq K}`.
        """
        return _model_process.FunctionalBasisProcess_setBasis(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_FunctionalBasisProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_FunctionalBasisProcess
    __del__ = lambda self : None;
FunctionalBasisProcess_swigregister = _model_process.FunctionalBasisProcess_swigregister
FunctionalBasisProcess_swigregister(FunctionalBasisProcess)

class ARMAFactoryImplementation(openturns.common.PersistentObject):
    """Base class for ARMA models factory."""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMAFactoryImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMAFactoryImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAFactoryImplementation_getClassName(self)

    def __repr__(self): return _model_process.ARMAFactoryImplementation___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMAFactoryImplementation___str__(self, offset)
    def getP(self): return _model_process.ARMAFactoryImplementation_getP(self)
    def getCurrentP(self): return _model_process.ARMAFactoryImplementation_getCurrentP(self)
    def getQ(self): return _model_process.ARMAFactoryImplementation_getQ(self)
    def getCurrentQ(self): return _model_process.ARMAFactoryImplementation_getCurrentQ(self)
    def getInvertible(self): return _model_process.ARMAFactoryImplementation_getInvertible(self)
    def setInvertible(self, *args): return _model_process.ARMAFactoryImplementation_setInvertible(self, *args)
    def build(self, *args):
        """
        Estimate the ARMA model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the ARMA model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the ARMA model is estimated.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The estimated spectral model.
         
        """
        return _model_process.ARMAFactoryImplementation_build(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ARMAFactoryImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMAFactoryImplementation
    __del__ = lambda self : None;
ARMAFactoryImplementation_swigregister = _model_process.ARMAFactoryImplementation_swigregister
ARMAFactoryImplementation_swigregister(ARMAFactoryImplementation)

class WhittleFactoryState(openturns.common.PersistentObject):
    """
    Last state recorded of a scalar ARMA process.

    Parameters
    ----------
    p : int
        AR order of the estimated :math:`ARMA(p,q)`.
    ARMACoeff : sequence of float of dimension :math:`p+q`
        Coefficients of the AR then MA part of the estimated :math:`ARMA(p,q)` process.
    sigma2 : float
        Variance of the white noise.
    criteria : sequence of float of dimension 3
        The values of the criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* on the estimated :math:`ARMA(p,q)` process.
    timeGrid : :class:`~openturns.RegularGrid`
        Time grid of the :math:`ARMA(p,q)` process.

    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 20)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()
    >>> myProcessSample = myARMAProcess.getSample(20)

    Estimate the ARMA process specifying a range for the orders:

    >>> pIndices = [1, 2]
    >>> qIndices =  [4, 5]
    >>> myFactory_Range = ot.WhittleFactory(pIndices, qIndices)

    Print all the models and their state:

    >>> myWhittleHistory = myFactory_Range.getHistory()
    >>> for i in range(myWhittleHistory.getSize()):
    ...     model_i = myWhittleHistory[i]
    ...     arma = model_i.getARMA()
    ...     print('Order(p,q) = '+str(model_i.getP())+', '+str(model_i.getQ()))
    ...     print('AR coeff = '+str(model_i.getARCoefficients()))
    ...     print('MA coeff = '+str(model_i.getMACoefficients()))
    ...     print('White Noise - Sigma = '+str(model_i.getSigma2()))
    ...     print('Criteria AICc, AIC, BIC = '+str(model_i.getInformationCriteria()))
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WhittleFactoryState, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WhittleFactoryState, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhittleFactoryState_getClassName(self)

    def __repr__(self): return _model_process.WhittleFactoryState___repr__(self)
    def __str__(self, offset=""): return _model_process.WhittleFactoryState___str__(self, offset)
    def getP(self):
        """
        Accessor to AR order.

        Returns
        -------
        p : int
            Order of the AR part of the estimated model.

        """
        return _model_process.WhittleFactoryState_getP(self)

    def getQ(self):
        """
        Accessor to MA order.

        Returns
        -------
        q : int
            Order of the MA part of the estimated model.
        """
        return _model_process.WhittleFactoryState_getQ(self)

    def getTheta(self):
        """
        Accessor to the coefficients of the scalar ARMA process.

        Returns
        -------
        coeff : :class:`~openturns.NumericalPoint`
            The AR and MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getTheta(self)

    def getSigma2(self):
        """
        Accessor to the variance of the white noise.

        Parameters
        ----------
        sigma2 : positive float
            Variance of the white noise.
        """
        return _model_process.WhittleFactoryState_getSigma2(self)

    def getARCoefficients(self):
        """
        Accessor to the AR coefficients of the scalar ARMA process.

        Returns
        -------
        ARCoeff : :class:`~openturns.ARMACoefficients`
            The AR coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getARCoefficients(self)

    def getMACoefficients(self):
        """
        Accessor to the MA coefficients of the scalar ARMA process.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMACoefficients`
            The MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getMACoefficients(self)

    def getWhiteNoise(self):
        """
        Accessor to the white noise defining the scalar ARMA process.

        Returns
        -------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise of the estimated model.
        """
        return _model_process.WhittleFactoryState_getWhiteNoise(self)

    def getARMA(self):
        """
        Accessor to the estimated scalar ARMA.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMA`
            The estimated ARMA model.
        """
        return _model_process.WhittleFactoryState_getARMA(self)

    def getInformationCriteria(self):
        """
        Accessor to the values of the criteria *AIC*, :math:`AIC_c` and *BIC*.

        Returns
        -------
        criteria : :class:`~openturns.NumericalPoint` of  dimension 3
            Values of the criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* of the estimated model. 
        """
        return _model_process.WhittleFactoryState_getInformationCriteria(self)

    def getTimeGrid(self):
        """
        Accessor to the time grid of the scalar ARMA process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid` 
           Time grid over which the ARMA process is defined.
        """
        return _model_process.WhittleFactoryState_getTimeGrid(self)

    def __init__(self, *args): 
        this = _model_process.new_WhittleFactoryState(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_WhittleFactoryState
    __del__ = lambda self : None;
WhittleFactoryState_swigregister = _model_process.WhittleFactoryState_swigregister
WhittleFactoryState_swigregister(WhittleFactoryState)

class WhittleFactoryStateCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, WhittleFactoryStateCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, WhittleFactoryStateCollection, name)
    __swig_destroy__ = _model_process.delete_WhittleFactoryStateCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _model_process.WhittleFactoryStateCollection_clear(self)

    def __len__(self): return _model_process.WhittleFactoryStateCollection___len__(self)
    def __eq__(self, *args): return _model_process.WhittleFactoryStateCollection___eq__(self, *args)
    def __contains__(self, *args): return _model_process.WhittleFactoryStateCollection___contains__(self, *args)
    def __getitem__(self, *args): return _model_process.WhittleFactoryStateCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _model_process.WhittleFactoryStateCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _model_process.WhittleFactoryStateCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.WhittleFactoryStateCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.WhittleFactoryStateCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.WhittleFactoryStateCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.WhittleFactoryStateCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.WhittleFactoryStateCollection_isEmpty(self)

    def __repr__(self): return _model_process.WhittleFactoryStateCollection___repr__(self)
    def __str__(self, offset=""): return _model_process.WhittleFactoryStateCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _model_process.new_WhittleFactoryStateCollection(*args)
        try: self.this.append(this)
        except: self.this = this
WhittleFactoryStateCollection_swigregister = _model_process.WhittleFactoryStateCollection_swigregister
WhittleFactoryStateCollection_swigregister(WhittleFactoryStateCollection)

class WhittleFactoryStatePersistentCollection(openturns.common.PersistentObject,WhittleFactoryStateCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,WhittleFactoryStateCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WhittleFactoryStatePersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,WhittleFactoryStateCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WhittleFactoryStatePersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhittleFactoryStatePersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _model_process.new_WhittleFactoryStatePersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _model_process.WhittleFactoryStatePersistentCollection___repr__(self)
    def __str__(self, offset=""): return _model_process.WhittleFactoryStatePersistentCollection___str__(self, offset)
    __swig_destroy__ = _model_process.delete_WhittleFactoryStatePersistentCollection
    __del__ = lambda self : None;
WhittleFactoryStatePersistentCollection_swigregister = _model_process.WhittleFactoryStatePersistentCollection_swigregister
WhittleFactoryStatePersistentCollection_swigregister(WhittleFactoryStatePersistentCollection)

class WhittleFactory(ARMAFactoryImplementation):
    """
    Whittle estimator of a scalar ARMA normal process.

    Available constructors:
        WhittleFactory()

        WhittleFactory(*p, q, invert*)

        WhittleFactory(*indP, indQ, invertible*)


    Parameters
    ----------
    p : int
        Order of the AR part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    q : int
        Order of the MA part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    invertible : bool, optional
        Restrict the estimation to invertible ARMA processes.

        By default: True.
    indP : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.
    indQ : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.

    Notes
    -----
    We suppose here that the white noise is normal with zero mean and  variance :math:`\\sigma^2`. It implies that the ARMA process estimated is normal.

    For each order :math:`(p,q)`, the estimation of the coefficients :math:`(a_k)_{1\\leq k\\leq p}`, :math:`(b_k)_{1\\leq k\\leq q}` and the variance :math:`\\sigma^2` is done using the Whittle estimator which is based on the maximization of the likelihood function in the frequency domain. 

    The principle is detailed hereafter for the case of a time series : in the case of a process sample, the estimator is similar except for the periodogram which is computed differently.

    Let :math:`(t_i, \\vect{X}_i)_{0\\leq i \\leq n-1}` be a multivariate time series of dimension :math:`d` from an :math:`ARMA(p,q)` process. 

    The spectral density function of the :math:`ARMA(p,q)` process writes :

    .. math::

        f(\\lambda, \\vect{\\theta}, \\sigma^2) = \\frac{\\sigma^2}{2 \\pi} \\frac{|1 + b_1 \\exp(-i \\lambda) + \\ldots + b_q \\exp(-i q \\lambda)|^2}{|1 + a_1 \\exp(-i \\lambda) + \\ldots + a_p \\exp(-i p \\lambda)|^2} = \\frac{\\sigma^2}{2 \\pi} g(\\lambda, \\vect{\\theta})

    where  :math:`\\vect{\\theta} = (a_1, a_2,...,a_p,b_1,...,b_q)` and :math:`\\lambda` is the frequency value.

    The Whittle log-likelihood writes :

    .. math::

        \\log L_w(\\vect{\\theta}, \\sigma^2) = - \\sum_{j=1}^{m} \\log f(\\lambda_j,  \\vect{\\theta}, \\sigma^2) - \\frac{1}{2 \\pi} \\sum_{j=1}^{m} \\frac{I(\\lambda_j)}{f(\\lambda_j,  \\vect{\\theta}, \\sigma^2)}

    where :

    - :math:`I` is the non parametric estimate of the spectral density, expressed in the Fourier space (frequencies in :math:`[0,2\\pi]` instead of :math:`[-f_{max}, f_{max}]`). OpenTURNS uses by default the Welch estimator.

    - :math:`\\lambda_j` is the :math:`j-th` Fourier frequency, :math:`\\lambda_j = \\frac{2 \\pi j}{n}`, :math:`j=1 \\ldots m` with :math:`m` the largest integer  :math:`\\leq \\frac{n-1}{2}`.


    We estimate the :math:`(p+q+1)` scalar coefficients by maximizing the log-likelihood function. The corresponding equations lead to the following relation :

    .. math::

        \\sigma^{2*} = \\frac{1}{m} \\sum_{j=1}^{m} \\frac{I(\\lambda_j)}{g(\\lambda_j, \\vect{\\theta}^{*})}

    where :math:`\\vect{\\theta}^{*}` maximizes :

    .. math::

        \\log L_w(\\vect{\\theta}) = m (\\log(2 \\pi) - 1) - m \\log\\left( \\frac{1}{m} \\sum_{j=1}^{m} \\frac{I(\\lambda_j)}{g(\\lambda_j, \\vect{\\theta})}\\right) - \\sum_{j=1}^{m} g(\\lambda_j, \\vect{\\theta})

    The Whitle estimation requires that :

    - the determinant of the eigen values of the companion matrix associated to the polynomial  :math:`1 + a_1X + \\dots + a_pX^p` are  outside the unit disc, which garantees the stationarity of the process;

    - the determinant of the eigen values of thez companion matrix associated to the polynomial  :math:`1 + ba_1X + \\dots + b_qX^q` are outside the unit disc, which garantees the invertibility of the process.


    The criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* are evaluated to help the model selection:

    .. math::
        :nowrap:

        \\begin{eqnarray*}
            AIC_c  & = &  -2\\log L_w + 2(p + q + 1)\\frac{m}{m - p - q - 2}\\\\
            AIC & = & -2\\log L_w + 2(p + q + 1)\\\\
            BIC & = & -2\\log L_w + 2(p + q + 1)\\log(p + q + 1)
        \\end{eqnarray*}

    where :math:`m` is half the number of points of the time grid of the process sample (if the data are a process sample) or in a block of the time series (if the data are a time series).

    The *BIC* criterion leads to a model that gives a better prediction. The *AIC* criterion selects the best model that fits the given data. The :math:`AIC_c` criterion improves the previous one by penalizing a too high order that would artificially fit to the data.


    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 100)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()
    >>> myProcessSample = myARMAProcess.getSample(10)

    Estimate the ARMA process specifying the orders:

    >>> myFactory_42 = ot.WhittleFactory(4, 2)

    Check the default SpectralModelFactory:

    >>> #print(myFactory_42.getSpectralModelFactory())

    Set a particular spectral model: WelchFactory as SpectralModelFactory with the Hanning filtering window:

    >>> myFilteringWindow = ot. Hanning()
    >>> mySpectralFactory = ot.WelchFactory(myFilteringWindow, 4, 0)
    >>> myFactory_42.setSpectralModelFactory(mySpectralFactory)
    >>> #print(myFactory_42.getSpectralModelFactory())

    Estimate the ARMA process specifying a range for the orders:

    p = [1, 2, 4] and q = [4,5,6]:

    >>> pIndices = ot.Indices([1, 2, 4])
    >>> qIndices =  ot.Indices(3)
    >>> qIndices.fill(4,1)
    >>> myFactory_Range = ot.WhittleFactory(pIndices, qIndices)

    To get the quantified AICc, AIC and BIC criteria:

    >>> myCriterion = ot.NumericalPoint()
    >>> myARMA_42 = myFactory_42.build(ot.TimeSeries(myTimeSeries), myCriterion)
    >>> AICc, AIC, BIC = myCriterion[0:3]
    """
    __swig_setmethods__ = {}
    for _s in [ARMAFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WhittleFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [ARMAFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WhittleFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhittleFactory_getClassName(self)

    def __repr__(self): return _model_process.WhittleFactory___repr__(self)
    def __str__(self, offset=""): return _model_process.WhittleFactory___str__(self, offset)
    def getSpectralModelFactory(self):
        """
        Accessor to the spectral factory.

        Returns
        -------
        initARCoeff : :class:`~openturns.SpectralModelFactory`
            The spectral factory used to estimate the spectral density based on the data.

        """
        return _model_process.WhittleFactory_getSpectralModelFactory(self)

    def setSpectralModelFactory(self, *args):
        """
        Accessor to the spectral factory.

        Parameters
        ----------
        spectralModelFact : :class:`~openturns.SpectralModelFactory`
            The spectral factory used to estimate the spectral density based on the data.

        """
        return _model_process.WhittleFactory_setSpectralModelFactory(self, *args)

    def build(self, *args):
        """
        Estimate the ARMA process.

        Available usages:
            build(*myTimeSeries, criterion*)

            build(*myProcessSample, criterion*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        criterion : :class:`~openturns.NumericalPoint` with the default implementation, optional
            To get the evaluation of the AICc, AIC and BIC criteria
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The  process estimated with the Whittle estimator.

        Notes
        -----
        The model selection is made using the spectral density built using the given data and theoretical spectral density of the ARMA process.

        The best ARMA process is selected according to the corrected AIC criterion.

        """
        return _model_process.WhittleFactory_build(self, *args)

    def getVerbose(self):
        """
        Accessor to the verbose mode.

        Returns
        -------
        verboseMode : bool
            Get the verbose mode while both the exploration of the possible models and the optimization steps.

        """
        return _model_process.WhittleFactory_getVerbose(self)

    def setVerbose(self, *args):
        """
        Accessor to the verbose mode.

        Parameters
        ----------
        verboseMode : bool
            Set the verbose mode while both the exploration of the possible models and the optimization steps.

        """
        return _model_process.WhittleFactory_setVerbose(self, *args)

    def enableHistory(self):
        """
        Activate the history of all the estimated models.

        Notes
        -----
        Activate the history mechanism which is the trace of all the tested models and their associated information criteria.

        By default, the history mecanism is activated.

        """
        return _model_process.WhittleFactory_enableHistory(self)

    def disableHistory(self):
        """
        Desactivate the history of all the estimated models.

        Notes
        -----
        Desactivate the history mechanism which is the trace of all the tested models and their associated information criteria.

        """
        return _model_process.WhittleFactory_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Check whether the history mecanism is activated.

        Returns
        -------
        histMec : bool
            Check whether the history mecanism is activated.

            By default, the history mecanism is activated.

        """
        return _model_process.WhittleFactory_isHistoryEnabled(self)

    def clearHistory(self):
        """
        Clear the history of the factory.

        Notes
        -----
        Clear the history of the factory.

        """
        return _model_process.WhittleFactory_clearHistory(self)

    def getHistory(self):
        """
        Check whether the history mecanism is activated.

        Returns
        -------
        histMec : a list of :class:`~openturns.WhittleFactoryState`
            Returns the collection of all the states that have been built for the estimation.

        """
        return _model_process.WhittleFactory_getHistory(self)

    def setStartingPoints(self, *args):
        """
        Accessor to the starting points for the optimization step.

        Parameters
        ----------
        startPointsList : a list of :class:`~openturns.NumericalPoint`
            Starting points for the optimization step, for each pair of orders that will be tested.

        """
        return _model_process.WhittleFactory_setStartingPoints(self, *args)

    def getStartingPoints(self):
        """
        Accessor to the starting points for the optimization step.

        Returns
        -------
        startPointsList : a list of :class:`~openturns.NumericalPoint`
            Starting points for the optimization step, for each pair of orders that will be tested.

        """
        return _model_process.WhittleFactory_getStartingPoints(self)

    def __init__(self, *args): 
        this = _model_process.new_WhittleFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_WhittleFactory
    __del__ = lambda self : None;
WhittleFactory_swigregister = _model_process.WhittleFactory_swigregister
WhittleFactory_swigregister(WhittleFactory)

class ARMALikelihoodFactory(ARMAFactoryImplementation):
    """
    Maximum likelihood estimator of a multivariate ARMA normal process.

    Available constructors:
        ARMALikelihoodFactory()

        ARMALikelihoodFactory(*p, q, d, invertible*)

        ARMALikelihoodFactory(*indP, indQ, d, invertible*)


    Parameters
    ----------
    p : int
        Order of the AR part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    q : int
        Order of the MA part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    d : int, :math:`d \\geq 1`
        Dimension of the process.
    invertible : bool, optional
        Restrict the estimation to invertible ARMA processes.

        By default: True.
    indP : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.
    indQ : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.

    Notes
    -----
    We suppose here that the white noise is normal with zero mean and  covariance matrix :math:`\\mat{\\Sigma}_{\\varepsilon} = \\sigma^2\\mat{Q}` where :math:`|\\mat{Q}| = 1`. It implies that the ARMA process estimated is normal.

    Let :math:`(t_i, \\vect{X}_i)_{0\\leq i \\leq n-1}` be a multivariate time series of dimension :math:`d` from an :math:`ARMA(p,q)` process. 

    If we note :math:`\\vect{W} = (\\vect{X}_0, \\hdots, \\vect{X}_{n-1})`, then :math:`\\vect{W}` is normal with zero mean. Its  covariance matrix writes :math:`\\mathbb{E}(\\vect{W}\\Tr{\\vect{W}})= \\sigma^2 \\Sigma_{\\vect{W}}` which depends on the coefficients :math:`(\\mat{A}_k, \\mat{B}_l)` for :math:`k = 1,\\ldots,p` and :math:`l = 1,\\ldots, q` and on the matrix :math:`\\mat{Q}`.

    The likelihood of :math:`\\vect{W}` writes :

    .. math::

        L(\\vect{\\beta}, \\sigma^2 | \\vect{W}) = (2 \\pi \\sigma^2) ^{-\\frac{d n}{2}} |\\Sigma_{w}|^{-\\frac{1}{2}} \\exp\\left(- (2\\sigma^2)^{-1}  \\Tr{\\vect{W}} \\Sigma_{\\vect{W}}^{-1}  \\vect{W} \\right)

    where  :math:`\\vect{\\beta} = (\\mat{A}_{k}, \\mat{B}_{l}, \\mat{Q}),\\ k = 1,\\ldots,p`, :math:`l = 1,\\ldots, q` and where  :math:`|.|` denotes the determinant.

    No evaluation of selection criteria such as AIC or BIC is done.

    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 50)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()

    Estimate the ARMA process with the maximum likelihood estimator:

    >>> myFactory = ot.ARMALikelihoodFactory(4, 2, 1)
    >>> myARMA = myFactory.build(ot.TimeSeries(myTimeSeries))
    """
    __swig_setmethods__ = {}
    for _s in [ARMAFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMALikelihoodFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [ARMAFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMALikelihoodFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMALikelihoodFactory_getClassName(self)

    def __repr__(self): return _model_process.ARMALikelihoodFactory___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMALikelihoodFactory___str__(self, offset)
    def setInitialARCoefficients(self, *args):
        """
        Accessor to the initial AR coefficients.

        Parameters
        ----------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialARCoefficients(self, *args)

    def setInitialMACoefficients(self, *args):
        """
        Accessor to the initial MA coefficients.

        Parameters
        ----------
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial MA coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialMACoefficients(self, *args)

    def setInitialCovarianceMatrix(self, *args):
        """
        Accessor to the initial covariance matrix of the white noise.

        Parameters
        ----------
        initCovMat : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialCovarianceMatrix(self, *args)

    def setInitialConditions(self, *args):
        """
        Accessor to the initial AR coefficients.

        Parameters
        ----------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.
        initCovMatr : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialConditions(self, *args)

    def getInitialARCoefficients(self):
        """
        Accessor to the initial AR coefficients.

        Returns
        -------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialARCoefficients(self)

    def getInitialMACoefficients(self):
        """
        Accessor to the initial MA coefficients.

        Returns
        -------
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial MA coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialMACoefficients(self)

    def getInitialCovarianceMatrix(self):
        """
        Accessor to the initial covariance matrix of the white noise.

        Returns
        -------
        initCovMat : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialCovarianceMatrix(self)

    def build(self, *args):
        """
        Estimate the ARMA process.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The  process estimated with the maximum likelihood estimator.

        """
        return _model_process.ARMALikelihoodFactory_build(self, *args)

    def getVerbose(self):
        """
        Accessor to the verbose mode.

        Returns
        -------
        verboseMode : bool
            Get the verbose mode while both the exploration of the possible models and the optimization steps.

        """
        return _model_process.ARMALikelihoodFactory_getVerbose(self)

    def setVerbose(self, *args):
        """
        Accessor to the verbose mode.

        Parameters
        ----------
        verboseMode : bool
            Set the verbose mode while both the exploration of the possible models and the optimization steps.

        """
        return _model_process.ARMALikelihoodFactory_setVerbose(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ARMALikelihoodFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMALikelihoodFactory
    __del__ = lambda self : None;
ARMALikelihoodFactory_swigregister = _model_process.ARMALikelihoodFactory_swigregister
ARMALikelihoodFactory_swigregister(ARMALikelihoodFactory)

class ARMAFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMAFactoryImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMAFactoryImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _model_process.new_ARMAFactoryImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _model_process.ARMAFactoryImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_process.ARMAFactoryImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_process.ARMAFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _model_process.ARMAFactoryImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _model_process.delete_ARMAFactoryImplementationTypedInterfaceObject
    __del__ = lambda self : None;
ARMAFactoryImplementationTypedInterfaceObject_swigregister = _model_process.ARMAFactoryImplementationTypedInterfaceObject_swigregister
ARMAFactoryImplementationTypedInterfaceObject_swigregister(ARMAFactoryImplementationTypedInterfaceObject)

class ARMAFactory(ARMAFactoryImplementationTypedInterfaceObject):
    """Base class for ARMA models factory."""
    __swig_setmethods__ = {}
    for _s in [ARMAFactoryImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ARMAFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [ARMAFactoryImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ARMAFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAFactory_getClassName(self)

    def __repr__(self): return _model_process.ARMAFactory___repr__(self)
    def __str__(self, offset=""): return _model_process.ARMAFactory___str__(self, offset)
    def build(self, *args):
        """
        Estimate the ARMA model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the ARMA model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the ARMA model is estimated.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The estimated spectral model.
         
        """
        return _model_process.ARMAFactory_build(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ARMAFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ARMAFactory
    __del__ = lambda self : None;
ARMAFactory_swigregister = _model_process.ARMAFactory_swigregister
ARMAFactory_swigregister(ARMAFactory)

class ConditionedNormalProcess(TemporalNormalProcess):
    """
    Conditioned normal process.

        ConditionedNormalProcess(*krigingResult, mesh*)


    Parameters
    ----------
    krigingResult : :class:`~openturns.KrigingResult`
        Structure that contains all elements of kriging computations.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\\cM` over which the domain :math:`\\cD` is discretized.

    Notes
    -----
    ConditionedNormalProcess helps to create Gaussian random fields,
    :math:`X: \\Omega \\times\\cD \\mapsto \\Rset^d` where :math:`\\cD \\in \\Rset^n`, with covariance function :math:`\\cC: \\cD \\times \\cD \\mapsto \\cM_{d \\times d}(\\Rset)` ( :math:`\\cC^{stat}: \\cD \\mapsto \\cM_{d \\times d}(\\Rset)` in the stationary case), conditionaly to some observations.

          Let :math:`X(\\omega,x=x_1)=y_1,\\cdots,X(\\omega,x=x_n)=y_n` be the observations of the Gaussian process. We assume the same Gaussian prior as in the :class:`~openturns.KrigingAlgorithm`:

    .. math::

        Y(\\vect{x}) = \\Tr{\\vect{f}(\\vect{x})} \\vect{\\beta} + Z(\\vect{x})

    with :math:`\\Tr{\\vect{f}(\\vect{x})} \\vect{\\beta}` a generalized linear model, :math:`Z(\\vect{x})` a zero-mean Gaussian process with a stationary autocorrelation function :math:`\\cC^{stat}`:

    .. math::

        \\mathbb{E}[Z(\\vect{x}), Z(\\vect{\\tilde{x}})] = \\sigma^2 \\cC^{stat}_{\\theta}(\\vect{x} - \\vect{\\tilde{x}})

    The ConditionedNormalProcess generates realizations of the conditioned process. It focuses first on the :class:`~openturns.KrigingAlgorithm` to build such prior. Results are stored in a :class:`~openturns.KrigingResult` structure, which is given as input argument of the class. This last one, combined with the mesh argument, define both the prior  :math:`Y(\\cM)` and the covariance evaluation on the mesh vertices :math:`\\cC^{stat}_{\\theta}(\\cM)` conditionnaly to the previous observations. It follows that the realizations are randomly generated from the Gaussian distribution :math:`\\cN ( Y(\\cM), \\cC^{stat}_{\\theta}(\\cM) )`.

    In practice, we do not store the Gaussian distribution as we need only the random realization method. For that purpose, we use the Cholesky method : we compute the Cholesky factor :math:`\\cL_{\\theta}(\\cM)` of the covariance matrix :math:`\\cC^{stat}_{\\theta}(\\cM)` such as :math:`\\cC^{stat}_{\\theta}(\\cM) = \\cL_{\\theta}(\\cM) \\Tr{\\cL_{\\theta}(\\cM)}`.
    It follows that the random realizations are obtained as following : :math:`realization = Y(\\cM) + \\cL_{\\theta}(\\cM) W` with :math:`W` a centered & reduced random Gaussian realization.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Kriging use case
    >>> # Learning data
    >>> levels = [8.0, 5.0]
    >>> box = ot.Box(levels)
    >>> inputSample = box.generate()
    >>> # Scale each direction
    >>> inputSample *= 10
    >>> # Define model
    >>> model = ot.NumericalMathFunction(['x', 'y'], ['z'], ['cos(0.5*x) + sin(y)'])
    >>> outputSample = model(inputSample)
    >>> # Definition of exponential model
    >>> spatialDimension = 2
    >>> covarianceModel = ot.SquaredExponential([1.988, 0.924], [3.153])
    >>> # Basis definition
    >>> basis = ot.ConstantBasisFactory(spatialDimension).build()
    >>> # Kriring algorithm
    >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, basis, covarianceModel)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> vertices = [[1.0, 0.0], [2.0, 0.0], [2.0, 1.0], [1.0, 1.0], [1.5, 0.5]]
    >>> simplices = ot.IndicesCollection([[0, 1, 4], [1, 2, 4], [2, 3, 4], [3, 0, 4]])
    >>> mesh2D = ot.Mesh(vertices, simplices)
    >>> process = ot.ConditionedNormalProcess(result, mesh2D)
    """
    __swig_setmethods__ = {}
    for _s in [TemporalNormalProcess]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConditionedNormalProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [TemporalNormalProcess]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConditionedNormalProcess, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ConditionedNormalProcess_getClassName(self)

    def __repr__(self): return _model_process.ConditionedNormalProcess___repr__(self)
    def __str__(self, offset=""): return _model_process.ConditionedNormalProcess___str__(self, offset)
    def getRealization(self):
        """
        Return a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            A realization of the process.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> # Kriging use case
        >>> # Learning data
        >>> levels = [8.0, 5.0]
        >>> box = ot.Box(levels)
        >>> inputSample = box.generate()
        >>> # Scale each direction
        >>> inputSample *= 10
        >>> # Define model
        >>> model = ot.NumericalMathFunction(['x', 'y'], ['z'], ['cos(0.5*x) + sin(y)'])
        >>> outputSample = model(inputSample)
        >>> # Definition of exponential model
        >>> spatialDimension = 2
        >>> covarianceModel = ot.SquaredExponential(spatialDimension *[0.95])
        >>> # Basis definition
        >>> basis = ot.ConstantBasisFactory(spatialDimension).build()
        >>> # Kriring algorithm
        >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, basis, covarianceModel)
        >>> algo.run()
        >>> result = algo.getResult()
        >>> vertices = [[1.0, 0.0], [2.0, 0.0], [2.0, 1.0],[1.0, 1.0], [1.5, 0.5]]
        >>> simplices = ot.IndicesCollection([[0, 1, 4], [1, 2, 4], [2, 3, 4], [3, 0, 4]])
        >>> mesh2D = ot.Mesh(vertices, simplices)
        >>> process = ot.ConditionedNormalProcess(result, mesh2D)
        >>> # Get a realization of the process
        >>> realization = process.getRealization()

        """
        return _model_process.ConditionedNormalProcess_getRealization(self)

    def isNormal(self):
        """
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \\in \\Nset` and
        :math:`I_k \\in \\Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\\vect{m}_1, \\dots, \\vect{m}_k \\in \\Rset^d` and
        :math:`\\mat{C}_{1,\\dots,k}\\in\\mathcal{M}_{kd,kd}(\\Rset)` such that:

        .. math::

            \\Expect{\\exp\\left\\{i\\Tr{\\vect{X}}_{I_k} \\vect{U}_{k}  \\right\\}} =
            \\exp{\\left\\{i\\Tr{\\vect{U}}_{k}\\vect{M}_{k}-\\frac{1}{2}\\Tr{\\vect{U}}_{k}\\mat{C}_{1,\\dots,k}\\vect{U}_{k}\\right\\}}

        where :math:`\\Tr{\\vect{X}}_{I_k} = (\\Tr{X}_{\\vect{t}_1}, \\hdots, \\Tr{X}_{\\vect{t}_k})`,
        :math:`\\\\Tr{vect{U}}_{k} = (\\Tr{\\vect{u}}_{1}, \\hdots, \\Tr{\\vect{u}}_{k})` and
        :math:`\\Tr{\\vect{M}}_{k} = (\\Tr{\\vect{m}}_{1}, \\hdots, \\Tr{\\vect{m}}_{k})` and
        :math:`\\mat{C}_{1,\\dots,k}` is the symmetric matrix:

        .. math::

          \\mat{C}_{1,\\dots,k} = \\left(
          \\begin{array}{cccc}
            C(\\vect{t}_1, \\vect{t}_1) &C(\\vect{t}_1, \\vect{t}_2) & \\hdots & C(\\vect{t}_1, \\vect{t}_{k}) \\\\
            \\hdots & C(\\vect{t}_2, \\vect{t}_2)  & \\hdots & C(\\vect{t}_2, \\vect{t}_{k}) \\\\
            \\hdots & \\hdots & \\hdots & \\hdots \\\\
            \\hdots & \\hdots & \\hdots & C(\\vect{t}_{k}, \\vect{t}_{k})
          \\end{array}
          \\right)

        A normal process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.ConditionedNormalProcess_isNormal(self)

    def isStationary(self):
        """
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\\forall k \\in \\Nset`,
        :math:`\\forall (\\vect{t}_1, \\dots, \\vect{t}_k) \\in \\cD`,
        :math:`\\forall \\vect{h}\\in \\Rset^n`, we have:

        .. math::

            (X_{\\vect{t}_1}, \\dots, X_{\\vect{t}_k})
            \\stackrel{\\mathcal{D}}{=} (X_{\\vect{t}_1+\\vect{h}}, \\dots, X_{\\vect{t}_k+\\vect{h}})

        """
        return _model_process.ConditionedNormalProcess_isStationary(self)

    def setMesh(self, *args):
        """
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _model_process.ConditionedNormalProcess_setMesh(self, *args)

    def setTimeGrid(self, *args):
        """
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.ConditionedNormalProcess_setTimeGrid(self, *args)

    def setSamplingMethod(self, *args):
        """
        Set the used method for getRealization.

        Available parameters are :

          * 0 : Cholesky factor sampling (default method)

          * 1 : H-Matrix method (if H-Mat available)

          * 2 : Gibbs method (in dimension 1 only)

        Parameters
        ----------
        samplingMethod : int
            Fix a method for sampling.


        """
        return _model_process.ConditionedNormalProcess_setSamplingMethod(self, *args)

    def __init__(self, *args): 
        this = _model_process.new_ConditionedNormalProcess(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_ConditionedNormalProcess
    __del__ = lambda self : None;
ConditionedNormalProcess_swigregister = _model_process.ConditionedNormalProcess_swigregister
ConditionedNormalProcess_swigregister(ConditionedNormalProcess)

class KarhunenLoeveQuadratureFactory(openturns.common.PersistentObject):
    """
    Computation of Karhunen-Loeve decomposition using Quadrature approximation.

    Parameters
    ----------
    domain : :class:`~openturns.Domain`
        The domain on which the Fredholm equation is defined.
    experiment : :class:`~openturns.WeightedExperiment`
        The algorithm used to discretize the integrale defining the Fredholm equation.
    basis : :class:`~openturns.Basis`
        The basis from which the base functions are taken to define the finite space on which live the approximate eigenfunctions.
    basisSize : int
        The dimension of the finite approximation space.
    mustScale : bool
        Flag to tell if a scaling function has to be inserted in the base functions.
    threshold : float
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue.

    Notes
    -----
    The Karhunen-Loeve decomposition using Quadrature approximation allows to approximate the solution of the second kind Fredholm equation:

    .. math::

        \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t})\\vect{\\phi}_n(\\vect{s})\\di{\\vect{s}}=\\lambda_n\\vect{\\phi}_n(\\vect{t})


    with :math:`\\mat{C}: \\cD\\times\\cD \\mapsto \\cS^+_d(\\Rset)` a given covariance function, :math:`\\lambda_n` a nonincreasing sequence of nonnegative values (the **eigenvalues** of the equation) and :math:`\\vect{\\phi}_n: \\cD\\mapsto\\Rset^d` the associated sequence of **eigenfunctions**, normalized by :math:`\\int_{\\cD_N}\\|\\vect{\\phi}_n(\\vect{s})\\|^2\\di{\\vect{s}}=1`.

    The Karhunen-Loeve quadrature approximation consists in replacing the integrals defining the Fredholm equation by its quadrature approximation counterpart:

    .. math::
       \\int_{\\Rset^d} \\mat{C}(\\vect{s},\\vect{t})\\vect{\\phi}_n(\\vect{s})\\di{\\vect{s}}\\simeq\\sum_{\\ell=1}^L\\omega_{\\ell}\\mat{C}(\\vect{\\xi}_{\\ell},\\vect{t})\\vect{\\phi}_n(\\vect{\\xi}_{\\ell})\\dfrac{\\fcar{\\vect{\\xi}_{\\ell}}{\\cD}}{p(\\vect{\\xi}_{\\ell})}

    Where :math:`(\\omega_{\\ell},\\vect{\\xi}_{\\ell})_{\\ell=1,\\dots,L}` is a quadrature formula wrt the density function :math:`p` such that its support contains :math:`\\cD`, ie the discrete measure :math:`\\sum_{\\ell=1}^L\\omega_{\\ell}\\delta_{\\vect{\\xi}_{\\ell}}` is an approximation of the probability measure defined by :math:`p`.

    The eigenfunctions :math:`\\phi_n` are decomposed into a functional basis :math:`(\\theta_p)_{p=1,\\dots,P}`:

    .. math::
        \\forall \\vect{s}\\in\\cD,\\quad \\phi_n(\\vect{s})=\\sum_{p=1}^P\\vect{\\alpha}_n^p\\theta_p(\\vect{s})

    and the associated coefficients are found using a Galerkin projection on the space generated by :math:`(\\theta_p)_{p=1,\\dots,P}`.
       

    Examples
    --------
    Create a Karhunen-Loeve Quadrature factory:

    >>> import openturns as ot
    >>> domain = ot.Interval([-1.0]*2, [1.0]*2)
    >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()]*2)
    >>> basisSize = 10
    >>> samplingSize = 20
    >>> experiment = ot.LHSExperiment(basis.getMeasure(), samplingSize)
    >>> mustScale = False
    >>> threshold = 0.01
    >>> factory = ot.KarhunenLoeveQuadratureFactory(domain, experiment, basis, basisSize, mustScale, threshold)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveQuadratureFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveQuadratureFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.KarhunenLoeveQuadratureFactory_getClassName(self)

    def build(self, *args):
        """
        Computation of the eigenvalues and eigen functions.

        Parameters
        ----------
        C : :class:`~openturns.CovarianceModel`, :math:`\\mat{C}: \\cD\\times\\cD \\mapsto \\cS^+_d(\\Rset)`
            The covariance model.
        ev : :class:`~openturns.NumericalPoint`
            The eigenvalues :math:`\\lambda_n` in descending order such that :math:`\\lambda_n/\\lambda_0\\geq\\mathrm{threshold}`

        Returns
        -------
        functions : :class:`~openturns.Basis`
            Eigen functions of the covariance model as a basis of functions using :class:`~openturns.QuadratureLagrangeEvaluationImplementation`.

        Examples
        --------
        >>> import openturns as ot
        >>> domain = ot.Interval([-1.0]*2, [1.0]*2)
        >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()]*2)
        >>> basisSize = 10
        >>> samplingSize = 20
        >>> experiment = ot.LHSExperiment(basis.getMeasure(), samplingSize)
        >>> mustScale = False
        >>> threshold = 0.01
        >>> factory = ot.KarhunenLoeveQuadratureFactory(domain, experiment, basis, basisSize, mustScale, threshold)
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> ev = ot.NumericalPoint()
        >>> functions = factory.build(model, ev)
        """
        return _model_process.KarhunenLoeveQuadratureFactory_build(self, *args)

    def __repr__(self): return _model_process.KarhunenLoeveQuadratureFactory___repr__(self)
    def __str__(self, offset=""): return _model_process.KarhunenLoeveQuadratureFactory___str__(self, offset)
    def __init__(self, *args): 
        this = _model_process.new_KarhunenLoeveQuadratureFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_KarhunenLoeveQuadratureFactory
    __del__ = lambda self : None;
KarhunenLoeveQuadratureFactory_swigregister = _model_process.KarhunenLoeveQuadratureFactory_swigregister
KarhunenLoeveQuadratureFactory_swigregister(KarhunenLoeveQuadratureFactory)

class KarhunenLoeveQuadratureAlgorithm(openturns.algo.KarhunenLoeveAlgorithmImplementation):
    """
    Computation of Karhunen-Loeve decomposition using Quadrature approximation.

    Available constructors:
        KarhunenLoeveQuadratureAlgorithm(*domain, covariance, experiment, basis, basisSize, mustScale, threshold*)

        KarhunenLoeveQuadratureAlgorithm(*domain, covariance, marginalDegree, threshold*)

    Parameters
    ----------
    domain : :class:`~openturns.Domain`
        The domain on which the covariance model and the Karhunen-Loeve eigenfunctions (modes) are discretized.
    covariance : :class:`~openturns.CovarianceModel`
        The covariance function to decompose.
    experiment : :class:`~openturns.WeightedExperiment`
        The points and weights used in the quadrature approximation.
    basis : :class:`~openturns.Basis`
        The basis in wich the eigenfunctions are projected.
    basisSize : integer
        The number of elements of the basis considered.
    marginalDegree : integer
        The maximum degree to take into account in the tensorized Legendre basis.
    mustScale : boolean
        Flag to tell if the bounding box of the weighted experiment and the domain have to be maped or not.
    threshold : float
        The minimal relative amplitude of the eigenvalues to consider in the decomposition wrt the maximum eigenvalue. Default value is 0.

    Notes
    -----
    We suppose that :math:`C:\\cD \\times \\cD \\rightarrow  \\cS^+_d(\\Rset)` is a covariance function defined on :math:`\\cD \\in \\Rset^n`, continuous at :math:`\\vect{0}`. 

    The class :class:`~openturns.KarhunenLoeveQuadratureAlgorithm` enables to determine the solutions of the second kind Fredholm equation associated to  :math:`C`, ie to find the :math:`(\\lambda_k,  \\vect{\\varphi}_k)_{k \\geq 1}` such that: 

    .. math::
        :label: fredholmQuadrature

        \\int_{\\cD} \\mat{C}(\\vect{s},\\vect{t}) \\vect{\\varphi}_k(\\vect{t})\\,  d\\vect{t} = \\lambda_k  \\vect{\\varphi}_k(\\vect{s}) \\quad \\forall \\vect{s} \\in \\cD


    where :math:`(\\lambda_k)_{k \\geq 1}` is a nonincreasing sequence of nonnegative values (the **eigenvalues**) and :math:`(\\vect{\\varphi}_k)_{k \\geq 1}` the   associated sequence of **eigenfunctions**, normalized by :math:`\\int_{\\cD}\\|\\vect{\\varphi}_k(\\vect{s})\\|^2\\di{\\vect{s}}=1`. They constitue an hilbertian basis of :math:`L^2(\\cD, \\Rset^d)`.

    OpenTURNS uses the threshold :math:`s` in order to select the most significant eigenvalues, ie all the eigenvalues such that :math:`\\lambda_k \\geq s \\lambda_1`.

    The Karhunen-Loeve Quadrature approximation consists in replacing the integral of :eq:`fredholmQuadrature` by a quadrature approximation: if :math:`(\\omega_\\ell, \\vect{\\xi}_\\ell)_{1 \\leq \\ell \\leq L}` is the weighted experiment (see :class:`~openturns.WeightedExperiment`) associated to the measure :math:`\\mu`, then for all functions measurable wrt :math:`\\mu`, we have:

    .. math::

        \\int_{\\Rset^n} f(\\vect{x}) \\mu(\\vect{x})\\, d\\vect{x} \\simeq \\sum_{\\ell=1}^{\\ell=L} \\omega_\\ell f(\\vect{\\xi}_\\ell)

    If we note :math:`\\eta_{\\ell}=\\omega_{\\ell}\\dfrac{1_{\\cD}(\\vect{\\xi}_{\\ell})}{\\mu(\\vect{\\xi}_{\\ell})}`, we build a more general quadrature approximation :math:`(\\eta_\\ell, \\xi_\\ell)_{1 \\leq l \\leq L}` such that:

    .. math::

        \\int_{\\cD} f(\\vect{t})  \\, d\\vect{t} \\simeq \\sum_{\\ell=1}^L \\eta_\\ell f(\\vect{\\xi}_\\ell)

    where only the points :math:`\\vect{\\xi}_\\ell \\in \\cD` are considered. 

    The second constructor is a short-hand to the first one, where *basis* is the tensorized Legendre basis, see :class:`~openturns.OrthogonalProductPolynomialFactory` and :class:`~openturns.LegendreFactory`, *experiment* is a tensorized Gauss-Legendre quadrature, see :class:`~openturns.GaussProductExperiment`, *basisSize* is equal to *marginalDegree* to the power the dimension of *domain* and *mustScale* is set to *True*.

    Examples
    --------
    Discretize the domain :math:`\\cD` and create a covariance model:

    >>> import openturns as ot
    >>> domain = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
    >>> threshold = 0.01
    >>> model = ot.AbsoluteExponential([1.0]*2)

    Give the basis used to decompose the eigenfunctions: 

    here, the 10 first Legendre polynomials family:

    >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()]*2)
    >>> basisSize = 10

    Create the weighted experiment of the quadrature approximation: 

    here, a Monte Carlo experiment from the measure orthogonal wrt the Legendre polynomials family:

    >>> experiment = ot.MonteCarloExperiment(basis.getMeasure(), 1000)

    Create the Karhunen-Loeve Quadrature algorithm:

    >>> algorithm = ot.KarhunenLoeveQuadratureAlgorithm(domain, model, experiment, basis, basisSize, True, threshold)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.algo.KarhunenLoeveAlgorithmImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, KarhunenLoeveQuadratureAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.algo.KarhunenLoeveAlgorithmImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, KarhunenLoeveQuadratureAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getClassName(self)

    def run(self):
        """
        Computation of the eigenvalues and eigenfunctions values at the quadrature points.

        Examples
        --------
        >>> import openturns as ot
        >>> domain = ot.Interval([-1.0]*2, [1.0]*2)
        >>> threshold = 0.01
        >>> model = ot.AbsoluteExponential([1.0]*2)
        >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()]*2)
        >>> experiment = ot.MonteCarloExperiment(basis.getMeasure(), 1000)
        >>> algorithm = ot.KarhunenLoeveQuadratureAlgorithm(domain, model, experiment, basis, 10, True, threshold)
        >>> algorithm.run()
        >>> result = algorithm.getResult()
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_run(self)

    def getDomain(self):
        """
        Accessor to the domain.

        Returns
        -------
        domain : :class:`~openturns.Domain`
        The domain  :math:`\\cD_N` that discretizes the domin :math:`\\cD`.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getDomain(self)

    def getExperiment(self): return _model_process.KarhunenLoeveQuadratureAlgorithm_getExperiment(self)
    def getBasis(self): return _model_process.KarhunenLoeveQuadratureAlgorithm_getBasis(self)
    def getBasisSize(self): return _model_process.KarhunenLoeveQuadratureAlgorithm_getBasisSize(self)
    def getMustScale(self): return _model_process.KarhunenLoeveQuadratureAlgorithm_getMustScale(self)
    def __repr__(self): return _model_process.KarhunenLoeveQuadratureAlgorithm___repr__(self)
    def __str__(self, offset=""): return _model_process.KarhunenLoeveQuadratureAlgorithm___str__(self, offset)
    def __init__(self, *args): 
        this = _model_process.new_KarhunenLoeveQuadratureAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _model_process.delete_KarhunenLoeveQuadratureAlgorithm
    __del__ = lambda self : None;
KarhunenLoeveQuadratureAlgorithm_swigregister = _model_process.KarhunenLoeveQuadratureAlgorithm_swigregister
KarhunenLoeveQuadratureAlgorithm_swigregister(KarhunenLoeveQuadratureAlgorithm)

# This file is compatible with both classic and new-style classes.


