# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Graphical output.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_graph', [dirname(__file__)])
        except ImportError:
            import _graph
            return _graph
        if fp is not None:
            try:
                _mod = imp.load_module('_graph', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _graph = swig_import_helper()
    del swig_import_helper
else:
    import _graph
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _graph.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _graph.SwigPyIterator_value(self)
    def incr(self, n=1): return _graph.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _graph.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _graph.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _graph.SwigPyIterator_equal(self, *args)
    def copy(self): return _graph.SwigPyIterator_copy(self)
    def next(self): return _graph.SwigPyIterator_next(self)
    def __next__(self): return _graph.SwigPyIterator___next__(self)
    def previous(self): return _graph.SwigPyIterator_previous(self)
    def advance(self, *args): return _graph.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _graph.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _graph.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _graph.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _graph.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _graph.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _graph.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _graph.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _graph.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
class DrawableImplementation(openturns.common.PersistentObject):
    """
    Drawable object.

    Notes
    -----
    In OpenTURNS a Drawable is a drawable element described by:

    - its data,
    - its attributes: color, line stype, point style, fill style, legend ...

    The different drawable elements are:

    - :class:`~openturns.BarPlot`

    - :class:`~openturns.Cloud`

    - :class:`~openturns.Contour`

    - :class:`~openturns.Curve`

    - :class:`~openturns.Pairs`

    - :class:`~openturns.Pie`

    - :class:`~openturns.Polygon`

    - :class:`~openturns.Staircase`

    - :class:`~openturns.Text`

    Examples
    --------
    >>> import openturns as ot
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, 'topright')
    >>> sample = ot.Normal([0.0,0.0], [1.0,1.0], ot.CorrelationMatrix(2)).getSample(10)
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'A Cloud')
    >>> myGraph.add(myCloud)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DrawableImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DrawableImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.DrawableImplementation_getClassName(self)

    def __repr__(self): return _graph.DrawableImplementation___repr__(self)
    def __str__(self, offset=""): return _graph.DrawableImplementation___str__(self, offset)
    def __eq__(self, *args): return _graph.DrawableImplementation___eq__(self, *args)
    def getPointCode(self, *args):
        """
        Accessor to the code of the points style.

        Parameters
        ----------
        pointStyle : str
            Style point to be changed in code.

        Returns
        -------
        code : int
            Code of the style of the points within the drawable element.
        """
        return _graph.DrawableImplementation_getPointCode(self, *args)

    def getLegend(self):
        """
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementation_getLegend(self)

    def setLegend(self, *args):
        """
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementation_setLegend(self, *args)

    def getData(self):
        """
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.NumericalSample`
            Data from which the Drawable is built.
        """
        return _graph.DrawableImplementation_getData(self)

    def getLineStyle(self):
        """
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph.DrawableImplementation_getLineStyle(self)

    def setLineStyle(self, *args):
        """
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setLineStyle(self, *args)

    def getColor(self):
        """
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        blue

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementation_getColor(self)

    def getColorCode(self):
        """
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #0000FF

        See Also
        --------
        setColor, getColor, GetValidColors, setColorCode
        """
        return _graph.DrawableImplementation_getColorCode(self)

    def setColor(self, *args):
        """
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementation_setColor(self, *args)

    def getEdgeColor(self):
        """
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.DrawableImplementation_getEdgeColor(self)

    def getPointStyle(self):
        """
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph.DrawableImplementation_getPointStyle(self)

    def setPointStyle(self, *args):
        """
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setPointStyle(self, *args)

    def getFillStyle(self):
        """
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph.DrawableImplementation_getFillStyle(self)

    def setFillStyle(self, *args):
        """
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph.DrawableImplementation_setFillStyle(self, *args)

    def getLineWidth(self):
        """
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : int
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementation_getLineWidth(self)

    def setLineWidth(self, *args):
        """
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive int
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementation_setLineWidth(self, *args)

    def getPattern(self):
        """
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementation_getPattern(self)

    def setPattern(self, *args):
        """
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementation_setPattern(self, *args)

    def getCenter(self):
        """
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementation_getCenter(self)

    def setCenter(self, *args):
        """
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementation_setCenter(self, *args)

    def getRadius(self):
        """
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementation_getRadius(self)

    def setRadius(self, *args):
        """
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementation_setRadius(self, *args)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementation_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementation_setLabels(self, *args)

    def getPalette(self):
        """
        Accessor to the names of the colors used for the Pie.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.DrawableImplementation_getPalette(self)

    def setPalette(self, *args):
        """
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.DrawableImplementation_setPalette(self, *args)

    def getOrigin(self):
        """
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementation_getOrigin(self)

    def setOrigin(self, *args):
        """
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementation_setOrigin(self, *args)

    def getX(self):
        """
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.NumericalSample`
            Values of the first coordinate.
        """
        return _graph.DrawableImplementation_getX(self)

    def setX(self, *args):
        """
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.DrawableImplementation_setX(self, *args)

    def getY(self):
        """
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.NumericalSample`
            Values of the second coordinate.
        """
        return _graph.DrawableImplementation_getY(self)

    def setY(self, *args):
        """
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.DrawableImplementation_setY(self, *args)

    def getLevels(self):
        """
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.NumericalPoint`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.DrawableImplementation_getLevels(self)

    def setLevels(self, *args):
        """
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.DrawableImplementation_setLevels(self, *args)

    def getDrawLabels(self):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementation_getDrawLabels(self)

    def setDrawLabels(self, *args):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementation_setDrawLabels(self, *args)

    def getTextAnnotations(self):
        """
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementation_getTextAnnotations(self)

    def setTextAnnotations(self, *args):
        """
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementation_setTextAnnotations(self, *args)

    def getTextPositions(self):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementation_getTextPositions(self)

    def setTextPositions(self, *args):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementation_setTextPositions(self, *args)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.DrawableImplementation_getBoundingBox(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.DrawableImplementation_draw(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.DrawableImplementation_clean(self)

    def GetValidColors():
        """
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph.DrawableImplementation_GetValidColors()

    if _newclass:GetValidColors = staticmethod(GetValidColors)
    __swig_getmethods__["GetValidColors"] = lambda x: GetValidColors
    def GetValidLineStyles():
        """
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph.DrawableImplementation_GetValidLineStyles()

    if _newclass:GetValidLineStyles = staticmethod(GetValidLineStyles)
    __swig_getmethods__["GetValidLineStyles"] = lambda x: GetValidLineStyles
    def GetValidFillStyles():
        """
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph.DrawableImplementation_GetValidFillStyles()

    if _newclass:GetValidFillStyles = staticmethod(GetValidFillStyles)
    __swig_getmethods__["GetValidFillStyles"] = lambda x: GetValidFillStyles
    def GetValidPointStyles():
        """
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles()[:5])
        [bullet,circle,diamond,dot,fcircle]
        """
        return _graph.DrawableImplementation_GetValidPointStyles()

    if _newclass:GetValidPointStyles = staticmethod(GetValidPointStyles)
    __swig_getmethods__["GetValidPointStyles"] = lambda x: GetValidPointStyles
    def ConvertFromName(*args):
        """
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph.DrawableImplementation_ConvertFromName(*args)

    if _newclass:ConvertFromName = staticmethod(ConvertFromName)
    __swig_getmethods__["ConvertFromName"] = lambda x: ConvertFromName
    def ConvertToRGB(*args):
        """
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph.DrawableImplementation_ConvertToRGB(*args)

    if _newclass:ConvertToRGB = staticmethod(ConvertToRGB)
    __swig_getmethods__["ConvertToRGB"] = lambda x: ConvertToRGB
    def ConvertToRGBA(*args):
        """
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph.DrawableImplementation_ConvertToRGBA(*args)

    if _newclass:ConvertToRGBA = staticmethod(ConvertToRGBA)
    __swig_getmethods__["ConvertToRGBA"] = lambda x: ConvertToRGBA
    def ConvertFromRGB(*args):
        """
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph.DrawableImplementation_ConvertFromRGB(*args)

    if _newclass:ConvertFromRGB = staticmethod(ConvertFromRGB)
    __swig_getmethods__["ConvertFromRGB"] = lambda x: ConvertFromRGB
    def ConvertFromRGBA(*args):
        """
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph.DrawableImplementation_ConvertFromRGBA(*args)

    if _newclass:ConvertFromRGBA = staticmethod(ConvertFromRGBA)
    __swig_getmethods__["ConvertFromRGBA"] = lambda x: ConvertFromRGBA
    def ConvertFromHSVIntoRGB(*args):
        """
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        RGBComponents : :class:`~openturns.NumericalPoint`
            RGB (Red, Green and Blue) components of the color.
        """
        return _graph.DrawableImplementation_ConvertFromHSVIntoRGB(*args)

    if _newclass:ConvertFromHSVIntoRGB = staticmethod(ConvertFromHSVIntoRGB)
    __swig_getmethods__["ConvertFromHSVIntoRGB"] = lambda x: ConvertFromHSVIntoRGB
    def ConvertFromHSV(*args):
        """
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementation_ConvertFromHSV(*args)

    if _newclass:ConvertFromHSV = staticmethod(ConvertFromHSV)
    __swig_getmethods__["ConvertFromHSV"] = lambda x: ConvertFromHSV
    def ConvertFromHSVA(*args):
        """
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementation_ConvertFromHSVA(*args)

    if _newclass:ConvertFromHSVA = staticmethod(ConvertFromHSVA)
    __swig_getmethods__["ConvertFromHSVA"] = lambda x: ConvertFromHSVA
    def BuildDefaultPalette(*args):
        """
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default OpenTURNS palette.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph.DrawableImplementation_BuildDefaultPalette(*args)

    if _newclass:BuildDefaultPalette = staticmethod(BuildDefaultPalette)
    __swig_getmethods__["BuildDefaultPalette"] = lambda x: BuildDefaultPalette
    def __init__(self, *args): 
        this = _graph.new_DrawableImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_DrawableImplementation
    __del__ = lambda self : None;
DrawableImplementation_swigregister = _graph.DrawableImplementation_swigregister
DrawableImplementation_swigregister(DrawableImplementation)

def DrawableImplementation_GetValidColors():
  """
    Return the list of the valid colors of the drawable element.

    Returns
    -------
    validColors : :class:`~openturns.Description`
        List of the valid colors of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidColors()[:5])
    [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
    """
  return _graph.DrawableImplementation_GetValidColors()

def DrawableImplementation_GetValidLineStyles():
  """
    Return the list of the valid line styles of the drawable element.

    Returns
    -------
    validLineStyles : :class:`~openturns.Description`
        List of the valid line styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidLineStyles())
    [blank,solid,dashed,dotted,dotdash,longdash,twodash]
    """
  return _graph.DrawableImplementation_GetValidLineStyles()

def DrawableImplementation_GetValidFillStyles():
  """
    Return the list of the valid fill styles of the drawable element.

    Returns
    -------
    validFillStyles : :class:`~openturns.Description`
        List of the valid fill styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidFillStyles()[:2])
    [solid,shaded]

    """
  return _graph.DrawableImplementation_GetValidFillStyles()

def DrawableImplementation_GetValidPointStyles():
  """
    Return the list of the valid point styles of the drawable element.

    Returns
    -------
    validPointStyles : :class:`~openturns.Description`
        List of the valid point styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable().GetValidPointStyles()[:5])
    [bullet,circle,diamond,dot,fcircle]
    """
  return _graph.DrawableImplementation_GetValidPointStyles()

def DrawableImplementation_ConvertFromName(*args):
  """
    Convert a color name to a valid hexadecimal code.

    Parameters
    ----------
    name : str
        Name of the color. The valid color names are given by the
        :meth:`GetValidColors` method.

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromName('red'))
    #FF0000
    """
  return _graph.DrawableImplementation_ConvertFromName(*args)

def DrawableImplementation_ConvertToRGB(*args):
  """
    Convert an hexadecimal code into an RGB triplet.

    Parameters
    ----------
    code : str
        Hexadecimal code of the color.

    Returns
    -------
    RGBComponents : :class:`~openturns.Indices`
        List containing the RGB (Red, Green and Blue) components of the color.
        A value of 0 meaning that the component is absent in the color, a value
        of 255 meaning that the component is fully saturated.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
    [255,0,0]
    """
  return _graph.DrawableImplementation_ConvertToRGB(*args)

def DrawableImplementation_ConvertToRGBA(*args):
  """
    Convert an hexadecimal code into an RGBA quadruplet.

    Parameters
    ----------
    code : str
        Hexadecimal code of the color.

    Returns
    -------
    RGBAComponents : :class:`~openturns.Indices`
        List containing the RGB (Red, Green and Blue) components. A value of 0
        meaning that the component is absent in the color, a value of 255 meaning
        that the component is fully saturated. It contains also alpha, the
        level of transparency of the color. Alpha equal to 0 meaning that the
        color is fully transparent and 255 meaning that the color is fully opaque.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
    [255,0,0,255]
    """
  return _graph.DrawableImplementation_ConvertToRGBA(*args)

def DrawableImplementation_ConvertFromRGB(*args):
  """
    Convert an RGB triplet to a valid hexadecimal code.

    Parameters
    ----------
    red, green and blue : either three nonnegative integers or three nonnegative floats
        These values are the Red, Green and Blue components of a color, a value
        of 0 (or 0.0) meaning that the component is absent in the color, a value
        of 255 (or 1.0) meaning that the component is fully saturated.

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
    #ff0000
    """
  return _graph.DrawableImplementation_ConvertFromRGB(*args)

def DrawableImplementation_ConvertFromRGBA(*args):
  """
    Convert an RGBA quadruplet to a valid hexadecimal code.

    Parameters
    ----------
    red, green and blue : either three nonnegative integers or three nonnegative floats
        These values are the Red, Green and Blue components of a color, a value
        of 0 (or 0.0) meaning that the component is absent in the color, a value
        of 255 (or 1.0) meaning that the component is fully saturated.
    alpha : either nonnegative integer or nonnegative float
        Level of the color's transparency, 0 (or 0.0) meaning that the color is
        fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
        The alpha channel is only supported by a few devices, namely the PDF and
        PNG formats, for the other format the color is fully transparent as soon as
        its alpha channel is less than 255 (or 1.0).

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
    #ff0000ff
    """
  return _graph.DrawableImplementation_ConvertFromRGBA(*args)

def DrawableImplementation_ConvertFromHSVIntoRGB(*args):
  """
    Convert an HSV triplet into an RGB triplet.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.

    Returns
    -------
    RGBComponents : :class:`~openturns.NumericalPoint`
        RGB (Red, Green and Blue) components of the color.
    """
  return _graph.DrawableImplementation_ConvertFromHSVIntoRGB(*args)

def DrawableImplementation_ConvertFromHSV(*args):
  """
    Convert an HSV triplet to a valid hexadecimal code.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.

    Returns
    -------
    code : str
        Hexadecimal code of the color.
    """
  return _graph.DrawableImplementation_ConvertFromHSV(*args)

def DrawableImplementation_ConvertFromHSVA(*args):
  """
    Convert an HSVA quadruplet to a valid hexadecimal code.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.
    alpha : float
        Alpha component.

    Returns
    -------
    code : str
        Hexadecimal code of the color.
    """
  return _graph.DrawableImplementation_ConvertFromHSVA(*args)

def DrawableImplementation_BuildDefaultPalette(*args):
  """
    Build default palette.

    Parameters
    ----------
    n : int :math:`n > 0`
        Number of colors needed.

    Returns
    -------
    listColors : :class:`~openturns.Description`
        List of n color codes defined according to the default OpenTURNS palette.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable().BuildDefaultPalette(4))
    [#ff0000,#ccff00,#00ff66,#0066ff]
    """
  return _graph.DrawableImplementation_BuildDefaultPalette(*args)

class DrawableImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DrawableImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DrawableImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _graph.new_DrawableImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _graph.DrawableImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph.DrawableImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph.DrawableImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _graph.DrawableImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _graph.delete_DrawableImplementationTypedInterfaceObject
    __del__ = lambda self : None;
DrawableImplementationTypedInterfaceObject_swigregister = _graph.DrawableImplementationTypedInterfaceObject_swigregister
DrawableImplementationTypedInterfaceObject_swigregister(DrawableImplementationTypedInterfaceObject)

class DrawableCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DrawableCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DrawableCollection, name)
    __swig_destroy__ = _graph.delete_DrawableCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _graph.DrawableCollection_clear(self)

    def __len__(self): return _graph.DrawableCollection___len__(self)
    def __eq__(self, *args): return _graph.DrawableCollection___eq__(self, *args)
    def __contains__(self, *args): return _graph.DrawableCollection___contains__(self, *args)
    def __getitem__(self, *args): return _graph.DrawableCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _graph.DrawableCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _graph.DrawableCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph.DrawableCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph.DrawableCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph.DrawableCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph.DrawableCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph.DrawableCollection_isEmpty(self)

    def __repr__(self): return _graph.DrawableCollection___repr__(self)
    def __str__(self, offset=""): return _graph.DrawableCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _graph.new_DrawableCollection(*args)
        try: self.this.append(this)
        except: self.this = this
DrawableCollection_swigregister = _graph.DrawableCollection_swigregister
DrawableCollection_swigregister(DrawableCollection)

class Drawable(DrawableImplementationTypedInterfaceObject):
    """
    Drawable object.

    Notes
    -----
    In OpenTURNS a Drawable is a drawable element described by:

    - its data,
    - its attributes: color, line stype, point style, fill style, legend ...

    The different drawable elements are:

    - :class:`~openturns.BarPlot`

    - :class:`~openturns.Cloud`

    - :class:`~openturns.Contour`

    - :class:`~openturns.Curve`

    - :class:`~openturns.Pairs`

    - :class:`~openturns.Pie`

    - :class:`~openturns.Polygon`

    - :class:`~openturns.Staircase`

    - :class:`~openturns.Text`

    Examples
    --------
    >>> import openturns as ot
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, 'topright')
    >>> sample = ot.Normal([0.0,0.0], [1.0,1.0], ot.CorrelationMatrix(2)).getSample(10)
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'A Cloud')
    >>> myGraph.add(myCloud)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Drawable, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Drawable, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Drawable_getClassName(self)

    def __repr__(self): return _graph.Drawable___repr__(self)
    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Drawable_getBoundingBox(self)

    def getLegend(self):
        """
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph.Drawable_getLegend(self)

    def setLegend(self, *args):
        """
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph.Drawable_setLegend(self, *args)

    def getLineStyle(self):
        """
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph.Drawable_getLineStyle(self)

    def setLineStyle(self, *args):
        """
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph.Drawable_setLineStyle(self, *args)

    def getPointStyle(self):
        """
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph.Drawable_getPointStyle(self)

    def setPointStyle(self, *args):
        """
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph.Drawable_setPointStyle(self, *args)

    def getFillStyle(self):
        """
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph.Drawable_getFillStyle(self)

    def setFillStyle(self, *args):
        """
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph.Drawable_setFillStyle(self, *args)

    def getLineWidth(self):
        """
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : int
            Width of the line within the drawable element.
        """
        return _graph.Drawable_getLineWidth(self)

    def setLineWidth(self, *args):
        """
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive int
            Width of the line within the drawable element.
        """
        return _graph.Drawable_setLineWidth(self, *args)

    def getColor(self):
        """
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        blue

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph.Drawable_getColor(self)

    def getColorCode(self):
        """
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #0000FF

        See Also
        --------
        setColor, getColor, GetValidColors, setColorCode
        """
        return _graph.Drawable_getColorCode(self)

    def setColor(self, *args):
        """
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.Drawable_setColor(self, *args)

    def getEdgeColor(self):
        """
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Drawable_getEdgeColor(self)

    def getPattern(self):
        """
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Drawable_getPattern(self)

    def setPattern(self, *args):
        """
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Drawable_setPattern(self, *args)

    def getCenter(self):
        """
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Drawable_getCenter(self)

    def setCenter(self, *args):
        """
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Drawable_setCenter(self, *args)

    def getRadius(self):
        """
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Drawable_getRadius(self)

    def setRadius(self, *args):
        """
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Drawable_setRadius(self, *args)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Drawable_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Drawable_setLabels(self, *args)

    def getPalette(self):
        """
        Accessor to the names of the colors used for the Pie.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.Drawable_getPalette(self)

    def setPalette(self, *args):
        """
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.Drawable_setPalette(self, *args)

    def getOrigin(self):
        """
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.Drawable_getOrigin(self)

    def setOrigin(self, *args):
        """
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.Drawable_setOrigin(self, *args)

    def getX(self):
        """
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.NumericalSample`
            Values of the first coordinate.
        """
        return _graph.Drawable_getX(self)

    def setX(self, *args):
        """
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.Drawable_setX(self, *args)

    def getY(self):
        """
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.NumericalSample`
            Values of the second coordinate.
        """
        return _graph.Drawable_getY(self)

    def setY(self, *args):
        """
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.Drawable_setY(self, *args)

    def getLevels(self):
        """
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.NumericalPoint`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.Drawable_getLevels(self)

    def setLevels(self, *args):
        """
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.Drawable_setLevels(self, *args)

    def getDrawLabels(self):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Drawable_getDrawLabels(self)

    def setDrawLabels(self, *args):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Drawable_setDrawLabels(self, *args)

    def getTextAnnotations(self):
        """
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Drawable_getTextAnnotations(self)

    def setTextAnnotations(self, *args):
        """
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Drawable_setTextAnnotations(self, *args)

    def getTextPositions(self):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Drawable_getTextPositions(self)

    def setTextPositions(self, *args):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Drawable_setTextPositions(self, *args)

    def getData(self):
        """
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.NumericalSample`
            Data from which the Drawable is built.
        """
        return _graph.Drawable_getData(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Drawable_draw(self)

    def getPointCode(self, *args):
        """
        Accessor to the code of the points style.

        Parameters
        ----------
        pointStyle : str
            Style point to be changed in code.

        Returns
        -------
        code : int
            Code of the style of the points within the drawable element.
        """
        return _graph.Drawable_getPointCode(self, *args)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.Drawable_clean(self)

    def GetValidColors():
        """
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph.Drawable_GetValidColors()

    if _newclass:GetValidColors = staticmethod(GetValidColors)
    __swig_getmethods__["GetValidColors"] = lambda x: GetValidColors
    def GetValidLineStyles():
        """
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph.Drawable_GetValidLineStyles()

    if _newclass:GetValidLineStyles = staticmethod(GetValidLineStyles)
    __swig_getmethods__["GetValidLineStyles"] = lambda x: GetValidLineStyles
    def GetValidFillStyles():
        """
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph.Drawable_GetValidFillStyles()

    if _newclass:GetValidFillStyles = staticmethod(GetValidFillStyles)
    __swig_getmethods__["GetValidFillStyles"] = lambda x: GetValidFillStyles
    def GetValidPointStyles():
        """
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles()[:5])
        [bullet,circle,diamond,dot,fcircle]
        """
        return _graph.Drawable_GetValidPointStyles()

    if _newclass:GetValidPointStyles = staticmethod(GetValidPointStyles)
    __swig_getmethods__["GetValidPointStyles"] = lambda x: GetValidPointStyles
    def ConvertFromName(*args):
        """
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph.Drawable_ConvertFromName(*args)

    if _newclass:ConvertFromName = staticmethod(ConvertFromName)
    __swig_getmethods__["ConvertFromName"] = lambda x: ConvertFromName
    def ConvertToRGB(*args):
        """
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph.Drawable_ConvertToRGB(*args)

    if _newclass:ConvertToRGB = staticmethod(ConvertToRGB)
    __swig_getmethods__["ConvertToRGB"] = lambda x: ConvertToRGB
    def ConvertToRGBA(*args):
        """
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph.Drawable_ConvertToRGBA(*args)

    if _newclass:ConvertToRGBA = staticmethod(ConvertToRGBA)
    __swig_getmethods__["ConvertToRGBA"] = lambda x: ConvertToRGBA
    def ConvertFromRGB(*args):
        """
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph.Drawable_ConvertFromRGB(*args)

    if _newclass:ConvertFromRGB = staticmethod(ConvertFromRGB)
    __swig_getmethods__["ConvertFromRGB"] = lambda x: ConvertFromRGB
    def ConvertFromRGBA(*args):
        """
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph.Drawable_ConvertFromRGBA(*args)

    if _newclass:ConvertFromRGBA = staticmethod(ConvertFromRGBA)
    __swig_getmethods__["ConvertFromRGBA"] = lambda x: ConvertFromRGBA
    def ConvertFromHSVIntoRGB(*args):
        """
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        RGBComponents : :class:`~openturns.NumericalPoint`
            RGB (Red, Green and Blue) components of the color.
        """
        return _graph.Drawable_ConvertFromHSVIntoRGB(*args)

    if _newclass:ConvertFromHSVIntoRGB = staticmethod(ConvertFromHSVIntoRGB)
    __swig_getmethods__["ConvertFromHSVIntoRGB"] = lambda x: ConvertFromHSVIntoRGB
    def ConvertFromHSV(*args):
        """
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.Drawable_ConvertFromHSV(*args)

    if _newclass:ConvertFromHSV = staticmethod(ConvertFromHSV)
    __swig_getmethods__["ConvertFromHSV"] = lambda x: ConvertFromHSV
    def ConvertFromHSVA(*args):
        """
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.Drawable_ConvertFromHSVA(*args)

    if _newclass:ConvertFromHSVA = staticmethod(ConvertFromHSVA)
    __swig_getmethods__["ConvertFromHSVA"] = lambda x: ConvertFromHSVA
    def BuildDefaultPalette(*args):
        """
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default OpenTURNS palette.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph.Drawable_BuildDefaultPalette(*args)

    if _newclass:BuildDefaultPalette = staticmethod(BuildDefaultPalette)
    __swig_getmethods__["BuildDefaultPalette"] = lambda x: BuildDefaultPalette
    def __init__(self, *args): 
        this = _graph.new_Drawable(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Drawable
    __del__ = lambda self : None;
Drawable_swigregister = _graph.Drawable_swigregister
Drawable_swigregister(Drawable)

def Drawable_GetValidColors():
  """
    Return the list of the valid colors of the drawable element.

    Returns
    -------
    validColors : :class:`~openturns.Description`
        List of the valid colors of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidColors()[:5])
    [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
    """
  return _graph.Drawable_GetValidColors()

def Drawable_GetValidLineStyles():
  """
    Return the list of the valid line styles of the drawable element.

    Returns
    -------
    validLineStyles : :class:`~openturns.Description`
        List of the valid line styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidLineStyles())
    [blank,solid,dashed,dotted,dotdash,longdash,twodash]
    """
  return _graph.Drawable_GetValidLineStyles()

def Drawable_GetValidFillStyles():
  """
    Return the list of the valid fill styles of the drawable element.

    Returns
    -------
    validFillStyles : :class:`~openturns.Description`
        List of the valid fill styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.GetValidFillStyles()[:2])
    [solid,shaded]

    """
  return _graph.Drawable_GetValidFillStyles()

def Drawable_GetValidPointStyles():
  """
    Return the list of the valid point styles of the drawable element.

    Returns
    -------
    validPointStyles : :class:`~openturns.Description`
        List of the valid point styles of the drawable element.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable().GetValidPointStyles()[:5])
    [bullet,circle,diamond,dot,fcircle]
    """
  return _graph.Drawable_GetValidPointStyles()

def Drawable_ConvertFromName(*args):
  """
    Convert a color name to a valid hexadecimal code.

    Parameters
    ----------
    name : str
        Name of the color. The valid color names are given by the
        :meth:`GetValidColors` method.

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromName('red'))
    #FF0000
    """
  return _graph.Drawable_ConvertFromName(*args)

def Drawable_ConvertToRGB(*args):
  """
    Convert an hexadecimal code into an RGB triplet.

    Parameters
    ----------
    code : str
        Hexadecimal code of the color.

    Returns
    -------
    RGBComponents : :class:`~openturns.Indices`
        List containing the RGB (Red, Green and Blue) components of the color.
        A value of 0 meaning that the component is absent in the color, a value
        of 255 meaning that the component is fully saturated.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
    [255,0,0]
    """
  return _graph.Drawable_ConvertToRGB(*args)

def Drawable_ConvertToRGBA(*args):
  """
    Convert an hexadecimal code into an RGBA quadruplet.

    Parameters
    ----------
    code : str
        Hexadecimal code of the color.

    Returns
    -------
    RGBAComponents : :class:`~openturns.Indices`
        List containing the RGB (Red, Green and Blue) components. A value of 0
        meaning that the component is absent in the color, a value of 255 meaning
        that the component is fully saturated. It contains also alpha, the
        level of transparency of the color. Alpha equal to 0 meaning that the
        color is fully transparent and 255 meaning that the color is fully opaque.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
    [255,0,0,255]
    """
  return _graph.Drawable_ConvertToRGBA(*args)

def Drawable_ConvertFromRGB(*args):
  """
    Convert an RGB triplet to a valid hexadecimal code.

    Parameters
    ----------
    red, green and blue : either three nonnegative integers or three nonnegative floats
        These values are the Red, Green and Blue components of a color, a value
        of 0 (or 0.0) meaning that the component is absent in the color, a value
        of 255 (or 1.0) meaning that the component is fully saturated.

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
    #ff0000
    """
  return _graph.Drawable_ConvertFromRGB(*args)

def Drawable_ConvertFromRGBA(*args):
  """
    Convert an RGBA quadruplet to a valid hexadecimal code.

    Parameters
    ----------
    red, green and blue : either three nonnegative integers or three nonnegative floats
        These values are the Red, Green and Blue components of a color, a value
        of 0 (or 0.0) meaning that the component is absent in the color, a value
        of 255 (or 1.0) meaning that the component is fully saturated.
    alpha : either nonnegative integer or nonnegative float
        Level of the color's transparency, 0 (or 0.0) meaning that the color is
        fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
        The alpha channel is only supported by a few devices, namely the PDF and
        PNG formats, for the other format the color is fully transparent as soon as
        its alpha channel is less than 255 (or 1.0).

    Returns
    -------
    code : str
        Hexadecimal code of the color.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
    #ff0000ff
    """
  return _graph.Drawable_ConvertFromRGBA(*args)

def Drawable_ConvertFromHSVIntoRGB(*args):
  """
    Convert an HSV triplet into an RGB triplet.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.

    Returns
    -------
    RGBComponents : :class:`~openturns.NumericalPoint`
        RGB (Red, Green and Blue) components of the color.
    """
  return _graph.Drawable_ConvertFromHSVIntoRGB(*args)

def Drawable_ConvertFromHSV(*args):
  """
    Convert an HSV triplet to a valid hexadecimal code.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.

    Returns
    -------
    code : str
        Hexadecimal code of the color.
    """
  return _graph.Drawable_ConvertFromHSV(*args)

def Drawable_ConvertFromHSVA(*args):
  """
    Convert an HSVA quadruplet to a valid hexadecimal code.

    Parameters
    ----------
    hue : float
        Hue.
    saturation : float
        Saturation.
    value : float
        Value.
    alpha : float
        Alpha component.

    Returns
    -------
    code : str
        Hexadecimal code of the color.
    """
  return _graph.Drawable_ConvertFromHSVA(*args)

def Drawable_BuildDefaultPalette(*args):
  """
    Build default palette.

    Parameters
    ----------
    n : int :math:`n > 0`
        Number of colors needed.

    Returns
    -------
    listColors : :class:`~openturns.Description`
        List of n color codes defined according to the default OpenTURNS palette.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Drawable().BuildDefaultPalette(4))
    [#ff0000,#ccff00,#00ff66,#0066ff]
    """
  return _graph.Drawable_BuildDefaultPalette(*args)

def Drawable__repr_svg_(self):
    """Get the SVG representation."""
    from .viewer import ToSVGString
    return ToSVGString(self)

Drawable._repr_svg_ = Drawable__repr_svg_


def Drawable__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError

Drawable._repr_html_ = Drawable__repr_html_

class GraphImplementation(openturns.common.PersistentObject):
    """
    Class Graph containing drawable elements and a graphical context.

    Available constructors:
        Graph(*title=''*)

        Graph(*title, xTitle, yTitle, showAxes, legendPosition='', legendFontSize=1.0, logScale=ot.GraphImplementation.NONE*)

    Parameters
    ----------
    title : str
        Title of the graph.
    xTitle : str
        Legend of the X axe.
    yTitle : str
        Legend of the Y axe.
    showAxes : bool
        *True* to draw the axes. *False* to hide them.
    legendPosition : str
        Indication of the legend's position. If *legendPosition* is not specified,
        the Graph has no legend. The valid strings are given by the
        :meth:`GetValidLegendPositions` method.
    legendFontSize : float
        Font size of the legend.
    logScale : int
        logScale indicates whether the logarithmic scale is used either for one or both axes:

        - ot.GraphImplementation.NONE or 0: no log scale is used,

        - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

        - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

        - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GraphImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.GraphImplementation_getClassName(self)

    PNG = _graph.GraphImplementation_PNG
    EPS = _graph.GraphImplementation_EPS
    FIG = _graph.GraphImplementation_FIG
    PDF = _graph.GraphImplementation_PDF
    ALL = _graph.GraphImplementation_ALL
    NONE = _graph.GraphImplementation_NONE
    LOGX = _graph.GraphImplementation_LOGX
    LOGY = _graph.GraphImplementation_LOGY
    LOGXY = _graph.GraphImplementation_LOGXY
    def __repr__(self): return _graph.GraphImplementation___repr__(self)
    def add(self, *args):
        """
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.

        .. warning::
            Different drawables might be colored the same...
        """
        return _graph.GraphImplementation_add(self, *args)

    def erase(self, *args):
        """
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph.GraphImplementation_erase(self, *args)

    def getDrawables(self):
        """
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.GraphImplementation_getDrawables(self)

    def setDrawables(self, *args):
        """
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.GraphImplementation_setDrawables(self, *args)

    def getDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph.GraphImplementation_getDrawable(self, *args)

    def setDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.
        index : int
            Position of the Drawable.
        """
        return _graph.GraphImplementation_setDrawable(self, *args)

    def getColors(self):
        """
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph.GraphImplementation_getColors(self)

    def setColors(self, *args):
        """
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` of the Drawable object.
        """
        return _graph.GraphImplementation_setColors(self, *args)

    def setDefaultColors(self):
        """
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph.GraphImplementation_setDefaultColors(self)

    def getLegends(self):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementation_getLegends(self)

    def setLegends(self, *args):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementation_setLegends(self, *args)

    def setAxes(self, *args):
        """
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.GraphImplementation_setAxes(self, *args)

    def getAxes(self):
        """
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph.GraphImplementation_getAxes(self)

    def setLogScale(self, *args):
        """
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph.GraphImplementation_setLogScale(self, *args)

    def getLogScale(self):
        """
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph.GraphImplementation_getLogScale(self)

    def setGrid(self, *args):
        """
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph.GraphImplementation_setGrid(self, *args)

    def getGrid(self):
        """
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph.GraphImplementation_getGrid(self)

    def setGridColor(self, *args):
        """
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementation_setGridColor(self, *args)

    def getGridColor(self):
        """
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementation_getGridColor(self)

    def getXTitle(self):
        """
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementation_getXTitle(self)

    def setXTitle(self, *args):
        """
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementation_setXTitle(self, *args)

    def getYTitle(self):
        """
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementation_getYTitle(self)

    def setYTitle(self, *args):
        """
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementation_setYTitle(self, *args)

    def getTitle(self):
        """
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementation_getTitle(self)

    def setTitle(self, *args):
        """
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementation_setTitle(self, *args)

    def draw(self, *args):
        """
        Generate graphic files.

        Parameters
        ----------
        file : str
             Name of the created file. The format is guessed from the extension.
             Supports png, fig, pdf and eps file formats. When the path is not
             specified in the file name, the files are created in the current directory.
        width : float
            Number of pixels fixing the width of the Graph, default value=640.
        height : float
            Number of pixels fixing the height of the Graph, default value=480.
        """
        return _graph.GraphImplementation_draw(self, *args)

    def getRCommand(self):
        """**(ditch me?)**"""
        return _graph.GraphImplementation_getRCommand(self)

    def clean(self):
        """
        Clean temporary files.

        Notes
        -----
        Cleans all the temporary data created by the drawables during their drawing.
        """
        return _graph.GraphImplementation_clean(self)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementation_getBoundingBox(self)

    def setBoundingBox(self, *args):
        """
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : sequence of float of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementation_setBoundingBox(self, *args)

    def getAutomaticBoundingBox(self):
        """
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementation_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, *args):
        """
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementation_setAutomaticBoundingBox(self, *args)

    def getLegendPosition(self):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph.GraphImplementation_getLegendPosition(self)

    def setLegendPosition(self, *args):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'topright'
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, position, 1.0, 0)
        >>> myGraph.setLegendPosition('bottomleft')
        >>> print(myGraph.getLegendPosition())
        bottomleft
        """
        return _graph.GraphImplementation_setLegendPosition(self, *args)

    def getLegendFontSize(self):
        """
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph.GraphImplementation_getLegendFontSize(self)

    def setLegendFontSize(self, *args):
        """
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> fontSize = 1.0
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, 'topright', fontSize, 0)
        >>> myGraph.setLegendFontSize(1.5)
        >>> print(myGraph.getLegendFontSize())
        1.5
        """
        return _graph.GraphImplementation_setLegendFontSize(self, *args)

    def IsValidLegendPosition(*args):
        """
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('topleft'))
        True
        """
        return _graph.GraphImplementation_IsValidLegendPosition(*args)

    if _newclass:IsValidLegendPosition = staticmethod(IsValidLegendPosition)
    __swig_getmethods__["IsValidLegendPosition"] = lambda x: IsValidLegendPosition
    def GetValidLegendPositions():
        """
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,bottomright,bottom,bottomleft,left,topleft,top,topright,right,center]#10
        """
        return _graph.GraphImplementation_GetValidLegendPositions()

    if _newclass:GetValidLegendPositions = staticmethod(GetValidLegendPositions)
    __swig_getmethods__["GetValidLegendPositions"] = lambda x: GetValidLegendPositions
    def __init__(self, *args): 
        this = _graph.new_GraphImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_GraphImplementation
    __del__ = lambda self : None;
GraphImplementation_swigregister = _graph.GraphImplementation_swigregister
GraphImplementation_swigregister(GraphImplementation)

def GraphImplementation_IsValidLegendPosition(*args):
  """
    Test if the proposed legend position is valid or not.

    Parameters
    ----------
    position : str
        Proposed legend position of the Drawables inside the Graph.

    Returns
    -------
    validity : bool
        *True* if the proposed legend position is valid, *False* if it is not.

    See Also
    --------
    setLegendPosition, GetValidLegendPositions

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
    False
    >>> print(ot.Graph.IsValidLegendPosition('topleft'))
    True
    """
  return _graph.GraphImplementation_IsValidLegendPosition(*args)

def GraphImplementation_GetValidLegendPositions():
  """
    Accessor to the list of valid legend positions.

    Returns
    -------
    listPositions : :class:`~openturns.Description`
        All the valid legend positions.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Graph.GetValidLegendPositions())
    [,bottomright,bottom,bottomleft,left,topleft,top,topright,right,center]#10
    """
  return _graph.GraphImplementation_GetValidLegendPositions()

class GraphImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GraphImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _graph.new_GraphImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _graph.GraphImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph.GraphImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph.GraphImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _graph.GraphImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _graph.delete_GraphImplementationTypedInterfaceObject
    __del__ = lambda self : None;
GraphImplementationTypedInterfaceObject_swigregister = _graph.GraphImplementationTypedInterfaceObject_swigregister
GraphImplementationTypedInterfaceObject_swigregister(GraphImplementationTypedInterfaceObject)

class GraphCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GraphCollection, name)
    __swig_destroy__ = _graph.delete_GraphCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _graph.GraphCollection_clear(self)

    def __len__(self): return _graph.GraphCollection___len__(self)
    def __eq__(self, *args): return _graph.GraphCollection___eq__(self, *args)
    def __contains__(self, *args): return _graph.GraphCollection___contains__(self, *args)
    def __getitem__(self, *args): return _graph.GraphCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _graph.GraphCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _graph.GraphCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph.GraphCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph.GraphCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph.GraphCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph.GraphCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph.GraphCollection_isEmpty(self)

    def __repr__(self): return _graph.GraphCollection___repr__(self)
    def __str__(self, offset=""): return _graph.GraphCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _graph.new_GraphCollection(*args)
        try: self.this.append(this)
        except: self.this = this
GraphCollection_swigregister = _graph.GraphCollection_swigregister
GraphCollection_swigregister(GraphCollection)

class Graph(GraphImplementationTypedInterfaceObject):
    """
    Class Graph containing drawable elements and a graphical context.

    Available constructors:
        Graph(*title=''*)

        Graph(*title, xTitle, yTitle, showAxes, legendPosition='', legendFontSize=1.0, logScale=ot.GraphImplementation.NONE*)

    Parameters
    ----------
    title : str
        Title of the graph.
    xTitle : str
        Legend of the X axe.
    yTitle : str
        Legend of the Y axe.
    showAxes : bool
        *True* to draw the axes. *False* to hide them.
    legendPosition : str
        Indication of the legend's position. If *legendPosition* is not specified,
        the Graph has no legend. The valid strings are given by the
        :meth:`GetValidLegendPositions` method.
    legendFontSize : float
        Font size of the legend.
    logScale : int
        logScale indicates whether the logarithmic scale is used either for one or both axes:

        - ot.GraphImplementation.NONE or 0: no log scale is used,

        - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

        - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

        - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.

    """
    __swig_setmethods__ = {}
    for _s in [GraphImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Graph, name, value)
    __swig_getmethods__ = {}
    for _s in [GraphImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Graph, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Graph_getClassName(self)

    def __repr__(self): return _graph.Graph___repr__(self)
    def __str__(self, offset=""): return _graph.Graph___str__(self, offset)
    def add(self, *args):
        """
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.

        .. warning::
            Different drawables might be colored the same...
        """
        return _graph.Graph_add(self, *args)

    def erase(self, *args):
        """
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph.Graph_erase(self, *args)

    def getDrawables(self):
        """
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.Graph_getDrawables(self)

    def setDrawables(self, *args):
        """
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.Graph_setDrawables(self, *args)

    def getDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph.Graph_getDrawable(self, *args)

    def setDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.
        index : int
            Position of the Drawable.
        """
        return _graph.Graph_setDrawable(self, *args)

    def getColors(self):
        """
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph.Graph_getColors(self)

    def setColors(self, *args):
        """
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` of the Drawable object.
        """
        return _graph.Graph_setColors(self, *args)

    def setDefaultColors(self):
        """
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph.Graph_setDefaultColors(self)

    def getLegends(self):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.Graph_getLegends(self)

    def setLegends(self, *args):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.Graph_setLegends(self, *args)

    def setAxes(self, *args):
        """
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.Graph_setAxes(self, *args)

    def getAxes(self):
        """
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph.Graph_getAxes(self)

    def setLogScale(self, *args):
        """
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph.Graph_setLogScale(self, *args)

    def getLogScale(self):
        """
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph.Graph_getLogScale(self)

    def setGrid(self, *args):
        """
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph.Graph_setGrid(self, *args)

    def getGrid(self):
        """
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph.Graph_getGrid(self)

    def setGridColor(self, *args):
        """
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.Graph_setGridColor(self, *args)

    def getGridColor(self):
        """
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.Graph_getGridColor(self)

    def getXTitle(self):
        """
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.Graph_getXTitle(self)

    def setXTitle(self, *args):
        """
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.Graph_setXTitle(self, *args)

    def getYTitle(self):
        """
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.Graph_getYTitle(self)

    def setYTitle(self, *args):
        """
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.Graph_setYTitle(self, *args)

    def getTitle(self):
        """
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph.Graph_getTitle(self)

    def setTitle(self, *args):
        """
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph.Graph_setTitle(self, *args)

    def draw(self, *args):
        """
        Generate graphic files.

        Parameters
        ----------
        file : str
             Name of the created file. The format is guessed from the extension.
             Supports png, fig, pdf and eps file formats. When the path is not
             specified in the file name, the files are created in the current directory.
        width : float
            Number of pixels fixing the width of the Graph, default value=640.
        height : float
            Number of pixels fixing the height of the Graph, default value=480.
        """
        return _graph.Graph_draw(self, *args)

    def getRCommand(self):
        """**(ditch me?)**"""
        return _graph.Graph_getRCommand(self)

    def clean(self):
        """
        Clean temporary files.

        Notes
        -----
        Cleans all the temporary data created by the drawables during their drawing.
        """
        return _graph.Graph_clean(self)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Graph_getBoundingBox(self)

    def setBoundingBox(self, *args):
        """
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : sequence of float of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Graph_setBoundingBox(self, *args)

    def getAutomaticBoundingBox(self):
        """
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Graph_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, *args):
        """
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Graph_setAutomaticBoundingBox(self, *args)

    def getLegendPosition(self):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph.Graph_getLegendPosition(self)

    def setLegendPosition(self, *args):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'topright'
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, position, 1.0, 0)
        >>> myGraph.setLegendPosition('bottomleft')
        >>> print(myGraph.getLegendPosition())
        bottomleft
        """
        return _graph.Graph_setLegendPosition(self, *args)

    def getLegendFontSize(self):
        """
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph.Graph_getLegendFontSize(self)

    def setLegendFontSize(self, *args):
        """
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> fontSize = 1.0
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, 'topright', fontSize, 0)
        >>> myGraph.setLegendFontSize(1.5)
        >>> print(myGraph.getLegendFontSize())
        1.5
        """
        return _graph.Graph_setLegendFontSize(self, *args)

    def IsValidLegendPosition(*args):
        """
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('topleft'))
        True
        """
        return _graph.Graph_IsValidLegendPosition(*args)

    if _newclass:IsValidLegendPosition = staticmethod(IsValidLegendPosition)
    __swig_getmethods__["IsValidLegendPosition"] = lambda x: IsValidLegendPosition
    def GetValidLegendPositions():
        """
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,bottomright,bottom,bottomleft,left,topleft,top,topright,right,center]#10
        """
        return _graph.Graph_GetValidLegendPositions()

    if _newclass:GetValidLegendPositions = staticmethod(GetValidLegendPositions)
    __swig_getmethods__["GetValidLegendPositions"] = lambda x: GetValidLegendPositions
    def __init__(self, *args): 
        this = _graph.new_Graph(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Graph
    __del__ = lambda self : None;
Graph_swigregister = _graph.Graph_swigregister
Graph_swigregister(Graph)

def Graph_IsValidLegendPosition(*args):
  """
    Test if the proposed legend position is valid or not.

    Parameters
    ----------
    position : str
        Proposed legend position of the Drawables inside the Graph.

    Returns
    -------
    validity : bool
        *True* if the proposed legend position is valid, *False* if it is not.

    See Also
    --------
    setLegendPosition, GetValidLegendPositions

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
    False
    >>> print(ot.Graph.IsValidLegendPosition('topleft'))
    True
    """
  return _graph.Graph_IsValidLegendPosition(*args)

def Graph_GetValidLegendPositions():
  """
    Accessor to the list of valid legend positions.

    Returns
    -------
    listPositions : :class:`~openturns.Description`
        All the valid legend positions.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.Graph.GetValidLegendPositions())
    [,bottomright,bottom,bottomleft,left,topleft,top,topright,right,center]#10
    """
  return _graph.Graph_GetValidLegendPositions()

def Graph__repr_svg_(self):
    """Get the SVG representation."""
    from .viewer import ToSVGString
    return ToSVGString(self)

Graph._repr_svg_ = Graph__repr_svg_


def Graph__repr_html_(self):
    """Get the HTML representation."""
    raise NotImplementedError

Graph._repr_html_ = Graph__repr_html_

class BarPlot(DrawableImplementation):
    """
    BarPlot.

    Available constructors:
        BarPlot(*data, origin, legend=' '*)

        BarPlot(*data, origin, color, fillStyle, lineStyle, legend=' '*)

        BarPlot(*data, origin, color, fillStyle, lineStyle, lineWidth, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Data from which the BarPlot is built, must be of dimension 2: the
        discontinuous points and their corresponding height.
    origin : float
        Scalar defining where the BarPlot begins.
    legend : str
        Legend of the BarPlot.
    color : str
        Color of the curve. If not specified, by default it is 'blue'.
    fillStyle : str
        Fill style of the surfaces. If not specified, by default it is 'solid'.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : int
        Width of the curve. If not specified, by default it is 1.

    Examples
    --------
    >>> import openturns as ot
    >>> from math import floor
    >>> # Create data
    >>> myDistribution = ot.Normal(0.5, 2.0)
    >>> sample = myDistribution.getSample(10)
    >>> minSample = sample.getMin()[0]
    >>> maxSample = sample.getMax()[0] + 0.1
    >>> nBars = 4
    >>> data = ot.NumericalSample(nBars, [(maxSample - minSample) / nBars, 0])
    >>> for i in range(10):
    ...     index = int(floor((sample[i, 0] - minSample) / (maxSample - minSample) * nBars))
    ...     data[index, 1] += 1
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A barplot', 'Realizations', 'Frequency', True, 'topright')
    >>> # Create the barplot
    >>> myBarPlot = ot.BarPlot(data, data.getMin()[0], 'red', 'shaded', 'dashed', 'Normal histogram')
    >>> myGraph.add(myBarPlot)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BarPlot, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BarPlot, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.BarPlot_getClassName(self)

    def __repr__(self): return _graph.BarPlot___repr__(self)
    def getOrigin(self):
        """
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.BarPlot_getOrigin(self)

    def setOrigin(self, *args):
        """
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.BarPlot_setOrigin(self, *args)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.BarPlot_getBoundingBox(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.BarPlot_draw(self)

    def __init__(self, *args): 
        this = _graph.new_BarPlot(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_BarPlot
    __del__ = lambda self : None;
BarPlot_swigregister = _graph.BarPlot_swigregister
BarPlot_swigregister(BarPlot)

class Cloud(DrawableImplementation):
    """
    Cloud.

    Available constructors:
        Cloud(*data, legend=' '*)

        Cloud(*dataX, dataY, legend=' '*)

        Cloud(*data, color, pointStyle, legend=' '*)

        Cloud(*dataComplex, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the cloud is built.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        Points from which the cloud is built.
    legend : str
        Legend of the Cloud.
    color : str
        Color of the points. If not specified, by default it is 'blue'.
    pointStyle : str
        Style of the points. If not specified, by default it is 'plus'.
    dataComplex : :class:`~openturns.NumericalComplexCollection`
        Collection of complex points.

    Examples
    --------
    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(2)
    >>> R[1, 0] = -0.25
    >>> distribution = ot.Normal([-1.5, 0.5], [4.0, 1.0], R)
    >>> sample = distribution.getSample(100)
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, '')
    >>> # Create the cloud
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'My Cloud')
    >>> myGraph.add(myCloud)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Cloud, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Cloud, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Cloud_getClassName(self)

    def __repr__(self): return _graph.Cloud___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Cloud_draw(self)

    def __init__(self, *args): 
        this = _graph.new_Cloud(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Cloud
    __del__ = lambda self : None;
Cloud_swigregister = _graph.Cloud_swigregister
Cloud_swigregister(Cloud)

class Contour(DrawableImplementation):
    """
    Contour.

    Available constructors:
        Contour(*dimX, dimY, data, legend=' '*)

        Contour(*sampleX, sampleY, data, levels, labels, drawLabels=True, legend=' '*)

    Parameters
    ----------
    dimX, dimY : int
        Dimensions of *data*.
    data : 2-d sequence of float of dimension 1 and of size :math:`dimX*dimY`
        These values are those of a function :math:`f: \\Rset^2 \\rightarrow \\Rset`
        on each point of the grid with *dimX* points along the :math:`X`-direction
        and *dimY* points along the :math:`Y`-direction. The :math:`(X, Y)`-
        values are stored row-by-row.
    sampleX, sampleY : two 2-d sequences of float of dimension 1
        First and second coordinates. If not specified the points are equally
        spaced in :math:`[0, 1]` along the :math:`X` and :math:`Y`-directions.
    levels : sequence of float
        Levels where the contour will be drawn. If two points of the grid have
        values bracketing the *level*, a linear interpolation is made in order to
        find the point associated to the *level* considered.
    labels : sequence of str
        Labels of each curve associated to one *level*. By default, the labels are
        the values of the *levels*.
    drawLabels : bool
        Flag telling if the labels of the iso-curves must be explicited or not.
    legend : str
        Legend of the Contour.

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction(['x', 'y'], ['z'], ['exp(-sin(cos(y)^2*x^2+sin(x)^2*y^2))'])
    >>> # Generate the data for the curves to be drawn
    >>> nX = 75
    >>> nY = 75
    >>> inputData = ot.Box([nX, nY]).generate()
    >>> inputData *= [10.0] * 2
    >>> inputData += [-5.0] * 2
    >>> data = f(inputData)
    >>> levels = [(0.5 + i) / 5 for i in range(5)]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Complex iso lines', 'u1', 'u2', True, '')
    >>> # Create the contour
    >>> myContour = ot.Contour(nX + 2, nY + 2, data)
    >>> myContour.setLevels(levels)
    >>> myGraph.add(myContour)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Contour, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Contour, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Contour_getClassName(self)

    def __repr__(self): return _graph.Contour___repr__(self)
    def getX(self):
        """
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.NumericalSample`
            Values of the first coordinate.
        """
        return _graph.Contour_getX(self)

    def setX(self, *args):
        """
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.Contour_setX(self, *args)

    def getY(self):
        """
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.NumericalSample`
            Values of the second coordinate.
        """
        return _graph.Contour_getY(self)

    def setY(self, *args):
        """
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.Contour_setY(self, *args)

    def getLevels(self):
        """
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.NumericalPoint`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.Contour_getLevels(self)

    def setLevels(self, *args):
        """
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.Contour_setLevels(self, *args)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Contour_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Contour_setLabels(self, *args)

    def getDrawLabels(self):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Contour_getDrawLabels(self)

    def setDrawLabels(self, *args):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.Contour_setDrawLabels(self, *args)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Contour_getBoundingBox(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Contour_draw(self)

    def buildDefaultLevels(self, *args):
        """
        Build default levels.

        Parameters
        ----------
        n : int
            Number of levels. If not specified, the default value is taken in the
            :class:`~openturns.ResourceMap` and :math:`n=10`.

        Notes
        -----
        It builds :math:`n` level values and the associated labels which are the level
        values. The level values are the empirical quantiles of the data to be sliced
        at orders :math:`q_k` regularly distributed over :math:`]0,1[`:
        :math:`q_k = \\frac{1}{n} \\left( k+ \\frac{1}{2} \\right)` for
        :math:`0 \\leq k \\leq n-1`.

        """
        return _graph.Contour_buildDefaultLevels(self, *args)

    def buildDefaultLabels(self):
        """Build default labels by taking the level values."""
        return _graph.Contour_buildDefaultLabels(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.Contour_clean(self)

    def __init__(self, *args): 
        this = _graph.new_Contour(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Contour
    __del__ = lambda self : None;
Contour_swigregister = _graph.Contour_swigregister
Contour_swigregister(Contour)

class Curve(DrawableImplementation):
    """
    Curve.

    Available constructors:
        Curve(*data, legend=' '*)

        Curve(*dataX, dataY, legend=' '*)

        Curve(*data, color, lineStyle, lineWidth, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the curve is built.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        Points from which the curve is built.
    legend : str
        Legend of the Curve.
    color : str
        Color of the curve. If not specified, by default it is 'blue'.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : int
        Width of the curve. If not specified, by default it is 1.

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi, sin
    >>> # Generate the data for the curve to be drawn
    >>> data = [[-3 * pi + 6 * pi * i / 100, sin(-3 * pi + 6 * pi * i / 100)] for i in range(100)]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A curve', 'x', 'sin(x)', True, '')
    >>> # Create the curve
    >>> myCurve = ot.Curve(data, 'blue', 'solid', 2, '')
    >>> myGraph.add(myCurve)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Curve, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Curve, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Curve_getClassName(self)

    def __repr__(self): return _graph.Curve___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Curve_draw(self)

    def __init__(self, *args): 
        this = _graph.new_Curve(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Curve
    __del__ = lambda self : None;
Curve_swigregister = _graph.Curve_swigregister
Curve_swigregister(Curve)

class Pairs(DrawableImplementation):
    """
    Pairs.

    Available constructors:
        Pairs(*data, title=' '*)

        Pairs(*data, title, labels, color, pointStyle*)

    Parameters
    ----------
    data : 2-d sequence of float of dimension :math:`n`
        Points from which 2D clouds are built.
    title : str
        Title of the Pairs.
    labels : sequence of str of dimension :math:`n`
        Names of each component of the sample.
    color : str
        Color of the points. If not specified, by default it is 'blue'.
    pointStyle : str
        Style of the points. If not specified, by default it is 'plus'.

    Examples
    --------
    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(3)
    >>> R[1, 0] = -0.4
    >>> R[2, 1] = -0.4
    >>> distribution = ot.Normal([0.0] * 3, [5.0] * 3, R)
    >>> sample = distribution.getSample(10)
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Pairs', ' ', ' ', True, '')
    >>> # Create the Pairs
    >>> myPairs = ot.Pairs(sample, 'Pairs example', sample.getDescription(), 'blue', 'bullet')
    >>> myGraph.add(myPairs)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pairs, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Pairs, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Pairs_getClassName(self)

    def __repr__(self): return _graph.Pairs___repr__(self)
    def getData(self):
        """
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.NumericalSample`
            Data from which the Drawable is built.
        """
        return _graph.Pairs_getData(self)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Pairs_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Pairs_setLabels(self, *args)

    def getTitle(self):
        """
        Get the title of the Pairs.

        Returns
        -------
        title : str
            Title of the Pairs.
        """
        return _graph.Pairs_getTitle(self)

    def setTitle(self, *args):
        """
        Set the title of the Pairs.

        Parameters
        ----------
        title : str
            Title of the Pairs.
        """
        return _graph.Pairs_setTitle(self, *args)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Pairs_draw(self)

    def buildDefaultLabels(self):
        """Build default labels by taking the column number of *data*."""
        return _graph.Pairs_buildDefaultLabels(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.Pairs_clean(self)

    def __init__(self, *args): 
        this = _graph.new_Pairs(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Pairs
    __del__ = lambda self : None;
Pairs_swigregister = _graph.Pairs_swigregister
Pairs_swigregister(Pairs)

class Pie(DrawableImplementation):
    """
    Pie.

    Available constructors:
        Pie(*data*)

        Pie(*data, labels*)

        Pie(*data, labels, center, radius, palette*)

    Parameters
    ----------
    data : sequence of float
        Sequence giving the percentiles of the pie.
    labels : sequence of str
        Names of each group. If not specified, by default equal to the description
        of the probabilistic input vector.
    center : sequence of float
        Center of the pie inside the bounding box. If not specified, by default it
        is (0,0).
    radius : positive float
        Radius of the pie. If not specified, by default it is 1.
    palette : sequence of str
        Names of the colors. If not specified, colors are successively taken from
        the list given by :meth:`buildDefaultPalette`, in the same order.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create the Pie
    >>> myPie = ot.Pie([0.4, 0.3, 0.2, 0.1], ['a0', 'a1', 'a2', 'a3'])
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A Pie', ' ', ' ', True, '')
    >>> myGraph.add(myPie)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pie, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Pie, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Pie_getClassName(self)

    def __repr__(self): return _graph.Pie___repr__(self)
    def getCenter(self):
        """
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Pie_getCenter(self)

    def setCenter(self, *args):
        """
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.Pie_setCenter(self, *args)

    def getRadius(self):
        """
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Pie_getRadius(self)

    def setRadius(self, *args):
        """
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.Pie_setRadius(self, *args)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.Pie_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.Pie_setLabels(self, *args)

    def getPalette(self):
        """
        Accessor to the names of the colors used for the Pie.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.Pie_getPalette(self)

    def setPalette(self, *args):
        """
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.Pie_setPalette(self, *args)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.Pie_getBoundingBox(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Pie_draw(self)

    def buildDefaultPalette(self):
        """
        Build default palette.

        Call :meth:`BuildDefaultPalette` with :math:`n` the size of *data* as argument.
        """
        return _graph.Pie_buildDefaultPalette(self)

    def buildDefaultLabels(self):
        """Build default labels by taking the percentiles."""
        return _graph.Pie_buildDefaultLabels(self)

    def IsValidColorPalette(*args):
        """
        Test the validity of a color palette.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors.

        Returns
        -------
        validity : bool
            *True* if *palette* is valid or *False* otherwise.

        Examples
        --------
        >>> import openturns as ot
        >>> pie = ot.Pie([0.5,0.2,0.3])
        >>> print(pie.IsValidColorPalette(['#ff0000','#ccff00','#00ff66']))
        True
        >>> print(pie.IsValidColorPalette(['green','red','darkorange']))
        True
        >>> print(pie.IsValidColorPalette(['green','red','darkpink']))
        False
        """
        return _graph.Pie_IsValidColorPalette(*args)

    if _newclass:IsValidColorPalette = staticmethod(IsValidColorPalette)
    __swig_getmethods__["IsValidColorPalette"] = lambda x: IsValidColorPalette
    def __init__(self, *args): 
        this = _graph.new_Pie(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Pie
    __del__ = lambda self : None;
Pie_swigregister = _graph.Pie_swigregister
Pie_swigregister(Pie)

def Pie_IsValidColorPalette(*args):
  """
    Test the validity of a color palette.

    Parameters
    ----------
    palette : sequence of str
        Names of the colors.

    Returns
    -------
    validity : bool
        *True* if *palette* is valid or *False* otherwise.

    Examples
    --------
    >>> import openturns as ot
    >>> pie = ot.Pie([0.5,0.2,0.3])
    >>> print(pie.IsValidColorPalette(['#ff0000','#ccff00','#00ff66']))
    True
    >>> print(pie.IsValidColorPalette(['green','red','darkorange']))
    True
    >>> print(pie.IsValidColorPalette(['green','red','darkpink']))
    False
    """
  return _graph.Pie_IsValidColorPalette(*args)

class Polygon(DrawableImplementation):
    """
    Polygon.

    Available constructors:
        Polygon(*legend=' '*)

        Polygon(*data, legend=' '*)

        Polygon(*dataX, dataY, legend=' '*)

        Polygon(*data, color, edgeColor, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float of dimension 2
        Vertices of the polygon.
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        List of the first and second coordinates of the vertices.
    legend : str
        Legend of the polygon.
    color, edgeColor : two str
        Fill color and the edge color. If not specified, by default it is 'blue'.

    Examples
    --------
    >>> import openturns as ot
    >>> # Generate the data for the polygons to be drawn
    >>> data =[[9.0*i/51, (9.0*i/51)*(9.0*i/51)] for i in range(50)]
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('Polygon example', 'x1', 'x2', True, '', 1.0)
    >>> myPolygon = ot.Polygon(data)
    >>> myPolygon.setColor('red')
    >>> myGraph.add(myPolygon)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Polygon, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Polygon, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Polygon_getClassName(self)

    def __repr__(self): return _graph.Polygon___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Polygon_draw(self)

    def setEdgeColor(self, *args):
        """
        Set the color of the Polygon edge.

        Parameters
        ----------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Polygon_setEdgeColor(self, *args)

    def getEdgeColor(self):
        """
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.Polygon_getEdgeColor(self)

    def __init__(self, *args): 
        this = _graph.new_Polygon(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Polygon
    __del__ = lambda self : None;
Polygon_swigregister = _graph.Polygon_swigregister
Polygon_swigregister(Polygon)

class PolygonCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolygonCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PolygonCollection, name)
    __swig_destroy__ = _graph.delete_PolygonCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _graph.PolygonCollection_clear(self)

    def __len__(self): return _graph.PolygonCollection___len__(self)
    def __eq__(self, *args): return _graph.PolygonCollection___eq__(self, *args)
    def __contains__(self, *args): return _graph.PolygonCollection___contains__(self, *args)
    def __getitem__(self, *args): return _graph.PolygonCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _graph.PolygonCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _graph.PolygonCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _graph.PolygonCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _graph.PolygonCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _graph.PolygonCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _graph.PolygonCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _graph.PolygonCollection_isEmpty(self)

    def __repr__(self): return _graph.PolygonCollection___repr__(self)
    def __str__(self, offset=""): return _graph.PolygonCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _graph.new_PolygonCollection(*args)
        try: self.this.append(this)
        except: self.this = this
PolygonCollection_swigregister = _graph.PolygonCollection_swigregister
PolygonCollection_swigregister(PolygonCollection)

class PolygonArray(DrawableImplementation):
    """
    Polygon array.

    Available constructors:
        PolygonArray(*legend=' '*)

        PolygonArray(*polygons, legend=' '*)

        PolygonArray(*coordinates, verticesNumber, palette, legend=' '*)

    Parameters
    ----------
    legend : str
        Legend of the Cloud.
    polygons : sequence of :class:`~openturns.Polygon`
        Sequence of polygons.
    coordinates : 2-d sequence of float
        The list of coordinates.
    verticesNumber : int
        Number of vertices.
    palette : sequence of str
        Polygon colors.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> generator = ot.Normal(2)
    >>> size = 5
    >>> array = []
    >>> palette = ot.Drawable.BuildDefaultPalette(size)
    >>> for i in range(size):
    ...     vertices = generator.getSample(3)
    ...     array.append(ot.Polygon(vertices, palette[i], palette[size - i - 1]))
    >>> graph = ot.Graph('An array of polygons', 'x', 'y', True, '')
    >>> graph.add(ot.PolygonArray(array))
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolygonArray, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PolygonArray, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.PolygonArray_getClassName(self)

    def __repr__(self): return _graph.PolygonArray___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.PolygonArray_draw(self)

    def setPalette(self, *args):
        """
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.PolygonArray_setPalette(self, *args)

    def getPalette(self):
        """
        Accessor to the names of the colors used for the Pie.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.PolygonArray_getPalette(self)

    def setCoordinatesAndVerticesNumber(self, *args):
        """
        Accessor to the coordinates of polygons.

        Parameters
        ----------
        coordinates : 2-d sequence of float
            The list of coordinates.
        verticesNumber : int
            number of vertices.
        """
        return _graph.PolygonArray_setCoordinatesAndVerticesNumber(self, *args)

    def getCoordinates(self):
        """
        Accessor to the color of each polygon.

        Returns
        -------
        coordinates : :class:`~openturns.NumericalSample`
            Polygon coordinates.
        """
        return _graph.PolygonArray_getCoordinates(self)

    def getVerticesNumber(self):
        """
        Accessor to the number of vertices.

        Returns
        -------
        verticesNumber : int
            Number of vertices.
        """
        return _graph.PolygonArray_getVerticesNumber(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.PolygonArray_clean(self)

    def __init__(self, *args): 
        this = _graph.new_PolygonArray(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_PolygonArray
    __del__ = lambda self : None;
PolygonArray_swigregister = _graph.PolygonArray_swigregister
PolygonArray_swigregister(PolygonArray)

class Staircase(DrawableImplementation):
    """
    Staircase.

    Available constructors:
        Staircase(*data, legend=' '*)

        Staircase(*data, color, lineStyle, lineWidth, pattern, legend=' '*)

        Staircase(*data, color, lineStyle, pattern, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Points from which the Staircase is built, must be of dimension 2: the
        discontinuous points and their corresponding height.
    legend : str
        Legend of the Staircase.
    color : str
        Color of the curve. If not specified, by default it is 'blue'.
    lineStyle : str
        Style of the curve. If not specified, by default it is 'solid'.
    lineWidth : int
        Width of the curve. If not specified, by default it is 1.
    pattern : str
        Pattern which is 'S' or 's'. By default the pattern is equal to 's'. Going
        from :math:`(x_1, y_1)` to :math:`(x_2, y_2)` with :math:`x_1<x_2`,
        pattern='s' moves first horizontal then vertical, whereas pattern='S' moves
        the other way around.

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.Normal([0.5], [2.], ot.CorrelationMatrix(1))
    >>> sample = distribution.getSample(200)
    >>> # Construct empirical CDF for the sample
    >>> data = ot.NumericalSample(20, 2)
    >>> cursor = ot.NumericalPoint(2)
    >>> for i in range(20):
    ...     cursor[0] = 13.0 * i / 20.0 - 6.5
    ...     count = 0
    ...     for j in range(200):
    ...         if(sample[j, 0] < cursor[0]):
    ...             count += 1
    ...     cursor[1] = count / 200.0
    ...     data[i] = cursor
    >>> # Create an empty graph
    >>> myGraph = ot.Graph('A staircase', 'x1', 'x2', True, 'topleft')
    >>> # Create the staircase
    >>> myStaircase = ot.Staircase(data, 'blue', 'solid', 's', 'Normal CDF')
    >>> myGraph.add(myStaircase)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Staircase, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Staircase, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Staircase_getClassName(self)

    def __repr__(self): return _graph.Staircase___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Staircase_draw(self)

    def getPattern(self):
        """
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Staircase_getPattern(self)

    def setPattern(self, *args):
        """
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.Staircase_setPattern(self, *args)

    def __init__(self, *args): 
        this = _graph.new_Staircase(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Staircase
    __del__ = lambda self : None;
Staircase_swigregister = _graph.Staircase_swigregister
Staircase_swigregister(Staircase)

class Text(DrawableImplementation):
    """
    Text.

    Available constructors:
        Text(*data, texts, position=3, legend=' '*)

        Text(*dataX, dataY, texts, position=3, legend=' '*)

    Parameters
    ----------
    data : 2-d sequence of float
        Locations of texts
    dataX, dataY : two 2-d sequences of float of dimension 1, or two sequences of float
        X- and Y-locations of texts
    position : str
        Text position; valid values are 'top' (default), 'below', 'left' or 'right'
    legend : str
        Legend of the Text.

    Examples
    --------
    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(2)
    >>> R[1, 0] = -0.25
    >>> distribution = ot.Normal([-1.5, 0.5], [4.0, 1.0], R)
    >>> sample = distribution.getSample(20)
    >>> myGraph = ot.Graph('Normal sample', 'x1', 'x2', True, '')
    >>> # Create the cloud
    >>> myCloud = ot.Cloud(sample, 'blue', 'fsquare', 'My Cloud')
    >>> myGraph.add(myCloud)
    >>> # Add annotations
    >>> texts = ot.Description(5)
    >>> for i in range(5): texts[i] = str(i+1)
    >>> myText = ot.Text(sample[0:5,:], texts)
    >>> myGraph.add(myText)
    """
    __swig_setmethods__ = {}
    for _s in [DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Text, name, value)
    __swig_getmethods__ = {}
    for _s in [DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Text, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.Text_getClassName(self)

    __swig_getmethods__["IsValidTextPosition"] = lambda x: _graph.Text_IsValidTextPosition
    if _newclass:IsValidTextPosition = staticmethod(_graph.Text_IsValidTextPosition)
    def __repr__(self): return _graph.Text___repr__(self)
    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.Text_draw(self)

    def getTextAnnotations(self):
        """
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Text_getTextAnnotations(self)

    def setTextAnnotations(self, *args):
        """
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.Text_setTextAnnotations(self, *args)

    def getTextPositions(self):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Text_getTextPositions(self)

    def setTextPositions(self, *args):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.Text_setTextPositions(self, *args)

    def __init__(self, *args): 
        this = _graph.new_Text(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_Text
    __del__ = lambda self : None;
Text_swigregister = _graph.Text_swigregister
Text_swigregister(Text)

def Text_IsValidTextPosition(*args):
  return _graph.Text_IsValidTextPosition(*args)
Text_IsValidTextPosition = _graph.Text_IsValidTextPosition

class DrawableImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DrawableImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DrawableImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _graph.DrawableImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _graph.DrawableImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_graph.DrawableImplementationPointer_ptr__get, _graph.DrawableImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _graph.new_DrawableImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_DrawableImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _graph.DrawableImplementationPointer_reset(self)
    def __ref__(self, *args): return _graph.DrawableImplementationPointer___ref__(self, *args)
    def __deref__(self): return _graph.DrawableImplementationPointer___deref__(self)
    def isNull(self): return _graph.DrawableImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _graph.DrawableImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _graph.DrawableImplementationPointer_get(self)
    def getImplementation(self): return _graph.DrawableImplementationPointer_getImplementation(self)
    def unique(self): return _graph.DrawableImplementationPointer_unique(self)
    def use_count(self): return _graph.DrawableImplementationPointer_use_count(self)
    def swap(self, *args): return _graph.DrawableImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.DrawableImplementationPointer_getClassName(self)

    def __repr__(self): return _graph.DrawableImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _graph.DrawableImplementationPointer___str__(self, offset)
    def __eq__(self, *args): return _graph.DrawableImplementationPointer___eq__(self, *args)
    def getPointCode(self, *args):
        """
        Accessor to the code of the points style.

        Parameters
        ----------
        pointStyle : str
            Style point to be changed in code.

        Returns
        -------
        code : int
            Code of the style of the points within the drawable element.
        """
        return _graph.DrawableImplementationPointer_getPointCode(self, *args)

    def getLegend(self):
        """
        Accessor to the legend of the drawable element.

        Returns
        -------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementationPointer_getLegend(self)

    def setLegend(self, *args):
        """
        Accessor to the legend of the drawable element.

        Parameters
        ----------
        legend : str
            Legend of the drawable element.
        """
        return _graph.DrawableImplementationPointer_setLegend(self, *args)

    def getData(self):
        """
        Accessor to the data from which the Drawable is built.

        Returns
        -------
        data : :class:`~openturns.NumericalSample`
            Data from which the Drawable is built.
        """
        return _graph.DrawableImplementationPointer_getData(self)

    def getLineStyle(self):
        """
        Accessor to the line style of the drawable element.

        Returns
        -------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getLineStyle())
        solid
        """
        return _graph.DrawableImplementationPointer_getLineStyle(self)

    def setLineStyle(self, *args):
        """
        Accessor to the line style of the drawable element.

        Parameters
        ----------
        lineStyle : str
            Style of the line within the drawable element. Use
            :meth:`GetValidLineStyles` for a list of available values.
        """
        return _graph.DrawableImplementationPointer_setLineStyle(self, *args)

    def getColor(self):
        """
        Accessor to the color of the drawable element.

        Returns
        -------
        color : str
            Name of the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColor())
        blue

        See Also
        --------
        setColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementationPointer_getColor(self)

    def getColorCode(self):
        """
        Accessor to the code of the color of the drawable element.

        Returns
        -------
        color : str
            Hexadecimal code corresponding to the RGB (Red, Green, Blue) components
            of the color of the lines within the drawable element
            or the RGBA (Red, Green, Blue, Alpha) components of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getColorCode())
        #0000FF

        See Also
        --------
        setColor, getColor, GetValidColors, setColorCode
        """
        return _graph.DrawableImplementationPointer_getColorCode(self)

    def setColor(self, *args):
        """
        Accessor to the color of the drawable element.

        Parameters
        ----------
        color : str
            Describes the color of the lines within the drawable element. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). The alpha channel is taken into account only by
            the PDF and PNG formats, for the other format the color is fully
            transparent as soon as its alpha channel is less than 255 (or 1.0).
            Use :meth:`GetValidColors` for a list of available values.

        See Also
        --------
        getColor, GetValidColors, getColorCode
        """
        return _graph.DrawableImplementationPointer_setColor(self, *args)

    def getEdgeColor(self):
        """
        Accessor to the color of the Polygon edge.

        Returns
        -------
        edgeColor : str
            Color of the edge of the :class:`~openturns.Polygon`.
        """
        return _graph.DrawableImplementationPointer_getEdgeColor(self)

    def getPointStyle(self):
        """
        Accessor to the point style of the drawable element.

        Returns
        -------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:GetValidPointStyles for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getPointStyle())
        none
        """
        return _graph.DrawableImplementationPointer_getPointStyle(self)

    def setPointStyle(self, *args):
        """
        Accessor to the point style of the drawable element.

        Parameters
        ----------
        pointStyle : str
            Style of the points within the drawable element. Use
            :meth:`GetValidPointStyles` for a list of available values.
        """
        return _graph.DrawableImplementationPointer_setPointStyle(self, *args)

    def getFillStyle(self):
        """
        Accessor to the fill style of the drawable element.

        Returns
        -------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().getFillStyle())
        solid
        """
        return _graph.DrawableImplementationPointer_getFillStyle(self)

    def setFillStyle(self, *args):
        """
        Accessor to the fill style of the drawable element.

        Parameters
        ----------
        fillStyle : str
            Fill style of the surfaces within the drawable element. Use
            :meth:`GetValidFillStyles` for a list of available values.
        """
        return _graph.DrawableImplementationPointer_setFillStyle(self, *args)

    def getLineWidth(self):
        """
        Accessor to the line width of the drawable element.

        Returns
        -------
        lineWidth : int
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementationPointer_getLineWidth(self)

    def setLineWidth(self, *args):
        """
        Accessor to the line width of the drawable element.

        Parameters
        ----------
        lineWidth : positive int
            Width of the line within the drawable element.
        """
        return _graph.DrawableImplementationPointer_setLineWidth(self, *args)

    def getPattern(self):
        """
        Accessor to the pattern of the Staircase.

        Returns
        -------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementationPointer_getPattern(self)

    def setPattern(self, *args):
        """
        Accessor to the pattern of the Staircase.

        Parameters
        ----------
        pattern : str
            Pattern of the :class:`~openturns.Staircase` which is 'S' or 's'.
            By default the pattern is equal to 's'. Going from :math:`(x_1, y_1)`
            to :math:`(x_2, y_2)` with :math:`x_1<x_2`, pattern='s' moves first
            horizontal then vertical, whereas pattern='S' moves the other way around.
        """
        return _graph.DrawableImplementationPointer_setPattern(self, *args)

    def getCenter(self):
        """
        Accessor to the center of the Pie inside the bounding box.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementationPointer_getCenter(self)

    def setCenter(self, *args):
        """
        Accessor to the center of the Pie inside the bounding box.

        Parameters
        ----------
        center : sequence of float
            Center of the :class:`~openturns.Pie` inside the bounding box.
        """
        return _graph.DrawableImplementationPointer_setCenter(self, *args)

    def getRadius(self):
        """
        Accessor to the radius of the Pie.

        Returns
        -------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementationPointer_getRadius(self)

    def setRadius(self, *args):
        """
        Accessor to the radius of the Pie.

        Parameters
        ----------
        radius : float
            Radius of the :class:`~openturns.Pie`.
        """
        return _graph.DrawableImplementationPointer_setRadius(self, *args)

    def getLabels(self):
        """
        Accessor to the labels of data.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementationPointer_getLabels(self)

    def setLabels(self, *args):
        """
        Accessor to the labels of data.

        Parameters
        ----------
        labels : sequence of str
            Describes the data within the drawable element.
        """
        return _graph.DrawableImplementationPointer_setLabels(self, *args)

    def getPalette(self):
        """
        Accessor to the names of the colors used for the Pie.

        Returns
        -------
        palette : :class:`~openturns.Description`
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4').
        """
        return _graph.DrawableImplementationPointer_getPalette(self)

    def setPalette(self, *args):
        """
        Accessor to the names of the colors used for the Pie.

        Parameters
        ----------
        palette : sequence of str
            Names of the colors used for the :class:`~openturns.Pie`. It can be
            either the name of a color (e.g. 'red') or an hexadecimal code
            corresponding to the RGB (Red, Green, Blue) components of the color
            (e.g. '#A1B2C3') or the RGBA (Red, Green, Blue, Alpha) components of the
            color (e.g. '#A1B2C3D4'). Use :meth:`GetValidColors` for a list of
            available values.
        """
        return _graph.DrawableImplementationPointer_setPalette(self, *args)

    def getOrigin(self):
        """
        Accessor to the origin of the BarPlot.

        Returns
        -------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementationPointer_getOrigin(self)

    def setOrigin(self, *args):
        """
        Accessor to the origin of the BarPlot.

        Parameters
        ----------
        origin : float
            Value where the :class:`~openturns.BarPlot` begins.
        """
        return _graph.DrawableImplementationPointer_setOrigin(self, *args)

    def getX(self):
        """
        Accessor to the first coordinate.

        Returns
        -------
        firstCoord : :class:`~openturns.NumericalSample`
            Values of the first coordinate.
        """
        return _graph.DrawableImplementationPointer_getX(self)

    def setX(self, *args):
        """
        Accessor to the first coordinate.

        Parameters
        ----------
        firstCoord : 2-d sequence of float
            Values of the first coordinate.
        """
        return _graph.DrawableImplementationPointer_setX(self, *args)

    def getY(self):
        """
        Accessor to the second coordinate.

        Returns
        -------
        secondCoord : :class:`~openturns.NumericalSample`
            Values of the second coordinate.
        """
        return _graph.DrawableImplementationPointer_getY(self)

    def setY(self, *args):
        """
        Accessor to the second coordinate.

        Parameters
        ----------
        secondCoord : 2-d sequence of float
            Values of the second coordinate.
        """
        return _graph.DrawableImplementationPointer_setY(self, *args)

    def getLevels(self):
        """
        Accessor to the levels of the Contour.

        Returns
        -------
        levels : :class:`~openturns.NumericalPoint`
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.DrawableImplementationPointer_getLevels(self)

    def setLevels(self, *args):
        """
        Accessor to the levels of the Contour.

        Parameters
        ----------
        levels : sequence of float
            Different levels where the iso-curves of the :class:`~openturns.Contour`
            will be drawn.
        """
        return _graph.DrawableImplementationPointer_setLevels(self, *args)

    def getDrawLabels(self):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Returns
        -------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementationPointer_getDrawLabels(self)

    def setDrawLabels(self, *args):
        """
        Accessor to the indication of data labels' presence within the drawable element.

        Parameters
        ----------
        drawLabels : bool
            *True* to draw the data labels, *False* to hide them.
        """
        return _graph.DrawableImplementationPointer_setDrawLabels(self, *args)

    def getTextAnnotations(self):
        """
        Accessor to the annotations of the Text.

        Returns
        -------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementationPointer_getTextAnnotations(self)

    def setTextAnnotations(self, *args):
        """
        Accessor to the annotations of the Text.

        Parameters
        ----------
        annotations : :class:`~openturns.Description`
            Accessor to text annotations.
        """
        return _graph.DrawableImplementationPointer_setTextAnnotations(self, *args)

    def getTextPositions(self):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementationPointer_getTextPositions(self)

    def setTextPositions(self, *args):
        """
        Accessor to the position of annotations.

        Parameters
        ----------
        positions : :class:`~openturns.Indices`
            Accessor to text position with respect to data coordinates.  Text is 
            written below (position=1), above (position=3), to the left (position=2)
            or to the right (position=4) of data coordinates.
        """
        return _graph.DrawableImplementationPointer_setTextPositions(self, *args)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.DrawableImplementationPointer_getBoundingBox(self)

    def draw(self):
        """
        Generate R command for plotting through R.

        Returns
        -------
        command : str
            R command used mainly by the draw method of :class:`~openturns.Graph`.
        """
        return _graph.DrawableImplementationPointer_draw(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _graph.DrawableImplementationPointer_clean(self)

    def GetValidColors(self):
        """
        Return the list of the valid colors of the drawable element.

        Returns
        -------
        validColors : :class:`~openturns.Description`
            List of the valid colors of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidColors()[:5])
        [aliceblue,antiquewhite,antiquewhite1,antiquewhite2,antiquewhite3]
        """
        return _graph.DrawableImplementationPointer_GetValidColors(self)

    def GetValidLineStyles(self):
        """
        Return the list of the valid line styles of the drawable element.

        Returns
        -------
        validLineStyles : :class:`~openturns.Description`
            List of the valid line styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidLineStyles())
        [blank,solid,dashed,dotted,dotdash,longdash,twodash]
        """
        return _graph.DrawableImplementationPointer_GetValidLineStyles(self)

    def GetValidFillStyles(self):
        """
        Return the list of the valid fill styles of the drawable element.

        Returns
        -------
        validFillStyles : :class:`~openturns.Description`
            List of the valid fill styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.GetValidFillStyles()[:2])
        [solid,shaded]

        """
        return _graph.DrawableImplementationPointer_GetValidFillStyles(self)

    def GetValidPointStyles(self):
        """
        Return the list of the valid point styles of the drawable element.

        Returns
        -------
        validPointStyles : :class:`~openturns.Description`
            List of the valid point styles of the drawable element.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().GetValidPointStyles()[:5])
        [bullet,circle,diamond,dot,fcircle]
        """
        return _graph.DrawableImplementationPointer_GetValidPointStyles(self)

    def ConvertFromName(self, *args):
        """
        Convert a color name to a valid hexadecimal code.

        Parameters
        ----------
        name : str
            Name of the color. The valid color names are given by the
            :meth:`GetValidColors` method.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromName('red'))
        #FF0000
        """
        return _graph.DrawableImplementationPointer_ConvertFromName(self, *args)

    def ConvertToRGB(self, *args):
        """
        Convert an hexadecimal code into an RGB triplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components of the color.
            A value of 0 meaning that the component is absent in the color, a value
            of 255 meaning that the component is fully saturated.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGB('#ff0000'))
        [255,0,0]
        """
        return _graph.DrawableImplementationPointer_ConvertToRGB(self, *args)

    def ConvertToRGBA(self, *args):
        """
        Convert an hexadecimal code into an RGBA quadruplet.

        Parameters
        ----------
        code : str
            Hexadecimal code of the color.

        Returns
        -------
        RGBAComponents : :class:`~openturns.Indices`
            List containing the RGB (Red, Green and Blue) components. A value of 0
            meaning that the component is absent in the color, a value of 255 meaning
            that the component is fully saturated. It contains also alpha, the
            level of transparency of the color. Alpha equal to 0 meaning that the
            color is fully transparent and 255 meaning that the color is fully opaque.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertToRGBA('#ff0000'))
        [255,0,0,255]
        """
        return _graph.DrawableImplementationPointer_ConvertToRGBA(self, *args)

    def ConvertFromRGB(self, *args):
        """
        Convert an RGB triplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGB(255,0,0))
        #ff0000
        """
        return _graph.DrawableImplementationPointer_ConvertFromRGB(self, *args)

    def ConvertFromRGBA(self, *args):
        """
        Convert an RGBA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        red, green and blue : either three nonnegative integers or three nonnegative floats
            These values are the Red, Green and Blue components of a color, a value
            of 0 (or 0.0) meaning that the component is absent in the color, a value
            of 255 (or 1.0) meaning that the component is fully saturated.
        alpha : either nonnegative integer or nonnegative float
            Level of the color's transparency, 0 (or 0.0) meaning that the color is
            fully transparent and 255 (or 1.0) meaning that the color is fully opaque.
            The alpha channel is only supported by a few devices, namely the PDF and
            PNG formats, for the other format the color is fully transparent as soon as
            its alpha channel is less than 255 (or 1.0).

        Returns
        -------
        code : str
            Hexadecimal code of the color.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable.ConvertFromRGBA(255,0,0,255))
        #ff0000ff
        """
        return _graph.DrawableImplementationPointer_ConvertFromRGBA(self, *args)

    def ConvertFromHSVIntoRGB(self, *args):
        """
        Convert an HSV triplet into an RGB triplet.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        RGBComponents : :class:`~openturns.NumericalPoint`
            RGB (Red, Green and Blue) components of the color.
        """
        return _graph.DrawableImplementationPointer_ConvertFromHSVIntoRGB(self, *args)

    def ConvertFromHSV(self, *args):
        """
        Convert an HSV triplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementationPointer_ConvertFromHSV(self, *args)

    def ConvertFromHSVA(self, *args):
        """
        Convert an HSVA quadruplet to a valid hexadecimal code.

        Parameters
        ----------
        hue : float
            Hue.
        saturation : float
            Saturation.
        value : float
            Value.
        alpha : float
            Alpha component.

        Returns
        -------
        code : str
            Hexadecimal code of the color.
        """
        return _graph.DrawableImplementationPointer_ConvertFromHSVA(self, *args)

    def BuildDefaultPalette(self, *args):
        """
        Build default palette.

        Parameters
        ----------
        n : int :math:`n > 0`
            Number of colors needed.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of n color codes defined according to the default OpenTURNS palette.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Drawable().BuildDefaultPalette(4))
        [#ff0000,#ccff00,#00ff66,#0066ff]
        """
        return _graph.DrawableImplementationPointer_BuildDefaultPalette(self, *args)

    def __ne__(self, *args): return _graph.DrawableImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _graph.DrawableImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _graph.DrawableImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _graph.DrawableImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _graph.DrawableImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _graph.DrawableImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _graph.DrawableImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _graph.DrawableImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph.DrawableImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph.DrawableImplementationPointer_setName(self, *args)

DrawableImplementationPointer_swigregister = _graph.DrawableImplementationPointer_swigregister
DrawableImplementationPointer_swigregister(DrawableImplementationPointer)

class GraphImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GraphImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GraphImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _graph.GraphImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _graph.GraphImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_graph.GraphImplementationPointer_ptr__get, _graph.GraphImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _graph.new_GraphImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _graph.delete_GraphImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _graph.GraphImplementationPointer_reset(self)
    def __ref__(self, *args): return _graph.GraphImplementationPointer___ref__(self, *args)
    def __deref__(self): return _graph.GraphImplementationPointer___deref__(self)
    def isNull(self): return _graph.GraphImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _graph.GraphImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _graph.GraphImplementationPointer_get(self)
    def getImplementation(self): return _graph.GraphImplementationPointer_getImplementation(self)
    def unique(self): return _graph.GraphImplementationPointer_unique(self)
    def use_count(self): return _graph.GraphImplementationPointer_use_count(self)
    def swap(self, *args): return _graph.GraphImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _graph.GraphImplementationPointer_getClassName(self)

    def __repr__(self): return _graph.GraphImplementationPointer___repr__(self)
    def add(self, *args):
        """
        Add drawable instances to the collection of drawables contained in Graph.

        Available usages:
            add(*drawables*)

            add(*aGraph*)

        Parameters
        ----------
        drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
            Drawable to add in the Graph.
        aGraph : :class:`~openturns.Graph`
            Graph to add in the Graph.

        Notes
        -----
        It adds the new drawables or graph inside the first one, with their legend.
        It keeps the graphical context of the first graph. Each drawable keeps
        its graphical context.

        .. warning::
            Different drawables might be colored the same...
        """
        return _graph.GraphImplementationPointer_add(self, *args)

    def erase(self, *args):
        """
        Erase a drawable instance from the collection of drawables contained in Graph.

        Parameters
        ----------
        index : int
            Index of the drawable instance to erase from the collection of drawables
            contained in Graph.
        """
        return _graph.GraphImplementationPointer_erase(self, *args)

    def getDrawables(self):
        """
        Accessor to the Drawables included in the Graph.

        Returns
        -------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.GraphImplementationPointer_getDrawables(self)

    def setDrawables(self, *args):
        """
        Accessor to the Drawables included in the Graph.

        Parameters
        ----------
        drawables : list of :class:`~openturns.Drawable`
            Drawables included in the Graph.
        """
        return _graph.GraphImplementationPointer_setDrawables(self, *args)

    def getDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        index : positive int
            Position of the Drawable.

        Returns
        -------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph at the index.
        """
        return _graph.GraphImplementationPointer_getDrawable(self, *args)

    def setDrawable(self, *args):
        """
        Accessor to a Drawable included in the Graph.

        Parameters
        ----------
        drawable : :class:`~openturns.Drawable`
            Drawable included in the Graph.
        index : int
            Position of the Drawable.
        """
        return _graph.GraphImplementationPointer_setDrawable(self, *args)

    def getColors(self):
        """
        Accessor to the colors of the Drawables included in the Graph.

        Returns
        -------
        listColors : :class:`~openturns.Description`
            List of all the colors used for the Drawables contained inside the graph.
        """
        return _graph.GraphImplementationPointer_getColors(self)

    def setColors(self, *args):
        """
        Update the colors of the Drawables inside the Graph.

        Parameters
        ----------
        listColors : sequence of str
            List of the colors used for each Drawable of the Graph.
            If the *listColors*'s size is lower than the number of Drawables, the
            first colors of *listColors* are re-used. If it is greated than
            the number of Drawables, the last colors of the list are ignored.

            The *listColors* argument can be the result of the static method
            :meth:`~openturns.Drawable.BuildDefaultPalette` of the Drawable object.
        """
        return _graph.GraphImplementationPointer_setColors(self, *args)

    def setDefaultColors(self):
        """
        Assign colors to a default palette to all the drawables of the Graph.

        Notes
        -----
        This method ensures that drawables of the Graph have different colors.
        """
        return _graph.GraphImplementationPointer_setDefaultColors(self)

    def getLegends(self):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Returns
        -------
        legends : :class:`~openturns.Description`
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementationPointer_getLegends(self)

    def setLegends(self, *args):
        """
        Accessor to the legends of the Drawables inside the Graph.

        Parameters
        ----------
        legends : sequence of str
            Legends used for the drawables contained inside the Graph.
        """
        return _graph.GraphImplementationPointer_setLegends(self, *args)

    def setAxes(self, *args):
        """
        Accessor to the indication of axes' presence on the Graph.

        Parameters
        ----------
        axes : bool
            *True* to draw the axes, *False* to hide the axes.
        """
        return _graph.GraphImplementationPointer_setAxes(self, *args)

    def getAxes(self):
        """
        Accessor to the indication of axes' presence on the Graph.

        Returns
        -------
        axes : bool
            *True* if the axes are drawn, *False* if they are hidden.
        """
        return _graph.GraphImplementationPointer_getAxes(self)

    def setLogScale(self, *args):
        """
        Accessor to the indication of axes' scale of the Graph.

        Parameters
        ----------
        scale : int
            Indicates the type of the axes's scale:

            - ot.GraphImplementation.NONE or 0: no log scale is used,

            - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

            - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

            - ot.GraphImplementation.LOGXY or 3: log scale is used for both data.
        """
        return _graph.GraphImplementationPointer_setLogScale(self, *args)

    def getLogScale(self):
        """
        Accessor to the indication of axes' scale of the Graph.

        Returns
        -------
        scale : int
            Indicates the type of the axes's scale:

            - 0: no log scale is used,

            - 1: log scale is used only for horizontal data,

            - 2: log scale is used only for vertical data,

            - 3: log scale is used for both data.
        """
        return _graph.GraphImplementationPointer_getLogScale(self)

    def setGrid(self, *args):
        """
        Hide or shows grid of the Graph.

        Parameters
        ----------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
        """
        return _graph.GraphImplementationPointer_setGrid(self, *args)

    def getGrid(self):
        """
        Accessor to the indication of grid's presence on the Graph.

        Returns
        -------
        showGrid : bool
            *True* to show the grid of the Graph, *False* to hide it.
            By default there is a gray grid.
        """
        return _graph.GraphImplementationPointer_getGrid(self)

    def setGridColor(self, *args):
        """
        Accessor to the indication of grid's color on the Graph.

        Parameters
        ----------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementationPointer_setGridColor(self, *args)

    def getGridColor(self):
        """
        Accessor to the indication of grid's color on the Graph.

        Returns
        -------
        gridColor : str
            Color of the grid. By default the grid is gray.
        """
        return _graph.GraphImplementationPointer_getGridColor(self)

    def getXTitle(self):
        """
        Accessor to the title of the X axe.

        Returns
        -------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementationPointer_getXTitle(self)

    def setXTitle(self, *args):
        """
        Accessor to the title of the X axe.

        Parameters
        ----------
        Xtitle : str
            Title of the X axe.
        """
        return _graph.GraphImplementationPointer_setXTitle(self, *args)

    def getYTitle(self):
        """
        Accessor to the title of the Y axe.

        Returns
        -------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementationPointer_getYTitle(self)

    def setYTitle(self, *args):
        """
        Accessor to the title of the Y axe.

        Parameters
        ----------
        Ytitle : str
            Title of the Y axe.
        """
        return _graph.GraphImplementationPointer_setYTitle(self, *args)

    def getTitle(self):
        """
        Accessor to the title of the Graph.

        Returns
        -------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementationPointer_getTitle(self)

    def setTitle(self, *args):
        """
        Accessor to the title of the Graph.

        Parameters
        ----------
        title : str
            Title of the Graph.
        """
        return _graph.GraphImplementationPointer_setTitle(self, *args)

    def draw(self, *args):
        """
        Generate graphic files.

        Parameters
        ----------
        file : str
             Name of the created file. The format is guessed from the extension.
             Supports png, fig, pdf and eps file formats. When the path is not
             specified in the file name, the files are created in the current directory.
        width : float
            Number of pixels fixing the width of the Graph, default value=640.
        height : float
            Number of pixels fixing the height of the Graph, default value=480.
        """
        return _graph.GraphImplementationPointer_draw(self, *args)

    def getRCommand(self):
        """**(ditch me?)**"""
        return _graph.GraphImplementationPointer_getRCommand(self)

    def clean(self):
        """
        Clean temporary files.

        Notes
        -----
        Cleans all the temporary data created by the drawables during their drawing.
        """
        return _graph.GraphImplementationPointer_clean(self)

    def getBoundingBox(self):
        """
        Accessor to the bounding box of the whole plot.

        Returns
        -------
        boundingBox : :class:`~openturns.NumericalPoint` of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementationPointer_getBoundingBox(self)

    def setBoundingBox(self, *args):
        """
        Accessor to the bounding box of the whole plot.

        Parameters
        ----------
        boundingBox : sequence of float of dimension 4
            Bounding box of the drawable element, which is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementationPointer_setBoundingBox(self, *args)

    def getAutomaticBoundingBox(self):
        """
        Accessor to the indication of automatic bounding box.

        Returns
        -------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementationPointer_getAutomaticBoundingBox(self)

    def setAutomaticBoundingBox(self, *args):
        """
        Accessor to the indication of automatic bounding box.

        Parameters
        ----------
        autoBoundingBox : bool
            Indicates if the bounding box is automatically created or not.
            The bounding box of the drawable element is a rectangle determined
            by its range along X and its range along Y.
            The *boundingBox* is :math:`(x_{min}, x_{max}, y_{min}, y_{max})`.
        """
        return _graph.GraphImplementationPointer_setAutomaticBoundingBox(self, *args)

    def getLegendPosition(self):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Returns
        -------
        position : str
            Legend's position used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions
        """
        return _graph.GraphImplementationPointer_getLegendPosition(self)

    def setLegendPosition(self, *args):
        """
        Accessor to the legend's position of the Drawables inside the Graph.

        Parameters
        ----------
        position : str
            Legend's position used for the drawables contained inside the Graph.
            The valid positions are given by the method :meth:`GetValidLegendPositions`.

        Examples
        --------
        >>> import openturns as ot
        >>> position = 'topright'
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, position, 1.0, 0)
        >>> myGraph.setLegendPosition('bottomleft')
        >>> print(myGraph.getLegendPosition())
        bottomleft
        """
        return _graph.GraphImplementationPointer_setLegendPosition(self, *args)

    def getLegendFontSize(self):
        """
        Accessor to the legends' font size of the Drawables inside the Graph.

        Returns
        -------
        fontSize : float
            Legends' font size used for the drawables contained inside the Graph.

        See Also
        --------
        setLegendFontSize
        """
        return _graph.GraphImplementationPointer_getLegendFontSize(self)

    def setLegendFontSize(self, *args):
        """
        Accessor to the legend's font size of the Drawables inside the Graph.

        Parameters
        ----------
        fontSize : float
            Legend's font size used for the drawables contained inside the Graph.

        Examples
        --------
        >>> import openturns as ot
        >>> fontSize = 1.0
        >>> # Create an empty graph
        >>> myGraph = ot.Graph('Some curves', 'x1', 'x2', True, 'topright', fontSize, 0)
        >>> myGraph.setLegendFontSize(1.5)
        >>> print(myGraph.getLegendFontSize())
        1.5
        """
        return _graph.GraphImplementationPointer_setLegendFontSize(self, *args)

    def IsValidLegendPosition(self, *args):
        """
        Test if the proposed legend position is valid or not.

        Parameters
        ----------
        position : str
            Proposed legend position of the Drawables inside the Graph.

        Returns
        -------
        validity : bool
            *True* if the proposed legend position is valid, *False* if it is not.

        See Also
        --------
        setLegendPosition, GetValidLegendPositions

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.IsValidLegendPosition('lefttop'))
        False
        >>> print(ot.Graph.IsValidLegendPosition('topleft'))
        True
        """
        return _graph.GraphImplementationPointer_IsValidLegendPosition(self, *args)

    def GetValidLegendPositions(self):
        """
        Accessor to the list of valid legend positions.

        Returns
        -------
        listPositions : :class:`~openturns.Description`
            All the valid legend positions.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.Graph.GetValidLegendPositions())
        [,bottomright,bottom,bottomleft,left,topleft,top,topright,right,center]#10
        """
        return _graph.GraphImplementationPointer_GetValidLegendPositions(self)

    def __eq__(self, *args): return _graph.GraphImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _graph.GraphImplementationPointer___ne__(self, *args)
    def __str__(self, offset=""): return _graph.GraphImplementationPointer___str__(self, offset)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _graph.GraphImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _graph.GraphImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _graph.GraphImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _graph.GraphImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _graph.GraphImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _graph.GraphImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _graph.GraphImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _graph.GraphImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _graph.GraphImplementationPointer_setName(self, *args)

GraphImplementationPointer_swigregister = _graph.GraphImplementationPointer_swigregister
GraphImplementationPointer_swigregister(GraphImplementationPointer)

# This file is compatible with both classic and new-style classes.


