# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Function primitives.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_func', [dirname(__file__)])
        except ImportError:
            import _func
            return _func
        if fp is not None:
            try:
                _mod = imp.load_module('_func', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _func = swig_import_helper()
    del swig_import_helper
else:
    import _func
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _func.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self): return _func.SwigPyIterator_value(self)
    def incr(self, n=1): return _func.SwigPyIterator_incr(self, n)
    def decr(self, n=1): return _func.SwigPyIterator_decr(self, n)
    def distance(self, *args): return _func.SwigPyIterator_distance(self, *args)
    def equal(self, *args): return _func.SwigPyIterator_equal(self, *args)
    def copy(self): return _func.SwigPyIterator_copy(self)
    def next(self): return _func.SwigPyIterator_next(self)
    def __next__(self): return _func.SwigPyIterator___next__(self)
    def previous(self): return _func.SwigPyIterator_previous(self)
    def advance(self, *args): return _func.SwigPyIterator_advance(self, *args)
    def __eq__(self, *args): return _func.SwigPyIterator___eq__(self, *args)
    def __ne__(self, *args): return _func.SwigPyIterator___ne__(self, *args)
    def __iadd__(self, *args): return _func.SwigPyIterator___iadd__(self, *args)
    def __isub__(self, *args): return _func.SwigPyIterator___isub__(self, *args)
    def __add__(self, *args): return _func.SwigPyIterator___add__(self, *args)
    def __sub__(self, *args): return _func.SwigPyIterator___sub__(self, *args)
    def __iter__(self): return self
SwigPyIterator_swigregister = _func.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

GCC_VERSION = _func.GCC_VERSION
class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.geom
import openturns.graph
class EnumerateFunctionImplementation(openturns.common.PersistentObject):
    """
    Enumerate function.

    Available constructors:
        EnumerateFunction(*dim=1*)

        EnumerateFunction(*dim, q*)

        EnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : positive int
        If *dim* is the only argument mentioned, it is used to create
        a :class:`~openturns.LinearEnumerateFunction` object of dimension *dim*.
        If *q* is also mentioned, it is used to create
        a :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object of
        dimension *dim* and parameter *q*.
    q : float
        The q-quasi-norm parameter used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.
    weight : sequence of float
        The weights of the indices in each dimension used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.

    Notes
    -----
    *EnumerateFunction* represents a bijection from :math:`\\Nset` to
    :math:`\\Nset^{dim}`. This bijection is based on a particular procedure of
    enumerating the set of multi-indices. It begins from the multi-index
    :math:`\\{0,0,\\dots,0\\}`.

    We associate a multi-index :math:`\\{j_{p1}, j_{p2},\\dots, j_{pdim}\\}` for every
    integer :math:`i_p` in :math:`\\Nset`:

    For more details, let us consider any :math:`i_p, i_q \\in \\Nset`:

    if :math:`|i_p-i_q|\\leq 1` then
    :math:`|\\sum_{k=1}^{dim} (j_{pk}- j_{qk})| \\leq 1`. This proposition provides a
    necessary but unsufficient condition for the construction of the bijection.
    Another assumption was done indicating the way of iteration.
    Below an example showing this assumption.

    Example for :math:`dim=2`:

    .. math::

        phi(0) &= [0 ~ 0] \\\\
        phi(1) &= [1 ~ 0] \\\\
        phi(2) &= [0 ~ 1] \\\\
        phi(3) &= [2 ~ 0] \\\\
        phi(4) &= [1 ~ 1] \\\\
        phi(5) &= [0 ~ 2] \\\\
        phi(6) &= [3 ~ 0]

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\\vect{i_p}` represents the collection of degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). In fact,
    after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* characterizes the term of the basis by providing the
    degrees of the univariate functions (respectively univariate polynomials).

    In order to know the degree of the :math:`k^{th}` polynomial of the
    multivariate basis, it is enough to sum all the integers given in the list.

    Examples
    --------
    >>> import openturns as ot
    >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
    >>> for i in range(6):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunctionImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunctionImplementation_getClassName(self)

    def __repr__(self): return _func.EnumerateFunctionImplementation___repr__(self)
    def __call__(self, *args): return _func.EnumerateFunctionImplementation___call__(self, *args)
    def inverse(self, *args):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.EnumerateFunctionImplementation_inverse(self, *args)

    def getStrataCardinal(self, *args):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.EnumerateFunctionImplementation_getStrataCardinal(self, *args)

    def getStrataCumulatedCardinal(self, *args):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.EnumerateFunctionImplementation_getStrataCumulatedCardinal(self, *args)

    def getMaximumDegreeStrataIndex(self, *args):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeStrataIndex(self, *args)

    def getMaximumDegreeCardinal(self, *args):
        """
        Get the cardinal of indices of degree inferior or equal to a given value.

        Parameters
        ----------
        maximumDegree : int
            Number of polynoms of the basis.

        Returns
        -------
        cardinal : int
            Cardinal of indices of degree :math:`max \\leq maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getMaximumDegreeCardinal(2))
        6
        """
        return _func.EnumerateFunctionImplementation_getMaximumDegreeCardinal(self, *args)

    def setDimension(self, *args):
        """
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_setDimension(self, *args)

    def getDimension(self):
        """
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunctionImplementation_getDimension(self)

    def __init__(self, *args): 
        this = _func.new_EnumerateFunctionImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_EnumerateFunctionImplementation
    __del__ = lambda self : None;
EnumerateFunctionImplementation_swigregister = _func.EnumerateFunctionImplementation_swigregister
EnumerateFunctionImplementation_swigregister(EnumerateFunctionImplementation)

class EnumerateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_EnumerateFunctionImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.EnumerateFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.EnumerateFunctionImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_EnumerateFunctionImplementationTypedInterfaceObject
    __del__ = lambda self : None;
EnumerateFunctionImplementationTypedInterfaceObject_swigregister = _func.EnumerateFunctionImplementationTypedInterfaceObject_swigregister
EnumerateFunctionImplementationTypedInterfaceObject_swigregister(EnumerateFunctionImplementationTypedInterfaceObject)

class EnumerateFunction(EnumerateFunctionImplementationTypedInterfaceObject):
    """
    Enumerate function.

    Available constructors:
        EnumerateFunction(*dim=1*)

        EnumerateFunction(*dim, q*)

        EnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : positive int
        If *dim* is the only argument mentioned, it is used to create
        a :class:`~openturns.LinearEnumerateFunction` object of dimension *dim*.
        If *q* is also mentioned, it is used to create
        a :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object of
        dimension *dim* and parameter *q*.
    q : float
        The q-quasi-norm parameter used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.
    weight : sequence of float
        The weights of the indices in each dimension used to create a
        :class:`~openturns.HyperbolicAnisotropicEnumerateFunction` object.

    Notes
    -----
    *EnumerateFunction* represents a bijection from :math:`\\Nset` to
    :math:`\\Nset^{dim}`. This bijection is based on a particular procedure of
    enumerating the set of multi-indices. It begins from the multi-index
    :math:`\\{0,0,\\dots,0\\}`.

    We associate a multi-index :math:`\\{j_{p1}, j_{p2},\\dots, j_{pdim}\\}` for every
    integer :math:`i_p` in :math:`\\Nset`:

    For more details, let us consider any :math:`i_p, i_q \\in \\Nset`:

    if :math:`|i_p-i_q|\\leq 1` then
    :math:`|\\sum_{k=1}^{dim} (j_{pk}- j_{qk})| \\leq 1`. This proposition provides a
    necessary but unsufficient condition for the construction of the bijection.
    Another assumption was done indicating the way of iteration.
    Below an example showing this assumption.

    Example for :math:`dim=2`:

    .. math::

        phi(0) &= [0 ~ 0] \\\\
        phi(1) &= [1 ~ 0] \\\\
        phi(2) &= [0 ~ 1] \\\\
        phi(3) &= [2 ~ 0] \\\\
        phi(4) &= [1 ~ 1] \\\\
        phi(5) &= [0 ~ 2] \\\\
        phi(6) &= [3 ~ 0]

    For the functional expansion (respectively polynomial chaos expansion), the
    multi-index :math:`\\vect{i_p}` represents the collection of degrees of the
    selected orthogonal functions (respectively orthogonal polynomials). In fact,
    after the selection of the type of orthogonal functions (respectively
    orthogonal polynomials) for the construction of the orthogonal basis, the
    *EnumerateFunction* characterizes the term of the basis by providing the
    degrees of the univariate functions (respectively univariate polynomials).

    In order to know the degree of the :math:`k^{th}` polynomial of the
    multivariate basis, it is enough to sum all the integers given in the list.

    Examples
    --------
    >>> import openturns as ot
    >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
    >>> for i in range(6):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [1,1]
    [0,2]
    """
    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, EnumerateFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EnumerateFunction_getClassName(self)

    def __repr__(self): return _func.EnumerateFunction___repr__(self)
    def __str__(self, offset=""): return _func.EnumerateFunction___str__(self, offset)
    def __call__(self, *args): return _func.EnumerateFunction___call__(self, *args)
    def inverse(self, *args):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.EnumerateFunction_inverse(self, *args)

    def getStrataCardinal(self, *args):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.EnumerateFunction_getStrataCardinal(self, *args)

    def getStrataCumulatedCardinal(self, *args):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.EnumerateFunction_getStrataCumulatedCardinal(self, *args)

    def getMaximumDegreeStrataIndex(self, *args):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.EnumerateFunction_getMaximumDegreeStrataIndex(self, *args)

    def getMaximumDegreeCardinal(self, *args):
        """
        Get the cardinal of indices of degree inferior or equal to a given value.

        Parameters
        ----------
        maximumDegree : int
            Number of polynoms of the basis.

        Returns
        -------
        cardinal : int
            Cardinal of indices of degree :math:`max \\leq maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getMaximumDegreeCardinal(2))
        6
        """
        return _func.EnumerateFunction_getMaximumDegreeCardinal(self, *args)

    def setDimension(self, *args):
        """
        Set the dimension of the *EnumerateFunction*.

        Parameters
        ----------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_setDimension(self, *args)

    def getDimension(self):
        """
        Return the dimension of the *EnumerateFunction*.

        Returns
        -------
        dim : int, :math:`dim \\geq 0`
            Dimension of the *EnumerateFunction*.
        """
        return _func.EnumerateFunction_getDimension(self)

    def __init__(self, *args): 
        this = _func.new_EnumerateFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_EnumerateFunction
    __del__ = lambda self : None;
EnumerateFunction_swigregister = _func.EnumerateFunction_swigregister
EnumerateFunction_swigregister(EnumerateFunction)

class LinearEnumerateFunction(EnumerateFunctionImplementation):
    """
    Linear enumerate function.

    Available constructors:
        LinearEnumerateFunction(*dim=1*)

    Parameters
    ----------
    dim : int
        Dimension.

    Notes
    -----
    Given an input random vector :math:`\\vect{X}` with prescribed probability
    density function (PDF) :math:`f_{\\vect{X}}(\\vect{x})`, it is possible to build
    up a *polynomial chaos* (PC) basis
    :math:`\\{\\psi_{\\vect{\\alpha}},\\vect{\\alpha} \\in \\Nset^{n_X}\\}`. Of interest is
    the definition of enumeration strategies for exploring this basis, i.e. of
    suitable *enumeration functions* :math:`\\tau` from :math:`\\Nset` to
    :math:`\\Nset^{n_X}`, which creates a one-to-one mapping between an integer
    :math:`j` and a multi-index :math:`\\Nset^{n_X}`.

    Let us first define the *total degree* of any multi-index :math:`\\vect{\\alpha}`
    in :math:`\\Nset^{n_X}` by :math:`\\sum_{i=1}^{n_X} \\alpha_i`. A natural choice to
    sort the PC basis (i.e. the multi-indices :math:`\\vect{\\alpha}`)
    is the lexicographical order with a constraint of increasing total degree.
    Mathematically speaking, a bijective enumeration function :math:`\\tau` is
    defined by:

    .. math::

        \\begin{array}{llcl}
          \\tau \\, : & \\Nset & \\longrightarrow & \\Nset^{n_X} \\\\
          &  j & \\longmapsto & \\{\\alpha_1,\\dots, \\alpha_{n_X}\\} \\,
                     \\equiv \\, \\{\\tau_1(j),\\dots,\\tau_{n_X}(j)\\} \\\\
        \\end{array}

    such that:

    .. math::

        \\tau(0) = \\{0,\\dots,0\\}

    and

    .. math::

        \\forall 1 \\leq j<k  \\quad \\, , \\quad \\, \\left\\{
        \\begin{array}{l}
          \\displaystyle{\\sum_{i=1}^{n_X} \\tau_i(j) < \\sum_{i=1}^{n_X} \\tau_i(k)}  \\\\
          \\\\
          \\mbox{ or} \\\\
          \\\\
          \\displaystyle{\\exists \\; m \\in \\{1,\\dots,n_X\\} \\; : \\;
              \\left(\\forall i \\leq m , \\; \\tau_i(j) = \\tau_i(k) \\; \\right)
              \\, \\, \\, \\mbox{ and } \\, \\, \\,
              \\left(\\tau_m(j) < \\tau_m(k) \\right)} \\\\
        \\end{array}
        \\right.

    Such an enumeration strategy is illustrated in a two-dimensional case
    (i.e. :math:`n_X=2`) in the figure below:

    .. plot:: pyplots/LinearEnumerateFunction.py
        :include-source: False

    This corresponds to the following enumeration of the multi-indices:

    ===== =====================
      j   :math:`\\vect{\\alpha} = \\{\\alpha_1,\\alpha_2\\}`
    ===== =====================
      0       {0, 0}
      1       {1, 0}
      2       {0, 1}
      3       {2, 0}
      4       {1, 1}
      5       {0, 2}
      6       {3, 0}
      7       {2, 1}
      8       {1, 2}
      9       {0, 3}
    ===== =====================

    See also
    --------
    EnumerateFunction, HyperbolicAnisotropicEnumerateFunction

    Examples
    --------
    >>> import openturns as ot
    >>> # 4-dimensional case
    >>> enumerateFunction = ot.LinearEnumerateFunction(4)
    >>> for i in range(9):
    ...     print(enumerateFunction(i))
    [0,0,0,0]
    [1,0,0,0]
    [0,1,0,0]
    [0,0,1,0]
    [0,0,0,1]
    [2,0,0,0]
    [1,1,0,0]
    [1,0,1,0]
    [1,0,0,1]
    """
    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearEnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearEnumerateFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearEnumerateFunction_getClassName(self)

    def __repr__(self): return _func.LinearEnumerateFunction___repr__(self)
    def __call__(self, *args): return _func.LinearEnumerateFunction___call__(self, *args)
    def inverse(self, *args):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.LinearEnumerateFunction_inverse(self, *args)

    def getStrataCardinal(self, *args):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.LinearEnumerateFunction_getStrataCardinal(self, *args)

    def getStrataCumulatedCardinal(self, *args):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.LinearEnumerateFunction_getStrataCumulatedCardinal(self, *args)

    def getMaximumDegreeStrataIndex(self, *args):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.LinearEnumerateFunction_getMaximumDegreeStrataIndex(self, *args)

    def __init__(self, *args): 
        this = _func.new_LinearEnumerateFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearEnumerateFunction
    __del__ = lambda self : None;
LinearEnumerateFunction_swigregister = _func.LinearEnumerateFunction_swigregister
LinearEnumerateFunction_swigregister(LinearEnumerateFunction)

class HyperbolicAnisotropicEnumerateFunction(EnumerateFunctionImplementation):
    """
    Hyperbolic and anisotropic enumerate function.

    Available constructors:
        HyperbolicAnisotropicEnumerateFunction(*dim*)

        HyperbolicAnisotropicEnumerateFunction(*dim, q*)

        HyperbolicAnisotropicEnumerateFunction(*weight*)

        HyperbolicAnisotropicEnumerateFunction(*weight, q*)

    Parameters
    ----------
    dim : integer
        Dimension of the :class:`~openturns.EnumerateFunction`. *dim* must be equal
        to the dimension of the :class:`~openturns.OrthogonalBasis`.
    q : float
        Correspond to the q-quasi norm parameter. If not precised, :math:`q = 0.4`.
    weight : sequence of float
        Weights of the indices in each dimension. If not precised, all weights are
        equals to :math:`w_i = 1`.

    See also
    --------
    EnumerateFunction, LinearEnumerateFunction

    Notes
    -----
    The hyperbolic truncation strategy is inspired by the so-called sparsity-of-
    effects principle, which states that most models are principally governed by
    main effects and low-order interactions. Accordingly, one wishes to define an
    enumeration strategy which first selects those multi-indices related to main
    effects, i.e. with a reasonably small number of nonzero components, prior to
    selecting those associated with higher-order interactions.

    For any real number :math:`q \\in ]0, 1]`, one defines the anisotropic hyperbolic
    norm of a multi-index :math:`a` by:

    .. math::
        
        \\| \\vect{a} \\|_{\\vect{w}, q} = \\left( \\sum_{i=1}^{n_X} w_i a^q \\right)^{1/q}

    where the :math:`w_i`'s are real positive numbers. This would lead to first
    select the basis polynomials depending on a specific subset of input variables.

    Examples
    --------
    >>> import openturns as ot
    >>> # 4-dimensional case
    >>> enumerateFunction = ot.HyperbolicAnisotropicEnumerateFunction(2, 0.5)
    >>> for i in range(10):
    ...     print(enumerateFunction(i))
    [0,0]
    [1,0]
    [0,1]
    [2,0]
    [0,2]
    [3,0]
    [0,3]
    [1,1]
    [4,0]
    [0,4]

    """
    __swig_setmethods__ = {}
    for _s in [EnumerateFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HyperbolicAnisotropicEnumerateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [EnumerateFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, HyperbolicAnisotropicEnumerateFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getClassName(self)

    def __repr__(self): return _func.HyperbolicAnisotropicEnumerateFunction___repr__(self)
    def __call__(self, *args): return _func.HyperbolicAnisotropicEnumerateFunction___call__(self, *args)
    def inverse(self, *args):
        """
        Get the antecedent of a indices list in the *EnumerateFunction*.

        Parameters
        ----------
        multiIndex : sequence of int
            List of indices.

        Returns
        -------
        antecedent : int
            Represents the antecedent of the *multiIndex* in the *EnumerateFunction*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     print(str(i)+' '+str(enumerateFunction(i)))
        0 [0,0]
        1 [1,0]
        2 [0,1]
        3 [2,0]
        4 [1,1]
        5 [0,2]
        >>> print(enumerateFunction.inverse([1,1]))
        4
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_inverse(self, *args)

    def getStrataCardinal(self, *args):
        """
        Get the number of members of the basis associated to a given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynom degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strata *strataIndex*. In
            the context of product of polynomial basis, this is the number of polynoms
            of the basis which total degree is *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [3, 4, 5]:
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCardinal(2))
        3
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCardinal(self, *args)

    def getStrataCumulatedCardinal(self, *args):
        """
        Get the cardinal of the cumulated strata above or equal to the given strata.

        Parameters
        ----------
        strataIndex : int
            Index of the strata in the hierarchical basis. In the context of product of
            polynomial basis, this is the total polynomial degree.

        Returns
        -------
        cardinal : int
            Number of members of the basis associated to the strates inferior or equal
            to *strataIndex*. In the context of product of polynomial basis, this is
            the number of polynomials of the basis which total degree is inferior or
            equal to *strataIndex*.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in range(6):
        ...     indices = enumerateFunction(i)
        ...     degree = sum(indices)
        ...     print(str(int(degree))+' '+str(indices))
        0 [0,0]
        1 [1,0]
        1 [0,1]
        2 [2,0]
        2 [1,1]
        2 [0,2]
        >>> print(enumerateFunction.getStrataCumulatedCardinal(2))
        6
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getStrataCumulatedCardinal(self, *args)

    def getMaximumDegreeStrataIndex(self, *args):
        """
        Get the index of the strata of degree inferior to a given value.

        Parameters
        ----------
        maximumDegree : int
            Degree.

        Returns
        -------
        index : int
            Index of the strata of degree :math:`max < maximumDegree`.

        Examples
        --------
        >>> import openturns as ot
        >>> enumerateFunction = ot.EnumerateFunction(ot.LinearEnumerateFunction(2))
        >>> for i in [1, 2]:
        ...     indices = enumerateFunction(i)
        ...     strataIndex = sum(indices) + 1
        ...     print(str(int(strataIndex))+' '+str(indices))
        2 [1,0]
        2 [0,1]
        >>> print(enumerateFunction.getMaximumDegreeStrataIndex(2))
        2
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getMaximumDegreeStrataIndex(self, *args)

    def setQ(self, *args):
        """
        Accessor to the norm.

        Parameters
        ----------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setQ(self, *args)

    def getQ(self):
        """
        Accessor to the norm.

        Returns
        -------
        q : float
            q-quasi norm parameter.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getQ(self)

    def setWeight(self, *args):
        """
        Accessor to the weights.

        Parameters
        ----------
        w : sequence of float
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_setWeight(self, *args)

    def getWeight(self):
        """
        Accessor to the weights.

        Returns
        -------
        w : :class:`~openturns.NumericalPoint`
            Weights of the indices in each dimension.
        """
        return _func.HyperbolicAnisotropicEnumerateFunction_getWeight(self)

    def __init__(self, *args): 
        this = _func.new_HyperbolicAnisotropicEnumerateFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_HyperbolicAnisotropicEnumerateFunction
    __del__ = lambda self : None;
HyperbolicAnisotropicEnumerateFunction_swigregister = _func.HyperbolicAnisotropicEnumerateFunction_swigregister
HyperbolicAnisotropicEnumerateFunction_swigregister(HyperbolicAnisotropicEnumerateFunction)

OT_TYPECHECK_FIELDIMPLEMENTATION = _func.OT_TYPECHECK_FIELDIMPLEMENTATION
class FieldImplementation(openturns.common.PersistentObject):
    """
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\\cD` a domain of :math:`\\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A class:`~openturns.Field` contains a mesh and the values associated to each
    vertice of the mesh. In the context of a stochastic process :math:`X`, a
    :class:`~openturns.Field` contains the mesh and a realization of :math:`X`
    discretized on this mesh.

    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = ot.IndicesCollection([[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]])
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FieldImplementation_getClassName(self)

    def getValueAtIndex(self, *args):
        """
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.NumericalPoint`
            The value of the field associated to the selected vertex, in :math:`\\Rset^d`.
        """
        return _func.FieldImplementation_getValueAtIndex(self, *args)

    def setValueAtIndex(self, *args):
        """
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.NumericalPoint` in :math:`\\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.FieldImplementation_setValueAtIndex(self, *args)

    def getValueAtNearestPosition(self, *args):
        """
        Get the value of the field at the vertex of the mesh the nearest to the given point.

        Parameters
        ----------
        point : sequence of float in :math:`\\Rset^n`.

        Returns
        -------
        value : :class:`~openturns.NumericalPoint` in :math:`\\Rset^d`.
            The value of the field associated to vertex the nearest of *point* with
            respect to the Euclidean norm.
        """
        return _func.FieldImplementation_getValueAtNearestPosition(self, *args)

    def setValueAtNearestPosition(self, *args):
        """
        Assign the value of the field to the vertex the nearest to a specified position.

        Parameters
        ----------
        position : sequence of float in :math:`\\Rset^n`.
        value : sequence of float in :math:`\\Rset^d`.
            New value assigned to the vertex the nearest to *position* with respect to
            the Euclidean norm.
        """
        return _func.FieldImplementation_setValueAtNearestPosition(self, *args)

    def getValueAtNearestTime(self, *args): return _func.FieldImplementation_getValueAtNearestTime(self, *args)
    def setValueAtNearestTime(self, *args): return _func.FieldImplementation_setValueAtNearestTime(self, *args)
    def setDescription(self, *args):
        """
        Set the description of the field..

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.FieldImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Get the description of the vertices and the values of the field.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and the values of the field.
        """
        return _func.FieldImplementation_getDescription(self)

    def getMesh(self):
        """
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _func.FieldImplementation_getMesh(self)

    def getTimeGrid(self):
        """
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.FieldImplementation_getTimeGrid(self)

    def __eq__(self, *args): return _func.FieldImplementation___eq__(self, *args)
    def __repr__(self): return _func.FieldImplementation___repr__(self)
    def __str__(self, offset=""): return _func.FieldImplementation___str__(self, offset)
    def getSize(self):
        """
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number of values inside the field, which corresponds to the number of
            vertices of the mesh.
        """
        return _func.FieldImplementation_getSize(self)

    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _func.FieldImplementation_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the values: :math:`d`.
        """
        return _func.FieldImplementation_getDimension(self)

    def getSample(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.FieldImplementation_getSample(self)

    def getValues(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`). Identical to :meth:`getSample`.
        """
        return _func.FieldImplementation_getValues(self)

    def setValues(self, *args):
        """
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.FieldImplementation_setValues(self, *args)

    def getMarginal(self, *args): return _func.FieldImplementation_getMarginal(self, *args)
    def asSample(self): return _func.FieldImplementation_asSample(self)
    def asDeformedMesh(self):
        """
        Get the mesh deformed according to the values of the field.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            replaced by the sum of the vertex and the value of the field at this
            vertex. Only works when :math:`d=n`: the spatial dimension :math:`n`: is
            equal to the dimension of the field :math:`d`.
        """
        return _func.FieldImplementation_asDeformedMesh(self)

    def getSpatialMean(self):
        """
        Get the spatial weighted mean of the values of the field.

        Returns
        -------
        spatialMean : :class:`~openturns.NumericalPoint`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The spatial mean of the field is defined by:

        .. math::

           \\displaystyle \\frac{1}{V} \\sum_{S_i \\in \\cM} \\left( \\frac{1}{n+1}\\sum_{k=0}^{n} \\vect{x}_{i_k}\\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\\vect{x}_{i_0}, \\dots, \\vect{x}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\\displaystyle V=\\sum_{S_i \\in \\cD} |S_i|`.
        """
        return _func.FieldImplementation_getSpatialMean(self)

    def getTemporalMean(self):
        """
        Get the mean of the values of the field.

        Returns
        -------
        temporalMean : :class:`~openturns.NumericalPoint`
            Mean of the values of the field.

        Notes
        -----
        If we note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values in
        :math:`\\Rset^d` of the field, then the temporal mean is defined by:

        .. math::

           \\displaystyle  \\frac{1}{N} \\sum_{i=0}^{N-1} \\vect{x}_i

        Only makes sense in the case of a regular grid.
        """
        return _func.FieldImplementation_getTemporalMean(self)

    def drawMarginal(self, index=0, interpolate=True):
        """
        Draw one marginal field if the spatial dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.FieldImplementation_drawMarginal(self, index, interpolate)

    def draw(self):
        """
        Draw the first marginal of the field if the spatial dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.FieldImplementation_draw(self)

    def exportToVTKFile(self, *args):
        """
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.FieldImplementation_exportToVTKFile(self, *args)

    def __getitem__(self, *args): return _func.FieldImplementation___getitem__(self, *args)
    def __setitem__(self, *args): return _func.FieldImplementation___setitem__(self, *args)
    def __init__(self, *args): 
        this = _func.new_FieldImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_FieldImplementation
    __del__ = lambda self : None;
FieldImplementation_swigregister = _func.FieldImplementation_swigregister
FieldImplementation_swigregister(FieldImplementation)

class FieldImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FieldImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_FieldImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FieldImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FieldImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FieldImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.FieldImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_FieldImplementationTypedInterfaceObject
    __del__ = lambda self : None;
FieldImplementationTypedInterfaceObject_swigregister = _func.FieldImplementationTypedInterfaceObject_swigregister
FieldImplementationTypedInterfaceObject_swigregister(FieldImplementationTypedInterfaceObject)

class Field(FieldImplementationTypedInterfaceObject):
    """
    Base class for Fields.

    Available constructors:
        Field(*mesh, dim*)

        Field(*mesh, values*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
           Each vertice of the mesh is in :math:`\\cD` a domain of :math:`\\Rset^n`.
    dim : int
          Dimension :math:`d` of the values.
    values : 2-d sequence of float of dimension :math:`d`
        The values associated to the vertices of the mesh. The size of *values* is
        equal to the number of vertices in the associated mesh. So we must have the
        equality between *values.getSize()* and *mesh.getVerticesNumber()*.

    Notes
    -----
    A class:`~openturns.Field` contains a mesh and the values associated to each
    vertice of the mesh. In the context of a stochastic process :math:`X`, a
    :class:`~openturns.Field` contains the mesh and a realization of :math:`X`
    discretized on this mesh.

    Examples
    --------
    Create a field:

    >>> import openturns as ot
    >>> myVertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0], [2.0, 1.5], [0.5, 1.5]]
    >>> mySimplicies = ot.IndicesCollection([[0,1,2], [1,2,3], [2,3,4], [2,4,5], [0,2,5]])
    >>> myMesh = ot.Mesh(myVertices, mySimplicies)
    >>> myValues = [[2.0],[2.5],[4.0], [4.5], [6.0], [7.0]]
    >>> myField = ot.Field(myMesh, myValues)

    Draw the field:

    >>> myGraph = myField.draw()

    """
    __swig_setmethods__ = {}
    for _s in [FieldImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Field, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Field, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Field_getClassName(self)

    def getValueAtIndex(self, *args):
        """
        Get the value of the field at the vertex of the given index.

        Parameters
        ----------
        index : int
            Vertex of the mesh of index *index*.

        Returns
        -------
        value : :class:`~openturns.NumericalPoint`
            The value of the field associated to the selected vertex, in :math:`\\Rset^d`.
        """
        return _func.Field_getValueAtIndex(self, *args)

    def setValueAtIndex(self, *args):
        """
        Assign the value of the field to the vertex at the given index.

        Parameters
        ----------
        index : int
            Index that characterizes one vertex of the mesh.
        value : :class:`~openturns.NumericalPoint` in :math:`\\Rset^d`.
            New value assigned to the selected vertex.
        """
        return _func.Field_setValueAtIndex(self, *args)

    def getValueAtNearestPosition(self, *args):
        """
        Get the value of the field at the vertex of the mesh the nearest to the given point.

        Parameters
        ----------
        point : sequence of float in :math:`\\Rset^n`.

        Returns
        -------
        value : :class:`~openturns.NumericalPoint` in :math:`\\Rset^d`.
            The value of the field associated to vertex the nearest of *point* with
            respect to the Euclidean norm.
        """
        return _func.Field_getValueAtNearestPosition(self, *args)

    def setValueAtNearestPosition(self, *args):
        """
        Assign the value of the field to the vertex the nearest to a specified position.

        Parameters
        ----------
        position : sequence of float in :math:`\\Rset^n`.
        value : sequence of float in :math:`\\Rset^d`.
            New value assigned to the vertex the nearest to *position* with respect to
            the Euclidean norm.
        """
        return _func.Field_setValueAtNearestPosition(self, *args)

    def getMarginal(self, *args): return _func.Field_getMarginal(self, *args)
    def setDescription(self, *args):
        """
        Set the description of the field..

        Parameters
        ----------
        myDescription : :class:`~openturns.Description`
            Description of the field. Must be of size :math:`n+d` and give the
            description of the vertices and the values.
        """
        return _func.Field_setDescription(self, *args)

    def getDescription(self):
        """
        Get the description of the vertices and the values of the field.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the vertices and the values of the field.
        """
        return _func.Field_getDescription(self)

    def getMesh(self):
        """
        Get the mesh on which the field is defined.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\\cD` is discretized.
        """
        return _func.Field_getMesh(self)

    def getTimeGrid(self):
        """
        Get the mesh as a time grid if it is 1D and regular.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Mesh of the field when it can be interpreted as a 
            :class:`~openturns.RegularGrid`. We check if the vertices of the mesh are
            scalar and are regularly spaced in :math:`\\Rset` but we don't check if the
            connectivity of the mesh is conform to the one of a regular grid (without
            any hole and composed of ordered instants).
        """
        return _func.Field_getTimeGrid(self)

    def __eq__(self, *args): return _func.Field___eq__(self, *args)
    def __repr__(self): return _func.Field___repr__(self)
    def __str__(self, offset=""): return _func.Field___str__(self, offset)
    def getSize(self):
        """
        Get the number of values inside the field.

        Returns
        -------
        size : int
            Number of values inside the field, which corresponds to the number of
            vertices of the mesh.
        """
        return _func.Field_getSize(self)

    def getSpatialDimension(self):
        """
        Get the dimension of the domain :math:`\\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\\cD`: :math:`n`.
        """
        return _func.Field_getSpatialDimension(self)

    def getDimension(self):
        """
        Get the dimension :math:`d` of the values.

        Returns
        -------
        d : int
            Dimension of the values: :math:`d`.
        """
        return _func.Field_getDimension(self)

    def getSample(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`).
        """
        return _func.Field_getSample(self)

    def getValues(self):
        """
        Get the values of the field.

        Returns
        -------
        values : :class:`~openturns.NumericalSample`
            Values associated to the mesh. The size of the sample is the number of
            vertices of the mesh and the dimension is the dimension of the values
            (:math:`d`). Identical to :meth:`getSample`.
        """
        return _func.Field_getValues(self)

    def setValues(self, *args):
        """
        Assign values to a field.

        Parameters
        ----------
        values : 2-d sequence of float
            Values assigned to the mesh. The size of the values is the number of
            vertices of the mesh and the dimension is :math:`d`.
        """
        return _func.Field_setValues(self, *args)

    def asDeformedMesh(self):
        """
        Get the mesh deformed according to the values of the field.

        Returns
        -------
        deformedMesh : :class:`~openturns.Mesh`
            The initial mesh is deformed as follows: each vertex of the mesh is
            replaced by the sum of the vertex and the value of the field at this
            vertex. Only works when :math:`d=n`: the spatial dimension :math:`n`: is
            equal to the dimension of the field :math:`d`.
        """
        return _func.Field_asDeformedMesh(self)

    def getSpatialMean(self):
        """
        Get the spatial weighted mean of the values of the field.

        Returns
        -------
        spatialMean : :class:`~openturns.NumericalPoint`
            Weighted mean of the  values of the field, weighted by the volume of each
            simplex.

        Notes
        -----
        The spatial mean of the field is defined by:

        .. math::

           \\displaystyle \\frac{1}{V} \\sum_{S_i \\in \\cM} \\left( \\frac{1}{n+1}\\sum_{k=0}^{n} \\vect{x}_{i_k}\\right) |S_i|

        where :math:`S_i` is the simplex of index :math:`i` of the mesh, :math:`|S_i|`
        its volume and :math:`(\\vect{x}_{i_0}, \\dots, \\vect{x}_{i_n})` the values of
        the field associated to the  vertices of :math:`S_i`, and
        :math:`\\displaystyle V=\\sum_{S_i \\in \\cD} |S_i|`.
        """
        return _func.Field_getSpatialMean(self)

    def getTemporalMean(self):
        """
        Get the mean of the values of the field.

        Returns
        -------
        temporalMean : :class:`~openturns.NumericalPoint`
            Mean of the values of the field.

        Notes
        -----
        If we note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values in
        :math:`\\Rset^d` of the field, then the temporal mean is defined by:

        .. math::

           \\displaystyle  \\frac{1}{N} \\sum_{i=0}^{N-1} \\vect{x}_i

        Only makes sense in the case of a regular grid.
        """
        return _func.Field_getTemporalMean(self)

    def drawMarginal(self, index=0, interpolate=True):
        """
        Draw one marginal field if the spatial dimension is less than 2.

        Parameters
        ----------
        index : int
            The selected marginal.
        interpolate : bool
            Indicates whether the values at the vertices are linearly interpolated.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            - If the dimension of the mesh is :math:`n=1` and *interpolate=True*: it
              draws the graph of the piecewise linear function based on the selected
              marginal values of the field and the vertices coordinates
              (in :math:`\\Rset`).

            - If the dimension of the mesh is :math:`n=1` and *interpolate=False*: it
              draws the cloud of points which coordinates are (vertex, value of the
              marginal *index*).

            - If the dimension of the mesh is :math:`n=2` and *interpolate=True*: it
              draws several iso-values curves of the selected marginal, based on a
              piecewise linear interpolation within the simplices (triangles) of the
              mesh. You get an empty graph if the vertices are not connected through
              simplicies.

            - If the dimension of the mesh is :math:`n=2` and *interpolate=False*: if
              the vertices are connected through simplicies, each simplex is drawn with
              a color defined by the mean of the values of the vertices of the simplex.
              In the other case, it draws each vertex colored by its value.
        """
        return _func.Field_drawMarginal(self, index, interpolate)

    def draw(self):
        """
        Draw the first marginal of the field if the spatial dimension is less than 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Calls *drawMarginal(0, False)*.

        See also
        --------
        drawMarginal
        """
        return _func.Field_draw(self)

    def exportToVTKFile(self, *args):
        """
        Create the VTK format file of the field.

        Parameters
        ----------
        myVTKFile : str
            Name of the output file. No extension is append to the filename.

        Notes
        -----
        Creates the VTK format file that contains the mesh and the associated values
        that can be visualised with the open source software
        `Paraview <http://www.paraview.org/>`_ .
        """
        return _func.Field_exportToVTKFile(self, *args)

    def __init__(self, *args): 
        this = _func.new_Field(*args)
        try: self.this.append(this)
        except: self.this = this
    def __getitem__(self, *args): return _func.Field___getitem__(self, *args)
    def __setitem__(self, *args): return _func.Field___setitem__(self, *args)
    def __len__(self): return _func.Field___len__(self)
    __swig_destroy__ = _func.delete_Field
    __del__ = lambda self : None;
Field_swigregister = _func.Field_swigregister
Field_swigregister(Field)

class TimeSeries(FieldImplementation):
    """
    Time series.

    Available constructors:
        TimeSeries(*nSteps,dim*)

        TimeSeries(*timeGrid, dim*)

        TimeSeries(*timeGrid, sample*)

        TimeSeries(*field*)

    Parameters
    ----------
    nSteps : int
        Enables to create a regular time grid on :math:`[0, nSteps]` which time step is equal to 1.

    timeGrid : :class:`~openturns.RegularGrid`
        Regular time grid of the time series.

    dim : int
        Dimension of the values of the time series at each time stamp. By default, the values are equal to the null vector.

    sample : 2-d sequence of float
        Values assigned to each time stamp of the time series.

    field : :class:`~openturns.Field`
        Maps a field into a time series when the associated lesh cn be interpretated as a regular time grid.

    Examples
    --------
    Create a time series:

    >>> import openturns as ot
    >>> tmin = 0.0
    >>> timeStep = 0.1
    >>> n = 5
    >>> myTimeGrid = ot.RegularGrid(tmin, timeStep, n)
    >>> myValues = [[1.0], [2.0], [1.5], [4.5], [0.5]]
    >>> myTimeSeries = ot.TimeSeries(myTimeGrid, myValues)

    Draw the time series:

    >>> graph = myTimeSeries.draw()
    """
    __swig_setmethods__ = {}
    for _s in [FieldImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeSeries, name, value)
    __swig_getmethods__ = {}
    for _s in [FieldImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeSeries, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TimeSeries_getClassName(self)

    def __repr__(self): return _func.TimeSeries___repr__(self)
    def __str__(self, offset=""): return _func.TimeSeries___str__(self, offset)
    def __eq__(self, *args): return _func.TimeSeries___eq__(self, *args)
    def add(self, *args):
        """
        Add a new value to the time series and extend the associated time grid.

        Available usages:
            add(*sample*)

            add(*timeSeries*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension the same as the dimension of the values of the time series.

        timeSeries : :class:`~openturns.TimeSeries`, which time grid must match with the initial time grid (one follows the other).

        Returns
        -------
        newTimeSeries: :class:`~openturns.TimeSeries`, which regular grid has been extended with a new time stamp or a second time grid, associated to the new values.

        """
        return _func.TimeSeries_add(self, *args)

    def __init__(self, *args): 
        this = _func.new_TimeSeries(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_TimeSeries
    __del__ = lambda self : None;
TimeSeries_swigregister = _func.TimeSeries_swigregister
TimeSeries_swigregister(TimeSeries)

class ProcessSample(openturns.common.PersistentObject):
    """
    Collection of fields.

    Available constructors:
        ProcessSample(*mesh, K, d*)

        ProcessSample(*K, field*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        The mesh shared by all the fields in the collection.
    K : int
        Number of fields in the collection.
    d : int
        Dimension  of the values of the field.
    field : :class:`~openturns.Field`
        One field.

    Notes
    -----
    A :class:`~openturns.ProcessSample` stores a sample of fields.
    We note `K` the number of fields contained in the process sample and `d` the dimension of the values associated to each vertex of the common mesh :math:`\\cM \\in \\Rset^n`.

    These fields can be generated by a stochastic process.

    - In the first usage, we fix the common mesh with `mesh`, the number of fields contained in the sample with `K` and the dimension of the values with `d`. The values of the fields are by default fixed to zero.

    - In the second usage, the  collection of fields is filled with `K` copies of the given field `field`.

    We note :math:`\\vect{x}_i^k \\in \\Rset^d` the value of the field `k` at the vertex `i`. We note `N` the number of vertices of :math:`\\cM`, with :math:`0 \\leq i \\leq N-1` and :math:`1 \\leq k \\leq K`.

    Examples
    --------
    Create a bi dimensional mesh as a box:

    >>> import openturns as ot
    >>> myIndices = [10, 5]
    >>> myMesher = ot.IntervalMesher(myIndices)
    >>> lowerBound = [0.0, 0.0]
    >>> upperBound = [2.0, 1.0]
    >>> myInterval = ot.Interval(lowerBound, upperBound)
    >>> myMesh = myMesher.build(myInterval)

    Create a second order normal porcess of dimension 3:

    >>> amplitude = [5]
    >>> scale = [3, 3]
    >>> model = ot.ExponentialModel(scale, amplitude)
    >>> myProcess = ot.TemporalNormalProcess(model, myMesh)

    Generate a sample of different fields:

    >>> n = 10
    >>> mySampleFields = myProcess.getSample(n)

    Duplicate the same field:

    >>> myField = myProcess.getRealization()
    >>> n = 10
    >>> mySampleFields2 = ot.ProcessSample(n, myField)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProcessSample, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProcessSample, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProcessSample_getClassName(self)

    def add(self, *args):
        """
        Add a field to the collection.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            A new field to add. 
            This field shares the same mesh and the same dimension as the other
            fields of the collection.

        """
        return _func.ProcessSample_add(self, *args)

    def __repr__(self): return _func.ProcessSample___repr__(self)
    def __str__(self, offset=""): return _func.ProcessSample___str__(self, offset)
    def getTimeGrid(self):
        """
        Get the time grid of the fields.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid shared by all the fields of the collection.
            Can be used only if the mesh can be interpreted as a regular time grid.

        """
        return _func.ProcessSample_getTimeGrid(self)

    def getMesh(self):
        """
        Get the mesh of the fields.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh shared by all the fields of the collection.

        """
        return _func.ProcessSample_getMesh(self)

    def getSize(self):
        """
        Get the size of the collection of fields.

        Returns
        -------
        K : int
            Number of fields in the collection.

        """
        return _func.ProcessSample_getSize(self)

    def getDimension(self):
        """
        Get the dimension of the values of fields.

        Returns
        -------
        d : int
            Dimension of the values of the fields.

        """
        return _func.ProcessSample_getDimension(self)

    def computeMean(self):
        """
        Compute the mean field of the collection of fields.

        Returns
        -------
        mean : :class:`~openturns.Field`
            The mean field has the same dimension `d` and the same mesh as the fields
            contained in the collection. At each vertex of the mesh, we calculate the
            mean of the values at this vertex of the `K` fields contained
            in the process sample:

        .. math::

            \\forall i \\in [0,N-1], \\quad \\dfrac{1}{K} \\sum_{k=1}^K \\vect{x}_i^k

        """
        return _func.ProcessSample_computeMean(self)

    def computeTemporalMean(self):
        """
        Compute the temporal mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.NumericalSample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`.
            The `k` numerical point is the temporal mean of the field `k`:

        .. math::

            \\forall k \\in [1,K], \\quad \\dfrac{1}{N}\\sum_{i=0}^{N-1} \\vect{x}_i^k

        This method can be used only when the mesh can be interpreted as a regular grid.

        """
        return _func.ProcessSample_computeTemporalMean(self)

    def computeSpatialMean(self):
        """
        Compute the spatial mean of the values of the fields.

        Returns
        -------
        spatialMean : :class:`~openturns.NumericalSample`
            Its size is the number `K` of fields in the collection.
            Its dimension is `d`. The `k` numerical point is the spatial mean of the field `k`:

        .. math::

            \\forall k \\in [1,K], \\quad \\dfrac{1}{N}\\sum_{i=0}^{N-1} \\vect{x}_i^k

        """
        return _func.ProcessSample_computeSpatialMean(self)

    def computeQuantilePerComponent(self, *args):
        """
        Compute the temporal mean of the values of the fields.

        Parameters
        ----------
        p : float, :math:`0 \\leq p \\leq 1`
            Order of the quantile.

        Returns
        -------
        quantileField : :class:`~openturns.Field`
            This field has the same size and the same dimension as the fields
            of the collection. At each vertex of the mesh, we estimate the
            component-wise quantile of order `p`, using the empirical quantile.

        """
        return _func.ProcessSample_computeQuantilePerComponent(self, *args)

    def getMarginal(self, *args): return _func.ProcessSample_getMarginal(self, *args)
    def drawMarginal(self, index=0):
        """
        Draw the selected field.

        Parameters
        ----------
        indice : int
            Index of the field that is drawn in the graph.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the selected field using the `interpolate` method.

        """
        return _func.ProcessSample_drawMarginal(self, index)

    def __init__(self, *args): 
        this = _func.new_ProcessSample(*args)
        try: self.this.append(this)
        except: self.this = this
    def __getitem__(self, *args): return _func.ProcessSample___getitem__(self, *args)
    def __setitem__(self, *args): return _func.ProcessSample___setitem__(self, *args)
    def __len__(self): return _func.ProcessSample___len__(self)
    __swig_destroy__ = _func.delete_ProcessSample
    __del__ = lambda self : None;
ProcessSample_swigregister = _func.ProcessSample_swigregister
ProcessSample_swigregister(ProcessSample)

class SpecFunc(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpecFunc, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SpecFunc, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["IsNaN"] = lambda x: _func.SpecFunc_IsNaN
    if _newclass:IsNaN = staticmethod(_func.SpecFunc_IsNaN)
    __swig_getmethods__["IsNormal"] = lambda x: _func.SpecFunc_IsNormal
    if _newclass:IsNormal = staticmethod(_func.SpecFunc_IsNormal)
    def BesselI0(*args):
        """
        Modified first kind Bessel function of order 0.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{I}_0(x) = \\sum_{m=0}^\\infty\\frac{1}{m!^2}\\left(\\frac{x}{2}\\right)^{2m}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselI0(*args)

    if _newclass:BesselI0 = staticmethod(BesselI0)
    __swig_getmethods__["BesselI0"] = lambda x: BesselI0
    def LogBesselI0(*args):
        """
        Logarithm of the modified first kind Bessel function of order 0.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselI0(x) = \\log (\\mathrm{I}_0(x))

        See also
        --------
        SpecFunc_BesselI0

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselI0(*args)

    if _newclass:LogBesselI0 = staticmethod(LogBesselI0)
    __swig_getmethods__["LogBesselI0"] = lambda x: LogBesselI0
    def BesselI1(*args):
        """
        Modified first kind Bessel function of order 1.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{I}_1(x) = \\sum_{m=0}^\\infty\\frac{1}{m!(m+1)!}\\left(\\frac{x}{2}\\right)^{2m+1}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselI1(*args)

    if _newclass:BesselI1 = staticmethod(BesselI1)
    __swig_getmethods__["BesselI1"] = lambda x: BesselI1
    def LogBesselI1(*args):
        """
        Logarithm of the modified first kind Bessel function of order 1.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselI1(x) = \\log (\\mathrm{I}_1(x))

        See also
        --------
        SpecFunc_BesselI1

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselI1(*args)

    if _newclass:LogBesselI1 = staticmethod(LogBesselI1)
    __swig_getmethods__["LogBesselI1"] = lambda x: LogBesselI1
    __swig_getmethods__["DeltaLogBesselI10"] = lambda x: _func.SpecFunc_DeltaLogBesselI10
    if _newclass:DeltaLogBesselI10 = staticmethod(_func.SpecFunc_DeltaLogBesselI10)
    def LogBesselK(*args):
        """
        Logarithm of the modified second kind Bessel function of order :math:`\\nu`.

        .. math::

            \\forall x \\in \\Rset, \\quad
            LogBesselK(\\nu, x) = \\log(\\mathrm{K}_{\\nu}(x))

        See also
        --------
        SpecFunc_BesselK

        Parameters
        ----------
        nu : float
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBesselK(*args)

    if _newclass:LogBesselK = staticmethod(LogBesselK)
    __swig_getmethods__["LogBesselK"] = lambda x: LogBesselK
    def BesselK(*args):
        """
        Modified second kind Bessel function of order :math:`\\nu`.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{K}_{\\nu}(x) = \\frac{\\pi}{2}\\frac{\\mathrm{I}_{-\\nu}(x)-\\mathrm{I}_{\\nu}(x)}{\\sin{\\nu\\pi}}

        Parameters
        ----------
        nu : float
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_BesselK(*args)

    if _newclass:BesselK = staticmethod(BesselK)
    __swig_getmethods__["BesselK"] = lambda x: BesselK
    __swig_getmethods__["BesselKDerivative"] = lambda x: _func.SpecFunc_BesselKDerivative
    if _newclass:BesselKDerivative = staticmethod(_func.SpecFunc_BesselKDerivative)
    def Beta(*args):
        """
        Beta function :math:`\\mathrm{B}`.

        .. math::

            \\forall (a, b) > 0, \\quad
            \\mathrm{B}(a, b) = \\int_0^1 t^{a-1}(1-t)^{b-1}\\di{t}

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Beta(*args)

    if _newclass:Beta = staticmethod(Beta)
    __swig_getmethods__["Beta"] = lambda x: Beta
    def IncompleteBeta(*args):
        """
        Incomplete Beta function.

        .. math::

            \\forall (a, b) > 0, t \\in [0, 1], \\quad
            \\mathrm{B}(x; a, b) = \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{B}(x; a, b)`.
            - If *tail* is *True*: :math:`result = \\mathrm{B}(a, b) - \\mathrm{B}(x; a, b)`.
        """
        return _func.SpecFunc_IncompleteBeta(*args)

    if _newclass:IncompleteBeta = staticmethod(IncompleteBeta)
    __swig_getmethods__["IncompleteBeta"] = lambda x: IncompleteBeta
    def IncompleteBetaInverse(*args):
        """
        Inverse of the incomplete Beta function.

        .. math::

            \\forall (a, b) > 0 \\quad
            IncompleteBetaInverse(x; a, b) = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)

        See also
        --------
        SpecFunc_IncompleteBeta, SpecFunc_RegularizedIncompleteBetaInverse

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); b, a)`.
        """
        return _func.SpecFunc_IncompleteBetaInverse(*args)

    if _newclass:IncompleteBetaInverse = staticmethod(IncompleteBetaInverse)
    __swig_getmethods__["IncompleteBetaInverse"] = lambda x: IncompleteBetaInverse
    def RegularizedIncompleteBeta(*args):
        """
        Regularized incomplete Beta function.

        .. math::

            \\forall (a, b) > 0 \\quad
            \\mathrm{I}(x; a, b) = \\frac{\\mathrm{B}(x; a, b)}{\\mathrm{B}(a, b)}
                                = \\frac{1}{\\mathrm{B}(a, b)} \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

        with :math:`B(a, b)` the Beta function and :math:`B(x; a, b)` the incomplete
        Beta function.

        See also
        --------
        SpecFunc_IncompleteBeta, SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{I}(x; a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}(x; a, b)`.
        """
        return _func.SpecFunc_RegularizedIncompleteBeta(*args)

    if _newclass:RegularizedIncompleteBeta = staticmethod(RegularizedIncompleteBeta)
    __swig_getmethods__["RegularizedIncompleteBeta"] = lambda x: RegularizedIncompleteBeta
    def RegularizedIncompleteBetaInverse(*args):
        """
        Inverse of the regularized incomplete Beta function.

        .. math::

            \\forall (a, b) > 0, \\quad
            RegularizedIncompleteBetaInverse(x; a, b) = \\mathrm{I}^{-1}(x; a, b)

        See also
        --------
        SpecFunc_RegularizedIncompleteBeta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{I}^{-1}(x; a, b)`.
            - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}^{-1}(x; b, a)`.
        """
        return _func.SpecFunc_RegularizedIncompleteBetaInverse(*args)

    if _newclass:RegularizedIncompleteBetaInverse = staticmethod(RegularizedIncompleteBetaInverse)
    __swig_getmethods__["RegularizedIncompleteBetaInverse"] = lambda x: RegularizedIncompleteBetaInverse
    def LnBeta(*args):
        """
        Logarithm of the Beta function.

        .. math::

            \\forall (a, b) > 0,\\quad
            LnBeta(a, b) = \\ln (\\mathrm{B}(a, b)) = \\log (\\mathrm{B}(a, b))

        See also
        --------
        SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LnBeta(*args)

    if _newclass:LnBeta = staticmethod(LnBeta)
    __swig_getmethods__["LnBeta"] = lambda x: LnBeta
    def LogBeta(*args):
        """
        Logarithm of the Beta function.

        .. math::

            \\forall (a, b) > 0, \\quad
            LogBeta(a, b) = \\log (\\mathrm{B}(a, b))

        See also
        --------
        SpecFunc_Beta

        Parameters
        ----------
        a, b : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogBeta(*args)

    if _newclass:LogBeta = staticmethod(LogBeta)
    __swig_getmethods__["LogBeta"] = lambda x: LogBeta
    def Dawson(*args):
        """
        Dawson function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            \\mathrm{D}_+(x) = \\exp(-x^2)\\int_0^x \\exp(t^2)\\di{t}

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Dawson(*args)

    if _newclass:Dawson = staticmethod(Dawson)
    __swig_getmethods__["Dawson"] = lambda x: Dawson
    def Debye(*args):
        """
        Debye function of order :math:`n`.

        .. math::

            \\forall x \\in \\Rset, \\forall n \\in \\Nset^* \\text{and} \\, n \\leq 20, \\quad
            \\mathrm{D}_n(x) = \\frac{n}{x^n} \\int_0^x \\frac{t^n}{\\exp(t)-1}\\di{t}

        Parameters
        ----------
        x : float
        n : int :math:`\\in \\{1, \\cdots, 20\\}`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Debye(*args)

    if _newclass:Debye = staticmethod(Debye)
    __swig_getmethods__["Debye"] = lambda x: Debye
    def DiLog(*args):
        """
        Dilogarithm function.

        .. math::

            \\forall x \\in ]-\\infty, 1[, \\quad
            Li_2(x) = -\\int_0^x \\frac{\\log (1-t)}{t}\\di{t}

        Parameters
        ----------
        x : float :math:`\\in ]-\\infty, 1[`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiLog(*args)

    if _newclass:DiLog = staticmethod(DiLog)
    __swig_getmethods__["DiLog"] = lambda x: DiLog
    def Ei(*args):
        """
        Exponential integral function.

        .. math::

            \\forall z \\in \\Cset, \\quad
            \\mathrm{Ei}(z) = -\\int_{-z}^{\\infty} \\frac{\\exp(-t)}{t}\\di{t}

        Parameters
        ----------
        z : float or complex

        Returns
        -------
        result : float or complex (same as z)
        """
        return _func.SpecFunc_Ei(*args)

    if _newclass:Ei = staticmethod(Ei)
    __swig_getmethods__["Ei"] = lambda x: Ei
    def Faddeeva(*args):
        """
        Complex Faddeeva function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            \\mathrm{W}(x) = \\exp(-x^2)\\mathrm{erfc}(-ix)

        with :math:`ErfC` the complementary error function.

        See also
        --------
        SpecFunc_ErfC

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Faddeeva(*args)

    if _newclass:Faddeeva = staticmethod(Faddeeva)
    __swig_getmethods__["Faddeeva"] = lambda x: Faddeeva
    def FaddeevaIm(*args):
        """
        Imaginary part of the Faddeeva function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            FaddeevaIm(x) = \\Im (\\mathrm{W}(x))

        See also
        --------
        SpecFunc_Faddeeva

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_FaddeevaIm(*args)

    if _newclass:FaddeevaIm = staticmethod(FaddeevaIm)
    __swig_getmethods__["FaddeevaIm"] = lambda x: FaddeevaIm
    def IGamma1pm1(*args):
        """
        IGamma1pm1 function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            IGamma1pm1(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_IGamma1pm1(*args)

    if _newclass:IGamma1pm1 = staticmethod(IGamma1pm1)
    __swig_getmethods__["IGamma1pm1"] = lambda x: IGamma1pm1
    def GammaCorrection(*args):
        """
        GammaCorrection function.

        .. math::

            \\forall x \\in \\Rset^*_+, \\quad
            GammaCorrection(a) = \\log (\\Gamma(a)) - \\log (\\sqrt{2\\Pi}) + a - (a - 0.5) \\log(a)

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_GammaCorrection(*args)

    if _newclass:GammaCorrection = staticmethod(GammaCorrection)
    __swig_getmethods__["GammaCorrection"] = lambda x: GammaCorrection
    def Gamma(*args):
        """
        Gamma function :math:`\\Gamma`.

        .. math::

            \\forall a \\in \\Cset, \\quad
            \\Gamma(a) = \\int_0^{\\infty} t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        a : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Gamma(*args)

    if _newclass:Gamma = staticmethod(Gamma)
    __swig_getmethods__["Gamma"] = lambda x: Gamma
    def LnGamma(*args):
        """
        Logarithm of the Gamma function.

        .. math::

            \\forall a \\in \\Rset, \\quad
            LnGamma(a) = \\ln (\\Gamma(a))

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LnGamma(*args)

    if _newclass:LnGamma = staticmethod(LnGamma)
    __swig_getmethods__["LnGamma"] = lambda x: LnGamma
    def LogGamma1p(*args):
        """
        LogGamma1p function.

        .. math::

            \\forall a \\in \\Rset, \\quad
            LogGamma1p(a) = \\log (\\Gamma(1+a))

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_LogGamma1p(*args)

    if _newclass:LogGamma1p = staticmethod(LogGamma1p)
    __swig_getmethods__["LogGamma1p"] = lambda x: LogGamma1p
    def LogGamma(*args):
        """
        Logarithm of the Gamma function.

        .. math::

            \\forall a \\in \\Cset, \\quad
            LogGamma(a) = \\log (\\Gamma(a))

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        a : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_LogGamma(*args)

    if _newclass:LogGamma = staticmethod(LogGamma)
    __swig_getmethods__["LogGamma"] = lambda x: LogGamma
    def IncompleteGamma(*args):
        """
        Incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\gamma(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\gamma(a, x)`.
            - If *tail* is *True*: :math:`result = \\Gamma(a) - \\gamma(a, x)`.
        """
        return _func.SpecFunc_IncompleteGamma(*args)

    if _newclass:IncompleteGamma = staticmethod(IncompleteGamma)
    __swig_getmethods__["IncompleteGamma"] = lambda x: IncompleteGamma
    def IncompleteGammaInverse(*args):
        """
        Inverse of the incomplete Gamma function with respect to :math:`x`.

        .. math::

            IncompleteGammaInverse(a, x) = \\gamma^{-1}(a, x)

        See also
        --------
        SpecFunc_IncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x/\\Gamma(a))`.
            - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, (1-x)/\\Gamma(a))`.
        """
        return _func.SpecFunc_IncompleteGammaInverse(*args)

    if _newclass:IncompleteGammaInverse = staticmethod(IncompleteGammaInverse)
    __swig_getmethods__["IncompleteGammaInverse"] = lambda x: IncompleteGammaInverse
    def RegularizedIncompleteGamma(*args):
        """
        Regularized incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            \\mathrm{P}(a, x) = \\frac{\\gamma(a, x)}{\\Gamma(a)}
                             = \\frac{1}{\\Gamma(a)}\\int_0^x t^{a-1}\\exp(-t)\\di{t}

        See also
        --------
        SpecFunc_Gamma, SpecFunc_IncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}(a, x)`.
            - If *tail* is *True*: :math:`result = \\Gamma(a) - \\mathrm{P}(a, x)`.
        """
        return _func.SpecFunc_RegularizedIncompleteGamma(*args)

    if _newclass:RegularizedIncompleteGamma = staticmethod(RegularizedIncompleteGamma)
    __swig_getmethods__["RegularizedIncompleteGamma"] = lambda x: RegularizedIncompleteGamma
    def RegularizedIncompleteGammaInverse(*args):
        """
        Inverse of the regularized incomplete Gamma function.

        .. math::

            \\forall x \\in \\Rset, \\quad
            RegularizedIncompleteGammaInverse(a, x) = \\mathrm{P}^{-1}(a, x)

        See also
        --------
        SpecFunc_Gamma, SpecFunc_RegularizedIncompleteGamma

        Parameters
        ----------
        a : float :math:`\\in \\Rset^*_+`
        x : float :math:`\\in [0, 1]`
        tail : bool, optional
            By default, *tail* is *False*.

        Returns
        -------
        result : float
            - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x)`.
            - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, 1-x)`.
        """
        return _func.SpecFunc_RegularizedIncompleteGammaInverse(*args)

    if _newclass:RegularizedIncompleteGammaInverse = staticmethod(RegularizedIncompleteGammaInverse)
    __swig_getmethods__["RegularizedIncompleteGammaInverse"] = lambda x: RegularizedIncompleteGammaInverse
    def DiGamma(*args):
        """
        Digamma function.

        .. math::

            \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiGamma(*args)

    if _newclass:DiGamma = staticmethod(DiGamma)
    __swig_getmethods__["DiGamma"] = lambda x: DiGamma
    def Psi(*args):
        """
        Psi function.

        .. math::

            \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Psi(*args)

    if _newclass:Psi = staticmethod(Psi)
    __swig_getmethods__["Psi"] = lambda x: Psi
    def DiGammaInv(*args):
        """
        Inverse of the DiGamma function.

        .. math::

            DiGammaInv(x) = \\Psi^{-1} (x)

        See also
        --------
        SpecFunc_DiGamma

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_DiGammaInv(*args)

    if _newclass:DiGammaInv = staticmethod(DiGammaInv)
    __swig_getmethods__["DiGammaInv"] = lambda x: DiGammaInv
    def TriGamma(*args):
        """
        TriGamma function.

        .. math::

            \\Psi_1(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d}^2 \\Gamma(x)}{\\mathrm{d}x^2}

        with :math:`\\Gamma` the Gamma function.

        See also
        --------
        SpecFunc_Gamma

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_TriGamma(*args)

    if _newclass:TriGamma = staticmethod(TriGamma)
    __swig_getmethods__["TriGamma"] = lambda x: TriGamma
    def HyperGeom_1_1(*args):
        """
        Hypergeometric function of type (1,1).

        .. math::

            {}_1F_1(p_1, q_1, x) = \\sum_{n=0}^{\\infty}
                                   \\left[
                                   \\prod_{k=0}^{n-1} \\frac{(p_1 + k)}{(q_1 + k)}
                                   \\right]  \\frac{x^n}{n!}

        Parameters
        ----------
        p1, q1 : float
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_HyperGeom_1_1(*args)

    if _newclass:HyperGeom_1_1 = staticmethod(HyperGeom_1_1)
    __swig_getmethods__["HyperGeom_1_1"] = lambda x: HyperGeom_1_1
    def HyperGeom_2_1(*args):
        """
        Hypergeometric function of type (2,1).

        .. math::

            {}_2F_1(p_1, p_2, q_1, x) = \\sum_{n=0}^{\\infty}
                                        \\left[
                                        \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k)}
                                        \\right] \\frac{x^n}{n!}

        Parameters
        ----------
        p1, p2, q1, x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_HyperGeom_2_1(*args)

    if _newclass:HyperGeom_2_1 = staticmethod(HyperGeom_2_1)
    __swig_getmethods__["HyperGeom_2_1"] = lambda x: HyperGeom_2_1
    def HyperGeom_2_2(*args):
        """
        Hypergeometric function of type (2,2).

        .. math::

            {}_2F_2(p_1, p_2, q_1, q_2, x) = \\sum_{n=0}^{\\infty}
                                 \\left[
                                 \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k) (q_2 + k)}
                                 \\right] \\frac{x^n}{n!}

        Parameters
        ----------
        p1, p2, q1, q2, x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_HyperGeom_2_2(*args)

    if _newclass:HyperGeom_2_2 = staticmethod(HyperGeom_2_2)
    __swig_getmethods__["HyperGeom_2_2"] = lambda x: HyperGeom_2_2
    def Erf(*args):
        """
        Error function Erf.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Erf(x) = \\frac{2}{\\sqrt{\\pi}} \\int_0^x \\exp(-t^2)\\di{t}

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_Erf(*args)

    if _newclass:Erf = staticmethod(Erf)
    __swig_getmethods__["Erf"] = lambda x: Erf
    def ErfI(*args):
        """
        Imaginary error function ErfI.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfI(x) = -i Erf(ix)

        with :math:`Erf` the error function.

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfI(*args)

    if _newclass:ErfI = staticmethod(ErfI)
    __swig_getmethods__["ErfI"] = lambda x: ErfI
    def ErfC(*args):
        """
        Complementary error function ErfC.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfC(x) = 1 - Erf(x)

        with :math:`Erf` the error function.

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfC(*args)

    if _newclass:ErfC = staticmethod(ErfC)
    __swig_getmethods__["ErfC"] = lambda x: ErfC
    def ErfCX(*args):
        """
        ErfCX function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfCX(x) = \\exp(x^2).ErfC(x)

        with :math:`ErfC` the complementary error function.

        See also
        --------
        SpecFunc_ErfC

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : float or complex
        """
        return _func.SpecFunc_ErfCX(*args)

    if _newclass:ErfCX = staticmethod(ErfCX)
    __swig_getmethods__["ErfCX"] = lambda x: ErfCX
    def ErfInverse(*args):
        """
        Inverse of the error function Erf.

        .. math::

            \\forall x \\in \\Cset, \\quad
            ErfInverse(x) = Erf^{-1} (x)

        See also
        --------
        SpecFunc_Erf

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_ErfInverse(*args)

    if _newclass:ErfInverse = staticmethod(ErfInverse)
    __swig_getmethods__["ErfInverse"] = lambda x: ErfInverse
    def LambertW(*args):
        """
        Lambert W function.

        The Lambert W function :math:`\\mathrm{W}(x)` is defined by the relation:

        .. math::

            x = \\mathrm{W}(x) \\exp(\\mathrm{W}(x))

        Parameters
        ----------
        x : float
        principal : bool, optional
            By default, *principal* is *True*.

        Returns
        -------
        result : float
            - If *principal* is *True* : :math:`result = \\mathrm{W}_0(x)`.
              :math:`\\mathrm{W}_0(x)` is referred to as the principal branch of the Lambert W
              function. It denotes the upper part of the function whose domain is
              :math:`[-1/e, +\\infty[` and range :math:`[-1, +\\infty[`.
            - If *principal* is *False* : :math:`result = \\mathrm{W}_{-1}(x)`.
              :math:`\\mathrm{W}_{-1}(x)` is the second real branch of the Lambert W function.
              It denotes the lower part of the function whose domain is
              :math:`[-1/e, 0[` and range :math:`]-\\infty, -1]`.
        """
        return _func.SpecFunc_LambertW(*args)

    if _newclass:LambertW = staticmethod(LambertW)
    __swig_getmethods__["LambertW"] = lambda x: LambertW
    def Log1p(*args):
        """
        Log1p function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Log1p(x) = \\log (1+x)

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Log1p(*args)

    if _newclass:Log1p = staticmethod(Log1p)
    __swig_getmethods__["Log1p"] = lambda x: Log1p
    def Expm1(*args):
        """
        Expm1 function.

        .. math::

            \\forall x \\in \\Cset, \\quad
            Expm1(x) = \\exp(x)-1

        Parameters
        ----------
        x : float or complex

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Expm1(*args)

    if _newclass:Expm1 = staticmethod(Expm1)
    __swig_getmethods__["Expm1"] = lambda x: Expm1
    def Log1MExp(*args):
        """
        Log1MExp function.

        .. math::

            \\forall x \\in \\Rset^+, \\quad
            Log1MExp(x) = \\log (1-\\exp(-x))

        Parameters
        ----------
        x : float :math:`\\in \\Rset^*_+`

        Returns
        -------
        result : complex
        """
        return _func.SpecFunc_Log1MExp(*args)

    if _newclass:Log1MExp = staticmethod(Log1MExp)
    __swig_getmethods__["Log1MExp"] = lambda x: Log1MExp
    def NextPowerOfTwo(*args):
        """
        Smallest power of two greater or equal to the given :math:`n`.

        .. math::

            NextPowerOfTwo(n) = 2^{\\lceil \\log_2(n)\\rceil}

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.NextPowerOfTwo(42))
        64
        """
        return _func.SpecFunc_NextPowerOfTwo(*args)

    if _newclass:NextPowerOfTwo = staticmethod(NextPowerOfTwo)
    __swig_getmethods__["NextPowerOfTwo"] = lambda x: NextPowerOfTwo
    def Log2(*args):
        """
        Integer base 2 logarithm of :math:`n`.

        .. math::

            Log2(n) = \\log_2(n)

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.Log2(42))
        5
        """
        return _func.SpecFunc_Log2(*args)

    if _newclass:Log2 = staticmethod(Log2)
    __swig_getmethods__["Log2"] = lambda x: Log2
    def BitCount(*args):
        """
        Compute the number of bits set to 1 in an integer.

        Parameters
        ----------
        n : positive int

        Returns
        -------
        result : positive int

        Examples
        --------
        >>> import openturns as ot
        >>> int(ot.SpecFunc.BitCount(42))
        3
        """
        return _func.SpecFunc_BitCount(*args)

    if _newclass:BitCount = staticmethod(BitCount)
    __swig_getmethods__["BitCount"] = lambda x: BitCount
    def Cbrt(*args):
        """
        Cubit root function.

        Parameters
        ----------
        x : float

        Returns
        -------
        result : float
        """
        return _func.SpecFunc_Cbrt(*args)

    if _newclass:Cbrt = staticmethod(Cbrt)
    __swig_getmethods__["Cbrt"] = lambda x: Cbrt
    def BinomialCoefficient(*args):
        """
        Binomial coefficient.

        Returns the value :math:`C_k^n = \\binom{n}{k}`

        Parameters
        ----------
        n : int
        k : int

        Returns
        -------
        result : int
        """
        return _func.SpecFunc_BinomialCoefficient(*args)

    if _newclass:BinomialCoefficient = staticmethod(BinomialCoefficient)
    __swig_getmethods__["BinomialCoefficient"] = lambda x: BinomialCoefficient
    __swig_destroy__ = _func.delete_SpecFunc
    __del__ = lambda self : None;
SpecFunc_swigregister = _func.SpecFunc_swigregister
SpecFunc_swigregister(SpecFunc)
cvar = _func.cvar
SpecFunc.ISQRT2PI = _func.cvar.SpecFunc_ISQRT2PI
SpecFunc.SQRT2PI = _func.cvar.SpecFunc_SQRT2PI
SpecFunc.LOGSQRT2PI = _func.cvar.SpecFunc_LOGSQRT2PI
SpecFunc.EulerConstant = _func.cvar.SpecFunc_EulerConstant
SpecFunc.PI2_6 = _func.cvar.SpecFunc_PI2_6
SpecFunc.PI_SQRT6 = _func.cvar.SpecFunc_PI_SQRT6
SpecFunc.EULERSQRT6_PI = _func.cvar.SpecFunc_EULERSQRT6_PI
SpecFunc.PI2_3 = _func.cvar.SpecFunc_PI2_3
SpecFunc.SQRT3_PI = _func.cvar.SpecFunc_SQRT3_PI
SpecFunc.PI_SQRT3 = _func.cvar.SpecFunc_PI_SQRT3
SpecFunc.ZETA3 = _func.cvar.SpecFunc_ZETA3
SpecFunc.MaximumIteration = _func.cvar.SpecFunc_MaximumIteration
SpecFunc.Precision = _func.cvar.SpecFunc_Precision
SpecFunc.MinNumericalScalar = _func.cvar.SpecFunc_MinNumericalScalar
SpecFunc.LogMinNumericalScalar = _func.cvar.SpecFunc_LogMinNumericalScalar
SpecFunc.MaxNumericalScalar = _func.cvar.SpecFunc_MaxNumericalScalar
SpecFunc.LogMaxNumericalScalar = _func.cvar.SpecFunc_LogMaxNumericalScalar
SpecFunc.NumericalScalarEpsilon = _func.cvar.SpecFunc_NumericalScalarEpsilon

def SpecFunc_IsNaN(*args):
  return _func.SpecFunc_IsNaN(*args)
SpecFunc_IsNaN = _func.SpecFunc_IsNaN

def SpecFunc_IsNormal(*args):
  return _func.SpecFunc_IsNormal(*args)
SpecFunc_IsNormal = _func.SpecFunc_IsNormal

def SpecFunc_BesselI0(*args):
  """
    Modified first kind Bessel function of order 0.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{I}_0(x) = \\sum_{m=0}^\\infty\\frac{1}{m!^2}\\left(\\frac{x}{2}\\right)^{2m}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_BesselI0(*args)

def SpecFunc_LogBesselI0(*args):
  """
    Logarithm of the modified first kind Bessel function of order 0.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselI0(x) = \\log (\\mathrm{I}_0(x))

    See also
    --------
    SpecFunc_BesselI0

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LogBesselI0(*args)

def SpecFunc_BesselI1(*args):
  """
    Modified first kind Bessel function of order 1.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{I}_1(x) = \\sum_{m=0}^\\infty\\frac{1}{m!(m+1)!}\\left(\\frac{x}{2}\\right)^{2m+1}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_BesselI1(*args)

def SpecFunc_LogBesselI1(*args):
  """
    Logarithm of the modified first kind Bessel function of order 1.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselI1(x) = \\log (\\mathrm{I}_1(x))

    See also
    --------
    SpecFunc_BesselI1

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LogBesselI1(*args)

def SpecFunc_DeltaLogBesselI10(*args):
  return _func.SpecFunc_DeltaLogBesselI10(*args)
SpecFunc_DeltaLogBesselI10 = _func.SpecFunc_DeltaLogBesselI10

def SpecFunc_LogBesselK(*args):
  """
    Logarithm of the modified second kind Bessel function of order :math:`\\nu`.

    .. math::

        \\forall x \\in \\Rset, \\quad
        LogBesselK(\\nu, x) = \\log(\\mathrm{K}_{\\nu}(x))

    See also
    --------
    SpecFunc_BesselK

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LogBesselK(*args)

def SpecFunc_BesselK(*args):
  """
    Modified second kind Bessel function of order :math:`\\nu`.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{K}_{\\nu}(x) = \\frac{\\pi}{2}\\frac{\\mathrm{I}_{-\\nu}(x)-\\mathrm{I}_{\\nu}(x)}{\\sin{\\nu\\pi}}

    Parameters
    ----------
    nu : float
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_BesselK(*args)

def SpecFunc_BesselKDerivative(*args):
  return _func.SpecFunc_BesselKDerivative(*args)
SpecFunc_BesselKDerivative = _func.SpecFunc_BesselKDerivative

def SpecFunc_Beta(*args):
  """
    Beta function :math:`\\mathrm{B}`.

    .. math::

        \\forall (a, b) > 0, \\quad
        \\mathrm{B}(a, b) = \\int_0^1 t^{a-1}(1-t)^{b-1}\\di{t}

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_Beta(*args)

def SpecFunc_IncompleteBeta(*args):
  """
    Incomplete Beta function.

    .. math::

        \\forall (a, b) > 0, t \\in [0, 1], \\quad
        \\mathrm{B}(x; a, b) = \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{B}(x; a, b)`.
        - If *tail* is *True*: :math:`result = \\mathrm{B}(a, b) - \\mathrm{B}(x; a, b)`.
    """
  return _func.SpecFunc_IncompleteBeta(*args)

def SpecFunc_IncompleteBetaInverse(*args):
  """
    Inverse of the incomplete Beta function.

    .. math::

        \\forall (a, b) > 0 \\quad
        IncompleteBetaInverse(x; a, b) = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)

    See also
    --------
    SpecFunc_IncompleteBeta, SpecFunc_RegularizedIncompleteBetaInverse

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{B}^{-1}(x/\\mathrm{B}(a, b); b, a)`.
    """
  return _func.SpecFunc_IncompleteBetaInverse(*args)

def SpecFunc_RegularizedIncompleteBeta(*args):
  """
    Regularized incomplete Beta function.

    .. math::

        \\forall (a, b) > 0 \\quad
        \\mathrm{I}(x; a, b) = \\frac{\\mathrm{B}(x; a, b)}{\\mathrm{B}(a, b)}
                            = \\frac{1}{\\mathrm{B}(a, b)} \\int_0^x t^{a-1}(1-t)^{b-1}\\di{t}

    with :math:`B(a, b)` the Beta function and :math:`B(x; a, b)` the incomplete
    Beta function.

    See also
    --------
    SpecFunc_IncompleteBeta, SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{I}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}(x; a, b)`.
    """
  return _func.SpecFunc_RegularizedIncompleteBeta(*args)

def SpecFunc_RegularizedIncompleteBetaInverse(*args):
  """
    Inverse of the regularized incomplete Beta function.

    .. math::

        \\forall (a, b) > 0, \\quad
        RegularizedIncompleteBetaInverse(x; a, b) = \\mathrm{I}^{-1}(x; a, b)

    See also
    --------
    SpecFunc_RegularizedIncompleteBeta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{I}^{-1}(x; a, b)`.
        - If *tail* is *True*: :math:`result = 1 - \\mathrm{I}^{-1}(x; b, a)`.
    """
  return _func.SpecFunc_RegularizedIncompleteBetaInverse(*args)

def SpecFunc_LnBeta(*args):
  """
    Logarithm of the Beta function.

    .. math::

        \\forall (a, b) > 0,\\quad
        LnBeta(a, b) = \\ln (\\mathrm{B}(a, b)) = \\log (\\mathrm{B}(a, b))

    See also
    --------
    SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LnBeta(*args)

def SpecFunc_LogBeta(*args):
  """
    Logarithm of the Beta function.

    .. math::

        \\forall (a, b) > 0, \\quad
        LogBeta(a, b) = \\log (\\mathrm{B}(a, b))

    See also
    --------
    SpecFunc_Beta

    Parameters
    ----------
    a, b : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LogBeta(*args)

def SpecFunc_Dawson(*args):
  """
    Dawson function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        \\mathrm{D}_+(x) = \\exp(-x^2)\\int_0^x \\exp(t^2)\\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_Dawson(*args)

def SpecFunc_Debye(*args):
  """
    Debye function of order :math:`n`.

    .. math::

        \\forall x \\in \\Rset, \\forall n \\in \\Nset^* \\text{and} \\, n \\leq 20, \\quad
        \\mathrm{D}_n(x) = \\frac{n}{x^n} \\int_0^x \\frac{t^n}{\\exp(t)-1}\\di{t}

    Parameters
    ----------
    x : float
    n : int :math:`\\in \\{1, \\cdots, 20\\}`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_Debye(*args)

def SpecFunc_DiLog(*args):
  """
    Dilogarithm function.

    .. math::

        \\forall x \\in ]-\\infty, 1[, \\quad
        Li_2(x) = -\\int_0^x \\frac{\\log (1-t)}{t}\\di{t}

    Parameters
    ----------
    x : float :math:`\\in ]-\\infty, 1[`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_DiLog(*args)

def SpecFunc_Ei(*args):
  """
    Exponential integral function.

    .. math::

        \\forall z \\in \\Cset, \\quad
        \\mathrm{Ei}(z) = -\\int_{-z}^{\\infty} \\frac{\\exp(-t)}{t}\\di{t}

    Parameters
    ----------
    z : float or complex

    Returns
    -------
    result : float or complex (same as z)
    """
  return _func.SpecFunc_Ei(*args)

def SpecFunc_Faddeeva(*args):
  """
    Complex Faddeeva function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        \\mathrm{W}(x) = \\exp(-x^2)\\mathrm{erfc}(-ix)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    SpecFunc_ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
  return _func.SpecFunc_Faddeeva(*args)

def SpecFunc_FaddeevaIm(*args):
  """
    Imaginary part of the Faddeeva function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        FaddeevaIm(x) = \\Im (\\mathrm{W}(x))

    See also
    --------
    SpecFunc_Faddeeva

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_FaddeevaIm(*args)

def SpecFunc_IGamma1pm1(*args):
  """
    IGamma1pm1 function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        IGamma1pm1(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_IGamma1pm1(*args)

def SpecFunc_GammaCorrection(*args):
  """
    GammaCorrection function.

    .. math::

        \\forall x \\in \\Rset^*_+, \\quad
        GammaCorrection(a) = \\log (\\Gamma(a)) - \\log (\\sqrt{2\\Pi}) + a - (a - 0.5) \\log(a)

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_GammaCorrection(*args)

def SpecFunc_Gamma(*args):
  """
    Gamma function :math:`\\Gamma`.

    .. math::

        \\forall a \\in \\Cset, \\quad
        \\Gamma(a) = \\int_0^{\\infty} t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_Gamma(*args)

def SpecFunc_LnGamma(*args):
  """
    Logarithm of the Gamma function.

    .. math::

        \\forall a \\in \\Rset, \\quad
        LnGamma(a) = \\ln (\\Gamma(a))

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LnGamma(*args)

def SpecFunc_LogGamma1p(*args):
  """
    LogGamma1p function.

    .. math::

        \\forall a \\in \\Rset, \\quad
        LogGamma1p(a) = \\log (\\Gamma(1+a))

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_LogGamma1p(*args)

def SpecFunc_LogGamma(*args):
  """
    Logarithm of the Gamma function.

    .. math::

        \\forall a \\in \\Cset, \\quad
        LogGamma(a) = \\log (\\Gamma(a))

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    a : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_LogGamma(*args)

def SpecFunc_IncompleteGamma(*args):
  """
    Incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\gamma(a, x) = \\int_0^x t^{a-1}\\exp(-t)\\di{t}

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\gamma(a, x)`.
        - If *tail* is *True*: :math:`result = \\Gamma(a) - \\gamma(a, x)`.
    """
  return _func.SpecFunc_IncompleteGamma(*args)

def SpecFunc_IncompleteGammaInverse(*args):
  """
    Inverse of the incomplete Gamma function with respect to :math:`x`.

    .. math::

        IncompleteGammaInverse(a, x) = \\gamma^{-1}(a, x)

    See also
    --------
    SpecFunc_IncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x/\\Gamma(a))`.
        - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, (1-x)/\\Gamma(a))`.
    """
  return _func.SpecFunc_IncompleteGammaInverse(*args)

def SpecFunc_RegularizedIncompleteGamma(*args):
  """
    Regularized incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        \\mathrm{P}(a, x) = \\frac{\\gamma(a, x)}{\\Gamma(a)}
                         = \\frac{1}{\\Gamma(a)}\\int_0^x t^{a-1}\\exp(-t)\\di{t}

    See also
    --------
    SpecFunc_Gamma, SpecFunc_IncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}(a, x)`.
        - If *tail* is *True*: :math:`result = \\Gamma(a) - \\mathrm{P}(a, x)`.
    """
  return _func.SpecFunc_RegularizedIncompleteGamma(*args)

def SpecFunc_RegularizedIncompleteGammaInverse(*args):
  """
    Inverse of the regularized incomplete Gamma function.

    .. math::

        \\forall x \\in \\Rset, \\quad
        RegularizedIncompleteGammaInverse(a, x) = \\mathrm{P}^{-1}(a, x)

    See also
    --------
    SpecFunc_Gamma, SpecFunc_RegularizedIncompleteGamma

    Parameters
    ----------
    a : float :math:`\\in \\Rset^*_+`
    x : float :math:`\\in [0, 1]`
    tail : bool, optional
        By default, *tail* is *False*.

    Returns
    -------
    result : float
        - If *tail* is *False*: :math:`result = \\mathrm{P}^{-1}(a, x)`.
        - If *tail* is *True*: :math:`result = \\mathrm{P}^{-1}(a, 1-x)`.
    """
  return _func.SpecFunc_RegularizedIncompleteGammaInverse(*args)

def SpecFunc_DiGamma(*args):
  """
    Digamma function.

    .. math::

        \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_DiGamma(*args)

def SpecFunc_Psi(*args):
  """
    Psi function.

    .. math::

        \\Psi(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d} \\Gamma(x)}{\\mathrm{d}x}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_Psi(*args)

def SpecFunc_DiGammaInv(*args):
  """
    Inverse of the DiGamma function.

    .. math::

        DiGammaInv(x) = \\Psi^{-1} (x)

    See also
    --------
    SpecFunc_DiGamma

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_DiGammaInv(*args)

def SpecFunc_TriGamma(*args):
  """
    TriGamma function.

    .. math::

        \\Psi_1(x) = \\frac{1}{\\Gamma(x)}\\frac{\\mathrm{d}^2 \\Gamma(x)}{\\mathrm{d}x^2}

    with :math:`\\Gamma` the Gamma function.

    See also
    --------
    SpecFunc_Gamma

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_TriGamma(*args)

def SpecFunc_HyperGeom_1_1(*args):
  """
    Hypergeometric function of type (1,1).

    .. math::

        {}_1F_1(p_1, q_1, x) = \\sum_{n=0}^{\\infty}
                               \\left[
                               \\prod_{k=0}^{n-1} \\frac{(p_1 + k)}{(q_1 + k)}
                               \\right]  \\frac{x^n}{n!}

    Parameters
    ----------
    p1, q1 : float
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_HyperGeom_1_1(*args)

def SpecFunc_HyperGeom_2_1(*args):
  """
    Hypergeometric function of type (2,1).

    .. math::

        {}_2F_1(p_1, p_2, q_1, x) = \\sum_{n=0}^{\\infty}
                                    \\left[
                                    \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k)}
                                    \\right] \\frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_HyperGeom_2_1(*args)

def SpecFunc_HyperGeom_2_2(*args):
  """
    Hypergeometric function of type (2,2).

    .. math::

        {}_2F_2(p_1, p_2, q_1, q_2, x) = \\sum_{n=0}^{\\infty}
                             \\left[
                             \\prod_{k=0}^{n-1} \\frac{(p_1 + k)(p_2 + k)}{(q_1 + k) (q_2 + k)}
                             \\right] \\frac{x^n}{n!}

    Parameters
    ----------
    p1, p2, q1, q2, x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_HyperGeom_2_2(*args)

def SpecFunc_Erf(*args):
  """
    Error function Erf.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Erf(x) = \\frac{2}{\\sqrt{\\pi}} \\int_0^x \\exp(-t^2)\\di{t}

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_Erf(*args)

def SpecFunc_ErfI(*args):
  """
    Imaginary error function ErfI.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfI(x) = -i Erf(ix)

    with :math:`Erf` the error function.

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_ErfI(*args)

def SpecFunc_ErfC(*args):
  """
    Complementary error function ErfC.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfC(x) = 1 - Erf(x)

    with :math:`Erf` the error function.

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_ErfC(*args)

def SpecFunc_ErfCX(*args):
  """
    ErfCX function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfCX(x) = \\exp(x^2).ErfC(x)

    with :math:`ErfC` the complementary error function.

    See also
    --------
    SpecFunc_ErfC

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : float or complex
    """
  return _func.SpecFunc_ErfCX(*args)

def SpecFunc_ErfInverse(*args):
  """
    Inverse of the error function Erf.

    .. math::

        \\forall x \\in \\Cset, \\quad
        ErfInverse(x) = Erf^{-1} (x)

    See also
    --------
    SpecFunc_Erf

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_ErfInverse(*args)

def SpecFunc_LambertW(*args):
  """
    Lambert W function.

    The Lambert W function :math:`\\mathrm{W}(x)` is defined by the relation:

    .. math::

        x = \\mathrm{W}(x) \\exp(\\mathrm{W}(x))

    Parameters
    ----------
    x : float
    principal : bool, optional
        By default, *principal* is *True*.

    Returns
    -------
    result : float
        - If *principal* is *True* : :math:`result = \\mathrm{W}_0(x)`.
          :math:`\\mathrm{W}_0(x)` is referred to as the principal branch of the Lambert W
          function. It denotes the upper part of the function whose domain is
          :math:`[-1/e, +\\infty[` and range :math:`[-1, +\\infty[`.
        - If *principal* is *False* : :math:`result = \\mathrm{W}_{-1}(x)`.
          :math:`\\mathrm{W}_{-1}(x)` is the second real branch of the Lambert W function.
          It denotes the lower part of the function whose domain is
          :math:`[-1/e, 0[` and range :math:`]-\\infty, -1]`.
    """
  return _func.SpecFunc_LambertW(*args)

def SpecFunc_Log1p(*args):
  """
    Log1p function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Log1p(x) = \\log (1+x)

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
  return _func.SpecFunc_Log1p(*args)

def SpecFunc_Expm1(*args):
  """
    Expm1 function.

    .. math::

        \\forall x \\in \\Cset, \\quad
        Expm1(x) = \\exp(x)-1

    Parameters
    ----------
    x : float or complex

    Returns
    -------
    result : complex
    """
  return _func.SpecFunc_Expm1(*args)

def SpecFunc_Log1MExp(*args):
  """
    Log1MExp function.

    .. math::

        \\forall x \\in \\Rset^+, \\quad
        Log1MExp(x) = \\log (1-\\exp(-x))

    Parameters
    ----------
    x : float :math:`\\in \\Rset^*_+`

    Returns
    -------
    result : complex
    """
  return _func.SpecFunc_Log1MExp(*args)

def SpecFunc_NextPowerOfTwo(*args):
  """
    Smallest power of two greater or equal to the given :math:`n`.

    .. math::

        NextPowerOfTwo(n) = 2^{\\lceil \\log_2(n)\\rceil}

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.NextPowerOfTwo(42))
    64
    """
  return _func.SpecFunc_NextPowerOfTwo(*args)

def SpecFunc_Log2(*args):
  """
    Integer base 2 logarithm of :math:`n`.

    .. math::

        Log2(n) = \\log_2(n)

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.Log2(42))
    5
    """
  return _func.SpecFunc_Log2(*args)

def SpecFunc_BitCount(*args):
  """
    Compute the number of bits set to 1 in an integer.

    Parameters
    ----------
    n : positive int

    Returns
    -------
    result : positive int

    Examples
    --------
    >>> import openturns as ot
    >>> int(ot.SpecFunc.BitCount(42))
    3
    """
  return _func.SpecFunc_BitCount(*args)

def SpecFunc_Cbrt(*args):
  """
    Cubit root function.

    Parameters
    ----------
    x : float

    Returns
    -------
    result : float
    """
  return _func.SpecFunc_Cbrt(*args)

def SpecFunc_BinomialCoefficient(*args):
  """
    Binomial coefficient.

    Returns the value :math:`C_k^n = \\binom{n}{k}`

    Parameters
    ----------
    n : int
    k : int

    Returns
    -------
    result : int
    """
  return _func.SpecFunc_BinomialCoefficient(*args)

class NumericalMathEvaluationImplementation(openturns.common.PersistentObject):
    """
    Numerical math evaluation implementation.

    Available constructors:
        NumericalMathEvaluationImplementation()

    See also
    --------
    NumericalMathFunction, AggregatedNumericalMathEvaluationImplementation,
    DatabaseNumericalMathEvaluationImplementation,
    DualLinearCombinationEvaluationImplementation, LinearNumericalMathFunction

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathEvaluationImplementation___str__(self, offset)
    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.NumericalMathEvaluationImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.NumericalMathEvaluationImplementation_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.NumericalMathEvaluationImplementation_getInputDescription(self)

    def setInputDescription(self, *args):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.NumericalMathEvaluationImplementation_setInputDescription(self, *args)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.NumericalMathEvaluationImplementation_getOutputDescription(self)

    def setOutputDescription(self, *args):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.NumericalMathEvaluationImplementation_setOutputDescription(self, *args)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.NumericalMathEvaluationImplementation_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.NumericalMathEvaluationImplementation_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathEvaluationImplementation_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.NumericalMathEvaluationImplementation_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getInputParameterHistory(self)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.NumericalMathEvaluationImplementation_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.NumericalMathEvaluationImplementation_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathEvaluationImplementation_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.NumericalMathEvaluationImplementation_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathEvaluationImplementation_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.NumericalMathEvaluationImplementation_clearCache(self)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NumericalMathEvaluationImplementation_isActualImplementation(self)

    def __call__(self, *args): return _func.NumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NumericalMathEvaluationImplementation_getOutputDimension(self)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.NumericalMathEvaluationImplementation_getParameterDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.NumericalMathEvaluationImplementation_getMarginal(self, *args)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.NumericalMathEvaluationImplementation_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.NumericalMathEvaluationImplementation_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.NumericalMathEvaluationImplementation_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathEvaluationImplementation_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathEvaluationImplementation_setParameterDescription(self, *args)

    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathEvaluationImplementation_getCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.NumericalMathEvaluationImplementation_draw(self, *args)

    def __init__(self, *args): 
        this = _func.new_NumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathEvaluationImplementation
    __del__ = lambda self : None;
NumericalMathEvaluationImplementation_swigregister = _func.NumericalMathEvaluationImplementation_swigregister
NumericalMathEvaluationImplementation_swigregister(NumericalMathEvaluationImplementation)

class NumericalMathGradientImplementation(openturns.common.PersistentObject):
    """
    Numerical math gradient implementation.

    See also
    --------
    NumericalMathFunction, NumericalMathHessianImplementation

    Notes
    -----
    This object is the result of the method *getGradient* of a 
    :class:`~openturns.NumericalMathFunction`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathGradientImplementation___str__(self, offset)
    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.NumericalMathGradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.NumericalMathGradientImplementation_getMarginal(self, *args)

    def isActualImplementation(self): return _func.NumericalMathGradientImplementation_isActualImplementation(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NumericalMathGradientImplementation_getOutputDimension(self)

    def getParameter(self): return _func.NumericalMathGradientImplementation_getParameter(self)
    def setParameter(self, *args): return _func.NumericalMathGradientImplementation_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.NumericalMathGradientImplementation_getCallsNumber(self)

    def __init__(self, *args): 
        this = _func.new_NumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathGradientImplementation
    __del__ = lambda self : None;
NumericalMathGradientImplementation_swigregister = _func.NumericalMathGradientImplementation_swigregister
NumericalMathGradientImplementation_swigregister(NumericalMathGradientImplementation)

class NumericalMathHessianImplementation(openturns.common.PersistentObject):
    """
    Numerical math hessian implementation.

    See also
    --------
    NumericalMathFunction, NumericalMathGradientImplementation

    Notes
    -----
    This object is the result of the method *getHessian* of a 
    :class:`~openturns.NumericalMathFunction`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathHessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathHessianImplementation___str__(self, offset)
    def isActualImplementation(self): return _func.NumericalMathHessianImplementation_isActualImplementation(self)
    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.NumericalMathHessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.NumericalMathHessianImplementation_getMarginal(self, *args)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NumericalMathHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NumericalMathHessianImplementation_getOutputDimension(self)

    def getParameter(self): return _func.NumericalMathHessianImplementation_getParameter(self)
    def setParameter(self, *args): return _func.NumericalMathHessianImplementation_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.NumericalMathHessianImplementation_getCallsNumber(self)

    def __init__(self, *args): 
        this = _func.new_NumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathHessianImplementation
    __del__ = lambda self : None;
NumericalMathHessianImplementation_swigregister = _func.NumericalMathHessianImplementation_swigregister
NumericalMathHessianImplementation_swigregister(NumericalMathHessianImplementation)

class NoNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::NoNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NoNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.NoNumericalMathEvaluationImplementation___repr__(self)
    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NoNumericalMathEvaluationImplementation_isActualImplementation(self)

    def __call__(self, *args): return _func.NoNumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NoNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NoNumericalMathEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_NoNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NoNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
NoNumericalMathEvaluationImplementation_swigregister = _func.NoNumericalMathEvaluationImplementation_swigregister
NoNumericalMathEvaluationImplementation_swigregister(NoNumericalMathEvaluationImplementation)

class NoNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::NoNumericalMathGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NoNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.NoNumericalMathGradientImplementation___repr__(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoNumericalMathGradientImplementation_getOutputDimension(self)

    def isActualImplementation(self): return _func.NoNumericalMathGradientImplementation_isActualImplementation(self)
    def __init__(self, *args): 
        this = _func.new_NoNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NoNumericalMathGradientImplementation
    __del__ = lambda self : None;
NoNumericalMathGradientImplementation_swigregister = _func.NoNumericalMathGradientImplementation_swigregister
NoNumericalMathGradientImplementation_swigregister(NoNumericalMathGradientImplementation)

class NoNumericalMathHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::NoNumericalMathHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NoNumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NoNumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NoNumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.NoNumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.NoNumericalMathHessianImplementation___repr__(self)
    def isActualImplementation(self): return _func.NoNumericalMathHessianImplementation_isActualImplementation(self)
    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NoNumericalMathHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NoNumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NoNumericalMathHessianImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_NoNumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NoNumericalMathHessianImplementation
    __del__ = lambda self : None;
NoNumericalMathHessianImplementation_swigregister = _func.NoNumericalMathHessianImplementation_swigregister
NoNumericalMathHessianImplementation_swigregister(NoNumericalMathHessianImplementation)

class LinearNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Proxy of C++ OT::LinearNumericalMathEvaluationImplementation

    Linear numerical math evaluation implementation.

    Available constructors:
       LinearNumericalMathEvaluationImplementation(*center, constant, linear*)

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\\vect{b}`.
    constant : sequence of float
        Vector :math:`\\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\\mat{A}`.

    See also
    --------
    NumericalMathFunction

    Notes
    -----
    This implements a linear :class:`~openturns.NumericalMathFunction` :math:`f` 
    defined as :

    .. math::

        f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
            & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

    where:

    - :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
      input *linear*
    - :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*
    - :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*.
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.LinearNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.LinearNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.LinearNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.LinearNumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearNumericalMathEvaluationImplementation_getOutputDimension(self)

    def getCenter(self):
        """
        Accessor to the center.

        Returns
        -------
        center : :class:`~openturns.NumericalPoint`
            The center :math:`\\vect{b}`.
        """
        return _func.LinearNumericalMathEvaluationImplementation_getCenter(self)

    def getConstant(self):
        """
        Accessor to the constant.

        Returns
        -------
        constant : :class:`~openturns.NumericalPoint`
            The constant :math:`\\vect{c}`.
        """
        return _func.LinearNumericalMathEvaluationImplementation_getConstant(self)

    def getLinear(self):
        """
        Accessor to the matrix.

        Returns
        -------
        linear : :class:`~openturns.Matrix`
            The matrix :math:`\\mat{A}`.
        """
        return _func.LinearNumericalMathEvaluationImplementation_getLinear(self)

    def __init__(self, *args): 
        this = _func.new_LinearNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
LinearNumericalMathEvaluationImplementation_swigregister = _func.LinearNumericalMathEvaluationImplementation_swigregister
LinearNumericalMathEvaluationImplementation_swigregister(LinearNumericalMathEvaluationImplementation)

class LinearNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Linear numerical math gradient implementation."""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.LinearNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.LinearNumericalMathGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.LinearNumericalMathGradientImplementation___str__(self, offset)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearNumericalMathGradientImplementation_getOutputDimension(self)

    def getCenter(self): return _func.LinearNumericalMathGradientImplementation_getCenter(self)
    def getConstant(self): return _func.LinearNumericalMathGradientImplementation_getConstant(self)
    def getLinear(self): return _func.LinearNumericalMathGradientImplementation_getLinear(self)
    def __init__(self, *args): 
        this = _func.new_LinearNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearNumericalMathGradientImplementation
    __del__ = lambda self : None;
LinearNumericalMathGradientImplementation_swigregister = _func.LinearNumericalMathGradientImplementation_swigregister
LinearNumericalMathGradientImplementation_swigregister(LinearNumericalMathGradientImplementation)

class QuadraticNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::QuadraticNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.QuadraticNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.QuadraticNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.QuadraticNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.QuadraticNumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.QuadraticNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.QuadraticNumericalMathEvaluationImplementation_getOutputDimension(self)

    def getCenter(self): return _func.QuadraticNumericalMathEvaluationImplementation_getCenter(self)
    def getConstant(self): return _func.QuadraticNumericalMathEvaluationImplementation_getConstant(self)
    def getLinear(self): return _func.QuadraticNumericalMathEvaluationImplementation_getLinear(self)
    def getQuadratic(self): return _func.QuadraticNumericalMathEvaluationImplementation_getQuadratic(self)
    def __init__(self, *args): 
        this = _func.new_QuadraticNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_QuadraticNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
QuadraticNumericalMathEvaluationImplementation_swigregister = _func.QuadraticNumericalMathEvaluationImplementation_swigregister
QuadraticNumericalMathEvaluationImplementation_swigregister(QuadraticNumericalMathEvaluationImplementation)

class ConstantNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::ConstantNumericalMathGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ConstantNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.ConstantNumericalMathGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ConstantNumericalMathGradientImplementation___str__(self, offset)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantNumericalMathGradientImplementation_getOutputDimension(self)

    def getConstant(self): return _func.ConstantNumericalMathGradientImplementation_getConstant(self)
    def __init__(self, *args): 
        this = _func.new_ConstantNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ConstantNumericalMathGradientImplementation
    __del__ = lambda self : None;
ConstantNumericalMathGradientImplementation_swigregister = _func.ConstantNumericalMathGradientImplementation_swigregister
ConstantNumericalMathGradientImplementation_swigregister(ConstantNumericalMathGradientImplementation)

class ConstantNumericalMathHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::ConstantNumericalMathHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantNumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantNumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantNumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ConstantNumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.ConstantNumericalMathHessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ConstantNumericalMathHessianImplementation___str__(self, offset)
    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ConstantNumericalMathHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ConstantNumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ConstantNumericalMathHessianImplementation_getOutputDimension(self)

    def getConstant(self): return _func.ConstantNumericalMathHessianImplementation_getConstant(self)
    def __init__(self, *args): 
        this = _func.new_ConstantNumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ConstantNumericalMathHessianImplementation
    __del__ = lambda self : None;
ConstantNumericalMathHessianImplementation_swigregister = _func.ConstantNumericalMathHessianImplementation_swigregister
ConstantNumericalMathHessianImplementation_swigregister(ConstantNumericalMathHessianImplementation)

class ComposedNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::ComposedNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ComposedNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.ComposedNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ComposedNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.ComposedNumericalMathEvaluationImplementation___call__(self, *args)
    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ComposedNumericalMathEvaluationImplementation_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ComposedNumericalMathEvaluationImplementation_setParameterDescription(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getOutputDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.ComposedNumericalMathEvaluationImplementation_getMarginal(self, *args)

    def getLeftEvaluationImplementation(self): return _func.ComposedNumericalMathEvaluationImplementation_getLeftEvaluationImplementation(self)
    def getRightEvaluationImplementation(self): return _func.ComposedNumericalMathEvaluationImplementation_getRightEvaluationImplementation(self)
    def __init__(self, *args): 
        this = _func.new_ComposedNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ComposedNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
ComposedNumericalMathEvaluationImplementation_swigregister = _func.ComposedNumericalMathEvaluationImplementation_swigregister
ComposedNumericalMathEvaluationImplementation_swigregister(ComposedNumericalMathEvaluationImplementation)

class ComposedNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::ComposedNumericalMathGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ComposedNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.ComposedNumericalMathGradientImplementation___repr__(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedNumericalMathGradientImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ComposedNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ComposedNumericalMathGradientImplementation
    __del__ = lambda self : None;
ComposedNumericalMathGradientImplementation_swigregister = _func.ComposedNumericalMathGradientImplementation_swigregister
ComposedNumericalMathGradientImplementation_swigregister(ComposedNumericalMathGradientImplementation)

class ComposedNumericalMathHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::ComposedNumericalMathHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedNumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedNumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedNumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ComposedNumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.ComposedNumericalMathHessianImplementation___repr__(self)
    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ComposedNumericalMathHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ComposedNumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ComposedNumericalMathHessianImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ComposedNumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ComposedNumericalMathHessianImplementation
    __del__ = lambda self : None;
ComposedNumericalMathHessianImplementation_swigregister = _func.ComposedNumericalMathHessianImplementation_swigregister
ComposedNumericalMathHessianImplementation_swigregister(ComposedNumericalMathHessianImplementation)

class ProductNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::ProductNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ProductNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.ProductNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ProductNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.ProductNumericalMathEvaluationImplementation___call__(self, *args)
    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.ProductNumericalMathEvaluationImplementation_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ProductNumericalMathEvaluationImplementation_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.ProductNumericalMathEvaluationImplementation_getParameterDescription(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductNumericalMathEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ProductNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ProductNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
ProductNumericalMathEvaluationImplementation_swigregister = _func.ProductNumericalMathEvaluationImplementation_swigregister
ProductNumericalMathEvaluationImplementation_swigregister(ProductNumericalMathEvaluationImplementation)

class ProductNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::ProductNumericalMathGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ProductNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.ProductNumericalMathGradientImplementation___repr__(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductNumericalMathGradientImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ProductNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ProductNumericalMathGradientImplementation
    __del__ = lambda self : None;
ProductNumericalMathGradientImplementation_swigregister = _func.ProductNumericalMathGradientImplementation_swigregister
ProductNumericalMathGradientImplementation_swigregister(ProductNumericalMathGradientImplementation)

class ProductNumericalMathHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::ProductNumericalMathHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductNumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductNumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductNumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.ProductNumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.ProductNumericalMathHessianImplementation___repr__(self)
    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ProductNumericalMathHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ProductNumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ProductNumericalMathHessianImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ProductNumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ProductNumericalMathHessianImplementation
    __del__ = lambda self : None;
ProductNumericalMathHessianImplementation_swigregister = _func.ProductNumericalMathHessianImplementation_swigregister
ProductNumericalMathHessianImplementation_swigregister(ProductNumericalMathHessianImplementation)

class EvaluationImplementation(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EvaluationImplementation, name)
    __swig_setmethods__["ptr_"] = _func.EvaluationImplementation_ptr__set
    __swig_getmethods__["ptr_"] = _func.EvaluationImplementation_ptr__get
    if _newclass:ptr_ = _swig_property(_func.EvaluationImplementation_ptr__get, _func.EvaluationImplementation_ptr__set)
    def __init__(self, *args): 
        this = _func.new_EvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_EvaluationImplementation
    __del__ = lambda self : None;
    def reset(self): return _func.EvaluationImplementation_reset(self)
    def __ref__(self, *args): return _func.EvaluationImplementation___ref__(self, *args)
    def __deref__(self): return _func.EvaluationImplementation___deref__(self)
    def isNull(self): return _func.EvaluationImplementation_isNull(self)
    def __nonzero__(self):
        return _func.EvaluationImplementation___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.EvaluationImplementation_get(self)
    def getImplementation(self): return _func.EvaluationImplementation_getImplementation(self)
    def unique(self): return _func.EvaluationImplementation_unique(self)
    def use_count(self): return _func.EvaluationImplementation_use_count(self)
    def swap(self, *args): return _func.EvaluationImplementation_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.EvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.EvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.EvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.EvaluationImplementation___str__(self, offset)
    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.EvaluationImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.EvaluationImplementation_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.EvaluationImplementation_getInputDescription(self)

    def setInputDescription(self, *args):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.EvaluationImplementation_setInputDescription(self, *args)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.EvaluationImplementation_getOutputDescription(self)

    def setOutputDescription(self, *args):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.EvaluationImplementation_setOutputDescription(self, *args)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.EvaluationImplementation_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.EvaluationImplementation_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementation_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.EvaluationImplementation_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.EvaluationImplementation_getInputParameterHistory(self)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.EvaluationImplementation_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.EvaluationImplementation_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.EvaluationImplementation_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.EvaluationImplementation_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.EvaluationImplementation_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementation_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.EvaluationImplementation_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.EvaluationImplementation_clearCache(self)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.EvaluationImplementation_isActualImplementation(self)

    def __call__(self, *args): return _func.EvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.EvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.EvaluationImplementation_getOutputDimension(self)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.EvaluationImplementation_getParameterDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.EvaluationImplementation_getMarginal(self, *args)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.EvaluationImplementation_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.EvaluationImplementation_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.EvaluationImplementation_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.EvaluationImplementation_setParameterDescription(self, *args)

    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.EvaluationImplementation_getCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.EvaluationImplementation_draw(self, *args)

    def __ne__(self, *args): return _func.EvaluationImplementation___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.EvaluationImplementation_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.EvaluationImplementation_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.EvaluationImplementation_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.EvaluationImplementation_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.EvaluationImplementation_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.EvaluationImplementation_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.EvaluationImplementation_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.EvaluationImplementation_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.EvaluationImplementation_setName(self, *args)

EvaluationImplementation_swigregister = _func.EvaluationImplementation_swigregister
EvaluationImplementation_swigregister(EvaluationImplementation)

class GradientImplementation(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GradientImplementation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GradientImplementation, name)
    __swig_setmethods__["ptr_"] = _func.GradientImplementation_ptr__set
    __swig_getmethods__["ptr_"] = _func.GradientImplementation_ptr__get
    if _newclass:ptr_ = _swig_property(_func.GradientImplementation_ptr__get, _func.GradientImplementation_ptr__set)
    def __init__(self, *args): 
        this = _func.new_GradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_GradientImplementation
    __del__ = lambda self : None;
    def reset(self): return _func.GradientImplementation_reset(self)
    def __ref__(self, *args): return _func.GradientImplementation___ref__(self, *args)
    def __deref__(self): return _func.GradientImplementation___deref__(self)
    def isNull(self): return _func.GradientImplementation_isNull(self)
    def __nonzero__(self):
        return _func.GradientImplementation___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.GradientImplementation_get(self)
    def getImplementation(self): return _func.GradientImplementation_getImplementation(self)
    def unique(self): return _func.GradientImplementation_unique(self)
    def use_count(self): return _func.GradientImplementation_use_count(self)
    def swap(self, *args): return _func.GradientImplementation_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.GradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.GradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.GradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.GradientImplementation___str__(self, offset)
    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.NumericalMathGradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.GradientImplementation_getMarginal(self, *args)

    def isActualImplementation(self): return _func.GradientImplementation_isActualImplementation(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.GradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.GradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.GradientImplementation_getOutputDimension(self)

    def getParameter(self): return _func.GradientImplementation_getParameter(self)
    def setParameter(self, *args): return _func.GradientImplementation_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.GradientImplementation_getCallsNumber(self)

    def __ne__(self, *args): return _func.GradientImplementation___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.GradientImplementation_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.GradientImplementation_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.GradientImplementation_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.GradientImplementation_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.GradientImplementation_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.GradientImplementation_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.GradientImplementation_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.GradientImplementation_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.GradientImplementation_setName(self, *args)

GradientImplementation_swigregister = _func.GradientImplementation_swigregister
GradientImplementation_swigregister(GradientImplementation)

class HessianImplementation(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HessianImplementation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HessianImplementation, name)
    __swig_setmethods__["ptr_"] = _func.HessianImplementation_ptr__set
    __swig_getmethods__["ptr_"] = _func.HessianImplementation_ptr__get
    if _newclass:ptr_ = _swig_property(_func.HessianImplementation_ptr__get, _func.HessianImplementation_ptr__set)
    def __init__(self, *args): 
        this = _func.new_HessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_HessianImplementation
    __del__ = lambda self : None;
    def reset(self): return _func.HessianImplementation_reset(self)
    def __ref__(self, *args): return _func.HessianImplementation___ref__(self, *args)
    def __deref__(self): return _func.HessianImplementation___deref__(self)
    def isNull(self): return _func.HessianImplementation_isNull(self)
    def __nonzero__(self):
        return _func.HessianImplementation___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.HessianImplementation_get(self)
    def getImplementation(self): return _func.HessianImplementation_getImplementation(self)
    def unique(self): return _func.HessianImplementation_unique(self)
    def use_count(self): return _func.HessianImplementation_use_count(self)
    def swap(self, *args): return _func.HessianImplementation_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.HessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.HessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.HessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.HessianImplementation___str__(self, offset)
    def isActualImplementation(self): return _func.HessianImplementation_isActualImplementation(self)
    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.NumericalMathHessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.HessianImplementation_getMarginal(self, *args)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.HessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.HessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.HessianImplementation_getOutputDimension(self)

    def getParameter(self): return _func.HessianImplementation_getParameter(self)
    def setParameter(self, *args): return _func.HessianImplementation_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.HessianImplementation_getCallsNumber(self)

    def __ne__(self, *args): return _func.HessianImplementation___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.HessianImplementation_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.HessianImplementation_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.HessianImplementation_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.HessianImplementation_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.HessianImplementation_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.HessianImplementation_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.HessianImplementation_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.HessianImplementation_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.HessianImplementation_setName(self, *args)

HessianImplementation_swigregister = _func.HessianImplementation_swigregister
HessianImplementation_swigregister(HessianImplementation)

class NumericalMathFunctionImplementation(openturns.common.PersistentObject):
    """
    Function.

    Available constructors:
        NumericalMathFunction(*inputs, outputs, formulas*)

        NumericalMathFunction(*inputs, formulas*)

        NumericalMathFunction(*inputString, formulaString, outputString = 'outputVariable'*)

        NumericalMathFunction(*f, g*)

        NumericalMathFunction(*functionCollection*)

        NumericalMathFunction(*functionCollection, scalarCoefficientColl*)

        NumericalMathFunction(*scalarFunctionCollection, vectorCoefficientColl*)

        NumericalMathFunction(*function, comparisonOperator, threshold*)

        NumericalMathFunction(*function, indices, referencePoint, parametersSet=True*)

        NumericalMathFunction(*inputSample, outputSample*)

    Parameters
    ----------
    inputs : sequence of str
        Ordered list of input variables names of the *NumericalMathFunction*.
    outputs : sequence of str
        Ordered list of output variables names of the *NumericalMathFunction*.
        If it is not specified, default names are created for the output variables.
    formulas : sequence of str
        Ordered list of analytical formulas between the inputs and the outputs.
        The *NumericalMathFunction* is defined by *ouputs = formulas(inputs)*.
    inputString : str
        Description of the *NumericalMathFunction*'s input.
    outputString : str
        Description of the *NumericalMathFunction*'s output.
    formulaString : str
        Analytical formula of the *NumericalMathFunction*.
        The *NumericalMathFunction* is defined by
        *ouputString = formulaString(inputString)*.

        Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

        Available operators:

        - = (assignment)
        - && (logical and)
        - || (logical or)
        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \\+ (addition)
        - \\- (subtraction)
        - \\* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

        Available constants:

        - _e (Euler's constant)
        - _pi (Pi)

    f,g : two :class:`~openturns.NumericalMathFunction`
        The *NumericalMathFunction* is the composition function :math:`f\\circ g`.
    functionCollection : list of :class:`~openturns.NumericalMathFunction`
        Collection of several *NumericalMathFunction*.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.
    scalarFunctionCollection : list of :class:`~openturns.NumericalMathFunction`
        Collection of several scalar *NumericalMathFunction*.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.
    function : :class:`~openturns.NumericalMathFunction`
        Function from which another function is created.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator.
    threshold : float
        Threshold from which values are compared.
    indices : sequence of int
        Indices of the set variables which are set to *referencePoint*'s values.
    parametersSet : bool
        If *True* (default), the set variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        vector of *indices*.
    referencePoint : sequence of float
        Values of the set variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.

    Examples
    --------
    Create a *NumericalMathFunction* from a list of analytical formulas and
    descriptions of the inputs and the outputs :

    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction(['x0', 'x1'], ['y0', 'y1'],
    ...                              ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *NumericalMathFunction* from strings:

    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction('x', '2.0*sqrt(x)', 'y')
    >>> print(f(([16],[4])))
        [ y ]
    0 : [ 8 ]
    1 : [ 4 ]


    Create a *NumericalMathFunction* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *NumericalMathFunction* from another *NumericalMathFunction*:

    >>> f = ot.NumericalMathFunction(ot.Description.BuildDefault(4, 'x'),
    ...                              ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.NumericalMathFunction(f, [3, 1], [10, 4], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.NumericalMathFunction(f, [3, 1], [6, 5], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *NumericalMathFunction* from another *NumericalMathFunction*
    and by using a comparison operator:

    >>> analytical = ot.NumericalMathFunction(['x0','x1'], ['y'], ['x0 + x1'])
    >>> indicator = ot.NumericalMathFunction(analytical, ot.Less(), 0.0)
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *NumericalMathFunction* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1', 'y2'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1', 'y2'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> myFunction = ot.NumericalMathFunction(functions)
    >>> print(myFunction([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *NumericalMathFunction* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
    then the linear combination is:

    .. math::

        linComb: \\left|\\begin{array}{rcl}
                      \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                      \\vect{X} & \\mapsto & \\displaystyle \\sum_i c_if_i (\\vect{X})
                  \\end{array}\\right.

    >>> myFunction2 = ot.NumericalMathFunction(functions, [2.0, 4.0])
    >>> print(myFunction2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *NumericalMathFunction* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,    f_i: \\Rset^n \\rightarrow \\Rset`
    and :math:`vectorCoefficientColl = (\\vect{c}_1, \\hdots, \\vect{c}_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,   \\vect{c}_i \\in \\Rset^p`

    .. math::

        vectLinComb: \\left|\\begin{array}{rcl}
                         \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                         \\vect{X} & \\mapsto & \\displaystyle \\sum_i \\vect{c}_if_i (\\vect{X})
                     \\end{array}\\right.

    >>> functions=list()
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1'],
    ...                                           ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1'],
    ...                                           ['x1^2 + x2']))
    >>> myFunction2 = ot.NumericalMathFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(myFunction2([1, 2, 3]))
    [25,35]


    Create a *NumericalMathFunction* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.NumericalMathFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *NumericalMathFunction* which is the composition function
    :math:`f\\circ g`:

    >>> g = ot.NumericalMathFunction(['x1', 'x2'], ['y1', 'y2'],
    ...                              ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'], ['2 * x1 - x2'])
    >>> composed = ot.NumericalMathFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunctionImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathFunctionImplementation_getClassName(self)

    def GetValidConstants():
        """
        Return the list of valid constants.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the constants we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidConstants()[0])
        _e -> Euler's constant (2.71828...)
        """
        return _func.NumericalMathFunctionImplementation_GetValidConstants()

    if _newclass:GetValidConstants = staticmethod(GetValidConstants)
    __swig_getmethods__["GetValidConstants"] = lambda x: GetValidConstants
    def GetValidFunctions():
        """
        Return the list of valid functions.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the functions we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidFunctions()[0])
        sin(arg) -> sine function
        """
        return _func.NumericalMathFunctionImplementation_GetValidFunctions()

    if _newclass:GetValidFunctions = staticmethod(GetValidFunctions)
    __swig_getmethods__["GetValidFunctions"] = lambda x: GetValidFunctions
    def GetValidOperators():
        """
        Return the list of valid operators.

        Returns
        -------
        list_operators : :class:`~openturns.Description`
            List of the operators we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidOperators()[0])
        = -> assignement, can only be applied to variable names (priority -1)
        """
        return _func.NumericalMathFunctionImplementation_GetValidOperators()

    if _newclass:GetValidOperators = staticmethod(GetValidOperators)
    __swig_getmethods__["GetValidOperators"] = lambda x: GetValidOperators
    def __mul__(self, *args): return _func.NumericalMathFunctionImplementation___mul__(self, *args)
    def __eq__(self, *args): return _func.NumericalMathFunctionImplementation___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathFunctionImplementation___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathFunctionImplementation___str__(self, offset)
    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.NumericalMathFunctionImplementation_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.NumericalMathFunctionImplementation_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunctionImplementation_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.NumericalMathFunctionImplementation_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.NumericalMathFunctionImplementation_clearCache(self)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.NumericalMathFunctionImplementation_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.NumericalMathFunctionImplementation_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunctionImplementation_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.NumericalMathFunctionImplementation_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementation_getInputParameterHistory(self)

    def setEvaluation(self, *args):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.
        """
        return _func.NumericalMathFunctionImplementation_setEvaluation(self, *args)

    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.NumericalMathFunctionImplementation_getEvaluation(self)

    def setGradient(self, *args):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunctionImplementation_setGradient(self, *args)

    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.
        """
        return _func.NumericalMathFunctionImplementation_getGradient(self)

    def setHessian(self, *args):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunctionImplementation_setHessian(self, *args)

    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.
        """
        return _func.NumericalMathFunctionImplementation_getHessian(self)

    def __call__(self, *args): return _func.NumericalMathFunctionImplementation___call__(self, *args)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.NumericalMathFunctionImplementation_gradient(self, *args)

    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.NumericalMathFunctionImplementation_hessian(self, *args)

    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.NumericalMathFunctionImplementation_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.NumericalMathFunctionImplementation_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.NumericalMathFunctionImplementation_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunctionImplementation_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunctionImplementation_setParameterDescription(self, *args)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.NumericalMathFunctionImplementation_getParameterDimension(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NumericalMathFunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NumericalMathFunctionImplementation_getOutputDimension(self)

    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.NumericalMathFunctionImplementation_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.NumericalMathFunctionImplementation_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.NumericalMathFunctionImplementation_getInputDescription(self)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.NumericalMathFunctionImplementation_getOutputDescription(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.NumericalMathFunctionImplementation_getMarginal(self, *args)

    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathFunctionImplementation_getEvaluationCallsNumber(self)

    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            NumericalMathFunction has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.NumericalMathFunctionImplementation_getGradientCallsNumber(self)

    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            NumericalMathFunction has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.NumericalMathFunctionImplementation_getHessianCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.NumericalMathFunctionImplementation_draw(self, *args)

    def __init__(self, *args): 
        this = _func.new_NumericalMathFunctionImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathFunctionImplementation
    __del__ = lambda self : None;
NumericalMathFunctionImplementation_swigregister = _func.NumericalMathFunctionImplementation_swigregister
NumericalMathFunctionImplementation_swigregister(NumericalMathFunctionImplementation)

def NumericalMathFunctionImplementation_GetValidConstants():
  """
    Return the list of valid constants.

    Returns
    -------
    list_constants : :class:`~openturns.Description`
        List of the constants we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidConstants()[0])
    _e -> Euler's constant (2.71828...)
    """
  return _func.NumericalMathFunctionImplementation_GetValidConstants()

def NumericalMathFunctionImplementation_GetValidFunctions():
  """
    Return the list of valid functions.

    Returns
    -------
    list_functions : :class:`~openturns.Description`
        List of the functions we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidFunctions()[0])
    sin(arg) -> sine function
    """
  return _func.NumericalMathFunctionImplementation_GetValidFunctions()

def NumericalMathFunctionImplementation_GetValidOperators():
  """
    Return the list of valid operators.

    Returns
    -------
    list_operators : :class:`~openturns.Description`
        List of the operators we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidOperators()[0])
    = -> assignement, can only be applied to variable names (priority -1)
    """
  return _func.NumericalMathFunctionImplementation_GetValidOperators()

class ProductNumericalMathFunction(NumericalMathFunctionImplementation):
    """Proxy of C++ OT::ProductNumericalMathFunction"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductNumericalMathFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductNumericalMathFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductNumericalMathFunction_getClassName(self)

    def __eq__(self, *args): return _func.ProductNumericalMathFunction___eq__(self, *args)
    def __repr__(self): return _func.ProductNumericalMathFunction___repr__(self)
    def __str__(self, offset=""): return _func.ProductNumericalMathFunction___str__(self, offset)
    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ProductNumericalMathFunction_parameterGradient(self, *args)

    def __init__(self, *args): 
        this = _func.new_ProductNumericalMathFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ProductNumericalMathFunction
    __del__ = lambda self : None;
ProductNumericalMathFunction_swigregister = _func.ProductNumericalMathFunction_swigregister
ProductNumericalMathFunction_swigregister(ProductNumericalMathFunction)

class NumericalMathFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_NumericalMathFunctionImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.NumericalMathFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.NumericalMathFunctionImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.NumericalMathFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.NumericalMathFunctionImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_NumericalMathFunctionImplementationTypedInterfaceObject
    __del__ = lambda self : None;
NumericalMathFunctionImplementationTypedInterfaceObject_swigregister = _func.NumericalMathFunctionImplementationTypedInterfaceObject_swigregister
NumericalMathFunctionImplementationTypedInterfaceObject_swigregister(NumericalMathFunctionImplementationTypedInterfaceObject)

class NumericalMathFunctionCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunctionCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunctionCollection, name)
    __swig_destroy__ = _func.delete_NumericalMathFunctionCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _func.NumericalMathFunctionCollection_clear(self)

    def __len__(self): return _func.NumericalMathFunctionCollection___len__(self)
    def __eq__(self, *args): return _func.NumericalMathFunctionCollection___eq__(self, *args)
    def __contains__(self, *args): return _func.NumericalMathFunctionCollection___contains__(self, *args)
    def __getitem__(self, *args): return _func.NumericalMathFunctionCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _func.NumericalMathFunctionCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _func.NumericalMathFunctionCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.NumericalMathFunctionCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.NumericalMathFunctionCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.NumericalMathFunctionCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.NumericalMathFunctionCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.NumericalMathFunctionCollection_isEmpty(self)

    def __repr__(self): return _func.NumericalMathFunctionCollection___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathFunctionCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_NumericalMathFunctionCollection(*args)
        try: self.this.append(this)
        except: self.this = this
NumericalMathFunctionCollection_swigregister = _func.NumericalMathFunctionCollection_swigregister
NumericalMathFunctionCollection_swigregister(NumericalMathFunctionCollection)

class NumericalMathFunctionPersistentCollection(openturns.common.PersistentObject,NumericalMathFunctionCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,NumericalMathFunctionCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunctionPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,NumericalMathFunctionCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunctionPersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathFunctionPersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _func.new_NumericalMathFunctionPersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _func.NumericalMathFunctionPersistentCollection___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathFunctionPersistentCollection___str__(self, offset)
    __swig_destroy__ = _func.delete_NumericalMathFunctionPersistentCollection
    __del__ = lambda self : None;
NumericalMathFunctionPersistentCollection_swigregister = _func.NumericalMathFunctionPersistentCollection_swigregister
NumericalMathFunctionPersistentCollection_swigregister(NumericalMathFunctionPersistentCollection)

class NumericalMathFunction(NumericalMathFunctionImplementationTypedInterfaceObject):
    """
    Function.

    Available constructors:
        NumericalMathFunction(*inputs, outputs, formulas*)

        NumericalMathFunction(*inputs, formulas*)

        NumericalMathFunction(*inputString, formulaString, outputString = 'outputVariable'*)

        NumericalMathFunction(*f, g*)

        NumericalMathFunction(*functionCollection*)

        NumericalMathFunction(*functionCollection, scalarCoefficientColl*)

        NumericalMathFunction(*scalarFunctionCollection, vectorCoefficientColl*)

        NumericalMathFunction(*function, comparisonOperator, threshold*)

        NumericalMathFunction(*function, indices, referencePoint, parametersSet=True*)

        NumericalMathFunction(*inputSample, outputSample*)

    Parameters
    ----------
    inputs : sequence of str
        Ordered list of input variables names of the *NumericalMathFunction*.
    outputs : sequence of str
        Ordered list of output variables names of the *NumericalMathFunction*.
        If it is not specified, default names are created for the output variables.
    formulas : sequence of str
        Ordered list of analytical formulas between the inputs and the outputs.
        The *NumericalMathFunction* is defined by *ouputs = formulas(inputs)*.
    inputString : str
        Description of the *NumericalMathFunction*'s input.
    outputString : str
        Description of the *NumericalMathFunction*'s output.
    formulaString : str
        Analytical formula of the *NumericalMathFunction*.
        The *NumericalMathFunction* is defined by
        *ouputString = formulaString(inputString)*.

        Available functions:

        - sin
        - cos
        - tan
        - asin
        - acos
        - atan
        - sinh
        - cosh
        - tanh
        - asinh
        - acosh
        - atanh
        - log2
        - log10
        - log
        - ln
        - lngamma
        - gamma
        - exp
        - erf
        - erfc
        - sqrt
        - cbrt
        - besselJ0
        - besselJ1
        - besselY0
        - besselY1
        - sign
        - rint
        - abs
        - min
        - max
        - sum
        - avg
        - floor
        - ceil
        - trunc
        - round

        Available operators:

        - = (assignment)
        - && (logical and)
        - || (logical or)
        - <= (less or equal)
        - >= (greater or equal)
        - != (not equal)
        - == (equal)
        - > (greater than)
        - < (less than)
        - \\+ (addition)
        - \\- (subtraction)
        - \\* (multiplication)
        - / (division)
        - ^ (raise x to the power of y)

        Available constants:

        - _e (Euler's constant)
        - _pi (Pi)

    f,g : two :class:`~openturns.NumericalMathFunction`
        The *NumericalMathFunction* is the composition function :math:`f\\circ g`.
    functionCollection : list of :class:`~openturns.NumericalMathFunction`
        Collection of several *NumericalMathFunction*.
    scalarCoefficientColl : sequence of float
        Collection of scalar weights.
    scalarFunctionCollection : list of :class:`~openturns.NumericalMathFunction`
        Collection of several scalar *NumericalMathFunction*.
    vectorCoefficientColl : 2-d sequence of float
        Collection of vectorial weights.
    function : :class:`~openturns.NumericalMathFunction`
        Function from which another function is created.
    comparisonOperator : :class:`~openturns.ComparisonOperator`
        Comparison operator.
    threshold : float
        Threshold from which values are compared.
    indices : sequence of int
        Indices of the set variables which are set to *referencePoint*'s values.
    parametersSet : bool
        If *True* (default), the set variables are the ones referenced
        in *indices*.
        Otherwise, the set variables are the ones referenced in the complementary
        vector of *indices*.
    referencePoint : sequence of float
        Values of the set variables.
        Must be of size of *indices* if *parametersSet* is *True* (default),
        else its size should be the complementary size of *indices*.
    inputSample : 2-d sequence of float
        Values of the inputs.
    outputSample : 2-d sequence of float
        Values of the outputs.

    Examples
    --------
    Create a *NumericalMathFunction* from a list of analytical formulas and
    descriptions of the inputs and the outputs :

    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction(['x0', 'x1'], ['y0', 'y1'],
    ...                              ['x0 + x1', 'x0 - x1'])
    >>> print(f([1, 2]))
    [3,-1]


    Create a *NumericalMathFunction* from strings:

    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction('x', '2.0*sqrt(x)', 'y')
    >>> print(f(([16],[4])))
        [ y ]
    0 : [ 8 ]
    1 : [ 4 ]


    Create a *NumericalMathFunction* from a Python function:

    >>> def a_function(X):
    ...     return [X[0] + X[1]]
    >>> f = ot.PythonFunction(2, 1, a_function)
    >>> print(f(((10, 5),(6, 7))))
        [ y0 ]
    0 : [ 15 ]
    1 : [ 13 ]


    See :class:`~openturns.PythonFunction` for further details.

    Create a *NumericalMathFunction* from another *NumericalMathFunction*:

    >>> f = ot.NumericalMathFunction(ot.Description.BuildDefault(4, 'x'),
    ...                              ['x0', 'x0 + x1', 'x0 + x2 + x3'])

    Then create another function by setting x1=4 and x3=10:

    >>> g = ot.NumericalMathFunction(f, [3, 1], [10, 4], True)
    >>> print(g.getInputDescription())
    [x0,x2]
    >>> print(g((1, 2)))
    [1,5,13]

    Or by setting x0=6 and x2=5:

    >>> g = ot.NumericalMathFunction(f, [3, 1], [6, 5], False)
    >>> print(g.getInputDescription())
    [x3,x1]
    >>> print(g((1, 2)))
    [6,8,12]


    Create a *NumericalMathFunction* from another *NumericalMathFunction*
    and by using a comparison operator:

    >>> analytical = ot.NumericalMathFunction(['x0','x1'], ['y'], ['x0 + x1'])
    >>> indicator = ot.NumericalMathFunction(analytical, ot.Less(), 0.0)
    >>> print(indicator([2, 3]))
    [0]
    >>> print(indicator([2, -3]))
    [1]

    Create a *NumericalMathFunction* from a collection of functions:

    >>> functions = list()
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1', 'y2'],
    ...                                      ['x1^2 + x2', 'x1 + x2 + x3']))
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1', 'y2'],
    ...                                      ['x1 + 2 * x2 + x3', 'x1 + x2 - x3']))
    >>> myFunction = ot.NumericalMathFunction(functions)
    >>> print(myFunction([1.0, 2.0, 3.0]))
    [3,6,8,0]

    Create a *NumericalMathFunction* which is the linear combination *linComb*
    of the functions defined in  *functionCollection* with scalar weights
    defined in *scalarCoefficientColl*:

    :math:`functionCollection  = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,     f_i: \\Rset^n \\rightarrow \\Rset^{p}`
    and :math:`scalarCoefficientColl = (c_1, \\hdots, c_N) \\in \\Rset^N`
    then the linear combination is:

    .. math::

        linComb: \\left|\\begin{array}{rcl}
                      \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                      \\vect{X} & \\mapsto & \\displaystyle \\sum_i c_if_i (\\vect{X})
                  \\end{array}\\right.

    >>> myFunction2 = ot.NumericalMathFunction(functions, [2.0, 4.0])
    >>> print(myFunction2([1.0, 2.0, 3.0]))
    [38,12]


    Create a *NumericalMathFunction* which is the linear combination
    *vectLinComb* of the scalar functions defined in
    *scalarFunctionCollection* with vectorial weights defined in
    *vectorCoefficientColl*:

    If :math:`scalarFunctionCollection = (f_1, \\hdots, f_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,    f_i: \\Rset^n \\rightarrow \\Rset`
    and :math:`vectorCoefficientColl = (\\vect{c}_1, \\hdots, \\vect{c}_N)`
    where :math:`\\forall 1 \\leq i \\leq N, \\,   \\vect{c}_i \\in \\Rset^p`

    .. math::

        vectLinComb: \\left|\\begin{array}{rcl}
                         \\Rset^n & \\rightarrow & \\Rset^{p} \\\\
                         \\vect{X} & \\mapsto & \\displaystyle \\sum_i \\vect{c}_if_i (\\vect{X})
                     \\end{array}\\right.

    >>> functions=list()
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1'],
    ...                                           ['x1 + 2 * x2 + x3']))
    >>> functions.append(ot.NumericalMathFunction(['x1', 'x2', 'x3'], ['y1'],
    ...                                           ['x1^2 + x2']))
    >>> myFunction2 = ot.NumericalMathFunction(functions, [[2., 4.], [3., 1.]])
    >>> print(myFunction2([1, 2, 3]))
    [25,35]


    Create a *NumericalMathFunction* from values of the inputs and the outputs:

    >>> inputSample = [[1.0, 1.0], [2.0, 2.0]]
    >>> outputSample = [[4.0], [5.0]]
    >>> database = ot.NumericalMathFunction(inputSample, outputSample)
    >>> x = [1.8]*database.getInputDimension()
    >>> print(database(x))
    [5]


    Create a *NumericalMathFunction* which is the composition function
    :math:`f\\circ g`:

    >>> g = ot.NumericalMathFunction(['x1', 'x2'], ['y1', 'y2'],
    ...                              ['x1 + x2','3 * x1 * x2'])
    >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'], ['2 * x1 - x2'])
    >>> composed = ot.NumericalMathFunction(f, g)
    >>> print(composed([3, 4]))
    [-22]
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunctionImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunctionImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathFunction_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathFunction___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathFunction___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathFunction___str__(self, offset)
    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.NumericalMathFunction_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.NumericalMathFunction_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunction_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.NumericalMathFunction_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.NumericalMathFunction_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunction_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunction_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.NumericalMathFunction_clearCache(self)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.NumericalMathFunction_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.NumericalMathFunction_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunction_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.NumericalMathFunction_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunction_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunction_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.NumericalMathFunction_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.NumericalMathFunction_getInputParameterHistory(self)

    def setEvaluation(self, *args):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.
        """
        return _func.NumericalMathFunction_setEvaluation(self, *args)

    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.NumericalMathFunction_getEvaluation(self)

    def setGradient(self, *args):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunction_setGradient(self, *args)

    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.
        """
        return _func.NumericalMathFunction_getGradient(self)

    def setHessian(self, *args):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunction_setHessian(self, *args)

    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.
        """
        return _func.NumericalMathFunction_getHessian(self)

    def __mul__(self, *args): return _func.NumericalMathFunction___mul__(self, *args)
    def __add__(self, *args): return _func.NumericalMathFunction___add__(self, *args)
    def __sub__(self, *args): return _func.NumericalMathFunction___sub__(self, *args)
    def __call__(self, *args): return _func.NumericalMathFunction___call__(self, *args)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.NumericalMathFunction_gradient(self, *args)

    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.NumericalMathFunction_hessian(self, *args)

    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.NumericalMathFunction_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.NumericalMathFunction_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.NumericalMathFunction_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunction_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunction_setParameterDescription(self, *args)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.NumericalMathFunction_getParameterDimension(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NumericalMathFunction_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NumericalMathFunction_getOutputDimension(self)

    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.NumericalMathFunction_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.NumericalMathFunction_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.NumericalMathFunction_getInputDescription(self)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.NumericalMathFunction_getOutputDescription(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.NumericalMathFunction_getMarginal(self, *args)

    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathFunction_getCallsNumber(self)

    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathFunction_getEvaluationCallsNumber(self)

    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            NumericalMathFunction has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.NumericalMathFunction_getGradientCallsNumber(self)

    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            NumericalMathFunction has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.NumericalMathFunction_getHessianCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.NumericalMathFunction_draw(self, *args)

    def GetValidConstants():
        """
        Return the list of valid constants.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the constants we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidConstants()[0])
        _e -> Euler's constant (2.71828...)
        """
        return _func.NumericalMathFunction_GetValidConstants()

    if _newclass:GetValidConstants = staticmethod(GetValidConstants)
    __swig_getmethods__["GetValidConstants"] = lambda x: GetValidConstants
    def GetValidFunctions():
        """
        Return the list of valid functions.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the functions we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidFunctions()[0])
        sin(arg) -> sine function
        """
        return _func.NumericalMathFunction_GetValidFunctions()

    if _newclass:GetValidFunctions = staticmethod(GetValidFunctions)
    __swig_getmethods__["GetValidFunctions"] = lambda x: GetValidFunctions
    def GetValidOperators():
        """
        Return the list of valid operators.

        Returns
        -------
        list_operators : :class:`~openturns.Description`
            List of the operators we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidOperators()[0])
        = -> assignement, can only be applied to variable names (priority -1)
        """
        return _func.NumericalMathFunction_GetValidOperators()

    if _newclass:GetValidOperators = staticmethod(GetValidOperators)
    __swig_getmethods__["GetValidOperators"] = lambda x: GetValidOperators
    def __init__(self, *args): 
        this = _func.new_NumericalMathFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathFunction
    __del__ = lambda self : None;
NumericalMathFunction_swigregister = _func.NumericalMathFunction_swigregister
NumericalMathFunction_swigregister(NumericalMathFunction)

def NumericalMathFunction_GetValidConstants():
  """
    Return the list of valid constants.

    Returns
    -------
    list_constants : :class:`~openturns.Description`
        List of the constants we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidConstants()[0])
    _e -> Euler's constant (2.71828...)
    """
  return _func.NumericalMathFunction_GetValidConstants()

def NumericalMathFunction_GetValidFunctions():
  """
    Return the list of valid functions.

    Returns
    -------
    list_functions : :class:`~openturns.Description`
        List of the functions we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidFunctions()[0])
    sin(arg) -> sine function
    """
  return _func.NumericalMathFunction_GetValidFunctions()

def NumericalMathFunction_GetValidOperators():
  """
    Return the list of valid operators.

    Returns
    -------
    list_operators : :class:`~openturns.Description`
        List of the operators we can use within OpenTURNS.

    Examples
    --------
    >>> import openturns as ot
    >>> print(ot.NumericalMathFunction.GetValidOperators()[0])
    = -> assignement, can only be applied to variable names (priority -1)
    """
  return _func.NumericalMathFunction_GetValidOperators()

# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonFunction(object):
    """
    Override NumericalMathFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a sequence of float,
        returns a sequence of float

    You can also optionally override these functions:
        _exec_sample(X): multiple evaluations, X is a 2-d sequence of float,
        returns a 2-d sequence of float

        _gradient(X): gradient, X is a sequence of float,
        returns a 2-d sequence of float

        _hessian(X): hessian, X is a sequence of float,
        returns a 3-d sequence of float
    """
    def __init__(self, n=0, p=0):
        try:
            self.__n = int(n)
        except:
            raise TypeError('n argument is not an integer.')
        try:
            self.__p = int(p)
        except:
            raise TypeError('p argument is not an integer.')
        self.__descIn = list(map(lambda i: 'x' + str(i), range(n)))
        self.__descOut = list(map(lambda i: 'y' + str(i), range(p)))
        self.__param = []
        self.__paramDesc = []

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__n):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__p):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__n

    def getOutputDimension(self):
        return self.__p

    def __str__(self):
        return 'OpenTURNSPythonFunction( %s #%d ) -> %s #%d' % (self.__descIn, self.__n, self.__descOut, self.__p)

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = None
        try:
            pt = openturns.typ.NumericalPoint(X)
        except TypeError:
            try:
                ns = openturns.typ.NumericalSample(X)
            except TypeError:
                raise TypeError('Expect a 1-d or 2-d sequence of float as argument')
            else:
                Y = self._exec_sample(ns)
        else:
            Y = self._exec(pt)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are 1-d sequence of float')

    def _exec_sample(self, X):
        res = list()
        for point in X:
            res.append(self._exec(point))
        return res

    def _exec_point_on_exec_sample(self, X):
        """Implement exec from exec_sample."""
        return self._exec_sample([X])[0]

    def setParameter(self, param):
        self.__param = param

    def getParameter(self):
        return self.__param

    def setParameterDescription(self, paramDesc):
        self.__paramDesc = paramDesc

    def getParameterDescription(self):
        return self.__paramDesc

def _exec_sample_multiprocessing(func, n_cpus):
    """Return a distributed function using multiprocessing.

    Parameters
    ----------
    func : Function or calable
        A callable python object, usually a function. The function should take
        an input vector as argument and return an output vector.

    n_cpus : int
        Number of CPUs on which to distribute the function calls.

    Returns
    -------
    _exec_sample : Function or callable
        The parallelized funtion.
    """

    def _exec_sample(X):
        from multiprocessing import Pool
        p = Pool(processes=n_cpus)
        rs = p.map_async(func, X)
        p.close()
        return rs.get()
    return _exec_sample

class PythonFunction(NumericalMathFunction):
    """
    Override NumericalMathFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    func : a callable python object
        called on a single point.
        Default is None.
    func_sample : a callable python object
        called on multiple points at once.
        Default is None.
    gradient : a callable python objects
        returns the gradient as a 2-d sequence of float.
        Default is None (uses finite-difference).
    hessian : a callable python object
        returns the hessian as a 3-d sequence of float.
        Default is None (uses finite-difference).
    n_cpus : integer
        Number of cpus on which func should be distributed using multiprocessing.
        If -1, it uses all the cpus available. If 1, it does nothing. If n_cpus
        and func_sample are both given as arguments, n_cpus will be ignored and
        samples will be handled by func_sample.
        Default is None.

    Notes
    -----
    You must provide at least func or func_sample arguments. Notice that if
    func_sample is provided, n_cpus is ignored. Note also that if PythonFunction
    is distributed (n_cpus > 1), the traceback of a raised exception by a func
    call is lost due to the way multiprocessing dispatches and handles func
    calls. This can be solved by temporarily deactivating n_cpus during the
    development of the wrapper or by manually handling the distribution of the
    wrapper with external libraries like joblib that keep track of a raised
    exception and shows the traceback to the user.

    Examples
    --------
    >>> import openturns as ot
    >>> def a_exec(X):
    ...     Y = [3.*X[0] - X[1]]
    ...     return Y
    >>> def a_grad(X):
    ...     dY = [[3.], [-1.]]
    ...     return dY
    >>> f = ot.PythonFunction(2, 1, a_exec, gradient=a_grad)
    >>> X = [100., 100.]
    >>> Y = f(X)
    >>> print(Y)
    [200]
    >>> dY = f.gradient(X)
    >>> print(dY)
    [[  3 ]
     [ -1 ]]
    """
    def __new__(self, n, p, func=None, func_sample=None, gradient=None, hessian=None, n_cpus=None):
        if func == None and func_sample == None:
            raise RuntimeError('no func nor func_sample given.')
        instance = OpenTURNSPythonFunction(n, p)
        import collections
        if func != None:
            if not isinstance(func, collections.Callable):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        if func_sample != None:
            if not isinstance(func_sample, collections.Callable):
                raise RuntimeError('func_sample argument is not callable.')
            instance._exec_sample = func_sample
            if func == None:
                instance._exec = instance._exec_point_on_exec_sample
        elif n_cpus != None and n_cpus != 1 and func != None:
            if not isinstance(n_cpus, int):
                raise RuntimeError('n_cpus is not an integer')
            if n_cpus == -1:
                import multiprocessing
                n_cpus = multiprocessing.cpu_count()
            instance._exec_sample = _exec_sample_multiprocessing(func, n_cpus)
        if gradient != None:
            if not isinstance(gradient, collections.Callable):
                raise RuntimeError('gradient argument is not callable.')
            instance._gradient = gradient
        if hessian != None:
            if not isinstance(hessian, collections.Callable):
                raise RuntimeError('hessian argument is not callable.')
            instance._hessian = hessian 
        return NumericalMathFunction(instance)

class DynamicalFunctionImplementation(openturns.common.PersistentObject):
    """
    Dynamical function.

    Available constructors:
        DynamicalFunction(*meshDimension=1*)

        DynamicalFunction(*function, meshDimension=1*)

    Parameters
    ----------
    function : :class:`~openturns.NumericalMathFunction`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q` used to define a
        :class:`~openturns.SpatialFunction` object.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the mesh :math:`\\cM`.

    Notes
    -----
    Dynamical functions are functions being able to act on fields. OpenTURNS
    defines two particular dynamical functions:
    the :class:`spatial function <openturns.SpatialFunction>` and
    the :class:`temporal function <openturns.TemporalFunction>`.


    A dynamical function
    :math:`f_{dyn}:\\cD \\times \\Rset^d \\mapsto \\cD' \\times \\Rset^q`
    where :math:`\\cD \\in \\Rset^n` and :math:`\\cD' \\in \\Rset^p` is defined by:

    .. math::

        f_{dyn}(\\vect{t}, \\vect{x}) = (t'(\\vect{t}), v'(\\vect{t}, \\vect{x}))

    with :math:`t': \\cD \\mapsto \\cD'` and
    :math:`v': \\cD \\times \\Rset^d \\mapsto \\Rset^q`.

    A dynamical function :math:`f_{dyn}` transforms a multivariate stochastic
    process:

    .. math::

        X: \\Omega \\times \\cD \\mapsto \\Rset^d

    where :math:`\\cD \\in \\Rset^n` is discretized according to the mesh :math:`\\cM`
    into the multivariate stochastic process:

    .. math::

        Y=f_{dyn}(X)

    such that:

    .. math::

        Y: \\Omega \\times \\cD' \\mapsto \\Rset^q

    where the mesh :math:`\\cD' \\in \\Rset^p`  is discretized according to the
    :math:`\\cM'`.

    A dynamical function :math:`f_{dyn}` also acts on fields and produces fields of
    possibly different dimension (:math:`q\\neq d`) and mesh (:math:`\\cD \\neq \\cD'`
    or :math:`\\cM \\neq \\cM'`).

    OpenTURNS only proposes dynamical functions where :math:`\\cD'=\\cD` and
    :math:`\\cM'=\\cM` which means that :math:`t'=Id` through the *spatial function*
    and the *temporal function*. It follows that the process :math:`Y` shares the
    same mesh with :math:`X`, only its values have changed.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DynamicalFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DynamicalFunctionImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DynamicalFunctionImplementation_getClassName(self)

    def __eq__(self, *args): return _func.DynamicalFunctionImplementation___eq__(self, *args)
    def __repr__(self): return _func.DynamicalFunctionImplementation___repr__(self)
    def __str__(self, offset=""): return _func.DynamicalFunctionImplementation___str__(self, offset)
    def __call__(self, *args): return _func.DynamicalFunctionImplementation___call__(self, *args)
    def getSpatialDimension(self):
        """
        Get the dimension of the mesh.

        Returns
        -------
        spatialDimension : int, :math:`n \\geq 0`
            Dimension of the mesh :math:`\\cM`.
        """
        return _func.DynamicalFunctionImplementation_getSpatialDimension(self)

    def getInputDimension(self):
        """
        Get the dimension of the input.

        Returns
        -------
        d : int
            Input dimension :math:`d` of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Get the dimension of the output.

        Returns
        -------
        q : int
            Output dimension :math:`q` of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_getOutputDimension(self)

    def setInputDescription(self, *args):
        """
        Set the description of the inputs.

        Parameters
        ----------
        inputDescription : sequence of str
            Describes the inputs of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_setInputDescription(self, *args)

    def getInputDescription(self):
        """
        Get the description of the inputs.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Describes the inputs of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_getInputDescription(self)

    def setOutputDescription(self, *args):
        """
        Set the description of the outputs.

        Parameters
        ----------
        outputDescription : sequence of str
            Describes the outputs of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_setOutputDescription(self, *args)

    def getOutputDescription(self):
        """
        Get the description of the outputs.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Describes the outputs of the dynamical function.
        """
        return _func.DynamicalFunctionImplementation_getOutputDescription(self)

    def getOutputMesh(self, *args):
        """
        Get the mesh associated to the output process.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh of the output process.
        """
        return _func.DynamicalFunctionImplementation_getOutputMesh(self, *args)

    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            DynamicalFunction.

        Returns
        -------
        dynamicalFunction : :class:`~openturns.DynamicalFunction`
            DynamicalFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the dynamical function :math:`f_{dyn}`.
        """
        return _func.DynamicalFunctionImplementation_getMarginal(self, *args)

    def getCallsNumber(self):
        """
        Get the number of calls of a DynamicalFunction.

        Returns
        -------
        callsNumber : int
            Counts the number of times the DynamicalFunction has been called since its
            creation.
        """
        return _func.DynamicalFunctionImplementation_getCallsNumber(self)

    def __init__(self, *args): 
        this = _func.new_DynamicalFunctionImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DynamicalFunctionImplementation
    __del__ = lambda self : None;
DynamicalFunctionImplementation_swigregister = _func.DynamicalFunctionImplementation_swigregister
DynamicalFunctionImplementation_swigregister(DynamicalFunctionImplementation)

class DynamicalFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DynamicalFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DynamicalFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_DynamicalFunctionImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.DynamicalFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.DynamicalFunctionImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.DynamicalFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.DynamicalFunctionImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_DynamicalFunctionImplementationTypedInterfaceObject
    __del__ = lambda self : None;
DynamicalFunctionImplementationTypedInterfaceObject_swigregister = _func.DynamicalFunctionImplementationTypedInterfaceObject_swigregister
DynamicalFunctionImplementationTypedInterfaceObject_swigregister(DynamicalFunctionImplementationTypedInterfaceObject)

class DynamicalFunction(DynamicalFunctionImplementationTypedInterfaceObject):
    """
    Dynamical function.

    Available constructors:
        DynamicalFunction(*meshDimension=1*)

        DynamicalFunction(*function, meshDimension=1*)

    Parameters
    ----------
    function : :class:`~openturns.NumericalMathFunction`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q` used to define a
        :class:`~openturns.SpatialFunction` object.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the mesh :math:`\\cM`.

    Notes
    -----
    Dynamical functions are functions being able to act on fields. OpenTURNS
    defines two particular dynamical functions:
    the :class:`spatial function <openturns.SpatialFunction>` and
    the :class:`temporal function <openturns.TemporalFunction>`.


    A dynamical function
    :math:`f_{dyn}:\\cD \\times \\Rset^d \\mapsto \\cD' \\times \\Rset^q`
    where :math:`\\cD \\in \\Rset^n` and :math:`\\cD' \\in \\Rset^p` is defined by:

    .. math::

        f_{dyn}(\\vect{t}, \\vect{x}) = (t'(\\vect{t}), v'(\\vect{t}, \\vect{x}))

    with :math:`t': \\cD \\mapsto \\cD'` and
    :math:`v': \\cD \\times \\Rset^d \\mapsto \\Rset^q`.

    A dynamical function :math:`f_{dyn}` transforms a multivariate stochastic
    process:

    .. math::

        X: \\Omega \\times \\cD \\mapsto \\Rset^d

    where :math:`\\cD \\in \\Rset^n` is discretized according to the mesh :math:`\\cM`
    into the multivariate stochastic process:

    .. math::

        Y=f_{dyn}(X)

    such that:

    .. math::

        Y: \\Omega \\times \\cD' \\mapsto \\Rset^q

    where the mesh :math:`\\cD' \\in \\Rset^p`  is discretized according to the
    :math:`\\cM'`.

    A dynamical function :math:`f_{dyn}` also acts on fields and produces fields of
    possibly different dimension (:math:`q\\neq d`) and mesh (:math:`\\cD \\neq \\cD'`
    or :math:`\\cM \\neq \\cM'`).

    OpenTURNS only proposes dynamical functions where :math:`\\cD'=\\cD` and
    :math:`\\cM'=\\cM` which means that :math:`t'=Id` through the *spatial function*
    and the *temporal function*. It follows that the process :math:`Y` shares the
    same mesh with :math:`X`, only its values have changed.
    """
    __swig_setmethods__ = {}
    for _s in [DynamicalFunctionImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DynamicalFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [DynamicalFunctionImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DynamicalFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DynamicalFunction_getClassName(self)

    def __eq__(self, *args): return _func.DynamicalFunction___eq__(self, *args)
    def __repr__(self): return _func.DynamicalFunction___repr__(self)
    def __str__(self, offset=""): return _func.DynamicalFunction___str__(self, offset)
    def __call__(self, *args): return _func.DynamicalFunction___call__(self, *args)
    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            DynamicalFunction.

        Returns
        -------
        dynamicalFunction : :class:`~openturns.DynamicalFunction`
            DynamicalFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the dynamical function :math:`f_{dyn}`.
        """
        return _func.DynamicalFunction_getMarginal(self, *args)

    def getSpatialDimension(self):
        """
        Get the dimension of the mesh.

        Returns
        -------
        spatialDimension : int, :math:`n \\geq 0`
            Dimension of the mesh :math:`\\cM`.
        """
        return _func.DynamicalFunction_getSpatialDimension(self)

    def getInputDimension(self):
        """
        Get the dimension of the input.

        Returns
        -------
        d : int
            Input dimension :math:`d` of the dynamical function.
        """
        return _func.DynamicalFunction_getInputDimension(self)

    def getOutputDimension(self):
        """
        Get the dimension of the output.

        Returns
        -------
        q : int
            Output dimension :math:`q` of the dynamical function.
        """
        return _func.DynamicalFunction_getOutputDimension(self)

    def getOutputMesh(self, *args):
        """
        Get the mesh associated to the output process.

        Returns
        -------
        outputMesh : :class:`~openturns.Mesh`
            The mesh of the output process.
        """
        return _func.DynamicalFunction_getOutputMesh(self, *args)

    def getInputDescription(self):
        """
        Get the description of the inputs.

        Returns
        -------
        inputDescription : :class:`~openturns.Description`
            Describes the inputs of the dynamical function.
        """
        return _func.DynamicalFunction_getInputDescription(self)

    def getOutputDescription(self):
        """
        Get the description of the outputs.

        Returns
        -------
        outputDescription : :class:`~openturns.Description`
            Describes the outputs of the dynamical function.
        """
        return _func.DynamicalFunction_getOutputDescription(self)

    def getCallsNumber(self):
        """
        Get the number of calls of a DynamicalFunction.

        Returns
        -------
        callsNumber : int
            Counts the number of times the DynamicalFunction has been called since its
            creation.
        """
        return _func.DynamicalFunction_getCallsNumber(self)

    def __init__(self, *args): 
        this = _func.new_DynamicalFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DynamicalFunction
    __del__ = lambda self : None;
DynamicalFunction_swigregister = _func.DynamicalFunction_swigregister
DynamicalFunction_swigregister(DynamicalFunction)

# We have to make sure the submodule is loaded with absolute path
import openturns.typ

class OpenTURNSPythonDynamicalFunction(object):
    """
    Override DynamicalFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    s : positive integer
        the spatial dimension

    Notes
    -----
    You have to overload the function:
        _exec(X): single evaluation, X is a :class:`~openturns.Field`,
        returns a :class:`~openturns.Field`
    """
    def __init__(self, n=0, p=0, s=0):
        try:
            self.__n = int(n)
        except:
            raise TypeError('n argument is not an integer.')
        try:
            self.__p = int(p)
        except:
            raise TypeError('p argument is not an integer.')
        try:
            self.__s = int(s)
        except:
            raise TypeError('s argument is not an integer.')
        self.__descIn = list(map(lambda i: 'x' + str(i), range(n)))
        self.__descOut = list(map(lambda i: 'y' + str(i), range(p)))

    def setInputDescription(self, descIn):
        if (len(descIn) != self.__n):
            raise ValueError('Input description size does NOT match input dimension')
        self.__descIn = descIn

    def getInputDescription(self):
        return self.__descIn

    def setOutputDescription(self, descOut):
        if (len(descOut) != self.__p):
            raise ValueError('Output description size does NOT match output dimension')
        self.__descOut = descOut

    def getOutputDescription(self):
        return self.__descOut

    def getInputDimension(self):
        return self.__n

    def getOutputDimension(self):
        return self.__p

    def getSpatialDimension(self):
        return self.__s

    def __str__(self):
        return 'OpenTURNSPythonDynamicalFunction( %s #%d ) -> %s #%d' % (self.__descIn, self.__n, self.__descOut, self.__p)

    def __repr__(self):
        return self.__str__()

    def __call__(self, X):
        Y = self._exec(X)
        return Y

    def _exec(self, X):
        raise RuntimeError('You must define a method _exec(X) -> Y, where X and Y are Fields objects')

class PythonDynamicalFunction(DynamicalFunction):
    """
    Override DynamicalFunction from Python.

    Parameters
    ----------
    n : positive int
        the input dimension
    p : positive int
        the output dimension
    s : positive int
        the spatial dimension
    func : a callable python object
        called on a :class:`~openturns.Field` object.
        Returns a :class:`~openturns.Field`.
        Default is None.

    Notes
    -----
    func 
    """
    def __new__(self, n, p, s, func=None):
        if func == None:
            raise RuntimeError('func not provided.')
        instance = OpenTURNSPythonDynamicalFunction(n, p, s)
        import collections
        if func != None:
            if not isinstance(func, collections.Callable):
                raise RuntimeError('func argument is not callable.')
            instance._exec = func
        return DynamicalFunction(instance)

class SpatialFunction(DynamicalFunctionImplementation):
    """
    Spatial function.

    Available constructors:
        SpatialFunction(*meshDimension=1*)

        SpatialFunction(*g, meshDimension=1*)

    Parameters
    ----------
    g : :class:`~openturns.NumericalMathFunction`
        Function :math:`g: \\Rset^d \\mapsto \\Rset^q`.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the vertices of the mesh :math:`\\cM`. This data is required
        for tests on the compatibility of dimension when a composite process is
        created using the spatial function.

    Notes
    -----
    A spatial function
    :math:`f_{spat}: \\cD \\times \\Rset^d \\mapsto \\cD \\times \\Rset^q`, with
    :math:`\\cD \\in \\Rset^n`, is a particular
    :class:`dynamical function <openturns.DynamicalFunction>` that lets invariant
    the mesh of a field and defined by a function
    :math:`g : \\Rset^d  \\mapsto \\Rset^q` such that:

    .. math::

        f_{spat}(\\vect{t}, \\vect{x})=(\\vect{t}, g(\\vect{x}))

    Let's note that the input dimension of :math:`f_{spat}` still designs the
    dimension of :math:`\\vect{x}`: :math:`d`. Its output dimension is equal to
    :math:`q`.

    See also
    --------
    TemporalFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`g : \\Rset^d \\mapsto \\Rset^q` such as:

    .. math::

        g: \\left|\\begin{array}{rcl}
                    \\Rset & \\rightarrow & \\Rset \\\\
                    x & \\mapsto & x^2
                \\end{array}\\right.

    >>> g = ot.NumericalMathFunction('x', 'x^2')

    Convert :math:`g` into a spatial function with :math:`n` the dimension of the
    mesh of the field on which :math:`g` will be applied:

    >>> n = 1
    >>> mySpatialFunction = ot.SpatialFunction(g, n)
    >>> # Create a TimeSeries
    >>> tg = ot.RegularGrid(0.0, 0.2, 6)
    >>> data = ot.NumericalSample(tg.getN(), g.getInputDimension())
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(tg, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(mySpatialFunction(ts))
        [ t              outputVariable ]
    0 : [  0              0             ]
    1 : [  0.2            1             ]
    2 : [  0.4            4             ]
    3 : [  0.6            9             ]
    4 : [  0.8           16             ]
    5 : [  1             25             ]
    """
    __swig_setmethods__ = {}
    for _s in [DynamicalFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpatialFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [DynamicalFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpatialFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.SpatialFunction_getClassName(self)

    def __eq__(self, *args): return _func.SpatialFunction___eq__(self, *args)
    def __repr__(self): return _func.SpatialFunction___repr__(self)
    def __str__(self, offset=""): return _func.SpatialFunction___str__(self, offset)
    def __call__(self, *args): return _func.SpatialFunction___call__(self, *args)
    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            DynamicalFunction.

        Returns
        -------
        dynamicalFunction : :class:`~openturns.DynamicalFunction`
            DynamicalFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the dynamical function :math:`f_{dyn}`.
        """
        return _func.SpatialFunction_getMarginal(self, *args)

    def getEvaluation(self):
        """
        Get the evaluation function of :math:`g`.

        Returns
        -------
        g : :class:`~openturns.NumericalMathEvaluationImplementation`
            Evaluation function of :math:`g: \\Rset^d \\mapsto \\Rset^q`.

        Examples
        --------
        >>> import openturns as ot
        >>> g = ot.NumericalMathFunction('x', 'x^2')
        >>> n = 1
        >>> mySpatialFunction = ot.SpatialFunction(g, n)
        >>> print(mySpatialFunction.getEvaluation())
        [x]->[x^2]
        """
        return _func.SpatialFunction_getEvaluation(self)

    def __init__(self, *args): 
        this = _func.new_SpatialFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_SpatialFunction
    __del__ = lambda self : None;
SpatialFunction_swigregister = _func.SpatialFunction_swigregister
SpatialFunction_swigregister(SpatialFunction)

class TemporalFunction(DynamicalFunctionImplementation):
    """
    Temporal function.

    Available constructors:
        TemporalFunction(*meshDimension=1*)

        TemporalFunction(*h, meshDimension=1*)

    Parameters
    ----------
    h : :class:`~openturns.NumericalMathFunction`
        Function :math:`h: \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q`.
    meshDimension : int, :math:`n \\geq 0`
        Dimension of the vertices of the mesh :math:`\\cM`. This data is required
        for tests on the compatibility of dimension when a composite process is
        created using the temporal function.

    Notes
    -----
    A temporal function
    :math:`f_{temp}: \\cD \\times \\Rset^d \\mapsto \\cD \\times \\Rset^q`, with
    :math:`\\cD \\in \\Rset^n`, is a particular
    :class:`dynamical function <openturns.DynamicalFunction>` that lets invariant
    the mesh of a field and defined by a function
    :math:`h : \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q` such that:

    .. math::

      f_{temp}(\\vect{t}, \\vect{x})=(\\vect{t}, h(\\vect{t},\\vect{x}))

    Let's note that the input dimension of :math:`f_{temp}` still design the
    dimension of :math:`\\vect{x}`: :math:`d`. Its output dimension is equal to
    :math:`q`.

    See also
    --------
    SpatialFunction

    Examples
    --------
    >>> import openturns as ot

    Create a function :math:`h : \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q` such as:

    .. math::

        h: \\left|\\begin{array}{rcl}
                    \\Rset \\times \\Rset & \\rightarrow & \\Rset \\\\
                    (t, x) & \\mapsto & (x + t^2)
                \\end{array}\\right.

    >>> h = ot.NumericalMathFunction(['t', 'x'], ['x + t^2'])

    Convert :math:`h` into a temporal function with :math:`n` the dimension of the
    mesh of the field on which :math:`h` will be applied:

    >>> n = 1
    >>> myTemporalFunction = ot.TemporalFunction(h, n)
    >>> # Create a TimeSeries
    >>> tg = ot.RegularGrid(0.0, 0.2, 6)
    >>> data = ot.NumericalSample(tg.getN(), h.getInputDimension()-1)
    >>> for i in range(data.getSize()):
    ...     for j in range(data.getDimension()):
    ...         data[i, j] = i * data.getDimension() + j
    >>> ts = ot.TimeSeries(tg, data)
    >>> print(ts)
        [ t   v0  ]
    0 : [ 0   0   ]
    1 : [ 0.2 1   ]
    2 : [ 0.4 2   ]
    3 : [ 0.6 3   ]
    4 : [ 0.8 4   ]
    5 : [ 1   5   ]
    >>> print(myTemporalFunction(ts))
        [ t    y0   ]
    0 : [ 0    0    ]
    1 : [ 0.2  1.04 ]
    2 : [ 0.4  2.16 ]
    3 : [ 0.6  3.36 ]
    4 : [ 0.8  4.64 ]
    5 : [ 1    6    ]
    """
    __swig_setmethods__ = {}
    for _s in [DynamicalFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemporalFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [DynamicalFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemporalFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TemporalFunction_getClassName(self)

    def __eq__(self, *args): return _func.TemporalFunction___eq__(self, *args)
    def __repr__(self): return _func.TemporalFunction___repr__(self)
    def __str__(self, offset=""): return _func.TemporalFunction___str__(self, offset)
    def __call__(self, *args): return _func.TemporalFunction___call__(self, *args)
    def getMarginal(self, *args):
        """
        Get the marginal(s) at given indice(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0 \\leq i < d`
            Indice(s) of the marginal(s) needed. :math:`d` is the dimension of the
            DynamicalFunction.

        Returns
        -------
        dynamicalFunction : :class:`~openturns.DynamicalFunction`
            DynamicalFunction restricted to the concerned marginal(s) at the indice(s)
            :math:`i` of the dynamical function :math:`f_{dyn}`.
        """
        return _func.TemporalFunction_getMarginal(self, *args)

    def getEvaluation(self):
        """
        Get the evaluation function of :math:`h`.

        Returns
        -------
        h : :class:`~openturns.NumericalMathEvaluationImplementation`
            Evaluation function of
            :math:`h: \\Rset^n \\times \\Rset^d \\mapsto \\Rset^q`.

        Examples
        --------
        >>> import openturns as ot
        >>> h = ot.NumericalMathFunction(['t', 'x'], ['x + t^2'])
        >>> n = 1
        >>> myTemporalFunction = ot.SpatialFunction(h, n)
        >>> print(myTemporalFunction.getEvaluation())
        [t,x]->[x + t^2]
        """
        return _func.TemporalFunction_getEvaluation(self)

    def __init__(self, *args): 
        this = _func.new_TemporalFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_TemporalFunction
    __del__ = lambda self : None;
TemporalFunction_swigregister = _func.TemporalFunction_swigregister
TemporalFunction_swigregister(TemporalFunction)

class ComposedNumericalMathFunction(NumericalMathFunctionImplementation):
    """Proxy of C++ OT::ComposedNumericalMathFunction"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ComposedNumericalMathFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ComposedNumericalMathFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ComposedNumericalMathFunction_getClassName(self)

    def __eq__(self, *args): return _func.ComposedNumericalMathFunction___eq__(self, *args)
    def __repr__(self): return _func.ComposedNumericalMathFunction___repr__(self)
    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.ComposedNumericalMathFunction_parameterGradient(self, *args)

    def __init__(self, *args): 
        this = _func.new_ComposedNumericalMathFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ComposedNumericalMathFunction
    __del__ = lambda self : None;
ComposedNumericalMathFunction_swigregister = _func.ComposedNumericalMathFunction_swigregister
ComposedNumericalMathFunction_swigregister(ComposedNumericalMathFunction)

class DualLinearCombinationEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Dual linear combination evaluation implementation.

    Available constructors:

        DualLinearCombinationEvaluationImplementation(*scalarFctColl, vectCoefColl*)
        
    Parameters
    ----------
    scalarFctColl : sequence of :class:`~openturns.NumericalMathFunction`
        A collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`,
        such that :math:`\\forall i \\in \\{1, \\ldots, l\\}`, 
        :math:`f_i : \\Rset^n \\rightarrow \\Rset`.
    vectCoefColl : 2-d sequence of float
        Sample :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}` of size :math:`l` and dimension :math:`p`.

    See also
    --------
    NumericalMathFunction, AggregatedNumericalMathEvaluationImplementation, DatabaseNumericalMathEvaluationImplementation,
    LinearNumericalMathFunction

    Notes
    -----
    It returns a :class:`~openturns.NumericalMathFunction` which is the function
    :math:`f: \\Rset^n \\rightarrow \\Rset^p` defined as the linear combination of the functions :math:`f_i` with vector coefficients in :math:`\\cC`:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\left\\{ \\sum_{i=1}^l f_i( \\vect{x} ) c_i^{(j)} \\right\\}_{j = 1, \\ldots, p}

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationEvaluationImplementation_getClassName(self)

    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.DualLinearCombinationEvaluationImplementation_setDescription(self, *args)

    def __repr__(self): return _func.DualLinearCombinationEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.DualLinearCombinationEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.DualLinearCombinationEvaluationImplementation___call__(self, *args)
    def getCoefficients(self):
        """
        Accessor to the coefficients.

        Returns
        -------
        coef : :class:`~openturns.NumericalSample`
            The vectorial coefficients :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}`
            which define the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluationImplementation_getCoefficients(self)

    def getFunctionsCollection(self):
        """
        Accessor to the collection of functions.

        Returns
        -------
        fctColl : :class:`~openturns.NumericalMathFunctionCollection`
            The collection of scalar functions :math:`(f_i)_{i = 1, \\ldots, l}` which
            defines the linear combination of :math:`f`.
        """
        return _func.DualLinearCombinationEvaluationImplementation_getFunctionsCollection(self)

    def setFunctionsCollectionAndCoefficients(self, *args):
        """
        Accessor to the coefficients and the collection of functions.

        Parameters
        ----------
        scalarFctColl : sequence of :class:`~openturns.NumericalMathFunction`
            The collection of functions :math:`(f_i)_{i = 1, \\ldots, l}`.
        vectCoefColl : 2-d sequence of float
            The sample of coefficients :math:`\\cC = \\{\\vect{c}_1, \\ldots, \\vect{c}_l \\}`.
        """
        return _func.DualLinearCombinationEvaluationImplementation_setFunctionsCollectionAndCoefficients(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DualLinearCombinationEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DualLinearCombinationEvaluationImplementation_getOutputDimension(self)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.DualLinearCombinationEvaluationImplementation_parameterGradient(self, *args)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluationImplementation_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.DualLinearCombinationEvaluationImplementation_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.DualLinearCombinationEvaluationImplementation_getParameterDescription(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.DualLinearCombinationEvaluationImplementation_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _func.new_DualLinearCombinationEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationEvaluationImplementation
    __del__ = lambda self : None;
DualLinearCombinationEvaluationImplementation_swigregister = _func.DualLinearCombinationEvaluationImplementation_swigregister
DualLinearCombinationEvaluationImplementation_swigregister(DualLinearCombinationEvaluationImplementation)

class DualLinearCombinationGradientImplementation(NumericalMathGradientImplementation):
    """
    Dual linear combination gradient implementation.

    Available constructors:

        DualLinearCombinationGradientImplementation(*myDLCEI*)
        
    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluationImplementation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluationImplementation,
    DualLinearCombinationHessianImplementation

    Notes
    -----
    It returns the implementation of the gradient. By default, the analytical
    gradient is implemented.
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationGradientImplementation_getClassName(self)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationGradientImplementation_getOutputDimension(self)

    def __repr__(self): return _func.DualLinearCombinationGradientImplementation___repr__(self)
    def __init__(self, *args): 
        this = _func.new_DualLinearCombinationGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationGradientImplementation
    __del__ = lambda self : None;
DualLinearCombinationGradientImplementation_swigregister = _func.DualLinearCombinationGradientImplementation_swigregister
DualLinearCombinationGradientImplementation_swigregister(DualLinearCombinationGradientImplementation)

class DualLinearCombinationHessianImplementation(NumericalMathHessianImplementation):
    """
    Dual linear combination hessian implementation.

    Available constructors:

        DualLinearCombinationHessianImplementation(*myDLCEI*)
        
    Parameters
    ----------
    myDLCEI : :class:`~openturns.DualLinearCombinationEvaluationImplementation`
        A dual linear combination evaluation implementation.

    See also
    --------
    DualLinearCombinationEvaluationImplementation,
    DualLinearCombinationGradientImplementation

    Notes
    -----
    It returns the implementation of the hessian. By default, the analytical
    hessian is implemented.
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DualLinearCombinationHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DualLinearCombinationHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DualLinearCombinationHessianImplementation_getClassName(self)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.DualLinearCombinationHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.DualLinearCombinationHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.DualLinearCombinationHessianImplementation_getOutputDimension(self)

    def __repr__(self): return _func.DualLinearCombinationHessianImplementation___repr__(self)
    def __init__(self, *args): 
        this = _func.new_DualLinearCombinationHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DualLinearCombinationHessianImplementation
    __del__ = lambda self : None;
DualLinearCombinationHessianImplementation_swigregister = _func.DualLinearCombinationHessianImplementation_swigregister
DualLinearCombinationHessianImplementation_swigregister(DualLinearCombinationHessianImplementation)

class LinearCombinationEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::LinearCombinationEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationEvaluationImplementation_getClassName(self)

    def __repr__(self): return _func.LinearCombinationEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.LinearCombinationEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.LinearCombinationEvaluationImplementation___call__(self, *args)
    def getCoefficients(self): return _func.LinearCombinationEvaluationImplementation_getCoefficients(self)
    def getFunctionsCollection(self): return _func.LinearCombinationEvaluationImplementation_getFunctionsCollection(self)
    def setFunctionsCollectionAndCoefficients(self, *args): return _func.LinearCombinationEvaluationImplementation_setFunctionsCollectionAndCoefficients(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.LinearCombinationEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.LinearCombinationEvaluationImplementation_getOutputDimension(self)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.LinearCombinationEvaluationImplementation_parameterGradient(self, *args)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.LinearCombinationEvaluationImplementation_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.LinearCombinationEvaluationImplementation_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.LinearCombinationEvaluationImplementation_getParameterDescription(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.LinearCombinationEvaluationImplementation_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _func.new_LinearCombinationEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationEvaluationImplementation
    __del__ = lambda self : None;
LinearCombinationEvaluationImplementation_swigregister = _func.LinearCombinationEvaluationImplementation_swigregister
LinearCombinationEvaluationImplementation_swigregister(LinearCombinationEvaluationImplementation)

class LinearCombinationGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::LinearCombinationGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationGradientImplementation_getClassName(self)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationGradientImplementation_getOutputDimension(self)

    def __repr__(self): return _func.LinearCombinationGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.LinearCombinationGradientImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_LinearCombinationGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationGradientImplementation
    __del__ = lambda self : None;
LinearCombinationGradientImplementation_swigregister = _func.LinearCombinationGradientImplementation_swigregister
LinearCombinationGradientImplementation_swigregister(LinearCombinationGradientImplementation)

class LinearCombinationHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::LinearCombinationHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearCombinationHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearCombinationHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearCombinationHessianImplementation_getClassName(self)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.LinearCombinationHessianImplementation_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.LinearCombinationHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.LinearCombinationHessianImplementation_getOutputDimension(self)

    def __repr__(self): return _func.LinearCombinationHessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.LinearCombinationHessianImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_LinearCombinationHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearCombinationHessianImplementation
    __del__ = lambda self : None;
LinearCombinationHessianImplementation_swigregister = _func.LinearCombinationHessianImplementation_swigregister
LinearCombinationHessianImplementation_swigregister(LinearCombinationHessianImplementation)

class LinearNumericalMathFunction(NumericalMathFunction):
    """
    Linear numerical math function.

    Available constructors:
       LinearNumericalMathFunction(*center, constant, linear*)

    Parameters
    ----------
    center : sequence of float
        Vector :math:`\\vect{b}`.
    constant : sequence of float
        Vector :math:`\\vect{c}`.
    linear : :class:`~openturns.Matrix`
        Matrix :math:`\\mat{A}`.

    See also
    --------
    NumericalMathFunction

    Notes
    -----
    This implements a linear :class:`~openturns.NumericalMathFunction` :math:`f` 
    defined as :

    .. math::

        f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
            & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

    where:

    - :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
      input *linear*,
    - :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*,

    - :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*.
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearNumericalMathFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearNumericalMathFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearNumericalMathFunction_getClassName(self)

    def __eq__(self, *args): return _func.LinearNumericalMathFunction___eq__(self, *args)
    def __repr__(self): return _func.LinearNumericalMathFunction___repr__(self)
    def __str__(self, offset=""): return _func.LinearNumericalMathFunction___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_LinearNumericalMathFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearNumericalMathFunction
    __del__ = lambda self : None;
LinearNumericalMathFunction_swigregister = _func.LinearNumericalMathFunction_swigregister
LinearNumericalMathFunction_swigregister(LinearNumericalMathFunction)

class QuadraticNumericalMathFunction(NumericalMathFunction):
    """Proxy of C++ OT::QuadraticNumericalMathFunction"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticNumericalMathFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticNumericalMathFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticNumericalMathFunction_getClassName(self)

    def __eq__(self, *args): return _func.QuadraticNumericalMathFunction___eq__(self, *args)
    def __repr__(self): return _func.QuadraticNumericalMathFunction___repr__(self)
    def __str__(self, offset=""): return _func.QuadraticNumericalMathFunction___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_QuadraticNumericalMathFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_QuadraticNumericalMathFunction
    __del__ = lambda self : None;
QuadraticNumericalMathFunction_swigregister = _func.QuadraticNumericalMathFunction_swigregister
QuadraticNumericalMathFunction_swigregister(QuadraticNumericalMathFunction)

class UniVariateFunctionImplementation(openturns.common.PersistentObject):
    """Base class for univariate functions."""
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunctionImplementation_getClassName(self)

    def __repr__(self): return _func.UniVariateFunctionImplementation___repr__(self)
    def __str__(self, offset=""): return _func.UniVariateFunctionImplementation___str__(self, offset)
    def __call__(self, *args): return _func.UniVariateFunctionImplementation___call__(self, *args)
    def gradient(self, *args):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunctionImplementation_gradient(self, *args)

    def hessian(self, *args):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunctionImplementation_hessian(self, *args)

    def draw(self, *args):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunctionImplementation_draw(self, *args)

    def __init__(self, *args): 
        this = _func.new_UniVariateFunctionImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunctionImplementation
    __del__ = lambda self : None;
UniVariateFunctionImplementation_swigregister = _func.UniVariateFunctionImplementation_swigregister
UniVariateFunctionImplementation_swigregister(UniVariateFunctionImplementation)

class UniVariateFunctionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunctionImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunctionImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_UniVariateFunctionImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariateFunctionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.UniVariateFunctionImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_UniVariateFunctionImplementationTypedInterfaceObject
    __del__ = lambda self : None;
UniVariateFunctionImplementationTypedInterfaceObject_swigregister = _func.UniVariateFunctionImplementationTypedInterfaceObject_swigregister
UniVariateFunctionImplementationTypedInterfaceObject_swigregister(UniVariateFunctionImplementationTypedInterfaceObject)

class UniVariateFunction(UniVariateFunctionImplementationTypedInterfaceObject):
    """Base class for univariate functions."""
    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariateFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariateFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariateFunction_getClassName(self)

    def __repr__(self): return _func.UniVariateFunction___repr__(self)
    def __str__(self, offset=""): return _func.UniVariateFunction___str__(self, offset)
    def __call__(self, *args): return _func.UniVariateFunction___call__(self, *args)
    def gradient(self, *args):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariateFunction_gradient(self, *args)

    def hessian(self, *args):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariateFunction_hessian(self, *args)

    def draw(self, *args):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariateFunction_draw(self, *args)

    def __init__(self, *args): 
        this = _func.new_UniVariateFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_UniVariateFunction
    __del__ = lambda self : None;
UniVariateFunction_swigregister = _func.UniVariateFunction_swigregister
UniVariateFunction_swigregister(UniVariateFunction)

class UniVariatePolynomialImplementation(UniVariateFunctionImplementation):
    """
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print('(%s) + (%s) = %s' % (P, Q, P + Q))
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print('(%s) - (%s) = %s' % (P, Q, P - Q))
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print('(%s) * (%s) = %s' % (P, Q, P * Q))
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """
    __swig_setmethods__ = {}
    for _s in [UniVariateFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariateFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomialImplementation_getClassName(self)

    def __repr__(self): return _func.UniVariatePolynomialImplementation___repr__(self)
    def __str__(self, *args): return _func.UniVariatePolynomialImplementation___str__(self, *args)
    def __call__(self, *args): return _func.UniVariatePolynomialImplementation___call__(self, *args)
    def gradient(self, *args):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomialImplementation_gradient(self, *args)

    def hessian(self, *args):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomialImplementation_hessian(self, *args)

    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomialImplementation_derivate(self)

    def __mul__(self, *args): return _func.UniVariatePolynomialImplementation___mul__(self, *args)
    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomialImplementation_incrementDegree(self, degree)

    def __add__(self, *args): return _func.UniVariatePolynomialImplementation___add__(self, *args)
    def __sub__(self, *args): return _func.UniVariatePolynomialImplementation___sub__(self, *args)
    def setCoefficients(self, *args):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomialImplementation_setCoefficients(self, *args)

    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.NumericalPoint`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomialImplementation_getCoefficients(self)

    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomialImplementation_getDegree(self)

    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomialImplementation_getRoots(self)

    def __init__(self, *args): 
        this = _func.new_UniVariatePolynomialImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementation
    __del__ = lambda self : None;
UniVariatePolynomialImplementation_swigregister = _func.UniVariatePolynomialImplementation_swigregister
UniVariatePolynomialImplementation_swigregister(UniVariatePolynomialImplementation)

class UniVariatePolynomialImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_UniVariatePolynomialImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.UniVariatePolynomialImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementationTypedInterfaceObject
    __del__ = lambda self : None;
UniVariatePolynomialImplementationTypedInterfaceObject_swigregister = _func.UniVariatePolynomialImplementationTypedInterfaceObject_swigregister
UniVariatePolynomialImplementationTypedInterfaceObject_swigregister(UniVariatePolynomialImplementationTypedInterfaceObject)

class UniVariatePolynomial(UniVariatePolynomialImplementationTypedInterfaceObject):
    """
    Base class for univariate polynomials.

    Parameters
    ----------
    coefficients : sequence of float
        Polynomial coefficients in increasing polynomial order.

    Examples
    --------
    >>> import openturns as ot

    Create a univariate polynomial from a list of coefficients:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> print(P)
    1 + 2 * X + 3 * X^2

    Univariate polynomials are of course callable:

    >>> print(P(1.0))
    6.0

    Addition, subtraction and multiplication of univariate polynomials:

    >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
    >>> Q = ot.UniVariatePolynomial([1.0, 2.0])
    >>> print('(%s) + (%s) = %s' % (P, Q, P + Q))
    (1 + 2 * X + 3 * X^2) + (1 + 2 * X) = 2 + 4 * X + 3 * X^2
    >>> print('(%s) - (%s) = %s' % (P, Q, P - Q))
    (1 + 2 * X + 3 * X^2) - (1 + 2 * X) = 3 * X^2
    >>> print('(%s) * (%s) = %s' % (P, Q, P * Q))
    (1 + 2 * X + 3 * X^2) * (1 + 2 * X) = 1 + 4 * X + 7 * X^2 + 6 * X^3
    """
    __swig_setmethods__ = {}
    for _s in [UniVariatePolynomialImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomial, name, value)
    __swig_getmethods__ = {}
    for _s in [UniVariatePolynomialImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomial, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomial_getClassName(self)

    def __repr__(self): return _func.UniVariatePolynomial___repr__(self)
    def __str__(self, *args): return _func.UniVariatePolynomial___str__(self, *args)
    def __call__(self, *args): return _func.UniVariatePolynomial___call__(self, *args)
    def gradient(self, *args):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomial_gradient(self, *args)

    def hessian(self, *args):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomial_hessian(self, *args)

    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomial_derivate(self)

    def __mul__(self, *args): return _func.UniVariatePolynomial___mul__(self, *args)
    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomial_incrementDegree(self, degree)

    def __add__(self, *args): return _func.UniVariatePolynomial___add__(self, *args)
    def __sub__(self, *args): return _func.UniVariatePolynomial___sub__(self, *args)
    def setCoefficients(self, *args):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomial_setCoefficients(self, *args)

    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.NumericalPoint`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomial_getCoefficients(self)

    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomial_getDegree(self)

    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomial_getRoots(self)

    def draw(self, *args):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariatePolynomial_draw(self, *args)

    def __init__(self, *args): 
        this = _func.new_UniVariatePolynomial(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomial
    __del__ = lambda self : None;
UniVariatePolynomial_swigregister = _func.UniVariatePolynomial_swigregister
UniVariatePolynomial_swigregister(UniVariatePolynomial)

class AggregatedNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Aggregated numerical math evaluation implementation.

    Available constructors:
        AggregatedNumericalMathEvaluationImplementation(*functionsCollection*)

    Parameters
    ----------
    functionsCollection : sequence of :class:`~openturns.NumericalMathFunction`
        A collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`,
        such that :math:`\\forall i \\in \\{1, \\ldots, l\\}`, 
        :math:`f_i : \\Rset^n \\rightarrow \\Rset^{p_i}`.

    See also
    --------
    NumericalMathFunction, DatabaseNumericalMathEvaluationImplementation, DualLinearCombinationEvaluationImplementation,
    LinearNumericalMathFunction

    Notes
    -----
    It implements a :class:`~openturns.NumericalMathFunction`
    :math:`f : \\Rset^n \\rightarrow \\Rset^{p_1 + \\ldots + p_l}` defined by:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\Tr{(f_1(\\vect{x}), \\ldots, f_l(\\vect{x}))}

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AggregatedNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AggregatedNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getClassName(self)

    def __repr__(self): return _func.AggregatedNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.AggregatedNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.AggregatedNumericalMathEvaluationImplementation___call__(self, *args)
    def getFunctionsCollection(self):
        """
        Accessor to the collection of functions.

        Returns
        -------
        functionCol : :class:`~openturns.NumericalMathFunctionCollection`
            The collection of functions defining :math:`f`.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getFunctionsCollection(self)

    def setFunctionsCollection(self, *args):
        """
        Accessor to the collection of functions.

        Parameters
        ----------
        functionsCollection : sequence of :class:`~openturns.NumericalMathFunction`
            The collection of functions :math:`(f_i)_{i = 1, \\ldots, l}` of size :math:`l`.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_setFunctionsCollection(self, *args)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getMarginal(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getOutputDimension(self)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_parameterGradient(self, *args)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_setParameter(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getParameter(self)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.AggregatedNumericalMathEvaluationImplementation_getParameterDescription(self)

    def __init__(self, *args): 
        this = _func.new_AggregatedNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_AggregatedNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
AggregatedNumericalMathEvaluationImplementation_swigregister = _func.AggregatedNumericalMathEvaluationImplementation_swigregister
AggregatedNumericalMathEvaluationImplementation_swigregister(AggregatedNumericalMathEvaluationImplementation)

class PiecewiseLinearEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::PiecewiseLinearEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PiecewiseLinearEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PiecewiseLinearEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseLinearEvaluationImplementation_getClassName(self)

    def __repr__(self): return _func.PiecewiseLinearEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.PiecewiseLinearEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.PiecewiseLinearEvaluationImplementation___call__(self, *args)
    def getLocations(self): return _func.PiecewiseLinearEvaluationImplementation_getLocations(self)
    def setLocations(self, *args): return _func.PiecewiseLinearEvaluationImplementation_setLocations(self, *args)
    def getValues(self): return _func.PiecewiseLinearEvaluationImplementation_getValues(self)
    def setValues(self, *args): return _func.PiecewiseLinearEvaluationImplementation_setValues(self, *args)
    def setLocationsAndValues(self, *args): return _func.PiecewiseLinearEvaluationImplementation_setLocationsAndValues(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseLinearEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseLinearEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_PiecewiseLinearEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_PiecewiseLinearEvaluationImplementation
    __del__ = lambda self : None;
PiecewiseLinearEvaluationImplementation_swigregister = _func.PiecewiseLinearEvaluationImplementation_swigregister
PiecewiseLinearEvaluationImplementation_swigregister(PiecewiseLinearEvaluationImplementation)

class PiecewiseHermiteEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::PiecewiseHermiteEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PiecewiseHermiteEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PiecewiseHermiteEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PiecewiseHermiteEvaluationImplementation_getClassName(self)

    def __repr__(self): return _func.PiecewiseHermiteEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.PiecewiseHermiteEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.PiecewiseHermiteEvaluationImplementation___call__(self, *args)
    def derivate(self, *args): return _func.PiecewiseHermiteEvaluationImplementation_derivate(self, *args)
    def getLocations(self): return _func.PiecewiseHermiteEvaluationImplementation_getLocations(self)
    def setLocations(self, *args): return _func.PiecewiseHermiteEvaluationImplementation_setLocations(self, *args)
    def getValues(self): return _func.PiecewiseHermiteEvaluationImplementation_getValues(self)
    def setValues(self, *args): return _func.PiecewiseHermiteEvaluationImplementation_setValues(self, *args)
    def getDerivatives(self): return _func.PiecewiseHermiteEvaluationImplementation_getDerivatives(self)
    def setDerivatives(self, *args): return _func.PiecewiseHermiteEvaluationImplementation_setDerivatives(self, *args)
    def setLocationsValuesAndDerivatives(self, *args): return _func.PiecewiseHermiteEvaluationImplementation_setLocationsValuesAndDerivatives(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.PiecewiseHermiteEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.PiecewiseHermiteEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_PiecewiseHermiteEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_PiecewiseHermiteEvaluationImplementation
    __del__ = lambda self : None;
PiecewiseHermiteEvaluationImplementation_swigregister = _func.PiecewiseHermiteEvaluationImplementation_swigregister
PiecewiseHermiteEvaluationImplementation_swigregister(PiecewiseHermiteEvaluationImplementation)

class AnalyticalNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::AnalyticalNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnalyticalNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AnalyticalNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AnalyticalNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.AnalyticalNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.AnalyticalNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.AnalyticalNumericalMathEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.AnalyticalNumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.AnalyticalNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.AnalyticalNumericalMathEvaluationImplementation_getOutputDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.AnalyticalNumericalMathEvaluationImplementation_getMarginal(self, *args)

    def getInputVariablesNames(self): return _func.AnalyticalNumericalMathEvaluationImplementation_getInputVariablesNames(self)
    def getOutputVariablesNames(self): return _func.AnalyticalNumericalMathEvaluationImplementation_getOutputVariablesNames(self)
    def getFormulas(self): return _func.AnalyticalNumericalMathEvaluationImplementation_getFormulas(self)
    def __init__(self, *args): 
        this = _func.new_AnalyticalNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_AnalyticalNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
AnalyticalNumericalMathEvaluationImplementation_swigregister = _func.AnalyticalNumericalMathEvaluationImplementation_swigregister
AnalyticalNumericalMathEvaluationImplementation_swigregister(AnalyticalNumericalMathEvaluationImplementation)

class AnalyticalNumericalMathGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::AnalyticalNumericalMathGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnalyticalNumericalMathGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AnalyticalNumericalMathGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AnalyticalNumericalMathGradientImplementation_getClassName(self)

    def __eq__(self, *args): return _func.AnalyticalNumericalMathGradientImplementation___eq__(self, *args)
    def __repr__(self): return _func.AnalyticalNumericalMathGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.AnalyticalNumericalMathGradientImplementation___str__(self, offset)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.AnalyticalNumericalMathGradientImplementation_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.AnalyticalNumericalMathGradientImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.AnalyticalNumericalMathGradientImplementation_getOutputDimension(self)

    def getFormula(self, *args): return _func.AnalyticalNumericalMathGradientImplementation_getFormula(self, *args)
    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.NumericalMathGradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.AnalyticalNumericalMathGradientImplementation_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _func.new_AnalyticalNumericalMathGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_AnalyticalNumericalMathGradientImplementation
    __del__ = lambda self : None;
AnalyticalNumericalMathGradientImplementation_swigregister = _func.AnalyticalNumericalMathGradientImplementation_swigregister
AnalyticalNumericalMathGradientImplementation_swigregister(AnalyticalNumericalMathGradientImplementation)

class AnalyticalNumericalMathHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::AnalyticalNumericalMathHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnalyticalNumericalMathHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AnalyticalNumericalMathHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.AnalyticalNumericalMathHessianImplementation_getClassName(self)

    def __eq__(self, *args): return _func.AnalyticalNumericalMathHessianImplementation___eq__(self, *args)
    def __repr__(self): return _func.AnalyticalNumericalMathHessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.AnalyticalNumericalMathHessianImplementation___str__(self, offset)
    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.AnalyticalNumericalMathHessianImplementation_hessian(self, *args)

    def getFormula(self, *args): return _func.AnalyticalNumericalMathHessianImplementation_getFormula(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.AnalyticalNumericalMathHessianImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.AnalyticalNumericalMathHessianImplementation_getOutputDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.NumericalMathHessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.AnalyticalNumericalMathHessianImplementation_getMarginal(self, *args)

    def __init__(self, *args): 
        this = _func.new_AnalyticalNumericalMathHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_AnalyticalNumericalMathHessianImplementation
    __del__ = lambda self : None;
AnalyticalNumericalMathHessianImplementation_swigregister = _func.AnalyticalNumericalMathHessianImplementation_swigregister
AnalyticalNumericalMathHessianImplementation_swigregister(AnalyticalNumericalMathHessianImplementation)

class DatabaseNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Data based math evaluation implementation.

    Available constructors:

        DatabaseNumericalMathEvaluationImplementation(*inputSample, outputSample*)
        
        DatabaseNumericalMathEvaluationImplementation(*inputSample, outputSample, activateCache*)

    Parameters
    ----------
    inputSample : 2-d sequence of float
        Sample :math:`\\cS^{in}` of size :math:`l` and dimension :math:`n`.
    outputSample : 2-d sequence of float
        Sample :math:`\\cS^{out}` of size :math:`l` and dimension :math:`p`.
    activateCache : bool
        Flag to enable cache or not.

    See also
    --------
    NumericalMathFunction, AggregatedNumericalMathEvaluationImplementation, DualLinearCombinationEvaluationImplementation,
    LinearNumericalMathFunction

    Notes
    -----
    It returns a :class:`~openturns.NumericalMathFunction` that implements a 
    nearest-neighbor function :math:`f : \\Rset^n \\rightarrow \\Rset^p` based on the 
    input sample :math:`S^{in}` and taking values in the outputSample :math:`S^{out}`:

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = y_{i*}

    where:

    .. math::
        i^* = \\underset{ \\vect{x}_i \\in S^{in} }{ \\argmin_{i \\in \\{1, \\ldots, l\\}} } \\|\\vect{x} - \\vect{x}_i \\|

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DatabaseNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, DatabaseNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.DatabaseNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.DatabaseNumericalMathEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.DatabaseNumericalMathEvaluationImplementation___str__(self, offset)
    def setInputSample(self, *args):
        """
        Accessor to the input sample defining the functions.

        Parameters
        ----------
        inputSample : :class:`~openturns.NumericalSample`
            The input sample defining the function.
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_setInputSample(self, *args)

    def getInputSample(self):
        """
        Accessor to the input sample defining the functions.

        Returns
        -------
        inputSample : :class:`~openturns.NumericalSample`
            The input sample defining the function.
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_getInputSample(self)

    def setOutputSample(self, *args):
        """
        Accessor to the output sample defining the functions.

        Parameters
        ----------
        outputSample : :class:`~openturns.NumericalSample`
            The output sample defining the function.
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_setOutputSample(self, *args)

    def getOutputSample(self):
        """
        Accessor to the output sample defining the functions.

        Returns
        -------
        outputSample : :class:`~openturns.NumericalSample`
            The output sample defining the function.
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_getOutputSample(self)

    def __call__(self, *args): return _func.DatabaseNumericalMathEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.DatabaseNumericalMathEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_DatabaseNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_DatabaseNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
DatabaseNumericalMathEvaluationImplementation_swigregister = _func.DatabaseNumericalMathEvaluationImplementation_swigregister
DatabaseNumericalMathEvaluationImplementation_swigregister(DatabaseNumericalMathEvaluationImplementation)

class IndicatorNumericalMathEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::IndicatorNumericalMathEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndicatorNumericalMathEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndicatorNumericalMathEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.IndicatorNumericalMathEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.IndicatorNumericalMathEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.IndicatorNumericalMathEvaluationImplementation___repr__(self)
    def __call__(self, *args): return _func.IndicatorNumericalMathEvaluationImplementation___call__(self, *args)
    def getEvaluation(self): return _func.IndicatorNumericalMathEvaluationImplementation_getEvaluation(self)
    def setEvaluation(self, *args): return _func.IndicatorNumericalMathEvaluationImplementation_setEvaluation(self, *args)
    def getComparisonOperator(self): return _func.IndicatorNumericalMathEvaluationImplementation_getComparisonOperator(self)
    def setComparisonOperator(self, *args): return _func.IndicatorNumericalMathEvaluationImplementation_setComparisonOperator(self, *args)
    def getThreshold(self): return _func.IndicatorNumericalMathEvaluationImplementation_getThreshold(self)
    def setThreshold(self, *args): return _func.IndicatorNumericalMathEvaluationImplementation_setThreshold(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.IndicatorNumericalMathEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.IndicatorNumericalMathEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_IndicatorNumericalMathEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_IndicatorNumericalMathEvaluationImplementation
    __del__ = lambda self : None;
IndicatorNumericalMathEvaluationImplementation_swigregister = _func.IndicatorNumericalMathEvaluationImplementation_swigregister
IndicatorNumericalMathEvaluationImplementation_swigregister(IndicatorNumericalMathEvaluationImplementation)

class PolynomialCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolynomialCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PolynomialCollection, name)
    __swig_destroy__ = _func.delete_PolynomialCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _func.PolynomialCollection_clear(self)

    def __len__(self): return _func.PolynomialCollection___len__(self)
    def __eq__(self, *args): return _func.PolynomialCollection___eq__(self, *args)
    def __contains__(self, *args): return _func.PolynomialCollection___contains__(self, *args)
    def __getitem__(self, *args): return _func.PolynomialCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _func.PolynomialCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _func.PolynomialCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.PolynomialCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.PolynomialCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.PolynomialCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.PolynomialCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.PolynomialCollection_isEmpty(self)

    def __repr__(self): return _func.PolynomialCollection___repr__(self)
    def __str__(self, offset=""): return _func.PolynomialCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_PolynomialCollection(*args)
        try: self.this.append(this)
        except: self.this = this
PolynomialCollection_swigregister = _func.PolynomialCollection_swigregister
PolynomialCollection_swigregister(PolynomialCollection)

class PolynomialPersistentCollection(openturns.common.PersistentObject,PolynomialCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,PolynomialCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PolynomialPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,PolynomialCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PolynomialPersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.PolynomialPersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _func.new_PolynomialPersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _func.PolynomialPersistentCollection___repr__(self)
    def __str__(self, offset=""): return _func.PolynomialPersistentCollection___str__(self, offset)
    __swig_destroy__ = _func.delete_PolynomialPersistentCollection
    __del__ = lambda self : None;
PolynomialPersistentCollection_swigregister = _func.PolynomialPersistentCollection_swigregister
PolynomialPersistentCollection_swigregister(PolynomialPersistentCollection)

class ProductPolynomialEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Product polynomial evaluation implementation.

    Available constructors:
        ProductPolynomialEvaluationImplementation(*polCollection*)

    Parameters
    ----------
    distCol : :class:`~openturns.PolynomialCollection`
        A collection of :class:`~openturns.UniVariatePolynomial`.

    Notes
    -----
    It returns the product of the polynomials of *polCollection*. The input
    dimension *n* is equal to the number of polynomials in *polCollection*.

    Examples
    --------
    >>> import openturns as ot
    >>> P1 = ot.UniVariatePolynomial([1.0, 2.0, 3.0, 0])
    >>> P2 = ot.UniVariatePolynomial([3.0, 2.0, 4.0, 5.0])
    >>> P3 = ot.UniVariatePolynomial([-1.0, 0.0, 4, 0.0])
    >>> polyCol = ot.PolynomialCollection(1, P1)
    >>> polyCol.add(P2)
    >>> polyCol.add(P3)
    >>> productPoly = ot.ProductPolynomialEvaluationImplementation(polyCol)
    >>> productPoly([2, 1, 3])
    class=NumericalPoint name=Unnamed dimension=1 values=[8330]

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProductPolynomialEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProductPolynomialEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ProductPolynomialEvaluationImplementation_getClassName(self)

    def __repr__(self): return _func.ProductPolynomialEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ProductPolynomialEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.ProductPolynomialEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ProductPolynomialEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ProductPolynomialEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_ProductPolynomialEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ProductPolynomialEvaluationImplementation
    __del__ = lambda self : None;
ProductPolynomialEvaluationImplementation_swigregister = _func.ProductPolynomialEvaluationImplementation_swigregister
ProductPolynomialEvaluationImplementation_swigregister(ProductPolynomialEvaluationImplementation)

class ParametricEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::ParametricEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricEvaluationImplementation_getClassName(self)

    def __call__(self, *args): return _func.ParametricEvaluationImplementation___call__(self, *args)
    def getParametersPositions(self): return _func.ParametricEvaluationImplementation_getParametersPositions(self)
    def getInputPositions(self): return _func.ParametricEvaluationImplementation_getInputPositions(self)
    def getFunction(self): return _func.ParametricEvaluationImplementation_getFunction(self)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.ParametricEvaluationImplementation_getInputDimension(self)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.ParametricEvaluationImplementation_getParameterDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.ParametricEvaluationImplementation_getOutputDimension(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.ParametricEvaluationImplementation_setParameter(self, *args)

    def __repr__(self): return _func.ParametricEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ParametricEvaluationImplementation___str__(self, offset)
    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.ParametricEvaluationImplementation_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.ParametricEvaluationImplementation_getInputParameterHistory(self)

    def __init__(self, *args): 
        this = _func.new_ParametricEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ParametricEvaluationImplementation
    __del__ = lambda self : None;
ParametricEvaluationImplementation_swigregister = _func.ParametricEvaluationImplementation_swigregister
ParametricEvaluationImplementation_swigregister(ParametricEvaluationImplementation)

class ParametricGradientImplementation(NumericalMathGradientImplementation):
    """Proxy of C++ OT::ParametricGradientImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricGradientImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathGradientImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricGradientImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricGradientImplementation_getClassName(self)

    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricGradientImplementation_gradient(self, *args)

    def getEvaluation(self): return _func.ParametricGradientImplementation_getEvaluation(self)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricGradientImplementation_getInputDimension(self)

    def getParameterDimension(self): return _func.ParametricGradientImplementation_getParameterDimension(self)
    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricGradientImplementation_getOutputDimension(self)

    def __repr__(self): return _func.ParametricGradientImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ParametricGradientImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_ParametricGradientImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ParametricGradientImplementation
    __del__ = lambda self : None;
ParametricGradientImplementation_swigregister = _func.ParametricGradientImplementation_swigregister
ParametricGradientImplementation_swigregister(ParametricGradientImplementation)

class ParametricHessianImplementation(NumericalMathHessianImplementation):
    """Proxy of C++ OT::ParametricHessianImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParametricHessianImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathHessianImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ParametricHessianImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ParametricHessianImplementation_getClassName(self)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.ParametricHessianImplementation_hessian(self, *args)

    def getEvaluation(self): return _func.ParametricHessianImplementation_getEvaluation(self)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.ParametricHessianImplementation_getInputDimension(self)

    def getParameterDimension(self): return _func.ParametricHessianImplementation_getParameterDimension(self)
    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.ParametricHessianImplementation_getOutputDimension(self)

    def __repr__(self): return _func.ParametricHessianImplementation___repr__(self)
    def __str__(self, offset=""): return _func.ParametricHessianImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_ParametricHessianImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ParametricHessianImplementation
    __del__ = lambda self : None;
ParametricHessianImplementation_swigregister = _func.ParametricHessianImplementation_swigregister
ParametricHessianImplementation_swigregister(ParametricHessianImplementation)

class P1LagrangeEvaluationImplementation(NumericalMathEvaluationImplementation):
    """
    Data based math evaluation implementation.

    Available constructors:

        P1LagrangeEvaluationImplementation(*field*)

    Parameters
    ----------
    field : :class:`~openturns.Field`
        Field :math:`\\cF` defining the parameters of a P1 Lagrange interpolation function.

    See also
    --------
    NumericalMathFunction, AggregatedNumericalMathEvaluationImplementation, DualLinearCombinationEvaluationImplementation,
    LinearNumericalMathFunction

    Notes
    -----
    It returns a :class:`~openturns.NumericalMathFunction` that implements the P1 Lagrange interpolation function :math:`f : \\cD_N \\rightarrow \\Rset^p` :

    .. math::
        \\forall \\vect{x} \\in \\Rset^n, f(\\vect{x}) = \\sum_{\\vect{\\xi}_i\\in\\cV(\\vect{x})}\\alpha_i f(\\vect{\\xi}_i)

    where :math:`\\cD_N` is a :class:`~openturns.Mesh`, :math:`\\cV(\\vect{x})` is the simplex in :math:`\\cD_N` that contains :math:`\\vect{x}`, :math:`\\alpha_i` are the barycentric coordinates of :math:`\\vect{x}` wrt the vertices :math:`\\vect{\\xi}_i` of :math:`\\cV(\\vect{x})`:

    .. math::
        \\vect{x}=\\sum_{\\vect{\\xi}_i\\in\\cV(\\vect{x})}\\alpha_i\\vect{\\xi}_i

    Examples
    --------
    Create a P1 Lagrange evaluation:

    >>> import openturns as ot
    >>> field = ot.Field(ot.RegularGrid(0.0, 1.0, 4), [[0.5], [1.5], [1.0], [-0.5]])
    >>> evaluation = ot.P1LagrangeEvaluationImplementation(field)
    >>> print(evaluation([2.3]))
    [0.55]
    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, P1LagrangeEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, P1LagrangeEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.P1LagrangeEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.P1LagrangeEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.P1LagrangeEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.P1LagrangeEvaluationImplementation___str__(self, offset)
    def setField(self, *args):
        """
        Accessor to the field defining the functions.

        Parameters
        ----------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluationImplementation_setField(self, *args)

    def getField(self):
        """
        Accessor to the field defining the functions.

        Returns
        -------
        field : :class:`~openturns.Field`
            The field defining the function.
        """
        return _func.P1LagrangeEvaluationImplementation_getField(self)

    def setVertices(self, *args): return _func.P1LagrangeEvaluationImplementation_setVertices(self, *args)
    def getVertices(self): return _func.P1LagrangeEvaluationImplementation_getVertices(self)
    def setValues(self, *args): return _func.P1LagrangeEvaluationImplementation_setValues(self, *args)
    def getValues(self): return _func.P1LagrangeEvaluationImplementation_getValues(self)
    def __call__(self, *args): return _func.P1LagrangeEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.P1LagrangeEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.P1LagrangeEvaluationImplementation_getOutputDimension(self)

    def __init__(self, *args): 
        this = _func.new_P1LagrangeEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_P1LagrangeEvaluationImplementation
    __del__ = lambda self : None;
P1LagrangeEvaluationImplementation_swigregister = _func.P1LagrangeEvaluationImplementation_swigregister
P1LagrangeEvaluationImplementation_swigregister(P1LagrangeEvaluationImplementation)

class BasisImplementation(openturns.common.PersistentObject):
    """
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.NumericalMathFunction`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
    >>> basis = ot.Basis(functions)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisImplementation_getClassName(self)

    def build(self, *args):
        """
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \\geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.BasisImplementation_build(self, *args)

    def getSubBasis(self, *args):
        """
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.NumericalMathFunction`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.BasisImplementation_getSubBasis(self, *args)

    def __repr__(self): return _func.BasisImplementation___repr__(self)
    def getDimension(self):
        """
        Get the dimension of the Basis.

        Returns
        -------
        dimension : int
            Dimension of the Basis.
        """
        return _func.BasisImplementation_getDimension(self)

    def getSize(self):
        """
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.BasisImplementation_getSize(self)

    def isOrthogonal(self):
        """
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.BasisImplementation_isOrthogonal(self)

    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.BasisImplementation_isFunctional(self)

    def add(self, *args):
        """
        Add an element in the Basis.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            Function added in the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(2):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> basis.add(ot.NumericalMathFunction(input, ['y'], [input[2]]))
        """
        return _func.BasisImplementation_add(self, *args)

    def __init__(self, *args): 
        this = _func.new_BasisImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisImplementation
    __del__ = lambda self : None;
BasisImplementation_swigregister = _func.BasisImplementation_swigregister
BasisImplementation_swigregister(BasisImplementation)

class BasisCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BasisCollection, name)
    __swig_destroy__ = _func.delete_BasisCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _func.BasisCollection_clear(self)

    def __len__(self): return _func.BasisCollection___len__(self)
    def __eq__(self, *args): return _func.BasisCollection___eq__(self, *args)
    def __contains__(self, *args): return _func.BasisCollection___contains__(self, *args)
    def __getitem__(self, *args): return _func.BasisCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _func.BasisCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _func.BasisCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _func.BasisCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _func.BasisCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _func.BasisCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _func.BasisCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _func.BasisCollection_isEmpty(self)

    def __repr__(self): return _func.BasisCollection___repr__(self)
    def __str__(self, offset=""): return _func.BasisCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_BasisCollection(*args)
        try: self.this.append(this)
        except: self.this = this
BasisCollection_swigregister = _func.BasisCollection_swigregister
BasisCollection_swigregister(BasisCollection)

class BasisPersistentCollection(openturns.common.PersistentObject,BasisCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject,BasisCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisPersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject,BasisCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisPersistentCollection, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisPersistentCollection_getClassName(self)

    def __init__(self, *args): 
        this = _func.new_BasisPersistentCollection(*args)
        try: self.this.append(this)
        except: self.this = this
    def __repr__(self): return _func.BasisPersistentCollection___repr__(self)
    def __str__(self, offset=""): return _func.BasisPersistentCollection___str__(self, offset)
    __swig_destroy__ = _func.delete_BasisPersistentCollection
    __del__ = lambda self : None;
BasisPersistentCollection_swigregister = _func.BasisPersistentCollection_swigregister
BasisPersistentCollection_swigregister(BasisPersistentCollection)

class BasisImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_BasisImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.BasisImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_BasisImplementationTypedInterfaceObject
    __del__ = lambda self : None;
BasisImplementationTypedInterfaceObject_swigregister = _func.BasisImplementationTypedInterfaceObject_swigregister
BasisImplementationTypedInterfaceObject_swigregister(BasisImplementationTypedInterfaceObject)

class Basis(BasisImplementationTypedInterfaceObject):
    """
    Basis.

    Available constructors:
        Basis(*functionsColl*)

        Basis(*size*)

    Parameters
    ----------
    functionsColl : list of :class:`~openturns.NumericalMathFunction`
        Functions constituting the Basis.
    size : int
        Size of the Basis.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> input = ['x0', 'x1', 'x2']
    >>> functions = []
    >>> for i in range(dimension):
    ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
    >>> basis = ot.Basis(functions)
    """
    __swig_setmethods__ = {}
    for _s in [BasisImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Basis, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Basis, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.Basis_getClassName(self)

    def build(self, *args):
        """
        Build the element of the given index.

        Parameters
        ----------
        index : int, :math:`index \\geq 0`
            Index of an element of the Basis.

        Returns
        -------
        function : :class:`~openturns.NumericalMathFunction`
            The function at the index *index* of the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> print(basis.build(0).getEvaluation())
        [x0,x1,x2]->[x0]
        """
        return _func.Basis_build(self, *args)

    def getSubBasis(self, *args):
        """
        Get a sub-basis of the Basis.

        Parameters
        ----------
        indices : list of int
            Indices of the terms of the Basis put in the sub-basis.

        Returns
        -------
        subBasis : list of :class:`~openturns.NumericalMathFunction`
            Functions defining a sub-basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(dimension):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> subbasis = basis.getSubBasis([1])
        >>> print(subbasis[0].getEvaluation())
        [x0,x1,x2]->[x1]
        """
        return _func.Basis_getSubBasis(self, *args)

    def getDimension(self):
        """
        Get the dimension of the Basis.

        Returns
        -------
        dimension : int
            Dimension of the Basis.
        """
        return _func.Basis_getDimension(self)

    def getSize(self):
        """
        Get the size of the Basis.

        Returns
        -------
        size : int
            Size of the Basis.
        """
        return _func.Basis_getSize(self)

    def add(self, *args):
        """
        Add an element in the Basis.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathFunction`
            Function added in the Basis.

        Examples
        --------
        >>> import openturns as ot
        >>> dimension = 3
        >>> input = ['x0', 'x1', 'x2']
        >>> functions = []
        >>> for i in range(2):
        ...     functions.append(ot.NumericalMathFunction(input, ['y'], [input[i]]))
        >>> basis = ot.Basis(functions)
        >>> basis.add(ot.NumericalMathFunction(input, ['y'], [input[2]]))
        """
        return _func.Basis_add(self, *args)

    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.Basis_isFunctional(self)

    def isOrthogonal(self):
        """
        Tell whether the basis is orthogonal.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is orthogonal.
        """
        return _func.Basis_isOrthogonal(self)

    def __repr__(self): return _func.Basis___repr__(self)
    def __str__(self, offset=""): return _func.Basis___str__(self, offset)
    def __len__(self): return _func.Basis___len__(self)
    def __init__(self, *args): 
        this = _func.new_Basis(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_Basis
    __del__ = lambda self : None;
Basis_swigregister = _func.Basis_swigregister
Basis_swigregister(Basis)

class BasisSequenceImplementation(openturns.geom.IndicesPersistentCollection):
    """
    Sequence of basis.

    Available constructors:
        BasisSequence(*basis*)

        BasisSequence(*basisSeqImp*)

    Parameters
    ----------
    basis : a :class:`~openturns.Basis`
        A Basis.
    basisSeqImp : BasisSequenceImplementation
        A BasisSequenceImplementation.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.geom.IndicesPersistentCollection]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.geom.IndicesPersistentCollection]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceImplementation_getClassName(self)

    def __repr__(self): return _func.BasisSequenceImplementation___repr__(self)
    def __str__(self, offset=""): return _func.BasisSequenceImplementation___str__(self, offset)
    def getDimension(self): return _func.BasisSequenceImplementation_getDimension(self)
    def getMasterBasis(self): return _func.BasisSequenceImplementation_getMasterBasis(self)
    def getBasis(self, *args): return _func.BasisSequenceImplementation_getBasis(self, *args)
    def getIndices(self, *args): return _func.BasisSequenceImplementation_getIndices(self, *args)
    def __init__(self, *args): 
        this = _func.new_BasisSequenceImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceImplementation
    __del__ = lambda self : None;
BasisSequenceImplementation_swigregister = _func.BasisSequenceImplementation_swigregister
BasisSequenceImplementation_swigregister(BasisSequenceImplementation)

class BasisSequenceImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_BasisSequenceImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.BasisSequenceImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_BasisSequenceImplementationTypedInterfaceObject
    __del__ = lambda self : None;
BasisSequenceImplementationTypedInterfaceObject_swigregister = _func.BasisSequenceImplementationTypedInterfaceObject_swigregister
BasisSequenceImplementationTypedInterfaceObject_swigregister(BasisSequenceImplementationTypedInterfaceObject)

class BasisSequenceImplementationTypedCollectionInterfaceObject(BasisSequenceImplementationTypedInterfaceObject):
    __swig_setmethods__ = {}
    for _s in [BasisSequenceImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceImplementationTypedCollectionInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceImplementationTypedCollectionInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_BasisSequenceImplementationTypedCollectionInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def __getitem__(self, *args): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject___getitem__(self, *args)
    def __setitem__(self, *args): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject___setitem__(self, *args)
    def add(self, *args): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_add(self, *args)
    def getSize(self): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_getSize(self)
    def getDimension(self): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_getDimension(self)
    def isEmpty(self): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_isEmpty(self)
    def erase(self, *args): return _func.BasisSequenceImplementationTypedCollectionInterfaceObject_erase(self, *args)
    __swig_destroy__ = _func.delete_BasisSequenceImplementationTypedCollectionInterfaceObject
    __del__ = lambda self : None;
BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister = _func.BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister
BasisSequenceImplementationTypedCollectionInterfaceObject_swigregister(BasisSequenceImplementationTypedCollectionInterfaceObject)

class BasisSequence(BasisSequenceImplementationTypedCollectionInterfaceObject):
    """
    Sequence of basis.

    Available constructors:
        BasisSequence(*basis*)

        BasisSequence(*basisSeqImp*)

    Parameters
    ----------
    basis : a :class:`~openturns.Basis`
        A Basis.
    basisSeqImp : BasisSequenceImplementation
        A BasisSequenceImplementation.
    """
    __swig_setmethods__ = {}
    for _s in [BasisSequenceImplementationTypedCollectionInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequence, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceImplementationTypedCollectionInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequence, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequence_getClassName(self)

    def getDimension(self): return _func.BasisSequence_getDimension(self)
    def getMasterBasis(self): return _func.BasisSequence_getMasterBasis(self)
    def getBasis(self, *args): return _func.BasisSequence_getBasis(self, *args)
    def getIndices(self, *args): return _func.BasisSequence_getIndices(self, *args)
    def __repr__(self): return _func.BasisSequence___repr__(self)
    def __str__(self, offset=""): return _func.BasisSequence___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_BasisSequence(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisSequence
    __del__ = lambda self : None;
BasisSequence_swigregister = _func.BasisSequence_swigregister
BasisSequence_swigregister(BasisSequence)

class FunctionalBasisImplementation(BasisImplementation):
    __swig_setmethods__ = {}
    for _s in [BasisImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasisImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasisImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionalBasisImplementation_getClassName(self)

    def isFunctional(self):
        """
        Tell whether the basis is functional.

        Returns
        -------
        isOrthogonal : bool
            `True` if the basis is functional i.e. if its terms are a solution
            to an equation (e.g. a basis made up of Legendre functions).
        """
        return _func.FunctionalBasisImplementation_isFunctional(self)

    def __repr__(self): return _func.FunctionalBasisImplementation___repr__(self)
    def __init__(self, *args): 
        this = _func.new_FunctionalBasisImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_FunctionalBasisImplementation
    __del__ = lambda self : None;
FunctionalBasisImplementation_swigregister = _func.FunctionalBasisImplementation_swigregister
FunctionalBasisImplementation_swigregister(FunctionalBasisImplementation)

class FunctionalBasisImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasisImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasisImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_FunctionalBasisImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.FunctionalBasisImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.FunctionalBasisImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_FunctionalBasisImplementationTypedInterfaceObject
    __del__ = lambda self : None;
FunctionalBasisImplementationTypedInterfaceObject_swigregister = _func.FunctionalBasisImplementationTypedInterfaceObject_swigregister
FunctionalBasisImplementationTypedInterfaceObject_swigregister(FunctionalBasisImplementationTypedInterfaceObject)

class FunctionalBasis(FunctionalBasisImplementationTypedInterfaceObject):
    """Proxy of C++ OT::FunctionalBasis"""
    __swig_setmethods__ = {}
    for _s in [FunctionalBasisImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FunctionalBasis, name, value)
    __swig_getmethods__ = {}
    for _s in [FunctionalBasisImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, FunctionalBasis, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.FunctionalBasis_getClassName(self)

    def build(self, *args): return _func.FunctionalBasis_build(self, *args)
    def isOrthogonal(self): return _func.FunctionalBasis_isOrthogonal(self)
    def __repr__(self): return _func.FunctionalBasis___repr__(self)
    def __init__(self, *args): 
        this = _func.new_FunctionalBasis(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_FunctionalBasis
    __del__ = lambda self : None;
FunctionalBasis_swigregister = _func.FunctionalBasis_swigregister
FunctionalBasis_swigregister(FunctionalBasis)

class BasisSequenceFactoryImplementation(openturns.common.PersistentObject):
    """
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LAR

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactoryImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactoryImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactoryImplementation_getClassName(self)

    def setVerbose(self, *args): return _func.BasisSequenceFactoryImplementation_setVerbose(self, *args)
    def getVerbose(self): return _func.BasisSequenceFactoryImplementation_getVerbose(self)
    def build(self, *args): return _func.BasisSequenceFactoryImplementation_build(self, *args)
    def setMaximumRelativeConvergence(self, *args): return _func.BasisSequenceFactoryImplementation_setMaximumRelativeConvergence(self, *args)
    def getMaximumRelativeConvergence(self): return _func.BasisSequenceFactoryImplementation_getMaximumRelativeConvergence(self)
    def __repr__(self): return _func.BasisSequenceFactoryImplementation___repr__(self)
    def __str__(self, offset=""): return _func.BasisSequenceFactoryImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_BasisSequenceFactoryImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceFactoryImplementation
    __del__ = lambda self : None;
BasisSequenceFactoryImplementation_swigregister = _func.BasisSequenceFactoryImplementation_swigregister
BasisSequenceFactoryImplementation_swigregister(BasisSequenceFactoryImplementation)

class BasisSequenceFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactoryImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactoryImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _func.new_BasisSequenceFactoryImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.BasisSequenceFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _func.BasisSequenceFactoryImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _func.delete_BasisSequenceFactoryImplementationTypedInterfaceObject
    __del__ = lambda self : None;
BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister = _func.BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister
BasisSequenceFactoryImplementationTypedInterfaceObject_swigregister(BasisSequenceFactoryImplementationTypedInterfaceObject)

class BasisSequenceFactory(BasisSequenceFactoryImplementationTypedInterfaceObject):
    """
    Basis sequence factory.

    Available constructors:
        BasisSequenceFactory(*basisSeqFacImp*)

    Parameters
    ----------
    basisSeqFacImp : a BasisSequenceFactoryImplementation

    See also
    --------
    LAR

    Notes
    -----
    BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
    This class is not usable because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """
    __swig_setmethods__ = {}
    for _s in [BasisSequenceFactoryImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisSequenceFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceFactoryImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisSequenceFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisSequenceFactory_getClassName(self)

    def __repr__(self): return _func.BasisSequenceFactory___repr__(self)
    def __str__(self, offset=""): return _func.BasisSequenceFactory___str__(self, offset)
    def setVerbose(self, *args):
        """
        Accessor to the verbosity.

        Parameters
        ----------
        v : bool
            Enable or disable the verbosity.
        """
        return _func.BasisSequenceFactory_setVerbose(self, *args)

    def getVerbose(self):
        """
        Accessor to the verbosity.

        Returns
        -------
        v : bool.
            Verbosity
        """
        return _func.BasisSequenceFactory_getVerbose(self)

    def build(self, *args): return _func.BasisSequenceFactory_build(self, *args)
    def setMaximumRelativeConvergence(self, *args):
        """
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Parameters
        ----------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_setMaximumRelativeConvergence(self, *args)

    def getMaximumRelativeConvergence(self):
        """
        Accessor to the stopping criterion on the L1-norm of the coefficients.

        Returns
        -------
        e : float
            Stopping criterion.
        """
        return _func.BasisSequenceFactory_getMaximumRelativeConvergence(self)

    def __init__(self, *args): 
        this = _func.new_BasisSequenceFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisSequenceFactory
    __del__ = lambda self : None;
BasisSequenceFactory_swigregister = _func.BasisSequenceFactory_swigregister
BasisSequenceFactory_swigregister(BasisSequenceFactory)

class LARS(BasisSequenceFactoryImplementation):
    """
    Least Angle Regression.

    Available constructors:
        LARS()

    See also
    --------
    BasisSequenceFactory

    Notes
    -----
    LARS inherits from :class:`~openturns.BasisSequenceFactory`.

    If the size :math:`P` of the PC basis is of similar size to :math:`N`, or even
    possibly significantly larger than :math:`N` , then the following ordinary least
    squares problem is ill-posed:

    .. math::

        \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} E_{\\mu} \\left[ \\left( g \\circ T^{-1}
                (\\vect{U}) - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U}) \\right)^2 \\right]

    The sparse least squares approaches may be employed instead. Eventually a sparse
    PC representation is obtained, that is an approximation which only contains a
    small number of active basis functions.

    This class is not usable as is because it has sense only whithin the
    :class:`~openturns.FunctionalChaosAlgorithm`.
    """
    __swig_setmethods__ = {}
    for _s in [BasisSequenceFactoryImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LARS, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisSequenceFactoryImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LARS, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LARS_getClassName(self)

    def build(self, *args): return _func.LARS_build(self, *args)
    def __repr__(self): return _func.LARS___repr__(self)
    def __str__(self, offset=""): return _func.LARS___str__(self, offset)
    def __init__(self, *args): 
        this = _func.new_LARS(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LARS
    __del__ = lambda self : None;
LARS_swigregister = _func.LARS_swigregister
LARS_swigregister(LARS)

# deprecated
class LAR(LARS):
    def __init__(self, *args):
        super(LAR, self).__init__(*args)
        openturns.common.Log.Warn('class LAR is deprecated in favor of LARS')

class BoxCoxEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::BoxCoxEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoxCoxEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BoxCoxEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.BoxCoxEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.BoxCoxEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.BoxCoxEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.BoxCoxEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.BoxCoxEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.BoxCoxEvaluationImplementation_getOutputDimension(self)

    def getLambda(self): return _func.BoxCoxEvaluationImplementation_getLambda(self)
    def getShift(self): return _func.BoxCoxEvaluationImplementation_getShift(self)
    def __init__(self, *args): 
        this = _func.new_BoxCoxEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BoxCoxEvaluationImplementation
    __del__ = lambda self : None;
BoxCoxEvaluationImplementation_swigregister = _func.BoxCoxEvaluationImplementation_swigregister
BoxCoxEvaluationImplementation_swigregister(BoxCoxEvaluationImplementation)

class BoxCoxTransform(NumericalMathFunction):
    """
    BoxCox transformation.

    Available constructors:
        BoxCoxTransform(*lambdaVect, shiftVect = [0]*)

        BoxCoxTransform(*lambda, shift=0*)

    Parameters
    ----------
    lambdaVect : sequence of float
        The  :math:`(\\lambda_1, \\dots, \\lambda_d)` parameter.
    shiftVect : sequence of float
        The  :math:`(\\alpha_1, \\dots, \\alpha_d)` parameter. 

        Default is :math:`(\\alpha_1, \\dots, \\alpha_d)=(0, \\dots, 0)`.
    lambda : float
        The  :math:`\\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\\alpha` parameter in the univariate case.

        Default is :math:`\\alpha = 0`.


    Notes
    -----
    The Box Cox transformation :math:`h_{\\vect{\\lambda}, \\vect{\\alpha}}: \\Rset^d \\rightarrow \\Rset^d` writes for each component :math:`h_{\\lambda_i, \\alpha_i}: \\Rset \\rightarrow \\Rset`:

    .. math::

        h_{\\lambda_i, \\alpha_i} (x)= 
        \\left\\{
        \\begin{array}{ll}
        \\dfrac{(x+\\alpha_i)^{\\lambda_i}-1}{\\lambda} & \\lambda_i \\neq 0 \\\\
        \\log(x+\\alpha_i)                        & \\lambda_i = 0
        \\end{array}
        \\right.

    for all :math:`x+\\alpha_i >0`.

    The inverse Box Cox transformation writes:

    .. math::

        \\begin{array}{lcl}
          h_{\\lambda_i, \\alpha_i}^{-1}(y) & = &
          \\left\\{
          \\begin{array}{ll}
        \\displaystyle (\\lambda_i y + 1)^{\\frac{1}{\\lambda_i}} - \\alpha_i & \\lambda_i \\neq 0 \\\\
        \\displaystyle \\exp(y) - \\alpha_i                         & \\lambda_i = 0
          \\end{array}
          \\right.
        \\end{array}

    Examples
    --------

    Create a Box Cox tranformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myBoxCox = ot.BoxCoxTransform(myLambda)

    Estimate a transformation from a sample:

    >>> mySample = ot.Exponential(2).getSample(100)
    >>> myModelTransform = ot.BoxCoxFactory().build(mySample)

    Apply ot to the sample:

    >>> myNormalSample = myModelTransform(mySample)

    >>> hist = ot.HistogramFactory().build(myNormalSample)
    >>> graph = hist.drawPDF()

    Apply it to a field:

    >>> myIndices= ot.Indices([10,5])
    >>> myMesher=ot.IntervalMesher(myIndices)
    >>> myInterval = ot.Interval([0.0, 0.0], [2.0, 1.0])
    >>> myMesh=myMesher.build(myInterval)
    >>> amplitude=[1.0]
    >>> scale=[0.2, 0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXproc=ot.TemporalNormalProcess(myCovModel, myMesh)
    >>> g = ot.NumericalMathFunction(['x1'],  ['exp(x1)'])
    >>> myDynTransform = ot.SpatialFunction(g, 2)
    >>> myXtProcess = ot.CompositeProcess(myDynTransform, myXproc)

    >>> myField = myXtProcess.getRealization()
    >>> myModelTransform = ot.BoxCoxFactory().build(myField)
    >>> myStabilizedField = myModelTransform(myField)

    >>> marginal = ot.HistogramFactory().build(myStabilizedField.getValues())
    >>> graph2 = marginal.drawPDF()

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoxCoxTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BoxCoxTransform, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BoxCoxTransform_getClassName(self)

    def getLambda(self):
        """
        Accessor to the :math:`\\vect{\\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.NumericalPoint`
            The :math:`\\vect{\\lambda}` parameter.


        """
        return _func.BoxCoxTransform_getLambda(self)

    def getShift(self):
        """
        Accessor to the :math:`\\vect{\\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.NumericalPoint`
            The :math:`\\vect{\\Lambda}` parameter.


        """
        return _func.BoxCoxTransform_getShift(self)

    def getInverse(self):
        """
        Accessor to the inverse Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.InverseBoxCoxTransform`
            The inverse Box Cox transformation.


        """
        return _func.BoxCoxTransform_getInverse(self)

    def __init__(self, *args): 
        this = _func.new_BoxCoxTransform(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BoxCoxTransform
    __del__ = lambda self : None;
BoxCoxTransform_swigregister = _func.BoxCoxTransform_swigregister
BoxCoxTransform_swigregister(BoxCoxTransform)

class InverseBoxCoxEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::InverseBoxCoxEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseBoxCoxEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseBoxCoxEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.InverseBoxCoxEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.InverseBoxCoxEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.InverseBoxCoxEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.InverseBoxCoxEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseBoxCoxEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseBoxCoxEvaluationImplementation_getOutputDimension(self)

    def getLambda(self): return _func.InverseBoxCoxEvaluationImplementation_getLambda(self)
    def getShift(self): return _func.InverseBoxCoxEvaluationImplementation_getShift(self)
    def __init__(self, *args): 
        this = _func.new_InverseBoxCoxEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_InverseBoxCoxEvaluationImplementation
    __del__ = lambda self : None;
InverseBoxCoxEvaluationImplementation_swigregister = _func.InverseBoxCoxEvaluationImplementation_swigregister
InverseBoxCoxEvaluationImplementation_swigregister(InverseBoxCoxEvaluationImplementation)

class InverseBoxCoxTransform(NumericalMathFunction):
    """
    BoxCox transformation.

    Available constructors:
        InverseBoxCoxTransform(*lambdaVect, shiftVect = 0*)

        InverseBoxCoxTransform(*lambda, shift=0*)

    Parameters
    ----------
    lambdaVect : :class:`~openturns.NumericalPoint`
        The  :math:`(\\lambda_1, \\dots, \\lambda_d)` parameter.
    shiftVect : :class:`~openturns.NumericalPoint`
        The  :math:`(\\alpha_1, \\dots, \\alpha_d)` parameter. 

        Default is :math:`(\\alpha_1, \\dots, \\alpha_d)=(0, \\dots, 0)`.
    lambda : float
        The  :math:`\\lambda` parameter in the univariate case.
    shift : float
        The   :math:`\\alpha` parameter in the univariate case.

        Default is :math:`\\alpha = 0`.


    Notes
    -----
    The inverse Box Cox transformation :math:`h_{\\vect{\\lambda}, \\vect{\\alpha}}^{-1}: \\Rset^d \\rightarrow \\Rset^d` writes for each component :math:`h_{\\lambda_i, \\alpha_i}^{-1}: \\Rset \\rightarrow \\Rset`:

    .. math::

        \\begin{array}{lcl}
          h_{\\lambda_i, \\alpha_i}^{-1}(y) & = &
          \\left\\{
          \\begin{array}{ll}
        \\displaystyle (\\lambda_i y + 1)^{\\frac{1}{\\lambda_i}} - \\alpha_i & \\lambda_i \\neq 0 \\\\
        \\displaystyle \\exp(y) - \\alpha_i                         & \\lambda_i = 0
          \\end{array}
          \\right.
        \\end{array}

    The  Box Cox transformation writes:

    .. math::

        h_{\\lambda_i, \\alpha_i}^{-1} (x)= 
        \\left\\{
        \\begin{array}{ll}
        \\dfrac{(x+\\alpha_i)^\\lambda_i-1}{\\lambda} & \\lambda_i \\neq 0 \\\\
        \\log(x+\\alpha_i)                        & \\lambda_i = 0
        \\end{array}
        \\right.

    for all :math:`x+\\alpha_i >0`.

    Examples
    --------

    Create an inverse Box Cox tranformation:

    >>> import openturns as ot
    >>> myLambda = 0.1
    >>> myInverseBoxCox = ot.InverseBoxCoxTransform(myLambda)

    """
    __swig_setmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseBoxCoxTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseBoxCoxTransform, name)
    __repr__ = _swig_repr
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseBoxCoxTransform_getClassName(self)

    def getLambda(self):
        """
        Accessor to the :math:`\\vect{\\lambda}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.NumericalPoint`
            The :math:`\\vect{\\lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getLambda(self)

    def getShift(self):
        """
        Accessor to the :math:`\\vect{\\alpha}` parameter.

        Returns
        -------
        myLambda : :class:`~openturns.NumericalPoint`
            The :math:`\\vect{\\Lambda}` parameter.


        """
        return _func.InverseBoxCoxTransform_getShift(self)

    def getInverse(self):
        """
        Accessor to the  Box Cox transformation.

        Returns
        -------
        myInverseBoxCox : :class:`~openturns.BoxCoxTransform`
            The Box Cox transformation.


        """
        return _func.InverseBoxCoxTransform_getInverse(self)

    def __init__(self, *args): 
        this = _func.new_InverseBoxCoxTransform(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_InverseBoxCoxTransform
    __del__ = lambda self : None;
InverseBoxCoxTransform_swigregister = _func.InverseBoxCoxTransform_swigregister
InverseBoxCoxTransform_swigregister(InverseBoxCoxTransform)

class TrendEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::TrendEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrendEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrendEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.TrendEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.TrendEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.TrendEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.TrendEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.TrendEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.TrendEvaluationImplementation_getOutputDimension(self)

    def getFunction(self): return _func.TrendEvaluationImplementation_getFunction(self)
    def __init__(self, *args): 
        this = _func.new_TrendEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_TrendEvaluationImplementation
    __del__ = lambda self : None;
TrendEvaluationImplementation_swigregister = _func.TrendEvaluationImplementation_swigregister
TrendEvaluationImplementation_swigregister(TrendEvaluationImplementation)

class TrendTransform(TemporalFunction):
    """
    Trend transformation.

    Parameters
    ----------
    myTrendFunc : :class:`~openturns.NumericalMathFunction`
        The trend function :math:`f_{trend}` of a process.

    Notes
    -----
    A multivariate stochastic process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* where :math:`\\cD \\in \\Rset^n` may write as the sum of a trend function :math:`f_{trend}: \\Rset^n \\rightarrow \\Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* as follows:

    .. math::

        X(\\omega,\\vect{t}) = X_{stat}(\\omega,\\vect{t}) + f_{trend}(\\vect{t})
        

    We note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\\cM = (\\vect{t}_0, \\dots, \\vect{t}_{N-1})` of :math:`\\cD`. We note :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \\vect{x}^{stat}_i = \\vect{x}_i - f_{trend}(\\vect{t}_i)

     
    Examples
    --------
    Create a trend function: :math:`f_{trend} : \\Rset \\mapsto \\Rset` where :math:`f_{trend}(t)=1+2t+t^2`:

    >>> import openturns as ot
    >>> f = ot.NumericalMathFunction(['t'], ['1+2*t+t^2'])
    >>> fTrend = ot.TrendTransform(f)

    Add it to a process:

    >>> myGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> amplitude=[5.0]
    >>> scale=[0.2]
    >>> myCovModel=ot.ExponentialModel(scale, amplitude)
    >>> myXProcess=ot.TemporalNormalProcess(myCovModel, myGrid)
    >>> myYProcess = ot.CompositeProcess(fTrend, myXProcess)

    Remove it from a field:

    >>> myField = myYProcess.getRealization()
    >>> myStatField = fTrend.getInverse()(myField)

    Then re-add it:

    >>> myInitialField = fTrend(myStatField)

    """
    __swig_setmethods__ = {}
    for _s in [TemporalFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrendTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [TemporalFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrendTransform, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.TrendTransform_getClassName(self)

    def __eq__(self, *args): return _func.TrendTransform___eq__(self, *args)
    def __repr__(self): return _func.TrendTransform___repr__(self)
    def __str__(self, offset=""): return _func.TrendTransform___str__(self, offset)
    def __call__(self, *args): return _func.TrendTransform___call__(self, *args)
    def getInverse(self):
        """
        Accessor to the inverse trend function.

        Returns
        -------
        myInverseTrendTransform : :class:`~openturns.InverseTrendTransform`
            The :math:`f_{trend}^{-1}` function.


        """
        return _func.TrendTransform_getInverse(self)

    def __init__(self, *args): 
        this = _func.new_TrendTransform(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_TrendTransform
    __del__ = lambda self : None;
TrendTransform_swigregister = _func.TrendTransform_swigregister
TrendTransform_swigregister(TrendTransform)

class InverseTrendEvaluationImplementation(NumericalMathEvaluationImplementation):
    """Proxy of C++ OT::InverseTrendEvaluationImplementation"""
    __swig_setmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseTrendEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseTrendEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendEvaluationImplementation_getClassName(self)

    def __eq__(self, *args): return _func.InverseTrendEvaluationImplementation___eq__(self, *args)
    def __repr__(self): return _func.InverseTrendEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _func.InverseTrendEvaluationImplementation___str__(self, offset)
    def __call__(self, *args): return _func.InverseTrendEvaluationImplementation___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.InverseTrendEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.InverseTrendEvaluationImplementation_getOutputDimension(self)

    def getFunction(self): return _func.InverseTrendEvaluationImplementation_getFunction(self)
    def __init__(self, *args): 
        this = _func.new_InverseTrendEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_InverseTrendEvaluationImplementation
    __del__ = lambda self : None;
InverseTrendEvaluationImplementation_swigregister = _func.InverseTrendEvaluationImplementation_swigregister
InverseTrendEvaluationImplementation_swigregister(InverseTrendEvaluationImplementation)

class InverseTrendTransform(TemporalFunction):
    """
    Inverse Trend transformation.

    Parameters
    ----------
    myInverseTrendFunc : :class:`~openturns.NumericalMathFunction`
        The  inverse trend function :math:`f_{trend}^{-1}`.


    Notes
    -----
    A multivariate stochastic  process :math:`X: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* where :math:`\\cD \\in \\Rset^n` may write as the sum of a trend function :math:`f_{trend}: \\Rset^n \\rightarrow \\Rset^d` and a stationary multivariate stochastic process :math:`X_{stat}: \\Omega \\times\\cD \\rightarrow \\Rset^d` of dimension *d* as follows:

    .. math::

        X(\\omega,\\vect{t}) = X_{stat}(\\omega,\\vect{t}) + f_{trend}(\\vect{t})
        

    We note :math:`(\\vect{x}_0, \\dots, \\vect{x}_{N-1})` the values of one field of the process *X*, associated to the mesh :math:`\\cM = (\\vect{t}_0, \\dots, \\vect{t}_{N-1})` of :math:`\\cD`. We note :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` the values of the resulting stationary field. Then we have:

    .. math::

        \\vect{x}^{stat}_i = \\vect{x}_i - f_{trend}(\\vect{t}_i)

    The inverse trend transformation enables to get the :math:`X_{stat}` process or to get the :math:`(\\vect{x}^{stat}_0, \\dots, \\vect{x}^{stat}_{N-1})` field.


    Examples
    --------
    Create a trend function: :math:`f_{trend} : \\Rset \\mapsto \\Rset` where :math:`f_{trend}(t,s)=-(1+2t+t^2)`:

    >>> import openturns as ot
    >>> h = ot.NumericalMathFunction(['t'], ['-(1+2*t+t^2)'])
    >>> fTrendInv = ot.InverseTrendTransform(h)


    """
    __swig_setmethods__ = {}
    for _s in [TemporalFunction]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InverseTrendTransform, name, value)
    __swig_getmethods__ = {}
    for _s in [TemporalFunction]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, InverseTrendTransform, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.InverseTrendTransform_getClassName(self)

    def getInverse(self):
        """
        Accessor to the  trend function.

        Returns
        -------
        myTrendTransform : :class:`~openturns.TrendTransform`
            The :math:`f_{trend}` function.


        """
        return _func.InverseTrendTransform_getInverse(self)

    def __eq__(self, *args): return _func.InverseTrendTransform___eq__(self, *args)
    def __repr__(self): return _func.InverseTrendTransform___repr__(self)
    def __str__(self, offset=""): return _func.InverseTrendTransform___str__(self, offset)
    def __call__(self, *args): return _func.InverseTrendTransform___call__(self, *args)
    def __init__(self, *args): 
        this = _func.new_InverseTrendTransform(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_InverseTrendTransform
    __del__ = lambda self : None;
InverseTrendTransform_swigregister = _func.InverseTrendTransform_swigregister
InverseTrendTransform_swigregister(InverseTrendTransform)

class BasisFactory(openturns.common.PersistentObject):
    """
    Basis factory to construct the regression basis.

    Available constructors:
       BasisFactory()

       BasisFactory(*orthogUniVarPolFactory*)

    Parameters
    ----------
    orthogUniVarPolFactory : :class:`~openturns.OrthogonalUniVariatePolynomialFactory`
        Factory that builds particular univariate polynomial (e.g. Hermite,
        Legendre, Laguerre, ...).

    See also
    --------
    ConstantBasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    BasisFactory is the interface of the OrthogonalUniVariatePolynomialFactory
    implementation. It represents the factory that allows the construction of any
    univariate orthonormal polynomial with any degree.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasisFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.BasisFactory_getClassName(self)

    def __repr__(self): return _func.BasisFactory___repr__(self)
    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.BasisFactory_build(self)

    def __init__(self, *args): 
        this = _func.new_BasisFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_BasisFactory
    __del__ = lambda self : None;
BasisFactory_swigregister = _func.BasisFactory_swigregister
BasisFactory_swigregister(BasisFactory)

class ConstantBasisFactory(BasisFactory):
    """
    Constant basis factory to construct the regression basis.

    Available constructors:
       ConstantBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, LinearBasisFactory, QuadraticBasisFactory

    Notes
    -----
    A factory for constant basis of input dimension *dimension*.
    """
    __swig_setmethods__ = {}
    for _s in [BasisFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ConstantBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, ConstantBasisFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.ConstantBasisFactory_getClassName(self)

    def __repr__(self): return _func.ConstantBasisFactory___repr__(self)
    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.ConstantBasisFactory_build(self)

    def save(self, *args): return _func.ConstantBasisFactory_save(self, *args)
    def load(self, *args): return _func.ConstantBasisFactory_load(self, *args)
    def __init__(self, *args): 
        this = _func.new_ConstantBasisFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_ConstantBasisFactory
    __del__ = lambda self : None;
ConstantBasisFactory_swigregister = _func.ConstantBasisFactory_swigregister
ConstantBasisFactory_swigregister(ConstantBasisFactory)

class LinearBasisFactory(BasisFactory):
    """
    Linear basis factory to construct the regression basis.

    Available constructors:
       LinearBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, QuadraticBasisFactory

    Notes
    -----
    A factory for linear basis of input dimension *dimension*.
    """
    __swig_setmethods__ = {}
    for _s in [BasisFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearBasisFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.LinearBasisFactory_getClassName(self)

    def __repr__(self): return _func.LinearBasisFactory___repr__(self)
    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.LinearBasisFactory_build(self)

    def save(self, *args): return _func.LinearBasisFactory_save(self, *args)
    def load(self, *args): return _func.LinearBasisFactory_load(self, *args)
    def __init__(self, *args): 
        this = _func.new_LinearBasisFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_LinearBasisFactory
    __del__ = lambda self : None;
LinearBasisFactory_swigregister = _func.LinearBasisFactory_swigregister
LinearBasisFactory_swigregister(LinearBasisFactory)

class QuadraticBasisFactory(BasisFactory):
    """
    Quadratic basis factory to construct the regression basis.

    Available constructors:
       QuadraticBasisFactory(*dimension*)

    Parameters
    ----------
    dimension : integer
        Input dimension of the basis.

    See also
    --------
    BasisFactory, ConstantBasisFactory, LinearBasisFactory

    Notes
    -----
    A factory for quadratic basis of input dimension *dimension*.
    """
    __swig_setmethods__ = {}
    for _s in [BasisFactory]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuadraticBasisFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [BasisFactory]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuadraticBasisFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.QuadraticBasisFactory_getClassName(self)

    def __repr__(self): return _func.QuadraticBasisFactory___repr__(self)
    def build(self):
        """
        Build the basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`.
        """
        return _func.QuadraticBasisFactory_build(self)

    def save(self, *args): return _func.QuadraticBasisFactory_save(self, *args)
    def load(self, *args): return _func.QuadraticBasisFactory_load(self, *args)
    def __init__(self, *args): 
        this = _func.new_QuadraticBasisFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_QuadraticBasisFactory
    __del__ = lambda self : None;
QuadraticBasisFactory_swigregister = _func.QuadraticBasisFactory_swigregister
QuadraticBasisFactory_swigregister(QuadraticBasisFactory)

class NumericalMathEvaluationImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathEvaluationImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathEvaluationImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.NumericalMathEvaluationImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.NumericalMathEvaluationImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_func.NumericalMathEvaluationImplementationPointer_ptr__get, _func.NumericalMathEvaluationImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _func.new_NumericalMathEvaluationImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathEvaluationImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _func.NumericalMathEvaluationImplementationPointer_reset(self)
    def __ref__(self, *args): return _func.NumericalMathEvaluationImplementationPointer___ref__(self, *args)
    def __deref__(self): return _func.NumericalMathEvaluationImplementationPointer___deref__(self)
    def isNull(self): return _func.NumericalMathEvaluationImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _func.NumericalMathEvaluationImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.NumericalMathEvaluationImplementationPointer_get(self)
    def getImplementation(self): return _func.NumericalMathEvaluationImplementationPointer_getImplementation(self)
    def unique(self): return _func.NumericalMathEvaluationImplementationPointer_unique(self)
    def use_count(self): return _func.NumericalMathEvaluationImplementationPointer_use_count(self)
    def swap(self, *args): return _func.NumericalMathEvaluationImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathEvaluationImplementationPointer_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathEvaluationImplementationPointer___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathEvaluationImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathEvaluationImplementationPointer___str__(self, offset)
    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.NumericalMathEvaluationImplementationPointer_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.NumericalMathEvaluationImplementationPointer_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.NumericalMathEvaluationImplementationPointer_getInputDescription(self)

    def setInputDescription(self, *args):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setInputDescription(self, *args)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.NumericalMathEvaluationImplementationPointer_getOutputDescription(self)

    def setOutputDescription(self, *args):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setOutputDescription(self, *args)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.NumericalMathEvaluationImplementationPointer_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.NumericalMathEvaluationImplementationPointer_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathEvaluationImplementationPointer_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.NumericalMathEvaluationImplementationPointer_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input points values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getInputParameterHistory(self)

    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.NumericalMathEvaluationImplementationPointer_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.NumericalMathEvaluationImplementationPointer_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathEvaluationImplementationPointer_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.NumericalMathEvaluationImplementationPointer_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.NumericalMathEvaluationImplementationPointer_clearCache(self)

    def isActualImplementation(self):
        """
        Accessor to the validity flag.

        Returns
        -------
        is_impl : bool
            Whether the implementation is valid.
        """
        return _func.NumericalMathEvaluationImplementationPointer_isActualImplementation(self)

    def __call__(self, *args): return _func.NumericalMathEvaluationImplementationPointer___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NumericalMathEvaluationImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NumericalMathEvaluationImplementationPointer_getOutputDimension(self)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameter_dimension : int
            Dimension of the parameter.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getParameterDimension(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getMarginal(self, *args)

    def parameterGradient(self, *args):
        """
        Gradient against the parameters.

        Parameters
        ----------
        x : sequence of float
            Input point

        Returns
        -------
        parameter_gradient : :class:`~openturns.Matrix`
            The parameters gradient computed at x.
        """
        return _func.NumericalMathEvaluationImplementationPointer_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setParameterDescription(self, *args)

    def getCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.NumericalMathEvaluationImplementationPointer_draw(self, *args)

    def __ne__(self, *args): return _func.NumericalMathEvaluationImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.NumericalMathEvaluationImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.NumericalMathEvaluationImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.NumericalMathEvaluationImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.NumericalMathEvaluationImplementationPointer_setName(self, *args)

NumericalMathEvaluationImplementationPointer_swigregister = _func.NumericalMathEvaluationImplementationPointer_swigregister
NumericalMathEvaluationImplementationPointer_swigregister(NumericalMathEvaluationImplementationPointer)

class NumericalMathFunctionImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathFunctionImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathFunctionImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.NumericalMathFunctionImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.NumericalMathFunctionImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_func.NumericalMathFunctionImplementationPointer_ptr__get, _func.NumericalMathFunctionImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _func.new_NumericalMathFunctionImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathFunctionImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _func.NumericalMathFunctionImplementationPointer_reset(self)
    def __ref__(self, *args): return _func.NumericalMathFunctionImplementationPointer___ref__(self, *args)
    def __deref__(self): return _func.NumericalMathFunctionImplementationPointer___deref__(self)
    def isNull(self): return _func.NumericalMathFunctionImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _func.NumericalMathFunctionImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.NumericalMathFunctionImplementationPointer_get(self)
    def getImplementation(self): return _func.NumericalMathFunctionImplementationPointer_getImplementation(self)
    def unique(self): return _func.NumericalMathFunctionImplementationPointer_unique(self)
    def use_count(self): return _func.NumericalMathFunctionImplementationPointer_use_count(self)
    def swap(self, *args): return _func.NumericalMathFunctionImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathFunctionImplementationPointer_getClassName(self)

    def GetValidConstants(self):
        """
        Return the list of valid constants.

        Returns
        -------
        list_constants : :class:`~openturns.Description`
            List of the constants we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidConstants()[0])
        _e -> Euler's constant (2.71828...)
        """
        return _func.NumericalMathFunctionImplementationPointer_GetValidConstants(self)

    def GetValidFunctions(self):
        """
        Return the list of valid functions.

        Returns
        -------
        list_functions : :class:`~openturns.Description`
            List of the functions we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidFunctions()[0])
        sin(arg) -> sine function
        """
        return _func.NumericalMathFunctionImplementationPointer_GetValidFunctions(self)

    def GetValidOperators(self):
        """
        Return the list of valid operators.

        Returns
        -------
        list_operators : :class:`~openturns.Description`
            List of the operators we can use within OpenTURNS.

        Examples
        --------
        >>> import openturns as ot
        >>> print(ot.NumericalMathFunction.GetValidOperators()[0])
        = -> assignement, can only be applied to variable names (priority -1)
        """
        return _func.NumericalMathFunctionImplementationPointer_GetValidOperators(self)

    def __mul__(self, *args): return _func.NumericalMathFunctionImplementationPointer___mul__(self, *args)
    def __eq__(self, *args): return _func.NumericalMathFunctionImplementationPointer___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathFunctionImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathFunctionImplementationPointer___str__(self, offset)
    def enableCache(self):
        """Enable the cache mechanism."""
        return _func.NumericalMathFunctionImplementationPointer_enableCache(self)

    def disableCache(self):
        """Disable the cache mechanism."""
        return _func.NumericalMathFunctionImplementationPointer_disableCache(self)

    def isCacheEnabled(self):
        """
        Test whether the cache mechanism is enabled or not.

        Returns
        -------
        isCacheEnabled : bool
            Flag telling whether the cache mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunctionImplementationPointer_isCacheEnabled(self)

    def getCacheHits(self):
        """
        Accessor to the number of computations saved thanks to the cache mecanism.

        Returns
        -------
        cacheHits : int
            Integer that counts the number of computations saved thanks to the cache
            mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getCacheHits(self)

    def addCacheContent(self, *args):
        """
        Add input numerical points and associated output to the cache.

        Parameters
        ----------
        input_sample : 2-d sequence of float
            Input numerical points to be added to the cache.
        output_sample : 2-d sequence of float
            Output numerical points associated with the input_sample to be added to the
            cache.
        """
        return _func.NumericalMathFunctionImplementationPointer_addCacheContent(self, *args)

    def getCacheInput(self):
        """
        Accessor to all the input numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getCacheInput(self)

    def getCacheOutput(self):
        """
        Accessor to all the output numerical points stored in the cache mecanism.

        Returns
        -------
        cacheInput : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the cache mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getCacheOutput(self)

    def clearCache(self):
        """Empty the content of the cache."""
        return _func.NumericalMathFunctionImplementationPointer_clearCache(self)

    def enableHistory(self):
        """Enable the history mechanism."""
        return _func.NumericalMathFunctionImplementationPointer_enableHistory(self)

    def disableHistory(self):
        """Disable the history mechanism."""
        return _func.NumericalMathFunctionImplementationPointer_disableHistory(self)

    def isHistoryEnabled(self):
        """
        Test whether the history mechanism is enabled or not.

        Returns
        -------
        isHistoryEnabled : bool
            Flag telling whether the history mechanism is enabled.
            It is disabled by default.
        """
        return _func.NumericalMathFunctionImplementationPointer_isHistoryEnabled(self)

    def clearHistory(self):
        """Empty the content of the history."""
        return _func.NumericalMathFunctionImplementationPointer_clearHistory(self)

    def getHistoryInput(self):
        """
        Accessor to the history of the input values.

        Returns
        -------
        input_history : :class:`~openturns.NumericalSample`
            All the input numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getHistoryInput(self)

    def getHistoryOutput(self):
        """
        Accessor to the history of the output values.

        Returns
        -------
        output_history : :class:`~openturns.NumericalSample`
            All the output numerical points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getHistoryOutput(self)

    def getInputPointHistory(self):
        """
        Accessor to the history of the input point values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input points stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getInputPointHistory(self)

    def getInputParameterHistory(self):
        """
        Accessor to the history of the input parameter values.

        Returns
        -------
        history : :class:`~openturns.NumericalSample`
            All the input parameters stored in the history mecanism.
        """
        return _func.NumericalMathFunctionImplementationPointer_getInputParameterHistory(self)

    def setEvaluation(self, *args):
        """
        Accessor to the evaluation function.

        Parameters
        ----------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.
        """
        return _func.NumericalMathFunctionImplementationPointer_setEvaluation(self, *args)

    def getEvaluation(self):
        """
        Accessor to the evaluation function.

        Returns
        -------
        function : :class:`~openturns.NumericalMathEvaluationImplementation`
            The evaluation function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getEvaluation())
        [x1,x2]->[2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6]
        """
        return _func.NumericalMathFunctionImplementationPointer_getEvaluation(self)

    def setGradient(self, *args):
        """
        Accessor to the gradient function.

        Parameters
        ----------
        gradient_function : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setGradient(ot.CenteredFiniteDifferenceGradient(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceGradient-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunctionImplementationPointer_setGradient(self, *args)

    def getGradient(self):
        """
        Accessor to the gradient function.

        Returns
        -------
        gradient : :class:`~openturns.NumericalMathGradientImplementation`
            The gradient function.
        """
        return _func.NumericalMathFunctionImplementationPointer_getGradient(self)

    def setHessian(self, *args):
        """
        Accessor to the hessian function.

        Parameters
        ----------
        hessian_function : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> f.setHessian(ot.CenteredFiniteDifferenceHessian(
        ...  ot.ResourceMap.GetAsNumericalScalar('CenteredFiniteDifferenceHessian-DefaultEpsilon'),
        ...  f.getEvaluation()))
        """
        return _func.NumericalMathFunctionImplementationPointer_setHessian(self, *args)

    def getHessian(self):
        """
        Accessor to the hessian function.

        Returns
        -------
        hessian : :class:`~openturns.NumericalMathHessianImplementation`
            The hessian function.
        """
        return _func.NumericalMathFunctionImplementationPointer_getHessian(self)

    def __call__(self, *args): return _func.NumericalMathFunctionImplementationPointer___call__(self, *args)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.gradient([3.14, 4]))
        [[ 13.5345   1       ]
         [  4.00001  1       ]]
        """
        return _func.NumericalMathFunctionImplementationPointer_gradient(self, *args)

    def hessian(self, *args):
        """
        Return the hessian of the function at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the hessian of the function is calculated.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the function at *point*.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y','z'],
        ...                ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6','x1 + x2'])
        >>> print(f.hessian([3.14, 4]))
        sheet #0
        [[ 20          -0.00637061 ]
         [ -0.00637061  0          ]]
        sheet #1
        [[  0           0          ]
         [  0           0          ]]
        """
        return _func.NumericalMathFunctionImplementationPointer_hessian(self, *args)

    def parameterGradient(self, *args):
        """
        Accessor to the gradient against the parameter.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient.
        """
        return _func.NumericalMathFunctionImplementationPointer_parameterGradient(self, *args)

    def getParameter(self):
        """
        Accessor to the parameter values.

        Returns
        -------
        parameter : :class:`~openturns.NumericalPoint`
            The parameter values.
        """
        return _func.NumericalMathFunctionImplementationPointer_getParameter(self)

    def setParameter(self, *args):
        """
        Accessor to the parameter values.

        Parameters
        ----------
        parameter : sequence of float
            The parameter values.
        """
        return _func.NumericalMathFunctionImplementationPointer_setParameter(self, *args)

    def getParameterDescription(self):
        """
        Accessor to the parameter description.

        Returns
        -------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunctionImplementationPointer_getParameterDescription(self)

    def setParameterDescription(self, *args):
        """
        Accessor to the parameter description.

        Parameters
        ----------
        parameter : :class:`~openturns.Description`
            The parameter description.
        """
        return _func.NumericalMathFunctionImplementationPointer_setParameterDescription(self, *args)

    def getParameterDimension(self):
        """
        Accessor to the dimension of the parameter.

        Returns
        -------
        parameterDimension : int
            Dimension of the parameter.
        """
        return _func.NumericalMathFunctionImplementationPointer_getParameterDimension(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _func.NumericalMathFunctionImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _func.NumericalMathFunctionImplementationPointer_getOutputDimension(self)

    def setDescription(self, *args):
        """
        Accessor to the description of the inputs and outputs.

        Parameters
        ----------
        description : sequence of str
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        >>> f.setDescription(['a','b','y'])
        >>> print(f.getDescription())
        [a,b,y]
        """
        return _func.NumericalMathFunctionImplementationPointer_setDescription(self, *args)

    def getDescription(self):
        """
        Accessor to the description of the inputs and outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs and the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getDescription())
        [x1,x2,y]
        """
        return _func.NumericalMathFunctionImplementationPointer_getDescription(self)

    def getInputDescription(self):
        """
        Accessor to the description of the inputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDescription())
        [x1,x2]
        """
        return _func.NumericalMathFunctionImplementationPointer_getInputDescription(self)

    def getOutputDescription(self):
        """
        Accessor to the description of the outputs.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDescription())
        [y]
        """
        return _func.NumericalMathFunctionImplementationPointer_getOutputDescription(self)

    def getMarginal(self, *args):
        """
        Accessor to marginal.

        Parameters
        ----------
        indices : int or list of ints
            Set of indices for which the marginal is extracted.

        Returns
        -------
        marginal : :class:`~openturns.NumericalMathFunction`
            Function corresponding to either :math:`f_i` or
            :math:`(f_i)_{i \\in indices}`, with :math:`f:\\Rset^n \\rightarrow \\Rset^p`
            and :math:`f=(f_0 , \\dots, f_{p-1})`.
        """
        return _func.NumericalMathFunctionImplementationPointer_getMarginal(self, *args)

    def getEvaluationCallsNumber(self):
        """
        Accessor to the number of times the function has been called.

        Returns
        -------
        evaluation_calls_number : int
            Integer that counts the number of times the function has been called
            since its creation.
        """
        return _func.NumericalMathFunctionImplementationPointer_getEvaluationCallsNumber(self)

    def getGradientCallsNumber(self):
        """
        Accessor to the number of times the gradient of the function has been called.

        Returns
        -------
        gradient_calls_number : int
            Integer that counts the number of times the gradient of the
            NumericalMathFunction has been called since its creation.
            Note that if the gradient is implemented by a finite difference method,
            the gradient calls number is equal to 0 and the different calls are
            counted in the evaluation calls number.
        """
        return _func.NumericalMathFunctionImplementationPointer_getGradientCallsNumber(self)

    def getHessianCallsNumber(self):
        """
        Accessor to the number of times the hessian of the function has been called.

        Returns
        -------
        hessian_calls_number : int
            Integer that counts the number of times the hessian of the
            NumericalMathFunction has been called since its creation.
            Note that if the hessian is implemented by a finite difference method,
            the hessian calls number is equal to 0 and the different calls are counted
            in the evaluation calls number.
        """
        return _func.NumericalMathFunctionImplementationPointer_getHessianCallsNumber(self)

    def draw(self, *args):
        """
        Draw the output of function as a :class:`~openturns.Graph`.

        Available usages:
            draw(*inputMarg, outputMarg, CP, xiMin, xiMax, ptNb*)

            draw(*firstInputMarg, secondInputMarg, outputMarg, CP, xiMin_xjMin, xiMax_xjMax, ptNbs*)

            draw(*xiMin, xiMax, ptNb*)

            draw(*xiMin_xjMin, xiMax_xjMax, ptNbs*)

        Parameters
        ----------
        outputMarg, inputMarg : int, :math:`outputMarg, inputMarg \\geq 0`
            *outputMarg* is the index of the marginal to draw as a function of the marginal
            with index *inputMarg*.
        firstInputMarg, secondInputMarg : int, :math:`firstInputMarg, secondInputMarg \\geq 0`
            In the 2D case, the marginal *outputMarg* is drawn as a function of the
            two marginals with indexes *firstInputMarg* and *secondInputMarg*.
        CP : sequence of float
            Central point.
        xiMin, xiMax : float
            Define the interval where the curve is plotted.
        xiMin_xjMin, xiMax_xjMax : sequence of float of dimension 2.
            In the 2D case, define the intervals where the curves are plotted.
        ptNb : int :math:`ptNb > 0` or list of ints of dimension 2 :math:`ptNb_k > 0, k=1,2`
            The number of points to draw the curves.

        Notes
        -----
        We note :math:`f: \\Rset^n \\rightarrow \\Rset^p`
        where :math:`\\vect{x} = (x_1, \\dots, x_n)` and
        :math:`f(\\vect{x}) = (f_1(\\vect{x}), \\dots,f_p(\\vect{x}))`,
        with :math:`n\\geq 1` and :math:`p\\geq 1`.

        - In the first usage:

        Draws graph of the given 1D *outputMarg* marginal
        :math:`f_k: \\Rset^n \\rightarrow \\Rset` as a function of the given 1D *inputMarg*
        marginal with respect to the variation of :math:`x_i` in the interval
        :math:`[x_i^{min}, x_i^{max}]`, when all the other components of
        :math:`\\vect{x}` are fixed to the corresponding ones of the central point *CP*.
        Then OpenTURNS draws the graph:
        :math:`t\\in [x_i^{min}, x_i^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t,  CP_{i+1} \\dots, CP_n)`.

        - In the second usage:

        Draws the iso-curves of the given *outputMarg* marginal :math:`f_k` as a
        function of the given 2D *firstInputMarg* and *secondInputMarg* marginals
        with respect to the variation of :math:`(x_i, x_j)` in the interval
        :math:`[x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}]`, when all the
        other components of :math:`\\vect{x}` are fixed to the corresponding ones of the
        central point *CP*. Then OpenTURNS draws the graph:
        :math:`(t,u) \\in [x_i^{min}, x_i^{max}] \\times [x_j^{min}, x_j^{max}] \\mapsto f_k(CP_1, \\dots, CP_{i-1}, t, CP_{i+1}, \\dots, CP_{j-1}, u,  CP_{j+1} \\dots, CP_n)`.

        - In the third usage:

        The same as the first usage but only for function :math:`f: \\Rset \\rightarrow \\Rset`.

        - In the fourth usage:

        The same as the second usage but only for function :math:`f: \\Rset^2 \\rightarrow \\Rset`.


        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.NumericalMathFunction('x', 'sin(2*_pi*x)*exp(-x^2/2)', 'y')
        >>> graph = f.draw(-1.2, 1.2, 100)
        >>> View(graph).show()
        """
        return _func.NumericalMathFunctionImplementationPointer_draw(self, *args)

    def __ne__(self, *args): return _func.NumericalMathFunctionImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.NumericalMathFunctionImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathFunctionImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathFunctionImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathFunctionImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathFunctionImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.NumericalMathFunctionImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.NumericalMathFunctionImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.NumericalMathFunctionImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.NumericalMathFunctionImplementationPointer_setName(self, *args)

NumericalMathFunctionImplementationPointer_swigregister = _func.NumericalMathFunctionImplementationPointer_swigregister
NumericalMathFunctionImplementationPointer_swigregister(NumericalMathFunctionImplementationPointer)

class NumericalMathGradientImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathGradientImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathGradientImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.NumericalMathGradientImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.NumericalMathGradientImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_func.NumericalMathGradientImplementationPointer_ptr__get, _func.NumericalMathGradientImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _func.new_NumericalMathGradientImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathGradientImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _func.NumericalMathGradientImplementationPointer_reset(self)
    def __ref__(self, *args): return _func.NumericalMathGradientImplementationPointer___ref__(self, *args)
    def __deref__(self): return _func.NumericalMathGradientImplementationPointer___deref__(self)
    def isNull(self): return _func.NumericalMathGradientImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _func.NumericalMathGradientImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.NumericalMathGradientImplementationPointer_get(self)
    def getImplementation(self): return _func.NumericalMathGradientImplementationPointer_getImplementation(self)
    def unique(self): return _func.NumericalMathGradientImplementationPointer_unique(self)
    def use_count(self): return _func.NumericalMathGradientImplementationPointer_use_count(self)
    def swap(self, *args): return _func.NumericalMathGradientImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathGradientImplementationPointer_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathGradientImplementationPointer___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathGradientImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathGradientImplementationPointer___str__(self, offset)
    def getMarginal(self, *args):
        """
        Accessor to the gradient implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        gradientImplementation : :class:`~openturns.NumericalMathGradientImplementation`
            A gradient implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.NumericalMathGradientImplementationPointer_getMarginal(self, *args)

    def isActualImplementation(self): return _func.NumericalMathGradientImplementationPointer_isActualImplementation(self)
    def gradient(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NumericalMathGradientImplementationPointer_gradient(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NumericalMathGradientImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NumericalMathGradientImplementationPointer_getOutputDimension(self)

    def getParameter(self): return _func.NumericalMathGradientImplementationPointer_getParameter(self)
    def setParameter(self, *args): return _func.NumericalMathGradientImplementationPointer_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the gradient has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the gradient has been called
            since its creation.
        """
        return _func.NumericalMathGradientImplementationPointer_getCallsNumber(self)

    def __ne__(self, *args): return _func.NumericalMathGradientImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.NumericalMathGradientImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathGradientImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathGradientImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathGradientImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathGradientImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.NumericalMathGradientImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.NumericalMathGradientImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.NumericalMathGradientImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.NumericalMathGradientImplementationPointer_setName(self, *args)

NumericalMathGradientImplementationPointer_swigregister = _func.NumericalMathGradientImplementationPointer_swigregister
NumericalMathGradientImplementationPointer_swigregister(NumericalMathGradientImplementationPointer)

class NumericalMathHessianImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericalMathHessianImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericalMathHessianImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.NumericalMathHessianImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.NumericalMathHessianImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_func.NumericalMathHessianImplementationPointer_ptr__get, _func.NumericalMathHessianImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _func.new_NumericalMathHessianImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_NumericalMathHessianImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _func.NumericalMathHessianImplementationPointer_reset(self)
    def __ref__(self, *args): return _func.NumericalMathHessianImplementationPointer___ref__(self, *args)
    def __deref__(self): return _func.NumericalMathHessianImplementationPointer___deref__(self)
    def isNull(self): return _func.NumericalMathHessianImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _func.NumericalMathHessianImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.NumericalMathHessianImplementationPointer_get(self)
    def getImplementation(self): return _func.NumericalMathHessianImplementationPointer_getImplementation(self)
    def unique(self): return _func.NumericalMathHessianImplementationPointer_unique(self)
    def use_count(self): return _func.NumericalMathHessianImplementationPointer_use_count(self)
    def swap(self, *args): return _func.NumericalMathHessianImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.NumericalMathHessianImplementationPointer_getClassName(self)

    def __eq__(self, *args): return _func.NumericalMathHessianImplementationPointer___eq__(self, *args)
    def __repr__(self): return _func.NumericalMathHessianImplementationPointer___repr__(self)
    def __str__(self, offset=""): return _func.NumericalMathHessianImplementationPointer___str__(self, offset)
    def isActualImplementation(self): return _func.NumericalMathHessianImplementationPointer_isActualImplementation(self)
    def getMarginal(self, *args):
        """
        Accessor to the hessian implementation of a specific output.

        Parameters
        ----------
        i : integer
            Integer corresponding to the output (Care: it starts at 0).
        indices : sequence of integer
            The set of indices for which the outputs are extracted.

        Returns
        -------
        hessianImplementation : :class:`~openturns.NumericalMathHessianImplementation`
            A hessian implementation restricted to its compenents functions which
            indices are *i* or *indices*.
        """
        return _func.NumericalMathHessianImplementationPointer_getMarginal(self, *args)

    def hessian(self, *args):
        """
        Return the Jacobian transposed matrix of the implementation at a point.

        Parameters
        ----------
        point : sequence of float
            Point where the Jacobian transposed matrix is calculated.

        Returns
        -------
        hessian : :class:`~openturns.Matrix`
            The Jacobian transposed matrix of the function at *point*.
        """
        return _func.NumericalMathHessianImplementationPointer_hessian(self, *args)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.
        """
        return _func.NumericalMathHessianImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.
        """
        return _func.NumericalMathHessianImplementationPointer_getOutputDimension(self)

    def getParameter(self): return _func.NumericalMathHessianImplementationPointer_getParameter(self)
    def setParameter(self, *args): return _func.NumericalMathHessianImplementationPointer_setParameter(self, *args)
    def getCallsNumber(self):
        """
        Accessor to the number of times the hessian has been called.

        Returns
        -------
        calls_number : int
            Integer that counts the number of times the hessian has been called
            since its creation.
        """
        return _func.NumericalMathHessianImplementationPointer_getCallsNumber(self)

    def __ne__(self, *args): return _func.NumericalMathHessianImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.NumericalMathHessianImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathHessianImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.NumericalMathHessianImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathHessianImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.NumericalMathHessianImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.NumericalMathHessianImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.NumericalMathHessianImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.NumericalMathHessianImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.NumericalMathHessianImplementationPointer_setName(self, *args)

NumericalMathHessianImplementationPointer_swigregister = _func.NumericalMathHessianImplementationPointer_swigregister
NumericalMathHessianImplementationPointer_swigregister(NumericalMathHessianImplementationPointer)

class UniVariatePolynomialImplementationPointer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UniVariatePolynomialImplementationPointer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UniVariatePolynomialImplementationPointer, name)
    __swig_setmethods__["ptr_"] = _func.UniVariatePolynomialImplementationPointer_ptr__set
    __swig_getmethods__["ptr_"] = _func.UniVariatePolynomialImplementationPointer_ptr__get
    if _newclass:ptr_ = _swig_property(_func.UniVariatePolynomialImplementationPointer_ptr__get, _func.UniVariatePolynomialImplementationPointer_ptr__set)
    def __init__(self, *args): 
        this = _func.new_UniVariatePolynomialImplementationPointer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _func.delete_UniVariatePolynomialImplementationPointer
    __del__ = lambda self : None;
    def reset(self): return _func.UniVariatePolynomialImplementationPointer_reset(self)
    def __ref__(self, *args): return _func.UniVariatePolynomialImplementationPointer___ref__(self, *args)
    def __deref__(self): return _func.UniVariatePolynomialImplementationPointer___deref__(self)
    def isNull(self): return _func.UniVariatePolynomialImplementationPointer_isNull(self)
    def __nonzero__(self):
        return _func.UniVariatePolynomialImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__


    def get(self): return _func.UniVariatePolynomialImplementationPointer_get(self)
    def getImplementation(self): return _func.UniVariatePolynomialImplementationPointer_getImplementation(self)
    def unique(self): return _func.UniVariatePolynomialImplementationPointer_unique(self)
    def use_count(self): return _func.UniVariatePolynomialImplementationPointer_use_count(self)
    def swap(self, *args): return _func.UniVariatePolynomialImplementationPointer_swap(self, *args)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _func.UniVariatePolynomialImplementationPointer_getClassName(self)

    def __repr__(self): return _func.UniVariatePolynomialImplementationPointer___repr__(self)
    def __str__(self, *args): return _func.UniVariatePolynomialImplementationPointer___str__(self, *args)
    def __call__(self, *args): return _func.UniVariatePolynomialImplementationPointer___call__(self, *args)
    def gradient(self, *args):
        """
        Compute the gradient at point :math:`x`.

        Returns
        -------
        gradient : float
            The value of the function's first-order derivative at point :math:`x`.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.gradient(1.0))
        8.0
        """
        return _func.UniVariatePolynomialImplementationPointer_gradient(self, *args)

    def hessian(self, *args):
        """
        Compute the hessian at point :math:`x`.

        Parameters
        ----------
        x : float
            Input value.

        Returns
        -------
        hessian : float
            The value of the function's second-order derivative at point :math:`x`.
        """
        return _func.UniVariatePolynomialImplementationPointer_hessian(self, *args)

    def derivate(self):
        """
        Build the first-order derivative polynomial.

        Returns
        -------
        derivated_polynomial : :class:`~openturns.Univariate`
            The first-order derivated polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.derivate())
        2 + 6 * X
        """
        return _func.UniVariatePolynomialImplementationPointer_derivate(self)

    def __mul__(self, *args): return _func.UniVariatePolynomialImplementationPointer___mul__(self, *args)
    def incrementDegree(self, degree=1):
        """
        Multiply the polynomial by :math:`x^k`.

        Parameters
        ----------
        degree : int, optional
            The incremented degree :math:`k`.
            Default uses :math:`k = 1`.

        Returns
        -------
        incremented_degree_polynomial : :class:`~openturns.UniVariatePolynomial`
            Polynomial with incremented degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.incrementDegree())
        X + 2 * X^2 + 3 * X^3
        >>> print(P.incrementDegree(2))
        X^2 + 2 * X^3 + 3 * X^4
        """
        return _func.UniVariatePolynomialImplementationPointer_incrementDegree(self, degree)

    def __add__(self, *args): return _func.UniVariatePolynomialImplementationPointer___add__(self, *args)
    def __sub__(self, *args): return _func.UniVariatePolynomialImplementationPointer___sub__(self, *args)
    def setCoefficients(self, *args):
        """
        Accessor to the polynomials's coefficients.

        Parameters
        ----------
        coefficients : sequence of float
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        getCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> P.setCoefficients([4.0, 2.0, 1.0])
        >>> print(P)
        4 + 2 * X + X^2
        """
        return _func.UniVariatePolynomialImplementationPointer_setCoefficients(self, *args)

    def getCoefficients(self):
        """
        Accessor to the polynomials's coefficients.

        Returns
        -------
        coefficients : :class:`~openturns.NumericalPoint`
            Polynomial coefficients in increasing polynomial order.

        See Also
        --------
        setCoefficients

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getCoefficients())
        [1,2,3]
        """
        return _func.UniVariatePolynomialImplementationPointer_getCoefficients(self)

    def getDegree(self):
        """
        Accessor to the polynomials's degree.

        Returns
        -------
        degree : int
            Polynomial's degree.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getDegree())
        2
        """
        return _func.UniVariatePolynomialImplementationPointer_getDegree(self)

    def getRoots(self):
        """
        Compute the roots of the polynomial.

        Returns
        -------
        roots : list of complex values
            Polynomial's roots.

        Examples
        --------
        >>> import openturns as ot
        >>> P = ot.UniVariatePolynomial([1.0, 2.0, 3.0])
        >>> print(P.getRoots())
        [(-0.333333,0.471405),(-0.333333,-0.471405)]
        """
        return _func.UniVariatePolynomialImplementationPointer_getRoots(self)

    def draw(self, *args):
        """
        Draw the function.

        Parameters
        ----------
        x_min : float, optional
            The starting value that is used for meshing the x-axis.
        x_max : float, optional, :math:`x_{\\max} > x_{\\min}`
            The ending value that is used for meshing the x-axis.
        n_points : int, optional
            The number of points that is used for meshing the x-axis.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> f = ot.UniVariatePolynomial([1.0, 2.0, -3.0, 5.0])
        >>> View(f.draw(-10.0, 10.0, 100)).show()
        """
        return _func.UniVariatePolynomialImplementationPointer_draw(self, *args)

    def __eq__(self, *args): return _func.UniVariatePolynomialImplementationPointer___eq__(self, *args)
    def __ne__(self, *args): return _func.UniVariatePolynomialImplementationPointer___ne__(self, *args)
    def getId(self):
        """
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_getId(self)

    def setShadowedId(self, *args):
        """
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_setShadowedId(self, *args)

    def getShadowedId(self):
        """
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _func.UniVariatePolynomialImplementationPointer_getShadowedId(self)

    def setVisibility(self, *args):
        """
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _func.UniVariatePolynomialImplementationPointer_setVisibility(self, *args)

    def getVisibility(self):
        """
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _func.UniVariatePolynomialImplementationPointer_getVisibility(self)

    def hasName(self):
        """
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _func.UniVariatePolynomialImplementationPointer_hasName(self)

    def hasVisibleName(self):
        """
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _func.UniVariatePolynomialImplementationPointer_hasVisibleName(self)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationPointer_getName(self)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _func.UniVariatePolynomialImplementationPointer_setName(self, *args)

UniVariatePolynomialImplementationPointer_swigregister = _func.UniVariatePolynomialImplementationPointer_swigregister
UniVariatePolynomialImplementationPointer_swigregister(UniVariatePolynomialImplementationPointer)

# This file is compatible with both classic and new-style classes.


