# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Weighted designs of experiments."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _weightedexperiment
else:
    import _weightedexperiment

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _weightedexperiment.delete_SwigPyIterator

    def value(self):
        return _weightedexperiment.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _weightedexperiment.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _weightedexperiment.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _weightedexperiment.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _weightedexperiment.SwigPyIterator_equal(self, x)

    def copy(self):
        return _weightedexperiment.SwigPyIterator_copy(self)

    def next(self):
        return _weightedexperiment.SwigPyIterator_next(self)

    def __next__(self):
        return _weightedexperiment.SwigPyIterator___next__(self)

    def previous(self):
        return _weightedexperiment.SwigPyIterator_previous(self)

    def advance(self, n):
        return _weightedexperiment.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _weightedexperiment.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _weightedexperiment.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _weightedexperiment.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _weightedexperiment.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _weightedexperiment.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _weightedexperiment.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _weightedexperiment:
_weightedexperiment.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class WeightedExperimentImplementation(openturns.experiment.ExperimentImplementation):
    r"""
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\Xi_i` so that the
    mean :math:`E_{\mu}` is approximated as follows:

    .. math::

        \Expect{ f(\vect{Z})}_{\mu} \simeq \sum_{i \in I} \omega_i f(\Xi_i)

    where :math:`\mu` is a distribution, :math:`f` is a function :math:`L_1(\mu)`
    and :math:`\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperimentImplementation_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.WeightedExperimentImplementation___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getDistribution(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperimentImplementation_getSize(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.WeightedExperimentImplementation_hasUniformWeights(self)

    def generate(self):
        r"""
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\Xi_i)_{i \in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generate(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperimentImplementation_generateWithWeights(self, weights)

    def __init__(self, *args):
        _weightedexperiment.WeightedExperimentImplementation_swiginit(self, _weightedexperiment.new_WeightedExperimentImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementation

# Register WeightedExperimentImplementation in _weightedexperiment:
_weightedexperiment.WeightedExperimentImplementation_swigregister(WeightedExperimentImplementation)

class WeightedExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new_WeightedExperimentImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperimentImplementationTypedInterfaceObject

# Register WeightedExperimentImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment.WeightedExperimentImplementationTypedInterfaceObject_swigregister(WeightedExperimentImplementationTypedInterfaceObject)

class WeightedExperiment(WeightedExperimentImplementationTypedInterfaceObject):
    r"""
    Weighted experiment.

    Available constructor:
        WeightedExperiment(*distribution=ot.Uniform(), size=100*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` used to generate the set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    WeightedExperiment is used to generate the points :math:`\Xi_i` so that the
    mean :math:`E_{\mu}` is approximated as follows:

    .. math::

        \Expect{ f(\vect{Z})}_{\mu} \simeq \sum_{i \in I} \omega_i f(\Xi_i)

    where :math:`\mu` is a distribution, :math:`f` is a function :math:`L_1(\mu)`
    and :math:`\omega_i` are the weights associated with the points. By default,
    all the weights are equal to :math:`1/cardI`.

    A WeightedExperiment object can be created only through its derived classes
    which are distributed in three groups:

    1. The first category is made up of the random patterns, where the set of input
       data is generated from the joint distribution of the input random vector,
       according to these sampling techniques:

       - :class:`Monte Carlo <openturns.MonteCarloExperiment>`

       - :class:`LHS <openturns.LHSExperiment>`

       - :class:`Bootstrap <openturns.BootstrapExperiment>`

       - :class:`Importance Sampling <openturns.ImportanceSamplingExperiment>`

    2. The second category contains the :class:`low discrepancy sequences
       <openturns.LowDiscrepancySequence>`. OpenTURNS proposes the Faure, Halton,
       Haselgrove, Reverse Halton and Sobol sequences.

    3. The third category consists of deterministic patterns:

       - :class:`Gauss product <openturns.GaussProductExperiment>`

       - :class:`~openturns.FixedExperiment`

       - :class:`~openturns.LowDiscrepancyExperiment`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.WeightedExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.WeightedExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.WeightedExperiment_getDistribution(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_setSize(self, size)

    def getSize(self):
        r"""
        Accessor to the size of the generated sample.

        Returns
        -------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _weightedexperiment.WeightedExperiment_getSize(self)

    def generate(self):
        r"""
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Points :math:`(\Xi_i)_{i \in I}` which constitute the design of experiments
            with :math:`card I = size`. The sampling method is defined by the nature of
            the weighted experiment.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample = myExperiment.generate()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        """
        return _weightedexperiment.WeightedExperiment_generate(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.WeightedExperiment_generateWithWeights(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.WeightedExperiment_hasUniformWeights(self)

    def __init__(self, *args):
        _weightedexperiment.WeightedExperiment_swiginit(self, _weightedexperiment.new_WeightedExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_WeightedExperiment

# Register WeightedExperiment in _weightedexperiment:
_weightedexperiment.WeightedExperiment_swigregister(WeightedExperiment)

class BootstrapExperiment(WeightedExperimentImplementation):
    r"""
    Bootstrap experiment.

    Available constructors:
        BootstrapExperiment(*sample*)

    Parameters
    ----------
    sample : 2-d sequence of float
        Points to defined a :class:`~openturns.UserDefined` distribution
        :math:`\mu`.

    Notes
    -----
    BootstrapExperiment is a random weighted design of experiments.
    To call the BootstrapExperiment constructor is equivalent to call the
    :class:`~openturns.WeightedExperiment` constructor as follows:
    *WeightedExperiment(UserDefined(sample), sample.getSize())*.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> experiment = ot.BootstrapExperiment(sample)
    >>> print(experiment.generate())
        [ v0 v1 ]
    0 : [ 4  5  ]
    1 : [ 1  2  ]
    2 : [ 1  2  ]
    3 : [ 1  2  ]
    4 : [ 2  3  ]
    >>> print(experiment.getDistribution())
    UserDefined({x = [0,1], p = 0.2}, {x = [1,2], p = 0.2}, {x = [2,3], p = 0.2}, {x = [3,4], p = 0.2}, {x = [4,5], p = 0.2})
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.BootstrapExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.BootstrapExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.BootstrapExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.BootstrapExperiment_getDistribution(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.BootstrapExperiment_generateWithWeights(self)

    @staticmethod
    def GenerateSelection(size, length):
        r"""
        Generate a list of indices of points with replacement.

        Parameters
        ----------
        size : positive int
            Size of the set of indices in which the indices are chosen.
        length : positive int
            Number of indices to choose.

        Returns
        -------
        selection : :class:`~openturns.Indices`
            Sequence of size *length* of indices :math:`i` such that :math:`0\leq i<size`.

        """
        return _weightedexperiment.BootstrapExperiment_GenerateSelection(size, length)

    def __init__(self, *args):
        _weightedexperiment.BootstrapExperiment_swiginit(self, _weightedexperiment.new_BootstrapExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_BootstrapExperiment

# Register BootstrapExperiment in _weightedexperiment:
_weightedexperiment.BootstrapExperiment_swigregister(BootstrapExperiment)

def BootstrapExperiment_GenerateSelection(size, length):
    r"""
    Generate a list of indices of points with replacement.

    Parameters
    ----------
    size : positive int
        Size of the set of indices in which the indices are chosen.
    length : positive int
        Number of indices to choose.

    Returns
    -------
    selection : :class:`~openturns.Indices`
        Sequence of size *length* of indices :math:`i` such that :math:`0\leq i<size`.

    """
    return _weightedexperiment.BootstrapExperiment_GenerateSelection(size, length)

class FixedExperiment(WeightedExperimentImplementation):
    r"""
    Fixed experiment.

    Available constructors:
        FixedExperiment(*aSample*)

        FixedExperiment(*aSample, weights*)

    Parameters
    ----------
    aSample : 2-d sequence of float
        Sample that already exists.
    weights : sequence of float
        Weights of each point of *aSample*.

    Notes
    -----
    FixedExperiment is a deterministic weighted design of experiments.
    It enables to take into account a random sample which has been obtained outside
    the study or at another step of the study.
    The :meth:`generate` method always gives the same sample, *aSample*, if it is
    recalled. When not specified, the weights associated to the points are all
    equal to :math:`1/cardI`. Then the sample *aSample* is considered as generated
    from the limit distribution
    :math:`\lim\limits_{cardI \to \infty} \sum_{i \in I} \omega_i \delta_{\vect{X}_i}=\mu`.
    The :meth:`setDistribution` method has no side effect, as the distribution is
    fixed by the initial sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = [[i,i+1] for i in range(5)]
    >>> experiment = ot.FixedExperiment(sample)
    >>> print(experiment.generate())
    0 : [ 0 1 ]
    1 : [ 1 2 ]
    2 : [ 2 3 ]
    3 : [ 3 4 ]
    4 : [ 4 5 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.FixedExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.FixedExperiment___repr__(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.FixedExperiment_setDistribution(self, distribution)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.FixedExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.FixedExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.FixedExperiment_swiginit(self, _weightedexperiment.new_FixedExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_FixedExperiment

# Register FixedExperiment in _weightedexperiment:
_weightedexperiment.FixedExperiment_swigregister(FixedExperiment)

class GaussProductExperiment(WeightedExperimentImplementation):
    r"""
    Gauss product experiment.

    Available constructors:
        GaussProductExperiment(*marginalDegrees*)

        GaussProductExperiment(*distribution*)

        GaussProductExperiment(*distribution, marginalDegrees*)

    Parameters
    ----------
    marginalDegrees : sequence of positive int
        Numbers of points :math:`N_i` for each direction. Then, the total number of
        points generated is :math:`cardI=\prod_{i=1}^n N_i`. If not specified,
        each value :math:`N_i` is :math:`5`.
    distribution :
        Distribution :math:`\mu` of dimension :math:`n` with an independent copula.

    Notes
    -----
    The number of points for each direction doesn't change and the :meth:`generate`
    method always gives the same sample.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Exponential(), ot.Triangular(-1.0, -0.5, 1.0)])
    >>> marginalDegrees = [3, 2]
    >>> experiment = ot.GaussProductExperiment(distribution, marginalDegrees)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.415775 -0.511215 ]
    1 : [  2.29428  -0.511215 ]
    2 : [  6.28995  -0.511215 ]
    3 : [  0.415775  0.357369 ]
    4 : [  2.29428   0.357369 ]
    5 : [  6.28995   0.357369 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GaussProductExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.GaussProductExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.GaussProductExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.GaussProductExperiment_generateWithWeights(self)

    def setMarginalDegrees(self, marginalDegrees):
        r"""
        Set the marginal degrees.

        Parameters
        ----------
        marginalDegrees : sequence of positive int
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_setMarginalDegrees(self, marginalDegrees)

    def getMarginalDegrees(self):
        r"""
        Get the marginal degrees.

        Returns
        -------
        marginalDegrees : :class:`~openturns.Indices`
            Numbers of points :math:`N_i` for each direction.
        """
        return _weightedexperiment.GaussProductExperiment_getMarginalDegrees(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.GaussProductExperiment_setDistribution(self, distribution)

    def __init__(self, *args):
        _weightedexperiment.GaussProductExperiment_swiginit(self, _weightedexperiment.new_GaussProductExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_GaussProductExperiment

# Register GaussProductExperiment in _weightedexperiment:
_weightedexperiment.GaussProductExperiment_swigregister(GaussProductExperiment)

class ImportanceSamplingExperiment(WeightedExperimentImplementation):
    r"""
    Importance Sampling experiment.

    Available constructors:
        ImportanceSamplingExperiment(*distribution*)

        ImportanceSamplingExperiment(*distribution, size*)

        ImportanceSamplingExperiment(*distribution, importanceDistribution, size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.
    importanceDistribution : :class:`~openturns.Distribution`
        Distribution :math:`p` according to which the points of the design of
        experiments will be generated with the Importance Sampling technique.

    Notes
    -----
    ImportanceSamplingExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\Xi_i)_{i \in I}`
    independently from the distribution :math:`\mu`. When the :meth:`generate`
    method is recalled, the generated sample changes.
    The weights associated to the points are all equal to:
    :math:`\frac{1}{\Xi_i}\frac{\mu(\Xi_i)}{p(\Xi_i)}`

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> importanceDistribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
    >>> experiment = ot.ImportanceSamplingExperiment(distribution, importanceDistribution, 5)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [ 0.629877  0.882805  ]
    1 : [ 0.135276  0.0325028 ]
    2 : [ 0.347057  0.969423  ]
    3 : [ 0.92068   0.50304   ]
    4 : [ 0.0632061 0.292757  ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.ImportanceSamplingExperiment_getClassName(self)

    def getImportanceDistribution(self):
        return _weightedexperiment.ImportanceSamplingExperiment_getImportanceDistribution(self)

    def __repr__(self):
        return _weightedexperiment.ImportanceSamplingExperiment___repr__(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _weightedexperiment.ImportanceSamplingExperiment_hasUniformWeights(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.ImportanceSamplingExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.ImportanceSamplingExperiment_swiginit(self, _weightedexperiment.new_ImportanceSamplingExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_ImportanceSamplingExperiment

# Register ImportanceSamplingExperiment in _weightedexperiment:
_weightedexperiment.ImportanceSamplingExperiment_swigregister(ImportanceSamplingExperiment)

class LHSExperiment(WeightedExperimentImplementation):
    r"""
    LHS experiment.

    Available constructors:
        LHSExperiment(*size, alwaysShuffle, randomShift*)

        LHSExperiment(*distribution, size, alwaysShuffle, randomShift*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`\mathrm{card}\,I` of points that will be generated in the experiment.
    alwaysShuffle : bool
        Flag to tell if the shuffle must be regenerated at each call to generate
        or not.
        Default is *False*: the shuffle is generated once and for all.

    randomShift : bool
        Flag to tell if the point selected in each cell of the shuffle is the center
        of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
        of the distribution to the cell.
        Default is *True*.

    Notes
    -----
    LHSExperiment is a random weighted design of experiments.
    The method generates a sample of points :math:`\Xi_i` according to the
    distribution :math:`\mu` with the LHS technique: some cells are determined,
    with the same probabilistic content according to the distribution, each line
    and each column contains exactly one cell, then points are selected among these
    selected cells. The weights associated to the points are all equal to
    :math:`1/\mathrm{card}\,I`. When recalled, the :meth:`generate` method generates a new
    sample: the point selection within the cells changes but not the cells
    selection. To change the cell selection, it is necessary to create a new LHS
    Experiment.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    Create an *LHSExperiment*:

    >>> import openturns as ot

    Generate the sample reusing the initial shuffle and using a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [  1.52938   -0.343515  ]
    1 : [ -0.0703427  2.36353   ]
    2 : [  0.576091  -1.79398   ]
    3 : [ -2.11636    0.619315  ]
    4 : [ -0.699601  -0.0570674 ]

    Generate the sample using a new shuffle and a random shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, True)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.887671 -0.647818 ]
    1 : [  0.107683  1.15851  ]
    2 : [  0.453077 -1.04742  ]
    3 : [ -0.928012  0.409732 ]
    4 : [ -0.290539  0.16153  ]
    >>> print(experiment.generate())
        [ X0         X1         ]
    0 : [ -1.72695   -0.591043  ]
    1 : [ -0.240653  -0.0406593 ]
    2 : [  0.828719   2.12547   ]
    3 : [  2.37061    0.508903  ]
    4 : [ -0.668296  -1.11573   ]

    Generate the sample reusing the initial shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, False, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]

    Generate the sample using a new shuffle and using a constant shift:

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment(ot.Normal(2), 5, True, False)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  1.28155  -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [  0.524401 -1.28155  ]
    3 : [ -1.28155   0.524401 ]
    4 : [ -0.524401  0        ]
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.524401 -0.524401 ]
    1 : [  0         1.28155  ]
    2 : [ -1.28155   0        ]
    3 : [ -0.524401  0.524401 ]
    4 : [  1.28155  -1.28155  ]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.LHSExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LHSExperiment___str__(self, *args)

    def generateStandard(self):
        return _weightedexperiment.LHSExperiment_generateStandard(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LHSExperiment_generateWithWeights(self)

    @staticmethod
    def ComputeShuffle(dimension, totalSize):
        r"""
        Generate a new cell randomization for external use.

        Parameters
        ----------
        dimension : positive int
            Number of input dimension.
        totalSize : positive int
            Number :math:`\mathrm{card}\,I` of points that need to be shuffled.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_ComputeShuffle(dimension, totalSize)

    def getShuffle(self):
        r"""
        Return the cell randomization.

        Returns
        -------
        shuffle : :class:`~openturns.Matrix`
            For each point, the indices of the shuffled components.
        """
        return _weightedexperiment.LHSExperiment_getShuffle(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LHSExperiment_setDistribution(self, distribution)

    def getAlwaysShuffle(self):
        r"""
        Cell randomization flag accessor.

        Returns
        -------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_getAlwaysShuffle(self)

    def setAlwaysShuffle(self, alwaysShuffle):
        r"""
        Cell randomization flag accessor.

        Parameters
        ----------
        alwaysShuffle : bool
            Flag to tell if the shuffle must be regenerated at each call to generate
            or not.
            Default is *False*: the shuffle is generated once and for all.
        """
        return _weightedexperiment.LHSExperiment_setAlwaysShuffle(self, alwaysShuffle)

    def getRandomShift(self):
        r"""
        Randomization flag accessor.

        Returns
        -------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_getRandomShift(self)

    def setRandomShift(self, randomShift):
        r"""
        Randomization flag accessor.

        Parameters
        ----------
        randomShift : bool
            Flag to tell if the point selected in each cell of the shuffle is the center
            of the cell (*randomshift* is *False*) or if it is drawn wrt the restriction
            of the distribution to the cell.
            Default is *True*.
        """
        return _weightedexperiment.LHSExperiment_setRandomShift(self, randomShift)

    def __init__(self, *args):
        _weightedexperiment.LHSExperiment_swiginit(self, _weightedexperiment.new_LHSExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_LHSExperiment

# Register LHSExperiment in _weightedexperiment:
_weightedexperiment.LHSExperiment_swigregister(LHSExperiment)

def LHSExperiment_ComputeShuffle(dimension, totalSize):
    r"""
    Generate a new cell randomization for external use.

    Parameters
    ----------
    dimension : positive int
        Number of input dimension.
    totalSize : positive int
        Number :math:`\mathrm{card}\,I` of points that need to be shuffled.

    Returns
    -------
    shuffle : :class:`~openturns.Matrix`
        For each point, the indices of the shuffled components.
    """
    return _weightedexperiment.LHSExperiment_ComputeShuffle(dimension, totalSize)

class TemperatureProfileImplementationdInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_swiginit(self, _weightedexperiment.new_TemperatureProfileImplementationdInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationdInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementationdInterfaceObject

# Register TemperatureProfileImplementationdInterfaceObject in _weightedexperiment:
_weightedexperiment.TemperatureProfileImplementationdInterfaceObject_swigregister(TemperatureProfileImplementationdInterfaceObject)

class TemperatureProfileImplementation(openturns.common.PersistentObject):
    r"""
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfileImplementation_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfileImplementation___call__(self, i)

    def getT0(self):
        r"""
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfileImplementation_getT0(self)

    def getIMax(self):
        r"""
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfileImplementation_getIMax(self)

    def __repr__(self):
        return _weightedexperiment.TemperatureProfileImplementation___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfileImplementation_swiginit(self, _weightedexperiment.new_TemperatureProfileImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementation

# Register TemperatureProfileImplementation in _weightedexperiment:
_weightedexperiment.TemperatureProfileImplementation_swigregister(TemperatureProfileImplementation)

class TemperatureProfileImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new_TemperatureProfileImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfileImplementationTypedInterfaceObject

# Register TemperatureProfileImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment.TemperatureProfileImplementationTypedInterfaceObject_swigregister(TemperatureProfileImplementationTypedInterfaceObject)

class TemperatureProfile(TemperatureProfileImplementationdInterfaceObject):
    r"""
    Base class to define a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.TemperatureProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _weightedexperiment.TemperatureProfile___call__(self, i)

    def getT0(self):
        r"""
        Temperature origin accessor.

        Returns
        -------
        t0 : float
            The temperature origin
        """
        return _weightedexperiment.TemperatureProfile_getT0(self)

    def getIMax(self):
        r"""
        Maximum index value accessor.

        Returns
        -------
        iMax : int
            The maximum index value
        """
        return _weightedexperiment.TemperatureProfile_getIMax(self)

    def __repr__(self):
        return _weightedexperiment.TemperatureProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.TemperatureProfile_swiginit(self, _weightedexperiment.new_TemperatureProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_TemperatureProfile

# Register TemperatureProfile in _weightedexperiment:
_weightedexperiment.TemperatureProfile_swigregister(TemperatureProfile)

class GeometricProfile(TemperatureProfileImplementation):
    r"""
    Geometric temperature profile.

    Available constructor:
        GeometricProfile()

        GeometricProfile(*T0, c, iMax*)


    Parameters
    ----------
    T0 : float
        Initial temperature
    c : float
        The geometric ratio
        Should be in ]0,1[
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \begin{equation*}
            T(i) = T_0 * c^{i} \in [0,iMax]
        \end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> c = 0.90
    >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.GeometricProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> c = 0.90
        >>> geometricProfile = ot.GeometricProfile(T0, c, iMax)
        >>> temperature = geometricProfile(5)
        >>> print(temperature)
        5.9049...
        """
        return _weightedexperiment.GeometricProfile___call__(self, i)

    def __repr__(self):
        return _weightedexperiment.GeometricProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.GeometricProfile_swiginit(self, _weightedexperiment.new_GeometricProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_GeometricProfile

# Register GeometricProfile in _weightedexperiment:
_weightedexperiment.GeometricProfile_swigregister(GeometricProfile)

class LinearProfile(TemperatureProfileImplementation):
    r"""
    Linear temperature profile.

    Available constructor:
        LinearProfile(*T0, iMax*)


    Parameters
    ----------
    T0 : float
        Initial temperature
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \begin{equation*}
            T(i) = T_0*(1 - \frac{i}{iMax}), i \in [0,iMax]
        \end{equation*}

    Examples
    --------
    >>> import openturns as ot
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> linearProfile = ot.LinearProfile(T0, iMax)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LinearProfile_getClassName(self)

    def __call__(self, i):
        r"""
        Compute the temperature T(i).

        Parameters
        ----------
        i : int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------
        >>> import openturns as ot
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> linearProfile = ot.LinearProfile(T0, iMax)
        >>> temperature = linearProfile(10)
        >>> print(temperature)
        9.0
        """
        return _weightedexperiment.LinearProfile___call__(self, i)

    def __repr__(self):
        return _weightedexperiment.LinearProfile___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.LinearProfile_swiginit(self, _weightedexperiment.new_LinearProfile(*args))
    __swig_destroy__ = _weightedexperiment.delete_LinearProfile

# Register LinearProfile in _weightedexperiment:
_weightedexperiment.LinearProfile_swigregister(LinearProfile)

class SpaceFillingImplementationdInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingImplementationdInterfaceObject_swiginit(self, _weightedexperiment.new_SpaceFillingImplementationdInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment.SpaceFillingImplementationdInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementationdInterfaceObject

# Register SpaceFillingImplementationdInterfaceObject in _weightedexperiment:
_weightedexperiment.SpaceFillingImplementationdInterfaceObject_swigregister(SpaceFillingImplementationdInterfaceObject)

class SpaceFillingImplementation(openturns.common.PersistentObject):
    r"""
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingImplementation_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_evaluate(self, sample)

    def isMinimizationProblem(self):
        r"""
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFillingImplementation_isMinimizationProblem(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingImplementation___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingImplementation_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingImplementation_swiginit(self, _weightedexperiment.new_SpaceFillingImplementation(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementation

# Register SpaceFillingImplementation in _weightedexperiment:
_weightedexperiment.SpaceFillingImplementation_swigregister(SpaceFillingImplementation)

class SpaceFillingImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_swiginit(self, _weightedexperiment.new_SpaceFillingImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _weightedexperiment.SpaceFillingImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingImplementationTypedInterfaceObject

# Register SpaceFillingImplementationTypedInterfaceObject in _weightedexperiment:
_weightedexperiment.SpaceFillingImplementationTypedInterfaceObject_swigregister(SpaceFillingImplementationTypedInterfaceObject)

class SpaceFilling(SpaceFillingImplementationdInterfaceObject):
    r"""
    Space filling computation base class.

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines
    how points fill the uniform space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFilling_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _weightedexperiment.SpaceFilling_evaluate(self, sample)

    def isMinimizationProblem(self):
        r"""
        Minimization flag accessor.

        Returns
        -------
        isMinimization : bool
            Whether the problem is a minimization.

        """
        return _weightedexperiment.SpaceFilling_isMinimizationProblem(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFilling___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFilling_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFilling_swiginit(self, _weightedexperiment.new_SpaceFilling(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFilling

# Register SpaceFilling in _weightedexperiment:
_weightedexperiment.SpaceFilling_swigregister(SpaceFilling)

class SpaceFillingC2(SpaceFillingImplementation):
    r"""
    Space filling C2 (centered L2-discrepancy) computation.

    Notes
    -----
    Compute the centered L2 discrepancy:

    .. math::
        :nowrap:

        \begin{multline*}
        C^2(X_{d}^N) = \left(\frac{13}{12}\right)^{d} - \frac{2}{N} \sum_{i=1}^{N} \prod_{k=1}^{d} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| - \frac{1}{2} |x_k^{(i)} - 0.5|^2 \right)\\
                 + \frac{1}{N^2} \sum_{i,j=1}^{N} \prod_{k=1}^{d} \left( 1 + \frac{1}{2} |x_k^{(i)} - 0.5| + \frac{1}{2} |x_k^{(j)} - 0.5| - \frac{1}{2} |x_k^{(i)} - x_k^{(j)}| \right)
        \end{multline*}

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingC2_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the C2 criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The C2 criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the C2 criterion
        >>> crit = ot.SpaceFillingC2().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingC2_evaluate(self, sample)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingC2___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingC2_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingC2_swiginit(self, _weightedexperiment.new_SpaceFillingC2(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingC2

# Register SpaceFillingC2 in _weightedexperiment:
_weightedexperiment.SpaceFillingC2_swigregister(SpaceFillingC2)

class SpaceFillingMinDist(SpaceFillingImplementation):
    r"""
    Space filling minimal distance criterion.

    Notes
    -----
    Compute the minimal distance of sample points

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingMinDist_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingMinDist___repr__(self)

    def evaluate(self, sample):
        r"""
        Compute the MinDist criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2-d array like
            The design

        Returns
        -------
        crit : float
            The MinDist criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the MinDist criterion
        >>> crit = ot.SpaceFillingMinDist().evaluate(design)
        """
        return _weightedexperiment.SpaceFillingMinDist_evaluate(self, sample)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingMinDist_swiginit(self, _weightedexperiment.new_SpaceFillingMinDist(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingMinDist

# Register SpaceFillingMinDist in _weightedexperiment:
_weightedexperiment.SpaceFillingMinDist_swigregister(SpaceFillingMinDist)

class SpaceFillingPhiP(SpaceFillingImplementation):
    r"""
    Space filling PhiP.

    Parameters
    ----------
    p : int
        Parameter for parametrizing the criterion 

    Notes
    -----
    Computes the criterion:

    .. math::
        :nowrap:

        \begin{equation*}
          \phi_p(X) = \sum_{i=1}^{j} \sum_{j=1}^{n} \left( |x^{(i)} - x^{(j)}|^{-p} \right)^{\frac{1}{p}}
        \end{equation*}

    This criterion is knwon to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SpaceFillingPhiP_getClassName(self)

    def evaluate(self, sample):
        r"""
        Compute the PhiP criterion for a specific design.

        Parameters
        ----------
        design : :class:`~openturns.Sample` or 2d array like
            The design

        Returns
        -------
        crit : float
            The phiP criterion

        Examples
        --------
        >>> import openturns as ot
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
        >>> design = lhs.generate()
        >>> # Compute the PhiP criterion
        >>> crit = ot.SpaceFillingPhiP(50).evaluate(design)
        """
        return _weightedexperiment.SpaceFillingPhiP_evaluate(self, sample)

    def __repr__(self):
        return _weightedexperiment.SpaceFillingPhiP___repr__(self)

    def perturbLHS(self, oldDesign, oldCriterion, row1, row2, column):
        r"""
        Elementary perturbation.

        Parameters
        ----------
        design : :class:`~openturns.Sample`
            The design to perturb (in-place)
        oldCriterion : float
            The previous value of the criterion
        row1 : int
            First row index
        row2 : int
            Second row index

        Returns
        -------
        criterion : float
            The value of the criterion
        """
        return _weightedexperiment.SpaceFillingPhiP_perturbLHS(self, oldDesign, oldCriterion, row1, row2, column)

    def __init__(self, *args):
        _weightedexperiment.SpaceFillingPhiP_swiginit(self, _weightedexperiment.new_SpaceFillingPhiP(*args))
    __swig_destroy__ = _weightedexperiment.delete_SpaceFillingPhiP

# Register SpaceFillingPhiP in _weightedexperiment:
_weightedexperiment.SpaceFillingPhiP_swigregister(SpaceFillingPhiP)

class LHSResult(openturns.common.PersistentObject):
    r"""
    Summarize the results of an LHS optimization.

    Available constructor:
        LHSResult(*bounds, spaceFilling, nRestart*)

    Parameters
    ----------
    spaceFilling : :class:`~openturns.SpaceFilling`
        The space filling criteria used by optimization algorithm
    nRestart : int
        The number of restarts performed by optimization algorithm

    Notes
    -----
    This class is not intendeted to be built by hand, but returned by optimization algorithms.

    Examples
    --------
    >>> import openturns as ot
    >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> profile = ot.GeometricProfile()
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Optim algo
    >>> algo = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
    >>> # first, generate a design
    >>> design = algo.generate()
    >>> # then, get the result
    >>> result = algo.getResult()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LHSResult_getClassName(self)

    def getNumberOfRestarts(self):
        r"""
        Restart number accessor.

        Returns
        -------
        restart : int (optional)
            The number of restart.
        """
        return _weightedexperiment.LHSResult_getNumberOfRestarts(self)

    def getOptimalDesign(self, *args):
        r"""
        Accessor to the optimal design.

        Returns
        -------
        design : :class:`~openturns.Sample`
            The design that optimizes the criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> spaceFilling = ot.SpaceFillingPhiP(10)
        >>> # By Monte Carlo
        >>> algoMC = ot.MonteCarloLHS(lhs, 1000, spaceFilling)
        >>> # Get LHSResult
        >>> optimalDesignMC = algoMC.generate()
        >>> resultMC = algoMC.getResult()
        >>> # By simulated annealing, with restart
        >>> profile = ot.GeometricProfile()
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> optimalDesignSA = algoSA.generateWithRestart(5)
        >>> resultSA = algoSA.getResult()
        >>> # Get optimal results for all restarts
        >>> optimRestart = [resultSA.getOptimalDesign(i) for i in range(resultSA.getNumberOfRestarts())]
        """
        return _weightedexperiment.LHSResult_getOptimalDesign(self, *args)

    def getOptimalValue(self, *args):
        r"""
        Optimal value accessor.

        Returns
        -------
        value : float (optional)
            The optimal value.
        """
        return _weightedexperiment.LHSResult_getOptimalValue(self, *args)

    def getAlgoHistory(self, *args):
        r"""
        Accessor to the internal values computed during optimization algorithm.

        Returns
        -------
        history : :class:`~openturns.Point`
            Some internal values computed during optimization algorithm.
            SimulatedAnnealingLHS stores criterion value, temperature
            and probability at each iteration.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> design = algoSA.generateWithRestart(5)
        >>> resultSA = algoSA.getResult()
        >>> criterionHistory = resultSA.getAlgoHistory()
        """
        return _weightedexperiment.LHSResult_getAlgoHistory(self, *args)

    def getC2(self, *args):
        r"""
        Accessor to the C2 criterion evaluated on the optimal design.

        Returns
        -------
        c2 : float
            The C2 criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> design = algoSA.generate()
        >>> resultSA = algoSA.getResult()
        >>> c2 = resultSA.getC2()
        """
        return _weightedexperiment.LHSResult_getC2(self, *args)

    def getPhiP(self, *args):
        r"""
        Accessor the PhiP criterion evaluated on the optimal design.

        Returns
        -------
        phiP : float
            The PhiP criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> lhs = ot.LHSExperiment(ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*3), 100)
        >>> lhs.setAlwaysShuffle(True) # randomized
        >>> profile = ot.GeometricProfile()
        >>> spaceFilling = ot.SpaceFillingPhiP(50)
        >>> algoSA = ot.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> design = algoSA.generate()
        >>> # Get LHSResult
        >>> resultSA = algoSA.getResult()
        >>> phip = resultSA.getPhiP()
        """
        return _weightedexperiment.LHSResult_getPhiP(self, *args)

    def getMinDist(self, *args):
        r"""
        Minimum distance accessor.

        Parameters
        ----------
        restart : int (optional)
            The restart index.

        Returns
        -------
        minDist : float
            The minimum distance of sample points.
        """
        return _weightedexperiment.LHSResult_getMinDist(self, *args)

    def drawHistoryCriterion(self, *args):
        r"""
        Draw criterion history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryCriterion(self, *args)

    def drawHistoryProbability(self, *args):
        r"""
        Draw probability history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryProbability(self, *args)

    def drawHistoryTemperature(self, *args):
        r"""
        Draw temperature history.

        Parameters
        ----------
        restart : int (optional)
            The restart index.
        title : str (optional)
            Graph title.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The resulting graph.
        """
        return _weightedexperiment.LHSResult_drawHistoryTemperature(self, *args)

    def add(self, optimalDesign, criterion, C2, PhiP, MinDist, algoHistory):
        return _weightedexperiment.LHSResult_add(self, optimalDesign, criterion, C2, PhiP, MinDist, algoHistory)

    def __repr__(self):
        return _weightedexperiment.LHSResult___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.LHSResult_swiginit(self, _weightedexperiment.new_LHSResult(*args))
    __swig_destroy__ = _weightedexperiment.delete_LHSResult

# Register LHSResult in _weightedexperiment:
_weightedexperiment.LHSResult_swigregister(LHSResult)

class OptimalLHSExperiment(WeightedExperimentImplementation):
    r"""
    OptimalLHS base class.

    See also
    --------
    MonteCarloLHS, SimulatedAnnealingLHS

    Notes
    -----
    Perform the generation of optimal LHS designs.

    See a complementary bibiliographic reference: [mckay1979]_
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.OptimalLHSExperiment_getClassName(self)

    def getLHS(self):
        r"""
        Return the LHS design.

        Returns
        -------
        value : :class:`~openturns.LHSExperiment`
            Result the factory that builds initial design to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getLHS(self)

    def getSpaceFilling(self):
        r"""
        Return the space-filling criterion to be optimized.

        Returns
        -------
        value : :class:`~openturns.SpaceFilling`
            Criterion function to be optimized
        """
        return _weightedexperiment.OptimalLHSExperiment_getSpaceFilling(self)

    def getResult(self):
        r"""
        Result accessor.

        Returns
        -------
        value : :class:`~openturns.LHSResult`
            Result of generation that contains the optimal design, some criteria and history
        """
        return _weightedexperiment.OptimalLHSExperiment_getResult(self)

    def __repr__(self):
        return _weightedexperiment.OptimalLHSExperiment___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.OptimalLHSExperiment_swiginit(self, _weightedexperiment.new_OptimalLHSExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_OptimalLHSExperiment

# Register OptimalLHSExperiment in _weightedexperiment:
_weightedexperiment.OptimalLHSExperiment_swigregister(OptimalLHSExperiment)

class MonteCarloLHS(OptimalLHSExperiment):
    r"""
    Monte Carlo LHS optimization.

    Performs the optimization of an LHS using Monte Carlo simulations.

    Available constructors:
        MonteCarloLHS(*lhsDesign, N*)

        MonteCarloLHS(*lhsDesign, N, spaceFilling*)

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
         Factory that generate designs
    N : int
        Number of simulations
    spaceFilling : :class:`~openturns.SpaceFilling`
        Criterion to be optimized
        Default spaceFilling is MinDist

    Notes
    -----
    MonteCarloLHS generate N designs using lhsDesign and returns the optimal one with respect to spaceFilling

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # RandomBruteForce MonteCarlo with N designs (LHS with C2 optimization)
    >>> N = 10000
    >>> optimalLHSAlgorithm = ot.MonteCarloLHS(lhs, N, spaceFilling)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloLHS_getClassName(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloLHS_generateWithWeights(self)

    def __repr__(self):
        return _weightedexperiment.MonteCarloLHS___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.MonteCarloLHS_swiginit(self, _weightedexperiment.new_MonteCarloLHS(*args))
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloLHS

# Register MonteCarloLHS in _weightedexperiment:
_weightedexperiment.MonteCarloLHS_swigregister(MonteCarloLHS)

class SimulatedAnnealingLHS(OptimalLHSExperiment):
    r"""
    LHS optimization using simulated annealing.

    Performs the optimization of an LHS using simulated annealing algorithm.

    Available constructors:

        SimulatedAnnealingLHS(*lhsDesign*)

        SimulatedAnnealingLHS(*lhsDesign, profile*)

        SimulatedAnnealingLHS(*lhsDesign, profile, spaceFilling*)

        SimulatedAnnealingLHS(*initialDesign, distribution*)

        SimulatedAnnealingLHS(*initialDesign, distribution, profile*)

        SimulatedAnnealingLHS(*initialDesign, distribution, profile, spaceFilling*)

    Parameters
    ----------
    lhsDesign : :class:`~openturns.LHSExperiment`
        Factory that generate designs
    initialDesign : 2d-array sequence
        Initial design to be optimized
    distribution : :class:`~openturns.Distribution`
        Distribution of designs
    profile : :class:`~openturns.TemperatureProfile`
        Temperature profile used by the simulated annealing algorithm
        Default one is GeometricProfile
    spaceFilling : :class:`~openturns.SpaceFilling`
        Criterion to be optimized
        Default one is SpaceFillingMinDist

    Notes
    -----

    With the first constructor, the initial design is generated thanks to lhsDesign. With the second usage, we fix it.
    Starting from this design, a new design is obtained by permuting one random coordinate of two randomly chosen elements; by construction, this design is also an LHS design. 
    If the new design is better than the previous one, it is kept.  
    If it is worse, it may anyway be kept with some probability, which depends on how these designs compare, but also on a temperature profile 
    T which decreases over time.  This means that jumping away from local extrema becomes less probable over time.

    Examples
    --------
    >>> import openturns as ot
    >>> dimension = 3
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
    >>> lhs = ot.LHSExperiment(distribution, size)
    >>> lhs.setAlwaysShuffle(True) # randomized
    >>> # Defining space fillings
    >>> spaceFilling = ot.SpaceFillingC2()
    >>> # Geometric profile
    >>> geomProfile = ot.GeometricProfile(10.0, 0.95, 2000)
    >>> # Simulated Annealing LHS with geometric temperature profile, C2 optimization
    >>> optimalLHSAlgorithm = ot.SimulatedAnnealingLHS(lhs, geomProfile, spaceFilling)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.SimulatedAnnealingLHS_getClassName(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithWeights(self)

    def generateWithRestart(self, nRestart):
        return _weightedexperiment.SimulatedAnnealingLHS_generateWithRestart(self, nRestart)

    def __repr__(self):
        return _weightedexperiment.SimulatedAnnealingLHS___repr__(self)

    def __init__(self, *args):
        _weightedexperiment.SimulatedAnnealingLHS_swiginit(self, _weightedexperiment.new_SimulatedAnnealingLHS(*args))
    __swig_destroy__ = _weightedexperiment.delete_SimulatedAnnealingLHS

# Register SimulatedAnnealingLHS in _weightedexperiment:
_weightedexperiment.SimulatedAnnealingLHS_swigregister(SimulatedAnnealingLHS)

class LowDiscrepancyExperiment(WeightedExperimentImplementation):
    r"""
    LowDiscrepancy experiment.

    Available constructors:
        LowDiscrepancyExperiment(*size, restart*)

        LowDiscrepancyExperiment(*sequence, size, restart*)

        LowDiscrepancyExperiment(*sequence, distribution, size, restart*)

    Parameters
    ----------
    size : positive int
        Number :math:`N` of points of the sequence.
    sequence : :class:`~openturns.LowDiscrepancySequence`
        Sequence of points :math:`(u_1, \cdots, u_N)` with low discrepancy.
        If not specified, the sequence is a :class:`~openturns.SobolSequence`.
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` of dimension :math:`n`.
        The low discrepancy sequence :math:`(u_1, \cdots, u_N)` is uniformly
        distributed over :math:`[0,1]^n`. We use an iso-probabilistic transformation
        from the independent copula of dimension :math:`n` to the given distribution.
        The weights are all equal to :math:`1/N`.
    restart : bool
        Flag to tell if the low discrepancy sequence must be restarted from
        its initial state at each change of distribution or not.
        Default is *True*: the sequence is restarted at each change of
        distribution.

    Notes
    -----
    The :meth:`generate` method generates points :math:`(\Xi_i)_{i \in I}`
    according to the distribution :math:`\mu`. When the :meth:`generate`
    method is called again, the generated sample changes. In case of dependent
    marginals, the approach based on [cambou2017]_ is used.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)] * 2)

    Generate the sample with a reinitialization of the sequence at each change
    of distribution:

    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, True)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> experiment.setDistribution(distribution)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]

    Generate the sample keeping the previous state of the sequence at each change
    of distribution:

    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(experiment.generate())
        [ y0    y1    ]
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.625  0.125  ]
    1 : [ 0.125  0.625  ]
    2 : [ 0.1875 0.3125 ]
    3 : [ 0.6875 0.8125 ]
    4 : [ 0.9375 0.0625 ]
    >>> experiment.setDistribution(distribution)
    >>> print(experiment.generate())
        [ y0     y1     ]
    0 : [ 0.4375 0.5625 ]
    1 : [ 0.3125 0.1875 ]
    2 : [ 0.8125 0.6875 ]
    3 : [ 0.5625 0.4375 ]
    4 : [ 0.0625 0.9375 ]

    Generate a sample according to a distribution with dependent marginals:

    >>> distribution = ot.Normal([0.0]*2, ot.CovarianceMatrix(2, [4.0, 1.0, 1.0, 9.0]))
    >>> experiment = ot.LowDiscrepancyExperiment(ot.SobolSequence(), distribution, 5, False)
    >>> print(experiment.generate())
        [ y0        y1        ]
    0 : [  0         0        ]
    1 : [  1.34898  -1.65792  ]
    2 : [ -1.34898   1.65792  ]
    3 : [ -0.637279 -1.10187  ]
    4 : [  2.3007    3.97795  ]

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.LowDiscrepancyExperiment___repr__(self)

    def __str__(self, *args):
        return _weightedexperiment.LowDiscrepancyExperiment___str__(self, *args)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_setDistribution(self, distribution)

    def getSequence(self):
        r"""
        Return the sequence.

        Returns
        -------
        sequence : :class:`~openturns.LowDiscrepancySequence`
            Sequence of points :math:`(u_1, \cdots, u_N)` with low discrepancy.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getSequence(self)

    def getRestart(self):
        r"""
        Return the value of the *restart* flag.

        Returns
        -------
        restart : bool
            The value of the *restart* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRestart(self)

    def setRestart(self, restart):
        r"""
        Set the value of the *restart* flag.

        Parameters
        ----------
        restart : bool
            The value of the *restart* flag. If equals to *True*, the low
            discrepancy sequence is restarted at each change of distribution,
            else it is changed only if the new distribution has a dimension
            different from the current one.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRestart(self, restart)

    def getRandomize(self):
        r"""
        Return the value of the *randomize* flag.

        Returns
        -------
        randomize : bool
            The value of the *randomize* flag.
        """
        return _weightedexperiment.LowDiscrepancyExperiment_getRandomize(self)

    def setRandomize(self, randomize):
        r"""
        Set the value of the *randomize* flag.

        Parameters
        ----------
        randomize : bool
            Use a cyclic scrambling of the low discrepancy sequence, it means, the whole
            low discrepancy sequence is translated by a random vector modulo 1.
            See [lecuyer2005]_ for the interest of such a scrambling.
            Default is False.

        """
        return _weightedexperiment.LowDiscrepancyExperiment_setRandomize(self, randomize)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.LowDiscrepancyExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.LowDiscrepancyExperiment_swiginit(self, _weightedexperiment.new_LowDiscrepancyExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_LowDiscrepancyExperiment

# Register LowDiscrepancyExperiment in _weightedexperiment:
_weightedexperiment.LowDiscrepancyExperiment_swigregister(LowDiscrepancyExperiment)

class MonteCarloExperiment(WeightedExperimentImplementation):
    r"""
    MonteCarlo experiment.

    Available constructors:
        MonteCarloExperiment(*distribution, size*)

        MonteCarloExperiment(*size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Number :math:`cardI` of points that will be generated in the experiment.

    Notes
    -----
    MonteCarloExperiment is a random weighted design of experiments.
    The :meth:`generate` method generates points :math:`(\Xi_i)_{i \in I}`
    independently from the distribution :math:`\mu`. The weights associated to the
    points are all equal to :math:`1/\mathrm{card}\,I`. When the :meth:`generate` method is
    recalled, the generated sample changes.

    See also
    --------
    WeightedExperiment

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
    >>> print(experiment.generate())
        [ X0        X1        ]
    0 : [  0.608202 -1.26617  ]
    1 : [ -0.438266  1.20548  ]
    2 : [ -2.18139   0.350042 ]
    3 : [ -0.355007  1.43725  ]
    4 : [  0.810668  0.793156 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _weightedexperiment.MonteCarloExperiment_getClassName(self)

    def __repr__(self):
        return _weightedexperiment.MonteCarloExperiment___repr__(self)

    def generateWithWeights(self):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _weightedexperiment.MonteCarloExperiment_generateWithWeights(self)

    def __init__(self, *args):
        _weightedexperiment.MonteCarloExperiment_swiginit(self, _weightedexperiment.new_MonteCarloExperiment(*args))
    __swig_destroy__ = _weightedexperiment.delete_MonteCarloExperiment

# Register MonteCarloExperiment in _weightedexperiment:
_weightedexperiment.MonteCarloExperiment_swigregister(MonteCarloExperiment)



